/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.fxapp;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.application.Application;
import javafx.scene.image.Image;
import javax.inject.Named;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.ui.common.ErrorComponent;
import org.cryptomator.ui.common.StageFactory;
import org.cryptomator.ui.fxapp.FxApplication;
import org.cryptomator.ui.fxapp.FxApplicationScoped;
import org.cryptomator.ui.fxapp.UpdateCheckerModule;
import org.cryptomator.ui.lock.LockComponent;
import org.cryptomator.ui.mainwindow.MainWindowComponent;
import org.cryptomator.ui.preferences.PreferencesComponent;
import org.cryptomator.ui.quit.QuitComponent;
import org.cryptomator.ui.unlock.UnlockComponent;

@Module(includes={UpdateCheckerModule.class}, subcomponents={MainWindowComponent.class, PreferencesComponent.class, UnlockComponent.class, LockComponent.class, QuitComponent.class, ErrorComponent.class})
abstract class FxApplicationModule {
    FxApplicationModule() {
    }

    @Provides
    @Named(value="windowIcons")
    @FxApplicationScoped
    static List<Image> provideWindowIcons() {
        if (SystemUtils.IS_OS_MAC) {
            return Collections.emptyList();
        }
        try {
            return List.of(FxApplicationModule.createImageFromResource("/img/window_icon_32.png"), FxApplicationModule.createImageFromResource("/img/window_icon_512.png"));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load embedded resource.", e);
        }
    }

    @Provides
    @FxApplicationScoped
    static StageFactory provideStageFactory(@Named(value="windowIcons") List<Image> windowIcons) {
        return new StageFactory(stage -> stage.getIcons().addAll((Collection)windowIcons));
    }

    private static Image createImageFromResource(String resourceName) throws IOException {
        try (InputStream in = FxApplicationModule.class.getResourceAsStream(resourceName);){
            Image image = new Image(in);
            return image;
        }
    }

    @Binds
    abstract Application bindApplication(FxApplication var1);

    @Provides
    static MainWindowComponent provideMainWindowComponent(MainWindowComponent.Builder builder) {
        return builder.build();
    }

    @Provides
    static PreferencesComponent providePreferencesComponent(PreferencesComponent.Builder builder) {
        return builder.build();
    }

    @Provides
    static QuitComponent provideQuitComponent(QuitComponent.Builder builder) {
        return builder.build();
    }
}

