/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.common;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.ErrorCode;
import org.cryptomator.common.Nullable;
import org.cryptomator.ui.common.FxController;

public class ErrorController
implements FxController {
    private static final String SEARCH_URL_FORMAT = "https://github.com/cryptomator/cryptomator/discussions/categories/errors?discussions_q=category:Errors+%s";
    private static final String REPORT_URL_FORMAT = "https://github.com/cryptomator/cryptomator/discussions/new?category=Errors&title=Error+%s&body=%s";
    private static final String SEARCH_ERRORCODE_DELIM = " OR ";
    private static final String REPORT_BODY_TEMPLATE = "<!-- \u270f\ufe0f Please describe what happened as accurately as possible. -->\n<!-- \ud83d\udccb Please also copy and paste the detail text from the error window. -->\n";
    private final Application application;
    private final String stackTrace;
    private final ErrorCode errorCode;
    private final Scene previousScene;
    private final Stage window;
    private BooleanProperty copiedDetails = new SimpleBooleanProperty();

    @Inject
    ErrorController(Application application, @Named(value="stackTrace") String stackTrace, ErrorCode errorCode, @Nullable Scene previousScene, Stage window) {
        this.application = application;
        this.stackTrace = stackTrace;
        this.errorCode = errorCode;
        this.previousScene = previousScene;
        this.window = window;
    }

    @FXML
    public void back() {
        if (this.previousScene != null) {
            this.window.setScene(this.previousScene);
        }
    }

    @FXML
    public void close() {
        this.window.close();
    }

    @FXML
    public void searchError() {
        String searchTerm = URLEncoder.encode(this.getErrorCode().replace(":", SEARCH_ERRORCODE_DELIM), StandardCharsets.UTF_8);
        this.application.getHostServices().showDocument(SEARCH_URL_FORMAT.formatted(searchTerm));
    }

    @FXML
    public void reportError() {
        String title = URLEncoder.encode(this.getErrorCode(), StandardCharsets.UTF_8);
        String body = URLEncoder.encode(REPORT_BODY_TEMPLATE, StandardCharsets.UTF_8);
        this.application.getHostServices().showDocument(REPORT_URL_FORMAT.formatted(title, body));
    }

    @FXML
    public void copyDetails() {
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(this.getDetailText());
        Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
        this.copiedDetails.set(true);
        CompletableFuture.delayedExecutor(2L, TimeUnit.SECONDS, Platform::runLater).execute(() -> this.copiedDetails.set(false));
    }

    public boolean isPreviousScenePresent() {
        return this.previousScene != null;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public String getErrorCode() {
        return this.errorCode.toString();
    }

    public String getDetailText() {
        return "```\nError Code " + this.getErrorCode() + "\n" + this.getStackTrace() + "\n```";
    }

    public BooleanProperty copiedDetailsProperty() {
        return this.copiedDetails;
    }

    public boolean getCopiedDetails() {
        return this.copiedDetails.get();
    }
}

