/*
 * Decompiled with CFR 0.152.
 */
package com.dokany.java;

import com.dokany.java.DokanyException;
import com.dokany.java.DokanyFileSystem;
import com.dokany.java.DokanyOperationsProxy;
import com.dokany.java.NativeMethods;
import com.dokany.java.constants.MountError;
import com.dokany.java.structure.DeviceOptions;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.cryptomator.frontend.dokany.Mount;
import org.cryptomator.frontend.dokany.Revealer;
import org.cryptomator.frontend.dokany.SafeUnmountCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DokanyMount
implements Mount {
    private static final Logger LOG = LoggerFactory.getLogger(DokanyMount.class);
    private static final int MOUNT_TIMEOUT_MILLIS = Integer.getInteger("org.cryptomator.frontend.dokany.mountTimeOut", 5000);
    private static final int ADDITIONAL_TIMEOUT_MILLIS = 5000;
    private static final AtomicInteger MOUNT_COUNTER = new AtomicInteger(1);
    private final DeviceOptions deviceOptions;
    private final DokanyFileSystem fileSystem;
    private final SafeUnmountCheck unmountCheck;
    private final AtomicBoolean isMounted;

    public DokanyMount(DeviceOptions deviceOptions, DokanyFileSystem fileSystem) {
        this(deviceOptions, fileSystem, () -> true);
    }

    public DokanyMount(DeviceOptions deviceOptions, DokanyFileSystem fileSystem, SafeUnmountCheck unmountCheck) {
        this.deviceOptions = deviceOptions;
        this.fileSystem = fileSystem;
        this.isMounted = new AtomicBoolean(false);
        this.unmountCheck = unmountCheck;
    }

    public static long getDriverVersion() {
        return NativeMethods.DokanDriverVersion();
    }

    public static long getVersion() {
        return NativeMethods.DokanVersion();
    }

    public void mount() throws DokanyException {
        this.mount(ignored -> {});
    }

    public synchronized void mount(Consumer<Throwable> onDokanExit) throws DokanyException {
        if (!this.isMounted.getAndSet(true)) {
            int mountId = MOUNT_COUNTER.getAndIncrement();
            try {
                this.checkReportedVersions();
                Runtime.getRuntime().addShutdownHook(new Thread(this::close));
                CountDownLatch mountSuccessSignal = new CountDownLatch(1);
                AtomicReference exception = new AtomicReference();
                Thread mountThread = new Thread(() -> {
                    try {
                        int r = NativeMethods.DokanMain(this.deviceOptions, new DokanyOperationsProxy(mountSuccessSignal, this.fileSystem, "dokanMount-" + mountId + "-callback-"));
                        if (r != 0) {
                            throw new DokanyException("DokanMain returned error code" + r + ": " + MountError.fromInt(r).getDescription());
                        }
                    }
                    catch (Exception e) {
                        exception.set(e);
                    }
                    finally {
                        this.isMounted.set(false);
                        onDokanExit.accept((Throwable)exception.get());
                    }
                });
                mountThread.setName("dokanMount-" + mountId + "-main");
                mountThread.setDaemon(true);
                mountThread.start();
                if (!mountSuccessSignal.await(MOUNT_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS)) {
                    this.checkToChoke((Throwable)exception.get(), mountThread.isAlive());
                    LOG.debug("Mount success not signaled after {} milliseconds. Waiting additional {} milliseconds.", (Object)MOUNT_TIMEOUT_MILLIS, (Object)5000);
                    if (!mountSuccessSignal.await(5000L, TimeUnit.MILLISECONDS)) {
                        this.checkToChoke((Throwable)exception.get(), mountThread.isAlive());
                        LOG.info("Mount success not signaled after second wait. Assume successful mount.");
                    }
                }
                return;
            }
            catch (UnsatisfiedLinkError err) {
                throw new DokanyException(err);
            }
            catch (InterruptedException e) {
                NativeMethods.DokanRemoveMountPoint(this.deviceOptions.MountPoint);
                Thread.currentThread().interrupt();
                throw new DokanyException("Mount interrupted.");
            }
        }
        LOG.debug("Dokan Device already mounted on {}.", (Object)this.deviceOptions.MountPoint);
    }

    private void checkReportedVersions() throws DokanyException {
        long apiVersion = NativeMethods.DokanVersion();
        long driverVersion = NativeMethods.DokanDriverVersion();
        LOG.info("Dokany API/driver version: {} / {}", (Object)DokanyMount.getVersion(), (Object)DokanyMount.getDriverVersion());
        if (apiVersion == 0L || driverVersion == 0L) {
            throw new DokanyException("Dokany not properly installed (Reported versions: " + apiVersion + "/" + driverVersion);
        }
    }

    void checkToChoke(Throwable e, boolean threadIsAlive) throws DokanyException {
        if (e != null) {
            if (e instanceof DokanyException) {
                throw (DokanyException)e;
            }
            throw new DokanyException(e);
        }
        if (!threadIsAlive) {
            throw new DokanyException("Unknown reason of failure.");
        }
    }

    @Override
    public synchronized void close() {
        if (this.isMounted.get()) {
            LOG.info("Unmounting dokan device at {}", (Object)this.deviceOptions.MountPoint);
            boolean unmounted = NativeMethods.DokanRemoveMountPoint(this.deviceOptions.MountPoint);
            if (unmounted) {
                this.isMounted.set(false);
            } else {
                LOG.error("Unable to unmount dokan device at {}.", (Object)this.deviceOptions.MountPoint);
            }
        }
    }

    @Override
    public void unmount() throws IllegalStateException {
        if (!this.unmountCheck.safeUnmountPossible()) {
            throw new IllegalStateException("There are handles to files or directories open.");
        }
        this.close();
    }

    @Override
    public void unmountForced() {
        this.close();
    }

    @Override
    public void reveal(Revealer revealer) throws Exception {
        if (!this.isMounted.get()) {
            throw new IllegalStateException("Filesystem not mounted.");
        }
        revealer.reveal(Path.of(this.deviceOptions.MountPoint.toString(), new String[0]));
    }
}

