/*$
Copyright (c) 2017, Azel
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

3. Neither the name of the copyright holder nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERSAND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
$*/

#ifndef MLIB_POPUPWINDOW_H
#define MLIB_POPUPWINDOW_H

#include "mWindowDef.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _mPopupWindow mPopupWindow;

#define M_POPUPWINDOW(p)  ((mPopupWindow *)(p))

typedef struct
{
	mBool (*quit)(mPopupWindow *,mBool bCancel);
	mBool bEnd;
}mPopupWindowData;

struct _mPopupWindow
{
	mWidget wg;
	mContainerData ct;
	mWindowData win;
	mPopupWindowData pop;
};


int mPopupWindowEventHandle(mWidget *wg,mEvent *ev);

mPopupWindow *mPopupWindowNew(int size,mWindow *owner,uint32_t style);

void mPopupWindowRun(mPopupWindow *p,int rootx,int rooty);
void mPopupWindowRun_show(mPopupWindow *p);

void mPopupWindowQuit(mPopupWindow *p,mBool bCancel);

#ifdef __cplusplus
}
#endif

#endif
