---
layout: page
title:  "Albert 0.13.0 released"
date: 2017-09-28 21:00 +0100
---

Albert v0.13 sets the focus on new frontends and performance optimizations in the core.

## Changes in the core

The frontend is now completely modular. From now on albert supports not only theming but an
abstract way to write completely separated user interfaces. You can even write one on your own since they are plugins now! No, don't. Designing frontends is a pain, PRs for curses interface welcome though ;D. The really amazing thing is that this finally allows using QML for designig frontends.

QML is a user interface markup language. It is a JSON-like declarative language for designing user interface–centric applications. Inline JavaScript code handles imperative aspects. This allows extremely flexible, flashy and animated interfaces, without coding imperative lines for hours and hours.

v0.13 comes with a new ready to use QML frontend plugin. QML allows to write the entire user interface in QML and Javascript. There is actually no need for another QML UI plugin anymore since the C++ code below to run QML would not change. Hence the QML plugin itself is modular, designed to have several _styles_ adhering to a determined QML-C++ interface. You can even write one on your own! No, dont, unless you're a dev. Actually its still a pain to write polished UIs, although its pretty easy. The devil's in the details.

A style in this context means a QML Frontend written in QML. v0.13 comes with one standard style: The _Box Model_ style. Looks pretty similar to the Widgets Box Model, but as you guessed, its flexible, animated and whatever. The Box Model style has properties that can be set with predefined themes. You could even make your own theme with the easy to use property editor without touching a single line of code! No don't… just kidding, do it! Its fun. Check out this video how-to video on [youtube](https://youtu.be/aCyB3ZngbLk).

Under the hood albert got some performance improvements. In the core ranking scores are now precomputed and items are added using move semantics to avoid expensive reference counting. Further you can tick the option lazy sort which delays sorting the items displayed until you actually display them by scrolling down. This has some implications on the scrollbar and the <kbd>Ctrl</kbd>+<kbd>End</kbd> button. The scrollbars height and position is determined by the amount of sorted instead of the actual amount of items and the <kbd>Ctrl</kbd>+<kbd>End</kbd> button moves the highlight to the last sorted item, which will trigger fetching and sorting of new items. So you wont be able to go to the actual last item. If you use neither of them enable it. It will save you some milliseconds on queries.

## Changes in the extensions

The files extension now has a tree structured folder index for smart indexing an less space
requirements. QStrings are memory expensive. Inherently to the tree structure of the file system, the prefix of a path repeatedly occurs in the file paths. The tree structured index avoids this kind of duplication. Further the tree stores information about the modified times to determine if an update of the directory is necessary at all. This greatly reduces index times and resource consumption.

Then there are several minor changes, the minimum language standard changed to C++14 and the minimum required CMake version is now 3.1.3. This comes along with the idea to always develop against the latest Ubuntu LTS.

Further several configuration paths changed. The uniform data location are now like {configPath, dataPath, cachePath}/albert/&lt;extensionId&gt; for each extension and type. If something broke while updating check if the folders are in the correct place.

The terminals tab completion for the executable is shell like, by completing the common prefix of all matches.

New actions were introduced. There's a file action "execute file" and a app action "run as root" using `gksudo` now.

The interface of the external extensions changed slightly. The trigger is now removed from the query string before extension get called.

## New extensions

**Key Value Store** lets you store key value pairs for later lookup, e.g. `"IBAN": "DE1329423908429304102"` or `"Telefon": "+49 176 32434920"`. Use the trigger `kv` to interact with the extension. Set values with `kv set <key> <value>`, unset values with `kv unset <key>` and get them either by directly calling the extension `kv <keyprefix>` or by regular lookup with a prefix of the key.

**Hash Generator** does string hashing for you. Enter `hash` or the name of the hash directly, e.g. `md5`, and a string you want to hash. You will get the hashes as results. Exmaple: `md5 hashsource`.

## Notes for devs

As in the external extensions the query interface changed. The query now has a string and a rawString. The raw string returns the query string including the trigger. If the query is not triggered string and rawString are equivalent.

The extensions folder is now a git submodule. Expect this to change to a even more fine grained structure in future.


As always check the [git log](https://github.com/albertlauncher/albert/commits/v0.13.0) for details.
