---
layout: docs
title: Extensions
permalink: /docs/extensions/
---

From the user perspective the application consists of the launcher, which is the main window, the settings window and the tray icon if you enabled it. However under the hood Albert has a plugin based architecture, which allows the user to modify or extend the functionality of the application.
There are several extensions that get shipped together with the main albert core.

## The frontends

- [Widgets Box Model](/docs/extensions/widgetboxmodel/)
- [QML Box Model](/docs/extensions/qmlboxmodel/)

## The extensions

- [Applications](/docs/extensions/applications/)
- [Calculator](/docs/extensions/calculator/)
- [Chromium](/docs/extensions/chromium/)
- [External extensions](/docs/extensions/external/)
- [Files](/docs/extensions/files/)
- Firefox
- Hash generator
- [MPRIS](/docs/extensions/mpris/)
- [Python](/docs/extensions/python/)
- [Secure Shell](/docs/extensions/ssh/)
- Snippets
- System
- Terminal
- [VirtualBox](/docs/extensions/virtualbox/)
- [Websearch](/docs/extensions/websearch/)

## Python extensions

The Python extension adds a lot of functionality via python modules. Most of the community effort goes into this part of the project. Check [the repo](https://github.com/albertlauncher/python) for an up to date list of extensions.
