--
-- modules/vstudio/tests/cs2005/test_nuget_framework_folders.lua
-- Validate parsing of framework versions from folder names for
-- Visual Studio 2010 and newer
-- Copyright (c) 2017 Jason Perkins and the Premake project
--

	local p = premake
	local suite = test.declare("vstudio_cs2005_nuget_framework_folders")
	local cs2005 = p.vstudio.cs2005


	function suite.net()
		test.isequal(cs2005.frameworkVersionForFolder("net451"), "4510000000")
		test.isequal(cs2005.frameworkVersionForFolder("net45"), "4500000000")
		test.isequal(cs2005.frameworkVersionForFolder("net20"), "2000000000")
		test.isequal(cs2005.frameworkVersionForFolder("net35"), "3500000000")
		test.isequal(cs2005.frameworkVersionForFolder("net"), "0000000000")
	end

	function suite.numeric()
		test.isequal(cs2005.frameworkVersionForFolder("10"), "1000000000")
		test.isequal(cs2005.frameworkVersionForFolder("11"), "1100000000")
		test.isequal(cs2005.frameworkVersionForFolder("20"), "2000000000")
		test.isequal(cs2005.frameworkVersionForFolder("45"), "4500000000")
	end

	function suite.numericWithDots()
		test.isequal(cs2005.frameworkVersionForFolder("1.0"), "1000000000")
		test.isequal(cs2005.frameworkVersionForFolder("1.1"), "1100000000")
		test.isequal(cs2005.frameworkVersionForFolder("2.0"), "2000000000")
		test.isequal(cs2005.frameworkVersionForFolder("4.5"), "4500000000")
	end

	function suite.invalid()
		test.isnil(cs2005.frameworkVersionForFolder("netstandard1.3"))
		test.isnil(cs2005.frameworkVersionForFolder("sl4"))
		test.isnil(cs2005.frameworkVersionForFolder("sl5"))
		test.isnil(cs2005.frameworkVersionForFolder("uap10"))
		test.isnil(cs2005.frameworkVersionForFolder("wp8"))
		test.isnil(cs2005.frameworkVersionForFolder("wp71"))
	end
