#!/bin/bash

# Author: Sotiris Papadopoulos <ytubedlg@gmail.com>
# Last-Revision: 2017-04-17
# Script to update the AUTHORS file
#
# Usage: ./update-authors.sh

cd ..

git log --reverse --format="%aN <%aE>" | python -c "

import sys

authors = set()

sys.stdout.write('# Authors ordered by first contribution.\n\n')

for line in sys.stdin:
    username, _ = line.split('<')

    if username not in authors:
        authors.add(username)
        sys.stdout.write(line)

sys.stdout.write('\n# Generated by update-authors.sh script\n')
" > AUTHORS
