#
# spec file for package xfce4-dxreminders-plugin
#
# Copyright (c) 2020 David Vachulka <arch_dvx@users.sourceforge.net>
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

Name:           xfce4-dxreminders-plugin
Summary:        Plugin for reminders, date a time
Version:        1.0.0
Release:        1
License:        GPL-2.0+
URL:            https://dxreminders.dxsolutions.org/plugin/
Source:         %{name}-%{version}.tar.gz

#--------------------------------------------------------------------
# Red Hat
#--------------------------------------------------------------------
%if 0%{?fedora} || 0%{?rhel_version} || 0%{?centos_version} || 0%{?scientificlinux_version}
Group:          Graphical desktop/Xfce

BuildRequires:  gettext
%endif
#--------------------------------------------------------------------
# Mageia
#--------------------------------------------------------------------
%if 0%{?mgaversion}
Group:          Graphical desktop/Xfce

BuildRequires:  gettext
%endif
#--------------------------------------------------------------------
# SUSE
#--------------------------------------------------------------------
%if 0%{?suse_version}
Group:          System/GUI/XFCE

BuildRequires:  pkgconfig
%endif
#--------------------------------------------------------------------
# All
#--------------------------------------------------------------------
BuildRequires:  cmake
BuildRequires:  gcc
BuildRequires:  pkgconfig(libxfce4panel-2.0) >= 4.11
BuildRequires:  pkgconfig(libxfce4ui-2) >= 4.11
Requires: dxreminders >= 1.20.0
#--------------------------------------------------------------------

%description
Reminders, date and time plugin for the Xfce4 panel.
This plugin shows the date and time in the panel, and mini-calendar or
dxReminders (depends on option) appears when you left-click on it.
dxReminders appers on right-click menu.

%prep
%setup -q

#--------------------------------------------------------------------
# Red Hat
#--------------------------------------------------------------------
%if 0%{?fedora} || 0%{?rhel_version} || 0%{?centos_version} || 0%{?scientificlinux_version}
%build
%cmake
%if 0%{?fedora} > 32
%cmake_build
%else
%make_build
%endif

%install
%if 0%{?fedora} > 32
%cmake_install
%else
%make_install
%endif

%find_lang %{name}
%endif
#--------------------------------------------------------------------
# Mageia
#--------------------------------------------------------------------
%if 0%{?mgaversion}
%build
%cmake
%make_build

%install
%make_install -C build

%find_lang %{name}
%endif
#--------------------------------------------------------------------
# SUSE
#--------------------------------------------------------------------
%if 0%{?suse_version}
%build
%cmake
%make_jobs

%install
%cmake_install

%find_lang %{name}
%endif
#--------------------------------------------------------------------

%files -f %{name}.lang
%defattr(-,root,root,-)
%{_libdir}/xfce4/panel/plugins/libdxreminders.so
%{_datadir}/xfce4/panel/plugins/dxreminders.desktop
%{_datadir}/icons/hicolor/*/*/xfce4-dxreminders-plugin.*g
%doc AUTHORS NEWS README

%changelog
* Sun Jun 21 2020 David Vachulka <arch_dvx@users.sourceforge.net> - 1.0.0-1
- Initial package.
