/*
 * Copyright (C) 2014 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from generate-input-with-guard.json
// by the script: JavaScriptCore/replay/scripts/CodeGeneratorReplayInputs.py

#pragma once

#if ENABLE(WEB_REPLAY)
#include "InternalNamespaceHeaderIncludeDummy.h"
#include <platform/ExternalNamespaceHeaderIncludeDummy.h>



namespace Test {
#if ENABLE(DUMMY_FEATURE)
class GetCurrentTime;
#endif // ENABLE(DUMMY_FEATURE)
class SetRandomSeed;
} // namespace Test

namespace JSC {
#if ENABLE(DUMMY_FEATURE)
template<> struct TEST_EXPORT_MACRO InputTraits<Test::GetCurrentTime> {
    static InputQueue queue() { return InputQueue::ScriptMemoizedData; }
    static const String& type();

    static void encode(JSC::EncodedValue&, const Test::GetCurrentTime&);
    static bool decode(JSC::EncodedValue&, std::unique_ptr<Test::GetCurrentTime>&);
};
#endif // ENABLE(DUMMY_FEATURE)

template<> struct TEST_EXPORT_MACRO InputTraits<Test::SetRandomSeed> {
    static InputQueue queue() { return InputQueue::ScriptMemoizedData; }
    static const String& type();

    static void encode(JSC::EncodedValue&, const Test::SetRandomSeed&);
    static bool decode(JSC::EncodedValue&, std::unique_ptr<Test::SetRandomSeed>&);
};

} // namespace JSC

namespace Test {
#if ENABLE(DUMMY_FEATURE)
class GetCurrentTime : public NondeterministicInput<GetCurrentTime> {
public:
    TEST_EXPORT_MACRO GetCurrentTime(double currentTime);
    virtual ~GetCurrentTime();

    double currentTime() const { return m_currentTime; }
private:
    double m_currentTime;
};
#endif // ENABLE(DUMMY_FEATURE)

class SetRandomSeed : public NondeterministicInput<SetRandomSeed> {
public:
    TEST_EXPORT_MACRO SetRandomSeed(uint64_t randomSeed);
    virtual ~SetRandomSeed();

    uint64_t randomSeed() const { return m_randomSeed; }
private:
    uint64_t m_randomSeed;
};
} // namespace Test

#if ENABLE(DUMMY_FEATURE)
SPECIALIZE_TYPE_TRAITS_BEGIN(Test::GetCurrentTime)
    static bool isType(const NondeterministicInputBase& input) { return input.type() == InputTraits<Test::GetCurrentTime>::type(); }
SPECIALIZE_TYPE_TRAITS_END()
#endif // ENABLE(DUMMY_FEATURE)

SPECIALIZE_TYPE_TRAITS_BEGIN(Test::SetRandomSeed)
    static bool isType(const NondeterministicInputBase& input) { return input.type() == InputTraits<Test::SetRandomSeed>::type(); }
SPECIALIZE_TYPE_TRAITS_END()

#define TEST_REPLAY_INPUT_NAMES_FOR_EACH(macro) \
    macro(GetCurrentTime) \
    macro(SetRandomSeed) \
    \
// end of TEST_REPLAY_INPUT_NAMES_FOR_EACH

#endif // ENABLE(WEB_REPLAY)
