# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

head-title = About Developer Tools
enable-title = Enable Firefox Developer Tools
enable-inspect-element-title = Enable Firefox Developer Tools to use Inspect Element
enable-inspect-element-message = Examine and edit HTML and CSS with the Developer Tools’ Inspector.
enable-about-debugging-message = Develop and debug WebExtensions, web workers, service workers and more with Firefox Developer Tools.
enable-key-shortcut-message = You activated a Developer Tools shortcut. If that was a mistake, you can close this Tab.
enable-menu-message = Perfect your website’s HTML, CSS, and JavaScript with tools like Inspector and Debugger.
enable-common-message = Firefox Developer Tools are disabled by default to give you more control over your browser.
enable-learn-more-link = Learn more about Developer Tools
enable-enable-button = Enable Developer Tools
enable-close-button = Close this Tab
welcome-title = Welcome to Firefox Developer Tools!
newsletter-title = Mozilla Developer Newsletter
newsletter-message = Get developer news, tricks and resources sent straight to your inbox.
newsletter-email-placeholder =
    .placeholder = Email
newsletter-privacy-label = I’m okay with Mozilla handling my info as explained in this <a data-l10n-name="privacy-policy">Privacy Policy</a>.
newsletter-subscribe-button = Subscribe
newsletter-thanks-title = Thanks!
newsletter-thanks-message = If you haven’t previously confirmed a subscription to a Mozilla-related newsletter you may have to do so. Please check your inbox or your spam filter for an email from us.
footer-title = Firefox Developer Edition
footer-message = Looking for more than just Developer Tools? Check out the Firefox browser that is built specifically for developers and modern workflows.
footer-learn-more-link = Learn more
features-learn-more = Learn more
features-inspector-title = Inspector
features-inspector-desc = Inspect and refine code to build pixel-perfect layouts. <a data-l10n-name="learn-more">{ features-learn-more }</a>
features-console-title = Console
features-console-desc = Track CSS, JavaScript, security and network issues. <a data-l10n-name="learn-more">{ features-learn-more }</a>
features-debugger-title = Debugger
features-debugger-desc = Powerful JavaScript debugger with support for your framework. <a data-l10n-name="learn-more">{ features-learn-more }</a>
features-network-title = Network
features-network-desc = Monitor network requests that can slow or block your site. <a data-l10n-name="learn-more">{ features-learn-more }</a>
features-storage-title = Storage
features-storage-desc = Add, modify and remove cache, cookies, databases and session data. <a data-l10n-name="learn-more">{ features-learn-more }</a>
features-responsive-title = Responsive Design Mode
features-responsive-desc = Test sites on emulated devices in your browser. <a data-l10n-name="learn-more">{ features-learn-more }</a>
features-visual-editing-title = Visual Editing
features-visual-editing-desc = Fine-tune animations, alignment and padding. <a data-l10n-name="learn-more">{ features-learn-more }</a>
features-performance-title = Performance
features-performance-desc = Unblock bottlenecks, streamline processes, optimize assets. <a data-l10n-name="learn-more">{ features-learn-more }</a>
features-memory-title = Memory
features-memory-desc = Find memory leaks and make your application zippy. <a data-l10n-name="learn-more">{ features-learn-more }</a>
# Variables:
#   $errorDescription (String) - The error that occurred e.g. 404 - Not Found
newsletter-error-common = Subscription request failed ({ $errorDescription }).
newsletter-error-unknown = An unexpected error occurred.
newsletter-error-timeout = Subscription request timed out.
# Variables:
#   $shortcut (String) - The keyboard shortcut used for the tool
welcome-message = You’ve successfully enabled Developer Tools! To get started, explore the Web Developer menu or open the tools with { $shortcut }.
