/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.DfsBlock;
import org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsPackKey;
import org.eclipse.jgit.internal.storage.dfs.DfsPackParser;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsText;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackIndexWriter;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.transport.PackedObjectInfo;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.io.CountingOutputStream;

public class DfsInserter
extends ObjectInserter {
    private static final int INDEX_VERSION = 2;
    private final DfsObjDatabase db;
    private int compression = 9;
    private List<PackedObjectInfo> objectList;
    private ObjectIdOwnerMap<PackedObjectInfo> objectMap;
    private DfsBlockCache cache;
    private DfsPackKey packKey;
    private DfsPackDescription packDsc;
    private PackStream packOut;
    private boolean rollback;

    protected DfsInserter(DfsObjDatabase db) {
        this.db = db;
    }

    void setCompressionLevel(int compression) {
        this.compression = compression;
    }

    @Override
    public DfsPackParser newPackParser(InputStream in) throws IOException {
        return new DfsPackParser(this.db, this, in);
    }

    @Override
    public ObjectReader newReader() {
        return new Reader();
    }

    @Override
    public ObjectId insert(int type, byte[] data, int off, int len) throws IOException {
        ObjectId id = this.idFor(type, data, off, len);
        if (this.objectMap != null && this.objectMap.contains(id)) {
            return id;
        }
        if (this.db.has(id)) {
            return id;
        }
        long offset = this.beginObject(type, len);
        this.packOut.compress.write(data, off, len);
        this.packOut.compress.finish();
        return this.endObject(id, offset);
    }

    @Override
    public ObjectId insert(int type, long len, InputStream in) throws IOException {
        byte[] buf = this.insertBuffer(len);
        if (len <= (long)buf.length) {
            IO.readFully(in, buf, 0, (int)len);
            return this.insert(type, buf, 0, (int)len);
        }
        long offset = this.beginObject(type, len);
        MessageDigest md = this.digest();
        md.update(Constants.encodedTypeString(type));
        md.update((byte)32);
        md.update(Constants.encodeASCII(len));
        md.update((byte)0);
        while (0L < len) {
            int n = in.read(buf, 0, (int)Math.min((long)buf.length, len));
            if (n <= 0) {
                throw new EOFException();
            }
            md.update(buf, 0, n);
            this.packOut.compress.write(buf, 0, n);
            len -= (long)n;
        }
        this.packOut.compress.finish();
        return this.endObject(ObjectId.fromRaw(md.digest()), offset);
    }

    private byte[] insertBuffer(long len) {
        byte[] buf = this.buffer();
        if (len <= (long)buf.length) {
            return buf;
        }
        if (len < (long)this.db.getReaderOptions().getStreamFileThreshold()) {
            try {
                return new byte[(int)len];
            }
            catch (OutOfMemoryError noMem) {
                return buf;
            }
        }
        return buf;
    }

    @Override
    public void flush() throws IOException {
        if (this.packDsc == null) {
            return;
        }
        if (this.packOut == null) {
            throw new IOException();
        }
        byte[] packHash = this.packOut.writePackFooter();
        this.packDsc.addFileExt(PackExt.PACK);
        this.packDsc.setFileSize(PackExt.PACK, this.packOut.getCount());
        this.packOut.close();
        this.packOut = null;
        this.sortObjectsById();
        PackIndex index = this.writePackIndex(this.packDsc, packHash, this.objectList);
        this.db.commitPack(Collections.singletonList(this.packDsc), null);
        this.rollback = false;
        DfsPackFile p = this.cache.getOrCreate(this.packDsc, this.packKey);
        if (index != null) {
            p.setPackIndex(index);
        }
        this.db.addPack(p);
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.packOut != null) {
            try {
                this.packOut.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.packOut = null;
            }
        }
        if (this.rollback && this.packDsc != null) {
            try {
                this.db.rollbackPack(Collections.singletonList(this.packDsc));
            }
            finally {
                this.packDsc = null;
                this.rollback = false;
            }
        }
        this.clear();
    }

    private void clear() {
        this.objectList = null;
        this.objectMap = null;
        this.packKey = null;
        this.packDsc = null;
    }

    private long beginObject(int type, long len) throws IOException {
        if (this.packOut == null) {
            this.beginPack();
        }
        long offset = this.packOut.getCount();
        this.packOut.beginObject(type, len);
        return offset;
    }

    private ObjectId endObject(ObjectId id, long offset) {
        PackedObjectInfo obj = new PackedObjectInfo(id);
        obj.setOffset(offset);
        obj.setCRC((int)this.packOut.crc32.getValue());
        this.objectList.add(obj);
        this.objectMap.addIfAbsent(obj);
        return id;
    }

    private void beginPack() throws IOException {
        this.objectList = new BlockList<PackedObjectInfo>();
        this.objectMap = new ObjectIdOwnerMap();
        this.cache = DfsBlockCache.getInstance();
        this.rollback = true;
        this.packDsc = this.db.newPack(DfsObjDatabase.PackSource.INSERT);
        this.packOut = new PackStream(this.db.writeFile(this.packDsc, PackExt.PACK));
        this.packKey = new DfsPackKey();
        byte[] buf = this.packOut.hdrBuf;
        System.arraycopy(Constants.PACK_SIGNATURE, 0, buf, 0, 4);
        NB.encodeInt32(buf, 4, 2);
        NB.encodeInt32(buf, 8, 1);
        this.packOut.write(buf, 0, 12);
    }

    private void sortObjectsById() {
        Collections.sort(this.objectList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackIndex writePackIndex(DfsPackDescription pack, byte[] packHash, List<PackedObjectInfo> list) throws IOException {
        pack.setIndexVersion(2);
        pack.setObjectCount(list.size());
        TemporaryBuffer.Heap buf = null;
        PackIndex packIndex = null;
        if (list.size() <= 58000) {
            buf = new TemporaryBuffer.Heap(0x200000);
            DfsInserter.index(buf, packHash, list);
            packIndex = PackIndex.read(buf.openInputStream());
        }
        try (DfsOutputStream os = this.db.writeFile(pack, PackExt.INDEX);){
            CountingOutputStream cnt = new CountingOutputStream(os);
            if (buf != null) {
                buf.writeTo(cnt, null);
            } else {
                DfsInserter.index(cnt, packHash, list);
            }
            pack.addFileExt(PackExt.INDEX);
            pack.setFileSize(PackExt.INDEX, cnt.getCount());
        }
        return packIndex;
    }

    private static void index(OutputStream out, byte[] packHash, List<PackedObjectInfo> list) throws IOException {
        PackIndexWriter.createVersion(out, 2).write(list, packHash);
    }

    private final class ReadBackStream
    extends InputStream {
        private long pos;

        ReadBackStream(long offset) {
            this.pos = offset;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int n = this.read(b);
            return n == 1 ? b[0] & 0xFF : -1;
        }

        @Override
        public int read(byte[] buf, int ptr, int len) throws IOException {
            int n = DfsInserter.this.packOut.read(this.pos, buf, ptr, len);
            if (n > 0) {
                this.pos += (long)n;
            }
            return n;
        }
    }

    private class StreamLoader
    extends ObjectLoader {
        private final ObjectId id;
        private final int type;
        private final long size;
        private final DfsPackKey srcPack;
        private final long pos;

        StreamLoader(ObjectId id, int type, long sz, DfsPackKey key, long pos) {
            this.id = id;
            this.type = type;
            this.size = sz;
            this.srcPack = key;
            this.pos = pos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectStream openStream() throws IOException {
            final DfsReader ctx = new DfsReader(DfsInserter.this.db);
            if (this.srcPack != DfsInserter.this.packKey) {
                try {
                    ObjectStream objectStream = ctx.open(this.id, this.type).openStream();
                    return objectStream;
                }
                finally {
                    ctx.close();
                }
            }
            int bufsz = 8192;
            Inflater inf = ctx.inflater();
            return new ObjectStream.Filter(this.type, this.size, new BufferedInputStream(new InflaterInputStream(new ReadBackStream(this.pos), inf, bufsz), bufsz)){

                @Override
                public void close() throws IOException {
                    ctx.close();
                    super.close();
                }
            };
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public boolean isLarge() {
            return true;
        }

        @Override
        public byte[] getCachedBytes() throws LargeObjectException {
            throw new LargeObjectException.ExceedsLimit(DfsInserter.this.db.getReaderOptions().getStreamFileThreshold(), this.size);
        }
    }

    private class Reader
    extends ObjectReader {
        private final DfsReader ctx;

        private Reader() {
            this.ctx = new DfsReader(DfsInserter.this.db);
        }

        @Override
        public ObjectReader newReader() {
            return DfsInserter.this.db.newReader();
        }

        @Override
        public Collection<ObjectId> resolve(AbbreviatedObjectId id) throws IOException {
            Collection<ObjectId> stored = this.ctx.resolve(id);
            if (DfsInserter.this.objectList == null) {
                return stored;
            }
            HashSet<ObjectId> r = new HashSet<ObjectId>(stored.size() + 2);
            r.addAll(stored);
            for (PackedObjectInfo obj : DfsInserter.this.objectList) {
                if (id.prefixCompare(obj) != 0) continue;
                r.add(obj.copy());
            }
            return r;
        }

        @Override
        public ObjectLoader open(AnyObjectId objectId, int typeHint) throws IOException {
            byte[] data;
            if (DfsInserter.this.objectMap == null) {
                return this.ctx.open(objectId, typeHint);
            }
            PackedObjectInfo obj = (PackedObjectInfo)DfsInserter.this.objectMap.get(objectId);
            if (obj == null) {
                return this.ctx.open(objectId, typeHint);
            }
            byte[] buf = DfsInserter.this.buffer();
            int cnt = DfsInserter.this.packOut.read(obj.getOffset(), buf, 0, 20);
            if (cnt <= 0) {
                throw new EOFException(DfsText.get().unexpectedEofInPack);
            }
            int c = buf[0] & 0xFF;
            int type = c >> 4 & 7;
            if (type == 6 || type == 7) {
                throw new IOException(MessageFormat.format(DfsText.get().cannotReadBackDelta, Integer.toString(type)));
            }
            long sz = c & 0xF;
            int ptr = 1;
            int shift = 4;
            while ((c & 0x80) != 0) {
                if (ptr >= cnt) {
                    throw new EOFException(DfsText.get().unexpectedEofInPack);
                }
                c = buf[ptr++] & 0xFF;
                sz += (long)(c & 0x7F) << shift;
                shift += 7;
            }
            long zpos = obj.getOffset() + (long)ptr;
            if (sz < (long)this.ctx.getStreamFileThreshold() && (data = this.inflate(obj, zpos, (int)sz)) != null) {
                return new ObjectLoader.SmallObject(type, data);
            }
            return new StreamLoader(obj.copy(), type, sz, DfsInserter.this.packKey, zpos);
        }

        private byte[] inflate(PackedObjectInfo obj, long zpos, int sz) throws IOException, CorruptObjectException {
            try {
                return DfsInserter.this.packOut.inflate(this.ctx, zpos, sz);
            }
            catch (DataFormatException dfe) {
                CorruptObjectException coe = new CorruptObjectException(MessageFormat.format(JGitText.get().objectAtHasBadZlibStream, obj.getOffset(), DfsInserter.this.packDsc.getFileName(PackExt.PACK)));
                coe.initCause(dfe);
                throw coe;
            }
        }

        @Override
        public Set<ObjectId> getShallowCommits() throws IOException {
            return this.ctx.getShallowCommits();
        }

        @Override
        public void close() {
            this.ctx.close();
        }
    }

    private class PackStream
    extends OutputStream {
        private final DfsOutputStream out;
        private final MessageDigest md;
        private final byte[] hdrBuf;
        private final Deflater deflater;
        private final int blockSize;
        private long currPos;
        private int currPtr;
        private byte[] currBuf;
        final CRC32 crc32;
        final DeflaterOutputStream compress;

        PackStream(DfsOutputStream out) {
            this.out = out;
            this.hdrBuf = new byte[32];
            this.md = Constants.newMessageDigest();
            this.crc32 = new CRC32();
            this.deflater = new Deflater(DfsInserter.this.compression);
            this.compress = new DeflaterOutputStream((OutputStream)this, this.deflater, 8192);
            int size = out.blockSize();
            if (size <= 0) {
                size = DfsInserter.this.cache.getBlockSize();
            } else if (size < DfsInserter.this.cache.getBlockSize()) {
                size = DfsInserter.this.cache.getBlockSize() / size * size;
            }
            this.blockSize = size;
            this.currBuf = new byte[this.blockSize];
        }

        long getCount() {
            return this.currPos + (long)this.currPtr;
        }

        void beginObject(int objectType, long length) throws IOException {
            this.crc32.reset();
            this.deflater.reset();
            this.write(this.hdrBuf, 0, this.encodeTypeSize(objectType, length));
        }

        private int encodeTypeSize(int type, long rawLength) {
            long nextLength = rawLength >>> 4;
            this.hdrBuf[0] = (byte)((long)((nextLength > 0L ? 128 : 0) | type << 4) | rawLength & 0xFL);
            rawLength = nextLength;
            int n = 1;
            while (rawLength > 0L) {
                this.hdrBuf[n++] = (byte)((long)((nextLength >>>= 7) > 0L ? 128 : 0) | rawLength & 0x7FL);
                rawLength = nextLength;
            }
            return n;
        }

        @Override
        public void write(int b) throws IOException {
            this.hdrBuf[0] = (byte)b;
            this.write(this.hdrBuf, 0, 1);
        }

        @Override
        public void write(byte[] data, int off, int len) throws IOException {
            this.crc32.update(data, off, len);
            this.md.update(data, off, len);
            this.writeNoHash(data, off, len);
        }

        private void writeNoHash(byte[] data, int off, int len) throws IOException {
            while (0 < len) {
                int n = Math.min(len, this.currBuf.length - this.currPtr);
                if (n == 0) {
                    this.flushBlock();
                    this.currBuf = new byte[this.blockSize];
                    continue;
                }
                System.arraycopy(data, off, this.currBuf, this.currPtr, n);
                off += n;
                len -= n;
                this.currPtr += n;
            }
        }

        private void flushBlock() throws IOException {
            this.out.write(this.currBuf, 0, this.currPtr);
            byte[] buf = this.currPtr == this.currBuf.length ? this.currBuf : this.copyOf(this.currBuf, 0, this.currPtr);
            DfsInserter.this.cache.put(new DfsBlock(DfsInserter.this.packKey, this.currPos, buf));
            this.currPos += (long)this.currPtr;
            this.currPtr = 0;
            this.currBuf = null;
        }

        private byte[] copyOf(byte[] src, int ptr, int cnt) {
            byte[] dst = new byte[cnt];
            System.arraycopy(src, ptr, dst, 0, cnt);
            return dst;
        }

        byte[] writePackFooter() throws IOException {
            byte[] packHash = this.md.digest();
            this.writeNoHash(packHash, 0, packHash.length);
            if (this.currPtr != 0) {
                this.flushBlock();
            }
            return packHash;
        }

        int read(long pos, byte[] dst, int ptr, int cnt) throws IOException {
            int r;
            int n;
            for (r = 0; pos < this.currPos && r < cnt; pos += (long)n, r += n) {
                DfsBlock b = this.getOrLoadBlock(pos);
                n = b.copy(pos, dst, ptr + r, cnt - r);
            }
            if (this.currPos <= pos && r < cnt) {
                int s = (int)(pos - this.currPos);
                n = Math.min(this.currPtr - s, cnt - r);
                System.arraycopy(this.currBuf, s, dst, ptr + r, n);
                r += n;
            }
            return r;
        }

        byte[] inflate(DfsReader ctx, long pos, int len) throws IOException, DataFormatException {
            byte[] dstbuf;
            try {
                dstbuf = new byte[len];
            }
            catch (OutOfMemoryError noMemory) {
                return null;
            }
            Inflater inf = ctx.inflater();
            pos += (long)this.setInput(pos, inf);
            int dstoff = 0;
            while (true) {
                int n = inf.inflate(dstbuf, dstoff, dstbuf.length - dstoff);
                dstoff += n;
                if (inf.finished()) {
                    return dstbuf;
                }
                if (inf.needsInput()) {
                    pos += (long)this.setInput(pos, inf);
                    continue;
                }
                if (n == 0) break;
            }
            throw new DataFormatException();
        }

        private int setInput(long pos, Inflater inf) throws IOException {
            if (pos < this.currPos) {
                return this.getOrLoadBlock(pos).setInput(pos, inf);
            }
            if (pos < this.currPos + (long)this.currPtr) {
                int s = (int)(pos - this.currPos);
                int n = this.currPtr - s;
                inf.setInput(this.currBuf, s, n);
                return n;
            }
            throw new EOFException(DfsText.get().unexpectedEofInPack);
        }

        private DfsBlock getOrLoadBlock(long pos) throws IOException {
            int n;
            long s = this.toBlockStart(pos);
            DfsBlock b = (DfsBlock)DfsInserter.this.cache.get(DfsInserter.this.packKey, s);
            if (b != null) {
                return b;
            }
            byte[] d = new byte[this.blockSize];
            for (int p = 0; p < this.blockSize; p += n) {
                n = this.out.read(s + (long)p, ByteBuffer.wrap(d, p, this.blockSize - p));
                if (n > 0) continue;
                throw new EOFException(DfsText.get().unexpectedEofInPack);
            }
            b = new DfsBlock(DfsInserter.this.packKey, s, d);
            DfsInserter.this.cache.put(b);
            return b;
        }

        private long toBlockStart(long pos) {
            return pos / (long)this.blockSize * (long)this.blockSize;
        }

        @Override
        public void close() throws IOException {
            this.deflater.end();
            this.out.close();
        }
    }
}

