/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli;

import java.text.MessageFormat;
import org.tmatesoft.svn.cli.AbstractSVNCommandEnvironment;
import org.tmatesoft.svn.cli.SVNCommandLine;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public abstract class AbstractSVNLauncher {
    private static volatile boolean ourIsCompleted;
    private static volatile Thread ourShutdownHook;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void run(String[] args) {
        ourIsCompleted = false;
        if (this.needArgs() && (args == null || args.length < 1)) {
            this.printBasicUsage();
            this.failure();
            return;
        }
        this.registerOptions();
        this.registerCommands();
        SVNCommandLine commandLine = new SVNCommandLine(this.needCommand());
        try {
            commandLine.init(args);
        }
        catch (SVNException e) {
            this.handleError(e);
            this.printBasicUsage();
            this.failure();
            return;
        }
        AbstractSVNCommandEnvironment env = this.createCommandEnvironment();
        Class<AbstractSVNLauncher> clazz = AbstractSVNLauncher.class;
        synchronized (AbstractSVNLauncher.class) {
            block21: {
                if (ourShutdownHook == null) {
                    ourShutdownHook = new Thread(new Cancellator(env));
                } else {
                    Runtime.getRuntime().removeShutdownHook(ourShutdownHook);
                }
                Runtime.getRuntime().addShutdownHook(ourShutdownHook);
                // ** MonitorExit[var4_5] (shouldn't be in output)
                try {
                    try {
                        env.init(commandLine);
                    }
                    catch (SVNException e) {
                        this.handleError(e);
                        if (e instanceof SVNCancelException || e instanceof SVNAuthenticationException) {
                            env.dispose();
                            this.failure();
                            this.setCompleted();
                            return;
                        }
                        this.printBasicUsage();
                        env.dispose();
                        this.failure();
                        this.setCompleted();
                        return;
                    }
                    env.initClientManager();
                    if (!env.run()) {
                        env.dispose();
                        this.failure();
                        return;
                    }
                    env.dispose();
                    this.success();
                    break block21;
                    {
                        catch (Throwable th) {
                            SVNDebugLog.getDefaultLog().logSevere(SVNLogType.CLIENT, th);
                            th.printStackTrace();
                            if (env != null) {
                                env.dispose();
                            }
                            this.failure();
                            break block21;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.setCompleted();
                }
            }
            return;
        }
    }

    protected abstract boolean needArgs();

    protected abstract boolean needCommand();

    protected abstract String getProgramName();

    protected abstract AbstractSVNCommandEnvironment createCommandEnvironment();

    protected void printBasicUsage() {
        System.err.println(MessageFormat.format("Type ''{0} help'' for usage.", this.getProgramName()));
    }

    protected abstract void registerCommands();

    protected abstract void registerOptions();

    public void handleError(SVNException e) {
        System.err.println(e.getMessage());
    }

    public void failure() {
        this.setCompleted();
        try {
            System.exit(1);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void success() {
        this.setCompleted();
        try {
            System.exit(0);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCompleted() {
        Class<AbstractSVNLauncher> clazz = AbstractSVNLauncher.class;
        synchronized (AbstractSVNLauncher.class) {
            ourIsCompleted = true;
            AbstractSVNLauncher.class.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private class Cancellator
    implements Runnable {
        private AbstractSVNCommandEnvironment myEnvironment;

        public Cancellator(AbstractSVNCommandEnvironment env) {
            this.myEnvironment = env;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.myEnvironment.setCancelled();
            Class<AbstractSVNLauncher> clazz = AbstractSVNLauncher.class;
            synchronized (AbstractSVNLauncher.class) {
                while (!ourIsCompleted) {
                    try {
                        AbstractSVNLauncher.class.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

