# ifndef  _QF_BLINCH_H
# define  _QF_BLINCH_H

/*
static qf_double_t pole2 [36] = {

			    0.044511, 0.965277, 0.044508, 1.034715,
			    0.089329, 0.930344, 0.089278, 1.069526,
			    0.134836, 0.894882, 0.134567, 1.104443,
			    0.181546, 0.858420, 0.180657, 1.139378,
			    0.230179, 0.820255, 0.227872, 1.174122,
			    0.281785, 0.779306, 0.276597, 1.208308,
			    0.337958, 0.733796, 0.327288, 1.241328,
			    0.401267, 0.680511, 0.380447, 1.272188,
			    0.476159, 0.612773, 0.436512, 1.299242};

static qf_double_t h02 [9] = {
			    0.01275,  0.05131,	0.11667,  0.21060,
			    0.33592,  0.49689,	0.69996,  0.95506,
			    1.27828};

static qf_double_t pole4 [48] = {
0.114619, 1.044764, 0.114697, 0.954882, 0.085827, 1.134242, 0.085978, 0.865360,
0.172351, 1.067484, 0.172637, 0.930875,	0.129240, 1.202886, 0.129922, 0.795038,
0.235782, 1.088517, 0.237162, 0.905318,	0.175754, 1.270874, 0.178543, 0.722063,
0.300384, 1.109270, 0.303271, 0.875795,	0.223361, 1.340451, 0.230216, 0.640595,
0.370450, 1.125351, 0.378336, 0.837932,	0.273742, 1.409428, 0.292384, 0.544766,
0.443841, 1.138139, 0.457506, 0.787494,	0.326699, 1.479135, 0.368296, 0.411812};

static qf_double_t  h04 [6] = {
	  0.006175, 0.032093, 0.109165,	0.287063, 0.662010, 1.387289};
*/

static qf_double_t  blc_o2 [45] = {
	  20.89,    0.05022, 0.9776,  7.683,	0.1491,
	  10.17,    0.1080,  0.9920,  3.862,	0.3398,
	  6.782,    0.1693,  0.9893,  2.555,	0.5964,
	  5.113,    0.2338,  0.9822,  1.891,	0.9537,
	  4.112,    0.3017,  0.9744,  1.486,	1.475,
	  3.458,    0.3704,  0.9633,  1.208,	2.327,
	  2.995,    0.4393,  0.9508,  1.003,	3.969,
	  2.653,    0.5064,  0.9369,  0.8429,	8.630,
	  2.375,    0.5734,  0.9254,  0.7121,	96.78};

static qf_double_t  blc_o4 [45] = {

	7.721,	0.1430,	1.204,	2.453,	0.6317,	0.3529,	3.823,	0.7714,	0.9270,
	5.708,	0.2042,	1.058,	2.413,	0.7123,	0.7489,	2.191,	0.8488,	0.6760,
	4.535,	0.2701,	0.9981,	2.169,	0.9196,	1.302,	1.567,	0.8574,	0.5280,
	3.783,	0.3384,	0.9691,	1.888,	1.301,	2.097,	1.249,	0.8265,	0.4227,
	3.238,	0.4106,	0.9623,	1.617,	2.036,	3.262,	1.069,	0.7725,	0.3468};

class qf_blinch: public qf_filter {

  private:

		    qf_blinch	(qf_spec* P);
		    ~qf_blinch	(void)	    {}

//  void	    scpt	(void) {};
  qf_double_t	    interp2	(qf_double_t, unsigned);
  qf_double_t	    interp4	(qf_double_t, unsigned);
  friend bool	    blval	(qf_spec* P);

  public:

  bool	    synth	(void) {return true;}
  friend qf_filter* blinch	(qf_spec* Pspec)
				  {return new qf_blinch (Pspec);}
};

// Global interface
qf_filter*	    blinch	(qf_spec*);
bool		    blval	(qf_spec* P);

  # ifdef _QF_API
struct	qf_filter_api qf_blinch_api = 
{
  "Blinchikoff",
  QF_BLNCH,

  blval,
  blinch,

  false,
  false,
  true,		  // Only orders 2 and 4
  "\002\004",
  CAN_ORDER | CAN_ORDER_ONLY | CAN_BANDPASS,
  0,
  0,
  0,
  QF_LOWPASS | QF_HIGHPASS | QF_BANDPASS | QF_BANDSTOP | QF_ZIGZAG,
};
  # endif // _QF_API
# endif // _QF_BLINCH_H
