/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

const SEARCH_ENGINES = {
  "DuckDuckGo": {
  	 image: "data:image/png;base64," +
            "iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAMAAACdt4HsAAACT1BMVEXvISn/////9/fvUlr3ra3/" +
            "zs7/7+/va2v/5+f/xsbvMTn/tbX/3t7/vb3vOUL3WmPvQkr/zgDvKTHvSlL3hIT3paX/1tbnISn3" +
            "c3v3e3v3a3P3jIz3nJz/tb33c3PvKSn3lJT39/cAc73vSkr3e4Tv7+/3Yxj3pa3/tQj3jJT3nKX3" +
            "Y2P/xs73hIzvQkL/vQjvQiHn5+f3hBD/ztbvMTH/vcb/3ucIc733lJz/pQilzufe7/fvMSHOzs73" +
            "//cQrUpKvVprxmP3Y2vvShiUzmvWlJRzzmMYtUrvOTnn7/davVrWra3v9//nY2PvISGUxudztd7e" +
            "3t7/76XvKSHea2v/xgDnOUK93vfW5/f/1t73Uhj/52ut3q2l3rXO784pjMZrrdb/rQjera3/5+/e" +
            "paWMxufO79aEazkYrUr/nAj3jBD3axj3lBD///fehIRKpd7/1hCEYzk5vVL3//8ptVLW77UxtVLn" +
            "SlLW1tZCvVp7vef/1gj/3invSkL//+fWtbXvpaX/3kr/97XvnJznWmMxjM5zvefOxsbWnKXWjIzG" +
            "3u/ea3Pn997O5/fnQkqExuf3Whit1u/nUlrnxs7v5+d7zmuU1pT3exDOSjFjrVL/987/pUoQe8b/" +
            "75T/3jFKxnO158bWKSl7zoRSxmtajEK1e0pzxlqcUjH/1iHOMSnOvb33cxDWnJx7td6EzmP/74xz" +
            "azlrcznec3Pe771jxlpzczne78YpvVqEvWPn99YxvWOtSjHee3vG787OOTE5lEK1QjHv9+drzmve" +
            "tbXO772q+r8wAAAFbUlEQVR4Xo2X84PzTBDHN3Zqu2fbemzbNl7atm3btvGHvTNJ2myuyd3NL2mT" +
            "zmdnvjM76RImyGQlH5dCHBeSmscNmQkyfwBrZMLEY2aRF5cMSDYPEx+LZpUlAYRQbVEpnuc1je/M" +
            "SbVwYoVFAbpE0IaLmiwqiVymmE3H84YuGs2mheCEhQH5qPUrje2ONxHKVIkXR2x2MxsMkDnLvftk" +
            "2fSTQNCzSAgngwCCipkXxHiU+BsnCDFE8f6AQgnwaTGhkmDLymW8jPsBeIsth8iCpha618El1wgo" +
            "4FOhWyWLWY+O8pbnAwTI29S1ElncJBmF4L0AGeJSdR4dUpt5w+DL0nAgoUuGGKKCBxDCOxrykaDb" +
            "+yFQjhUylLlXpAB5jGnIqV6uvvWUcAAhLmDBXIAMrkXRdHQ+cerUiWefq1hRrAgg8LikUgdkQUAx" +
            "6+2Ze0WLEO/1BQzrHCFNrAPAeDSD4q/Ln6R3p68MSYzDAUiwIEutJM0bHXE/gpEhJMxaAB3T6aT8" +
            "mfkm+QBiMlwKFqAHvrHu9tvTOLrEdX4hFAkJWQB42qbVyam75ruv3zvF+wBCKJ0MAAV6SAy5+raA" +
            "y+lb9tYBUw9sffKRJh+CDl2SAEAPquaC76swU1c+zlxbA9if/EIY78AcCBODDKjnVzDM0+sb57zq" +
            "N14gdpbg4nraBaxm3NWpIDKNgJIIDTxEAKMyVM9/VrFcpijK52PbNhmk0RQORCA8dhGhIkDA+qPV" +
            "Y/U8No2NHZsUfQCdzYTECSiRSRJKgxYAnK6+tnVrPYL7q2P7GNNnT0L3SQSS61AowK4BAExWq9XJ" +
            "OmDT5D4GtUab7p92W1aD6AFBOjUKcONNKMG2o9vmScmhd+v5SCTS91StDLBwmHR5q0iiM4yv3X5g" +
            "sD1i24tUHc0GQOrOihdw+ZV7drx+8I1IzfpaCQ1oSIGsbqEBdxy8KkLb8dYt7m7AFBpEJI8OUIAd" +
            "Hve+wX509IqYgzLqxKMi5X+r6737wgHfMrZBKGwpQMWP0PN8/8qLn15cSRosEQeI3coxGrzRVfE2" +
            "BEyTAMNpmbA3k2erPOyq+CUCPGvv3OmGykYBQhiYFbynDLu2uyW826qb7bSlv/VCe2R3vQqhIYQQ" +
            "nLmSGKUAT1AqXn7V6p72iUsTThsNuhKUAeKMNFaiW2nG08H90IF1m6DywVdsHgA4bPgRGgAqUgBr" +
            "DwxOtPcdv9RK6yklnaGKOXBMmN7RVCtJJMiUdG2s78dv9HbY7KrI9AQBOHwjaxaA6cKhRLXCHkpF" +
            "PrAJYBz1su7LtSBQIjzozgI5AJDWsQ7gTJxETTHuEh5yW8kR5+1fvQBT5PDdWgPokE6GSuK3Aaby" +
            "2KwNyGFIZ8/NfexVMAGXEfe8MA5QTVdrgGe2M9evev6FMwiAYr308nVzcx/SgHwSlswyLgDLHU0K" +
            "tX5UZwCwZsM1b7516J1333v/g2UAuJoCNMsmZkEDZBXujCoOIfVJxQKsvXnDshvWfrEcAV9RAoqY" +
            "rfdvHjY06R3tVmtjzQYsQ8ByC/C1O0dEzqkAGqELbiZ1W/RvBr51Ad9ZgO8dQCkh4/q5xvMC6hot" +
            "sBl7rP1QT+HHQz9RGoSHhkyMgqEBdNPFWSWMY+1nBPxy+MjvZ2aZxB9n/zz3FwKiOTZfotb3AhhF" +
            "xSUUNmGSjX+vWvPPYacVWJOkUilUT05ymEVb0JFHj9l/AVn+35b/jsx6YzNz8mja+iAEH7rYDntY" +
            "Gaz3dizW080KWaeICx77kiG7lTKG6EEoPb0Wu0lZ9OA5whFH8GxHQjOMQls5HSs5t/glHX2FYtT/" +
            "mGAs/fCtFU0vQJUSQYfvIBvVyukuLhbjuood/H6WCbD/AQSFvIO3JDxgAAAAAElFTkSuQmCC"
  },
  "Yahoo": {
    image: "data:image/png;base64," +
           "iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAIAAAAlC+aJAAAJjUlEQVR4Xs1aa3BU5Rl+nu/sZnPZ" +
           "sLvZAMVECgoFokUUBbnkAjNqa6W2XlqsWAE1Ee0P+8NO2z+1Y2dsx5nO9I5aBERxrDo6Vp2OZQrE" +
           "hEvRqqOFqVy8IRZCdjeBkOxmz/eUTLM7Q4BzTkOn3Wf257tnvue9PPt871lms1mUHATh6fsPtv+q" +
           "TxBBj1CDEoSQPa4dG4/B7/QAQig9iNj+XCrXHSi5pgSbh2L7oynBF1KpEZAI2n27eg6+PQh/kCVX" +
           "AVrK2bI6Y6wB5FcsWKq0ZoAyPV25t17oY4DMEqi/PFRiLUR1buh2TzDIrAhobo2XEAFJyJuONT2C" +
           "/GNhKsbm59yYNCWkPsC7m1Ld+60J1D/u3GXxSKUpFQIUCWx+JEMQQRBCyx21ggxKBl0fZHdvGghW" +
           "LkxbXPG5KRGSJUOA2LImbXJCMLS0JsQS8UIChMF+27khLQTSn/gkM/OaGGEBhATQKxoUwMBHARQs" +
           "uPhYAYD++kKq/wgI+pIlsGBlzCkjYACENv/uaLGIxecVTWwoiqZbE4ADBlXCreuPugMQzAhmxTRQ" +
           "EnXJtdVjJ5YDAEGh/bEMZYgA2Sq3TctrIIAEEPrDfV0gIBRpnAJjJ19SVT+zggiEA2/2bVx1xFjH" +
           "wwhYMhLPL7w1CQgghQ/fPvHhzqyBA9BXamd9rXLM+DIJLNhpQqdEnQLX6Xiie+nD9WAgG9yxLuNY" +
           "B4DHURzpyltikWozfCpiy+9TcA38QdA235WkoEILhuBXs50be2960IYr6BeIbK9949kewfGMk3Vs" +
           "c2uSAghBJ9LY9cyxgHM2YaYzbX61KAa/D/R3880/piH/yB3Pp3O9Xs0DSOCUpvK66RXicP63b+x2" +
           "j9EEIqDGO2tgQBBgUAIAO9f2iNanOy061mYowROWWtQaK6oN89i6phvBEIpr/tLkyCEVXV/Xuvf1" +
           "/iP7ct5G4KN3T3z8Ro6ghxQKjNXp0utqUAja/Xpv1+6gEn3l0jGRMSN12tTNDAt+GDQdT6QhSDqb" +
           "De5YmzIu4YeFK+NO2AxLrrD50Qxkg/gfOWpprQEo6hQCzW0JerYtIcDseCrt5l2ejWCfdg4Nog9M" +
           "xF14exLDYObT7HsvH2cwrzplYVldQ+XpFTZXfiMZqc3DCyRs70G881rP6VohUcKuF9PZNDybR4Iu" +
           "XlKVrIsUxsluXZtGLti1lra5NcEzJyXKebcl/ESABuhc22t5hvqIbufQ+HoVkjCiPdkD4rBu53Ps" +
           "XJ9iMDMWncDLliTOKLVGxKK7kjY8CB9wz2t9mYO502frsz3Z/dsG4OkCBDu+ITSjsZoQAEhvvpI+" +
           "9kmQm7sELFwed8pwxmBDceyF5Q1XVwrysYxZs31jCiNAdK5LG9fQr4ZNQxIugAAFtD+aBhTAftKU" +
           "uY0ras8WaERRWrxqKMKzByCwY31a7ilB+QFt39gjvyyGY+6CWxIFkjq0p3/v1uzwU32gi64dUzMx" +
           "RAE8YwVAkA2Lq8dNc7zzQSC9D3vaeymhgL+9nBroIrxgBTNnaaw8YQoSrpPmx7GGgL+AEs1tMcCA" +
           "BHjW1aIxbGwbQ/988KRdKzYVpI7H05LPj5eMbbkzUfQvA73a+XSvgAAf1X6BF7VUA/Jf7i741tiX" +
           "ftQ92OvdzXrnpWPHj+ajtWFCR/Zn923NAd4+j5Pnh+q/WAkSgKRdL3YPDshUWO/+EUGoqS3pLVSF" +
           "9wOC6D5136cdq09Q3nqiG36euPqecQCff+Cfm37a42sBbn9y7LybasACSYvgd7zhQMK/ApRpaR3b" +
           "8dgHypNed0a77fFj16wan3e5Y0PG9woSnWBnL0mIJAowUuEqU/AFpAR6sPJdrxMg62aUT22O0HOO" +
           "Ceez9wb37up7+0+pY4coz9MTZv7yeDhCjsiqQAnD5ydhRWJUMCM8w6JVNdZX28iT2t+5pgfyVl66" +
           "4XzzilqSwyMvQLavO/fnX3f94voPf9Dw/v0X/OPBy99f13bo769lYAlJECQExinvyATZPH948e6e" +
           "D7zu14LCVXSzUp7wxMVfLbvn2ckEIQmU3L880v3SA125jITiYlkAXdrJ8yO3rz7vvKnlIgiOpgIA" +
           "HAdNrQnBCwQH+6zN+1g3O6QhCQoAREruhu988tx3u3OZEBEyEIZBAUb8qDP3s8UHPnqrjxp1C4Eg" +
           "mm6rDUddPw6G3hyh2ummoSUOCgClVx4+vP3xAYqERihL8Rct12V+882Dfen8aAgUUV0bnn1zFUCM" +
           "FgQA03hH3HEoAMLhA/2vPpSC6F1YgL0fD1EVBGiUBEAtunsc6GL0kBN1Fy5LgoAMgE2/Sak/RPg+" +
           "U4La1/W4/YQ4SgICJs2qnDwvIgijxRU3VVfVOIUOxzsvH1exNr4DljYH3uodfQUISmq+N0GY0XFw" +
           "TWHzA1Doy9j0wbwJRIAEKR7eNzj6GQBA8vLraqrOzwP8zzfNmjSnfNJl0cJ32d+bM9YgOCCbA3gO" +
           "BAA45WpcWTOqZblpao2RAgFARFV1xNIiOMDoeCOcGwECzSuSKHcthOAAK8a5c29IQiiiMs5kfTh4" +
           "Aa0ZnHxpFOdIQDBjJpTN/nqUACAExrxvx0Ll5pR+MJh5fTRYCUSYCxsrknVlAM+JACAjtdydBIXA" +
           "UDjfsjLBkYR11b3JcIVVAAmCca/7fq0g6lxbiCCnzInWzw4rGAkBDVdVjrugErRF2gQJ1k6KLPlJ" +
           "jShBOlvvQAIa761qWBQDgw+xJ0i0tCUAAS78oKHlfQ0owYxoAAJX3zP+qu9FYexZyNNSc1ZGlj40" +
           "EURwGPhh7s2x8vGgT6QEJCabmdfEz2hiRcLoxh+f3/ZsXe10WAyXovBhfIq7Yv345b+dxDAgIjBC" +
           "8AZtqDxcNyO8/7CXdRZIoOnOGI2XOwIx6yuxmV+K7d12/P3O4+lPcgDi9eEvzK+eOj8aKmMx+r9H" +
           "QObw3r59r2cJA3hSiNrGZbWkz5/cSDoOpjVVzWisUrGqHL1r8fnTn6Bn7v90yy99dsiCrlhWuXLN" +
           "RIL438LAEwO97vYnewj5qndza2H5WlIEtj2TyqUc35PVX+pcMGcMpRIiIEgW7aszvlbCAk1tcQOV" +
           "VgUo7GnPHNqdJ+h9+oqknXtjshBVQi3EzaszxvoskAnMvTVWXu1ABEuphY5+nH3v1RO+C2Q5+Za7" +
           "aiCCKJUWEgBpy5pu5UhPtydoekvlhKkRUUDJtBClwQF1rs1ABLzfb/Pk+AoGKCUCIHY8l+o/Yvxe" +
           "eyHxecz6coIAwBIiYMX2R9K+SSW4YOitNUAQ/zf8C4sZTcVG5HPrAAAAAElFTkSuQmCC"
  },
  "Bing": {
    image: "data:image/png;base64," +
           "iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAMAAACdt4HsAAACslBMVEX+sgf9vwj+uQj+wwn+uQn+" +
           "wwj/rgf+xAn+sgb+rgb9wAj9wwn9wwj9vgj+uAj+swf9wAlQUFD+wAn+xAj+ughQUE/+wQn9wglQ" +
           "T1D9vAj9sgf9sQf+sQdPUE/9uwj+twj9vwn9wQn/uQn9ugj9uQj+rgf+vAlPT1D9sgb9wQj+rQb9" +
           "vQj+wAj+sAf+rwb9uAhPUFD9tAf9swf+ugn+rQf+tQf9vgn9sQb+tAf+wgn+vQn+uwj9twf9tgf+" +
           "sAb9vQn+sQZQT09RUE/+wghPT0/+uwn+vAj9xAj9uwl8aj39tQf9wgj+uAlTUk7EkR//rgZ8bD10" +
           "ZED+tghnXUZXVEz+vghVUk1cV0r6qwjuuQ+ugij+tQiogir9rQf+vwjlpBGHbzj7sAhbVUtkW0do" +
           "XUX7rAhzY0HhohJdWUp8bT3anRZdWEp8aD18aT1dV0r2rQrKnh23iiT8vwnRmRnyuQ3ZqBeBazv3" +
           "uwvqpw/6sAi2iSXSmRneoBSkhi3wqgxmXEbcnxSNcja+lyKVfDOdey/rpw5eWEn+vQjzqwt8az3o" +
           "pg/+vgm7jCK2iST8sQfFkh5rX0RiW0iCbDr3rgl9aTxoYEblrhKthChvZEL+twdyZ0GGczn+tgfn" +
           "pRCQdDRSUU9+ajzYnBaOczX0vA2agTFUUk5iWkiNdTf6tgrztg2khy1YVUyjfyz2rQmdeS/9sAf3" +
           "sAquiCmDbDqvgyiogSq4iCRiWkfJlB29iyLCjSBpXUVXVE34rgn+uAd/bTyEbDmbeDBxYkGIdDno" +
           "qxG0hiVrYUTOoRzRlRlkWkdZVEz9uQfPlxrzpwuMcDaNcTbspA7goROqgirAjCDfoBNvYULTlhic" +
           "ey/pog98Zz2zhSZZVUxVUk6SczTvpQ30rAvdnBRtYEPYmRf9tgj9ugf+rwf/rQfADIlEAAAE5ElE" +
           "QVR4Xo3XY7fkShgF4GKIpo1j22ds29a1bdu2bdu2bf+PW0ljJp0J9rdeq/dTb1VqpVcDrpMU9ZAo" +
           "zwedAlVU/uYiMob5SjD2CkDYjow6Qk2juFZP9HkFav1+CSvV/gW9AHgDIEyQRQwg6BJMy22K1V6Q" +
           "9AhAOMdYHyVGaXV4uEBgbW8AhFm9T/o7aChUBjomWN0rAOE81kdkqDr93MJNAHgHIAwXixpqivGV" +
           "RDWj6BWAaj8pktkFWSmvPrPESt4BCFWkIbIFV45Oyfpahl2AYyW/+fqQMTlUeXIJn15xBvzLbjzt" +
           "uKOl2vUh2ajMG5HbewFwB4LLArOmX3XOkSf4YTCfQOE8VvTdK/LqQZDyCOiJrLrlbHZ9xuTy8njL" +
           "oPHgvAMsh2Rnx6i++xDumGyxNt0BP6Z6nUZfA/Z90GYLHGicvVxoAI4RHQG6sAQEZ6DLAcB43Afc" +
           "krYH9HvjHq3PDMC9hzgCvISUhhCpARBKB1WBwwWQOmIYpF2AYjhWCKMKAGGrvC8Atl191HmCGyDx" +
           "eAwRHZBaFV4xAacEAjOWf/VNSnACoIypP4yiPI7xPKYmILU8o1srvz/mJAeArcvPbIpSHvOUFi7a" +
           "FxCWGEAmHl9795LfBZstQGy8pvmQjBeWkoftC4DtuwLVZNYcf9mJ+wWkVqowA+NR9r4BZgCcnAnU" +
           "Eg/M2LPp1JRlC1DClAFyPgsEUA9cc74B1IxZkTO2mgDEzkCWeSq3N8gyHEnWA+DZeKAuB5sAqMZo" +
           "CGN1sBuHZDpTswCnr3IGFiqUKrFu0NIxNyTzIbp6fh0gnHnW4kDcHqAKjTb1l4DQwTOAxXQPyrn4" +
           "3J97bAGpMBURhHxCB7UDWC684f4eG2B2GKpNiOSANhSTQzaAsP3SndNtABSW9N+fRF8OoamjWNkP" +
           "kLz8iisztlsoMoAFfpwrEg2xC20BUp8sj0QCrgDUGFBcRMarL5T4Lh0QknddG2HPwA1ggjqvQdPf" +
           "LPMr/euu94Hh5JfbIgFzMosP2C8gxSAEvhwhZaD55vW09dbbbr8jUJfInUbfCvhjrf4pothVvonN" +
           "r9+D6fp778uY2/GenUtSgh2A4RSO5VB9mQceJA89/Ii5zdg1jz7GKnYAX+isAJHHn3jyqbUBy/RP" +
           "bx0GToBSBjKRZ3Y/93xzc127eeULKQAcAd4n6sDiF196uad+9VmvbHoVABcglG3kuIE33nxrunX6" +
           "t9/xCUk3gJdSHCe+O8Paf+99KMFEt88NCDaInDjwwYfm7cc/2rAuPdEOWdobFoAWJwB2sk1wn34W" +
           "2Qv0RD7/QuSWip0r5hmGWppMOgDdIgPEga931IBvv2tr4/SI6Y0o3KTqSHbCZwfALn0ErvGHH+PG" +
           "8jt+2q3PVBa6wGA36p+jQj/MJ7p708kWCxCEk+XlBjZv+IX9LP76m/GxRkwDvTmkkfHqgbQIFkAV" +
           "K4WBP/7c85fImdIoTgGgL4eKCIUTKszDodKkGWDCYFUQ121u4+rTJqaB4FuhIYKIYeTrgWC7uJRz" +
           "ChuC5W/N+AuCxqdaANjnDLCznAbAtORGjegEsQIJ0RkwzlLPSE6fwgpA0OgqdBmEMJIjFoAJ/4ic" +
           "W9oqQwDfCisQzKcbXQWRnWUlVgA26CO4byNtAzDhXwZ42YYdIE38xwCPQ1gBFtjFAI9D/A+btEBN" +
           "Oyr4fwAAAABJRU5ErkJggg=="
  },
  "Ecosia": {
    image: "data:image/png;base64," +
           "iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAN9klEQVR4XuVbCVQUV9Z+1SvVQAPN" +
           "urQgiAiouCcY3BOjOCExjkuCGDWa/DHbjOPEjEuMSeY3GZ2YxTgmkkTNoAbJuBJ1EgUNUXFwRdki" +
           "myzNYjcNNN1N71PfOXlnQIVuZmjhHMrTx+9offd+71a9V7fufcXYbDbSnw9ebzit17fJDpdXz+y3" +
           "AfjgSsHqRadzvr2t0Qb2uwCYrFb+7uLy51vNZo+P84p/1+8CcE2pHtZkNPkCZ9xWPNEd7tGKmsdH" +
           "pZ+8wNmI7nMBuHKncdifL+e/oWwzeHRFqNBoQyku07RGOHjX8JadubjtqZPZJ6+pmuJUbUafPheA" +
           "W82tEW/l3tgc/e3xgpx65ejOCAz3h2KrzTH/L57N3fZ1UfmroIPny4rv9LkADPF0/wWAuwOCnjyR" +
           "fUxtMLrfjzDIw62EYh8X+wM5UlE9g1szVlCOr4tYEeMlLe5zARjh7VnwiL9PJvAdLggphaXP348Q" +
           "y503wFVSCjzax+uyPbsfXS9eSa88jleGDf5UwOPZ+lwAGIYhBx5/JClW5pELwrk6Zfz9CHzuvLWj" +
           "Y94DThocurcrm2arlTlfr5xIucNkHpdXj4zeSnrwEPSksWBXSX3ub2eMT71VMV9vtkg6ndMxg/bo" +
           "zGZxcuTAA13ZazWZWZPVJgGWu7KlR2ZOnM0K+Kae1OxoKoyrQbgzGSFuvwd0WKw2xnv3QUViaFDG" +
           "lvEj/xQgYVX2OFzg+UIeY8U06dEAnFU0xE09mpnNLUA3lkcP2snNxZ1cMKyOcG1mE89Y9HOc8UbW" +
           "VFPppbFmxS+RVnVtkM2gcwOBEUtaeV6BCkFQ5C/CQWMviYZPzRJFTchhBEKH7Ku4R+97l/PXppdW" +
           "zVPo9AN/eGLKlOnygJ96NAAWm40ZnnbiSmFTy0gQpgX5HT82a9IciUBg6HQO15aEaI9ve6Ute98i" +
           "a4uyW2kvT+pT6zIx6e+us17bLgiMqOyMUKPV+U04fDqbyy8iwRvs4Zafv2DWCO7iWHo0AADXVero" +
           "R49lneYSkUAQXoqJ+HjHpLEr7wmWqsZPs2/du/qzqc8Tq0XY0SNj5vuGlvF9QioZibQFBJuuRWpR" +
           "VoZY7twOJzaboGMk+CZ2cvLX7kn/v4HvHdxwt69nT53f9W1J5RLgUDfJre9nTf7NUJnHLYcHhQB0" +
           "51ep0QYszczZ4f31PxTinWktJoulA0f745cLa5OkKsXTxEZ/tYtkdU2fr/hIf/n7aRZtk6Qz2/g/" +
           "nINzwWlvAzZh+26O766DFeGpRwvXXby+rtlglHR3PP9TPUBvNvNYgcAKbDO2CZv/9sJ2/U+pL1AC" +
           "z1te5jZv/buSKc/tY0RsN1Zv2NMLdWe+SWpN//MGq6o6nBLYSckpHi+nvMKIXExOfgo4Dqx6jUS9" +
           "KfGgMf/sDIKD4Zlcn1r1vvuCjZsYscTQboUW/Vx3J+5SQ+O4spbW8EaD0Qt8mVikDpe6lY31k+VO" +
           "CPDNYQV8I+VwC6VYk7ZxrfbIh2uIzSqEHdHQyf/0WntsDo911/V6AHDlG9+beYwOnnH3rvNalTZX" +
           "HPvoOUrQthUPP1Z+4bXP8jXz6vSMZ6nWG67va89NIGiaEy4/8PvYIZ+M8vEqoDYMeafj1R8u+M6m" +
           "UQXQIMjeOpmIO6FXA9D08aKd9LbnyYLKvd/JfFQQPKScVn4Kar/4q9SatphhCA8EuEv8eQmpbZPa" +
           "TQOSIkJ3b40ftdqfdWkE11xTHKZ6e9ppa6MijE4Hz9///cVeS4V1p75aiMHTK08HT/OG2AMnrrfp" +
           "M5Zi8G0WPils8SVv5iU4MngA/r6S28tgA7ZAgG34gC8Q4BsaeiUAeNS17PrDp3TO47angy9UXk2Y" +
           "8X1WZoPeIE+viiWrryeQiZkrSPLFZ8nphsEd7Ih5JjLNr4SM9arixNyb98DG4xlnMrkaYgINAnzB" +
           "J/jQAC0PfAo0bVvyuT5rz/8Bu85+413pc5vfBq7VFMRV1L2aueraDPaCKrRLG8M9asmWEceJr1hL" +
           "cCgNEpJ9J4ybHu7EU9hGAlw0JIDVEH+xhrACRj/Af/u0UI8hOeC2fLP6He3hLRuA2amLv/B8bfdL" +
           "D+xlCBkekhz6qMNqD6w1tsgOF29PP1U7ni3XenXKnx2UT3LVcrJk4GU6eBzER6wjT8vzO6Oxt+vX" +
           "pXu47B7hKXZrhE999v5kPCKhxW3u+k3IGB/IFEB6SzM8POfpo+7Fn/I3v3xpovxgzXBS18U8Twgs" +
           "IunjU8kk37Ju+XXjK+Q3FCmbgeETvoGhBZqcvgbQFxvk9sCMm6weSQ7wVaU6hlu0ltjjB7PNxFus" +
           "I2K+hfCY7gvmmw4tqWypiQGGb2gAhiZoc3oA8FZHX2zY+AX7aYaHEjf02eOvicoiYa5qUsFNkUPV" +
           "Q4nJ2j0JLnwzv1r9HXwR+IYGYGiCNqcHAK+0FIvHPXGMZngHy6rnO3L1R3opAEmoRE0KNX5k7vlk" +
           "ckwRjQKpw4eh7cf5bWaziGpor83pAcD7PH2rE0XF5wAiveUaHZ72Bv/FmIOE5Zt/pRPyJ+5uWMwt" +
           "hDeaA8hfiqY4rMFD0OhZ21oUBwwN0EK1OT0AKGYA4JWWJ/HQAV9XNoyzx3sz6gwJZDUdnTOEzJHn" +
           "k7XRWWRN9Jlu6TAYC+CTQAO0UG1ODwAqOQB4n6eEJ/x/CH8r5hRhuyjXydnm7r9n2FCKY+4fAJMi" +
           "HIBqodqcHgBaxkIx4z9Km2Wzgwu4K5nZKa9a79G9NNssJCuvJZKFXPZosd0bBCFplAFQLVRbr5TF" +
           "eYwNgCQEFJN58rz7prSfl8YRJEdGB1b9ghY/knTxGZKtDCMlrT7kUqOc4PimYhR5++ZjpJULjpBn" +
           "YXqlL4ACJi1jUQKfJ1UTurBxc3n/+H0kRKK+a1D+3Iq/iEzKXIGBdOljT8UYUqXzIvQ4WTeEVGg9" +
           "yae3JpCM2hiyq3wcEfLdmkCgWqg2pwcA1VsA1PAoQSgILu3Q/nJtJDKR7r58k41Ptt2KJyoDe1/7" +
           "p+ojyNmG8A6cDEUUefXKbGL7tYZQ1iojIkFQGTDVQrU5PQAoXQOggGnVNUuAJeKoS+0JuY1ycq0p" +
           "uPOFlHNbrpXdY/tyYzBZkzcTQbr7/A71g0FuKuIqjsoFhgZoodqcHgDU7QFQvTUWnYsD9JIMv8Aw" +
           "Li3AzSYxSSl/yK4dmUh/j+2M2igM1i63XDeg2Y0deR4YGqCFanN6ANC0oNiQm5EIwOeJjB6S+CPN" +
           "RheyMOdZckUtt2snRNJ0V+eJIXlNgYTlG+1zPePS+DyxgWpor83pAUDHBk0LYP25tGdRvQX2kSam" +
           "vFf4qMXBag/RmoUdBr8xfzoZ7K4kC0Ou2qNaUC+klWNooI0UaHN6ANCuQscG2Nba6I/SNbBU8lB2" +
           "oHTabkft5KoHUEj2Vo4iJ+qiiM4sIodqhnXJQ52QFkvhGxqAoQnaHkgegHYVOjbAqNujdA2MAqYf" +
           "K662bwF5wcOkWiclx2uHkB0l4wmOc6qBRGV07ZQD2/BBy+XwTbtH0NQnSmIoYKKGZ7RaWdKDh4jH" +
           "03NNz2mTg/wcKYk5PxNEr45hpY3AaFqgbg8MgWnTH/ktBPfk4GGTDh6+4BMYGqDlgVeF0aiULt36" +
           "OjA6NmhaoG4Pwuww+QlcLfvTwT6ADdiCTdobgC/aJYIGaOmVvoDksWV70ZwARscGTQsIpHdC3vyE" +
           "Edyi9RVWbtL9wwIubMBW+8YIfNHGCDT06h4hNCrRpgJGx0a5Nv48nQ7o6Ox9bPzyK3NnxD4XOXAn" +
           "2l727OEcnAsOuLBBb3vYhg/aGoPvzuw4rT0ObDBb+Gdr6uNSi8vngWPRtUiU6yefpK1sxRyesXnP" +
           "G+9Y27Ti9jydySz6oap20qbL+auWZ13cPudk9j78gPFv+D+c054DG7AFm9Q+fMEnWvMpBSWLDpVV" +
           "zVK3GVz/m7F0m/BVYWmS/+5DlWTHflts2vF/UY7VoBeqP0re2b6nX7dcXtr6z88XWw06YXf9gAMu" +
           "bLS3CR/wRTlBew6XQYv7l+mqXYWlzzg1AB9eK1zBObPCIf7+9tbtp8DpzQ0Se4rK5rfXtOPmrcXO" +
           "2CCBTq/XwNSjVW0Wq6uAYYybHo794xsjo7eB0JtbZAC23fhl+R/OX/3MbLOJ3YQCdVXykyGeYlFr" +
           "jyZCOfXKUe9fKVwzVCbNfy4yLDXKS1pKCb25SYqCAnVzxJeFZcuK1C0xG8cN2/CQn/d1J2WCji+u" +
           "DMM4cZucfdArAeCuQPiyM/9KmRkSePKtMUO39JTd9NLKJzdeurlxZeyQvy6LCt+H4Pa1DybwLUDw" +
           "5KOnf+L2906zWK1CB3afMh9cLXjdaLHy7eYbImFzgbpl1Atnc/dyv0/65BcjS7MuftmgNwQDR3ra" +
           "39K+Na/4tTUX8z7Zcq1wpT3bU4L8fx7gJikD/qqo7PWM2zXT+1QALtQpR59RNMz8NZtrTggJ/KEr" +
           "gsFi4W++WrgG+G/5JS/bm4oiPs+yfcKYlzjBZnC4zZHP9KUAoD84keINY4eu9xKLNF0RztcpH1YZ" +
           "jAHACp0+rFqrt7vNJXFg8I9pj8c/7eMiVlS16uR9KgAakxkruu314ZEfrBoR9Zk9wo3G5tiOW+NN" +
           "no74mRs+ION2cmL41kdGrepT3wtMDPTNzkiYNP03oUGnHdzhLWvPZwUCjaO+sEF7jK/sZp8KgKPb" +
           "0ynwZcXKdiu8klvg6vrNl6MAU4P8szBlgJ8Ok3/HZxhbvwoAtrTPHBBwhOXzNetGx7zfr74dpmDH" +
           "pHGv7Hts/IIID/fK3tLQ7z+f/zdtBQxrg2hCXQAAAABJRU5ErkJggg=="
  },
  "Ekoru": {
    image: "data:image/png;base64," +
           "iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAMAAACdt4HsAAACplBMVEVCrUIApdYYrbUhrbVzvUJ1" +
           "wUaBxj8Apc4AnNpHskcApd7O7/f///8praRovUc3s4dCtYRKuXuMyDxuwFWHyU1WvWtnv2lUvXUI" +
           "pcYAnM4InM4Ipc4Qpb0QrcYQrb0IpdZKtUoYrb1dwNuUzjmczjmUzkKl3ufG7+9St0TO9/fn9/f3" +
           "//8trZRjwWMYpa0InMYhraQQpcZzvTl7vTlGuIdKtVJSuVIMnNpLuGmMzkJauVZhwFghrb0ttb0Y" +
           "n9Mcps4mq881scpBtsI8sNZHt9BOvc4xsKJoxdNrxt5zxt6E0uK11jE8sp95w1Jctz+czkKUzkqM" +
           "zoyl1qXG58aM1udjvT2p4uu95+9avUrG7/fO7+9rxmd/x2Te7/f39/d4xXCDyYeMztYApcbv9+/W" +
           "79YQpa9GtT0rq9ilzkqUzlKUzmsIrcat2JGczpyt2Jyt2qW93q233re93r3O58pSvWOIyliU1t6U" +
           "1uec1udSrUpMut613ue15+dcv8zG5+fG5+8ArecIpd4QpdoIstt3zNfW587n7+fe79Z3zORjtUoQ" +
           "nM4Qpc7v9/f3//elzjmUxkKc2toYra1SvUoYpd4Ard6t5++15+8YpcbW7+/e78a33qet1jnO571S" +
           "tTne797v9+ec0I6MzpQIlM4Ypb2t1lKg3uJrvTkhta2UzlqUznuczmMprb295+ex1mcIrc4InL2U" +
           "zpQYnN7O5++l1oiE0taUzpwAlNYQrc6czkrW9/etzjGt1jGt27re9/e93ojn9+cArdYAnOcKqrpf" +
           "v46957XL57e13sa93sal1mul1jkApefW786t1krW796UzozW7/e11kqcznu11jlrxka11lLn79a9" +
           "584hnL3G584AlN6t1kLG797v9/8htb2lzmeM1tb///eg1q3q6+s+AAAJxklEQVR4XoWXY5NsSxqF" +
           "K7dVtG00bds2jm3bNi5t2zbGtuefzJt7V+OeqohZ1dHR/WE9+SpRqmi2RDGeQ+JkNIfuzwJM5rZj" +
           "gpiLcQ9AXLKL45GRzsDhxsbG5sOBzoNHZWwOhCrX6mI00tlSf8WLOI5D8OG83vrmwIGoiBFZgKzc" +
           "pyKBDVewFSGWZZEiIDkaOsZEOYjcgEnFHh1pOY29SFCcCoITBGRH3J1ABCNyApTlowdanEjgBMQi" +
           "zs7abC6QzWZjZRJEJZwOjOOGZAOUGo0dvgzL2WFR27q8VEpn3Quq0OtT6nX5GCAAecNBcSVBtdI/" +
           "Uq9E7XSpdebqiYlYjAepeD42sVendkFFcGKnO6IrCqFa9k9dLBfwGm/k6dLVfdjrKy0DlZYe4lXr" +
           "fVXmtnVKPbiW+5cJquX1O8oF3DeXtlrTx6t8VQvbdg+vBZ0b3jU4X+Xj+TJ9ygW1AW1YJqiW/J0O" +
           "XCR7gZme4PnShd1rpJVaM/yUBRC6PMQh+GmJxsUMINM/8QBeX3C2pak+3rew9j9SluaG53lfhdqG" +
           "7E6OC0xlCKpMAPfV49a5eoxUTGXZc03KqWvDab5M68IxnOqCqZcBygBED0PvkT0Fft+bXyxbrs4e" +
           "P378wURyEXH+TV9VyToBCPVjSjNVsl/sOi0ILCqopmJlQ3OL5lffba19pQb0z6azRxKZPHZXlenX" +
           "4UI0K2VQyQmMb8Aj8oyZjvGL/tl3m0iCIEmSAPn9/qazJ5JKGmW39S6EkPeinIRK7sBFL/jzS4yX" +
           "fE8p/qv7a8FHYj9J1PgxwV/TPiWj/3KoqoQAQsN9cQxYCgAVGGnVvNK8qWNuD4mlxnrhBUABw1O7" +
           "/yom7C6d0NmgZwERCCo5gFMnEXJZoQBrZf/RJsJPki+0legtM6B5i7VETfoJwuM/NosJQ2XVKQdC" +
           "dWMZQFQOIGXU8Ntk/6u1hJ8ge8wzA/3910OgYKhyxtpDEh6Pv/VBXIfB2N48xJ7CIWDAAe8ZhBxW" +
           "+lLZeew/3gR29TcmbO0PZdT/4T4rROF3N2LC4+kJnROdrB+XAWJAuItQXjXFL8j1a4Xwe6YHwGsw" +
           "MHRxMcMY+kPB/tANS5vf4/G04oZ+OmHO4wRvVzwOgGjDSQF5tcyobw8GrAK/dh8OnKF7eze/9NJM" +
           "L00xBpyJUe0miMJ2vDUsE1qnHbWIGBA5DQCb2dCXxi18sJYgtTPXP+5nqN6tF9bgjNec295LMTeA" +
           "kC7wEO7CI0DYdcnsgjKOY0C7AD0gjTdigxLoLFHTNh0MhRjqnSekJT2xvbfIEA5XWkmP3/1KAodQ" +
           "XYDQqREAiC1QAlZNF/NDYEg0+knrQChEax5OSit1YYYyGMImnZvwuFbhVlZpEfoqAIBo3ckziNXS" +
           "Gt85MBzxE21QAAP1zr078onfUpX9wTTpcRc+ACGsrdbbWKEZunD/5ZNfIqeOnjh0AWdAkiUDoTDV" +
           "C/Hfo/MzVGXQpAOA7SbkkDa72K/qTqjiEQeUwKmnYqWPQw+bCPU0BKDZLmXrW01xMGy55XazLTDS" +
           "C1V5SHCMq+IjXrkJRT48RrO1ZA9kwPQCDAQdOH9+bulY20wZwjMp9we2B2Cadkyk4M47qop3obsA" +
           "2EsdkgGvECXhUKhoZk62X9j6k5c3P7kbyLL20IzBpHW73baDkjQ8oeW48ucw4AwCQFHMB6u+Td6y" +
           "hkPXi7bKhu+efeSRjc9ufHHhT5kQoAo3rB4gBJLSeYvOznn34xQwwAyAtQoAZpjaiQ0P/eYXr33+" +
           "2saNv/tw/pcK4clRU6UFAB4owpppHYu8EMH+8kXALgD4MSBIP4oNn//hoWvS3M9f6+7+MHPObB9l" +
           "DBhgg1mam9evFjBgrPxnGED14UGarSH0YZgCGfDQH5UR2vjJT+d/kAE7MgD2gVnp2rzeJnjH8CAJ" +
           "AgbE+HlcRA+MQZD6buV98K/uT/Y9Jc/lTg1jmJYBcLr9qsImOKGNkxswwEpN8JaklGzy40EsfvhH" +
           "AMjhm7kVgELWOS5JgxU2dBkA8VbhLuvQ9VLrcR9XeQgLbP3Ncytm+MXuj//Wk5BT6GMGrMTXhTbX" +
           "CRkgNEwCQD6SUxpNDJ8HJ2r8WlOwEqq4pJ3B7u5NPfJxuhVqUOJxnXHiSVqocAot4uJ5UFD9+1js" +
           "PUlKtnsKpoNBw74LS1vgxf7r3ZZjSXkORhmmZ0vhGbZ+FnfBIcBuzJypLjOlWW+BHThVS2hNoWDl" +
           "vm+VLC68HLp+fVPJTcx63EiZjAWsm2UbEnAi6GCOMEAMINgVOtr0mLyhb9aQ1k0QA7P54Uf37Hxn" +
           "IAx+a1NCko+hYpOZeL3wdbYVJjGtFa4cxQCYRSSwKSMcim9CCFfP+tUWaGU4bDDduAFnU2jA2nZE" +
           "bsdCH2PSuWwfOFe3J6Vze9XchkkAyDkglGehNHwV3jaJdpkQDikKz1jbVslTsNZIGYwFhZ4tbH5E" +
           "kr7f+2euIy4DxA4OZlFP0zEcAo6hhiyZGcDmgU1wo9Sukltw7UkNw1hdq1ezuIb/eK+i8PQYBoAi" +
           "dzh8MdCXeOVkTx5p8qv1lulpuNPayKbnkpISAG0wpraAH5dgdkHLNYsZgBjgOHyqUbHF2zXxbm0N" +
           "3I5wM9eums3s5QUNY9K7PBgQkZJ/t+aV74+LMAdKCAKHnkkXaXjfECQhI179d3vrsbORxOLzZhuM" +
           "cXUBuwX89Qnps+/1TvmJAQAlBMSilIa+zVftzv082nGJMdBaG8t+ybIXpavif1N1kbgCwBqrRxyb" +
           "r9XQPlXZnlz+oZiRYfRfy8/3hkTyo+PfPNOFn7yLALHTLnCCUwc7gq8azvKvGYxRxcXmPCQDDkqf" +
           "xafaR0SwKW8krGizwLHoDT1NXeJLt93zyNxliT0P/lssbiFqTCZgbRH7lWeeEsJYPYcEzqU30hBE" +
           "escXS+5zQ5ZYn7GYtuax7GpYv/7tRFxRBjCZIXQ5IQmhUGekqNHH+KrBoR9Anw5afHxMw9BGPfhx" +
           "/JcPXv1o2a+8VDOEDq8gQAwps+b55zW3fbwPxPPrY30UXZzWusBtRw5HV2LZv/KxDYoGyjmEkBNe" +
           "+xoNVUSNjvaNauCvYli+wMauRo6n3y/v/LW46J/MAFYSHPi1JTjztPo0TVG0IrO2wAnR2x3vOy53" +
           "isv+rC8cOIsrwldQCc7uIlPaCrPZatZr1eucCNntDke+o2Eky48BKwlddWDn7Ahxdnt+vi0/34EU" +
           "99OgxgjY7/ED4MeESEs553DYQQ744F8OB2De/+vTdR3j8Sx/1tc+KERXcx3orbfuLAv+bzh2n5jL" +
           "D4B7CdCesciBrs6OTvxzsbOza+TA2Pjksj33F08ljf+nbH/0f+C6zXUwzYSLAAAAAElFTkSuQmCC"
  },
  "generic": { // generic search image to be used if no engine logo is present
    image: "data:image/png;base64," +
           "iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAATM0lEQVR4XuWbeXRUVbbGv3PvrUqq" +
           "UhkqA2FIGBQZA2HQfoKi4IA0Dg2IQ4s2iIqNgsrQyCCjIA0oo0AghKYRCCKTMgYEZEqQKQ1CGAIk" +
           "IYGEIfNYVffe/fZddXHV48Far/utssX+1vp5bpn8Ud93zt5nV0Xxa5QQQmIpsiwrEotf3/5zyCzz" +
           "5zIgBH4DEoYZ5k5mJCbQxIo7SGYZwd2bzoWQfXc50Ga/r2PHTn8aOvQvCxOXLN3//fe7Mw8eTCtI" +
           "S/vx2sGDqblbt6UcnzP3y3Vvv/PuqJZxrR4FEHBbEOKesS6x4JWlZVz8S3+dNiPl5E+n1KtXrtKJ" +
           "9H/QhnXr6IsZn1dPHDe+eOyYMcWTJkwo/3LuXNq+dRudO3OW8vMLKDX10KVBgz+cGhlVqzFMGaXx" +
           "a9/1n896o/se6LkwIfEf16/foGNHjtKoj0fmtmvbbmeQPSgJwDRmLDPcZCTzKTM/3Bm+ocvjnU/N" +
           "njlTvXThImVnX64ZOWrMHD5B0bfK4ld75M2nyD/17b8qj3f7+LFj9MpLLx8JsAYsAPAR05t5lGkG" +
           "iHoQgVGAEg4ggqnLNGceZ15nJtaKitoyfOjQkit5eXQ8/cSVhzt07A2WecLEr858kCOk7cxZczMr" +
           "Kypp3CdjM9n4PABvMp3C6zSJfey5/gFDJiy0JK7eHfrtzvQGO1IzW2354dSD67bufXj+kuT4vgOG" +
           "xDSLa28DhAVADPMkM6xBbP1dq1eupIrySnqz/ztTboUgWL8a86Fh4R1XJX9TfK2ggJ7o8sQOAB8y" +
           "nds90qP2iC82i6OZ1VY3UQMieoj5PdOHeZ8Zw8xgFjPL3Sol7Np3bNDr/Qc3sdpCBYB6TFdm1rCP" +
           "Pip0uVw0ctQnST7lIP6tNQ+W3e6IX/b3lcVXcnMprmXcagCv1Ylt1mzE51uUzacIu7NInL5BASU1" +
           "al1N9bRTVbWzR9W6q6r2KvMuvx7h8ahTVNWTQEQbmcPMsfRTF2c83+v1GAAWIdDaKKM3Xnstx1Xj" +
           "osEfDJn/b22Mwivuy4pzzNiJF4puFlKb+DbJAHq0/l33ektSCrHzAontZ1Vpb44qDhToOFJMuOwi" +
           "m4cojoieYXowfZkPmHHMF7pOSRzKWg5jHxFdYc4tSFzRI8AWAgE0BtD/zwMG5FZVVlHXZ34/2CeE" +
           "f0/dP9PtueSS4hLq8YceWw3zjz87MHrtUcKWUyTtOK+KtAISx0v4BFSTOK8yOodAJKqJGhPRs8zL" +
           "zNvMMOZTZh6zgtmqadoBDiKbiNSUPUeG20OjwWrE/Hn+vHllWVk5NVFR0a2FEGDkX9x8reg6z6Wm" +
           "HabFCYvOA+jX8sHn6yenkvjupGr5/oKmHLpGyokyUs64Sbmok5JDpPCWWq7ymk8EDuF+IurFvOHT" +
           "D6YzicxaZjdz3O325BDrh0MZQ2o3aAdWk7DQsGlnTp+mWbPnHgQgGYIpAf9LAEJ+7/0P0j8eMax5" +
           "mzatZ8iB0V9PSTqaWbuuXbLZgZBQiYw1MBCwKoAFgMJIjDnogwC3A2hqBeIB2JkQJpQJM3Ey4Uwo" +
           "l0WkoshRe44X9nm11wvbr+ekPtD7xRdnLlqc2LFDx0dePX/uzNdGKei6rkl+3n0FAEVE1nq+X7++" +
           "cYmLFx4tLi5Je2fU6oLouo5AxUIBQQ4pICAQgQZWhQECLYxirjIQoDD8HOICcjQgF155TFwmNUyV" +
           "sXLDLyVdQ8sWEfcPHLusxhHerPzbb9cvyzx3Ths0aNBoM18d5oMfRTpYj3Z6bGB0VATmz//yhyd7" +
           "jslp16GNpGuaPcgpU0AAYGBVGACKicyYE4wJBAEBbuBiIFBbADafENy3giCgQghEV6jywvRcbe7D" +
           "HR8I6dl/ivrVF/1OJSUtTh09dkKnTz4Z83hZackuozwVf3Z+ItIVi7Ve9+7dO6em7s/T5IhTvfuN" +
           "rNFUPSg4TILVCljZvMVqmoa5mggf4A1EIsCjcggWoJa5i5pPEFUCiHQRtl+qwXSHXQqPi6BpFX/o" +
           "vuhYWp+Cnbt37x43TnTq0vmJN/hE7OIygD9LQGbgDI/sHN8qzsKf4n7q1mPANWeUwyrLcFgDhJ2N" +
           "2xULIxjALvsgGMlEMCaBEhCqAdU6cN3MSTNxMVYPcCRfYD7JEM0ixYehgXgprnHg4526/lGDJexi" +
           "Rsapqq5duz4DwMFoCvys2JiYDg6HHWXlNZc6Pt3TraoUbA+CsFhAigIosnncb9t13wFemPi81FUO" +
           "wArUBxBgBmBVgbPFwHc64Glow2uhAr0JqKzrRJdmLeI3n3vgd6Vnz57PbNOufTwgWnATPOzPAHQG" +
           "9erFtFA9LkREx16vHdvY4tJEgMUiSJYBA0li/ne9/yzpLtcKAaoOlErem8CiAZcqgEM6QJHA0yEC" +
           "LxJQKiBkhxX1o6ND6jZq+pDrZlFWbmRkZHxIaGhz7gN+C0AQkW6stWvXqauqmrt+oybV1kDF5nKR" +
           "RZIFSZJpXvgE4GNYmNxFQgCaDlQa+alATg1wgQAlFOhk4wAAVAtAIkK1JMgRHiJiasc0zRGleaVW" +
           "qwWhoaENOQD4uwSsFqslRJalmrr1YomAYAmkSEIQhNeFr8Q/OZzogOQBLruBEgDBxpxgAeLNW0Hx" +
           "6Q0OCYgKi6h9jdRQN0iHwxEcIYTwewCSpmmSlVt9rVo2pYjgAIRCAOH/L5DXoSazOSvQUALqAvCY" +
           "5s0fQzXQCXZHUHCQ7HTKRAQhpEBe/R6Ap6a6pkqxWMKiIu2OkkJ4NIKi6yAiQGd8RT6I/1sAJAOK" +
           "FYi51dUZKyOZAegmbiJYA23WYIceEsKbgqqqqprw8HC/BUCMYKmFhTcLQWjkDLE5rWVQtXJvALoG" +
           "EKMTIxgf8/BZ71YS5FMGBAQIQIbPFG1i5ihcbhWSPUAKjQgMC6uoqERlRXlpeLgT/hyEJCLS8vPz" +
           "s8orKh+MbVAvMtiG6jwNVtUDUjVAu4UC6PAi+ZgTvs93OSk6QAQownsdWm4fJIWA5NbgKquEHGHX" +
           "nBG2kNp5eXkoLLpZcOPGNb+WgGBw48b1o1nZl3u3b9+6XmQolYKE1e0CcQjwMKpqBMCY71r3uQ3M" +
           "Z9P0XcuFNMAmAYGmeYuJQgRJCMg3y1DGgQeEBakOZ3Bw3e0pp926puVZLFa/BkAMiouL9p84eVL0" +
           "6vFswzrhuBoUCEt1NcjhNgLwYrEAsszcZQagO5wA+JwAj7cEAs0MFWEGoPNq4fViPtUE20VQWJA7" +
           "UlaUkAOpqWcA5AB+bIJEpAEQrpqq48ePp2fnXcmvH1s/tlZMFHnO5QqppgawBpjvkJElRtyWoE8h" +
           "053rHxpAvCrkbX4ymSEYqxCwVKjApXygZSOEhdmoQXb2VRxKTT0qhLgGluLvL0Pcbrfr3Nkzq/bt" +
           "Tx39ep9XYprEUGFWvlDKy0E/B6B4AxDW/7m78m27L24zT4zKsCQjBEYiL7KmQgqQYPnpIqqtFmGP" +
           "iagJDtSssSkpO12FN6/vlySpTFVVv1+DOoObNwqWbN2eMrT777vG1A4PoyaxhJ8uCtgCAUUGfP+8" +
           "SRZGAIpPUxR3aYK6GQCZbUMnCF1j8x4IaJAKKyEys0l7pLUIdciukOy8awHJq5P3CiGOMzW6rvs3" +
           "ACLSjVNQVlaadezI4SXr1n876J23+0W1aqi7C4qEKCr27r6QfGpaZ6yAJt3hPjPRb5tyNB0gDULz" +
           "eFHdEMbrU2ehNawjlPrOakl3i7AVK1a5zp/L2CDLch6E0AAIBX4WsQCIrKzMyStXJb/aocN/Rca1" +
           "bO55uIUudh+XUFjodUfE6LeuRp/SMEdm6fbdJ69xVfU2Uo1h4wZCN+bjPCDQCnqoiQYLgF2pP8pL" +
           "lyZtEkAa73wREYFFAv4XOHGFj5saHBL2x2e6Pfu3hIXzLOHOMCm7UMf+ExLcGsBDGWxBjA2wBjJW" +
           "wKIAEiObJSJM80RmUCqgegCXC/Awqse7Xr8O2KxAl7Y6nFYPnb+QLd56e8DFtNR9owHsYwpuu2n8" +
           "2wg1TVOJCNWV5Zs8bteNseMmivLyCr1hhITO/CaDbd43XVIElJUB5aUm5UAlU3H7WualnCkz19IS" +
           "Y+YA8q4AzmDgifYaIm26fiX/hhg3flIpm5/PG3GSx/Ib8JHwo3Fx62Nx27Zt7+MvQ21PPdU1of87" +
           "Ax798VCanpmZKU2eNIGczjBRXK0h/YKMS1e9W+JwmCchwFsGkuRFmKWim6WiqoDbBZ7rwaMtoEhA" +
           "84ZAfEMNNousX8rKlsaOm1C5ZvWqL3gPNgshTgGo5hLwbwASi+uMANCUz6a+N3rUyGn8d3zrhawc" +
           "a+P7GlGd2rXE9M/n0EkekCaMG4PGje/TCZAuXddx9rLAtSIBlbx9IMBqzgnmlAQdUDVv3bvd3hKw" +
           "KgDPF2hen1DPKREA/fCRY/Knkz8rTdm2ebbH405h82eJqBj+lqIoMljBwcHyipUr5xHr7Lnz9Pms" +
           "ObRuw0atsqpazzibWfPkU09P556w6LkXXtTXrN1A/KlRIyLd+EfOTY0OnNVoQ5pOX+0mStpBlLjd" +
           "JIVoKb9esYdo02GdDmdqlF+qEUtntOKiElq0eCm1afvQOUmShwLowOYj8EtIYYHVomXL6MOHj+wg" +
           "1vYdO9V33xus/3nQhzR12gztxE8Zeq/evZMAPCwEou1BjndbtIy/MPD9D2nn93uosrLSMKIxuvFQ" +
           "Uk2UW6TRhWsanS/Q6CKvV0t0KnPRz6YNiouLacPGTfTSK69XRURGrwPwRwG0ZfOh8LfMY6+A1a1b" +
           "t/aXc/MyibVwUaLntTfepH5vDaCPR4+jlJ27tGvXb1Dbtu0+5t8P5aYkzHbRNswZPqdVfPusvv3e" +
           "ocSkv1N6+gkqKSnxMXk7Ot28cZPSDh2m2XMXUI+eL1fExDTcJcnyMABd2HgTALZfwrhgZLD6vdn/" +
           "Ra79cmM3Jk7+zNN/wEAa/OFQGjBwEK1M/lotLC6hYcOGbQTwNAdgNZslTDn58TGbLWh83Xr1d7Z/" +
           "sMOVHr1e8Qz+aDhNmTqD5s5LoAULE2kOm5346VR6d+Bg6tb9hZJmzVudCA51rhBCGgzgSaaleeSl" +
           "X8S8sTCYNn36cGKdO59JI0Z9og39y0gaO34SvcUhzJ47XyvgnZ82fdpeAC/wzt9/2xsUhgBYmDCm" +
           "GdNNlpWBHMhn9qDgRWHOyOTwiFprHcGhywNtQfMUxTIWwFtMN+ZB5n42Hu5/4yZsQgIg+OtlrP76" +
           "69nEOvTjYW34iNH6pMlT6a8zZtL7HwyhcRMna9k5lyk5efVJAC+z+Wbs1YK7yOfP1zYzjDrMfUxT" +
           "piXTgmli/rsYY7eZQPyLEv+qeU3TdO70lvUbNq546sknXk7hZvfDvgNyndrRgusQeTyRGL/zp9f7" +
           "SDdvXs994fnnx3ODOwLA6A+uf2KewB2+NdcNiHUHP+TvnZfBahkXF7J//4EdxFq3fqN7/KQptHTZ" +
           "V8xymjx1Gg0Z/rG+d/9B4wosadig4RAA8VwyNv9ukP+vOQms1q3jI3IuXz5ArNVff+OZ9vks+mbd" +
           "Blr9zTqaPW8+DRsxSt+0ZZt+Nb/A1a5d+08BPMS5hcD/8r/5Vq1aR7H548akt3xlsmfeggTalrKD" +
           "2DAtWbqMRn0yTk9es1Yr4o7fs1fP+QAe4eCicC/LbHiIi2sVkZWVnW6YT+adT+Ljvu/AQdrzwz7j" +
           "NU3gMli2fIVWXFJKAwa8uwpAFzZfB4C4583zdBfCV9xBYq1dv9GzavUaOpb+Dzp89Bh9+90WnvI+" +
           "p8Sly7QiHl4mTZq0GcAzbD4WgHTPm2/cuHHw6YwzB4i18bvNnvUbv+PmlkkZZ87Rju9308zZX9Ki" +
           "xCT1Gk9ms2bP3g3geTbfULBwr0piARB2u922Zeu2ncTavHW7Z8u2FMrNu0I5uXm0/2AazU9YTIuX" +
           "LFXzC65RQkJCKoCeHNwD9+x/u+874dnsdvmbteu2EGv3nr3unbv2UGFRMd1kjh5LN5oez+1/U41A" +
           "Fi1anAbgJc6tqTnI3Jsyj61kDwriCW/NGmLtP3DQs2fvfqqqrqEal5t+Op1By1esoqS//V3Nysml" +
           "hQmLbpk3pjzlnjbPJuTg4BAsX7EyyRxvPQf4qHs8HjJ0PvMCreKOz92ezV+mBQsWHjLNN7+HzZuY" +
           "R3f2nLkziXX0eLrnYNqPpKoaGcrKzjEGHvpqVbJ24eIlmjlr1v57fud9m57FYsHQYcNH60SUkXHW" +
           "k+pjnj/jGzeAsftq5oVLNG3a9B8A9DDNW+5582A1bda8bVV1NfGXiSofe93jUYlldH3jBqA1a9dr" +
           "59n8xImTtgP4A3f7pve6eQk+qqioKK+oqCwrLS0T7dq2gaLIYPM4dToDLrdbb9UqTkpakrh5/Phx" +
           "X7L5DF3XLxKRB78Fmd/q4NnnnutLXqkXL2Xp/DWWvuG7TfqpjDP03vvvrwXQnX/3fvOq+22JM5DA" +
           "6tu376e5eVdpN8/4mzZvNa496tOnz1cAusqK0giAhN+ohPlFJdo/+NAovupqfjxy1NWzZ68EAE8q" +
           "itLA94PNbz4Ep9P5Ymxs7AgAXTiYGAAy/kMkzHHYUD1+jgIg8J8m8//Sxn+6BH7D+m9uoBi14hOM" +
           "NwAAAABJRU5ErkJggg=="
  }
};
