/* Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/ */

"use strict";

/*
 * THIS FILE IS AUTOGENERATED. DO NOT MODIFY BY HAND. RUN TESTS IN FIXTURES/ TO UPDATE.
 */

const { ConsoleMessage, NetworkEventMessage } = require("devtools/client/webconsole/new-console-output/types");

let stubPreparedMessages = new Map();
let stubPackets = new Map();


stubPreparedMessages.set("console.log('foobar', 'test')", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "log",
	"level": "log",
	"messageText": null,
	"parameters": [
		"foobar",
		"test"
	],
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[\"foobar\",\"test\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(%27foobar%27%2C%20%27test%27)\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(%27foobar%27%2C%20%27test%27)",
		"line": 1,
		"column": 27
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.log(undefined)", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "log",
	"level": "log",
	"messageText": null,
	"parameters": [
		{
			"type": "undefined"
		}
	],
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"undefined\"}],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(undefined)\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(undefined)",
		"line": 1,
		"column": 27
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.warn('danger, will robinson!')", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "warn",
	"level": "warn",
	"messageText": null,
	"parameters": [
		"danger, will robinson!"
	],
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"warn\",\"level\":\"warn\",\"messageText\":null,\"parameters\":[\"danger, will robinson!\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.warn(%27danger%2C%20will%20robinson!%27)\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.warn(%27danger%2C%20will%20robinson!%27)",
		"line": 1,
		"column": 27
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.log(NaN)", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "log",
	"level": "log",
	"messageText": null,
	"parameters": [
		{
			"type": "NaN"
		}
	],
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"NaN\"}],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(NaN)\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(NaN)",
		"line": 1,
		"column": 27
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.log(null)", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "log",
	"level": "log",
	"messageText": null,
	"parameters": [
		{
			"type": "null"
		}
	],
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"null\"}],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(null)\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(null)",
		"line": 1,
		"column": 27
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.log('鼬')", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "log",
	"level": "log",
	"messageText": null,
	"parameters": [
		"鼬"
	],
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[\"鼬\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(%27%E9%BC%AC%27)\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(%27%E9%BC%AC%27)",
		"line": 1,
		"column": 27
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.clear()", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "clear",
	"level": "log",
	"messageText": null,
	"parameters": [
		"Console was cleared."
	],
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"clear\",\"level\":\"log\",\"messageText\":null,\"parameters\":[\"Console was cleared.\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.clear()\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.clear()",
		"line": 1,
		"column": 27
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.count('bar')", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "log",
	"level": "debug",
	"messageText": "bar: 1",
	"parameters": null,
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"log\",\"level\":\"debug\",\"messageText\":\"bar: 1\",\"parameters\":null,\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.count(%27bar%27)\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.count(%27bar%27)",
		"line": 1,
		"column": 27
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.assert(false, {message: 'foobar'})", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "assert",
	"level": "error",
	"messageText": null,
	"parameters": [
		{
			"type": "object",
			"actor": "server1.conn8.child1/obj31",
			"class": "Object",
			"extensible": true,
			"frozen": false,
			"sealed": false,
			"ownPropertyLength": 1,
			"preview": {
				"kind": "Object",
				"ownProperties": {
					"message": {
						"configurable": true,
						"enumerable": true,
						"writable": true,
						"value": "foobar"
					}
				},
				"ownPropertiesLength": 1,
				"safeGetterValues": {}
			}
		}
	],
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"assert\",\"level\":\"error\",\"messageText\":null,\"parameters\":[{\"type\":\"object\",\"actor\":\"server1.conn8.child1/obj31\",\"class\":\"Object\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":1,\"preview\":{\"kind\":\"Object\",\"ownProperties\":{\"message\":{\"configurable\":true,\"enumerable\":true,\"writable\":true,\"value\":\"foobar\"}},\"ownPropertiesLength\":1,\"safeGetterValues\":{}}}],\"repeatId\":null,\"stacktrace\":[{\"columnNumber\":27,\"filename\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.assert(false%2C%20%7Bmessage%3A%20%27foobar%27%7D)\",\"functionName\":\"triggerPacket\",\"language\":2,\"lineNumber\":1}],\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.assert(false%2C%20%7Bmessage%3A%20%27foobar%27%7D)\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": [
		{
			"columnNumber": 27,
			"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.assert(false%2C%20%7Bmessage%3A%20%27foobar%27%7D)",
			"functionName": "triggerPacket",
			"language": 2,
			"lineNumber": 1
		}
	],
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.assert(false%2C%20%7Bmessage%3A%20%27foobar%27%7D)",
		"line": 1,
		"column": 27
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.log('hello \nfrom \rthe \"string world!')", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "log",
	"level": "log",
	"messageText": null,
	"parameters": [
		"hello \nfrom \rthe \"string world!"
	],
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[\"hello \\nfrom \\rthe \\\"string world!\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(%27hello%20%5Cnfrom%20%5Crthe%20%5C%22string%20world!%27)\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(%27hello%20%5Cnfrom%20%5Crthe%20%5C%22string%20world!%27)",
		"line": 1,
		"column": 27
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.log('úṇĩçödê țĕșť')", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "log",
	"level": "log",
	"messageText": null,
	"parameters": [
		"úṇĩçödê țĕșť"
	],
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[\"úṇĩçödê țĕșť\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(%27%C3%BA%E1%B9%87%C4%A9%C3%A7%C3%B6d%C3%AA%20%C8%9B%C4%95%C8%99%C5%A5%27)\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(%27%C3%BA%E1%B9%87%C4%A9%C3%A7%C3%B6d%C3%AA%20%C8%9B%C4%95%C8%99%C5%A5%27)",
		"line": 1,
		"column": 27
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.dirxml(window)", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "log",
	"level": "log",
	"messageText": null,
	"parameters": [
		{
			"type": "object",
			"actor": "server1.conn11.child1/obj31",
			"class": "Window",
			"extensible": true,
			"frozen": false,
			"sealed": false,
			"ownPropertyLength": 804,
			"preview": {
				"kind": "ObjectWithURL",
				"url": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html"
			}
		}
	],
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"object\",\"actor\":\"server1.conn11.child1/obj31\",\"class\":\"Window\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":804,\"preview\":{\"kind\":\"ObjectWithURL\",\"url\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html\"}}],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.dirxml(window)\",\"line\":1,\"column\":27},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.dirxml(window)",
		"line": 1,
		"column": 27
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.trace()", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "trace",
	"level": "log",
	"messageText": null,
	"parameters": [],
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"trace\",\"level\":\"log\",\"messageText\":null,\"parameters\":[],\"repeatId\":null,\"stacktrace\":[{\"columnNumber\":3,\"filename\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.trace()\",\"functionName\":\"testStacktraceFiltering\",\"language\":2,\"lineNumber\":3},{\"columnNumber\":3,\"filename\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.trace()\",\"functionName\":\"foo\",\"language\":2,\"lineNumber\":6},{\"columnNumber\":1,\"filename\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.trace()\",\"functionName\":\"triggerPacket\",\"language\":2,\"lineNumber\":9}],\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.trace()\",\"line\":3,\"column\":3},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": [
		{
			"columnNumber": 3,
			"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.trace()",
			"functionName": "testStacktraceFiltering",
			"language": 2,
			"lineNumber": 3
		},
		{
			"columnNumber": 3,
			"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.trace()",
			"functionName": "foo",
			"language": 2,
			"lineNumber": 6
		},
		{
			"columnNumber": 1,
			"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.trace()",
			"functionName": "triggerPacket",
			"language": 2,
			"lineNumber": 9
		}
	],
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.trace()",
		"line": 3,
		"column": 3
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.time('bar')", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "nullMessage",
	"level": "log",
	"messageText": null,
	"parameters": null,
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"nullMessage\",\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.time(%27bar%27)\",\"line\":2,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.time(%27bar%27)",
		"line": 2,
		"column": 1
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.timeEnd('bar')", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "timeEnd",
	"level": "log",
	"messageText": "bar: 1.36ms",
	"parameters": null,
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"timeEnd\",\"level\":\"log\",\"messageText\":\"bar: 1.36ms\",\"parameters\":null,\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.time(%27bar%27)\",\"line\":3,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.time(%27bar%27)",
		"line": 3,
		"column": 1
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.table('bar')", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "log",
	"level": "log",
	"messageText": null,
	"parameters": [
		"bar"
	],
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[\"bar\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.table(%27bar%27)\",\"line\":2,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.table(%27bar%27)",
		"line": 2,
		"column": 1
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.table(['a', 'b', 'c'])", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "table",
	"level": "log",
	"messageText": null,
	"parameters": [
		{
			"type": "object",
			"actor": "server1.conn15.child1/obj31",
			"class": "Array",
			"extensible": true,
			"frozen": false,
			"sealed": false,
			"ownPropertyLength": 4,
			"preview": {
				"kind": "ArrayLike",
				"length": 3,
				"items": [
					"a",
					"b",
					"c"
				]
			}
		}
	],
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"table\",\"level\":\"log\",\"messageText\":null,\"parameters\":[{\"type\":\"object\",\"actor\":\"server1.conn15.child1/obj31\",\"class\":\"Array\",\"extensible\":true,\"frozen\":false,\"sealed\":false,\"ownPropertyLength\":4,\"preview\":{\"kind\":\"ArrayLike\",\"length\":3,\"items\":[\"a\",\"b\",\"c\"]}}],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.table(%5B%27a%27%2C%20%27b%27%2C%20%27c%27%5D)\",\"line\":2,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.table(%5B%27a%27%2C%20%27b%27%2C%20%27c%27%5D)",
		"line": 2,
		"column": 1
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.group('bar')", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "startGroup",
	"level": "log",
	"messageText": "bar",
	"parameters": null,
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"startGroup\",\"level\":\"log\",\"messageText\":\"bar\",\"parameters\":null,\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.group(%27bar%27)\",\"line\":2,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.group(%27bar%27)",
		"line": 2,
		"column": 1
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.groupEnd('bar')", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "endGroup",
	"level": "log",
	"messageText": null,
	"parameters": null,
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"endGroup\",\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.group(%27bar%27)\",\"line\":3,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.group(%27bar%27)",
		"line": 3,
		"column": 1
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.groupCollapsed('foo')", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "startGroupCollapsed",
	"level": "log",
	"messageText": "foo",
	"parameters": null,
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"startGroupCollapsed\",\"level\":\"log\",\"messageText\":\"foo\",\"parameters\":null,\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.groupCollapsed(%27foo%27)\",\"line\":2,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.groupCollapsed(%27foo%27)",
		"line": 2,
		"column": 1
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.groupEnd('foo')", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "endGroup",
	"level": "log",
	"messageText": null,
	"parameters": null,
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"endGroup\",\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.groupCollapsed(%27foo%27)\",\"line\":3,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.groupCollapsed(%27foo%27)",
		"line": 3,
		"column": 1
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.group()", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "startGroup",
	"level": "log",
	"messageText": "<no group label>",
	"parameters": null,
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"startGroup\",\"level\":\"log\",\"messageText\":\"<no group label>\",\"parameters\":null,\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.group()\",\"line\":2,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.group()",
		"line": 2,
		"column": 1
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.groupEnd()", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "endGroup",
	"level": "log",
	"messageText": null,
	"parameters": null,
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"endGroup\",\"level\":\"log\",\"messageText\":null,\"parameters\":null,\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.group()\",\"line\":3,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.group()",
		"line": 3,
		"column": 1
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": []
}));

stubPreparedMessages.set("console.log(%cfoobar)", new ConsoleMessage({
	"id": "1",
	"allowRepeating": true,
	"source": "console-api",
	"type": "log",
	"level": "log",
	"messageText": null,
	"parameters": [
		"foo",
		"bar"
	],
	"repeat": 1,
	"repeatId": "{\"id\":null,\"allowRepeating\":true,\"source\":\"console-api\",\"type\":\"log\",\"level\":\"log\",\"messageText\":null,\"parameters\":[\"foo\",\"bar\"],\"repeatId\":null,\"stacktrace\":null,\"frame\":{\"source\":\"http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(%25cfoobar)\",\"line\":2,\"column\":1},\"groupId\":null,\"exceptionDocURL\":null,\"userProvidedStyles\":[\"color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px\",\"color:red;background:url('http://example.com/test')\"]}",
	"stacktrace": null,
	"frame": {
		"source": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(%25cfoobar)",
		"line": 2,
		"column": 1
	},
	"groupId": null,
	"exceptionDocURL": null,
	"userProvidedStyles": [
		"color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
		"color:red;background:url('http://example.com/test')"
	]
}));


stubPackets.set("console.log('foobar', 'test')", {
	"from": "server1.conn0.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			"foobar",
			"test"
		],
		"columnNumber": 27,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(%27foobar%27%2C%20%27test%27)",
		"functionName": "triggerPacket",
		"groupName": "",
		"level": "log",
		"lineNumber": 1,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"styles": [],
		"timeStamp": 1477086261590,
		"timer": null,
		"workerType": "none",
		"category": "webdev"
	}
});

stubPackets.set("console.log(undefined)", {
	"from": "server1.conn1.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			{
				"type": "undefined"
			}
		],
		"columnNumber": 27,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(undefined)",
		"functionName": "triggerPacket",
		"groupName": "",
		"level": "log",
		"lineNumber": 1,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"styles": [],
		"timeStamp": 1477086264886,
		"timer": null,
		"workerType": "none",
		"category": "webdev"
	}
});

stubPackets.set("console.warn('danger, will robinson!')", {
	"from": "server1.conn2.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			"danger, will robinson!"
		],
		"columnNumber": 27,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.warn(%27danger%2C%20will%20robinson!%27)",
		"functionName": "triggerPacket",
		"groupName": "",
		"level": "warn",
		"lineNumber": 1,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"styles": [],
		"timeStamp": 1477086267284,
		"timer": null,
		"workerType": "none",
		"category": "webdev"
	}
});

stubPackets.set("console.log(NaN)", {
	"from": "server1.conn3.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			{
				"type": "NaN"
			}
		],
		"columnNumber": 27,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(NaN)",
		"functionName": "triggerPacket",
		"groupName": "",
		"level": "log",
		"lineNumber": 1,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"styles": [],
		"timeStamp": 1477086269484,
		"timer": null,
		"workerType": "none",
		"category": "webdev"
	}
});

stubPackets.set("console.log(null)", {
	"from": "server1.conn4.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			{
				"type": "null"
			}
		],
		"columnNumber": 27,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(null)",
		"functionName": "triggerPacket",
		"groupName": "",
		"level": "log",
		"lineNumber": 1,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"styles": [],
		"timeStamp": 1477086271418,
		"timer": null,
		"workerType": "none",
		"category": "webdev"
	}
});

stubPackets.set("console.log('鼬')", {
	"from": "server1.conn5.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			"鼬"
		],
		"columnNumber": 27,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(%27%E9%BC%AC%27)",
		"functionName": "triggerPacket",
		"groupName": "",
		"level": "log",
		"lineNumber": 1,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"styles": [],
		"timeStamp": 1477086273549,
		"timer": null,
		"workerType": "none",
		"category": "webdev"
	}
});

stubPackets.set("console.clear()", {
	"from": "server1.conn6.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [],
		"columnNumber": 27,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.clear()",
		"functionName": "triggerPacket",
		"groupName": "",
		"level": "clear",
		"lineNumber": 1,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"timeStamp": 1477086275587,
		"timer": null,
		"workerType": "none",
		"styles": [],
		"category": "webdev"
	}
});

stubPackets.set("console.count('bar')", {
	"from": "server1.conn7.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			"bar"
		],
		"columnNumber": 27,
		"counter": {
			"count": 1,
			"label": "bar"
		},
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.count(%27bar%27)",
		"functionName": "triggerPacket",
		"groupName": "",
		"level": "count",
		"lineNumber": 1,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"timeStamp": 1477086277812,
		"timer": null,
		"workerType": "none",
		"styles": [],
		"category": "webdev"
	}
});

stubPackets.set("console.assert(false, {message: 'foobar'})", {
	"from": "server1.conn8.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			{
				"type": "object",
				"actor": "server1.conn8.child1/obj31",
				"class": "Object",
				"extensible": true,
				"frozen": false,
				"sealed": false,
				"ownPropertyLength": 1,
				"preview": {
					"kind": "Object",
					"ownProperties": {
						"message": {
							"configurable": true,
							"enumerable": true,
							"writable": true,
							"value": "foobar"
						}
					},
					"ownPropertiesLength": 1,
					"safeGetterValues": {}
				}
			}
		],
		"columnNumber": 27,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.assert(false%2C%20%7Bmessage%3A%20%27foobar%27%7D)",
		"functionName": "triggerPacket",
		"groupName": "",
		"level": "assert",
		"lineNumber": 1,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"styles": [],
		"timeStamp": 1477086280131,
		"timer": null,
		"stacktrace": [
			{
				"columnNumber": 27,
				"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.assert(false%2C%20%7Bmessage%3A%20%27foobar%27%7D)",
				"functionName": "triggerPacket",
				"language": 2,
				"lineNumber": 1
			}
		],
		"workerType": "none",
		"category": "webdev"
	}
});

stubPackets.set("console.log('hello \nfrom \rthe \"string world!')", {
	"from": "server1.conn9.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			"hello \nfrom \rthe \"string world!"
		],
		"columnNumber": 27,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(%27hello%20%5Cnfrom%20%5Crthe%20%5C%22string%20world!%27)",
		"functionName": "triggerPacket",
		"groupName": "",
		"level": "log",
		"lineNumber": 1,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"styles": [],
		"timeStamp": 1477086281936,
		"timer": null,
		"workerType": "none",
		"category": "webdev"
	}
});

stubPackets.set("console.log('úṇĩçödê țĕșť')", {
	"from": "server1.conn10.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			"úṇĩçödê țĕșť"
		],
		"columnNumber": 27,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(%27%C3%BA%E1%B9%87%C4%A9%C3%A7%C3%B6d%C3%AA%20%C8%9B%C4%95%C8%99%C5%A5%27)",
		"functionName": "triggerPacket",
		"groupName": "",
		"level": "log",
		"lineNumber": 1,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"styles": [],
		"timeStamp": 1477086283713,
		"timer": null,
		"workerType": "none",
		"category": "webdev"
	}
});

stubPackets.set("console.dirxml(window)", {
	"from": "server1.conn11.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			{
				"type": "object",
				"actor": "server1.conn11.child1/obj31",
				"class": "Window",
				"extensible": true,
				"frozen": false,
				"sealed": false,
				"ownPropertyLength": 804,
				"preview": {
					"kind": "ObjectWithURL",
					"url": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-console-api.html"
				}
			}
		],
		"columnNumber": 27,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.dirxml(window)",
		"functionName": "triggerPacket",
		"groupName": "",
		"level": "dirxml",
		"lineNumber": 1,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"timeStamp": 1477086285483,
		"timer": null,
		"workerType": "none",
		"styles": [],
		"category": "webdev"
	}
});

stubPackets.set("console.trace()", {
	"from": "server1.conn12.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [],
		"columnNumber": 3,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.trace()",
		"functionName": "testStacktraceFiltering",
		"groupName": "",
		"level": "trace",
		"lineNumber": 3,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"timeStamp": 1477086287286,
		"timer": null,
		"stacktrace": [
			{
				"columnNumber": 3,
				"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.trace()",
				"functionName": "testStacktraceFiltering",
				"language": 2,
				"lineNumber": 3
			},
			{
				"columnNumber": 3,
				"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.trace()",
				"functionName": "foo",
				"language": 2,
				"lineNumber": 6
			},
			{
				"columnNumber": 1,
				"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.trace()",
				"functionName": "triggerPacket",
				"language": 2,
				"lineNumber": 9
			}
		],
		"workerType": "none",
		"styles": [],
		"category": "webdev"
	}
});

stubPackets.set("console.time('bar')", {
	"from": "server1.conn13.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			"bar"
		],
		"columnNumber": 1,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.time(%27bar%27)",
		"functionName": "triggerPacket",
		"groupName": "",
		"level": "time",
		"lineNumber": 2,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"timeStamp": 1477086289137,
		"timer": {
			"name": "bar",
			"started": 1166.305
		},
		"workerType": "none",
		"styles": [],
		"category": "webdev"
	}
});

stubPackets.set("console.timeEnd('bar')", {
	"from": "server1.conn13.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			"bar"
		],
		"columnNumber": 1,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.time(%27bar%27)",
		"functionName": "triggerPacket",
		"groupName": "",
		"level": "timeEnd",
		"lineNumber": 3,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"timeStamp": 1477086289138,
		"timer": {
			"duration": 1.3550000000000182,
			"name": "bar"
		},
		"workerType": "none",
		"styles": [],
		"category": "webdev"
	}
});

stubPackets.set("console.table('bar')", {
	"from": "server1.conn14.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			"bar"
		],
		"columnNumber": 1,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.table(%27bar%27)",
		"functionName": "triggerPacket",
		"groupName": "",
		"level": "table",
		"lineNumber": 2,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"timeStamp": 1477086290984,
		"timer": null,
		"workerType": "none",
		"styles": [],
		"category": "webdev"
	}
});

stubPackets.set("console.table(['a', 'b', 'c'])", {
	"from": "server1.conn15.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			{
				"type": "object",
				"actor": "server1.conn15.child1/obj31",
				"class": "Array",
				"extensible": true,
				"frozen": false,
				"sealed": false,
				"ownPropertyLength": 4,
				"preview": {
					"kind": "ArrayLike",
					"length": 3,
					"items": [
						"a",
						"b",
						"c"
					]
				}
			}
		],
		"columnNumber": 1,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.table(%5B%27a%27%2C%20%27b%27%2C%20%27c%27%5D)",
		"functionName": "triggerPacket",
		"groupName": "",
		"level": "table",
		"lineNumber": 2,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"timeStamp": 1477086292762,
		"timer": null,
		"workerType": "none",
		"styles": [],
		"category": "webdev"
	}
});

stubPackets.set("console.group('bar')", {
	"from": "server1.conn16.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			"bar"
		],
		"columnNumber": 1,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.group(%27bar%27)",
		"functionName": "triggerPacket",
		"groupName": "bar",
		"level": "group",
		"lineNumber": 2,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"timeStamp": 1477086294628,
		"timer": null,
		"workerType": "none",
		"styles": [],
		"category": "webdev"
	}
});

stubPackets.set("console.groupEnd('bar')", {
	"from": "server1.conn16.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			"bar"
		],
		"columnNumber": 1,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.group(%27bar%27)",
		"functionName": "triggerPacket",
		"groupName": "bar",
		"level": "groupEnd",
		"lineNumber": 3,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"timeStamp": 1477086294630,
		"timer": null,
		"workerType": "none",
		"styles": [],
		"category": "webdev"
	}
});

stubPackets.set("console.groupCollapsed('foo')", {
	"from": "server1.conn17.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			"foo"
		],
		"columnNumber": 1,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.groupCollapsed(%27foo%27)",
		"functionName": "triggerPacket",
		"groupName": "foo",
		"level": "groupCollapsed",
		"lineNumber": 2,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"timeStamp": 1477086296567,
		"timer": null,
		"workerType": "none",
		"styles": [],
		"category": "webdev"
	}
});

stubPackets.set("console.groupEnd('foo')", {
	"from": "server1.conn17.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			"foo"
		],
		"columnNumber": 1,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.groupCollapsed(%27foo%27)",
		"functionName": "triggerPacket",
		"groupName": "foo",
		"level": "groupEnd",
		"lineNumber": 3,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"timeStamp": 1477086296570,
		"timer": null,
		"workerType": "none",
		"styles": [],
		"category": "webdev"
	}
});

stubPackets.set("console.group()", {
	"from": "server1.conn18.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [],
		"columnNumber": 1,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.group()",
		"functionName": "triggerPacket",
		"groupName": "",
		"level": "group",
		"lineNumber": 2,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"timeStamp": 1477086298462,
		"timer": null,
		"workerType": "none",
		"styles": [],
		"category": "webdev"
	}
});

stubPackets.set("console.groupEnd()", {
	"from": "server1.conn18.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [],
		"columnNumber": 1,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.group()",
		"functionName": "triggerPacket",
		"groupName": "",
		"level": "groupEnd",
		"lineNumber": 3,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"timeStamp": 1477086298464,
		"timer": null,
		"workerType": "none",
		"styles": [],
		"category": "webdev"
	}
});

stubPackets.set("console.log(%cfoobar)", {
	"from": "server1.conn19.child1/consoleActor2",
	"type": "consoleAPICall",
	"message": {
		"arguments": [
			"foo",
			"bar"
		],
		"columnNumber": 1,
		"counter": null,
		"filename": "http://example.com/browser/devtools/client/webconsole/new-console-output/test/fixtures/stub-generators/test-tempfile.js?key=console.log(%25cfoobar)",
		"functionName": "triggerPacket",
		"groupName": "",
		"level": "log",
		"lineNumber": 2,
		"originAttributes": {
			"addonId": "",
			"appId": 0,
			"firstPartyDomain": "",
			"inIsolatedMozBrowser": false,
			"privateBrowsingId": 0
		},
		"private": false,
		"styles": [
			"color:blue;font-size:1.3em;background:url('http://example.com/test');position:absolute;top:10px",
			"color:red;background:url('http://example.com/test')"
		],
		"timeStamp": 1477086300265,
		"timer": null,
		"workerType": "none",
		"category": "webdev"
	}
});


module.exports = {
  stubPreparedMessages,
  stubPackets,
}