/*********************************************************************
 * Name:      	main.h
 * Purpose:   	Declares simple wxWidgets application with GUI
 * 				created using wxFormBuilder.
 * Author:
 * Created:
 * Copyright:
 * License:   	wxWidgets license (www.wxwidgets.org)
 *
 * Notes:		Note that all GUI creation code is declared in
 * 				gui.h source file which is generated by wxFormBuilder.
 *********************************************************************/

#ifndef __findit__
#define __findit__

// main wxWidgets header file
#include <wx/wx.h>
#include "wx/grid.h"
#include <wx/object.h>

// gui classes generated by wxFormBuilder
#include "gui.h"
#include "findit_pi.h"


class findit_pi;

class MainDialog : public FindItDialog
{
public:
    enum FIELDS { BUY,PRIORITY,QUOTA,ACTUELL,TOBUY, UNIT,TEXT,LOC1,LOC2,LOC3,LOC4,LOC5,LOC6};

    MainDialog( wxWindow *parent, findit_pi* p );
    virtual ~MainDialog();

    void reloadData();
    void setLogbookColumns(bool logbookReady);

protected:
    // protected event handlers
    virtual void OnCloseDialog( wxCloseEvent& event );
    virtual void OnOKClick( wxCommandEvent& event );
    virtual void OnCancelClick( wxCommandEvent& event );
    void OnInit( wxInitDialogEvent& event );
    void OnButtonClickMaterialAdd( wxCommandEvent& event );
    void OnGridCellLeftClickMaterial( wxGridEvent& event );
    void OnGridCellLeftClickFood( wxGridEvent& event );
    void onButtonClickAddLineLocations( wxCommandEvent& event );
    void OnButtonClickAddLineFood( wxCommandEvent& event );
    void OnButtonClickUnitsAddLine( wxCommandEvent& event );
    void OnTextMaterial( wxCommandEvent& event );
    void OnTextFood( wxCommandEvent& event );
    void OnCharMaterial( wxKeyEvent& event );
    void OnCharFood( wxKeyEvent& event );
    void OnGridCellChangeUnits( wxGridEvent& event );
    void OnGridCellChangeLocations( wxGridEvent& event );
    void onEditorShownLocations( wxGridEvent& event );
    void onEditorShownUnits( wxGridEvent& event );
    void OnGridCellChangeMaterial( wxGridEvent& event );
    void OnGridCellChangeFood( wxGridEvent& event );
    void OnButtonClickBuyFood( wxCommandEvent& event );
    void OnButtonClickBuyMaterial( wxCommandEvent& event );
    void OnCharLocations( wxKeyEvent& event );
    void OnCharUnits( wxKeyEvent& event );
    void OnGridCellLeftClickUnits( wxGridEvent& event );
    void OnGridCellLeftClickLocations( wxGridEvent& event );
    void OnGridLabelLClickFood( wxGridEvent& event );
    void OnGridLabelLClickMaterial( wxGridEvent& event );

    void saveData();
    void loadData();

    int addLineMaterial();
    int addLineFood();
    bool deleteGridRow(int key, wxGrid* grid);
    void searchItem(wxGrid* grid, wxString str);
    void sortGrid(wxGrid* grid, int col, bool ascending);
    void renameMaterialAndFood(wxArrayString& location1, int column, wxString str);

private:
    wxArrayString location1,location2,location3,location4,location5,location6,unit,prioritystr;
    int lastRowSelectedMaterial, lastRowSelectedFood, lastRowSelectedUnits, lastRowSelectedLocations;
    int lastColSelectedMaterial, lastColSelectedFood, lastColSelectedUnits, lastColSelectedLocations;
    wxString oldCellValue;
    unsigned int searchStringCountMaterial, searchStringCountFood;
    void resetRowHeight(wxGrid* grid);

    wxString			    pHome_Locn;
    findit_pi*              pPlugin;
    wxGridCellBoolEditor *boolEditor;
    wxGridCellChoiceEditor* combo;
    wxGridCellChoiceEditor* combo1;
    wxGridCellChoiceEditor* combo2;
    wxGridCellChoiceEditor* combo3;
    wxGridCellChoiceEditor* combo4;
    wxGridCellChoiceEditor* combo5;
    wxGridCellChoiceEditor* comboUnit;
    wxGridCellChoiceEditor* comboPriority;
};

WX_DECLARE_OBJARRAY(wxArrayString, myGridStringArray);//(,
//class WXDLLIMPEXP_ADV);

class myGridStringTable : public wxGridTableBase
{
public:
    myGridStringTable();
    myGridStringTable( int numRows, int numCols );
    virtual ~myGridStringTable();

    // these are pure virtual in wxGridTableBase
    //
    int GetNumberRows();
    int GetNumberCols();
    wxString GetValue( int row, int col );
    void SetValue( int row, int col, const wxString& s );
    bool IsEmptyCell( int row, int col );

    // overridden functions from wxGridTableBase
    //
    void Clear();
    bool InsertRows( size_t pos = 0, size_t numRows = 1 );
    bool AppendRows( size_t numRows = 1 );
    bool DeleteRows( size_t pos = 0, size_t numRows = 1 );
    bool InsertCols( size_t pos = 0, size_t numCols = 1 );
    bool AppendCols( size_t numCols = 1 );
    bool DeleteCols( size_t pos = 0, size_t numCols = 1 );

    void SetRowLabelValue( int row, const wxString& );
    void SetColLabelValue( int col, const wxString& );
    wxString GetRowLabelValue( int row );
    wxString GetColLabelValue( int col );

    wxGridStringArray m_data;

private:


    // These only get used if you set your own labels, otherwise the
    // GetRow/ColLabelValue functions return wxGridTableBase defaults
    //
    wxArrayString     m_rowLabels;
    wxArrayString     m_colLabels;

//    DECLARE_DYNAMIC_CLASS_NO_COPY( wxGridStringTable )
};

#endif //__main__
