#!/usr/bin/env bash
set -euo pipefail
IFS=$'\n\t'


new_version=$1
aur_dev_repo_dir=~/build/oomox-git


if [[ $(git status --porcelain 2>/dev/null| grep -c "^ [MD]") -gt 0 ]] ; then
	echo
	echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	echo "!!    You have uncommited changes:    !!"
	echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
	echo
	git status

	echo
	echo "?????????????????????????????????????????"
	echo "??    Do you want to proceed? [y/N]    ??"
	echo "?????????????????????????????????????????"
	echo -n "> "
	read -r answer
	echo
	if [[ "${answer}" != "y" ]] ; then
		exit 1
	fi
	answer=
fi

./maintenance_scripts/show_recent_history.sh -c || true


echo
echo "*******************************"
echo "**    Updating version...    **"
echo "*******************************"
echo

sed -i -e "s/pkgver=.*/pkgver=${new_version}/g" packaging/arch/PKGBUILD
sed -i -e "s/pkgrel=.*/pkgrel=1/g" packaging/arch/PKGBUILD
sed -i -e "s/^Version: .*/Version: ${new_version}-1~themixproject~zesty/" packaging/ubuntu/control
sed -i -e "s/^Version: .*/Version: ${new_version}-1~themixproject~cosmic/" packaging/ubuntu/control_1810
sed -i -e 's/"tag": ".*"/"tag": "'"${new_version}"'"/g' packaging/flatpak/com.github.themix_project.Oomox.json
sed -i -e 's/<release .*\/>/<release date="'"$(date +"%Y-%m-%d")"'" version="'"$new_version"'"\/>/g' packaging/com.github.themix_project.Oomox.appdata.xml

echo
echo "??????????????????????????????????????????????????????????????????????"
echo "??    Confirm pushing ${new_version} to Oomox GitHub repo? [y/N]    ??"
echo "??????????????????????????????????????????????????????????????????????"
echo -n "> "
read -r answer
echo
if [[ "${answer}" = "y" ]] ; then
	git commit -am "chore: bump version to ${new_version}" || true
	git tag -a "${new_version}"
	git push origin HEAD
	git push origin "${new_version}"
fi
answer=



echo
echo "***************************************"
echo "**    Updating AUR dev PKBUILD...    **"
echo "***************************************"
echo
./maintenance_scripts/changelog.sh > "${aur_dev_repo_dir}"/CHANGELOG
cp ./packaging/arch/PKGBUILD "${aur_dev_repo_dir}"/PKGBUILD
cd "${aur_dev_repo_dir}"
makepkg --printsrcinfo > .SRCINFO


echo
echo "??????????????????????????????????????????????????"
echo "??    Confirm push to AUR dev package? [y/N]    ??"
echo "??????????????????????????????????????????????????"
echo -n "> "
read -r answer
echo
if [[ "${answer}" = "y" ]] ; then
	git add PKGBUILD .SRCINFO CHANGELOG
	git commit -m "update to ${new_version}"
	git push origin HEAD
fi
answer=


echo
echo '$$$$$$$$$$$$$$$$$$$$$$$$$'
echo '$$    Full Success!    $$'
echo '$$$$$$$$$$$$$$$$$$$$$$$$$'

exit 0
