# OpenCV installation script based on: https://www.learnopencv.com/install-opencv-4-on-ubuntu-16-04/


# Define OpenCV version to install
cvVersion="master"

echo "Building OpenCV $cvVersion"
	
mkdir installation
mkdir installation/OpenCV-"$cvVersion"

# Save current working directory
cwd=$(pwd)
	
sudo apt -y remove x264 libx264-dev
 
## Install dependencies
sudo apt -y install pkg-config yasm
sudo apt -y install git gfortran
# sudo apt -y install libjpeg8-dev libjasper-dev libpng12-dev
 
sudo apt -y install libtiff5-dev
 
# sudo apt -y install libavcodec-dev libavformat-dev libswscale-dev libdc1394-22-dev
# sudo apt -y install libxine2-dev libv4l-dev
# cd /usr/include/linux
# sudo ln -s -f ../libv4l1-videodev.h videodev.h
cd $cwd
 
# sudo apt -y install libgstreamer0.10-dev libgstreamer-plugins-base0.10-dev
# sudo apt -y install libgtk2.0-dev libtbb-dev qt5-default
sudo apt -y install libatlas-base-dev
sudo apt -y install libfaac-dev libmp3lame-dev libtheora-dev
sudo apt -y install libvorbis-dev libxvidcore-dev
sudo apt -y install libopencore-amrnb-dev libopencore-amrwb-dev
sudo apt -y install libavresample-dev
sudo apt -y install x264 v4l-utils
 
# Optional dependencies
# sudo apt -y install libprotobuf-dev protobuf-compiler
# sudo apt -y install libgoogle-glog-dev libgflags-dev
# sudo apt -y install libgphoto2-dev libeigen3-dev libhdf5-dev doxygen
	
# sudo apt -y install python3-dev python3-pip
# sudo -H pip3 install -U pip numpy
# sudo apt -y install python3-testresources

# cd $cwd
# ############ For Python 3 ############
# # create virtual environment
# python3 -m venv OpenCV-"$cvVersion"-py3
# echo "# Virtual Environment Wrapper" >> ~/.bashrc
# echo "alias workoncv-$cvVersion=\"source $cwd/OpenCV-$cvVersion-py3/bin/activate\"" >> ~/.bashrc
# source "$cwd"/OpenCV-"$cvVersion"-py3/bin/activate
 
# # now install python libraries within this virtual environment
# pip install wheel numpy scipy matplotlib scikit-image scikit-learn ipython dlib
  
# # quit virtual environment
# deactivate

git clone https://github.com/opencv/opencv.git
cd opencv
git checkout $cvVersion
cd ..
 
# git clone https://github.com/opencv/opencv_contrib.git
# cd opencv_contrib
# git checkout $cvVersion
	
cd opencv
mkdir build
cd build
	
cmake -D CMAKE_BUILD_TYPE=RELEASE \
            -D CMAKE_INSTALL_PREFIX=$cwd/installation/OpenCV-"$cvVersion" \
            -D INSTALL_C_EXAMPLES=OFF \
            -D INSTALL_PYTHON_EXAMPLES=OFF \
            -D WITH_TBB=OFF \
            -D WITH_V4L=OFF \
        -D WITH_QT=OFF \
        -D WITH_OPENGL=OFF \
        -D OPENCV_EXTRA_MODULES_PATH=../../opencv_contrib/modules \
        -D BUILD_EXAMPLES=OFF ..
	
make -j4
make install
	