/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2017 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Menger Middle Mod

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the function "MengerMiddleModIteration" in the file fractal_formulas.cpp
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 MengerMiddleModIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{ // fabs() and menger fold
	z = fabs(z + fractal->transformCommon.additionConstantA000);
	if (z.x - z.y < 0.0f)
	{
		REAL temp = z.y;
		z.y = z.x;
		z.x = temp;
	}
	if (z.x - z.z < 0.0f)
	{
		REAL temp = z.z;
		z.z = z.x;
		z.x = temp;
	}
	if (z.y - z.z < 0.0f)
	{
		REAL temp = z.z;
		z.z = z.y;
		z.y = temp;
	}

	if (fractal->mandelbox.mainRotationEnabled && aux->i >= fractal->transformCommon.startIterationsC
			&& aux->i < fractal->transformCommon.stopIterationsC) // rotation
	{
		z = Matrix33MulFloat4(fractal->mandelbox.mainRot, z);
	}

	if (fractal->transformCommon.functionEnabledBxFalse
			&& aux->i >= fractal->transformCommon.startIterationsA
			&& aux->i < fractal->transformCommon.stopIterationsA) // box fold
	{
		if (fabs(z.x) > fractal->mandelbox.foldingLimit)
		{
			z.x = mad(sign(z.x), fractal->mandelbox.foldingValue, -z.x);
			aux->color += fractal->mandelbox.color.factor.x;
		}
		if (fabs(z.y) > fractal->mandelbox.foldingLimit)
		{
			z.y = mad(sign(z.y), fractal->mandelbox.foldingValue, -z.y);
			aux->color += fractal->mandelbox.color.factor.y;
		}
		REAL zLimit = fractal->mandelbox.foldingLimit * fractal->transformCommon.scale1;
		REAL zValue = fractal->mandelbox.foldingValue * fractal->transformCommon.scale1;
		if (fabs(z.z) > zLimit)
		{
			z.z = mad(sign(z.z), zValue, -z.z);
			aux->color += fractal->mandelbox.color.factor.z;
		}
	}
	if (fractal->transformCommon.functionEnabledByFalse
			&& aux->i >= fractal->transformCommon.startIterations
			&& aux->i < fractal->transformCommon.stopIterations)
	{ // fabsBoxFold
		REAL4 tempA, tempB;

		if (fractal->transformCommon.functionEnabledx)
			tempA.x = fabs(z.x + fractal->transformCommon.additionConstant111.x);
		if (fractal->transformCommon.functionEnabledAx)
			tempB.x = fabs(z.x - fractal->transformCommon.additionConstantA111.x);
		z.x = tempA.x - tempB.x - (z.x * fractal->transformCommon.scale3D111.x);

		if (fractal->transformCommon.functionEnabledy)
			tempA.y = fabs(z.y + fractal->transformCommon.additionConstant111.y);
		if (fractal->transformCommon.functionEnabledAy)
			tempB.y = fabs(z.y - fractal->transformCommon.additionConstantA111.y);
		z.y = tempA.y - tempB.y - (z.y * fractal->transformCommon.scale3D111.y);

		if (fractal->transformCommon.functionEnabledz)
			tempA.z = fabs(z.z + fractal->transformCommon.additionConstant111.z);
		if (fractal->transformCommon.functionEnabledAz)
			tempB.z = fabs(z.z - fractal->transformCommon.additionConstantA111.z);
		z.z = tempA.z - tempB.z - (z.z * fractal->transformCommon.scale3D111.z);

		if (aux->i >= fractal->transformCommon.startIterationsB
				&& aux->i < fractal->transformCommon.stopIterationsB)
		{
			z *= fractal->transformCommon.scaleA1;
			aux->DE *= fabs(fractal->transformCommon.scaleA1);
		}
	}
	// menger scales and offsets
	z *= fractal->transformCommon.scale3;
	z.x -= 2.0f * fractal->transformCommon.constantMultiplier111.x;
	z.y -= 2.0f * fractal->transformCommon.constantMultiplier111.y;
	if (fractal->transformCommon.functionEnabled)
	{
		if (z.z > 1.0f) z.z -= 2.0f * fractal->transformCommon.constantMultiplier111.z;
	}
	else
	{
		z.z -= 2.0f * fractal->transformCommon.constantMultiplier111.z;
	}
	aux->DE *= fractal->transformCommon.scale3;

	if (fractal->transformCommon.addCpixelEnabledFalse) // addCpixel options
	{
		switch (fractal->mandelbulbMulti.orderOfXYZC)
		{
			case multi_OrderOfXYZCl_xyz:
			default: aux->c = (REAL4){aux->c.x, aux->c.y, aux->c.z, aux->c.w}; break;
			case multi_OrderOfXYZCl_xzy: aux->c = (REAL4){aux->c.x, aux->c.z, aux->c.y, aux->c.w}; break;
			case multi_OrderOfXYZCl_yxz: aux->c = (REAL4){aux->c.y, aux->c.x, aux->c.z, aux->c.w}; break;
			case multi_OrderOfXYZCl_yzx: aux->c = (REAL4){aux->c.y, aux->c.z, aux->c.x, aux->c.w}; break;
			case multi_OrderOfXYZCl_zxy: aux->c = (REAL4){aux->c.z, aux->c.x, aux->c.y, aux->c.w}; break;
			case multi_OrderOfXYZCl_zyx: aux->c = (REAL4){aux->c.z, aux->c.y, aux->c.x, aux->c.w}; break;
		}
		z += aux->c * fractal->transformCommon.constantMultiplierC111;
	}
	return z;
}