; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py

; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mcpu=haswell | FileCheck %s

declare <4 x double> @llvm.minnum.v4f64(<4 x double> %x, <4 x double> %y)
declare <4 x double> @llvm.maxnum.v4f64(<4 x double> %x, <4 x double> %y)

define <4 x double> @via_minnum(<4 x double> %x, <4 x double> %y) {
; CHECK-LABEL: via_minnum:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vminpd %ymm0, %ymm1, %ymm2
; CHECK-NEXT:    vcmpunordpd %ymm0, %ymm0, %ymm0
; CHECK-NEXT:    vblendvpd %ymm0, %ymm1, %ymm2, %ymm0
; CHECK-NEXT:    retq
  %z = call fast <4 x double> @llvm.minnum.v4f64(<4 x double> %x, <4 x double> %y) readnone
  ret <4 x double> %z
}

define <4 x double> @via_maxnum(<4 x double> %x, <4 x double> %y) {
; CHECK-LABEL: via_maxnum:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaxpd %ymm0, %ymm1, %ymm2
; CHECK-NEXT:    vcmpunordpd %ymm0, %ymm0, %ymm0
; CHECK-NEXT:    vblendvpd %ymm0, %ymm1, %ymm2, %ymm0
; CHECK-NEXT:    retq
  %z = call fast <4 x double> @llvm.maxnum.v4f64(<4 x double> %x, <4 x double> %y) readnone
  ret <4 x double> %z
}

define <4 x double> @via_fcmp(<4 x double> %x, <4 x double> %y) {
; CHECK-LABEL: via_fcmp:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vminpd %ymm0, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %c = fcmp ule <4 x double> %x, %y
  %z = select <4 x i1> %c, <4 x double> %x, <4 x double> %y
  ret <4 x double> %z
}


