
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQWizard.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQWizard_EventAdaptor.h"
#include "gsiDeclQWizard_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QWizard

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QWizard::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// int QWizard::addPage(QWizardPage *page)


static void _init_f_addPage_1709 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("page");
  decl->add_arg<QWizardPage * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_addPage_1709 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWizardPage *arg1 = args.read<QWizardPage * > ();
  ret.write<int > ((int)((QWizard *)cls)->addPage (arg1));
}

static qt_gsi::GenericMethod *_create_f_addPage_1709 ()
{
  return new qt_gsi::GenericMethod ("addPage", "@brief Method int QWizard::addPage(QWizardPage *page)\n", false, &_init_f_addPage_1709, &_call_f_addPage_1709);
}

// void QWizard::back()


static void _init_f_back_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_back_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWizard *)cls)->back ();
}

static qt_gsi::GenericMethod *_create_f_back_0 ()
{
  return new qt_gsi::GenericMethod ("back", "@brief Method void QWizard::back()\n", false, &_init_f_back_0, &_call_f_back_0);
}

// QAbstractButton *QWizard::button(QWizard::WizardButton which)


static void _init_f_button_c2519 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<QWizard::WizardButton>::target_type & > (argspec_0);
  decl->set_return<QAbstractButton * > ();
}

static void _call_f_button_c2519 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QWizard::WizardButton>::target_type & arg1 = args.read<const qt_gsi::Converter<QWizard::WizardButton>::target_type & > ();
  ret.write<QAbstractButton * > ((QAbstractButton *)((QWizard *)cls)->button (qt_gsi::QtToCppAdaptor<QWizard::WizardButton>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_button_c2519 ()
{
  return new qt_gsi::GenericMethod ("button", "@brief Method QAbstractButton *QWizard::button(QWizard::WizardButton which)\n", true, &_init_f_button_c2519, &_call_f_button_c2519);
}

// QString QWizard::buttonText(QWizard::WizardButton which)


static void _init_f_buttonText_c2519 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<QWizard::WizardButton>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_buttonText_c2519 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QWizard::WizardButton>::target_type & arg1 = args.read<const qt_gsi::Converter<QWizard::WizardButton>::target_type & > ();
  ret.write<QString > ((QString)((QWizard *)cls)->buttonText (qt_gsi::QtToCppAdaptor<QWizard::WizardButton>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_buttonText_c2519 ()
{
  return new qt_gsi::GenericMethod ("buttonText", "@brief Method QString QWizard::buttonText(QWizard::WizardButton which)\n", true, &_init_f_buttonText_c2519, &_call_f_buttonText_c2519);
}

// int QWizard::currentId()


static void _init_f_currentId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentId_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QWizard *)cls)->currentId ());
}

static qt_gsi::GenericMethod *_create_f_currentId_c0 ()
{
  return new qt_gsi::GenericMethod (":currentId", "@brief Method int QWizard::currentId()\n", true, &_init_f_currentId_c0, &_call_f_currentId_c0);
}

// QWizardPage *QWizard::currentPage()


static void _init_f_currentPage_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWizardPage * > ();
}

static void _call_f_currentPage_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWizardPage * > ((QWizardPage *)((QWizard *)cls)->currentPage ());
}

static qt_gsi::GenericMethod *_create_f_currentPage_c0 ()
{
  return new qt_gsi::GenericMethod ("currentPage", "@brief Method QWizardPage *QWizard::currentPage()\n", true, &_init_f_currentPage_c0, &_call_f_currentPage_c0);
}

// QVariant QWizard::field(const QString &name)


static void _init_f_field_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_field_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QVariant > ((QVariant)((QWizard *)cls)->field (arg1));
}

static qt_gsi::GenericMethod *_create_f_field_c2025 ()
{
  return new qt_gsi::GenericMethod ("field", "@brief Method QVariant QWizard::field(const QString &name)\n", true, &_init_f_field_c2025, &_call_f_field_c2025);
}

// bool QWizard::hasVisitedPage(int id)


static void _init_f_hasVisitedPage_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasVisitedPage_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<bool > ((bool)((QWizard *)cls)->hasVisitedPage (arg1));
}

static qt_gsi::GenericMethod *_create_f_hasVisitedPage_c767 ()
{
  return new qt_gsi::GenericMethod ("hasVisitedPage", "@brief Method bool QWizard::hasVisitedPage(int id)\n", true, &_init_f_hasVisitedPage_c767, &_call_f_hasVisitedPage_c767);
}

// void QWizard::next()


static void _init_f_next_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_next_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWizard *)cls)->next ();
}

static qt_gsi::GenericMethod *_create_f_next_0 ()
{
  return new qt_gsi::GenericMethod ("next", "@brief Method void QWizard::next()\n", false, &_init_f_next_0, &_call_f_next_0);
}

// int QWizard::nextId()


static void _init_f_nextId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_nextId_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QWizard *)cls)->nextId ());
}

static qt_gsi::GenericMethod *_create_f_nextId_c0 ()
{
  return new qt_gsi::GenericMethod ("nextId", "@brief Method int QWizard::nextId()\n", true, &_init_f_nextId_c0, &_call_f_nextId_c0);
}

// QFlags<QWizard::WizardOption> QWizard::options()


static void _init_f_options_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QWizard::WizardOption> >::target_type > ();
}

static void _call_f_options_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QWizard::WizardOption> >::target_type > ((qt_gsi::Converter<QFlags<QWizard::WizardOption> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QWizard::WizardOption> >(((QWizard *)cls)->options ()));
}

static qt_gsi::GenericMethod *_create_f_options_c0 ()
{
  return new qt_gsi::GenericMethod (":options", "@brief Method QFlags<QWizard::WizardOption> QWizard::options()\n", true, &_init_f_options_c0, &_call_f_options_c0);
}

// QWizardPage *QWizard::page(int id)


static void _init_f_page_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QWizardPage * > ();
}

static void _call_f_page_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QWizardPage * > ((QWizardPage *)((QWizard *)cls)->page (arg1));
}

static qt_gsi::GenericMethod *_create_f_page_c767 ()
{
  return new qt_gsi::GenericMethod ("page", "@brief Method QWizardPage *QWizard::page(int id)\n", true, &_init_f_page_c767, &_call_f_page_c767);
}

// QList<int> QWizard::pageIds()


static void _init_f_pageIds_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<int> >::target_type > ();
}

static void _call_f_pageIds_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<int> >::target_type > ((qt_gsi::Converter<QList<int> >::target_type)qt_gsi::CppToQtAdaptor<QList<int> >(((QWizard *)cls)->pageIds ()));
}

static qt_gsi::GenericMethod *_create_f_pageIds_c0 ()
{
  return new qt_gsi::GenericMethod ("pageIds", "@brief Method QList<int> QWizard::pageIds()\n", true, &_init_f_pageIds_c0, &_call_f_pageIds_c0);
}

// QPixmap QWizard::pixmap(QWizard::WizardPixmap which)


static void _init_f_pixmap_c2506 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<QWizard::WizardPixmap>::target_type & > (argspec_0);
  decl->set_return<QPixmap > ();
}

static void _call_f_pixmap_c2506 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QWizard::WizardPixmap>::target_type & arg1 = args.read<const qt_gsi::Converter<QWizard::WizardPixmap>::target_type & > ();
  ret.write<QPixmap > ((QPixmap)((QWizard *)cls)->pixmap (qt_gsi::QtToCppAdaptor<QWizard::WizardPixmap>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_pixmap_c2506 ()
{
  return new qt_gsi::GenericMethod ("pixmap", "@brief Method QPixmap QWizard::pixmap(QWizard::WizardPixmap which)\n", true, &_init_f_pixmap_c2506, &_call_f_pixmap_c2506);
}

// void QWizard::removePage(int id)


static void _init_f_removePage_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removePage_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QWizard *)cls)->removePage (arg1);
}

static qt_gsi::GenericMethod *_create_f_removePage_767 ()
{
  return new qt_gsi::GenericMethod ("removePage", "@brief Method void QWizard::removePage(int id)\n", false, &_init_f_removePage_767, &_call_f_removePage_767);
}

// void QWizard::restart()


static void _init_f_restart_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_restart_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWizard *)cls)->restart ();
}

static qt_gsi::GenericMethod *_create_f_restart_0 ()
{
  return new qt_gsi::GenericMethod ("restart", "@brief Method void QWizard::restart()\n", false, &_init_f_restart_0, &_call_f_restart_0);
}

// void QWizard::setButton(QWizard::WizardButton which, QAbstractButton *button)


static void _init_f_setButton_4570 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<QWizard::WizardButton>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("button");
  decl->add_arg<QAbstractButton * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setButton_4570 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QWizard::WizardButton>::target_type & arg1 = args.read<const qt_gsi::Converter<QWizard::WizardButton>::target_type & > ();
  QAbstractButton *arg2 = args.read<QAbstractButton * > ();
  ((QWizard *)cls)->setButton (qt_gsi::QtToCppAdaptor<QWizard::WizardButton>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setButton_4570 ()
{
  return new qt_gsi::GenericMethod ("setButton", "@brief Method void QWizard::setButton(QWizard::WizardButton which, QAbstractButton *button)\n", false, &_init_f_setButton_4570, &_call_f_setButton_4570);
}

// void QWizard::setButtonLayout(const QList<QWizard::WizardButton> &layout)


static void _init_f_setButtonLayout_4011 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("layout");
  decl->add_arg<const qt_gsi::Converter<QList<QWizard::WizardButton> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setButtonLayout_4011 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QWizard::WizardButton> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QWizard::WizardButton> >::target_type & > ();
  ((QWizard *)cls)->setButtonLayout (qt_gsi::QtToCppAdaptor<QList<QWizard::WizardButton> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setButtonLayout_4011 ()
{
  return new qt_gsi::GenericMethod ("setButtonLayout", "@brief Method void QWizard::setButtonLayout(const QList<QWizard::WizardButton> &layout)\n", false, &_init_f_setButtonLayout_4011, &_call_f_setButtonLayout_4011);
}

// void QWizard::setButtonText(QWizard::WizardButton which, const QString &text)


static void _init_f_setButtonText_4436 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<QWizard::WizardButton>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setButtonText_4436 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QWizard::WizardButton>::target_type & arg1 = args.read<const qt_gsi::Converter<QWizard::WizardButton>::target_type & > ();
  const QString &arg2 = args.read<const QString & > ();
  ((QWizard *)cls)->setButtonText (qt_gsi::QtToCppAdaptor<QWizard::WizardButton>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setButtonText_4436 ()
{
  return new qt_gsi::GenericMethod ("setButtonText", "@brief Method void QWizard::setButtonText(QWizard::WizardButton which, const QString &text)\n", false, &_init_f_setButtonText_4436, &_call_f_setButtonText_4436);
}

// void QWizard::setDefaultProperty(const char *className, const char *property, const char *changedSignal)


static void _init_f_setDefaultProperty_4977 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("className");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("property");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("changedSignal");
  decl->add_arg<const char * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setDefaultProperty_4977 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  const char *arg3 = args.read<const char * > ();
  ((QWizard *)cls)->setDefaultProperty (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_setDefaultProperty_4977 ()
{
  return new qt_gsi::GenericMethod ("setDefaultProperty", "@brief Method void QWizard::setDefaultProperty(const char *className, const char *property, const char *changedSignal)\n", false, &_init_f_setDefaultProperty_4977, &_call_f_setDefaultProperty_4977);
}

// void QWizard::setField(const QString &name, const QVariant &value)


static void _init_f_setField_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setField_4036 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ((QWizard *)cls)->setField (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setField_4036 ()
{
  return new qt_gsi::GenericMethod ("setField", "@brief Method void QWizard::setField(const QString &name, const QVariant &value)\n", false, &_init_f_setField_4036, &_call_f_setField_4036);
}

// void QWizard::setOption(QWizard::WizardOption option, bool on)


static void _init_f_setOption_3272 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QWizard::WizardOption>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setOption_3272 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QWizard::WizardOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QWizard::WizardOption>::target_type & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QWizard *)cls)->setOption (qt_gsi::QtToCppAdaptor<QWizard::WizardOption>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setOption_3272 ()
{
  return new qt_gsi::GenericMethod ("setOption", "@brief Method void QWizard::setOption(QWizard::WizardOption option, bool on)\n", false, &_init_f_setOption_3272, &_call_f_setOption_3272);
}

// void QWizard::setOptions(QFlags<QWizard::WizardOption> options)


static void _init_f_setOptions_3212 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options");
  decl->add_arg<const qt_gsi::Converter<QFlags<QWizard::WizardOption> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOptions_3212 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QWizard::WizardOption> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QWizard::WizardOption> >::target_type & > ();
  ((QWizard *)cls)->setOptions (qt_gsi::QtToCppAdaptor<QFlags<QWizard::WizardOption> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setOptions_3212 ()
{
  return new qt_gsi::GenericMethod ("setOptions|options=", "@brief Method void QWizard::setOptions(QFlags<QWizard::WizardOption> options)\n", false, &_init_f_setOptions_3212, &_call_f_setOptions_3212);
}

// void QWizard::setPage(int id, QWizardPage *page)


static void _init_f_setPage_2368 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("page");
  decl->add_arg<QWizardPage * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPage_2368 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QWizardPage *arg2 = args.read<QWizardPage * > ();
  ((QWizard *)cls)->setPage (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setPage_2368 ()
{
  return new qt_gsi::GenericMethod ("setPage", "@brief Method void QWizard::setPage(int id, QWizardPage *page)\n", false, &_init_f_setPage_2368, &_call_f_setPage_2368);
}

// void QWizard::setPixmap(QWizard::WizardPixmap which, const QPixmap &pixmap)


static void _init_f_setPixmap_4415 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<QWizard::WizardPixmap>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPixmap_4415 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QWizard::WizardPixmap>::target_type & arg1 = args.read<const qt_gsi::Converter<QWizard::WizardPixmap>::target_type & > ();
  const QPixmap &arg2 = args.read<const QPixmap & > ();
  ((QWizard *)cls)->setPixmap (qt_gsi::QtToCppAdaptor<QWizard::WizardPixmap>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setPixmap_4415 ()
{
  return new qt_gsi::GenericMethod ("setPixmap", "@brief Method void QWizard::setPixmap(QWizard::WizardPixmap which, const QPixmap &pixmap)\n", false, &_init_f_setPixmap_4415, &_call_f_setPixmap_4415);
}

// void QWizard::setStartId(int id)


static void _init_f_setStartId_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStartId_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QWizard *)cls)->setStartId (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStartId_767 ()
{
  return new qt_gsi::GenericMethod ("setStartId|startId=", "@brief Method void QWizard::setStartId(int id)\n", false, &_init_f_setStartId_767, &_call_f_setStartId_767);
}

// void QWizard::setSubTitleFormat(Qt::TextFormat format)


static void _init_f_setSubTitleFormat_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<Qt::TextFormat>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSubTitleFormat_1787 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::TextFormat>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::TextFormat>::target_type & > ();
  ((QWizard *)cls)->setSubTitleFormat (qt_gsi::QtToCppAdaptor<Qt::TextFormat>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setSubTitleFormat_1787 ()
{
  return new qt_gsi::GenericMethod ("setSubTitleFormat|subTitleFormat=", "@brief Method void QWizard::setSubTitleFormat(Qt::TextFormat format)\n", false, &_init_f_setSubTitleFormat_1787, &_call_f_setSubTitleFormat_1787);
}

// void QWizard::setTitleFormat(Qt::TextFormat format)


static void _init_f_setTitleFormat_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<Qt::TextFormat>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTitleFormat_1787 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::TextFormat>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::TextFormat>::target_type & > ();
  ((QWizard *)cls)->setTitleFormat (qt_gsi::QtToCppAdaptor<Qt::TextFormat>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setTitleFormat_1787 ()
{
  return new qt_gsi::GenericMethod ("setTitleFormat|titleFormat=", "@brief Method void QWizard::setTitleFormat(Qt::TextFormat format)\n", false, &_init_f_setTitleFormat_1787, &_call_f_setTitleFormat_1787);
}

// void QWizard::setVisible(bool visible)


static void _init_f_setVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisible_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QWizard *)cls)->setVisible (arg1);
}

static qt_gsi::GenericMethod *_create_f_setVisible_864 ()
{
  return new qt_gsi::GenericMethod ("setVisible|visible=", "@brief Method void QWizard::setVisible(bool visible)\nThis is a reimplementation of QDialog::setVisible", false, &_init_f_setVisible_864, &_call_f_setVisible_864);
}

// void QWizard::setWizardStyle(QWizard::WizardStyle style)


static void _init_f_setWizardStyle_2412 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("style");
  decl->add_arg<const qt_gsi::Converter<QWizard::WizardStyle>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWizardStyle_2412 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QWizard::WizardStyle>::target_type & arg1 = args.read<const qt_gsi::Converter<QWizard::WizardStyle>::target_type & > ();
  ((QWizard *)cls)->setWizardStyle (qt_gsi::QtToCppAdaptor<QWizard::WizardStyle>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setWizardStyle_2412 ()
{
  return new qt_gsi::GenericMethod ("setWizardStyle|wizardStyle=", "@brief Method void QWizard::setWizardStyle(QWizard::WizardStyle style)\n", false, &_init_f_setWizardStyle_2412, &_call_f_setWizardStyle_2412);
}

// QSize QWizard::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QWizard *)cls)->sizeHint ());
}

static qt_gsi::GenericMethod *_create_f_sizeHint_c0 ()
{
  return new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QWizard::sizeHint()\nThis is a reimplementation of QDialog::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
}

// int QWizard::startId()


static void _init_f_startId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_startId_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QWizard *)cls)->startId ());
}

static qt_gsi::GenericMethod *_create_f_startId_c0 ()
{
  return new qt_gsi::GenericMethod (":startId", "@brief Method int QWizard::startId()\n", true, &_init_f_startId_c0, &_call_f_startId_c0);
}

// Qt::TextFormat QWizard::subTitleFormat()


static void _init_f_subTitleFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::TextFormat>::target_type > ();
}

static void _call_f_subTitleFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::TextFormat>::target_type > ((qt_gsi::Converter<Qt::TextFormat>::target_type)qt_gsi::CppToQtAdaptor<Qt::TextFormat>(((QWizard *)cls)->subTitleFormat ()));
}

static qt_gsi::GenericMethod *_create_f_subTitleFormat_c0 ()
{
  return new qt_gsi::GenericMethod (":subTitleFormat", "@brief Method Qt::TextFormat QWizard::subTitleFormat()\n", true, &_init_f_subTitleFormat_c0, &_call_f_subTitleFormat_c0);
}

// bool QWizard::testOption(QWizard::WizardOption option)


static void _init_f_testOption_c2516 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QWizard::WizardOption>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testOption_c2516 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QWizard::WizardOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QWizard::WizardOption>::target_type & > ();
  ret.write<bool > ((bool)((QWizard *)cls)->testOption (qt_gsi::QtToCppAdaptor<QWizard::WizardOption>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_testOption_c2516 ()
{
  return new qt_gsi::GenericMethod ("testOption", "@brief Method bool QWizard::testOption(QWizard::WizardOption option)\n", true, &_init_f_testOption_c2516, &_call_f_testOption_c2516);
}

// Qt::TextFormat QWizard::titleFormat()


static void _init_f_titleFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::TextFormat>::target_type > ();
}

static void _call_f_titleFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::TextFormat>::target_type > ((qt_gsi::Converter<Qt::TextFormat>::target_type)qt_gsi::CppToQtAdaptor<Qt::TextFormat>(((QWizard *)cls)->titleFormat ()));
}

static qt_gsi::GenericMethod *_create_f_titleFormat_c0 ()
{
  return new qt_gsi::GenericMethod (":titleFormat", "@brief Method Qt::TextFormat QWizard::titleFormat()\n", true, &_init_f_titleFormat_c0, &_call_f_titleFormat_c0);
}

// bool QWizard::validateCurrentPage()


static void _init_f_validateCurrentPage_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_validateCurrentPage_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWizard *)cls)->validateCurrentPage ());
}

static qt_gsi::GenericMethod *_create_f_validateCurrentPage_0 ()
{
  return new qt_gsi::GenericMethod ("validateCurrentPage", "@brief Method bool QWizard::validateCurrentPage()\n", false, &_init_f_validateCurrentPage_0, &_call_f_validateCurrentPage_0);
}

// QList<int> QWizard::visitedPages()


static void _init_f_visitedPages_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<int> >::target_type > ();
}

static void _call_f_visitedPages_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<int> >::target_type > ((qt_gsi::Converter<QList<int> >::target_type)qt_gsi::CppToQtAdaptor<QList<int> >(((QWizard *)cls)->visitedPages ()));
}

static qt_gsi::GenericMethod *_create_f_visitedPages_c0 ()
{
  return new qt_gsi::GenericMethod ("visitedPages", "@brief Method QList<int> QWizard::visitedPages()\n", true, &_init_f_visitedPages_c0, &_call_f_visitedPages_c0);
}

// QWizard::WizardStyle QWizard::wizardStyle()


static void _init_f_wizardStyle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QWizard::WizardStyle>::target_type > ();
}

static void _call_f_wizardStyle_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QWizard::WizardStyle>::target_type > ((qt_gsi::Converter<QWizard::WizardStyle>::target_type)qt_gsi::CppToQtAdaptor<QWizard::WizardStyle>(((QWizard *)cls)->wizardStyle ()));
}

static qt_gsi::GenericMethod *_create_f_wizardStyle_c0 ()
{
  return new qt_gsi::GenericMethod (":wizardStyle", "@brief Method QWizard::WizardStyle QWizard::wizardStyle()\n", true, &_init_f_wizardStyle_c0, &_call_f_wizardStyle_c0);
}

// static QString QWizard::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QWizard::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QWizard::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QWizard::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QWizard::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QWizard::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QWizard::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QWizard::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QWizard::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QWizard::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QWizard::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QWizard::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QWizard, QWizard_EventAdaptor> ea_QWizard;

namespace gsi
{
extern gsi::Class<QDialog> decl_QDialog;

gsi::Class<QWizard> decl_QWizard (ea_QWizard, decl_QDialog, "QWizard_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_addPage_1709 ()) +
  gsi::Methods(_create_f_back_0 ()) +
  gsi::Methods(_create_f_button_c2519 ()) +
  gsi::Methods(_create_f_buttonText_c2519 ()) +
  gsi::Methods(_create_f_currentId_c0 ()) +
  gsi::Methods(_create_f_currentPage_c0 ()) +
  gsi::Methods(_create_f_field_c2025 ()) +
  gsi::Methods(_create_f_hasVisitedPage_c767 ()) +
  gsi::Methods(_create_f_next_0 ()) +
  gsi::Methods(_create_f_nextId_c0 ()) +
  gsi::Methods(_create_f_options_c0 ()) +
  gsi::Methods(_create_f_page_c767 ()) +
  gsi::Methods(_create_f_pageIds_c0 ()) +
  gsi::Methods(_create_f_pixmap_c2506 ()) +
  gsi::Methods(_create_f_removePage_767 ()) +
  gsi::Methods(_create_f_restart_0 ()) +
  gsi::Methods(_create_f_setButton_4570 ()) +
  gsi::Methods(_create_f_setButtonLayout_4011 ()) +
  gsi::Methods(_create_f_setButtonText_4436 ()) +
  gsi::Methods(_create_f_setDefaultProperty_4977 ()) +
  gsi::Methods(_create_f_setField_4036 ()) +
  gsi::Methods(_create_f_setOption_3272 ()) +
  gsi::Methods(_create_f_setOptions_3212 ()) +
  gsi::Methods(_create_f_setPage_2368 ()) +
  gsi::Methods(_create_f_setPixmap_4415 ()) +
  gsi::Methods(_create_f_setStartId_767 ()) +
  gsi::Methods(_create_f_setSubTitleFormat_1787 ()) +
  gsi::Methods(_create_f_setTitleFormat_1787 ()) +
  gsi::Methods(_create_f_setVisible_864 ()) +
  gsi::Methods(_create_f_setWizardStyle_2412 ()) +
  gsi::Methods(_create_f_sizeHint_c0 ()) +
  gsi::Methods(_create_f_startId_c0 ()) +
  gsi::Methods(_create_f_subTitleFormat_c0 ()) +
  gsi::Methods(_create_f_testOption_c2516 ()) +
  gsi::Methods(_create_f_titleFormat_c0 ()) +
  gsi::Methods(_create_f_validateCurrentPage_0 ()) +
  gsi::Methods(_create_f_visitedPages_c0 ()) +
  gsi::Methods(_create_f_wizardStyle_c0 ()) +
  qt_gsi::qt_signal<QWizard, QWizard_EventAdaptor> ("accepted", &QWizard_EventAdaptor::accepted_e_0, "@brief Signal declaration for QWizard::accepted()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QWizard, QWizard_EventAdaptor, int> ("currentIdChanged", &QWizard_EventAdaptor::currentIdChanged_e_767, gsi::arg("id"), "@brief Signal declaration for QWizard::currentIdChanged(int id)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QWizard, QWizard_EventAdaptor, int> ("customButtonClicked", &QWizard_EventAdaptor::customButtonClicked_e_767, gsi::arg("which"), "@brief Signal declaration for QWizard::customButtonClicked(int which)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QWizard, QWizard_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QWizard_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QWizard::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QWizard, QWizard_EventAdaptor, QObject *> ("destroyed", &QWizard_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QWizard::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QWizard, QWizard_EventAdaptor, int> ("finished", &QWizard_EventAdaptor::finished_e_767, gsi::arg("result"), "@brief Signal declaration for QWizard::finished(int result)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QWizard, QWizard_EventAdaptor> ("helpRequested", &QWizard_EventAdaptor::helpRequested_e_0, "@brief Signal declaration for QWizard::helpRequested()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QWizard, QWizard_EventAdaptor> ("rejected", &QWizard_EventAdaptor::rejected_e_0, "@brief Signal declaration for QWizard::rejected()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QWizard");
}


class QWizard_Adaptor : public QWizard, public qt_gsi::QtObjectBase
{
public:

  virtual ~QWizard_Adaptor();

  //  [adaptor ctor] QWizard::QWizard(QWidget *parent, QFlags<Qt::WindowType> flags)
  QWizard_Adaptor() : QWizard()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QWizard::QWizard(QWidget *parent, QFlags<Qt::WindowType> flags)
  QWizard_Adaptor(QWidget *parent) : QWizard(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QWizard::QWizard(QWidget *parent, QFlags<Qt::WindowType> flags)
  QWizard_Adaptor(QWidget *parent, QFlags<Qt::WindowType> flags) : QWizard(parent, flags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QWizard::adjustPosition(QWidget *)
  void fp_QWizard_adjustPosition_1315 (QWidget *arg1) {
    QWizard::adjustPosition(arg1);
  }

  //  void QWizard::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QWizard_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QWizard::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QWizard::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QWizard_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QWizard::destroy(destroyWindow, destroySubWindows);
  }

  //  bool QWizard::focusNextChild()
  bool fp_QWizard_focusNextChild_0 () {
    return QWizard::focusNextChild();
  }

  //  bool QWizard::focusPreviousChild()
  bool fp_QWizard_focusPreviousChild_0 () {
    return QWizard::focusPreviousChild();
  }

  //  int QWizard::receivers(const char *signal)
  int fp_QWizard_receivers_c1731 (const char *signal) const {
    return QWizard::receivers(signal);
  }

  //  void QWizard::resetInputContext()
  void fp_QWizard_resetInputContext_0 () {
    QWizard::resetInputContext();
  }

  //  QObject *QWizard::sender()
  QObject * fp_QWizard_sender_c0 () const {
    return QWizard::sender();
  }

  //  void QWizard::updateMicroFocus()
  void fp_QWizard_updateMicroFocus_0 () {
    QWizard::updateMicroFocus();
  }

  //  [adaptor impl] void QWizard::accept()
  void cbs_accept_0_0()
  {
    QWizard::accept();
  }

  virtual void accept()
  {
    if (cb_accept_0_0.can_issue()) {
      cb_accept_0_0.issue<QWizard_Adaptor>(&QWizard_Adaptor::cbs_accept_0_0);
    } else {
      QWizard::accept();
    }
  }

  //  [adaptor impl] int QWizard::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QWizard::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QWizard_Adaptor, int, int>(&QWizard_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QWizard::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QWizard::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QWizard::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QWizard_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QWizard_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QWizard::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QWizard::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QWizard::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QWizard_Adaptor, QSize>(&QWizard_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QWizard::minimumSizeHint();
    }
  }

  //  [adaptor impl] int QWizard::nextId()
  int cbs_nextId_c0_0() const
  {
    return QWizard::nextId();
  }

  virtual int nextId() const
  {
    if (cb_nextId_c0_0.can_issue()) {
      return cb_nextId_c0_0.issue<QWizard_Adaptor, int>(&QWizard_Adaptor::cbs_nextId_c0_0);
    } else {
      return QWizard::nextId();
    }
  }

  //  [adaptor impl] QPaintEngine *QWizard::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QWizard::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QWizard_Adaptor, QPaintEngine *>(&QWizard_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QWizard::paintEngine();
    }
  }

  //  [adaptor impl] void QWizard::reject()
  void cbs_reject_0_0()
  {
    QWizard::reject();
  }

  virtual void reject()
  {
    if (cb_reject_0_0.can_issue()) {
      cb_reject_0_0.issue<QWizard_Adaptor>(&QWizard_Adaptor::cbs_reject_0_0);
    } else {
      QWizard::reject();
    }
  }

  //  [adaptor impl] void QWizard::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QWizard::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QWizard_Adaptor, bool>(&QWizard_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QWizard::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QWizard::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QWizard::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QWizard_Adaptor, QSize>(&QWizard_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QWizard::sizeHint();
    }
  }

  //  [adaptor impl] bool QWizard::validateCurrentPage()
  bool cbs_validateCurrentPage_0_0()
  {
    return QWizard::validateCurrentPage();
  }

  virtual bool validateCurrentPage()
  {
    if (cb_validateCurrentPage_0_0.can_issue()) {
      return cb_validateCurrentPage_0_0.issue<QWizard_Adaptor, bool>(&QWizard_Adaptor::cbs_validateCurrentPage_0_0);
    } else {
      return QWizard::validateCurrentPage();
    }
  }

  //  [adaptor impl] void QWizard::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QWizard::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QWizard_Adaptor, QActionEvent *>(&QWizard_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QWizard::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QWizard::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QWizard_Adaptor, QEvent *>(&QWizard_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QWizard::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QWizard::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QWizard_Adaptor, QChildEvent *>(&QWizard_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QWizard::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::cleanupPage(int id)
  void cbs_cleanupPage_767_0(int id)
  {
    QWizard::cleanupPage(id);
  }

  virtual void cleanupPage(int id)
  {
    if (cb_cleanupPage_767_0.can_issue()) {
      cb_cleanupPage_767_0.issue<QWizard_Adaptor, int>(&QWizard_Adaptor::cbs_cleanupPage_767_0, id);
    } else {
      QWizard::cleanupPage(id);
    }
  }

  //  [adaptor impl] void QWizard::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QWizard::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QWizard_Adaptor, QCloseEvent *>(&QWizard_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QWizard::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QWizard::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QWizard_Adaptor, QContextMenuEvent *>(&QWizard_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QWizard::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QWizard::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QWizard_Adaptor, QEvent *>(&QWizard_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QWizard::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QWizard::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QWizard_Adaptor, const char *>(&QWizard_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QWizard::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QWizard::done(int result)
  void cbs_done_767_0(int result)
  {
    QWizard::done(result);
  }

  virtual void done(int result)
  {
    if (cb_done_767_0.can_issue()) {
      cb_done_767_0.issue<QWizard_Adaptor, int>(&QWizard_Adaptor::cbs_done_767_0, result);
    } else {
      QWizard::done(result);
    }
  }

  //  [adaptor impl] void QWizard::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QWizard::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QWizard_Adaptor, QDragEnterEvent *>(&QWizard_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QWizard::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QWizard::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QWizard_Adaptor, QDragLeaveEvent *>(&QWizard_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QWizard::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QWizard::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QWizard_Adaptor, QDragMoveEvent *>(&QWizard_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QWizard::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QWizard::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QWizard_Adaptor, QDropEvent *>(&QWizard_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QWizard::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QWizard::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QWizard_Adaptor, bool>(&QWizard_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QWizard::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QWizard::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QWizard::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QWizard_Adaptor, QEvent *>(&QWizard_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QWizard::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QWizard::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QWizard::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QWizard_Adaptor, bool, QEvent *>(&QWizard_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QWizard::event(_event);
    }
  }

  //  [adaptor impl] bool QWizard::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QWizard::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QWizard_Adaptor, bool, QObject *, QEvent *>(&QWizard_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QWizard::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QWizard::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QWizard::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QWizard_Adaptor, QFocusEvent *>(&QWizard_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QWizard::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] bool QWizard::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QWizard::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QWizard_Adaptor, bool, bool>(&QWizard_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QWizard::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QWizard::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QWizard::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QWizard_Adaptor, QFocusEvent *>(&QWizard_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QWizard::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QWizard::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QWizard_Adaptor, const QFont &>(&QWizard_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QWizard::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QWizard::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QWizard::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QWizard_Adaptor, QHideEvent *>(&QWizard_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QWizard::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::initializePage(int id)
  void cbs_initializePage_767_0(int id)
  {
    QWizard::initializePage(id);
  }

  virtual void initializePage(int id)
  {
    if (cb_initializePage_767_0.can_issue()) {
      cb_initializePage_767_0.issue<QWizard_Adaptor, int>(&QWizard_Adaptor::cbs_initializePage_767_0, id);
    } else {
      QWizard::initializePage(id);
    }
  }

  //  [adaptor impl] void QWizard::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QWizard::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QWizard_Adaptor, QInputMethodEvent *>(&QWizard_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QWizard::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QWizard::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QWizard_Adaptor, QKeyEvent *>(&QWizard_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QWizard::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QWizard::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QWizard_Adaptor, QKeyEvent *>(&QWizard_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QWizard::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::languageChange()
  void cbs_languageChange_0_0()
  {
    QWizard::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QWizard_Adaptor>(&QWizard_Adaptor::cbs_languageChange_0_0);
    } else {
      QWizard::languageChange();
    }
  }

  //  [adaptor impl] void QWizard::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QWizard::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QWizard_Adaptor, QEvent *>(&QWizard_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QWizard::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QWizard::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QWizard::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QWizard_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QWizard_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QWizard::metric(arg1);
    }
  }

  //  [adaptor impl] void QWizard::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QWizard::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QWizard_Adaptor, QMouseEvent *>(&QWizard_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QWizard::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QWizard::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QWizard_Adaptor, QMouseEvent *>(&QWizard_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QWizard::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QWizard::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QWizard_Adaptor, QMouseEvent *>(&QWizard_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QWizard::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QWizard::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QWizard_Adaptor, QMouseEvent *>(&QWizard_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QWizard::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QWizard::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QWizard_Adaptor, QMoveEvent *>(&QWizard_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QWizard::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::paintEvent(QPaintEvent *event)
  void cbs_paintEvent_1725_0(QPaintEvent *event)
  {
    QWizard::paintEvent(event);
  }

  virtual void paintEvent(QPaintEvent *event)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QWizard_Adaptor, QPaintEvent *>(&QWizard_Adaptor::cbs_paintEvent_1725_0, event);
    } else {
      QWizard::paintEvent(event);
    }
  }

  //  [adaptor impl] void QWizard::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QWizard::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QWizard_Adaptor, const QPalette &>(&QWizard_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QWizard::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QWizard::resizeEvent(QResizeEvent *event)
  void cbs_resizeEvent_1843_0(QResizeEvent *event)
  {
    QWizard::resizeEvent(event);
  }

  virtual void resizeEvent(QResizeEvent *event)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QWizard_Adaptor, QResizeEvent *>(&QWizard_Adaptor::cbs_resizeEvent_1843_0, event);
    } else {
      QWizard::resizeEvent(event);
    }
  }

  //  [adaptor impl] void QWizard::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QWizard::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QWizard_Adaptor, QShowEvent *>(&QWizard_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QWizard::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QWizard::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QWizard_Adaptor, QStyle &>(&QWizard_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QWizard::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QWizard::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QWizard::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QWizard_Adaptor, QTabletEvent *>(&QWizard_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QWizard::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QWizard::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QWizard_Adaptor, QTimerEvent *>(&QWizard_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QWizard::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QWizard::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QWizard_Adaptor, QWheelEvent *>(&QWizard_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QWizard::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QWizard::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QWizard::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QWizard_Adaptor, bool>(&QWizard_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QWizard::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_accept_0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_nextId_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_reject_0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_validateCurrentPage_0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_cleanupPage_767_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_done_767_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initializePage_767_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QWizard_Adaptor::~QWizard_Adaptor() { }

//  Constructor QWizard::QWizard(QWidget *parent, QFlags<Qt::WindowType> flags) (adaptor class)

static void _init_ctor_QWizard_Adaptor_3702 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_1);
  decl->set_return_new<QWizard_Adaptor *> ();
}

static void _call_ctor_QWizard_Adaptor_3702 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::WindowType> >(heap, 0));
  ret.write<QWizard_Adaptor *> (new QWizard_Adaptor (arg1, qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QWizard_Adaptor_3702 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QWizard::QWizard(QWidget *parent, QFlags<Qt::WindowType> flags)\nThis method creates an object of class QWizard.", &_init_ctor_QWizard_Adaptor_3702, &_call_ctor_QWizard_Adaptor_3702);
}

// void QWizard::adjustPosition(QWidget *)

static void _init_fp_adjustPosition_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_adjustPosition_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QWizard_Adaptor *)cls)->fp_QWizard_adjustPosition_1315 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_adjustPosition_1315 ()
{
  return new qt_gsi::GenericMethod("*adjustPosition", "@brief Method void QWizard::adjustPosition(QWidget *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_adjustPosition_1315, &_call_fp_adjustPosition_1315);
}


// void QWizard::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QWizard_Adaptor *)cls)->fp_QWizard_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QWizard::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QWizard::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QWizard_Adaptor *)cls)->fp_QWizard_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QWizard::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// bool QWizard::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWizard_Adaptor *)cls)->fp_QWizard_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QWizard::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QWizard::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWizard_Adaptor *)cls)->fp_QWizard_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QWizard::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// int QWizard::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QWizard_Adaptor *)cls)->fp_QWizard_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QWizard::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QWizard::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWizard_Adaptor *)cls)->fp_QWizard_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QWizard::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// QObject *QWizard::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QWizard_Adaptor *)cls)->fp_QWizard_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QWizard::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QWizard::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWizard_Adaptor *)cls)->fp_QWizard_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QWizard::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// void QWizard::accept()

static void _init_cbs_accept_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_accept_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWizard_Adaptor *)cls)->cbs_accept_0_0 ();
}

static void _set_callback_cbs_accept_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_accept_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_accept_0_0 ()
{
  return new qt_gsi::GenericMethod ("accept", "@hide", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_accept_0_0 ()
{
  return new qt_gsi::GenericMethod ("accept", "@brief Virtual method void QWizard::accept()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0, &_set_callback_cbs_accept_0_0);
}


// int QWizard::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QWizard_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QWizard::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// QVariant QWizard::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QWizard_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QWizard::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// QSize QWizard::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QWizard_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QWizard::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// int QWizard::nextId()

static void _init_cbs_nextId_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_nextId_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QWizard_Adaptor *)cls)->cbs_nextId_c0_0 ());
}

static void _set_callback_cbs_nextId_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_nextId_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_nextId_c0_0 ()
{
  return new qt_gsi::GenericMethod ("nextId", "@hide", true, &_init_cbs_nextId_c0_0, &_call_cbs_nextId_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_nextId_c0_0 ()
{
  return new qt_gsi::GenericMethod ("nextId", "@brief Virtual method int QWizard::nextId()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_nextId_c0_0, &_call_cbs_nextId_c0_0, &_set_callback_cbs_nextId_c0_0);
}


// QPaintEngine *QWizard::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QWizard_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QWizard::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QWizard::reject()

static void _init_cbs_reject_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reject_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWizard_Adaptor *)cls)->cbs_reject_0_0 ();
}

static void _set_callback_cbs_reject_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_reject_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_reject_0_0 ()
{
  return new qt_gsi::GenericMethod ("reject", "@hide", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_reject_0_0 ()
{
  return new qt_gsi::GenericMethod ("reject", "@brief Virtual method void QWizard::reject()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0, &_set_callback_cbs_reject_0_0);
}


// void QWizard::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QWizard_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QWizard::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// QSize QWizard::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QWizard_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QWizard::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// bool QWizard::validateCurrentPage()

static void _init_cbs_validateCurrentPage_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_validateCurrentPage_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QWizard_Adaptor *)cls)->cbs_validateCurrentPage_0_0 ());
}

static void _set_callback_cbs_validateCurrentPage_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_validateCurrentPage_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_validateCurrentPage_0_0 ()
{
  return new qt_gsi::GenericMethod ("validateCurrentPage", "@hide", false, &_init_cbs_validateCurrentPage_0_0, &_call_cbs_validateCurrentPage_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_validateCurrentPage_0_0 ()
{
  return new qt_gsi::GenericMethod ("validateCurrentPage", "@brief Virtual method bool QWizard::validateCurrentPage()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_validateCurrentPage_0_0, &_call_cbs_validateCurrentPage_0_0, &_set_callback_cbs_validateCurrentPage_0_0);
}


// void QWizard::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QWizard::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QWizard::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QWizard::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QWizard::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QWizard::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QWizard::cleanupPage(int id)

static void _init_cbs_cleanupPage_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_cleanupPage_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QWizard_Adaptor *)cls)->cbs_cleanupPage_767_0 (arg1);
}

static void _set_callback_cbs_cleanupPage_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_cleanupPage_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_cleanupPage_767_0 ()
{
  return new qt_gsi::GenericMethod ("*cleanupPage", "@hide", false, &_init_cbs_cleanupPage_767_0, &_call_cbs_cleanupPage_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_cleanupPage_767_0 ()
{
  return new qt_gsi::GenericMethod ("*cleanupPage", "@brief Virtual method void QWizard::cleanupPage(int id)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_cleanupPage_767_0, &_call_cbs_cleanupPage_767_0, &_set_callback_cbs_cleanupPage_767_0);
}


// void QWizard::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QWizard::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QWizard::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QWizard::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QWizard::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QWizard::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QWizard::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QWizard_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QWizard::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QWizard::done(int result)

static void _init_cbs_done_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("result");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_done_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QWizard_Adaptor *)cls)->cbs_done_767_0 (arg1);
}

static void _set_callback_cbs_done_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_done_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_done_767_0 ()
{
  return new qt_gsi::GenericMethod ("*done", "@hide", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_done_767_0 ()
{
  return new qt_gsi::GenericMethod ("*done", "@brief Virtual method void QWizard::done(int result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0, &_set_callback_cbs_done_767_0);
}


// void QWizard::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QWizard::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QWizard::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QWizard::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QWizard::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QWizard::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// void QWizard::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QWizard::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// void QWizard::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QWizard_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QWizard::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QWizard::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QWizard::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// bool QWizard::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QWizard_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QWizard::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QWizard::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QWizard_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QWizard::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QWizard::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QWizard::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QWizard::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QWizard_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QWizard::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QWizard::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QWizard::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QWizard::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QWizard_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QWizard::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QWizard::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QWizard::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// void QWizard::initializePage(int id)

static void _init_cbs_initializePage_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initializePage_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QWizard_Adaptor *)cls)->cbs_initializePage_767_0 (arg1);
}

static void _set_callback_cbs_initializePage_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_initializePage_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_initializePage_767_0 ()
{
  return new qt_gsi::GenericMethod ("*initializePage", "@hide", false, &_init_cbs_initializePage_767_0, &_call_cbs_initializePage_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_initializePage_767_0 ()
{
  return new qt_gsi::GenericMethod ("*initializePage", "@brief Virtual method void QWizard::initializePage(int id)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_initializePage_767_0, &_call_cbs_initializePage_767_0, &_set_callback_cbs_initializePage_767_0);
}


// void QWizard::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QWizard::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// void QWizard::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QWizard::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QWizard::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QWizard::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QWizard::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QWizard_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QWizard::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QWizard::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QWizard::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QWizard::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QWizard_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QWizard::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// void QWizard::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QWizard::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QWizard::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QWizard::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QWizard::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QWizard::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QWizard::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QWizard::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// void QWizard::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QWizard::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QWizard::paintEvent(QPaintEvent *event)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QWizard::paintEvent(QPaintEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QWizard::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QWizard_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QWizard::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QWizard::resizeEvent(QResizeEvent *event)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QWizard::resizeEvent(QResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QWizard::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QWizard::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// void QWizard::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QWizard_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QWizard::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// void QWizard::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QWizard::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QWizard::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QWizard::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QWizard::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QWizard_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QWizard::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QWizard::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QWizard_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QWizard_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QWizard::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QWizard> decl_QWizard;

gsi::Class<QWizard_Adaptor> decl_QWizard_Adaptor (decl_QWizard, "QWizard",
  gsi::Methods(_create_fp_adjustPosition_1315 ()) +
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_cbs_accept_0_0 ()) +
  gsi::Methods(_create_callback_cbs_accept_0_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_nextId_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_nextId_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_reject_0_0 ()) +
  gsi::Methods(_create_callback_cbs_reject_0_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_validateCurrentPage_0_0 ()) +
  gsi::Methods(_create_callback_cbs_validateCurrentPage_0_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_cleanupPage_767_0 ()) +
  gsi::Methods(_create_callback_cbs_cleanupPage_767_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_done_767_0 ()) +
  gsi::Methods(_create_callback_cbs_done_767_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_initializePage_767_0 ()) +
  gsi::Methods(_create_callback_cbs_initializePage_767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QWizard_Adaptor_3702 ()),
  "@qt\n@brief Binding of QWizard");

}


//  Implementation of the enum wrapper class for QWizard::WizardButton
namespace qt_gsi
{

static QWizard_WizardButton_Enum *c_1_QWizard_WizardButton_Enum () { return new QWizard_WizardButton_Enum (QWizard::BackButton); }
static QWizard_WizardButton_Enum *c_2_QWizard_WizardButton_Enum () { return new QWizard_WizardButton_Enum (QWizard::NextButton); }
static QWizard_WizardButton_Enum *c_3_QWizard_WizardButton_Enum () { return new QWizard_WizardButton_Enum (QWizard::CommitButton); }
static QWizard_WizardButton_Enum *c_4_QWizard_WizardButton_Enum () { return new QWizard_WizardButton_Enum (QWizard::FinishButton); }
static QWizard_WizardButton_Enum *c_5_QWizard_WizardButton_Enum () { return new QWizard_WizardButton_Enum (QWizard::CancelButton); }
static QWizard_WizardButton_Enum *c_6_QWizard_WizardButton_Enum () { return new QWizard_WizardButton_Enum (QWizard::HelpButton); }
static QWizard_WizardButton_Enum *c_7_QWizard_WizardButton_Enum () { return new QWizard_WizardButton_Enum (QWizard::CustomButton1); }
static QWizard_WizardButton_Enum *c_8_QWizard_WizardButton_Enum () { return new QWizard_WizardButton_Enum (QWizard::CustomButton2); }
static QWizard_WizardButton_Enum *c_9_QWizard_WizardButton_Enum () { return new QWizard_WizardButton_Enum (QWizard::CustomButton3); }
static QWizard_WizardButton_Enum *c_10_QWizard_WizardButton_Enum () { return new QWizard_WizardButton_Enum (QWizard::Stretch); }
static QWizard_WizardButton_Enum *c_11_QWizard_WizardButton_Enum () { return new QWizard_WizardButton_Enum (QWizard::NoButton); }
static QWizard_WizardButton_Enum *c_12_QWizard_WizardButton_Enum () { return new QWizard_WizardButton_Enum (QWizard::NStandardButtons); }
static QWizard_WizardButton_Enum *c_13_QWizard_WizardButton_Enum () { return new QWizard_WizardButton_Enum (QWizard::NButtons); }

static gsi::Methods mkdefs_QWizard_WizardButton () {
  return
    gsi::constant ("BackButton", &qt_gsi::c_1_QWizard_WizardButton_Enum, "@brief Enum constant QWizard::BackButton") +
    gsi::constant ("NextButton", &qt_gsi::c_2_QWizard_WizardButton_Enum, "@brief Enum constant QWizard::NextButton") +
    gsi::constant ("CommitButton", &qt_gsi::c_3_QWizard_WizardButton_Enum, "@brief Enum constant QWizard::CommitButton") +
    gsi::constant ("FinishButton", &qt_gsi::c_4_QWizard_WizardButton_Enum, "@brief Enum constant QWizard::FinishButton") +
    gsi::constant ("CancelButton", &qt_gsi::c_5_QWizard_WizardButton_Enum, "@brief Enum constant QWizard::CancelButton") +
    gsi::constant ("HelpButton", &qt_gsi::c_6_QWizard_WizardButton_Enum, "@brief Enum constant QWizard::HelpButton") +
    gsi::constant ("CustomButton1", &qt_gsi::c_7_QWizard_WizardButton_Enum, "@brief Enum constant QWizard::CustomButton1") +
    gsi::constant ("CustomButton2", &qt_gsi::c_8_QWizard_WizardButton_Enum, "@brief Enum constant QWizard::CustomButton2") +
    gsi::constant ("CustomButton3", &qt_gsi::c_9_QWizard_WizardButton_Enum, "@brief Enum constant QWizard::CustomButton3") +
    gsi::constant ("Stretch", &qt_gsi::c_10_QWizard_WizardButton_Enum, "@brief Enum constant QWizard::Stretch") +
    gsi::constant ("NoButton", &qt_gsi::c_11_QWizard_WizardButton_Enum, "@brief Enum constant QWizard::NoButton") +
    gsi::constant ("NStandardButtons", &qt_gsi::c_12_QWizard_WizardButton_Enum, "@brief Enum constant QWizard::NStandardButtons") +
    gsi::constant ("NButtons", &qt_gsi::c_13_QWizard_WizardButton_Enum, "@brief Enum constant QWizard::NButtons");
}

static std::string to_s_QWizard_WizardButton_Enum (const QWizard_WizardButton_Enum *e)
{
  if (e->value () == QWizard::BackButton) { return tl::sprintf ("BackButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::NextButton) { return tl::sprintf ("NextButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::CommitButton) { return tl::sprintf ("CommitButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::FinishButton) { return tl::sprintf ("FinishButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::CancelButton) { return tl::sprintf ("CancelButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::HelpButton) { return tl::sprintf ("HelpButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::CustomButton1) { return tl::sprintf ("CustomButton1 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::CustomButton2) { return tl::sprintf ("CustomButton2 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::CustomButton3) { return tl::sprintf ("CustomButton3 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::Stretch) { return tl::sprintf ("Stretch (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::NoButton) { return tl::sprintf ("NoButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::NStandardButtons) { return tl::sprintf ("NStandardButtons (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::NButtons) { return tl::sprintf ("NButtons (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QWizard_WizardButton_Enum (const QWizard_WizardButton_Enum *e)
{
  return (unsigned int) e->value ();
}

static QWizard_WizardButton_Enum *from_i_QWizard_WizardButton_Enum (unsigned int i)
{
  return new QWizard_WizardButton_Enum ((QWizard::WizardButton) i);
}

static bool equalQWizard_WizardButton_Enum (const QWizard_WizardButton_Enum *e, QWizard_WizardButton_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QWizard_WizardButton_Enum (const QWizard_WizardButton_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QWizard_WizardButton_Enums oropQWizard_WizardButton_Enums (const QWizard_WizardButton_Enums *e, const QWizard_WizardButton_Enums &d)
{
  return e->flags () | d.flags ();
}

static QWizard_WizardButton_Enums andopQWizard_WizardButton_Enums (const QWizard_WizardButton_Enums *e, const QWizard_WizardButton_Enums &d)
{
  return e->flags () & d.flags ();
}

static QWizard_WizardButton_Enums xoropQWizard_WizardButton_Enums (const QWizard_WizardButton_Enums *e, const QWizard_WizardButton_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QWizard_WizardButton_Enums (const QWizard_WizardButton_Enums *e)
{
  std::string l;
  if (e->testFlag (QWizard::BackButton)) { if (!l.empty ()) l += "|"; l += "BackButton"; }
  if (e->testFlag (QWizard::NextButton)) { if (!l.empty ()) l += "|"; l += "NextButton"; }
  if (e->testFlag (QWizard::CommitButton)) { if (!l.empty ()) l += "|"; l += "CommitButton"; }
  if (e->testFlag (QWizard::FinishButton)) { if (!l.empty ()) l += "|"; l += "FinishButton"; }
  if (e->testFlag (QWizard::CancelButton)) { if (!l.empty ()) l += "|"; l += "CancelButton"; }
  if (e->testFlag (QWizard::HelpButton)) { if (!l.empty ()) l += "|"; l += "HelpButton"; }
  if (e->testFlag (QWizard::CustomButton1)) { if (!l.empty ()) l += "|"; l += "CustomButton1"; }
  if (e->testFlag (QWizard::CustomButton2)) { if (!l.empty ()) l += "|"; l += "CustomButton2"; }
  if (e->testFlag (QWizard::CustomButton3)) { if (!l.empty ()) l += "|"; l += "CustomButton3"; }
  if (e->testFlag (QWizard::Stretch)) { if (!l.empty ()) l += "|"; l += "Stretch"; }
  if (e->testFlag (QWizard::NoButton)) { if (!l.empty ()) l += "|"; l += "NoButton"; }
  if (e->testFlag (QWizard::NStandardButtons)) { if (!l.empty ()) l += "|"; l += "NStandardButtons"; }
  if (e->testFlag (QWizard::NButtons)) { if (!l.empty ()) l += "|"; l += "NButtons"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QWizard_WizardButton_Enums (const QWizard_WizardButton_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QWizard_WizardButton_Enums (const QWizard_WizardButton_Enums *e, const QWizard_WizardButton_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QWizard_WizardButton_Enums> decl_QWizard_WizardButton_Enums ("QWizard_QFlags_WizardButton",
  gsi::method_ext ("|", &qt_gsi::oropQWizard_WizardButton_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQWizard_WizardButton_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQWizard_WizardButton_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QWizard_WizardButton_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QWizard_WizardButton_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QWizard_WizardButton_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QWizard::WizardButton> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QWizard_WizardButton_Enum> decl_QWizard_WizardButton_Enum (decl_QWizard_WizardButton_Enums, "QWizard_WizardButton",
  qt_gsi::mkdefs_QWizard_WizardButton () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QWizard_WizardButton_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QWizard_WizardButton_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQWizard_WizardButton_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QWizard_WizardButton_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QWizard_WizardButton_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QWizard::WizardButton enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QWizard> inject_QWizard_WizardButton_Enum_in_parent (qt_gsi::mkdefs_QWizard_WizardButton ());
static gsi::ClassExt<QWizard> decl_QWizard_WizardButton_Enum_as_child (decl_QWizard_WizardButton_Enum, "WizardButton");

}


//  Implementation of the enum wrapper class for QWizard::WizardOption
namespace qt_gsi
{

static QWizard_WizardOption_Enum *c_1_QWizard_WizardOption_Enum () { return new QWizard_WizardOption_Enum (QWizard::IndependentPages); }
static QWizard_WizardOption_Enum *c_2_QWizard_WizardOption_Enum () { return new QWizard_WizardOption_Enum (QWizard::IgnoreSubTitles); }
static QWizard_WizardOption_Enum *c_3_QWizard_WizardOption_Enum () { return new QWizard_WizardOption_Enum (QWizard::ExtendedWatermarkPixmap); }
static QWizard_WizardOption_Enum *c_4_QWizard_WizardOption_Enum () { return new QWizard_WizardOption_Enum (QWizard::NoDefaultButton); }
static QWizard_WizardOption_Enum *c_5_QWizard_WizardOption_Enum () { return new QWizard_WizardOption_Enum (QWizard::NoBackButtonOnStartPage); }
static QWizard_WizardOption_Enum *c_6_QWizard_WizardOption_Enum () { return new QWizard_WizardOption_Enum (QWizard::NoBackButtonOnLastPage); }
static QWizard_WizardOption_Enum *c_7_QWizard_WizardOption_Enum () { return new QWizard_WizardOption_Enum (QWizard::DisabledBackButtonOnLastPage); }
static QWizard_WizardOption_Enum *c_8_QWizard_WizardOption_Enum () { return new QWizard_WizardOption_Enum (QWizard::HaveNextButtonOnLastPage); }
static QWizard_WizardOption_Enum *c_9_QWizard_WizardOption_Enum () { return new QWizard_WizardOption_Enum (QWizard::HaveFinishButtonOnEarlyPages); }
static QWizard_WizardOption_Enum *c_10_QWizard_WizardOption_Enum () { return new QWizard_WizardOption_Enum (QWizard::NoCancelButton); }
static QWizard_WizardOption_Enum *c_11_QWizard_WizardOption_Enum () { return new QWizard_WizardOption_Enum (QWizard::CancelButtonOnLeft); }
static QWizard_WizardOption_Enum *c_12_QWizard_WizardOption_Enum () { return new QWizard_WizardOption_Enum (QWizard::HaveHelpButton); }
static QWizard_WizardOption_Enum *c_13_QWizard_WizardOption_Enum () { return new QWizard_WizardOption_Enum (QWizard::HelpButtonOnRight); }
static QWizard_WizardOption_Enum *c_14_QWizard_WizardOption_Enum () { return new QWizard_WizardOption_Enum (QWizard::HaveCustomButton1); }
static QWizard_WizardOption_Enum *c_15_QWizard_WizardOption_Enum () { return new QWizard_WizardOption_Enum (QWizard::HaveCustomButton2); }
static QWizard_WizardOption_Enum *c_16_QWizard_WizardOption_Enum () { return new QWizard_WizardOption_Enum (QWizard::HaveCustomButton3); }

static gsi::Methods mkdefs_QWizard_WizardOption () {
  return
    gsi::constant ("IndependentPages", &qt_gsi::c_1_QWizard_WizardOption_Enum, "@brief Enum constant QWizard::IndependentPages") +
    gsi::constant ("IgnoreSubTitles", &qt_gsi::c_2_QWizard_WizardOption_Enum, "@brief Enum constant QWizard::IgnoreSubTitles") +
    gsi::constant ("ExtendedWatermarkPixmap", &qt_gsi::c_3_QWizard_WizardOption_Enum, "@brief Enum constant QWizard::ExtendedWatermarkPixmap") +
    gsi::constant ("NoDefaultButton", &qt_gsi::c_4_QWizard_WizardOption_Enum, "@brief Enum constant QWizard::NoDefaultButton") +
    gsi::constant ("NoBackButtonOnStartPage", &qt_gsi::c_5_QWizard_WizardOption_Enum, "@brief Enum constant QWizard::NoBackButtonOnStartPage") +
    gsi::constant ("NoBackButtonOnLastPage", &qt_gsi::c_6_QWizard_WizardOption_Enum, "@brief Enum constant QWizard::NoBackButtonOnLastPage") +
    gsi::constant ("DisabledBackButtonOnLastPage", &qt_gsi::c_7_QWizard_WizardOption_Enum, "@brief Enum constant QWizard::DisabledBackButtonOnLastPage") +
    gsi::constant ("HaveNextButtonOnLastPage", &qt_gsi::c_8_QWizard_WizardOption_Enum, "@brief Enum constant QWizard::HaveNextButtonOnLastPage") +
    gsi::constant ("HaveFinishButtonOnEarlyPages", &qt_gsi::c_9_QWizard_WizardOption_Enum, "@brief Enum constant QWizard::HaveFinishButtonOnEarlyPages") +
    gsi::constant ("NoCancelButton", &qt_gsi::c_10_QWizard_WizardOption_Enum, "@brief Enum constant QWizard::NoCancelButton") +
    gsi::constant ("CancelButtonOnLeft", &qt_gsi::c_11_QWizard_WizardOption_Enum, "@brief Enum constant QWizard::CancelButtonOnLeft") +
    gsi::constant ("HaveHelpButton", &qt_gsi::c_12_QWizard_WizardOption_Enum, "@brief Enum constant QWizard::HaveHelpButton") +
    gsi::constant ("HelpButtonOnRight", &qt_gsi::c_13_QWizard_WizardOption_Enum, "@brief Enum constant QWizard::HelpButtonOnRight") +
    gsi::constant ("HaveCustomButton1", &qt_gsi::c_14_QWizard_WizardOption_Enum, "@brief Enum constant QWizard::HaveCustomButton1") +
    gsi::constant ("HaveCustomButton2", &qt_gsi::c_15_QWizard_WizardOption_Enum, "@brief Enum constant QWizard::HaveCustomButton2") +
    gsi::constant ("HaveCustomButton3", &qt_gsi::c_16_QWizard_WizardOption_Enum, "@brief Enum constant QWizard::HaveCustomButton3");
}

static std::string to_s_QWizard_WizardOption_Enum (const QWizard_WizardOption_Enum *e)
{
  if (e->value () == QWizard::IndependentPages) { return tl::sprintf ("IndependentPages (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::IgnoreSubTitles) { return tl::sprintf ("IgnoreSubTitles (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::ExtendedWatermarkPixmap) { return tl::sprintf ("ExtendedWatermarkPixmap (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::NoDefaultButton) { return tl::sprintf ("NoDefaultButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::NoBackButtonOnStartPage) { return tl::sprintf ("NoBackButtonOnStartPage (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::NoBackButtonOnLastPage) { return tl::sprintf ("NoBackButtonOnLastPage (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::DisabledBackButtonOnLastPage) { return tl::sprintf ("DisabledBackButtonOnLastPage (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::HaveNextButtonOnLastPage) { return tl::sprintf ("HaveNextButtonOnLastPage (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::HaveFinishButtonOnEarlyPages) { return tl::sprintf ("HaveFinishButtonOnEarlyPages (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::NoCancelButton) { return tl::sprintf ("NoCancelButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::CancelButtonOnLeft) { return tl::sprintf ("CancelButtonOnLeft (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::HaveHelpButton) { return tl::sprintf ("HaveHelpButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::HelpButtonOnRight) { return tl::sprintf ("HelpButtonOnRight (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::HaveCustomButton1) { return tl::sprintf ("HaveCustomButton1 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::HaveCustomButton2) { return tl::sprintf ("HaveCustomButton2 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::HaveCustomButton3) { return tl::sprintf ("HaveCustomButton3 (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QWizard_WizardOption_Enum (const QWizard_WizardOption_Enum *e)
{
  return (unsigned int) e->value ();
}

static QWizard_WizardOption_Enum *from_i_QWizard_WizardOption_Enum (unsigned int i)
{
  return new QWizard_WizardOption_Enum ((QWizard::WizardOption) i);
}

static bool equalQWizard_WizardOption_Enum (const QWizard_WizardOption_Enum *e, QWizard_WizardOption_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QWizard_WizardOption_Enum (const QWizard_WizardOption_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QWizard_WizardOption_Enums oropQWizard_WizardOption_Enums (const QWizard_WizardOption_Enums *e, const QWizard_WizardOption_Enums &d)
{
  return e->flags () | d.flags ();
}

static QWizard_WizardOption_Enums andopQWizard_WizardOption_Enums (const QWizard_WizardOption_Enums *e, const QWizard_WizardOption_Enums &d)
{
  return e->flags () & d.flags ();
}

static QWizard_WizardOption_Enums xoropQWizard_WizardOption_Enums (const QWizard_WizardOption_Enums *e, const QWizard_WizardOption_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QWizard_WizardOption_Enums (const QWizard_WizardOption_Enums *e)
{
  std::string l;
  if (e->testFlag (QWizard::IndependentPages)) { if (!l.empty ()) l += "|"; l += "IndependentPages"; }
  if (e->testFlag (QWizard::IgnoreSubTitles)) { if (!l.empty ()) l += "|"; l += "IgnoreSubTitles"; }
  if (e->testFlag (QWizard::ExtendedWatermarkPixmap)) { if (!l.empty ()) l += "|"; l += "ExtendedWatermarkPixmap"; }
  if (e->testFlag (QWizard::NoDefaultButton)) { if (!l.empty ()) l += "|"; l += "NoDefaultButton"; }
  if (e->testFlag (QWizard::NoBackButtonOnStartPage)) { if (!l.empty ()) l += "|"; l += "NoBackButtonOnStartPage"; }
  if (e->testFlag (QWizard::NoBackButtonOnLastPage)) { if (!l.empty ()) l += "|"; l += "NoBackButtonOnLastPage"; }
  if (e->testFlag (QWizard::DisabledBackButtonOnLastPage)) { if (!l.empty ()) l += "|"; l += "DisabledBackButtonOnLastPage"; }
  if (e->testFlag (QWizard::HaveNextButtonOnLastPage)) { if (!l.empty ()) l += "|"; l += "HaveNextButtonOnLastPage"; }
  if (e->testFlag (QWizard::HaveFinishButtonOnEarlyPages)) { if (!l.empty ()) l += "|"; l += "HaveFinishButtonOnEarlyPages"; }
  if (e->testFlag (QWizard::NoCancelButton)) { if (!l.empty ()) l += "|"; l += "NoCancelButton"; }
  if (e->testFlag (QWizard::CancelButtonOnLeft)) { if (!l.empty ()) l += "|"; l += "CancelButtonOnLeft"; }
  if (e->testFlag (QWizard::HaveHelpButton)) { if (!l.empty ()) l += "|"; l += "HaveHelpButton"; }
  if (e->testFlag (QWizard::HelpButtonOnRight)) { if (!l.empty ()) l += "|"; l += "HelpButtonOnRight"; }
  if (e->testFlag (QWizard::HaveCustomButton1)) { if (!l.empty ()) l += "|"; l += "HaveCustomButton1"; }
  if (e->testFlag (QWizard::HaveCustomButton2)) { if (!l.empty ()) l += "|"; l += "HaveCustomButton2"; }
  if (e->testFlag (QWizard::HaveCustomButton3)) { if (!l.empty ()) l += "|"; l += "HaveCustomButton3"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QWizard_WizardOption_Enums (const QWizard_WizardOption_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QWizard_WizardOption_Enums (const QWizard_WizardOption_Enums *e, const QWizard_WizardOption_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QWizard_WizardOption_Enums> decl_QWizard_WizardOption_Enums ("QWizard_QFlags_WizardOption",
  gsi::method_ext ("|", &qt_gsi::oropQWizard_WizardOption_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQWizard_WizardOption_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQWizard_WizardOption_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QWizard_WizardOption_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QWizard_WizardOption_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QWizard_WizardOption_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QWizard::WizardOption> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QWizard_WizardOption_Enum> decl_QWizard_WizardOption_Enum (decl_QWizard_WizardOption_Enums, "QWizard_WizardOption",
  qt_gsi::mkdefs_QWizard_WizardOption () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QWizard_WizardOption_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QWizard_WizardOption_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQWizard_WizardOption_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QWizard_WizardOption_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QWizard_WizardOption_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QWizard::WizardOption enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QWizard> inject_QWizard_WizardOption_Enum_in_parent (qt_gsi::mkdefs_QWizard_WizardOption ());
static gsi::ClassExt<QWizard> decl_QWizard_WizardOption_Enum_as_child (decl_QWizard_WizardOption_Enum, "WizardOption");

}


//  Implementation of the enum wrapper class for QWizard::WizardPixmap
namespace qt_gsi
{

static QWizard_WizardPixmap_Enum *c_1_QWizard_WizardPixmap_Enum () { return new QWizard_WizardPixmap_Enum (QWizard::WatermarkPixmap); }
static QWizard_WizardPixmap_Enum *c_2_QWizard_WizardPixmap_Enum () { return new QWizard_WizardPixmap_Enum (QWizard::LogoPixmap); }
static QWizard_WizardPixmap_Enum *c_3_QWizard_WizardPixmap_Enum () { return new QWizard_WizardPixmap_Enum (QWizard::BannerPixmap); }
static QWizard_WizardPixmap_Enum *c_4_QWizard_WizardPixmap_Enum () { return new QWizard_WizardPixmap_Enum (QWizard::BackgroundPixmap); }
static QWizard_WizardPixmap_Enum *c_5_QWizard_WizardPixmap_Enum () { return new QWizard_WizardPixmap_Enum (QWizard::NPixmaps); }

static gsi::Methods mkdefs_QWizard_WizardPixmap () {
  return
    gsi::constant ("WatermarkPixmap", &qt_gsi::c_1_QWizard_WizardPixmap_Enum, "@brief Enum constant QWizard::WatermarkPixmap") +
    gsi::constant ("LogoPixmap", &qt_gsi::c_2_QWizard_WizardPixmap_Enum, "@brief Enum constant QWizard::LogoPixmap") +
    gsi::constant ("BannerPixmap", &qt_gsi::c_3_QWizard_WizardPixmap_Enum, "@brief Enum constant QWizard::BannerPixmap") +
    gsi::constant ("BackgroundPixmap", &qt_gsi::c_4_QWizard_WizardPixmap_Enum, "@brief Enum constant QWizard::BackgroundPixmap") +
    gsi::constant ("NPixmaps", &qt_gsi::c_5_QWizard_WizardPixmap_Enum, "@brief Enum constant QWizard::NPixmaps");
}

static std::string to_s_QWizard_WizardPixmap_Enum (const QWizard_WizardPixmap_Enum *e)
{
  if (e->value () == QWizard::WatermarkPixmap) { return tl::sprintf ("WatermarkPixmap (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::LogoPixmap) { return tl::sprintf ("LogoPixmap (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::BannerPixmap) { return tl::sprintf ("BannerPixmap (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::BackgroundPixmap) { return tl::sprintf ("BackgroundPixmap (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::NPixmaps) { return tl::sprintf ("NPixmaps (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QWizard_WizardPixmap_Enum (const QWizard_WizardPixmap_Enum *e)
{
  return (unsigned int) e->value ();
}

static QWizard_WizardPixmap_Enum *from_i_QWizard_WizardPixmap_Enum (unsigned int i)
{
  return new QWizard_WizardPixmap_Enum ((QWizard::WizardPixmap) i);
}

static bool equalQWizard_WizardPixmap_Enum (const QWizard_WizardPixmap_Enum *e, QWizard_WizardPixmap_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QWizard_WizardPixmap_Enum (const QWizard_WizardPixmap_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QWizard_WizardPixmap_Enums oropQWizard_WizardPixmap_Enums (const QWizard_WizardPixmap_Enums *e, const QWizard_WizardPixmap_Enums &d)
{
  return e->flags () | d.flags ();
}

static QWizard_WizardPixmap_Enums andopQWizard_WizardPixmap_Enums (const QWizard_WizardPixmap_Enums *e, const QWizard_WizardPixmap_Enums &d)
{
  return e->flags () & d.flags ();
}

static QWizard_WizardPixmap_Enums xoropQWizard_WizardPixmap_Enums (const QWizard_WizardPixmap_Enums *e, const QWizard_WizardPixmap_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QWizard_WizardPixmap_Enums (const QWizard_WizardPixmap_Enums *e)
{
  std::string l;
  if (e->testFlag (QWizard::WatermarkPixmap)) { if (!l.empty ()) l += "|"; l += "WatermarkPixmap"; }
  if (e->testFlag (QWizard::LogoPixmap)) { if (!l.empty ()) l += "|"; l += "LogoPixmap"; }
  if (e->testFlag (QWizard::BannerPixmap)) { if (!l.empty ()) l += "|"; l += "BannerPixmap"; }
  if (e->testFlag (QWizard::BackgroundPixmap)) { if (!l.empty ()) l += "|"; l += "BackgroundPixmap"; }
  if (e->testFlag (QWizard::NPixmaps)) { if (!l.empty ()) l += "|"; l += "NPixmaps"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QWizard_WizardPixmap_Enums (const QWizard_WizardPixmap_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QWizard_WizardPixmap_Enums (const QWizard_WizardPixmap_Enums *e, const QWizard_WizardPixmap_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QWizard_WizardPixmap_Enums> decl_QWizard_WizardPixmap_Enums ("QWizard_QFlags_WizardPixmap",
  gsi::method_ext ("|", &qt_gsi::oropQWizard_WizardPixmap_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQWizard_WizardPixmap_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQWizard_WizardPixmap_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QWizard_WizardPixmap_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QWizard_WizardPixmap_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QWizard_WizardPixmap_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QWizard::WizardPixmap> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QWizard_WizardPixmap_Enum> decl_QWizard_WizardPixmap_Enum (decl_QWizard_WizardPixmap_Enums, "QWizard_WizardPixmap",
  qt_gsi::mkdefs_QWizard_WizardPixmap () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QWizard_WizardPixmap_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QWizard_WizardPixmap_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQWizard_WizardPixmap_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QWizard_WizardPixmap_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QWizard_WizardPixmap_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QWizard::WizardPixmap enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QWizard> inject_QWizard_WizardPixmap_Enum_in_parent (qt_gsi::mkdefs_QWizard_WizardPixmap ());
static gsi::ClassExt<QWizard> decl_QWizard_WizardPixmap_Enum_as_child (decl_QWizard_WizardPixmap_Enum, "WizardPixmap");

}


//  Implementation of the enum wrapper class for QWizard::WizardStyle
namespace qt_gsi
{

static QWizard_WizardStyle_Enum *c_1_QWizard_WizardStyle_Enum () { return new QWizard_WizardStyle_Enum (QWizard::ClassicStyle); }
static QWizard_WizardStyle_Enum *c_2_QWizard_WizardStyle_Enum () { return new QWizard_WizardStyle_Enum (QWizard::ModernStyle); }
static QWizard_WizardStyle_Enum *c_3_QWizard_WizardStyle_Enum () { return new QWizard_WizardStyle_Enum (QWizard::MacStyle); }
static QWizard_WizardStyle_Enum *c_4_QWizard_WizardStyle_Enum () { return new QWizard_WizardStyle_Enum (QWizard::AeroStyle); }
static QWizard_WizardStyle_Enum *c_5_QWizard_WizardStyle_Enum () { return new QWizard_WizardStyle_Enum (QWizard::NStyles); }

static gsi::Methods mkdefs_QWizard_WizardStyle () {
  return
    gsi::constant ("ClassicStyle", &qt_gsi::c_1_QWizard_WizardStyle_Enum, "@brief Enum constant QWizard::ClassicStyle") +
    gsi::constant ("ModernStyle", &qt_gsi::c_2_QWizard_WizardStyle_Enum, "@brief Enum constant QWizard::ModernStyle") +
    gsi::constant ("MacStyle", &qt_gsi::c_3_QWizard_WizardStyle_Enum, "@brief Enum constant QWizard::MacStyle") +
    gsi::constant ("AeroStyle", &qt_gsi::c_4_QWizard_WizardStyle_Enum, "@brief Enum constant QWizard::AeroStyle") +
    gsi::constant ("NStyles", &qt_gsi::c_5_QWizard_WizardStyle_Enum, "@brief Enum constant QWizard::NStyles");
}

static std::string to_s_QWizard_WizardStyle_Enum (const QWizard_WizardStyle_Enum *e)
{
  if (e->value () == QWizard::ClassicStyle) { return tl::sprintf ("ClassicStyle (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::ModernStyle) { return tl::sprintf ("ModernStyle (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::MacStyle) { return tl::sprintf ("MacStyle (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::AeroStyle) { return tl::sprintf ("AeroStyle (%u)", (unsigned int) e->value ()); }
  if (e->value () == QWizard::NStyles) { return tl::sprintf ("NStyles (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QWizard_WizardStyle_Enum (const QWizard_WizardStyle_Enum *e)
{
  return (unsigned int) e->value ();
}

static QWizard_WizardStyle_Enum *from_i_QWizard_WizardStyle_Enum (unsigned int i)
{
  return new QWizard_WizardStyle_Enum ((QWizard::WizardStyle) i);
}

static bool equalQWizard_WizardStyle_Enum (const QWizard_WizardStyle_Enum *e, QWizard_WizardStyle_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QWizard_WizardStyle_Enum (const QWizard_WizardStyle_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QWizard_WizardStyle_Enums oropQWizard_WizardStyle_Enums (const QWizard_WizardStyle_Enums *e, const QWizard_WizardStyle_Enums &d)
{
  return e->flags () | d.flags ();
}

static QWizard_WizardStyle_Enums andopQWizard_WizardStyle_Enums (const QWizard_WizardStyle_Enums *e, const QWizard_WizardStyle_Enums &d)
{
  return e->flags () & d.flags ();
}

static QWizard_WizardStyle_Enums xoropQWizard_WizardStyle_Enums (const QWizard_WizardStyle_Enums *e, const QWizard_WizardStyle_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QWizard_WizardStyle_Enums (const QWizard_WizardStyle_Enums *e)
{
  std::string l;
  if (e->testFlag (QWizard::ClassicStyle)) { if (!l.empty ()) l += "|"; l += "ClassicStyle"; }
  if (e->testFlag (QWizard::ModernStyle)) { if (!l.empty ()) l += "|"; l += "ModernStyle"; }
  if (e->testFlag (QWizard::MacStyle)) { if (!l.empty ()) l += "|"; l += "MacStyle"; }
  if (e->testFlag (QWizard::AeroStyle)) { if (!l.empty ()) l += "|"; l += "AeroStyle"; }
  if (e->testFlag (QWizard::NStyles)) { if (!l.empty ()) l += "|"; l += "NStyles"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QWizard_WizardStyle_Enums (const QWizard_WizardStyle_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QWizard_WizardStyle_Enums (const QWizard_WizardStyle_Enums *e, const QWizard_WizardStyle_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QWizard_WizardStyle_Enums> decl_QWizard_WizardStyle_Enums ("QWizard_QFlags_WizardStyle",
  gsi::method_ext ("|", &qt_gsi::oropQWizard_WizardStyle_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQWizard_WizardStyle_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQWizard_WizardStyle_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QWizard_WizardStyle_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QWizard_WizardStyle_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QWizard_WizardStyle_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QWizard::WizardStyle> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QWizard_WizardStyle_Enum> decl_QWizard_WizardStyle_Enum (decl_QWizard_WizardStyle_Enums, "QWizard_WizardStyle",
  qt_gsi::mkdefs_QWizard_WizardStyle () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QWizard_WizardStyle_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QWizard_WizardStyle_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQWizard_WizardStyle_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QWizard_WizardStyle_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QWizard_WizardStyle_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QWizard::WizardStyle enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QWizard> inject_QWizard_WizardStyle_Enum_in_parent (qt_gsi::mkdefs_QWizard_WizardStyle ());
static gsi::ClassExt<QWizard> decl_QWizard_WizardStyle_Enum_as_child (decl_QWizard_WizardStyle_Enum, "WizardStyle");

}

