
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQUndoView.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQUndoView_EventAdaptor.h"
#include "gsiDeclQUndoView_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QUndoView

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QUndoView::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QIcon QUndoView::cleanIcon()


static void _init_f_cleanIcon_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIcon > ();
}

static void _call_f_cleanIcon_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QIcon > ((QIcon)((QUndoView *)cls)->cleanIcon ());
}

static qt_gsi::GenericMethod *_create_f_cleanIcon_c0 ()
{
  return new qt_gsi::GenericMethod (":cleanIcon", "@brief Method QIcon QUndoView::cleanIcon()\n", true, &_init_f_cleanIcon_c0, &_call_f_cleanIcon_c0);
}

// QString QUndoView::emptyLabel()


static void _init_f_emptyLabel_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_emptyLabel_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QUndoView *)cls)->emptyLabel ());
}

static qt_gsi::GenericMethod *_create_f_emptyLabel_c0 ()
{
  return new qt_gsi::GenericMethod (":emptyLabel", "@brief Method QString QUndoView::emptyLabel()\n", true, &_init_f_emptyLabel_c0, &_call_f_emptyLabel_c0);
}

// QUndoGroup *QUndoView::group()


static void _init_f_group_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QUndoGroup * > ();
}

static void _call_f_group_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QUndoGroup * > ((QUndoGroup *)((QUndoView *)cls)->group ());
}

static qt_gsi::GenericMethod *_create_f_group_c0 ()
{
  return new qt_gsi::GenericMethod (":group", "@brief Method QUndoGroup *QUndoView::group()\n", true, &_init_f_group_c0, &_call_f_group_c0);
}

// void QUndoView::setCleanIcon(const QIcon &icon)


static void _init_f_setCleanIcon_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCleanIcon_1787 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QIcon &arg1 = args.read<const QIcon & > ();
  ((QUndoView *)cls)->setCleanIcon (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCleanIcon_1787 ()
{
  return new qt_gsi::GenericMethod ("setCleanIcon|cleanIcon=", "@brief Method void QUndoView::setCleanIcon(const QIcon &icon)\n", false, &_init_f_setCleanIcon_1787, &_call_f_setCleanIcon_1787);
}

// void QUndoView::setEmptyLabel(const QString &label)


static void _init_f_setEmptyLabel_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("label");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEmptyLabel_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUndoView *)cls)->setEmptyLabel (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEmptyLabel_2025 ()
{
  return new qt_gsi::GenericMethod ("setEmptyLabel|emptyLabel=", "@brief Method void QUndoView::setEmptyLabel(const QString &label)\n", false, &_init_f_setEmptyLabel_2025, &_call_f_setEmptyLabel_2025);
}

// void QUndoView::setGroup(QUndoGroup *group)


static void _init_f_setGroup_1634 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("group");
  decl->add_arg<QUndoGroup * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGroup_1634 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QUndoGroup *arg1 = args.read<QUndoGroup * > ();
  ((QUndoView *)cls)->setGroup (arg1);
}

static qt_gsi::GenericMethod *_create_f_setGroup_1634 ()
{
  return new qt_gsi::GenericMethod ("setGroup|group=", "@brief Method void QUndoView::setGroup(QUndoGroup *group)\n", false, &_init_f_setGroup_1634, &_call_f_setGroup_1634);
}

// void QUndoView::setStack(QUndoStack *stack)


static void _init_f_setStack_1611 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stack");
  decl->add_arg<QUndoStack * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStack_1611 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QUndoStack *arg1 = args.read<QUndoStack * > ();
  ((QUndoView *)cls)->setStack (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStack_1611 ()
{
  return new qt_gsi::GenericMethod ("setStack|stack=", "@brief Method void QUndoView::setStack(QUndoStack *stack)\n", false, &_init_f_setStack_1611, &_call_f_setStack_1611);
}

// QUndoStack *QUndoView::stack()


static void _init_f_stack_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QUndoStack * > ();
}

static void _call_f_stack_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QUndoStack * > ((QUndoStack *)((QUndoView *)cls)->stack ());
}

static qt_gsi::GenericMethod *_create_f_stack_c0 ()
{
  return new qt_gsi::GenericMethod (":stack", "@brief Method QUndoStack *QUndoView::stack()\n", true, &_init_f_stack_c0, &_call_f_stack_c0);
}

// static QString QUndoView::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QUndoView::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QUndoView::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QUndoView::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QUndoView::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QUndoView::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QUndoView::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QUndoView::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QUndoView::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QUndoView::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QUndoView::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QUndoView::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QUndoView, QUndoView_EventAdaptor> ea_QUndoView;

namespace gsi
{
extern gsi::Class<QListView> decl_QListView;

gsi::Class<QUndoView> decl_QUndoView (ea_QUndoView, decl_QListView, "QUndoView_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_cleanIcon_c0 ()) +
  gsi::Methods(_create_f_emptyLabel_c0 ()) +
  gsi::Methods(_create_f_group_c0 ()) +
  gsi::Methods(_create_f_setCleanIcon_1787 ()) +
  gsi::Methods(_create_f_setEmptyLabel_2025 ()) +
  gsi::Methods(_create_f_setGroup_1634 ()) +
  gsi::Methods(_create_f_setStack_1611 ()) +
  gsi::Methods(_create_f_stack_c0 ()) +
  qt_gsi::qt_signal<QUndoView, QUndoView_EventAdaptor, const QModelIndex &> ("activated", &QUndoView_EventAdaptor::activated_e_2395, gsi::arg("index"), "@brief Signal declaration for QUndoView::activated(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUndoView, QUndoView_EventAdaptor, const QModelIndex &> ("clicked", &QUndoView_EventAdaptor::clicked_e_2395, gsi::arg("index"), "@brief Signal declaration for QUndoView::clicked(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUndoView, QUndoView_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QUndoView_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QUndoView::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUndoView, QUndoView_EventAdaptor, QObject *> ("destroyed", &QUndoView_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QUndoView::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUndoView, QUndoView_EventAdaptor, const QModelIndex &> ("doubleClicked", &QUndoView_EventAdaptor::doubleClicked_e_2395, gsi::arg("index"), "@brief Signal declaration for QUndoView::doubleClicked(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUndoView, QUndoView_EventAdaptor, const QModelIndex &> ("entered", &QUndoView_EventAdaptor::entered_e_2395, gsi::arg("index"), "@brief Signal declaration for QUndoView::entered(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUndoView, QUndoView_EventAdaptor, const qt_gsi::Converter<QList<QModelIndex> >::target_type &> ("indexesMoved", &QUndoView_EventAdaptor::indexesMoved_e_3010, gsi::arg("indexes"), "@brief Signal declaration for QUndoView::indexesMoved(const QList<QModelIndex> &indexes)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUndoView, QUndoView_EventAdaptor, const QModelIndex &> ("pressed", &QUndoView_EventAdaptor::pressed_e_2395, gsi::arg("index"), "@brief Signal declaration for QUndoView::pressed(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QUndoView, QUndoView_EventAdaptor> ("viewportEntered", &QUndoView_EventAdaptor::viewportEntered_e_0, "@brief Signal declaration for QUndoView::viewportEntered()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QUndoView");
}


class QUndoView_Adaptor : public QUndoView, public qt_gsi::QtObjectBase
{
public:

  virtual ~QUndoView_Adaptor();

  //  [adaptor ctor] QUndoView::QUndoView(QWidget *parent)
  QUndoView_Adaptor() : QUndoView()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QUndoView::QUndoView(QWidget *parent)
  QUndoView_Adaptor(QWidget *parent) : QUndoView(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QUndoView::QUndoView(QUndoStack *stack, QWidget *parent)
  QUndoView_Adaptor(QUndoStack *stack) : QUndoView(stack)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QUndoView::QUndoView(QUndoStack *stack, QWidget *parent)
  QUndoView_Adaptor(QUndoStack *stack, QWidget *parent) : QUndoView(stack, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QUndoView::QUndoView(QUndoGroup *group, QWidget *parent)
  QUndoView_Adaptor(QUndoGroup *group) : QUndoView(group)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QUndoView::QUndoView(QUndoGroup *group, QWidget *parent)
  QUndoView_Adaptor(QUndoGroup *group, QWidget *parent) : QUndoView(group, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  QSize QUndoView::contentsSize()
  QSize fp_QUndoView_contentsSize_c0 () const {
    return QUndoView::contentsSize();
  }

  //  void QUndoView::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QUndoView_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QUndoView::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QUndoView::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QUndoView_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QUndoView::destroy(destroyWindow, destroySubWindows);
  }

  //  QPoint QUndoView::dirtyRegionOffset()
  QPoint fp_QUndoView_dirtyRegionOffset_c0 () const {
    return QUndoView::dirtyRegionOffset();
  }

  //  void QUndoView::doAutoScroll()
  void fp_QUndoView_doAutoScroll_0 () {
    QUndoView::doAutoScroll();
  }

  //  void QUndoView::drawFrame(QPainter *)
  void fp_QUndoView_drawFrame_1426 (QPainter *arg1) {
    QUndoView::drawFrame(arg1);
  }

  //  QAbstractItemView::DropIndicatorPosition QUndoView::dropIndicatorPosition()
  unsigned int fp_QUndoView_dropIndicatorPosition_c0 () const {
    return (unsigned int)(QUndoView::dropIndicatorPosition());
  }

  //  void QUndoView::executeDelayedItemsLayout()
  void fp_QUndoView_executeDelayedItemsLayout_0 () {
    QUndoView::executeDelayedItemsLayout();
  }

  //  bool QUndoView::focusNextChild()
  bool fp_QUndoView_focusNextChild_0 () {
    return QUndoView::focusNextChild();
  }

  //  bool QUndoView::focusPreviousChild()
  bool fp_QUndoView_focusPreviousChild_0 () {
    return QUndoView::focusPreviousChild();
  }

  //  int QUndoView::horizontalStepsPerItem()
  int fp_QUndoView_horizontalStepsPerItem_c0 () const {
    return QUndoView::horizontalStepsPerItem();
  }

  //  void QUndoView::internalDrag(QFlags<Qt::DropAction> supportedActions)
  void fp_QUndoView_internalDrag_2456 (const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & supportedActions) {
    QUndoView::internalDrag(qt_gsi::QtToCppAdaptor<QFlags<Qt::DropAction> >(supportedActions).cref());
  }

  //  void QUndoView::internalDrop(QDropEvent *e)
  void fp_QUndoView_internalDrop_1622 (QDropEvent *e) {
    QUndoView::internalDrop(e);
  }

  //  int QUndoView::receivers(const char *signal)
  int fp_QUndoView_receivers_c1731 (const char *signal) const {
    return QUndoView::receivers(signal);
  }

  //  QRect QUndoView::rectForIndex(const QModelIndex &index)
  QRect fp_QUndoView_rectForIndex_c2395 (const QModelIndex &index) const {
    return QUndoView::rectForIndex(index);
  }

  //  void QUndoView::resetInputContext()
  void fp_QUndoView_resetInputContext_0 () {
    QUndoView::resetInputContext();
  }

  //  void QUndoView::resizeContents(int width, int height)
  void fp_QUndoView_resizeContents_1426 (int width, int height) {
    QUndoView::resizeContents(width, height);
  }

  //  void QUndoView::scheduleDelayedItemsLayout()
  void fp_QUndoView_scheduleDelayedItemsLayout_0 () {
    QUndoView::scheduleDelayedItemsLayout();
  }

  //  void QUndoView::scrollDirtyRegion(int dx, int dy)
  void fp_QUndoView_scrollDirtyRegion_1426 (int dx, int dy) {
    QUndoView::scrollDirtyRegion(dx, dy);
  }

  //  QObject *QUndoView::sender()
  QObject * fp_QUndoView_sender_c0 () const {
    return QUndoView::sender();
  }

  //  void QUndoView::setDirtyRegion(const QRegion &region)
  void fp_QUndoView_setDirtyRegion_2006 (const QRegion &region) {
    QUndoView::setDirtyRegion(region);
  }

  //  void QUndoView::setHorizontalStepsPerItem(int steps)
  void fp_QUndoView_setHorizontalStepsPerItem_767 (int steps) {
    QUndoView::setHorizontalStepsPerItem(steps);
  }

  //  void QUndoView::setPositionForIndex(const QPoint &position, const QModelIndex &index)
  void fp_QUndoView_setPositionForIndex_4203 (const QPoint &position, const QModelIndex &index) {
    QUndoView::setPositionForIndex(position, index);
  }

  //  void QUndoView::setState(QAbstractItemView::State state)
  void fp_QUndoView_setState_2776 (unsigned int state) {
    QUndoView::setState(QAbstractItemView::State(state));
  }

  //  void QUndoView::setVerticalStepsPerItem(int steps)
  void fp_QUndoView_setVerticalStepsPerItem_767 (int steps) {
    QUndoView::setVerticalStepsPerItem(steps);
  }

  //  void QUndoView::setViewportMargins(int left, int top, int right, int bottom)
  void fp_QUndoView_setViewportMargins_2744 (int left, int top, int right, int bottom) {
    QUndoView::setViewportMargins(left, top, right, bottom);
  }

  //  void QUndoView::setViewportMargins(const QMargins &margins)
  void fp_QUndoView_setViewportMargins_2115 (const QMargins &margins) {
    QUndoView::setViewportMargins(margins);
  }

  //  void QUndoView::setupViewport(QWidget *viewport)
  void fp_QUndoView_setupViewport_1315 (QWidget *viewport) {
    QUndoView::setupViewport(viewport);
  }

  //  void QUndoView::startAutoScroll()
  void fp_QUndoView_startAutoScroll_0 () {
    QUndoView::startAutoScroll();
  }

  //  QAbstractItemView::State QUndoView::state()
  unsigned int fp_QUndoView_state_c0 () const {
    return (unsigned int)(QUndoView::state());
  }

  //  void QUndoView::stopAutoScroll()
  void fp_QUndoView_stopAutoScroll_0 () {
    QUndoView::stopAutoScroll();
  }

  //  void QUndoView::updateMicroFocus()
  void fp_QUndoView_updateMicroFocus_0 () {
    QUndoView::updateMicroFocus();
  }

  //  int QUndoView::verticalStepsPerItem()
  int fp_QUndoView_verticalStepsPerItem_c0 () const {
    return QUndoView::verticalStepsPerItem();
  }

  //  [adaptor impl] void QUndoView::doItemsLayout()
  void cbs_doItemsLayout_0_0()
  {
    QUndoView::doItemsLayout();
  }

  virtual void doItemsLayout()
  {
    if (cb_doItemsLayout_0_0.can_issue()) {
      cb_doItemsLayout_0_0.issue<QUndoView_Adaptor>(&QUndoView_Adaptor::cbs_doItemsLayout_0_0);
    } else {
      QUndoView::doItemsLayout();
    }
  }

  //  [adaptor impl] bool QUndoView::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QUndoView::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QUndoView_Adaptor, bool, QObject *, QEvent *>(&QUndoView_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QUndoView::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] int QUndoView::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QUndoView::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QUndoView_Adaptor, int, int>(&QUndoView_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QUndoView::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QModelIndex QUndoView::indexAt(const QPoint &p)
  QModelIndex cbs_indexAt_c1916_0(const QPoint &p) const
  {
    return QUndoView::indexAt(p);
  }

  virtual QModelIndex indexAt(const QPoint &p) const
  {
    if (cb_indexAt_c1916_0.can_issue()) {
      return cb_indexAt_c1916_0.issue<QUndoView_Adaptor, QModelIndex, const QPoint &>(&QUndoView_Adaptor::cbs_indexAt_c1916_0, p);
    } else {
      return QUndoView::indexAt(p);
    }
  }

  //  [adaptor impl] QVariant QUndoView::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QUndoView::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QUndoView_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QUndoView_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QUndoView::inputMethodQuery(query);
    }
  }

  //  [adaptor impl] void QUndoView::keyboardSearch(const QString &search)
  void cbs_keyboardSearch_2025_0(const QString &search)
  {
    QUndoView::keyboardSearch(search);
  }

  virtual void keyboardSearch(const QString &search)
  {
    if (cb_keyboardSearch_2025_0.can_issue()) {
      cb_keyboardSearch_2025_0.issue<QUndoView_Adaptor, const QString &>(&QUndoView_Adaptor::cbs_keyboardSearch_2025_0, search);
    } else {
      QUndoView::keyboardSearch(search);
    }
  }

  //  [adaptor impl] QSize QUndoView::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QUndoView::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QUndoView_Adaptor, QSize>(&QUndoView_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QUndoView::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QUndoView::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QUndoView::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QUndoView_Adaptor, QPaintEngine *>(&QUndoView_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QUndoView::paintEngine();
    }
  }

  //  [adaptor impl] void QUndoView::reset()
  void cbs_reset_0_0()
  {
    QUndoView::reset();
  }

  virtual void reset()
  {
    if (cb_reset_0_0.can_issue()) {
      cb_reset_0_0.issue<QUndoView_Adaptor>(&QUndoView_Adaptor::cbs_reset_0_0);
    } else {
      QUndoView::reset();
    }
  }

  //  [adaptor impl] void QUndoView::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)
  void cbs_scrollTo_5576_1(const QModelIndex &index, const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & hint)
  {
    QUndoView::scrollTo(index, qt_gsi::QtToCppAdaptor<QAbstractItemView::ScrollHint>(hint).cref());
  }

  virtual void scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)
  {
    if (cb_scrollTo_5576_1.can_issue()) {
      cb_scrollTo_5576_1.issue<QUndoView_Adaptor, const QModelIndex &, const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type &>(&QUndoView_Adaptor::cbs_scrollTo_5576_1, index, qt_gsi::CppToQtAdaptor<QAbstractItemView::ScrollHint>(hint));
    } else {
      QUndoView::scrollTo(index, hint);
    }
  }

  //  [adaptor impl] void QUndoView::selectAll()
  void cbs_selectAll_0_0()
  {
    QUndoView::selectAll();
  }

  virtual void selectAll()
  {
    if (cb_selectAll_0_0.can_issue()) {
      cb_selectAll_0_0.issue<QUndoView_Adaptor>(&QUndoView_Adaptor::cbs_selectAll_0_0);
    } else {
      QUndoView::selectAll();
    }
  }

  //  [adaptor impl] void QUndoView::setModel(QAbstractItemModel *model)
  void cbs_setModel_2419_0(QAbstractItemModel *model)
  {
    QUndoView::setModel(model);
  }

  virtual void setModel(QAbstractItemModel *model)
  {
    if (cb_setModel_2419_0.can_issue()) {
      cb_setModel_2419_0.issue<QUndoView_Adaptor, QAbstractItemModel *>(&QUndoView_Adaptor::cbs_setModel_2419_0, model);
    } else {
      QUndoView::setModel(model);
    }
  }

  //  [adaptor impl] void QUndoView::setRootIndex(const QModelIndex &index)
  void cbs_setRootIndex_2395_0(const QModelIndex &index)
  {
    QUndoView::setRootIndex(index);
  }

  virtual void setRootIndex(const QModelIndex &index)
  {
    if (cb_setRootIndex_2395_0.can_issue()) {
      cb_setRootIndex_2395_0.issue<QUndoView_Adaptor, const QModelIndex &>(&QUndoView_Adaptor::cbs_setRootIndex_2395_0, index);
    } else {
      QUndoView::setRootIndex(index);
    }
  }

  //  [adaptor impl] void QUndoView::setSelectionModel(QItemSelectionModel *selectionModel)
  void cbs_setSelectionModel_2533_0(QItemSelectionModel *selectionModel)
  {
    QUndoView::setSelectionModel(selectionModel);
  }

  virtual void setSelectionModel(QItemSelectionModel *selectionModel)
  {
    if (cb_setSelectionModel_2533_0.can_issue()) {
      cb_setSelectionModel_2533_0.issue<QUndoView_Adaptor, QItemSelectionModel *>(&QUndoView_Adaptor::cbs_setSelectionModel_2533_0, selectionModel);
    } else {
      QUndoView::setSelectionModel(selectionModel);
    }
  }

  //  [adaptor impl] void QUndoView::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QUndoView::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QUndoView_Adaptor, bool>(&QUndoView_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QUndoView::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QUndoView::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QUndoView::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QUndoView_Adaptor, QSize>(&QUndoView_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QUndoView::sizeHint();
    }
  }

  //  [adaptor impl] int QUndoView::sizeHintForColumn(int column)
  int cbs_sizeHintForColumn_c767_0(int column) const
  {
    return QUndoView::sizeHintForColumn(column);
  }

  virtual int sizeHintForColumn(int column) const
  {
    if (cb_sizeHintForColumn_c767_0.can_issue()) {
      return cb_sizeHintForColumn_c767_0.issue<QUndoView_Adaptor, int, int>(&QUndoView_Adaptor::cbs_sizeHintForColumn_c767_0, column);
    } else {
      return QUndoView::sizeHintForColumn(column);
    }
  }

  //  [adaptor impl] int QUndoView::sizeHintForRow(int row)
  int cbs_sizeHintForRow_c767_0(int row) const
  {
    return QUndoView::sizeHintForRow(row);
  }

  virtual int sizeHintForRow(int row) const
  {
    if (cb_sizeHintForRow_c767_0.can_issue()) {
      return cb_sizeHintForRow_c767_0.issue<QUndoView_Adaptor, int, int>(&QUndoView_Adaptor::cbs_sizeHintForRow_c767_0, row);
    } else {
      return QUndoView::sizeHintForRow(row);
    }
  }

  //  [adaptor impl] QRect QUndoView::visualRect(const QModelIndex &index)
  QRect cbs_visualRect_c2395_0(const QModelIndex &index) const
  {
    return QUndoView::visualRect(index);
  }

  virtual QRect visualRect(const QModelIndex &index) const
  {
    if (cb_visualRect_c2395_0.can_issue()) {
      return cb_visualRect_c2395_0.issue<QUndoView_Adaptor, QRect, const QModelIndex &>(&QUndoView_Adaptor::cbs_visualRect_c2395_0, index);
    } else {
      return QUndoView::visualRect(index);
    }
  }

  //  [adaptor impl] void QUndoView::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QUndoView::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QUndoView_Adaptor, QActionEvent *>(&QUndoView_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QUndoView::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QUndoView::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QUndoView::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QUndoView_Adaptor, QEvent *>(&QUndoView_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QUndoView::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QUndoView::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QUndoView::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QUndoView_Adaptor, QChildEvent *>(&QUndoView_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QUndoView::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QUndoView::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  void cbs_closeEditor_4926_0(QWidget *editor, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & hint)
  {
    QUndoView::closeEditor(editor, qt_gsi::QtToCppAdaptor<QAbstractItemDelegate::EndEditHint>(hint).cref());
  }

  virtual void closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  {
    if (cb_closeEditor_4926_0.can_issue()) {
      cb_closeEditor_4926_0.issue<QUndoView_Adaptor, QWidget *, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type &>(&QUndoView_Adaptor::cbs_closeEditor_4926_0, editor, qt_gsi::CppToQtAdaptor<QAbstractItemDelegate::EndEditHint>(hint));
    } else {
      QUndoView::closeEditor(editor, hint);
    }
  }

  //  [adaptor impl] void QUndoView::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QUndoView::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QUndoView_Adaptor, QCloseEvent *>(&QUndoView_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QUndoView::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QUndoView::commitData(QWidget *editor)
  void cbs_commitData_1315_0(QWidget *editor)
  {
    QUndoView::commitData(editor);
  }

  virtual void commitData(QWidget *editor)
  {
    if (cb_commitData_1315_0.can_issue()) {
      cb_commitData_1315_0.issue<QUndoView_Adaptor, QWidget *>(&QUndoView_Adaptor::cbs_commitData_1315_0, editor);
    } else {
      QUndoView::commitData(editor);
    }
  }

  //  [adaptor impl] void QUndoView::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QUndoView::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QUndoView_Adaptor, QContextMenuEvent *>(&QUndoView_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QUndoView::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QUndoView::currentChanged(const QModelIndex &current, const QModelIndex &previous)
  void cbs_currentChanged_4682_0(const QModelIndex &current, const QModelIndex &previous)
  {
    QUndoView::currentChanged(current, previous);
  }

  virtual void currentChanged(const QModelIndex &current, const QModelIndex &previous)
  {
    if (cb_currentChanged_4682_0.can_issue()) {
      cb_currentChanged_4682_0.issue<QUndoView_Adaptor, const QModelIndex &, const QModelIndex &>(&QUndoView_Adaptor::cbs_currentChanged_4682_0, current, previous);
    } else {
      QUndoView::currentChanged(current, previous);
    }
  }

  //  [adaptor impl] void QUndoView::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QUndoView::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QUndoView_Adaptor, QEvent *>(&QUndoView_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QUndoView::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QUndoView::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  void cbs_dataChanged_4682_0(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  {
    QUndoView::dataChanged(topLeft, bottomRight);
  }

  virtual void dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  {
    if (cb_dataChanged_4682_0.can_issue()) {
      cb_dataChanged_4682_0.issue<QUndoView_Adaptor, const QModelIndex &, const QModelIndex &>(&QUndoView_Adaptor::cbs_dataChanged_4682_0, topLeft, bottomRight);
    } else {
      QUndoView::dataChanged(topLeft, bottomRight);
    }
  }

  //  [adaptor impl] void QUndoView::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QUndoView::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QUndoView_Adaptor, const char *>(&QUndoView_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QUndoView::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QUndoView::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QUndoView::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QUndoView_Adaptor, QDragEnterEvent *>(&QUndoView_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QUndoView::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QUndoView::dragLeaveEvent(QDragLeaveEvent *e)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *e)
  {
    QUndoView::dragLeaveEvent(e);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *e)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QUndoView_Adaptor, QDragLeaveEvent *>(&QUndoView_Adaptor::cbs_dragLeaveEvent_2092_0, e);
    } else {
      QUndoView::dragLeaveEvent(e);
    }
  }

  //  [adaptor impl] void QUndoView::dragMoveEvent(QDragMoveEvent *e)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *e)
  {
    QUndoView::dragMoveEvent(e);
  }

  virtual void dragMoveEvent(QDragMoveEvent *e)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QUndoView_Adaptor, QDragMoveEvent *>(&QUndoView_Adaptor::cbs_dragMoveEvent_2006_0, e);
    } else {
      QUndoView::dragMoveEvent(e);
    }
  }

  //  [adaptor impl] void QUndoView::dropEvent(QDropEvent *e)
  void cbs_dropEvent_1622_0(QDropEvent *e)
  {
    QUndoView::dropEvent(e);
  }

  virtual void dropEvent(QDropEvent *e)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QUndoView_Adaptor, QDropEvent *>(&QUndoView_Adaptor::cbs_dropEvent_1622_0, e);
    } else {
      QUndoView::dropEvent(e);
    }
  }

  //  [adaptor impl] bool QUndoView::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)
  bool cbs_edit_6773_0(const QModelIndex &index, const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & trigger, QEvent *event)
  {
    return QUndoView::edit(index, qt_gsi::QtToCppAdaptor<QAbstractItemView::EditTrigger>(trigger).cref(), event);
  }

  virtual bool edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)
  {
    if (cb_edit_6773_0.can_issue()) {
      return cb_edit_6773_0.issue<QUndoView_Adaptor, bool, const QModelIndex &, const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type &, QEvent *>(&QUndoView_Adaptor::cbs_edit_6773_0, index, qt_gsi::CppToQtAdaptor<QAbstractItemView::EditTrigger>(trigger), event);
    } else {
      return QUndoView::edit(index, trigger, event);
    }
  }

  //  [adaptor impl] void QUndoView::editorDestroyed(QObject *editor)
  void cbs_editorDestroyed_1302_0(QObject *editor)
  {
    QUndoView::editorDestroyed(editor);
  }

  virtual void editorDestroyed(QObject *editor)
  {
    if (cb_editorDestroyed_1302_0.can_issue()) {
      cb_editorDestroyed_1302_0.issue<QUndoView_Adaptor, QObject *>(&QUndoView_Adaptor::cbs_editorDestroyed_1302_0, editor);
    } else {
      QUndoView::editorDestroyed(editor);
    }
  }

  //  [adaptor impl] void QUndoView::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QUndoView::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QUndoView_Adaptor, bool>(&QUndoView_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QUndoView::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QUndoView::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QUndoView::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QUndoView_Adaptor, QEvent *>(&QUndoView_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QUndoView::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QUndoView::event(QEvent *e)
  bool cbs_event_1217_0(QEvent *e)
  {
    return QUndoView::event(e);
  }

  virtual bool event(QEvent *e)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QUndoView_Adaptor, bool, QEvent *>(&QUndoView_Adaptor::cbs_event_1217_0, e);
    } else {
      return QUndoView::event(e);
    }
  }

  //  [adaptor impl] void QUndoView::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QUndoView::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QUndoView_Adaptor, QFocusEvent *>(&QUndoView_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QUndoView::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QUndoView::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QUndoView::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QUndoView_Adaptor, bool, bool>(&QUndoView_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QUndoView::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QUndoView::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QUndoView::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QUndoView_Adaptor, QFocusEvent *>(&QUndoView_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QUndoView::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QUndoView::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QUndoView::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QUndoView_Adaptor, const QFont &>(&QUndoView_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QUndoView::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QUndoView::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QUndoView::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QUndoView_Adaptor, QHideEvent *>(&QUndoView_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QUndoView::hideEvent(arg1);
    }
  }

  //  [adaptor impl] int QUndoView::horizontalOffset()
  int cbs_horizontalOffset_c0_0() const
  {
    return QUndoView::horizontalOffset();
  }

  virtual int horizontalOffset() const
  {
    if (cb_horizontalOffset_c0_0.can_issue()) {
      return cb_horizontalOffset_c0_0.issue<QUndoView_Adaptor, int>(&QUndoView_Adaptor::cbs_horizontalOffset_c0_0);
    } else {
      return QUndoView::horizontalOffset();
    }
  }

  //  [adaptor impl] void QUndoView::horizontalScrollbarAction(int action)
  void cbs_horizontalScrollbarAction_767_0(int action)
  {
    QUndoView::horizontalScrollbarAction(action);
  }

  virtual void horizontalScrollbarAction(int action)
  {
    if (cb_horizontalScrollbarAction_767_0.can_issue()) {
      cb_horizontalScrollbarAction_767_0.issue<QUndoView_Adaptor, int>(&QUndoView_Adaptor::cbs_horizontalScrollbarAction_767_0, action);
    } else {
      QUndoView::horizontalScrollbarAction(action);
    }
  }

  //  [adaptor impl] void QUndoView::horizontalScrollbarValueChanged(int value)
  void cbs_horizontalScrollbarValueChanged_767_0(int value)
  {
    QUndoView::horizontalScrollbarValueChanged(value);
  }

  virtual void horizontalScrollbarValueChanged(int value)
  {
    if (cb_horizontalScrollbarValueChanged_767_0.can_issue()) {
      cb_horizontalScrollbarValueChanged_767_0.issue<QUndoView_Adaptor, int>(&QUndoView_Adaptor::cbs_horizontalScrollbarValueChanged_767_0, value);
    } else {
      QUndoView::horizontalScrollbarValueChanged(value);
    }
  }

  //  [adaptor impl] void QUndoView::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QUndoView::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QUndoView_Adaptor, QInputMethodEvent *>(&QUndoView_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QUndoView::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] bool QUndoView::isIndexHidden(const QModelIndex &index)
  bool cbs_isIndexHidden_c2395_0(const QModelIndex &index) const
  {
    return QUndoView::isIndexHidden(index);
  }

  virtual bool isIndexHidden(const QModelIndex &index) const
  {
    if (cb_isIndexHidden_c2395_0.can_issue()) {
      return cb_isIndexHidden_c2395_0.issue<QUndoView_Adaptor, bool, const QModelIndex &>(&QUndoView_Adaptor::cbs_isIndexHidden_c2395_0, index);
    } else {
      return QUndoView::isIndexHidden(index);
    }
  }

  //  [adaptor impl] void QUndoView::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QUndoView::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QUndoView_Adaptor, QKeyEvent *>(&QUndoView_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QUndoView::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QUndoView::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QUndoView::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QUndoView_Adaptor, QKeyEvent *>(&QUndoView_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QUndoView::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QUndoView::languageChange()
  void cbs_languageChange_0_0()
  {
    QUndoView::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QUndoView_Adaptor>(&QUndoView_Adaptor::cbs_languageChange_0_0);
    } else {
      QUndoView::languageChange();
    }
  }

  //  [adaptor impl] void QUndoView::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QUndoView::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QUndoView_Adaptor, QEvent *>(&QUndoView_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QUndoView::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QUndoView::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QUndoView::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QUndoView_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QUndoView_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QUndoView::metric(arg1);
    }
  }

  //  [adaptor impl] void QUndoView::mouseDoubleClickEvent(QMouseEvent *event)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *event)
  {
    QUndoView::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QUndoView_Adaptor, QMouseEvent *>(&QUndoView_Adaptor::cbs_mouseDoubleClickEvent_1738_0, event);
    } else {
      QUndoView::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QUndoView::mouseMoveEvent(QMouseEvent *e)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *e)
  {
    QUndoView::mouseMoveEvent(e);
  }

  virtual void mouseMoveEvent(QMouseEvent *e)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QUndoView_Adaptor, QMouseEvent *>(&QUndoView_Adaptor::cbs_mouseMoveEvent_1738_0, e);
    } else {
      QUndoView::mouseMoveEvent(e);
    }
  }

  //  [adaptor impl] void QUndoView::mousePressEvent(QMouseEvent *event)
  void cbs_mousePressEvent_1738_0(QMouseEvent *event)
  {
    QUndoView::mousePressEvent(event);
  }

  virtual void mousePressEvent(QMouseEvent *event)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QUndoView_Adaptor, QMouseEvent *>(&QUndoView_Adaptor::cbs_mousePressEvent_1738_0, event);
    } else {
      QUndoView::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QUndoView::mouseReleaseEvent(QMouseEvent *e)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *e)
  {
    QUndoView::mouseReleaseEvent(e);
  }

  virtual void mouseReleaseEvent(QMouseEvent *e)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QUndoView_Adaptor, QMouseEvent *>(&QUndoView_Adaptor::cbs_mouseReleaseEvent_1738_0, e);
    } else {
      QUndoView::mouseReleaseEvent(e);
    }
  }

  //  [adaptor impl] QModelIndex QUndoView::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)
  QModelIndex cbs_moveCursor_6476_0(unsigned int cursorAction, const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & modifiers)
  {
    return QUndoView::moveCursor(QAbstractItemView::CursorAction(cursorAction), qt_gsi::QtToCppAdaptor<QFlags<Qt::KeyboardModifier> >(modifiers).cref());
  }

  virtual QModelIndex moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)
  {
    if (cb_moveCursor_6476_0.can_issue()) {
      return cb_moveCursor_6476_0.issue<QUndoView_Adaptor, QModelIndex, unsigned int, const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type &>(&QUndoView_Adaptor::cbs_moveCursor_6476_0, (unsigned int)(cursorAction), qt_gsi::CppToQtAdaptor<QFlags<Qt::KeyboardModifier> >(modifiers));
    } else {
      return QUndoView::moveCursor(cursorAction, modifiers);
    }
  }

  //  [adaptor impl] void QUndoView::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QUndoView::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QUndoView_Adaptor, QMoveEvent *>(&QUndoView_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QUndoView::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QUndoView::paintEvent(QPaintEvent *e)
  void cbs_paintEvent_1725_0(QPaintEvent *e)
  {
    QUndoView::paintEvent(e);
  }

  virtual void paintEvent(QPaintEvent *e)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QUndoView_Adaptor, QPaintEvent *>(&QUndoView_Adaptor::cbs_paintEvent_1725_0, e);
    } else {
      QUndoView::paintEvent(e);
    }
  }

  //  [adaptor impl] void QUndoView::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QUndoView::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QUndoView_Adaptor, const QPalette &>(&QUndoView_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QUndoView::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QUndoView::resizeEvent(QResizeEvent *e)
  void cbs_resizeEvent_1843_0(QResizeEvent *e)
  {
    QUndoView::resizeEvent(e);
  }

  virtual void resizeEvent(QResizeEvent *e)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QUndoView_Adaptor, QResizeEvent *>(&QUndoView_Adaptor::cbs_resizeEvent_1843_0, e);
    } else {
      QUndoView::resizeEvent(e);
    }
  }

  //  [adaptor impl] void QUndoView::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)
  void cbs_rowsAboutToBeRemoved_3713_0(const QModelIndex &parent, int start, int end)
  {
    QUndoView::rowsAboutToBeRemoved(parent, start, end);
  }

  virtual void rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)
  {
    if (cb_rowsAboutToBeRemoved_3713_0.can_issue()) {
      cb_rowsAboutToBeRemoved_3713_0.issue<QUndoView_Adaptor, const QModelIndex &, int, int>(&QUndoView_Adaptor::cbs_rowsAboutToBeRemoved_3713_0, parent, start, end);
    } else {
      QUndoView::rowsAboutToBeRemoved(parent, start, end);
    }
  }

  //  [adaptor impl] void QUndoView::rowsInserted(const QModelIndex &parent, int start, int end)
  void cbs_rowsInserted_3713_0(const QModelIndex &parent, int start, int end)
  {
    QUndoView::rowsInserted(parent, start, end);
  }

  virtual void rowsInserted(const QModelIndex &parent, int start, int end)
  {
    if (cb_rowsInserted_3713_0.can_issue()) {
      cb_rowsInserted_3713_0.issue<QUndoView_Adaptor, const QModelIndex &, int, int>(&QUndoView_Adaptor::cbs_rowsInserted_3713_0, parent, start, end);
    } else {
      QUndoView::rowsInserted(parent, start, end);
    }
  }

  //  [adaptor impl] void QUndoView::scrollContentsBy(int dx, int dy)
  void cbs_scrollContentsBy_1426_0(int dx, int dy)
  {
    QUndoView::scrollContentsBy(dx, dy);
  }

  virtual void scrollContentsBy(int dx, int dy)
  {
    if (cb_scrollContentsBy_1426_0.can_issue()) {
      cb_scrollContentsBy_1426_0.issue<QUndoView_Adaptor, int, int>(&QUndoView_Adaptor::cbs_scrollContentsBy_1426_0, dx, dy);
    } else {
      QUndoView::scrollContentsBy(dx, dy);
    }
  }

  //  [adaptor impl] QList<QModelIndex> QUndoView::selectedIndexes()
  qt_gsi::Converter<QList<QModelIndex> >::target_type cbs_selectedIndexes_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(QUndoView::selectedIndexes());
  }

  virtual QList<QModelIndex> selectedIndexes() const
  {
    if (cb_selectedIndexes_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(cb_selectedIndexes_c0_0.issue<QUndoView_Adaptor, qt_gsi::Converter<QList<QModelIndex> >::target_type>(&QUndoView_Adaptor::cbs_selectedIndexes_c0_0)).cref();
    } else {
      return QUndoView::selectedIndexes();
    }
  }

  //  [adaptor impl] void QUndoView::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
  void cbs_selectionChanged_5346_0(const QItemSelection &selected, const QItemSelection &deselected)
  {
    QUndoView::selectionChanged(selected, deselected);
  }

  virtual void selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
  {
    if (cb_selectionChanged_5346_0.can_issue()) {
      cb_selectionChanged_5346_0.issue<QUndoView_Adaptor, const QItemSelection &, const QItemSelection &>(&QUndoView_Adaptor::cbs_selectionChanged_5346_0, selected, deselected);
    } else {
      QUndoView::selectionChanged(selected, deselected);
    }
  }

  //  [adaptor impl] QFlags<QItemSelectionModel::SelectionFlag> QUndoView::selectionCommand(const QModelIndex &index, const QEvent *event)
  qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type cbs_selectionCommand_c4199_1(const QModelIndex &index, const QEvent *event) const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(QUndoView::selectionCommand(index, event));
  }

  virtual QFlags<QItemSelectionModel::SelectionFlag> selectionCommand(const QModelIndex &index, const QEvent *event) const
  {
    if (cb_selectionCommand_c4199_1.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(cb_selectionCommand_c4199_1.issue<QUndoView_Adaptor, qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type, const QModelIndex &, const QEvent *>(&QUndoView_Adaptor::cbs_selectionCommand_c4199_1, index, event)).cref();
    } else {
      return QUndoView::selectionCommand(index, event);
    }
  }

  //  [adaptor impl] void QUndoView::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)
  void cbs_setSelection_6155_0(const QRect &rect, const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & command)
  {
    QUndoView::setSelection(rect, qt_gsi::QtToCppAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(command).cref());
  }

  virtual void setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)
  {
    if (cb_setSelection_6155_0.can_issue()) {
      cb_setSelection_6155_0.issue<QUndoView_Adaptor, const QRect &, const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type &>(&QUndoView_Adaptor::cbs_setSelection_6155_0, rect, qt_gsi::CppToQtAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(command));
    } else {
      QUndoView::setSelection(rect, command);
    }
  }

  //  [adaptor impl] void QUndoView::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QUndoView::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QUndoView_Adaptor, QShowEvent *>(&QUndoView_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QUndoView::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QUndoView::startDrag(QFlags<Qt::DropAction> supportedActions)
  void cbs_startDrag_2456_0(const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & supportedActions)
  {
    QUndoView::startDrag(qt_gsi::QtToCppAdaptor<QFlags<Qt::DropAction> >(supportedActions).cref());
  }

  virtual void startDrag(QFlags<Qt::DropAction> supportedActions)
  {
    if (cb_startDrag_2456_0.can_issue()) {
      cb_startDrag_2456_0.issue<QUndoView_Adaptor, const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type &>(&QUndoView_Adaptor::cbs_startDrag_2456_0, qt_gsi::CppToQtAdaptor<QFlags<Qt::DropAction> >(supportedActions));
    } else {
      QUndoView::startDrag(supportedActions);
    }
  }

  //  [adaptor impl] void QUndoView::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QUndoView::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QUndoView_Adaptor, QStyle &>(&QUndoView_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QUndoView::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QUndoView::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QUndoView::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QUndoView_Adaptor, QTabletEvent *>(&QUndoView_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QUndoView::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QUndoView::timerEvent(QTimerEvent *e)
  void cbs_timerEvent_1730_0(QTimerEvent *e)
  {
    QUndoView::timerEvent(e);
  }

  virtual void timerEvent(QTimerEvent *e)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QUndoView_Adaptor, QTimerEvent *>(&QUndoView_Adaptor::cbs_timerEvent_1730_0, e);
    } else {
      QUndoView::timerEvent(e);
    }
  }

  //  [adaptor impl] void QUndoView::updateEditorData()
  void cbs_updateEditorData_0_0()
  {
    QUndoView::updateEditorData();
  }

  virtual void updateEditorData()
  {
    if (cb_updateEditorData_0_0.can_issue()) {
      cb_updateEditorData_0_0.issue<QUndoView_Adaptor>(&QUndoView_Adaptor::cbs_updateEditorData_0_0);
    } else {
      QUndoView::updateEditorData();
    }
  }

  //  [adaptor impl] void QUndoView::updateEditorGeometries()
  void cbs_updateEditorGeometries_0_0()
  {
    QUndoView::updateEditorGeometries();
  }

  virtual void updateEditorGeometries()
  {
    if (cb_updateEditorGeometries_0_0.can_issue()) {
      cb_updateEditorGeometries_0_0.issue<QUndoView_Adaptor>(&QUndoView_Adaptor::cbs_updateEditorGeometries_0_0);
    } else {
      QUndoView::updateEditorGeometries();
    }
  }

  //  [adaptor impl] void QUndoView::updateGeometries()
  void cbs_updateGeometries_0_0()
  {
    QUndoView::updateGeometries();
  }

  virtual void updateGeometries()
  {
    if (cb_updateGeometries_0_0.can_issue()) {
      cb_updateGeometries_0_0.issue<QUndoView_Adaptor>(&QUndoView_Adaptor::cbs_updateGeometries_0_0);
    } else {
      QUndoView::updateGeometries();
    }
  }

  //  [adaptor impl] int QUndoView::verticalOffset()
  int cbs_verticalOffset_c0_0() const
  {
    return QUndoView::verticalOffset();
  }

  virtual int verticalOffset() const
  {
    if (cb_verticalOffset_c0_0.can_issue()) {
      return cb_verticalOffset_c0_0.issue<QUndoView_Adaptor, int>(&QUndoView_Adaptor::cbs_verticalOffset_c0_0);
    } else {
      return QUndoView::verticalOffset();
    }
  }

  //  [adaptor impl] void QUndoView::verticalScrollbarAction(int action)
  void cbs_verticalScrollbarAction_767_0(int action)
  {
    QUndoView::verticalScrollbarAction(action);
  }

  virtual void verticalScrollbarAction(int action)
  {
    if (cb_verticalScrollbarAction_767_0.can_issue()) {
      cb_verticalScrollbarAction_767_0.issue<QUndoView_Adaptor, int>(&QUndoView_Adaptor::cbs_verticalScrollbarAction_767_0, action);
    } else {
      QUndoView::verticalScrollbarAction(action);
    }
  }

  //  [adaptor impl] void QUndoView::verticalScrollbarValueChanged(int value)
  void cbs_verticalScrollbarValueChanged_767_0(int value)
  {
    QUndoView::verticalScrollbarValueChanged(value);
  }

  virtual void verticalScrollbarValueChanged(int value)
  {
    if (cb_verticalScrollbarValueChanged_767_0.can_issue()) {
      cb_verticalScrollbarValueChanged_767_0.issue<QUndoView_Adaptor, int>(&QUndoView_Adaptor::cbs_verticalScrollbarValueChanged_767_0, value);
    } else {
      QUndoView::verticalScrollbarValueChanged(value);
    }
  }

  //  [adaptor impl] QStyleOptionViewItem QUndoView::viewOptions()
  QStyleOptionViewItem cbs_viewOptions_c0_0() const
  {
    return QUndoView::viewOptions();
  }

  virtual QStyleOptionViewItem viewOptions() const
  {
    if (cb_viewOptions_c0_0.can_issue()) {
      return cb_viewOptions_c0_0.issue<QUndoView_Adaptor, QStyleOptionViewItem>(&QUndoView_Adaptor::cbs_viewOptions_c0_0);
    } else {
      return QUndoView::viewOptions();
    }
  }

  //  [adaptor impl] bool QUndoView::viewportEvent(QEvent *event)
  bool cbs_viewportEvent_1217_0(QEvent *event)
  {
    return QUndoView::viewportEvent(event);
  }

  virtual bool viewportEvent(QEvent *event)
  {
    if (cb_viewportEvent_1217_0.can_issue()) {
      return cb_viewportEvent_1217_0.issue<QUndoView_Adaptor, bool, QEvent *>(&QUndoView_Adaptor::cbs_viewportEvent_1217_0, event);
    } else {
      return QUndoView::viewportEvent(event);
    }
  }

  //  [adaptor impl] QRegion QUndoView::visualRegionForSelection(const QItemSelection &selection)
  QRegion cbs_visualRegionForSelection_c2727_0(const QItemSelection &selection) const
  {
    return QUndoView::visualRegionForSelection(selection);
  }

  virtual QRegion visualRegionForSelection(const QItemSelection &selection) const
  {
    if (cb_visualRegionForSelection_c2727_0.can_issue()) {
      return cb_visualRegionForSelection_c2727_0.issue<QUndoView_Adaptor, QRegion, const QItemSelection &>(&QUndoView_Adaptor::cbs_visualRegionForSelection_c2727_0, selection);
    } else {
      return QUndoView::visualRegionForSelection(selection);
    }
  }

  //  [adaptor impl] void QUndoView::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QUndoView::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QUndoView_Adaptor, QWheelEvent *>(&QUndoView_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QUndoView::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QUndoView::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QUndoView::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QUndoView_Adaptor, bool>(&QUndoView_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QUndoView::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_doItemsLayout_0_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_indexAt_c1916_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_keyboardSearch_2025_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_reset_0_0;
  gsi::Callback cb_scrollTo_5576_1;
  gsi::Callback cb_selectAll_0_0;
  gsi::Callback cb_setModel_2419_0;
  gsi::Callback cb_setRootIndex_2395_0;
  gsi::Callback cb_setSelectionModel_2533_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_sizeHintForColumn_c767_0;
  gsi::Callback cb_sizeHintForRow_c767_0;
  gsi::Callback cb_visualRect_c2395_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEditor_4926_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_commitData_1315_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_currentChanged_4682_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_dataChanged_4682_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_edit_6773_0;
  gsi::Callback cb_editorDestroyed_1302_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_horizontalOffset_c0_0;
  gsi::Callback cb_horizontalScrollbarAction_767_0;
  gsi::Callback cb_horizontalScrollbarValueChanged_767_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_isIndexHidden_c2395_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveCursor_6476_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_rowsAboutToBeRemoved_3713_0;
  gsi::Callback cb_rowsInserted_3713_0;
  gsi::Callback cb_scrollContentsBy_1426_0;
  gsi::Callback cb_selectedIndexes_c0_0;
  gsi::Callback cb_selectionChanged_5346_0;
  gsi::Callback cb_selectionCommand_c4199_1;
  gsi::Callback cb_setSelection_6155_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_startDrag_2456_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_updateEditorData_0_0;
  gsi::Callback cb_updateEditorGeometries_0_0;
  gsi::Callback cb_updateGeometries_0_0;
  gsi::Callback cb_verticalOffset_c0_0;
  gsi::Callback cb_verticalScrollbarAction_767_0;
  gsi::Callback cb_verticalScrollbarValueChanged_767_0;
  gsi::Callback cb_viewOptions_c0_0;
  gsi::Callback cb_viewportEvent_1217_0;
  gsi::Callback cb_visualRegionForSelection_c2727_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QUndoView_Adaptor::~QUndoView_Adaptor() { }

//  Constructor QUndoView::QUndoView(QWidget *parent) (adaptor class)

static void _init_ctor_QUndoView_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QUndoView_Adaptor *> ();
}

static void _call_ctor_QUndoView_Adaptor_1315 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QUndoView_Adaptor *> (new QUndoView_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QUndoView_Adaptor_1315 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUndoView::QUndoView(QWidget *parent)\nThis method creates an object of class QUndoView.", &_init_ctor_QUndoView_Adaptor_1315, &_call_ctor_QUndoView_Adaptor_1315);
}

//  Constructor QUndoView::QUndoView(QUndoStack *stack, QWidget *parent) (adaptor class)

static void _init_ctor_QUndoView_Adaptor_2818 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stack");
  decl->add_arg<QUndoStack * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return_new<QUndoView_Adaptor *> ();
}

static void _call_ctor_QUndoView_Adaptor_2818 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QUndoStack *arg1 = args.read<QUndoStack * > ();
  QWidget *arg2 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QUndoView_Adaptor *> (new QUndoView_Adaptor (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QUndoView_Adaptor_2818 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUndoView::QUndoView(QUndoStack *stack, QWidget *parent)\nThis method creates an object of class QUndoView.", &_init_ctor_QUndoView_Adaptor_2818, &_call_ctor_QUndoView_Adaptor_2818);
}

//  Constructor QUndoView::QUndoView(QUndoGroup *group, QWidget *parent) (adaptor class)

static void _init_ctor_QUndoView_Adaptor_2841 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("group");
  decl->add_arg<QUndoGroup * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return_new<QUndoView_Adaptor *> ();
}

static void _call_ctor_QUndoView_Adaptor_2841 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QUndoGroup *arg1 = args.read<QUndoGroup * > ();
  QWidget *arg2 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QUndoView_Adaptor *> (new QUndoView_Adaptor (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QUndoView_Adaptor_2841 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUndoView::QUndoView(QUndoGroup *group, QWidget *parent)\nThis method creates an object of class QUndoView.", &_init_ctor_QUndoView_Adaptor_2841, &_call_ctor_QUndoView_Adaptor_2841);
}

// QSize QUndoView::contentsSize()

static void _init_fp_contentsSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_fp_contentsSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QUndoView_Adaptor *)cls)->fp_QUndoView_contentsSize_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_contentsSize_c0 ()
{
  return new qt_gsi::GenericMethod("*contentsSize", "@brief Method QSize QUndoView::contentsSize()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_contentsSize_c0, &_call_fp_contentsSize_c0);
}


// void QUndoView::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QUndoView::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QUndoView::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QUndoView::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// QPoint QUndoView::dirtyRegionOffset()

static void _init_fp_dirtyRegionOffset_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_fp_dirtyRegionOffset_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPoint > ((QPoint)((QUndoView_Adaptor *)cls)->fp_QUndoView_dirtyRegionOffset_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_dirtyRegionOffset_c0 ()
{
  return new qt_gsi::GenericMethod("*dirtyRegionOffset", "@brief Method QPoint QUndoView::dirtyRegionOffset()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_dirtyRegionOffset_c0, &_call_fp_dirtyRegionOffset_c0);
}


// void QUndoView::doAutoScroll()

static void _init_fp_doAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_doAutoScroll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_doAutoScroll_0 ();
}

static qt_gsi::GenericMethod*_create_fp_doAutoScroll_0 ()
{
  return new qt_gsi::GenericMethod("*doAutoScroll", "@brief Method void QUndoView::doAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_doAutoScroll_0, &_call_fp_doAutoScroll_0);
}


// void QUndoView::drawFrame(QPainter *)

static void _init_fp_drawFrame_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawFrame_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_drawFrame_1426 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_drawFrame_1426 ()
{
  return new qt_gsi::GenericMethod("*drawFrame", "@brief Method void QUndoView::drawFrame(QPainter *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawFrame_1426, &_call_fp_drawFrame_1426);
}


// QAbstractItemView::DropIndicatorPosition QUndoView::dropIndicatorPosition()

static void _init_fp_dropIndicatorPosition_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_fp_dropIndicatorPosition_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<unsigned int > ((unsigned int)((QUndoView_Adaptor *)cls)->fp_QUndoView_dropIndicatorPosition_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_dropIndicatorPosition_c0 ()
{
  return new qt_gsi::GenericMethod("*dropIndicatorPosition", "@brief Method QAbstractItemView::DropIndicatorPosition QUndoView::dropIndicatorPosition()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_dropIndicatorPosition_c0, &_call_fp_dropIndicatorPosition_c0);
}


// void QUndoView::executeDelayedItemsLayout()

static void _init_fp_executeDelayedItemsLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_executeDelayedItemsLayout_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_executeDelayedItemsLayout_0 ();
}

static qt_gsi::GenericMethod*_create_fp_executeDelayedItemsLayout_0 ()
{
  return new qt_gsi::GenericMethod("*executeDelayedItemsLayout", "@brief Method void QUndoView::executeDelayedItemsLayout()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_executeDelayedItemsLayout_0, &_call_fp_executeDelayedItemsLayout_0);
}


// bool QUndoView::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUndoView_Adaptor *)cls)->fp_QUndoView_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QUndoView::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QUndoView::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUndoView_Adaptor *)cls)->fp_QUndoView_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QUndoView::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// int QUndoView::horizontalStepsPerItem()

static void _init_fp_horizontalStepsPerItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_horizontalStepsPerItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QUndoView_Adaptor *)cls)->fp_QUndoView_horizontalStepsPerItem_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_horizontalStepsPerItem_c0 ()
{
  return new qt_gsi::GenericMethod("*horizontalStepsPerItem", "@brief Method int QUndoView::horizontalStepsPerItem()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_horizontalStepsPerItem_c0, &_call_fp_horizontalStepsPerItem_c0);
}


// void QUndoView::internalDrag(QFlags<Qt::DropAction> supportedActions)

static void _init_fp_internalDrag_2456 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("supportedActions");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_internalDrag_2456 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & > ();
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_internalDrag_2456 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_internalDrag_2456 ()
{
  return new qt_gsi::GenericMethod("*internalDrag", "@brief Method void QUndoView::internalDrag(QFlags<Qt::DropAction> supportedActions)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_internalDrag_2456, &_call_fp_internalDrag_2456);
}


// void QUndoView::internalDrop(QDropEvent *e)

static void _init_fp_internalDrop_1622 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_internalDrop_1622 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_internalDrop_1622 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_internalDrop_1622 ()
{
  return new qt_gsi::GenericMethod("*internalDrop", "@brief Method void QUndoView::internalDrop(QDropEvent *e)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_internalDrop_1622, &_call_fp_internalDrop_1622);
}


// int QUndoView::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QUndoView_Adaptor *)cls)->fp_QUndoView_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QUndoView::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QRect QUndoView::rectForIndex(const QModelIndex &index)

static void _init_fp_rectForIndex_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_fp_rectForIndex_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QRect > ((QRect)((QUndoView_Adaptor *)cls)->fp_QUndoView_rectForIndex_c2395 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_rectForIndex_c2395 ()
{
  return new qt_gsi::GenericMethod("*rectForIndex", "@brief Method QRect QUndoView::rectForIndex(const QModelIndex &index)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_rectForIndex_c2395, &_call_fp_rectForIndex_c2395);
}


// void QUndoView::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QUndoView::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// void QUndoView::resizeContents(int width, int height)

static void _init_fp_resizeContents_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("height");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_resizeContents_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_resizeContents_1426 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_resizeContents_1426 ()
{
  return new qt_gsi::GenericMethod("*resizeContents", "@brief Method void QUndoView::resizeContents(int width, int height)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resizeContents_1426, &_call_fp_resizeContents_1426);
}


// void QUndoView::scheduleDelayedItemsLayout()

static void _init_fp_scheduleDelayedItemsLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_scheduleDelayedItemsLayout_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_scheduleDelayedItemsLayout_0 ();
}

static qt_gsi::GenericMethod*_create_fp_scheduleDelayedItemsLayout_0 ()
{
  return new qt_gsi::GenericMethod("*scheduleDelayedItemsLayout", "@brief Method void QUndoView::scheduleDelayedItemsLayout()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_scheduleDelayedItemsLayout_0, &_call_fp_scheduleDelayedItemsLayout_0);
}


// void QUndoView::scrollDirtyRegion(int dx, int dy)

static void _init_fp_scrollDirtyRegion_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_scrollDirtyRegion_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_scrollDirtyRegion_1426 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_scrollDirtyRegion_1426 ()
{
  return new qt_gsi::GenericMethod("*scrollDirtyRegion", "@brief Method void QUndoView::scrollDirtyRegion(int dx, int dy)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_scrollDirtyRegion_1426, &_call_fp_scrollDirtyRegion_1426);
}


// QObject *QUndoView::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QUndoView_Adaptor *)cls)->fp_QUndoView_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QUndoView::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QUndoView::setDirtyRegion(const QRegion &region)

static void _init_fp_setDirtyRegion_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("region");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setDirtyRegion_2006 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegion &arg1 = args.read<const QRegion & > ();
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_setDirtyRegion_2006 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setDirtyRegion_2006 ()
{
  return new qt_gsi::GenericMethod("*setDirtyRegion", "@brief Method void QUndoView::setDirtyRegion(const QRegion &region)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setDirtyRegion_2006, &_call_fp_setDirtyRegion_2006);
}


// void QUndoView::setHorizontalStepsPerItem(int steps)

static void _init_fp_setHorizontalStepsPerItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("steps");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setHorizontalStepsPerItem_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_setHorizontalStepsPerItem_767 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setHorizontalStepsPerItem_767 ()
{
  return new qt_gsi::GenericMethod("*setHorizontalStepsPerItem", "@brief Method void QUndoView::setHorizontalStepsPerItem(int steps)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setHorizontalStepsPerItem_767, &_call_fp_setHorizontalStepsPerItem_767);
}


// void QUndoView::setPositionForIndex(const QPoint &position, const QModelIndex &index)

static void _init_fp_setPositionForIndex_4203 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_setPositionForIndex_4203 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_setPositionForIndex_4203 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_setPositionForIndex_4203 ()
{
  return new qt_gsi::GenericMethod("*setPositionForIndex", "@brief Method void QUndoView::setPositionForIndex(const QPoint &position, const QModelIndex &index)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setPositionForIndex_4203, &_call_fp_setPositionForIndex_4203);
}


// void QUndoView::setState(QAbstractItemView::State state)

static void _init_fp_setState_2776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setState_2776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_setState_2776 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setState_2776 ()
{
  return new qt_gsi::GenericMethod("*setState", "@brief Method void QUndoView::setState(QAbstractItemView::State state)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setState_2776, &_call_fp_setState_2776);
}


// void QUndoView::setVerticalStepsPerItem(int steps)

static void _init_fp_setVerticalStepsPerItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("steps");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setVerticalStepsPerItem_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_setVerticalStepsPerItem_767 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setVerticalStepsPerItem_767 ()
{
  return new qt_gsi::GenericMethod("*setVerticalStepsPerItem", "@brief Method void QUndoView::setVerticalStepsPerItem(int steps)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setVerticalStepsPerItem_767, &_call_fp_setVerticalStepsPerItem_767);
}


// void QUndoView::setViewportMargins(int left, int top, int right, int bottom)

static void _init_fp_setViewportMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_setViewportMargins_2744 (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod*_create_fp_setViewportMargins_2744 ()
{
  return new qt_gsi::GenericMethod("*setViewportMargins", "@brief Method void QUndoView::setViewportMargins(int left, int top, int right, int bottom)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2744, &_call_fp_setViewportMargins_2744);
}


// void QUndoView::setViewportMargins(const QMargins &margins)

static void _init_fp_setViewportMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2115 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMargins &arg1 = args.read<const QMargins & > ();
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_setViewportMargins_2115 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setViewportMargins_2115 ()
{
  return new qt_gsi::GenericMethod("*setViewportMargins", "@brief Method void QUndoView::setViewportMargins(const QMargins &margins)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2115, &_call_fp_setViewportMargins_2115);
}


// void QUndoView::setupViewport(QWidget *viewport)

static void _init_fp_setupViewport_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewport");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setupViewport_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_setupViewport_1315 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setupViewport_1315 ()
{
  return new qt_gsi::GenericMethod("*setupViewport", "@brief Method void QUndoView::setupViewport(QWidget *viewport)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setupViewport_1315, &_call_fp_setupViewport_1315);
}


// void QUndoView::startAutoScroll()

static void _init_fp_startAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_startAutoScroll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_startAutoScroll_0 ();
}

static qt_gsi::GenericMethod*_create_fp_startAutoScroll_0 ()
{
  return new qt_gsi::GenericMethod("*startAutoScroll", "@brief Method void QUndoView::startAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_startAutoScroll_0, &_call_fp_startAutoScroll_0);
}


// QAbstractItemView::State QUndoView::state()

static void _init_fp_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_fp_state_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<unsigned int > ((unsigned int)((QUndoView_Adaptor *)cls)->fp_QUndoView_state_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_state_c0 ()
{
  return new qt_gsi::GenericMethod("*state", "@brief Method QAbstractItemView::State QUndoView::state()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_state_c0, &_call_fp_state_c0);
}


// void QUndoView::stopAutoScroll()

static void _init_fp_stopAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_stopAutoScroll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_stopAutoScroll_0 ();
}

static qt_gsi::GenericMethod*_create_fp_stopAutoScroll_0 ()
{
  return new qt_gsi::GenericMethod("*stopAutoScroll", "@brief Method void QUndoView::stopAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_stopAutoScroll_0, &_call_fp_stopAutoScroll_0);
}


// void QUndoView::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUndoView_Adaptor *)cls)->fp_QUndoView_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QUndoView::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// int QUndoView::verticalStepsPerItem()

static void _init_fp_verticalStepsPerItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_verticalStepsPerItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QUndoView_Adaptor *)cls)->fp_QUndoView_verticalStepsPerItem_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_verticalStepsPerItem_c0 ()
{
  return new qt_gsi::GenericMethod("*verticalStepsPerItem", "@brief Method int QUndoView::verticalStepsPerItem()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_verticalStepsPerItem_c0, &_call_fp_verticalStepsPerItem_c0);
}


// void QUndoView::doItemsLayout()

static void _init_cbs_doItemsLayout_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_doItemsLayout_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUndoView_Adaptor *)cls)->cbs_doItemsLayout_0_0 ();
}

static void _set_callback_cbs_doItemsLayout_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_doItemsLayout_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_doItemsLayout_0_0 ()
{
  return new qt_gsi::GenericMethod ("doItemsLayout", "@hide", false, &_init_cbs_doItemsLayout_0_0, &_call_cbs_doItemsLayout_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_doItemsLayout_0_0 ()
{
  return new qt_gsi::GenericMethod ("doItemsLayout", "@brief Virtual method void QUndoView::doItemsLayout()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_doItemsLayout_0_0, &_call_cbs_doItemsLayout_0_0, &_set_callback_cbs_doItemsLayout_0_0);
}


// bool QUndoView::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QUndoView_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QUndoView::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// int QUndoView::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QUndoView_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QUndoView::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// QModelIndex QUndoView::indexAt(const QPoint &p)

static void _init_cbs_indexAt_c1916_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_indexAt_c1916_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QModelIndex > ((QModelIndex)((QUndoView_Adaptor *)cls)->cbs_indexAt_c1916_0 (arg1));
}

static void _set_callback_cbs_indexAt_c1916_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_indexAt_c1916_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_indexAt_c1916_0 ()
{
  return new qt_gsi::GenericMethod ("indexAt", "@hide", true, &_init_cbs_indexAt_c1916_0, &_call_cbs_indexAt_c1916_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_indexAt_c1916_0 ()
{
  return new qt_gsi::GenericMethod ("indexAt", "@brief Virtual method QModelIndex QUndoView::indexAt(const QPoint &p)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexAt_c1916_0, &_call_cbs_indexAt_c1916_0, &_set_callback_cbs_indexAt_c1916_0);
}


// QVariant QUndoView::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QUndoView_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QUndoView::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// void QUndoView::keyboardSearch(const QString &search)

static void _init_cbs_keyboardSearch_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("search");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyboardSearch_2025_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUndoView_Adaptor *)cls)->cbs_keyboardSearch_2025_0 (arg1);
}

static void _set_callback_cbs_keyboardSearch_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_keyboardSearch_2025_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyboardSearch_2025_0 ()
{
  return new qt_gsi::GenericMethod ("keyboardSearch", "@hide", false, &_init_cbs_keyboardSearch_2025_0, &_call_cbs_keyboardSearch_2025_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyboardSearch_2025_0 ()
{
  return new qt_gsi::GenericMethod ("keyboardSearch", "@brief Virtual method void QUndoView::keyboardSearch(const QString &search)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyboardSearch_2025_0, &_call_cbs_keyboardSearch_2025_0, &_set_callback_cbs_keyboardSearch_2025_0);
}


// QSize QUndoView::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QUndoView_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QUndoView::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// QPaintEngine *QUndoView::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QUndoView_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QUndoView::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QUndoView::reset()

static void _init_cbs_reset_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reset_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUndoView_Adaptor *)cls)->cbs_reset_0_0 ();
}

static void _set_callback_cbs_reset_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_reset_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_reset_0_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@hide", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_reset_0_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@brief Virtual method void QUndoView::reset()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0, &_set_callback_cbs_reset_0_0);
}


// void QUndoView::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)

static void _init_cbs_scrollTo_5576_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollTo_5576_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > ();
  ((QUndoView_Adaptor *)cls)->cbs_scrollTo_5576_1 (arg1, arg2);
}

static void _set_callback_cbs_scrollTo_5576_1 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_scrollTo_5576_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_scrollTo_5576_1 ()
{
  return new qt_gsi::GenericMethod ("scrollTo", "@hide", false, &_init_cbs_scrollTo_5576_1, &_call_cbs_scrollTo_5576_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_scrollTo_5576_1 ()
{
  return new qt_gsi::GenericMethod ("scrollTo", "@brief Virtual method void QUndoView::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollTo_5576_1, &_call_cbs_scrollTo_5576_1, &_set_callback_cbs_scrollTo_5576_1);
}


// void QUndoView::selectAll()

static void _init_cbs_selectAll_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_selectAll_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUndoView_Adaptor *)cls)->cbs_selectAll_0_0 ();
}

static void _set_callback_cbs_selectAll_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_selectAll_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectAll_0_0 ()
{
  return new qt_gsi::GenericMethod ("selectAll", "@hide", false, &_init_cbs_selectAll_0_0, &_call_cbs_selectAll_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectAll_0_0 ()
{
  return new qt_gsi::GenericMethod ("selectAll", "@brief Virtual method void QUndoView::selectAll()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectAll_0_0, &_call_cbs_selectAll_0_0, &_set_callback_cbs_selectAll_0_0);
}


// void QUndoView::setModel(QAbstractItemModel *model)

static void _init_cbs_setModel_2419_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setModel_2419_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractItemModel *arg1 = args.read<QAbstractItemModel * > ();
  ((QUndoView_Adaptor *)cls)->cbs_setModel_2419_0 (arg1);
}

static void _set_callback_cbs_setModel_2419_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_setModel_2419_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setModel_2419_0 ()
{
  return new qt_gsi::GenericMethod ("setModel", "@hide", false, &_init_cbs_setModel_2419_0, &_call_cbs_setModel_2419_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setModel_2419_0 ()
{
  return new qt_gsi::GenericMethod ("setModel", "@brief Virtual method void QUndoView::setModel(QAbstractItemModel *model)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setModel_2419_0, &_call_cbs_setModel_2419_0, &_set_callback_cbs_setModel_2419_0);
}


// void QUndoView::setRootIndex(const QModelIndex &index)

static void _init_cbs_setRootIndex_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setRootIndex_2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QUndoView_Adaptor *)cls)->cbs_setRootIndex_2395_0 (arg1);
}

static void _set_callback_cbs_setRootIndex_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_setRootIndex_2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setRootIndex_2395_0 ()
{
  return new qt_gsi::GenericMethod ("setRootIndex", "@hide", false, &_init_cbs_setRootIndex_2395_0, &_call_cbs_setRootIndex_2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setRootIndex_2395_0 ()
{
  return new qt_gsi::GenericMethod ("setRootIndex", "@brief Virtual method void QUndoView::setRootIndex(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setRootIndex_2395_0, &_call_cbs_setRootIndex_2395_0, &_set_callback_cbs_setRootIndex_2395_0);
}


// void QUndoView::setSelectionModel(QItemSelectionModel *selectionModel)

static void _init_cbs_setSelectionModel_2533_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selectionModel");
  decl->add_arg<QItemSelectionModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSelectionModel_2533_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QItemSelectionModel *arg1 = args.read<QItemSelectionModel * > ();
  ((QUndoView_Adaptor *)cls)->cbs_setSelectionModel_2533_0 (arg1);
}

static void _set_callback_cbs_setSelectionModel_2533_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_setSelectionModel_2533_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setSelectionModel_2533_0 ()
{
  return new qt_gsi::GenericMethod ("setSelectionModel", "@hide", false, &_init_cbs_setSelectionModel_2533_0, &_call_cbs_setSelectionModel_2533_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setSelectionModel_2533_0 ()
{
  return new qt_gsi::GenericMethod ("setSelectionModel", "@brief Virtual method void QUndoView::setSelectionModel(QItemSelectionModel *selectionModel)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSelectionModel_2533_0, &_call_cbs_setSelectionModel_2533_0, &_set_callback_cbs_setSelectionModel_2533_0);
}


// void QUndoView::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QUndoView_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QUndoView::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// QSize QUndoView::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QUndoView_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QUndoView::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// int QUndoView::sizeHintForColumn(int column)

static void _init_cbs_sizeHintForColumn_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_sizeHintForColumn_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QUndoView_Adaptor *)cls)->cbs_sizeHintForColumn_c767_0 (arg1));
}

static void _set_callback_cbs_sizeHintForColumn_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_sizeHintForColumn_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHintForColumn_c767_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForColumn", "@hide", true, &_init_cbs_sizeHintForColumn_c767_0, &_call_cbs_sizeHintForColumn_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHintForColumn_c767_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForColumn", "@brief Virtual method int QUndoView::sizeHintForColumn(int column)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHintForColumn_c767_0, &_call_cbs_sizeHintForColumn_c767_0, &_set_callback_cbs_sizeHintForColumn_c767_0);
}


// int QUndoView::sizeHintForRow(int row)

static void _init_cbs_sizeHintForRow_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_sizeHintForRow_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QUndoView_Adaptor *)cls)->cbs_sizeHintForRow_c767_0 (arg1));
}

static void _set_callback_cbs_sizeHintForRow_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_sizeHintForRow_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHintForRow_c767_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForRow", "@hide", true, &_init_cbs_sizeHintForRow_c767_0, &_call_cbs_sizeHintForRow_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHintForRow_c767_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForRow", "@brief Virtual method int QUndoView::sizeHintForRow(int row)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHintForRow_c767_0, &_call_cbs_sizeHintForRow_c767_0, &_set_callback_cbs_sizeHintForRow_c767_0);
}


// QRect QUndoView::visualRect(const QModelIndex &index)

static void _init_cbs_visualRect_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_cbs_visualRect_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QRect > ((QRect)((QUndoView_Adaptor *)cls)->cbs_visualRect_c2395_0 (arg1));
}

static void _set_callback_cbs_visualRect_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_visualRect_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_visualRect_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("visualRect", "@hide", true, &_init_cbs_visualRect_c2395_0, &_call_cbs_visualRect_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_visualRect_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("visualRect", "@brief Virtual method QRect QUndoView::visualRect(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_visualRect_c2395_0, &_call_cbs_visualRect_c2395_0, &_set_callback_cbs_visualRect_c2395_0);
}


// void QUndoView::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QUndoView::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QUndoView::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QUndoView::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QUndoView::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QUndoView::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QUndoView::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)

static void _init_cbs_closeEditor_4926_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_closeEditor_4926_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > ();
  ((QUndoView_Adaptor *)cls)->cbs_closeEditor_4926_0 (arg1, arg2);
}

static void _set_callback_cbs_closeEditor_4926_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_closeEditor_4926_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEditor_4926_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEditor", "@hide", false, &_init_cbs_closeEditor_4926_0, &_call_cbs_closeEditor_4926_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEditor_4926_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEditor", "@brief Virtual method void QUndoView::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEditor_4926_0, &_call_cbs_closeEditor_4926_0, &_set_callback_cbs_closeEditor_4926_0);
}


// void QUndoView::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QUndoView::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QUndoView::commitData(QWidget *editor)

static void _init_cbs_commitData_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_commitData_1315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QUndoView_Adaptor *)cls)->cbs_commitData_1315_0 (arg1);
}

static void _set_callback_cbs_commitData_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_commitData_1315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_commitData_1315_0 ()
{
  return new qt_gsi::GenericMethod ("*commitData", "@hide", false, &_init_cbs_commitData_1315_0, &_call_cbs_commitData_1315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_commitData_1315_0 ()
{
  return new qt_gsi::GenericMethod ("*commitData", "@brief Virtual method void QUndoView::commitData(QWidget *editor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_commitData_1315_0, &_call_cbs_commitData_1315_0, &_set_callback_cbs_commitData_1315_0);
}


// void QUndoView::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QUndoView::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QUndoView::currentChanged(const QModelIndex &current, const QModelIndex &previous)

static void _init_cbs_currentChanged_4682_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("current");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("previous");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_currentChanged_4682_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QUndoView_Adaptor *)cls)->cbs_currentChanged_4682_0 (arg1, arg2);
}

static void _set_callback_cbs_currentChanged_4682_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_currentChanged_4682_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_currentChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("*currentChanged", "@hide", false, &_init_cbs_currentChanged_4682_0, &_call_cbs_currentChanged_4682_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_currentChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("*currentChanged", "@brief Virtual method void QUndoView::currentChanged(const QModelIndex &current, const QModelIndex &previous)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_currentChanged_4682_0, &_call_cbs_currentChanged_4682_0, &_set_callback_cbs_currentChanged_4682_0);
}


// void QUndoView::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QUndoView::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QUndoView::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)

static void _init_cbs_dataChanged_4682_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topLeft");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bottomRight");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_dataChanged_4682_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QUndoView_Adaptor *)cls)->cbs_dataChanged_4682_0 (arg1, arg2);
}

static void _set_callback_cbs_dataChanged_4682_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_dataChanged_4682_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dataChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("*dataChanged", "@hide", false, &_init_cbs_dataChanged_4682_0, &_call_cbs_dataChanged_4682_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dataChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("*dataChanged", "@brief Virtual method void QUndoView::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dataChanged_4682_0, &_call_cbs_dataChanged_4682_0, &_set_callback_cbs_dataChanged_4682_0);
}


// void QUndoView::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QUndoView_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QUndoView::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QUndoView::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QUndoView::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QUndoView::dragLeaveEvent(QDragLeaveEvent *e)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QUndoView::dragLeaveEvent(QDragLeaveEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QUndoView::dragMoveEvent(QDragMoveEvent *e)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QUndoView::dragMoveEvent(QDragMoveEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// void QUndoView::dropEvent(QDropEvent *e)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QUndoView::dropEvent(QDropEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// bool QUndoView::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)

static void _init_cbs_edit_6773_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("trigger");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("event");
  decl->add_arg<QEvent * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_edit_6773_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & > ();
  QEvent *arg3 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QUndoView_Adaptor *)cls)->cbs_edit_6773_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_edit_6773_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_edit_6773_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_edit_6773_0 ()
{
  return new qt_gsi::GenericMethod ("*edit", "@hide", false, &_init_cbs_edit_6773_0, &_call_cbs_edit_6773_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_edit_6773_0 ()
{
  return new qt_gsi::GenericMethod ("*edit", "@brief Virtual method bool QUndoView::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_edit_6773_0, &_call_cbs_edit_6773_0, &_set_callback_cbs_edit_6773_0);
}


// void QUndoView::editorDestroyed(QObject *editor)

static void _init_cbs_editorDestroyed_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_editorDestroyed_1302_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  ((QUndoView_Adaptor *)cls)->cbs_editorDestroyed_1302_0 (arg1);
}

static void _set_callback_cbs_editorDestroyed_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_editorDestroyed_1302_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_editorDestroyed_1302_0 ()
{
  return new qt_gsi::GenericMethod ("*editorDestroyed", "@hide", false, &_init_cbs_editorDestroyed_1302_0, &_call_cbs_editorDestroyed_1302_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_editorDestroyed_1302_0 ()
{
  return new qt_gsi::GenericMethod ("*editorDestroyed", "@brief Virtual method void QUndoView::editorDestroyed(QObject *editor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_editorDestroyed_1302_0, &_call_cbs_editorDestroyed_1302_0, &_set_callback_cbs_editorDestroyed_1302_0);
}


// void QUndoView::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QUndoView_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QUndoView::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QUndoView::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QUndoView::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// bool QUndoView::event(QEvent *e)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QUndoView_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QUndoView::event(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QUndoView::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QUndoView::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QUndoView::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QUndoView_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QUndoView::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QUndoView::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QUndoView::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QUndoView::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QUndoView_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QUndoView::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QUndoView::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QUndoView::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// int QUndoView::horizontalOffset()

static void _init_cbs_horizontalOffset_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_horizontalOffset_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QUndoView_Adaptor *)cls)->cbs_horizontalOffset_c0_0 ());
}

static void _set_callback_cbs_horizontalOffset_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_horizontalOffset_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_horizontalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalOffset", "@hide", true, &_init_cbs_horizontalOffset_c0_0, &_call_cbs_horizontalOffset_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_horizontalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalOffset", "@brief Virtual method int QUndoView::horizontalOffset()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_horizontalOffset_c0_0, &_call_cbs_horizontalOffset_c0_0, &_set_callback_cbs_horizontalOffset_c0_0);
}


// void QUndoView::horizontalScrollbarAction(int action)

static void _init_cbs_horizontalScrollbarAction_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_horizontalScrollbarAction_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QUndoView_Adaptor *)cls)->cbs_horizontalScrollbarAction_767_0 (arg1);
}

static void _set_callback_cbs_horizontalScrollbarAction_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_horizontalScrollbarAction_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_horizontalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarAction", "@hide", false, &_init_cbs_horizontalScrollbarAction_767_0, &_call_cbs_horizontalScrollbarAction_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_horizontalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarAction", "@brief Virtual method void QUndoView::horizontalScrollbarAction(int action)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_horizontalScrollbarAction_767_0, &_call_cbs_horizontalScrollbarAction_767_0, &_set_callback_cbs_horizontalScrollbarAction_767_0);
}


// void QUndoView::horizontalScrollbarValueChanged(int value)

static void _init_cbs_horizontalScrollbarValueChanged_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_horizontalScrollbarValueChanged_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QUndoView_Adaptor *)cls)->cbs_horizontalScrollbarValueChanged_767_0 (arg1);
}

static void _set_callback_cbs_horizontalScrollbarValueChanged_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_horizontalScrollbarValueChanged_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_horizontalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarValueChanged", "@hide", false, &_init_cbs_horizontalScrollbarValueChanged_767_0, &_call_cbs_horizontalScrollbarValueChanged_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_horizontalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarValueChanged", "@brief Virtual method void QUndoView::horizontalScrollbarValueChanged(int value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_horizontalScrollbarValueChanged_767_0, &_call_cbs_horizontalScrollbarValueChanged_767_0, &_set_callback_cbs_horizontalScrollbarValueChanged_767_0);
}


// void QUndoView::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QUndoView::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// bool QUndoView::isIndexHidden(const QModelIndex &index)

static void _init_cbs_isIndexHidden_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isIndexHidden_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QUndoView_Adaptor *)cls)->cbs_isIndexHidden_c2395_0 (arg1));
}

static void _set_callback_cbs_isIndexHidden_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_isIndexHidden_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_isIndexHidden_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("*isIndexHidden", "@hide", true, &_init_cbs_isIndexHidden_c2395_0, &_call_cbs_isIndexHidden_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_isIndexHidden_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("*isIndexHidden", "@brief Virtual method bool QUndoView::isIndexHidden(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isIndexHidden_c2395_0, &_call_cbs_isIndexHidden_c2395_0, &_set_callback_cbs_isIndexHidden_c2395_0);
}


// void QUndoView::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QUndoView::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QUndoView::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QUndoView::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QUndoView::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUndoView_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QUndoView::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QUndoView::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QUndoView::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QUndoView::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QUndoView_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QUndoView::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// void QUndoView::mouseDoubleClickEvent(QMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QUndoView::mouseDoubleClickEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QUndoView::mouseMoveEvent(QMouseEvent *e)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QUndoView::mouseMoveEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QUndoView::mousePressEvent(QMouseEvent *event)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QUndoView::mousePressEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QUndoView::mouseReleaseEvent(QMouseEvent *e)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QUndoView::mouseReleaseEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// QModelIndex QUndoView::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)

static void _init_cbs_moveCursor_6476_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursorAction");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("modifiers");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & > (argspec_1);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_moveCursor_6476_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & > ();
  ret.write<QModelIndex > ((QModelIndex)((QUndoView_Adaptor *)cls)->cbs_moveCursor_6476_0 (arg1, arg2));
}

static void _set_callback_cbs_moveCursor_6476_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_moveCursor_6476_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveCursor_6476_0 ()
{
  return new qt_gsi::GenericMethod ("*moveCursor", "@hide", false, &_init_cbs_moveCursor_6476_0, &_call_cbs_moveCursor_6476_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveCursor_6476_0 ()
{
  return new qt_gsi::GenericMethod ("*moveCursor", "@brief Virtual method QModelIndex QUndoView::moveCursor(QAbstractItemView::CursorAction cursorAction, QFlags<Qt::KeyboardModifier> modifiers)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveCursor_6476_0, &_call_cbs_moveCursor_6476_0, &_set_callback_cbs_moveCursor_6476_0);
}


// void QUndoView::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QUndoView::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QUndoView::paintEvent(QPaintEvent *e)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QUndoView::paintEvent(QPaintEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QUndoView::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QUndoView_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QUndoView::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QUndoView::resizeEvent(QResizeEvent *e)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QUndoView::resizeEvent(QResizeEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QUndoView::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)

static void _init_cbs_rowsAboutToBeRemoved_3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_rowsAboutToBeRemoved_3713_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QUndoView_Adaptor *)cls)->cbs_rowsAboutToBeRemoved_3713_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_rowsAboutToBeRemoved_3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_rowsAboutToBeRemoved_3713_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_rowsAboutToBeRemoved_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsAboutToBeRemoved", "@hide", false, &_init_cbs_rowsAboutToBeRemoved_3713_0, &_call_cbs_rowsAboutToBeRemoved_3713_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_rowsAboutToBeRemoved_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsAboutToBeRemoved", "@brief Virtual method void QUndoView::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_rowsAboutToBeRemoved_3713_0, &_call_cbs_rowsAboutToBeRemoved_3713_0, &_set_callback_cbs_rowsAboutToBeRemoved_3713_0);
}


// void QUndoView::rowsInserted(const QModelIndex &parent, int start, int end)

static void _init_cbs_rowsInserted_3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_rowsInserted_3713_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QUndoView_Adaptor *)cls)->cbs_rowsInserted_3713_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_rowsInserted_3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_rowsInserted_3713_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_rowsInserted_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsInserted", "@hide", false, &_init_cbs_rowsInserted_3713_0, &_call_cbs_rowsInserted_3713_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_rowsInserted_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsInserted", "@brief Virtual method void QUndoView::rowsInserted(const QModelIndex &parent, int start, int end)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_rowsInserted_3713_0, &_call_cbs_rowsInserted_3713_0, &_set_callback_cbs_rowsInserted_3713_0);
}


// void QUndoView::scrollContentsBy(int dx, int dy)

static void _init_cbs_scrollContentsBy_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollContentsBy_1426_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QUndoView_Adaptor *)cls)->cbs_scrollContentsBy_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_scrollContentsBy_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_scrollContentsBy_1426_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_scrollContentsBy_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*scrollContentsBy", "@hide", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_scrollContentsBy_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*scrollContentsBy", "@brief Virtual method void QUndoView::scrollContentsBy(int dx, int dy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0, &_set_callback_cbs_scrollContentsBy_1426_0);
}


// QList<QModelIndex> QUndoView::selectedIndexes()

static void _init_cbs_selectedIndexes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QModelIndex> >::target_type > ();
}

static void _call_cbs_selectedIndexes_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QModelIndex> >::target_type > ((qt_gsi::Converter<QList<QModelIndex> >::target_type)((QUndoView_Adaptor *)cls)->cbs_selectedIndexes_c0_0 ());
}

static void _set_callback_cbs_selectedIndexes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_selectedIndexes_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectedIndexes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*selectedIndexes", "@hide", true, &_init_cbs_selectedIndexes_c0_0, &_call_cbs_selectedIndexes_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectedIndexes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*selectedIndexes", "@brief Virtual method QList<QModelIndex> QUndoView::selectedIndexes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectedIndexes_c0_0, &_call_cbs_selectedIndexes_c0_0, &_set_callback_cbs_selectedIndexes_c0_0);
}


// void QUndoView::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)

static void _init_cbs_selectionChanged_5346_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selected");
  decl->add_arg<const QItemSelection & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("deselected");
  decl->add_arg<const QItemSelection & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_selectionChanged_5346_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QItemSelection &arg1 = args.read<const QItemSelection & > ();
  const QItemSelection &arg2 = args.read<const QItemSelection & > ();
  ((QUndoView_Adaptor *)cls)->cbs_selectionChanged_5346_0 (arg1, arg2);
}

static void _set_callback_cbs_selectionChanged_5346_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_selectionChanged_5346_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectionChanged_5346_0 ()
{
  return new qt_gsi::GenericMethod ("*selectionChanged", "@hide", false, &_init_cbs_selectionChanged_5346_0, &_call_cbs_selectionChanged_5346_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectionChanged_5346_0 ()
{
  return new qt_gsi::GenericMethod ("*selectionChanged", "@brief Virtual method void QUndoView::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectionChanged_5346_0, &_call_cbs_selectionChanged_5346_0, &_set_callback_cbs_selectionChanged_5346_0);
}


// QFlags<QItemSelectionModel::SelectionFlag> QUndoView::selectionCommand(const QModelIndex &index, const QEvent *event)

static void _init_cbs_selectionCommand_c4199_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<const QEvent * > (argspec_1);
  decl->set_return<qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type > ();
}

static void _call_cbs_selectionCommand_c4199_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QEvent *arg2 = args.read<const QEvent * > ();
  ret.write<qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type > ((qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type)((QUndoView_Adaptor *)cls)->cbs_selectionCommand_c4199_1 (arg1, arg2));
}

static void _set_callback_cbs_selectionCommand_c4199_1 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_selectionCommand_c4199_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectionCommand_c4199_1 ()
{
  return new qt_gsi::GenericMethod ("*selectionCommand", "@hide", true, &_init_cbs_selectionCommand_c4199_1, &_call_cbs_selectionCommand_c4199_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectionCommand_c4199_1 ()
{
  return new qt_gsi::GenericMethod ("*selectionCommand", "@brief Virtual method QFlags<QItemSelectionModel::SelectionFlag> QUndoView::selectionCommand(const QModelIndex &index, const QEvent *event)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectionCommand_c4199_1, &_call_cbs_selectionCommand_c4199_1, &_set_callback_cbs_selectionCommand_c4199_1);
}


// void QUndoView::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)

static void _init_cbs_setSelection_6155_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("command");
  decl->add_arg<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setSelection_6155_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > ();
  ((QUndoView_Adaptor *)cls)->cbs_setSelection_6155_0 (arg1, arg2);
}

static void _set_callback_cbs_setSelection_6155_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_setSelection_6155_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setSelection_6155_0 ()
{
  return new qt_gsi::GenericMethod ("*setSelection", "@hide", false, &_init_cbs_setSelection_6155_0, &_call_cbs_setSelection_6155_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setSelection_6155_0 ()
{
  return new qt_gsi::GenericMethod ("*setSelection", "@brief Virtual method void QUndoView::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> command)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSelection_6155_0, &_call_cbs_setSelection_6155_0, &_set_callback_cbs_setSelection_6155_0);
}


// void QUndoView::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QUndoView::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// void QUndoView::startDrag(QFlags<Qt::DropAction> supportedActions)

static void _init_cbs_startDrag_2456_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("supportedActions");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_startDrag_2456_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & > ();
  ((QUndoView_Adaptor *)cls)->cbs_startDrag_2456_0 (arg1);
}

static void _set_callback_cbs_startDrag_2456_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_startDrag_2456_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_startDrag_2456_0 ()
{
  return new qt_gsi::GenericMethod ("*startDrag", "@hide", false, &_init_cbs_startDrag_2456_0, &_call_cbs_startDrag_2456_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_startDrag_2456_0 ()
{
  return new qt_gsi::GenericMethod ("*startDrag", "@brief Virtual method void QUndoView::startDrag(QFlags<Qt::DropAction> supportedActions)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_startDrag_2456_0, &_call_cbs_startDrag_2456_0, &_set_callback_cbs_startDrag_2456_0);
}


// void QUndoView::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QUndoView_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QUndoView::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// void QUndoView::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QUndoView::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QUndoView::timerEvent(QTimerEvent *e)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QUndoView::timerEvent(QTimerEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QUndoView::updateEditorData()

static void _init_cbs_updateEditorData_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorData_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUndoView_Adaptor *)cls)->cbs_updateEditorData_0_0 ();
}

static void _set_callback_cbs_updateEditorData_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_updateEditorData_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_updateEditorData_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorData", "@hide", false, &_init_cbs_updateEditorData_0_0, &_call_cbs_updateEditorData_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_updateEditorData_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorData", "@brief Virtual method void QUndoView::updateEditorData()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateEditorData_0_0, &_call_cbs_updateEditorData_0_0, &_set_callback_cbs_updateEditorData_0_0);
}


// void QUndoView::updateEditorGeometries()

static void _init_cbs_updateEditorGeometries_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorGeometries_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUndoView_Adaptor *)cls)->cbs_updateEditorGeometries_0_0 ();
}

static void _set_callback_cbs_updateEditorGeometries_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_updateEditorGeometries_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_updateEditorGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorGeometries", "@hide", false, &_init_cbs_updateEditorGeometries_0_0, &_call_cbs_updateEditorGeometries_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_updateEditorGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorGeometries", "@brief Virtual method void QUndoView::updateEditorGeometries()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateEditorGeometries_0_0, &_call_cbs_updateEditorGeometries_0_0, &_set_callback_cbs_updateEditorGeometries_0_0);
}


// void QUndoView::updateGeometries()

static void _init_cbs_updateGeometries_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateGeometries_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QUndoView_Adaptor *)cls)->cbs_updateGeometries_0_0 ();
}

static void _set_callback_cbs_updateGeometries_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_updateGeometries_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_updateGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateGeometries", "@hide", false, &_init_cbs_updateGeometries_0_0, &_call_cbs_updateGeometries_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_updateGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateGeometries", "@brief Virtual method void QUndoView::updateGeometries()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateGeometries_0_0, &_call_cbs_updateGeometries_0_0, &_set_callback_cbs_updateGeometries_0_0);
}


// int QUndoView::verticalOffset()

static void _init_cbs_verticalOffset_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_verticalOffset_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QUndoView_Adaptor *)cls)->cbs_verticalOffset_c0_0 ());
}

static void _set_callback_cbs_verticalOffset_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_verticalOffset_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_verticalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalOffset", "@hide", true, &_init_cbs_verticalOffset_c0_0, &_call_cbs_verticalOffset_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_verticalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalOffset", "@brief Virtual method int QUndoView::verticalOffset()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_verticalOffset_c0_0, &_call_cbs_verticalOffset_c0_0, &_set_callback_cbs_verticalOffset_c0_0);
}


// void QUndoView::verticalScrollbarAction(int action)

static void _init_cbs_verticalScrollbarAction_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_verticalScrollbarAction_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QUndoView_Adaptor *)cls)->cbs_verticalScrollbarAction_767_0 (arg1);
}

static void _set_callback_cbs_verticalScrollbarAction_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_verticalScrollbarAction_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_verticalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarAction", "@hide", false, &_init_cbs_verticalScrollbarAction_767_0, &_call_cbs_verticalScrollbarAction_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_verticalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarAction", "@brief Virtual method void QUndoView::verticalScrollbarAction(int action)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_verticalScrollbarAction_767_0, &_call_cbs_verticalScrollbarAction_767_0, &_set_callback_cbs_verticalScrollbarAction_767_0);
}


// void QUndoView::verticalScrollbarValueChanged(int value)

static void _init_cbs_verticalScrollbarValueChanged_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_verticalScrollbarValueChanged_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QUndoView_Adaptor *)cls)->cbs_verticalScrollbarValueChanged_767_0 (arg1);
}

static void _set_callback_cbs_verticalScrollbarValueChanged_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_verticalScrollbarValueChanged_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_verticalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarValueChanged", "@hide", false, &_init_cbs_verticalScrollbarValueChanged_767_0, &_call_cbs_verticalScrollbarValueChanged_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_verticalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarValueChanged", "@brief Virtual method void QUndoView::verticalScrollbarValueChanged(int value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_verticalScrollbarValueChanged_767_0, &_call_cbs_verticalScrollbarValueChanged_767_0, &_set_callback_cbs_verticalScrollbarValueChanged_767_0);
}


// QStyleOptionViewItem QUndoView::viewOptions()

static void _init_cbs_viewOptions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStyleOptionViewItem > ();
}

static void _call_cbs_viewOptions_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QStyleOptionViewItem > ((QStyleOptionViewItem)((QUndoView_Adaptor *)cls)->cbs_viewOptions_c0_0 ());
}

static void _set_callback_cbs_viewOptions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_viewOptions_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_viewOptions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*viewOptions", "@hide", true, &_init_cbs_viewOptions_c0_0, &_call_cbs_viewOptions_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_viewOptions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*viewOptions", "@brief Virtual method QStyleOptionViewItem QUndoView::viewOptions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_viewOptions_c0_0, &_call_cbs_viewOptions_c0_0, &_set_callback_cbs_viewOptions_c0_0);
}


// bool QUndoView::viewportEvent(QEvent *event)

static void _init_cbs_viewportEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_viewportEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QUndoView_Adaptor *)cls)->cbs_viewportEvent_1217_0 (arg1));
}

static void _set_callback_cbs_viewportEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_viewportEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_viewportEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*viewportEvent", "@hide", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_viewportEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*viewportEvent", "@brief Virtual method bool QUndoView::viewportEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0, &_set_callback_cbs_viewportEvent_1217_0);
}


// QRegion QUndoView::visualRegionForSelection(const QItemSelection &selection)

static void _init_cbs_visualRegionForSelection_c2727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  decl->set_return<QRegion > ();
}

static void _call_cbs_visualRegionForSelection_c2727_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QItemSelection &arg1 = args.read<const QItemSelection & > ();
  ret.write<QRegion > ((QRegion)((QUndoView_Adaptor *)cls)->cbs_visualRegionForSelection_c2727_0 (arg1));
}

static void _set_callback_cbs_visualRegionForSelection_c2727_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_visualRegionForSelection_c2727_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_visualRegionForSelection_c2727_0 ()
{
  return new qt_gsi::GenericMethod ("*visualRegionForSelection", "@hide", true, &_init_cbs_visualRegionForSelection_c2727_0, &_call_cbs_visualRegionForSelection_c2727_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_visualRegionForSelection_c2727_0 ()
{
  return new qt_gsi::GenericMethod ("*visualRegionForSelection", "@brief Virtual method QRegion QUndoView::visualRegionForSelection(const QItemSelection &selection)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_visualRegionForSelection_c2727_0, &_call_cbs_visualRegionForSelection_c2727_0, &_set_callback_cbs_visualRegionForSelection_c2727_0);
}


// void QUndoView::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QUndoView_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QUndoView::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QUndoView::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QUndoView_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QUndoView_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QUndoView::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QUndoView> decl_QUndoView;

gsi::Class<QUndoView_Adaptor> decl_QUndoView_Adaptor (decl_QUndoView, "QUndoView",
  gsi::Methods(_create_fp_contentsSize_c0 ()) +
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_dirtyRegionOffset_c0 ()) +
  gsi::Methods(_create_fp_doAutoScroll_0 ()) +
  gsi::Methods(_create_fp_drawFrame_1426 ()) +
  gsi::Methods(_create_fp_dropIndicatorPosition_c0 ()) +
  gsi::Methods(_create_fp_executeDelayedItemsLayout_0 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_horizontalStepsPerItem_c0 ()) +
  gsi::Methods(_create_fp_internalDrag_2456 ()) +
  gsi::Methods(_create_fp_internalDrop_1622 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_rectForIndex_c2395 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_resizeContents_1426 ()) +
  gsi::Methods(_create_fp_scheduleDelayedItemsLayout_0 ()) +
  gsi::Methods(_create_fp_scrollDirtyRegion_1426 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_setDirtyRegion_2006 ()) +
  gsi::Methods(_create_fp_setHorizontalStepsPerItem_767 ()) +
  gsi::Methods(_create_fp_setPositionForIndex_4203 ()) +
  gsi::Methods(_create_fp_setState_2776 ()) +
  gsi::Methods(_create_fp_setVerticalStepsPerItem_767 ()) +
  gsi::Methods(_create_fp_setViewportMargins_2744 ()) +
  gsi::Methods(_create_fp_setViewportMargins_2115 ()) +
  gsi::Methods(_create_fp_setupViewport_1315 ()) +
  gsi::Methods(_create_fp_startAutoScroll_0 ()) +
  gsi::Methods(_create_fp_state_c0 ()) +
  gsi::Methods(_create_fp_stopAutoScroll_0 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_fp_verticalStepsPerItem_c0 ()) +
  gsi::Methods(_create_cbs_doItemsLayout_0_0 ()) +
  gsi::Methods(_create_callback_cbs_doItemsLayout_0_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_indexAt_c1916_0 ()) +
  gsi::Methods(_create_callback_cbs_indexAt_c1916_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_keyboardSearch_2025_0 ()) +
  gsi::Methods(_create_callback_cbs_keyboardSearch_2025_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_reset_0_0 ()) +
  gsi::Methods(_create_callback_cbs_reset_0_0 ()) +
  gsi::Methods(_create_cbs_scrollTo_5576_1 ()) +
  gsi::Methods(_create_callback_cbs_scrollTo_5576_1 ()) +
  gsi::Methods(_create_cbs_selectAll_0_0 ()) +
  gsi::Methods(_create_callback_cbs_selectAll_0_0 ()) +
  gsi::Methods(_create_cbs_setModel_2419_0 ()) +
  gsi::Methods(_create_callback_cbs_setModel_2419_0 ()) +
  gsi::Methods(_create_cbs_setRootIndex_2395_0 ()) +
  gsi::Methods(_create_callback_cbs_setRootIndex_2395_0 ()) +
  gsi::Methods(_create_cbs_setSelectionModel_2533_0 ()) +
  gsi::Methods(_create_callback_cbs_setSelectionModel_2533_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_sizeHintForColumn_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHintForColumn_c767_0 ()) +
  gsi::Methods(_create_cbs_sizeHintForRow_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHintForRow_c767_0 ()) +
  gsi::Methods(_create_cbs_visualRect_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_visualRect_c2395_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEditor_4926_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEditor_4926_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_commitData_1315_0 ()) +
  gsi::Methods(_create_callback_cbs_commitData_1315_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_currentChanged_4682_0 ()) +
  gsi::Methods(_create_callback_cbs_currentChanged_4682_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_dataChanged_4682_0 ()) +
  gsi::Methods(_create_callback_cbs_dataChanged_4682_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_edit_6773_0 ()) +
  gsi::Methods(_create_callback_cbs_edit_6773_0 ()) +
  gsi::Methods(_create_cbs_editorDestroyed_1302_0 ()) +
  gsi::Methods(_create_callback_cbs_editorDestroyed_1302_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_horizontalOffset_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_horizontalOffset_c0_0 ()) +
  gsi::Methods(_create_cbs_horizontalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_callback_cbs_horizontalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_cbs_horizontalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_callback_cbs_horizontalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_isIndexHidden_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_isIndexHidden_c2395_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveCursor_6476_0 ()) +
  gsi::Methods(_create_callback_cbs_moveCursor_6476_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_rowsAboutToBeRemoved_3713_0 ()) +
  gsi::Methods(_create_callback_cbs_rowsAboutToBeRemoved_3713_0 ()) +
  gsi::Methods(_create_cbs_rowsInserted_3713_0 ()) +
  gsi::Methods(_create_callback_cbs_rowsInserted_3713_0 ()) +
  gsi::Methods(_create_cbs_scrollContentsBy_1426_0 ()) +
  gsi::Methods(_create_callback_cbs_scrollContentsBy_1426_0 ()) +
  gsi::Methods(_create_cbs_selectedIndexes_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_selectedIndexes_c0_0 ()) +
  gsi::Methods(_create_cbs_selectionChanged_5346_0 ()) +
  gsi::Methods(_create_callback_cbs_selectionChanged_5346_0 ()) +
  gsi::Methods(_create_cbs_selectionCommand_c4199_1 ()) +
  gsi::Methods(_create_callback_cbs_selectionCommand_c4199_1 ()) +
  gsi::Methods(_create_cbs_setSelection_6155_0 ()) +
  gsi::Methods(_create_callback_cbs_setSelection_6155_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_startDrag_2456_0 ()) +
  gsi::Methods(_create_callback_cbs_startDrag_2456_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_updateEditorData_0_0 ()) +
  gsi::Methods(_create_callback_cbs_updateEditorData_0_0 ()) +
  gsi::Methods(_create_cbs_updateEditorGeometries_0_0 ()) +
  gsi::Methods(_create_callback_cbs_updateEditorGeometries_0_0 ()) +
  gsi::Methods(_create_cbs_updateGeometries_0_0 ()) +
  gsi::Methods(_create_callback_cbs_updateGeometries_0_0 ()) +
  gsi::Methods(_create_cbs_verticalOffset_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_verticalOffset_c0_0 ()) +
  gsi::Methods(_create_cbs_verticalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_callback_cbs_verticalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_cbs_verticalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_callback_cbs_verticalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_cbs_viewOptions_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_viewOptions_c0_0 ()) +
  gsi::Methods(_create_cbs_viewportEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_viewportEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_visualRegionForSelection_c2727_0 ()) +
  gsi::Methods(_create_callback_cbs_visualRegionForSelection_c2727_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QUndoView_Adaptor_1315 ()) +
  gsi::Methods(_create_ctor_QUndoView_Adaptor_2818 ()) +
  gsi::Methods(_create_ctor_QUndoView_Adaptor_2841 ()),
  "@qt\n@brief Binding of QUndoView");

}

