
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTranslator.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQTranslator_EventAdaptor.h"
#include "gsiDeclQTranslator_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTranslator

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QTranslator::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// bool QTranslator::isEmpty()


static void _init_f_isEmpty_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEmpty_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTranslator *)cls)->isEmpty ());
}

static qt_gsi::GenericMethod *_create_f_isEmpty_c0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty?", "@brief Method bool QTranslator::isEmpty()\n", true, &_init_f_isEmpty_c0, &_call_f_isEmpty_c0);
}

// bool QTranslator::load(const QString &filename, const QString &directory, const QString &search_delimiters, const QString &suffix)


static void _init_f_load_7776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filename");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("directory", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("search_delimiters", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("suffix", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_f_load_7776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args ? args.read<const QString & > () : (const QString &)(QString());
  const QString &arg3 = args ? args.read<const QString & > () : (const QString &)(QString());
  const QString &arg4 = args ? args.read<const QString & > () : (const QString &)(QString());
  ret.write<bool > ((bool)((QTranslator *)cls)->load (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_load_7776 ()
{
  return new qt_gsi::GenericMethod ("load", "@brief Method bool QTranslator::load(const QString &filename, const QString &directory, const QString &search_delimiters, const QString &suffix)\n", false, &_init_f_load_7776, &_call_f_load_7776);
}

// bool QTranslator::load(const unsigned char *data, int len)


static void _init_f_load_3395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const unsigned char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("len");
  decl->add_arg<int > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_load_3395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const unsigned char *arg1 = args.read<const unsigned char * > ();
  int arg2 = args.read<int > ();
  ret.write<bool > ((bool)((QTranslator *)cls)->load (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_load_3395 ()
{
  return new qt_gsi::GenericMethod ("load", "@brief Method bool QTranslator::load(const unsigned char *data, int len)\n", false, &_init_f_load_3395, &_call_f_load_3395);
}

// QString QTranslator::translate(const char *context, const char *sourceText, const char *disambiguation)


static void _init_f_translate_c4977 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("context");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceText");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("disambiguation", true, "0");
  decl->add_arg<const char * > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_translate_c4977 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  const char *arg3 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)((QTranslator *)cls)->translate (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_translate_c4977 ()
{
  return new qt_gsi::GenericMethod ("translate", "@brief Method QString QTranslator::translate(const char *context, const char *sourceText, const char *disambiguation)\n", true, &_init_f_translate_c4977, &_call_f_translate_c4977);
}

// QString QTranslator::translate(const char *context, const char *sourceText, const char *disambiguation, int n)


static void _init_f_translate_c5636 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("context");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceText");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("disambiguation");
  decl->add_arg<const char * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("n");
  decl->add_arg<int > (argspec_3);
  decl->set_return<QString > ();
}

static void _call_f_translate_c5636 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  const char *arg3 = args.read<const char * > ();
  int arg4 = args.read<int > ();
  ret.write<QString > ((QString)((QTranslator *)cls)->translate (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_translate_c5636 ()
{
  return new qt_gsi::GenericMethod ("translate", "@brief Method QString QTranslator::translate(const char *context, const char *sourceText, const char *disambiguation, int n)\n", true, &_init_f_translate_c5636, &_call_f_translate_c5636);
}

// static QString QTranslator::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QTranslator::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTranslator::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QTranslator::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QTranslator::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTranslator::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QTranslator::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QTranslator::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTranslator::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QTranslator::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QTranslator::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTranslator::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QTranslator, QTranslator_EventAdaptor> ea_QTranslator;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QTranslator> decl_QTranslator (ea_QTranslator, decl_QObject, "QTranslator_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_isEmpty_c0 ()) +
  gsi::Methods(_create_f_load_7776 ()) +
  gsi::Methods(_create_f_load_3395 ()) +
  gsi::Methods(_create_f_translate_c4977 ()) +
  gsi::Methods(_create_f_translate_c5636 ()) +
  qt_gsi::qt_signal<QTranslator, QTranslator_EventAdaptor, QObject *> ("destroyed", &QTranslator_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QTranslator::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QTranslator");
}


class QTranslator_Adaptor : public QTranslator, public qt_gsi::QtObjectBase
{
public:

  virtual ~QTranslator_Adaptor();

  //  [adaptor ctor] QTranslator::QTranslator(QObject *parent)
  QTranslator_Adaptor() : QTranslator()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTranslator::QTranslator(QObject *parent)
  QTranslator_Adaptor(QObject *parent) : QTranslator(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QTranslator::receivers(const char *signal)
  int fp_QTranslator_receivers_c1731 (const char *signal) const {
    return QTranslator::receivers(signal);
  }

  //  QObject *QTranslator::sender()
  QObject * fp_QTranslator_sender_c0 () const {
    return QTranslator::sender();
  }

  //  [adaptor impl] bool QTranslator::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QTranslator::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QTranslator_Adaptor, bool, QEvent *>(&QTranslator_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QTranslator::event(arg1);
    }
  }

  //  [adaptor impl] bool QTranslator::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QTranslator::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QTranslator_Adaptor, bool, QObject *, QEvent *>(&QTranslator_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QTranslator::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QTranslator::isEmpty()
  bool cbs_isEmpty_c0_0() const
  {
    return QTranslator::isEmpty();
  }

  virtual bool isEmpty() const
  {
    if (cb_isEmpty_c0_0.can_issue()) {
      return cb_isEmpty_c0_0.issue<QTranslator_Adaptor, bool>(&QTranslator_Adaptor::cbs_isEmpty_c0_0);
    } else {
      return QTranslator::isEmpty();
    }
  }

  //  [adaptor impl] QString QTranslator::translate(const char *context, const char *sourceText, const char *disambiguation)
  QString cbs_translate_c4977_1(const char *context, const char *sourceText, const char *disambiguation) const
  {
    return QTranslator::translate(context, sourceText, disambiguation);
  }

  virtual QString translate(const char *context, const char *sourceText, const char *disambiguation) const
  {
    if (cb_translate_c4977_1.can_issue()) {
      return cb_translate_c4977_1.issue<QTranslator_Adaptor, QString, const char *, const char *, const char *>(&QTranslator_Adaptor::cbs_translate_c4977_1, context, sourceText, disambiguation);
    } else {
      return QTranslator::translate(context, sourceText, disambiguation);
    }
  }

  //  [adaptor impl] void QTranslator::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QTranslator::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QTranslator_Adaptor, QChildEvent *>(&QTranslator_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QTranslator::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QTranslator::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QTranslator::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QTranslator_Adaptor, QEvent *>(&QTranslator_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QTranslator::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QTranslator::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QTranslator::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QTranslator_Adaptor, const char *>(&QTranslator_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QTranslator::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QTranslator::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QTranslator::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QTranslator_Adaptor, QTimerEvent *>(&QTranslator_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QTranslator::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isEmpty_c0_0;
  gsi::Callback cb_translate_c4977_1;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QTranslator_Adaptor::~QTranslator_Adaptor() { }

//  Constructor QTranslator::QTranslator(QObject *parent) (adaptor class)

static void _init_ctor_QTranslator_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QTranslator_Adaptor *> ();
}

static void _call_ctor_QTranslator_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QTranslator_Adaptor *> (new QTranslator_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTranslator_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTranslator::QTranslator(QObject *parent)\nThis method creates an object of class QTranslator.", &_init_ctor_QTranslator_Adaptor_1302, &_call_ctor_QTranslator_Adaptor_1302);
}

// int QTranslator::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QTranslator_Adaptor *)cls)->fp_QTranslator_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QTranslator::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QTranslator::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QTranslator_Adaptor *)cls)->fp_QTranslator_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QTranslator::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QTranslator::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QTranslator_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTranslator_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QTranslator::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QTranslator::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QTranslator_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QTranslator_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QTranslator::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// bool QTranslator::isEmpty()

static void _init_cbs_isEmpty_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isEmpty_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTranslator_Adaptor *)cls)->cbs_isEmpty_c0_0 ());
}

static void _set_callback_cbs_isEmpty_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTranslator_Adaptor *)cls)->cb_isEmpty_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_isEmpty_c0_0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty", "@hide", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_isEmpty_c0_0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty", "@brief Virtual method bool QTranslator::isEmpty()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0, &_set_callback_cbs_isEmpty_c0_0);
}


// QString QTranslator::translate(const char *context, const char *sourceText, const char *disambiguation)

static void _init_cbs_translate_c4977_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("context");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceText");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("disambiguation");
  decl->add_arg<const char * > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_cbs_translate_c4977_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  const char *arg3 = args.read<const char * > ();
  ret.write<QString > ((QString)((QTranslator_Adaptor *)cls)->cbs_translate_c4977_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_translate_c4977_1 (void *cls, const gsi::Callback &cb)
{
  ((QTranslator_Adaptor *)cls)->cb_translate_c4977_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_translate_c4977_1 ()
{
  return new qt_gsi::GenericMethod ("translate", "@hide", true, &_init_cbs_translate_c4977_1, &_call_cbs_translate_c4977_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_translate_c4977_1 ()
{
  return new qt_gsi::GenericMethod ("translate", "@brief Virtual method QString QTranslator::translate(const char *context, const char *sourceText, const char *disambiguation)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_translate_c4977_1, &_call_cbs_translate_c4977_1, &_set_callback_cbs_translate_c4977_1);
}


// void QTranslator::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QTranslator_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QTranslator_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QTranslator::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QTranslator::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QTranslator_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTranslator_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QTranslator::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QTranslator::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QTranslator_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QTranslator_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QTranslator::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QTranslator::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QTranslator_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QTranslator_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QTranslator::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QTranslator> decl_QTranslator;

gsi::Class<QTranslator_Adaptor> decl_QTranslator_Adaptor (decl_QTranslator, "QTranslator",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_isEmpty_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_isEmpty_c0_0 ()) +
  gsi::Methods(_create_cbs_translate_c4977_1 ()) +
  gsi::Methods(_create_callback_cbs_translate_c4977_1 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QTranslator_Adaptor_1302 ()),
  "@qt\n@brief Binding of QTranslator");

}

