
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTextTable.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQTextTable_EventAdaptor.h"
#include "gsiDeclQTextTable_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTextTable

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QTextTable::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QTextTable::appendColumns(int count)


static void _init_f_appendColumns_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("count");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_appendColumns_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTextTable *)cls)->appendColumns (arg1);
}

static qt_gsi::GenericMethod *_create_f_appendColumns_767 ()
{
  return new qt_gsi::GenericMethod ("appendColumns", "@brief Method void QTextTable::appendColumns(int count)\n", false, &_init_f_appendColumns_767, &_call_f_appendColumns_767);
}

// void QTextTable::appendRows(int count)


static void _init_f_appendRows_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("count");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_appendRows_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTextTable *)cls)->appendRows (arg1);
}

static qt_gsi::GenericMethod *_create_f_appendRows_767 ()
{
  return new qt_gsi::GenericMethod ("appendRows", "@brief Method void QTextTable::appendRows(int count)\n", false, &_init_f_appendRows_767, &_call_f_appendRows_767);
}

// QTextTableCell QTextTable::cellAt(int row, int col)


static void _init_f_cellAt_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("col");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QTextTableCell > ();
}

static void _call_f_cellAt_c1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<QTextTableCell > ((QTextTableCell)((QTextTable *)cls)->cellAt (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_cellAt_c1426 ()
{
  return new qt_gsi::GenericMethod ("cellAt", "@brief Method QTextTableCell QTextTable::cellAt(int row, int col)\n", true, &_init_f_cellAt_c1426, &_call_f_cellAt_c1426);
}

// QTextTableCell QTextTable::cellAt(int position)


static void _init_f_cellAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextTableCell > ();
}

static void _call_f_cellAt_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QTextTableCell > ((QTextTableCell)((QTextTable *)cls)->cellAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_cellAt_c767 ()
{
  return new qt_gsi::GenericMethod ("cellAt", "@brief Method QTextTableCell QTextTable::cellAt(int position)\n", true, &_init_f_cellAt_c767, &_call_f_cellAt_c767);
}

// QTextTableCell QTextTable::cellAt(const QTextCursor &c)


static void _init_f_cellAt_c2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<QTextTableCell > ();
}

static void _call_f_cellAt_c2453 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextCursor &arg1 = args.read<const QTextCursor & > ();
  ret.write<QTextTableCell > ((QTextTableCell)((QTextTable *)cls)->cellAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_cellAt_c2453 ()
{
  return new qt_gsi::GenericMethod ("cellAt", "@brief Method QTextTableCell QTextTable::cellAt(const QTextCursor &c)\n", true, &_init_f_cellAt_c2453, &_call_f_cellAt_c2453);
}

// int QTextTable::columns()


static void _init_f_columns_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_columns_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextTable *)cls)->columns ());
}

static qt_gsi::GenericMethod *_create_f_columns_c0 ()
{
  return new qt_gsi::GenericMethod ("columns", "@brief Method int QTextTable::columns()\n", true, &_init_f_columns_c0, &_call_f_columns_c0);
}

// QTextTableFormat QTextTable::format()


static void _init_f_format_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextTableFormat > ();
}

static void _call_f_format_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextTableFormat > ((QTextTableFormat)((QTextTable *)cls)->format ());
}

static qt_gsi::GenericMethod *_create_f_format_c0 ()
{
  return new qt_gsi::GenericMethod (":format", "@brief Method QTextTableFormat QTextTable::format()\n", true, &_init_f_format_c0, &_call_f_format_c0);
}

// void QTextTable::insertColumns(int pos, int num)


static void _init_f_insertColumns_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("num");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertColumns_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QTextTable *)cls)->insertColumns (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_insertColumns_1426 ()
{
  return new qt_gsi::GenericMethod ("insertColumns", "@brief Method void QTextTable::insertColumns(int pos, int num)\n", false, &_init_f_insertColumns_1426, &_call_f_insertColumns_1426);
}

// void QTextTable::insertRows(int pos, int num)


static void _init_f_insertRows_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("num");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertRows_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QTextTable *)cls)->insertRows (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_insertRows_1426 ()
{
  return new qt_gsi::GenericMethod ("insertRows", "@brief Method void QTextTable::insertRows(int pos, int num)\n", false, &_init_f_insertRows_1426, &_call_f_insertRows_1426);
}

// void QTextTable::mergeCells(int row, int col, int numRows, int numCols)


static void _init_f_mergeCells_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("col");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("numRows");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("numCols");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_mergeCells_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QTextTable *)cls)->mergeCells (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_mergeCells_2744 ()
{
  return new qt_gsi::GenericMethod ("mergeCells", "@brief Method void QTextTable::mergeCells(int row, int col, int numRows, int numCols)\n", false, &_init_f_mergeCells_2744, &_call_f_mergeCells_2744);
}

// void QTextTable::mergeCells(const QTextCursor &cursor)


static void _init_f_mergeCells_2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursor");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_mergeCells_2453 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextCursor &arg1 = args.read<const QTextCursor & > ();
  ((QTextTable *)cls)->mergeCells (arg1);
}

static qt_gsi::GenericMethod *_create_f_mergeCells_2453 ()
{
  return new qt_gsi::GenericMethod ("mergeCells", "@brief Method void QTextTable::mergeCells(const QTextCursor &cursor)\n", false, &_init_f_mergeCells_2453, &_call_f_mergeCells_2453);
}

// void QTextTable::removeColumns(int pos, int num)


static void _init_f_removeColumns_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("num");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_removeColumns_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QTextTable *)cls)->removeColumns (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_removeColumns_1426 ()
{
  return new qt_gsi::GenericMethod ("removeColumns", "@brief Method void QTextTable::removeColumns(int pos, int num)\n", false, &_init_f_removeColumns_1426, &_call_f_removeColumns_1426);
}

// void QTextTable::removeRows(int pos, int num)


static void _init_f_removeRows_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("num");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_removeRows_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QTextTable *)cls)->removeRows (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_removeRows_1426 ()
{
  return new qt_gsi::GenericMethod ("removeRows", "@brief Method void QTextTable::removeRows(int pos, int num)\n", false, &_init_f_removeRows_1426, &_call_f_removeRows_1426);
}

// void QTextTable::resize(int rows, int cols)


static void _init_f_resize_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rows");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cols");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_resize_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QTextTable *)cls)->resize (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_resize_1426 ()
{
  return new qt_gsi::GenericMethod ("resize", "@brief Method void QTextTable::resize(int rows, int cols)\n", false, &_init_f_resize_1426, &_call_f_resize_1426);
}

// QTextCursor QTextTable::rowEnd(const QTextCursor &c)


static void _init_f_rowEnd_c2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<QTextCursor > ();
}

static void _call_f_rowEnd_c2453 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextCursor &arg1 = args.read<const QTextCursor & > ();
  ret.write<QTextCursor > ((QTextCursor)((QTextTable *)cls)->rowEnd (arg1));
}

static qt_gsi::GenericMethod *_create_f_rowEnd_c2453 ()
{
  return new qt_gsi::GenericMethod ("rowEnd", "@brief Method QTextCursor QTextTable::rowEnd(const QTextCursor &c)\n", true, &_init_f_rowEnd_c2453, &_call_f_rowEnd_c2453);
}

// QTextCursor QTextTable::rowStart(const QTextCursor &c)


static void _init_f_rowStart_c2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<QTextCursor > ();
}

static void _call_f_rowStart_c2453 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextCursor &arg1 = args.read<const QTextCursor & > ();
  ret.write<QTextCursor > ((QTextCursor)((QTextTable *)cls)->rowStart (arg1));
}

static qt_gsi::GenericMethod *_create_f_rowStart_c2453 ()
{
  return new qt_gsi::GenericMethod ("rowStart", "@brief Method QTextCursor QTextTable::rowStart(const QTextCursor &c)\n", true, &_init_f_rowStart_c2453, &_call_f_rowStart_c2453);
}

// int QTextTable::rows()


static void _init_f_rows_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_rows_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextTable *)cls)->rows ());
}

static qt_gsi::GenericMethod *_create_f_rows_c0 ()
{
  return new qt_gsi::GenericMethod ("rows", "@brief Method int QTextTable::rows()\n", true, &_init_f_rows_c0, &_call_f_rows_c0);
}

// void QTextTable::setFormat(const QTextTableFormat &format)


static void _init_f_setFormat_2920 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextTableFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFormat_2920 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextTableFormat &arg1 = args.read<const QTextTableFormat & > ();
  ((QTextTable *)cls)->setFormat (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFormat_2920 ()
{
  return new qt_gsi::GenericMethod ("setFormat|format=", "@brief Method void QTextTable::setFormat(const QTextTableFormat &format)\n", false, &_init_f_setFormat_2920, &_call_f_setFormat_2920);
}

// void QTextTable::splitCell(int row, int col, int numRows, int numCols)


static void _init_f_splitCell_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("col");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("numRows");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("numCols");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_splitCell_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QTextTable *)cls)->splitCell (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_splitCell_2744 ()
{
  return new qt_gsi::GenericMethod ("splitCell", "@brief Method void QTextTable::splitCell(int row, int col, int numRows, int numCols)\n", false, &_init_f_splitCell_2744, &_call_f_splitCell_2744);
}

// static QString QTextTable::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QTextTable::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTextTable::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QTextTable::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QTextTable::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTextTable::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QTextTable::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QTextTable::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTextTable::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QTextTable::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QTextTable::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTextTable::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QTextTable, QTextTable_EventAdaptor> ea_QTextTable;

namespace gsi
{
extern gsi::Class<QTextFrame> decl_QTextFrame;

gsi::Class<QTextTable> decl_QTextTable (ea_QTextTable, decl_QTextFrame, "QTextTable_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_appendColumns_767 ()) +
  gsi::Methods(_create_f_appendRows_767 ()) +
  gsi::Methods(_create_f_cellAt_c1426 ()) +
  gsi::Methods(_create_f_cellAt_c767 ()) +
  gsi::Methods(_create_f_cellAt_c2453 ()) +
  gsi::Methods(_create_f_columns_c0 ()) +
  gsi::Methods(_create_f_format_c0 ()) +
  gsi::Methods(_create_f_insertColumns_1426 ()) +
  gsi::Methods(_create_f_insertRows_1426 ()) +
  gsi::Methods(_create_f_mergeCells_2744 ()) +
  gsi::Methods(_create_f_mergeCells_2453 ()) +
  gsi::Methods(_create_f_removeColumns_1426 ()) +
  gsi::Methods(_create_f_removeRows_1426 ()) +
  gsi::Methods(_create_f_resize_1426 ()) +
  gsi::Methods(_create_f_rowEnd_c2453 ()) +
  gsi::Methods(_create_f_rowStart_c2453 ()) +
  gsi::Methods(_create_f_rows_c0 ()) +
  gsi::Methods(_create_f_setFormat_2920 ()) +
  gsi::Methods(_create_f_splitCell_2744 ()) +
  qt_gsi::qt_signal<QTextTable, QTextTable_EventAdaptor, QObject *> ("destroyed", &QTextTable_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QTextTable::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QTextTable");
}


class QTextTable_Adaptor : public QTextTable, public qt_gsi::QtObjectBase
{
public:

  virtual ~QTextTable_Adaptor();

  //  [adaptor ctor] QTextTable::QTextTable(QTextDocument *doc)
  QTextTable_Adaptor(QTextDocument *doc) : QTextTable(doc)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QTextTable::receivers(const char *signal)
  int fp_QTextTable_receivers_c1731 (const char *signal) const {
    return QTextTable::receivers(signal);
  }

  //  QObject *QTextTable::sender()
  QObject * fp_QTextTable_sender_c0 () const {
    return QTextTable::sender();
  }

  //  [adaptor impl] bool QTextTable::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QTextTable::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QTextTable_Adaptor, bool, QEvent *>(&QTextTable_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QTextTable::event(arg1);
    }
  }

  //  [adaptor impl] bool QTextTable::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QTextTable::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QTextTable_Adaptor, bool, QObject *, QEvent *>(&QTextTable_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QTextTable::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QTextTable::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QTextTable::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QTextTable_Adaptor, QChildEvent *>(&QTextTable_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QTextTable::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QTextTable::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QTextTable::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QTextTable_Adaptor, QEvent *>(&QTextTable_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QTextTable::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QTextTable::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QTextTable::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QTextTable_Adaptor, const char *>(&QTextTable_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QTextTable::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QTextTable::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QTextTable::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QTextTable_Adaptor, QTimerEvent *>(&QTextTable_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QTextTable::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QTextTable_Adaptor::~QTextTable_Adaptor() { }

//  Constructor QTextTable::QTextTable(QTextDocument *doc) (adaptor class)

static void _init_ctor_QTextTable_Adaptor_1955 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("doc");
  decl->add_arg<QTextDocument * > (argspec_0);
  decl->set_return_new<QTextTable_Adaptor *> ();
}

static void _call_ctor_QTextTable_Adaptor_1955 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextDocument *arg1 = args.read<QTextDocument * > ();
  ret.write<QTextTable_Adaptor *> (new QTextTable_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextTable_Adaptor_1955 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextTable::QTextTable(QTextDocument *doc)\nThis method creates an object of class QTextTable.", &_init_ctor_QTextTable_Adaptor_1955, &_call_ctor_QTextTable_Adaptor_1955);
}

// int QTextTable::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QTextTable_Adaptor *)cls)->fp_QTextTable_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QTextTable::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QTextTable::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QTextTable_Adaptor *)cls)->fp_QTextTable_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QTextTable::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QTextTable::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QTextTable_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextTable_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QTextTable::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QTextTable::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QTextTable_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextTable_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QTextTable::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QTextTable::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QTextTable_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextTable_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QTextTable::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QTextTable::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QTextTable_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextTable_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QTextTable::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QTextTable::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QTextTable_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextTable_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QTextTable::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QTextTable::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QTextTable_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextTable_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QTextTable::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QTextTable> decl_QTextTable;

gsi::Class<QTextTable_Adaptor> decl_QTextTable_Adaptor (decl_QTextTable, "QTextTable",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QTextTable_Adaptor_1955 ()),
  "@qt\n@brief Binding of QTextTable");

}

