
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTextLine.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQTextLine_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTextLine

//  Constructor QTextLine::QTextLine()


static void _init_ctor_QTextLine_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QTextLine *> ();
}

static void _call_ctor_QTextLine_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextLine *> (new QTextLine ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextLine_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextLine::QTextLine()\nThis method creates an object of class QTextLine.", &_init_ctor_QTextLine_0, &_call_ctor_QTextLine_0);
}

// double QTextLine::ascent()


static void _init_f_ascent_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_ascent_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextLine *)cls)->ascent ());
}

static qt_gsi::GenericMethod *_create_f_ascent_c0 ()
{
  return new qt_gsi::GenericMethod ("ascent", "@brief Method double QTextLine::ascent()\n", true, &_init_f_ascent_c0, &_call_f_ascent_c0);
}

// double QTextLine::cursorToX(int *cursorPos, QTextLine::Edge edge)


static void _init_f_cursorToX_c2664 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursorPos");
  decl->add_arg<int * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("edge", true, "QTextLine::Leading");
  decl->add_arg<const qt_gsi::Converter<QTextLine::Edge>::target_type & > (argspec_1);
  decl->set_return<double > ();
}

static void _call_f_cursorToX_c2664 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int *arg1 = args.read<int * > ();
  tl::Heap heap;
  const qt_gsi::Converter<QTextLine::Edge>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QTextLine::Edge>::target_type & > () : (const qt_gsi::Converter<QTextLine::Edge>::target_type &)(qt_gsi::CppToQtReadAdaptor<QTextLine::Edge>(heap, QTextLine::Leading));
  ret.write<double > ((double)((QTextLine *)cls)->cursorToX (arg1, qt_gsi::QtToCppAdaptor<QTextLine::Edge>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_cursorToX_c2664 ()
{
  return new qt_gsi::GenericMethod ("cursorToX", "@brief Method double QTextLine::cursorToX(int *cursorPos, QTextLine::Edge edge)\n", true, &_init_f_cursorToX_c2664, &_call_f_cursorToX_c2664);
}

// double QTextLine::cursorToX(int cursorPos, QTextLine::Edge edge)


static void _init_f_cursorToX_c2478 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursorPos");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("edge", true, "QTextLine::Leading");
  decl->add_arg<const qt_gsi::Converter<QTextLine::Edge>::target_type & > (argspec_1);
  decl->set_return<double > ();
}

static void _call_f_cursorToX_c2478 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<QTextLine::Edge>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QTextLine::Edge>::target_type & > () : (const qt_gsi::Converter<QTextLine::Edge>::target_type &)(qt_gsi::CppToQtReadAdaptor<QTextLine::Edge>(heap, QTextLine::Leading));
  ret.write<double > ((double)((QTextLine *)cls)->cursorToX (arg1, qt_gsi::QtToCppAdaptor<QTextLine::Edge>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_cursorToX_c2478 ()
{
  return new qt_gsi::GenericMethod ("cursorToX", "@brief Method double QTextLine::cursorToX(int cursorPos, QTextLine::Edge edge)\n", true, &_init_f_cursorToX_c2478, &_call_f_cursorToX_c2478);
}

// double QTextLine::descent()


static void _init_f_descent_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_descent_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextLine *)cls)->descent ());
}

static qt_gsi::GenericMethod *_create_f_descent_c0 ()
{
  return new qt_gsi::GenericMethod ("descent", "@brief Method double QTextLine::descent()\n", true, &_init_f_descent_c0, &_call_f_descent_c0);
}

// void QTextLine::draw(QPainter *p, const QPointF &point, const QTextLayout::FormatRange *selection)


static void _init_f_draw_c6879 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("point");
  decl->add_arg<const QPointF & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("selection", true, "0");
  decl->add_arg<const QTextLayout::FormatRange * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_draw_c6879 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QPointF &arg2 = args.read<const QPointF & > ();
  const QTextLayout::FormatRange *arg3 = args ? args.read<const QTextLayout::FormatRange * > () : (const QTextLayout::FormatRange *)(0);
  ((QTextLine *)cls)->draw (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_draw_c6879 ()
{
  return new qt_gsi::GenericMethod ("draw", "@brief Method void QTextLine::draw(QPainter *p, const QPointF &point, const QTextLayout::FormatRange *selection)\n", true, &_init_f_draw_c6879, &_call_f_draw_c6879);
}

// double QTextLine::height()


static void _init_f_height_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_height_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextLine *)cls)->height ());
}

static qt_gsi::GenericMethod *_create_f_height_c0 ()
{
  return new qt_gsi::GenericMethod ("height", "@brief Method double QTextLine::height()\n", true, &_init_f_height_c0, &_call_f_height_c0);
}

// bool QTextLine::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextLine *)cls)->isValid ());
}

static qt_gsi::GenericMethod *_create_f_isValid_c0 ()
{
  return new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QTextLine::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
}

// double QTextLine::leading()


static void _init_f_leading_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_leading_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextLine *)cls)->leading ());
}

static qt_gsi::GenericMethod *_create_f_leading_c0 ()
{
  return new qt_gsi::GenericMethod ("leading", "@brief Method double QTextLine::leading()\n", true, &_init_f_leading_c0, &_call_f_leading_c0);
}

// bool QTextLine::leadingIncluded()


static void _init_f_leadingIncluded_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_leadingIncluded_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextLine *)cls)->leadingIncluded ());
}

static qt_gsi::GenericMethod *_create_f_leadingIncluded_c0 ()
{
  return new qt_gsi::GenericMethod (":leadingIncluded", "@brief Method bool QTextLine::leadingIncluded()\n", true, &_init_f_leadingIncluded_c0, &_call_f_leadingIncluded_c0);
}

// int QTextLine::lineNumber()


static void _init_f_lineNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_lineNumber_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextLine *)cls)->lineNumber ());
}

static qt_gsi::GenericMethod *_create_f_lineNumber_c0 ()
{
  return new qt_gsi::GenericMethod ("lineNumber", "@brief Method int QTextLine::lineNumber()\n", true, &_init_f_lineNumber_c0, &_call_f_lineNumber_c0);
}

// QRectF QTextLine::naturalTextRect()


static void _init_f_naturalTextRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_naturalTextRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QTextLine *)cls)->naturalTextRect ());
}

static qt_gsi::GenericMethod *_create_f_naturalTextRect_c0 ()
{
  return new qt_gsi::GenericMethod ("naturalTextRect", "@brief Method QRectF QTextLine::naturalTextRect()\n", true, &_init_f_naturalTextRect_c0, &_call_f_naturalTextRect_c0);
}

// double QTextLine::naturalTextWidth()


static void _init_f_naturalTextWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_naturalTextWidth_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextLine *)cls)->naturalTextWidth ());
}

static qt_gsi::GenericMethod *_create_f_naturalTextWidth_c0 ()
{
  return new qt_gsi::GenericMethod ("naturalTextWidth", "@brief Method double QTextLine::naturalTextWidth()\n", true, &_init_f_naturalTextWidth_c0, &_call_f_naturalTextWidth_c0);
}

// QPointF QTextLine::position()


static void _init_f_position_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPointF > ();
}

static void _call_f_position_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPointF > ((QPointF)((QTextLine *)cls)->position ());
}

static qt_gsi::GenericMethod *_create_f_position_c0 ()
{
  return new qt_gsi::GenericMethod (":position", "@brief Method QPointF QTextLine::position()\n", true, &_init_f_position_c0, &_call_f_position_c0);
}

// QRectF QTextLine::rect()


static void _init_f_rect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_rect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QTextLine *)cls)->rect ());
}

static qt_gsi::GenericMethod *_create_f_rect_c0 ()
{
  return new qt_gsi::GenericMethod ("rect", "@brief Method QRectF QTextLine::rect()\n", true, &_init_f_rect_c0, &_call_f_rect_c0);
}

// void QTextLine::setLeadingIncluded(bool included)


static void _init_f_setLeadingIncluded_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("included");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLeadingIncluded_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QTextLine *)cls)->setLeadingIncluded (arg1);
}

static qt_gsi::GenericMethod *_create_f_setLeadingIncluded_864 ()
{
  return new qt_gsi::GenericMethod ("setLeadingIncluded|leadingIncluded=", "@brief Method void QTextLine::setLeadingIncluded(bool included)\n", false, &_init_f_setLeadingIncluded_864, &_call_f_setLeadingIncluded_864);
}

// void QTextLine::setLineWidth(double width)


static void _init_f_setLineWidth_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLineWidth_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QTextLine *)cls)->setLineWidth (arg1);
}

static qt_gsi::GenericMethod *_create_f_setLineWidth_1071 ()
{
  return new qt_gsi::GenericMethod ("setLineWidth", "@brief Method void QTextLine::setLineWidth(double width)\n", false, &_init_f_setLineWidth_1071, &_call_f_setLineWidth_1071);
}

// void QTextLine::setNumColumns(int columns)


static void _init_f_setNumColumns_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("columns");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNumColumns_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTextLine *)cls)->setNumColumns (arg1);
}

static qt_gsi::GenericMethod *_create_f_setNumColumns_767 ()
{
  return new qt_gsi::GenericMethod ("setNumColumns", "@brief Method void QTextLine::setNumColumns(int columns)\n", false, &_init_f_setNumColumns_767, &_call_f_setNumColumns_767);
}

// void QTextLine::setNumColumns(int columns, double alignmentWidth)


static void _init_f_setNumColumns_1730 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("columns");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("alignmentWidth");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setNumColumns_1730 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  double arg2 = args.read<double > ();
  ((QTextLine *)cls)->setNumColumns (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setNumColumns_1730 ()
{
  return new qt_gsi::GenericMethod ("setNumColumns", "@brief Method void QTextLine::setNumColumns(int columns, double alignmentWidth)\n", false, &_init_f_setNumColumns_1730, &_call_f_setNumColumns_1730);
}

// void QTextLine::setPosition(const QPointF &pos)


static void _init_f_setPosition_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPosition_1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ((QTextLine *)cls)->setPosition (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPosition_1986 ()
{
  return new qt_gsi::GenericMethod ("setPosition|position=", "@brief Method void QTextLine::setPosition(const QPointF &pos)\n", false, &_init_f_setPosition_1986, &_call_f_setPosition_1986);
}

// int QTextLine::textLength()


static void _init_f_textLength_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_textLength_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextLine *)cls)->textLength ());
}

static qt_gsi::GenericMethod *_create_f_textLength_c0 ()
{
  return new qt_gsi::GenericMethod ("textLength", "@brief Method int QTextLine::textLength()\n", true, &_init_f_textLength_c0, &_call_f_textLength_c0);
}

// int QTextLine::textStart()


static void _init_f_textStart_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_textStart_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextLine *)cls)->textStart ());
}

static qt_gsi::GenericMethod *_create_f_textStart_c0 ()
{
  return new qt_gsi::GenericMethod ("textStart", "@brief Method int QTextLine::textStart()\n", true, &_init_f_textStart_c0, &_call_f_textStart_c0);
}

// double QTextLine::width()


static void _init_f_width_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_width_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextLine *)cls)->width ());
}

static qt_gsi::GenericMethod *_create_f_width_c0 ()
{
  return new qt_gsi::GenericMethod ("width", "@brief Method double QTextLine::width()\n", true, &_init_f_width_c0, &_call_f_width_c0);
}

// double QTextLine::x()


static void _init_f_x_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_x_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextLine *)cls)->x ());
}

static qt_gsi::GenericMethod *_create_f_x_c0 ()
{
  return new qt_gsi::GenericMethod ("x", "@brief Method double QTextLine::x()\n", true, &_init_f_x_c0, &_call_f_x_c0);
}

// int QTextLine::xToCursor(double x, QTextLine::CursorPosition)


static void _init_f_xToCursor_c3900 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2", true, "QTextLine::CursorBetweenCharacters");
  decl->add_arg<const qt_gsi::Converter<QTextLine::CursorPosition>::target_type & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_xToCursor_c3900 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  tl::Heap heap;
  const qt_gsi::Converter<QTextLine::CursorPosition>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QTextLine::CursorPosition>::target_type & > () : (const qt_gsi::Converter<QTextLine::CursorPosition>::target_type &)(qt_gsi::CppToQtReadAdaptor<QTextLine::CursorPosition>(heap, QTextLine::CursorBetweenCharacters));
  ret.write<int > ((int)((QTextLine *)cls)->xToCursor (arg1, qt_gsi::QtToCppAdaptor<QTextLine::CursorPosition>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_xToCursor_c3900 ()
{
  return new qt_gsi::GenericMethod ("xToCursor", "@brief Method int QTextLine::xToCursor(double x, QTextLine::CursorPosition)\n", true, &_init_f_xToCursor_c3900, &_call_f_xToCursor_c3900);
}

// double QTextLine::y()


static void _init_f_y_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_y_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextLine *)cls)->y ());
}

static qt_gsi::GenericMethod *_create_f_y_c0 ()
{
  return new qt_gsi::GenericMethod ("y", "@brief Method double QTextLine::y()\n", true, &_init_f_y_c0, &_call_f_y_c0);
}


namespace gsi
{
gsi::Class<QTextLine> decl_QTextLine ("QTextLine",
  gsi::Methods(_create_ctor_QTextLine_0 ()) +
  gsi::Methods(_create_f_ascent_c0 ()) +
  gsi::Methods(_create_f_cursorToX_c2664 ()) +
  gsi::Methods(_create_f_cursorToX_c2478 ()) +
  gsi::Methods(_create_f_descent_c0 ()) +
  gsi::Methods(_create_f_draw_c6879 ()) +
  gsi::Methods(_create_f_height_c0 ()) +
  gsi::Methods(_create_f_isValid_c0 ()) +
  gsi::Methods(_create_f_leading_c0 ()) +
  gsi::Methods(_create_f_leadingIncluded_c0 ()) +
  gsi::Methods(_create_f_lineNumber_c0 ()) +
  gsi::Methods(_create_f_naturalTextRect_c0 ()) +
  gsi::Methods(_create_f_naturalTextWidth_c0 ()) +
  gsi::Methods(_create_f_position_c0 ()) +
  gsi::Methods(_create_f_rect_c0 ()) +
  gsi::Methods(_create_f_setLeadingIncluded_864 ()) +
  gsi::Methods(_create_f_setLineWidth_1071 ()) +
  gsi::Methods(_create_f_setNumColumns_767 ()) +
  gsi::Methods(_create_f_setNumColumns_1730 ()) +
  gsi::Methods(_create_f_setPosition_1986 ()) +
  gsi::Methods(_create_f_textLength_c0 ()) +
  gsi::Methods(_create_f_textStart_c0 ()) +
  gsi::Methods(_create_f_width_c0 ()) +
  gsi::Methods(_create_f_x_c0 ()) +
  gsi::Methods(_create_f_xToCursor_c3900 ()) +
  gsi::Methods(_create_f_y_c0 ()),
  "@qt\n@brief Binding of QTextLine");

}


//  Implementation of the enum wrapper class for QTextLine::CursorPosition
namespace qt_gsi
{

static QTextLine_CursorPosition_Enum *c_1_QTextLine_CursorPosition_Enum () { return new QTextLine_CursorPosition_Enum (QTextLine::CursorBetweenCharacters); }
static QTextLine_CursorPosition_Enum *c_2_QTextLine_CursorPosition_Enum () { return new QTextLine_CursorPosition_Enum (QTextLine::CursorOnCharacter); }

static gsi::Methods mkdefs_QTextLine_CursorPosition () {
  return
    gsi::constant ("CursorBetweenCharacters", &qt_gsi::c_1_QTextLine_CursorPosition_Enum, "@brief Enum constant QTextLine::CursorBetweenCharacters") +
    gsi::constant ("CursorOnCharacter", &qt_gsi::c_2_QTextLine_CursorPosition_Enum, "@brief Enum constant QTextLine::CursorOnCharacter");
}

static std::string to_s_QTextLine_CursorPosition_Enum (const QTextLine_CursorPosition_Enum *e)
{
  if (e->value () == QTextLine::CursorBetweenCharacters) { return tl::sprintf ("CursorBetweenCharacters (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextLine::CursorOnCharacter) { return tl::sprintf ("CursorOnCharacter (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTextLine_CursorPosition_Enum (const QTextLine_CursorPosition_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTextLine_CursorPosition_Enum *from_i_QTextLine_CursorPosition_Enum (unsigned int i)
{
  return new QTextLine_CursorPosition_Enum ((QTextLine::CursorPosition) i);
}

static bool equalQTextLine_CursorPosition_Enum (const QTextLine_CursorPosition_Enum *e, QTextLine_CursorPosition_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTextLine_CursorPosition_Enum (const QTextLine_CursorPosition_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTextLine_CursorPosition_Enums oropQTextLine_CursorPosition_Enums (const QTextLine_CursorPosition_Enums *e, const QTextLine_CursorPosition_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTextLine_CursorPosition_Enums andopQTextLine_CursorPosition_Enums (const QTextLine_CursorPosition_Enums *e, const QTextLine_CursorPosition_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTextLine_CursorPosition_Enums xoropQTextLine_CursorPosition_Enums (const QTextLine_CursorPosition_Enums *e, const QTextLine_CursorPosition_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTextLine_CursorPosition_Enums (const QTextLine_CursorPosition_Enums *e)
{
  std::string l;
  if (e->testFlag (QTextLine::CursorBetweenCharacters)) { if (!l.empty ()) l += "|"; l += "CursorBetweenCharacters"; }
  if (e->testFlag (QTextLine::CursorOnCharacter)) { if (!l.empty ()) l += "|"; l += "CursorOnCharacter"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTextLine_CursorPosition_Enums (const QTextLine_CursorPosition_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTextLine_CursorPosition_Enums (const QTextLine_CursorPosition_Enums *e, const QTextLine_CursorPosition_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTextLine_CursorPosition_Enums> decl_QTextLine_CursorPosition_Enums ("QTextLine_QFlags_CursorPosition",
  gsi::method_ext ("|", &qt_gsi::oropQTextLine_CursorPosition_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTextLine_CursorPosition_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTextLine_CursorPosition_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextLine_CursorPosition_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextLine_CursorPosition_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTextLine_CursorPosition_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTextLine::CursorPosition> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTextLine_CursorPosition_Enum> decl_QTextLine_CursorPosition_Enum (decl_QTextLine_CursorPosition_Enums, "QTextLine_CursorPosition",
  qt_gsi::mkdefs_QTextLine_CursorPosition () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextLine_CursorPosition_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextLine_CursorPosition_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTextLine_CursorPosition_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTextLine_CursorPosition_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTextLine_CursorPosition_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTextLine::CursorPosition enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextLine> inject_QTextLine_CursorPosition_Enum_in_parent (qt_gsi::mkdefs_QTextLine_CursorPosition ());
static gsi::ClassExt<QTextLine> decl_QTextLine_CursorPosition_Enum_as_child (decl_QTextLine_CursorPosition_Enum, "CursorPosition");

}


//  Implementation of the enum wrapper class for QTextLine::Edge
namespace qt_gsi
{

static QTextLine_Edge_Enum *c_1_QTextLine_Edge_Enum () { return new QTextLine_Edge_Enum (QTextLine::Leading); }
static QTextLine_Edge_Enum *c_2_QTextLine_Edge_Enum () { return new QTextLine_Edge_Enum (QTextLine::Trailing); }

static gsi::Methods mkdefs_QTextLine_Edge () {
  return
    gsi::constant ("Leading", &qt_gsi::c_1_QTextLine_Edge_Enum, "@brief Enum constant QTextLine::Leading") +
    gsi::constant ("Trailing", &qt_gsi::c_2_QTextLine_Edge_Enum, "@brief Enum constant QTextLine::Trailing");
}

static std::string to_s_QTextLine_Edge_Enum (const QTextLine_Edge_Enum *e)
{
  if (e->value () == QTextLine::Leading) { return tl::sprintf ("Leading (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextLine::Trailing) { return tl::sprintf ("Trailing (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTextLine_Edge_Enum (const QTextLine_Edge_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTextLine_Edge_Enum *from_i_QTextLine_Edge_Enum (unsigned int i)
{
  return new QTextLine_Edge_Enum ((QTextLine::Edge) i);
}

static bool equalQTextLine_Edge_Enum (const QTextLine_Edge_Enum *e, QTextLine_Edge_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTextLine_Edge_Enum (const QTextLine_Edge_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTextLine_Edge_Enums oropQTextLine_Edge_Enums (const QTextLine_Edge_Enums *e, const QTextLine_Edge_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTextLine_Edge_Enums andopQTextLine_Edge_Enums (const QTextLine_Edge_Enums *e, const QTextLine_Edge_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTextLine_Edge_Enums xoropQTextLine_Edge_Enums (const QTextLine_Edge_Enums *e, const QTextLine_Edge_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTextLine_Edge_Enums (const QTextLine_Edge_Enums *e)
{
  std::string l;
  if (e->testFlag (QTextLine::Leading)) { if (!l.empty ()) l += "|"; l += "Leading"; }
  if (e->testFlag (QTextLine::Trailing)) { if (!l.empty ()) l += "|"; l += "Trailing"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTextLine_Edge_Enums (const QTextLine_Edge_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTextLine_Edge_Enums (const QTextLine_Edge_Enums *e, const QTextLine_Edge_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTextLine_Edge_Enums> decl_QTextLine_Edge_Enums ("QTextLine_QFlags_Edge",
  gsi::method_ext ("|", &qt_gsi::oropQTextLine_Edge_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTextLine_Edge_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTextLine_Edge_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextLine_Edge_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextLine_Edge_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTextLine_Edge_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTextLine::Edge> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTextLine_Edge_Enum> decl_QTextLine_Edge_Enum (decl_QTextLine_Edge_Enums, "QTextLine_Edge",
  qt_gsi::mkdefs_QTextLine_Edge () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextLine_Edge_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextLine_Edge_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTextLine_Edge_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTextLine_Edge_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTextLine_Edge_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTextLine::Edge enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextLine> inject_QTextLine_Edge_Enum_in_parent (qt_gsi::mkdefs_QTextLine_Edge ());
static gsi::ClassExt<QTextLine> decl_QTextLine_Edge_Enum_as_child (decl_QTextLine_Edge_Enum, "Edge");

}

