
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTextDocument.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQTextDocument_EventAdaptor.h"
#include "gsiDeclQTextDocument_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTextDocument

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QTextDocument::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QTextDocument::addResource(int type, const QUrl &name, const QVariant &resource)


static void _init_f_addResource_4371 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name");
  decl->add_arg<const QUrl & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("resource");
  decl->add_arg<const QVariant & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_addResource_4371 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QUrl &arg2 = args.read<const QUrl & > ();
  const QVariant &arg3 = args.read<const QVariant & > ();
  ((QTextDocument *)cls)->addResource (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_addResource_4371 ()
{
  return new qt_gsi::GenericMethod ("addResource", "@brief Method void QTextDocument::addResource(int type, const QUrl &name, const QVariant &resource)\n", false, &_init_f_addResource_4371, &_call_f_addResource_4371);
}

// void QTextDocument::adjustSize()


static void _init_f_adjustSize_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_adjustSize_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextDocument *)cls)->adjustSize ();
}

static qt_gsi::GenericMethod *_create_f_adjustSize_0 ()
{
  return new qt_gsi::GenericMethod ("adjustSize", "@brief Method void QTextDocument::adjustSize()\n", false, &_init_f_adjustSize_0, &_call_f_adjustSize_0);
}

// QVector<QTextFormat> QTextDocument::allFormats()


static void _init_f_allFormats_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QVector<QTextFormat> >::target_type > ();
}

static void _call_f_allFormats_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QVector<QTextFormat> >::target_type > ((qt_gsi::Converter<QVector<QTextFormat> >::target_type)qt_gsi::CppToQtAdaptor<QVector<QTextFormat> >(((QTextDocument *)cls)->allFormats ()));
}

static qt_gsi::GenericMethod *_create_f_allFormats_c0 ()
{
  return new qt_gsi::GenericMethod ("allFormats", "@brief Method QVector<QTextFormat> QTextDocument::allFormats()\n", true, &_init_f_allFormats_c0, &_call_f_allFormats_c0);
}

// int QTextDocument::availableRedoSteps()


static void _init_f_availableRedoSteps_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_availableRedoSteps_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextDocument *)cls)->availableRedoSteps ());
}

static qt_gsi::GenericMethod *_create_f_availableRedoSteps_c0 ()
{
  return new qt_gsi::GenericMethod ("availableRedoSteps", "@brief Method int QTextDocument::availableRedoSteps()\n", true, &_init_f_availableRedoSteps_c0, &_call_f_availableRedoSteps_c0);
}

// int QTextDocument::availableUndoSteps()


static void _init_f_availableUndoSteps_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_availableUndoSteps_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextDocument *)cls)->availableUndoSteps ());
}

static qt_gsi::GenericMethod *_create_f_availableUndoSteps_c0 ()
{
  return new qt_gsi::GenericMethod ("availableUndoSteps", "@brief Method int QTextDocument::availableUndoSteps()\n", true, &_init_f_availableUndoSteps_c0, &_call_f_availableUndoSteps_c0);
}

// QTextBlock QTextDocument::begin()


static void _init_f_begin_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextBlock > ();
}

static void _call_f_begin_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextBlock > ((QTextBlock)((QTextDocument *)cls)->begin ());
}

static qt_gsi::GenericMethod *_create_f_begin_c0 ()
{
  return new qt_gsi::GenericMethod ("begin", "@brief Method QTextBlock QTextDocument::begin()\n", true, &_init_f_begin_c0, &_call_f_begin_c0);
}

// int QTextDocument::blockCount()


static void _init_f_blockCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_blockCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextDocument *)cls)->blockCount ());
}

static qt_gsi::GenericMethod *_create_f_blockCount_c0 ()
{
  return new qt_gsi::GenericMethod (":blockCount", "@brief Method int QTextDocument::blockCount()\n", true, &_init_f_blockCount_c0, &_call_f_blockCount_c0);
}

// QChar QTextDocument::characterAt(int pos)


static void _init_f_characterAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_characterAt_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QTextDocument *)cls)->characterAt (arg1)));
}

static qt_gsi::GenericMethod *_create_f_characterAt_c767 ()
{
  return new qt_gsi::GenericMethod ("characterAt", "@brief Method QChar QTextDocument::characterAt(int pos)\n", true, &_init_f_characterAt_c767, &_call_f_characterAt_c767);
}

// int QTextDocument::characterCount()


static void _init_f_characterCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_characterCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextDocument *)cls)->characterCount ());
}

static qt_gsi::GenericMethod *_create_f_characterCount_c0 ()
{
  return new qt_gsi::GenericMethod ("characterCount", "@brief Method int QTextDocument::characterCount()\n", true, &_init_f_characterCount_c0, &_call_f_characterCount_c0);
}

// void QTextDocument::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextDocument *)cls)->clear ();
}

static qt_gsi::GenericMethod *_create_f_clear_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Method void QTextDocument::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
}

// QTextDocument *QTextDocument::clone(QObject *parent)


static void _init_f_clone_c1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<QTextDocument * > ();
}

static void _call_f_clone_c1302 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QTextDocument * > ((QTextDocument *)((QTextDocument *)cls)->clone (arg1));
}

static qt_gsi::GenericMethod *_create_f_clone_c1302 ()
{
  return new qt_gsi::GenericMethod ("clone", "@brief Method QTextDocument *QTextDocument::clone(QObject *parent)\n", true, &_init_f_clone_c1302, &_call_f_clone_c1302);
}

// QFont QTextDocument::defaultFont()


static void _init_f_defaultFont_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_defaultFont_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFont > ((QFont)((QTextDocument *)cls)->defaultFont ());
}

static qt_gsi::GenericMethod *_create_f_defaultFont_c0 ()
{
  return new qt_gsi::GenericMethod (":defaultFont", "@brief Method QFont QTextDocument::defaultFont()\n", true, &_init_f_defaultFont_c0, &_call_f_defaultFont_c0);
}

// QString QTextDocument::defaultStyleSheet()


static void _init_f_defaultStyleSheet_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_defaultStyleSheet_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QTextDocument *)cls)->defaultStyleSheet ());
}

static qt_gsi::GenericMethod *_create_f_defaultStyleSheet_c0 ()
{
  return new qt_gsi::GenericMethod (":defaultStyleSheet", "@brief Method QString QTextDocument::defaultStyleSheet()\n", true, &_init_f_defaultStyleSheet_c0, &_call_f_defaultStyleSheet_c0);
}

// QTextOption QTextDocument::defaultTextOption()


static void _init_f_defaultTextOption_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextOption > ();
}

static void _call_f_defaultTextOption_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextOption > ((QTextOption)((QTextDocument *)cls)->defaultTextOption ());
}

static qt_gsi::GenericMethod *_create_f_defaultTextOption_c0 ()
{
  return new qt_gsi::GenericMethod (":defaultTextOption", "@brief Method QTextOption QTextDocument::defaultTextOption()\n", true, &_init_f_defaultTextOption_c0, &_call_f_defaultTextOption_c0);
}

// QAbstractTextDocumentLayout *QTextDocument::documentLayout()


static void _init_f_documentLayout_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractTextDocumentLayout * > ();
}

static void _call_f_documentLayout_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QAbstractTextDocumentLayout * > ((QAbstractTextDocumentLayout *)((QTextDocument *)cls)->documentLayout ());
}

static qt_gsi::GenericMethod *_create_f_documentLayout_c0 ()
{
  return new qt_gsi::GenericMethod (":documentLayout", "@brief Method QAbstractTextDocumentLayout *QTextDocument::documentLayout()\n", true, &_init_f_documentLayout_c0, &_call_f_documentLayout_c0);
}

// double QTextDocument::documentMargin()


static void _init_f_documentMargin_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_documentMargin_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextDocument *)cls)->documentMargin ());
}

static qt_gsi::GenericMethod *_create_f_documentMargin_c0 ()
{
  return new qt_gsi::GenericMethod (":documentMargin", "@brief Method double QTextDocument::documentMargin()\n", true, &_init_f_documentMargin_c0, &_call_f_documentMargin_c0);
}

// void QTextDocument::drawContents(QPainter *painter, const QRectF &rect)


static void _init_f_drawContents_3180 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_drawContents_3180 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRectF &arg2 = args ? args.read<const QRectF & > () : (const QRectF &)(QRectF());
  ((QTextDocument *)cls)->drawContents (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_drawContents_3180 ()
{
  return new qt_gsi::GenericMethod ("drawContents", "@brief Method void QTextDocument::drawContents(QPainter *painter, const QRectF &rect)\n", false, &_init_f_drawContents_3180, &_call_f_drawContents_3180);
}

// QTextBlock QTextDocument::end()


static void _init_f_end_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextBlock > ();
}

static void _call_f_end_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextBlock > ((QTextBlock)((QTextDocument *)cls)->end ());
}

static qt_gsi::GenericMethod *_create_f_end_c0 ()
{
  return new qt_gsi::GenericMethod ("end", "@brief Method QTextBlock QTextDocument::end()\n", true, &_init_f_end_c0, &_call_f_end_c0);
}

// QTextCursor QTextDocument::find(const QString &subString, int from, QFlags<QTextDocument::FindFlag> options)


static void _init_f_find_c5920 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("subString");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("from", true, "0");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("options", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<QTextDocument::FindFlag> >::target_type & > (argspec_2);
  decl->set_return<QTextCursor > ();
}

static void _call_f_find_c5920 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  int arg2 = args ? args.read<int > () : (int)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QTextDocument::FindFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<QTextDocument::FindFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QTextDocument::FindFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QTextDocument::FindFlag> >(heap, 0));
  ret.write<QTextCursor > ((QTextCursor)((QTextDocument *)cls)->find (arg1, arg2, qt_gsi::QtToCppAdaptor<QFlags<QTextDocument::FindFlag> >(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_find_c5920 ()
{
  return new qt_gsi::GenericMethod ("find", "@brief Method QTextCursor QTextDocument::find(const QString &subString, int from, QFlags<QTextDocument::FindFlag> options)\n", true, &_init_f_find_c5920, &_call_f_find_c5920);
}

// QTextCursor QTextDocument::find(const QString &subString, const QTextCursor &from, QFlags<QTextDocument::FindFlag> options)


static void _init_f_find_c7606 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("subString");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("from");
  decl->add_arg<const QTextCursor & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("options", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<QTextDocument::FindFlag> >::target_type & > (argspec_2);
  decl->set_return<QTextCursor > ();
}

static void _call_f_find_c7606 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QTextCursor &arg2 = args.read<const QTextCursor & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QTextDocument::FindFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<QTextDocument::FindFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QTextDocument::FindFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QTextDocument::FindFlag> >(heap, 0));
  ret.write<QTextCursor > ((QTextCursor)((QTextDocument *)cls)->find (arg1, arg2, qt_gsi::QtToCppAdaptor<QFlags<QTextDocument::FindFlag> >(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_find_c7606 ()
{
  return new qt_gsi::GenericMethod ("find", "@brief Method QTextCursor QTextDocument::find(const QString &subString, const QTextCursor &from, QFlags<QTextDocument::FindFlag> options)\n", true, &_init_f_find_c7606, &_call_f_find_c7606);
}

// QTextCursor QTextDocument::find(const QRegExp &expr, int from, QFlags<QTextDocument::FindFlag> options)


static void _init_f_find_c5876 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("expr");
  decl->add_arg<const QRegExp & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("from", true, "0");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("options", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<QTextDocument::FindFlag> >::target_type & > (argspec_2);
  decl->set_return<QTextCursor > ();
}

static void _call_f_find_c5876 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegExp &arg1 = args.read<const QRegExp & > ();
  int arg2 = args ? args.read<int > () : (int)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QTextDocument::FindFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<QTextDocument::FindFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QTextDocument::FindFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QTextDocument::FindFlag> >(heap, 0));
  ret.write<QTextCursor > ((QTextCursor)((QTextDocument *)cls)->find (arg1, arg2, qt_gsi::QtToCppAdaptor<QFlags<QTextDocument::FindFlag> >(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_find_c5876 ()
{
  return new qt_gsi::GenericMethod ("find", "@brief Method QTextCursor QTextDocument::find(const QRegExp &expr, int from, QFlags<QTextDocument::FindFlag> options)\n", true, &_init_f_find_c5876, &_call_f_find_c5876);
}

// QTextCursor QTextDocument::find(const QRegExp &expr, const QTextCursor &from, QFlags<QTextDocument::FindFlag> options)


static void _init_f_find_c7562 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("expr");
  decl->add_arg<const QRegExp & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("from");
  decl->add_arg<const QTextCursor & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("options", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<QTextDocument::FindFlag> >::target_type & > (argspec_2);
  decl->set_return<QTextCursor > ();
}

static void _call_f_find_c7562 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegExp &arg1 = args.read<const QRegExp & > ();
  const QTextCursor &arg2 = args.read<const QTextCursor & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QTextDocument::FindFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<QTextDocument::FindFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QTextDocument::FindFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QTextDocument::FindFlag> >(heap, 0));
  ret.write<QTextCursor > ((QTextCursor)((QTextDocument *)cls)->find (arg1, arg2, qt_gsi::QtToCppAdaptor<QFlags<QTextDocument::FindFlag> >(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_find_c7562 ()
{
  return new qt_gsi::GenericMethod ("find", "@brief Method QTextCursor QTextDocument::find(const QRegExp &expr, const QTextCursor &from, QFlags<QTextDocument::FindFlag> options)\n", true, &_init_f_find_c7562, &_call_f_find_c7562);
}

// QTextBlock QTextDocument::findBlock(int pos)


static void _init_f_findBlock_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextBlock > ();
}

static void _call_f_findBlock_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QTextBlock > ((QTextBlock)((QTextDocument *)cls)->findBlock (arg1));
}

static qt_gsi::GenericMethod *_create_f_findBlock_c767 ()
{
  return new qt_gsi::GenericMethod ("findBlock", "@brief Method QTextBlock QTextDocument::findBlock(int pos)\n", true, &_init_f_findBlock_c767, &_call_f_findBlock_c767);
}

// QTextBlock QTextDocument::findBlockByLineNumber(int blockNumber)


static void _init_f_findBlockByLineNumber_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("blockNumber");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextBlock > ();
}

static void _call_f_findBlockByLineNumber_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QTextBlock > ((QTextBlock)((QTextDocument *)cls)->findBlockByLineNumber (arg1));
}

static qt_gsi::GenericMethod *_create_f_findBlockByLineNumber_c767 ()
{
  return new qt_gsi::GenericMethod ("findBlockByLineNumber", "@brief Method QTextBlock QTextDocument::findBlockByLineNumber(int blockNumber)\n", true, &_init_f_findBlockByLineNumber_c767, &_call_f_findBlockByLineNumber_c767);
}

// QTextBlock QTextDocument::findBlockByNumber(int blockNumber)


static void _init_f_findBlockByNumber_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("blockNumber");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextBlock > ();
}

static void _call_f_findBlockByNumber_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QTextBlock > ((QTextBlock)((QTextDocument *)cls)->findBlockByNumber (arg1));
}

static qt_gsi::GenericMethod *_create_f_findBlockByNumber_c767 ()
{
  return new qt_gsi::GenericMethod ("findBlockByNumber", "@brief Method QTextBlock QTextDocument::findBlockByNumber(int blockNumber)\n", true, &_init_f_findBlockByNumber_c767, &_call_f_findBlockByNumber_c767);
}

// QTextBlock QTextDocument::firstBlock()


static void _init_f_firstBlock_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextBlock > ();
}

static void _call_f_firstBlock_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextBlock > ((QTextBlock)((QTextDocument *)cls)->firstBlock ());
}

static qt_gsi::GenericMethod *_create_f_firstBlock_c0 ()
{
  return new qt_gsi::GenericMethod ("firstBlock", "@brief Method QTextBlock QTextDocument::firstBlock()\n", true, &_init_f_firstBlock_c0, &_call_f_firstBlock_c0);
}

// QTextFrame *QTextDocument::frameAt(int pos)


static void _init_f_frameAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextFrame * > ();
}

static void _call_f_frameAt_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QTextFrame * > ((QTextFrame *)((QTextDocument *)cls)->frameAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_frameAt_c767 ()
{
  return new qt_gsi::GenericMethod ("frameAt", "@brief Method QTextFrame *QTextDocument::frameAt(int pos)\n", true, &_init_f_frameAt_c767, &_call_f_frameAt_c767);
}

// double QTextDocument::idealWidth()


static void _init_f_idealWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_idealWidth_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextDocument *)cls)->idealWidth ());
}

static qt_gsi::GenericMethod *_create_f_idealWidth_c0 ()
{
  return new qt_gsi::GenericMethod ("idealWidth", "@brief Method double QTextDocument::idealWidth()\n", true, &_init_f_idealWidth_c0, &_call_f_idealWidth_c0);
}

// double QTextDocument::indentWidth()


static void _init_f_indentWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_indentWidth_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextDocument *)cls)->indentWidth ());
}

static qt_gsi::GenericMethod *_create_f_indentWidth_c0 ()
{
  return new qt_gsi::GenericMethod (":indentWidth", "@brief Method double QTextDocument::indentWidth()\n", true, &_init_f_indentWidth_c0, &_call_f_indentWidth_c0);
}

// bool QTextDocument::isEmpty()


static void _init_f_isEmpty_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEmpty_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextDocument *)cls)->isEmpty ());
}

static qt_gsi::GenericMethod *_create_f_isEmpty_c0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty?", "@brief Method bool QTextDocument::isEmpty()\n", true, &_init_f_isEmpty_c0, &_call_f_isEmpty_c0);
}

// bool QTextDocument::isModified()


static void _init_f_isModified_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isModified_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextDocument *)cls)->isModified ());
}

static qt_gsi::GenericMethod *_create_f_isModified_c0 ()
{
  return new qt_gsi::GenericMethod ("isModified?|:modified", "@brief Method bool QTextDocument::isModified()\n", true, &_init_f_isModified_c0, &_call_f_isModified_c0);
}

// bool QTextDocument::isRedoAvailable()


static void _init_f_isRedoAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRedoAvailable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextDocument *)cls)->isRedoAvailable ());
}

static qt_gsi::GenericMethod *_create_f_isRedoAvailable_c0 ()
{
  return new qt_gsi::GenericMethod ("isRedoAvailable?", "@brief Method bool QTextDocument::isRedoAvailable()\n", true, &_init_f_isRedoAvailable_c0, &_call_f_isRedoAvailable_c0);
}

// bool QTextDocument::isUndoAvailable()


static void _init_f_isUndoAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isUndoAvailable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextDocument *)cls)->isUndoAvailable ());
}

static qt_gsi::GenericMethod *_create_f_isUndoAvailable_c0 ()
{
  return new qt_gsi::GenericMethod ("isUndoAvailable?", "@brief Method bool QTextDocument::isUndoAvailable()\n", true, &_init_f_isUndoAvailable_c0, &_call_f_isUndoAvailable_c0);
}

// bool QTextDocument::isUndoRedoEnabled()


static void _init_f_isUndoRedoEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isUndoRedoEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextDocument *)cls)->isUndoRedoEnabled ());
}

static qt_gsi::GenericMethod *_create_f_isUndoRedoEnabled_c0 ()
{
  return new qt_gsi::GenericMethod ("isUndoRedoEnabled?|:undoRedoEnabled", "@brief Method bool QTextDocument::isUndoRedoEnabled()\n", true, &_init_f_isUndoRedoEnabled_c0, &_call_f_isUndoRedoEnabled_c0);
}

// QTextBlock QTextDocument::lastBlock()


static void _init_f_lastBlock_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextBlock > ();
}

static void _call_f_lastBlock_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextBlock > ((QTextBlock)((QTextDocument *)cls)->lastBlock ());
}

static qt_gsi::GenericMethod *_create_f_lastBlock_c0 ()
{
  return new qt_gsi::GenericMethod ("lastBlock", "@brief Method QTextBlock QTextDocument::lastBlock()\n", true, &_init_f_lastBlock_c0, &_call_f_lastBlock_c0);
}

// int QTextDocument::lineCount()


static void _init_f_lineCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_lineCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextDocument *)cls)->lineCount ());
}

static qt_gsi::GenericMethod *_create_f_lineCount_c0 ()
{
  return new qt_gsi::GenericMethod ("lineCount", "@brief Method int QTextDocument::lineCount()\n", true, &_init_f_lineCount_c0, &_call_f_lineCount_c0);
}

// void QTextDocument::markContentsDirty(int from, int length)


static void _init_f_markContentsDirty_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("length");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_markContentsDirty_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QTextDocument *)cls)->markContentsDirty (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_markContentsDirty_1426 ()
{
  return new qt_gsi::GenericMethod ("markContentsDirty", "@brief Method void QTextDocument::markContentsDirty(int from, int length)\n", false, &_init_f_markContentsDirty_1426, &_call_f_markContentsDirty_1426);
}

// int QTextDocument::maximumBlockCount()


static void _init_f_maximumBlockCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maximumBlockCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextDocument *)cls)->maximumBlockCount ());
}

static qt_gsi::GenericMethod *_create_f_maximumBlockCount_c0 ()
{
  return new qt_gsi::GenericMethod (":maximumBlockCount", "@brief Method int QTextDocument::maximumBlockCount()\n", true, &_init_f_maximumBlockCount_c0, &_call_f_maximumBlockCount_c0);
}

// QString QTextDocument::metaInformation(QTextDocument::MetaInformation info)


static void _init_f_metaInformation_c3434 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("info");
  decl->add_arg<const qt_gsi::Converter<QTextDocument::MetaInformation>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_metaInformation_c3434 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QTextDocument::MetaInformation>::target_type & arg1 = args.read<const qt_gsi::Converter<QTextDocument::MetaInformation>::target_type & > ();
  ret.write<QString > ((QString)((QTextDocument *)cls)->metaInformation (qt_gsi::QtToCppAdaptor<QTextDocument::MetaInformation>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_metaInformation_c3434 ()
{
  return new qt_gsi::GenericMethod ("metaInformation", "@brief Method QString QTextDocument::metaInformation(QTextDocument::MetaInformation info)\n", true, &_init_f_metaInformation_c3434, &_call_f_metaInformation_c3434);
}

// QTextObject *QTextDocument::object(int objectIndex)


static void _init_f_object_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectIndex");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextObject * > ();
}

static void _call_f_object_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QTextObject * > ((QTextObject *)((QTextDocument *)cls)->object (arg1));
}

static qt_gsi::GenericMethod *_create_f_object_c767 ()
{
  return new qt_gsi::GenericMethod ("object", "@brief Method QTextObject *QTextDocument::object(int objectIndex)\n", true, &_init_f_object_c767, &_call_f_object_c767);
}

// QTextObject *QTextDocument::objectForFormat(const QTextFormat &)


static void _init_f_objectForFormat_c2432 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QTextFormat & > (argspec_0);
  decl->set_return<QTextObject * > ();
}

static void _call_f_objectForFormat_c2432 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextFormat &arg1 = args.read<const QTextFormat & > ();
  ret.write<QTextObject * > ((QTextObject *)((QTextDocument *)cls)->objectForFormat (arg1));
}

static qt_gsi::GenericMethod *_create_f_objectForFormat_c2432 ()
{
  return new qt_gsi::GenericMethod ("objectForFormat", "@brief Method QTextObject *QTextDocument::objectForFormat(const QTextFormat &)\n", true, &_init_f_objectForFormat_c2432, &_call_f_objectForFormat_c2432);
}

// int QTextDocument::pageCount()


static void _init_f_pageCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_pageCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextDocument *)cls)->pageCount ());
}

static qt_gsi::GenericMethod *_create_f_pageCount_c0 ()
{
  return new qt_gsi::GenericMethod ("pageCount", "@brief Method int QTextDocument::pageCount()\n", true, &_init_f_pageCount_c0, &_call_f_pageCount_c0);
}

// QSizeF QTextDocument::pageSize()


static void _init_f_pageSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_f_pageSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSizeF > ((QSizeF)((QTextDocument *)cls)->pageSize ());
}

static qt_gsi::GenericMethod *_create_f_pageSize_c0 ()
{
  return new qt_gsi::GenericMethod (":pageSize", "@brief Method QSizeF QTextDocument::pageSize()\n", true, &_init_f_pageSize_c0, &_call_f_pageSize_c0);
}

// void QTextDocument::print(QPrinter *printer)


static void _init_f_print_c1443 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("printer");
  decl->add_arg<QPrinter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_print_c1443 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPrinter *arg1 = args.read<QPrinter * > ();
  ((QTextDocument *)cls)->print (arg1);
}

static qt_gsi::GenericMethod *_create_f_print_c1443 ()
{
  return new qt_gsi::GenericMethod ("print", "@brief Method void QTextDocument::print(QPrinter *printer)\n", true, &_init_f_print_c1443, &_call_f_print_c1443);
}

// void QTextDocument::redo(QTextCursor *cursor)


static void _init_f_redo_1762 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursor");
  decl->add_arg<QTextCursor * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_redo_1762 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextCursor *arg1 = args.read<QTextCursor * > ();
  ((QTextDocument *)cls)->redo (arg1);
}

static qt_gsi::GenericMethod *_create_f_redo_1762 ()
{
  return new qt_gsi::GenericMethod ("redo", "@brief Method void QTextDocument::redo(QTextCursor *cursor)\n", false, &_init_f_redo_1762, &_call_f_redo_1762);
}

// void QTextDocument::redo()


static void _init_f_redo_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_redo_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextDocument *)cls)->redo ();
}

static qt_gsi::GenericMethod *_create_f_redo_0 ()
{
  return new qt_gsi::GenericMethod ("redo", "@brief Method void QTextDocument::redo()\n", false, &_init_f_redo_0, &_call_f_redo_0);
}

// QVariant QTextDocument::resource(int type, const QUrl &name)


static void _init_f_resource_c2360 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name");
  decl->add_arg<const QUrl & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_resource_c2360 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QUrl &arg2 = args.read<const QUrl & > ();
  ret.write<QVariant > ((QVariant)((QTextDocument *)cls)->resource (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_resource_c2360 ()
{
  return new qt_gsi::GenericMethod ("resource", "@brief Method QVariant QTextDocument::resource(int type, const QUrl &name)\n", true, &_init_f_resource_c2360, &_call_f_resource_c2360);
}

// int QTextDocument::revision()


static void _init_f_revision_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_revision_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextDocument *)cls)->revision ());
}

static qt_gsi::GenericMethod *_create_f_revision_c0 ()
{
  return new qt_gsi::GenericMethod ("revision", "@brief Method int QTextDocument::revision()\n", true, &_init_f_revision_c0, &_call_f_revision_c0);
}

// QTextFrame *QTextDocument::rootFrame()


static void _init_f_rootFrame_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextFrame * > ();
}

static void _call_f_rootFrame_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextFrame * > ((QTextFrame *)((QTextDocument *)cls)->rootFrame ());
}

static qt_gsi::GenericMethod *_create_f_rootFrame_c0 ()
{
  return new qt_gsi::GenericMethod ("rootFrame", "@brief Method QTextFrame *QTextDocument::rootFrame()\n", true, &_init_f_rootFrame_c0, &_call_f_rootFrame_c0);
}

// void QTextDocument::setDefaultFont(const QFont &font)


static void _init_f_setDefaultFont_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("font");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultFont_1801 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QTextDocument *)cls)->setDefaultFont (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDefaultFont_1801 ()
{
  return new qt_gsi::GenericMethod ("setDefaultFont|defaultFont=", "@brief Method void QTextDocument::setDefaultFont(const QFont &font)\n", false, &_init_f_setDefaultFont_1801, &_call_f_setDefaultFont_1801);
}

// void QTextDocument::setDefaultStyleSheet(const QString &sheet)


static void _init_f_setDefaultStyleSheet_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sheet");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultStyleSheet_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QTextDocument *)cls)->setDefaultStyleSheet (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDefaultStyleSheet_2025 ()
{
  return new qt_gsi::GenericMethod ("setDefaultStyleSheet|defaultStyleSheet=", "@brief Method void QTextDocument::setDefaultStyleSheet(const QString &sheet)\n", false, &_init_f_setDefaultStyleSheet_2025, &_call_f_setDefaultStyleSheet_2025);
}

// void QTextDocument::setDefaultTextOption(const QTextOption &option)


static void _init_f_setDefaultTextOption_2448 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QTextOption & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultTextOption_2448 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextOption &arg1 = args.read<const QTextOption & > ();
  ((QTextDocument *)cls)->setDefaultTextOption (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDefaultTextOption_2448 ()
{
  return new qt_gsi::GenericMethod ("setDefaultTextOption|defaultTextOption=", "@brief Method void QTextDocument::setDefaultTextOption(const QTextOption &option)\n", false, &_init_f_setDefaultTextOption_2448, &_call_f_setDefaultTextOption_2448);
}

// void QTextDocument::setDocumentLayout(QAbstractTextDocumentLayout *layout)


static void _init_f_setDocumentLayout_3413 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("layout");
  decl->add_arg<QAbstractTextDocumentLayout * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDocumentLayout_3413 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractTextDocumentLayout *arg1 = args.read<QAbstractTextDocumentLayout * > ();
  ((QTextDocument *)cls)->setDocumentLayout (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDocumentLayout_3413 ()
{
  return new qt_gsi::GenericMethod ("setDocumentLayout|documentLayout=", "@brief Method void QTextDocument::setDocumentLayout(QAbstractTextDocumentLayout *layout)\n", false, &_init_f_setDocumentLayout_3413, &_call_f_setDocumentLayout_3413);
}

// void QTextDocument::setDocumentMargin(double margin)


static void _init_f_setDocumentMargin_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margin");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDocumentMargin_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QTextDocument *)cls)->setDocumentMargin (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDocumentMargin_1071 ()
{
  return new qt_gsi::GenericMethod ("setDocumentMargin|documentMargin=", "@brief Method void QTextDocument::setDocumentMargin(double margin)\n", false, &_init_f_setDocumentMargin_1071, &_call_f_setDocumentMargin_1071);
}

// void QTextDocument::setHtml(const QString &html)


static void _init_f_setHtml_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("html");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHtml_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QTextDocument *)cls)->setHtml (arg1);
}

static qt_gsi::GenericMethod *_create_f_setHtml_2025 ()
{
  return new qt_gsi::GenericMethod ("setHtml", "@brief Method void QTextDocument::setHtml(const QString &html)\n", false, &_init_f_setHtml_2025, &_call_f_setHtml_2025);
}

// void QTextDocument::setIndentWidth(double width)


static void _init_f_setIndentWidth_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIndentWidth_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QTextDocument *)cls)->setIndentWidth (arg1);
}

static qt_gsi::GenericMethod *_create_f_setIndentWidth_1071 ()
{
  return new qt_gsi::GenericMethod ("setIndentWidth|indentWidth=", "@brief Method void QTextDocument::setIndentWidth(double width)\n", false, &_init_f_setIndentWidth_1071, &_call_f_setIndentWidth_1071);
}

// void QTextDocument::setMaximumBlockCount(int maximum)


static void _init_f_setMaximumBlockCount_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maximum");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximumBlockCount_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTextDocument *)cls)->setMaximumBlockCount (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMaximumBlockCount_767 ()
{
  return new qt_gsi::GenericMethod ("setMaximumBlockCount|maximumBlockCount=", "@brief Method void QTextDocument::setMaximumBlockCount(int maximum)\n", false, &_init_f_setMaximumBlockCount_767, &_call_f_setMaximumBlockCount_767);
}

// void QTextDocument::setMetaInformation(QTextDocument::MetaInformation info, const QString &)


static void _init_f_setMetaInformation_5351 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("info");
  decl->add_arg<const qt_gsi::Converter<QTextDocument::MetaInformation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMetaInformation_5351 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QTextDocument::MetaInformation>::target_type & arg1 = args.read<const qt_gsi::Converter<QTextDocument::MetaInformation>::target_type & > ();
  const QString &arg2 = args.read<const QString & > ();
  ((QTextDocument *)cls)->setMetaInformation (qt_gsi::QtToCppAdaptor<QTextDocument::MetaInformation>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setMetaInformation_5351 ()
{
  return new qt_gsi::GenericMethod ("setMetaInformation", "@brief Method void QTextDocument::setMetaInformation(QTextDocument::MetaInformation info, const QString &)\n", false, &_init_f_setMetaInformation_5351, &_call_f_setMetaInformation_5351);
}

// void QTextDocument::setModified(bool m)


static void _init_f_setModified_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("m", true, "true");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setModified_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  ((QTextDocument *)cls)->setModified (arg1);
}

static qt_gsi::GenericMethod *_create_f_setModified_864 ()
{
  return new qt_gsi::GenericMethod ("setModified|modified=", "@brief Method void QTextDocument::setModified(bool m)\n", false, &_init_f_setModified_864, &_call_f_setModified_864);
}

// void QTextDocument::setPageSize(const QSizeF &size)


static void _init_f_setPageSize_1875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPageSize_1875 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSizeF &arg1 = args.read<const QSizeF & > ();
  ((QTextDocument *)cls)->setPageSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPageSize_1875 ()
{
  return new qt_gsi::GenericMethod ("setPageSize|pageSize=", "@brief Method void QTextDocument::setPageSize(const QSizeF &size)\n", false, &_init_f_setPageSize_1875, &_call_f_setPageSize_1875);
}

// void QTextDocument::setPlainText(const QString &text)


static void _init_f_setPlainText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPlainText_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QTextDocument *)cls)->setPlainText (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPlainText_2025 ()
{
  return new qt_gsi::GenericMethod ("setPlainText", "@brief Method void QTextDocument::setPlainText(const QString &text)\n", false, &_init_f_setPlainText_2025, &_call_f_setPlainText_2025);
}

// void QTextDocument::setTextWidth(double width)


static void _init_f_setTextWidth_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextWidth_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QTextDocument *)cls)->setTextWidth (arg1);
}

static qt_gsi::GenericMethod *_create_f_setTextWidth_1071 ()
{
  return new qt_gsi::GenericMethod ("setTextWidth|textWidth=", "@brief Method void QTextDocument::setTextWidth(double width)\n", false, &_init_f_setTextWidth_1071, &_call_f_setTextWidth_1071);
}

// void QTextDocument::setUndoRedoEnabled(bool enable)


static void _init_f_setUndoRedoEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUndoRedoEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QTextDocument *)cls)->setUndoRedoEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setUndoRedoEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setUndoRedoEnabled|undoRedoEnabled=", "@brief Method void QTextDocument::setUndoRedoEnabled(bool enable)\n", false, &_init_f_setUndoRedoEnabled_864, &_call_f_setUndoRedoEnabled_864);
}

// void QTextDocument::setUseDesignMetrics(bool b)


static void _init_f_setUseDesignMetrics_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUseDesignMetrics_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QTextDocument *)cls)->setUseDesignMetrics (arg1);
}

static qt_gsi::GenericMethod *_create_f_setUseDesignMetrics_864 ()
{
  return new qt_gsi::GenericMethod ("setUseDesignMetrics|useDesignMetrics=", "@brief Method void QTextDocument::setUseDesignMetrics(bool b)\n", false, &_init_f_setUseDesignMetrics_864, &_call_f_setUseDesignMetrics_864);
}

// QSizeF QTextDocument::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSizeF > ((QSizeF)((QTextDocument *)cls)->size ());
}

static qt_gsi::GenericMethod *_create_f_size_c0 ()
{
  return new qt_gsi::GenericMethod (":size", "@brief Method QSizeF QTextDocument::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
}

// double QTextDocument::textWidth()


static void _init_f_textWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_textWidth_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QTextDocument *)cls)->textWidth ());
}

static qt_gsi::GenericMethod *_create_f_textWidth_c0 ()
{
  return new qt_gsi::GenericMethod (":textWidth", "@brief Method double QTextDocument::textWidth()\n", true, &_init_f_textWidth_c0, &_call_f_textWidth_c0);
}

// QString QTextDocument::toHtml(const QByteArray &encoding)


static void _init_f_toHtml_c2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("encoding", true, "QByteArray()");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toHtml_c2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args ? args.read<const QByteArray & > () : (const QByteArray &)(QByteArray());
  ret.write<QString > ((QString)((QTextDocument *)cls)->toHtml (arg1));
}

static qt_gsi::GenericMethod *_create_f_toHtml_c2309 ()
{
  return new qt_gsi::GenericMethod ("toHtml", "@brief Method QString QTextDocument::toHtml(const QByteArray &encoding)\n", true, &_init_f_toHtml_c2309, &_call_f_toHtml_c2309);
}

// QString QTextDocument::toPlainText()


static void _init_f_toPlainText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_toPlainText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QTextDocument *)cls)->toPlainText ());
}

static qt_gsi::GenericMethod *_create_f_toPlainText_c0 ()
{
  return new qt_gsi::GenericMethod ("toPlainText", "@brief Method QString QTextDocument::toPlainText()\n", true, &_init_f_toPlainText_c0, &_call_f_toPlainText_c0);
}

// void QTextDocument::undo(QTextCursor *cursor)


static void _init_f_undo_1762 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursor");
  decl->add_arg<QTextCursor * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_undo_1762 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextCursor *arg1 = args.read<QTextCursor * > ();
  ((QTextDocument *)cls)->undo (arg1);
}

static qt_gsi::GenericMethod *_create_f_undo_1762 ()
{
  return new qt_gsi::GenericMethod ("undo", "@brief Method void QTextDocument::undo(QTextCursor *cursor)\n", false, &_init_f_undo_1762, &_call_f_undo_1762);
}

// void QTextDocument::undo()


static void _init_f_undo_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_undo_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextDocument *)cls)->undo ();
}

static qt_gsi::GenericMethod *_create_f_undo_0 ()
{
  return new qt_gsi::GenericMethod ("undo", "@brief Method void QTextDocument::undo()\n", false, &_init_f_undo_0, &_call_f_undo_0);
}

// bool QTextDocument::useDesignMetrics()


static void _init_f_useDesignMetrics_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_useDesignMetrics_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextDocument *)cls)->useDesignMetrics ());
}

static qt_gsi::GenericMethod *_create_f_useDesignMetrics_c0 ()
{
  return new qt_gsi::GenericMethod (":useDesignMetrics", "@brief Method bool QTextDocument::useDesignMetrics()\n", true, &_init_f_useDesignMetrics_c0, &_call_f_useDesignMetrics_c0);
}

// static QString QTextDocument::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QTextDocument::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTextDocument::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QTextDocument::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QTextDocument::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTextDocument::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QTextDocument::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QTextDocument::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTextDocument::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QTextDocument::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QTextDocument::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QTextDocument::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QTextDocument, QTextDocument_EventAdaptor> ea_QTextDocument;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QTextDocument> decl_QTextDocument (ea_QTextDocument, decl_QObject, "QTextDocument_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_addResource_4371 ()) +
  gsi::Methods(_create_f_adjustSize_0 ()) +
  gsi::Methods(_create_f_allFormats_c0 ()) +
  gsi::Methods(_create_f_availableRedoSteps_c0 ()) +
  gsi::Methods(_create_f_availableUndoSteps_c0 ()) +
  gsi::Methods(_create_f_begin_c0 ()) +
  gsi::Methods(_create_f_blockCount_c0 ()) +
  gsi::Methods(_create_f_characterAt_c767 ()) +
  gsi::Methods(_create_f_characterCount_c0 ()) +
  gsi::Methods(_create_f_clear_0 ()) +
  gsi::Methods(_create_f_clone_c1302 ()) +
  gsi::Methods(_create_f_defaultFont_c0 ()) +
  gsi::Methods(_create_f_defaultStyleSheet_c0 ()) +
  gsi::Methods(_create_f_defaultTextOption_c0 ()) +
  gsi::Methods(_create_f_documentLayout_c0 ()) +
  gsi::Methods(_create_f_documentMargin_c0 ()) +
  gsi::Methods(_create_f_drawContents_3180 ()) +
  gsi::Methods(_create_f_end_c0 ()) +
  gsi::Methods(_create_f_find_c5920 ()) +
  gsi::Methods(_create_f_find_c7606 ()) +
  gsi::Methods(_create_f_find_c5876 ()) +
  gsi::Methods(_create_f_find_c7562 ()) +
  gsi::Methods(_create_f_findBlock_c767 ()) +
  gsi::Methods(_create_f_findBlockByLineNumber_c767 ()) +
  gsi::Methods(_create_f_findBlockByNumber_c767 ()) +
  gsi::Methods(_create_f_firstBlock_c0 ()) +
  gsi::Methods(_create_f_frameAt_c767 ()) +
  gsi::Methods(_create_f_idealWidth_c0 ()) +
  gsi::Methods(_create_f_indentWidth_c0 ()) +
  gsi::Methods(_create_f_isEmpty_c0 ()) +
  gsi::Methods(_create_f_isModified_c0 ()) +
  gsi::Methods(_create_f_isRedoAvailable_c0 ()) +
  gsi::Methods(_create_f_isUndoAvailable_c0 ()) +
  gsi::Methods(_create_f_isUndoRedoEnabled_c0 ()) +
  gsi::Methods(_create_f_lastBlock_c0 ()) +
  gsi::Methods(_create_f_lineCount_c0 ()) +
  gsi::Methods(_create_f_markContentsDirty_1426 ()) +
  gsi::Methods(_create_f_maximumBlockCount_c0 ()) +
  gsi::Methods(_create_f_metaInformation_c3434 ()) +
  gsi::Methods(_create_f_object_c767 ()) +
  gsi::Methods(_create_f_objectForFormat_c2432 ()) +
  gsi::Methods(_create_f_pageCount_c0 ()) +
  gsi::Methods(_create_f_pageSize_c0 ()) +
  gsi::Methods(_create_f_print_c1443 ()) +
  gsi::Methods(_create_f_redo_1762 ()) +
  gsi::Methods(_create_f_redo_0 ()) +
  gsi::Methods(_create_f_resource_c2360 ()) +
  gsi::Methods(_create_f_revision_c0 ()) +
  gsi::Methods(_create_f_rootFrame_c0 ()) +
  gsi::Methods(_create_f_setDefaultFont_1801 ()) +
  gsi::Methods(_create_f_setDefaultStyleSheet_2025 ()) +
  gsi::Methods(_create_f_setDefaultTextOption_2448 ()) +
  gsi::Methods(_create_f_setDocumentLayout_3413 ()) +
  gsi::Methods(_create_f_setDocumentMargin_1071 ()) +
  gsi::Methods(_create_f_setHtml_2025 ()) +
  gsi::Methods(_create_f_setIndentWidth_1071 ()) +
  gsi::Methods(_create_f_setMaximumBlockCount_767 ()) +
  gsi::Methods(_create_f_setMetaInformation_5351 ()) +
  gsi::Methods(_create_f_setModified_864 ()) +
  gsi::Methods(_create_f_setPageSize_1875 ()) +
  gsi::Methods(_create_f_setPlainText_2025 ()) +
  gsi::Methods(_create_f_setTextWidth_1071 ()) +
  gsi::Methods(_create_f_setUndoRedoEnabled_864 ()) +
  gsi::Methods(_create_f_setUseDesignMetrics_864 ()) +
  gsi::Methods(_create_f_size_c0 ()) +
  gsi::Methods(_create_f_textWidth_c0 ()) +
  gsi::Methods(_create_f_toHtml_c2309 ()) +
  gsi::Methods(_create_f_toPlainText_c0 ()) +
  gsi::Methods(_create_f_undo_1762 ()) +
  gsi::Methods(_create_f_undo_0 ()) +
  gsi::Methods(_create_f_useDesignMetrics_c0 ()) +
  qt_gsi::qt_signal<QTextDocument, QTextDocument_EventAdaptor, int> ("blockCountChanged", &QTextDocument_EventAdaptor::blockCountChanged_e_767, gsi::arg("newBlockCount"), "@brief Signal declaration for QTextDocument::blockCountChanged(int newBlockCount)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTextDocument, QTextDocument_EventAdaptor, int, int, int> ("contentsChange", &QTextDocument_EventAdaptor::contentsChange_e_2085, gsi::arg("from"), gsi::arg("charsRemoves"), gsi::arg("charsAdded"), "@brief Signal declaration for QTextDocument::contentsChange(int from, int charsRemoves, int charsAdded)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTextDocument, QTextDocument_EventAdaptor> ("contentsChanged", &QTextDocument_EventAdaptor::contentsChanged_e_0, "@brief Signal declaration for QTextDocument::contentsChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTextDocument, QTextDocument_EventAdaptor, const QTextCursor &> ("cursorPositionChanged", &QTextDocument_EventAdaptor::cursorPositionChanged_e_2453, gsi::arg("cursor"), "@brief Signal declaration for QTextDocument::cursorPositionChanged(const QTextCursor &cursor)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTextDocument, QTextDocument_EventAdaptor, QObject *> ("destroyed", &QTextDocument_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QTextDocument::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTextDocument, QTextDocument_EventAdaptor> ("documentLayoutChanged", &QTextDocument_EventAdaptor::documentLayoutChanged_e_0, "@brief Signal declaration for QTextDocument::documentLayoutChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTextDocument, QTextDocument_EventAdaptor, bool> ("modificationChanged", &QTextDocument_EventAdaptor::modificationChanged_e_864, gsi::arg("m"), "@brief Signal declaration for QTextDocument::modificationChanged(bool m)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTextDocument, QTextDocument_EventAdaptor, bool> ("redoAvailable", &QTextDocument_EventAdaptor::redoAvailable_e_864, gsi::arg("arg1"), "@brief Signal declaration for QTextDocument::redoAvailable(bool)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTextDocument, QTextDocument_EventAdaptor, bool> ("undoAvailable", &QTextDocument_EventAdaptor::undoAvailable_e_864, gsi::arg("arg1"), "@brief Signal declaration for QTextDocument::undoAvailable(bool)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QTextDocument, QTextDocument_EventAdaptor> ("undoCommandAdded", &QTextDocument_EventAdaptor::undoCommandAdded_e_0, "@brief Signal declaration for QTextDocument::undoCommandAdded()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QTextDocument");
}


class QTextDocument_Adaptor : public QTextDocument, public qt_gsi::QtObjectBase
{
public:

  virtual ~QTextDocument_Adaptor();

  //  [adaptor ctor] QTextDocument::QTextDocument(QObject *parent)
  QTextDocument_Adaptor() : QTextDocument()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTextDocument::QTextDocument(QObject *parent)
  QTextDocument_Adaptor(QObject *parent) : QTextDocument(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTextDocument::QTextDocument(const QString &text, QObject *parent)
  QTextDocument_Adaptor(const QString &text) : QTextDocument(text)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTextDocument::QTextDocument(const QString &text, QObject *parent)
  QTextDocument_Adaptor(const QString &text, QObject *parent) : QTextDocument(text, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QTextDocument::receivers(const char *signal)
  int fp_QTextDocument_receivers_c1731 (const char *signal) const {
    return QTextDocument::receivers(signal);
  }

  //  QObject *QTextDocument::sender()
  QObject * fp_QTextDocument_sender_c0 () const {
    return QTextDocument::sender();
  }

  //  [adaptor impl] void QTextDocument::clear()
  void cbs_clear_0_0()
  {
    QTextDocument::clear();
  }

  virtual void clear()
  {
    if (cb_clear_0_0.can_issue()) {
      cb_clear_0_0.issue<QTextDocument_Adaptor>(&QTextDocument_Adaptor::cbs_clear_0_0);
    } else {
      QTextDocument::clear();
    }
  }

  //  [adaptor impl] bool QTextDocument::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QTextDocument::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QTextDocument_Adaptor, bool, QEvent *>(&QTextDocument_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QTextDocument::event(arg1);
    }
  }

  //  [adaptor impl] bool QTextDocument::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QTextDocument::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QTextDocument_Adaptor, bool, QObject *, QEvent *>(&QTextDocument_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QTextDocument::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QTextDocument::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QTextDocument::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QTextDocument_Adaptor, QChildEvent *>(&QTextDocument_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QTextDocument::childEvent(arg1);
    }
  }

  //  [adaptor impl] QTextObject *QTextDocument::createObject(const QTextFormat &f)
  QTextObject * cbs_createObject_2432_0(const QTextFormat &f)
  {
    return QTextDocument::createObject(f);
  }

  virtual QTextObject * createObject(const QTextFormat &f)
  {
    if (cb_createObject_2432_0.can_issue()) {
      return cb_createObject_2432_0.issue<QTextDocument_Adaptor, QTextObject *, const QTextFormat &>(&QTextDocument_Adaptor::cbs_createObject_2432_0, f);
    } else {
      return QTextDocument::createObject(f);
    }
  }

  //  [adaptor impl] void QTextDocument::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QTextDocument::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QTextDocument_Adaptor, QEvent *>(&QTextDocument_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QTextDocument::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QTextDocument::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QTextDocument::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QTextDocument_Adaptor, const char *>(&QTextDocument_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QTextDocument::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] QVariant QTextDocument::loadResource(int type, const QUrl &name)
  QVariant cbs_loadResource_2360_0(int type, const QUrl &name)
  {
    return QTextDocument::loadResource(type, name);
  }

  virtual QVariant loadResource(int type, const QUrl &name)
  {
    if (cb_loadResource_2360_0.can_issue()) {
      return cb_loadResource_2360_0.issue<QTextDocument_Adaptor, QVariant, int, const QUrl &>(&QTextDocument_Adaptor::cbs_loadResource_2360_0, type, name);
    } else {
      return QTextDocument::loadResource(type, name);
    }
  }

  //  [adaptor impl] void QTextDocument::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QTextDocument::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QTextDocument_Adaptor, QTimerEvent *>(&QTextDocument_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QTextDocument::timerEvent(arg1);
    }
  }

  gsi::Callback cb_clear_0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_createObject_2432_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_loadResource_2360_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QTextDocument_Adaptor::~QTextDocument_Adaptor() { }

//  Constructor QTextDocument::QTextDocument(QObject *parent) (adaptor class)

static void _init_ctor_QTextDocument_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QTextDocument_Adaptor *> ();
}

static void _call_ctor_QTextDocument_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QTextDocument_Adaptor *> (new QTextDocument_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextDocument_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextDocument::QTextDocument(QObject *parent)\nThis method creates an object of class QTextDocument.", &_init_ctor_QTextDocument_Adaptor_1302, &_call_ctor_QTextDocument_Adaptor_1302);
}

//  Constructor QTextDocument::QTextDocument(const QString &text, QObject *parent) (adaptor class)

static void _init_ctor_QTextDocument_Adaptor_3219 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QTextDocument_Adaptor *> ();
}

static void _call_ctor_QTextDocument_Adaptor_3219 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QObject *arg2 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QTextDocument_Adaptor *> (new QTextDocument_Adaptor (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextDocument_Adaptor_3219 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextDocument::QTextDocument(const QString &text, QObject *parent)\nThis method creates an object of class QTextDocument.", &_init_ctor_QTextDocument_Adaptor_3219, &_call_ctor_QTextDocument_Adaptor_3219);
}

// int QTextDocument::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QTextDocument_Adaptor *)cls)->fp_QTextDocument_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QTextDocument::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QTextDocument::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QTextDocument_Adaptor *)cls)->fp_QTextDocument_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QTextDocument::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QTextDocument::clear()

static void _init_cbs_clear_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_clear_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextDocument_Adaptor *)cls)->cbs_clear_0_0 ();
}

static void _set_callback_cbs_clear_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextDocument_Adaptor *)cls)->cb_clear_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_clear_0_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@hide", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_clear_0_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Virtual method void QTextDocument::clear()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_clear_0_0, &_call_cbs_clear_0_0, &_set_callback_cbs_clear_0_0);
}


// bool QTextDocument::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QTextDocument_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextDocument_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QTextDocument::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QTextDocument::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QTextDocument_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextDocument_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QTextDocument::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QTextDocument::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QTextDocument_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextDocument_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QTextDocument::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// QTextObject *QTextDocument::createObject(const QTextFormat &f)

static void _init_cbs_createObject_2432_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f");
  decl->add_arg<const QTextFormat & > (argspec_0);
  decl->set_return<QTextObject * > ();
}

static void _call_cbs_createObject_2432_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextFormat &arg1 = args.read<const QTextFormat & > ();
  ret.write<QTextObject * > ((QTextObject *)((QTextDocument_Adaptor *)cls)->cbs_createObject_2432_0 (arg1));
}

static void _set_callback_cbs_createObject_2432_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextDocument_Adaptor *)cls)->cb_createObject_2432_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_createObject_2432_0 ()
{
  return new qt_gsi::GenericMethod ("*createObject", "@hide", false, &_init_cbs_createObject_2432_0, &_call_cbs_createObject_2432_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_createObject_2432_0 ()
{
  return new qt_gsi::GenericMethod ("*createObject", "@brief Virtual method QTextObject *QTextDocument::createObject(const QTextFormat &f)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_createObject_2432_0, &_call_cbs_createObject_2432_0, &_set_callback_cbs_createObject_2432_0);
}


// void QTextDocument::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QTextDocument_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextDocument_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QTextDocument::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QTextDocument::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QTextDocument_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextDocument_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QTextDocument::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// QVariant QTextDocument::loadResource(int type, const QUrl &name)

static void _init_cbs_loadResource_2360_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name");
  decl->add_arg<const QUrl & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_loadResource_2360_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QUrl &arg2 = args.read<const QUrl & > ();
  ret.write<QVariant > ((QVariant)((QTextDocument_Adaptor *)cls)->cbs_loadResource_2360_0 (arg1, arg2));
}

static void _set_callback_cbs_loadResource_2360_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextDocument_Adaptor *)cls)->cb_loadResource_2360_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_loadResource_2360_0 ()
{
  return new qt_gsi::GenericMethod ("*loadResource", "@hide", false, &_init_cbs_loadResource_2360_0, &_call_cbs_loadResource_2360_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_loadResource_2360_0 ()
{
  return new qt_gsi::GenericMethod ("*loadResource", "@brief Virtual method QVariant QTextDocument::loadResource(int type, const QUrl &name)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_loadResource_2360_0, &_call_cbs_loadResource_2360_0, &_set_callback_cbs_loadResource_2360_0);
}


// void QTextDocument::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QTextDocument_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QTextDocument_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QTextDocument::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QTextDocument> decl_QTextDocument;

gsi::Class<QTextDocument_Adaptor> decl_QTextDocument_Adaptor (decl_QTextDocument, "QTextDocument",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_clear_0_0 ()) +
  gsi::Methods(_create_callback_cbs_clear_0_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_createObject_2432_0 ()) +
  gsi::Methods(_create_callback_cbs_createObject_2432_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_loadResource_2360_0 ()) +
  gsi::Methods(_create_callback_cbs_loadResource_2360_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QTextDocument_Adaptor_1302 ()) +
  gsi::Methods(_create_ctor_QTextDocument_Adaptor_3219 ()),
  "@qt\n@brief Binding of QTextDocument");

}


//  Implementation of the enum wrapper class for QTextDocument::FindFlag
namespace qt_gsi
{

static QTextDocument_FindFlag_Enum *c_1_QTextDocument_FindFlag_Enum () { return new QTextDocument_FindFlag_Enum (QTextDocument::FindBackward); }
static QTextDocument_FindFlag_Enum *c_2_QTextDocument_FindFlag_Enum () { return new QTextDocument_FindFlag_Enum (QTextDocument::FindCaseSensitively); }
static QTextDocument_FindFlag_Enum *c_3_QTextDocument_FindFlag_Enum () { return new QTextDocument_FindFlag_Enum (QTextDocument::FindWholeWords); }

static gsi::Methods mkdefs_QTextDocument_FindFlag () {
  return
    gsi::constant ("FindBackward", &qt_gsi::c_1_QTextDocument_FindFlag_Enum, "@brief Enum constant QTextDocument::FindBackward") +
    gsi::constant ("FindCaseSensitively", &qt_gsi::c_2_QTextDocument_FindFlag_Enum, "@brief Enum constant QTextDocument::FindCaseSensitively") +
    gsi::constant ("FindWholeWords", &qt_gsi::c_3_QTextDocument_FindFlag_Enum, "@brief Enum constant QTextDocument::FindWholeWords");
}

static std::string to_s_QTextDocument_FindFlag_Enum (const QTextDocument_FindFlag_Enum *e)
{
  if (e->value () == QTextDocument::FindBackward) { return tl::sprintf ("FindBackward (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextDocument::FindCaseSensitively) { return tl::sprintf ("FindCaseSensitively (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextDocument::FindWholeWords) { return tl::sprintf ("FindWholeWords (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTextDocument_FindFlag_Enum (const QTextDocument_FindFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTextDocument_FindFlag_Enum *from_i_QTextDocument_FindFlag_Enum (unsigned int i)
{
  return new QTextDocument_FindFlag_Enum ((QTextDocument::FindFlag) i);
}

static bool equalQTextDocument_FindFlag_Enum (const QTextDocument_FindFlag_Enum *e, QTextDocument_FindFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTextDocument_FindFlag_Enum (const QTextDocument_FindFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTextDocument_FindFlag_Enums oropQTextDocument_FindFlag_Enums (const QTextDocument_FindFlag_Enums *e, const QTextDocument_FindFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTextDocument_FindFlag_Enums andopQTextDocument_FindFlag_Enums (const QTextDocument_FindFlag_Enums *e, const QTextDocument_FindFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTextDocument_FindFlag_Enums xoropQTextDocument_FindFlag_Enums (const QTextDocument_FindFlag_Enums *e, const QTextDocument_FindFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTextDocument_FindFlag_Enums (const QTextDocument_FindFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (QTextDocument::FindBackward)) { if (!l.empty ()) l += "|"; l += "FindBackward"; }
  if (e->testFlag (QTextDocument::FindCaseSensitively)) { if (!l.empty ()) l += "|"; l += "FindCaseSensitively"; }
  if (e->testFlag (QTextDocument::FindWholeWords)) { if (!l.empty ()) l += "|"; l += "FindWholeWords"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTextDocument_FindFlag_Enums (const QTextDocument_FindFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTextDocument_FindFlag_Enums (const QTextDocument_FindFlag_Enums *e, const QTextDocument_FindFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTextDocument_FindFlag_Enums> decl_QTextDocument_FindFlag_Enums ("QTextDocument_QFlags_FindFlag",
  gsi::method_ext ("|", &qt_gsi::oropQTextDocument_FindFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTextDocument_FindFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTextDocument_FindFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextDocument_FindFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextDocument_FindFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTextDocument_FindFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTextDocument::FindFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTextDocument_FindFlag_Enum> decl_QTextDocument_FindFlag_Enum (decl_QTextDocument_FindFlag_Enums, "QTextDocument_FindFlag",
  qt_gsi::mkdefs_QTextDocument_FindFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextDocument_FindFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextDocument_FindFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTextDocument_FindFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTextDocument_FindFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTextDocument_FindFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTextDocument::FindFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextDocument> inject_QTextDocument_FindFlag_Enum_in_parent (qt_gsi::mkdefs_QTextDocument_FindFlag ());
static gsi::ClassExt<QTextDocument> decl_QTextDocument_FindFlag_Enum_as_child (decl_QTextDocument_FindFlag_Enum, "FindFlag");

}


//  Implementation of the enum wrapper class for QTextDocument::MetaInformation
namespace qt_gsi
{

static QTextDocument_MetaInformation_Enum *c_1_QTextDocument_MetaInformation_Enum () { return new QTextDocument_MetaInformation_Enum (QTextDocument::DocumentTitle); }
static QTextDocument_MetaInformation_Enum *c_2_QTextDocument_MetaInformation_Enum () { return new QTextDocument_MetaInformation_Enum (QTextDocument::DocumentUrl); }

static gsi::Methods mkdefs_QTextDocument_MetaInformation () {
  return
    gsi::constant ("DocumentTitle", &qt_gsi::c_1_QTextDocument_MetaInformation_Enum, "@brief Enum constant QTextDocument::DocumentTitle") +
    gsi::constant ("DocumentUrl", &qt_gsi::c_2_QTextDocument_MetaInformation_Enum, "@brief Enum constant QTextDocument::DocumentUrl");
}

static std::string to_s_QTextDocument_MetaInformation_Enum (const QTextDocument_MetaInformation_Enum *e)
{
  if (e->value () == QTextDocument::DocumentTitle) { return tl::sprintf ("DocumentTitle (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextDocument::DocumentUrl) { return tl::sprintf ("DocumentUrl (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTextDocument_MetaInformation_Enum (const QTextDocument_MetaInformation_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTextDocument_MetaInformation_Enum *from_i_QTextDocument_MetaInformation_Enum (unsigned int i)
{
  return new QTextDocument_MetaInformation_Enum ((QTextDocument::MetaInformation) i);
}

static bool equalQTextDocument_MetaInformation_Enum (const QTextDocument_MetaInformation_Enum *e, QTextDocument_MetaInformation_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTextDocument_MetaInformation_Enum (const QTextDocument_MetaInformation_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTextDocument_MetaInformation_Enums oropQTextDocument_MetaInformation_Enums (const QTextDocument_MetaInformation_Enums *e, const QTextDocument_MetaInformation_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTextDocument_MetaInformation_Enums andopQTextDocument_MetaInformation_Enums (const QTextDocument_MetaInformation_Enums *e, const QTextDocument_MetaInformation_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTextDocument_MetaInformation_Enums xoropQTextDocument_MetaInformation_Enums (const QTextDocument_MetaInformation_Enums *e, const QTextDocument_MetaInformation_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTextDocument_MetaInformation_Enums (const QTextDocument_MetaInformation_Enums *e)
{
  std::string l;
  if (e->testFlag (QTextDocument::DocumentTitle)) { if (!l.empty ()) l += "|"; l += "DocumentTitle"; }
  if (e->testFlag (QTextDocument::DocumentUrl)) { if (!l.empty ()) l += "|"; l += "DocumentUrl"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTextDocument_MetaInformation_Enums (const QTextDocument_MetaInformation_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTextDocument_MetaInformation_Enums (const QTextDocument_MetaInformation_Enums *e, const QTextDocument_MetaInformation_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTextDocument_MetaInformation_Enums> decl_QTextDocument_MetaInformation_Enums ("QTextDocument_QFlags_MetaInformation",
  gsi::method_ext ("|", &qt_gsi::oropQTextDocument_MetaInformation_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTextDocument_MetaInformation_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTextDocument_MetaInformation_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextDocument_MetaInformation_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextDocument_MetaInformation_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTextDocument_MetaInformation_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTextDocument::MetaInformation> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTextDocument_MetaInformation_Enum> decl_QTextDocument_MetaInformation_Enum (decl_QTextDocument_MetaInformation_Enums, "QTextDocument_MetaInformation",
  qt_gsi::mkdefs_QTextDocument_MetaInformation () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextDocument_MetaInformation_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextDocument_MetaInformation_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTextDocument_MetaInformation_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTextDocument_MetaInformation_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTextDocument_MetaInformation_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTextDocument::MetaInformation enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextDocument> inject_QTextDocument_MetaInformation_Enum_in_parent (qt_gsi::mkdefs_QTextDocument_MetaInformation ());
static gsi::ClassExt<QTextDocument> decl_QTextDocument_MetaInformation_Enum_as_child (decl_QTextDocument_MetaInformation_Enum, "MetaInformation");

}

