
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTextCursor.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQTextCursor_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTextCursor

//  Constructor QTextCursor::QTextCursor()


static void _init_ctor_QTextCursor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QTextCursor *> ();
}

static void _call_ctor_QTextCursor_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextCursor *> (new QTextCursor ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextCursor_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextCursor::QTextCursor()\nThis method creates an object of class QTextCursor.", &_init_ctor_QTextCursor_0, &_call_ctor_QTextCursor_0);
}

//  Constructor QTextCursor::QTextCursor(QTextDocument *document)


static void _init_ctor_QTextCursor_1955 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("document");
  decl->add_arg<QTextDocument * > (argspec_0);
  decl->set_return_new<QTextCursor *> ();
}

static void _call_ctor_QTextCursor_1955 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextDocument *arg1 = args.read<QTextDocument * > ();
  ret.write<QTextCursor *> (new QTextCursor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextCursor_1955 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextCursor::QTextCursor(QTextDocument *document)\nThis method creates an object of class QTextCursor.", &_init_ctor_QTextCursor_1955, &_call_ctor_QTextCursor_1955);
}

//  Constructor QTextCursor::QTextCursor(QTextFrame *frame)


static void _init_ctor_QTextCursor_1615 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frame");
  decl->add_arg<QTextFrame * > (argspec_0);
  decl->set_return_new<QTextCursor *> ();
}

static void _call_ctor_QTextCursor_1615 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextFrame *arg1 = args.read<QTextFrame * > ();
  ret.write<QTextCursor *> (new QTextCursor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextCursor_1615 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextCursor::QTextCursor(QTextFrame *frame)\nThis method creates an object of class QTextCursor.", &_init_ctor_QTextCursor_1615, &_call_ctor_QTextCursor_1615);
}

//  Constructor QTextCursor::QTextCursor(const QTextBlock &block)


static void _init_ctor_QTextCursor_2306 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return_new<QTextCursor *> ();
}

static void _call_ctor_QTextCursor_2306 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextBlock &arg1 = args.read<const QTextBlock & > ();
  ret.write<QTextCursor *> (new QTextCursor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextCursor_2306 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextCursor::QTextCursor(const QTextBlock &block)\nThis method creates an object of class QTextCursor.", &_init_ctor_QTextCursor_2306, &_call_ctor_QTextCursor_2306);
}

//  Constructor QTextCursor::QTextCursor(const QTextCursor &cursor)


static void _init_ctor_QTextCursor_2453 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cursor");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return_new<QTextCursor *> ();
}

static void _call_ctor_QTextCursor_2453 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextCursor &arg1 = args.read<const QTextCursor & > ();
  ret.write<QTextCursor *> (new QTextCursor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextCursor_2453 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextCursor::QTextCursor(const QTextCursor &cursor)\nThis method creates an object of class QTextCursor.", &_init_ctor_QTextCursor_2453, &_call_ctor_QTextCursor_2453);
}

// int QTextCursor::anchor()


static void _init_f_anchor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_anchor_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextCursor *)cls)->anchor ());
}

static qt_gsi::GenericMethod *_create_f_anchor_c0 ()
{
  return new qt_gsi::GenericMethod ("anchor", "@brief Method int QTextCursor::anchor()\n", true, &_init_f_anchor_c0, &_call_f_anchor_c0);
}

// bool QTextCursor::atBlockEnd()


static void _init_f_atBlockEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atBlockEnd_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextCursor *)cls)->atBlockEnd ());
}

static qt_gsi::GenericMethod *_create_f_atBlockEnd_c0 ()
{
  return new qt_gsi::GenericMethod ("atBlockEnd", "@brief Method bool QTextCursor::atBlockEnd()\n", true, &_init_f_atBlockEnd_c0, &_call_f_atBlockEnd_c0);
}

// bool QTextCursor::atBlockStart()


static void _init_f_atBlockStart_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atBlockStart_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextCursor *)cls)->atBlockStart ());
}

static qt_gsi::GenericMethod *_create_f_atBlockStart_c0 ()
{
  return new qt_gsi::GenericMethod ("atBlockStart", "@brief Method bool QTextCursor::atBlockStart()\n", true, &_init_f_atBlockStart_c0, &_call_f_atBlockStart_c0);
}

// bool QTextCursor::atEnd()


static void _init_f_atEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atEnd_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextCursor *)cls)->atEnd ());
}

static qt_gsi::GenericMethod *_create_f_atEnd_c0 ()
{
  return new qt_gsi::GenericMethod ("atEnd", "@brief Method bool QTextCursor::atEnd()\n", true, &_init_f_atEnd_c0, &_call_f_atEnd_c0);
}

// bool QTextCursor::atStart()


static void _init_f_atStart_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atStart_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextCursor *)cls)->atStart ());
}

static qt_gsi::GenericMethod *_create_f_atStart_c0 ()
{
  return new qt_gsi::GenericMethod ("atStart", "@brief Method bool QTextCursor::atStart()\n", true, &_init_f_atStart_c0, &_call_f_atStart_c0);
}

// void QTextCursor::beginEditBlock()


static void _init_f_beginEditBlock_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_beginEditBlock_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextCursor *)cls)->beginEditBlock ();
}

static qt_gsi::GenericMethod *_create_f_beginEditBlock_0 ()
{
  return new qt_gsi::GenericMethod ("beginEditBlock", "@brief Method void QTextCursor::beginEditBlock()\n", false, &_init_f_beginEditBlock_0, &_call_f_beginEditBlock_0);
}

// QTextBlock QTextCursor::block()


static void _init_f_block_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextBlock > ();
}

static void _call_f_block_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextBlock > ((QTextBlock)((QTextCursor *)cls)->block ());
}

static qt_gsi::GenericMethod *_create_f_block_c0 ()
{
  return new qt_gsi::GenericMethod ("block", "@brief Method QTextBlock QTextCursor::block()\n", true, &_init_f_block_c0, &_call_f_block_c0);
}

// QTextCharFormat QTextCursor::blockCharFormat()


static void _init_f_blockCharFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextCharFormat > ();
}

static void _call_f_blockCharFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextCharFormat > ((QTextCharFormat)((QTextCursor *)cls)->blockCharFormat ());
}

static qt_gsi::GenericMethod *_create_f_blockCharFormat_c0 ()
{
  return new qt_gsi::GenericMethod (":blockCharFormat", "@brief Method QTextCharFormat QTextCursor::blockCharFormat()\n", true, &_init_f_blockCharFormat_c0, &_call_f_blockCharFormat_c0);
}

// QTextBlockFormat QTextCursor::blockFormat()


static void _init_f_blockFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextBlockFormat > ();
}

static void _call_f_blockFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextBlockFormat > ((QTextBlockFormat)((QTextCursor *)cls)->blockFormat ());
}

static qt_gsi::GenericMethod *_create_f_blockFormat_c0 ()
{
  return new qt_gsi::GenericMethod (":blockFormat", "@brief Method QTextBlockFormat QTextCursor::blockFormat()\n", true, &_init_f_blockFormat_c0, &_call_f_blockFormat_c0);
}

// int QTextCursor::blockNumber()


static void _init_f_blockNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_blockNumber_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextCursor *)cls)->blockNumber ());
}

static qt_gsi::GenericMethod *_create_f_blockNumber_c0 ()
{
  return new qt_gsi::GenericMethod ("blockNumber", "@brief Method int QTextCursor::blockNumber()\n", true, &_init_f_blockNumber_c0, &_call_f_blockNumber_c0);
}

// QTextCharFormat QTextCursor::charFormat()


static void _init_f_charFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextCharFormat > ();
}

static void _call_f_charFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextCharFormat > ((QTextCharFormat)((QTextCursor *)cls)->charFormat ());
}

static qt_gsi::GenericMethod *_create_f_charFormat_c0 ()
{
  return new qt_gsi::GenericMethod (":charFormat", "@brief Method QTextCharFormat QTextCursor::charFormat()\n", true, &_init_f_charFormat_c0, &_call_f_charFormat_c0);
}

// void QTextCursor::clearSelection()


static void _init_f_clearSelection_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearSelection_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextCursor *)cls)->clearSelection ();
}

static qt_gsi::GenericMethod *_create_f_clearSelection_0 ()
{
  return new qt_gsi::GenericMethod ("clearSelection", "@brief Method void QTextCursor::clearSelection()\n", false, &_init_f_clearSelection_0, &_call_f_clearSelection_0);
}

// int QTextCursor::columnNumber()


static void _init_f_columnNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_columnNumber_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextCursor *)cls)->columnNumber ());
}

static qt_gsi::GenericMethod *_create_f_columnNumber_c0 ()
{
  return new qt_gsi::GenericMethod ("columnNumber", "@brief Method int QTextCursor::columnNumber()\n", true, &_init_f_columnNumber_c0, &_call_f_columnNumber_c0);
}

// QTextList *QTextCursor::createList(const QTextListFormat &format)


static void _init_f_createList_2844 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextListFormat & > (argspec_0);
  decl->set_return<QTextList * > ();
}

static void _call_f_createList_2844 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextListFormat &arg1 = args.read<const QTextListFormat & > ();
  ret.write<QTextList * > ((QTextList *)((QTextCursor *)cls)->createList (arg1));
}

static qt_gsi::GenericMethod *_create_f_createList_2844 ()
{
  return new qt_gsi::GenericMethod ("createList", "@brief Method QTextList *QTextCursor::createList(const QTextListFormat &format)\n", false, &_init_f_createList_2844, &_call_f_createList_2844);
}

// QTextList *QTextCursor::createList(QTextListFormat::Style style)


static void _init_f_createList_2612 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("style");
  decl->add_arg<const qt_gsi::Converter<QTextListFormat::Style>::target_type & > (argspec_0);
  decl->set_return<QTextList * > ();
}

static void _call_f_createList_2612 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QTextListFormat::Style>::target_type & arg1 = args.read<const qt_gsi::Converter<QTextListFormat::Style>::target_type & > ();
  ret.write<QTextList * > ((QTextList *)((QTextCursor *)cls)->createList (qt_gsi::QtToCppAdaptor<QTextListFormat::Style>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_createList_2612 ()
{
  return new qt_gsi::GenericMethod ("createList", "@brief Method QTextList *QTextCursor::createList(QTextListFormat::Style style)\n", false, &_init_f_createList_2612, &_call_f_createList_2612);
}

// QTextFrame *QTextCursor::currentFrame()


static void _init_f_currentFrame_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextFrame * > ();
}

static void _call_f_currentFrame_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextFrame * > ((QTextFrame *)((QTextCursor *)cls)->currentFrame ());
}

static qt_gsi::GenericMethod *_create_f_currentFrame_c0 ()
{
  return new qt_gsi::GenericMethod ("currentFrame", "@brief Method QTextFrame *QTextCursor::currentFrame()\n", true, &_init_f_currentFrame_c0, &_call_f_currentFrame_c0);
}

// QTextList *QTextCursor::currentList()


static void _init_f_currentList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextList * > ();
}

static void _call_f_currentList_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextList * > ((QTextList *)((QTextCursor *)cls)->currentList ());
}

static qt_gsi::GenericMethod *_create_f_currentList_c0 ()
{
  return new qt_gsi::GenericMethod ("currentList", "@brief Method QTextList *QTextCursor::currentList()\n", true, &_init_f_currentList_c0, &_call_f_currentList_c0);
}

// QTextTable *QTextCursor::currentTable()


static void _init_f_currentTable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextTable * > ();
}

static void _call_f_currentTable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextTable * > ((QTextTable *)((QTextCursor *)cls)->currentTable ());
}

static qt_gsi::GenericMethod *_create_f_currentTable_c0 ()
{
  return new qt_gsi::GenericMethod ("currentTable", "@brief Method QTextTable *QTextCursor::currentTable()\n", true, &_init_f_currentTable_c0, &_call_f_currentTable_c0);
}

// void QTextCursor::deleteChar()


static void _init_f_deleteChar_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_deleteChar_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextCursor *)cls)->deleteChar ();
}

static qt_gsi::GenericMethod *_create_f_deleteChar_0 ()
{
  return new qt_gsi::GenericMethod ("deleteChar", "@brief Method void QTextCursor::deleteChar()\n", false, &_init_f_deleteChar_0, &_call_f_deleteChar_0);
}

// void QTextCursor::deletePreviousChar()


static void _init_f_deletePreviousChar_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_deletePreviousChar_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextCursor *)cls)->deletePreviousChar ();
}

static qt_gsi::GenericMethod *_create_f_deletePreviousChar_0 ()
{
  return new qt_gsi::GenericMethod ("deletePreviousChar", "@brief Method void QTextCursor::deletePreviousChar()\n", false, &_init_f_deletePreviousChar_0, &_call_f_deletePreviousChar_0);
}

// QTextDocument *QTextCursor::document()


static void _init_f_document_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextDocument * > ();
}

static void _call_f_document_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextDocument * > ((QTextDocument *)((QTextCursor *)cls)->document ());
}

static qt_gsi::GenericMethod *_create_f_document_c0 ()
{
  return new qt_gsi::GenericMethod ("document", "@brief Method QTextDocument *QTextCursor::document()\n", true, &_init_f_document_c0, &_call_f_document_c0);
}

// void QTextCursor::endEditBlock()


static void _init_f_endEditBlock_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_endEditBlock_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextCursor *)cls)->endEditBlock ();
}

static qt_gsi::GenericMethod *_create_f_endEditBlock_0 ()
{
  return new qt_gsi::GenericMethod ("endEditBlock", "@brief Method void QTextCursor::endEditBlock()\n", false, &_init_f_endEditBlock_0, &_call_f_endEditBlock_0);
}

// bool QTextCursor::hasComplexSelection()


static void _init_f_hasComplexSelection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasComplexSelection_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextCursor *)cls)->hasComplexSelection ());
}

static qt_gsi::GenericMethod *_create_f_hasComplexSelection_c0 ()
{
  return new qt_gsi::GenericMethod ("hasComplexSelection", "@brief Method bool QTextCursor::hasComplexSelection()\n", true, &_init_f_hasComplexSelection_c0, &_call_f_hasComplexSelection_c0);
}

// bool QTextCursor::hasSelection()


static void _init_f_hasSelection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasSelection_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextCursor *)cls)->hasSelection ());
}

static qt_gsi::GenericMethod *_create_f_hasSelection_c0 ()
{
  return new qt_gsi::GenericMethod ("hasSelection", "@brief Method bool QTextCursor::hasSelection()\n", true, &_init_f_hasSelection_c0, &_call_f_hasSelection_c0);
}

// void QTextCursor::insertBlock()


static void _init_f_insertBlock_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_insertBlock_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextCursor *)cls)->insertBlock ();
}

static qt_gsi::GenericMethod *_create_f_insertBlock_0 ()
{
  return new qt_gsi::GenericMethod ("insertBlock", "@brief Method void QTextCursor::insertBlock()\n", false, &_init_f_insertBlock_0, &_call_f_insertBlock_0);
}

// void QTextCursor::insertBlock(const QTextBlockFormat &format)


static void _init_f_insertBlock_2923 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextBlockFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertBlock_2923 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextBlockFormat &arg1 = args.read<const QTextBlockFormat & > ();
  ((QTextCursor *)cls)->insertBlock (arg1);
}

static qt_gsi::GenericMethod *_create_f_insertBlock_2923 ()
{
  return new qt_gsi::GenericMethod ("insertBlock", "@brief Method void QTextCursor::insertBlock(const QTextBlockFormat &format)\n", false, &_init_f_insertBlock_2923, &_call_f_insertBlock_2923);
}

// void QTextCursor::insertBlock(const QTextBlockFormat &format, const QTextCharFormat &charFormat)


static void _init_f_insertBlock_5629 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextBlockFormat & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("charFormat");
  decl->add_arg<const QTextCharFormat & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertBlock_5629 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextBlockFormat &arg1 = args.read<const QTextBlockFormat & > ();
  const QTextCharFormat &arg2 = args.read<const QTextCharFormat & > ();
  ((QTextCursor *)cls)->insertBlock (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_insertBlock_5629 ()
{
  return new qt_gsi::GenericMethod ("insertBlock", "@brief Method void QTextCursor::insertBlock(const QTextBlockFormat &format, const QTextCharFormat &charFormat)\n", false, &_init_f_insertBlock_5629, &_call_f_insertBlock_5629);
}

// void QTextCursor::insertFragment(const QTextDocumentFragment &fragment)


static void _init_f_insertFragment_3466 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fragment");
  decl->add_arg<const QTextDocumentFragment & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertFragment_3466 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextDocumentFragment &arg1 = args.read<const QTextDocumentFragment & > ();
  ((QTextCursor *)cls)->insertFragment (arg1);
}

static qt_gsi::GenericMethod *_create_f_insertFragment_3466 ()
{
  return new qt_gsi::GenericMethod ("insertFragment", "@brief Method void QTextCursor::insertFragment(const QTextDocumentFragment &fragment)\n", false, &_init_f_insertFragment_3466, &_call_f_insertFragment_3466);
}

// QTextFrame *QTextCursor::insertFrame(const QTextFrameFormat &format)


static void _init_f_insertFrame_2923 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextFrameFormat & > (argspec_0);
  decl->set_return<QTextFrame * > ();
}

static void _call_f_insertFrame_2923 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextFrameFormat &arg1 = args.read<const QTextFrameFormat & > ();
  ret.write<QTextFrame * > ((QTextFrame *)((QTextCursor *)cls)->insertFrame (arg1));
}

static qt_gsi::GenericMethod *_create_f_insertFrame_2923 ()
{
  return new qt_gsi::GenericMethod ("insertFrame", "@brief Method QTextFrame *QTextCursor::insertFrame(const QTextFrameFormat &format)\n", false, &_init_f_insertFrame_2923, &_call_f_insertFrame_2923);
}

// void QTextCursor::insertHtml(const QString &html)


static void _init_f_insertHtml_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("html");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertHtml_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QTextCursor *)cls)->insertHtml (arg1);
}

static qt_gsi::GenericMethod *_create_f_insertHtml_2025 ()
{
  return new qt_gsi::GenericMethod ("insertHtml", "@brief Method void QTextCursor::insertHtml(const QString &html)\n", false, &_init_f_insertHtml_2025, &_call_f_insertHtml_2025);
}

// void QTextCursor::insertImage(const QTextImageFormat &format, QTextFrameFormat::Position alignment)


static void _init_f_insertImage_5822 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextImageFormat & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("alignment");
  decl->add_arg<const qt_gsi::Converter<QTextFrameFormat::Position>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertImage_5822 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextImageFormat &arg1 = args.read<const QTextImageFormat & > ();
  const qt_gsi::Converter<QTextFrameFormat::Position>::target_type & arg2 = args.read<const qt_gsi::Converter<QTextFrameFormat::Position>::target_type & > ();
  ((QTextCursor *)cls)->insertImage (arg1, qt_gsi::QtToCppAdaptor<QTextFrameFormat::Position>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_insertImage_5822 ()
{
  return new qt_gsi::GenericMethod ("insertImage", "@brief Method void QTextCursor::insertImage(const QTextImageFormat &format, QTextFrameFormat::Position alignment)\n", false, &_init_f_insertImage_5822, &_call_f_insertImage_5822);
}

// void QTextCursor::insertImage(const QTextImageFormat &format)


static void _init_f_insertImage_2915 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextImageFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertImage_2915 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextImageFormat &arg1 = args.read<const QTextImageFormat & > ();
  ((QTextCursor *)cls)->insertImage (arg1);
}

static qt_gsi::GenericMethod *_create_f_insertImage_2915 ()
{
  return new qt_gsi::GenericMethod ("insertImage", "@brief Method void QTextCursor::insertImage(const QTextImageFormat &format)\n", false, &_init_f_insertImage_2915, &_call_f_insertImage_2915);
}

// void QTextCursor::insertImage(const QString &name)


static void _init_f_insertImage_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertImage_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QTextCursor *)cls)->insertImage (arg1);
}

static qt_gsi::GenericMethod *_create_f_insertImage_2025 ()
{
  return new qt_gsi::GenericMethod ("insertImage", "@brief Method void QTextCursor::insertImage(const QString &name)\n", false, &_init_f_insertImage_2025, &_call_f_insertImage_2025);
}

// void QTextCursor::insertImage(const QImage &image, const QString &name)


static void _init_f_insertImage_3794 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("image");
  decl->add_arg<const QImage & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("name", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertImage_3794 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QImage &arg1 = args.read<const QImage & > ();
  const QString &arg2 = args ? args.read<const QString & > () : (const QString &)(QString());
  ((QTextCursor *)cls)->insertImage (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_insertImage_3794 ()
{
  return new qt_gsi::GenericMethod ("insertImage", "@brief Method void QTextCursor::insertImage(const QImage &image, const QString &name)\n", false, &_init_f_insertImage_3794, &_call_f_insertImage_3794);
}

// QTextList *QTextCursor::insertList(const QTextListFormat &format)


static void _init_f_insertList_2844 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextListFormat & > (argspec_0);
  decl->set_return<QTextList * > ();
}

static void _call_f_insertList_2844 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextListFormat &arg1 = args.read<const QTextListFormat & > ();
  ret.write<QTextList * > ((QTextList *)((QTextCursor *)cls)->insertList (arg1));
}

static qt_gsi::GenericMethod *_create_f_insertList_2844 ()
{
  return new qt_gsi::GenericMethod ("insertList", "@brief Method QTextList *QTextCursor::insertList(const QTextListFormat &format)\n", false, &_init_f_insertList_2844, &_call_f_insertList_2844);
}

// QTextList *QTextCursor::insertList(QTextListFormat::Style style)


static void _init_f_insertList_2612 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("style");
  decl->add_arg<const qt_gsi::Converter<QTextListFormat::Style>::target_type & > (argspec_0);
  decl->set_return<QTextList * > ();
}

static void _call_f_insertList_2612 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QTextListFormat::Style>::target_type & arg1 = args.read<const qt_gsi::Converter<QTextListFormat::Style>::target_type & > ();
  ret.write<QTextList * > ((QTextList *)((QTextCursor *)cls)->insertList (qt_gsi::QtToCppAdaptor<QTextListFormat::Style>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_insertList_2612 ()
{
  return new qt_gsi::GenericMethod ("insertList", "@brief Method QTextList *QTextCursor::insertList(QTextListFormat::Style style)\n", false, &_init_f_insertList_2612, &_call_f_insertList_2612);
}

// QTextTable *QTextCursor::insertTable(int rows, int cols, const QTextTableFormat &format)


static void _init_f_insertTable_4238 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rows");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cols");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format");
  decl->add_arg<const QTextTableFormat & > (argspec_2);
  decl->set_return<QTextTable * > ();
}

static void _call_f_insertTable_4238 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QTextTableFormat &arg3 = args.read<const QTextTableFormat & > ();
  ret.write<QTextTable * > ((QTextTable *)((QTextCursor *)cls)->insertTable (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_insertTable_4238 ()
{
  return new qt_gsi::GenericMethod ("insertTable", "@brief Method QTextTable *QTextCursor::insertTable(int rows, int cols, const QTextTableFormat &format)\n", false, &_init_f_insertTable_4238, &_call_f_insertTable_4238);
}

// QTextTable *QTextCursor::insertTable(int rows, int cols)


static void _init_f_insertTable_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rows");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cols");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QTextTable * > ();
}

static void _call_f_insertTable_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<QTextTable * > ((QTextTable *)((QTextCursor *)cls)->insertTable (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_insertTable_1426 ()
{
  return new qt_gsi::GenericMethod ("insertTable", "@brief Method QTextTable *QTextCursor::insertTable(int rows, int cols)\n", false, &_init_f_insertTable_1426, &_call_f_insertTable_1426);
}

// void QTextCursor::insertText(const QString &text)


static void _init_f_insertText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_insertText_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QTextCursor *)cls)->insertText (arg1);
}

static qt_gsi::GenericMethod *_create_f_insertText_2025 ()
{
  return new qt_gsi::GenericMethod ("insertText", "@brief Method void QTextCursor::insertText(const QString &text)\n", false, &_init_f_insertText_2025, &_call_f_insertText_2025);
}

// void QTextCursor::insertText(const QString &text, const QTextCharFormat &format)


static void _init_f_insertText_4731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QTextCharFormat & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertText_4731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QTextCharFormat &arg2 = args.read<const QTextCharFormat & > ();
  ((QTextCursor *)cls)->insertText (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_insertText_4731 ()
{
  return new qt_gsi::GenericMethod ("insertText", "@brief Method void QTextCursor::insertText(const QString &text, const QTextCharFormat &format)\n", false, &_init_f_insertText_4731, &_call_f_insertText_4731);
}

// bool QTextCursor::isCopyOf(const QTextCursor &other)


static void _init_f_isCopyOf_c2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isCopyOf_c2453 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextCursor &arg1 = args.read<const QTextCursor & > ();
  ret.write<bool > ((bool)((QTextCursor *)cls)->isCopyOf (arg1));
}

static qt_gsi::GenericMethod *_create_f_isCopyOf_c2453 ()
{
  return new qt_gsi::GenericMethod ("isCopyOf?", "@brief Method bool QTextCursor::isCopyOf(const QTextCursor &other)\n", true, &_init_f_isCopyOf_c2453, &_call_f_isCopyOf_c2453);
}

// bool QTextCursor::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextCursor *)cls)->isNull ());
}

static qt_gsi::GenericMethod *_create_f_isNull_c0 ()
{
  return new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QTextCursor::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
}

// void QTextCursor::joinPreviousEditBlock()


static void _init_f_joinPreviousEditBlock_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_joinPreviousEditBlock_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextCursor *)cls)->joinPreviousEditBlock ();
}

static qt_gsi::GenericMethod *_create_f_joinPreviousEditBlock_0 ()
{
  return new qt_gsi::GenericMethod ("joinPreviousEditBlock", "@brief Method void QTextCursor::joinPreviousEditBlock()\n", false, &_init_f_joinPreviousEditBlock_0, &_call_f_joinPreviousEditBlock_0);
}

// void QTextCursor::mergeBlockCharFormat(const QTextCharFormat &modifier)


static void _init_f_mergeBlockCharFormat_2814 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("modifier");
  decl->add_arg<const QTextCharFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_mergeBlockCharFormat_2814 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextCharFormat &arg1 = args.read<const QTextCharFormat & > ();
  ((QTextCursor *)cls)->mergeBlockCharFormat (arg1);
}

static qt_gsi::GenericMethod *_create_f_mergeBlockCharFormat_2814 ()
{
  return new qt_gsi::GenericMethod ("mergeBlockCharFormat", "@brief Method void QTextCursor::mergeBlockCharFormat(const QTextCharFormat &modifier)\n", false, &_init_f_mergeBlockCharFormat_2814, &_call_f_mergeBlockCharFormat_2814);
}

// void QTextCursor::mergeBlockFormat(const QTextBlockFormat &modifier)


static void _init_f_mergeBlockFormat_2923 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("modifier");
  decl->add_arg<const QTextBlockFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_mergeBlockFormat_2923 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextBlockFormat &arg1 = args.read<const QTextBlockFormat & > ();
  ((QTextCursor *)cls)->mergeBlockFormat (arg1);
}

static qt_gsi::GenericMethod *_create_f_mergeBlockFormat_2923 ()
{
  return new qt_gsi::GenericMethod ("mergeBlockFormat", "@brief Method void QTextCursor::mergeBlockFormat(const QTextBlockFormat &modifier)\n", false, &_init_f_mergeBlockFormat_2923, &_call_f_mergeBlockFormat_2923);
}

// void QTextCursor::mergeCharFormat(const QTextCharFormat &modifier)


static void _init_f_mergeCharFormat_2814 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("modifier");
  decl->add_arg<const QTextCharFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_mergeCharFormat_2814 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextCharFormat &arg1 = args.read<const QTextCharFormat & > ();
  ((QTextCursor *)cls)->mergeCharFormat (arg1);
}

static qt_gsi::GenericMethod *_create_f_mergeCharFormat_2814 ()
{
  return new qt_gsi::GenericMethod ("mergeCharFormat", "@brief Method void QTextCursor::mergeCharFormat(const QTextCharFormat &modifier)\n", false, &_init_f_mergeCharFormat_2814, &_call_f_mergeCharFormat_2814);
}

// bool QTextCursor::movePosition(QTextCursor::MoveOperation op, QTextCursor::MoveMode, int n)


static void _init_f_movePosition_6083 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("op");
  decl->add_arg<const qt_gsi::Converter<QTextCursor::MoveOperation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2", true, "QTextCursor::MoveAnchor");
  decl->add_arg<const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_movePosition_6083 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QTextCursor::MoveOperation>::target_type & arg1 = args.read<const qt_gsi::Converter<QTextCursor::MoveOperation>::target_type & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & > () : (const qt_gsi::Converter<QTextCursor::MoveMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QTextCursor::MoveMode>(heap, QTextCursor::MoveAnchor));
  int arg3 = args ? args.read<int > () : (int)(1);
  ret.write<bool > ((bool)((QTextCursor *)cls)->movePosition (qt_gsi::QtToCppAdaptor<QTextCursor::MoveOperation>(arg1).cref(), qt_gsi::QtToCppAdaptor<QTextCursor::MoveMode>(arg2).cref(), arg3));
}

static qt_gsi::GenericMethod *_create_f_movePosition_6083 ()
{
  return new qt_gsi::GenericMethod ("movePosition", "@brief Method bool QTextCursor::movePosition(QTextCursor::MoveOperation op, QTextCursor::MoveMode, int n)\n", false, &_init_f_movePosition_6083, &_call_f_movePosition_6083);
}

// bool QTextCursor::operator!=(const QTextCursor &rhs)


static void _init_f_operator_excl__eq__c2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rhs");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2453 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextCursor &arg1 = args.read<const QTextCursor & > ();
  ret.write<bool > ((bool)((QTextCursor *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c2453 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QTextCursor::operator!=(const QTextCursor &rhs)\n", true, &_init_f_operator_excl__eq__c2453, &_call_f_operator_excl__eq__c2453);
}

// bool QTextCursor::operator<(const QTextCursor &rhs)


static void _init_f_operator_lt__c2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rhs");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_lt__c2453 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextCursor &arg1 = args.read<const QTextCursor & > ();
  ret.write<bool > ((bool)((QTextCursor *)cls)->operator< (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_lt__c2453 ()
{
  return new qt_gsi::GenericMethod ("<", "@brief Method bool QTextCursor::operator<(const QTextCursor &rhs)\n", true, &_init_f_operator_lt__c2453, &_call_f_operator_lt__c2453);
}

// bool QTextCursor::operator<=(const QTextCursor &rhs)


static void _init_f_operator_lt__eq__c2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rhs");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_lt__eq__c2453 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextCursor &arg1 = args.read<const QTextCursor & > ();
  ret.write<bool > ((bool)((QTextCursor *)cls)->operator<= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_lt__eq__c2453 ()
{
  return new qt_gsi::GenericMethod ("<=", "@brief Method bool QTextCursor::operator<=(const QTextCursor &rhs)\n", true, &_init_f_operator_lt__eq__c2453, &_call_f_operator_lt__eq__c2453);
}

// QTextCursor &QTextCursor::operator=(const QTextCursor &other)


static void _init_f_operator_eq__2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<QTextCursor & > ();
}

static void _call_f_operator_eq__2453 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextCursor &arg1 = args.read<const QTextCursor & > ();
  ret.write<QTextCursor & > ((QTextCursor &)((QTextCursor *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__2453 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QTextCursor &QTextCursor::operator=(const QTextCursor &other)\n", false, &_init_f_operator_eq__2453, &_call_f_operator_eq__2453);
}

// bool QTextCursor::operator==(const QTextCursor &rhs)


static void _init_f_operator_eq__eq__c2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rhs");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2453 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextCursor &arg1 = args.read<const QTextCursor & > ();
  ret.write<bool > ((bool)((QTextCursor *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c2453 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QTextCursor::operator==(const QTextCursor &rhs)\n", true, &_init_f_operator_eq__eq__c2453, &_call_f_operator_eq__eq__c2453);
}

// bool QTextCursor::operator>(const QTextCursor &rhs)


static void _init_f_operator_gt__c2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rhs");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_gt__c2453 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextCursor &arg1 = args.read<const QTextCursor & > ();
  ret.write<bool > ((bool)((QTextCursor *)cls)->operator> (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_gt__c2453 ()
{
  return new qt_gsi::GenericMethod (">", "@brief Method bool QTextCursor::operator>(const QTextCursor &rhs)\n", true, &_init_f_operator_gt__c2453, &_call_f_operator_gt__c2453);
}

// bool QTextCursor::operator>=(const QTextCursor &rhs)


static void _init_f_operator_gt__eq__c2453 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rhs");
  decl->add_arg<const QTextCursor & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_gt__eq__c2453 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextCursor &arg1 = args.read<const QTextCursor & > ();
  ret.write<bool > ((bool)((QTextCursor *)cls)->operator>= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_gt__eq__c2453 ()
{
  return new qt_gsi::GenericMethod (">=", "@brief Method bool QTextCursor::operator>=(const QTextCursor &rhs)\n", true, &_init_f_operator_gt__eq__c2453, &_call_f_operator_gt__eq__c2453);
}

// int QTextCursor::position()


static void _init_f_position_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_position_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextCursor *)cls)->position ());
}

static qt_gsi::GenericMethod *_create_f_position_c0 ()
{
  return new qt_gsi::GenericMethod (":position", "@brief Method int QTextCursor::position()\n", true, &_init_f_position_c0, &_call_f_position_c0);
}

// void QTextCursor::removeSelectedText()


static void _init_f_removeSelectedText_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_removeSelectedText_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextCursor *)cls)->removeSelectedText ();
}

static qt_gsi::GenericMethod *_create_f_removeSelectedText_0 ()
{
  return new qt_gsi::GenericMethod ("removeSelectedText", "@brief Method void QTextCursor::removeSelectedText()\n", false, &_init_f_removeSelectedText_0, &_call_f_removeSelectedText_0);
}

// void QTextCursor::select(QTextCursor::SelectionType selection)


static void _init_f_select_3044 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const qt_gsi::Converter<QTextCursor::SelectionType>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_select_3044 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QTextCursor::SelectionType>::target_type & arg1 = args.read<const qt_gsi::Converter<QTextCursor::SelectionType>::target_type & > ();
  ((QTextCursor *)cls)->select (qt_gsi::QtToCppAdaptor<QTextCursor::SelectionType>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_select_3044 ()
{
  return new qt_gsi::GenericMethod ("select", "@brief Method void QTextCursor::select(QTextCursor::SelectionType selection)\n", false, &_init_f_select_3044, &_call_f_select_3044);
}

// void QTextCursor::selectedTableCells(int *firstRow, int *numRows, int *firstColumn, int *numColumns)


static void _init_f_selectedTableCells_c3488 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("firstRow");
  decl->add_arg<int * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("numRows");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("firstColumn");
  decl->add_arg<int * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("numColumns");
  decl->add_arg<int * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_selectedTableCells_c3488 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int *arg1 = args.read<int * > ();
  int *arg2 = args.read<int * > ();
  int *arg3 = args.read<int * > ();
  int *arg4 = args.read<int * > ();
  ((QTextCursor *)cls)->selectedTableCells (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_selectedTableCells_c3488 ()
{
  return new qt_gsi::GenericMethod ("selectedTableCells", "@brief Method void QTextCursor::selectedTableCells(int *firstRow, int *numRows, int *firstColumn, int *numColumns)\n", true, &_init_f_selectedTableCells_c3488, &_call_f_selectedTableCells_c3488);
}

// QString QTextCursor::selectedText()


static void _init_f_selectedText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_selectedText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QTextCursor *)cls)->selectedText ());
}

static qt_gsi::GenericMethod *_create_f_selectedText_c0 ()
{
  return new qt_gsi::GenericMethod ("selectedText", "@brief Method QString QTextCursor::selectedText()\n", true, &_init_f_selectedText_c0, &_call_f_selectedText_c0);
}

// QTextDocumentFragment QTextCursor::selection()


static void _init_f_selection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextDocumentFragment > ();
}

static void _call_f_selection_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextDocumentFragment > ((QTextDocumentFragment)((QTextCursor *)cls)->selection ());
}

static qt_gsi::GenericMethod *_create_f_selection_c0 ()
{
  return new qt_gsi::GenericMethod ("selection", "@brief Method QTextDocumentFragment QTextCursor::selection()\n", true, &_init_f_selection_c0, &_call_f_selection_c0);
}

// int QTextCursor::selectionEnd()


static void _init_f_selectionEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_selectionEnd_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextCursor *)cls)->selectionEnd ());
}

static qt_gsi::GenericMethod *_create_f_selectionEnd_c0 ()
{
  return new qt_gsi::GenericMethod ("selectionEnd", "@brief Method int QTextCursor::selectionEnd()\n", true, &_init_f_selectionEnd_c0, &_call_f_selectionEnd_c0);
}

// int QTextCursor::selectionStart()


static void _init_f_selectionStart_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_selectionStart_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextCursor *)cls)->selectionStart ());
}

static qt_gsi::GenericMethod *_create_f_selectionStart_c0 ()
{
  return new qt_gsi::GenericMethod ("selectionStart", "@brief Method int QTextCursor::selectionStart()\n", true, &_init_f_selectionStart_c0, &_call_f_selectionStart_c0);
}

// void QTextCursor::setBlockCharFormat(const QTextCharFormat &format)


static void _init_f_setBlockCharFormat_2814 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextCharFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBlockCharFormat_2814 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextCharFormat &arg1 = args.read<const QTextCharFormat & > ();
  ((QTextCursor *)cls)->setBlockCharFormat (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBlockCharFormat_2814 ()
{
  return new qt_gsi::GenericMethod ("setBlockCharFormat|blockCharFormat=", "@brief Method void QTextCursor::setBlockCharFormat(const QTextCharFormat &format)\n", false, &_init_f_setBlockCharFormat_2814, &_call_f_setBlockCharFormat_2814);
}

// void QTextCursor::setBlockFormat(const QTextBlockFormat &format)


static void _init_f_setBlockFormat_2923 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextBlockFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBlockFormat_2923 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextBlockFormat &arg1 = args.read<const QTextBlockFormat & > ();
  ((QTextCursor *)cls)->setBlockFormat (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBlockFormat_2923 ()
{
  return new qt_gsi::GenericMethod ("setBlockFormat|blockFormat=", "@brief Method void QTextCursor::setBlockFormat(const QTextBlockFormat &format)\n", false, &_init_f_setBlockFormat_2923, &_call_f_setBlockFormat_2923);
}

// void QTextCursor::setCharFormat(const QTextCharFormat &format)


static void _init_f_setCharFormat_2814 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextCharFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCharFormat_2814 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextCharFormat &arg1 = args.read<const QTextCharFormat & > ();
  ((QTextCursor *)cls)->setCharFormat (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCharFormat_2814 ()
{
  return new qt_gsi::GenericMethod ("setCharFormat|charFormat=", "@brief Method void QTextCursor::setCharFormat(const QTextCharFormat &format)\n", false, &_init_f_setCharFormat_2814, &_call_f_setCharFormat_2814);
}

// void QTextCursor::setPosition(int pos, QTextCursor::MoveMode mode)


static void _init_f_setPosition_3147 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "QTextCursor::MoveAnchor");
  decl->add_arg<const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPosition_3147 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QTextCursor::MoveMode>::target_type & > () : (const qt_gsi::Converter<QTextCursor::MoveMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QTextCursor::MoveMode>(heap, QTextCursor::MoveAnchor));
  ((QTextCursor *)cls)->setPosition (arg1, qt_gsi::QtToCppAdaptor<QTextCursor::MoveMode>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setPosition_3147 ()
{
  return new qt_gsi::GenericMethod ("setPosition", "@brief Method void QTextCursor::setPosition(int pos, QTextCursor::MoveMode mode)\n", false, &_init_f_setPosition_3147, &_call_f_setPosition_3147);
}

// void QTextCursor::setVisualNavigation(bool b)


static void _init_f_setVisualNavigation_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisualNavigation_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QTextCursor *)cls)->setVisualNavigation (arg1);
}

static qt_gsi::GenericMethod *_create_f_setVisualNavigation_864 ()
{
  return new qt_gsi::GenericMethod ("setVisualNavigation|visualNavigation=", "@brief Method void QTextCursor::setVisualNavigation(bool b)\n", false, &_init_f_setVisualNavigation_864, &_call_f_setVisualNavigation_864);
}

// bool QTextCursor::visualNavigation()


static void _init_f_visualNavigation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_visualNavigation_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextCursor *)cls)->visualNavigation ());
}

static qt_gsi::GenericMethod *_create_f_visualNavigation_c0 ()
{
  return new qt_gsi::GenericMethod (":visualNavigation", "@brief Method bool QTextCursor::visualNavigation()\n", true, &_init_f_visualNavigation_c0, &_call_f_visualNavigation_c0);
}


namespace gsi
{
gsi::Class<QTextCursor> decl_QTextCursor ("QTextCursor",
  gsi::Methods(_create_ctor_QTextCursor_0 ()) +
  gsi::Methods(_create_ctor_QTextCursor_1955 ()) +
  gsi::Methods(_create_ctor_QTextCursor_1615 ()) +
  gsi::Methods(_create_ctor_QTextCursor_2306 ()) +
  gsi::Methods(_create_ctor_QTextCursor_2453 ()) +
  gsi::Methods(_create_f_anchor_c0 ()) +
  gsi::Methods(_create_f_atBlockEnd_c0 ()) +
  gsi::Methods(_create_f_atBlockStart_c0 ()) +
  gsi::Methods(_create_f_atEnd_c0 ()) +
  gsi::Methods(_create_f_atStart_c0 ()) +
  gsi::Methods(_create_f_beginEditBlock_0 ()) +
  gsi::Methods(_create_f_block_c0 ()) +
  gsi::Methods(_create_f_blockCharFormat_c0 ()) +
  gsi::Methods(_create_f_blockFormat_c0 ()) +
  gsi::Methods(_create_f_blockNumber_c0 ()) +
  gsi::Methods(_create_f_charFormat_c0 ()) +
  gsi::Methods(_create_f_clearSelection_0 ()) +
  gsi::Methods(_create_f_columnNumber_c0 ()) +
  gsi::Methods(_create_f_createList_2844 ()) +
  gsi::Methods(_create_f_createList_2612 ()) +
  gsi::Methods(_create_f_currentFrame_c0 ()) +
  gsi::Methods(_create_f_currentList_c0 ()) +
  gsi::Methods(_create_f_currentTable_c0 ()) +
  gsi::Methods(_create_f_deleteChar_0 ()) +
  gsi::Methods(_create_f_deletePreviousChar_0 ()) +
  gsi::Methods(_create_f_document_c0 ()) +
  gsi::Methods(_create_f_endEditBlock_0 ()) +
  gsi::Methods(_create_f_hasComplexSelection_c0 ()) +
  gsi::Methods(_create_f_hasSelection_c0 ()) +
  gsi::Methods(_create_f_insertBlock_0 ()) +
  gsi::Methods(_create_f_insertBlock_2923 ()) +
  gsi::Methods(_create_f_insertBlock_5629 ()) +
  gsi::Methods(_create_f_insertFragment_3466 ()) +
  gsi::Methods(_create_f_insertFrame_2923 ()) +
  gsi::Methods(_create_f_insertHtml_2025 ()) +
  gsi::Methods(_create_f_insertImage_5822 ()) +
  gsi::Methods(_create_f_insertImage_2915 ()) +
  gsi::Methods(_create_f_insertImage_2025 ()) +
  gsi::Methods(_create_f_insertImage_3794 ()) +
  gsi::Methods(_create_f_insertList_2844 ()) +
  gsi::Methods(_create_f_insertList_2612 ()) +
  gsi::Methods(_create_f_insertTable_4238 ()) +
  gsi::Methods(_create_f_insertTable_1426 ()) +
  gsi::Methods(_create_f_insertText_2025 ()) +
  gsi::Methods(_create_f_insertText_4731 ()) +
  gsi::Methods(_create_f_isCopyOf_c2453 ()) +
  gsi::Methods(_create_f_isNull_c0 ()) +
  gsi::Methods(_create_f_joinPreviousEditBlock_0 ()) +
  gsi::Methods(_create_f_mergeBlockCharFormat_2814 ()) +
  gsi::Methods(_create_f_mergeBlockFormat_2923 ()) +
  gsi::Methods(_create_f_mergeCharFormat_2814 ()) +
  gsi::Methods(_create_f_movePosition_6083 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c2453 ()) +
  gsi::Methods(_create_f_operator_lt__c2453 ()) +
  gsi::Methods(_create_f_operator_lt__eq__c2453 ()) +
  gsi::Methods(_create_f_operator_eq__2453 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c2453 ()) +
  gsi::Methods(_create_f_operator_gt__c2453 ()) +
  gsi::Methods(_create_f_operator_gt__eq__c2453 ()) +
  gsi::Methods(_create_f_position_c0 ()) +
  gsi::Methods(_create_f_removeSelectedText_0 ()) +
  gsi::Methods(_create_f_select_3044 ()) +
  gsi::Methods(_create_f_selectedTableCells_c3488 ()) +
  gsi::Methods(_create_f_selectedText_c0 ()) +
  gsi::Methods(_create_f_selection_c0 ()) +
  gsi::Methods(_create_f_selectionEnd_c0 ()) +
  gsi::Methods(_create_f_selectionStart_c0 ()) +
  gsi::Methods(_create_f_setBlockCharFormat_2814 ()) +
  gsi::Methods(_create_f_setBlockFormat_2923 ()) +
  gsi::Methods(_create_f_setCharFormat_2814 ()) +
  gsi::Methods(_create_f_setPosition_3147 ()) +
  gsi::Methods(_create_f_setVisualNavigation_864 ()) +
  gsi::Methods(_create_f_visualNavigation_c0 ()),
  "@qt\n@brief Binding of QTextCursor");

}


//  Implementation of the enum wrapper class for QTextCursor::MoveMode
namespace qt_gsi
{

static QTextCursor_MoveMode_Enum *c_1_QTextCursor_MoveMode_Enum () { return new QTextCursor_MoveMode_Enum (QTextCursor::MoveAnchor); }
static QTextCursor_MoveMode_Enum *c_2_QTextCursor_MoveMode_Enum () { return new QTextCursor_MoveMode_Enum (QTextCursor::KeepAnchor); }

static gsi::Methods mkdefs_QTextCursor_MoveMode () {
  return
    gsi::constant ("MoveAnchor", &qt_gsi::c_1_QTextCursor_MoveMode_Enum, "@brief Enum constant QTextCursor::MoveAnchor") +
    gsi::constant ("KeepAnchor", &qt_gsi::c_2_QTextCursor_MoveMode_Enum, "@brief Enum constant QTextCursor::KeepAnchor");
}

static std::string to_s_QTextCursor_MoveMode_Enum (const QTextCursor_MoveMode_Enum *e)
{
  if (e->value () == QTextCursor::MoveAnchor) { return tl::sprintf ("MoveAnchor (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::KeepAnchor) { return tl::sprintf ("KeepAnchor (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTextCursor_MoveMode_Enum (const QTextCursor_MoveMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTextCursor_MoveMode_Enum *from_i_QTextCursor_MoveMode_Enum (unsigned int i)
{
  return new QTextCursor_MoveMode_Enum ((QTextCursor::MoveMode) i);
}

static bool equalQTextCursor_MoveMode_Enum (const QTextCursor_MoveMode_Enum *e, QTextCursor_MoveMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTextCursor_MoveMode_Enum (const QTextCursor_MoveMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTextCursor_MoveMode_Enums oropQTextCursor_MoveMode_Enums (const QTextCursor_MoveMode_Enums *e, const QTextCursor_MoveMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTextCursor_MoveMode_Enums andopQTextCursor_MoveMode_Enums (const QTextCursor_MoveMode_Enums *e, const QTextCursor_MoveMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTextCursor_MoveMode_Enums xoropQTextCursor_MoveMode_Enums (const QTextCursor_MoveMode_Enums *e, const QTextCursor_MoveMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTextCursor_MoveMode_Enums (const QTextCursor_MoveMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QTextCursor::MoveAnchor)) { if (!l.empty ()) l += "|"; l += "MoveAnchor"; }
  if (e->testFlag (QTextCursor::KeepAnchor)) { if (!l.empty ()) l += "|"; l += "KeepAnchor"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTextCursor_MoveMode_Enums (const QTextCursor_MoveMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTextCursor_MoveMode_Enums (const QTextCursor_MoveMode_Enums *e, const QTextCursor_MoveMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTextCursor_MoveMode_Enums> decl_QTextCursor_MoveMode_Enums ("QTextCursor_QFlags_MoveMode",
  gsi::method_ext ("|", &qt_gsi::oropQTextCursor_MoveMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTextCursor_MoveMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTextCursor_MoveMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextCursor_MoveMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextCursor_MoveMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTextCursor_MoveMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTextCursor::MoveMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTextCursor_MoveMode_Enum> decl_QTextCursor_MoveMode_Enum (decl_QTextCursor_MoveMode_Enums, "QTextCursor_MoveMode",
  qt_gsi::mkdefs_QTextCursor_MoveMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextCursor_MoveMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextCursor_MoveMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTextCursor_MoveMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTextCursor_MoveMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTextCursor_MoveMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTextCursor::MoveMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextCursor> inject_QTextCursor_MoveMode_Enum_in_parent (qt_gsi::mkdefs_QTextCursor_MoveMode ());
static gsi::ClassExt<QTextCursor> decl_QTextCursor_MoveMode_Enum_as_child (decl_QTextCursor_MoveMode_Enum, "MoveMode");

}


//  Implementation of the enum wrapper class for QTextCursor::MoveOperation
namespace qt_gsi
{

static QTextCursor_MoveOperation_Enum *c_1_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::NoMove); }
static QTextCursor_MoveOperation_Enum *c_2_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::Start); }
static QTextCursor_MoveOperation_Enum *c_3_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::Up); }
static QTextCursor_MoveOperation_Enum *c_4_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::StartOfLine); }
static QTextCursor_MoveOperation_Enum *c_5_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::StartOfBlock); }
static QTextCursor_MoveOperation_Enum *c_6_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::StartOfWord); }
static QTextCursor_MoveOperation_Enum *c_7_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::PreviousBlock); }
static QTextCursor_MoveOperation_Enum *c_8_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::PreviousCharacter); }
static QTextCursor_MoveOperation_Enum *c_9_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::PreviousWord); }
static QTextCursor_MoveOperation_Enum *c_10_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::Left); }
static QTextCursor_MoveOperation_Enum *c_11_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::WordLeft); }
static QTextCursor_MoveOperation_Enum *c_12_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::End); }
static QTextCursor_MoveOperation_Enum *c_13_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::Down); }
static QTextCursor_MoveOperation_Enum *c_14_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::EndOfLine); }
static QTextCursor_MoveOperation_Enum *c_15_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::EndOfWord); }
static QTextCursor_MoveOperation_Enum *c_16_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::EndOfBlock); }
static QTextCursor_MoveOperation_Enum *c_17_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::NextBlock); }
static QTextCursor_MoveOperation_Enum *c_18_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::NextCharacter); }
static QTextCursor_MoveOperation_Enum *c_19_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::NextWord); }
static QTextCursor_MoveOperation_Enum *c_20_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::Right); }
static QTextCursor_MoveOperation_Enum *c_21_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::WordRight); }
static QTextCursor_MoveOperation_Enum *c_22_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::NextCell); }
static QTextCursor_MoveOperation_Enum *c_23_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::PreviousCell); }
static QTextCursor_MoveOperation_Enum *c_24_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::NextRow); }
static QTextCursor_MoveOperation_Enum *c_25_QTextCursor_MoveOperation_Enum () { return new QTextCursor_MoveOperation_Enum (QTextCursor::PreviousRow); }

static gsi::Methods mkdefs_QTextCursor_MoveOperation () {
  return
    gsi::constant ("NoMove", &qt_gsi::c_1_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::NoMove") +
    gsi::constant ("Start", &qt_gsi::c_2_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::Start") +
    gsi::constant ("Up", &qt_gsi::c_3_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::Up") +
    gsi::constant ("StartOfLine", &qt_gsi::c_4_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::StartOfLine") +
    gsi::constant ("StartOfBlock", &qt_gsi::c_5_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::StartOfBlock") +
    gsi::constant ("StartOfWord", &qt_gsi::c_6_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::StartOfWord") +
    gsi::constant ("PreviousBlock", &qt_gsi::c_7_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::PreviousBlock") +
    gsi::constant ("PreviousCharacter", &qt_gsi::c_8_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::PreviousCharacter") +
    gsi::constant ("PreviousWord", &qt_gsi::c_9_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::PreviousWord") +
    gsi::constant ("Left", &qt_gsi::c_10_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::Left") +
    gsi::constant ("WordLeft", &qt_gsi::c_11_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::WordLeft") +
    gsi::constant ("End", &qt_gsi::c_12_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::End") +
    gsi::constant ("Down", &qt_gsi::c_13_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::Down") +
    gsi::constant ("EndOfLine", &qt_gsi::c_14_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::EndOfLine") +
    gsi::constant ("EndOfWord", &qt_gsi::c_15_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::EndOfWord") +
    gsi::constant ("EndOfBlock", &qt_gsi::c_16_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::EndOfBlock") +
    gsi::constant ("NextBlock", &qt_gsi::c_17_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::NextBlock") +
    gsi::constant ("NextCharacter", &qt_gsi::c_18_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::NextCharacter") +
    gsi::constant ("NextWord", &qt_gsi::c_19_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::NextWord") +
    gsi::constant ("Right", &qt_gsi::c_20_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::Right") +
    gsi::constant ("WordRight", &qt_gsi::c_21_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::WordRight") +
    gsi::constant ("NextCell", &qt_gsi::c_22_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::NextCell") +
    gsi::constant ("PreviousCell", &qt_gsi::c_23_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::PreviousCell") +
    gsi::constant ("NextRow", &qt_gsi::c_24_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::NextRow") +
    gsi::constant ("PreviousRow", &qt_gsi::c_25_QTextCursor_MoveOperation_Enum, "@brief Enum constant QTextCursor::PreviousRow");
}

static std::string to_s_QTextCursor_MoveOperation_Enum (const QTextCursor_MoveOperation_Enum *e)
{
  if (e->value () == QTextCursor::NoMove) { return tl::sprintf ("NoMove (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::Start) { return tl::sprintf ("Start (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::Up) { return tl::sprintf ("Up (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::StartOfLine) { return tl::sprintf ("StartOfLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::StartOfBlock) { return tl::sprintf ("StartOfBlock (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::StartOfWord) { return tl::sprintf ("StartOfWord (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::PreviousBlock) { return tl::sprintf ("PreviousBlock (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::PreviousCharacter) { return tl::sprintf ("PreviousCharacter (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::PreviousWord) { return tl::sprintf ("PreviousWord (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::Left) { return tl::sprintf ("Left (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::WordLeft) { return tl::sprintf ("WordLeft (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::End) { return tl::sprintf ("End (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::Down) { return tl::sprintf ("Down (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::EndOfLine) { return tl::sprintf ("EndOfLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::EndOfWord) { return tl::sprintf ("EndOfWord (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::EndOfBlock) { return tl::sprintf ("EndOfBlock (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::NextBlock) { return tl::sprintf ("NextBlock (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::NextCharacter) { return tl::sprintf ("NextCharacter (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::NextWord) { return tl::sprintf ("NextWord (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::Right) { return tl::sprintf ("Right (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::WordRight) { return tl::sprintf ("WordRight (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::NextCell) { return tl::sprintf ("NextCell (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::PreviousCell) { return tl::sprintf ("PreviousCell (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::NextRow) { return tl::sprintf ("NextRow (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::PreviousRow) { return tl::sprintf ("PreviousRow (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTextCursor_MoveOperation_Enum (const QTextCursor_MoveOperation_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTextCursor_MoveOperation_Enum *from_i_QTextCursor_MoveOperation_Enum (unsigned int i)
{
  return new QTextCursor_MoveOperation_Enum ((QTextCursor::MoveOperation) i);
}

static bool equalQTextCursor_MoveOperation_Enum (const QTextCursor_MoveOperation_Enum *e, QTextCursor_MoveOperation_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTextCursor_MoveOperation_Enum (const QTextCursor_MoveOperation_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTextCursor_MoveOperation_Enums oropQTextCursor_MoveOperation_Enums (const QTextCursor_MoveOperation_Enums *e, const QTextCursor_MoveOperation_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTextCursor_MoveOperation_Enums andopQTextCursor_MoveOperation_Enums (const QTextCursor_MoveOperation_Enums *e, const QTextCursor_MoveOperation_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTextCursor_MoveOperation_Enums xoropQTextCursor_MoveOperation_Enums (const QTextCursor_MoveOperation_Enums *e, const QTextCursor_MoveOperation_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTextCursor_MoveOperation_Enums (const QTextCursor_MoveOperation_Enums *e)
{
  std::string l;
  if (e->testFlag (QTextCursor::NoMove)) { if (!l.empty ()) l += "|"; l += "NoMove"; }
  if (e->testFlag (QTextCursor::Start)) { if (!l.empty ()) l += "|"; l += "Start"; }
  if (e->testFlag (QTextCursor::Up)) { if (!l.empty ()) l += "|"; l += "Up"; }
  if (e->testFlag (QTextCursor::StartOfLine)) { if (!l.empty ()) l += "|"; l += "StartOfLine"; }
  if (e->testFlag (QTextCursor::StartOfBlock)) { if (!l.empty ()) l += "|"; l += "StartOfBlock"; }
  if (e->testFlag (QTextCursor::StartOfWord)) { if (!l.empty ()) l += "|"; l += "StartOfWord"; }
  if (e->testFlag (QTextCursor::PreviousBlock)) { if (!l.empty ()) l += "|"; l += "PreviousBlock"; }
  if (e->testFlag (QTextCursor::PreviousCharacter)) { if (!l.empty ()) l += "|"; l += "PreviousCharacter"; }
  if (e->testFlag (QTextCursor::PreviousWord)) { if (!l.empty ()) l += "|"; l += "PreviousWord"; }
  if (e->testFlag (QTextCursor::Left)) { if (!l.empty ()) l += "|"; l += "Left"; }
  if (e->testFlag (QTextCursor::WordLeft)) { if (!l.empty ()) l += "|"; l += "WordLeft"; }
  if (e->testFlag (QTextCursor::End)) { if (!l.empty ()) l += "|"; l += "End"; }
  if (e->testFlag (QTextCursor::Down)) { if (!l.empty ()) l += "|"; l += "Down"; }
  if (e->testFlag (QTextCursor::EndOfLine)) { if (!l.empty ()) l += "|"; l += "EndOfLine"; }
  if (e->testFlag (QTextCursor::EndOfWord)) { if (!l.empty ()) l += "|"; l += "EndOfWord"; }
  if (e->testFlag (QTextCursor::EndOfBlock)) { if (!l.empty ()) l += "|"; l += "EndOfBlock"; }
  if (e->testFlag (QTextCursor::NextBlock)) { if (!l.empty ()) l += "|"; l += "NextBlock"; }
  if (e->testFlag (QTextCursor::NextCharacter)) { if (!l.empty ()) l += "|"; l += "NextCharacter"; }
  if (e->testFlag (QTextCursor::NextWord)) { if (!l.empty ()) l += "|"; l += "NextWord"; }
  if (e->testFlag (QTextCursor::Right)) { if (!l.empty ()) l += "|"; l += "Right"; }
  if (e->testFlag (QTextCursor::WordRight)) { if (!l.empty ()) l += "|"; l += "WordRight"; }
  if (e->testFlag (QTextCursor::NextCell)) { if (!l.empty ()) l += "|"; l += "NextCell"; }
  if (e->testFlag (QTextCursor::PreviousCell)) { if (!l.empty ()) l += "|"; l += "PreviousCell"; }
  if (e->testFlag (QTextCursor::NextRow)) { if (!l.empty ()) l += "|"; l += "NextRow"; }
  if (e->testFlag (QTextCursor::PreviousRow)) { if (!l.empty ()) l += "|"; l += "PreviousRow"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTextCursor_MoveOperation_Enums (const QTextCursor_MoveOperation_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTextCursor_MoveOperation_Enums (const QTextCursor_MoveOperation_Enums *e, const QTextCursor_MoveOperation_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTextCursor_MoveOperation_Enums> decl_QTextCursor_MoveOperation_Enums ("QTextCursor_QFlags_MoveOperation",
  gsi::method_ext ("|", &qt_gsi::oropQTextCursor_MoveOperation_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTextCursor_MoveOperation_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTextCursor_MoveOperation_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextCursor_MoveOperation_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextCursor_MoveOperation_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTextCursor_MoveOperation_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTextCursor::MoveOperation> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTextCursor_MoveOperation_Enum> decl_QTextCursor_MoveOperation_Enum (decl_QTextCursor_MoveOperation_Enums, "QTextCursor_MoveOperation",
  qt_gsi::mkdefs_QTextCursor_MoveOperation () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextCursor_MoveOperation_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextCursor_MoveOperation_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTextCursor_MoveOperation_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTextCursor_MoveOperation_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTextCursor_MoveOperation_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTextCursor::MoveOperation enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextCursor> inject_QTextCursor_MoveOperation_Enum_in_parent (qt_gsi::mkdefs_QTextCursor_MoveOperation ());
static gsi::ClassExt<QTextCursor> decl_QTextCursor_MoveOperation_Enum_as_child (decl_QTextCursor_MoveOperation_Enum, "MoveOperation");

}


//  Implementation of the enum wrapper class for QTextCursor::SelectionType
namespace qt_gsi
{

static QTextCursor_SelectionType_Enum *c_1_QTextCursor_SelectionType_Enum () { return new QTextCursor_SelectionType_Enum (QTextCursor::WordUnderCursor); }
static QTextCursor_SelectionType_Enum *c_2_QTextCursor_SelectionType_Enum () { return new QTextCursor_SelectionType_Enum (QTextCursor::LineUnderCursor); }
static QTextCursor_SelectionType_Enum *c_3_QTextCursor_SelectionType_Enum () { return new QTextCursor_SelectionType_Enum (QTextCursor::BlockUnderCursor); }
static QTextCursor_SelectionType_Enum *c_4_QTextCursor_SelectionType_Enum () { return new QTextCursor_SelectionType_Enum (QTextCursor::Document); }

static gsi::Methods mkdefs_QTextCursor_SelectionType () {
  return
    gsi::constant ("WordUnderCursor", &qt_gsi::c_1_QTextCursor_SelectionType_Enum, "@brief Enum constant QTextCursor::WordUnderCursor") +
    gsi::constant ("LineUnderCursor", &qt_gsi::c_2_QTextCursor_SelectionType_Enum, "@brief Enum constant QTextCursor::LineUnderCursor") +
    gsi::constant ("BlockUnderCursor", &qt_gsi::c_3_QTextCursor_SelectionType_Enum, "@brief Enum constant QTextCursor::BlockUnderCursor") +
    gsi::constant ("Document", &qt_gsi::c_4_QTextCursor_SelectionType_Enum, "@brief Enum constant QTextCursor::Document");
}

static std::string to_s_QTextCursor_SelectionType_Enum (const QTextCursor_SelectionType_Enum *e)
{
  if (e->value () == QTextCursor::WordUnderCursor) { return tl::sprintf ("WordUnderCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::LineUnderCursor) { return tl::sprintf ("LineUnderCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::BlockUnderCursor) { return tl::sprintf ("BlockUnderCursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextCursor::Document) { return tl::sprintf ("Document (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTextCursor_SelectionType_Enum (const QTextCursor_SelectionType_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTextCursor_SelectionType_Enum *from_i_QTextCursor_SelectionType_Enum (unsigned int i)
{
  return new QTextCursor_SelectionType_Enum ((QTextCursor::SelectionType) i);
}

static bool equalQTextCursor_SelectionType_Enum (const QTextCursor_SelectionType_Enum *e, QTextCursor_SelectionType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTextCursor_SelectionType_Enum (const QTextCursor_SelectionType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTextCursor_SelectionType_Enums oropQTextCursor_SelectionType_Enums (const QTextCursor_SelectionType_Enums *e, const QTextCursor_SelectionType_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTextCursor_SelectionType_Enums andopQTextCursor_SelectionType_Enums (const QTextCursor_SelectionType_Enums *e, const QTextCursor_SelectionType_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTextCursor_SelectionType_Enums xoropQTextCursor_SelectionType_Enums (const QTextCursor_SelectionType_Enums *e, const QTextCursor_SelectionType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTextCursor_SelectionType_Enums (const QTextCursor_SelectionType_Enums *e)
{
  std::string l;
  if (e->testFlag (QTextCursor::WordUnderCursor)) { if (!l.empty ()) l += "|"; l += "WordUnderCursor"; }
  if (e->testFlag (QTextCursor::LineUnderCursor)) { if (!l.empty ()) l += "|"; l += "LineUnderCursor"; }
  if (e->testFlag (QTextCursor::BlockUnderCursor)) { if (!l.empty ()) l += "|"; l += "BlockUnderCursor"; }
  if (e->testFlag (QTextCursor::Document)) { if (!l.empty ()) l += "|"; l += "Document"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTextCursor_SelectionType_Enums (const QTextCursor_SelectionType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTextCursor_SelectionType_Enums (const QTextCursor_SelectionType_Enums *e, const QTextCursor_SelectionType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTextCursor_SelectionType_Enums> decl_QTextCursor_SelectionType_Enums ("QTextCursor_QFlags_SelectionType",
  gsi::method_ext ("|", &qt_gsi::oropQTextCursor_SelectionType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTextCursor_SelectionType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTextCursor_SelectionType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextCursor_SelectionType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextCursor_SelectionType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTextCursor_SelectionType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTextCursor::SelectionType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTextCursor_SelectionType_Enum> decl_QTextCursor_SelectionType_Enum (decl_QTextCursor_SelectionType_Enums, "QTextCursor_SelectionType",
  qt_gsi::mkdefs_QTextCursor_SelectionType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextCursor_SelectionType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextCursor_SelectionType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTextCursor_SelectionType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTextCursor_SelectionType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTextCursor_SelectionType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTextCursor::SelectionType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextCursor> inject_QTextCursor_SelectionType_Enum_in_parent (qt_gsi::mkdefs_QTextCursor_SelectionType ());
static gsi::ClassExt<QTextCursor> decl_QTextCursor_SelectionType_Enum_as_child (decl_QTextCursor_SelectionType_Enum, "SelectionType");

}

