
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSql.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtSql.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQSql_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// namespace QSql

class QSql_Namespace { };

namespace gsi
{
gsi::Class<QSql_Namespace> decl_QSql_Namespace ("QSql",
  gsi::Methods(),
  "@qt\n@brief This class represents the QSql namespace");
}


//  Implementation of the enum wrapper class for QSql::Location
namespace qt_gsi
{

static QSql_Location_Enum *c_1_QSql_Location_Enum () { return new QSql_Location_Enum (QSql::BeforeFirstRow); }
static QSql_Location_Enum *c_2_QSql_Location_Enum () { return new QSql_Location_Enum (QSql::AfterLastRow); }

static gsi::Methods mkdefs_QSql_Location () {
  return
    gsi::constant ("BeforeFirstRow", &qt_gsi::c_1_QSql_Location_Enum, "@brief Enum constant QSql::BeforeFirstRow") +
    gsi::constant ("AfterLastRow", &qt_gsi::c_2_QSql_Location_Enum, "@brief Enum constant QSql::AfterLastRow");
}

static std::string to_s_QSql_Location_Enum (const QSql_Location_Enum *e)
{
  if (e->value () == QSql::BeforeFirstRow) { return tl::sprintf ("BeforeFirstRow (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSql::AfterLastRow) { return tl::sprintf ("AfterLastRow (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSql_Location_Enum (const QSql_Location_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSql_Location_Enum *from_i_QSql_Location_Enum (unsigned int i)
{
  return new QSql_Location_Enum ((QSql::Location) i);
}

static bool equalQSql_Location_Enum (const QSql_Location_Enum *e, QSql_Location_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSql_Location_Enum (const QSql_Location_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSql_Location_Enums oropQSql_Location_Enums (const QSql_Location_Enums *e, const QSql_Location_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSql_Location_Enums andopQSql_Location_Enums (const QSql_Location_Enums *e, const QSql_Location_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSql_Location_Enums xoropQSql_Location_Enums (const QSql_Location_Enums *e, const QSql_Location_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSql_Location_Enums (const QSql_Location_Enums *e)
{
  std::string l;
  if (e->testFlag (QSql::BeforeFirstRow)) { if (!l.empty ()) l += "|"; l += "BeforeFirstRow"; }
  if (e->testFlag (QSql::AfterLastRow)) { if (!l.empty ()) l += "|"; l += "AfterLastRow"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSql_Location_Enums (const QSql_Location_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSql_Location_Enums (const QSql_Location_Enums *e, const QSql_Location_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSql_Location_Enums> decl_QSql_Location_Enums ("QSql_QFlags_Location",
  gsi::method_ext ("|", &qt_gsi::oropQSql_Location_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSql_Location_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSql_Location_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSql_Location_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSql_Location_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSql_Location_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSql::Location> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSql_Location_Enum> decl_QSql_Location_Enum (decl_QSql_Location_Enums, "QSql_Location",
  qt_gsi::mkdefs_QSql_Location () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSql_Location_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSql_Location_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSql_Location_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSql_Location_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSql_Location_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSql::Location enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSql_Namespace> inject_QSql_Location_Enum_in_parent (qt_gsi::mkdefs_QSql_Location ());
static gsi::ClassExt<QSql_Namespace> decl_QSql_Location_Enum_as_child (decl_QSql_Location_Enum, "Location");

}


//  Implementation of the enum wrapper class for QSql::NumericalPrecisionPolicy
namespace qt_gsi
{

static QSql_NumericalPrecisionPolicy_Enum *c_1_QSql_NumericalPrecisionPolicy_Enum () { return new QSql_NumericalPrecisionPolicy_Enum (QSql::LowPrecisionInt32); }
static QSql_NumericalPrecisionPolicy_Enum *c_2_QSql_NumericalPrecisionPolicy_Enum () { return new QSql_NumericalPrecisionPolicy_Enum (QSql::LowPrecisionInt64); }
static QSql_NumericalPrecisionPolicy_Enum *c_3_QSql_NumericalPrecisionPolicy_Enum () { return new QSql_NumericalPrecisionPolicy_Enum (QSql::LowPrecisionDouble); }
static QSql_NumericalPrecisionPolicy_Enum *c_4_QSql_NumericalPrecisionPolicy_Enum () { return new QSql_NumericalPrecisionPolicy_Enum (QSql::HighPrecision); }

static gsi::Methods mkdefs_QSql_NumericalPrecisionPolicy () {
  return
    gsi::constant ("LowPrecisionInt32", &qt_gsi::c_1_QSql_NumericalPrecisionPolicy_Enum, "@brief Enum constant QSql::LowPrecisionInt32") +
    gsi::constant ("LowPrecisionInt64", &qt_gsi::c_2_QSql_NumericalPrecisionPolicy_Enum, "@brief Enum constant QSql::LowPrecisionInt64") +
    gsi::constant ("LowPrecisionDouble", &qt_gsi::c_3_QSql_NumericalPrecisionPolicy_Enum, "@brief Enum constant QSql::LowPrecisionDouble") +
    gsi::constant ("HighPrecision", &qt_gsi::c_4_QSql_NumericalPrecisionPolicy_Enum, "@brief Enum constant QSql::HighPrecision");
}

static std::string to_s_QSql_NumericalPrecisionPolicy_Enum (const QSql_NumericalPrecisionPolicy_Enum *e)
{
  if (e->value () == QSql::LowPrecisionInt32) { return tl::sprintf ("LowPrecisionInt32 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSql::LowPrecisionInt64) { return tl::sprintf ("LowPrecisionInt64 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSql::LowPrecisionDouble) { return tl::sprintf ("LowPrecisionDouble (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSql::HighPrecision) { return tl::sprintf ("HighPrecision (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSql_NumericalPrecisionPolicy_Enum (const QSql_NumericalPrecisionPolicy_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSql_NumericalPrecisionPolicy_Enum *from_i_QSql_NumericalPrecisionPolicy_Enum (unsigned int i)
{
  return new QSql_NumericalPrecisionPolicy_Enum ((QSql::NumericalPrecisionPolicy) i);
}

static bool equalQSql_NumericalPrecisionPolicy_Enum (const QSql_NumericalPrecisionPolicy_Enum *e, QSql_NumericalPrecisionPolicy_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSql_NumericalPrecisionPolicy_Enum (const QSql_NumericalPrecisionPolicy_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSql_NumericalPrecisionPolicy_Enums oropQSql_NumericalPrecisionPolicy_Enums (const QSql_NumericalPrecisionPolicy_Enums *e, const QSql_NumericalPrecisionPolicy_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSql_NumericalPrecisionPolicy_Enums andopQSql_NumericalPrecisionPolicy_Enums (const QSql_NumericalPrecisionPolicy_Enums *e, const QSql_NumericalPrecisionPolicy_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSql_NumericalPrecisionPolicy_Enums xoropQSql_NumericalPrecisionPolicy_Enums (const QSql_NumericalPrecisionPolicy_Enums *e, const QSql_NumericalPrecisionPolicy_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSql_NumericalPrecisionPolicy_Enums (const QSql_NumericalPrecisionPolicy_Enums *e)
{
  std::string l;
  if (e->testFlag (QSql::LowPrecisionInt32)) { if (!l.empty ()) l += "|"; l += "LowPrecisionInt32"; }
  if (e->testFlag (QSql::LowPrecisionInt64)) { if (!l.empty ()) l += "|"; l += "LowPrecisionInt64"; }
  if (e->testFlag (QSql::LowPrecisionDouble)) { if (!l.empty ()) l += "|"; l += "LowPrecisionDouble"; }
  if (e->testFlag (QSql::HighPrecision)) { if (!l.empty ()) l += "|"; l += "HighPrecision"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSql_NumericalPrecisionPolicy_Enums (const QSql_NumericalPrecisionPolicy_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSql_NumericalPrecisionPolicy_Enums (const QSql_NumericalPrecisionPolicy_Enums *e, const QSql_NumericalPrecisionPolicy_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSql_NumericalPrecisionPolicy_Enums> decl_QSql_NumericalPrecisionPolicy_Enums ("QSql_QFlags_NumericalPrecisionPolicy",
  gsi::method_ext ("|", &qt_gsi::oropQSql_NumericalPrecisionPolicy_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSql_NumericalPrecisionPolicy_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSql_NumericalPrecisionPolicy_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSql_NumericalPrecisionPolicy_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSql_NumericalPrecisionPolicy_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSql_NumericalPrecisionPolicy_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSql::NumericalPrecisionPolicy> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSql_NumericalPrecisionPolicy_Enum> decl_QSql_NumericalPrecisionPolicy_Enum (decl_QSql_NumericalPrecisionPolicy_Enums, "QSql_NumericalPrecisionPolicy",
  qt_gsi::mkdefs_QSql_NumericalPrecisionPolicy () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSql_NumericalPrecisionPolicy_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSql_NumericalPrecisionPolicy_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSql_NumericalPrecisionPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSql_NumericalPrecisionPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSql_NumericalPrecisionPolicy_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSql::NumericalPrecisionPolicy enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSql_Namespace> inject_QSql_NumericalPrecisionPolicy_Enum_in_parent (qt_gsi::mkdefs_QSql_NumericalPrecisionPolicy ());
static gsi::ClassExt<QSql_Namespace> decl_QSql_NumericalPrecisionPolicy_Enum_as_child (decl_QSql_NumericalPrecisionPolicy_Enum, "NumericalPrecisionPolicy");

}


//  Implementation of the enum wrapper class for QSql::ParamTypeFlag
namespace qt_gsi
{

static QSql_ParamTypeFlag_Enum *c_1_QSql_ParamTypeFlag_Enum () { return new QSql_ParamTypeFlag_Enum (QSql::In); }
static QSql_ParamTypeFlag_Enum *c_2_QSql_ParamTypeFlag_Enum () { return new QSql_ParamTypeFlag_Enum (QSql::Out); }
static QSql_ParamTypeFlag_Enum *c_3_QSql_ParamTypeFlag_Enum () { return new QSql_ParamTypeFlag_Enum (QSql::InOut); }
static QSql_ParamTypeFlag_Enum *c_4_QSql_ParamTypeFlag_Enum () { return new QSql_ParamTypeFlag_Enum (QSql::Binary); }

static gsi::Methods mkdefs_QSql_ParamTypeFlag () {
  return
    gsi::constant ("In", &qt_gsi::c_1_QSql_ParamTypeFlag_Enum, "@brief Enum constant QSql::In") +
    gsi::constant ("Out", &qt_gsi::c_2_QSql_ParamTypeFlag_Enum, "@brief Enum constant QSql::Out") +
    gsi::constant ("InOut", &qt_gsi::c_3_QSql_ParamTypeFlag_Enum, "@brief Enum constant QSql::InOut") +
    gsi::constant ("Binary", &qt_gsi::c_4_QSql_ParamTypeFlag_Enum, "@brief Enum constant QSql::Binary");
}

static std::string to_s_QSql_ParamTypeFlag_Enum (const QSql_ParamTypeFlag_Enum *e)
{
  if (e->value () == QSql::In) { return tl::sprintf ("In (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSql::Out) { return tl::sprintf ("Out (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSql::InOut) { return tl::sprintf ("InOut (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSql::Binary) { return tl::sprintf ("Binary (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSql_ParamTypeFlag_Enum (const QSql_ParamTypeFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSql_ParamTypeFlag_Enum *from_i_QSql_ParamTypeFlag_Enum (unsigned int i)
{
  return new QSql_ParamTypeFlag_Enum ((QSql::ParamTypeFlag) i);
}

static bool equalQSql_ParamTypeFlag_Enum (const QSql_ParamTypeFlag_Enum *e, QSql_ParamTypeFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSql_ParamTypeFlag_Enum (const QSql_ParamTypeFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSql_ParamTypeFlag_Enums oropQSql_ParamTypeFlag_Enums (const QSql_ParamTypeFlag_Enums *e, const QSql_ParamTypeFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSql_ParamTypeFlag_Enums andopQSql_ParamTypeFlag_Enums (const QSql_ParamTypeFlag_Enums *e, const QSql_ParamTypeFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSql_ParamTypeFlag_Enums xoropQSql_ParamTypeFlag_Enums (const QSql_ParamTypeFlag_Enums *e, const QSql_ParamTypeFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSql_ParamTypeFlag_Enums (const QSql_ParamTypeFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (QSql::In)) { if (!l.empty ()) l += "|"; l += "In"; }
  if (e->testFlag (QSql::Out)) { if (!l.empty ()) l += "|"; l += "Out"; }
  if (e->testFlag (QSql::InOut)) { if (!l.empty ()) l += "|"; l += "InOut"; }
  if (e->testFlag (QSql::Binary)) { if (!l.empty ()) l += "|"; l += "Binary"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSql_ParamTypeFlag_Enums (const QSql_ParamTypeFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSql_ParamTypeFlag_Enums (const QSql_ParamTypeFlag_Enums *e, const QSql_ParamTypeFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSql_ParamTypeFlag_Enums> decl_QSql_ParamTypeFlag_Enums ("QSql_QFlags_ParamTypeFlag",
  gsi::method_ext ("|", &qt_gsi::oropQSql_ParamTypeFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSql_ParamTypeFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSql_ParamTypeFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSql_ParamTypeFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSql_ParamTypeFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSql_ParamTypeFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSql::ParamTypeFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSql_ParamTypeFlag_Enum> decl_QSql_ParamTypeFlag_Enum (decl_QSql_ParamTypeFlag_Enums, "QSql_ParamTypeFlag",
  qt_gsi::mkdefs_QSql_ParamTypeFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSql_ParamTypeFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSql_ParamTypeFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSql_ParamTypeFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSql_ParamTypeFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSql_ParamTypeFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSql::ParamTypeFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSql_Namespace> inject_QSql_ParamTypeFlag_Enum_in_parent (qt_gsi::mkdefs_QSql_ParamTypeFlag ());
static gsi::ClassExt<QSql_Namespace> decl_QSql_ParamTypeFlag_Enum_as_child (decl_QSql_ParamTypeFlag_Enum, "ParamTypeFlag");

}


//  Implementation of the enum wrapper class for QSql::TableType
namespace qt_gsi
{

static QSql_TableType_Enum *c_1_QSql_TableType_Enum () { return new QSql_TableType_Enum (QSql::Tables); }
static QSql_TableType_Enum *c_2_QSql_TableType_Enum () { return new QSql_TableType_Enum (QSql::SystemTables); }
static QSql_TableType_Enum *c_3_QSql_TableType_Enum () { return new QSql_TableType_Enum (QSql::Views); }
static QSql_TableType_Enum *c_4_QSql_TableType_Enum () { return new QSql_TableType_Enum (QSql::AllTables); }

static gsi::Methods mkdefs_QSql_TableType () {
  return
    gsi::constant ("Tables", &qt_gsi::c_1_QSql_TableType_Enum, "@brief Enum constant QSql::Tables") +
    gsi::constant ("SystemTables", &qt_gsi::c_2_QSql_TableType_Enum, "@brief Enum constant QSql::SystemTables") +
    gsi::constant ("Views", &qt_gsi::c_3_QSql_TableType_Enum, "@brief Enum constant QSql::Views") +
    gsi::constant ("AllTables", &qt_gsi::c_4_QSql_TableType_Enum, "@brief Enum constant QSql::AllTables");
}

static std::string to_s_QSql_TableType_Enum (const QSql_TableType_Enum *e)
{
  if (e->value () == QSql::Tables) { return tl::sprintf ("Tables (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSql::SystemTables) { return tl::sprintf ("SystemTables (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSql::Views) { return tl::sprintf ("Views (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSql::AllTables) { return tl::sprintf ("AllTables (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSql_TableType_Enum (const QSql_TableType_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSql_TableType_Enum *from_i_QSql_TableType_Enum (unsigned int i)
{
  return new QSql_TableType_Enum ((QSql::TableType) i);
}

static bool equalQSql_TableType_Enum (const QSql_TableType_Enum *e, QSql_TableType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSql_TableType_Enum (const QSql_TableType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSql_TableType_Enums oropQSql_TableType_Enums (const QSql_TableType_Enums *e, const QSql_TableType_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSql_TableType_Enums andopQSql_TableType_Enums (const QSql_TableType_Enums *e, const QSql_TableType_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSql_TableType_Enums xoropQSql_TableType_Enums (const QSql_TableType_Enums *e, const QSql_TableType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSql_TableType_Enums (const QSql_TableType_Enums *e)
{
  std::string l;
  if (e->testFlag (QSql::Tables)) { if (!l.empty ()) l += "|"; l += "Tables"; }
  if (e->testFlag (QSql::SystemTables)) { if (!l.empty ()) l += "|"; l += "SystemTables"; }
  if (e->testFlag (QSql::Views)) { if (!l.empty ()) l += "|"; l += "Views"; }
  if (e->testFlag (QSql::AllTables)) { if (!l.empty ()) l += "|"; l += "AllTables"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSql_TableType_Enums (const QSql_TableType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSql_TableType_Enums (const QSql_TableType_Enums *e, const QSql_TableType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSql_TableType_Enums> decl_QSql_TableType_Enums ("QSql_QFlags_TableType",
  gsi::method_ext ("|", &qt_gsi::oropQSql_TableType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSql_TableType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSql_TableType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSql_TableType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSql_TableType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSql_TableType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSql::TableType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSql_TableType_Enum> decl_QSql_TableType_Enum (decl_QSql_TableType_Enums, "QSql_TableType",
  qt_gsi::mkdefs_QSql_TableType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSql_TableType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSql_TableType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSql_TableType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSql_TableType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSql_TableType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSql::TableType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSql_Namespace> inject_QSql_TableType_Enum_in_parent (qt_gsi::mkdefs_QSql_TableType ());
static gsi::ClassExt<QSql_Namespace> decl_QSql_TableType_Enum_as_child (decl_QSql_TableType_Enum, "TableType");

}

