
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQNetworkAccessManager.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtNetwork.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQNetworkAccessManager_EventAdaptor.h"
#include "gsiDeclQNetworkAccessManager_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QNetworkAccessManager

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QNetworkAccessManager::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QAbstractNetworkCache *QNetworkAccessManager::cache()


static void _init_f_cache_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractNetworkCache * > ();
}

static void _call_f_cache_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QAbstractNetworkCache * > ((QAbstractNetworkCache *)((QNetworkAccessManager *)cls)->cache ());
}

static qt_gsi::GenericMethod *_create_f_cache_c0 ()
{
  return new qt_gsi::GenericMethod (":cache", "@brief Method QAbstractNetworkCache *QNetworkAccessManager::cache()\n", true, &_init_f_cache_c0, &_call_f_cache_c0);
}

// QNetworkCookieJar *QNetworkAccessManager::cookieJar()


static void _init_f_cookieJar_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QNetworkCookieJar * > ();
}

static void _call_f_cookieJar_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QNetworkCookieJar * > ((QNetworkCookieJar *)((QNetworkAccessManager *)cls)->cookieJar ());
}

static qt_gsi::GenericMethod *_create_f_cookieJar_c0 ()
{
  return new qt_gsi::GenericMethod (":cookieJar", "@brief Method QNetworkCookieJar *QNetworkAccessManager::cookieJar()\n", true, &_init_f_cookieJar_c0, &_call_f_cookieJar_c0);
}

// QNetworkReply *QNetworkAccessManager::deleteResource(const QNetworkRequest &request)


static void _init_f_deleteResource_2885 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  decl->set_return<QNetworkReply * > ();
}

static void _call_f_deleteResource_2885 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QNetworkRequest &arg1 = args.read<const QNetworkRequest & > ();
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager *)cls)->deleteResource (arg1));
}

static qt_gsi::GenericMethod *_create_f_deleteResource_2885 ()
{
  return new qt_gsi::GenericMethod ("deleteResource", "@brief Method QNetworkReply *QNetworkAccessManager::deleteResource(const QNetworkRequest &request)\n", false, &_init_f_deleteResource_2885, &_call_f_deleteResource_2885);
}

// QNetworkReply *QNetworkAccessManager::get(const QNetworkRequest &request)


static void _init_f_get_2885 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  decl->set_return<QNetworkReply * > ();
}

static void _call_f_get_2885 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QNetworkRequest &arg1 = args.read<const QNetworkRequest & > ();
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager *)cls)->get (arg1));
}

static qt_gsi::GenericMethod *_create_f_get_2885 ()
{
  return new qt_gsi::GenericMethod ("get", "@brief Method QNetworkReply *QNetworkAccessManager::get(const QNetworkRequest &request)\n", false, &_init_f_get_2885, &_call_f_get_2885);
}

// QNetworkReply *QNetworkAccessManager::head(const QNetworkRequest &request)


static void _init_f_head_2885 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  decl->set_return<QNetworkReply * > ();
}

static void _call_f_head_2885 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QNetworkRequest &arg1 = args.read<const QNetworkRequest & > ();
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager *)cls)->head (arg1));
}

static qt_gsi::GenericMethod *_create_f_head_2885 ()
{
  return new qt_gsi::GenericMethod ("head", "@brief Method QNetworkReply *QNetworkAccessManager::head(const QNetworkRequest &request)\n", false, &_init_f_head_2885, &_call_f_head_2885);
}

// QNetworkReply *QNetworkAccessManager::post(const QNetworkRequest &request, QIODevice *data)


static void _init_f_post_4224 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("data");
  decl->add_arg<QIODevice * > (argspec_1);
  decl->set_return<QNetworkReply * > ();
}

static void _call_f_post_4224 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QNetworkRequest &arg1 = args.read<const QNetworkRequest & > ();
  QIODevice *arg2 = args.read<QIODevice * > ();
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager *)cls)->post (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_post_4224 ()
{
  return new qt_gsi::GenericMethod ("post", "@brief Method QNetworkReply *QNetworkAccessManager::post(const QNetworkRequest &request, QIODevice *data)\n", false, &_init_f_post_4224, &_call_f_post_4224);
}

// QNetworkReply *QNetworkAccessManager::post(const QNetworkRequest &request, const QByteArray &data)


static void _init_f_post_5086 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("data");
  decl->add_arg<const QByteArray & > (argspec_1);
  decl->set_return<QNetworkReply * > ();
}

static void _call_f_post_5086 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QNetworkRequest &arg1 = args.read<const QNetworkRequest & > ();
  const QByteArray &arg2 = args.read<const QByteArray & > ();
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager *)cls)->post (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_post_5086 ()
{
  return new qt_gsi::GenericMethod ("post", "@brief Method QNetworkReply *QNetworkAccessManager::post(const QNetworkRequest &request, const QByteArray &data)\n", false, &_init_f_post_5086, &_call_f_post_5086);
}

// QNetworkProxy QNetworkAccessManager::proxy()


static void _init_f_proxy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QNetworkProxy > ();
}

static void _call_f_proxy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QNetworkProxy > ((QNetworkProxy)((QNetworkAccessManager *)cls)->proxy ());
}

static qt_gsi::GenericMethod *_create_f_proxy_c0 ()
{
  return new qt_gsi::GenericMethod (":proxy", "@brief Method QNetworkProxy QNetworkAccessManager::proxy()\n", true, &_init_f_proxy_c0, &_call_f_proxy_c0);
}

// QNetworkProxyFactory *QNetworkAccessManager::proxyFactory()


static void _init_f_proxyFactory_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QNetworkProxyFactory * > ();
}

static void _call_f_proxyFactory_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QNetworkProxyFactory * > ((QNetworkProxyFactory *)((QNetworkAccessManager *)cls)->proxyFactory ());
}

static qt_gsi::GenericMethod *_create_f_proxyFactory_c0 ()
{
  return new qt_gsi::GenericMethod (":proxyFactory", "@brief Method QNetworkProxyFactory *QNetworkAccessManager::proxyFactory()\n", true, &_init_f_proxyFactory_c0, &_call_f_proxyFactory_c0);
}

// QNetworkReply *QNetworkAccessManager::put(const QNetworkRequest &request, QIODevice *data)


static void _init_f_put_4224 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("data");
  decl->add_arg<QIODevice * > (argspec_1);
  decl->set_return<QNetworkReply * > ();
}

static void _call_f_put_4224 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QNetworkRequest &arg1 = args.read<const QNetworkRequest & > ();
  QIODevice *arg2 = args.read<QIODevice * > ();
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager *)cls)->put (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_put_4224 ()
{
  return new qt_gsi::GenericMethod ("put", "@brief Method QNetworkReply *QNetworkAccessManager::put(const QNetworkRequest &request, QIODevice *data)\n", false, &_init_f_put_4224, &_call_f_put_4224);
}

// QNetworkReply *QNetworkAccessManager::put(const QNetworkRequest &request, const QByteArray &data)


static void _init_f_put_5086 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("data");
  decl->add_arg<const QByteArray & > (argspec_1);
  decl->set_return<QNetworkReply * > ();
}

static void _call_f_put_5086 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QNetworkRequest &arg1 = args.read<const QNetworkRequest & > ();
  const QByteArray &arg2 = args.read<const QByteArray & > ();
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager *)cls)->put (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_put_5086 ()
{
  return new qt_gsi::GenericMethod ("put", "@brief Method QNetworkReply *QNetworkAccessManager::put(const QNetworkRequest &request, const QByteArray &data)\n", false, &_init_f_put_5086, &_call_f_put_5086);
}

// void QNetworkAccessManager::setCache(QAbstractNetworkCache *cache)


static void _init_f_setCache_2737 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cache");
  decl->add_arg<QAbstractNetworkCache * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCache_2737 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractNetworkCache *arg1 = args.read<QAbstractNetworkCache * > ();
  ((QNetworkAccessManager *)cls)->setCache (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCache_2737 ()
{
  return new qt_gsi::GenericMethod ("setCache|cache=", "@brief Method void QNetworkAccessManager::setCache(QAbstractNetworkCache *cache)\n", false, &_init_f_setCache_2737, &_call_f_setCache_2737);
}

// void QNetworkAccessManager::setCookieJar(QNetworkCookieJar *cookieJar)


static void _init_f_setCookieJar_2336 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cookieJar");
  decl->add_arg<QNetworkCookieJar * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCookieJar_2336 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QNetworkCookieJar *arg1 = args.read<QNetworkCookieJar * > ();
  ((QNetworkAccessManager *)cls)->setCookieJar (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCookieJar_2336 ()
{
  return new qt_gsi::GenericMethod ("setCookieJar|cookieJar=", "@brief Method void QNetworkAccessManager::setCookieJar(QNetworkCookieJar *cookieJar)\n", false, &_init_f_setCookieJar_2336, &_call_f_setCookieJar_2336);
}

// void QNetworkAccessManager::setProxy(const QNetworkProxy &proxy)


static void _init_f_setProxy_2686 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("proxy");
  decl->add_arg<const QNetworkProxy & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProxy_2686 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QNetworkProxy &arg1 = args.read<const QNetworkProxy & > ();
  ((QNetworkAccessManager *)cls)->setProxy (arg1);
}

static qt_gsi::GenericMethod *_create_f_setProxy_2686 ()
{
  return new qt_gsi::GenericMethod ("setProxy|proxy=", "@brief Method void QNetworkAccessManager::setProxy(const QNetworkProxy &proxy)\n", false, &_init_f_setProxy_2686, &_call_f_setProxy_2686);
}

// void QNetworkAccessManager::setProxyFactory(QNetworkProxyFactory *factory)


static void _init_f_setProxyFactory_2723 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("factory");
  decl->add_arg<QNetworkProxyFactory * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProxyFactory_2723 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QNetworkProxyFactory *arg1 = args.read<QNetworkProxyFactory * > ();
  ((QNetworkAccessManager *)cls)->setProxyFactory (arg1);
}

static qt_gsi::GenericMethod *_create_f_setProxyFactory_2723 ()
{
  return new qt_gsi::GenericMethod ("setProxyFactory|proxyFactory=", "@brief Method void QNetworkAccessManager::setProxyFactory(QNetworkProxyFactory *factory)\n", false, &_init_f_setProxyFactory_2723, &_call_f_setProxyFactory_2723);
}

// static QString QNetworkAccessManager::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QNetworkAccessManager::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QNetworkAccessManager::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QNetworkAccessManager::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QNetworkAccessManager::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QNetworkAccessManager::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QNetworkAccessManager::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QNetworkAccessManager::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QNetworkAccessManager::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QNetworkAccessManager::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QNetworkAccessManager::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QNetworkAccessManager::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QNetworkAccessManager, QNetworkAccessManager_EventAdaptor> ea_QNetworkAccessManager;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QNetworkAccessManager> decl_QNetworkAccessManager (ea_QNetworkAccessManager, decl_QObject, "QNetworkAccessManager_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_cache_c0 ()) +
  gsi::Methods(_create_f_cookieJar_c0 ()) +
  gsi::Methods(_create_f_deleteResource_2885 ()) +
  gsi::Methods(_create_f_get_2885 ()) +
  gsi::Methods(_create_f_head_2885 ()) +
  gsi::Methods(_create_f_post_4224 ()) +
  gsi::Methods(_create_f_post_5086 ()) +
  gsi::Methods(_create_f_proxy_c0 ()) +
  gsi::Methods(_create_f_proxyFactory_c0 ()) +
  gsi::Methods(_create_f_put_4224 ()) +
  gsi::Methods(_create_f_put_5086 ()) +
  gsi::Methods(_create_f_setCache_2737 ()) +
  gsi::Methods(_create_f_setCookieJar_2336 ()) +
  gsi::Methods(_create_f_setProxy_2686 ()) +
  gsi::Methods(_create_f_setProxyFactory_2723 ()) +
  qt_gsi::qt_signal<QNetworkAccessManager, QNetworkAccessManager_EventAdaptor, QNetworkReply *, QAuthenticator *> ("authenticationRequired", &QNetworkAccessManager_EventAdaptor::authenticationRequired_e_3939, gsi::arg("reply"), gsi::arg("authenticator"), "@brief Signal declaration for QNetworkAccessManager::authenticationRequired(QNetworkReply *reply, QAuthenticator *authenticator)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QNetworkAccessManager, QNetworkAccessManager_EventAdaptor, QObject *> ("destroyed", &QNetworkAccessManager_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QNetworkAccessManager::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QNetworkAccessManager, QNetworkAccessManager_EventAdaptor, QNetworkReply *> ("finished", &QNetworkAccessManager_EventAdaptor::finished_e_1973, gsi::arg("reply"), "@brief Signal declaration for QNetworkAccessManager::finished(QNetworkReply *reply)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QNetworkAccessManager, QNetworkAccessManager_EventAdaptor, const QNetworkProxy &, QAuthenticator *> ("proxyAuthenticationRequired", &QNetworkAccessManager_EventAdaptor::proxyAuthenticationRequired_e_4652, gsi::arg("proxy"), gsi::arg("authenticator"), "@brief Signal declaration for QNetworkAccessManager::proxyAuthenticationRequired(const QNetworkProxy &proxy, QAuthenticator *authenticator)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QNetworkAccessManager, QNetworkAccessManager_EventAdaptor, QNetworkReply *, const qt_gsi::Converter<QList<QSslError> >::target_type &> ("sslErrors", &QNetworkAccessManager_EventAdaptor::sslErrors_e_4702, gsi::arg("reply"), gsi::arg("errors"), "@brief Signal declaration for QNetworkAccessManager::sslErrors(QNetworkReply *reply, const QList<QSslError> &errors)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QNetworkAccessManager");
}


class QNetworkAccessManager_Adaptor : public QNetworkAccessManager, public qt_gsi::QtObjectBase
{
public:

  virtual ~QNetworkAccessManager_Adaptor();

  //  [adaptor ctor] QNetworkAccessManager::QNetworkAccessManager(QObject *parent)
  QNetworkAccessManager_Adaptor() : QNetworkAccessManager()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QNetworkAccessManager::QNetworkAccessManager(QObject *parent)
  QNetworkAccessManager_Adaptor(QObject *parent) : QNetworkAccessManager(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QNetworkAccessManager::receivers(const char *signal)
  int fp_QNetworkAccessManager_receivers_c1731 (const char *signal) const {
    return QNetworkAccessManager::receivers(signal);
  }

  //  QObject *QNetworkAccessManager::sender()
  QObject * fp_QNetworkAccessManager_sender_c0 () const {
    return QNetworkAccessManager::sender();
  }

  //  [adaptor impl] bool QNetworkAccessManager::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QNetworkAccessManager::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QNetworkAccessManager_Adaptor, bool, QEvent *>(&QNetworkAccessManager_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QNetworkAccessManager::event(arg1);
    }
  }

  //  [adaptor impl] bool QNetworkAccessManager::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QNetworkAccessManager::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QNetworkAccessManager_Adaptor, bool, QObject *, QEvent *>(&QNetworkAccessManager_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QNetworkAccessManager::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QNetworkAccessManager::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QNetworkAccessManager::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QNetworkAccessManager_Adaptor, QChildEvent *>(&QNetworkAccessManager_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QNetworkAccessManager::childEvent(arg1);
    }
  }

  //  [adaptor impl] QNetworkReply *QNetworkAccessManager::createRequest(QNetworkAccessManager::Operation op, const QNetworkRequest &request, QIODevice *outgoingData)
  QNetworkReply * cbs_createRequest_7733_1(const qt_gsi::Converter<QNetworkAccessManager::Operation>::target_type & op, const QNetworkRequest &request, QIODevice *outgoingData)
  {
    return QNetworkAccessManager::createRequest(qt_gsi::QtToCppAdaptor<QNetworkAccessManager::Operation>(op).cref(), request, outgoingData);
  }

  virtual QNetworkReply * createRequest(QNetworkAccessManager::Operation op, const QNetworkRequest &request, QIODevice *outgoingData)
  {
    if (cb_createRequest_7733_1.can_issue()) {
      return cb_createRequest_7733_1.issue<QNetworkAccessManager_Adaptor, QNetworkReply *, const qt_gsi::Converter<QNetworkAccessManager::Operation>::target_type &, const QNetworkRequest &, QIODevice *>(&QNetworkAccessManager_Adaptor::cbs_createRequest_7733_1, qt_gsi::CppToQtAdaptor<QNetworkAccessManager::Operation>(op), request, outgoingData);
    } else {
      return QNetworkAccessManager::createRequest(op, request, outgoingData);
    }
  }

  //  [adaptor impl] void QNetworkAccessManager::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QNetworkAccessManager::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QNetworkAccessManager_Adaptor, QEvent *>(&QNetworkAccessManager_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QNetworkAccessManager::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QNetworkAccessManager::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QNetworkAccessManager::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QNetworkAccessManager_Adaptor, const char *>(&QNetworkAccessManager_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QNetworkAccessManager::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QNetworkAccessManager::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QNetworkAccessManager::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QNetworkAccessManager_Adaptor, QTimerEvent *>(&QNetworkAccessManager_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QNetworkAccessManager::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_createRequest_7733_1;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QNetworkAccessManager_Adaptor::~QNetworkAccessManager_Adaptor() { }

//  Constructor QNetworkAccessManager::QNetworkAccessManager(QObject *parent) (adaptor class)

static void _init_ctor_QNetworkAccessManager_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QNetworkAccessManager_Adaptor *> ();
}

static void _call_ctor_QNetworkAccessManager_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QNetworkAccessManager_Adaptor *> (new QNetworkAccessManager_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QNetworkAccessManager_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QNetworkAccessManager::QNetworkAccessManager(QObject *parent)\nThis method creates an object of class QNetworkAccessManager.", &_init_ctor_QNetworkAccessManager_Adaptor_1302, &_call_ctor_QNetworkAccessManager_Adaptor_1302);
}

// int QNetworkAccessManager::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QNetworkAccessManager_Adaptor *)cls)->fp_QNetworkAccessManager_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QNetworkAccessManager::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QNetworkAccessManager::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QNetworkAccessManager_Adaptor *)cls)->fp_QNetworkAccessManager_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QNetworkAccessManager::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QNetworkAccessManager::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QNetworkAccessManager_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkAccessManager_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QNetworkAccessManager::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QNetworkAccessManager::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QNetworkAccessManager_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkAccessManager_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QNetworkAccessManager::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QNetworkAccessManager::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QNetworkAccessManager_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkAccessManager_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QNetworkAccessManager::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// QNetworkReply *QNetworkAccessManager::createRequest(QNetworkAccessManager::Operation op, const QNetworkRequest &request, QIODevice *outgoingData)

static void _init_cbs_createRequest_7733_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("op");
  decl->add_arg<const qt_gsi::Converter<QNetworkAccessManager::Operation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("request");
  decl->add_arg<const QNetworkRequest & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("outgoingData");
  decl->add_arg<QIODevice * > (argspec_2);
  decl->set_return<QNetworkReply * > ();
}

static void _call_cbs_createRequest_7733_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QNetworkAccessManager::Operation>::target_type & arg1 = args.read<const qt_gsi::Converter<QNetworkAccessManager::Operation>::target_type & > ();
  const QNetworkRequest &arg2 = args.read<const QNetworkRequest & > ();
  QIODevice *arg3 = args.read<QIODevice * > ();
  ret.write<QNetworkReply * > ((QNetworkReply *)((QNetworkAccessManager_Adaptor *)cls)->cbs_createRequest_7733_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_createRequest_7733_1 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkAccessManager_Adaptor *)cls)->cb_createRequest_7733_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_createRequest_7733_1 ()
{
  return new qt_gsi::GenericMethod ("*createRequest", "@hide", false, &_init_cbs_createRequest_7733_1, &_call_cbs_createRequest_7733_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_createRequest_7733_1 ()
{
  return new qt_gsi::GenericMethod ("*createRequest", "@brief Virtual method QNetworkReply *QNetworkAccessManager::createRequest(QNetworkAccessManager::Operation op, const QNetworkRequest &request, QIODevice *outgoingData)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_createRequest_7733_1, &_call_cbs_createRequest_7733_1, &_set_callback_cbs_createRequest_7733_1);
}


// void QNetworkAccessManager::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QNetworkAccessManager_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkAccessManager_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QNetworkAccessManager::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QNetworkAccessManager::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QNetworkAccessManager_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkAccessManager_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QNetworkAccessManager::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QNetworkAccessManager::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QNetworkAccessManager_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QNetworkAccessManager_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QNetworkAccessManager::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QNetworkAccessManager> decl_QNetworkAccessManager;

gsi::Class<QNetworkAccessManager_Adaptor> decl_QNetworkAccessManager_Adaptor (decl_QNetworkAccessManager, "QNetworkAccessManager",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_createRequest_7733_1 ()) +
  gsi::Methods(_create_callback_cbs_createRequest_7733_1 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QNetworkAccessManager_Adaptor_1302 ()),
  "@qt\n@brief Binding of QNetworkAccessManager");

}


//  Implementation of the enum wrapper class for QNetworkAccessManager::Operation
namespace qt_gsi
{

static QNetworkAccessManager_Operation_Enum *c_1_QNetworkAccessManager_Operation_Enum () { return new QNetworkAccessManager_Operation_Enum (QNetworkAccessManager::HeadOperation); }
static QNetworkAccessManager_Operation_Enum *c_2_QNetworkAccessManager_Operation_Enum () { return new QNetworkAccessManager_Operation_Enum (QNetworkAccessManager::GetOperation); }
static QNetworkAccessManager_Operation_Enum *c_3_QNetworkAccessManager_Operation_Enum () { return new QNetworkAccessManager_Operation_Enum (QNetworkAccessManager::PutOperation); }
static QNetworkAccessManager_Operation_Enum *c_4_QNetworkAccessManager_Operation_Enum () { return new QNetworkAccessManager_Operation_Enum (QNetworkAccessManager::PostOperation); }
static QNetworkAccessManager_Operation_Enum *c_5_QNetworkAccessManager_Operation_Enum () { return new QNetworkAccessManager_Operation_Enum (QNetworkAccessManager::DeleteOperation); }
static QNetworkAccessManager_Operation_Enum *c_6_QNetworkAccessManager_Operation_Enum () { return new QNetworkAccessManager_Operation_Enum (QNetworkAccessManager::UnknownOperation); }

static gsi::Methods mkdefs_QNetworkAccessManager_Operation () {
  return
    gsi::constant ("HeadOperation", &qt_gsi::c_1_QNetworkAccessManager_Operation_Enum, "@brief Enum constant QNetworkAccessManager::HeadOperation") +
    gsi::constant ("GetOperation", &qt_gsi::c_2_QNetworkAccessManager_Operation_Enum, "@brief Enum constant QNetworkAccessManager::GetOperation") +
    gsi::constant ("PutOperation", &qt_gsi::c_3_QNetworkAccessManager_Operation_Enum, "@brief Enum constant QNetworkAccessManager::PutOperation") +
    gsi::constant ("PostOperation", &qt_gsi::c_4_QNetworkAccessManager_Operation_Enum, "@brief Enum constant QNetworkAccessManager::PostOperation") +
    gsi::constant ("DeleteOperation", &qt_gsi::c_5_QNetworkAccessManager_Operation_Enum, "@brief Enum constant QNetworkAccessManager::DeleteOperation") +
    gsi::constant ("UnknownOperation", &qt_gsi::c_6_QNetworkAccessManager_Operation_Enum, "@brief Enum constant QNetworkAccessManager::UnknownOperation");
}

static std::string to_s_QNetworkAccessManager_Operation_Enum (const QNetworkAccessManager_Operation_Enum *e)
{
  if (e->value () == QNetworkAccessManager::HeadOperation) { return tl::sprintf ("HeadOperation (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkAccessManager::GetOperation) { return tl::sprintf ("GetOperation (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkAccessManager::PutOperation) { return tl::sprintf ("PutOperation (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkAccessManager::PostOperation) { return tl::sprintf ("PostOperation (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkAccessManager::DeleteOperation) { return tl::sprintf ("DeleteOperation (%u)", (unsigned int) e->value ()); }
  if (e->value () == QNetworkAccessManager::UnknownOperation) { return tl::sprintf ("UnknownOperation (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QNetworkAccessManager_Operation_Enum (const QNetworkAccessManager_Operation_Enum *e)
{
  return (unsigned int) e->value ();
}

static QNetworkAccessManager_Operation_Enum *from_i_QNetworkAccessManager_Operation_Enum (unsigned int i)
{
  return new QNetworkAccessManager_Operation_Enum ((QNetworkAccessManager::Operation) i);
}

static bool equalQNetworkAccessManager_Operation_Enum (const QNetworkAccessManager_Operation_Enum *e, QNetworkAccessManager_Operation_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QNetworkAccessManager_Operation_Enum (const QNetworkAccessManager_Operation_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QNetworkAccessManager_Operation_Enums oropQNetworkAccessManager_Operation_Enums (const QNetworkAccessManager_Operation_Enums *e, const QNetworkAccessManager_Operation_Enums &d)
{
  return e->flags () | d.flags ();
}

static QNetworkAccessManager_Operation_Enums andopQNetworkAccessManager_Operation_Enums (const QNetworkAccessManager_Operation_Enums *e, const QNetworkAccessManager_Operation_Enums &d)
{
  return e->flags () & d.flags ();
}

static QNetworkAccessManager_Operation_Enums xoropQNetworkAccessManager_Operation_Enums (const QNetworkAccessManager_Operation_Enums *e, const QNetworkAccessManager_Operation_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QNetworkAccessManager_Operation_Enums (const QNetworkAccessManager_Operation_Enums *e)
{
  std::string l;
  if (e->testFlag (QNetworkAccessManager::HeadOperation)) { if (!l.empty ()) l += "|"; l += "HeadOperation"; }
  if (e->testFlag (QNetworkAccessManager::GetOperation)) { if (!l.empty ()) l += "|"; l += "GetOperation"; }
  if (e->testFlag (QNetworkAccessManager::PutOperation)) { if (!l.empty ()) l += "|"; l += "PutOperation"; }
  if (e->testFlag (QNetworkAccessManager::PostOperation)) { if (!l.empty ()) l += "|"; l += "PostOperation"; }
  if (e->testFlag (QNetworkAccessManager::DeleteOperation)) { if (!l.empty ()) l += "|"; l += "DeleteOperation"; }
  if (e->testFlag (QNetworkAccessManager::UnknownOperation)) { if (!l.empty ()) l += "|"; l += "UnknownOperation"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QNetworkAccessManager_Operation_Enums (const QNetworkAccessManager_Operation_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QNetworkAccessManager_Operation_Enums (const QNetworkAccessManager_Operation_Enums *e, const QNetworkAccessManager_Operation_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QNetworkAccessManager_Operation_Enums> decl_QNetworkAccessManager_Operation_Enums ("QNetworkAccessManager_QFlags_Operation",
  gsi::method_ext ("|", &qt_gsi::oropQNetworkAccessManager_Operation_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQNetworkAccessManager_Operation_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQNetworkAccessManager_Operation_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QNetworkAccessManager_Operation_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QNetworkAccessManager_Operation_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QNetworkAccessManager_Operation_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QNetworkAccessManager::Operation> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QNetworkAccessManager_Operation_Enum> decl_QNetworkAccessManager_Operation_Enum (decl_QNetworkAccessManager_Operation_Enums, "QNetworkAccessManager_Operation",
  qt_gsi::mkdefs_QNetworkAccessManager_Operation () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QNetworkAccessManager_Operation_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QNetworkAccessManager_Operation_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQNetworkAccessManager_Operation_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QNetworkAccessManager_Operation_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QNetworkAccessManager_Operation_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QNetworkAccessManager::Operation enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QNetworkAccessManager> inject_QNetworkAccessManager_Operation_Enum_in_parent (qt_gsi::mkdefs_QNetworkAccessManager_Operation ());
static gsi::ClassExt<QNetworkAccessManager> decl_QNetworkAccessManager_Operation_Enum_as_child (decl_QNetworkAccessManager_Operation_Enum, "Operation");

}

