
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMessageBox.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQMessageBox_EventAdaptor.h"
#include "gsiDeclQMessageBox_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMessageBox

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMessageBox::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QMessageBox::addButton(QAbstractButton *button, QMessageBox::ButtonRole role)


static void _init_f_addButton_4728 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::ButtonRole>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addButton_4728 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractButton *arg1 = args.read<QAbstractButton * > ();
  const qt_gsi::Converter<QMessageBox::ButtonRole>::target_type & arg2 = args.read<const qt_gsi::Converter<QMessageBox::ButtonRole>::target_type & > ();
  ((QMessageBox *)cls)->addButton (arg1, qt_gsi::QtToCppAdaptor<QMessageBox::ButtonRole>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_addButton_4728 ()
{
  return new qt_gsi::GenericMethod ("addButton", "@brief Method void QMessageBox::addButton(QAbstractButton *button, QMessageBox::ButtonRole role)\n", false, &_init_f_addButton_4728, &_call_f_addButton_4728);
}

// QPushButton *QMessageBox::addButton(const QString &text, QMessageBox::ButtonRole role)


static void _init_f_addButton_4594 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::ButtonRole>::target_type & > (argspec_1);
  decl->set_return<QPushButton * > ();
}

static void _call_f_addButton_4594 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QMessageBox::ButtonRole>::target_type & arg2 = args.read<const qt_gsi::Converter<QMessageBox::ButtonRole>::target_type & > ();
  ret.write<QPushButton * > ((QPushButton *)((QMessageBox *)cls)->addButton (arg1, qt_gsi::QtToCppAdaptor<QMessageBox::ButtonRole>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_addButton_4594 ()
{
  return new qt_gsi::GenericMethod ("addButton", "@brief Method QPushButton *QMessageBox::addButton(const QString &text, QMessageBox::ButtonRole role)\n", false, &_init_f_addButton_4594, &_call_f_addButton_4594);
}

// QPushButton *QMessageBox::addButton(QMessageBox::StandardButton button)


static void _init_f_addButton_3092 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > (argspec_0);
  decl->set_return<QPushButton * > ();
}

static void _call_f_addButton_3092 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & arg1 = args.read<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > ();
  ret.write<QPushButton * > ((QPushButton *)((QMessageBox *)cls)->addButton (qt_gsi::QtToCppAdaptor<QMessageBox::StandardButton>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_addButton_3092 ()
{
  return new qt_gsi::GenericMethod ("addButton", "@brief Method QPushButton *QMessageBox::addButton(QMessageBox::StandardButton button)\n", false, &_init_f_addButton_3092, &_call_f_addButton_3092);
}

// QAbstractButton *QMessageBox::button(QMessageBox::StandardButton which)


static void _init_f_button_c3092 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > (argspec_0);
  decl->set_return<QAbstractButton * > ();
}

static void _call_f_button_c3092 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & arg1 = args.read<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > ();
  ret.write<QAbstractButton * > ((QAbstractButton *)((QMessageBox *)cls)->button (qt_gsi::QtToCppAdaptor<QMessageBox::StandardButton>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_button_c3092 ()
{
  return new qt_gsi::GenericMethod ("button", "@brief Method QAbstractButton *QMessageBox::button(QMessageBox::StandardButton which)\n", true, &_init_f_button_c3092, &_call_f_button_c3092);
}

// QMessageBox::ButtonRole QMessageBox::buttonRole(QAbstractButton *button)


static void _init_f_buttonRole_c2159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  decl->set_return<qt_gsi::Converter<QMessageBox::ButtonRole>::target_type > ();
}

static void _call_f_buttonRole_c2159 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractButton *arg1 = args.read<QAbstractButton * > ();
  ret.write<qt_gsi::Converter<QMessageBox::ButtonRole>::target_type > ((qt_gsi::Converter<QMessageBox::ButtonRole>::target_type)qt_gsi::CppToQtAdaptor<QMessageBox::ButtonRole>(((QMessageBox *)cls)->buttonRole (arg1)));
}

static qt_gsi::GenericMethod *_create_f_buttonRole_c2159 ()
{
  return new qt_gsi::GenericMethod ("buttonRole", "@brief Method QMessageBox::ButtonRole QMessageBox::buttonRole(QAbstractButton *button)\n", true, &_init_f_buttonRole_c2159, &_call_f_buttonRole_c2159);
}

// QString QMessageBox::buttonText(int button)


static void _init_f_buttonText_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_buttonText_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QString > ((QString)((QMessageBox *)cls)->buttonText (arg1));
}

static qt_gsi::GenericMethod *_create_f_buttonText_c767 ()
{
  return new qt_gsi::GenericMethod ("buttonText", "@brief Method QString QMessageBox::buttonText(int button)\n", true, &_init_f_buttonText_c767, &_call_f_buttonText_c767);
}

// QList<QAbstractButton *> QMessageBox::buttons()


static void _init_f_buttons_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QAbstractButton *> >::target_type > ();
}

static void _call_f_buttons_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QAbstractButton *> >::target_type > ((qt_gsi::Converter<QList<QAbstractButton *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QAbstractButton *> >(((QMessageBox *)cls)->buttons ()));
}

static qt_gsi::GenericMethod *_create_f_buttons_c0 ()
{
  return new qt_gsi::GenericMethod ("buttons", "@brief Method QList<QAbstractButton *> QMessageBox::buttons()\n", true, &_init_f_buttons_c0, &_call_f_buttons_c0);
}

// QAbstractButton *QMessageBox::clickedButton()


static void _init_f_clickedButton_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractButton * > ();
}

static void _call_f_clickedButton_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QAbstractButton * > ((QAbstractButton *)((QMessageBox *)cls)->clickedButton ());
}

static qt_gsi::GenericMethod *_create_f_clickedButton_c0 ()
{
  return new qt_gsi::GenericMethod ("clickedButton", "@brief Method QAbstractButton *QMessageBox::clickedButton()\n", true, &_init_f_clickedButton_c0, &_call_f_clickedButton_c0);
}

// QPushButton *QMessageBox::defaultButton()


static void _init_f_defaultButton_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPushButton * > ();
}

static void _call_f_defaultButton_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPushButton * > ((QPushButton *)((QMessageBox *)cls)->defaultButton ());
}

static qt_gsi::GenericMethod *_create_f_defaultButton_c0 ()
{
  return new qt_gsi::GenericMethod (":defaultButton", "@brief Method QPushButton *QMessageBox::defaultButton()\n", true, &_init_f_defaultButton_c0, &_call_f_defaultButton_c0);
}

// QString QMessageBox::detailedText()


static void _init_f_detailedText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_detailedText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QMessageBox *)cls)->detailedText ());
}

static qt_gsi::GenericMethod *_create_f_detailedText_c0 ()
{
  return new qt_gsi::GenericMethod (":detailedText", "@brief Method QString QMessageBox::detailedText()\n", true, &_init_f_detailedText_c0, &_call_f_detailedText_c0);
}

// QAbstractButton *QMessageBox::escapeButton()


static void _init_f_escapeButton_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAbstractButton * > ();
}

static void _call_f_escapeButton_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QAbstractButton * > ((QAbstractButton *)((QMessageBox *)cls)->escapeButton ());
}

static qt_gsi::GenericMethod *_create_f_escapeButton_c0 ()
{
  return new qt_gsi::GenericMethod (":escapeButton", "@brief Method QAbstractButton *QMessageBox::escapeButton()\n", true, &_init_f_escapeButton_c0, &_call_f_escapeButton_c0);
}

// QMessageBox::Icon QMessageBox::icon()


static void _init_f_icon_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMessageBox::Icon>::target_type > ();
}

static void _call_f_icon_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QMessageBox::Icon>::target_type > ((qt_gsi::Converter<QMessageBox::Icon>::target_type)qt_gsi::CppToQtAdaptor<QMessageBox::Icon>(((QMessageBox *)cls)->icon ()));
}

static qt_gsi::GenericMethod *_create_f_icon_c0 ()
{
  return new qt_gsi::GenericMethod (":icon", "@brief Method QMessageBox::Icon QMessageBox::icon()\n", true, &_init_f_icon_c0, &_call_f_icon_c0);
}

// QPixmap QMessageBox::iconPixmap()


static void _init_f_iconPixmap_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPixmap > ();
}

static void _call_f_iconPixmap_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPixmap > ((QPixmap)((QMessageBox *)cls)->iconPixmap ());
}

static qt_gsi::GenericMethod *_create_f_iconPixmap_c0 ()
{
  return new qt_gsi::GenericMethod (":iconPixmap", "@brief Method QPixmap QMessageBox::iconPixmap()\n", true, &_init_f_iconPixmap_c0, &_call_f_iconPixmap_c0);
}

// QString QMessageBox::informativeText()


static void _init_f_informativeText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_informativeText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QMessageBox *)cls)->informativeText ());
}

static qt_gsi::GenericMethod *_create_f_informativeText_c0 ()
{
  return new qt_gsi::GenericMethod (":informativeText", "@brief Method QString QMessageBox::informativeText()\n", true, &_init_f_informativeText_c0, &_call_f_informativeText_c0);
}

// void QMessageBox::open()


static void _init_f_open_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_open_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMessageBox *)cls)->open ();
}

static qt_gsi::GenericMethod *_create_f_open_0 ()
{
  return new qt_gsi::GenericMethod ("open", "@brief Method void QMessageBox::open()\n", false, &_init_f_open_0, &_call_f_open_0);
}

// void QMessageBox::open(QObject *receiver, const char *member)


static void _init_f_open_2925 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("member");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_open_2925 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  const char *arg2 = args.read<const char * > ();
  ((QMessageBox *)cls)->open (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_open_2925 ()
{
  return new qt_gsi::GenericMethod ("open", "@brief Method void QMessageBox::open(QObject *receiver, const char *member)\n", false, &_init_f_open_2925, &_call_f_open_2925);
}

// void QMessageBox::removeButton(QAbstractButton *button)


static void _init_f_removeButton_2159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeButton_2159 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractButton *arg1 = args.read<QAbstractButton * > ();
  ((QMessageBox *)cls)->removeButton (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeButton_2159 ()
{
  return new qt_gsi::GenericMethod ("removeButton", "@brief Method void QMessageBox::removeButton(QAbstractButton *button)\n", false, &_init_f_removeButton_2159, &_call_f_removeButton_2159);
}

// void QMessageBox::setButtonText(int button, const QString &text)


static void _init_f_setButtonText_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setButtonText_2684 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QString &arg2 = args.read<const QString & > ();
  ((QMessageBox *)cls)->setButtonText (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setButtonText_2684 ()
{
  return new qt_gsi::GenericMethod ("setButtonText", "@brief Method void QMessageBox::setButtonText(int button, const QString &text)\n", false, &_init_f_setButtonText_2684, &_call_f_setButtonText_2684);
}

// void QMessageBox::setDefaultButton(QPushButton *button)


static void _init_f_setDefaultButton_1755 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QPushButton * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultButton_1755 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPushButton *arg1 = args.read<QPushButton * > ();
  ((QMessageBox *)cls)->setDefaultButton (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDefaultButton_1755 ()
{
  return new qt_gsi::GenericMethod ("setDefaultButton|defaultButton=", "@brief Method void QMessageBox::setDefaultButton(QPushButton *button)\n", false, &_init_f_setDefaultButton_1755, &_call_f_setDefaultButton_1755);
}

// void QMessageBox::setDefaultButton(QMessageBox::StandardButton button)


static void _init_f_setDefaultButton_3092 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultButton_3092 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & arg1 = args.read<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > ();
  ((QMessageBox *)cls)->setDefaultButton (qt_gsi::QtToCppAdaptor<QMessageBox::StandardButton>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setDefaultButton_3092 ()
{
  return new qt_gsi::GenericMethod ("setDefaultButton|defaultButton=", "@brief Method void QMessageBox::setDefaultButton(QMessageBox::StandardButton button)\n", false, &_init_f_setDefaultButton_3092, &_call_f_setDefaultButton_3092);
}

// void QMessageBox::setDetailedText(const QString &text)


static void _init_f_setDetailedText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDetailedText_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QMessageBox *)cls)->setDetailedText (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDetailedText_2025 ()
{
  return new qt_gsi::GenericMethod ("setDetailedText|detailedText=", "@brief Method void QMessageBox::setDetailedText(const QString &text)\n", false, &_init_f_setDetailedText_2025, &_call_f_setDetailedText_2025);
}

// void QMessageBox::setEscapeButton(QAbstractButton *button)


static void _init_f_setEscapeButton_2159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEscapeButton_2159 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractButton *arg1 = args.read<QAbstractButton * > ();
  ((QMessageBox *)cls)->setEscapeButton (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEscapeButton_2159 ()
{
  return new qt_gsi::GenericMethod ("setEscapeButton|escapeButton=", "@brief Method void QMessageBox::setEscapeButton(QAbstractButton *button)\n", false, &_init_f_setEscapeButton_2159, &_call_f_setEscapeButton_2159);
}

// void QMessageBox::setEscapeButton(QMessageBox::StandardButton button)


static void _init_f_setEscapeButton_3092 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEscapeButton_3092 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & arg1 = args.read<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > ();
  ((QMessageBox *)cls)->setEscapeButton (qt_gsi::QtToCppAdaptor<QMessageBox::StandardButton>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setEscapeButton_3092 ()
{
  return new qt_gsi::GenericMethod ("setEscapeButton|escapeButton=", "@brief Method void QMessageBox::setEscapeButton(QMessageBox::StandardButton button)\n", false, &_init_f_setEscapeButton_3092, &_call_f_setEscapeButton_3092);
}

// void QMessageBox::setIcon(QMessageBox::Icon)


static void _init_f_setIcon_2032 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::Icon>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIcon_2032 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QMessageBox::Icon>::target_type & arg1 = args.read<const qt_gsi::Converter<QMessageBox::Icon>::target_type & > ();
  ((QMessageBox *)cls)->setIcon (qt_gsi::QtToCppAdaptor<QMessageBox::Icon>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setIcon_2032 ()
{
  return new qt_gsi::GenericMethod ("setIcon|icon=", "@brief Method void QMessageBox::setIcon(QMessageBox::Icon)\n", false, &_init_f_setIcon_2032, &_call_f_setIcon_2032);
}

// void QMessageBox::setIconPixmap(const QPixmap &pixmap)


static void _init_f_setIconPixmap_2017 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIconPixmap_2017 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPixmap &arg1 = args.read<const QPixmap & > ();
  ((QMessageBox *)cls)->setIconPixmap (arg1);
}

static qt_gsi::GenericMethod *_create_f_setIconPixmap_2017 ()
{
  return new qt_gsi::GenericMethod ("setIconPixmap|iconPixmap=", "@brief Method void QMessageBox::setIconPixmap(const QPixmap &pixmap)\n", false, &_init_f_setIconPixmap_2017, &_call_f_setIconPixmap_2017);
}

// void QMessageBox::setInformativeText(const QString &text)


static void _init_f_setInformativeText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setInformativeText_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QMessageBox *)cls)->setInformativeText (arg1);
}

static qt_gsi::GenericMethod *_create_f_setInformativeText_2025 ()
{
  return new qt_gsi::GenericMethod ("setInformativeText|informativeText=", "@brief Method void QMessageBox::setInformativeText(const QString &text)\n", false, &_init_f_setInformativeText_2025, &_call_f_setInformativeText_2025);
}

// void QMessageBox::setStandardButtons(QFlags<QMessageBox::StandardButton> buttons)


static void _init_f_setStandardButtons_3788 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("buttons");
  decl->add_arg<const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStandardButtons_3788 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type & > ();
  ((QMessageBox *)cls)->setStandardButtons (qt_gsi::QtToCppAdaptor<QFlags<QMessageBox::StandardButton> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setStandardButtons_3788 ()
{
  return new qt_gsi::GenericMethod ("setStandardButtons|standardButtons=", "@brief Method void QMessageBox::setStandardButtons(QFlags<QMessageBox::StandardButton> buttons)\n", false, &_init_f_setStandardButtons_3788, &_call_f_setStandardButtons_3788);
}

// void QMessageBox::setText(const QString &text)


static void _init_f_setText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setText_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QMessageBox *)cls)->setText (arg1);
}

static qt_gsi::GenericMethod *_create_f_setText_2025 ()
{
  return new qt_gsi::GenericMethod ("setText|text=", "@brief Method void QMessageBox::setText(const QString &text)\n", false, &_init_f_setText_2025, &_call_f_setText_2025);
}

// void QMessageBox::setTextFormat(Qt::TextFormat format)


static void _init_f_setTextFormat_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<Qt::TextFormat>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextFormat_1787 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::TextFormat>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::TextFormat>::target_type & > ();
  ((QMessageBox *)cls)->setTextFormat (qt_gsi::QtToCppAdaptor<Qt::TextFormat>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setTextFormat_1787 ()
{
  return new qt_gsi::GenericMethod ("setTextFormat|textFormat=", "@brief Method void QMessageBox::setTextFormat(Qt::TextFormat format)\n", false, &_init_f_setTextFormat_1787, &_call_f_setTextFormat_1787);
}

// void QMessageBox::setWindowModality(Qt::WindowModality windowModality)


static void _init_f_setWindowModality_2216 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("windowModality");
  decl->add_arg<const qt_gsi::Converter<Qt::WindowModality>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowModality_2216 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::WindowModality>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::WindowModality>::target_type & > ();
  ((QMessageBox *)cls)->setWindowModality (qt_gsi::QtToCppAdaptor<Qt::WindowModality>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setWindowModality_2216 ()
{
  return new qt_gsi::GenericMethod ("setWindowModality|windowModality=", "@brief Method void QMessageBox::setWindowModality(Qt::WindowModality windowModality)\n", false, &_init_f_setWindowModality_2216, &_call_f_setWindowModality_2216);
}

// void QMessageBox::setWindowTitle(const QString &title)


static void _init_f_setWindowTitle_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowTitle_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QMessageBox *)cls)->setWindowTitle (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWindowTitle_2025 ()
{
  return new qt_gsi::GenericMethod ("setWindowTitle|windowTitle=", "@brief Method void QMessageBox::setWindowTitle(const QString &title)\n", false, &_init_f_setWindowTitle_2025, &_call_f_setWindowTitle_2025);
}

// QSize QMessageBox::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QMessageBox *)cls)->sizeHint ());
}

static qt_gsi::GenericMethod *_create_f_sizeHint_c0 ()
{
  return new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QMessageBox::sizeHint()\nThis is a reimplementation of QDialog::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
}

// QMessageBox::StandardButton QMessageBox::standardButton(QAbstractButton *button)


static void _init_f_standardButton_c2159 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("button");
  decl->add_arg<QAbstractButton * > (argspec_0);
  decl->set_return<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ();
}

static void _call_f_standardButton_c2159 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractButton *arg1 = args.read<QAbstractButton * > ();
  ret.write<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ((qt_gsi::Converter<QMessageBox::StandardButton>::target_type)qt_gsi::CppToQtAdaptor<QMessageBox::StandardButton>(((QMessageBox *)cls)->standardButton (arg1)));
}

static qt_gsi::GenericMethod *_create_f_standardButton_c2159 ()
{
  return new qt_gsi::GenericMethod ("standardButton", "@brief Method QMessageBox::StandardButton QMessageBox::standardButton(QAbstractButton *button)\n", true, &_init_f_standardButton_c2159, &_call_f_standardButton_c2159);
}

// QFlags<QMessageBox::StandardButton> QMessageBox::standardButtons()


static void _init_f_standardButtons_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type > ();
}

static void _call_f_standardButtons_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type > ((qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QMessageBox::StandardButton> >(((QMessageBox *)cls)->standardButtons ()));
}

static qt_gsi::GenericMethod *_create_f_standardButtons_c0 ()
{
  return new qt_gsi::GenericMethod (":standardButtons", "@brief Method QFlags<QMessageBox::StandardButton> QMessageBox::standardButtons()\n", true, &_init_f_standardButtons_c0, &_call_f_standardButtons_c0);
}

// QString QMessageBox::text()


static void _init_f_text_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_text_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QMessageBox *)cls)->text ());
}

static qt_gsi::GenericMethod *_create_f_text_c0 ()
{
  return new qt_gsi::GenericMethod (":text", "@brief Method QString QMessageBox::text()\n", true, &_init_f_text_c0, &_call_f_text_c0);
}

// Qt::TextFormat QMessageBox::textFormat()


static void _init_f_textFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::TextFormat>::target_type > ();
}

static void _call_f_textFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::TextFormat>::target_type > ((qt_gsi::Converter<Qt::TextFormat>::target_type)qt_gsi::CppToQtAdaptor<Qt::TextFormat>(((QMessageBox *)cls)->textFormat ()));
}

static qt_gsi::GenericMethod *_create_f_textFormat_c0 ()
{
  return new qt_gsi::GenericMethod (":textFormat", "@brief Method Qt::TextFormat QMessageBox::textFormat()\n", true, &_init_f_textFormat_c0, &_call_f_textFormat_c0);
}

// static void QMessageBox::about(QWidget *parent, const QString &title, const QString &text)


static void _init_f_about_5149 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_about_5149 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QString &arg2 = args.read<const QString & > ();
  const QString &arg3 = args.read<const QString & > ();
  QMessageBox::about (arg1, arg2, arg3);
}

static qt_gsi::GenericStaticMethod *_create_f_about_5149 ()
{
  return new qt_gsi::GenericStaticMethod ("about", "@brief Static method void QMessageBox::about(QWidget *parent, const QString &title, const QString &text)\nThis method is static and can be called without an instance.", &_init_f_about_5149, &_call_f_about_5149);
}

// static void QMessageBox::aboutQt(QWidget *parent, const QString &title)


static void _init_f_aboutQt_3232 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_aboutQt_3232 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QString &arg2 = args ? args.read<const QString & > () : (const QString &)(QString());
  QMessageBox::aboutQt (arg1, arg2);
}

static qt_gsi::GenericStaticMethod *_create_f_aboutQt_3232 ()
{
  return new qt_gsi::GenericStaticMethod ("aboutQt", "@brief Static method void QMessageBox::aboutQt(QWidget *parent, const QString &title)\nThis method is static and can be called without an instance.", &_init_f_aboutQt_3232, &_call_f_aboutQt_3232);
}

// static QMessageBox::StandardButton QMessageBox::critical(QWidget *parent, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QMessageBox::StandardButton defaultButton)


static void _init_f_critical_11813 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("buttons", true, "QMessageBox::Ok");
  decl->add_arg<const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("defaultButton", true, "QMessageBox::NoButton");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > (argspec_4);
  decl->set_return<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ();
}

static void _call_f_critical_11813 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QString &arg2 = args.read<const QString & > ();
  const QString &arg3 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type & > () : (const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QMessageBox::StandardButton> >(heap, QMessageBox::Ok));
  const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & arg5 = args ? args.read<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > () : (const qt_gsi::Converter<QMessageBox::StandardButton>::target_type &)(qt_gsi::CppToQtReadAdaptor<QMessageBox::StandardButton>(heap, QMessageBox::NoButton));
  ret.write<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ((qt_gsi::Converter<QMessageBox::StandardButton>::target_type)qt_gsi::CppToQtAdaptor<QMessageBox::StandardButton>(QMessageBox::critical (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QFlags<QMessageBox::StandardButton> >(arg4).cref(), qt_gsi::QtToCppAdaptor<QMessageBox::StandardButton>(arg5).cref())));
}

static qt_gsi::GenericStaticMethod *_create_f_critical_11813 ()
{
  return new qt_gsi::GenericStaticMethod ("critical", "@brief Static method QMessageBox::StandardButton QMessageBox::critical(QWidget *parent, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QMessageBox::StandardButton defaultButton)\nThis method is static and can be called without an instance.", &_init_f_critical_11813, &_call_f_critical_11813);
}

// static QMessageBox::StandardButton QMessageBox::information(QWidget *parent, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QMessageBox::StandardButton defaultButton)


static void _init_f_information_11813 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("buttons", true, "QMessageBox::Ok");
  decl->add_arg<const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("defaultButton", true, "QMessageBox::NoButton");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > (argspec_4);
  decl->set_return<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ();
}

static void _call_f_information_11813 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QString &arg2 = args.read<const QString & > ();
  const QString &arg3 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type & > () : (const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QMessageBox::StandardButton> >(heap, QMessageBox::Ok));
  const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & arg5 = args ? args.read<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > () : (const qt_gsi::Converter<QMessageBox::StandardButton>::target_type &)(qt_gsi::CppToQtReadAdaptor<QMessageBox::StandardButton>(heap, QMessageBox::NoButton));
  ret.write<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ((qt_gsi::Converter<QMessageBox::StandardButton>::target_type)qt_gsi::CppToQtAdaptor<QMessageBox::StandardButton>(QMessageBox::information (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QFlags<QMessageBox::StandardButton> >(arg4).cref(), qt_gsi::QtToCppAdaptor<QMessageBox::StandardButton>(arg5).cref())));
}

static qt_gsi::GenericStaticMethod *_create_f_information_11813 ()
{
  return new qt_gsi::GenericStaticMethod ("information", "@brief Static method QMessageBox::StandardButton QMessageBox::information(QWidget *parent, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QMessageBox::StandardButton defaultButton)\nThis method is static and can be called without an instance.", &_init_f_information_11813, &_call_f_information_11813);
}

// static QMessageBox::StandardButton QMessageBox::question(QWidget *parent, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QMessageBox::StandardButton defaultButton)


static void _init_f_question_11813 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("buttons", true, "QMessageBox::Ok");
  decl->add_arg<const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("defaultButton", true, "QMessageBox::NoButton");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > (argspec_4);
  decl->set_return<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ();
}

static void _call_f_question_11813 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QString &arg2 = args.read<const QString & > ();
  const QString &arg3 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type & > () : (const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QMessageBox::StandardButton> >(heap, QMessageBox::Ok));
  const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & arg5 = args ? args.read<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > () : (const qt_gsi::Converter<QMessageBox::StandardButton>::target_type &)(qt_gsi::CppToQtReadAdaptor<QMessageBox::StandardButton>(heap, QMessageBox::NoButton));
  ret.write<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ((qt_gsi::Converter<QMessageBox::StandardButton>::target_type)qt_gsi::CppToQtAdaptor<QMessageBox::StandardButton>(QMessageBox::question (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QFlags<QMessageBox::StandardButton> >(arg4).cref(), qt_gsi::QtToCppAdaptor<QMessageBox::StandardButton>(arg5).cref())));
}

static qt_gsi::GenericStaticMethod *_create_f_question_11813 ()
{
  return new qt_gsi::GenericStaticMethod ("question", "@brief Static method QMessageBox::StandardButton QMessageBox::question(QWidget *parent, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QMessageBox::StandardButton defaultButton)\nThis method is static and can be called without an instance.", &_init_f_question_11813, &_call_f_question_11813);
}

// static QString QMessageBox::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QMessageBox::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMessageBox::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QMessageBox::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QMessageBox::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMessageBox::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QMessageBox::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QMessageBox::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMessageBox::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QMessageBox::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QMessageBox::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMessageBox::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

// static QMessageBox::StandardButton QMessageBox::warning(QWidget *parent, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QMessageBox::StandardButton defaultButton)


static void _init_f_warning_11813 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("buttons", true, "QMessageBox::Ok");
  decl->add_arg<const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("defaultButton", true, "QMessageBox::NoButton");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > (argspec_4);
  decl->set_return<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ();
}

static void _call_f_warning_11813 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QString &arg2 = args.read<const QString & > ();
  const QString &arg3 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type & > () : (const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QMessageBox::StandardButton> >(heap, QMessageBox::Ok));
  const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & arg5 = args ? args.read<const qt_gsi::Converter<QMessageBox::StandardButton>::target_type & > () : (const qt_gsi::Converter<QMessageBox::StandardButton>::target_type &)(qt_gsi::CppToQtReadAdaptor<QMessageBox::StandardButton>(heap, QMessageBox::NoButton));
  ret.write<qt_gsi::Converter<QMessageBox::StandardButton>::target_type > ((qt_gsi::Converter<QMessageBox::StandardButton>::target_type)qt_gsi::CppToQtAdaptor<QMessageBox::StandardButton>(QMessageBox::warning (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QFlags<QMessageBox::StandardButton> >(arg4).cref(), qt_gsi::QtToCppAdaptor<QMessageBox::StandardButton>(arg5).cref())));
}

static qt_gsi::GenericStaticMethod *_create_f_warning_11813 ()
{
  return new qt_gsi::GenericStaticMethod ("warning", "@brief Static method QMessageBox::StandardButton QMessageBox::warning(QWidget *parent, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QMessageBox::StandardButton defaultButton)\nThis method is static and can be called without an instance.", &_init_f_warning_11813, &_call_f_warning_11813);
}

static qt_gsi::QObjectConnector<QMessageBox, QMessageBox_EventAdaptor> ea_QMessageBox;

namespace gsi
{
extern gsi::Class<QDialog> decl_QDialog;

gsi::Class<QMessageBox> decl_QMessageBox (ea_QMessageBox, decl_QDialog, "QMessageBox_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_addButton_4728 ()) +
  gsi::Methods(_create_f_addButton_4594 ()) +
  gsi::Methods(_create_f_addButton_3092 ()) +
  gsi::Methods(_create_f_button_c3092 ()) +
  gsi::Methods(_create_f_buttonRole_c2159 ()) +
  gsi::Methods(_create_f_buttonText_c767 ()) +
  gsi::Methods(_create_f_buttons_c0 ()) +
  gsi::Methods(_create_f_clickedButton_c0 ()) +
  gsi::Methods(_create_f_defaultButton_c0 ()) +
  gsi::Methods(_create_f_detailedText_c0 ()) +
  gsi::Methods(_create_f_escapeButton_c0 ()) +
  gsi::Methods(_create_f_icon_c0 ()) +
  gsi::Methods(_create_f_iconPixmap_c0 ()) +
  gsi::Methods(_create_f_informativeText_c0 ()) +
  gsi::Methods(_create_f_open_0 ()) +
  gsi::Methods(_create_f_open_2925 ()) +
  gsi::Methods(_create_f_removeButton_2159 ()) +
  gsi::Methods(_create_f_setButtonText_2684 ()) +
  gsi::Methods(_create_f_setDefaultButton_1755 ()) +
  gsi::Methods(_create_f_setDefaultButton_3092 ()) +
  gsi::Methods(_create_f_setDetailedText_2025 ()) +
  gsi::Methods(_create_f_setEscapeButton_2159 ()) +
  gsi::Methods(_create_f_setEscapeButton_3092 ()) +
  gsi::Methods(_create_f_setIcon_2032 ()) +
  gsi::Methods(_create_f_setIconPixmap_2017 ()) +
  gsi::Methods(_create_f_setInformativeText_2025 ()) +
  gsi::Methods(_create_f_setStandardButtons_3788 ()) +
  gsi::Methods(_create_f_setText_2025 ()) +
  gsi::Methods(_create_f_setTextFormat_1787 ()) +
  gsi::Methods(_create_f_setWindowModality_2216 ()) +
  gsi::Methods(_create_f_setWindowTitle_2025 ()) +
  gsi::Methods(_create_f_sizeHint_c0 ()) +
  gsi::Methods(_create_f_standardButton_c2159 ()) +
  gsi::Methods(_create_f_standardButtons_c0 ()) +
  gsi::Methods(_create_f_text_c0 ()) +
  gsi::Methods(_create_f_textFormat_c0 ()) +
  qt_gsi::qt_signal<QMessageBox, QMessageBox_EventAdaptor> ("accepted", &QMessageBox_EventAdaptor::accepted_e_0, "@brief Signal declaration for QMessageBox::accepted()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMessageBox, QMessageBox_EventAdaptor, QAbstractButton *> ("buttonClicked", &QMessageBox_EventAdaptor::buttonClicked_e_2159, gsi::arg("button"), "@brief Signal declaration for QMessageBox::buttonClicked(QAbstractButton *button)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMessageBox, QMessageBox_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QMessageBox_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QMessageBox::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMessageBox, QMessageBox_EventAdaptor, QObject *> ("destroyed", &QMessageBox_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QMessageBox::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMessageBox, QMessageBox_EventAdaptor, int> ("finished", &QMessageBox_EventAdaptor::finished_e_767, gsi::arg("result"), "@brief Signal declaration for QMessageBox::finished(int result)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QMessageBox, QMessageBox_EventAdaptor> ("rejected", &QMessageBox_EventAdaptor::rejected_e_0, "@brief Signal declaration for QMessageBox::rejected()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_about_5149 ()) +
  gsi::Methods(_create_f_aboutQt_3232 ()) +
  gsi::Methods(_create_f_critical_11813 ()) +
  gsi::Methods(_create_f_information_11813 ()) +
  gsi::Methods(_create_f_question_11813 ()) +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()) +
  gsi::Methods(_create_f_warning_11813 ()),
  "@hide\n@alias QMessageBox");
}


class QMessageBox_Adaptor : public QMessageBox, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMessageBox_Adaptor();

  //  [adaptor ctor] QMessageBox::QMessageBox(QWidget *parent)
  QMessageBox_Adaptor() : QMessageBox()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMessageBox::QMessageBox(QWidget *parent)
  QMessageBox_Adaptor(QWidget *parent) : QMessageBox(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMessageBox::QMessageBox(QMessageBox::Icon icon, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QWidget *parent, QFlags<Qt::WindowType> flags)
  QMessageBox_Adaptor(QMessageBox::Icon icon, const QString &title, const QString &text) : QMessageBox(icon, title, text)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMessageBox::QMessageBox(QMessageBox::Icon icon, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QWidget *parent, QFlags<Qt::WindowType> flags)
  QMessageBox_Adaptor(QMessageBox::Icon icon, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons) : QMessageBox(icon, title, text, buttons)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMessageBox::QMessageBox(QMessageBox::Icon icon, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QWidget *parent, QFlags<Qt::WindowType> flags)
  QMessageBox_Adaptor(QMessageBox::Icon icon, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QWidget *parent) : QMessageBox(icon, title, text, buttons, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMessageBox::QMessageBox(QMessageBox::Icon icon, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QWidget *parent, QFlags<Qt::WindowType> flags)
  QMessageBox_Adaptor(QMessageBox::Icon icon, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QWidget *parent, QFlags<Qt::WindowType> flags) : QMessageBox(icon, title, text, buttons, parent, flags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMessageBox::QMessageBox(const QString &title, const QString &text, QMessageBox::Icon icon, int button0, int button1, int button2, QWidget *parent, QFlags<Qt::WindowType> f)
  QMessageBox_Adaptor(const QString &title, const QString &text, QMessageBox::Icon icon, int button0, int button1, int button2) : QMessageBox(title, text, icon, button0, button1, button2)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMessageBox::QMessageBox(const QString &title, const QString &text, QMessageBox::Icon icon, int button0, int button1, int button2, QWidget *parent, QFlags<Qt::WindowType> f)
  QMessageBox_Adaptor(const QString &title, const QString &text, QMessageBox::Icon icon, int button0, int button1, int button2, QWidget *parent) : QMessageBox(title, text, icon, button0, button1, button2, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMessageBox::QMessageBox(const QString &title, const QString &text, QMessageBox::Icon icon, int button0, int button1, int button2, QWidget *parent, QFlags<Qt::WindowType> f)
  QMessageBox_Adaptor(const QString &title, const QString &text, QMessageBox::Icon icon, int button0, int button1, int button2, QWidget *parent, QFlags<Qt::WindowType> f) : QMessageBox(title, text, icon, button0, button1, button2, parent, f)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QMessageBox::adjustPosition(QWidget *)
  void fp_QMessageBox_adjustPosition_1315 (QWidget *arg1) {
    QMessageBox::adjustPosition(arg1);
  }

  //  void QMessageBox::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QMessageBox_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QMessageBox::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QMessageBox::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QMessageBox_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QMessageBox::destroy(destroyWindow, destroySubWindows);
  }

  //  bool QMessageBox::focusNextChild()
  bool fp_QMessageBox_focusNextChild_0 () {
    return QMessageBox::focusNextChild();
  }

  //  bool QMessageBox::focusPreviousChild()
  bool fp_QMessageBox_focusPreviousChild_0 () {
    return QMessageBox::focusPreviousChild();
  }

  //  int QMessageBox::receivers(const char *signal)
  int fp_QMessageBox_receivers_c1731 (const char *signal) const {
    return QMessageBox::receivers(signal);
  }

  //  void QMessageBox::resetInputContext()
  void fp_QMessageBox_resetInputContext_0 () {
    QMessageBox::resetInputContext();
  }

  //  QObject *QMessageBox::sender()
  QObject * fp_QMessageBox_sender_c0 () const {
    return QMessageBox::sender();
  }

  //  void QMessageBox::updateMicroFocus()
  void fp_QMessageBox_updateMicroFocus_0 () {
    QMessageBox::updateMicroFocus();
  }

  //  [adaptor impl] void QMessageBox::accept()
  void cbs_accept_0_0()
  {
    QMessageBox::accept();
  }

  virtual void accept()
  {
    if (cb_accept_0_0.can_issue()) {
      cb_accept_0_0.issue<QMessageBox_Adaptor>(&QMessageBox_Adaptor::cbs_accept_0_0);
    } else {
      QMessageBox::accept();
    }
  }

  //  [adaptor impl] void QMessageBox::done(int)
  void cbs_done_767_0(int arg1)
  {
    QMessageBox::done(arg1);
  }

  virtual void done(int arg1)
  {
    if (cb_done_767_0.can_issue()) {
      cb_done_767_0.issue<QMessageBox_Adaptor, int>(&QMessageBox_Adaptor::cbs_done_767_0, arg1);
    } else {
      QMessageBox::done(arg1);
    }
  }

  //  [adaptor impl] int QMessageBox::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QMessageBox::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QMessageBox_Adaptor, int, int>(&QMessageBox_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QMessageBox::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QMessageBox::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QMessageBox::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QMessageBox_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QMessageBox_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QMessageBox::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QMessageBox::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QMessageBox::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QMessageBox_Adaptor, QSize>(&QMessageBox_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QMessageBox::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QMessageBox::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QMessageBox::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QMessageBox_Adaptor, QPaintEngine *>(&QMessageBox_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QMessageBox::paintEngine();
    }
  }

  //  [adaptor impl] void QMessageBox::reject()
  void cbs_reject_0_0()
  {
    QMessageBox::reject();
  }

  virtual void reject()
  {
    if (cb_reject_0_0.can_issue()) {
      cb_reject_0_0.issue<QMessageBox_Adaptor>(&QMessageBox_Adaptor::cbs_reject_0_0);
    } else {
      QMessageBox::reject();
    }
  }

  //  [adaptor impl] void QMessageBox::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QMessageBox::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QMessageBox_Adaptor, bool>(&QMessageBox_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QMessageBox::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QMessageBox::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QMessageBox::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QMessageBox_Adaptor, QSize>(&QMessageBox_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QMessageBox::sizeHint();
    }
  }

  //  [adaptor impl] void QMessageBox::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QMessageBox::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QMessageBox_Adaptor, QActionEvent *>(&QMessageBox_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QMessageBox::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::changeEvent(QEvent *event)
  void cbs_changeEvent_1217_0(QEvent *event)
  {
    QMessageBox::changeEvent(event);
  }

  virtual void changeEvent(QEvent *event)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QMessageBox_Adaptor, QEvent *>(&QMessageBox_Adaptor::cbs_changeEvent_1217_0, event);
    } else {
      QMessageBox::changeEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QMessageBox::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMessageBox_Adaptor, QChildEvent *>(&QMessageBox_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QMessageBox::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::closeEvent(QCloseEvent *event)
  void cbs_closeEvent_1719_0(QCloseEvent *event)
  {
    QMessageBox::closeEvent(event);
  }

  virtual void closeEvent(QCloseEvent *event)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QMessageBox_Adaptor, QCloseEvent *>(&QMessageBox_Adaptor::cbs_closeEvent_1719_0, event);
    } else {
      QMessageBox::closeEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QMessageBox::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QMessageBox_Adaptor, QContextMenuEvent *>(&QMessageBox_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QMessageBox::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QMessageBox::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMessageBox_Adaptor, QEvent *>(&QMessageBox_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QMessageBox::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QMessageBox::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QMessageBox_Adaptor, const char *>(&QMessageBox_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QMessageBox::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QMessageBox::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QMessageBox::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QMessageBox_Adaptor, QDragEnterEvent *>(&QMessageBox_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QMessageBox::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QMessageBox::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QMessageBox_Adaptor, QDragLeaveEvent *>(&QMessageBox_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QMessageBox::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QMessageBox::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QMessageBox_Adaptor, QDragMoveEvent *>(&QMessageBox_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QMessageBox::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QMessageBox::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QMessageBox_Adaptor, QDropEvent *>(&QMessageBox_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QMessageBox::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QMessageBox::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QMessageBox_Adaptor, bool>(&QMessageBox_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QMessageBox::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QMessageBox::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QMessageBox_Adaptor, QEvent *>(&QMessageBox_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QMessageBox::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QMessageBox::event(QEvent *e)
  bool cbs_event_1217_0(QEvent *e)
  {
    return QMessageBox::event(e);
  }

  virtual bool event(QEvent *e)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMessageBox_Adaptor, bool, QEvent *>(&QMessageBox_Adaptor::cbs_event_1217_0, e);
    } else {
      return QMessageBox::event(e);
    }
  }

  //  [adaptor impl] bool QMessageBox::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QMessageBox::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMessageBox_Adaptor, bool, QObject *, QEvent *>(&QMessageBox_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QMessageBox::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QMessageBox::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QMessageBox::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QMessageBox_Adaptor, QFocusEvent *>(&QMessageBox_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QMessageBox::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] bool QMessageBox::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QMessageBox::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QMessageBox_Adaptor, bool, bool>(&QMessageBox_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QMessageBox::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QMessageBox::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QMessageBox::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QMessageBox_Adaptor, QFocusEvent *>(&QMessageBox_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QMessageBox::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QMessageBox::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QMessageBox_Adaptor, const QFont &>(&QMessageBox_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QMessageBox::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QMessageBox::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QMessageBox_Adaptor, QHideEvent *>(&QMessageBox_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QMessageBox::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QMessageBox::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QMessageBox_Adaptor, QInputMethodEvent *>(&QMessageBox_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QMessageBox::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QMessageBox::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QMessageBox_Adaptor, QKeyEvent *>(&QMessageBox_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QMessageBox::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QMessageBox::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QMessageBox_Adaptor, QKeyEvent *>(&QMessageBox_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QMessageBox::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::languageChange()
  void cbs_languageChange_0_0()
  {
    QMessageBox::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QMessageBox_Adaptor>(&QMessageBox_Adaptor::cbs_languageChange_0_0);
    } else {
      QMessageBox::languageChange();
    }
  }

  //  [adaptor impl] void QMessageBox::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QMessageBox::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QMessageBox_Adaptor, QEvent *>(&QMessageBox_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QMessageBox::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QMessageBox::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QMessageBox::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QMessageBox_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QMessageBox_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QMessageBox::metric(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QMessageBox::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QMessageBox_Adaptor, QMouseEvent *>(&QMessageBox_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QMessageBox::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QMessageBox::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QMessageBox_Adaptor, QMouseEvent *>(&QMessageBox_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QMessageBox::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QMessageBox::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QMessageBox_Adaptor, QMouseEvent *>(&QMessageBox_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QMessageBox::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QMessageBox::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QMessageBox_Adaptor, QMouseEvent *>(&QMessageBox_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QMessageBox::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QMessageBox::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QMessageBox_Adaptor, QMoveEvent *>(&QMessageBox_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QMessageBox::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QMessageBox::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QMessageBox_Adaptor, QPaintEvent *>(&QMessageBox_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QMessageBox::paintEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QMessageBox::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QMessageBox_Adaptor, const QPalette &>(&QMessageBox_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QMessageBox::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::resizeEvent(QResizeEvent *event)
  void cbs_resizeEvent_1843_0(QResizeEvent *event)
  {
    QMessageBox::resizeEvent(event);
  }

  virtual void resizeEvent(QResizeEvent *event)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QMessageBox_Adaptor, QResizeEvent *>(&QMessageBox_Adaptor::cbs_resizeEvent_1843_0, event);
    } else {
      QMessageBox::resizeEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::showEvent(QShowEvent *event)
  void cbs_showEvent_1634_0(QShowEvent *event)
  {
    QMessageBox::showEvent(event);
  }

  virtual void showEvent(QShowEvent *event)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QMessageBox_Adaptor, QShowEvent *>(&QMessageBox_Adaptor::cbs_showEvent_1634_0, event);
    } else {
      QMessageBox::showEvent(event);
    }
  }

  //  [adaptor impl] void QMessageBox::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QMessageBox::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QMessageBox_Adaptor, QStyle &>(&QMessageBox_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QMessageBox::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QMessageBox::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QMessageBox_Adaptor, QTabletEvent *>(&QMessageBox_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QMessageBox::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QMessageBox::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMessageBox_Adaptor, QTimerEvent *>(&QMessageBox_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QMessageBox::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QMessageBox::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QMessageBox_Adaptor, QWheelEvent *>(&QMessageBox_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QMessageBox::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QMessageBox::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QMessageBox::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QMessageBox_Adaptor, bool>(&QMessageBox_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QMessageBox::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_accept_0_0;
  gsi::Callback cb_done_767_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_reject_0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QMessageBox_Adaptor::~QMessageBox_Adaptor() { }

//  Constructor QMessageBox::QMessageBox(QWidget *parent) (adaptor class)

static void _init_ctor_QMessageBox_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QMessageBox_Adaptor *> ();
}

static void _call_ctor_QMessageBox_Adaptor_1315 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QMessageBox_Adaptor *> (new QMessageBox_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QMessageBox_Adaptor_1315 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMessageBox::QMessageBox(QWidget *parent)\nThis method creates an object of class QMessageBox.", &_init_ctor_QMessageBox_Adaptor_1315, &_call_ctor_QMessageBox_Adaptor_1315);
}

//  Constructor QMessageBox::QMessageBox(QMessageBox::Icon icon, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QWidget *parent, QFlags<Qt::WindowType> flags) (adaptor class)

static void _init_ctor_QMessageBox_Adaptor_13140 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::Icon>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("text");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("buttons", true, "QMessageBox::NoButton");
  decl->add_arg<const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("flags", true, "Qt::Dialog | Qt::MSWindowsFixedSizeDialogHint");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_5);
  decl->set_return_new<QMessageBox_Adaptor *> ();
}

static void _call_ctor_QMessageBox_Adaptor_13140 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QMessageBox::Icon>::target_type & arg1 = args.read<const qt_gsi::Converter<QMessageBox::Icon>::target_type & > ();
  const QString &arg2 = args.read<const QString & > ();
  const QString &arg3 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type & > () : (const qt_gsi::Converter<QFlags<QMessageBox::StandardButton> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QMessageBox::StandardButton> >(heap, QMessageBox::NoButton));
  QWidget *arg5 = args ? args.read<QWidget * > () : (QWidget *)(0);
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg6 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::WindowType> >(heap, Qt::Dialog | Qt::MSWindowsFixedSizeDialogHint));
  ret.write<QMessageBox_Adaptor *> (new QMessageBox_Adaptor (qt_gsi::QtToCppAdaptor<QMessageBox::Icon>(arg1).cref(), arg2, arg3, qt_gsi::QtToCppAdaptor<QFlags<QMessageBox::StandardButton> >(arg4).cref(), arg5, qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg6).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QMessageBox_Adaptor_13140 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMessageBox::QMessageBox(QMessageBox::Icon icon, const QString &title, const QString &text, QFlags<QMessageBox::StandardButton> buttons, QWidget *parent, QFlags<Qt::WindowType> flags)\nThis method creates an object of class QMessageBox.", &_init_ctor_QMessageBox_Adaptor_13140, &_call_ctor_QMessageBox_Adaptor_13140);
}

//  Constructor QMessageBox::QMessageBox(const QString &title, const QString &text, QMessageBox::Icon icon, int button0, int button1, int button2, QWidget *parent, QFlags<Qt::WindowType> f) (adaptor class)

static void _init_ctor_QMessageBox_Adaptor_11437 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("icon");
  decl->add_arg<const qt_gsi::Converter<QMessageBox::Icon>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("button0");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("button1");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("button2");
  decl->add_arg<int > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("f", true, "Qt::Dialog | Qt::MSWindowsFixedSizeDialogHint");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_7);
  decl->set_return_new<QMessageBox_Adaptor *> ();
}

static void _call_ctor_QMessageBox_Adaptor_11437 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  const qt_gsi::Converter<QMessageBox::Icon>::target_type & arg3 = args.read<const qt_gsi::Converter<QMessageBox::Icon>::target_type & > ();
  int arg4 = args.read<int > ();
  int arg5 = args.read<int > ();
  int arg6 = args.read<int > ();
  QWidget *arg7 = args ? args.read<QWidget * > () : (QWidget *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg8 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::WindowType> >(heap, Qt::Dialog | Qt::MSWindowsFixedSizeDialogHint));
  ret.write<QMessageBox_Adaptor *> (new QMessageBox_Adaptor (arg1, arg2, qt_gsi::QtToCppAdaptor<QMessageBox::Icon>(arg3).cref(), arg4, arg5, arg6, arg7, qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg8).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QMessageBox_Adaptor_11437 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMessageBox::QMessageBox(const QString &title, const QString &text, QMessageBox::Icon icon, int button0, int button1, int button2, QWidget *parent, QFlags<Qt::WindowType> f)\nThis method creates an object of class QMessageBox.", &_init_ctor_QMessageBox_Adaptor_11437, &_call_ctor_QMessageBox_Adaptor_11437);
}

// void QMessageBox::adjustPosition(QWidget *)

static void _init_fp_adjustPosition_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_adjustPosition_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QMessageBox_Adaptor *)cls)->fp_QMessageBox_adjustPosition_1315 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_adjustPosition_1315 ()
{
  return new qt_gsi::GenericMethod("*adjustPosition", "@brief Method void QMessageBox::adjustPosition(QWidget *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_adjustPosition_1315, &_call_fp_adjustPosition_1315);
}


// void QMessageBox::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QMessageBox_Adaptor *)cls)->fp_QMessageBox_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QMessageBox::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QMessageBox::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QMessageBox_Adaptor *)cls)->fp_QMessageBox_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QMessageBox::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// bool QMessageBox::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QMessageBox_Adaptor *)cls)->fp_QMessageBox_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QMessageBox::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QMessageBox::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QMessageBox_Adaptor *)cls)->fp_QMessageBox_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QMessageBox::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// int QMessageBox::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QMessageBox_Adaptor *)cls)->fp_QMessageBox_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QMessageBox::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QMessageBox::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMessageBox_Adaptor *)cls)->fp_QMessageBox_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QMessageBox::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// QObject *QMessageBox::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QMessageBox_Adaptor *)cls)->fp_QMessageBox_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QMessageBox::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QMessageBox::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMessageBox_Adaptor *)cls)->fp_QMessageBox_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QMessageBox::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// void QMessageBox::accept()

static void _init_cbs_accept_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_accept_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMessageBox_Adaptor *)cls)->cbs_accept_0_0 ();
}

static void _set_callback_cbs_accept_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_accept_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_accept_0_0 ()
{
  return new qt_gsi::GenericMethod ("accept", "@hide", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_accept_0_0 ()
{
  return new qt_gsi::GenericMethod ("accept", "@brief Virtual method void QMessageBox::accept()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0, &_set_callback_cbs_accept_0_0);
}


// void QMessageBox::done(int)

static void _init_cbs_done_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_done_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QMessageBox_Adaptor *)cls)->cbs_done_767_0 (arg1);
}

static void _set_callback_cbs_done_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_done_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_done_767_0 ()
{
  return new qt_gsi::GenericMethod ("done", "@hide", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_done_767_0 ()
{
  return new qt_gsi::GenericMethod ("done", "@brief Virtual method void QMessageBox::done(int)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0, &_set_callback_cbs_done_767_0);
}


// int QMessageBox::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QMessageBox_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QMessageBox::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// QVariant QMessageBox::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QMessageBox_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QMessageBox::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// QSize QMessageBox::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QMessageBox_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QMessageBox::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// QPaintEngine *QMessageBox::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QMessageBox_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QMessageBox::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QMessageBox::reject()

static void _init_cbs_reject_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reject_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMessageBox_Adaptor *)cls)->cbs_reject_0_0 ();
}

static void _set_callback_cbs_reject_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_reject_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_reject_0_0 ()
{
  return new qt_gsi::GenericMethod ("reject", "@hide", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_reject_0_0 ()
{
  return new qt_gsi::GenericMethod ("reject", "@brief Virtual method void QMessageBox::reject()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0, &_set_callback_cbs_reject_0_0);
}


// void QMessageBox::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMessageBox_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QMessageBox::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// QSize QMessageBox::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QMessageBox_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QMessageBox::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// void QMessageBox::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QMessageBox::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QMessageBox::changeEvent(QEvent *event)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QMessageBox::changeEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QMessageBox::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMessageBox::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QMessageBox::closeEvent(QCloseEvent *event)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QMessageBox::closeEvent(QCloseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QMessageBox::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QMessageBox::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QMessageBox::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMessageBox::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QMessageBox::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMessageBox::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QMessageBox::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QMessageBox::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QMessageBox::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QMessageBox::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QMessageBox::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QMessageBox::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// void QMessageBox::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QMessageBox::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// void QMessageBox::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMessageBox_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QMessageBox::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QMessageBox::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QMessageBox::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// bool QMessageBox::event(QEvent *e)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QMessageBox_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QMessageBox::event(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QMessageBox::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QMessageBox_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QMessageBox::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QMessageBox::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QMessageBox::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QMessageBox::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QMessageBox_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QMessageBox::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QMessageBox::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QMessageBox::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QMessageBox::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QMessageBox_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QMessageBox::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QMessageBox::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QMessageBox::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// void QMessageBox::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QMessageBox::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// void QMessageBox::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QMessageBox::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QMessageBox::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QMessageBox::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QMessageBox::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QMessageBox_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QMessageBox::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QMessageBox::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QMessageBox::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QMessageBox::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QMessageBox_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QMessageBox::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// void QMessageBox::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QMessageBox::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QMessageBox::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QMessageBox::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QMessageBox::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QMessageBox::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QMessageBox::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QMessageBox::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// void QMessageBox::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QMessageBox::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QMessageBox::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QMessageBox::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QMessageBox::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QMessageBox_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QMessageBox::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QMessageBox::resizeEvent(QResizeEvent *event)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QMessageBox::resizeEvent(QResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QMessageBox::showEvent(QShowEvent *event)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QMessageBox::showEvent(QShowEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// void QMessageBox::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QMessageBox_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QMessageBox::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// void QMessageBox::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QMessageBox::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QMessageBox::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMessageBox::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QMessageBox::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QMessageBox_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QMessageBox::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QMessageBox::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QMessageBox_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMessageBox_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QMessageBox::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QMessageBox> decl_QMessageBox;

gsi::Class<QMessageBox_Adaptor> decl_QMessageBox_Adaptor (decl_QMessageBox, "QMessageBox",
  gsi::Methods(_create_fp_adjustPosition_1315 ()) +
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_cbs_accept_0_0 ()) +
  gsi::Methods(_create_callback_cbs_accept_0_0 ()) +
  gsi::Methods(_create_cbs_done_767_0 ()) +
  gsi::Methods(_create_callback_cbs_done_767_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_reject_0_0 ()) +
  gsi::Methods(_create_callback_cbs_reject_0_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QMessageBox_Adaptor_1315 ()) +
  gsi::Methods(_create_ctor_QMessageBox_Adaptor_13140 ()) +
  gsi::Methods(_create_ctor_QMessageBox_Adaptor_11437 ()),
  "@qt\n@brief Binding of QMessageBox");

}


//  Implementation of the enum wrapper class for QMessageBox::ButtonRole
namespace qt_gsi
{

static QMessageBox_ButtonRole_Enum *c_1_QMessageBox_ButtonRole_Enum () { return new QMessageBox_ButtonRole_Enum (QMessageBox::InvalidRole); }
static QMessageBox_ButtonRole_Enum *c_2_QMessageBox_ButtonRole_Enum () { return new QMessageBox_ButtonRole_Enum (QMessageBox::AcceptRole); }
static QMessageBox_ButtonRole_Enum *c_3_QMessageBox_ButtonRole_Enum () { return new QMessageBox_ButtonRole_Enum (QMessageBox::RejectRole); }
static QMessageBox_ButtonRole_Enum *c_4_QMessageBox_ButtonRole_Enum () { return new QMessageBox_ButtonRole_Enum (QMessageBox::DestructiveRole); }
static QMessageBox_ButtonRole_Enum *c_5_QMessageBox_ButtonRole_Enum () { return new QMessageBox_ButtonRole_Enum (QMessageBox::ActionRole); }
static QMessageBox_ButtonRole_Enum *c_6_QMessageBox_ButtonRole_Enum () { return new QMessageBox_ButtonRole_Enum (QMessageBox::HelpRole); }
static QMessageBox_ButtonRole_Enum *c_7_QMessageBox_ButtonRole_Enum () { return new QMessageBox_ButtonRole_Enum (QMessageBox::YesRole); }
static QMessageBox_ButtonRole_Enum *c_8_QMessageBox_ButtonRole_Enum () { return new QMessageBox_ButtonRole_Enum (QMessageBox::NoRole); }
static QMessageBox_ButtonRole_Enum *c_9_QMessageBox_ButtonRole_Enum () { return new QMessageBox_ButtonRole_Enum (QMessageBox::ResetRole); }
static QMessageBox_ButtonRole_Enum *c_10_QMessageBox_ButtonRole_Enum () { return new QMessageBox_ButtonRole_Enum (QMessageBox::ApplyRole); }
static QMessageBox_ButtonRole_Enum *c_11_QMessageBox_ButtonRole_Enum () { return new QMessageBox_ButtonRole_Enum (QMessageBox::NRoles); }

static gsi::Methods mkdefs_QMessageBox_ButtonRole () {
  return
    gsi::constant ("InvalidRole", &qt_gsi::c_1_QMessageBox_ButtonRole_Enum, "@brief Enum constant QMessageBox::InvalidRole") +
    gsi::constant ("AcceptRole", &qt_gsi::c_2_QMessageBox_ButtonRole_Enum, "@brief Enum constant QMessageBox::AcceptRole") +
    gsi::constant ("RejectRole", &qt_gsi::c_3_QMessageBox_ButtonRole_Enum, "@brief Enum constant QMessageBox::RejectRole") +
    gsi::constant ("DestructiveRole", &qt_gsi::c_4_QMessageBox_ButtonRole_Enum, "@brief Enum constant QMessageBox::DestructiveRole") +
    gsi::constant ("ActionRole", &qt_gsi::c_5_QMessageBox_ButtonRole_Enum, "@brief Enum constant QMessageBox::ActionRole") +
    gsi::constant ("HelpRole", &qt_gsi::c_6_QMessageBox_ButtonRole_Enum, "@brief Enum constant QMessageBox::HelpRole") +
    gsi::constant ("YesRole", &qt_gsi::c_7_QMessageBox_ButtonRole_Enum, "@brief Enum constant QMessageBox::YesRole") +
    gsi::constant ("NoRole", &qt_gsi::c_8_QMessageBox_ButtonRole_Enum, "@brief Enum constant QMessageBox::NoRole") +
    gsi::constant ("ResetRole", &qt_gsi::c_9_QMessageBox_ButtonRole_Enum, "@brief Enum constant QMessageBox::ResetRole") +
    gsi::constant ("ApplyRole", &qt_gsi::c_10_QMessageBox_ButtonRole_Enum, "@brief Enum constant QMessageBox::ApplyRole") +
    gsi::constant ("NRoles", &qt_gsi::c_11_QMessageBox_ButtonRole_Enum, "@brief Enum constant QMessageBox::NRoles");
}

static std::string to_s_QMessageBox_ButtonRole_Enum (const QMessageBox_ButtonRole_Enum *e)
{
  if (e->value () == QMessageBox::InvalidRole) { return tl::sprintf ("InvalidRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::AcceptRole) { return tl::sprintf ("AcceptRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::RejectRole) { return tl::sprintf ("RejectRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::DestructiveRole) { return tl::sprintf ("DestructiveRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::ActionRole) { return tl::sprintf ("ActionRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::HelpRole) { return tl::sprintf ("HelpRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::YesRole) { return tl::sprintf ("YesRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::NoRole) { return tl::sprintf ("NoRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::ResetRole) { return tl::sprintf ("ResetRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::ApplyRole) { return tl::sprintf ("ApplyRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::NRoles) { return tl::sprintf ("NRoles (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QMessageBox_ButtonRole_Enum (const QMessageBox_ButtonRole_Enum *e)
{
  return (unsigned int) e->value ();
}

static QMessageBox_ButtonRole_Enum *from_i_QMessageBox_ButtonRole_Enum (unsigned int i)
{
  return new QMessageBox_ButtonRole_Enum ((QMessageBox::ButtonRole) i);
}

static bool equalQMessageBox_ButtonRole_Enum (const QMessageBox_ButtonRole_Enum *e, QMessageBox_ButtonRole_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QMessageBox_ButtonRole_Enum (const QMessageBox_ButtonRole_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QMessageBox_ButtonRole_Enums oropQMessageBox_ButtonRole_Enums (const QMessageBox_ButtonRole_Enums *e, const QMessageBox_ButtonRole_Enums &d)
{
  return e->flags () | d.flags ();
}

static QMessageBox_ButtonRole_Enums andopQMessageBox_ButtonRole_Enums (const QMessageBox_ButtonRole_Enums *e, const QMessageBox_ButtonRole_Enums &d)
{
  return e->flags () & d.flags ();
}

static QMessageBox_ButtonRole_Enums xoropQMessageBox_ButtonRole_Enums (const QMessageBox_ButtonRole_Enums *e, const QMessageBox_ButtonRole_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QMessageBox_ButtonRole_Enums (const QMessageBox_ButtonRole_Enums *e)
{
  std::string l;
  if (e->testFlag (QMessageBox::InvalidRole)) { if (!l.empty ()) l += "|"; l += "InvalidRole"; }
  if (e->testFlag (QMessageBox::AcceptRole)) { if (!l.empty ()) l += "|"; l += "AcceptRole"; }
  if (e->testFlag (QMessageBox::RejectRole)) { if (!l.empty ()) l += "|"; l += "RejectRole"; }
  if (e->testFlag (QMessageBox::DestructiveRole)) { if (!l.empty ()) l += "|"; l += "DestructiveRole"; }
  if (e->testFlag (QMessageBox::ActionRole)) { if (!l.empty ()) l += "|"; l += "ActionRole"; }
  if (e->testFlag (QMessageBox::HelpRole)) { if (!l.empty ()) l += "|"; l += "HelpRole"; }
  if (e->testFlag (QMessageBox::YesRole)) { if (!l.empty ()) l += "|"; l += "YesRole"; }
  if (e->testFlag (QMessageBox::NoRole)) { if (!l.empty ()) l += "|"; l += "NoRole"; }
  if (e->testFlag (QMessageBox::ResetRole)) { if (!l.empty ()) l += "|"; l += "ResetRole"; }
  if (e->testFlag (QMessageBox::ApplyRole)) { if (!l.empty ()) l += "|"; l += "ApplyRole"; }
  if (e->testFlag (QMessageBox::NRoles)) { if (!l.empty ()) l += "|"; l += "NRoles"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QMessageBox_ButtonRole_Enums (const QMessageBox_ButtonRole_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QMessageBox_ButtonRole_Enums (const QMessageBox_ButtonRole_Enums *e, const QMessageBox_ButtonRole_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QMessageBox_ButtonRole_Enums> decl_QMessageBox_ButtonRole_Enums ("QMessageBox_QFlags_ButtonRole",
  gsi::method_ext ("|", &qt_gsi::oropQMessageBox_ButtonRole_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQMessageBox_ButtonRole_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQMessageBox_ButtonRole_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QMessageBox_ButtonRole_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QMessageBox_ButtonRole_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QMessageBox_ButtonRole_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QMessageBox::ButtonRole> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QMessageBox_ButtonRole_Enum> decl_QMessageBox_ButtonRole_Enum (decl_QMessageBox_ButtonRole_Enums, "QMessageBox_ButtonRole",
  qt_gsi::mkdefs_QMessageBox_ButtonRole () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QMessageBox_ButtonRole_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QMessageBox_ButtonRole_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQMessageBox_ButtonRole_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QMessageBox_ButtonRole_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QMessageBox_ButtonRole_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QMessageBox::ButtonRole enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QMessageBox> inject_QMessageBox_ButtonRole_Enum_in_parent (qt_gsi::mkdefs_QMessageBox_ButtonRole ());
static gsi::ClassExt<QMessageBox> decl_QMessageBox_ButtonRole_Enum_as_child (decl_QMessageBox_ButtonRole_Enum, "ButtonRole");

}


//  Implementation of the enum wrapper class for QMessageBox::Icon
namespace qt_gsi
{

static QMessageBox_Icon_Enum *c_1_QMessageBox_Icon_Enum () { return new QMessageBox_Icon_Enum (QMessageBox::NoIcon); }
static QMessageBox_Icon_Enum *c_2_QMessageBox_Icon_Enum () { return new QMessageBox_Icon_Enum (QMessageBox::Information); }
static QMessageBox_Icon_Enum *c_3_QMessageBox_Icon_Enum () { return new QMessageBox_Icon_Enum (QMessageBox::Warning); }
static QMessageBox_Icon_Enum *c_4_QMessageBox_Icon_Enum () { return new QMessageBox_Icon_Enum (QMessageBox::Critical); }
static QMessageBox_Icon_Enum *c_5_QMessageBox_Icon_Enum () { return new QMessageBox_Icon_Enum (QMessageBox::Question); }

static gsi::Methods mkdefs_QMessageBox_Icon () {
  return
    gsi::constant ("NoIcon", &qt_gsi::c_1_QMessageBox_Icon_Enum, "@brief Enum constant QMessageBox::NoIcon") +
    gsi::constant ("Information", &qt_gsi::c_2_QMessageBox_Icon_Enum, "@brief Enum constant QMessageBox::Information") +
    gsi::constant ("Warning", &qt_gsi::c_3_QMessageBox_Icon_Enum, "@brief Enum constant QMessageBox::Warning") +
    gsi::constant ("Critical", &qt_gsi::c_4_QMessageBox_Icon_Enum, "@brief Enum constant QMessageBox::Critical") +
    gsi::constant ("Question", &qt_gsi::c_5_QMessageBox_Icon_Enum, "@brief Enum constant QMessageBox::Question");
}

static std::string to_s_QMessageBox_Icon_Enum (const QMessageBox_Icon_Enum *e)
{
  if (e->value () == QMessageBox::NoIcon) { return tl::sprintf ("NoIcon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::Information) { return tl::sprintf ("Information (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::Warning) { return tl::sprintf ("Warning (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::Critical) { return tl::sprintf ("Critical (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::Question) { return tl::sprintf ("Question (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QMessageBox_Icon_Enum (const QMessageBox_Icon_Enum *e)
{
  return (unsigned int) e->value ();
}

static QMessageBox_Icon_Enum *from_i_QMessageBox_Icon_Enum (unsigned int i)
{
  return new QMessageBox_Icon_Enum ((QMessageBox::Icon) i);
}

static bool equalQMessageBox_Icon_Enum (const QMessageBox_Icon_Enum *e, QMessageBox_Icon_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QMessageBox_Icon_Enum (const QMessageBox_Icon_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QMessageBox_Icon_Enums oropQMessageBox_Icon_Enums (const QMessageBox_Icon_Enums *e, const QMessageBox_Icon_Enums &d)
{
  return e->flags () | d.flags ();
}

static QMessageBox_Icon_Enums andopQMessageBox_Icon_Enums (const QMessageBox_Icon_Enums *e, const QMessageBox_Icon_Enums &d)
{
  return e->flags () & d.flags ();
}

static QMessageBox_Icon_Enums xoropQMessageBox_Icon_Enums (const QMessageBox_Icon_Enums *e, const QMessageBox_Icon_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QMessageBox_Icon_Enums (const QMessageBox_Icon_Enums *e)
{
  std::string l;
  if (e->testFlag (QMessageBox::NoIcon)) { if (!l.empty ()) l += "|"; l += "NoIcon"; }
  if (e->testFlag (QMessageBox::Information)) { if (!l.empty ()) l += "|"; l += "Information"; }
  if (e->testFlag (QMessageBox::Warning)) { if (!l.empty ()) l += "|"; l += "Warning"; }
  if (e->testFlag (QMessageBox::Critical)) { if (!l.empty ()) l += "|"; l += "Critical"; }
  if (e->testFlag (QMessageBox::Question)) { if (!l.empty ()) l += "|"; l += "Question"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QMessageBox_Icon_Enums (const QMessageBox_Icon_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QMessageBox_Icon_Enums (const QMessageBox_Icon_Enums *e, const QMessageBox_Icon_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QMessageBox_Icon_Enums> decl_QMessageBox_Icon_Enums ("QMessageBox_QFlags_Icon",
  gsi::method_ext ("|", &qt_gsi::oropQMessageBox_Icon_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQMessageBox_Icon_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQMessageBox_Icon_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QMessageBox_Icon_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QMessageBox_Icon_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QMessageBox_Icon_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QMessageBox::Icon> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QMessageBox_Icon_Enum> decl_QMessageBox_Icon_Enum (decl_QMessageBox_Icon_Enums, "QMessageBox_Icon",
  qt_gsi::mkdefs_QMessageBox_Icon () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QMessageBox_Icon_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QMessageBox_Icon_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQMessageBox_Icon_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QMessageBox_Icon_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QMessageBox_Icon_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QMessageBox::Icon enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QMessageBox> inject_QMessageBox_Icon_Enum_in_parent (qt_gsi::mkdefs_QMessageBox_Icon ());
static gsi::ClassExt<QMessageBox> decl_QMessageBox_Icon_Enum_as_child (decl_QMessageBox_Icon_Enum, "Icon");

}


//  Implementation of the enum wrapper class for QMessageBox::StandardButton
namespace qt_gsi
{

static QMessageBox_StandardButton_Enum *c_1_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::NoButton); }
static QMessageBox_StandardButton_Enum *c_2_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::Ok); }
static QMessageBox_StandardButton_Enum *c_3_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::Save); }
static QMessageBox_StandardButton_Enum *c_4_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::SaveAll); }
static QMessageBox_StandardButton_Enum *c_5_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::Open); }
static QMessageBox_StandardButton_Enum *c_6_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::Yes); }
static QMessageBox_StandardButton_Enum *c_7_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::YesToAll); }
static QMessageBox_StandardButton_Enum *c_8_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::No); }
static QMessageBox_StandardButton_Enum *c_9_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::NoToAll); }
static QMessageBox_StandardButton_Enum *c_10_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::Abort); }
static QMessageBox_StandardButton_Enum *c_11_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::Retry); }
static QMessageBox_StandardButton_Enum *c_12_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::Ignore); }
static QMessageBox_StandardButton_Enum *c_13_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::Close); }
static QMessageBox_StandardButton_Enum *c_14_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::Cancel); }
static QMessageBox_StandardButton_Enum *c_15_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::Discard); }
static QMessageBox_StandardButton_Enum *c_16_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::Help); }
static QMessageBox_StandardButton_Enum *c_17_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::Apply); }
static QMessageBox_StandardButton_Enum *c_18_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::Reset); }
static QMessageBox_StandardButton_Enum *c_19_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::RestoreDefaults); }
static QMessageBox_StandardButton_Enum *c_20_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::FirstButton); }
static QMessageBox_StandardButton_Enum *c_21_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::LastButton); }
static QMessageBox_StandardButton_Enum *c_22_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::YesAll); }
static QMessageBox_StandardButton_Enum *c_23_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::NoAll); }
static QMessageBox_StandardButton_Enum *c_24_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::Default); }
static QMessageBox_StandardButton_Enum *c_25_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::Escape); }
static QMessageBox_StandardButton_Enum *c_26_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::FlagMask); }
static QMessageBox_StandardButton_Enum *c_27_QMessageBox_StandardButton_Enum () { return new QMessageBox_StandardButton_Enum (QMessageBox::ButtonMask); }

static gsi::Methods mkdefs_QMessageBox_StandardButton () {
  return
    gsi::constant ("NoButton", &qt_gsi::c_1_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::NoButton") +
    gsi::constant ("Ok", &qt_gsi::c_2_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::Ok") +
    gsi::constant ("Save", &qt_gsi::c_3_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::Save") +
    gsi::constant ("SaveAll", &qt_gsi::c_4_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::SaveAll") +
    gsi::constant ("Open", &qt_gsi::c_5_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::Open") +
    gsi::constant ("Yes", &qt_gsi::c_6_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::Yes") +
    gsi::constant ("YesToAll", &qt_gsi::c_7_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::YesToAll") +
    gsi::constant ("No", &qt_gsi::c_8_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::No") +
    gsi::constant ("NoToAll", &qt_gsi::c_9_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::NoToAll") +
    gsi::constant ("Abort", &qt_gsi::c_10_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::Abort") +
    gsi::constant ("Retry", &qt_gsi::c_11_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::Retry") +
    gsi::constant ("Ignore", &qt_gsi::c_12_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::Ignore") +
    gsi::constant ("Close", &qt_gsi::c_13_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::Close") +
    gsi::constant ("Cancel", &qt_gsi::c_14_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::Cancel") +
    gsi::constant ("Discard", &qt_gsi::c_15_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::Discard") +
    gsi::constant ("Help", &qt_gsi::c_16_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::Help") +
    gsi::constant ("Apply", &qt_gsi::c_17_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::Apply") +
    gsi::constant ("Reset", &qt_gsi::c_18_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::Reset") +
    gsi::constant ("RestoreDefaults", &qt_gsi::c_19_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::RestoreDefaults") +
    gsi::constant ("FirstButton", &qt_gsi::c_20_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::FirstButton") +
    gsi::constant ("LastButton", &qt_gsi::c_21_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::LastButton") +
    gsi::constant ("YesAll", &qt_gsi::c_22_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::YesAll") +
    gsi::constant ("NoAll", &qt_gsi::c_23_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::NoAll") +
    gsi::constant ("Default", &qt_gsi::c_24_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::Default") +
    gsi::constant ("Escape", &qt_gsi::c_25_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::Escape") +
    gsi::constant ("FlagMask", &qt_gsi::c_26_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::FlagMask") +
    gsi::constant ("ButtonMask", &qt_gsi::c_27_QMessageBox_StandardButton_Enum, "@brief Enum constant QMessageBox::ButtonMask");
}

static std::string to_s_QMessageBox_StandardButton_Enum (const QMessageBox_StandardButton_Enum *e)
{
  if (e->value () == QMessageBox::NoButton) { return tl::sprintf ("NoButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::Ok) { return tl::sprintf ("Ok (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::Save) { return tl::sprintf ("Save (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::SaveAll) { return tl::sprintf ("SaveAll (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::Open) { return tl::sprintf ("Open (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::Yes) { return tl::sprintf ("Yes (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::YesToAll) { return tl::sprintf ("YesToAll (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::No) { return tl::sprintf ("No (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::NoToAll) { return tl::sprintf ("NoToAll (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::Abort) { return tl::sprintf ("Abort (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::Retry) { return tl::sprintf ("Retry (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::Ignore) { return tl::sprintf ("Ignore (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::Close) { return tl::sprintf ("Close (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::Cancel) { return tl::sprintf ("Cancel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::Discard) { return tl::sprintf ("Discard (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::Help) { return tl::sprintf ("Help (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::Apply) { return tl::sprintf ("Apply (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::Reset) { return tl::sprintf ("Reset (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::RestoreDefaults) { return tl::sprintf ("RestoreDefaults (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::FirstButton) { return tl::sprintf ("FirstButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::LastButton) { return tl::sprintf ("LastButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::YesAll) { return tl::sprintf ("YesAll (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::NoAll) { return tl::sprintf ("NoAll (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::Default) { return tl::sprintf ("Default (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::Escape) { return tl::sprintf ("Escape (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::FlagMask) { return tl::sprintf ("FlagMask (%u)", (unsigned int) e->value ()); }
  if (e->value () == QMessageBox::ButtonMask) { return tl::sprintf ("ButtonMask (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QMessageBox_StandardButton_Enum (const QMessageBox_StandardButton_Enum *e)
{
  return (unsigned int) e->value ();
}

static QMessageBox_StandardButton_Enum *from_i_QMessageBox_StandardButton_Enum (unsigned int i)
{
  return new QMessageBox_StandardButton_Enum ((QMessageBox::StandardButton) i);
}

static bool equalQMessageBox_StandardButton_Enum (const QMessageBox_StandardButton_Enum *e, QMessageBox_StandardButton_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QMessageBox_StandardButton_Enum (const QMessageBox_StandardButton_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QMessageBox_StandardButton_Enums oropQMessageBox_StandardButton_Enums (const QMessageBox_StandardButton_Enums *e, const QMessageBox_StandardButton_Enums &d)
{
  return e->flags () | d.flags ();
}

static QMessageBox_StandardButton_Enums andopQMessageBox_StandardButton_Enums (const QMessageBox_StandardButton_Enums *e, const QMessageBox_StandardButton_Enums &d)
{
  return e->flags () & d.flags ();
}

static QMessageBox_StandardButton_Enums xoropQMessageBox_StandardButton_Enums (const QMessageBox_StandardButton_Enums *e, const QMessageBox_StandardButton_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QMessageBox_StandardButton_Enums (const QMessageBox_StandardButton_Enums *e)
{
  std::string l;
  if (e->testFlag (QMessageBox::NoButton)) { if (!l.empty ()) l += "|"; l += "NoButton"; }
  if (e->testFlag (QMessageBox::Ok)) { if (!l.empty ()) l += "|"; l += "Ok"; }
  if (e->testFlag (QMessageBox::Save)) { if (!l.empty ()) l += "|"; l += "Save"; }
  if (e->testFlag (QMessageBox::SaveAll)) { if (!l.empty ()) l += "|"; l += "SaveAll"; }
  if (e->testFlag (QMessageBox::Open)) { if (!l.empty ()) l += "|"; l += "Open"; }
  if (e->testFlag (QMessageBox::Yes)) { if (!l.empty ()) l += "|"; l += "Yes"; }
  if (e->testFlag (QMessageBox::YesToAll)) { if (!l.empty ()) l += "|"; l += "YesToAll"; }
  if (e->testFlag (QMessageBox::No)) { if (!l.empty ()) l += "|"; l += "No"; }
  if (e->testFlag (QMessageBox::NoToAll)) { if (!l.empty ()) l += "|"; l += "NoToAll"; }
  if (e->testFlag (QMessageBox::Abort)) { if (!l.empty ()) l += "|"; l += "Abort"; }
  if (e->testFlag (QMessageBox::Retry)) { if (!l.empty ()) l += "|"; l += "Retry"; }
  if (e->testFlag (QMessageBox::Ignore)) { if (!l.empty ()) l += "|"; l += "Ignore"; }
  if (e->testFlag (QMessageBox::Close)) { if (!l.empty ()) l += "|"; l += "Close"; }
  if (e->testFlag (QMessageBox::Cancel)) { if (!l.empty ()) l += "|"; l += "Cancel"; }
  if (e->testFlag (QMessageBox::Discard)) { if (!l.empty ()) l += "|"; l += "Discard"; }
  if (e->testFlag (QMessageBox::Help)) { if (!l.empty ()) l += "|"; l += "Help"; }
  if (e->testFlag (QMessageBox::Apply)) { if (!l.empty ()) l += "|"; l += "Apply"; }
  if (e->testFlag (QMessageBox::Reset)) { if (!l.empty ()) l += "|"; l += "Reset"; }
  if (e->testFlag (QMessageBox::RestoreDefaults)) { if (!l.empty ()) l += "|"; l += "RestoreDefaults"; }
  if (e->testFlag (QMessageBox::FirstButton)) { if (!l.empty ()) l += "|"; l += "FirstButton"; }
  if (e->testFlag (QMessageBox::LastButton)) { if (!l.empty ()) l += "|"; l += "LastButton"; }
  if (e->testFlag (QMessageBox::YesAll)) { if (!l.empty ()) l += "|"; l += "YesAll"; }
  if (e->testFlag (QMessageBox::NoAll)) { if (!l.empty ()) l += "|"; l += "NoAll"; }
  if (e->testFlag (QMessageBox::Default)) { if (!l.empty ()) l += "|"; l += "Default"; }
  if (e->testFlag (QMessageBox::Escape)) { if (!l.empty ()) l += "|"; l += "Escape"; }
  if (e->testFlag (QMessageBox::FlagMask)) { if (!l.empty ()) l += "|"; l += "FlagMask"; }
  if (e->testFlag (QMessageBox::ButtonMask)) { if (!l.empty ()) l += "|"; l += "ButtonMask"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QMessageBox_StandardButton_Enums (const QMessageBox_StandardButton_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QMessageBox_StandardButton_Enums (const QMessageBox_StandardButton_Enums *e, const QMessageBox_StandardButton_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QMessageBox_StandardButton_Enums> decl_QMessageBox_StandardButton_Enums ("QMessageBox_QFlags_StandardButton",
  gsi::method_ext ("|", &qt_gsi::oropQMessageBox_StandardButton_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQMessageBox_StandardButton_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQMessageBox_StandardButton_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QMessageBox_StandardButton_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QMessageBox_StandardButton_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QMessageBox_StandardButton_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QMessageBox::StandardButton> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QMessageBox_StandardButton_Enum> decl_QMessageBox_StandardButton_Enum (decl_QMessageBox_StandardButton_Enums, "QMessageBox_StandardButton",
  qt_gsi::mkdefs_QMessageBox_StandardButton () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QMessageBox_StandardButton_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QMessageBox_StandardButton_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQMessageBox_StandardButton_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QMessageBox_StandardButton_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QMessageBox_StandardButton_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QMessageBox::StandardButton enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QMessageBox> inject_QMessageBox_StandardButton_Enum_in_parent (qt_gsi::mkdefs_QMessageBox_StandardButton ());
static gsi::ClassExt<QMessageBox> decl_QMessageBox_StandardButton_Enum_as_child (decl_QMessageBox_StandardButton_Enum, "StandardButton");

}

