
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQLocale.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQLocale_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QLocale

//  Constructor QLocale::QLocale()


static void _init_ctor_QLocale_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QLocale *> ();
}

static void _call_ctor_QLocale_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLocale *> (new QLocale ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QLocale_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLocale::QLocale()\nThis method creates an object of class QLocale.", &_init_ctor_QLocale_0, &_call_ctor_QLocale_0);
}

//  Constructor QLocale::QLocale(const QString &name)


static void _init_ctor_QLocale_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QLocale *> ();
}

static void _call_ctor_QLocale_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QLocale *> (new QLocale (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QLocale_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLocale::QLocale(const QString &name)\nThis method creates an object of class QLocale.", &_init_ctor_QLocale_2025, &_call_ctor_QLocale_2025);
}

//  Constructor QLocale::QLocale(QLocale::Language language, QLocale::Country country)


static void _init_ctor_QLocale_3902 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("language");
  decl->add_arg<const qt_gsi::Converter<QLocale::Language>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("country", true, "QLocale::AnyCountry");
  decl->add_arg<const qt_gsi::Converter<QLocale::Country>::target_type & > (argspec_1);
  decl->set_return_new<QLocale *> ();
}

static void _call_ctor_QLocale_3902 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QLocale::Language>::target_type & arg1 = args.read<const qt_gsi::Converter<QLocale::Language>::target_type & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::Country>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QLocale::Country>::target_type & > () : (const qt_gsi::Converter<QLocale::Country>::target_type &)(qt_gsi::CppToQtReadAdaptor<QLocale::Country>(heap, QLocale::AnyCountry));
  ret.write<QLocale *> (new QLocale (qt_gsi::QtToCppAdaptor<QLocale::Language>(arg1).cref(), qt_gsi::QtToCppAdaptor<QLocale::Country>(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QLocale_3902 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLocale::QLocale(QLocale::Language language, QLocale::Country country)\nThis method creates an object of class QLocale.", &_init_ctor_QLocale_3902, &_call_ctor_QLocale_3902);
}

//  Constructor QLocale::QLocale(const QLocale &other)


static void _init_ctor_QLocale_1986 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return_new<QLocale *> ();
}

static void _call_ctor_QLocale_1986 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLocale &arg1 = args.read<const QLocale & > ();
  ret.write<QLocale *> (new QLocale (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QLocale_1986 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLocale::QLocale(const QLocale &other)\nThis method creates an object of class QLocale.", &_init_ctor_QLocale_1986, &_call_ctor_QLocale_1986);
}

// QString QLocale::amText()


static void _init_f_amText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_amText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QLocale *)cls)->amText ());
}

static qt_gsi::GenericMethod *_create_f_amText_c0 ()
{
  return new qt_gsi::GenericMethod ("amText", "@brief Method QString QLocale::amText()\n", true, &_init_f_amText_c0, &_call_f_amText_c0);
}

// QLocale::Country QLocale::country()


static void _init_f_country_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QLocale::Country>::target_type > ();
}

static void _call_f_country_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QLocale::Country>::target_type > ((qt_gsi::Converter<QLocale::Country>::target_type)qt_gsi::CppToQtAdaptor<QLocale::Country>(((QLocale *)cls)->country ()));
}

static qt_gsi::GenericMethod *_create_f_country_c0 ()
{
  return new qt_gsi::GenericMethod ("country", "@brief Method QLocale::Country QLocale::country()\n", true, &_init_f_country_c0, &_call_f_country_c0);
}

// QString QLocale::dateFormat(QLocale::FormatType format)


static void _init_f_dateFormat_c2260 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_dateFormat_c2260 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<QLocale::FormatType>::target_type & > () : (const qt_gsi::Converter<QLocale::FormatType>::target_type &)(qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat));
  ret.write<QString > ((QString)((QLocale *)cls)->dateFormat (qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_dateFormat_c2260 ()
{
  return new qt_gsi::GenericMethod ("dateFormat", "@brief Method QString QLocale::dateFormat(QLocale::FormatType format)\n", true, &_init_f_dateFormat_c2260, &_call_f_dateFormat_c2260);
}

// QString QLocale::dateTimeFormat(QLocale::FormatType format)


static void _init_f_dateTimeFormat_c2260 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_dateTimeFormat_c2260 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<QLocale::FormatType>::target_type & > () : (const qt_gsi::Converter<QLocale::FormatType>::target_type &)(qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat));
  ret.write<QString > ((QString)((QLocale *)cls)->dateTimeFormat (qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_dateTimeFormat_c2260 ()
{
  return new qt_gsi::GenericMethod ("dateTimeFormat", "@brief Method QString QLocale::dateTimeFormat(QLocale::FormatType format)\n", true, &_init_f_dateTimeFormat_c2260, &_call_f_dateTimeFormat_c2260);
}

// QString QLocale::dayName(int, QLocale::FormatType format)


static void _init_f_dayName_c2919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_dayName_c2919 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QLocale::FormatType>::target_type & > () : (const qt_gsi::Converter<QLocale::FormatType>::target_type &)(qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat));
  ret.write<QString > ((QString)((QLocale *)cls)->dayName (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_dayName_c2919 ()
{
  return new qt_gsi::GenericMethod ("dayName", "@brief Method QString QLocale::dayName(int, QLocale::FormatType format)\n", true, &_init_f_dayName_c2919, &_call_f_dayName_c2919);
}

// QChar QLocale::decimalPoint()


static void _init_f_decimalPoint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_decimalPoint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->decimalPoint ()));
}

static qt_gsi::GenericMethod *_create_f_decimalPoint_c0 ()
{
  return new qt_gsi::GenericMethod ("decimalPoint", "@brief Method QChar QLocale::decimalPoint()\n", true, &_init_f_decimalPoint_c0, &_call_f_decimalPoint_c0);
}

// QChar QLocale::exponential()


static void _init_f_exponential_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_exponential_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->exponential ()));
}

static qt_gsi::GenericMethod *_create_f_exponential_c0 ()
{
  return new qt_gsi::GenericMethod ("exponential", "@brief Method QChar QLocale::exponential()\n", true, &_init_f_exponential_c0, &_call_f_exponential_c0);
}

// QChar QLocale::groupSeparator()


static void _init_f_groupSeparator_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_groupSeparator_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->groupSeparator ()));
}

static qt_gsi::GenericMethod *_create_f_groupSeparator_c0 ()
{
  return new qt_gsi::GenericMethod ("groupSeparator", "@brief Method QChar QLocale::groupSeparator()\n", true, &_init_f_groupSeparator_c0, &_call_f_groupSeparator_c0);
}

// QLocale::Language QLocale::language()


static void _init_f_language_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QLocale::Language>::target_type > ();
}

static void _call_f_language_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QLocale::Language>::target_type > ((qt_gsi::Converter<QLocale::Language>::target_type)qt_gsi::CppToQtAdaptor<QLocale::Language>(((QLocale *)cls)->language ()));
}

static qt_gsi::GenericMethod *_create_f_language_c0 ()
{
  return new qt_gsi::GenericMethod ("language", "@brief Method QLocale::Language QLocale::language()\n", true, &_init_f_language_c0, &_call_f_language_c0);
}

// QLocale::MeasurementSystem QLocale::measurementSystem()


static void _init_f_measurementSystem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QLocale::MeasurementSystem>::target_type > ();
}

static void _call_f_measurementSystem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QLocale::MeasurementSystem>::target_type > ((qt_gsi::Converter<QLocale::MeasurementSystem>::target_type)qt_gsi::CppToQtAdaptor<QLocale::MeasurementSystem>(((QLocale *)cls)->measurementSystem ()));
}

static qt_gsi::GenericMethod *_create_f_measurementSystem_c0 ()
{
  return new qt_gsi::GenericMethod ("measurementSystem", "@brief Method QLocale::MeasurementSystem QLocale::measurementSystem()\n", true, &_init_f_measurementSystem_c0, &_call_f_measurementSystem_c0);
}

// QString QLocale::monthName(int, QLocale::FormatType format)


static void _init_f_monthName_c2919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_monthName_c2919 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QLocale::FormatType>::target_type & > () : (const qt_gsi::Converter<QLocale::FormatType>::target_type &)(qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat));
  ret.write<QString > ((QString)((QLocale *)cls)->monthName (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_monthName_c2919 ()
{
  return new qt_gsi::GenericMethod ("monthName", "@brief Method QString QLocale::monthName(int, QLocale::FormatType format)\n", true, &_init_f_monthName_c2919, &_call_f_monthName_c2919);
}

// QString QLocale::name()


static void _init_f_name_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_name_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QLocale *)cls)->name ());
}

static qt_gsi::GenericMethod *_create_f_name_c0 ()
{
  return new qt_gsi::GenericMethod ("name", "@brief Method QString QLocale::name()\n", true, &_init_f_name_c0, &_call_f_name_c0);
}

// QChar QLocale::negativeSign()


static void _init_f_negativeSign_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_negativeSign_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->negativeSign ()));
}

static qt_gsi::GenericMethod *_create_f_negativeSign_c0 ()
{
  return new qt_gsi::GenericMethod ("negativeSign", "@brief Method QChar QLocale::negativeSign()\n", true, &_init_f_negativeSign_c0, &_call_f_negativeSign_c0);
}

// QFlags<QLocale::NumberOption> QLocale::numberOptions()


static void _init_f_numberOptions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QLocale::NumberOption> >::target_type > ();
}

static void _call_f_numberOptions_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QLocale::NumberOption> >::target_type > ((qt_gsi::Converter<QFlags<QLocale::NumberOption> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QLocale::NumberOption> >(((QLocale *)cls)->numberOptions ()));
}

static qt_gsi::GenericMethod *_create_f_numberOptions_c0 ()
{
  return new qt_gsi::GenericMethod (":numberOptions", "@brief Method QFlags<QLocale::NumberOption> QLocale::numberOptions()\n", true, &_init_f_numberOptions_c0, &_call_f_numberOptions_c0);
}

// bool QLocale::operator!=(const QLocale &other)


static void _init_f_operator_excl__eq__c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLocale &arg1 = args.read<const QLocale & > ();
  ret.write<bool > ((bool)((QLocale *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c1986 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QLocale::operator!=(const QLocale &other)\n", true, &_init_f_operator_excl__eq__c1986, &_call_f_operator_excl__eq__c1986);
}

// QLocale &QLocale::operator=(const QLocale &other)


static void _init_f_operator_eq__1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return<QLocale & > ();
}

static void _call_f_operator_eq__1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLocale &arg1 = args.read<const QLocale & > ();
  ret.write<QLocale & > ((QLocale &)((QLocale *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__1986 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QLocale &QLocale::operator=(const QLocale &other)\n", false, &_init_f_operator_eq__1986, &_call_f_operator_eq__1986);
}

// bool QLocale::operator==(const QLocale &other)


static void _init_f_operator_eq__eq__c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLocale &arg1 = args.read<const QLocale & > ();
  ret.write<bool > ((bool)((QLocale *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c1986 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QLocale::operator==(const QLocale &other)\n", true, &_init_f_operator_eq__eq__c1986, &_call_f_operator_eq__eq__c1986);
}

// QChar QLocale::percent()


static void _init_f_percent_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_percent_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->percent ()));
}

static qt_gsi::GenericMethod *_create_f_percent_c0 ()
{
  return new qt_gsi::GenericMethod ("percent", "@brief Method QChar QLocale::percent()\n", true, &_init_f_percent_c0, &_call_f_percent_c0);
}

// QString QLocale::pmText()


static void _init_f_pmText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_pmText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QLocale *)cls)->pmText ());
}

static qt_gsi::GenericMethod *_create_f_pmText_c0 ()
{
  return new qt_gsi::GenericMethod ("pmText", "@brief Method QString QLocale::pmText()\n", true, &_init_f_pmText_c0, &_call_f_pmText_c0);
}

// QChar QLocale::positiveSign()


static void _init_f_positiveSign_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_positiveSign_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->positiveSign ()));
}

static qt_gsi::GenericMethod *_create_f_positiveSign_c0 ()
{
  return new qt_gsi::GenericMethod ("positiveSign", "@brief Method QChar QLocale::positiveSign()\n", true, &_init_f_positiveSign_c0, &_call_f_positiveSign_c0);
}

// void QLocale::setNumberOptions(QFlags<QLocale::NumberOption> options)


static void _init_f_setNumberOptions_3171 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options");
  decl->add_arg<const qt_gsi::Converter<QFlags<QLocale::NumberOption> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNumberOptions_3171 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QLocale::NumberOption> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QLocale::NumberOption> >::target_type & > ();
  ((QLocale *)cls)->setNumberOptions (qt_gsi::QtToCppAdaptor<QFlags<QLocale::NumberOption> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setNumberOptions_3171 ()
{
  return new qt_gsi::GenericMethod ("setNumberOptions|numberOptions=", "@brief Method void QLocale::setNumberOptions(QFlags<QLocale::NumberOption> options)\n", false, &_init_f_setNumberOptions_3171, &_call_f_setNumberOptions_3171);
}

// QString QLocale::standaloneDayName(int, QLocale::FormatType format)


static void _init_f_standaloneDayName_c2919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_standaloneDayName_c2919 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QLocale::FormatType>::target_type & > () : (const qt_gsi::Converter<QLocale::FormatType>::target_type &)(qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat));
  ret.write<QString > ((QString)((QLocale *)cls)->standaloneDayName (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_standaloneDayName_c2919 ()
{
  return new qt_gsi::GenericMethod ("standaloneDayName", "@brief Method QString QLocale::standaloneDayName(int, QLocale::FormatType format)\n", true, &_init_f_standaloneDayName_c2919, &_call_f_standaloneDayName_c2919);
}

// QString QLocale::standaloneMonthName(int, QLocale::FormatType format)


static void _init_f_standaloneMonthName_c2919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_standaloneMonthName_c2919 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QLocale::FormatType>::target_type & > () : (const qt_gsi::Converter<QLocale::FormatType>::target_type &)(qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat));
  ret.write<QString > ((QString)((QLocale *)cls)->standaloneMonthName (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_standaloneMonthName_c2919 ()
{
  return new qt_gsi::GenericMethod ("standaloneMonthName", "@brief Method QString QLocale::standaloneMonthName(int, QLocale::FormatType format)\n", true, &_init_f_standaloneMonthName_c2919, &_call_f_standaloneMonthName_c2919);
}

// QString QLocale::timeFormat(QLocale::FormatType format)


static void _init_f_timeFormat_c2260 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_timeFormat_c2260 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<QLocale::FormatType>::target_type & > () : (const qt_gsi::Converter<QLocale::FormatType>::target_type &)(qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat));
  ret.write<QString > ((QString)((QLocale *)cls)->timeFormat (qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_timeFormat_c2260 ()
{
  return new qt_gsi::GenericMethod ("timeFormat", "@brief Method QString QLocale::timeFormat(QLocale::FormatType format)\n", true, &_init_f_timeFormat_c2260, &_call_f_timeFormat_c2260);
}

// QDate QLocale::toDate(const QString &string, QLocale::FormatType)


static void _init_f_toDate_c4177 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QDate > ();
}

static void _call_f_toDate_c4177 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QLocale::FormatType>::target_type & > () : (const qt_gsi::Converter<QLocale::FormatType>::target_type &)(qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat));
  ret.write<QDate > ((QDate)((QLocale *)cls)->toDate (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_toDate_c4177 ()
{
  return new qt_gsi::GenericMethod ("toDate", "@brief Method QDate QLocale::toDate(const QString &string, QLocale::FormatType)\n", true, &_init_f_toDate_c4177, &_call_f_toDate_c4177);
}

// QDate QLocale::toDate(const QString &string, const QString &format)


static void _init_f_toDate_c3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QDate > ();
}

static void _call_f_toDate_c3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<QDate > ((QDate)((QLocale *)cls)->toDate (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_toDate_c3942 ()
{
  return new qt_gsi::GenericMethod ("toDate", "@brief Method QDate QLocale::toDate(const QString &string, const QString &format)\n", true, &_init_f_toDate_c3942, &_call_f_toDate_c3942);
}

// QDateTime QLocale::toDateTime(const QString &string, QLocale::FormatType format)


static void _init_f_toDateTime_c4177 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QDateTime > ();
}

static void _call_f_toDateTime_c4177 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QLocale::FormatType>::target_type & > () : (const qt_gsi::Converter<QLocale::FormatType>::target_type &)(qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat));
  ret.write<QDateTime > ((QDateTime)((QLocale *)cls)->toDateTime (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_toDateTime_c4177 ()
{
  return new qt_gsi::GenericMethod ("toDateTime", "@brief Method QDateTime QLocale::toDateTime(const QString &string, QLocale::FormatType format)\n", true, &_init_f_toDateTime_c4177, &_call_f_toDateTime_c4177);
}

// QDateTime QLocale::toDateTime(const QString &string, const QString &format)


static void _init_f_toDateTime_c3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QDateTime > ();
}

static void _call_f_toDateTime_c3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<QDateTime > ((QDateTime)((QLocale *)cls)->toDateTime (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_toDateTime_c3942 ()
{
  return new qt_gsi::GenericMethod ("toDateTime", "@brief Method QDateTime QLocale::toDateTime(const QString &string, const QString &format)\n", true, &_init_f_toDateTime_c3942, &_call_f_toDateTime_c3942);
}

// double QLocale::toDouble(const QString &s, bool *ok)


static void _init_f_toDouble_c2967 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<double > ();
}

static void _call_f_toDouble_c2967 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  bool *arg2 = args ? args.read<bool * > () : (bool *)(0);
  ret.write<double > ((double)((QLocale *)cls)->toDouble (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_toDouble_c2967 ()
{
  return new qt_gsi::GenericMethod ("toDouble", "@brief Method double QLocale::toDouble(const QString &s, bool *ok)\n", true, &_init_f_toDouble_c2967, &_call_f_toDouble_c2967);
}

// float QLocale::toFloat(const QString &s, bool *ok)


static void _init_f_toFloat_c2967 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<float > ();
}

static void _call_f_toFloat_c2967 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  bool *arg2 = args ? args.read<bool * > () : (bool *)(0);
  ret.write<float > ((float)((QLocale *)cls)->toFloat (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_toFloat_c2967 ()
{
  return new qt_gsi::GenericMethod ("toFloat", "@brief Method float QLocale::toFloat(const QString &s, bool *ok)\n", true, &_init_f_toFloat_c2967, &_call_f_toFloat_c2967);
}

// int QLocale::toInt(const QString &s, bool *ok, int base)


static void _init_f_toInt_c3626 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("base", true, "0");
  decl->add_arg<int > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_toInt_c3626 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  bool *arg2 = args ? args.read<bool * > () : (bool *)(0);
  int arg3 = args ? args.read<int > () : (int)(0);
  ret.write<int > ((int)((QLocale *)cls)->toInt (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_toInt_c3626 ()
{
  return new qt_gsi::GenericMethod ("toInt", "@brief Method int QLocale::toInt(const QString &s, bool *ok, int base)\n", true, &_init_f_toInt_c3626, &_call_f_toInt_c3626);
}

// qlonglong QLocale::toLongLong(const QString &s, bool *ok, int base)


static void _init_f_toLongLong_c3626 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("base", true, "0");
  decl->add_arg<int > (argspec_2);
  decl->set_return<qlonglong > ();
}

static void _call_f_toLongLong_c3626 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  bool *arg2 = args ? args.read<bool * > () : (bool *)(0);
  int arg3 = args ? args.read<int > () : (int)(0);
  ret.write<qlonglong > ((qlonglong)((QLocale *)cls)->toLongLong (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_toLongLong_c3626 ()
{
  return new qt_gsi::GenericMethod ("toLongLong", "@brief Method qlonglong QLocale::toLongLong(const QString &s, bool *ok, int base)\n", true, &_init_f_toLongLong_c3626, &_call_f_toLongLong_c3626);
}

// short int QLocale::toShort(const QString &s, bool *ok, int base)


static void _init_f_toShort_c3626 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("base", true, "0");
  decl->add_arg<int > (argspec_2);
  decl->set_return<short int > ();
}

static void _call_f_toShort_c3626 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  bool *arg2 = args ? args.read<bool * > () : (bool *)(0);
  int arg3 = args ? args.read<int > () : (int)(0);
  ret.write<short int > ((short int)((QLocale *)cls)->toShort (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_toShort_c3626 ()
{
  return new qt_gsi::GenericMethod ("toShort", "@brief Method short int QLocale::toShort(const QString &s, bool *ok, int base)\n", true, &_init_f_toShort_c3626, &_call_f_toShort_c3626);
}

// QString QLocale::toString(qlonglong i)


static void _init_f_toString_c1413 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<qlonglong > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c1413 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qlonglong arg1 = args.read<qlonglong > ();
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1));
}

static qt_gsi::GenericMethod *_create_f_toString_c1413 ()
{
  return new qt_gsi::GenericMethod ("toString_ll", "@brief Method QString QLocale::toString(qlonglong i)\n", true, &_init_f_toString_c1413, &_call_f_toString_c1413);
}

// QString QLocale::toString(qulonglong i)


static void _init_f_toString_c1530 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<qulonglong > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c1530 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qulonglong arg1 = args.read<qulonglong > ();
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1));
}

static qt_gsi::GenericMethod *_create_f_toString_c1530 ()
{
  return new qt_gsi::GenericMethod ("toString_ull", "@brief Method QString QLocale::toString(qulonglong i)\n", true, &_init_f_toString_c1530, &_call_f_toString_c1530);
}

// QString QLocale::toString(short int i)


static void _init_f_toString_c1471 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<short int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c1471 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  short int arg1 = args.read<short int > ();
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1));
}

static qt_gsi::GenericMethod *_create_f_toString_c1471 ()
{
  return new qt_gsi::GenericMethod ("toString_s", "@brief Method QString QLocale::toString(short int i)\n", true, &_init_f_toString_c1471, &_call_f_toString_c1471);
}

// QString QLocale::toString(unsigned short int i)


static void _init_f_toString_c2476 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<unsigned short int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c2476 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned short int arg1 = args.read<unsigned short int > ();
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1));
}

static qt_gsi::GenericMethod *_create_f_toString_c2476 ()
{
  return new qt_gsi::GenericMethod ("toString_us", "@brief Method QString QLocale::toString(unsigned short int i)\n", true, &_init_f_toString_c2476, &_call_f_toString_c2476);
}

// QString QLocale::toString(int i)


static void _init_f_toString_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1));
}

static qt_gsi::GenericMethod *_create_f_toString_c767 ()
{
  return new qt_gsi::GenericMethod ("toString_i", "@brief Method QString QLocale::toString(int i)\n", true, &_init_f_toString_c767, &_call_f_toString_c767);
}

// QString QLocale::toString(unsigned int i)


static void _init_f_toString_c1772 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c1772 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1));
}

static qt_gsi::GenericMethod *_create_f_toString_c1772 ()
{
  return new qt_gsi::GenericMethod ("toString_ui", "@brief Method QString QLocale::toString(unsigned int i)\n", true, &_init_f_toString_c1772, &_call_f_toString_c1772);
}

// QString QLocale::toString(double i, char f, int prec)


static void _init_f_toString_c2472 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("f", true, "'g'");
  decl->add_arg<char > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("prec", true, "6");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_toString_c2472 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  char arg2 = args ? args.read<char > () : (char)('g');
  int arg3 = args ? args.read<int > () : (int)(6);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_toString_c2472 ()
{
  return new qt_gsi::GenericMethod ("toString_d", "@brief Method QString QLocale::toString(double i, char f, int prec)\n", true, &_init_f_toString_c2472, &_call_f_toString_c2472);
}

// QString QLocale::toString(float i, char f, int prec)


static void _init_f_toString_c2371 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<float > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("f", true, "'g'");
  decl->add_arg<char > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("prec", true, "6");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_toString_c2371 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  float arg1 = args.read<float > ();
  char arg2 = args ? args.read<char > () : (char)('g');
  int arg3 = args ? args.read<int > () : (int)(6);
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_toString_c2371 ()
{
  return new qt_gsi::GenericMethod ("toString_f", "@brief Method QString QLocale::toString(float i, char f, int prec)\n", true, &_init_f_toString_c2371, &_call_f_toString_c2371);
}

// QString QLocale::toString(const QDate &date, const QString &formatStr)


static void _init_f_toString_c3693 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<const QDate & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("formatStr");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c3693 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDate &arg1 = args.read<const QDate & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_toString_c3693 ()
{
  return new qt_gsi::GenericMethod ("toString", "@brief Method QString QLocale::toString(const QDate &date, const QString &formatStr)\n", true, &_init_f_toString_c3693, &_call_f_toString_c3693);
}

// QString QLocale::toString(const QDate &date, QLocale::FormatType format)


static void _init_f_toString_c3928 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<const QDate & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c3928 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDate &arg1 = args.read<const QDate & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QLocale::FormatType>::target_type & > () : (const qt_gsi::Converter<QLocale::FormatType>::target_type &)(qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat));
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_toString_c3928 ()
{
  return new qt_gsi::GenericMethod ("toString", "@brief Method QString QLocale::toString(const QDate &date, QLocale::FormatType format)\n", true, &_init_f_toString_c3928, &_call_f_toString_c3928);
}

// QString QLocale::toString(const QTime &time, const QString &formatStr)


static void _init_f_toString_c3710 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("time");
  decl->add_arg<const QTime & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("formatStr");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c3710 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTime &arg1 = args.read<const QTime & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_toString_c3710 ()
{
  return new qt_gsi::GenericMethod ("toString", "@brief Method QString QLocale::toString(const QTime &time, const QString &formatStr)\n", true, &_init_f_toString_c3710, &_call_f_toString_c3710);
}

// QString QLocale::toString(const QTime &time, QLocale::FormatType format)


static void _init_f_toString_c3945 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("time");
  decl->add_arg<const QTime & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c3945 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTime &arg1 = args.read<const QTime & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QLocale::FormatType>::target_type & > () : (const qt_gsi::Converter<QLocale::FormatType>::target_type &)(qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat));
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_toString_c3945 ()
{
  return new qt_gsi::GenericMethod ("toString", "@brief Method QString QLocale::toString(const QTime &time, QLocale::FormatType format)\n", true, &_init_f_toString_c3945, &_call_f_toString_c3945);
}

// QString QLocale::toString(const QDateTime &dateTime, QLocale::FormatType format)


static void _init_f_toString_c4327 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dateTime");
  decl->add_arg<const QDateTime & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c4327 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDateTime &arg1 = args.read<const QDateTime & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QLocale::FormatType>::target_type & > () : (const qt_gsi::Converter<QLocale::FormatType>::target_type &)(qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat));
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_toString_c4327 ()
{
  return new qt_gsi::GenericMethod ("toString", "@brief Method QString QLocale::toString(const QDateTime &dateTime, QLocale::FormatType format)\n", true, &_init_f_toString_c4327, &_call_f_toString_c4327);
}

// QString QLocale::toString(const QDateTime &dateTime, const QString &format)


static void _init_f_toString_c4092 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dateTime");
  decl->add_arg<const QDateTime & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c4092 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDateTime &arg1 = args.read<const QDateTime & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<QString > ((QString)((QLocale *)cls)->toString (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_toString_c4092 ()
{
  return new qt_gsi::GenericMethod ("toString", "@brief Method QString QLocale::toString(const QDateTime &dateTime, const QString &format)\n", true, &_init_f_toString_c4092, &_call_f_toString_c4092);
}

// QTime QLocale::toTime(const QString &string, QLocale::FormatType)


static void _init_f_toTime_c4177 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2", true, "QLocale::LongFormat");
  decl->add_arg<const qt_gsi::Converter<QLocale::FormatType>::target_type & > (argspec_1);
  decl->set_return<QTime > ();
}

static void _call_f_toTime_c4177 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QLocale::FormatType>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QLocale::FormatType>::target_type & > () : (const qt_gsi::Converter<QLocale::FormatType>::target_type &)(qt_gsi::CppToQtReadAdaptor<QLocale::FormatType>(heap, QLocale::LongFormat));
  ret.write<QTime > ((QTime)((QLocale *)cls)->toTime (arg1, qt_gsi::QtToCppAdaptor<QLocale::FormatType>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_toTime_c4177 ()
{
  return new qt_gsi::GenericMethod ("toTime", "@brief Method QTime QLocale::toTime(const QString &string, QLocale::FormatType)\n", true, &_init_f_toTime_c4177, &_call_f_toTime_c4177);
}

// QTime QLocale::toTime(const QString &string, const QString &format)


static void _init_f_toTime_c3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<QTime > ();
}

static void _call_f_toTime_c3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<QTime > ((QTime)((QLocale *)cls)->toTime (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_toTime_c3942 ()
{
  return new qt_gsi::GenericMethod ("toTime", "@brief Method QTime QLocale::toTime(const QString &string, const QString &format)\n", true, &_init_f_toTime_c3942, &_call_f_toTime_c3942);
}

// unsigned int QLocale::toUInt(const QString &s, bool *ok, int base)


static void _init_f_toUInt_c3626 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("base", true, "0");
  decl->add_arg<int > (argspec_2);
  decl->set_return<unsigned int > ();
}

static void _call_f_toUInt_c3626 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  bool *arg2 = args ? args.read<bool * > () : (bool *)(0);
  int arg3 = args ? args.read<int > () : (int)(0);
  ret.write<unsigned int > ((unsigned int)((QLocale *)cls)->toUInt (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_toUInt_c3626 ()
{
  return new qt_gsi::GenericMethod ("toUInt", "@brief Method unsigned int QLocale::toUInt(const QString &s, bool *ok, int base)\n", true, &_init_f_toUInt_c3626, &_call_f_toUInt_c3626);
}

// qlonglong QLocale::toULongLong(const QString &s, bool *ok, int base)


static void _init_f_toULongLong_c3626 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("base", true, "0");
  decl->add_arg<int > (argspec_2);
  decl->set_return<qlonglong > ();
}

static void _call_f_toULongLong_c3626 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  bool *arg2 = args ? args.read<bool * > () : (bool *)(0);
  int arg3 = args ? args.read<int > () : (int)(0);
  ret.write<qlonglong > ((qlonglong)((QLocale *)cls)->toULongLong (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_toULongLong_c3626 ()
{
  return new qt_gsi::GenericMethod ("toULongLong", "@brief Method qlonglong QLocale::toULongLong(const QString &s, bool *ok, int base)\n", true, &_init_f_toULongLong_c3626, &_call_f_toULongLong_c3626);
}

// unsigned short int QLocale::toUShort(const QString &s, bool *ok, int base)


static void _init_f_toUShort_c3626 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("base", true, "0");
  decl->add_arg<int > (argspec_2);
  decl->set_return<unsigned short int > ();
}

static void _call_f_toUShort_c3626 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  bool *arg2 = args ? args.read<bool * > () : (bool *)(0);
  int arg3 = args ? args.read<int > () : (int)(0);
  ret.write<unsigned short int > ((unsigned short int)((QLocale *)cls)->toUShort (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_toUShort_c3626 ()
{
  return new qt_gsi::GenericMethod ("toUShort", "@brief Method unsigned short int QLocale::toUShort(const QString &s, bool *ok, int base)\n", true, &_init_f_toUShort_c3626, &_call_f_toUShort_c3626);
}

// QChar QLocale::zeroDigit()


static void _init_f_zeroDigit_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_zeroDigit_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QLocale *)cls)->zeroDigit ()));
}

static qt_gsi::GenericMethod *_create_f_zeroDigit_c0 ()
{
  return new qt_gsi::GenericMethod ("zeroDigit", "@brief Method QChar QLocale::zeroDigit()\n", true, &_init_f_zeroDigit_c0, &_call_f_zeroDigit_c0);
}

// static QLocale QLocale::c()


static void _init_f_c_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QLocale > ();
}

static void _call_f_c_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLocale > ((QLocale)QLocale::c ());
}

static qt_gsi::GenericStaticMethod *_create_f_c_0 ()
{
  return new qt_gsi::GenericStaticMethod ("c", "@brief Static method QLocale QLocale::c()\nThis method is static and can be called without an instance.", &_init_f_c_0, &_call_f_c_0);
}

// static QList<QLocale::Country> QLocale::countriesForLanguage(QLocale::Language lang)


static void _init_f_countriesForLanguage_2029 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("lang");
  decl->add_arg<const qt_gsi::Converter<QLocale::Language>::target_type & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QList<QLocale::Country> >::target_type > ();
}

static void _call_f_countriesForLanguage_2029 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QLocale::Language>::target_type & arg1 = args.read<const qt_gsi::Converter<QLocale::Language>::target_type & > ();
  ret.write<qt_gsi::Converter<QList<QLocale::Country> >::target_type > ((qt_gsi::Converter<QList<QLocale::Country> >::target_type)qt_gsi::CppToQtAdaptor<QList<QLocale::Country> >(QLocale::countriesForLanguage (qt_gsi::QtToCppAdaptor<QLocale::Language>(arg1).cref())));
}

static qt_gsi::GenericStaticMethod *_create_f_countriesForLanguage_2029 ()
{
  return new qt_gsi::GenericStaticMethod ("countriesForLanguage", "@brief Static method QList<QLocale::Country> QLocale::countriesForLanguage(QLocale::Language lang)\nThis method is static and can be called without an instance.", &_init_f_countriesForLanguage_2029, &_call_f_countriesForLanguage_2029);
}

// static QString QLocale::countryToString(QLocale::Country country)


static void _init_f_countryToString_1981 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("country");
  decl->add_arg<const qt_gsi::Converter<QLocale::Country>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_countryToString_1981 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QLocale::Country>::target_type & arg1 = args.read<const qt_gsi::Converter<QLocale::Country>::target_type & > ();
  ret.write<QString > ((QString)QLocale::countryToString (qt_gsi::QtToCppAdaptor<QLocale::Country>(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_countryToString_1981 ()
{
  return new qt_gsi::GenericStaticMethod ("countryToString", "@brief Static method QString QLocale::countryToString(QLocale::Country country)\nThis method is static and can be called without an instance.", &_init_f_countryToString_1981, &_call_f_countryToString_1981);
}

// static QString QLocale::languageToString(QLocale::Language language)


static void _init_f_languageToString_2029 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("language");
  decl->add_arg<const qt_gsi::Converter<QLocale::Language>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_languageToString_2029 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QLocale::Language>::target_type & arg1 = args.read<const qt_gsi::Converter<QLocale::Language>::target_type & > ();
  ret.write<QString > ((QString)QLocale::languageToString (qt_gsi::QtToCppAdaptor<QLocale::Language>(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_languageToString_2029 ()
{
  return new qt_gsi::GenericStaticMethod ("languageToString", "@brief Static method QString QLocale::languageToString(QLocale::Language language)\nThis method is static and can be called without an instance.", &_init_f_languageToString_2029, &_call_f_languageToString_2029);
}

// static void QLocale::setDefault(const QLocale &locale)


static void _init_f_setDefault_1986 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("locale");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefault_1986 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLocale &arg1 = args.read<const QLocale & > ();
  QLocale::setDefault (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setDefault_1986 ()
{
  return new qt_gsi::GenericStaticMethod ("setDefault", "@brief Static method void QLocale::setDefault(const QLocale &locale)\nThis method is static and can be called without an instance.", &_init_f_setDefault_1986, &_call_f_setDefault_1986);
}

// static QLocale QLocale::system()


static void _init_f_system_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QLocale > ();
}

static void _call_f_system_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLocale > ((QLocale)QLocale::system ());
}

static qt_gsi::GenericStaticMethod *_create_f_system_0 ()
{
  return new qt_gsi::GenericStaticMethod ("system", "@brief Static method QLocale QLocale::system()\nThis method is static and can be called without an instance.", &_init_f_system_0, &_call_f_system_0);
}


namespace gsi
{
gsi::Class<QLocale> decl_QLocale ("QLocale",
  gsi::Methods(_create_ctor_QLocale_0 ()) +
  gsi::Methods(_create_ctor_QLocale_2025 ()) +
  gsi::Methods(_create_ctor_QLocale_3902 ()) +
  gsi::Methods(_create_ctor_QLocale_1986 ()) +
  gsi::Methods(_create_f_amText_c0 ()) +
  gsi::Methods(_create_f_country_c0 ()) +
  gsi::Methods(_create_f_dateFormat_c2260 ()) +
  gsi::Methods(_create_f_dateTimeFormat_c2260 ()) +
  gsi::Methods(_create_f_dayName_c2919 ()) +
  gsi::Methods(_create_f_decimalPoint_c0 ()) +
  gsi::Methods(_create_f_exponential_c0 ()) +
  gsi::Methods(_create_f_groupSeparator_c0 ()) +
  gsi::Methods(_create_f_language_c0 ()) +
  gsi::Methods(_create_f_measurementSystem_c0 ()) +
  gsi::Methods(_create_f_monthName_c2919 ()) +
  gsi::Methods(_create_f_name_c0 ()) +
  gsi::Methods(_create_f_negativeSign_c0 ()) +
  gsi::Methods(_create_f_numberOptions_c0 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c1986 ()) +
  gsi::Methods(_create_f_operator_eq__1986 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c1986 ()) +
  gsi::Methods(_create_f_percent_c0 ()) +
  gsi::Methods(_create_f_pmText_c0 ()) +
  gsi::Methods(_create_f_positiveSign_c0 ()) +
  gsi::Methods(_create_f_setNumberOptions_3171 ()) +
  gsi::Methods(_create_f_standaloneDayName_c2919 ()) +
  gsi::Methods(_create_f_standaloneMonthName_c2919 ()) +
  gsi::Methods(_create_f_timeFormat_c2260 ()) +
  gsi::Methods(_create_f_toDate_c4177 ()) +
  gsi::Methods(_create_f_toDate_c3942 ()) +
  gsi::Methods(_create_f_toDateTime_c4177 ()) +
  gsi::Methods(_create_f_toDateTime_c3942 ()) +
  gsi::Methods(_create_f_toDouble_c2967 ()) +
  gsi::Methods(_create_f_toFloat_c2967 ()) +
  gsi::Methods(_create_f_toInt_c3626 ()) +
  gsi::Methods(_create_f_toLongLong_c3626 ()) +
  gsi::Methods(_create_f_toShort_c3626 ()) +
  gsi::Methods(_create_f_toString_c1413 ()) +
  gsi::Methods(_create_f_toString_c1530 ()) +
  gsi::Methods(_create_f_toString_c1471 ()) +
  gsi::Methods(_create_f_toString_c2476 ()) +
  gsi::Methods(_create_f_toString_c767 ()) +
  gsi::Methods(_create_f_toString_c1772 ()) +
  gsi::Methods(_create_f_toString_c2472 ()) +
  gsi::Methods(_create_f_toString_c2371 ()) +
  gsi::Methods(_create_f_toString_c3693 ()) +
  gsi::Methods(_create_f_toString_c3928 ()) +
  gsi::Methods(_create_f_toString_c3710 ()) +
  gsi::Methods(_create_f_toString_c3945 ()) +
  gsi::Methods(_create_f_toString_c4327 ()) +
  gsi::Methods(_create_f_toString_c4092 ()) +
  gsi::Methods(_create_f_toTime_c4177 ()) +
  gsi::Methods(_create_f_toTime_c3942 ()) +
  gsi::Methods(_create_f_toUInt_c3626 ()) +
  gsi::Methods(_create_f_toULongLong_c3626 ()) +
  gsi::Methods(_create_f_toUShort_c3626 ()) +
  gsi::Methods(_create_f_zeroDigit_c0 ()) +
  gsi::Methods(_create_f_c_0 ()) +
  gsi::Methods(_create_f_countriesForLanguage_2029 ()) +
  gsi::Methods(_create_f_countryToString_1981 ()) +
  gsi::Methods(_create_f_languageToString_2029 ()) +
  gsi::Methods(_create_f_setDefault_1986 ()) +
  gsi::Methods(_create_f_system_0 ()),
  "@qt\n@brief Binding of QLocale");

}


//  Implementation of the enum wrapper class for QLocale::Country
namespace qt_gsi
{

static QLocale_Country_Enum *c_1_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::AnyCountry); }
static QLocale_Country_Enum *c_2_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Afghanistan); }
static QLocale_Country_Enum *c_3_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Albania); }
static QLocale_Country_Enum *c_4_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Algeria); }
static QLocale_Country_Enum *c_5_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::AmericanSamoa); }
static QLocale_Country_Enum *c_6_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Andorra); }
static QLocale_Country_Enum *c_7_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Angola); }
static QLocale_Country_Enum *c_8_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Anguilla); }
static QLocale_Country_Enum *c_9_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Antarctica); }
static QLocale_Country_Enum *c_10_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::AntiguaAndBarbuda); }
static QLocale_Country_Enum *c_11_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Argentina); }
static QLocale_Country_Enum *c_12_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Armenia); }
static QLocale_Country_Enum *c_13_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Aruba); }
static QLocale_Country_Enum *c_14_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Australia); }
static QLocale_Country_Enum *c_15_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Austria); }
static QLocale_Country_Enum *c_16_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Azerbaijan); }
static QLocale_Country_Enum *c_17_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Bahamas); }
static QLocale_Country_Enum *c_18_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Bahrain); }
static QLocale_Country_Enum *c_19_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Bangladesh); }
static QLocale_Country_Enum *c_20_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Barbados); }
static QLocale_Country_Enum *c_21_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Belarus); }
static QLocale_Country_Enum *c_22_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Belgium); }
static QLocale_Country_Enum *c_23_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Belize); }
static QLocale_Country_Enum *c_24_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Benin); }
static QLocale_Country_Enum *c_25_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Bermuda); }
static QLocale_Country_Enum *c_26_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Bhutan); }
static QLocale_Country_Enum *c_27_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Bolivia); }
static QLocale_Country_Enum *c_28_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::BosniaAndHerzegowina); }
static QLocale_Country_Enum *c_29_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Botswana); }
static QLocale_Country_Enum *c_30_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::BouvetIsland); }
static QLocale_Country_Enum *c_31_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Brazil); }
static QLocale_Country_Enum *c_32_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::BritishIndianOceanTerritory); }
static QLocale_Country_Enum *c_33_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::BruneiDarussalam); }
static QLocale_Country_Enum *c_34_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Bulgaria); }
static QLocale_Country_Enum *c_35_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::BurkinaFaso); }
static QLocale_Country_Enum *c_36_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Burundi); }
static QLocale_Country_Enum *c_37_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Cambodia); }
static QLocale_Country_Enum *c_38_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Cameroon); }
static QLocale_Country_Enum *c_39_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Canada); }
static QLocale_Country_Enum *c_40_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::CapeVerde); }
static QLocale_Country_Enum *c_41_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::CaymanIslands); }
static QLocale_Country_Enum *c_42_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::CentralAfricanRepublic); }
static QLocale_Country_Enum *c_43_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Chad); }
static QLocale_Country_Enum *c_44_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Chile); }
static QLocale_Country_Enum *c_45_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::China); }
static QLocale_Country_Enum *c_46_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::ChristmasIsland); }
static QLocale_Country_Enum *c_47_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::CocosIslands); }
static QLocale_Country_Enum *c_48_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Colombia); }
static QLocale_Country_Enum *c_49_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Comoros); }
static QLocale_Country_Enum *c_50_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::DemocraticRepublicOfCongo); }
static QLocale_Country_Enum *c_51_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::PeoplesRepublicOfCongo); }
static QLocale_Country_Enum *c_52_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::CookIslands); }
static QLocale_Country_Enum *c_53_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::CostaRica); }
static QLocale_Country_Enum *c_54_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::IvoryCoast); }
static QLocale_Country_Enum *c_55_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Croatia); }
static QLocale_Country_Enum *c_56_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Cuba); }
static QLocale_Country_Enum *c_57_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Cyprus); }
static QLocale_Country_Enum *c_58_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::CzechRepublic); }
static QLocale_Country_Enum *c_59_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Denmark); }
static QLocale_Country_Enum *c_60_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Djibouti); }
static QLocale_Country_Enum *c_61_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Dominica); }
static QLocale_Country_Enum *c_62_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::DominicanRepublic); }
static QLocale_Country_Enum *c_63_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::EastTimor); }
static QLocale_Country_Enum *c_64_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Ecuador); }
static QLocale_Country_Enum *c_65_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Egypt); }
static QLocale_Country_Enum *c_66_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::ElSalvador); }
static QLocale_Country_Enum *c_67_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::EquatorialGuinea); }
static QLocale_Country_Enum *c_68_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Eritrea); }
static QLocale_Country_Enum *c_69_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Estonia); }
static QLocale_Country_Enum *c_70_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Ethiopia); }
static QLocale_Country_Enum *c_71_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::FalklandIslands); }
static QLocale_Country_Enum *c_72_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::FaroeIslands); }
static QLocale_Country_Enum *c_73_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::FijiCountry); }
static QLocale_Country_Enum *c_74_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Finland); }
static QLocale_Country_Enum *c_75_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::France); }
static QLocale_Country_Enum *c_76_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::MetropolitanFrance); }
static QLocale_Country_Enum *c_77_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::FrenchGuiana); }
static QLocale_Country_Enum *c_78_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::FrenchPolynesia); }
static QLocale_Country_Enum *c_79_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::FrenchSouthernTerritories); }
static QLocale_Country_Enum *c_80_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Gabon); }
static QLocale_Country_Enum *c_81_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Gambia); }
static QLocale_Country_Enum *c_82_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Georgia); }
static QLocale_Country_Enum *c_83_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Germany); }
static QLocale_Country_Enum *c_84_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Ghana); }
static QLocale_Country_Enum *c_85_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Gibraltar); }
static QLocale_Country_Enum *c_86_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Greece); }
static QLocale_Country_Enum *c_87_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Greenland); }
static QLocale_Country_Enum *c_88_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Grenada); }
static QLocale_Country_Enum *c_89_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Guadeloupe); }
static QLocale_Country_Enum *c_90_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Guam); }
static QLocale_Country_Enum *c_91_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Guatemala); }
static QLocale_Country_Enum *c_92_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Guinea); }
static QLocale_Country_Enum *c_93_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::GuineaBissau); }
static QLocale_Country_Enum *c_94_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Guyana); }
static QLocale_Country_Enum *c_95_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Haiti); }
static QLocale_Country_Enum *c_96_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::HeardAndMcDonaldIslands); }
static QLocale_Country_Enum *c_97_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Honduras); }
static QLocale_Country_Enum *c_98_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::HongKong); }
static QLocale_Country_Enum *c_99_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Hungary); }
static QLocale_Country_Enum *c_100_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Iceland); }
static QLocale_Country_Enum *c_101_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::India); }
static QLocale_Country_Enum *c_102_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Indonesia); }
static QLocale_Country_Enum *c_103_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Iran); }
static QLocale_Country_Enum *c_104_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Iraq); }
static QLocale_Country_Enum *c_105_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Ireland); }
static QLocale_Country_Enum *c_106_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Israel); }
static QLocale_Country_Enum *c_107_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Italy); }
static QLocale_Country_Enum *c_108_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Jamaica); }
static QLocale_Country_Enum *c_109_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Japan); }
static QLocale_Country_Enum *c_110_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Jordan); }
static QLocale_Country_Enum *c_111_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Kazakhstan); }
static QLocale_Country_Enum *c_112_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Kenya); }
static QLocale_Country_Enum *c_113_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Kiribati); }
static QLocale_Country_Enum *c_114_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::DemocraticRepublicOfKorea); }
static QLocale_Country_Enum *c_115_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::RepublicOfKorea); }
static QLocale_Country_Enum *c_116_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Kuwait); }
static QLocale_Country_Enum *c_117_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Kyrgyzstan); }
static QLocale_Country_Enum *c_118_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Lao); }
static QLocale_Country_Enum *c_119_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Latvia); }
static QLocale_Country_Enum *c_120_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Lebanon); }
static QLocale_Country_Enum *c_121_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Lesotho); }
static QLocale_Country_Enum *c_122_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Liberia); }
static QLocale_Country_Enum *c_123_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::LibyanArabJamahiriya); }
static QLocale_Country_Enum *c_124_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Liechtenstein); }
static QLocale_Country_Enum *c_125_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Lithuania); }
static QLocale_Country_Enum *c_126_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Luxembourg); }
static QLocale_Country_Enum *c_127_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Macau); }
static QLocale_Country_Enum *c_128_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Macedonia); }
static QLocale_Country_Enum *c_129_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Madagascar); }
static QLocale_Country_Enum *c_130_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Malawi); }
static QLocale_Country_Enum *c_131_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Malaysia); }
static QLocale_Country_Enum *c_132_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Maldives); }
static QLocale_Country_Enum *c_133_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Mali); }
static QLocale_Country_Enum *c_134_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Malta); }
static QLocale_Country_Enum *c_135_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::MarshallIslands); }
static QLocale_Country_Enum *c_136_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Martinique); }
static QLocale_Country_Enum *c_137_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Mauritania); }
static QLocale_Country_Enum *c_138_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Mauritius); }
static QLocale_Country_Enum *c_139_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Mayotte); }
static QLocale_Country_Enum *c_140_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Mexico); }
static QLocale_Country_Enum *c_141_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Micronesia); }
static QLocale_Country_Enum *c_142_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Moldova); }
static QLocale_Country_Enum *c_143_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Monaco); }
static QLocale_Country_Enum *c_144_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Mongolia); }
static QLocale_Country_Enum *c_145_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Montserrat); }
static QLocale_Country_Enum *c_146_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Morocco); }
static QLocale_Country_Enum *c_147_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Mozambique); }
static QLocale_Country_Enum *c_148_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Myanmar); }
static QLocale_Country_Enum *c_149_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Namibia); }
static QLocale_Country_Enum *c_150_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::NauruCountry); }
static QLocale_Country_Enum *c_151_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Nepal); }
static QLocale_Country_Enum *c_152_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Netherlands); }
static QLocale_Country_Enum *c_153_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::NetherlandsAntilles); }
static QLocale_Country_Enum *c_154_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::NewCaledonia); }
static QLocale_Country_Enum *c_155_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::NewZealand); }
static QLocale_Country_Enum *c_156_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Nicaragua); }
static QLocale_Country_Enum *c_157_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Niger); }
static QLocale_Country_Enum *c_158_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Nigeria); }
static QLocale_Country_Enum *c_159_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Niue); }
static QLocale_Country_Enum *c_160_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::NorfolkIsland); }
static QLocale_Country_Enum *c_161_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::NorthernMarianaIslands); }
static QLocale_Country_Enum *c_162_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Norway); }
static QLocale_Country_Enum *c_163_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Oman); }
static QLocale_Country_Enum *c_164_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Pakistan); }
static QLocale_Country_Enum *c_165_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Palau); }
static QLocale_Country_Enum *c_166_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::PalestinianTerritory); }
static QLocale_Country_Enum *c_167_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Panama); }
static QLocale_Country_Enum *c_168_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::PapuaNewGuinea); }
static QLocale_Country_Enum *c_169_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Paraguay); }
static QLocale_Country_Enum *c_170_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Peru); }
static QLocale_Country_Enum *c_171_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Philippines); }
static QLocale_Country_Enum *c_172_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Pitcairn); }
static QLocale_Country_Enum *c_173_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Poland); }
static QLocale_Country_Enum *c_174_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Portugal); }
static QLocale_Country_Enum *c_175_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::PuertoRico); }
static QLocale_Country_Enum *c_176_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Qatar); }
static QLocale_Country_Enum *c_177_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Reunion); }
static QLocale_Country_Enum *c_178_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Romania); }
static QLocale_Country_Enum *c_179_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::RussianFederation); }
static QLocale_Country_Enum *c_180_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Rwanda); }
static QLocale_Country_Enum *c_181_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::SaintKittsAndNevis); }
static QLocale_Country_Enum *c_182_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::StLucia); }
static QLocale_Country_Enum *c_183_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::StVincentAndTheGrenadines); }
static QLocale_Country_Enum *c_184_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Samoa); }
static QLocale_Country_Enum *c_185_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::SanMarino); }
static QLocale_Country_Enum *c_186_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::SaoTomeAndPrincipe); }
static QLocale_Country_Enum *c_187_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::SaudiArabia); }
static QLocale_Country_Enum *c_188_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Senegal); }
static QLocale_Country_Enum *c_189_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Seychelles); }
static QLocale_Country_Enum *c_190_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::SierraLeone); }
static QLocale_Country_Enum *c_191_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Singapore); }
static QLocale_Country_Enum *c_192_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Slovakia); }
static QLocale_Country_Enum *c_193_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Slovenia); }
static QLocale_Country_Enum *c_194_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::SolomonIslands); }
static QLocale_Country_Enum *c_195_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Somalia); }
static QLocale_Country_Enum *c_196_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::SouthAfrica); }
static QLocale_Country_Enum *c_197_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::SouthGeorgiaAndTheSouthSandwichIslands); }
static QLocale_Country_Enum *c_198_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Spain); }
static QLocale_Country_Enum *c_199_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::SriLanka); }
static QLocale_Country_Enum *c_200_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::StHelena); }
static QLocale_Country_Enum *c_201_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::StPierreAndMiquelon); }
static QLocale_Country_Enum *c_202_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Sudan); }
static QLocale_Country_Enum *c_203_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Suriname); }
static QLocale_Country_Enum *c_204_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::SvalbardAndJanMayenIslands); }
static QLocale_Country_Enum *c_205_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Swaziland); }
static QLocale_Country_Enum *c_206_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Sweden); }
static QLocale_Country_Enum *c_207_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Switzerland); }
static QLocale_Country_Enum *c_208_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::SyrianArabRepublic); }
static QLocale_Country_Enum *c_209_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Taiwan); }
static QLocale_Country_Enum *c_210_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Tajikistan); }
static QLocale_Country_Enum *c_211_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Tanzania); }
static QLocale_Country_Enum *c_212_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Thailand); }
static QLocale_Country_Enum *c_213_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Togo); }
static QLocale_Country_Enum *c_214_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Tokelau); }
static QLocale_Country_Enum *c_215_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::TongaCountry); }
static QLocale_Country_Enum *c_216_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::TrinidadAndTobago); }
static QLocale_Country_Enum *c_217_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Tunisia); }
static QLocale_Country_Enum *c_218_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Turkey); }
static QLocale_Country_Enum *c_219_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Turkmenistan); }
static QLocale_Country_Enum *c_220_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::TurksAndCaicosIslands); }
static QLocale_Country_Enum *c_221_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Tuvalu); }
static QLocale_Country_Enum *c_222_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Uganda); }
static QLocale_Country_Enum *c_223_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Ukraine); }
static QLocale_Country_Enum *c_224_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::UnitedArabEmirates); }
static QLocale_Country_Enum *c_225_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::UnitedKingdom); }
static QLocale_Country_Enum *c_226_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::UnitedStates); }
static QLocale_Country_Enum *c_227_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::UnitedStatesMinorOutlyingIslands); }
static QLocale_Country_Enum *c_228_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Uruguay); }
static QLocale_Country_Enum *c_229_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Uzbekistan); }
static QLocale_Country_Enum *c_230_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Vanuatu); }
static QLocale_Country_Enum *c_231_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::VaticanCityState); }
static QLocale_Country_Enum *c_232_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Venezuela); }
static QLocale_Country_Enum *c_233_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::VietNam); }
static QLocale_Country_Enum *c_234_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::BritishVirginIslands); }
static QLocale_Country_Enum *c_235_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::USVirginIslands); }
static QLocale_Country_Enum *c_236_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::WallisAndFutunaIslands); }
static QLocale_Country_Enum *c_237_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::WesternSahara); }
static QLocale_Country_Enum *c_238_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Yemen); }
static QLocale_Country_Enum *c_239_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Yugoslavia); }
static QLocale_Country_Enum *c_240_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Zambia); }
static QLocale_Country_Enum *c_241_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::Zimbabwe); }
static QLocale_Country_Enum *c_242_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::SerbiaAndMontenegro); }
static QLocale_Country_Enum *c_243_QLocale_Country_Enum () { return new QLocale_Country_Enum (QLocale::LastCountry); }

static gsi::Methods mkdefs_QLocale_Country () {
  return
    gsi::constant ("AnyCountry", &qt_gsi::c_1_QLocale_Country_Enum, "@brief Enum constant QLocale::AnyCountry") +
    gsi::constant ("Afghanistan", &qt_gsi::c_2_QLocale_Country_Enum, "@brief Enum constant QLocale::Afghanistan") +
    gsi::constant ("Albania", &qt_gsi::c_3_QLocale_Country_Enum, "@brief Enum constant QLocale::Albania") +
    gsi::constant ("Algeria", &qt_gsi::c_4_QLocale_Country_Enum, "@brief Enum constant QLocale::Algeria") +
    gsi::constant ("AmericanSamoa", &qt_gsi::c_5_QLocale_Country_Enum, "@brief Enum constant QLocale::AmericanSamoa") +
    gsi::constant ("Andorra", &qt_gsi::c_6_QLocale_Country_Enum, "@brief Enum constant QLocale::Andorra") +
    gsi::constant ("Angola", &qt_gsi::c_7_QLocale_Country_Enum, "@brief Enum constant QLocale::Angola") +
    gsi::constant ("Anguilla", &qt_gsi::c_8_QLocale_Country_Enum, "@brief Enum constant QLocale::Anguilla") +
    gsi::constant ("Antarctica", &qt_gsi::c_9_QLocale_Country_Enum, "@brief Enum constant QLocale::Antarctica") +
    gsi::constant ("AntiguaAndBarbuda", &qt_gsi::c_10_QLocale_Country_Enum, "@brief Enum constant QLocale::AntiguaAndBarbuda") +
    gsi::constant ("Argentina", &qt_gsi::c_11_QLocale_Country_Enum, "@brief Enum constant QLocale::Argentina") +
    gsi::constant ("Armenia", &qt_gsi::c_12_QLocale_Country_Enum, "@brief Enum constant QLocale::Armenia") +
    gsi::constant ("Aruba", &qt_gsi::c_13_QLocale_Country_Enum, "@brief Enum constant QLocale::Aruba") +
    gsi::constant ("Australia", &qt_gsi::c_14_QLocale_Country_Enum, "@brief Enum constant QLocale::Australia") +
    gsi::constant ("Austria", &qt_gsi::c_15_QLocale_Country_Enum, "@brief Enum constant QLocale::Austria") +
    gsi::constant ("Azerbaijan", &qt_gsi::c_16_QLocale_Country_Enum, "@brief Enum constant QLocale::Azerbaijan") +
    gsi::constant ("Bahamas", &qt_gsi::c_17_QLocale_Country_Enum, "@brief Enum constant QLocale::Bahamas") +
    gsi::constant ("Bahrain", &qt_gsi::c_18_QLocale_Country_Enum, "@brief Enum constant QLocale::Bahrain") +
    gsi::constant ("Bangladesh", &qt_gsi::c_19_QLocale_Country_Enum, "@brief Enum constant QLocale::Bangladesh") +
    gsi::constant ("Barbados", &qt_gsi::c_20_QLocale_Country_Enum, "@brief Enum constant QLocale::Barbados") +
    gsi::constant ("Belarus", &qt_gsi::c_21_QLocale_Country_Enum, "@brief Enum constant QLocale::Belarus") +
    gsi::constant ("Belgium", &qt_gsi::c_22_QLocale_Country_Enum, "@brief Enum constant QLocale::Belgium") +
    gsi::constant ("Belize", &qt_gsi::c_23_QLocale_Country_Enum, "@brief Enum constant QLocale::Belize") +
    gsi::constant ("Benin", &qt_gsi::c_24_QLocale_Country_Enum, "@brief Enum constant QLocale::Benin") +
    gsi::constant ("Bermuda", &qt_gsi::c_25_QLocale_Country_Enum, "@brief Enum constant QLocale::Bermuda") +
    gsi::constant ("Bhutan", &qt_gsi::c_26_QLocale_Country_Enum, "@brief Enum constant QLocale::Bhutan") +
    gsi::constant ("Bolivia", &qt_gsi::c_27_QLocale_Country_Enum, "@brief Enum constant QLocale::Bolivia") +
    gsi::constant ("BosniaAndHerzegowina", &qt_gsi::c_28_QLocale_Country_Enum, "@brief Enum constant QLocale::BosniaAndHerzegowina") +
    gsi::constant ("Botswana", &qt_gsi::c_29_QLocale_Country_Enum, "@brief Enum constant QLocale::Botswana") +
    gsi::constant ("BouvetIsland", &qt_gsi::c_30_QLocale_Country_Enum, "@brief Enum constant QLocale::BouvetIsland") +
    gsi::constant ("Brazil", &qt_gsi::c_31_QLocale_Country_Enum, "@brief Enum constant QLocale::Brazil") +
    gsi::constant ("BritishIndianOceanTerritory", &qt_gsi::c_32_QLocale_Country_Enum, "@brief Enum constant QLocale::BritishIndianOceanTerritory") +
    gsi::constant ("BruneiDarussalam", &qt_gsi::c_33_QLocale_Country_Enum, "@brief Enum constant QLocale::BruneiDarussalam") +
    gsi::constant ("Bulgaria", &qt_gsi::c_34_QLocale_Country_Enum, "@brief Enum constant QLocale::Bulgaria") +
    gsi::constant ("BurkinaFaso", &qt_gsi::c_35_QLocale_Country_Enum, "@brief Enum constant QLocale::BurkinaFaso") +
    gsi::constant ("Burundi", &qt_gsi::c_36_QLocale_Country_Enum, "@brief Enum constant QLocale::Burundi") +
    gsi::constant ("Cambodia", &qt_gsi::c_37_QLocale_Country_Enum, "@brief Enum constant QLocale::Cambodia") +
    gsi::constant ("Cameroon", &qt_gsi::c_38_QLocale_Country_Enum, "@brief Enum constant QLocale::Cameroon") +
    gsi::constant ("Canada", &qt_gsi::c_39_QLocale_Country_Enum, "@brief Enum constant QLocale::Canada") +
    gsi::constant ("CapeVerde", &qt_gsi::c_40_QLocale_Country_Enum, "@brief Enum constant QLocale::CapeVerde") +
    gsi::constant ("CaymanIslands", &qt_gsi::c_41_QLocale_Country_Enum, "@brief Enum constant QLocale::CaymanIslands") +
    gsi::constant ("CentralAfricanRepublic", &qt_gsi::c_42_QLocale_Country_Enum, "@brief Enum constant QLocale::CentralAfricanRepublic") +
    gsi::constant ("Chad", &qt_gsi::c_43_QLocale_Country_Enum, "@brief Enum constant QLocale::Chad") +
    gsi::constant ("Chile", &qt_gsi::c_44_QLocale_Country_Enum, "@brief Enum constant QLocale::Chile") +
    gsi::constant ("China", &qt_gsi::c_45_QLocale_Country_Enum, "@brief Enum constant QLocale::China") +
    gsi::constant ("ChristmasIsland", &qt_gsi::c_46_QLocale_Country_Enum, "@brief Enum constant QLocale::ChristmasIsland") +
    gsi::constant ("CocosIslands", &qt_gsi::c_47_QLocale_Country_Enum, "@brief Enum constant QLocale::CocosIslands") +
    gsi::constant ("Colombia", &qt_gsi::c_48_QLocale_Country_Enum, "@brief Enum constant QLocale::Colombia") +
    gsi::constant ("Comoros", &qt_gsi::c_49_QLocale_Country_Enum, "@brief Enum constant QLocale::Comoros") +
    gsi::constant ("DemocraticRepublicOfCongo", &qt_gsi::c_50_QLocale_Country_Enum, "@brief Enum constant QLocale::DemocraticRepublicOfCongo") +
    gsi::constant ("PeoplesRepublicOfCongo", &qt_gsi::c_51_QLocale_Country_Enum, "@brief Enum constant QLocale::PeoplesRepublicOfCongo") +
    gsi::constant ("CookIslands", &qt_gsi::c_52_QLocale_Country_Enum, "@brief Enum constant QLocale::CookIslands") +
    gsi::constant ("CostaRica", &qt_gsi::c_53_QLocale_Country_Enum, "@brief Enum constant QLocale::CostaRica") +
    gsi::constant ("IvoryCoast", &qt_gsi::c_54_QLocale_Country_Enum, "@brief Enum constant QLocale::IvoryCoast") +
    gsi::constant ("Croatia", &qt_gsi::c_55_QLocale_Country_Enum, "@brief Enum constant QLocale::Croatia") +
    gsi::constant ("Cuba", &qt_gsi::c_56_QLocale_Country_Enum, "@brief Enum constant QLocale::Cuba") +
    gsi::constant ("Cyprus", &qt_gsi::c_57_QLocale_Country_Enum, "@brief Enum constant QLocale::Cyprus") +
    gsi::constant ("CzechRepublic", &qt_gsi::c_58_QLocale_Country_Enum, "@brief Enum constant QLocale::CzechRepublic") +
    gsi::constant ("Denmark", &qt_gsi::c_59_QLocale_Country_Enum, "@brief Enum constant QLocale::Denmark") +
    gsi::constant ("Djibouti", &qt_gsi::c_60_QLocale_Country_Enum, "@brief Enum constant QLocale::Djibouti") +
    gsi::constant ("Dominica", &qt_gsi::c_61_QLocale_Country_Enum, "@brief Enum constant QLocale::Dominica") +
    gsi::constant ("DominicanRepublic", &qt_gsi::c_62_QLocale_Country_Enum, "@brief Enum constant QLocale::DominicanRepublic") +
    gsi::constant ("EastTimor", &qt_gsi::c_63_QLocale_Country_Enum, "@brief Enum constant QLocale::EastTimor") +
    gsi::constant ("Ecuador", &qt_gsi::c_64_QLocale_Country_Enum, "@brief Enum constant QLocale::Ecuador") +
    gsi::constant ("Egypt", &qt_gsi::c_65_QLocale_Country_Enum, "@brief Enum constant QLocale::Egypt") +
    gsi::constant ("ElSalvador", &qt_gsi::c_66_QLocale_Country_Enum, "@brief Enum constant QLocale::ElSalvador") +
    gsi::constant ("EquatorialGuinea", &qt_gsi::c_67_QLocale_Country_Enum, "@brief Enum constant QLocale::EquatorialGuinea") +
    gsi::constant ("Eritrea", &qt_gsi::c_68_QLocale_Country_Enum, "@brief Enum constant QLocale::Eritrea") +
    gsi::constant ("Estonia", &qt_gsi::c_69_QLocale_Country_Enum, "@brief Enum constant QLocale::Estonia") +
    gsi::constant ("Ethiopia", &qt_gsi::c_70_QLocale_Country_Enum, "@brief Enum constant QLocale::Ethiopia") +
    gsi::constant ("FalklandIslands", &qt_gsi::c_71_QLocale_Country_Enum, "@brief Enum constant QLocale::FalklandIslands") +
    gsi::constant ("FaroeIslands", &qt_gsi::c_72_QLocale_Country_Enum, "@brief Enum constant QLocale::FaroeIslands") +
    gsi::constant ("FijiCountry", &qt_gsi::c_73_QLocale_Country_Enum, "@brief Enum constant QLocale::FijiCountry") +
    gsi::constant ("Finland", &qt_gsi::c_74_QLocale_Country_Enum, "@brief Enum constant QLocale::Finland") +
    gsi::constant ("France", &qt_gsi::c_75_QLocale_Country_Enum, "@brief Enum constant QLocale::France") +
    gsi::constant ("MetropolitanFrance", &qt_gsi::c_76_QLocale_Country_Enum, "@brief Enum constant QLocale::MetropolitanFrance") +
    gsi::constant ("FrenchGuiana", &qt_gsi::c_77_QLocale_Country_Enum, "@brief Enum constant QLocale::FrenchGuiana") +
    gsi::constant ("FrenchPolynesia", &qt_gsi::c_78_QLocale_Country_Enum, "@brief Enum constant QLocale::FrenchPolynesia") +
    gsi::constant ("FrenchSouthernTerritories", &qt_gsi::c_79_QLocale_Country_Enum, "@brief Enum constant QLocale::FrenchSouthernTerritories") +
    gsi::constant ("Gabon", &qt_gsi::c_80_QLocale_Country_Enum, "@brief Enum constant QLocale::Gabon") +
    gsi::constant ("Gambia", &qt_gsi::c_81_QLocale_Country_Enum, "@brief Enum constant QLocale::Gambia") +
    gsi::constant ("Georgia", &qt_gsi::c_82_QLocale_Country_Enum, "@brief Enum constant QLocale::Georgia") +
    gsi::constant ("Germany", &qt_gsi::c_83_QLocale_Country_Enum, "@brief Enum constant QLocale::Germany") +
    gsi::constant ("Ghana", &qt_gsi::c_84_QLocale_Country_Enum, "@brief Enum constant QLocale::Ghana") +
    gsi::constant ("Gibraltar", &qt_gsi::c_85_QLocale_Country_Enum, "@brief Enum constant QLocale::Gibraltar") +
    gsi::constant ("Greece", &qt_gsi::c_86_QLocale_Country_Enum, "@brief Enum constant QLocale::Greece") +
    gsi::constant ("Greenland", &qt_gsi::c_87_QLocale_Country_Enum, "@brief Enum constant QLocale::Greenland") +
    gsi::constant ("Grenada", &qt_gsi::c_88_QLocale_Country_Enum, "@brief Enum constant QLocale::Grenada") +
    gsi::constant ("Guadeloupe", &qt_gsi::c_89_QLocale_Country_Enum, "@brief Enum constant QLocale::Guadeloupe") +
    gsi::constant ("Guam", &qt_gsi::c_90_QLocale_Country_Enum, "@brief Enum constant QLocale::Guam") +
    gsi::constant ("Guatemala", &qt_gsi::c_91_QLocale_Country_Enum, "@brief Enum constant QLocale::Guatemala") +
    gsi::constant ("Guinea", &qt_gsi::c_92_QLocale_Country_Enum, "@brief Enum constant QLocale::Guinea") +
    gsi::constant ("GuineaBissau", &qt_gsi::c_93_QLocale_Country_Enum, "@brief Enum constant QLocale::GuineaBissau") +
    gsi::constant ("Guyana", &qt_gsi::c_94_QLocale_Country_Enum, "@brief Enum constant QLocale::Guyana") +
    gsi::constant ("Haiti", &qt_gsi::c_95_QLocale_Country_Enum, "@brief Enum constant QLocale::Haiti") +
    gsi::constant ("HeardAndMcDonaldIslands", &qt_gsi::c_96_QLocale_Country_Enum, "@brief Enum constant QLocale::HeardAndMcDonaldIslands") +
    gsi::constant ("Honduras", &qt_gsi::c_97_QLocale_Country_Enum, "@brief Enum constant QLocale::Honduras") +
    gsi::constant ("HongKong", &qt_gsi::c_98_QLocale_Country_Enum, "@brief Enum constant QLocale::HongKong") +
    gsi::constant ("Hungary", &qt_gsi::c_99_QLocale_Country_Enum, "@brief Enum constant QLocale::Hungary") +
    gsi::constant ("Iceland", &qt_gsi::c_100_QLocale_Country_Enum, "@brief Enum constant QLocale::Iceland") +
    gsi::constant ("India", &qt_gsi::c_101_QLocale_Country_Enum, "@brief Enum constant QLocale::India") +
    gsi::constant ("Indonesia", &qt_gsi::c_102_QLocale_Country_Enum, "@brief Enum constant QLocale::Indonesia") +
    gsi::constant ("Iran", &qt_gsi::c_103_QLocale_Country_Enum, "@brief Enum constant QLocale::Iran") +
    gsi::constant ("Iraq", &qt_gsi::c_104_QLocale_Country_Enum, "@brief Enum constant QLocale::Iraq") +
    gsi::constant ("Ireland", &qt_gsi::c_105_QLocale_Country_Enum, "@brief Enum constant QLocale::Ireland") +
    gsi::constant ("Israel", &qt_gsi::c_106_QLocale_Country_Enum, "@brief Enum constant QLocale::Israel") +
    gsi::constant ("Italy", &qt_gsi::c_107_QLocale_Country_Enum, "@brief Enum constant QLocale::Italy") +
    gsi::constant ("Jamaica", &qt_gsi::c_108_QLocale_Country_Enum, "@brief Enum constant QLocale::Jamaica") +
    gsi::constant ("Japan", &qt_gsi::c_109_QLocale_Country_Enum, "@brief Enum constant QLocale::Japan") +
    gsi::constant ("Jordan", &qt_gsi::c_110_QLocale_Country_Enum, "@brief Enum constant QLocale::Jordan") +
    gsi::constant ("Kazakhstan", &qt_gsi::c_111_QLocale_Country_Enum, "@brief Enum constant QLocale::Kazakhstan") +
    gsi::constant ("Kenya", &qt_gsi::c_112_QLocale_Country_Enum, "@brief Enum constant QLocale::Kenya") +
    gsi::constant ("Kiribati", &qt_gsi::c_113_QLocale_Country_Enum, "@brief Enum constant QLocale::Kiribati") +
    gsi::constant ("DemocraticRepublicOfKorea", &qt_gsi::c_114_QLocale_Country_Enum, "@brief Enum constant QLocale::DemocraticRepublicOfKorea") +
    gsi::constant ("RepublicOfKorea", &qt_gsi::c_115_QLocale_Country_Enum, "@brief Enum constant QLocale::RepublicOfKorea") +
    gsi::constant ("Kuwait", &qt_gsi::c_116_QLocale_Country_Enum, "@brief Enum constant QLocale::Kuwait") +
    gsi::constant ("Kyrgyzstan", &qt_gsi::c_117_QLocale_Country_Enum, "@brief Enum constant QLocale::Kyrgyzstan") +
    gsi::constant ("Lao", &qt_gsi::c_118_QLocale_Country_Enum, "@brief Enum constant QLocale::Lao") +
    gsi::constant ("Latvia", &qt_gsi::c_119_QLocale_Country_Enum, "@brief Enum constant QLocale::Latvia") +
    gsi::constant ("Lebanon", &qt_gsi::c_120_QLocale_Country_Enum, "@brief Enum constant QLocale::Lebanon") +
    gsi::constant ("Lesotho", &qt_gsi::c_121_QLocale_Country_Enum, "@brief Enum constant QLocale::Lesotho") +
    gsi::constant ("Liberia", &qt_gsi::c_122_QLocale_Country_Enum, "@brief Enum constant QLocale::Liberia") +
    gsi::constant ("LibyanArabJamahiriya", &qt_gsi::c_123_QLocale_Country_Enum, "@brief Enum constant QLocale::LibyanArabJamahiriya") +
    gsi::constant ("Liechtenstein", &qt_gsi::c_124_QLocale_Country_Enum, "@brief Enum constant QLocale::Liechtenstein") +
    gsi::constant ("Lithuania", &qt_gsi::c_125_QLocale_Country_Enum, "@brief Enum constant QLocale::Lithuania") +
    gsi::constant ("Luxembourg", &qt_gsi::c_126_QLocale_Country_Enum, "@brief Enum constant QLocale::Luxembourg") +
    gsi::constant ("Macau", &qt_gsi::c_127_QLocale_Country_Enum, "@brief Enum constant QLocale::Macau") +
    gsi::constant ("Macedonia", &qt_gsi::c_128_QLocale_Country_Enum, "@brief Enum constant QLocale::Macedonia") +
    gsi::constant ("Madagascar", &qt_gsi::c_129_QLocale_Country_Enum, "@brief Enum constant QLocale::Madagascar") +
    gsi::constant ("Malawi", &qt_gsi::c_130_QLocale_Country_Enum, "@brief Enum constant QLocale::Malawi") +
    gsi::constant ("Malaysia", &qt_gsi::c_131_QLocale_Country_Enum, "@brief Enum constant QLocale::Malaysia") +
    gsi::constant ("Maldives", &qt_gsi::c_132_QLocale_Country_Enum, "@brief Enum constant QLocale::Maldives") +
    gsi::constant ("Mali", &qt_gsi::c_133_QLocale_Country_Enum, "@brief Enum constant QLocale::Mali") +
    gsi::constant ("Malta", &qt_gsi::c_134_QLocale_Country_Enum, "@brief Enum constant QLocale::Malta") +
    gsi::constant ("MarshallIslands", &qt_gsi::c_135_QLocale_Country_Enum, "@brief Enum constant QLocale::MarshallIslands") +
    gsi::constant ("Martinique", &qt_gsi::c_136_QLocale_Country_Enum, "@brief Enum constant QLocale::Martinique") +
    gsi::constant ("Mauritania", &qt_gsi::c_137_QLocale_Country_Enum, "@brief Enum constant QLocale::Mauritania") +
    gsi::constant ("Mauritius", &qt_gsi::c_138_QLocale_Country_Enum, "@brief Enum constant QLocale::Mauritius") +
    gsi::constant ("Mayotte", &qt_gsi::c_139_QLocale_Country_Enum, "@brief Enum constant QLocale::Mayotte") +
    gsi::constant ("Mexico", &qt_gsi::c_140_QLocale_Country_Enum, "@brief Enum constant QLocale::Mexico") +
    gsi::constant ("Micronesia", &qt_gsi::c_141_QLocale_Country_Enum, "@brief Enum constant QLocale::Micronesia") +
    gsi::constant ("Moldova", &qt_gsi::c_142_QLocale_Country_Enum, "@brief Enum constant QLocale::Moldova") +
    gsi::constant ("Monaco", &qt_gsi::c_143_QLocale_Country_Enum, "@brief Enum constant QLocale::Monaco") +
    gsi::constant ("Mongolia", &qt_gsi::c_144_QLocale_Country_Enum, "@brief Enum constant QLocale::Mongolia") +
    gsi::constant ("Montserrat", &qt_gsi::c_145_QLocale_Country_Enum, "@brief Enum constant QLocale::Montserrat") +
    gsi::constant ("Morocco", &qt_gsi::c_146_QLocale_Country_Enum, "@brief Enum constant QLocale::Morocco") +
    gsi::constant ("Mozambique", &qt_gsi::c_147_QLocale_Country_Enum, "@brief Enum constant QLocale::Mozambique") +
    gsi::constant ("Myanmar", &qt_gsi::c_148_QLocale_Country_Enum, "@brief Enum constant QLocale::Myanmar") +
    gsi::constant ("Namibia", &qt_gsi::c_149_QLocale_Country_Enum, "@brief Enum constant QLocale::Namibia") +
    gsi::constant ("NauruCountry", &qt_gsi::c_150_QLocale_Country_Enum, "@brief Enum constant QLocale::NauruCountry") +
    gsi::constant ("Nepal", &qt_gsi::c_151_QLocale_Country_Enum, "@brief Enum constant QLocale::Nepal") +
    gsi::constant ("Netherlands", &qt_gsi::c_152_QLocale_Country_Enum, "@brief Enum constant QLocale::Netherlands") +
    gsi::constant ("NetherlandsAntilles", &qt_gsi::c_153_QLocale_Country_Enum, "@brief Enum constant QLocale::NetherlandsAntilles") +
    gsi::constant ("NewCaledonia", &qt_gsi::c_154_QLocale_Country_Enum, "@brief Enum constant QLocale::NewCaledonia") +
    gsi::constant ("NewZealand", &qt_gsi::c_155_QLocale_Country_Enum, "@brief Enum constant QLocale::NewZealand") +
    gsi::constant ("Nicaragua", &qt_gsi::c_156_QLocale_Country_Enum, "@brief Enum constant QLocale::Nicaragua") +
    gsi::constant ("Niger", &qt_gsi::c_157_QLocale_Country_Enum, "@brief Enum constant QLocale::Niger") +
    gsi::constant ("Nigeria", &qt_gsi::c_158_QLocale_Country_Enum, "@brief Enum constant QLocale::Nigeria") +
    gsi::constant ("Niue", &qt_gsi::c_159_QLocale_Country_Enum, "@brief Enum constant QLocale::Niue") +
    gsi::constant ("NorfolkIsland", &qt_gsi::c_160_QLocale_Country_Enum, "@brief Enum constant QLocale::NorfolkIsland") +
    gsi::constant ("NorthernMarianaIslands", &qt_gsi::c_161_QLocale_Country_Enum, "@brief Enum constant QLocale::NorthernMarianaIslands") +
    gsi::constant ("Norway", &qt_gsi::c_162_QLocale_Country_Enum, "@brief Enum constant QLocale::Norway") +
    gsi::constant ("Oman", &qt_gsi::c_163_QLocale_Country_Enum, "@brief Enum constant QLocale::Oman") +
    gsi::constant ("Pakistan", &qt_gsi::c_164_QLocale_Country_Enum, "@brief Enum constant QLocale::Pakistan") +
    gsi::constant ("Palau", &qt_gsi::c_165_QLocale_Country_Enum, "@brief Enum constant QLocale::Palau") +
    gsi::constant ("PalestinianTerritory", &qt_gsi::c_166_QLocale_Country_Enum, "@brief Enum constant QLocale::PalestinianTerritory") +
    gsi::constant ("Panama", &qt_gsi::c_167_QLocale_Country_Enum, "@brief Enum constant QLocale::Panama") +
    gsi::constant ("PapuaNewGuinea", &qt_gsi::c_168_QLocale_Country_Enum, "@brief Enum constant QLocale::PapuaNewGuinea") +
    gsi::constant ("Paraguay", &qt_gsi::c_169_QLocale_Country_Enum, "@brief Enum constant QLocale::Paraguay") +
    gsi::constant ("Peru", &qt_gsi::c_170_QLocale_Country_Enum, "@brief Enum constant QLocale::Peru") +
    gsi::constant ("Philippines", &qt_gsi::c_171_QLocale_Country_Enum, "@brief Enum constant QLocale::Philippines") +
    gsi::constant ("Pitcairn", &qt_gsi::c_172_QLocale_Country_Enum, "@brief Enum constant QLocale::Pitcairn") +
    gsi::constant ("Poland", &qt_gsi::c_173_QLocale_Country_Enum, "@brief Enum constant QLocale::Poland") +
    gsi::constant ("Portugal", &qt_gsi::c_174_QLocale_Country_Enum, "@brief Enum constant QLocale::Portugal") +
    gsi::constant ("PuertoRico", &qt_gsi::c_175_QLocale_Country_Enum, "@brief Enum constant QLocale::PuertoRico") +
    gsi::constant ("Qatar", &qt_gsi::c_176_QLocale_Country_Enum, "@brief Enum constant QLocale::Qatar") +
    gsi::constant ("Reunion", &qt_gsi::c_177_QLocale_Country_Enum, "@brief Enum constant QLocale::Reunion") +
    gsi::constant ("Romania", &qt_gsi::c_178_QLocale_Country_Enum, "@brief Enum constant QLocale::Romania") +
    gsi::constant ("RussianFederation", &qt_gsi::c_179_QLocale_Country_Enum, "@brief Enum constant QLocale::RussianFederation") +
    gsi::constant ("Rwanda", &qt_gsi::c_180_QLocale_Country_Enum, "@brief Enum constant QLocale::Rwanda") +
    gsi::constant ("SaintKittsAndNevis", &qt_gsi::c_181_QLocale_Country_Enum, "@brief Enum constant QLocale::SaintKittsAndNevis") +
    gsi::constant ("StLucia", &qt_gsi::c_182_QLocale_Country_Enum, "@brief Enum constant QLocale::StLucia") +
    gsi::constant ("StVincentAndTheGrenadines", &qt_gsi::c_183_QLocale_Country_Enum, "@brief Enum constant QLocale::StVincentAndTheGrenadines") +
    gsi::constant ("Samoa", &qt_gsi::c_184_QLocale_Country_Enum, "@brief Enum constant QLocale::Samoa") +
    gsi::constant ("SanMarino", &qt_gsi::c_185_QLocale_Country_Enum, "@brief Enum constant QLocale::SanMarino") +
    gsi::constant ("SaoTomeAndPrincipe", &qt_gsi::c_186_QLocale_Country_Enum, "@brief Enum constant QLocale::SaoTomeAndPrincipe") +
    gsi::constant ("SaudiArabia", &qt_gsi::c_187_QLocale_Country_Enum, "@brief Enum constant QLocale::SaudiArabia") +
    gsi::constant ("Senegal", &qt_gsi::c_188_QLocale_Country_Enum, "@brief Enum constant QLocale::Senegal") +
    gsi::constant ("Seychelles", &qt_gsi::c_189_QLocale_Country_Enum, "@brief Enum constant QLocale::Seychelles") +
    gsi::constant ("SierraLeone", &qt_gsi::c_190_QLocale_Country_Enum, "@brief Enum constant QLocale::SierraLeone") +
    gsi::constant ("Singapore", &qt_gsi::c_191_QLocale_Country_Enum, "@brief Enum constant QLocale::Singapore") +
    gsi::constant ("Slovakia", &qt_gsi::c_192_QLocale_Country_Enum, "@brief Enum constant QLocale::Slovakia") +
    gsi::constant ("Slovenia", &qt_gsi::c_193_QLocale_Country_Enum, "@brief Enum constant QLocale::Slovenia") +
    gsi::constant ("SolomonIslands", &qt_gsi::c_194_QLocale_Country_Enum, "@brief Enum constant QLocale::SolomonIslands") +
    gsi::constant ("Somalia", &qt_gsi::c_195_QLocale_Country_Enum, "@brief Enum constant QLocale::Somalia") +
    gsi::constant ("SouthAfrica", &qt_gsi::c_196_QLocale_Country_Enum, "@brief Enum constant QLocale::SouthAfrica") +
    gsi::constant ("SouthGeorgiaAndTheSouthSandwichIslands", &qt_gsi::c_197_QLocale_Country_Enum, "@brief Enum constant QLocale::SouthGeorgiaAndTheSouthSandwichIslands") +
    gsi::constant ("Spain", &qt_gsi::c_198_QLocale_Country_Enum, "@brief Enum constant QLocale::Spain") +
    gsi::constant ("SriLanka", &qt_gsi::c_199_QLocale_Country_Enum, "@brief Enum constant QLocale::SriLanka") +
    gsi::constant ("StHelena", &qt_gsi::c_200_QLocale_Country_Enum, "@brief Enum constant QLocale::StHelena") +
    gsi::constant ("StPierreAndMiquelon", &qt_gsi::c_201_QLocale_Country_Enum, "@brief Enum constant QLocale::StPierreAndMiquelon") +
    gsi::constant ("Sudan", &qt_gsi::c_202_QLocale_Country_Enum, "@brief Enum constant QLocale::Sudan") +
    gsi::constant ("Suriname", &qt_gsi::c_203_QLocale_Country_Enum, "@brief Enum constant QLocale::Suriname") +
    gsi::constant ("SvalbardAndJanMayenIslands", &qt_gsi::c_204_QLocale_Country_Enum, "@brief Enum constant QLocale::SvalbardAndJanMayenIslands") +
    gsi::constant ("Swaziland", &qt_gsi::c_205_QLocale_Country_Enum, "@brief Enum constant QLocale::Swaziland") +
    gsi::constant ("Sweden", &qt_gsi::c_206_QLocale_Country_Enum, "@brief Enum constant QLocale::Sweden") +
    gsi::constant ("Switzerland", &qt_gsi::c_207_QLocale_Country_Enum, "@brief Enum constant QLocale::Switzerland") +
    gsi::constant ("SyrianArabRepublic", &qt_gsi::c_208_QLocale_Country_Enum, "@brief Enum constant QLocale::SyrianArabRepublic") +
    gsi::constant ("Taiwan", &qt_gsi::c_209_QLocale_Country_Enum, "@brief Enum constant QLocale::Taiwan") +
    gsi::constant ("Tajikistan", &qt_gsi::c_210_QLocale_Country_Enum, "@brief Enum constant QLocale::Tajikistan") +
    gsi::constant ("Tanzania", &qt_gsi::c_211_QLocale_Country_Enum, "@brief Enum constant QLocale::Tanzania") +
    gsi::constant ("Thailand", &qt_gsi::c_212_QLocale_Country_Enum, "@brief Enum constant QLocale::Thailand") +
    gsi::constant ("Togo", &qt_gsi::c_213_QLocale_Country_Enum, "@brief Enum constant QLocale::Togo") +
    gsi::constant ("Tokelau", &qt_gsi::c_214_QLocale_Country_Enum, "@brief Enum constant QLocale::Tokelau") +
    gsi::constant ("TongaCountry", &qt_gsi::c_215_QLocale_Country_Enum, "@brief Enum constant QLocale::TongaCountry") +
    gsi::constant ("TrinidadAndTobago", &qt_gsi::c_216_QLocale_Country_Enum, "@brief Enum constant QLocale::TrinidadAndTobago") +
    gsi::constant ("Tunisia", &qt_gsi::c_217_QLocale_Country_Enum, "@brief Enum constant QLocale::Tunisia") +
    gsi::constant ("Turkey", &qt_gsi::c_218_QLocale_Country_Enum, "@brief Enum constant QLocale::Turkey") +
    gsi::constant ("Turkmenistan", &qt_gsi::c_219_QLocale_Country_Enum, "@brief Enum constant QLocale::Turkmenistan") +
    gsi::constant ("TurksAndCaicosIslands", &qt_gsi::c_220_QLocale_Country_Enum, "@brief Enum constant QLocale::TurksAndCaicosIslands") +
    gsi::constant ("Tuvalu", &qt_gsi::c_221_QLocale_Country_Enum, "@brief Enum constant QLocale::Tuvalu") +
    gsi::constant ("Uganda", &qt_gsi::c_222_QLocale_Country_Enum, "@brief Enum constant QLocale::Uganda") +
    gsi::constant ("Ukraine", &qt_gsi::c_223_QLocale_Country_Enum, "@brief Enum constant QLocale::Ukraine") +
    gsi::constant ("UnitedArabEmirates", &qt_gsi::c_224_QLocale_Country_Enum, "@brief Enum constant QLocale::UnitedArabEmirates") +
    gsi::constant ("UnitedKingdom", &qt_gsi::c_225_QLocale_Country_Enum, "@brief Enum constant QLocale::UnitedKingdom") +
    gsi::constant ("UnitedStates", &qt_gsi::c_226_QLocale_Country_Enum, "@brief Enum constant QLocale::UnitedStates") +
    gsi::constant ("UnitedStatesMinorOutlyingIslands", &qt_gsi::c_227_QLocale_Country_Enum, "@brief Enum constant QLocale::UnitedStatesMinorOutlyingIslands") +
    gsi::constant ("Uruguay", &qt_gsi::c_228_QLocale_Country_Enum, "@brief Enum constant QLocale::Uruguay") +
    gsi::constant ("Uzbekistan", &qt_gsi::c_229_QLocale_Country_Enum, "@brief Enum constant QLocale::Uzbekistan") +
    gsi::constant ("Vanuatu", &qt_gsi::c_230_QLocale_Country_Enum, "@brief Enum constant QLocale::Vanuatu") +
    gsi::constant ("VaticanCityState", &qt_gsi::c_231_QLocale_Country_Enum, "@brief Enum constant QLocale::VaticanCityState") +
    gsi::constant ("Venezuela", &qt_gsi::c_232_QLocale_Country_Enum, "@brief Enum constant QLocale::Venezuela") +
    gsi::constant ("VietNam", &qt_gsi::c_233_QLocale_Country_Enum, "@brief Enum constant QLocale::VietNam") +
    gsi::constant ("BritishVirginIslands", &qt_gsi::c_234_QLocale_Country_Enum, "@brief Enum constant QLocale::BritishVirginIslands") +
    gsi::constant ("USVirginIslands", &qt_gsi::c_235_QLocale_Country_Enum, "@brief Enum constant QLocale::USVirginIslands") +
    gsi::constant ("WallisAndFutunaIslands", &qt_gsi::c_236_QLocale_Country_Enum, "@brief Enum constant QLocale::WallisAndFutunaIslands") +
    gsi::constant ("WesternSahara", &qt_gsi::c_237_QLocale_Country_Enum, "@brief Enum constant QLocale::WesternSahara") +
    gsi::constant ("Yemen", &qt_gsi::c_238_QLocale_Country_Enum, "@brief Enum constant QLocale::Yemen") +
    gsi::constant ("Yugoslavia", &qt_gsi::c_239_QLocale_Country_Enum, "@brief Enum constant QLocale::Yugoslavia") +
    gsi::constant ("Zambia", &qt_gsi::c_240_QLocale_Country_Enum, "@brief Enum constant QLocale::Zambia") +
    gsi::constant ("Zimbabwe", &qt_gsi::c_241_QLocale_Country_Enum, "@brief Enum constant QLocale::Zimbabwe") +
    gsi::constant ("SerbiaAndMontenegro", &qt_gsi::c_242_QLocale_Country_Enum, "@brief Enum constant QLocale::SerbiaAndMontenegro") +
    gsi::constant ("LastCountry", &qt_gsi::c_243_QLocale_Country_Enum, "@brief Enum constant QLocale::LastCountry");
}

static std::string to_s_QLocale_Country_Enum (const QLocale_Country_Enum *e)
{
  if (e->value () == QLocale::AnyCountry) { return tl::sprintf ("AnyCountry (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Afghanistan) { return tl::sprintf ("Afghanistan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Albania) { return tl::sprintf ("Albania (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Algeria) { return tl::sprintf ("Algeria (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::AmericanSamoa) { return tl::sprintf ("AmericanSamoa (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Andorra) { return tl::sprintf ("Andorra (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Angola) { return tl::sprintf ("Angola (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Anguilla) { return tl::sprintf ("Anguilla (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Antarctica) { return tl::sprintf ("Antarctica (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::AntiguaAndBarbuda) { return tl::sprintf ("AntiguaAndBarbuda (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Argentina) { return tl::sprintf ("Argentina (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Armenia) { return tl::sprintf ("Armenia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Aruba) { return tl::sprintf ("Aruba (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Australia) { return tl::sprintf ("Australia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Austria) { return tl::sprintf ("Austria (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Azerbaijan) { return tl::sprintf ("Azerbaijan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Bahamas) { return tl::sprintf ("Bahamas (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Bahrain) { return tl::sprintf ("Bahrain (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Bangladesh) { return tl::sprintf ("Bangladesh (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Barbados) { return tl::sprintf ("Barbados (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Belarus) { return tl::sprintf ("Belarus (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Belgium) { return tl::sprintf ("Belgium (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Belize) { return tl::sprintf ("Belize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Benin) { return tl::sprintf ("Benin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Bermuda) { return tl::sprintf ("Bermuda (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Bhutan) { return tl::sprintf ("Bhutan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Bolivia) { return tl::sprintf ("Bolivia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::BosniaAndHerzegowina) { return tl::sprintf ("BosniaAndHerzegowina (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Botswana) { return tl::sprintf ("Botswana (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::BouvetIsland) { return tl::sprintf ("BouvetIsland (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Brazil) { return tl::sprintf ("Brazil (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::BritishIndianOceanTerritory) { return tl::sprintf ("BritishIndianOceanTerritory (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::BruneiDarussalam) { return tl::sprintf ("BruneiDarussalam (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Bulgaria) { return tl::sprintf ("Bulgaria (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::BurkinaFaso) { return tl::sprintf ("BurkinaFaso (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Burundi) { return tl::sprintf ("Burundi (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Cambodia) { return tl::sprintf ("Cambodia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Cameroon) { return tl::sprintf ("Cameroon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Canada) { return tl::sprintf ("Canada (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::CapeVerde) { return tl::sprintf ("CapeVerde (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::CaymanIslands) { return tl::sprintf ("CaymanIslands (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::CentralAfricanRepublic) { return tl::sprintf ("CentralAfricanRepublic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Chad) { return tl::sprintf ("Chad (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Chile) { return tl::sprintf ("Chile (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::China) { return tl::sprintf ("China (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::ChristmasIsland) { return tl::sprintf ("ChristmasIsland (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::CocosIslands) { return tl::sprintf ("CocosIslands (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Colombia) { return tl::sprintf ("Colombia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Comoros) { return tl::sprintf ("Comoros (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::DemocraticRepublicOfCongo) { return tl::sprintf ("DemocraticRepublicOfCongo (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::PeoplesRepublicOfCongo) { return tl::sprintf ("PeoplesRepublicOfCongo (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::CookIslands) { return tl::sprintf ("CookIslands (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::CostaRica) { return tl::sprintf ("CostaRica (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::IvoryCoast) { return tl::sprintf ("IvoryCoast (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Croatia) { return tl::sprintf ("Croatia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Cuba) { return tl::sprintf ("Cuba (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Cyprus) { return tl::sprintf ("Cyprus (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::CzechRepublic) { return tl::sprintf ("CzechRepublic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Denmark) { return tl::sprintf ("Denmark (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Djibouti) { return tl::sprintf ("Djibouti (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Dominica) { return tl::sprintf ("Dominica (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::DominicanRepublic) { return tl::sprintf ("DominicanRepublic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::EastTimor) { return tl::sprintf ("EastTimor (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Ecuador) { return tl::sprintf ("Ecuador (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Egypt) { return tl::sprintf ("Egypt (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::ElSalvador) { return tl::sprintf ("ElSalvador (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::EquatorialGuinea) { return tl::sprintf ("EquatorialGuinea (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Eritrea) { return tl::sprintf ("Eritrea (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Estonia) { return tl::sprintf ("Estonia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Ethiopia) { return tl::sprintf ("Ethiopia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::FalklandIslands) { return tl::sprintf ("FalklandIslands (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::FaroeIslands) { return tl::sprintf ("FaroeIslands (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::FijiCountry) { return tl::sprintf ("FijiCountry (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Finland) { return tl::sprintf ("Finland (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::France) { return tl::sprintf ("France (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::MetropolitanFrance) { return tl::sprintf ("MetropolitanFrance (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::FrenchGuiana) { return tl::sprintf ("FrenchGuiana (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::FrenchPolynesia) { return tl::sprintf ("FrenchPolynesia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::FrenchSouthernTerritories) { return tl::sprintf ("FrenchSouthernTerritories (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Gabon) { return tl::sprintf ("Gabon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Gambia) { return tl::sprintf ("Gambia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Georgia) { return tl::sprintf ("Georgia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Germany) { return tl::sprintf ("Germany (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Ghana) { return tl::sprintf ("Ghana (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Gibraltar) { return tl::sprintf ("Gibraltar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Greece) { return tl::sprintf ("Greece (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Greenland) { return tl::sprintf ("Greenland (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Grenada) { return tl::sprintf ("Grenada (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Guadeloupe) { return tl::sprintf ("Guadeloupe (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Guam) { return tl::sprintf ("Guam (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Guatemala) { return tl::sprintf ("Guatemala (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Guinea) { return tl::sprintf ("Guinea (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::GuineaBissau) { return tl::sprintf ("GuineaBissau (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Guyana) { return tl::sprintf ("Guyana (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Haiti) { return tl::sprintf ("Haiti (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::HeardAndMcDonaldIslands) { return tl::sprintf ("HeardAndMcDonaldIslands (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Honduras) { return tl::sprintf ("Honduras (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::HongKong) { return tl::sprintf ("HongKong (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Hungary) { return tl::sprintf ("Hungary (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Iceland) { return tl::sprintf ("Iceland (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::India) { return tl::sprintf ("India (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Indonesia) { return tl::sprintf ("Indonesia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Iran) { return tl::sprintf ("Iran (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Iraq) { return tl::sprintf ("Iraq (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Ireland) { return tl::sprintf ("Ireland (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Israel) { return tl::sprintf ("Israel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Italy) { return tl::sprintf ("Italy (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Jamaica) { return tl::sprintf ("Jamaica (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Japan) { return tl::sprintf ("Japan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Jordan) { return tl::sprintf ("Jordan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Kazakhstan) { return tl::sprintf ("Kazakhstan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Kenya) { return tl::sprintf ("Kenya (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Kiribati) { return tl::sprintf ("Kiribati (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::DemocraticRepublicOfKorea) { return tl::sprintf ("DemocraticRepublicOfKorea (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::RepublicOfKorea) { return tl::sprintf ("RepublicOfKorea (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Kuwait) { return tl::sprintf ("Kuwait (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Kyrgyzstan) { return tl::sprintf ("Kyrgyzstan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Lao) { return tl::sprintf ("Lao (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Latvia) { return tl::sprintf ("Latvia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Lebanon) { return tl::sprintf ("Lebanon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Lesotho) { return tl::sprintf ("Lesotho (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Liberia) { return tl::sprintf ("Liberia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::LibyanArabJamahiriya) { return tl::sprintf ("LibyanArabJamahiriya (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Liechtenstein) { return tl::sprintf ("Liechtenstein (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Lithuania) { return tl::sprintf ("Lithuania (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Luxembourg) { return tl::sprintf ("Luxembourg (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Macau) { return tl::sprintf ("Macau (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Macedonia) { return tl::sprintf ("Macedonia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Madagascar) { return tl::sprintf ("Madagascar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Malawi) { return tl::sprintf ("Malawi (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Malaysia) { return tl::sprintf ("Malaysia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Maldives) { return tl::sprintf ("Maldives (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Mali) { return tl::sprintf ("Mali (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Malta) { return tl::sprintf ("Malta (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::MarshallIslands) { return tl::sprintf ("MarshallIslands (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Martinique) { return tl::sprintf ("Martinique (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Mauritania) { return tl::sprintf ("Mauritania (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Mauritius) { return tl::sprintf ("Mauritius (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Mayotte) { return tl::sprintf ("Mayotte (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Mexico) { return tl::sprintf ("Mexico (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Micronesia) { return tl::sprintf ("Micronesia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Moldova) { return tl::sprintf ("Moldova (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Monaco) { return tl::sprintf ("Monaco (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Mongolia) { return tl::sprintf ("Mongolia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Montserrat) { return tl::sprintf ("Montserrat (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Morocco) { return tl::sprintf ("Morocco (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Mozambique) { return tl::sprintf ("Mozambique (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Myanmar) { return tl::sprintf ("Myanmar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Namibia) { return tl::sprintf ("Namibia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::NauruCountry) { return tl::sprintf ("NauruCountry (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Nepal) { return tl::sprintf ("Nepal (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Netherlands) { return tl::sprintf ("Netherlands (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::NetherlandsAntilles) { return tl::sprintf ("NetherlandsAntilles (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::NewCaledonia) { return tl::sprintf ("NewCaledonia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::NewZealand) { return tl::sprintf ("NewZealand (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Nicaragua) { return tl::sprintf ("Nicaragua (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Niger) { return tl::sprintf ("Niger (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Nigeria) { return tl::sprintf ("Nigeria (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Niue) { return tl::sprintf ("Niue (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::NorfolkIsland) { return tl::sprintf ("NorfolkIsland (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::NorthernMarianaIslands) { return tl::sprintf ("NorthernMarianaIslands (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Norway) { return tl::sprintf ("Norway (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Oman) { return tl::sprintf ("Oman (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Pakistan) { return tl::sprintf ("Pakistan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Palau) { return tl::sprintf ("Palau (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::PalestinianTerritory) { return tl::sprintf ("PalestinianTerritory (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Panama) { return tl::sprintf ("Panama (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::PapuaNewGuinea) { return tl::sprintf ("PapuaNewGuinea (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Paraguay) { return tl::sprintf ("Paraguay (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Peru) { return tl::sprintf ("Peru (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Philippines) { return tl::sprintf ("Philippines (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Pitcairn) { return tl::sprintf ("Pitcairn (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Poland) { return tl::sprintf ("Poland (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Portugal) { return tl::sprintf ("Portugal (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::PuertoRico) { return tl::sprintf ("PuertoRico (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Qatar) { return tl::sprintf ("Qatar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Reunion) { return tl::sprintf ("Reunion (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Romania) { return tl::sprintf ("Romania (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::RussianFederation) { return tl::sprintf ("RussianFederation (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Rwanda) { return tl::sprintf ("Rwanda (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::SaintKittsAndNevis) { return tl::sprintf ("SaintKittsAndNevis (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::StLucia) { return tl::sprintf ("StLucia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::StVincentAndTheGrenadines) { return tl::sprintf ("StVincentAndTheGrenadines (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Samoa) { return tl::sprintf ("Samoa (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::SanMarino) { return tl::sprintf ("SanMarino (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::SaoTomeAndPrincipe) { return tl::sprintf ("SaoTomeAndPrincipe (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::SaudiArabia) { return tl::sprintf ("SaudiArabia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Senegal) { return tl::sprintf ("Senegal (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Seychelles) { return tl::sprintf ("Seychelles (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::SierraLeone) { return tl::sprintf ("SierraLeone (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Singapore) { return tl::sprintf ("Singapore (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Slovakia) { return tl::sprintf ("Slovakia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Slovenia) { return tl::sprintf ("Slovenia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::SolomonIslands) { return tl::sprintf ("SolomonIslands (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Somalia) { return tl::sprintf ("Somalia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::SouthAfrica) { return tl::sprintf ("SouthAfrica (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::SouthGeorgiaAndTheSouthSandwichIslands) { return tl::sprintf ("SouthGeorgiaAndTheSouthSandwichIslands (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Spain) { return tl::sprintf ("Spain (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::SriLanka) { return tl::sprintf ("SriLanka (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::StHelena) { return tl::sprintf ("StHelena (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::StPierreAndMiquelon) { return tl::sprintf ("StPierreAndMiquelon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Sudan) { return tl::sprintf ("Sudan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Suriname) { return tl::sprintf ("Suriname (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::SvalbardAndJanMayenIslands) { return tl::sprintf ("SvalbardAndJanMayenIslands (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Swaziland) { return tl::sprintf ("Swaziland (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Sweden) { return tl::sprintf ("Sweden (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Switzerland) { return tl::sprintf ("Switzerland (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::SyrianArabRepublic) { return tl::sprintf ("SyrianArabRepublic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Taiwan) { return tl::sprintf ("Taiwan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Tajikistan) { return tl::sprintf ("Tajikistan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Tanzania) { return tl::sprintf ("Tanzania (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Thailand) { return tl::sprintf ("Thailand (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Togo) { return tl::sprintf ("Togo (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Tokelau) { return tl::sprintf ("Tokelau (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::TongaCountry) { return tl::sprintf ("TongaCountry (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::TrinidadAndTobago) { return tl::sprintf ("TrinidadAndTobago (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Tunisia) { return tl::sprintf ("Tunisia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Turkey) { return tl::sprintf ("Turkey (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Turkmenistan) { return tl::sprintf ("Turkmenistan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::TurksAndCaicosIslands) { return tl::sprintf ("TurksAndCaicosIslands (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Tuvalu) { return tl::sprintf ("Tuvalu (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Uganda) { return tl::sprintf ("Uganda (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Ukraine) { return tl::sprintf ("Ukraine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::UnitedArabEmirates) { return tl::sprintf ("UnitedArabEmirates (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::UnitedKingdom) { return tl::sprintf ("UnitedKingdom (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::UnitedStates) { return tl::sprintf ("UnitedStates (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::UnitedStatesMinorOutlyingIslands) { return tl::sprintf ("UnitedStatesMinorOutlyingIslands (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Uruguay) { return tl::sprintf ("Uruguay (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Uzbekistan) { return tl::sprintf ("Uzbekistan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Vanuatu) { return tl::sprintf ("Vanuatu (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::VaticanCityState) { return tl::sprintf ("VaticanCityState (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Venezuela) { return tl::sprintf ("Venezuela (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::VietNam) { return tl::sprintf ("VietNam (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::BritishVirginIslands) { return tl::sprintf ("BritishVirginIslands (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::USVirginIslands) { return tl::sprintf ("USVirginIslands (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::WallisAndFutunaIslands) { return tl::sprintf ("WallisAndFutunaIslands (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::WesternSahara) { return tl::sprintf ("WesternSahara (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Yemen) { return tl::sprintf ("Yemen (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Yugoslavia) { return tl::sprintf ("Yugoslavia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Zambia) { return tl::sprintf ("Zambia (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Zimbabwe) { return tl::sprintf ("Zimbabwe (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::SerbiaAndMontenegro) { return tl::sprintf ("SerbiaAndMontenegro (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::LastCountry) { return tl::sprintf ("LastCountry (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QLocale_Country_Enum (const QLocale_Country_Enum *e)
{
  return (unsigned int) e->value ();
}

static QLocale_Country_Enum *from_i_QLocale_Country_Enum (unsigned int i)
{
  return new QLocale_Country_Enum ((QLocale::Country) i);
}

static bool equalQLocale_Country_Enum (const QLocale_Country_Enum *e, QLocale_Country_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QLocale_Country_Enum (const QLocale_Country_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QLocale_Country_Enums oropQLocale_Country_Enums (const QLocale_Country_Enums *e, const QLocale_Country_Enums &d)
{
  return e->flags () | d.flags ();
}

static QLocale_Country_Enums andopQLocale_Country_Enums (const QLocale_Country_Enums *e, const QLocale_Country_Enums &d)
{
  return e->flags () & d.flags ();
}

static QLocale_Country_Enums xoropQLocale_Country_Enums (const QLocale_Country_Enums *e, const QLocale_Country_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QLocale_Country_Enums (const QLocale_Country_Enums *e)
{
  std::string l;
  if (e->testFlag (QLocale::AnyCountry)) { if (!l.empty ()) l += "|"; l += "AnyCountry"; }
  if (e->testFlag (QLocale::Afghanistan)) { if (!l.empty ()) l += "|"; l += "Afghanistan"; }
  if (e->testFlag (QLocale::Albania)) { if (!l.empty ()) l += "|"; l += "Albania"; }
  if (e->testFlag (QLocale::Algeria)) { if (!l.empty ()) l += "|"; l += "Algeria"; }
  if (e->testFlag (QLocale::AmericanSamoa)) { if (!l.empty ()) l += "|"; l += "AmericanSamoa"; }
  if (e->testFlag (QLocale::Andorra)) { if (!l.empty ()) l += "|"; l += "Andorra"; }
  if (e->testFlag (QLocale::Angola)) { if (!l.empty ()) l += "|"; l += "Angola"; }
  if (e->testFlag (QLocale::Anguilla)) { if (!l.empty ()) l += "|"; l += "Anguilla"; }
  if (e->testFlag (QLocale::Antarctica)) { if (!l.empty ()) l += "|"; l += "Antarctica"; }
  if (e->testFlag (QLocale::AntiguaAndBarbuda)) { if (!l.empty ()) l += "|"; l += "AntiguaAndBarbuda"; }
  if (e->testFlag (QLocale::Argentina)) { if (!l.empty ()) l += "|"; l += "Argentina"; }
  if (e->testFlag (QLocale::Armenia)) { if (!l.empty ()) l += "|"; l += "Armenia"; }
  if (e->testFlag (QLocale::Aruba)) { if (!l.empty ()) l += "|"; l += "Aruba"; }
  if (e->testFlag (QLocale::Australia)) { if (!l.empty ()) l += "|"; l += "Australia"; }
  if (e->testFlag (QLocale::Austria)) { if (!l.empty ()) l += "|"; l += "Austria"; }
  if (e->testFlag (QLocale::Azerbaijan)) { if (!l.empty ()) l += "|"; l += "Azerbaijan"; }
  if (e->testFlag (QLocale::Bahamas)) { if (!l.empty ()) l += "|"; l += "Bahamas"; }
  if (e->testFlag (QLocale::Bahrain)) { if (!l.empty ()) l += "|"; l += "Bahrain"; }
  if (e->testFlag (QLocale::Bangladesh)) { if (!l.empty ()) l += "|"; l += "Bangladesh"; }
  if (e->testFlag (QLocale::Barbados)) { if (!l.empty ()) l += "|"; l += "Barbados"; }
  if (e->testFlag (QLocale::Belarus)) { if (!l.empty ()) l += "|"; l += "Belarus"; }
  if (e->testFlag (QLocale::Belgium)) { if (!l.empty ()) l += "|"; l += "Belgium"; }
  if (e->testFlag (QLocale::Belize)) { if (!l.empty ()) l += "|"; l += "Belize"; }
  if (e->testFlag (QLocale::Benin)) { if (!l.empty ()) l += "|"; l += "Benin"; }
  if (e->testFlag (QLocale::Bermuda)) { if (!l.empty ()) l += "|"; l += "Bermuda"; }
  if (e->testFlag (QLocale::Bhutan)) { if (!l.empty ()) l += "|"; l += "Bhutan"; }
  if (e->testFlag (QLocale::Bolivia)) { if (!l.empty ()) l += "|"; l += "Bolivia"; }
  if (e->testFlag (QLocale::BosniaAndHerzegowina)) { if (!l.empty ()) l += "|"; l += "BosniaAndHerzegowina"; }
  if (e->testFlag (QLocale::Botswana)) { if (!l.empty ()) l += "|"; l += "Botswana"; }
  if (e->testFlag (QLocale::BouvetIsland)) { if (!l.empty ()) l += "|"; l += "BouvetIsland"; }
  if (e->testFlag (QLocale::Brazil)) { if (!l.empty ()) l += "|"; l += "Brazil"; }
  if (e->testFlag (QLocale::BritishIndianOceanTerritory)) { if (!l.empty ()) l += "|"; l += "BritishIndianOceanTerritory"; }
  if (e->testFlag (QLocale::BruneiDarussalam)) { if (!l.empty ()) l += "|"; l += "BruneiDarussalam"; }
  if (e->testFlag (QLocale::Bulgaria)) { if (!l.empty ()) l += "|"; l += "Bulgaria"; }
  if (e->testFlag (QLocale::BurkinaFaso)) { if (!l.empty ()) l += "|"; l += "BurkinaFaso"; }
  if (e->testFlag (QLocale::Burundi)) { if (!l.empty ()) l += "|"; l += "Burundi"; }
  if (e->testFlag (QLocale::Cambodia)) { if (!l.empty ()) l += "|"; l += "Cambodia"; }
  if (e->testFlag (QLocale::Cameroon)) { if (!l.empty ()) l += "|"; l += "Cameroon"; }
  if (e->testFlag (QLocale::Canada)) { if (!l.empty ()) l += "|"; l += "Canada"; }
  if (e->testFlag (QLocale::CapeVerde)) { if (!l.empty ()) l += "|"; l += "CapeVerde"; }
  if (e->testFlag (QLocale::CaymanIslands)) { if (!l.empty ()) l += "|"; l += "CaymanIslands"; }
  if (e->testFlag (QLocale::CentralAfricanRepublic)) { if (!l.empty ()) l += "|"; l += "CentralAfricanRepublic"; }
  if (e->testFlag (QLocale::Chad)) { if (!l.empty ()) l += "|"; l += "Chad"; }
  if (e->testFlag (QLocale::Chile)) { if (!l.empty ()) l += "|"; l += "Chile"; }
  if (e->testFlag (QLocale::China)) { if (!l.empty ()) l += "|"; l += "China"; }
  if (e->testFlag (QLocale::ChristmasIsland)) { if (!l.empty ()) l += "|"; l += "ChristmasIsland"; }
  if (e->testFlag (QLocale::CocosIslands)) { if (!l.empty ()) l += "|"; l += "CocosIslands"; }
  if (e->testFlag (QLocale::Colombia)) { if (!l.empty ()) l += "|"; l += "Colombia"; }
  if (e->testFlag (QLocale::Comoros)) { if (!l.empty ()) l += "|"; l += "Comoros"; }
  if (e->testFlag (QLocale::DemocraticRepublicOfCongo)) { if (!l.empty ()) l += "|"; l += "DemocraticRepublicOfCongo"; }
  if (e->testFlag (QLocale::PeoplesRepublicOfCongo)) { if (!l.empty ()) l += "|"; l += "PeoplesRepublicOfCongo"; }
  if (e->testFlag (QLocale::CookIslands)) { if (!l.empty ()) l += "|"; l += "CookIslands"; }
  if (e->testFlag (QLocale::CostaRica)) { if (!l.empty ()) l += "|"; l += "CostaRica"; }
  if (e->testFlag (QLocale::IvoryCoast)) { if (!l.empty ()) l += "|"; l += "IvoryCoast"; }
  if (e->testFlag (QLocale::Croatia)) { if (!l.empty ()) l += "|"; l += "Croatia"; }
  if (e->testFlag (QLocale::Cuba)) { if (!l.empty ()) l += "|"; l += "Cuba"; }
  if (e->testFlag (QLocale::Cyprus)) { if (!l.empty ()) l += "|"; l += "Cyprus"; }
  if (e->testFlag (QLocale::CzechRepublic)) { if (!l.empty ()) l += "|"; l += "CzechRepublic"; }
  if (e->testFlag (QLocale::Denmark)) { if (!l.empty ()) l += "|"; l += "Denmark"; }
  if (e->testFlag (QLocale::Djibouti)) { if (!l.empty ()) l += "|"; l += "Djibouti"; }
  if (e->testFlag (QLocale::Dominica)) { if (!l.empty ()) l += "|"; l += "Dominica"; }
  if (e->testFlag (QLocale::DominicanRepublic)) { if (!l.empty ()) l += "|"; l += "DominicanRepublic"; }
  if (e->testFlag (QLocale::EastTimor)) { if (!l.empty ()) l += "|"; l += "EastTimor"; }
  if (e->testFlag (QLocale::Ecuador)) { if (!l.empty ()) l += "|"; l += "Ecuador"; }
  if (e->testFlag (QLocale::Egypt)) { if (!l.empty ()) l += "|"; l += "Egypt"; }
  if (e->testFlag (QLocale::ElSalvador)) { if (!l.empty ()) l += "|"; l += "ElSalvador"; }
  if (e->testFlag (QLocale::EquatorialGuinea)) { if (!l.empty ()) l += "|"; l += "EquatorialGuinea"; }
  if (e->testFlag (QLocale::Eritrea)) { if (!l.empty ()) l += "|"; l += "Eritrea"; }
  if (e->testFlag (QLocale::Estonia)) { if (!l.empty ()) l += "|"; l += "Estonia"; }
  if (e->testFlag (QLocale::Ethiopia)) { if (!l.empty ()) l += "|"; l += "Ethiopia"; }
  if (e->testFlag (QLocale::FalklandIslands)) { if (!l.empty ()) l += "|"; l += "FalklandIslands"; }
  if (e->testFlag (QLocale::FaroeIslands)) { if (!l.empty ()) l += "|"; l += "FaroeIslands"; }
  if (e->testFlag (QLocale::FijiCountry)) { if (!l.empty ()) l += "|"; l += "FijiCountry"; }
  if (e->testFlag (QLocale::Finland)) { if (!l.empty ()) l += "|"; l += "Finland"; }
  if (e->testFlag (QLocale::France)) { if (!l.empty ()) l += "|"; l += "France"; }
  if (e->testFlag (QLocale::MetropolitanFrance)) { if (!l.empty ()) l += "|"; l += "MetropolitanFrance"; }
  if (e->testFlag (QLocale::FrenchGuiana)) { if (!l.empty ()) l += "|"; l += "FrenchGuiana"; }
  if (e->testFlag (QLocale::FrenchPolynesia)) { if (!l.empty ()) l += "|"; l += "FrenchPolynesia"; }
  if (e->testFlag (QLocale::FrenchSouthernTerritories)) { if (!l.empty ()) l += "|"; l += "FrenchSouthernTerritories"; }
  if (e->testFlag (QLocale::Gabon)) { if (!l.empty ()) l += "|"; l += "Gabon"; }
  if (e->testFlag (QLocale::Gambia)) { if (!l.empty ()) l += "|"; l += "Gambia"; }
  if (e->testFlag (QLocale::Georgia)) { if (!l.empty ()) l += "|"; l += "Georgia"; }
  if (e->testFlag (QLocale::Germany)) { if (!l.empty ()) l += "|"; l += "Germany"; }
  if (e->testFlag (QLocale::Ghana)) { if (!l.empty ()) l += "|"; l += "Ghana"; }
  if (e->testFlag (QLocale::Gibraltar)) { if (!l.empty ()) l += "|"; l += "Gibraltar"; }
  if (e->testFlag (QLocale::Greece)) { if (!l.empty ()) l += "|"; l += "Greece"; }
  if (e->testFlag (QLocale::Greenland)) { if (!l.empty ()) l += "|"; l += "Greenland"; }
  if (e->testFlag (QLocale::Grenada)) { if (!l.empty ()) l += "|"; l += "Grenada"; }
  if (e->testFlag (QLocale::Guadeloupe)) { if (!l.empty ()) l += "|"; l += "Guadeloupe"; }
  if (e->testFlag (QLocale::Guam)) { if (!l.empty ()) l += "|"; l += "Guam"; }
  if (e->testFlag (QLocale::Guatemala)) { if (!l.empty ()) l += "|"; l += "Guatemala"; }
  if (e->testFlag (QLocale::Guinea)) { if (!l.empty ()) l += "|"; l += "Guinea"; }
  if (e->testFlag (QLocale::GuineaBissau)) { if (!l.empty ()) l += "|"; l += "GuineaBissau"; }
  if (e->testFlag (QLocale::Guyana)) { if (!l.empty ()) l += "|"; l += "Guyana"; }
  if (e->testFlag (QLocale::Haiti)) { if (!l.empty ()) l += "|"; l += "Haiti"; }
  if (e->testFlag (QLocale::HeardAndMcDonaldIslands)) { if (!l.empty ()) l += "|"; l += "HeardAndMcDonaldIslands"; }
  if (e->testFlag (QLocale::Honduras)) { if (!l.empty ()) l += "|"; l += "Honduras"; }
  if (e->testFlag (QLocale::HongKong)) { if (!l.empty ()) l += "|"; l += "HongKong"; }
  if (e->testFlag (QLocale::Hungary)) { if (!l.empty ()) l += "|"; l += "Hungary"; }
  if (e->testFlag (QLocale::Iceland)) { if (!l.empty ()) l += "|"; l += "Iceland"; }
  if (e->testFlag (QLocale::India)) { if (!l.empty ()) l += "|"; l += "India"; }
  if (e->testFlag (QLocale::Indonesia)) { if (!l.empty ()) l += "|"; l += "Indonesia"; }
  if (e->testFlag (QLocale::Iran)) { if (!l.empty ()) l += "|"; l += "Iran"; }
  if (e->testFlag (QLocale::Iraq)) { if (!l.empty ()) l += "|"; l += "Iraq"; }
  if (e->testFlag (QLocale::Ireland)) { if (!l.empty ()) l += "|"; l += "Ireland"; }
  if (e->testFlag (QLocale::Israel)) { if (!l.empty ()) l += "|"; l += "Israel"; }
  if (e->testFlag (QLocale::Italy)) { if (!l.empty ()) l += "|"; l += "Italy"; }
  if (e->testFlag (QLocale::Jamaica)) { if (!l.empty ()) l += "|"; l += "Jamaica"; }
  if (e->testFlag (QLocale::Japan)) { if (!l.empty ()) l += "|"; l += "Japan"; }
  if (e->testFlag (QLocale::Jordan)) { if (!l.empty ()) l += "|"; l += "Jordan"; }
  if (e->testFlag (QLocale::Kazakhstan)) { if (!l.empty ()) l += "|"; l += "Kazakhstan"; }
  if (e->testFlag (QLocale::Kenya)) { if (!l.empty ()) l += "|"; l += "Kenya"; }
  if (e->testFlag (QLocale::Kiribati)) { if (!l.empty ()) l += "|"; l += "Kiribati"; }
  if (e->testFlag (QLocale::DemocraticRepublicOfKorea)) { if (!l.empty ()) l += "|"; l += "DemocraticRepublicOfKorea"; }
  if (e->testFlag (QLocale::RepublicOfKorea)) { if (!l.empty ()) l += "|"; l += "RepublicOfKorea"; }
  if (e->testFlag (QLocale::Kuwait)) { if (!l.empty ()) l += "|"; l += "Kuwait"; }
  if (e->testFlag (QLocale::Kyrgyzstan)) { if (!l.empty ()) l += "|"; l += "Kyrgyzstan"; }
  if (e->testFlag (QLocale::Lao)) { if (!l.empty ()) l += "|"; l += "Lao"; }
  if (e->testFlag (QLocale::Latvia)) { if (!l.empty ()) l += "|"; l += "Latvia"; }
  if (e->testFlag (QLocale::Lebanon)) { if (!l.empty ()) l += "|"; l += "Lebanon"; }
  if (e->testFlag (QLocale::Lesotho)) { if (!l.empty ()) l += "|"; l += "Lesotho"; }
  if (e->testFlag (QLocale::Liberia)) { if (!l.empty ()) l += "|"; l += "Liberia"; }
  if (e->testFlag (QLocale::LibyanArabJamahiriya)) { if (!l.empty ()) l += "|"; l += "LibyanArabJamahiriya"; }
  if (e->testFlag (QLocale::Liechtenstein)) { if (!l.empty ()) l += "|"; l += "Liechtenstein"; }
  if (e->testFlag (QLocale::Lithuania)) { if (!l.empty ()) l += "|"; l += "Lithuania"; }
  if (e->testFlag (QLocale::Luxembourg)) { if (!l.empty ()) l += "|"; l += "Luxembourg"; }
  if (e->testFlag (QLocale::Macau)) { if (!l.empty ()) l += "|"; l += "Macau"; }
  if (e->testFlag (QLocale::Macedonia)) { if (!l.empty ()) l += "|"; l += "Macedonia"; }
  if (e->testFlag (QLocale::Madagascar)) { if (!l.empty ()) l += "|"; l += "Madagascar"; }
  if (e->testFlag (QLocale::Malawi)) { if (!l.empty ()) l += "|"; l += "Malawi"; }
  if (e->testFlag (QLocale::Malaysia)) { if (!l.empty ()) l += "|"; l += "Malaysia"; }
  if (e->testFlag (QLocale::Maldives)) { if (!l.empty ()) l += "|"; l += "Maldives"; }
  if (e->testFlag (QLocale::Mali)) { if (!l.empty ()) l += "|"; l += "Mali"; }
  if (e->testFlag (QLocale::Malta)) { if (!l.empty ()) l += "|"; l += "Malta"; }
  if (e->testFlag (QLocale::MarshallIslands)) { if (!l.empty ()) l += "|"; l += "MarshallIslands"; }
  if (e->testFlag (QLocale::Martinique)) { if (!l.empty ()) l += "|"; l += "Martinique"; }
  if (e->testFlag (QLocale::Mauritania)) { if (!l.empty ()) l += "|"; l += "Mauritania"; }
  if (e->testFlag (QLocale::Mauritius)) { if (!l.empty ()) l += "|"; l += "Mauritius"; }
  if (e->testFlag (QLocale::Mayotte)) { if (!l.empty ()) l += "|"; l += "Mayotte"; }
  if (e->testFlag (QLocale::Mexico)) { if (!l.empty ()) l += "|"; l += "Mexico"; }
  if (e->testFlag (QLocale::Micronesia)) { if (!l.empty ()) l += "|"; l += "Micronesia"; }
  if (e->testFlag (QLocale::Moldova)) { if (!l.empty ()) l += "|"; l += "Moldova"; }
  if (e->testFlag (QLocale::Monaco)) { if (!l.empty ()) l += "|"; l += "Monaco"; }
  if (e->testFlag (QLocale::Mongolia)) { if (!l.empty ()) l += "|"; l += "Mongolia"; }
  if (e->testFlag (QLocale::Montserrat)) { if (!l.empty ()) l += "|"; l += "Montserrat"; }
  if (e->testFlag (QLocale::Morocco)) { if (!l.empty ()) l += "|"; l += "Morocco"; }
  if (e->testFlag (QLocale::Mozambique)) { if (!l.empty ()) l += "|"; l += "Mozambique"; }
  if (e->testFlag (QLocale::Myanmar)) { if (!l.empty ()) l += "|"; l += "Myanmar"; }
  if (e->testFlag (QLocale::Namibia)) { if (!l.empty ()) l += "|"; l += "Namibia"; }
  if (e->testFlag (QLocale::NauruCountry)) { if (!l.empty ()) l += "|"; l += "NauruCountry"; }
  if (e->testFlag (QLocale::Nepal)) { if (!l.empty ()) l += "|"; l += "Nepal"; }
  if (e->testFlag (QLocale::Netherlands)) { if (!l.empty ()) l += "|"; l += "Netherlands"; }
  if (e->testFlag (QLocale::NetherlandsAntilles)) { if (!l.empty ()) l += "|"; l += "NetherlandsAntilles"; }
  if (e->testFlag (QLocale::NewCaledonia)) { if (!l.empty ()) l += "|"; l += "NewCaledonia"; }
  if (e->testFlag (QLocale::NewZealand)) { if (!l.empty ()) l += "|"; l += "NewZealand"; }
  if (e->testFlag (QLocale::Nicaragua)) { if (!l.empty ()) l += "|"; l += "Nicaragua"; }
  if (e->testFlag (QLocale::Niger)) { if (!l.empty ()) l += "|"; l += "Niger"; }
  if (e->testFlag (QLocale::Nigeria)) { if (!l.empty ()) l += "|"; l += "Nigeria"; }
  if (e->testFlag (QLocale::Niue)) { if (!l.empty ()) l += "|"; l += "Niue"; }
  if (e->testFlag (QLocale::NorfolkIsland)) { if (!l.empty ()) l += "|"; l += "NorfolkIsland"; }
  if (e->testFlag (QLocale::NorthernMarianaIslands)) { if (!l.empty ()) l += "|"; l += "NorthernMarianaIslands"; }
  if (e->testFlag (QLocale::Norway)) { if (!l.empty ()) l += "|"; l += "Norway"; }
  if (e->testFlag (QLocale::Oman)) { if (!l.empty ()) l += "|"; l += "Oman"; }
  if (e->testFlag (QLocale::Pakistan)) { if (!l.empty ()) l += "|"; l += "Pakistan"; }
  if (e->testFlag (QLocale::Palau)) { if (!l.empty ()) l += "|"; l += "Palau"; }
  if (e->testFlag (QLocale::PalestinianTerritory)) { if (!l.empty ()) l += "|"; l += "PalestinianTerritory"; }
  if (e->testFlag (QLocale::Panama)) { if (!l.empty ()) l += "|"; l += "Panama"; }
  if (e->testFlag (QLocale::PapuaNewGuinea)) { if (!l.empty ()) l += "|"; l += "PapuaNewGuinea"; }
  if (e->testFlag (QLocale::Paraguay)) { if (!l.empty ()) l += "|"; l += "Paraguay"; }
  if (e->testFlag (QLocale::Peru)) { if (!l.empty ()) l += "|"; l += "Peru"; }
  if (e->testFlag (QLocale::Philippines)) { if (!l.empty ()) l += "|"; l += "Philippines"; }
  if (e->testFlag (QLocale::Pitcairn)) { if (!l.empty ()) l += "|"; l += "Pitcairn"; }
  if (e->testFlag (QLocale::Poland)) { if (!l.empty ()) l += "|"; l += "Poland"; }
  if (e->testFlag (QLocale::Portugal)) { if (!l.empty ()) l += "|"; l += "Portugal"; }
  if (e->testFlag (QLocale::PuertoRico)) { if (!l.empty ()) l += "|"; l += "PuertoRico"; }
  if (e->testFlag (QLocale::Qatar)) { if (!l.empty ()) l += "|"; l += "Qatar"; }
  if (e->testFlag (QLocale::Reunion)) { if (!l.empty ()) l += "|"; l += "Reunion"; }
  if (e->testFlag (QLocale::Romania)) { if (!l.empty ()) l += "|"; l += "Romania"; }
  if (e->testFlag (QLocale::RussianFederation)) { if (!l.empty ()) l += "|"; l += "RussianFederation"; }
  if (e->testFlag (QLocale::Rwanda)) { if (!l.empty ()) l += "|"; l += "Rwanda"; }
  if (e->testFlag (QLocale::SaintKittsAndNevis)) { if (!l.empty ()) l += "|"; l += "SaintKittsAndNevis"; }
  if (e->testFlag (QLocale::StLucia)) { if (!l.empty ()) l += "|"; l += "StLucia"; }
  if (e->testFlag (QLocale::StVincentAndTheGrenadines)) { if (!l.empty ()) l += "|"; l += "StVincentAndTheGrenadines"; }
  if (e->testFlag (QLocale::Samoa)) { if (!l.empty ()) l += "|"; l += "Samoa"; }
  if (e->testFlag (QLocale::SanMarino)) { if (!l.empty ()) l += "|"; l += "SanMarino"; }
  if (e->testFlag (QLocale::SaoTomeAndPrincipe)) { if (!l.empty ()) l += "|"; l += "SaoTomeAndPrincipe"; }
  if (e->testFlag (QLocale::SaudiArabia)) { if (!l.empty ()) l += "|"; l += "SaudiArabia"; }
  if (e->testFlag (QLocale::Senegal)) { if (!l.empty ()) l += "|"; l += "Senegal"; }
  if (e->testFlag (QLocale::Seychelles)) { if (!l.empty ()) l += "|"; l += "Seychelles"; }
  if (e->testFlag (QLocale::SierraLeone)) { if (!l.empty ()) l += "|"; l += "SierraLeone"; }
  if (e->testFlag (QLocale::Singapore)) { if (!l.empty ()) l += "|"; l += "Singapore"; }
  if (e->testFlag (QLocale::Slovakia)) { if (!l.empty ()) l += "|"; l += "Slovakia"; }
  if (e->testFlag (QLocale::Slovenia)) { if (!l.empty ()) l += "|"; l += "Slovenia"; }
  if (e->testFlag (QLocale::SolomonIslands)) { if (!l.empty ()) l += "|"; l += "SolomonIslands"; }
  if (e->testFlag (QLocale::Somalia)) { if (!l.empty ()) l += "|"; l += "Somalia"; }
  if (e->testFlag (QLocale::SouthAfrica)) { if (!l.empty ()) l += "|"; l += "SouthAfrica"; }
  if (e->testFlag (QLocale::SouthGeorgiaAndTheSouthSandwichIslands)) { if (!l.empty ()) l += "|"; l += "SouthGeorgiaAndTheSouthSandwichIslands"; }
  if (e->testFlag (QLocale::Spain)) { if (!l.empty ()) l += "|"; l += "Spain"; }
  if (e->testFlag (QLocale::SriLanka)) { if (!l.empty ()) l += "|"; l += "SriLanka"; }
  if (e->testFlag (QLocale::StHelena)) { if (!l.empty ()) l += "|"; l += "StHelena"; }
  if (e->testFlag (QLocale::StPierreAndMiquelon)) { if (!l.empty ()) l += "|"; l += "StPierreAndMiquelon"; }
  if (e->testFlag (QLocale::Sudan)) { if (!l.empty ()) l += "|"; l += "Sudan"; }
  if (e->testFlag (QLocale::Suriname)) { if (!l.empty ()) l += "|"; l += "Suriname"; }
  if (e->testFlag (QLocale::SvalbardAndJanMayenIslands)) { if (!l.empty ()) l += "|"; l += "SvalbardAndJanMayenIslands"; }
  if (e->testFlag (QLocale::Swaziland)) { if (!l.empty ()) l += "|"; l += "Swaziland"; }
  if (e->testFlag (QLocale::Sweden)) { if (!l.empty ()) l += "|"; l += "Sweden"; }
  if (e->testFlag (QLocale::Switzerland)) { if (!l.empty ()) l += "|"; l += "Switzerland"; }
  if (e->testFlag (QLocale::SyrianArabRepublic)) { if (!l.empty ()) l += "|"; l += "SyrianArabRepublic"; }
  if (e->testFlag (QLocale::Taiwan)) { if (!l.empty ()) l += "|"; l += "Taiwan"; }
  if (e->testFlag (QLocale::Tajikistan)) { if (!l.empty ()) l += "|"; l += "Tajikistan"; }
  if (e->testFlag (QLocale::Tanzania)) { if (!l.empty ()) l += "|"; l += "Tanzania"; }
  if (e->testFlag (QLocale::Thailand)) { if (!l.empty ()) l += "|"; l += "Thailand"; }
  if (e->testFlag (QLocale::Togo)) { if (!l.empty ()) l += "|"; l += "Togo"; }
  if (e->testFlag (QLocale::Tokelau)) { if (!l.empty ()) l += "|"; l += "Tokelau"; }
  if (e->testFlag (QLocale::TongaCountry)) { if (!l.empty ()) l += "|"; l += "TongaCountry"; }
  if (e->testFlag (QLocale::TrinidadAndTobago)) { if (!l.empty ()) l += "|"; l += "TrinidadAndTobago"; }
  if (e->testFlag (QLocale::Tunisia)) { if (!l.empty ()) l += "|"; l += "Tunisia"; }
  if (e->testFlag (QLocale::Turkey)) { if (!l.empty ()) l += "|"; l += "Turkey"; }
  if (e->testFlag (QLocale::Turkmenistan)) { if (!l.empty ()) l += "|"; l += "Turkmenistan"; }
  if (e->testFlag (QLocale::TurksAndCaicosIslands)) { if (!l.empty ()) l += "|"; l += "TurksAndCaicosIslands"; }
  if (e->testFlag (QLocale::Tuvalu)) { if (!l.empty ()) l += "|"; l += "Tuvalu"; }
  if (e->testFlag (QLocale::Uganda)) { if (!l.empty ()) l += "|"; l += "Uganda"; }
  if (e->testFlag (QLocale::Ukraine)) { if (!l.empty ()) l += "|"; l += "Ukraine"; }
  if (e->testFlag (QLocale::UnitedArabEmirates)) { if (!l.empty ()) l += "|"; l += "UnitedArabEmirates"; }
  if (e->testFlag (QLocale::UnitedKingdom)) { if (!l.empty ()) l += "|"; l += "UnitedKingdom"; }
  if (e->testFlag (QLocale::UnitedStates)) { if (!l.empty ()) l += "|"; l += "UnitedStates"; }
  if (e->testFlag (QLocale::UnitedStatesMinorOutlyingIslands)) { if (!l.empty ()) l += "|"; l += "UnitedStatesMinorOutlyingIslands"; }
  if (e->testFlag (QLocale::Uruguay)) { if (!l.empty ()) l += "|"; l += "Uruguay"; }
  if (e->testFlag (QLocale::Uzbekistan)) { if (!l.empty ()) l += "|"; l += "Uzbekistan"; }
  if (e->testFlag (QLocale::Vanuatu)) { if (!l.empty ()) l += "|"; l += "Vanuatu"; }
  if (e->testFlag (QLocale::VaticanCityState)) { if (!l.empty ()) l += "|"; l += "VaticanCityState"; }
  if (e->testFlag (QLocale::Venezuela)) { if (!l.empty ()) l += "|"; l += "Venezuela"; }
  if (e->testFlag (QLocale::VietNam)) { if (!l.empty ()) l += "|"; l += "VietNam"; }
  if (e->testFlag (QLocale::BritishVirginIslands)) { if (!l.empty ()) l += "|"; l += "BritishVirginIslands"; }
  if (e->testFlag (QLocale::USVirginIslands)) { if (!l.empty ()) l += "|"; l += "USVirginIslands"; }
  if (e->testFlag (QLocale::WallisAndFutunaIslands)) { if (!l.empty ()) l += "|"; l += "WallisAndFutunaIslands"; }
  if (e->testFlag (QLocale::WesternSahara)) { if (!l.empty ()) l += "|"; l += "WesternSahara"; }
  if (e->testFlag (QLocale::Yemen)) { if (!l.empty ()) l += "|"; l += "Yemen"; }
  if (e->testFlag (QLocale::Yugoslavia)) { if (!l.empty ()) l += "|"; l += "Yugoslavia"; }
  if (e->testFlag (QLocale::Zambia)) { if (!l.empty ()) l += "|"; l += "Zambia"; }
  if (e->testFlag (QLocale::Zimbabwe)) { if (!l.empty ()) l += "|"; l += "Zimbabwe"; }
  if (e->testFlag (QLocale::SerbiaAndMontenegro)) { if (!l.empty ()) l += "|"; l += "SerbiaAndMontenegro"; }
  if (e->testFlag (QLocale::LastCountry)) { if (!l.empty ()) l += "|"; l += "LastCountry"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QLocale_Country_Enums (const QLocale_Country_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QLocale_Country_Enums (const QLocale_Country_Enums *e, const QLocale_Country_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QLocale_Country_Enums> decl_QLocale_Country_Enums ("QLocale_QFlags_Country",
  gsi::method_ext ("|", &qt_gsi::oropQLocale_Country_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQLocale_Country_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQLocale_Country_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLocale_Country_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLocale_Country_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QLocale_Country_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QLocale::Country> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QLocale_Country_Enum> decl_QLocale_Country_Enum (decl_QLocale_Country_Enums, "QLocale_Country",
  qt_gsi::mkdefs_QLocale_Country () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLocale_Country_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLocale_Country_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQLocale_Country_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QLocale_Country_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QLocale_Country_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QLocale::Country enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocale> inject_QLocale_Country_Enum_in_parent (qt_gsi::mkdefs_QLocale_Country ());
static gsi::ClassExt<QLocale> decl_QLocale_Country_Enum_as_child (decl_QLocale_Country_Enum, "Country");

}


//  Implementation of the enum wrapper class for QLocale::FormatType
namespace qt_gsi
{

static QLocale_FormatType_Enum *c_1_QLocale_FormatType_Enum () { return new QLocale_FormatType_Enum (QLocale::LongFormat); }
static QLocale_FormatType_Enum *c_2_QLocale_FormatType_Enum () { return new QLocale_FormatType_Enum (QLocale::ShortFormat); }
static QLocale_FormatType_Enum *c_3_QLocale_FormatType_Enum () { return new QLocale_FormatType_Enum (QLocale::NarrowFormat); }

static gsi::Methods mkdefs_QLocale_FormatType () {
  return
    gsi::constant ("LongFormat", &qt_gsi::c_1_QLocale_FormatType_Enum, "@brief Enum constant QLocale::LongFormat") +
    gsi::constant ("ShortFormat", &qt_gsi::c_2_QLocale_FormatType_Enum, "@brief Enum constant QLocale::ShortFormat") +
    gsi::constant ("NarrowFormat", &qt_gsi::c_3_QLocale_FormatType_Enum, "@brief Enum constant QLocale::NarrowFormat");
}

static std::string to_s_QLocale_FormatType_Enum (const QLocale_FormatType_Enum *e)
{
  if (e->value () == QLocale::LongFormat) { return tl::sprintf ("LongFormat (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::ShortFormat) { return tl::sprintf ("ShortFormat (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::NarrowFormat) { return tl::sprintf ("NarrowFormat (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QLocale_FormatType_Enum (const QLocale_FormatType_Enum *e)
{
  return (unsigned int) e->value ();
}

static QLocale_FormatType_Enum *from_i_QLocale_FormatType_Enum (unsigned int i)
{
  return new QLocale_FormatType_Enum ((QLocale::FormatType) i);
}

static bool equalQLocale_FormatType_Enum (const QLocale_FormatType_Enum *e, QLocale_FormatType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QLocale_FormatType_Enum (const QLocale_FormatType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QLocale_FormatType_Enums oropQLocale_FormatType_Enums (const QLocale_FormatType_Enums *e, const QLocale_FormatType_Enums &d)
{
  return e->flags () | d.flags ();
}

static QLocale_FormatType_Enums andopQLocale_FormatType_Enums (const QLocale_FormatType_Enums *e, const QLocale_FormatType_Enums &d)
{
  return e->flags () & d.flags ();
}

static QLocale_FormatType_Enums xoropQLocale_FormatType_Enums (const QLocale_FormatType_Enums *e, const QLocale_FormatType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QLocale_FormatType_Enums (const QLocale_FormatType_Enums *e)
{
  std::string l;
  if (e->testFlag (QLocale::LongFormat)) { if (!l.empty ()) l += "|"; l += "LongFormat"; }
  if (e->testFlag (QLocale::ShortFormat)) { if (!l.empty ()) l += "|"; l += "ShortFormat"; }
  if (e->testFlag (QLocale::NarrowFormat)) { if (!l.empty ()) l += "|"; l += "NarrowFormat"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QLocale_FormatType_Enums (const QLocale_FormatType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QLocale_FormatType_Enums (const QLocale_FormatType_Enums *e, const QLocale_FormatType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QLocale_FormatType_Enums> decl_QLocale_FormatType_Enums ("QLocale_QFlags_FormatType",
  gsi::method_ext ("|", &qt_gsi::oropQLocale_FormatType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQLocale_FormatType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQLocale_FormatType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLocale_FormatType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLocale_FormatType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QLocale_FormatType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QLocale::FormatType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QLocale_FormatType_Enum> decl_QLocale_FormatType_Enum (decl_QLocale_FormatType_Enums, "QLocale_FormatType",
  qt_gsi::mkdefs_QLocale_FormatType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLocale_FormatType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLocale_FormatType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQLocale_FormatType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QLocale_FormatType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QLocale_FormatType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QLocale::FormatType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocale> inject_QLocale_FormatType_Enum_in_parent (qt_gsi::mkdefs_QLocale_FormatType ());
static gsi::ClassExt<QLocale> decl_QLocale_FormatType_Enum_as_child (decl_QLocale_FormatType_Enum, "FormatType");

}


//  Implementation of the enum wrapper class for QLocale::Language
namespace qt_gsi
{

static QLocale_Language_Enum *c_1_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::C); }
static QLocale_Language_Enum *c_2_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Abkhazian); }
static QLocale_Language_Enum *c_3_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Afan); }
static QLocale_Language_Enum *c_4_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Afar); }
static QLocale_Language_Enum *c_5_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Afrikaans); }
static QLocale_Language_Enum *c_6_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Albanian); }
static QLocale_Language_Enum *c_7_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Amharic); }
static QLocale_Language_Enum *c_8_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Arabic); }
static QLocale_Language_Enum *c_9_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Armenian); }
static QLocale_Language_Enum *c_10_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Assamese); }
static QLocale_Language_Enum *c_11_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Aymara); }
static QLocale_Language_Enum *c_12_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Azerbaijani); }
static QLocale_Language_Enum *c_13_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Bashkir); }
static QLocale_Language_Enum *c_14_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Basque); }
static QLocale_Language_Enum *c_15_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Bengali); }
static QLocale_Language_Enum *c_16_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Bhutani); }
static QLocale_Language_Enum *c_17_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Bihari); }
static QLocale_Language_Enum *c_18_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Bislama); }
static QLocale_Language_Enum *c_19_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Breton); }
static QLocale_Language_Enum *c_20_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Bulgarian); }
static QLocale_Language_Enum *c_21_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Burmese); }
static QLocale_Language_Enum *c_22_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Byelorussian); }
static QLocale_Language_Enum *c_23_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Cambodian); }
static QLocale_Language_Enum *c_24_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Catalan); }
static QLocale_Language_Enum *c_25_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Chinese); }
static QLocale_Language_Enum *c_26_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Corsican); }
static QLocale_Language_Enum *c_27_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Croatian); }
static QLocale_Language_Enum *c_28_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Czech); }
static QLocale_Language_Enum *c_29_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Danish); }
static QLocale_Language_Enum *c_30_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Dutch); }
static QLocale_Language_Enum *c_31_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::English); }
static QLocale_Language_Enum *c_32_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Esperanto); }
static QLocale_Language_Enum *c_33_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Estonian); }
static QLocale_Language_Enum *c_34_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Faroese); }
static QLocale_Language_Enum *c_35_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::FijiLanguage); }
static QLocale_Language_Enum *c_36_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Finnish); }
static QLocale_Language_Enum *c_37_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::French); }
static QLocale_Language_Enum *c_38_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Frisian); }
static QLocale_Language_Enum *c_39_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Gaelic); }
static QLocale_Language_Enum *c_40_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Galician); }
static QLocale_Language_Enum *c_41_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Georgian); }
static QLocale_Language_Enum *c_42_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::German); }
static QLocale_Language_Enum *c_43_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Greek); }
static QLocale_Language_Enum *c_44_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Greenlandic); }
static QLocale_Language_Enum *c_45_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Guarani); }
static QLocale_Language_Enum *c_46_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Gujarati); }
static QLocale_Language_Enum *c_47_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Hausa); }
static QLocale_Language_Enum *c_48_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Hebrew); }
static QLocale_Language_Enum *c_49_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Hindi); }
static QLocale_Language_Enum *c_50_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Hungarian); }
static QLocale_Language_Enum *c_51_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Icelandic); }
static QLocale_Language_Enum *c_52_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Indonesian); }
static QLocale_Language_Enum *c_53_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Interlingua); }
static QLocale_Language_Enum *c_54_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Interlingue); }
static QLocale_Language_Enum *c_55_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Inuktitut); }
static QLocale_Language_Enum *c_56_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Inupiak); }
static QLocale_Language_Enum *c_57_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Irish); }
static QLocale_Language_Enum *c_58_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Italian); }
static QLocale_Language_Enum *c_59_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Japanese); }
static QLocale_Language_Enum *c_60_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Javanese); }
static QLocale_Language_Enum *c_61_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Kannada); }
static QLocale_Language_Enum *c_62_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Kashmiri); }
static QLocale_Language_Enum *c_63_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Kazakh); }
static QLocale_Language_Enum *c_64_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Kinyarwanda); }
static QLocale_Language_Enum *c_65_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Kirghiz); }
static QLocale_Language_Enum *c_66_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Korean); }
static QLocale_Language_Enum *c_67_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Kurdish); }
static QLocale_Language_Enum *c_68_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Kurundi); }
static QLocale_Language_Enum *c_69_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Laothian); }
static QLocale_Language_Enum *c_70_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Latin); }
static QLocale_Language_Enum *c_71_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Latvian); }
static QLocale_Language_Enum *c_72_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Lingala); }
static QLocale_Language_Enum *c_73_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Lithuanian); }
static QLocale_Language_Enum *c_74_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Macedonian); }
static QLocale_Language_Enum *c_75_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Malagasy); }
static QLocale_Language_Enum *c_76_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Malay); }
static QLocale_Language_Enum *c_77_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Malayalam); }
static QLocale_Language_Enum *c_78_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Maltese); }
static QLocale_Language_Enum *c_79_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Maori); }
static QLocale_Language_Enum *c_80_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Marathi); }
static QLocale_Language_Enum *c_81_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Moldavian); }
static QLocale_Language_Enum *c_82_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Mongolian); }
static QLocale_Language_Enum *c_83_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::NauruLanguage); }
static QLocale_Language_Enum *c_84_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Nepali); }
static QLocale_Language_Enum *c_85_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Norwegian); }
static QLocale_Language_Enum *c_86_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::NorwegianBokmal); }
static QLocale_Language_Enum *c_87_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Occitan); }
static QLocale_Language_Enum *c_88_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Oriya); }
static QLocale_Language_Enum *c_89_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Pashto); }
static QLocale_Language_Enum *c_90_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Persian); }
static QLocale_Language_Enum *c_91_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Polish); }
static QLocale_Language_Enum *c_92_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Portuguese); }
static QLocale_Language_Enum *c_93_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Punjabi); }
static QLocale_Language_Enum *c_94_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Quechua); }
static QLocale_Language_Enum *c_95_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::RhaetoRomance); }
static QLocale_Language_Enum *c_96_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Romanian); }
static QLocale_Language_Enum *c_97_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Russian); }
static QLocale_Language_Enum *c_98_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Samoan); }
static QLocale_Language_Enum *c_99_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Sangho); }
static QLocale_Language_Enum *c_100_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Sanskrit); }
static QLocale_Language_Enum *c_101_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Serbian); }
static QLocale_Language_Enum *c_102_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::SerboCroatian); }
static QLocale_Language_Enum *c_103_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Sesotho); }
static QLocale_Language_Enum *c_104_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Setswana); }
static QLocale_Language_Enum *c_105_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Shona); }
static QLocale_Language_Enum *c_106_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Sindhi); }
static QLocale_Language_Enum *c_107_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Singhalese); }
static QLocale_Language_Enum *c_108_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Siswati); }
static QLocale_Language_Enum *c_109_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Slovak); }
static QLocale_Language_Enum *c_110_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Slovenian); }
static QLocale_Language_Enum *c_111_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Somali); }
static QLocale_Language_Enum *c_112_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Spanish); }
static QLocale_Language_Enum *c_113_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Sundanese); }
static QLocale_Language_Enum *c_114_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Swahili); }
static QLocale_Language_Enum *c_115_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Swedish); }
static QLocale_Language_Enum *c_116_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Tagalog); }
static QLocale_Language_Enum *c_117_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Tajik); }
static QLocale_Language_Enum *c_118_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Tamil); }
static QLocale_Language_Enum *c_119_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Tatar); }
static QLocale_Language_Enum *c_120_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Telugu); }
static QLocale_Language_Enum *c_121_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Thai); }
static QLocale_Language_Enum *c_122_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Tibetan); }
static QLocale_Language_Enum *c_123_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Tigrinya); }
static QLocale_Language_Enum *c_124_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::TongaLanguage); }
static QLocale_Language_Enum *c_125_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Tsonga); }
static QLocale_Language_Enum *c_126_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Turkish); }
static QLocale_Language_Enum *c_127_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Turkmen); }
static QLocale_Language_Enum *c_128_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Twi); }
static QLocale_Language_Enum *c_129_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Uigur); }
static QLocale_Language_Enum *c_130_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Ukrainian); }
static QLocale_Language_Enum *c_131_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Urdu); }
static QLocale_Language_Enum *c_132_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Uzbek); }
static QLocale_Language_Enum *c_133_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Vietnamese); }
static QLocale_Language_Enum *c_134_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Volapuk); }
static QLocale_Language_Enum *c_135_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Welsh); }
static QLocale_Language_Enum *c_136_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Wolof); }
static QLocale_Language_Enum *c_137_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Xhosa); }
static QLocale_Language_Enum *c_138_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Yiddish); }
static QLocale_Language_Enum *c_139_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Yoruba); }
static QLocale_Language_Enum *c_140_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Zhuang); }
static QLocale_Language_Enum *c_141_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Zulu); }
static QLocale_Language_Enum *c_142_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::NorwegianNynorsk); }
static QLocale_Language_Enum *c_143_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Nynorsk); }
static QLocale_Language_Enum *c_144_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Bosnian); }
static QLocale_Language_Enum *c_145_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Divehi); }
static QLocale_Language_Enum *c_146_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Manx); }
static QLocale_Language_Enum *c_147_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Cornish); }
static QLocale_Language_Enum *c_148_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Akan); }
static QLocale_Language_Enum *c_149_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Konkani); }
static QLocale_Language_Enum *c_150_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Ga); }
static QLocale_Language_Enum *c_151_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Igbo); }
static QLocale_Language_Enum *c_152_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Kamba); }
static QLocale_Language_Enum *c_153_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Syriac); }
static QLocale_Language_Enum *c_154_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Blin); }
static QLocale_Language_Enum *c_155_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Geez); }
static QLocale_Language_Enum *c_156_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Koro); }
static QLocale_Language_Enum *c_157_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Sidamo); }
static QLocale_Language_Enum *c_158_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Atsam); }
static QLocale_Language_Enum *c_159_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Tigre); }
static QLocale_Language_Enum *c_160_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Jju); }
static QLocale_Language_Enum *c_161_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Friulian); }
static QLocale_Language_Enum *c_162_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Venda); }
static QLocale_Language_Enum *c_163_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Ewe); }
static QLocale_Language_Enum *c_164_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Walamo); }
static QLocale_Language_Enum *c_165_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Hawaiian); }
static QLocale_Language_Enum *c_166_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Tyap); }
static QLocale_Language_Enum *c_167_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::Chewa); }
static QLocale_Language_Enum *c_168_QLocale_Language_Enum () { return new QLocale_Language_Enum (QLocale::LastLanguage); }

static gsi::Methods mkdefs_QLocale_Language () {
  return
    gsi::constant ("C", &qt_gsi::c_1_QLocale_Language_Enum, "@brief Enum constant QLocale::C") +
    gsi::constant ("Abkhazian", &qt_gsi::c_2_QLocale_Language_Enum, "@brief Enum constant QLocale::Abkhazian") +
    gsi::constant ("Afan", &qt_gsi::c_3_QLocale_Language_Enum, "@brief Enum constant QLocale::Afan") +
    gsi::constant ("Afar", &qt_gsi::c_4_QLocale_Language_Enum, "@brief Enum constant QLocale::Afar") +
    gsi::constant ("Afrikaans", &qt_gsi::c_5_QLocale_Language_Enum, "@brief Enum constant QLocale::Afrikaans") +
    gsi::constant ("Albanian", &qt_gsi::c_6_QLocale_Language_Enum, "@brief Enum constant QLocale::Albanian") +
    gsi::constant ("Amharic", &qt_gsi::c_7_QLocale_Language_Enum, "@brief Enum constant QLocale::Amharic") +
    gsi::constant ("Arabic", &qt_gsi::c_8_QLocale_Language_Enum, "@brief Enum constant QLocale::Arabic") +
    gsi::constant ("Armenian", &qt_gsi::c_9_QLocale_Language_Enum, "@brief Enum constant QLocale::Armenian") +
    gsi::constant ("Assamese", &qt_gsi::c_10_QLocale_Language_Enum, "@brief Enum constant QLocale::Assamese") +
    gsi::constant ("Aymara", &qt_gsi::c_11_QLocale_Language_Enum, "@brief Enum constant QLocale::Aymara") +
    gsi::constant ("Azerbaijani", &qt_gsi::c_12_QLocale_Language_Enum, "@brief Enum constant QLocale::Azerbaijani") +
    gsi::constant ("Bashkir", &qt_gsi::c_13_QLocale_Language_Enum, "@brief Enum constant QLocale::Bashkir") +
    gsi::constant ("Basque", &qt_gsi::c_14_QLocale_Language_Enum, "@brief Enum constant QLocale::Basque") +
    gsi::constant ("Bengali", &qt_gsi::c_15_QLocale_Language_Enum, "@brief Enum constant QLocale::Bengali") +
    gsi::constant ("Bhutani", &qt_gsi::c_16_QLocale_Language_Enum, "@brief Enum constant QLocale::Bhutani") +
    gsi::constant ("Bihari", &qt_gsi::c_17_QLocale_Language_Enum, "@brief Enum constant QLocale::Bihari") +
    gsi::constant ("Bislama", &qt_gsi::c_18_QLocale_Language_Enum, "@brief Enum constant QLocale::Bislama") +
    gsi::constant ("Breton", &qt_gsi::c_19_QLocale_Language_Enum, "@brief Enum constant QLocale::Breton") +
    gsi::constant ("Bulgarian", &qt_gsi::c_20_QLocale_Language_Enum, "@brief Enum constant QLocale::Bulgarian") +
    gsi::constant ("Burmese", &qt_gsi::c_21_QLocale_Language_Enum, "@brief Enum constant QLocale::Burmese") +
    gsi::constant ("Byelorussian", &qt_gsi::c_22_QLocale_Language_Enum, "@brief Enum constant QLocale::Byelorussian") +
    gsi::constant ("Cambodian", &qt_gsi::c_23_QLocale_Language_Enum, "@brief Enum constant QLocale::Cambodian") +
    gsi::constant ("Catalan", &qt_gsi::c_24_QLocale_Language_Enum, "@brief Enum constant QLocale::Catalan") +
    gsi::constant ("Chinese", &qt_gsi::c_25_QLocale_Language_Enum, "@brief Enum constant QLocale::Chinese") +
    gsi::constant ("Corsican", &qt_gsi::c_26_QLocale_Language_Enum, "@brief Enum constant QLocale::Corsican") +
    gsi::constant ("Croatian", &qt_gsi::c_27_QLocale_Language_Enum, "@brief Enum constant QLocale::Croatian") +
    gsi::constant ("Czech", &qt_gsi::c_28_QLocale_Language_Enum, "@brief Enum constant QLocale::Czech") +
    gsi::constant ("Danish", &qt_gsi::c_29_QLocale_Language_Enum, "@brief Enum constant QLocale::Danish") +
    gsi::constant ("Dutch", &qt_gsi::c_30_QLocale_Language_Enum, "@brief Enum constant QLocale::Dutch") +
    gsi::constant ("English", &qt_gsi::c_31_QLocale_Language_Enum, "@brief Enum constant QLocale::English") +
    gsi::constant ("Esperanto", &qt_gsi::c_32_QLocale_Language_Enum, "@brief Enum constant QLocale::Esperanto") +
    gsi::constant ("Estonian", &qt_gsi::c_33_QLocale_Language_Enum, "@brief Enum constant QLocale::Estonian") +
    gsi::constant ("Faroese", &qt_gsi::c_34_QLocale_Language_Enum, "@brief Enum constant QLocale::Faroese") +
    gsi::constant ("FijiLanguage", &qt_gsi::c_35_QLocale_Language_Enum, "@brief Enum constant QLocale::FijiLanguage") +
    gsi::constant ("Finnish", &qt_gsi::c_36_QLocale_Language_Enum, "@brief Enum constant QLocale::Finnish") +
    gsi::constant ("French", &qt_gsi::c_37_QLocale_Language_Enum, "@brief Enum constant QLocale::French") +
    gsi::constant ("Frisian", &qt_gsi::c_38_QLocale_Language_Enum, "@brief Enum constant QLocale::Frisian") +
    gsi::constant ("Gaelic", &qt_gsi::c_39_QLocale_Language_Enum, "@brief Enum constant QLocale::Gaelic") +
    gsi::constant ("Galician", &qt_gsi::c_40_QLocale_Language_Enum, "@brief Enum constant QLocale::Galician") +
    gsi::constant ("Georgian", &qt_gsi::c_41_QLocale_Language_Enum, "@brief Enum constant QLocale::Georgian") +
    gsi::constant ("German", &qt_gsi::c_42_QLocale_Language_Enum, "@brief Enum constant QLocale::German") +
    gsi::constant ("Greek", &qt_gsi::c_43_QLocale_Language_Enum, "@brief Enum constant QLocale::Greek") +
    gsi::constant ("Greenlandic", &qt_gsi::c_44_QLocale_Language_Enum, "@brief Enum constant QLocale::Greenlandic") +
    gsi::constant ("Guarani", &qt_gsi::c_45_QLocale_Language_Enum, "@brief Enum constant QLocale::Guarani") +
    gsi::constant ("Gujarati", &qt_gsi::c_46_QLocale_Language_Enum, "@brief Enum constant QLocale::Gujarati") +
    gsi::constant ("Hausa", &qt_gsi::c_47_QLocale_Language_Enum, "@brief Enum constant QLocale::Hausa") +
    gsi::constant ("Hebrew", &qt_gsi::c_48_QLocale_Language_Enum, "@brief Enum constant QLocale::Hebrew") +
    gsi::constant ("Hindi", &qt_gsi::c_49_QLocale_Language_Enum, "@brief Enum constant QLocale::Hindi") +
    gsi::constant ("Hungarian", &qt_gsi::c_50_QLocale_Language_Enum, "@brief Enum constant QLocale::Hungarian") +
    gsi::constant ("Icelandic", &qt_gsi::c_51_QLocale_Language_Enum, "@brief Enum constant QLocale::Icelandic") +
    gsi::constant ("Indonesian", &qt_gsi::c_52_QLocale_Language_Enum, "@brief Enum constant QLocale::Indonesian") +
    gsi::constant ("Interlingua", &qt_gsi::c_53_QLocale_Language_Enum, "@brief Enum constant QLocale::Interlingua") +
    gsi::constant ("Interlingue", &qt_gsi::c_54_QLocale_Language_Enum, "@brief Enum constant QLocale::Interlingue") +
    gsi::constant ("Inuktitut", &qt_gsi::c_55_QLocale_Language_Enum, "@brief Enum constant QLocale::Inuktitut") +
    gsi::constant ("Inupiak", &qt_gsi::c_56_QLocale_Language_Enum, "@brief Enum constant QLocale::Inupiak") +
    gsi::constant ("Irish", &qt_gsi::c_57_QLocale_Language_Enum, "@brief Enum constant QLocale::Irish") +
    gsi::constant ("Italian", &qt_gsi::c_58_QLocale_Language_Enum, "@brief Enum constant QLocale::Italian") +
    gsi::constant ("Japanese", &qt_gsi::c_59_QLocale_Language_Enum, "@brief Enum constant QLocale::Japanese") +
    gsi::constant ("Javanese", &qt_gsi::c_60_QLocale_Language_Enum, "@brief Enum constant QLocale::Javanese") +
    gsi::constant ("Kannada", &qt_gsi::c_61_QLocale_Language_Enum, "@brief Enum constant QLocale::Kannada") +
    gsi::constant ("Kashmiri", &qt_gsi::c_62_QLocale_Language_Enum, "@brief Enum constant QLocale::Kashmiri") +
    gsi::constant ("Kazakh", &qt_gsi::c_63_QLocale_Language_Enum, "@brief Enum constant QLocale::Kazakh") +
    gsi::constant ("Kinyarwanda", &qt_gsi::c_64_QLocale_Language_Enum, "@brief Enum constant QLocale::Kinyarwanda") +
    gsi::constant ("Kirghiz", &qt_gsi::c_65_QLocale_Language_Enum, "@brief Enum constant QLocale::Kirghiz") +
    gsi::constant ("Korean", &qt_gsi::c_66_QLocale_Language_Enum, "@brief Enum constant QLocale::Korean") +
    gsi::constant ("Kurdish", &qt_gsi::c_67_QLocale_Language_Enum, "@brief Enum constant QLocale::Kurdish") +
    gsi::constant ("Kurundi", &qt_gsi::c_68_QLocale_Language_Enum, "@brief Enum constant QLocale::Kurundi") +
    gsi::constant ("Laothian", &qt_gsi::c_69_QLocale_Language_Enum, "@brief Enum constant QLocale::Laothian") +
    gsi::constant ("Latin", &qt_gsi::c_70_QLocale_Language_Enum, "@brief Enum constant QLocale::Latin") +
    gsi::constant ("Latvian", &qt_gsi::c_71_QLocale_Language_Enum, "@brief Enum constant QLocale::Latvian") +
    gsi::constant ("Lingala", &qt_gsi::c_72_QLocale_Language_Enum, "@brief Enum constant QLocale::Lingala") +
    gsi::constant ("Lithuanian", &qt_gsi::c_73_QLocale_Language_Enum, "@brief Enum constant QLocale::Lithuanian") +
    gsi::constant ("Macedonian", &qt_gsi::c_74_QLocale_Language_Enum, "@brief Enum constant QLocale::Macedonian") +
    gsi::constant ("Malagasy", &qt_gsi::c_75_QLocale_Language_Enum, "@brief Enum constant QLocale::Malagasy") +
    gsi::constant ("Malay", &qt_gsi::c_76_QLocale_Language_Enum, "@brief Enum constant QLocale::Malay") +
    gsi::constant ("Malayalam", &qt_gsi::c_77_QLocale_Language_Enum, "@brief Enum constant QLocale::Malayalam") +
    gsi::constant ("Maltese", &qt_gsi::c_78_QLocale_Language_Enum, "@brief Enum constant QLocale::Maltese") +
    gsi::constant ("Maori", &qt_gsi::c_79_QLocale_Language_Enum, "@brief Enum constant QLocale::Maori") +
    gsi::constant ("Marathi", &qt_gsi::c_80_QLocale_Language_Enum, "@brief Enum constant QLocale::Marathi") +
    gsi::constant ("Moldavian", &qt_gsi::c_81_QLocale_Language_Enum, "@brief Enum constant QLocale::Moldavian") +
    gsi::constant ("Mongolian", &qt_gsi::c_82_QLocale_Language_Enum, "@brief Enum constant QLocale::Mongolian") +
    gsi::constant ("NauruLanguage", &qt_gsi::c_83_QLocale_Language_Enum, "@brief Enum constant QLocale::NauruLanguage") +
    gsi::constant ("Nepali", &qt_gsi::c_84_QLocale_Language_Enum, "@brief Enum constant QLocale::Nepali") +
    gsi::constant ("Norwegian", &qt_gsi::c_85_QLocale_Language_Enum, "@brief Enum constant QLocale::Norwegian") +
    gsi::constant ("NorwegianBokmal", &qt_gsi::c_86_QLocale_Language_Enum, "@brief Enum constant QLocale::NorwegianBokmal") +
    gsi::constant ("Occitan", &qt_gsi::c_87_QLocale_Language_Enum, "@brief Enum constant QLocale::Occitan") +
    gsi::constant ("Oriya", &qt_gsi::c_88_QLocale_Language_Enum, "@brief Enum constant QLocale::Oriya") +
    gsi::constant ("Pashto", &qt_gsi::c_89_QLocale_Language_Enum, "@brief Enum constant QLocale::Pashto") +
    gsi::constant ("Persian", &qt_gsi::c_90_QLocale_Language_Enum, "@brief Enum constant QLocale::Persian") +
    gsi::constant ("Polish", &qt_gsi::c_91_QLocale_Language_Enum, "@brief Enum constant QLocale::Polish") +
    gsi::constant ("Portuguese", &qt_gsi::c_92_QLocale_Language_Enum, "@brief Enum constant QLocale::Portuguese") +
    gsi::constant ("Punjabi", &qt_gsi::c_93_QLocale_Language_Enum, "@brief Enum constant QLocale::Punjabi") +
    gsi::constant ("Quechua", &qt_gsi::c_94_QLocale_Language_Enum, "@brief Enum constant QLocale::Quechua") +
    gsi::constant ("RhaetoRomance", &qt_gsi::c_95_QLocale_Language_Enum, "@brief Enum constant QLocale::RhaetoRomance") +
    gsi::constant ("Romanian", &qt_gsi::c_96_QLocale_Language_Enum, "@brief Enum constant QLocale::Romanian") +
    gsi::constant ("Russian", &qt_gsi::c_97_QLocale_Language_Enum, "@brief Enum constant QLocale::Russian") +
    gsi::constant ("Samoan", &qt_gsi::c_98_QLocale_Language_Enum, "@brief Enum constant QLocale::Samoan") +
    gsi::constant ("Sangho", &qt_gsi::c_99_QLocale_Language_Enum, "@brief Enum constant QLocale::Sangho") +
    gsi::constant ("Sanskrit", &qt_gsi::c_100_QLocale_Language_Enum, "@brief Enum constant QLocale::Sanskrit") +
    gsi::constant ("Serbian", &qt_gsi::c_101_QLocale_Language_Enum, "@brief Enum constant QLocale::Serbian") +
    gsi::constant ("SerboCroatian", &qt_gsi::c_102_QLocale_Language_Enum, "@brief Enum constant QLocale::SerboCroatian") +
    gsi::constant ("Sesotho", &qt_gsi::c_103_QLocale_Language_Enum, "@brief Enum constant QLocale::Sesotho") +
    gsi::constant ("Setswana", &qt_gsi::c_104_QLocale_Language_Enum, "@brief Enum constant QLocale::Setswana") +
    gsi::constant ("Shona", &qt_gsi::c_105_QLocale_Language_Enum, "@brief Enum constant QLocale::Shona") +
    gsi::constant ("Sindhi", &qt_gsi::c_106_QLocale_Language_Enum, "@brief Enum constant QLocale::Sindhi") +
    gsi::constant ("Singhalese", &qt_gsi::c_107_QLocale_Language_Enum, "@brief Enum constant QLocale::Singhalese") +
    gsi::constant ("Siswati", &qt_gsi::c_108_QLocale_Language_Enum, "@brief Enum constant QLocale::Siswati") +
    gsi::constant ("Slovak", &qt_gsi::c_109_QLocale_Language_Enum, "@brief Enum constant QLocale::Slovak") +
    gsi::constant ("Slovenian", &qt_gsi::c_110_QLocale_Language_Enum, "@brief Enum constant QLocale::Slovenian") +
    gsi::constant ("Somali", &qt_gsi::c_111_QLocale_Language_Enum, "@brief Enum constant QLocale::Somali") +
    gsi::constant ("Spanish", &qt_gsi::c_112_QLocale_Language_Enum, "@brief Enum constant QLocale::Spanish") +
    gsi::constant ("Sundanese", &qt_gsi::c_113_QLocale_Language_Enum, "@brief Enum constant QLocale::Sundanese") +
    gsi::constant ("Swahili", &qt_gsi::c_114_QLocale_Language_Enum, "@brief Enum constant QLocale::Swahili") +
    gsi::constant ("Swedish", &qt_gsi::c_115_QLocale_Language_Enum, "@brief Enum constant QLocale::Swedish") +
    gsi::constant ("Tagalog", &qt_gsi::c_116_QLocale_Language_Enum, "@brief Enum constant QLocale::Tagalog") +
    gsi::constant ("Tajik", &qt_gsi::c_117_QLocale_Language_Enum, "@brief Enum constant QLocale::Tajik") +
    gsi::constant ("Tamil", &qt_gsi::c_118_QLocale_Language_Enum, "@brief Enum constant QLocale::Tamil") +
    gsi::constant ("Tatar", &qt_gsi::c_119_QLocale_Language_Enum, "@brief Enum constant QLocale::Tatar") +
    gsi::constant ("Telugu", &qt_gsi::c_120_QLocale_Language_Enum, "@brief Enum constant QLocale::Telugu") +
    gsi::constant ("Thai", &qt_gsi::c_121_QLocale_Language_Enum, "@brief Enum constant QLocale::Thai") +
    gsi::constant ("Tibetan", &qt_gsi::c_122_QLocale_Language_Enum, "@brief Enum constant QLocale::Tibetan") +
    gsi::constant ("Tigrinya", &qt_gsi::c_123_QLocale_Language_Enum, "@brief Enum constant QLocale::Tigrinya") +
    gsi::constant ("TongaLanguage", &qt_gsi::c_124_QLocale_Language_Enum, "@brief Enum constant QLocale::TongaLanguage") +
    gsi::constant ("Tsonga", &qt_gsi::c_125_QLocale_Language_Enum, "@brief Enum constant QLocale::Tsonga") +
    gsi::constant ("Turkish", &qt_gsi::c_126_QLocale_Language_Enum, "@brief Enum constant QLocale::Turkish") +
    gsi::constant ("Turkmen", &qt_gsi::c_127_QLocale_Language_Enum, "@brief Enum constant QLocale::Turkmen") +
    gsi::constant ("Twi", &qt_gsi::c_128_QLocale_Language_Enum, "@brief Enum constant QLocale::Twi") +
    gsi::constant ("Uigur", &qt_gsi::c_129_QLocale_Language_Enum, "@brief Enum constant QLocale::Uigur") +
    gsi::constant ("Ukrainian", &qt_gsi::c_130_QLocale_Language_Enum, "@brief Enum constant QLocale::Ukrainian") +
    gsi::constant ("Urdu", &qt_gsi::c_131_QLocale_Language_Enum, "@brief Enum constant QLocale::Urdu") +
    gsi::constant ("Uzbek", &qt_gsi::c_132_QLocale_Language_Enum, "@brief Enum constant QLocale::Uzbek") +
    gsi::constant ("Vietnamese", &qt_gsi::c_133_QLocale_Language_Enum, "@brief Enum constant QLocale::Vietnamese") +
    gsi::constant ("Volapuk", &qt_gsi::c_134_QLocale_Language_Enum, "@brief Enum constant QLocale::Volapuk") +
    gsi::constant ("Welsh", &qt_gsi::c_135_QLocale_Language_Enum, "@brief Enum constant QLocale::Welsh") +
    gsi::constant ("Wolof", &qt_gsi::c_136_QLocale_Language_Enum, "@brief Enum constant QLocale::Wolof") +
    gsi::constant ("Xhosa", &qt_gsi::c_137_QLocale_Language_Enum, "@brief Enum constant QLocale::Xhosa") +
    gsi::constant ("Yiddish", &qt_gsi::c_138_QLocale_Language_Enum, "@brief Enum constant QLocale::Yiddish") +
    gsi::constant ("Yoruba", &qt_gsi::c_139_QLocale_Language_Enum, "@brief Enum constant QLocale::Yoruba") +
    gsi::constant ("Zhuang", &qt_gsi::c_140_QLocale_Language_Enum, "@brief Enum constant QLocale::Zhuang") +
    gsi::constant ("Zulu", &qt_gsi::c_141_QLocale_Language_Enum, "@brief Enum constant QLocale::Zulu") +
    gsi::constant ("NorwegianNynorsk", &qt_gsi::c_142_QLocale_Language_Enum, "@brief Enum constant QLocale::NorwegianNynorsk") +
    gsi::constant ("Nynorsk", &qt_gsi::c_143_QLocale_Language_Enum, "@brief Enum constant QLocale::Nynorsk") +
    gsi::constant ("Bosnian", &qt_gsi::c_144_QLocale_Language_Enum, "@brief Enum constant QLocale::Bosnian") +
    gsi::constant ("Divehi", &qt_gsi::c_145_QLocale_Language_Enum, "@brief Enum constant QLocale::Divehi") +
    gsi::constant ("Manx", &qt_gsi::c_146_QLocale_Language_Enum, "@brief Enum constant QLocale::Manx") +
    gsi::constant ("Cornish", &qt_gsi::c_147_QLocale_Language_Enum, "@brief Enum constant QLocale::Cornish") +
    gsi::constant ("Akan", &qt_gsi::c_148_QLocale_Language_Enum, "@brief Enum constant QLocale::Akan") +
    gsi::constant ("Konkani", &qt_gsi::c_149_QLocale_Language_Enum, "@brief Enum constant QLocale::Konkani") +
    gsi::constant ("Ga", &qt_gsi::c_150_QLocale_Language_Enum, "@brief Enum constant QLocale::Ga") +
    gsi::constant ("Igbo", &qt_gsi::c_151_QLocale_Language_Enum, "@brief Enum constant QLocale::Igbo") +
    gsi::constant ("Kamba", &qt_gsi::c_152_QLocale_Language_Enum, "@brief Enum constant QLocale::Kamba") +
    gsi::constant ("Syriac", &qt_gsi::c_153_QLocale_Language_Enum, "@brief Enum constant QLocale::Syriac") +
    gsi::constant ("Blin", &qt_gsi::c_154_QLocale_Language_Enum, "@brief Enum constant QLocale::Blin") +
    gsi::constant ("Geez", &qt_gsi::c_155_QLocale_Language_Enum, "@brief Enum constant QLocale::Geez") +
    gsi::constant ("Koro", &qt_gsi::c_156_QLocale_Language_Enum, "@brief Enum constant QLocale::Koro") +
    gsi::constant ("Sidamo", &qt_gsi::c_157_QLocale_Language_Enum, "@brief Enum constant QLocale::Sidamo") +
    gsi::constant ("Atsam", &qt_gsi::c_158_QLocale_Language_Enum, "@brief Enum constant QLocale::Atsam") +
    gsi::constant ("Tigre", &qt_gsi::c_159_QLocale_Language_Enum, "@brief Enum constant QLocale::Tigre") +
    gsi::constant ("Jju", &qt_gsi::c_160_QLocale_Language_Enum, "@brief Enum constant QLocale::Jju") +
    gsi::constant ("Friulian", &qt_gsi::c_161_QLocale_Language_Enum, "@brief Enum constant QLocale::Friulian") +
    gsi::constant ("Venda", &qt_gsi::c_162_QLocale_Language_Enum, "@brief Enum constant QLocale::Venda") +
    gsi::constant ("Ewe", &qt_gsi::c_163_QLocale_Language_Enum, "@brief Enum constant QLocale::Ewe") +
    gsi::constant ("Walamo", &qt_gsi::c_164_QLocale_Language_Enum, "@brief Enum constant QLocale::Walamo") +
    gsi::constant ("Hawaiian", &qt_gsi::c_165_QLocale_Language_Enum, "@brief Enum constant QLocale::Hawaiian") +
    gsi::constant ("Tyap", &qt_gsi::c_166_QLocale_Language_Enum, "@brief Enum constant QLocale::Tyap") +
    gsi::constant ("Chewa", &qt_gsi::c_167_QLocale_Language_Enum, "@brief Enum constant QLocale::Chewa") +
    gsi::constant ("LastLanguage", &qt_gsi::c_168_QLocale_Language_Enum, "@brief Enum constant QLocale::LastLanguage");
}

static std::string to_s_QLocale_Language_Enum (const QLocale_Language_Enum *e)
{
  if (e->value () == QLocale::C) { return tl::sprintf ("C (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Abkhazian) { return tl::sprintf ("Abkhazian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Afan) { return tl::sprintf ("Afan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Afar) { return tl::sprintf ("Afar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Afrikaans) { return tl::sprintf ("Afrikaans (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Albanian) { return tl::sprintf ("Albanian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Amharic) { return tl::sprintf ("Amharic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Arabic) { return tl::sprintf ("Arabic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Armenian) { return tl::sprintf ("Armenian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Assamese) { return tl::sprintf ("Assamese (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Aymara) { return tl::sprintf ("Aymara (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Azerbaijani) { return tl::sprintf ("Azerbaijani (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Bashkir) { return tl::sprintf ("Bashkir (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Basque) { return tl::sprintf ("Basque (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Bengali) { return tl::sprintf ("Bengali (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Bhutani) { return tl::sprintf ("Bhutani (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Bihari) { return tl::sprintf ("Bihari (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Bislama) { return tl::sprintf ("Bislama (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Breton) { return tl::sprintf ("Breton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Bulgarian) { return tl::sprintf ("Bulgarian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Burmese) { return tl::sprintf ("Burmese (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Byelorussian) { return tl::sprintf ("Byelorussian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Cambodian) { return tl::sprintf ("Cambodian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Catalan) { return tl::sprintf ("Catalan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Chinese) { return tl::sprintf ("Chinese (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Corsican) { return tl::sprintf ("Corsican (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Croatian) { return tl::sprintf ("Croatian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Czech) { return tl::sprintf ("Czech (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Danish) { return tl::sprintf ("Danish (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Dutch) { return tl::sprintf ("Dutch (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::English) { return tl::sprintf ("English (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Esperanto) { return tl::sprintf ("Esperanto (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Estonian) { return tl::sprintf ("Estonian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Faroese) { return tl::sprintf ("Faroese (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::FijiLanguage) { return tl::sprintf ("FijiLanguage (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Finnish) { return tl::sprintf ("Finnish (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::French) { return tl::sprintf ("French (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Frisian) { return tl::sprintf ("Frisian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Gaelic) { return tl::sprintf ("Gaelic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Galician) { return tl::sprintf ("Galician (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Georgian) { return tl::sprintf ("Georgian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::German) { return tl::sprintf ("German (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Greek) { return tl::sprintf ("Greek (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Greenlandic) { return tl::sprintf ("Greenlandic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Guarani) { return tl::sprintf ("Guarani (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Gujarati) { return tl::sprintf ("Gujarati (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Hausa) { return tl::sprintf ("Hausa (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Hebrew) { return tl::sprintf ("Hebrew (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Hindi) { return tl::sprintf ("Hindi (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Hungarian) { return tl::sprintf ("Hungarian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Icelandic) { return tl::sprintf ("Icelandic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Indonesian) { return tl::sprintf ("Indonesian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Interlingua) { return tl::sprintf ("Interlingua (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Interlingue) { return tl::sprintf ("Interlingue (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Inuktitut) { return tl::sprintf ("Inuktitut (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Inupiak) { return tl::sprintf ("Inupiak (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Irish) { return tl::sprintf ("Irish (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Italian) { return tl::sprintf ("Italian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Japanese) { return tl::sprintf ("Japanese (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Javanese) { return tl::sprintf ("Javanese (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Kannada) { return tl::sprintf ("Kannada (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Kashmiri) { return tl::sprintf ("Kashmiri (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Kazakh) { return tl::sprintf ("Kazakh (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Kinyarwanda) { return tl::sprintf ("Kinyarwanda (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Kirghiz) { return tl::sprintf ("Kirghiz (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Korean) { return tl::sprintf ("Korean (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Kurdish) { return tl::sprintf ("Kurdish (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Kurundi) { return tl::sprintf ("Kurundi (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Laothian) { return tl::sprintf ("Laothian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Latin) { return tl::sprintf ("Latin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Latvian) { return tl::sprintf ("Latvian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Lingala) { return tl::sprintf ("Lingala (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Lithuanian) { return tl::sprintf ("Lithuanian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Macedonian) { return tl::sprintf ("Macedonian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Malagasy) { return tl::sprintf ("Malagasy (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Malay) { return tl::sprintf ("Malay (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Malayalam) { return tl::sprintf ("Malayalam (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Maltese) { return tl::sprintf ("Maltese (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Maori) { return tl::sprintf ("Maori (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Marathi) { return tl::sprintf ("Marathi (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Moldavian) { return tl::sprintf ("Moldavian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Mongolian) { return tl::sprintf ("Mongolian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::NauruLanguage) { return tl::sprintf ("NauruLanguage (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Nepali) { return tl::sprintf ("Nepali (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Norwegian) { return tl::sprintf ("Norwegian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::NorwegianBokmal) { return tl::sprintf ("NorwegianBokmal (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Occitan) { return tl::sprintf ("Occitan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Oriya) { return tl::sprintf ("Oriya (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Pashto) { return tl::sprintf ("Pashto (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Persian) { return tl::sprintf ("Persian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Polish) { return tl::sprintf ("Polish (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Portuguese) { return tl::sprintf ("Portuguese (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Punjabi) { return tl::sprintf ("Punjabi (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Quechua) { return tl::sprintf ("Quechua (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::RhaetoRomance) { return tl::sprintf ("RhaetoRomance (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Romanian) { return tl::sprintf ("Romanian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Russian) { return tl::sprintf ("Russian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Samoan) { return tl::sprintf ("Samoan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Sangho) { return tl::sprintf ("Sangho (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Sanskrit) { return tl::sprintf ("Sanskrit (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Serbian) { return tl::sprintf ("Serbian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::SerboCroatian) { return tl::sprintf ("SerboCroatian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Sesotho) { return tl::sprintf ("Sesotho (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Setswana) { return tl::sprintf ("Setswana (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Shona) { return tl::sprintf ("Shona (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Sindhi) { return tl::sprintf ("Sindhi (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Singhalese) { return tl::sprintf ("Singhalese (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Siswati) { return tl::sprintf ("Siswati (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Slovak) { return tl::sprintf ("Slovak (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Slovenian) { return tl::sprintf ("Slovenian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Somali) { return tl::sprintf ("Somali (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Spanish) { return tl::sprintf ("Spanish (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Sundanese) { return tl::sprintf ("Sundanese (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Swahili) { return tl::sprintf ("Swahili (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Swedish) { return tl::sprintf ("Swedish (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Tagalog) { return tl::sprintf ("Tagalog (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Tajik) { return tl::sprintf ("Tajik (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Tamil) { return tl::sprintf ("Tamil (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Tatar) { return tl::sprintf ("Tatar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Telugu) { return tl::sprintf ("Telugu (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Thai) { return tl::sprintf ("Thai (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Tibetan) { return tl::sprintf ("Tibetan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Tigrinya) { return tl::sprintf ("Tigrinya (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::TongaLanguage) { return tl::sprintf ("TongaLanguage (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Tsonga) { return tl::sprintf ("Tsonga (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Turkish) { return tl::sprintf ("Turkish (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Turkmen) { return tl::sprintf ("Turkmen (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Twi) { return tl::sprintf ("Twi (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Uigur) { return tl::sprintf ("Uigur (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Ukrainian) { return tl::sprintf ("Ukrainian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Urdu) { return tl::sprintf ("Urdu (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Uzbek) { return tl::sprintf ("Uzbek (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Vietnamese) { return tl::sprintf ("Vietnamese (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Volapuk) { return tl::sprintf ("Volapuk (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Welsh) { return tl::sprintf ("Welsh (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Wolof) { return tl::sprintf ("Wolof (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Xhosa) { return tl::sprintf ("Xhosa (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Yiddish) { return tl::sprintf ("Yiddish (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Yoruba) { return tl::sprintf ("Yoruba (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Zhuang) { return tl::sprintf ("Zhuang (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Zulu) { return tl::sprintf ("Zulu (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::NorwegianNynorsk) { return tl::sprintf ("NorwegianNynorsk (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Nynorsk) { return tl::sprintf ("Nynorsk (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Bosnian) { return tl::sprintf ("Bosnian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Divehi) { return tl::sprintf ("Divehi (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Manx) { return tl::sprintf ("Manx (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Cornish) { return tl::sprintf ("Cornish (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Akan) { return tl::sprintf ("Akan (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Konkani) { return tl::sprintf ("Konkani (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Ga) { return tl::sprintf ("Ga (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Igbo) { return tl::sprintf ("Igbo (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Kamba) { return tl::sprintf ("Kamba (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Syriac) { return tl::sprintf ("Syriac (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Blin) { return tl::sprintf ("Blin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Geez) { return tl::sprintf ("Geez (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Koro) { return tl::sprintf ("Koro (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Sidamo) { return tl::sprintf ("Sidamo (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Atsam) { return tl::sprintf ("Atsam (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Tigre) { return tl::sprintf ("Tigre (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Jju) { return tl::sprintf ("Jju (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Friulian) { return tl::sprintf ("Friulian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Venda) { return tl::sprintf ("Venda (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Ewe) { return tl::sprintf ("Ewe (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Walamo) { return tl::sprintf ("Walamo (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Hawaiian) { return tl::sprintf ("Hawaiian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Tyap) { return tl::sprintf ("Tyap (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::Chewa) { return tl::sprintf ("Chewa (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::LastLanguage) { return tl::sprintf ("LastLanguage (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QLocale_Language_Enum (const QLocale_Language_Enum *e)
{
  return (unsigned int) e->value ();
}

static QLocale_Language_Enum *from_i_QLocale_Language_Enum (unsigned int i)
{
  return new QLocale_Language_Enum ((QLocale::Language) i);
}

static bool equalQLocale_Language_Enum (const QLocale_Language_Enum *e, QLocale_Language_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QLocale_Language_Enum (const QLocale_Language_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QLocale_Language_Enums oropQLocale_Language_Enums (const QLocale_Language_Enums *e, const QLocale_Language_Enums &d)
{
  return e->flags () | d.flags ();
}

static QLocale_Language_Enums andopQLocale_Language_Enums (const QLocale_Language_Enums *e, const QLocale_Language_Enums &d)
{
  return e->flags () & d.flags ();
}

static QLocale_Language_Enums xoropQLocale_Language_Enums (const QLocale_Language_Enums *e, const QLocale_Language_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QLocale_Language_Enums (const QLocale_Language_Enums *e)
{
  std::string l;
  if (e->testFlag (QLocale::C)) { if (!l.empty ()) l += "|"; l += "C"; }
  if (e->testFlag (QLocale::Abkhazian)) { if (!l.empty ()) l += "|"; l += "Abkhazian"; }
  if (e->testFlag (QLocale::Afan)) { if (!l.empty ()) l += "|"; l += "Afan"; }
  if (e->testFlag (QLocale::Afar)) { if (!l.empty ()) l += "|"; l += "Afar"; }
  if (e->testFlag (QLocale::Afrikaans)) { if (!l.empty ()) l += "|"; l += "Afrikaans"; }
  if (e->testFlag (QLocale::Albanian)) { if (!l.empty ()) l += "|"; l += "Albanian"; }
  if (e->testFlag (QLocale::Amharic)) { if (!l.empty ()) l += "|"; l += "Amharic"; }
  if (e->testFlag (QLocale::Arabic)) { if (!l.empty ()) l += "|"; l += "Arabic"; }
  if (e->testFlag (QLocale::Armenian)) { if (!l.empty ()) l += "|"; l += "Armenian"; }
  if (e->testFlag (QLocale::Assamese)) { if (!l.empty ()) l += "|"; l += "Assamese"; }
  if (e->testFlag (QLocale::Aymara)) { if (!l.empty ()) l += "|"; l += "Aymara"; }
  if (e->testFlag (QLocale::Azerbaijani)) { if (!l.empty ()) l += "|"; l += "Azerbaijani"; }
  if (e->testFlag (QLocale::Bashkir)) { if (!l.empty ()) l += "|"; l += "Bashkir"; }
  if (e->testFlag (QLocale::Basque)) { if (!l.empty ()) l += "|"; l += "Basque"; }
  if (e->testFlag (QLocale::Bengali)) { if (!l.empty ()) l += "|"; l += "Bengali"; }
  if (e->testFlag (QLocale::Bhutani)) { if (!l.empty ()) l += "|"; l += "Bhutani"; }
  if (e->testFlag (QLocale::Bihari)) { if (!l.empty ()) l += "|"; l += "Bihari"; }
  if (e->testFlag (QLocale::Bislama)) { if (!l.empty ()) l += "|"; l += "Bislama"; }
  if (e->testFlag (QLocale::Breton)) { if (!l.empty ()) l += "|"; l += "Breton"; }
  if (e->testFlag (QLocale::Bulgarian)) { if (!l.empty ()) l += "|"; l += "Bulgarian"; }
  if (e->testFlag (QLocale::Burmese)) { if (!l.empty ()) l += "|"; l += "Burmese"; }
  if (e->testFlag (QLocale::Byelorussian)) { if (!l.empty ()) l += "|"; l += "Byelorussian"; }
  if (e->testFlag (QLocale::Cambodian)) { if (!l.empty ()) l += "|"; l += "Cambodian"; }
  if (e->testFlag (QLocale::Catalan)) { if (!l.empty ()) l += "|"; l += "Catalan"; }
  if (e->testFlag (QLocale::Chinese)) { if (!l.empty ()) l += "|"; l += "Chinese"; }
  if (e->testFlag (QLocale::Corsican)) { if (!l.empty ()) l += "|"; l += "Corsican"; }
  if (e->testFlag (QLocale::Croatian)) { if (!l.empty ()) l += "|"; l += "Croatian"; }
  if (e->testFlag (QLocale::Czech)) { if (!l.empty ()) l += "|"; l += "Czech"; }
  if (e->testFlag (QLocale::Danish)) { if (!l.empty ()) l += "|"; l += "Danish"; }
  if (e->testFlag (QLocale::Dutch)) { if (!l.empty ()) l += "|"; l += "Dutch"; }
  if (e->testFlag (QLocale::English)) { if (!l.empty ()) l += "|"; l += "English"; }
  if (e->testFlag (QLocale::Esperanto)) { if (!l.empty ()) l += "|"; l += "Esperanto"; }
  if (e->testFlag (QLocale::Estonian)) { if (!l.empty ()) l += "|"; l += "Estonian"; }
  if (e->testFlag (QLocale::Faroese)) { if (!l.empty ()) l += "|"; l += "Faroese"; }
  if (e->testFlag (QLocale::FijiLanguage)) { if (!l.empty ()) l += "|"; l += "FijiLanguage"; }
  if (e->testFlag (QLocale::Finnish)) { if (!l.empty ()) l += "|"; l += "Finnish"; }
  if (e->testFlag (QLocale::French)) { if (!l.empty ()) l += "|"; l += "French"; }
  if (e->testFlag (QLocale::Frisian)) { if (!l.empty ()) l += "|"; l += "Frisian"; }
  if (e->testFlag (QLocale::Gaelic)) { if (!l.empty ()) l += "|"; l += "Gaelic"; }
  if (e->testFlag (QLocale::Galician)) { if (!l.empty ()) l += "|"; l += "Galician"; }
  if (e->testFlag (QLocale::Georgian)) { if (!l.empty ()) l += "|"; l += "Georgian"; }
  if (e->testFlag (QLocale::German)) { if (!l.empty ()) l += "|"; l += "German"; }
  if (e->testFlag (QLocale::Greek)) { if (!l.empty ()) l += "|"; l += "Greek"; }
  if (e->testFlag (QLocale::Greenlandic)) { if (!l.empty ()) l += "|"; l += "Greenlandic"; }
  if (e->testFlag (QLocale::Guarani)) { if (!l.empty ()) l += "|"; l += "Guarani"; }
  if (e->testFlag (QLocale::Gujarati)) { if (!l.empty ()) l += "|"; l += "Gujarati"; }
  if (e->testFlag (QLocale::Hausa)) { if (!l.empty ()) l += "|"; l += "Hausa"; }
  if (e->testFlag (QLocale::Hebrew)) { if (!l.empty ()) l += "|"; l += "Hebrew"; }
  if (e->testFlag (QLocale::Hindi)) { if (!l.empty ()) l += "|"; l += "Hindi"; }
  if (e->testFlag (QLocale::Hungarian)) { if (!l.empty ()) l += "|"; l += "Hungarian"; }
  if (e->testFlag (QLocale::Icelandic)) { if (!l.empty ()) l += "|"; l += "Icelandic"; }
  if (e->testFlag (QLocale::Indonesian)) { if (!l.empty ()) l += "|"; l += "Indonesian"; }
  if (e->testFlag (QLocale::Interlingua)) { if (!l.empty ()) l += "|"; l += "Interlingua"; }
  if (e->testFlag (QLocale::Interlingue)) { if (!l.empty ()) l += "|"; l += "Interlingue"; }
  if (e->testFlag (QLocale::Inuktitut)) { if (!l.empty ()) l += "|"; l += "Inuktitut"; }
  if (e->testFlag (QLocale::Inupiak)) { if (!l.empty ()) l += "|"; l += "Inupiak"; }
  if (e->testFlag (QLocale::Irish)) { if (!l.empty ()) l += "|"; l += "Irish"; }
  if (e->testFlag (QLocale::Italian)) { if (!l.empty ()) l += "|"; l += "Italian"; }
  if (e->testFlag (QLocale::Japanese)) { if (!l.empty ()) l += "|"; l += "Japanese"; }
  if (e->testFlag (QLocale::Javanese)) { if (!l.empty ()) l += "|"; l += "Javanese"; }
  if (e->testFlag (QLocale::Kannada)) { if (!l.empty ()) l += "|"; l += "Kannada"; }
  if (e->testFlag (QLocale::Kashmiri)) { if (!l.empty ()) l += "|"; l += "Kashmiri"; }
  if (e->testFlag (QLocale::Kazakh)) { if (!l.empty ()) l += "|"; l += "Kazakh"; }
  if (e->testFlag (QLocale::Kinyarwanda)) { if (!l.empty ()) l += "|"; l += "Kinyarwanda"; }
  if (e->testFlag (QLocale::Kirghiz)) { if (!l.empty ()) l += "|"; l += "Kirghiz"; }
  if (e->testFlag (QLocale::Korean)) { if (!l.empty ()) l += "|"; l += "Korean"; }
  if (e->testFlag (QLocale::Kurdish)) { if (!l.empty ()) l += "|"; l += "Kurdish"; }
  if (e->testFlag (QLocale::Kurundi)) { if (!l.empty ()) l += "|"; l += "Kurundi"; }
  if (e->testFlag (QLocale::Laothian)) { if (!l.empty ()) l += "|"; l += "Laothian"; }
  if (e->testFlag (QLocale::Latin)) { if (!l.empty ()) l += "|"; l += "Latin"; }
  if (e->testFlag (QLocale::Latvian)) { if (!l.empty ()) l += "|"; l += "Latvian"; }
  if (e->testFlag (QLocale::Lingala)) { if (!l.empty ()) l += "|"; l += "Lingala"; }
  if (e->testFlag (QLocale::Lithuanian)) { if (!l.empty ()) l += "|"; l += "Lithuanian"; }
  if (e->testFlag (QLocale::Macedonian)) { if (!l.empty ()) l += "|"; l += "Macedonian"; }
  if (e->testFlag (QLocale::Malagasy)) { if (!l.empty ()) l += "|"; l += "Malagasy"; }
  if (e->testFlag (QLocale::Malay)) { if (!l.empty ()) l += "|"; l += "Malay"; }
  if (e->testFlag (QLocale::Malayalam)) { if (!l.empty ()) l += "|"; l += "Malayalam"; }
  if (e->testFlag (QLocale::Maltese)) { if (!l.empty ()) l += "|"; l += "Maltese"; }
  if (e->testFlag (QLocale::Maori)) { if (!l.empty ()) l += "|"; l += "Maori"; }
  if (e->testFlag (QLocale::Marathi)) { if (!l.empty ()) l += "|"; l += "Marathi"; }
  if (e->testFlag (QLocale::Moldavian)) { if (!l.empty ()) l += "|"; l += "Moldavian"; }
  if (e->testFlag (QLocale::Mongolian)) { if (!l.empty ()) l += "|"; l += "Mongolian"; }
  if (e->testFlag (QLocale::NauruLanguage)) { if (!l.empty ()) l += "|"; l += "NauruLanguage"; }
  if (e->testFlag (QLocale::Nepali)) { if (!l.empty ()) l += "|"; l += "Nepali"; }
  if (e->testFlag (QLocale::Norwegian)) { if (!l.empty ()) l += "|"; l += "Norwegian"; }
  if (e->testFlag (QLocale::NorwegianBokmal)) { if (!l.empty ()) l += "|"; l += "NorwegianBokmal"; }
  if (e->testFlag (QLocale::Occitan)) { if (!l.empty ()) l += "|"; l += "Occitan"; }
  if (e->testFlag (QLocale::Oriya)) { if (!l.empty ()) l += "|"; l += "Oriya"; }
  if (e->testFlag (QLocale::Pashto)) { if (!l.empty ()) l += "|"; l += "Pashto"; }
  if (e->testFlag (QLocale::Persian)) { if (!l.empty ()) l += "|"; l += "Persian"; }
  if (e->testFlag (QLocale::Polish)) { if (!l.empty ()) l += "|"; l += "Polish"; }
  if (e->testFlag (QLocale::Portuguese)) { if (!l.empty ()) l += "|"; l += "Portuguese"; }
  if (e->testFlag (QLocale::Punjabi)) { if (!l.empty ()) l += "|"; l += "Punjabi"; }
  if (e->testFlag (QLocale::Quechua)) { if (!l.empty ()) l += "|"; l += "Quechua"; }
  if (e->testFlag (QLocale::RhaetoRomance)) { if (!l.empty ()) l += "|"; l += "RhaetoRomance"; }
  if (e->testFlag (QLocale::Romanian)) { if (!l.empty ()) l += "|"; l += "Romanian"; }
  if (e->testFlag (QLocale::Russian)) { if (!l.empty ()) l += "|"; l += "Russian"; }
  if (e->testFlag (QLocale::Samoan)) { if (!l.empty ()) l += "|"; l += "Samoan"; }
  if (e->testFlag (QLocale::Sangho)) { if (!l.empty ()) l += "|"; l += "Sangho"; }
  if (e->testFlag (QLocale::Sanskrit)) { if (!l.empty ()) l += "|"; l += "Sanskrit"; }
  if (e->testFlag (QLocale::Serbian)) { if (!l.empty ()) l += "|"; l += "Serbian"; }
  if (e->testFlag (QLocale::SerboCroatian)) { if (!l.empty ()) l += "|"; l += "SerboCroatian"; }
  if (e->testFlag (QLocale::Sesotho)) { if (!l.empty ()) l += "|"; l += "Sesotho"; }
  if (e->testFlag (QLocale::Setswana)) { if (!l.empty ()) l += "|"; l += "Setswana"; }
  if (e->testFlag (QLocale::Shona)) { if (!l.empty ()) l += "|"; l += "Shona"; }
  if (e->testFlag (QLocale::Sindhi)) { if (!l.empty ()) l += "|"; l += "Sindhi"; }
  if (e->testFlag (QLocale::Singhalese)) { if (!l.empty ()) l += "|"; l += "Singhalese"; }
  if (e->testFlag (QLocale::Siswati)) { if (!l.empty ()) l += "|"; l += "Siswati"; }
  if (e->testFlag (QLocale::Slovak)) { if (!l.empty ()) l += "|"; l += "Slovak"; }
  if (e->testFlag (QLocale::Slovenian)) { if (!l.empty ()) l += "|"; l += "Slovenian"; }
  if (e->testFlag (QLocale::Somali)) { if (!l.empty ()) l += "|"; l += "Somali"; }
  if (e->testFlag (QLocale::Spanish)) { if (!l.empty ()) l += "|"; l += "Spanish"; }
  if (e->testFlag (QLocale::Sundanese)) { if (!l.empty ()) l += "|"; l += "Sundanese"; }
  if (e->testFlag (QLocale::Swahili)) { if (!l.empty ()) l += "|"; l += "Swahili"; }
  if (e->testFlag (QLocale::Swedish)) { if (!l.empty ()) l += "|"; l += "Swedish"; }
  if (e->testFlag (QLocale::Tagalog)) { if (!l.empty ()) l += "|"; l += "Tagalog"; }
  if (e->testFlag (QLocale::Tajik)) { if (!l.empty ()) l += "|"; l += "Tajik"; }
  if (e->testFlag (QLocale::Tamil)) { if (!l.empty ()) l += "|"; l += "Tamil"; }
  if (e->testFlag (QLocale::Tatar)) { if (!l.empty ()) l += "|"; l += "Tatar"; }
  if (e->testFlag (QLocale::Telugu)) { if (!l.empty ()) l += "|"; l += "Telugu"; }
  if (e->testFlag (QLocale::Thai)) { if (!l.empty ()) l += "|"; l += "Thai"; }
  if (e->testFlag (QLocale::Tibetan)) { if (!l.empty ()) l += "|"; l += "Tibetan"; }
  if (e->testFlag (QLocale::Tigrinya)) { if (!l.empty ()) l += "|"; l += "Tigrinya"; }
  if (e->testFlag (QLocale::TongaLanguage)) { if (!l.empty ()) l += "|"; l += "TongaLanguage"; }
  if (e->testFlag (QLocale::Tsonga)) { if (!l.empty ()) l += "|"; l += "Tsonga"; }
  if (e->testFlag (QLocale::Turkish)) { if (!l.empty ()) l += "|"; l += "Turkish"; }
  if (e->testFlag (QLocale::Turkmen)) { if (!l.empty ()) l += "|"; l += "Turkmen"; }
  if (e->testFlag (QLocale::Twi)) { if (!l.empty ()) l += "|"; l += "Twi"; }
  if (e->testFlag (QLocale::Uigur)) { if (!l.empty ()) l += "|"; l += "Uigur"; }
  if (e->testFlag (QLocale::Ukrainian)) { if (!l.empty ()) l += "|"; l += "Ukrainian"; }
  if (e->testFlag (QLocale::Urdu)) { if (!l.empty ()) l += "|"; l += "Urdu"; }
  if (e->testFlag (QLocale::Uzbek)) { if (!l.empty ()) l += "|"; l += "Uzbek"; }
  if (e->testFlag (QLocale::Vietnamese)) { if (!l.empty ()) l += "|"; l += "Vietnamese"; }
  if (e->testFlag (QLocale::Volapuk)) { if (!l.empty ()) l += "|"; l += "Volapuk"; }
  if (e->testFlag (QLocale::Welsh)) { if (!l.empty ()) l += "|"; l += "Welsh"; }
  if (e->testFlag (QLocale::Wolof)) { if (!l.empty ()) l += "|"; l += "Wolof"; }
  if (e->testFlag (QLocale::Xhosa)) { if (!l.empty ()) l += "|"; l += "Xhosa"; }
  if (e->testFlag (QLocale::Yiddish)) { if (!l.empty ()) l += "|"; l += "Yiddish"; }
  if (e->testFlag (QLocale::Yoruba)) { if (!l.empty ()) l += "|"; l += "Yoruba"; }
  if (e->testFlag (QLocale::Zhuang)) { if (!l.empty ()) l += "|"; l += "Zhuang"; }
  if (e->testFlag (QLocale::Zulu)) { if (!l.empty ()) l += "|"; l += "Zulu"; }
  if (e->testFlag (QLocale::NorwegianNynorsk)) { if (!l.empty ()) l += "|"; l += "NorwegianNynorsk"; }
  if (e->testFlag (QLocale::Nynorsk)) { if (!l.empty ()) l += "|"; l += "Nynorsk"; }
  if (e->testFlag (QLocale::Bosnian)) { if (!l.empty ()) l += "|"; l += "Bosnian"; }
  if (e->testFlag (QLocale::Divehi)) { if (!l.empty ()) l += "|"; l += "Divehi"; }
  if (e->testFlag (QLocale::Manx)) { if (!l.empty ()) l += "|"; l += "Manx"; }
  if (e->testFlag (QLocale::Cornish)) { if (!l.empty ()) l += "|"; l += "Cornish"; }
  if (e->testFlag (QLocale::Akan)) { if (!l.empty ()) l += "|"; l += "Akan"; }
  if (e->testFlag (QLocale::Konkani)) { if (!l.empty ()) l += "|"; l += "Konkani"; }
  if (e->testFlag (QLocale::Ga)) { if (!l.empty ()) l += "|"; l += "Ga"; }
  if (e->testFlag (QLocale::Igbo)) { if (!l.empty ()) l += "|"; l += "Igbo"; }
  if (e->testFlag (QLocale::Kamba)) { if (!l.empty ()) l += "|"; l += "Kamba"; }
  if (e->testFlag (QLocale::Syriac)) { if (!l.empty ()) l += "|"; l += "Syriac"; }
  if (e->testFlag (QLocale::Blin)) { if (!l.empty ()) l += "|"; l += "Blin"; }
  if (e->testFlag (QLocale::Geez)) { if (!l.empty ()) l += "|"; l += "Geez"; }
  if (e->testFlag (QLocale::Koro)) { if (!l.empty ()) l += "|"; l += "Koro"; }
  if (e->testFlag (QLocale::Sidamo)) { if (!l.empty ()) l += "|"; l += "Sidamo"; }
  if (e->testFlag (QLocale::Atsam)) { if (!l.empty ()) l += "|"; l += "Atsam"; }
  if (e->testFlag (QLocale::Tigre)) { if (!l.empty ()) l += "|"; l += "Tigre"; }
  if (e->testFlag (QLocale::Jju)) { if (!l.empty ()) l += "|"; l += "Jju"; }
  if (e->testFlag (QLocale::Friulian)) { if (!l.empty ()) l += "|"; l += "Friulian"; }
  if (e->testFlag (QLocale::Venda)) { if (!l.empty ()) l += "|"; l += "Venda"; }
  if (e->testFlag (QLocale::Ewe)) { if (!l.empty ()) l += "|"; l += "Ewe"; }
  if (e->testFlag (QLocale::Walamo)) { if (!l.empty ()) l += "|"; l += "Walamo"; }
  if (e->testFlag (QLocale::Hawaiian)) { if (!l.empty ()) l += "|"; l += "Hawaiian"; }
  if (e->testFlag (QLocale::Tyap)) { if (!l.empty ()) l += "|"; l += "Tyap"; }
  if (e->testFlag (QLocale::Chewa)) { if (!l.empty ()) l += "|"; l += "Chewa"; }
  if (e->testFlag (QLocale::LastLanguage)) { if (!l.empty ()) l += "|"; l += "LastLanguage"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QLocale_Language_Enums (const QLocale_Language_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QLocale_Language_Enums (const QLocale_Language_Enums *e, const QLocale_Language_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QLocale_Language_Enums> decl_QLocale_Language_Enums ("QLocale_QFlags_Language",
  gsi::method_ext ("|", &qt_gsi::oropQLocale_Language_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQLocale_Language_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQLocale_Language_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLocale_Language_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLocale_Language_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QLocale_Language_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QLocale::Language> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QLocale_Language_Enum> decl_QLocale_Language_Enum (decl_QLocale_Language_Enums, "QLocale_Language",
  qt_gsi::mkdefs_QLocale_Language () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLocale_Language_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLocale_Language_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQLocale_Language_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QLocale_Language_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QLocale_Language_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QLocale::Language enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocale> inject_QLocale_Language_Enum_in_parent (qt_gsi::mkdefs_QLocale_Language ());
static gsi::ClassExt<QLocale> decl_QLocale_Language_Enum_as_child (decl_QLocale_Language_Enum, "Language");

}


//  Implementation of the enum wrapper class for QLocale::MeasurementSystem
namespace qt_gsi
{

static QLocale_MeasurementSystem_Enum *c_1_QLocale_MeasurementSystem_Enum () { return new QLocale_MeasurementSystem_Enum (QLocale::MetricSystem); }
static QLocale_MeasurementSystem_Enum *c_2_QLocale_MeasurementSystem_Enum () { return new QLocale_MeasurementSystem_Enum (QLocale::ImperialSystem); }

static gsi::Methods mkdefs_QLocale_MeasurementSystem () {
  return
    gsi::constant ("MetricSystem", &qt_gsi::c_1_QLocale_MeasurementSystem_Enum, "@brief Enum constant QLocale::MetricSystem") +
    gsi::constant ("ImperialSystem", &qt_gsi::c_2_QLocale_MeasurementSystem_Enum, "@brief Enum constant QLocale::ImperialSystem");
}

static std::string to_s_QLocale_MeasurementSystem_Enum (const QLocale_MeasurementSystem_Enum *e)
{
  if (e->value () == QLocale::MetricSystem) { return tl::sprintf ("MetricSystem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::ImperialSystem) { return tl::sprintf ("ImperialSystem (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QLocale_MeasurementSystem_Enum (const QLocale_MeasurementSystem_Enum *e)
{
  return (unsigned int) e->value ();
}

static QLocale_MeasurementSystem_Enum *from_i_QLocale_MeasurementSystem_Enum (unsigned int i)
{
  return new QLocale_MeasurementSystem_Enum ((QLocale::MeasurementSystem) i);
}

static bool equalQLocale_MeasurementSystem_Enum (const QLocale_MeasurementSystem_Enum *e, QLocale_MeasurementSystem_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QLocale_MeasurementSystem_Enum (const QLocale_MeasurementSystem_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QLocale_MeasurementSystem_Enums oropQLocale_MeasurementSystem_Enums (const QLocale_MeasurementSystem_Enums *e, const QLocale_MeasurementSystem_Enums &d)
{
  return e->flags () | d.flags ();
}

static QLocale_MeasurementSystem_Enums andopQLocale_MeasurementSystem_Enums (const QLocale_MeasurementSystem_Enums *e, const QLocale_MeasurementSystem_Enums &d)
{
  return e->flags () & d.flags ();
}

static QLocale_MeasurementSystem_Enums xoropQLocale_MeasurementSystem_Enums (const QLocale_MeasurementSystem_Enums *e, const QLocale_MeasurementSystem_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QLocale_MeasurementSystem_Enums (const QLocale_MeasurementSystem_Enums *e)
{
  std::string l;
  if (e->testFlag (QLocale::MetricSystem)) { if (!l.empty ()) l += "|"; l += "MetricSystem"; }
  if (e->testFlag (QLocale::ImperialSystem)) { if (!l.empty ()) l += "|"; l += "ImperialSystem"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QLocale_MeasurementSystem_Enums (const QLocale_MeasurementSystem_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QLocale_MeasurementSystem_Enums (const QLocale_MeasurementSystem_Enums *e, const QLocale_MeasurementSystem_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QLocale_MeasurementSystem_Enums> decl_QLocale_MeasurementSystem_Enums ("QLocale_QFlags_MeasurementSystem",
  gsi::method_ext ("|", &qt_gsi::oropQLocale_MeasurementSystem_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQLocale_MeasurementSystem_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQLocale_MeasurementSystem_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLocale_MeasurementSystem_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLocale_MeasurementSystem_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QLocale_MeasurementSystem_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QLocale::MeasurementSystem> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QLocale_MeasurementSystem_Enum> decl_QLocale_MeasurementSystem_Enum (decl_QLocale_MeasurementSystem_Enums, "QLocale_MeasurementSystem",
  qt_gsi::mkdefs_QLocale_MeasurementSystem () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLocale_MeasurementSystem_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLocale_MeasurementSystem_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQLocale_MeasurementSystem_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QLocale_MeasurementSystem_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QLocale_MeasurementSystem_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QLocale::MeasurementSystem enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocale> inject_QLocale_MeasurementSystem_Enum_in_parent (qt_gsi::mkdefs_QLocale_MeasurementSystem ());
static gsi::ClassExt<QLocale> decl_QLocale_MeasurementSystem_Enum_as_child (decl_QLocale_MeasurementSystem_Enum, "MeasurementSystem");

}


//  Implementation of the enum wrapper class for QLocale::NumberOption
namespace qt_gsi
{

static QLocale_NumberOption_Enum *c_1_QLocale_NumberOption_Enum () { return new QLocale_NumberOption_Enum (QLocale::OmitGroupSeparator); }
static QLocale_NumberOption_Enum *c_2_QLocale_NumberOption_Enum () { return new QLocale_NumberOption_Enum (QLocale::RejectGroupSeparator); }

static gsi::Methods mkdefs_QLocale_NumberOption () {
  return
    gsi::constant ("OmitGroupSeparator", &qt_gsi::c_1_QLocale_NumberOption_Enum, "@brief Enum constant QLocale::OmitGroupSeparator") +
    gsi::constant ("RejectGroupSeparator", &qt_gsi::c_2_QLocale_NumberOption_Enum, "@brief Enum constant QLocale::RejectGroupSeparator");
}

static std::string to_s_QLocale_NumberOption_Enum (const QLocale_NumberOption_Enum *e)
{
  if (e->value () == QLocale::OmitGroupSeparator) { return tl::sprintf ("OmitGroupSeparator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLocale::RejectGroupSeparator) { return tl::sprintf ("RejectGroupSeparator (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QLocale_NumberOption_Enum (const QLocale_NumberOption_Enum *e)
{
  return (unsigned int) e->value ();
}

static QLocale_NumberOption_Enum *from_i_QLocale_NumberOption_Enum (unsigned int i)
{
  return new QLocale_NumberOption_Enum ((QLocale::NumberOption) i);
}

static bool equalQLocale_NumberOption_Enum (const QLocale_NumberOption_Enum *e, QLocale_NumberOption_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QLocale_NumberOption_Enum (const QLocale_NumberOption_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QLocale_NumberOption_Enums oropQLocale_NumberOption_Enums (const QLocale_NumberOption_Enums *e, const QLocale_NumberOption_Enums &d)
{
  return e->flags () | d.flags ();
}

static QLocale_NumberOption_Enums andopQLocale_NumberOption_Enums (const QLocale_NumberOption_Enums *e, const QLocale_NumberOption_Enums &d)
{
  return e->flags () & d.flags ();
}

static QLocale_NumberOption_Enums xoropQLocale_NumberOption_Enums (const QLocale_NumberOption_Enums *e, const QLocale_NumberOption_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QLocale_NumberOption_Enums (const QLocale_NumberOption_Enums *e)
{
  std::string l;
  if (e->testFlag (QLocale::OmitGroupSeparator)) { if (!l.empty ()) l += "|"; l += "OmitGroupSeparator"; }
  if (e->testFlag (QLocale::RejectGroupSeparator)) { if (!l.empty ()) l += "|"; l += "RejectGroupSeparator"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QLocale_NumberOption_Enums (const QLocale_NumberOption_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QLocale_NumberOption_Enums (const QLocale_NumberOption_Enums *e, const QLocale_NumberOption_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QLocale_NumberOption_Enums> decl_QLocale_NumberOption_Enums ("QLocale_QFlags_NumberOption",
  gsi::method_ext ("|", &qt_gsi::oropQLocale_NumberOption_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQLocale_NumberOption_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQLocale_NumberOption_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLocale_NumberOption_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLocale_NumberOption_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QLocale_NumberOption_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QLocale::NumberOption> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QLocale_NumberOption_Enum> decl_QLocale_NumberOption_Enum (decl_QLocale_NumberOption_Enums, "QLocale_NumberOption",
  qt_gsi::mkdefs_QLocale_NumberOption () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLocale_NumberOption_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLocale_NumberOption_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQLocale_NumberOption_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QLocale_NumberOption_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QLocale_NumberOption_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QLocale::NumberOption enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QLocale> inject_QLocale_NumberOption_Enum_in_parent (qt_gsi::mkdefs_QLocale_NumberOption ());
static gsi::ClassExt<QLocale> decl_QLocale_NumberOption_Enum_as_child (decl_QLocale_NumberOption_Enum, "NumberOption");

}

