
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQImageWriter.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQImageWriter_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QImageWriter

//  Constructor QImageWriter::QImageWriter()


static void _init_ctor_QImageWriter_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QImageWriter *> ();
}

static void _call_ctor_QImageWriter_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QImageWriter *> (new QImageWriter ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QImageWriter_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImageWriter::QImageWriter()\nThis method creates an object of class QImageWriter.", &_init_ctor_QImageWriter_0, &_call_ctor_QImageWriter_0);
}

//  Constructor QImageWriter::QImageWriter(QIODevice *device, const QByteArray &format)


static void _init_ctor_QImageWriter_3648 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QByteArray & > (argspec_1);
  decl->set_return_new<QImageWriter *> ();
}

static void _call_ctor_QImageWriter_3648 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QIODevice *arg1 = args.read<QIODevice * > ();
  const QByteArray &arg2 = args.read<const QByteArray & > ();
  ret.write<QImageWriter *> (new QImageWriter (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QImageWriter_3648 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImageWriter::QImageWriter(QIODevice *device, const QByteArray &format)\nThis method creates an object of class QImageWriter.", &_init_ctor_QImageWriter_3648, &_call_ctor_QImageWriter_3648);
}

//  Constructor QImageWriter::QImageWriter(const QString &fileName, const QByteArray &format)


static void _init_ctor_QImageWriter_4226 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QByteArray()");
  decl->add_arg<const QByteArray & > (argspec_1);
  decl->set_return_new<QImageWriter *> ();
}

static void _call_ctor_QImageWriter_4226 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QByteArray &arg2 = args ? args.read<const QByteArray & > () : (const QByteArray &)(QByteArray());
  ret.write<QImageWriter *> (new QImageWriter (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QImageWriter_4226 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImageWriter::QImageWriter(const QString &fileName, const QByteArray &format)\nThis method creates an object of class QImageWriter.", &_init_ctor_QImageWriter_4226, &_call_ctor_QImageWriter_4226);
}

// bool QImageWriter::canWrite()


static void _init_f_canWrite_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_canWrite_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QImageWriter *)cls)->canWrite ());
}

static qt_gsi::GenericMethod *_create_f_canWrite_c0 ()
{
  return new qt_gsi::GenericMethod ("canWrite", "@brief Method bool QImageWriter::canWrite()\n", true, &_init_f_canWrite_c0, &_call_f_canWrite_c0);
}

// int QImageWriter::compression()


static void _init_f_compression_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_compression_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImageWriter *)cls)->compression ());
}

static qt_gsi::GenericMethod *_create_f_compression_c0 ()
{
  return new qt_gsi::GenericMethod (":compression", "@brief Method int QImageWriter::compression()\n", true, &_init_f_compression_c0, &_call_f_compression_c0);
}

// QString QImageWriter::description()


static void _init_f_description_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_description_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QImageWriter *)cls)->description ());
}

static qt_gsi::GenericMethod *_create_f_description_c0 ()
{
  return new qt_gsi::GenericMethod (":description", "@brief Method QString QImageWriter::description()\n", true, &_init_f_description_c0, &_call_f_description_c0);
}

// QIODevice *QImageWriter::device()


static void _init_f_device_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_f_device_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QIODevice * > ((QIODevice *)((QImageWriter *)cls)->device ());
}

static qt_gsi::GenericMethod *_create_f_device_c0 ()
{
  return new qt_gsi::GenericMethod (":device", "@brief Method QIODevice *QImageWriter::device()\n", true, &_init_f_device_c0, &_call_f_device_c0);
}

// QImageWriter::ImageWriterError QImageWriter::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QImageWriter::ImageWriterError>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QImageWriter::ImageWriterError>::target_type > ((qt_gsi::Converter<QImageWriter::ImageWriterError>::target_type)qt_gsi::CppToQtAdaptor<QImageWriter::ImageWriterError>(((QImageWriter *)cls)->error ()));
}

static qt_gsi::GenericMethod *_create_f_error_c0 ()
{
  return new qt_gsi::GenericMethod ("error", "@brief Method QImageWriter::ImageWriterError QImageWriter::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
}

// QString QImageWriter::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QImageWriter *)cls)->errorString ());
}

static qt_gsi::GenericMethod *_create_f_errorString_c0 ()
{
  return new qt_gsi::GenericMethod ("errorString", "@brief Method QString QImageWriter::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
}

// QString QImageWriter::fileName()


static void _init_f_fileName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fileName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QImageWriter *)cls)->fileName ());
}

static qt_gsi::GenericMethod *_create_f_fileName_c0 ()
{
  return new qt_gsi::GenericMethod (":fileName", "@brief Method QString QImageWriter::fileName()\n", true, &_init_f_fileName_c0, &_call_f_fileName_c0);
}

// QByteArray QImageWriter::format()


static void _init_f_format_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_format_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QImageWriter *)cls)->format ());
}

static qt_gsi::GenericMethod *_create_f_format_c0 ()
{
  return new qt_gsi::GenericMethod (":format", "@brief Method QByteArray QImageWriter::format()\n", true, &_init_f_format_c0, &_call_f_format_c0);
}

// float QImageWriter::gamma()


static void _init_f_gamma_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<float > ();
}

static void _call_f_gamma_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<float > ((float)((QImageWriter *)cls)->gamma ());
}

static qt_gsi::GenericMethod *_create_f_gamma_c0 ()
{
  return new qt_gsi::GenericMethod (":gamma", "@brief Method float QImageWriter::gamma()\n", true, &_init_f_gamma_c0, &_call_f_gamma_c0);
}

// int QImageWriter::quality()


static void _init_f_quality_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_quality_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QImageWriter *)cls)->quality ());
}

static qt_gsi::GenericMethod *_create_f_quality_c0 ()
{
  return new qt_gsi::GenericMethod (":quality", "@brief Method int QImageWriter::quality()\n", true, &_init_f_quality_c0, &_call_f_quality_c0);
}

// void QImageWriter::setCompression(int compression)


static void _init_f_setCompression_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("compression");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCompression_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QImageWriter *)cls)->setCompression (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCompression_767 ()
{
  return new qt_gsi::GenericMethod ("setCompression|compression=", "@brief Method void QImageWriter::setCompression(int compression)\n", false, &_init_f_setCompression_767, &_call_f_setCompression_767);
}

// void QImageWriter::setDescription(const QString &description)


static void _init_f_setDescription_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("description");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDescription_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QImageWriter *)cls)->setDescription (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDescription_2025 ()
{
  return new qt_gsi::GenericMethod ("setDescription|description=", "@brief Method void QImageWriter::setDescription(const QString &description)\n", false, &_init_f_setDescription_2025, &_call_f_setDescription_2025);
}

// void QImageWriter::setDevice(QIODevice *device)


static void _init_f_setDevice_1447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDevice_1447 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QIODevice *arg1 = args.read<QIODevice * > ();
  ((QImageWriter *)cls)->setDevice (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDevice_1447 ()
{
  return new qt_gsi::GenericMethod ("setDevice|device=", "@brief Method void QImageWriter::setDevice(QIODevice *device)\n", false, &_init_f_setDevice_1447, &_call_f_setDevice_1447);
}

// void QImageWriter::setFileName(const QString &fileName)


static void _init_f_setFileName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFileName_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QImageWriter *)cls)->setFileName (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFileName_2025 ()
{
  return new qt_gsi::GenericMethod ("setFileName|fileName=", "@brief Method void QImageWriter::setFileName(const QString &fileName)\n", false, &_init_f_setFileName_2025, &_call_f_setFileName_2025);
}

// void QImageWriter::setFormat(const QByteArray &format)


static void _init_f_setFormat_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFormat_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ((QImageWriter *)cls)->setFormat (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFormat_2309 ()
{
  return new qt_gsi::GenericMethod ("setFormat|format=", "@brief Method void QImageWriter::setFormat(const QByteArray &format)\n", false, &_init_f_setFormat_2309, &_call_f_setFormat_2309);
}

// void QImageWriter::setGamma(float gamma)


static void _init_f_setGamma_970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("gamma");
  decl->add_arg<float > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGamma_970 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  float arg1 = args.read<float > ();
  ((QImageWriter *)cls)->setGamma (arg1);
}

static qt_gsi::GenericMethod *_create_f_setGamma_970 ()
{
  return new qt_gsi::GenericMethod ("setGamma|gamma=", "@brief Method void QImageWriter::setGamma(float gamma)\n", false, &_init_f_setGamma_970, &_call_f_setGamma_970);
}

// void QImageWriter::setQuality(int quality)


static void _init_f_setQuality_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("quality");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setQuality_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QImageWriter *)cls)->setQuality (arg1);
}

static qt_gsi::GenericMethod *_create_f_setQuality_767 ()
{
  return new qt_gsi::GenericMethod ("setQuality|quality=", "@brief Method void QImageWriter::setQuality(int quality)\n", false, &_init_f_setQuality_767, &_call_f_setQuality_767);
}

// void QImageWriter::setText(const QString &key, const QString &text)


static void _init_f_setText_3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setText_3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  ((QImageWriter *)cls)->setText (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setText_3942 ()
{
  return new qt_gsi::GenericMethod ("setText", "@brief Method void QImageWriter::setText(const QString &key, const QString &text)\n", false, &_init_f_setText_3942, &_call_f_setText_3942);
}

// bool QImageWriter::supportsOption(QImageIOHandler::ImageOption option)


static void _init_f_supportsOption_c3086 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_supportsOption_c3086 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QImageIOHandler::ImageOption>::target_type & > ();
  ret.write<bool > ((bool)((QImageWriter *)cls)->supportsOption (qt_gsi::QtToCppAdaptor<QImageIOHandler::ImageOption>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_supportsOption_c3086 ()
{
  return new qt_gsi::GenericMethod ("supportsOption", "@brief Method bool QImageWriter::supportsOption(QImageIOHandler::ImageOption option)\n", true, &_init_f_supportsOption_c3086, &_call_f_supportsOption_c3086);
}

// bool QImageWriter::write(const QImage &image)


static void _init_f_write_1877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("image");
  decl->add_arg<const QImage & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_write_1877 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QImage &arg1 = args.read<const QImage & > ();
  ret.write<bool > ((bool)((QImageWriter *)cls)->write (arg1));
}

static qt_gsi::GenericMethod *_create_f_write_1877 ()
{
  return new qt_gsi::GenericMethod ("write", "@brief Method bool QImageWriter::write(const QImage &image)\n", false, &_init_f_write_1877, &_call_f_write_1877);
}

// static QList<QByteArray> QImageWriter::supportedImageFormats()


static void _init_f_supportedImageFormats_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QByteArray> >::target_type > ();
}

static void _call_f_supportedImageFormats_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QByteArray> >::target_type > ((qt_gsi::Converter<QList<QByteArray> >::target_type)qt_gsi::CppToQtAdaptor<QList<QByteArray> >(QImageWriter::supportedImageFormats ()));
}

static qt_gsi::GenericStaticMethod *_create_f_supportedImageFormats_0 ()
{
  return new qt_gsi::GenericStaticMethod ("supportedImageFormats", "@brief Static method QList<QByteArray> QImageWriter::supportedImageFormats()\nThis method is static and can be called without an instance.", &_init_f_supportedImageFormats_0, &_call_f_supportedImageFormats_0);
}


namespace gsi
{
gsi::Class<QImageWriter> decl_QImageWriter ("QImageWriter",
  gsi::Methods(_create_ctor_QImageWriter_0 ()) +
  gsi::Methods(_create_ctor_QImageWriter_3648 ()) +
  gsi::Methods(_create_ctor_QImageWriter_4226 ()) +
  gsi::Methods(_create_f_canWrite_c0 ()) +
  gsi::Methods(_create_f_compression_c0 ()) +
  gsi::Methods(_create_f_description_c0 ()) +
  gsi::Methods(_create_f_device_c0 ()) +
  gsi::Methods(_create_f_error_c0 ()) +
  gsi::Methods(_create_f_errorString_c0 ()) +
  gsi::Methods(_create_f_fileName_c0 ()) +
  gsi::Methods(_create_f_format_c0 ()) +
  gsi::Methods(_create_f_gamma_c0 ()) +
  gsi::Methods(_create_f_quality_c0 ()) +
  gsi::Methods(_create_f_setCompression_767 ()) +
  gsi::Methods(_create_f_setDescription_2025 ()) +
  gsi::Methods(_create_f_setDevice_1447 ()) +
  gsi::Methods(_create_f_setFileName_2025 ()) +
  gsi::Methods(_create_f_setFormat_2309 ()) +
  gsi::Methods(_create_f_setGamma_970 ()) +
  gsi::Methods(_create_f_setQuality_767 ()) +
  gsi::Methods(_create_f_setText_3942 ()) +
  gsi::Methods(_create_f_supportsOption_c3086 ()) +
  gsi::Methods(_create_f_write_1877 ()) +
  gsi::Methods(_create_f_supportedImageFormats_0 ()),
  "@qt\n@brief Binding of QImageWriter");

}


//  Implementation of the enum wrapper class for QImageWriter::ImageWriterError
namespace qt_gsi
{

static QImageWriter_ImageWriterError_Enum *c_1_QImageWriter_ImageWriterError_Enum () { return new QImageWriter_ImageWriterError_Enum (QImageWriter::UnknownError); }
static QImageWriter_ImageWriterError_Enum *c_2_QImageWriter_ImageWriterError_Enum () { return new QImageWriter_ImageWriterError_Enum (QImageWriter::DeviceError); }
static QImageWriter_ImageWriterError_Enum *c_3_QImageWriter_ImageWriterError_Enum () { return new QImageWriter_ImageWriterError_Enum (QImageWriter::UnsupportedFormatError); }

static gsi::Methods mkdefs_QImageWriter_ImageWriterError () {
  return
    gsi::constant ("UnknownError", &qt_gsi::c_1_QImageWriter_ImageWriterError_Enum, "@brief Enum constant QImageWriter::UnknownError") +
    gsi::constant ("DeviceError", &qt_gsi::c_2_QImageWriter_ImageWriterError_Enum, "@brief Enum constant QImageWriter::DeviceError") +
    gsi::constant ("UnsupportedFormatError", &qt_gsi::c_3_QImageWriter_ImageWriterError_Enum, "@brief Enum constant QImageWriter::UnsupportedFormatError");
}

static std::string to_s_QImageWriter_ImageWriterError_Enum (const QImageWriter_ImageWriterError_Enum *e)
{
  if (e->value () == QImageWriter::UnknownError) { return tl::sprintf ("UnknownError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageWriter::DeviceError) { return tl::sprintf ("DeviceError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QImageWriter::UnsupportedFormatError) { return tl::sprintf ("UnsupportedFormatError (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QImageWriter_ImageWriterError_Enum (const QImageWriter_ImageWriterError_Enum *e)
{
  return (unsigned int) e->value ();
}

static QImageWriter_ImageWriterError_Enum *from_i_QImageWriter_ImageWriterError_Enum (unsigned int i)
{
  return new QImageWriter_ImageWriterError_Enum ((QImageWriter::ImageWriterError) i);
}

static bool equalQImageWriter_ImageWriterError_Enum (const QImageWriter_ImageWriterError_Enum *e, QImageWriter_ImageWriterError_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QImageWriter_ImageWriterError_Enum (const QImageWriter_ImageWriterError_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QImageWriter_ImageWriterError_Enums oropQImageWriter_ImageWriterError_Enums (const QImageWriter_ImageWriterError_Enums *e, const QImageWriter_ImageWriterError_Enums &d)
{
  return e->flags () | d.flags ();
}

static QImageWriter_ImageWriterError_Enums andopQImageWriter_ImageWriterError_Enums (const QImageWriter_ImageWriterError_Enums *e, const QImageWriter_ImageWriterError_Enums &d)
{
  return e->flags () & d.flags ();
}

static QImageWriter_ImageWriterError_Enums xoropQImageWriter_ImageWriterError_Enums (const QImageWriter_ImageWriterError_Enums *e, const QImageWriter_ImageWriterError_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QImageWriter_ImageWriterError_Enums (const QImageWriter_ImageWriterError_Enums *e)
{
  std::string l;
  if (e->testFlag (QImageWriter::UnknownError)) { if (!l.empty ()) l += "|"; l += "UnknownError"; }
  if (e->testFlag (QImageWriter::DeviceError)) { if (!l.empty ()) l += "|"; l += "DeviceError"; }
  if (e->testFlag (QImageWriter::UnsupportedFormatError)) { if (!l.empty ()) l += "|"; l += "UnsupportedFormatError"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QImageWriter_ImageWriterError_Enums (const QImageWriter_ImageWriterError_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QImageWriter_ImageWriterError_Enums (const QImageWriter_ImageWriterError_Enums *e, const QImageWriter_ImageWriterError_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QImageWriter_ImageWriterError_Enums> decl_QImageWriter_ImageWriterError_Enums ("QImageWriter_QFlags_ImageWriterError",
  gsi::method_ext ("|", &qt_gsi::oropQImageWriter_ImageWriterError_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQImageWriter_ImageWriterError_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQImageWriter_ImageWriterError_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QImageWriter_ImageWriterError_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QImageWriter_ImageWriterError_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QImageWriter_ImageWriterError_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QImageWriter::ImageWriterError> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QImageWriter_ImageWriterError_Enum> decl_QImageWriter_ImageWriterError_Enum (decl_QImageWriter_ImageWriterError_Enums, "QImageWriter_ImageWriterError",
  qt_gsi::mkdefs_QImageWriter_ImageWriterError () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QImageWriter_ImageWriterError_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QImageWriter_ImageWriterError_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQImageWriter_ImageWriterError_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QImageWriter_ImageWriterError_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QImageWriter_ImageWriterError_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QImageWriter::ImageWriterError enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QImageWriter> inject_QImageWriter_ImageWriterError_Enum_in_parent (qt_gsi::mkdefs_QImageWriter_ImageWriterError ());
static gsi::ClassExt<QImageWriter> decl_QImageWriter_ImageWriterError_Enum_as_child (decl_QImageWriter_ImageWriterError_Enum, "ImageWriterError");

}

