
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQHeaderView.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQHeaderView_EventAdaptor.h"
#include "gsiDeclQHeaderView_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QHeaderView

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QHeaderView::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// bool QHeaderView::cascadingSectionResizes()


static void _init_f_cascadingSectionResizes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_cascadingSectionResizes_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QHeaderView *)cls)->cascadingSectionResizes ());
}

static qt_gsi::GenericMethod *_create_f_cascadingSectionResizes_c0 ()
{
  return new qt_gsi::GenericMethod (":cascadingSectionResizes", "@brief Method bool QHeaderView::cascadingSectionResizes()\n", true, &_init_f_cascadingSectionResizes_c0, &_call_f_cascadingSectionResizes_c0);
}

// int QHeaderView::count()


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QHeaderView *)cls)->count ());
}

static qt_gsi::GenericMethod *_create_f_count_c0 ()
{
  return new qt_gsi::GenericMethod ("count", "@brief Method int QHeaderView::count()\n", true, &_init_f_count_c0, &_call_f_count_c0);
}

// QFlags<Qt::AlignmentFlag> QHeaderView::defaultAlignment()


static void _init_f_defaultAlignment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type > ();
}

static void _call_f_defaultAlignment_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type > ((qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::AlignmentFlag> >(((QHeaderView *)cls)->defaultAlignment ()));
}

static qt_gsi::GenericMethod *_create_f_defaultAlignment_c0 ()
{
  return new qt_gsi::GenericMethod (":defaultAlignment", "@brief Method QFlags<Qt::AlignmentFlag> QHeaderView::defaultAlignment()\n", true, &_init_f_defaultAlignment_c0, &_call_f_defaultAlignment_c0);
}

// int QHeaderView::defaultSectionSize()


static void _init_f_defaultSectionSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_defaultSectionSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QHeaderView *)cls)->defaultSectionSize ());
}

static qt_gsi::GenericMethod *_create_f_defaultSectionSize_c0 ()
{
  return new qt_gsi::GenericMethod (":defaultSectionSize", "@brief Method int QHeaderView::defaultSectionSize()\n", true, &_init_f_defaultSectionSize_c0, &_call_f_defaultSectionSize_c0);
}

// void QHeaderView::doItemsLayout()


static void _init_f_doItemsLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_doItemsLayout_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView *)cls)->doItemsLayout ();
}

static qt_gsi::GenericMethod *_create_f_doItemsLayout_0 ()
{
  return new qt_gsi::GenericMethod ("doItemsLayout", "@brief Method void QHeaderView::doItemsLayout()\nThis is a reimplementation of QAbstractItemView::doItemsLayout", false, &_init_f_doItemsLayout_0, &_call_f_doItemsLayout_0);
}

// void QHeaderView::headerDataChanged(Qt::Orientation orientation, int logicalFirst, int logicalLast)


static void _init_f_headerDataChanged_3231 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("logicalFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("logicalLast");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_headerDataChanged_3231 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QHeaderView *)cls)->headerDataChanged (qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg1).cref(), arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_headerDataChanged_3231 ()
{
  return new qt_gsi::GenericMethod ("headerDataChanged", "@brief Method void QHeaderView::headerDataChanged(Qt::Orientation orientation, int logicalFirst, int logicalLast)\n", false, &_init_f_headerDataChanged_3231, &_call_f_headerDataChanged_3231);
}

// int QHeaderView::hiddenSectionCount()


static void _init_f_hiddenSectionCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_hiddenSectionCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QHeaderView *)cls)->hiddenSectionCount ());
}

static qt_gsi::GenericMethod *_create_f_hiddenSectionCount_c0 ()
{
  return new qt_gsi::GenericMethod ("hiddenSectionCount", "@brief Method int QHeaderView::hiddenSectionCount()\n", true, &_init_f_hiddenSectionCount_c0, &_call_f_hiddenSectionCount_c0);
}

// void QHeaderView::hideSection(int logicalIndex)


static void _init_f_hideSection_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("logicalIndex");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_hideSection_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QHeaderView *)cls)->hideSection (arg1);
}

static qt_gsi::GenericMethod *_create_f_hideSection_767 ()
{
  return new qt_gsi::GenericMethod ("hideSection", "@brief Method void QHeaderView::hideSection(int logicalIndex)\n", false, &_init_f_hideSection_767, &_call_f_hideSection_767);
}

// bool QHeaderView::highlightSections()


static void _init_f_highlightSections_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_highlightSections_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QHeaderView *)cls)->highlightSections ());
}

static qt_gsi::GenericMethod *_create_f_highlightSections_c0 ()
{
  return new qt_gsi::GenericMethod (":highlightSections", "@brief Method bool QHeaderView::highlightSections()\n", true, &_init_f_highlightSections_c0, &_call_f_highlightSections_c0);
}

// bool QHeaderView::isClickable()


static void _init_f_isClickable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isClickable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QHeaderView *)cls)->isClickable ());
}

static qt_gsi::GenericMethod *_create_f_isClickable_c0 ()
{
  return new qt_gsi::GenericMethod ("isClickable?|:clickable", "@brief Method bool QHeaderView::isClickable()\n", true, &_init_f_isClickable_c0, &_call_f_isClickable_c0);
}

// bool QHeaderView::isMovable()


static void _init_f_isMovable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMovable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QHeaderView *)cls)->isMovable ());
}

static qt_gsi::GenericMethod *_create_f_isMovable_c0 ()
{
  return new qt_gsi::GenericMethod ("isMovable?|:movable", "@brief Method bool QHeaderView::isMovable()\n", true, &_init_f_isMovable_c0, &_call_f_isMovable_c0);
}

// bool QHeaderView::isSectionHidden(int logicalIndex)


static void _init_f_isSectionHidden_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("logicalIndex");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isSectionHidden_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<bool > ((bool)((QHeaderView *)cls)->isSectionHidden (arg1));
}

static qt_gsi::GenericMethod *_create_f_isSectionHidden_c767 ()
{
  return new qt_gsi::GenericMethod ("isSectionHidden?", "@brief Method bool QHeaderView::isSectionHidden(int logicalIndex)\n", true, &_init_f_isSectionHidden_c767, &_call_f_isSectionHidden_c767);
}

// bool QHeaderView::isSortIndicatorShown()


static void _init_f_isSortIndicatorShown_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSortIndicatorShown_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QHeaderView *)cls)->isSortIndicatorShown ());
}

static qt_gsi::GenericMethod *_create_f_isSortIndicatorShown_c0 ()
{
  return new qt_gsi::GenericMethod ("isSortIndicatorShown?|:sortIndicatorShown", "@brief Method bool QHeaderView::isSortIndicatorShown()\n", true, &_init_f_isSortIndicatorShown_c0, &_call_f_isSortIndicatorShown_c0);
}

// int QHeaderView::length()


static void _init_f_length_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_length_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QHeaderView *)cls)->length ());
}

static qt_gsi::GenericMethod *_create_f_length_c0 ()
{
  return new qt_gsi::GenericMethod ("length", "@brief Method int QHeaderView::length()\n", true, &_init_f_length_c0, &_call_f_length_c0);
}

// int QHeaderView::logicalIndex(int visualIndex)


static void _init_f_logicalIndex_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visualIndex");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_logicalIndex_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QHeaderView *)cls)->logicalIndex (arg1));
}

static qt_gsi::GenericMethod *_create_f_logicalIndex_c767 ()
{
  return new qt_gsi::GenericMethod ("logicalIndex", "@brief Method int QHeaderView::logicalIndex(int visualIndex)\n", true, &_init_f_logicalIndex_c767, &_call_f_logicalIndex_c767);
}

// int QHeaderView::logicalIndexAt(int position)


static void _init_f_logicalIndexAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_logicalIndexAt_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QHeaderView *)cls)->logicalIndexAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_logicalIndexAt_c767 ()
{
  return new qt_gsi::GenericMethod ("logicalIndexAt", "@brief Method int QHeaderView::logicalIndexAt(int position)\n", true, &_init_f_logicalIndexAt_c767, &_call_f_logicalIndexAt_c767);
}

// int QHeaderView::logicalIndexAt(int x, int y)


static void _init_f_logicalIndexAt_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_logicalIndexAt_c1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<int > ((int)((QHeaderView *)cls)->logicalIndexAt (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_logicalIndexAt_c1426 ()
{
  return new qt_gsi::GenericMethod ("logicalIndexAt", "@brief Method int QHeaderView::logicalIndexAt(int x, int y)\n", true, &_init_f_logicalIndexAt_c1426, &_call_f_logicalIndexAt_c1426);
}

// int QHeaderView::logicalIndexAt(const QPoint &pos)


static void _init_f_logicalIndexAt_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_logicalIndexAt_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<int > ((int)((QHeaderView *)cls)->logicalIndexAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_logicalIndexAt_c1916 ()
{
  return new qt_gsi::GenericMethod ("logicalIndexAt", "@brief Method int QHeaderView::logicalIndexAt(const QPoint &pos)\n", true, &_init_f_logicalIndexAt_c1916, &_call_f_logicalIndexAt_c1916);
}

// int QHeaderView::minimumSectionSize()


static void _init_f_minimumSectionSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_minimumSectionSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QHeaderView *)cls)->minimumSectionSize ());
}

static qt_gsi::GenericMethod *_create_f_minimumSectionSize_c0 ()
{
  return new qt_gsi::GenericMethod (":minimumSectionSize", "@brief Method int QHeaderView::minimumSectionSize()\n", true, &_init_f_minimumSectionSize_c0, &_call_f_minimumSectionSize_c0);
}

// void QHeaderView::moveSection(int from, int to)


static void _init_f_moveSection_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_moveSection_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QHeaderView *)cls)->moveSection (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_moveSection_1426 ()
{
  return new qt_gsi::GenericMethod ("moveSection", "@brief Method void QHeaderView::moveSection(int from, int to)\n", false, &_init_f_moveSection_1426, &_call_f_moveSection_1426);
}

// int QHeaderView::offset()


static void _init_f_offset_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_offset_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QHeaderView *)cls)->offset ());
}

static qt_gsi::GenericMethod *_create_f_offset_c0 ()
{
  return new qt_gsi::GenericMethod (":offset", "@brief Method int QHeaderView::offset()\n", true, &_init_f_offset_c0, &_call_f_offset_c0);
}

// Qt::Orientation QHeaderView::orientation()


static void _init_f_orientation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::Orientation>::target_type > ();
}

static void _call_f_orientation_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::Orientation>::target_type > ((qt_gsi::Converter<Qt::Orientation>::target_type)qt_gsi::CppToQtAdaptor<Qt::Orientation>(((QHeaderView *)cls)->orientation ()));
}

static qt_gsi::GenericMethod *_create_f_orientation_c0 ()
{
  return new qt_gsi::GenericMethod ("orientation", "@brief Method Qt::Orientation QHeaderView::orientation()\n", true, &_init_f_orientation_c0, &_call_f_orientation_c0);
}

// void QHeaderView::reset()


static void _init_f_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_reset_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView *)cls)->reset ();
}

static qt_gsi::GenericMethod *_create_f_reset_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@brief Method void QHeaderView::reset()\nThis is a reimplementation of QAbstractItemView::reset", false, &_init_f_reset_0, &_call_f_reset_0);
}

// QHeaderView::ResizeMode QHeaderView::resizeMode(int logicalIndex)


static void _init_f_resizeMode_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("logicalIndex");
  decl->add_arg<int > (argspec_0);
  decl->set_return<qt_gsi::Converter<QHeaderView::ResizeMode>::target_type > ();
}

static void _call_f_resizeMode_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<qt_gsi::Converter<QHeaderView::ResizeMode>::target_type > ((qt_gsi::Converter<QHeaderView::ResizeMode>::target_type)qt_gsi::CppToQtAdaptor<QHeaderView::ResizeMode>(((QHeaderView *)cls)->resizeMode (arg1)));
}

static qt_gsi::GenericMethod *_create_f_resizeMode_c767 ()
{
  return new qt_gsi::GenericMethod ("resizeMode", "@brief Method QHeaderView::ResizeMode QHeaderView::resizeMode(int logicalIndex)\n", true, &_init_f_resizeMode_c767, &_call_f_resizeMode_c767);
}

// void QHeaderView::resizeSection(int logicalIndex, int size)


static void _init_f_resizeSection_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("logicalIndex");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("size");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_resizeSection_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QHeaderView *)cls)->resizeSection (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_resizeSection_1426 ()
{
  return new qt_gsi::GenericMethod ("resizeSection", "@brief Method void QHeaderView::resizeSection(int logicalIndex, int size)\n", false, &_init_f_resizeSection_1426, &_call_f_resizeSection_1426);
}

// void QHeaderView::resizeSections(QHeaderView::ResizeMode mode)


static void _init_f_resizeSections_2644 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QHeaderView::ResizeMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_resizeSections_2644 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QHeaderView::ResizeMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QHeaderView::ResizeMode>::target_type & > ();
  ((QHeaderView *)cls)->resizeSections (qt_gsi::QtToCppAdaptor<QHeaderView::ResizeMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_resizeSections_2644 ()
{
  return new qt_gsi::GenericMethod ("resizeSections", "@brief Method void QHeaderView::resizeSections(QHeaderView::ResizeMode mode)\n", false, &_init_f_resizeSections_2644, &_call_f_resizeSections_2644);
}

// bool QHeaderView::restoreState(const QByteArray &state)


static void _init_f_restoreState_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_restoreState_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ret.write<bool > ((bool)((QHeaderView *)cls)->restoreState (arg1));
}

static qt_gsi::GenericMethod *_create_f_restoreState_2309 ()
{
  return new qt_gsi::GenericMethod ("restoreState", "@brief Method bool QHeaderView::restoreState(const QByteArray &state)\n", false, &_init_f_restoreState_2309, &_call_f_restoreState_2309);
}

// QByteArray QHeaderView::saveState()


static void _init_f_saveState_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_saveState_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QHeaderView *)cls)->saveState ());
}

static qt_gsi::GenericMethod *_create_f_saveState_c0 ()
{
  return new qt_gsi::GenericMethod ("saveState", "@brief Method QByteArray QHeaderView::saveState()\n", true, &_init_f_saveState_c0, &_call_f_saveState_c0);
}

// int QHeaderView::sectionPosition(int logicalIndex)


static void _init_f_sectionPosition_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("logicalIndex");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_sectionPosition_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QHeaderView *)cls)->sectionPosition (arg1));
}

static qt_gsi::GenericMethod *_create_f_sectionPosition_c767 ()
{
  return new qt_gsi::GenericMethod ("sectionPosition", "@brief Method int QHeaderView::sectionPosition(int logicalIndex)\n", true, &_init_f_sectionPosition_c767, &_call_f_sectionPosition_c767);
}

// int QHeaderView::sectionSize(int logicalIndex)


static void _init_f_sectionSize_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("logicalIndex");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_sectionSize_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QHeaderView *)cls)->sectionSize (arg1));
}

static qt_gsi::GenericMethod *_create_f_sectionSize_c767 ()
{
  return new qt_gsi::GenericMethod ("sectionSize", "@brief Method int QHeaderView::sectionSize(int logicalIndex)\n", true, &_init_f_sectionSize_c767, &_call_f_sectionSize_c767);
}

// int QHeaderView::sectionSizeHint(int logicalIndex)


static void _init_f_sectionSizeHint_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("logicalIndex");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_sectionSizeHint_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QHeaderView *)cls)->sectionSizeHint (arg1));
}

static qt_gsi::GenericMethod *_create_f_sectionSizeHint_c767 ()
{
  return new qt_gsi::GenericMethod ("sectionSizeHint", "@brief Method int QHeaderView::sectionSizeHint(int logicalIndex)\n", true, &_init_f_sectionSizeHint_c767, &_call_f_sectionSizeHint_c767);
}

// int QHeaderView::sectionViewportPosition(int logicalIndex)


static void _init_f_sectionViewportPosition_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("logicalIndex");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_sectionViewportPosition_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QHeaderView *)cls)->sectionViewportPosition (arg1));
}

static qt_gsi::GenericMethod *_create_f_sectionViewportPosition_c767 ()
{
  return new qt_gsi::GenericMethod ("sectionViewportPosition", "@brief Method int QHeaderView::sectionViewportPosition(int logicalIndex)\n", true, &_init_f_sectionViewportPosition_c767, &_call_f_sectionViewportPosition_c767);
}

// bool QHeaderView::sectionsHidden()


static void _init_f_sectionsHidden_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_sectionsHidden_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QHeaderView *)cls)->sectionsHidden ());
}

static qt_gsi::GenericMethod *_create_f_sectionsHidden_c0 ()
{
  return new qt_gsi::GenericMethod ("sectionsHidden", "@brief Method bool QHeaderView::sectionsHidden()\n", true, &_init_f_sectionsHidden_c0, &_call_f_sectionsHidden_c0);
}

// bool QHeaderView::sectionsMoved()


static void _init_f_sectionsMoved_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_sectionsMoved_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QHeaderView *)cls)->sectionsMoved ());
}

static qt_gsi::GenericMethod *_create_f_sectionsMoved_c0 ()
{
  return new qt_gsi::GenericMethod ("sectionsMoved", "@brief Method bool QHeaderView::sectionsMoved()\n", true, &_init_f_sectionsMoved_c0, &_call_f_sectionsMoved_c0);
}

// void QHeaderView::setCascadingSectionResizes(bool enable)


static void _init_f_setCascadingSectionResizes_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCascadingSectionResizes_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QHeaderView *)cls)->setCascadingSectionResizes (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCascadingSectionResizes_864 ()
{
  return new qt_gsi::GenericMethod ("setCascadingSectionResizes|cascadingSectionResizes=", "@brief Method void QHeaderView::setCascadingSectionResizes(bool enable)\n", false, &_init_f_setCascadingSectionResizes_864, &_call_f_setCascadingSectionResizes_864);
}

// void QHeaderView::setClickable(bool clickable)


static void _init_f_setClickable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("clickable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setClickable_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QHeaderView *)cls)->setClickable (arg1);
}

static qt_gsi::GenericMethod *_create_f_setClickable_864 ()
{
  return new qt_gsi::GenericMethod ("setClickable|clickable=", "@brief Method void QHeaderView::setClickable(bool clickable)\n", false, &_init_f_setClickable_864, &_call_f_setClickable_864);
}

// void QHeaderView::setDefaultAlignment(QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_setDefaultAlignment_2750 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("alignment");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultAlignment_2750 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > ();
  ((QHeaderView *)cls)->setDefaultAlignment (qt_gsi::QtToCppAdaptor<QFlags<Qt::AlignmentFlag> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setDefaultAlignment_2750 ()
{
  return new qt_gsi::GenericMethod ("setDefaultAlignment|defaultAlignment=", "@brief Method void QHeaderView::setDefaultAlignment(QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_setDefaultAlignment_2750, &_call_f_setDefaultAlignment_2750);
}

// void QHeaderView::setDefaultSectionSize(int size)


static void _init_f_setDefaultSectionSize_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultSectionSize_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QHeaderView *)cls)->setDefaultSectionSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDefaultSectionSize_767 ()
{
  return new qt_gsi::GenericMethod ("setDefaultSectionSize|defaultSectionSize=", "@brief Method void QHeaderView::setDefaultSectionSize(int size)\n", false, &_init_f_setDefaultSectionSize_767, &_call_f_setDefaultSectionSize_767);
}

// void QHeaderView::setHighlightSections(bool highlight)


static void _init_f_setHighlightSections_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("highlight");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHighlightSections_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QHeaderView *)cls)->setHighlightSections (arg1);
}

static qt_gsi::GenericMethod *_create_f_setHighlightSections_864 ()
{
  return new qt_gsi::GenericMethod ("setHighlightSections|highlightSections=", "@brief Method void QHeaderView::setHighlightSections(bool highlight)\n", false, &_init_f_setHighlightSections_864, &_call_f_setHighlightSections_864);
}

// void QHeaderView::setMinimumSectionSize(int size)


static void _init_f_setMinimumSectionSize_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimumSectionSize_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QHeaderView *)cls)->setMinimumSectionSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMinimumSectionSize_767 ()
{
  return new qt_gsi::GenericMethod ("setMinimumSectionSize|minimumSectionSize=", "@brief Method void QHeaderView::setMinimumSectionSize(int size)\n", false, &_init_f_setMinimumSectionSize_767, &_call_f_setMinimumSectionSize_767);
}

// void QHeaderView::setModel(QAbstractItemModel *model)


static void _init_f_setModel_2419 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setModel_2419 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractItemModel *arg1 = args.read<QAbstractItemModel * > ();
  ((QHeaderView *)cls)->setModel (arg1);
}

static qt_gsi::GenericMethod *_create_f_setModel_2419 ()
{
  return new qt_gsi::GenericMethod ("setModel|model=", "@brief Method void QHeaderView::setModel(QAbstractItemModel *model)\nThis is a reimplementation of QAbstractItemView::setModel", false, &_init_f_setModel_2419, &_call_f_setModel_2419);
}

// void QHeaderView::setMovable(bool movable)


static void _init_f_setMovable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("movable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMovable_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QHeaderView *)cls)->setMovable (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMovable_864 ()
{
  return new qt_gsi::GenericMethod ("setMovable|movable=", "@brief Method void QHeaderView::setMovable(bool movable)\n", false, &_init_f_setMovable_864, &_call_f_setMovable_864);
}

// void QHeaderView::setOffset(int offset)


static void _init_f_setOffset_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOffset_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QHeaderView *)cls)->setOffset (arg1);
}

static qt_gsi::GenericMethod *_create_f_setOffset_767 ()
{
  return new qt_gsi::GenericMethod ("setOffset|offset=", "@brief Method void QHeaderView::setOffset(int offset)\n", false, &_init_f_setOffset_767, &_call_f_setOffset_767);
}

// void QHeaderView::setOffsetToLastSection()


static void _init_f_setOffsetToLastSection_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_setOffsetToLastSection_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView *)cls)->setOffsetToLastSection ();
}

static qt_gsi::GenericMethod *_create_f_setOffsetToLastSection_0 ()
{
  return new qt_gsi::GenericMethod ("setOffsetToLastSection", "@brief Method void QHeaderView::setOffsetToLastSection()\n", false, &_init_f_setOffsetToLastSection_0, &_call_f_setOffsetToLastSection_0);
}

// void QHeaderView::setOffsetToSectionPosition(int visualIndex)


static void _init_f_setOffsetToSectionPosition_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visualIndex");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOffsetToSectionPosition_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QHeaderView *)cls)->setOffsetToSectionPosition (arg1);
}

static qt_gsi::GenericMethod *_create_f_setOffsetToSectionPosition_767 ()
{
  return new qt_gsi::GenericMethod ("setOffsetToSectionPosition", "@brief Method void QHeaderView::setOffsetToSectionPosition(int visualIndex)\n", false, &_init_f_setOffsetToSectionPosition_767, &_call_f_setOffsetToSectionPosition_767);
}

// void QHeaderView::setResizeMode(QHeaderView::ResizeMode mode)


static void _init_f_setResizeMode_2644 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QHeaderView::ResizeMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setResizeMode_2644 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QHeaderView::ResizeMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QHeaderView::ResizeMode>::target_type & > ();
  ((QHeaderView *)cls)->setResizeMode (qt_gsi::QtToCppAdaptor<QHeaderView::ResizeMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setResizeMode_2644 ()
{
  return new qt_gsi::GenericMethod ("setResizeMode", "@brief Method void QHeaderView::setResizeMode(QHeaderView::ResizeMode mode)\n", false, &_init_f_setResizeMode_2644, &_call_f_setResizeMode_2644);
}

// void QHeaderView::setResizeMode(int logicalIndex, QHeaderView::ResizeMode mode)


static void _init_f_setResizeMode_3303 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("logicalIndex");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<QHeaderView::ResizeMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setResizeMode_3303 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<QHeaderView::ResizeMode>::target_type & arg2 = args.read<const qt_gsi::Converter<QHeaderView::ResizeMode>::target_type & > ();
  ((QHeaderView *)cls)->setResizeMode (arg1, qt_gsi::QtToCppAdaptor<QHeaderView::ResizeMode>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setResizeMode_3303 ()
{
  return new qt_gsi::GenericMethod ("setResizeMode", "@brief Method void QHeaderView::setResizeMode(int logicalIndex, QHeaderView::ResizeMode mode)\n", false, &_init_f_setResizeMode_3303, &_call_f_setResizeMode_3303);
}

// void QHeaderView::setSectionHidden(int logicalIndex, bool hide)


static void _init_f_setSectionHidden_1523 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("logicalIndex");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hide");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSectionHidden_1523 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  bool arg2 = args.read<bool > ();
  ((QHeaderView *)cls)->setSectionHidden (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setSectionHidden_1523 ()
{
  return new qt_gsi::GenericMethod ("setSectionHidden", "@brief Method void QHeaderView::setSectionHidden(int logicalIndex, bool hide)\n", false, &_init_f_setSectionHidden_1523, &_call_f_setSectionHidden_1523);
}

// void QHeaderView::setSortIndicator(int logicalIndex, Qt::SortOrder order)


static void _init_f_setSortIndicator_2340 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("logicalIndex");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSortIndicator_2340 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > ();
  ((QHeaderView *)cls)->setSortIndicator (arg1, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setSortIndicator_2340 ()
{
  return new qt_gsi::GenericMethod ("setSortIndicator", "@brief Method void QHeaderView::setSortIndicator(int logicalIndex, Qt::SortOrder order)\n", false, &_init_f_setSortIndicator_2340, &_call_f_setSortIndicator_2340);
}

// void QHeaderView::setSortIndicatorShown(bool show)


static void _init_f_setSortIndicatorShown_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("show");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSortIndicatorShown_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QHeaderView *)cls)->setSortIndicatorShown (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSortIndicatorShown_864 ()
{
  return new qt_gsi::GenericMethod ("setSortIndicatorShown|sortIndicatorShown=", "@brief Method void QHeaderView::setSortIndicatorShown(bool show)\n", false, &_init_f_setSortIndicatorShown_864, &_call_f_setSortIndicatorShown_864);
}

// void QHeaderView::setStretchLastSection(bool stretch)


static void _init_f_setStretchLastSection_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stretch");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStretchLastSection_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QHeaderView *)cls)->setStretchLastSection (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStretchLastSection_864 ()
{
  return new qt_gsi::GenericMethod ("setStretchLastSection|stretchLastSection=", "@brief Method void QHeaderView::setStretchLastSection(bool stretch)\n", false, &_init_f_setStretchLastSection_864, &_call_f_setStretchLastSection_864);
}

// void QHeaderView::showSection(int logicalIndex)


static void _init_f_showSection_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("logicalIndex");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_showSection_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QHeaderView *)cls)->showSection (arg1);
}

static qt_gsi::GenericMethod *_create_f_showSection_767 ()
{
  return new qt_gsi::GenericMethod ("showSection", "@brief Method void QHeaderView::showSection(int logicalIndex)\n", false, &_init_f_showSection_767, &_call_f_showSection_767);
}

// QSize QHeaderView::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QHeaderView *)cls)->sizeHint ());
}

static qt_gsi::GenericMethod *_create_f_sizeHint_c0 ()
{
  return new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QHeaderView::sizeHint()\nThis is a reimplementation of QAbstractScrollArea::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
}

// Qt::SortOrder QHeaderView::sortIndicatorOrder()


static void _init_f_sortIndicatorOrder_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::SortOrder>::target_type > ();
}

static void _call_f_sortIndicatorOrder_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::SortOrder>::target_type > ((qt_gsi::Converter<Qt::SortOrder>::target_type)qt_gsi::CppToQtAdaptor<Qt::SortOrder>(((QHeaderView *)cls)->sortIndicatorOrder ()));
}

static qt_gsi::GenericMethod *_create_f_sortIndicatorOrder_c0 ()
{
  return new qt_gsi::GenericMethod ("sortIndicatorOrder", "@brief Method Qt::SortOrder QHeaderView::sortIndicatorOrder()\n", true, &_init_f_sortIndicatorOrder_c0, &_call_f_sortIndicatorOrder_c0);
}

// int QHeaderView::sortIndicatorSection()


static void _init_f_sortIndicatorSection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_sortIndicatorSection_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QHeaderView *)cls)->sortIndicatorSection ());
}

static qt_gsi::GenericMethod *_create_f_sortIndicatorSection_c0 ()
{
  return new qt_gsi::GenericMethod ("sortIndicatorSection", "@brief Method int QHeaderView::sortIndicatorSection()\n", true, &_init_f_sortIndicatorSection_c0, &_call_f_sortIndicatorSection_c0);
}

// bool QHeaderView::stretchLastSection()


static void _init_f_stretchLastSection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_stretchLastSection_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QHeaderView *)cls)->stretchLastSection ());
}

static qt_gsi::GenericMethod *_create_f_stretchLastSection_c0 ()
{
  return new qt_gsi::GenericMethod (":stretchLastSection", "@brief Method bool QHeaderView::stretchLastSection()\n", true, &_init_f_stretchLastSection_c0, &_call_f_stretchLastSection_c0);
}

// int QHeaderView::stretchSectionCount()


static void _init_f_stretchSectionCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_stretchSectionCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QHeaderView *)cls)->stretchSectionCount ());
}

static qt_gsi::GenericMethod *_create_f_stretchSectionCount_c0 ()
{
  return new qt_gsi::GenericMethod ("stretchSectionCount", "@brief Method int QHeaderView::stretchSectionCount()\n", true, &_init_f_stretchSectionCount_c0, &_call_f_stretchSectionCount_c0);
}

// void QHeaderView::swapSections(int first, int second)


static void _init_f_swapSections_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("first");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("second");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_swapSections_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QHeaderView *)cls)->swapSections (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_swapSections_1426 ()
{
  return new qt_gsi::GenericMethod ("swapSections", "@brief Method void QHeaderView::swapSections(int first, int second)\n", false, &_init_f_swapSections_1426, &_call_f_swapSections_1426);
}

// int QHeaderView::visualIndex(int logicalIndex)


static void _init_f_visualIndex_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("logicalIndex");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_visualIndex_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QHeaderView *)cls)->visualIndex (arg1));
}

static qt_gsi::GenericMethod *_create_f_visualIndex_c767 ()
{
  return new qt_gsi::GenericMethod ("visualIndex", "@brief Method int QHeaderView::visualIndex(int logicalIndex)\n", true, &_init_f_visualIndex_c767, &_call_f_visualIndex_c767);
}

// int QHeaderView::visualIndexAt(int position)


static void _init_f_visualIndexAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_visualIndexAt_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QHeaderView *)cls)->visualIndexAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_visualIndexAt_c767 ()
{
  return new qt_gsi::GenericMethod ("visualIndexAt", "@brief Method int QHeaderView::visualIndexAt(int position)\n", true, &_init_f_visualIndexAt_c767, &_call_f_visualIndexAt_c767);
}

// static QString QHeaderView::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QHeaderView::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QHeaderView::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QHeaderView::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QHeaderView::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QHeaderView::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QHeaderView::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QHeaderView::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QHeaderView::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QHeaderView::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QHeaderView::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QHeaderView::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QHeaderView, QHeaderView_EventAdaptor> ea_QHeaderView;

namespace gsi
{
extern gsi::Class<QAbstractItemView> decl_QAbstractItemView;

gsi::Class<QHeaderView> decl_QHeaderView (ea_QHeaderView, decl_QAbstractItemView, "QHeaderView_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_cascadingSectionResizes_c0 ()) +
  gsi::Methods(_create_f_count_c0 ()) +
  gsi::Methods(_create_f_defaultAlignment_c0 ()) +
  gsi::Methods(_create_f_defaultSectionSize_c0 ()) +
  gsi::Methods(_create_f_doItemsLayout_0 ()) +
  gsi::Methods(_create_f_headerDataChanged_3231 ()) +
  gsi::Methods(_create_f_hiddenSectionCount_c0 ()) +
  gsi::Methods(_create_f_hideSection_767 ()) +
  gsi::Methods(_create_f_highlightSections_c0 ()) +
  gsi::Methods(_create_f_isClickable_c0 ()) +
  gsi::Methods(_create_f_isMovable_c0 ()) +
  gsi::Methods(_create_f_isSectionHidden_c767 ()) +
  gsi::Methods(_create_f_isSortIndicatorShown_c0 ()) +
  gsi::Methods(_create_f_length_c0 ()) +
  gsi::Methods(_create_f_logicalIndex_c767 ()) +
  gsi::Methods(_create_f_logicalIndexAt_c767 ()) +
  gsi::Methods(_create_f_logicalIndexAt_c1426 ()) +
  gsi::Methods(_create_f_logicalIndexAt_c1916 ()) +
  gsi::Methods(_create_f_minimumSectionSize_c0 ()) +
  gsi::Methods(_create_f_moveSection_1426 ()) +
  gsi::Methods(_create_f_offset_c0 ()) +
  gsi::Methods(_create_f_orientation_c0 ()) +
  gsi::Methods(_create_f_reset_0 ()) +
  gsi::Methods(_create_f_resizeMode_c767 ()) +
  gsi::Methods(_create_f_resizeSection_1426 ()) +
  gsi::Methods(_create_f_resizeSections_2644 ()) +
  gsi::Methods(_create_f_restoreState_2309 ()) +
  gsi::Methods(_create_f_saveState_c0 ()) +
  gsi::Methods(_create_f_sectionPosition_c767 ()) +
  gsi::Methods(_create_f_sectionSize_c767 ()) +
  gsi::Methods(_create_f_sectionSizeHint_c767 ()) +
  gsi::Methods(_create_f_sectionViewportPosition_c767 ()) +
  gsi::Methods(_create_f_sectionsHidden_c0 ()) +
  gsi::Methods(_create_f_sectionsMoved_c0 ()) +
  gsi::Methods(_create_f_setCascadingSectionResizes_864 ()) +
  gsi::Methods(_create_f_setClickable_864 ()) +
  gsi::Methods(_create_f_setDefaultAlignment_2750 ()) +
  gsi::Methods(_create_f_setDefaultSectionSize_767 ()) +
  gsi::Methods(_create_f_setHighlightSections_864 ()) +
  gsi::Methods(_create_f_setMinimumSectionSize_767 ()) +
  gsi::Methods(_create_f_setModel_2419 ()) +
  gsi::Methods(_create_f_setMovable_864 ()) +
  gsi::Methods(_create_f_setOffset_767 ()) +
  gsi::Methods(_create_f_setOffsetToLastSection_0 ()) +
  gsi::Methods(_create_f_setOffsetToSectionPosition_767 ()) +
  gsi::Methods(_create_f_setResizeMode_2644 ()) +
  gsi::Methods(_create_f_setResizeMode_3303 ()) +
  gsi::Methods(_create_f_setSectionHidden_1523 ()) +
  gsi::Methods(_create_f_setSortIndicator_2340 ()) +
  gsi::Methods(_create_f_setSortIndicatorShown_864 ()) +
  gsi::Methods(_create_f_setStretchLastSection_864 ()) +
  gsi::Methods(_create_f_showSection_767 ()) +
  gsi::Methods(_create_f_sizeHint_c0 ()) +
  gsi::Methods(_create_f_sortIndicatorOrder_c0 ()) +
  gsi::Methods(_create_f_sortIndicatorSection_c0 ()) +
  gsi::Methods(_create_f_stretchLastSection_c0 ()) +
  gsi::Methods(_create_f_stretchSectionCount_c0 ()) +
  gsi::Methods(_create_f_swapSections_1426 ()) +
  gsi::Methods(_create_f_visualIndex_c767 ()) +
  gsi::Methods(_create_f_visualIndexAt_c767 ()) +
  qt_gsi::qt_signal<QHeaderView, QHeaderView_EventAdaptor, const QModelIndex &> ("activated", &QHeaderView_EventAdaptor::activated_e_2395, gsi::arg("index"), "@brief Signal declaration for QHeaderView::activated(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QHeaderView, QHeaderView_EventAdaptor, const QModelIndex &> ("clicked", &QHeaderView_EventAdaptor::clicked_e_2395, gsi::arg("index"), "@brief Signal declaration for QHeaderView::clicked(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QHeaderView, QHeaderView_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QHeaderView_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QHeaderView::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QHeaderView, QHeaderView_EventAdaptor, QObject *> ("destroyed", &QHeaderView_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QHeaderView::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QHeaderView, QHeaderView_EventAdaptor, const QModelIndex &> ("doubleClicked", &QHeaderView_EventAdaptor::doubleClicked_e_2395, gsi::arg("index"), "@brief Signal declaration for QHeaderView::doubleClicked(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QHeaderView, QHeaderView_EventAdaptor, const QModelIndex &> ("entered", &QHeaderView_EventAdaptor::entered_e_2395, gsi::arg("index"), "@brief Signal declaration for QHeaderView::entered(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QHeaderView, QHeaderView_EventAdaptor> ("geometriesChanged", &QHeaderView_EventAdaptor::geometriesChanged_e_0, "@brief Signal declaration for QHeaderView::geometriesChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QHeaderView, QHeaderView_EventAdaptor, const QModelIndex &> ("pressed", &QHeaderView_EventAdaptor::pressed_e_2395, gsi::arg("index"), "@brief Signal declaration for QHeaderView::pressed(const QModelIndex &index)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QHeaderView, QHeaderView_EventAdaptor, int, const qt_gsi::Converter<QHeaderView::ResizeMode>::target_type &> ("sectionAutoResize", &QHeaderView_EventAdaptor::sectionAutoResize_e_3303, gsi::arg("logicalIndex"), gsi::arg("mode"), "@brief Signal declaration for QHeaderView::sectionAutoResize(int logicalIndex, QHeaderView::ResizeMode mode)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QHeaderView, QHeaderView_EventAdaptor, int> ("sectionClicked", &QHeaderView_EventAdaptor::sectionClicked_e_767, gsi::arg("logicalIndex"), "@brief Signal declaration for QHeaderView::sectionClicked(int logicalIndex)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QHeaderView, QHeaderView_EventAdaptor, int, int> ("sectionCountChanged", &QHeaderView_EventAdaptor::sectionCountChanged_e_1426, gsi::arg("oldCount"), gsi::arg("newCount"), "@brief Signal declaration for QHeaderView::sectionCountChanged(int oldCount, int newCount)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QHeaderView, QHeaderView_EventAdaptor, int> ("sectionDoubleClicked", &QHeaderView_EventAdaptor::sectionDoubleClicked_e_767, gsi::arg("logicalIndex"), "@brief Signal declaration for QHeaderView::sectionDoubleClicked(int logicalIndex)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QHeaderView, QHeaderView_EventAdaptor, int> ("sectionEntered", &QHeaderView_EventAdaptor::sectionEntered_e_767, gsi::arg("logicalIndex"), "@brief Signal declaration for QHeaderView::sectionEntered(int logicalIndex)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QHeaderView, QHeaderView_EventAdaptor, int> ("sectionHandleDoubleClicked", &QHeaderView_EventAdaptor::sectionHandleDoubleClicked_e_767, gsi::arg("logicalIndex"), "@brief Signal declaration for QHeaderView::sectionHandleDoubleClicked(int logicalIndex)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QHeaderView, QHeaderView_EventAdaptor, int, int, int> ("sectionMoved", &QHeaderView_EventAdaptor::sectionMoved_e_2085, gsi::arg("logicalIndex"), gsi::arg("oldVisualIndex"), gsi::arg("newVisualIndex"), "@brief Signal declaration for QHeaderView::sectionMoved(int logicalIndex, int oldVisualIndex, int newVisualIndex)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QHeaderView, QHeaderView_EventAdaptor, int> ("sectionPressed", &QHeaderView_EventAdaptor::sectionPressed_e_767, gsi::arg("logicalIndex"), "@brief Signal declaration for QHeaderView::sectionPressed(int logicalIndex)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QHeaderView, QHeaderView_EventAdaptor, int, int, int> ("sectionResized", &QHeaderView_EventAdaptor::sectionResized_e_2085, gsi::arg("logicalIndex"), gsi::arg("oldSize"), gsi::arg("newSize"), "@brief Signal declaration for QHeaderView::sectionResized(int logicalIndex, int oldSize, int newSize)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QHeaderView, QHeaderView_EventAdaptor, int, const qt_gsi::Converter<Qt::SortOrder>::target_type &> ("sortIndicatorChanged", &QHeaderView_EventAdaptor::sortIndicatorChanged_e_2340, gsi::arg("logicalIndex"), gsi::arg("order"), "@brief Signal declaration for QHeaderView::sortIndicatorChanged(int logicalIndex, Qt::SortOrder order)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QHeaderView, QHeaderView_EventAdaptor> ("viewportEntered", &QHeaderView_EventAdaptor::viewportEntered_e_0, "@brief Signal declaration for QHeaderView::viewportEntered()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QHeaderView");
}


class QHeaderView_Adaptor : public QHeaderView, public qt_gsi::QtObjectBase
{
public:

  virtual ~QHeaderView_Adaptor();

  //  [adaptor ctor] QHeaderView::QHeaderView(Qt::Orientation orientation, QWidget *parent)
  QHeaderView_Adaptor(Qt::Orientation orientation) : QHeaderView(orientation)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QHeaderView::QHeaderView(Qt::Orientation orientation, QWidget *parent)
  QHeaderView_Adaptor(Qt::Orientation orientation, QWidget *parent) : QHeaderView(orientation, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QHeaderView::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QHeaderView_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QHeaderView::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QHeaderView::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QHeaderView_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QHeaderView::destroy(destroyWindow, destroySubWindows);
  }

  //  QPoint QHeaderView::dirtyRegionOffset()
  QPoint fp_QHeaderView_dirtyRegionOffset_c0 () const {
    return QHeaderView::dirtyRegionOffset();
  }

  //  void QHeaderView::doAutoScroll()
  void fp_QHeaderView_doAutoScroll_0 () {
    QHeaderView::doAutoScroll();
  }

  //  void QHeaderView::drawFrame(QPainter *)
  void fp_QHeaderView_drawFrame_1426 (QPainter *arg1) {
    QHeaderView::drawFrame(arg1);
  }

  //  QAbstractItemView::DropIndicatorPosition QHeaderView::dropIndicatorPosition()
  unsigned int fp_QHeaderView_dropIndicatorPosition_c0 () const {
    return (unsigned int)(QHeaderView::dropIndicatorPosition());
  }

  //  void QHeaderView::executeDelayedItemsLayout()
  void fp_QHeaderView_executeDelayedItemsLayout_0 () {
    QHeaderView::executeDelayedItemsLayout();
  }

  //  bool QHeaderView::focusNextChild()
  bool fp_QHeaderView_focusNextChild_0 () {
    return QHeaderView::focusNextChild();
  }

  //  bool QHeaderView::focusPreviousChild()
  bool fp_QHeaderView_focusPreviousChild_0 () {
    return QHeaderView::focusPreviousChild();
  }

  //  int QHeaderView::horizontalStepsPerItem()
  int fp_QHeaderView_horizontalStepsPerItem_c0 () const {
    return QHeaderView::horizontalStepsPerItem();
  }

  //  void QHeaderView::initStyleOption(QStyleOptionHeader *option)
  void fp_QHeaderView_initStyleOption_c2450 (QStyleOptionHeader *option) const {
    QHeaderView::initStyleOption(option);
  }

  //  void QHeaderView::initialize()
  void fp_QHeaderView_initialize_0 () {
    QHeaderView::initialize();
  }

  //  void QHeaderView::initializeSections()
  void fp_QHeaderView_initializeSections_0 () {
    QHeaderView::initializeSections();
  }

  //  void QHeaderView::initializeSections(int start, int end)
  void fp_QHeaderView_initializeSections_1426 (int start, int end) {
    QHeaderView::initializeSections(start, end);
  }

  //  int QHeaderView::receivers(const char *signal)
  int fp_QHeaderView_receivers_c1731 (const char *signal) const {
    return QHeaderView::receivers(signal);
  }

  //  void QHeaderView::resetInputContext()
  void fp_QHeaderView_resetInputContext_0 () {
    QHeaderView::resetInputContext();
  }

  //  void QHeaderView::resizeSections()
  void fp_QHeaderView_resizeSections_0 () {
    QHeaderView::resizeSections();
  }

  //  void QHeaderView::scheduleDelayedItemsLayout()
  void fp_QHeaderView_scheduleDelayedItemsLayout_0 () {
    QHeaderView::scheduleDelayedItemsLayout();
  }

  //  void QHeaderView::scrollDirtyRegion(int dx, int dy)
  void fp_QHeaderView_scrollDirtyRegion_1426 (int dx, int dy) {
    QHeaderView::scrollDirtyRegion(dx, dy);
  }

  //  void QHeaderView::sectionsAboutToBeRemoved(const QModelIndex &parent, int logicalFirst, int logicalLast)
  void fp_QHeaderView_sectionsAboutToBeRemoved_3713 (const QModelIndex &parent, int logicalFirst, int logicalLast) {
    QHeaderView::sectionsAboutToBeRemoved(parent, logicalFirst, logicalLast);
  }

  //  void QHeaderView::sectionsInserted(const QModelIndex &parent, int logicalFirst, int logicalLast)
  void fp_QHeaderView_sectionsInserted_3713 (const QModelIndex &parent, int logicalFirst, int logicalLast) {
    QHeaderView::sectionsInserted(parent, logicalFirst, logicalLast);
  }

  //  QObject *QHeaderView::sender()
  QObject * fp_QHeaderView_sender_c0 () const {
    return QHeaderView::sender();
  }

  //  void QHeaderView::setDirtyRegion(const QRegion &region)
  void fp_QHeaderView_setDirtyRegion_2006 (const QRegion &region) {
    QHeaderView::setDirtyRegion(region);
  }

  //  void QHeaderView::setHorizontalStepsPerItem(int steps)
  void fp_QHeaderView_setHorizontalStepsPerItem_767 (int steps) {
    QHeaderView::setHorizontalStepsPerItem(steps);
  }

  //  void QHeaderView::setState(QAbstractItemView::State state)
  void fp_QHeaderView_setState_2776 (unsigned int state) {
    QHeaderView::setState(QAbstractItemView::State(state));
  }

  //  void QHeaderView::setVerticalStepsPerItem(int steps)
  void fp_QHeaderView_setVerticalStepsPerItem_767 (int steps) {
    QHeaderView::setVerticalStepsPerItem(steps);
  }

  //  void QHeaderView::setViewportMargins(int left, int top, int right, int bottom)
  void fp_QHeaderView_setViewportMargins_2744 (int left, int top, int right, int bottom) {
    QHeaderView::setViewportMargins(left, top, right, bottom);
  }

  //  void QHeaderView::setViewportMargins(const QMargins &margins)
  void fp_QHeaderView_setViewportMargins_2115 (const QMargins &margins) {
    QHeaderView::setViewportMargins(margins);
  }

  //  void QHeaderView::setupViewport(QWidget *viewport)
  void fp_QHeaderView_setupViewport_1315 (QWidget *viewport) {
    QHeaderView::setupViewport(viewport);
  }

  //  void QHeaderView::startAutoScroll()
  void fp_QHeaderView_startAutoScroll_0 () {
    QHeaderView::startAutoScroll();
  }

  //  QAbstractItemView::State QHeaderView::state()
  unsigned int fp_QHeaderView_state_c0 () const {
    return (unsigned int)(QHeaderView::state());
  }

  //  void QHeaderView::stopAutoScroll()
  void fp_QHeaderView_stopAutoScroll_0 () {
    QHeaderView::stopAutoScroll();
  }

  //  void QHeaderView::updateMicroFocus()
  void fp_QHeaderView_updateMicroFocus_0 () {
    QHeaderView::updateMicroFocus();
  }

  //  void QHeaderView::updateSection(int logicalIndex)
  void fp_QHeaderView_updateSection_767 (int logicalIndex) {
    QHeaderView::updateSection(logicalIndex);
  }

  //  int QHeaderView::verticalStepsPerItem()
  int fp_QHeaderView_verticalStepsPerItem_c0 () const {
    return QHeaderView::verticalStepsPerItem();
  }

  //  [adaptor impl] void QHeaderView::doItemsLayout()
  void cbs_doItemsLayout_0_0()
  {
    QHeaderView::doItemsLayout();
  }

  virtual void doItemsLayout()
  {
    if (cb_doItemsLayout_0_0.can_issue()) {
      cb_doItemsLayout_0_0.issue<QHeaderView_Adaptor>(&QHeaderView_Adaptor::cbs_doItemsLayout_0_0);
    } else {
      QHeaderView::doItemsLayout();
    }
  }

  //  [adaptor impl] bool QHeaderView::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QHeaderView::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QHeaderView_Adaptor, bool, QObject *, QEvent *>(&QHeaderView_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QHeaderView::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] int QHeaderView::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QHeaderView::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QHeaderView_Adaptor, int, int>(&QHeaderView_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QHeaderView::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QHeaderView::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QHeaderView::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QHeaderView_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QHeaderView_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QHeaderView::inputMethodQuery(query);
    }
  }

  //  [adaptor impl] void QHeaderView::keyboardSearch(const QString &search)
  void cbs_keyboardSearch_2025_0(const QString &search)
  {
    QHeaderView::keyboardSearch(search);
  }

  virtual void keyboardSearch(const QString &search)
  {
    if (cb_keyboardSearch_2025_0.can_issue()) {
      cb_keyboardSearch_2025_0.issue<QHeaderView_Adaptor, const QString &>(&QHeaderView_Adaptor::cbs_keyboardSearch_2025_0, search);
    } else {
      QHeaderView::keyboardSearch(search);
    }
  }

  //  [adaptor impl] QSize QHeaderView::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QHeaderView::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QHeaderView_Adaptor, QSize>(&QHeaderView_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QHeaderView::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QHeaderView::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QHeaderView::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QHeaderView_Adaptor, QPaintEngine *>(&QHeaderView_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QHeaderView::paintEngine();
    }
  }

  //  [adaptor impl] void QHeaderView::reset()
  void cbs_reset_0_0()
  {
    QHeaderView::reset();
  }

  virtual void reset()
  {
    if (cb_reset_0_0.can_issue()) {
      cb_reset_0_0.issue<QHeaderView_Adaptor>(&QHeaderView_Adaptor::cbs_reset_0_0);
    } else {
      QHeaderView::reset();
    }
  }

  //  [adaptor impl] void QHeaderView::selectAll()
  void cbs_selectAll_0_0()
  {
    QHeaderView::selectAll();
  }

  virtual void selectAll()
  {
    if (cb_selectAll_0_0.can_issue()) {
      cb_selectAll_0_0.issue<QHeaderView_Adaptor>(&QHeaderView_Adaptor::cbs_selectAll_0_0);
    } else {
      QHeaderView::selectAll();
    }
  }

  //  [adaptor impl] void QHeaderView::setModel(QAbstractItemModel *model)
  void cbs_setModel_2419_0(QAbstractItemModel *model)
  {
    QHeaderView::setModel(model);
  }

  virtual void setModel(QAbstractItemModel *model)
  {
    if (cb_setModel_2419_0.can_issue()) {
      cb_setModel_2419_0.issue<QHeaderView_Adaptor, QAbstractItemModel *>(&QHeaderView_Adaptor::cbs_setModel_2419_0, model);
    } else {
      QHeaderView::setModel(model);
    }
  }

  //  [adaptor impl] void QHeaderView::setRootIndex(const QModelIndex &index)
  void cbs_setRootIndex_2395_0(const QModelIndex &index)
  {
    QHeaderView::setRootIndex(index);
  }

  virtual void setRootIndex(const QModelIndex &index)
  {
    if (cb_setRootIndex_2395_0.can_issue()) {
      cb_setRootIndex_2395_0.issue<QHeaderView_Adaptor, const QModelIndex &>(&QHeaderView_Adaptor::cbs_setRootIndex_2395_0, index);
    } else {
      QHeaderView::setRootIndex(index);
    }
  }

  //  [adaptor impl] void QHeaderView::setSelectionModel(QItemSelectionModel *selectionModel)
  void cbs_setSelectionModel_2533_0(QItemSelectionModel *selectionModel)
  {
    QHeaderView::setSelectionModel(selectionModel);
  }

  virtual void setSelectionModel(QItemSelectionModel *selectionModel)
  {
    if (cb_setSelectionModel_2533_0.can_issue()) {
      cb_setSelectionModel_2533_0.issue<QHeaderView_Adaptor, QItemSelectionModel *>(&QHeaderView_Adaptor::cbs_setSelectionModel_2533_0, selectionModel);
    } else {
      QHeaderView::setSelectionModel(selectionModel);
    }
  }

  //  [adaptor impl] void QHeaderView::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QHeaderView::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QHeaderView_Adaptor, bool>(&QHeaderView_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QHeaderView::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QHeaderView::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QHeaderView::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QHeaderView_Adaptor, QSize>(&QHeaderView_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QHeaderView::sizeHint();
    }
  }

  //  [adaptor impl] int QHeaderView::sizeHintForColumn(int column)
  int cbs_sizeHintForColumn_c767_0(int column) const
  {
    return QHeaderView::sizeHintForColumn(column);
  }

  virtual int sizeHintForColumn(int column) const
  {
    if (cb_sizeHintForColumn_c767_0.can_issue()) {
      return cb_sizeHintForColumn_c767_0.issue<QHeaderView_Adaptor, int, int>(&QHeaderView_Adaptor::cbs_sizeHintForColumn_c767_0, column);
    } else {
      return QHeaderView::sizeHintForColumn(column);
    }
  }

  //  [adaptor impl] int QHeaderView::sizeHintForRow(int row)
  int cbs_sizeHintForRow_c767_0(int row) const
  {
    return QHeaderView::sizeHintForRow(row);
  }

  virtual int sizeHintForRow(int row) const
  {
    if (cb_sizeHintForRow_c767_0.can_issue()) {
      return cb_sizeHintForRow_c767_0.issue<QHeaderView_Adaptor, int, int>(&QHeaderView_Adaptor::cbs_sizeHintForRow_c767_0, row);
    } else {
      return QHeaderView::sizeHintForRow(row);
    }
  }

  //  [adaptor impl] void QHeaderView::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QHeaderView::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QHeaderView_Adaptor, QActionEvent *>(&QHeaderView_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QHeaderView::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QHeaderView::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QHeaderView::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QHeaderView_Adaptor, QEvent *>(&QHeaderView_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QHeaderView::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QHeaderView::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QHeaderView::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QHeaderView_Adaptor, QChildEvent *>(&QHeaderView_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QHeaderView::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QHeaderView::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  void cbs_closeEditor_4926_0(QWidget *editor, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & hint)
  {
    QHeaderView::closeEditor(editor, qt_gsi::QtToCppAdaptor<QAbstractItemDelegate::EndEditHint>(hint).cref());
  }

  virtual void closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  {
    if (cb_closeEditor_4926_0.can_issue()) {
      cb_closeEditor_4926_0.issue<QHeaderView_Adaptor, QWidget *, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type &>(&QHeaderView_Adaptor::cbs_closeEditor_4926_0, editor, qt_gsi::CppToQtAdaptor<QAbstractItemDelegate::EndEditHint>(hint));
    } else {
      QHeaderView::closeEditor(editor, hint);
    }
  }

  //  [adaptor impl] void QHeaderView::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QHeaderView::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QHeaderView_Adaptor, QCloseEvent *>(&QHeaderView_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QHeaderView::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QHeaderView::commitData(QWidget *editor)
  void cbs_commitData_1315_0(QWidget *editor)
  {
    QHeaderView::commitData(editor);
  }

  virtual void commitData(QWidget *editor)
  {
    if (cb_commitData_1315_0.can_issue()) {
      cb_commitData_1315_0.issue<QHeaderView_Adaptor, QWidget *>(&QHeaderView_Adaptor::cbs_commitData_1315_0, editor);
    } else {
      QHeaderView::commitData(editor);
    }
  }

  //  [adaptor impl] void QHeaderView::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QHeaderView::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QHeaderView_Adaptor, QContextMenuEvent *>(&QHeaderView_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QHeaderView::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QHeaderView::currentChanged(const QModelIndex &current, const QModelIndex &old)
  void cbs_currentChanged_4682_0(const QModelIndex &current, const QModelIndex &old)
  {
    QHeaderView::currentChanged(current, old);
  }

  virtual void currentChanged(const QModelIndex &current, const QModelIndex &old)
  {
    if (cb_currentChanged_4682_0.can_issue()) {
      cb_currentChanged_4682_0.issue<QHeaderView_Adaptor, const QModelIndex &, const QModelIndex &>(&QHeaderView_Adaptor::cbs_currentChanged_4682_0, current, old);
    } else {
      QHeaderView::currentChanged(current, old);
    }
  }

  //  [adaptor impl] void QHeaderView::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QHeaderView::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QHeaderView_Adaptor, QEvent *>(&QHeaderView_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QHeaderView::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QHeaderView::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  void cbs_dataChanged_4682_0(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  {
    QHeaderView::dataChanged(topLeft, bottomRight);
  }

  virtual void dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)
  {
    if (cb_dataChanged_4682_0.can_issue()) {
      cb_dataChanged_4682_0.issue<QHeaderView_Adaptor, const QModelIndex &, const QModelIndex &>(&QHeaderView_Adaptor::cbs_dataChanged_4682_0, topLeft, bottomRight);
    } else {
      QHeaderView::dataChanged(topLeft, bottomRight);
    }
  }

  //  [adaptor impl] void QHeaderView::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QHeaderView::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QHeaderView_Adaptor, const char *>(&QHeaderView_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QHeaderView::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QHeaderView::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QHeaderView::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QHeaderView_Adaptor, QDragEnterEvent *>(&QHeaderView_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QHeaderView::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QHeaderView::dragLeaveEvent(QDragLeaveEvent *event)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *event)
  {
    QHeaderView::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *event)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QHeaderView_Adaptor, QDragLeaveEvent *>(&QHeaderView_Adaptor::cbs_dragLeaveEvent_2092_0, event);
    } else {
      QHeaderView::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QHeaderView::dragMoveEvent(QDragMoveEvent *event)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *event)
  {
    QHeaderView::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QDragMoveEvent *event)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QHeaderView_Adaptor, QDragMoveEvent *>(&QHeaderView_Adaptor::cbs_dragMoveEvent_2006_0, event);
    } else {
      QHeaderView::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QHeaderView::dropEvent(QDropEvent *event)
  void cbs_dropEvent_1622_0(QDropEvent *event)
  {
    QHeaderView::dropEvent(event);
  }

  virtual void dropEvent(QDropEvent *event)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QHeaderView_Adaptor, QDropEvent *>(&QHeaderView_Adaptor::cbs_dropEvent_1622_0, event);
    } else {
      QHeaderView::dropEvent(event);
    }
  }

  //  [adaptor impl] bool QHeaderView::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)
  bool cbs_edit_6773_0(const QModelIndex &index, const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & trigger, QEvent *event)
  {
    return QHeaderView::edit(index, qt_gsi::QtToCppAdaptor<QAbstractItemView::EditTrigger>(trigger).cref(), event);
  }

  virtual bool edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)
  {
    if (cb_edit_6773_0.can_issue()) {
      return cb_edit_6773_0.issue<QHeaderView_Adaptor, bool, const QModelIndex &, const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type &, QEvent *>(&QHeaderView_Adaptor::cbs_edit_6773_0, index, qt_gsi::CppToQtAdaptor<QAbstractItemView::EditTrigger>(trigger), event);
    } else {
      return QHeaderView::edit(index, trigger, event);
    }
  }

  //  [adaptor impl] void QHeaderView::editorDestroyed(QObject *editor)
  void cbs_editorDestroyed_1302_0(QObject *editor)
  {
    QHeaderView::editorDestroyed(editor);
  }

  virtual void editorDestroyed(QObject *editor)
  {
    if (cb_editorDestroyed_1302_0.can_issue()) {
      cb_editorDestroyed_1302_0.issue<QHeaderView_Adaptor, QObject *>(&QHeaderView_Adaptor::cbs_editorDestroyed_1302_0, editor);
    } else {
      QHeaderView::editorDestroyed(editor);
    }
  }

  //  [adaptor impl] void QHeaderView::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QHeaderView::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QHeaderView_Adaptor, bool>(&QHeaderView_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QHeaderView::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QHeaderView::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QHeaderView::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QHeaderView_Adaptor, QEvent *>(&QHeaderView_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QHeaderView::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QHeaderView::event(QEvent *e)
  bool cbs_event_1217_0(QEvent *e)
  {
    return QHeaderView::event(e);
  }

  virtual bool event(QEvent *e)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QHeaderView_Adaptor, bool, QEvent *>(&QHeaderView_Adaptor::cbs_event_1217_0, e);
    } else {
      return QHeaderView::event(e);
    }
  }

  //  [adaptor impl] void QHeaderView::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QHeaderView::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QHeaderView_Adaptor, QFocusEvent *>(&QHeaderView_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QHeaderView::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QHeaderView::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QHeaderView::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QHeaderView_Adaptor, bool, bool>(&QHeaderView_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QHeaderView::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QHeaderView::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QHeaderView::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QHeaderView_Adaptor, QFocusEvent *>(&QHeaderView_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QHeaderView::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QHeaderView::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QHeaderView::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QHeaderView_Adaptor, const QFont &>(&QHeaderView_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QHeaderView::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QHeaderView::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QHeaderView::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QHeaderView_Adaptor, QHideEvent *>(&QHeaderView_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QHeaderView::hideEvent(arg1);
    }
  }

  //  [adaptor impl] int QHeaderView::horizontalOffset()
  int cbs_horizontalOffset_c0_0() const
  {
    return QHeaderView::horizontalOffset();
  }

  virtual int horizontalOffset() const
  {
    if (cb_horizontalOffset_c0_0.can_issue()) {
      return cb_horizontalOffset_c0_0.issue<QHeaderView_Adaptor, int>(&QHeaderView_Adaptor::cbs_horizontalOffset_c0_0);
    } else {
      return QHeaderView::horizontalOffset();
    }
  }

  //  [adaptor impl] void QHeaderView::horizontalScrollbarAction(int action)
  void cbs_horizontalScrollbarAction_767_0(int action)
  {
    QHeaderView::horizontalScrollbarAction(action);
  }

  virtual void horizontalScrollbarAction(int action)
  {
    if (cb_horizontalScrollbarAction_767_0.can_issue()) {
      cb_horizontalScrollbarAction_767_0.issue<QHeaderView_Adaptor, int>(&QHeaderView_Adaptor::cbs_horizontalScrollbarAction_767_0, action);
    } else {
      QHeaderView::horizontalScrollbarAction(action);
    }
  }

  //  [adaptor impl] void QHeaderView::horizontalScrollbarValueChanged(int value)
  void cbs_horizontalScrollbarValueChanged_767_0(int value)
  {
    QHeaderView::horizontalScrollbarValueChanged(value);
  }

  virtual void horizontalScrollbarValueChanged(int value)
  {
    if (cb_horizontalScrollbarValueChanged_767_0.can_issue()) {
      cb_horizontalScrollbarValueChanged_767_0.issue<QHeaderView_Adaptor, int>(&QHeaderView_Adaptor::cbs_horizontalScrollbarValueChanged_767_0, value);
    } else {
      QHeaderView::horizontalScrollbarValueChanged(value);
    }
  }

  //  [adaptor impl] QModelIndex QHeaderView::indexAt(const QPoint &p)
  QModelIndex cbs_indexAt_c1916_0(const QPoint &p) const
  {
    return QHeaderView::indexAt(p);
  }

  virtual QModelIndex indexAt(const QPoint &p) const
  {
    if (cb_indexAt_c1916_0.can_issue()) {
      return cb_indexAt_c1916_0.issue<QHeaderView_Adaptor, QModelIndex, const QPoint &>(&QHeaderView_Adaptor::cbs_indexAt_c1916_0, p);
    } else {
      return QHeaderView::indexAt(p);
    }
  }

  //  [adaptor impl] void QHeaderView::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QHeaderView::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QHeaderView_Adaptor, QInputMethodEvent *>(&QHeaderView_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QHeaderView::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] bool QHeaderView::isIndexHidden(const QModelIndex &index)
  bool cbs_isIndexHidden_c2395_0(const QModelIndex &index) const
  {
    return QHeaderView::isIndexHidden(index);
  }

  virtual bool isIndexHidden(const QModelIndex &index) const
  {
    if (cb_isIndexHidden_c2395_0.can_issue()) {
      return cb_isIndexHidden_c2395_0.issue<QHeaderView_Adaptor, bool, const QModelIndex &>(&QHeaderView_Adaptor::cbs_isIndexHidden_c2395_0, index);
    } else {
      return QHeaderView::isIndexHidden(index);
    }
  }

  //  [adaptor impl] void QHeaderView::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QHeaderView::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QHeaderView_Adaptor, QKeyEvent *>(&QHeaderView_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QHeaderView::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QHeaderView::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QHeaderView::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QHeaderView_Adaptor, QKeyEvent *>(&QHeaderView_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QHeaderView::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QHeaderView::languageChange()
  void cbs_languageChange_0_0()
  {
    QHeaderView::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QHeaderView_Adaptor>(&QHeaderView_Adaptor::cbs_languageChange_0_0);
    } else {
      QHeaderView::languageChange();
    }
  }

  //  [adaptor impl] void QHeaderView::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QHeaderView::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QHeaderView_Adaptor, QEvent *>(&QHeaderView_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QHeaderView::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QHeaderView::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QHeaderView::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QHeaderView_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QHeaderView_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QHeaderView::metric(arg1);
    }
  }

  //  [adaptor impl] void QHeaderView::mouseDoubleClickEvent(QMouseEvent *e)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *e)
  {
    QHeaderView::mouseDoubleClickEvent(e);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *e)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QHeaderView_Adaptor, QMouseEvent *>(&QHeaderView_Adaptor::cbs_mouseDoubleClickEvent_1738_0, e);
    } else {
      QHeaderView::mouseDoubleClickEvent(e);
    }
  }

  //  [adaptor impl] void QHeaderView::mouseMoveEvent(QMouseEvent *e)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *e)
  {
    QHeaderView::mouseMoveEvent(e);
  }

  virtual void mouseMoveEvent(QMouseEvent *e)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QHeaderView_Adaptor, QMouseEvent *>(&QHeaderView_Adaptor::cbs_mouseMoveEvent_1738_0, e);
    } else {
      QHeaderView::mouseMoveEvent(e);
    }
  }

  //  [adaptor impl] void QHeaderView::mousePressEvent(QMouseEvent *e)
  void cbs_mousePressEvent_1738_0(QMouseEvent *e)
  {
    QHeaderView::mousePressEvent(e);
  }

  virtual void mousePressEvent(QMouseEvent *e)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QHeaderView_Adaptor, QMouseEvent *>(&QHeaderView_Adaptor::cbs_mousePressEvent_1738_0, e);
    } else {
      QHeaderView::mousePressEvent(e);
    }
  }

  //  [adaptor impl] void QHeaderView::mouseReleaseEvent(QMouseEvent *e)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *e)
  {
    QHeaderView::mouseReleaseEvent(e);
  }

  virtual void mouseReleaseEvent(QMouseEvent *e)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QHeaderView_Adaptor, QMouseEvent *>(&QHeaderView_Adaptor::cbs_mouseReleaseEvent_1738_0, e);
    } else {
      QHeaderView::mouseReleaseEvent(e);
    }
  }

  //  [adaptor impl] QModelIndex QHeaderView::moveCursor(QAbstractItemView::CursorAction, QFlags<Qt::KeyboardModifier>)
  QModelIndex cbs_moveCursor_6476_0(unsigned int arg1, const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & arg2)
  {
    return QHeaderView::moveCursor(QAbstractItemView::CursorAction(arg1), qt_gsi::QtToCppAdaptor<QFlags<Qt::KeyboardModifier> >(arg2).cref());
  }

  virtual QModelIndex moveCursor(QAbstractItemView::CursorAction arg1, QFlags<Qt::KeyboardModifier> arg2)
  {
    if (cb_moveCursor_6476_0.can_issue()) {
      return cb_moveCursor_6476_0.issue<QHeaderView_Adaptor, QModelIndex, unsigned int, const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type &>(&QHeaderView_Adaptor::cbs_moveCursor_6476_0, (unsigned int)(arg1), qt_gsi::CppToQtAdaptor<QFlags<Qt::KeyboardModifier> >(arg2));
    } else {
      return QHeaderView::moveCursor(arg1, arg2);
    }
  }

  //  [adaptor impl] void QHeaderView::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QHeaderView::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QHeaderView_Adaptor, QMoveEvent *>(&QHeaderView_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QHeaderView::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QHeaderView::paintEvent(QPaintEvent *e)
  void cbs_paintEvent_1725_0(QPaintEvent *e)
  {
    QHeaderView::paintEvent(e);
  }

  virtual void paintEvent(QPaintEvent *e)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QHeaderView_Adaptor, QPaintEvent *>(&QHeaderView_Adaptor::cbs_paintEvent_1725_0, e);
    } else {
      QHeaderView::paintEvent(e);
    }
  }

  //  [adaptor impl] void QHeaderView::paintSection(QPainter *painter, const QRect &rect, int logicalIndex)
  void cbs_paintSection_c3769_0(QPainter *painter, const QRect &rect, int logicalIndex) const
  {
    QHeaderView::paintSection(painter, rect, logicalIndex);
  }

  virtual void paintSection(QPainter *painter, const QRect &rect, int logicalIndex) const
  {
    if (cb_paintSection_c3769_0.can_issue()) {
      cb_paintSection_c3769_0.issue<QHeaderView_Adaptor, QPainter *, const QRect &, int>(&QHeaderView_Adaptor::cbs_paintSection_c3769_0, painter, rect, logicalIndex);
    } else {
      QHeaderView::paintSection(painter, rect, logicalIndex);
    }
  }

  //  [adaptor impl] void QHeaderView::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QHeaderView::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QHeaderView_Adaptor, const QPalette &>(&QHeaderView_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QHeaderView::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QHeaderView::resizeEvent(QResizeEvent *event)
  void cbs_resizeEvent_1843_0(QResizeEvent *event)
  {
    QHeaderView::resizeEvent(event);
  }

  virtual void resizeEvent(QResizeEvent *event)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QHeaderView_Adaptor, QResizeEvent *>(&QHeaderView_Adaptor::cbs_resizeEvent_1843_0, event);
    } else {
      QHeaderView::resizeEvent(event);
    }
  }

  //  [adaptor impl] void QHeaderView::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)
  void cbs_rowsAboutToBeRemoved_3713_0(const QModelIndex &parent, int start, int end)
  {
    QHeaderView::rowsAboutToBeRemoved(parent, start, end);
  }

  virtual void rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)
  {
    if (cb_rowsAboutToBeRemoved_3713_0.can_issue()) {
      cb_rowsAboutToBeRemoved_3713_0.issue<QHeaderView_Adaptor, const QModelIndex &, int, int>(&QHeaderView_Adaptor::cbs_rowsAboutToBeRemoved_3713_0, parent, start, end);
    } else {
      QHeaderView::rowsAboutToBeRemoved(parent, start, end);
    }
  }

  //  [adaptor impl] void QHeaderView::rowsInserted(const QModelIndex &parent, int start, int end)
  void cbs_rowsInserted_3713_0(const QModelIndex &parent, int start, int end)
  {
    QHeaderView::rowsInserted(parent, start, end);
  }

  virtual void rowsInserted(const QModelIndex &parent, int start, int end)
  {
    if (cb_rowsInserted_3713_0.can_issue()) {
      cb_rowsInserted_3713_0.issue<QHeaderView_Adaptor, const QModelIndex &, int, int>(&QHeaderView_Adaptor::cbs_rowsInserted_3713_0, parent, start, end);
    } else {
      QHeaderView::rowsInserted(parent, start, end);
    }
  }

  //  [adaptor impl] void QHeaderView::scrollContentsBy(int dx, int dy)
  void cbs_scrollContentsBy_1426_0(int dx, int dy)
  {
    QHeaderView::scrollContentsBy(dx, dy);
  }

  virtual void scrollContentsBy(int dx, int dy)
  {
    if (cb_scrollContentsBy_1426_0.can_issue()) {
      cb_scrollContentsBy_1426_0.issue<QHeaderView_Adaptor, int, int>(&QHeaderView_Adaptor::cbs_scrollContentsBy_1426_0, dx, dy);
    } else {
      QHeaderView::scrollContentsBy(dx, dy);
    }
  }

  //  [adaptor impl] void QHeaderView::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)
  void cbs_scrollTo_5576_0(const QModelIndex &index, const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & hint)
  {
    QHeaderView::scrollTo(index, qt_gsi::QtToCppAdaptor<QAbstractItemView::ScrollHint>(hint).cref());
  }

  virtual void scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)
  {
    if (cb_scrollTo_5576_0.can_issue()) {
      cb_scrollTo_5576_0.issue<QHeaderView_Adaptor, const QModelIndex &, const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type &>(&QHeaderView_Adaptor::cbs_scrollTo_5576_0, index, qt_gsi::CppToQtAdaptor<QAbstractItemView::ScrollHint>(hint));
    } else {
      QHeaderView::scrollTo(index, hint);
    }
  }

  //  [adaptor impl] QSize QHeaderView::sectionSizeFromContents(int logicalIndex)
  QSize cbs_sectionSizeFromContents_c767_0(int logicalIndex) const
  {
    return QHeaderView::sectionSizeFromContents(logicalIndex);
  }

  virtual QSize sectionSizeFromContents(int logicalIndex) const
  {
    if (cb_sectionSizeFromContents_c767_0.can_issue()) {
      return cb_sectionSizeFromContents_c767_0.issue<QHeaderView_Adaptor, QSize, int>(&QHeaderView_Adaptor::cbs_sectionSizeFromContents_c767_0, logicalIndex);
    } else {
      return QHeaderView::sectionSizeFromContents(logicalIndex);
    }
  }

  //  [adaptor impl] QList<QModelIndex> QHeaderView::selectedIndexes()
  qt_gsi::Converter<QList<QModelIndex> >::target_type cbs_selectedIndexes_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(QHeaderView::selectedIndexes());
  }

  virtual QList<QModelIndex> selectedIndexes() const
  {
    if (cb_selectedIndexes_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(cb_selectedIndexes_c0_0.issue<QHeaderView_Adaptor, qt_gsi::Converter<QList<QModelIndex> >::target_type>(&QHeaderView_Adaptor::cbs_selectedIndexes_c0_0)).cref();
    } else {
      return QHeaderView::selectedIndexes();
    }
  }

  //  [adaptor impl] void QHeaderView::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
  void cbs_selectionChanged_5346_0(const QItemSelection &selected, const QItemSelection &deselected)
  {
    QHeaderView::selectionChanged(selected, deselected);
  }

  virtual void selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)
  {
    if (cb_selectionChanged_5346_0.can_issue()) {
      cb_selectionChanged_5346_0.issue<QHeaderView_Adaptor, const QItemSelection &, const QItemSelection &>(&QHeaderView_Adaptor::cbs_selectionChanged_5346_0, selected, deselected);
    } else {
      QHeaderView::selectionChanged(selected, deselected);
    }
  }

  //  [adaptor impl] QFlags<QItemSelectionModel::SelectionFlag> QHeaderView::selectionCommand(const QModelIndex &index, const QEvent *event)
  qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type cbs_selectionCommand_c4199_1(const QModelIndex &index, const QEvent *event) const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(QHeaderView::selectionCommand(index, event));
  }

  virtual QFlags<QItemSelectionModel::SelectionFlag> selectionCommand(const QModelIndex &index, const QEvent *event) const
  {
    if (cb_selectionCommand_c4199_1.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(cb_selectionCommand_c4199_1.issue<QHeaderView_Adaptor, qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type, const QModelIndex &, const QEvent *>(&QHeaderView_Adaptor::cbs_selectionCommand_c4199_1, index, event)).cref();
    } else {
      return QHeaderView::selectionCommand(index, event);
    }
  }

  //  [adaptor impl] void QHeaderView::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> flags)
  void cbs_setSelection_6155_0(const QRect &rect, const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & flags)
  {
    QHeaderView::setSelection(rect, qt_gsi::QtToCppAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(flags).cref());
  }

  virtual void setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> flags)
  {
    if (cb_setSelection_6155_0.can_issue()) {
      cb_setSelection_6155_0.issue<QHeaderView_Adaptor, const QRect &, const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type &>(&QHeaderView_Adaptor::cbs_setSelection_6155_0, rect, qt_gsi::CppToQtAdaptor<QFlags<QItemSelectionModel::SelectionFlag> >(flags));
    } else {
      QHeaderView::setSelection(rect, flags);
    }
  }

  //  [adaptor impl] void QHeaderView::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QHeaderView::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QHeaderView_Adaptor, QShowEvent *>(&QHeaderView_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QHeaderView::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QHeaderView::startDrag(QFlags<Qt::DropAction> supportedActions)
  void cbs_startDrag_2456_0(const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & supportedActions)
  {
    QHeaderView::startDrag(qt_gsi::QtToCppAdaptor<QFlags<Qt::DropAction> >(supportedActions).cref());
  }

  virtual void startDrag(QFlags<Qt::DropAction> supportedActions)
  {
    if (cb_startDrag_2456_0.can_issue()) {
      cb_startDrag_2456_0.issue<QHeaderView_Adaptor, const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type &>(&QHeaderView_Adaptor::cbs_startDrag_2456_0, qt_gsi::CppToQtAdaptor<QFlags<Qt::DropAction> >(supportedActions));
    } else {
      QHeaderView::startDrag(supportedActions);
    }
  }

  //  [adaptor impl] void QHeaderView::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QHeaderView::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QHeaderView_Adaptor, QStyle &>(&QHeaderView_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QHeaderView::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QHeaderView::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QHeaderView::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QHeaderView_Adaptor, QTabletEvent *>(&QHeaderView_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QHeaderView::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QHeaderView::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QHeaderView::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QHeaderView_Adaptor, QTimerEvent *>(&QHeaderView_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QHeaderView::timerEvent(event);
    }
  }

  //  [adaptor impl] void QHeaderView::updateEditorData()
  void cbs_updateEditorData_0_0()
  {
    QHeaderView::updateEditorData();
  }

  virtual void updateEditorData()
  {
    if (cb_updateEditorData_0_0.can_issue()) {
      cb_updateEditorData_0_0.issue<QHeaderView_Adaptor>(&QHeaderView_Adaptor::cbs_updateEditorData_0_0);
    } else {
      QHeaderView::updateEditorData();
    }
  }

  //  [adaptor impl] void QHeaderView::updateEditorGeometries()
  void cbs_updateEditorGeometries_0_0()
  {
    QHeaderView::updateEditorGeometries();
  }

  virtual void updateEditorGeometries()
  {
    if (cb_updateEditorGeometries_0_0.can_issue()) {
      cb_updateEditorGeometries_0_0.issue<QHeaderView_Adaptor>(&QHeaderView_Adaptor::cbs_updateEditorGeometries_0_0);
    } else {
      QHeaderView::updateEditorGeometries();
    }
  }

  //  [adaptor impl] void QHeaderView::updateGeometries()
  void cbs_updateGeometries_0_0()
  {
    QHeaderView::updateGeometries();
  }

  virtual void updateGeometries()
  {
    if (cb_updateGeometries_0_0.can_issue()) {
      cb_updateGeometries_0_0.issue<QHeaderView_Adaptor>(&QHeaderView_Adaptor::cbs_updateGeometries_0_0);
    } else {
      QHeaderView::updateGeometries();
    }
  }

  //  [adaptor impl] int QHeaderView::verticalOffset()
  int cbs_verticalOffset_c0_0() const
  {
    return QHeaderView::verticalOffset();
  }

  virtual int verticalOffset() const
  {
    if (cb_verticalOffset_c0_0.can_issue()) {
      return cb_verticalOffset_c0_0.issue<QHeaderView_Adaptor, int>(&QHeaderView_Adaptor::cbs_verticalOffset_c0_0);
    } else {
      return QHeaderView::verticalOffset();
    }
  }

  //  [adaptor impl] void QHeaderView::verticalScrollbarAction(int action)
  void cbs_verticalScrollbarAction_767_0(int action)
  {
    QHeaderView::verticalScrollbarAction(action);
  }

  virtual void verticalScrollbarAction(int action)
  {
    if (cb_verticalScrollbarAction_767_0.can_issue()) {
      cb_verticalScrollbarAction_767_0.issue<QHeaderView_Adaptor, int>(&QHeaderView_Adaptor::cbs_verticalScrollbarAction_767_0, action);
    } else {
      QHeaderView::verticalScrollbarAction(action);
    }
  }

  //  [adaptor impl] void QHeaderView::verticalScrollbarValueChanged(int value)
  void cbs_verticalScrollbarValueChanged_767_0(int value)
  {
    QHeaderView::verticalScrollbarValueChanged(value);
  }

  virtual void verticalScrollbarValueChanged(int value)
  {
    if (cb_verticalScrollbarValueChanged_767_0.can_issue()) {
      cb_verticalScrollbarValueChanged_767_0.issue<QHeaderView_Adaptor, int>(&QHeaderView_Adaptor::cbs_verticalScrollbarValueChanged_767_0, value);
    } else {
      QHeaderView::verticalScrollbarValueChanged(value);
    }
  }

  //  [adaptor impl] QStyleOptionViewItem QHeaderView::viewOptions()
  QStyleOptionViewItem cbs_viewOptions_c0_0() const
  {
    return QHeaderView::viewOptions();
  }

  virtual QStyleOptionViewItem viewOptions() const
  {
    if (cb_viewOptions_c0_0.can_issue()) {
      return cb_viewOptions_c0_0.issue<QHeaderView_Adaptor, QStyleOptionViewItem>(&QHeaderView_Adaptor::cbs_viewOptions_c0_0);
    } else {
      return QHeaderView::viewOptions();
    }
  }

  //  [adaptor impl] bool QHeaderView::viewportEvent(QEvent *e)
  bool cbs_viewportEvent_1217_0(QEvent *e)
  {
    return QHeaderView::viewportEvent(e);
  }

  virtual bool viewportEvent(QEvent *e)
  {
    if (cb_viewportEvent_1217_0.can_issue()) {
      return cb_viewportEvent_1217_0.issue<QHeaderView_Adaptor, bool, QEvent *>(&QHeaderView_Adaptor::cbs_viewportEvent_1217_0, e);
    } else {
      return QHeaderView::viewportEvent(e);
    }
  }

  //  [adaptor impl] QRect QHeaderView::visualRect(const QModelIndex &index)
  QRect cbs_visualRect_c2395_0(const QModelIndex &index) const
  {
    return QHeaderView::visualRect(index);
  }

  virtual QRect visualRect(const QModelIndex &index) const
  {
    if (cb_visualRect_c2395_0.can_issue()) {
      return cb_visualRect_c2395_0.issue<QHeaderView_Adaptor, QRect, const QModelIndex &>(&QHeaderView_Adaptor::cbs_visualRect_c2395_0, index);
    } else {
      return QHeaderView::visualRect(index);
    }
  }

  //  [adaptor impl] QRegion QHeaderView::visualRegionForSelection(const QItemSelection &selection)
  QRegion cbs_visualRegionForSelection_c2727_0(const QItemSelection &selection) const
  {
    return QHeaderView::visualRegionForSelection(selection);
  }

  virtual QRegion visualRegionForSelection(const QItemSelection &selection) const
  {
    if (cb_visualRegionForSelection_c2727_0.can_issue()) {
      return cb_visualRegionForSelection_c2727_0.issue<QHeaderView_Adaptor, QRegion, const QItemSelection &>(&QHeaderView_Adaptor::cbs_visualRegionForSelection_c2727_0, selection);
    } else {
      return QHeaderView::visualRegionForSelection(selection);
    }
  }

  //  [adaptor impl] void QHeaderView::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QHeaderView::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QHeaderView_Adaptor, QWheelEvent *>(&QHeaderView_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QHeaderView::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QHeaderView::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QHeaderView::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QHeaderView_Adaptor, bool>(&QHeaderView_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QHeaderView::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_doItemsLayout_0_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_keyboardSearch_2025_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_reset_0_0;
  gsi::Callback cb_selectAll_0_0;
  gsi::Callback cb_setModel_2419_0;
  gsi::Callback cb_setRootIndex_2395_0;
  gsi::Callback cb_setSelectionModel_2533_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_sizeHintForColumn_c767_0;
  gsi::Callback cb_sizeHintForRow_c767_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEditor_4926_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_commitData_1315_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_currentChanged_4682_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_dataChanged_4682_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_edit_6773_0;
  gsi::Callback cb_editorDestroyed_1302_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_horizontalOffset_c0_0;
  gsi::Callback cb_horizontalScrollbarAction_767_0;
  gsi::Callback cb_horizontalScrollbarValueChanged_767_0;
  gsi::Callback cb_indexAt_c1916_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_isIndexHidden_c2395_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveCursor_6476_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paintSection_c3769_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_rowsAboutToBeRemoved_3713_0;
  gsi::Callback cb_rowsInserted_3713_0;
  gsi::Callback cb_scrollContentsBy_1426_0;
  gsi::Callback cb_scrollTo_5576_0;
  gsi::Callback cb_sectionSizeFromContents_c767_0;
  gsi::Callback cb_selectedIndexes_c0_0;
  gsi::Callback cb_selectionChanged_5346_0;
  gsi::Callback cb_selectionCommand_c4199_1;
  gsi::Callback cb_setSelection_6155_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_startDrag_2456_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_updateEditorData_0_0;
  gsi::Callback cb_updateEditorGeometries_0_0;
  gsi::Callback cb_updateGeometries_0_0;
  gsi::Callback cb_verticalOffset_c0_0;
  gsi::Callback cb_verticalScrollbarAction_767_0;
  gsi::Callback cb_verticalScrollbarValueChanged_767_0;
  gsi::Callback cb_viewOptions_c0_0;
  gsi::Callback cb_viewportEvent_1217_0;
  gsi::Callback cb_visualRect_c2395_0;
  gsi::Callback cb_visualRegionForSelection_c2727_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QHeaderView_Adaptor::~QHeaderView_Adaptor() { }

//  Constructor QHeaderView::QHeaderView(Qt::Orientation orientation, QWidget *parent) (adaptor class)

static void _init_ctor_QHeaderView_Adaptor_3120 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return_new<QHeaderView_Adaptor *> ();
}

static void _call_ctor_QHeaderView_Adaptor_3120 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  QWidget *arg2 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QHeaderView_Adaptor *> (new QHeaderView_Adaptor (qt_gsi::QtToCppAdaptor<Qt::Orientation>(arg1).cref(), arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QHeaderView_Adaptor_3120 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QHeaderView::QHeaderView(Qt::Orientation orientation, QWidget *parent)\nThis method creates an object of class QHeaderView.", &_init_ctor_QHeaderView_Adaptor_3120, &_call_ctor_QHeaderView_Adaptor_3120);
}

// void QHeaderView::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QHeaderView::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QHeaderView::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QHeaderView::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// QPoint QHeaderView::dirtyRegionOffset()

static void _init_fp_dirtyRegionOffset_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPoint > ();
}

static void _call_fp_dirtyRegionOffset_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPoint > ((QPoint)((QHeaderView_Adaptor *)cls)->fp_QHeaderView_dirtyRegionOffset_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_dirtyRegionOffset_c0 ()
{
  return new qt_gsi::GenericMethod("*dirtyRegionOffset", "@brief Method QPoint QHeaderView::dirtyRegionOffset()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_dirtyRegionOffset_c0, &_call_fp_dirtyRegionOffset_c0);
}


// void QHeaderView::doAutoScroll()

static void _init_fp_doAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_doAutoScroll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_doAutoScroll_0 ();
}

static qt_gsi::GenericMethod*_create_fp_doAutoScroll_0 ()
{
  return new qt_gsi::GenericMethod("*doAutoScroll", "@brief Method void QHeaderView::doAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_doAutoScroll_0, &_call_fp_doAutoScroll_0);
}


// void QHeaderView::drawFrame(QPainter *)

static void _init_fp_drawFrame_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawFrame_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_drawFrame_1426 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_drawFrame_1426 ()
{
  return new qt_gsi::GenericMethod("*drawFrame", "@brief Method void QHeaderView::drawFrame(QPainter *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawFrame_1426, &_call_fp_drawFrame_1426);
}


// QAbstractItemView::DropIndicatorPosition QHeaderView::dropIndicatorPosition()

static void _init_fp_dropIndicatorPosition_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_fp_dropIndicatorPosition_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<unsigned int > ((unsigned int)((QHeaderView_Adaptor *)cls)->fp_QHeaderView_dropIndicatorPosition_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_dropIndicatorPosition_c0 ()
{
  return new qt_gsi::GenericMethod("*dropIndicatorPosition", "@brief Method QAbstractItemView::DropIndicatorPosition QHeaderView::dropIndicatorPosition()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_dropIndicatorPosition_c0, &_call_fp_dropIndicatorPosition_c0);
}


// void QHeaderView::executeDelayedItemsLayout()

static void _init_fp_executeDelayedItemsLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_executeDelayedItemsLayout_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_executeDelayedItemsLayout_0 ();
}

static qt_gsi::GenericMethod*_create_fp_executeDelayedItemsLayout_0 ()
{
  return new qt_gsi::GenericMethod("*executeDelayedItemsLayout", "@brief Method void QHeaderView::executeDelayedItemsLayout()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_executeDelayedItemsLayout_0, &_call_fp_executeDelayedItemsLayout_0);
}


// bool QHeaderView::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QHeaderView_Adaptor *)cls)->fp_QHeaderView_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QHeaderView::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QHeaderView::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QHeaderView_Adaptor *)cls)->fp_QHeaderView_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QHeaderView::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// int QHeaderView::horizontalStepsPerItem()

static void _init_fp_horizontalStepsPerItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_horizontalStepsPerItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QHeaderView_Adaptor *)cls)->fp_QHeaderView_horizontalStepsPerItem_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_horizontalStepsPerItem_c0 ()
{
  return new qt_gsi::GenericMethod("*horizontalStepsPerItem", "@brief Method int QHeaderView::horizontalStepsPerItem()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_horizontalStepsPerItem_c0, &_call_fp_horizontalStepsPerItem_c0);
}


// void QHeaderView::initStyleOption(QStyleOptionHeader *option)

static void _init_fp_initStyleOption_c2450 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionHeader * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_initStyleOption_c2450 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyleOptionHeader *arg1 = args.read<QStyleOptionHeader * > ();
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_initStyleOption_c2450 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_initStyleOption_c2450 ()
{
  return new qt_gsi::GenericMethod("*initStyleOption", "@brief Method void QHeaderView::initStyleOption(QStyleOptionHeader *option)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_initStyleOption_c2450, &_call_fp_initStyleOption_c2450);
}


// void QHeaderView::initialize()

static void _init_fp_initialize_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_initialize_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_initialize_0 ();
}

static qt_gsi::GenericMethod*_create_fp_initialize_0 ()
{
  return new qt_gsi::GenericMethod("*initialize", "@brief Method void QHeaderView::initialize()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_initialize_0, &_call_fp_initialize_0);
}


// void QHeaderView::initializeSections()

static void _init_fp_initializeSections_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_initializeSections_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_initializeSections_0 ();
}

static qt_gsi::GenericMethod*_create_fp_initializeSections_0 ()
{
  return new qt_gsi::GenericMethod("*initializeSections", "@brief Method void QHeaderView::initializeSections()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_initializeSections_0, &_call_fp_initializeSections_0);
}


// void QHeaderView::initializeSections(int start, int end)

static void _init_fp_initializeSections_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("end");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_initializeSections_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_initializeSections_1426 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_initializeSections_1426 ()
{
  return new qt_gsi::GenericMethod("*initializeSections", "@brief Method void QHeaderView::initializeSections(int start, int end)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_initializeSections_1426, &_call_fp_initializeSections_1426);
}


// int QHeaderView::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QHeaderView_Adaptor *)cls)->fp_QHeaderView_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QHeaderView::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QHeaderView::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QHeaderView::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// void QHeaderView::resizeSections()

static void _init_fp_resizeSections_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resizeSections_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_resizeSections_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resizeSections_0 ()
{
  return new qt_gsi::GenericMethod("*resizeSections", "@brief Method void QHeaderView::resizeSections()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resizeSections_0, &_call_fp_resizeSections_0);
}


// void QHeaderView::scheduleDelayedItemsLayout()

static void _init_fp_scheduleDelayedItemsLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_scheduleDelayedItemsLayout_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_scheduleDelayedItemsLayout_0 ();
}

static qt_gsi::GenericMethod*_create_fp_scheduleDelayedItemsLayout_0 ()
{
  return new qt_gsi::GenericMethod("*scheduleDelayedItemsLayout", "@brief Method void QHeaderView::scheduleDelayedItemsLayout()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_scheduleDelayedItemsLayout_0, &_call_fp_scheduleDelayedItemsLayout_0);
}


// void QHeaderView::scrollDirtyRegion(int dx, int dy)

static void _init_fp_scrollDirtyRegion_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_scrollDirtyRegion_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_scrollDirtyRegion_1426 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_scrollDirtyRegion_1426 ()
{
  return new qt_gsi::GenericMethod("*scrollDirtyRegion", "@brief Method void QHeaderView::scrollDirtyRegion(int dx, int dy)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_scrollDirtyRegion_1426, &_call_fp_scrollDirtyRegion_1426);
}


// void QHeaderView::sectionsAboutToBeRemoved(const QModelIndex &parent, int logicalFirst, int logicalLast)

static void _init_fp_sectionsAboutToBeRemoved_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("logicalFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("logicalLast");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_sectionsAboutToBeRemoved_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_sectionsAboutToBeRemoved_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_sectionsAboutToBeRemoved_3713 ()
{
  return new qt_gsi::GenericMethod("*sectionsAboutToBeRemoved", "@brief Method void QHeaderView::sectionsAboutToBeRemoved(const QModelIndex &parent, int logicalFirst, int logicalLast)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_sectionsAboutToBeRemoved_3713, &_call_fp_sectionsAboutToBeRemoved_3713);
}


// void QHeaderView::sectionsInserted(const QModelIndex &parent, int logicalFirst, int logicalLast)

static void _init_fp_sectionsInserted_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("logicalFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("logicalLast");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_sectionsInserted_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_sectionsInserted_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_sectionsInserted_3713 ()
{
  return new qt_gsi::GenericMethod("*sectionsInserted", "@brief Method void QHeaderView::sectionsInserted(const QModelIndex &parent, int logicalFirst, int logicalLast)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_sectionsInserted_3713, &_call_fp_sectionsInserted_3713);
}


// QObject *QHeaderView::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QHeaderView_Adaptor *)cls)->fp_QHeaderView_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QHeaderView::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QHeaderView::setDirtyRegion(const QRegion &region)

static void _init_fp_setDirtyRegion_2006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("region");
  decl->add_arg<const QRegion & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setDirtyRegion_2006 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRegion &arg1 = args.read<const QRegion & > ();
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_setDirtyRegion_2006 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setDirtyRegion_2006 ()
{
  return new qt_gsi::GenericMethod("*setDirtyRegion", "@brief Method void QHeaderView::setDirtyRegion(const QRegion &region)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setDirtyRegion_2006, &_call_fp_setDirtyRegion_2006);
}


// void QHeaderView::setHorizontalStepsPerItem(int steps)

static void _init_fp_setHorizontalStepsPerItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("steps");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setHorizontalStepsPerItem_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_setHorizontalStepsPerItem_767 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setHorizontalStepsPerItem_767 ()
{
  return new qt_gsi::GenericMethod("*setHorizontalStepsPerItem", "@brief Method void QHeaderView::setHorizontalStepsPerItem(int steps)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setHorizontalStepsPerItem_767, &_call_fp_setHorizontalStepsPerItem_767);
}


// void QHeaderView::setState(QAbstractItemView::State state)

static void _init_fp_setState_2776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setState_2776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_setState_2776 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setState_2776 ()
{
  return new qt_gsi::GenericMethod("*setState", "@brief Method void QHeaderView::setState(QAbstractItemView::State state)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setState_2776, &_call_fp_setState_2776);
}


// void QHeaderView::setVerticalStepsPerItem(int steps)

static void _init_fp_setVerticalStepsPerItem_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("steps");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setVerticalStepsPerItem_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_setVerticalStepsPerItem_767 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setVerticalStepsPerItem_767 ()
{
  return new qt_gsi::GenericMethod("*setVerticalStepsPerItem", "@brief Method void QHeaderView::setVerticalStepsPerItem(int steps)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setVerticalStepsPerItem_767, &_call_fp_setVerticalStepsPerItem_767);
}


// void QHeaderView::setViewportMargins(int left, int top, int right, int bottom)

static void _init_fp_setViewportMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_setViewportMargins_2744 (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod*_create_fp_setViewportMargins_2744 ()
{
  return new qt_gsi::GenericMethod("*setViewportMargins", "@brief Method void QHeaderView::setViewportMargins(int left, int top, int right, int bottom)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2744, &_call_fp_setViewportMargins_2744);
}


// void QHeaderView::setViewportMargins(const QMargins &margins)

static void _init_fp_setViewportMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2115 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMargins &arg1 = args.read<const QMargins & > ();
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_setViewportMargins_2115 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setViewportMargins_2115 ()
{
  return new qt_gsi::GenericMethod("*setViewportMargins", "@brief Method void QHeaderView::setViewportMargins(const QMargins &margins)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2115, &_call_fp_setViewportMargins_2115);
}


// void QHeaderView::setupViewport(QWidget *viewport)

static void _init_fp_setupViewport_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewport");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setupViewport_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_setupViewport_1315 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setupViewport_1315 ()
{
  return new qt_gsi::GenericMethod("*setupViewport", "@brief Method void QHeaderView::setupViewport(QWidget *viewport)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setupViewport_1315, &_call_fp_setupViewport_1315);
}


// void QHeaderView::startAutoScroll()

static void _init_fp_startAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_startAutoScroll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_startAutoScroll_0 ();
}

static qt_gsi::GenericMethod*_create_fp_startAutoScroll_0 ()
{
  return new qt_gsi::GenericMethod("*startAutoScroll", "@brief Method void QHeaderView::startAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_startAutoScroll_0, &_call_fp_startAutoScroll_0);
}


// QAbstractItemView::State QHeaderView::state()

static void _init_fp_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_fp_state_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<unsigned int > ((unsigned int)((QHeaderView_Adaptor *)cls)->fp_QHeaderView_state_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_state_c0 ()
{
  return new qt_gsi::GenericMethod("*state", "@brief Method QAbstractItemView::State QHeaderView::state()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_state_c0, &_call_fp_state_c0);
}


// void QHeaderView::stopAutoScroll()

static void _init_fp_stopAutoScroll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_stopAutoScroll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_stopAutoScroll_0 ();
}

static qt_gsi::GenericMethod*_create_fp_stopAutoScroll_0 ()
{
  return new qt_gsi::GenericMethod("*stopAutoScroll", "@brief Method void QHeaderView::stopAutoScroll()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_stopAutoScroll_0, &_call_fp_stopAutoScroll_0);
}


// void QHeaderView::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QHeaderView::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// void QHeaderView::updateSection(int logicalIndex)

static void _init_fp_updateSection_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("logicalIndex");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_updateSection_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QHeaderView_Adaptor *)cls)->fp_QHeaderView_updateSection_767 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_updateSection_767 ()
{
  return new qt_gsi::GenericMethod("*updateSection", "@brief Method void QHeaderView::updateSection(int logicalIndex)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateSection_767, &_call_fp_updateSection_767);
}


// int QHeaderView::verticalStepsPerItem()

static void _init_fp_verticalStepsPerItem_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_verticalStepsPerItem_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QHeaderView_Adaptor *)cls)->fp_QHeaderView_verticalStepsPerItem_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_verticalStepsPerItem_c0 ()
{
  return new qt_gsi::GenericMethod("*verticalStepsPerItem", "@brief Method int QHeaderView::verticalStepsPerItem()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_verticalStepsPerItem_c0, &_call_fp_verticalStepsPerItem_c0);
}


// void QHeaderView::doItemsLayout()

static void _init_cbs_doItemsLayout_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_doItemsLayout_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView_Adaptor *)cls)->cbs_doItemsLayout_0_0 ();
}

static void _set_callback_cbs_doItemsLayout_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_doItemsLayout_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_doItemsLayout_0_0 ()
{
  return new qt_gsi::GenericMethod ("doItemsLayout", "@hide", false, &_init_cbs_doItemsLayout_0_0, &_call_cbs_doItemsLayout_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_doItemsLayout_0_0 ()
{
  return new qt_gsi::GenericMethod ("doItemsLayout", "@brief Virtual method void QHeaderView::doItemsLayout()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_doItemsLayout_0_0, &_call_cbs_doItemsLayout_0_0, &_set_callback_cbs_doItemsLayout_0_0);
}


// bool QHeaderView::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QHeaderView_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QHeaderView::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// int QHeaderView::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QHeaderView_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QHeaderView::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// QVariant QHeaderView::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QHeaderView_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QHeaderView::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// void QHeaderView::keyboardSearch(const QString &search)

static void _init_cbs_keyboardSearch_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("search");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyboardSearch_2025_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QHeaderView_Adaptor *)cls)->cbs_keyboardSearch_2025_0 (arg1);
}

static void _set_callback_cbs_keyboardSearch_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_keyboardSearch_2025_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyboardSearch_2025_0 ()
{
  return new qt_gsi::GenericMethod ("keyboardSearch", "@hide", false, &_init_cbs_keyboardSearch_2025_0, &_call_cbs_keyboardSearch_2025_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyboardSearch_2025_0 ()
{
  return new qt_gsi::GenericMethod ("keyboardSearch", "@brief Virtual method void QHeaderView::keyboardSearch(const QString &search)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyboardSearch_2025_0, &_call_cbs_keyboardSearch_2025_0, &_set_callback_cbs_keyboardSearch_2025_0);
}


// QSize QHeaderView::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QHeaderView_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QHeaderView::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// QPaintEngine *QHeaderView::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QHeaderView_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QHeaderView::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QHeaderView::reset()

static void _init_cbs_reset_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reset_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView_Adaptor *)cls)->cbs_reset_0_0 ();
}

static void _set_callback_cbs_reset_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_reset_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_reset_0_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@hide", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_reset_0_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@brief Virtual method void QHeaderView::reset()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0, &_set_callback_cbs_reset_0_0);
}


// void QHeaderView::selectAll()

static void _init_cbs_selectAll_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_selectAll_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView_Adaptor *)cls)->cbs_selectAll_0_0 ();
}

static void _set_callback_cbs_selectAll_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_selectAll_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectAll_0_0 ()
{
  return new qt_gsi::GenericMethod ("selectAll", "@hide", false, &_init_cbs_selectAll_0_0, &_call_cbs_selectAll_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectAll_0_0 ()
{
  return new qt_gsi::GenericMethod ("selectAll", "@brief Virtual method void QHeaderView::selectAll()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectAll_0_0, &_call_cbs_selectAll_0_0, &_set_callback_cbs_selectAll_0_0);
}


// void QHeaderView::setModel(QAbstractItemModel *model)

static void _init_cbs_setModel_2419_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setModel_2419_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAbstractItemModel *arg1 = args.read<QAbstractItemModel * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_setModel_2419_0 (arg1);
}

static void _set_callback_cbs_setModel_2419_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_setModel_2419_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setModel_2419_0 ()
{
  return new qt_gsi::GenericMethod ("setModel", "@hide", false, &_init_cbs_setModel_2419_0, &_call_cbs_setModel_2419_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setModel_2419_0 ()
{
  return new qt_gsi::GenericMethod ("setModel", "@brief Virtual method void QHeaderView::setModel(QAbstractItemModel *model)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setModel_2419_0, &_call_cbs_setModel_2419_0, &_set_callback_cbs_setModel_2419_0);
}


// void QHeaderView::setRootIndex(const QModelIndex &index)

static void _init_cbs_setRootIndex_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setRootIndex_2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QHeaderView_Adaptor *)cls)->cbs_setRootIndex_2395_0 (arg1);
}

static void _set_callback_cbs_setRootIndex_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_setRootIndex_2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setRootIndex_2395_0 ()
{
  return new qt_gsi::GenericMethod ("setRootIndex", "@hide", false, &_init_cbs_setRootIndex_2395_0, &_call_cbs_setRootIndex_2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setRootIndex_2395_0 ()
{
  return new qt_gsi::GenericMethod ("setRootIndex", "@brief Virtual method void QHeaderView::setRootIndex(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setRootIndex_2395_0, &_call_cbs_setRootIndex_2395_0, &_set_callback_cbs_setRootIndex_2395_0);
}


// void QHeaderView::setSelectionModel(QItemSelectionModel *selectionModel)

static void _init_cbs_setSelectionModel_2533_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selectionModel");
  decl->add_arg<QItemSelectionModel * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSelectionModel_2533_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QItemSelectionModel *arg1 = args.read<QItemSelectionModel * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_setSelectionModel_2533_0 (arg1);
}

static void _set_callback_cbs_setSelectionModel_2533_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_setSelectionModel_2533_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setSelectionModel_2533_0 ()
{
  return new qt_gsi::GenericMethod ("setSelectionModel", "@hide", false, &_init_cbs_setSelectionModel_2533_0, &_call_cbs_setSelectionModel_2533_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setSelectionModel_2533_0 ()
{
  return new qt_gsi::GenericMethod ("setSelectionModel", "@brief Virtual method void QHeaderView::setSelectionModel(QItemSelectionModel *selectionModel)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSelectionModel_2533_0, &_call_cbs_setSelectionModel_2533_0, &_set_callback_cbs_setSelectionModel_2533_0);
}


// void QHeaderView::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QHeaderView_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QHeaderView::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// QSize QHeaderView::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QHeaderView_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QHeaderView::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// int QHeaderView::sizeHintForColumn(int column)

static void _init_cbs_sizeHintForColumn_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_sizeHintForColumn_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QHeaderView_Adaptor *)cls)->cbs_sizeHintForColumn_c767_0 (arg1));
}

static void _set_callback_cbs_sizeHintForColumn_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_sizeHintForColumn_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHintForColumn_c767_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForColumn", "@hide", true, &_init_cbs_sizeHintForColumn_c767_0, &_call_cbs_sizeHintForColumn_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHintForColumn_c767_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForColumn", "@brief Virtual method int QHeaderView::sizeHintForColumn(int column)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHintForColumn_c767_0, &_call_cbs_sizeHintForColumn_c767_0, &_set_callback_cbs_sizeHintForColumn_c767_0);
}


// int QHeaderView::sizeHintForRow(int row)

static void _init_cbs_sizeHintForRow_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_sizeHintForRow_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QHeaderView_Adaptor *)cls)->cbs_sizeHintForRow_c767_0 (arg1));
}

static void _set_callback_cbs_sizeHintForRow_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_sizeHintForRow_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHintForRow_c767_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForRow", "@hide", true, &_init_cbs_sizeHintForRow_c767_0, &_call_cbs_sizeHintForRow_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHintForRow_c767_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHintForRow", "@brief Virtual method int QHeaderView::sizeHintForRow(int row)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHintForRow_c767_0, &_call_cbs_sizeHintForRow_c767_0, &_set_callback_cbs_sizeHintForRow_c767_0);
}


// void QHeaderView::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QHeaderView::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QHeaderView::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QHeaderView::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QHeaderView::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QHeaderView::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QHeaderView::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)

static void _init_cbs_closeEditor_4926_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_closeEditor_4926_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > ();
  ((QHeaderView_Adaptor *)cls)->cbs_closeEditor_4926_0 (arg1, arg2);
}

static void _set_callback_cbs_closeEditor_4926_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_closeEditor_4926_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEditor_4926_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEditor", "@hide", false, &_init_cbs_closeEditor_4926_0, &_call_cbs_closeEditor_4926_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEditor_4926_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEditor", "@brief Virtual method void QHeaderView::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEditor_4926_0, &_call_cbs_closeEditor_4926_0, &_set_callback_cbs_closeEditor_4926_0);
}


// void QHeaderView::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QHeaderView::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QHeaderView::commitData(QWidget *editor)

static void _init_cbs_commitData_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_commitData_1315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_commitData_1315_0 (arg1);
}

static void _set_callback_cbs_commitData_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_commitData_1315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_commitData_1315_0 ()
{
  return new qt_gsi::GenericMethod ("*commitData", "@hide", false, &_init_cbs_commitData_1315_0, &_call_cbs_commitData_1315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_commitData_1315_0 ()
{
  return new qt_gsi::GenericMethod ("*commitData", "@brief Virtual method void QHeaderView::commitData(QWidget *editor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_commitData_1315_0, &_call_cbs_commitData_1315_0, &_set_callback_cbs_commitData_1315_0);
}


// void QHeaderView::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QHeaderView::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QHeaderView::currentChanged(const QModelIndex &current, const QModelIndex &old)

static void _init_cbs_currentChanged_4682_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("current");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("old");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_currentChanged_4682_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QHeaderView_Adaptor *)cls)->cbs_currentChanged_4682_0 (arg1, arg2);
}

static void _set_callback_cbs_currentChanged_4682_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_currentChanged_4682_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_currentChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("*currentChanged", "@hide", false, &_init_cbs_currentChanged_4682_0, &_call_cbs_currentChanged_4682_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_currentChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("*currentChanged", "@brief Virtual method void QHeaderView::currentChanged(const QModelIndex &current, const QModelIndex &old)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_currentChanged_4682_0, &_call_cbs_currentChanged_4682_0, &_set_callback_cbs_currentChanged_4682_0);
}


// void QHeaderView::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QHeaderView::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QHeaderView::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)

static void _init_cbs_dataChanged_4682_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("topLeft");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bottomRight");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_dataChanged_4682_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QHeaderView_Adaptor *)cls)->cbs_dataChanged_4682_0 (arg1, arg2);
}

static void _set_callback_cbs_dataChanged_4682_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_dataChanged_4682_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dataChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("*dataChanged", "@hide", false, &_init_cbs_dataChanged_4682_0, &_call_cbs_dataChanged_4682_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dataChanged_4682_0 ()
{
  return new qt_gsi::GenericMethod ("*dataChanged", "@brief Virtual method void QHeaderView::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dataChanged_4682_0, &_call_cbs_dataChanged_4682_0, &_set_callback_cbs_dataChanged_4682_0);
}


// void QHeaderView::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QHeaderView::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QHeaderView::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QHeaderView::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QHeaderView::dragLeaveEvent(QDragLeaveEvent *event)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QHeaderView::dragLeaveEvent(QDragLeaveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QHeaderView::dragMoveEvent(QDragMoveEvent *event)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QHeaderView::dragMoveEvent(QDragMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// void QHeaderView::dropEvent(QDropEvent *event)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QHeaderView::dropEvent(QDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// bool QHeaderView::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)

static void _init_cbs_edit_6773_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("trigger");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("event");
  decl->add_arg<QEvent * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_edit_6773_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemView::EditTrigger>::target_type & > ();
  QEvent *arg3 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QHeaderView_Adaptor *)cls)->cbs_edit_6773_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_edit_6773_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_edit_6773_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_edit_6773_0 ()
{
  return new qt_gsi::GenericMethod ("*edit", "@hide", false, &_init_cbs_edit_6773_0, &_call_cbs_edit_6773_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_edit_6773_0 ()
{
  return new qt_gsi::GenericMethod ("*edit", "@brief Virtual method bool QHeaderView::edit(const QModelIndex &index, QAbstractItemView::EditTrigger trigger, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_edit_6773_0, &_call_cbs_edit_6773_0, &_set_callback_cbs_edit_6773_0);
}


// void QHeaderView::editorDestroyed(QObject *editor)

static void _init_cbs_editorDestroyed_1302_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_editorDestroyed_1302_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_editorDestroyed_1302_0 (arg1);
}

static void _set_callback_cbs_editorDestroyed_1302_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_editorDestroyed_1302_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_editorDestroyed_1302_0 ()
{
  return new qt_gsi::GenericMethod ("*editorDestroyed", "@hide", false, &_init_cbs_editorDestroyed_1302_0, &_call_cbs_editorDestroyed_1302_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_editorDestroyed_1302_0 ()
{
  return new qt_gsi::GenericMethod ("*editorDestroyed", "@brief Virtual method void QHeaderView::editorDestroyed(QObject *editor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_editorDestroyed_1302_0, &_call_cbs_editorDestroyed_1302_0, &_set_callback_cbs_editorDestroyed_1302_0);
}


// void QHeaderView::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QHeaderView_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QHeaderView::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QHeaderView::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QHeaderView::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// bool QHeaderView::event(QEvent *e)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QHeaderView_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QHeaderView::event(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QHeaderView::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QHeaderView::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QHeaderView::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QHeaderView_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QHeaderView::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QHeaderView::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QHeaderView::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QHeaderView::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QHeaderView_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QHeaderView::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QHeaderView::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QHeaderView::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// int QHeaderView::horizontalOffset()

static void _init_cbs_horizontalOffset_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_horizontalOffset_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QHeaderView_Adaptor *)cls)->cbs_horizontalOffset_c0_0 ());
}

static void _set_callback_cbs_horizontalOffset_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_horizontalOffset_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_horizontalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalOffset", "@hide", true, &_init_cbs_horizontalOffset_c0_0, &_call_cbs_horizontalOffset_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_horizontalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalOffset", "@brief Virtual method int QHeaderView::horizontalOffset()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_horizontalOffset_c0_0, &_call_cbs_horizontalOffset_c0_0, &_set_callback_cbs_horizontalOffset_c0_0);
}


// void QHeaderView::horizontalScrollbarAction(int action)

static void _init_cbs_horizontalScrollbarAction_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_horizontalScrollbarAction_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QHeaderView_Adaptor *)cls)->cbs_horizontalScrollbarAction_767_0 (arg1);
}

static void _set_callback_cbs_horizontalScrollbarAction_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_horizontalScrollbarAction_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_horizontalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarAction", "@hide", false, &_init_cbs_horizontalScrollbarAction_767_0, &_call_cbs_horizontalScrollbarAction_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_horizontalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarAction", "@brief Virtual method void QHeaderView::horizontalScrollbarAction(int action)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_horizontalScrollbarAction_767_0, &_call_cbs_horizontalScrollbarAction_767_0, &_set_callback_cbs_horizontalScrollbarAction_767_0);
}


// void QHeaderView::horizontalScrollbarValueChanged(int value)

static void _init_cbs_horizontalScrollbarValueChanged_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_horizontalScrollbarValueChanged_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QHeaderView_Adaptor *)cls)->cbs_horizontalScrollbarValueChanged_767_0 (arg1);
}

static void _set_callback_cbs_horizontalScrollbarValueChanged_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_horizontalScrollbarValueChanged_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_horizontalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarValueChanged", "@hide", false, &_init_cbs_horizontalScrollbarValueChanged_767_0, &_call_cbs_horizontalScrollbarValueChanged_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_horizontalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*horizontalScrollbarValueChanged", "@brief Virtual method void QHeaderView::horizontalScrollbarValueChanged(int value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_horizontalScrollbarValueChanged_767_0, &_call_cbs_horizontalScrollbarValueChanged_767_0, &_set_callback_cbs_horizontalScrollbarValueChanged_767_0);
}


// QModelIndex QHeaderView::indexAt(const QPoint &p)

static void _init_cbs_indexAt_c1916_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_indexAt_c1916_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QModelIndex > ((QModelIndex)((QHeaderView_Adaptor *)cls)->cbs_indexAt_c1916_0 (arg1));
}

static void _set_callback_cbs_indexAt_c1916_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_indexAt_c1916_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_indexAt_c1916_0 ()
{
  return new qt_gsi::GenericMethod ("*indexAt", "@hide", true, &_init_cbs_indexAt_c1916_0, &_call_cbs_indexAt_c1916_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_indexAt_c1916_0 ()
{
  return new qt_gsi::GenericMethod ("*indexAt", "@brief Virtual method QModelIndex QHeaderView::indexAt(const QPoint &p)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexAt_c1916_0, &_call_cbs_indexAt_c1916_0, &_set_callback_cbs_indexAt_c1916_0);
}


// void QHeaderView::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QHeaderView::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// bool QHeaderView::isIndexHidden(const QModelIndex &index)

static void _init_cbs_isIndexHidden_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isIndexHidden_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QHeaderView_Adaptor *)cls)->cbs_isIndexHidden_c2395_0 (arg1));
}

static void _set_callback_cbs_isIndexHidden_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_isIndexHidden_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_isIndexHidden_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("*isIndexHidden", "@hide", true, &_init_cbs_isIndexHidden_c2395_0, &_call_cbs_isIndexHidden_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_isIndexHidden_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("*isIndexHidden", "@brief Virtual method bool QHeaderView::isIndexHidden(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isIndexHidden_c2395_0, &_call_cbs_isIndexHidden_c2395_0, &_set_callback_cbs_isIndexHidden_c2395_0);
}


// void QHeaderView::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QHeaderView::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QHeaderView::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QHeaderView::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QHeaderView::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QHeaderView::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QHeaderView::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QHeaderView::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QHeaderView::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QHeaderView_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QHeaderView::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// void QHeaderView::mouseDoubleClickEvent(QMouseEvent *e)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QHeaderView::mouseDoubleClickEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QHeaderView::mouseMoveEvent(QMouseEvent *e)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QHeaderView::mouseMoveEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QHeaderView::mousePressEvent(QMouseEvent *e)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QHeaderView::mousePressEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QHeaderView::mouseReleaseEvent(QMouseEvent *e)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QHeaderView::mouseReleaseEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// QModelIndex QHeaderView::moveCursor(QAbstractItemView::CursorAction, QFlags<Qt::KeyboardModifier>)

static void _init_cbs_moveCursor_6476_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & > (argspec_1);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_moveCursor_6476_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type & > ();
  ret.write<QModelIndex > ((QModelIndex)((QHeaderView_Adaptor *)cls)->cbs_moveCursor_6476_0 (arg1, arg2));
}

static void _set_callback_cbs_moveCursor_6476_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_moveCursor_6476_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveCursor_6476_0 ()
{
  return new qt_gsi::GenericMethod ("*moveCursor", "@hide", false, &_init_cbs_moveCursor_6476_0, &_call_cbs_moveCursor_6476_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveCursor_6476_0 ()
{
  return new qt_gsi::GenericMethod ("*moveCursor", "@brief Virtual method QModelIndex QHeaderView::moveCursor(QAbstractItemView::CursorAction, QFlags<Qt::KeyboardModifier>)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveCursor_6476_0, &_call_cbs_moveCursor_6476_0, &_set_callback_cbs_moveCursor_6476_0);
}


// void QHeaderView::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QHeaderView::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QHeaderView::paintEvent(QPaintEvent *e)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QHeaderView::paintEvent(QPaintEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QHeaderView::paintSection(QPainter *painter, const QRect &rect, int logicalIndex)

static void _init_cbs_paintSection_c3769_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("logicalIndex");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_paintSection_c3769_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRect &arg2 = args.read<const QRect & > ();
  int arg3 = args.read<int > ();
  ((QHeaderView_Adaptor *)cls)->cbs_paintSection_c3769_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_paintSection_c3769_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_paintSection_c3769_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintSection_c3769_0 ()
{
  return new qt_gsi::GenericMethod ("*paintSection", "@hide", true, &_init_cbs_paintSection_c3769_0, &_call_cbs_paintSection_c3769_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintSection_c3769_0 ()
{
  return new qt_gsi::GenericMethod ("*paintSection", "@brief Virtual method void QHeaderView::paintSection(QPainter *painter, const QRect &rect, int logicalIndex)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintSection_c3769_0, &_call_cbs_paintSection_c3769_0, &_set_callback_cbs_paintSection_c3769_0);
}


// void QHeaderView::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QHeaderView_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QHeaderView::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QHeaderView::resizeEvent(QResizeEvent *event)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QHeaderView::resizeEvent(QResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QHeaderView::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)

static void _init_cbs_rowsAboutToBeRemoved_3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_rowsAboutToBeRemoved_3713_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QHeaderView_Adaptor *)cls)->cbs_rowsAboutToBeRemoved_3713_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_rowsAboutToBeRemoved_3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_rowsAboutToBeRemoved_3713_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_rowsAboutToBeRemoved_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsAboutToBeRemoved", "@hide", false, &_init_cbs_rowsAboutToBeRemoved_3713_0, &_call_cbs_rowsAboutToBeRemoved_3713_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_rowsAboutToBeRemoved_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsAboutToBeRemoved", "@brief Virtual method void QHeaderView::rowsAboutToBeRemoved(const QModelIndex &parent, int start, int end)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_rowsAboutToBeRemoved_3713_0, &_call_cbs_rowsAboutToBeRemoved_3713_0, &_set_callback_cbs_rowsAboutToBeRemoved_3713_0);
}


// void QHeaderView::rowsInserted(const QModelIndex &parent, int start, int end)

static void _init_cbs_rowsInserted_3713_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("start");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("end");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_rowsInserted_3713_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QHeaderView_Adaptor *)cls)->cbs_rowsInserted_3713_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_rowsInserted_3713_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_rowsInserted_3713_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_rowsInserted_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsInserted", "@hide", false, &_init_cbs_rowsInserted_3713_0, &_call_cbs_rowsInserted_3713_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_rowsInserted_3713_0 ()
{
  return new qt_gsi::GenericMethod ("*rowsInserted", "@brief Virtual method void QHeaderView::rowsInserted(const QModelIndex &parent, int start, int end)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_rowsInserted_3713_0, &_call_cbs_rowsInserted_3713_0, &_set_callback_cbs_rowsInserted_3713_0);
}


// void QHeaderView::scrollContentsBy(int dx, int dy)

static void _init_cbs_scrollContentsBy_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollContentsBy_1426_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QHeaderView_Adaptor *)cls)->cbs_scrollContentsBy_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_scrollContentsBy_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_scrollContentsBy_1426_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_scrollContentsBy_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*scrollContentsBy", "@hide", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_scrollContentsBy_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*scrollContentsBy", "@brief Virtual method void QHeaderView::scrollContentsBy(int dx, int dy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0, &_set_callback_cbs_scrollContentsBy_1426_0);
}


// void QHeaderView::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)

static void _init_cbs_scrollTo_5576_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollTo_5576_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractItemView::ScrollHint>::target_type & > ();
  ((QHeaderView_Adaptor *)cls)->cbs_scrollTo_5576_0 (arg1, arg2);
}

static void _set_callback_cbs_scrollTo_5576_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_scrollTo_5576_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_scrollTo_5576_0 ()
{
  return new qt_gsi::GenericMethod ("*scrollTo", "@hide", false, &_init_cbs_scrollTo_5576_0, &_call_cbs_scrollTo_5576_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_scrollTo_5576_0 ()
{
  return new qt_gsi::GenericMethod ("*scrollTo", "@brief Virtual method void QHeaderView::scrollTo(const QModelIndex &index, QAbstractItemView::ScrollHint hint)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollTo_5576_0, &_call_cbs_scrollTo_5576_0, &_set_callback_cbs_scrollTo_5576_0);
}


// QSize QHeaderView::sectionSizeFromContents(int logicalIndex)

static void _init_cbs_sectionSizeFromContents_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("logicalIndex");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_cbs_sectionSizeFromContents_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QSize > ((QSize)((QHeaderView_Adaptor *)cls)->cbs_sectionSizeFromContents_c767_0 (arg1));
}

static void _set_callback_cbs_sectionSizeFromContents_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_sectionSizeFromContents_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sectionSizeFromContents_c767_0 ()
{
  return new qt_gsi::GenericMethod ("*sectionSizeFromContents", "@hide", true, &_init_cbs_sectionSizeFromContents_c767_0, &_call_cbs_sectionSizeFromContents_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sectionSizeFromContents_c767_0 ()
{
  return new qt_gsi::GenericMethod ("*sectionSizeFromContents", "@brief Virtual method QSize QHeaderView::sectionSizeFromContents(int logicalIndex)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sectionSizeFromContents_c767_0, &_call_cbs_sectionSizeFromContents_c767_0, &_set_callback_cbs_sectionSizeFromContents_c767_0);
}


// QList<QModelIndex> QHeaderView::selectedIndexes()

static void _init_cbs_selectedIndexes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QModelIndex> >::target_type > ();
}

static void _call_cbs_selectedIndexes_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QModelIndex> >::target_type > ((qt_gsi::Converter<QList<QModelIndex> >::target_type)((QHeaderView_Adaptor *)cls)->cbs_selectedIndexes_c0_0 ());
}

static void _set_callback_cbs_selectedIndexes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_selectedIndexes_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectedIndexes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*selectedIndexes", "@hide", true, &_init_cbs_selectedIndexes_c0_0, &_call_cbs_selectedIndexes_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectedIndexes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*selectedIndexes", "@brief Virtual method QList<QModelIndex> QHeaderView::selectedIndexes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectedIndexes_c0_0, &_call_cbs_selectedIndexes_c0_0, &_set_callback_cbs_selectedIndexes_c0_0);
}


// void QHeaderView::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)

static void _init_cbs_selectionChanged_5346_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selected");
  decl->add_arg<const QItemSelection & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("deselected");
  decl->add_arg<const QItemSelection & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_selectionChanged_5346_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QItemSelection &arg1 = args.read<const QItemSelection & > ();
  const QItemSelection &arg2 = args.read<const QItemSelection & > ();
  ((QHeaderView_Adaptor *)cls)->cbs_selectionChanged_5346_0 (arg1, arg2);
}

static void _set_callback_cbs_selectionChanged_5346_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_selectionChanged_5346_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectionChanged_5346_0 ()
{
  return new qt_gsi::GenericMethod ("*selectionChanged", "@hide", false, &_init_cbs_selectionChanged_5346_0, &_call_cbs_selectionChanged_5346_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectionChanged_5346_0 ()
{
  return new qt_gsi::GenericMethod ("*selectionChanged", "@brief Virtual method void QHeaderView::selectionChanged(const QItemSelection &selected, const QItemSelection &deselected)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_selectionChanged_5346_0, &_call_cbs_selectionChanged_5346_0, &_set_callback_cbs_selectionChanged_5346_0);
}


// QFlags<QItemSelectionModel::SelectionFlag> QHeaderView::selectionCommand(const QModelIndex &index, const QEvent *event)

static void _init_cbs_selectionCommand_c4199_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<const QEvent * > (argspec_1);
  decl->set_return<qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type > ();
}

static void _call_cbs_selectionCommand_c4199_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QEvent *arg2 = args.read<const QEvent * > ();
  ret.write<qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type > ((qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type)((QHeaderView_Adaptor *)cls)->cbs_selectionCommand_c4199_1 (arg1, arg2));
}

static void _set_callback_cbs_selectionCommand_c4199_1 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_selectionCommand_c4199_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_selectionCommand_c4199_1 ()
{
  return new qt_gsi::GenericMethod ("*selectionCommand", "@hide", true, &_init_cbs_selectionCommand_c4199_1, &_call_cbs_selectionCommand_c4199_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_selectionCommand_c4199_1 ()
{
  return new qt_gsi::GenericMethod ("*selectionCommand", "@brief Virtual method QFlags<QItemSelectionModel::SelectionFlag> QHeaderView::selectionCommand(const QModelIndex &index, const QEvent *event)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_selectionCommand_c4199_1, &_call_cbs_selectionCommand_c4199_1, &_set_callback_cbs_selectionCommand_c4199_1);
}


// void QHeaderView::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> flags)

static void _init_cbs_setSelection_6155_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setSelection_6155_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<QItemSelectionModel::SelectionFlag> >::target_type & > ();
  ((QHeaderView_Adaptor *)cls)->cbs_setSelection_6155_0 (arg1, arg2);
}

static void _set_callback_cbs_setSelection_6155_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_setSelection_6155_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setSelection_6155_0 ()
{
  return new qt_gsi::GenericMethod ("*setSelection", "@hide", false, &_init_cbs_setSelection_6155_0, &_call_cbs_setSelection_6155_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setSelection_6155_0 ()
{
  return new qt_gsi::GenericMethod ("*setSelection", "@brief Virtual method void QHeaderView::setSelection(const QRect &rect, QFlags<QItemSelectionModel::SelectionFlag> flags)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSelection_6155_0, &_call_cbs_setSelection_6155_0, &_set_callback_cbs_setSelection_6155_0);
}


// void QHeaderView::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QHeaderView::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// void QHeaderView::startDrag(QFlags<Qt::DropAction> supportedActions)

static void _init_cbs_startDrag_2456_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("supportedActions");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_startDrag_2456_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type & > ();
  ((QHeaderView_Adaptor *)cls)->cbs_startDrag_2456_0 (arg1);
}

static void _set_callback_cbs_startDrag_2456_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_startDrag_2456_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_startDrag_2456_0 ()
{
  return new qt_gsi::GenericMethod ("*startDrag", "@hide", false, &_init_cbs_startDrag_2456_0, &_call_cbs_startDrag_2456_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_startDrag_2456_0 ()
{
  return new qt_gsi::GenericMethod ("*startDrag", "@brief Virtual method void QHeaderView::startDrag(QFlags<Qt::DropAction> supportedActions)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_startDrag_2456_0, &_call_cbs_startDrag_2456_0, &_set_callback_cbs_startDrag_2456_0);
}


// void QHeaderView::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QHeaderView_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QHeaderView::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// void QHeaderView::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QHeaderView::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QHeaderView::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QHeaderView::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QHeaderView::updateEditorData()

static void _init_cbs_updateEditorData_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorData_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView_Adaptor *)cls)->cbs_updateEditorData_0_0 ();
}

static void _set_callback_cbs_updateEditorData_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_updateEditorData_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_updateEditorData_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorData", "@hide", false, &_init_cbs_updateEditorData_0_0, &_call_cbs_updateEditorData_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_updateEditorData_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorData", "@brief Virtual method void QHeaderView::updateEditorData()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateEditorData_0_0, &_call_cbs_updateEditorData_0_0, &_set_callback_cbs_updateEditorData_0_0);
}


// void QHeaderView::updateEditorGeometries()

static void _init_cbs_updateEditorGeometries_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorGeometries_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView_Adaptor *)cls)->cbs_updateEditorGeometries_0_0 ();
}

static void _set_callback_cbs_updateEditorGeometries_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_updateEditorGeometries_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_updateEditorGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorGeometries", "@hide", false, &_init_cbs_updateEditorGeometries_0_0, &_call_cbs_updateEditorGeometries_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_updateEditorGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateEditorGeometries", "@brief Virtual method void QHeaderView::updateEditorGeometries()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateEditorGeometries_0_0, &_call_cbs_updateEditorGeometries_0_0, &_set_callback_cbs_updateEditorGeometries_0_0);
}


// void QHeaderView::updateGeometries()

static void _init_cbs_updateGeometries_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateGeometries_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QHeaderView_Adaptor *)cls)->cbs_updateGeometries_0_0 ();
}

static void _set_callback_cbs_updateGeometries_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_updateGeometries_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_updateGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateGeometries", "@hide", false, &_init_cbs_updateGeometries_0_0, &_call_cbs_updateGeometries_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_updateGeometries_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateGeometries", "@brief Virtual method void QHeaderView::updateGeometries()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateGeometries_0_0, &_call_cbs_updateGeometries_0_0, &_set_callback_cbs_updateGeometries_0_0);
}


// int QHeaderView::verticalOffset()

static void _init_cbs_verticalOffset_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_verticalOffset_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QHeaderView_Adaptor *)cls)->cbs_verticalOffset_c0_0 ());
}

static void _set_callback_cbs_verticalOffset_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_verticalOffset_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_verticalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalOffset", "@hide", true, &_init_cbs_verticalOffset_c0_0, &_call_cbs_verticalOffset_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_verticalOffset_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalOffset", "@brief Virtual method int QHeaderView::verticalOffset()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_verticalOffset_c0_0, &_call_cbs_verticalOffset_c0_0, &_set_callback_cbs_verticalOffset_c0_0);
}


// void QHeaderView::verticalScrollbarAction(int action)

static void _init_cbs_verticalScrollbarAction_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_verticalScrollbarAction_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QHeaderView_Adaptor *)cls)->cbs_verticalScrollbarAction_767_0 (arg1);
}

static void _set_callback_cbs_verticalScrollbarAction_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_verticalScrollbarAction_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_verticalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarAction", "@hide", false, &_init_cbs_verticalScrollbarAction_767_0, &_call_cbs_verticalScrollbarAction_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_verticalScrollbarAction_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarAction", "@brief Virtual method void QHeaderView::verticalScrollbarAction(int action)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_verticalScrollbarAction_767_0, &_call_cbs_verticalScrollbarAction_767_0, &_set_callback_cbs_verticalScrollbarAction_767_0);
}


// void QHeaderView::verticalScrollbarValueChanged(int value)

static void _init_cbs_verticalScrollbarValueChanged_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_verticalScrollbarValueChanged_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QHeaderView_Adaptor *)cls)->cbs_verticalScrollbarValueChanged_767_0 (arg1);
}

static void _set_callback_cbs_verticalScrollbarValueChanged_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_verticalScrollbarValueChanged_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_verticalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarValueChanged", "@hide", false, &_init_cbs_verticalScrollbarValueChanged_767_0, &_call_cbs_verticalScrollbarValueChanged_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_verticalScrollbarValueChanged_767_0 ()
{
  return new qt_gsi::GenericMethod ("*verticalScrollbarValueChanged", "@brief Virtual method void QHeaderView::verticalScrollbarValueChanged(int value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_verticalScrollbarValueChanged_767_0, &_call_cbs_verticalScrollbarValueChanged_767_0, &_set_callback_cbs_verticalScrollbarValueChanged_767_0);
}


// QStyleOptionViewItem QHeaderView::viewOptions()

static void _init_cbs_viewOptions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStyleOptionViewItem > ();
}

static void _call_cbs_viewOptions_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QStyleOptionViewItem > ((QStyleOptionViewItem)((QHeaderView_Adaptor *)cls)->cbs_viewOptions_c0_0 ());
}

static void _set_callback_cbs_viewOptions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_viewOptions_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_viewOptions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*viewOptions", "@hide", true, &_init_cbs_viewOptions_c0_0, &_call_cbs_viewOptions_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_viewOptions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("*viewOptions", "@brief Virtual method QStyleOptionViewItem QHeaderView::viewOptions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_viewOptions_c0_0, &_call_cbs_viewOptions_c0_0, &_set_callback_cbs_viewOptions_c0_0);
}


// bool QHeaderView::viewportEvent(QEvent *e)

static void _init_cbs_viewportEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_viewportEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QHeaderView_Adaptor *)cls)->cbs_viewportEvent_1217_0 (arg1));
}

static void _set_callback_cbs_viewportEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_viewportEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_viewportEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*viewportEvent", "@hide", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_viewportEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*viewportEvent", "@brief Virtual method bool QHeaderView::viewportEvent(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0, &_set_callback_cbs_viewportEvent_1217_0);
}


// QRect QHeaderView::visualRect(const QModelIndex &index)

static void _init_cbs_visualRect_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_cbs_visualRect_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QRect > ((QRect)((QHeaderView_Adaptor *)cls)->cbs_visualRect_c2395_0 (arg1));
}

static void _set_callback_cbs_visualRect_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_visualRect_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_visualRect_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("*visualRect", "@hide", true, &_init_cbs_visualRect_c2395_0, &_call_cbs_visualRect_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_visualRect_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("*visualRect", "@brief Virtual method QRect QHeaderView::visualRect(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_visualRect_c2395_0, &_call_cbs_visualRect_c2395_0, &_set_callback_cbs_visualRect_c2395_0);
}


// QRegion QHeaderView::visualRegionForSelection(const QItemSelection &selection)

static void _init_cbs_visualRegionForSelection_c2727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("selection");
  decl->add_arg<const QItemSelection & > (argspec_0);
  decl->set_return<QRegion > ();
}

static void _call_cbs_visualRegionForSelection_c2727_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QItemSelection &arg1 = args.read<const QItemSelection & > ();
  ret.write<QRegion > ((QRegion)((QHeaderView_Adaptor *)cls)->cbs_visualRegionForSelection_c2727_0 (arg1));
}

static void _set_callback_cbs_visualRegionForSelection_c2727_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_visualRegionForSelection_c2727_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_visualRegionForSelection_c2727_0 ()
{
  return new qt_gsi::GenericMethod ("*visualRegionForSelection", "@hide", true, &_init_cbs_visualRegionForSelection_c2727_0, &_call_cbs_visualRegionForSelection_c2727_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_visualRegionForSelection_c2727_0 ()
{
  return new qt_gsi::GenericMethod ("*visualRegionForSelection", "@brief Virtual method QRegion QHeaderView::visualRegionForSelection(const QItemSelection &selection)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_visualRegionForSelection_c2727_0, &_call_cbs_visualRegionForSelection_c2727_0, &_set_callback_cbs_visualRegionForSelection_c2727_0);
}


// void QHeaderView::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QHeaderView_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QHeaderView::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QHeaderView::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QHeaderView_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QHeaderView_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QHeaderView::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QHeaderView> decl_QHeaderView;

gsi::Class<QHeaderView_Adaptor> decl_QHeaderView_Adaptor (decl_QHeaderView, "QHeaderView",
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_dirtyRegionOffset_c0 ()) +
  gsi::Methods(_create_fp_doAutoScroll_0 ()) +
  gsi::Methods(_create_fp_drawFrame_1426 ()) +
  gsi::Methods(_create_fp_dropIndicatorPosition_c0 ()) +
  gsi::Methods(_create_fp_executeDelayedItemsLayout_0 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_horizontalStepsPerItem_c0 ()) +
  gsi::Methods(_create_fp_initStyleOption_c2450 ()) +
  gsi::Methods(_create_fp_initialize_0 ()) +
  gsi::Methods(_create_fp_initializeSections_0 ()) +
  gsi::Methods(_create_fp_initializeSections_1426 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_resizeSections_0 ()) +
  gsi::Methods(_create_fp_scheduleDelayedItemsLayout_0 ()) +
  gsi::Methods(_create_fp_scrollDirtyRegion_1426 ()) +
  gsi::Methods(_create_fp_sectionsAboutToBeRemoved_3713 ()) +
  gsi::Methods(_create_fp_sectionsInserted_3713 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_setDirtyRegion_2006 ()) +
  gsi::Methods(_create_fp_setHorizontalStepsPerItem_767 ()) +
  gsi::Methods(_create_fp_setState_2776 ()) +
  gsi::Methods(_create_fp_setVerticalStepsPerItem_767 ()) +
  gsi::Methods(_create_fp_setViewportMargins_2744 ()) +
  gsi::Methods(_create_fp_setViewportMargins_2115 ()) +
  gsi::Methods(_create_fp_setupViewport_1315 ()) +
  gsi::Methods(_create_fp_startAutoScroll_0 ()) +
  gsi::Methods(_create_fp_state_c0 ()) +
  gsi::Methods(_create_fp_stopAutoScroll_0 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_fp_updateSection_767 ()) +
  gsi::Methods(_create_fp_verticalStepsPerItem_c0 ()) +
  gsi::Methods(_create_cbs_doItemsLayout_0_0 ()) +
  gsi::Methods(_create_callback_cbs_doItemsLayout_0_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_keyboardSearch_2025_0 ()) +
  gsi::Methods(_create_callback_cbs_keyboardSearch_2025_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_reset_0_0 ()) +
  gsi::Methods(_create_callback_cbs_reset_0_0 ()) +
  gsi::Methods(_create_cbs_selectAll_0_0 ()) +
  gsi::Methods(_create_callback_cbs_selectAll_0_0 ()) +
  gsi::Methods(_create_cbs_setModel_2419_0 ()) +
  gsi::Methods(_create_callback_cbs_setModel_2419_0 ()) +
  gsi::Methods(_create_cbs_setRootIndex_2395_0 ()) +
  gsi::Methods(_create_callback_cbs_setRootIndex_2395_0 ()) +
  gsi::Methods(_create_cbs_setSelectionModel_2533_0 ()) +
  gsi::Methods(_create_callback_cbs_setSelectionModel_2533_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_sizeHintForColumn_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHintForColumn_c767_0 ()) +
  gsi::Methods(_create_cbs_sizeHintForRow_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHintForRow_c767_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEditor_4926_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEditor_4926_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_commitData_1315_0 ()) +
  gsi::Methods(_create_callback_cbs_commitData_1315_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_currentChanged_4682_0 ()) +
  gsi::Methods(_create_callback_cbs_currentChanged_4682_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_dataChanged_4682_0 ()) +
  gsi::Methods(_create_callback_cbs_dataChanged_4682_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_edit_6773_0 ()) +
  gsi::Methods(_create_callback_cbs_edit_6773_0 ()) +
  gsi::Methods(_create_cbs_editorDestroyed_1302_0 ()) +
  gsi::Methods(_create_callback_cbs_editorDestroyed_1302_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_horizontalOffset_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_horizontalOffset_c0_0 ()) +
  gsi::Methods(_create_cbs_horizontalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_callback_cbs_horizontalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_cbs_horizontalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_callback_cbs_horizontalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_cbs_indexAt_c1916_0 ()) +
  gsi::Methods(_create_callback_cbs_indexAt_c1916_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_isIndexHidden_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_isIndexHidden_c2395_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveCursor_6476_0 ()) +
  gsi::Methods(_create_callback_cbs_moveCursor_6476_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paintSection_c3769_0 ()) +
  gsi::Methods(_create_callback_cbs_paintSection_c3769_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_rowsAboutToBeRemoved_3713_0 ()) +
  gsi::Methods(_create_callback_cbs_rowsAboutToBeRemoved_3713_0 ()) +
  gsi::Methods(_create_cbs_rowsInserted_3713_0 ()) +
  gsi::Methods(_create_callback_cbs_rowsInserted_3713_0 ()) +
  gsi::Methods(_create_cbs_scrollContentsBy_1426_0 ()) +
  gsi::Methods(_create_callback_cbs_scrollContentsBy_1426_0 ()) +
  gsi::Methods(_create_cbs_scrollTo_5576_0 ()) +
  gsi::Methods(_create_callback_cbs_scrollTo_5576_0 ()) +
  gsi::Methods(_create_cbs_sectionSizeFromContents_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_sectionSizeFromContents_c767_0 ()) +
  gsi::Methods(_create_cbs_selectedIndexes_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_selectedIndexes_c0_0 ()) +
  gsi::Methods(_create_cbs_selectionChanged_5346_0 ()) +
  gsi::Methods(_create_callback_cbs_selectionChanged_5346_0 ()) +
  gsi::Methods(_create_cbs_selectionCommand_c4199_1 ()) +
  gsi::Methods(_create_callback_cbs_selectionCommand_c4199_1 ()) +
  gsi::Methods(_create_cbs_setSelection_6155_0 ()) +
  gsi::Methods(_create_callback_cbs_setSelection_6155_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_startDrag_2456_0 ()) +
  gsi::Methods(_create_callback_cbs_startDrag_2456_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_updateEditorData_0_0 ()) +
  gsi::Methods(_create_callback_cbs_updateEditorData_0_0 ()) +
  gsi::Methods(_create_cbs_updateEditorGeometries_0_0 ()) +
  gsi::Methods(_create_callback_cbs_updateEditorGeometries_0_0 ()) +
  gsi::Methods(_create_cbs_updateGeometries_0_0 ()) +
  gsi::Methods(_create_callback_cbs_updateGeometries_0_0 ()) +
  gsi::Methods(_create_cbs_verticalOffset_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_verticalOffset_c0_0 ()) +
  gsi::Methods(_create_cbs_verticalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_callback_cbs_verticalScrollbarAction_767_0 ()) +
  gsi::Methods(_create_cbs_verticalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_callback_cbs_verticalScrollbarValueChanged_767_0 ()) +
  gsi::Methods(_create_cbs_viewOptions_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_viewOptions_c0_0 ()) +
  gsi::Methods(_create_cbs_viewportEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_viewportEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_visualRect_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_visualRect_c2395_0 ()) +
  gsi::Methods(_create_cbs_visualRegionForSelection_c2727_0 ()) +
  gsi::Methods(_create_callback_cbs_visualRegionForSelection_c2727_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QHeaderView_Adaptor_3120 ()),
  "@qt\n@brief Binding of QHeaderView");

}


//  Implementation of the enum wrapper class for QHeaderView::ResizeMode
namespace qt_gsi
{

static QHeaderView_ResizeMode_Enum *c_1_QHeaderView_ResizeMode_Enum () { return new QHeaderView_ResizeMode_Enum (QHeaderView::Interactive); }
static QHeaderView_ResizeMode_Enum *c_2_QHeaderView_ResizeMode_Enum () { return new QHeaderView_ResizeMode_Enum (QHeaderView::Stretch); }
static QHeaderView_ResizeMode_Enum *c_3_QHeaderView_ResizeMode_Enum () { return new QHeaderView_ResizeMode_Enum (QHeaderView::Fixed); }
static QHeaderView_ResizeMode_Enum *c_4_QHeaderView_ResizeMode_Enum () { return new QHeaderView_ResizeMode_Enum (QHeaderView::ResizeToContents); }
static QHeaderView_ResizeMode_Enum *c_5_QHeaderView_ResizeMode_Enum () { return new QHeaderView_ResizeMode_Enum (QHeaderView::Custom); }

static gsi::Methods mkdefs_QHeaderView_ResizeMode () {
  return
    gsi::constant ("Interactive", &qt_gsi::c_1_QHeaderView_ResizeMode_Enum, "@brief Enum constant QHeaderView::Interactive") +
    gsi::constant ("Stretch", &qt_gsi::c_2_QHeaderView_ResizeMode_Enum, "@brief Enum constant QHeaderView::Stretch") +
    gsi::constant ("Fixed", &qt_gsi::c_3_QHeaderView_ResizeMode_Enum, "@brief Enum constant QHeaderView::Fixed") +
    gsi::constant ("ResizeToContents", &qt_gsi::c_4_QHeaderView_ResizeMode_Enum, "@brief Enum constant QHeaderView::ResizeToContents") +
    gsi::constant ("Custom", &qt_gsi::c_5_QHeaderView_ResizeMode_Enum, "@brief Enum constant QHeaderView::Custom");
}

static std::string to_s_QHeaderView_ResizeMode_Enum (const QHeaderView_ResizeMode_Enum *e)
{
  if (e->value () == QHeaderView::Interactive) { return tl::sprintf ("Interactive (%u)", (unsigned int) e->value ()); }
  if (e->value () == QHeaderView::Stretch) { return tl::sprintf ("Stretch (%u)", (unsigned int) e->value ()); }
  if (e->value () == QHeaderView::Fixed) { return tl::sprintf ("Fixed (%u)", (unsigned int) e->value ()); }
  if (e->value () == QHeaderView::ResizeToContents) { return tl::sprintf ("ResizeToContents (%u)", (unsigned int) e->value ()); }
  if (e->value () == QHeaderView::Custom) { return tl::sprintf ("Custom (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QHeaderView_ResizeMode_Enum (const QHeaderView_ResizeMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QHeaderView_ResizeMode_Enum *from_i_QHeaderView_ResizeMode_Enum (unsigned int i)
{
  return new QHeaderView_ResizeMode_Enum ((QHeaderView::ResizeMode) i);
}

static bool equalQHeaderView_ResizeMode_Enum (const QHeaderView_ResizeMode_Enum *e, QHeaderView_ResizeMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QHeaderView_ResizeMode_Enum (const QHeaderView_ResizeMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QHeaderView_ResizeMode_Enums oropQHeaderView_ResizeMode_Enums (const QHeaderView_ResizeMode_Enums *e, const QHeaderView_ResizeMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QHeaderView_ResizeMode_Enums andopQHeaderView_ResizeMode_Enums (const QHeaderView_ResizeMode_Enums *e, const QHeaderView_ResizeMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QHeaderView_ResizeMode_Enums xoropQHeaderView_ResizeMode_Enums (const QHeaderView_ResizeMode_Enums *e, const QHeaderView_ResizeMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QHeaderView_ResizeMode_Enums (const QHeaderView_ResizeMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QHeaderView::Interactive)) { if (!l.empty ()) l += "|"; l += "Interactive"; }
  if (e->testFlag (QHeaderView::Stretch)) { if (!l.empty ()) l += "|"; l += "Stretch"; }
  if (e->testFlag (QHeaderView::Fixed)) { if (!l.empty ()) l += "|"; l += "Fixed"; }
  if (e->testFlag (QHeaderView::ResizeToContents)) { if (!l.empty ()) l += "|"; l += "ResizeToContents"; }
  if (e->testFlag (QHeaderView::Custom)) { if (!l.empty ()) l += "|"; l += "Custom"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QHeaderView_ResizeMode_Enums (const QHeaderView_ResizeMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QHeaderView_ResizeMode_Enums (const QHeaderView_ResizeMode_Enums *e, const QHeaderView_ResizeMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QHeaderView_ResizeMode_Enums> decl_QHeaderView_ResizeMode_Enums ("QHeaderView_QFlags_ResizeMode",
  gsi::method_ext ("|", &qt_gsi::oropQHeaderView_ResizeMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQHeaderView_ResizeMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQHeaderView_ResizeMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QHeaderView_ResizeMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QHeaderView_ResizeMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QHeaderView_ResizeMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QHeaderView::ResizeMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QHeaderView_ResizeMode_Enum> decl_QHeaderView_ResizeMode_Enum (decl_QHeaderView_ResizeMode_Enums, "QHeaderView_ResizeMode",
  qt_gsi::mkdefs_QHeaderView_ResizeMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QHeaderView_ResizeMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QHeaderView_ResizeMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQHeaderView_ResizeMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QHeaderView_ResizeMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QHeaderView_ResizeMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QHeaderView::ResizeMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QHeaderView> inject_QHeaderView_ResizeMode_Enum_in_parent (qt_gsi::mkdefs_QHeaderView_ResizeMode ());
static gsi::ClassExt<QHeaderView> decl_QHeaderView_ResizeMode_Enum_as_child (decl_QHeaderView_ResizeMode_Enum, "ResizeMode");

}

