
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsWidget.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQGraphicsWidget_EventAdaptor.h"
#include "gsiDeclQGraphicsWidget_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsWidget

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGraphicsWidget::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QList<QAction *> QGraphicsWidget::actions()


static void _init_f_actions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QAction *> >::target_type > ();
}

static void _call_f_actions_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QAction *> >::target_type > ((qt_gsi::Converter<QList<QAction *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QAction *> >(((QGraphicsWidget *)cls)->actions ()));
}

static qt_gsi::GenericMethod *_create_f_actions_c0 ()
{
  return new qt_gsi::GenericMethod ("actions", "@brief Method QList<QAction *> QGraphicsWidget::actions()\n", true, &_init_f_actions_c0, &_call_f_actions_c0);
}

// void QGraphicsWidget::addAction(QAction *action)


static void _init_f_addAction_1309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<QAction * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addAction_1309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAction *arg1 = args.read<QAction * > ();
  ((QGraphicsWidget *)cls)->addAction (arg1);
}

static qt_gsi::GenericMethod *_create_f_addAction_1309 ()
{
  return new qt_gsi::GenericMethod ("addAction", "@brief Method void QGraphicsWidget::addAction(QAction *action)\n", false, &_init_f_addAction_1309, &_call_f_addAction_1309);
}

// void QGraphicsWidget::addActions(QList<QAction *> actions)


static void _init_f_addActions_1924 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("actions");
  decl->add_arg<const qt_gsi::Converter<QList<QAction *> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addActions_1924 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QAction *> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QAction *> >::target_type & > ();
  ((QGraphicsWidget *)cls)->addActions (qt_gsi::QtToCppAdaptor<QList<QAction *> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_addActions_1924 ()
{
  return new qt_gsi::GenericMethod ("addActions", "@brief Method void QGraphicsWidget::addActions(QList<QAction *> actions)\n", false, &_init_f_addActions_1924, &_call_f_addActions_1924);
}

// void QGraphicsWidget::adjustSize()


static void _init_f_adjustSize_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_adjustSize_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsWidget *)cls)->adjustSize ();
}

static qt_gsi::GenericMethod *_create_f_adjustSize_0 ()
{
  return new qt_gsi::GenericMethod ("adjustSize", "@brief Method void QGraphicsWidget::adjustSize()\n", false, &_init_f_adjustSize_0, &_call_f_adjustSize_0);
}

// QRectF QGraphicsWidget::boundingRect()


static void _init_f_boundingRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_boundingRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QGraphicsWidget *)cls)->boundingRect ());
}

static qt_gsi::GenericMethod *_create_f_boundingRect_c0 ()
{
  return new qt_gsi::GenericMethod ("boundingRect", "@brief Method QRectF QGraphicsWidget::boundingRect()\nThis is a reimplementation of QGraphicsItem::boundingRect", true, &_init_f_boundingRect_c0, &_call_f_boundingRect_c0);
}

// const QList<QObject *> &QGraphicsWidget::children()


static void _init_f_children_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QObject *> >::target_type > ();
}

static void _call_f_children_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QObject *> >::target_type > ((qt_gsi::Converter<QList<QObject *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QObject *> >(((QGraphicsWidget *)cls)->children ()));
}

static qt_gsi::GenericMethod *_create_f_children_c0 ()
{
  return new qt_gsi::GenericMethod ("children", "@brief Method const QList<QObject *> &QGraphicsWidget::children()\n", true, &_init_f_children_c0, &_call_f_children_c0);
}

// bool QGraphicsWidget::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsWidget *)cls)->close ());
}

static qt_gsi::GenericMethod *_create_f_close_0 ()
{
  return new qt_gsi::GenericMethod ("close", "@brief Method bool QGraphicsWidget::close()\n", false, &_init_f_close_0, &_call_f_close_0);
}

// Qt::FocusPolicy QGraphicsWidget::focusPolicy()


static void _init_f_focusPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::FocusPolicy>::target_type > ();
}

static void _call_f_focusPolicy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::FocusPolicy>::target_type > ((qt_gsi::Converter<Qt::FocusPolicy>::target_type)qt_gsi::CppToQtAdaptor<Qt::FocusPolicy>(((QGraphicsWidget *)cls)->focusPolicy ()));
}

static qt_gsi::GenericMethod *_create_f_focusPolicy_c0 ()
{
  return new qt_gsi::GenericMethod (":focusPolicy", "@brief Method Qt::FocusPolicy QGraphicsWidget::focusPolicy()\n", true, &_init_f_focusPolicy_c0, &_call_f_focusPolicy_c0);
}

// QGraphicsWidget *QGraphicsWidget::focusWidget()


static void _init_f_focusWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsWidget * > ();
}

static void _call_f_focusWidget_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsWidget * > ((QGraphicsWidget *)((QGraphicsWidget *)cls)->focusWidget ());
}

static qt_gsi::GenericMethod *_create_f_focusWidget_c0 ()
{
  return new qt_gsi::GenericMethod ("focusWidget", "@brief Method QGraphicsWidget *QGraphicsWidget::focusWidget()\n", true, &_init_f_focusWidget_c0, &_call_f_focusWidget_c0);
}

// QFont QGraphicsWidget::font()


static void _init_f_font_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_font_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFont > ((QFont)((QGraphicsWidget *)cls)->font ());
}

static qt_gsi::GenericMethod *_create_f_font_c0 ()
{
  return new qt_gsi::GenericMethod (":font", "@brief Method QFont QGraphicsWidget::font()\n", true, &_init_f_font_c0, &_call_f_font_c0);
}

// void QGraphicsWidget::getContentsMargins(double *left, double *top, double *right, double *bottom)


static void _init_f_getContentsMargins_c4704 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<double * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<double * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_getContentsMargins_c4704 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double *arg1 = args.read<double * > ();
  double *arg2 = args.read<double * > ();
  double *arg3 = args.read<double * > ();
  double *arg4 = args.read<double * > ();
  ((QGraphicsWidget *)cls)->getContentsMargins (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_getContentsMargins_c4704 ()
{
  return new qt_gsi::GenericMethod ("getContentsMargins", "@brief Method void QGraphicsWidget::getContentsMargins(double *left, double *top, double *right, double *bottom)\nThis is a reimplementation of QGraphicsLayoutItem::getContentsMargins", true, &_init_f_getContentsMargins_c4704, &_call_f_getContentsMargins_c4704);
}

// void QGraphicsWidget::getWindowFrameMargins(double *left, double *top, double *right, double *bottom)


static void _init_f_getWindowFrameMargins_c4704 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<double * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<double * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_getWindowFrameMargins_c4704 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double *arg1 = args.read<double * > ();
  double *arg2 = args.read<double * > ();
  double *arg3 = args.read<double * > ();
  double *arg4 = args.read<double * > ();
  ((QGraphicsWidget *)cls)->getWindowFrameMargins (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_getWindowFrameMargins_c4704 ()
{
  return new qt_gsi::GenericMethod ("getWindowFrameMargins", "@brief Method void QGraphicsWidget::getWindowFrameMargins(double *left, double *top, double *right, double *bottom)\n", true, &_init_f_getWindowFrameMargins_c4704, &_call_f_getWindowFrameMargins_c4704);
}

// int QGraphicsWidget::grabShortcut(const QKeySequence &sequence, Qt::ShortcutContext context)


static void _init_f_grabShortcut_4758 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sequence");
  decl->add_arg<const QKeySequence & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("context", true, "Qt::WindowShortcut");
  decl->add_arg<const qt_gsi::Converter<Qt::ShortcutContext>::target_type & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_grabShortcut_4758 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QKeySequence &arg1 = args.read<const QKeySequence & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ShortcutContext>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::ShortcutContext>::target_type & > () : (const qt_gsi::Converter<Qt::ShortcutContext>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ShortcutContext>(heap, Qt::WindowShortcut));
  ret.write<int > ((int)((QGraphicsWidget *)cls)->grabShortcut (arg1, qt_gsi::QtToCppAdaptor<Qt::ShortcutContext>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_grabShortcut_4758 ()
{
  return new qt_gsi::GenericMethod ("grabShortcut", "@brief Method int QGraphicsWidget::grabShortcut(const QKeySequence &sequence, Qt::ShortcutContext context)\n", false, &_init_f_grabShortcut_4758, &_call_f_grabShortcut_4758);
}

// void QGraphicsWidget::insertAction(QAction *before, QAction *action)


static void _init_f_insertAction_2510 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("before");
  decl->add_arg<QAction * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<QAction * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertAction_2510 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAction *arg1 = args.read<QAction * > ();
  QAction *arg2 = args.read<QAction * > ();
  ((QGraphicsWidget *)cls)->insertAction (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_insertAction_2510 ()
{
  return new qt_gsi::GenericMethod ("insertAction", "@brief Method void QGraphicsWidget::insertAction(QAction *before, QAction *action)\n", false, &_init_f_insertAction_2510, &_call_f_insertAction_2510);
}

// void QGraphicsWidget::insertActions(QAction *before, QList<QAction *> actions)


static void _init_f_insertActions_3125 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("before");
  decl->add_arg<QAction * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("actions");
  decl->add_arg<const qt_gsi::Converter<QList<QAction *> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertActions_3125 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAction *arg1 = args.read<QAction * > ();
  const qt_gsi::Converter<QList<QAction *> >::target_type & arg2 = args.read<const qt_gsi::Converter<QList<QAction *> >::target_type & > ();
  ((QGraphicsWidget *)cls)->insertActions (arg1, qt_gsi::QtToCppAdaptor<QList<QAction *> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_insertActions_3125 ()
{
  return new qt_gsi::GenericMethod ("insertActions", "@brief Method void QGraphicsWidget::insertActions(QAction *before, QList<QAction *> actions)\n", false, &_init_f_insertActions_3125, &_call_f_insertActions_3125);
}

// bool QGraphicsWidget::isActiveWindow()


static void _init_f_isActiveWindow_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActiveWindow_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsWidget *)cls)->isActiveWindow ());
}

static qt_gsi::GenericMethod *_create_f_isActiveWindow_c0 ()
{
  return new qt_gsi::GenericMethod ("isActiveWindow?", "@brief Method bool QGraphicsWidget::isActiveWindow()\n", true, &_init_f_isActiveWindow_c0, &_call_f_isActiveWindow_c0);
}

// QGraphicsLayout *QGraphicsWidget::layout()


static void _init_f_layout_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsLayout * > ();
}

static void _call_f_layout_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsLayout * > ((QGraphicsLayout *)((QGraphicsWidget *)cls)->layout ());
}

static qt_gsi::GenericMethod *_create_f_layout_c0 ()
{
  return new qt_gsi::GenericMethod (":layout", "@brief Method QGraphicsLayout *QGraphicsWidget::layout()\n", true, &_init_f_layout_c0, &_call_f_layout_c0);
}

// Qt::LayoutDirection QGraphicsWidget::layoutDirection()


static void _init_f_layoutDirection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ();
}

static void _call_f_layoutDirection_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ((qt_gsi::Converter<Qt::LayoutDirection>::target_type)qt_gsi::CppToQtAdaptor<Qt::LayoutDirection>(((QGraphicsWidget *)cls)->layoutDirection ()));
}

static qt_gsi::GenericMethod *_create_f_layoutDirection_c0 ()
{
  return new qt_gsi::GenericMethod (":layoutDirection", "@brief Method Qt::LayoutDirection QGraphicsWidget::layoutDirection()\n", true, &_init_f_layoutDirection_c0, &_call_f_layoutDirection_c0);
}

// void QGraphicsWidget::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)


static void _init_f_paint_6301 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_paint_6301 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QStyleOptionGraphicsItem *arg2 = args.read<const QStyleOptionGraphicsItem * > ();
  QWidget *arg3 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ((QGraphicsWidget *)cls)->paint (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_paint_6301 ()
{
  return new qt_gsi::GenericMethod ("paint", "@brief Method void QGraphicsWidget::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)\nThis is a reimplementation of QGraphicsItem::paint", false, &_init_f_paint_6301, &_call_f_paint_6301);
}

// void QGraphicsWidget::paintWindowFrame(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)


static void _init_f_paintWindowFrame_6301 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_paintWindowFrame_6301 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QStyleOptionGraphicsItem *arg2 = args.read<const QStyleOptionGraphicsItem * > ();
  QWidget *arg3 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ((QGraphicsWidget *)cls)->paintWindowFrame (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_paintWindowFrame_6301 ()
{
  return new qt_gsi::GenericMethod ("paintWindowFrame", "@brief Method void QGraphicsWidget::paintWindowFrame(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)\n", false, &_init_f_paintWindowFrame_6301, &_call_f_paintWindowFrame_6301);
}

// QPalette QGraphicsWidget::palette()


static void _init_f_palette_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPalette > ();
}

static void _call_f_palette_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPalette > ((QPalette)((QGraphicsWidget *)cls)->palette ());
}

static qt_gsi::GenericMethod *_create_f_palette_c0 ()
{
  return new qt_gsi::GenericMethod (":palette", "@brief Method QPalette QGraphicsWidget::palette()\n", true, &_init_f_palette_c0, &_call_f_palette_c0);
}

// QRectF QGraphicsWidget::rect()


static void _init_f_rect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_rect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QGraphicsWidget *)cls)->rect ());
}

static qt_gsi::GenericMethod *_create_f_rect_c0 ()
{
  return new qt_gsi::GenericMethod ("rect", "@brief Method QRectF QGraphicsWidget::rect()\n", true, &_init_f_rect_c0, &_call_f_rect_c0);
}

// void QGraphicsWidget::releaseShortcut(int id)


static void _init_f_releaseShortcut_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_releaseShortcut_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QGraphicsWidget *)cls)->releaseShortcut (arg1);
}

static qt_gsi::GenericMethod *_create_f_releaseShortcut_767 ()
{
  return new qt_gsi::GenericMethod ("releaseShortcut", "@brief Method void QGraphicsWidget::releaseShortcut(int id)\n", false, &_init_f_releaseShortcut_767, &_call_f_releaseShortcut_767);
}

// void QGraphicsWidget::removeAction(QAction *action)


static void _init_f_removeAction_1309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("action");
  decl->add_arg<QAction * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeAction_1309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAction *arg1 = args.read<QAction * > ();
  ((QGraphicsWidget *)cls)->removeAction (arg1);
}

static qt_gsi::GenericMethod *_create_f_removeAction_1309 ()
{
  return new qt_gsi::GenericMethod ("removeAction", "@brief Method void QGraphicsWidget::removeAction(QAction *action)\n", false, &_init_f_removeAction_1309, &_call_f_removeAction_1309);
}

// void QGraphicsWidget::resize(const QSizeF &size)


static void _init_f_resize_1875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_resize_1875 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSizeF &arg1 = args.read<const QSizeF & > ();
  ((QGraphicsWidget *)cls)->resize (arg1);
}

static qt_gsi::GenericMethod *_create_f_resize_1875 ()
{
  return new qt_gsi::GenericMethod ("resize", "@brief Method void QGraphicsWidget::resize(const QSizeF &size)\n", false, &_init_f_resize_1875, &_call_f_resize_1875);
}

// void QGraphicsWidget::resize(double w, double h)


static void _init_f_resize_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("h");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_resize_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QGraphicsWidget *)cls)->resize (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_resize_2034 ()
{
  return new qt_gsi::GenericMethod ("resize", "@brief Method void QGraphicsWidget::resize(double w, double h)\n", false, &_init_f_resize_2034, &_call_f_resize_2034);
}

// void QGraphicsWidget::setAttribute(Qt::WidgetAttribute attribute, bool on)


static void _init_f_setAttribute_3065 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("attribute");
  decl->add_arg<const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setAttribute_3065 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QGraphicsWidget *)cls)->setAttribute (qt_gsi::QtToCppAdaptor<Qt::WidgetAttribute>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setAttribute_3065 ()
{
  return new qt_gsi::GenericMethod ("setAttribute", "@brief Method void QGraphicsWidget::setAttribute(Qt::WidgetAttribute attribute, bool on)\n", false, &_init_f_setAttribute_3065, &_call_f_setAttribute_3065);
}

// void QGraphicsWidget::setContentsMargins(double left, double top, double right, double bottom)


static void _init_f_setContentsMargins_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setContentsMargins_3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ((QGraphicsWidget *)cls)->setContentsMargins (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_setContentsMargins_3960 ()
{
  return new qt_gsi::GenericMethod ("setContentsMargins", "@brief Method void QGraphicsWidget::setContentsMargins(double left, double top, double right, double bottom)\n", false, &_init_f_setContentsMargins_3960, &_call_f_setContentsMargins_3960);
}

// void QGraphicsWidget::setFocusPolicy(Qt::FocusPolicy policy)


static void _init_f_setFocusPolicy_1885 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<Qt::FocusPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFocusPolicy_1885 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::FocusPolicy>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::FocusPolicy>::target_type & > ();
  ((QGraphicsWidget *)cls)->setFocusPolicy (qt_gsi::QtToCppAdaptor<Qt::FocusPolicy>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setFocusPolicy_1885 ()
{
  return new qt_gsi::GenericMethod ("setFocusPolicy|focusPolicy=", "@brief Method void QGraphicsWidget::setFocusPolicy(Qt::FocusPolicy policy)\n", false, &_init_f_setFocusPolicy_1885, &_call_f_setFocusPolicy_1885);
}

// void QGraphicsWidget::setFont(const QFont &font)


static void _init_f_setFont_1801 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("font");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFont_1801 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QGraphicsWidget *)cls)->setFont (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFont_1801 ()
{
  return new qt_gsi::GenericMethod ("setFont|font=", "@brief Method void QGraphicsWidget::setFont(const QFont &font)\n", false, &_init_f_setFont_1801, &_call_f_setFont_1801);
}

// void QGraphicsWidget::setGeometry(const QRectF &rect)


static void _init_f_setGeometry_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ((QGraphicsWidget *)cls)->setGeometry (arg1);
}

static qt_gsi::GenericMethod *_create_f_setGeometry_1862 ()
{
  return new qt_gsi::GenericMethod ("setGeometry|geometry=", "@brief Method void QGraphicsWidget::setGeometry(const QRectF &rect)\nThis is a reimplementation of QGraphicsLayoutItem::setGeometry", false, &_init_f_setGeometry_1862, &_call_f_setGeometry_1862);
}

// void QGraphicsWidget::setGeometry(double x, double y, double w, double h)


static void _init_f_setGeometry_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ((QGraphicsWidget *)cls)->setGeometry (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_setGeometry_3960 ()
{
  return new qt_gsi::GenericMethod ("setGeometry", "@brief Method void QGraphicsWidget::setGeometry(double x, double y, double w, double h)\n", false, &_init_f_setGeometry_3960, &_call_f_setGeometry_3960);
}

// void QGraphicsWidget::setLayout(QGraphicsLayout *layout)


static void _init_f_setLayout_2158 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("layout");
  decl->add_arg<QGraphicsLayout * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLayout_2158 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsLayout *arg1 = args.read<QGraphicsLayout * > ();
  ((QGraphicsWidget *)cls)->setLayout (arg1);
}

static qt_gsi::GenericMethod *_create_f_setLayout_2158 ()
{
  return new qt_gsi::GenericMethod ("setLayout|layout=", "@brief Method void QGraphicsWidget::setLayout(QGraphicsLayout *layout)\n", false, &_init_f_setLayout_2158, &_call_f_setLayout_2158);
}

// void QGraphicsWidget::setLayoutDirection(Qt::LayoutDirection direction)


static void _init_f_setLayoutDirection_2316 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLayoutDirection_2316 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > ();
  ((QGraphicsWidget *)cls)->setLayoutDirection (qt_gsi::QtToCppAdaptor<Qt::LayoutDirection>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setLayoutDirection_2316 ()
{
  return new qt_gsi::GenericMethod ("setLayoutDirection|layoutDirection=", "@brief Method void QGraphicsWidget::setLayoutDirection(Qt::LayoutDirection direction)\n", false, &_init_f_setLayoutDirection_2316, &_call_f_setLayoutDirection_2316);
}

// void QGraphicsWidget::setPalette(const QPalette &palette)


static void _init_f_setPalette_2113 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("palette");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPalette_2113 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QGraphicsWidget *)cls)->setPalette (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPalette_2113 ()
{
  return new qt_gsi::GenericMethod ("setPalette|palette=", "@brief Method void QGraphicsWidget::setPalette(const QPalette &palette)\n", false, &_init_f_setPalette_2113, &_call_f_setPalette_2113);
}

// void QGraphicsWidget::setShortcutAutoRepeat(int id, bool enabled)


static void _init_f_setShortcutAutoRepeat_1523 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("enabled", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setShortcutAutoRepeat_1523 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QGraphicsWidget *)cls)->setShortcutAutoRepeat (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setShortcutAutoRepeat_1523 ()
{
  return new qt_gsi::GenericMethod ("setShortcutAutoRepeat", "@brief Method void QGraphicsWidget::setShortcutAutoRepeat(int id, bool enabled)\n", false, &_init_f_setShortcutAutoRepeat_1523, &_call_f_setShortcutAutoRepeat_1523);
}

// void QGraphicsWidget::setShortcutEnabled(int id, bool enabled)


static void _init_f_setShortcutEnabled_1523 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("enabled", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setShortcutEnabled_1523 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QGraphicsWidget *)cls)->setShortcutEnabled (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setShortcutEnabled_1523 ()
{
  return new qt_gsi::GenericMethod ("setShortcutEnabled", "@brief Method void QGraphicsWidget::setShortcutEnabled(int id, bool enabled)\n", false, &_init_f_setShortcutEnabled_1523, &_call_f_setShortcutEnabled_1523);
}

// void QGraphicsWidget::setStyle(QStyle *style)


static void _init_f_setStyle_1232 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("style");
  decl->add_arg<QStyle * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStyle_1232 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle *arg1 = args.read<QStyle * > ();
  ((QGraphicsWidget *)cls)->setStyle (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStyle_1232 ()
{
  return new qt_gsi::GenericMethod ("setStyle|style=", "@brief Method void QGraphicsWidget::setStyle(QStyle *style)\n", false, &_init_f_setStyle_1232, &_call_f_setStyle_1232);
}

// void QGraphicsWidget::setWindowFlags(QFlags<Qt::WindowType> wFlags)


static void _init_f_setWindowFlags_2495 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("wFlags");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowFlags_2495 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > ();
  ((QGraphicsWidget *)cls)->setWindowFlags (qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setWindowFlags_2495 ()
{
  return new qt_gsi::GenericMethod ("setWindowFlags|windowFlags=", "@brief Method void QGraphicsWidget::setWindowFlags(QFlags<Qt::WindowType> wFlags)\n", false, &_init_f_setWindowFlags_2495, &_call_f_setWindowFlags_2495);
}

// void QGraphicsWidget::setWindowFrameMargins(double left, double top, double right, double bottom)


static void _init_f_setWindowFrameMargins_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setWindowFrameMargins_3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ((QGraphicsWidget *)cls)->setWindowFrameMargins (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_setWindowFrameMargins_3960 ()
{
  return new qt_gsi::GenericMethod ("setWindowFrameMargins", "@brief Method void QGraphicsWidget::setWindowFrameMargins(double left, double top, double right, double bottom)\n", false, &_init_f_setWindowFrameMargins_3960, &_call_f_setWindowFrameMargins_3960);
}

// void QGraphicsWidget::setWindowTitle(const QString &title)


static void _init_f_setWindowTitle_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowTitle_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QGraphicsWidget *)cls)->setWindowTitle (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWindowTitle_2025 ()
{
  return new qt_gsi::GenericMethod ("setWindowTitle|windowTitle=", "@brief Method void QGraphicsWidget::setWindowTitle(const QString &title)\n", false, &_init_f_setWindowTitle_2025, &_call_f_setWindowTitle_2025);
}

// QPainterPath QGraphicsWidget::shape()


static void _init_f_shape_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_f_shape_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsWidget *)cls)->shape ());
}

static qt_gsi::GenericMethod *_create_f_shape_c0 ()
{
  return new qt_gsi::GenericMethod ("shape", "@brief Method QPainterPath QGraphicsWidget::shape()\nThis is a reimplementation of QGraphicsItem::shape", true, &_init_f_shape_c0, &_call_f_shape_c0);
}

// QSizeF QGraphicsWidget::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSizeF > ((QSizeF)((QGraphicsWidget *)cls)->size ());
}

static qt_gsi::GenericMethod *_create_f_size_c0 ()
{
  return new qt_gsi::GenericMethod (":size", "@brief Method QSizeF QGraphicsWidget::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
}

// QStyle *QGraphicsWidget::style()


static void _init_f_style_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QStyle * > ();
}

static void _call_f_style_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QStyle * > ((QStyle *)((QGraphicsWidget *)cls)->style ());
}

static qt_gsi::GenericMethod *_create_f_style_c0 ()
{
  return new qt_gsi::GenericMethod (":style", "@brief Method QStyle *QGraphicsWidget::style()\n", true, &_init_f_style_c0, &_call_f_style_c0);
}

// bool QGraphicsWidget::testAttribute(Qt::WidgetAttribute attribute)


static void _init_f_testAttribute_c2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("attribute");
  decl->add_arg<const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testAttribute_c2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::WidgetAttribute>::target_type & > ();
  ret.write<bool > ((bool)((QGraphicsWidget *)cls)->testAttribute (qt_gsi::QtToCppAdaptor<Qt::WidgetAttribute>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_testAttribute_c2309 ()
{
  return new qt_gsi::GenericMethod ("testAttribute", "@brief Method bool QGraphicsWidget::testAttribute(Qt::WidgetAttribute attribute)\n", true, &_init_f_testAttribute_c2309, &_call_f_testAttribute_c2309);
}

// int QGraphicsWidget::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QGraphicsWidget *)cls)->type ());
}

static qt_gsi::GenericMethod *_create_f_type_c0 ()
{
  return new qt_gsi::GenericMethod ("type", "@brief Method int QGraphicsWidget::type()\nThis is a reimplementation of QGraphicsItem::type", true, &_init_f_type_c0, &_call_f_type_c0);
}

// void QGraphicsWidget::unsetLayoutDirection()


static void _init_f_unsetLayoutDirection_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_unsetLayoutDirection_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsWidget *)cls)->unsetLayoutDirection ();
}

static qt_gsi::GenericMethod *_create_f_unsetLayoutDirection_0 ()
{
  return new qt_gsi::GenericMethod ("unsetLayoutDirection", "@brief Method void QGraphicsWidget::unsetLayoutDirection()\n", false, &_init_f_unsetLayoutDirection_0, &_call_f_unsetLayoutDirection_0);
}

// void QGraphicsWidget::unsetWindowFrameMargins()


static void _init_f_unsetWindowFrameMargins_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_unsetWindowFrameMargins_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsWidget *)cls)->unsetWindowFrameMargins ();
}

static qt_gsi::GenericMethod *_create_f_unsetWindowFrameMargins_0 ()
{
  return new qt_gsi::GenericMethod ("unsetWindowFrameMargins", "@brief Method void QGraphicsWidget::unsetWindowFrameMargins()\n", false, &_init_f_unsetWindowFrameMargins_0, &_call_f_unsetWindowFrameMargins_0);
}

// QFlags<Qt::WindowType> QGraphicsWidget::windowFlags()


static void _init_f_windowFlags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type > ();
}

static void _call_f_windowFlags_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type > ((qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::WindowType> >(((QGraphicsWidget *)cls)->windowFlags ()));
}

static qt_gsi::GenericMethod *_create_f_windowFlags_c0 ()
{
  return new qt_gsi::GenericMethod (":windowFlags", "@brief Method QFlags<Qt::WindowType> QGraphicsWidget::windowFlags()\n", true, &_init_f_windowFlags_c0, &_call_f_windowFlags_c0);
}

// QRectF QGraphicsWidget::windowFrameGeometry()


static void _init_f_windowFrameGeometry_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_windowFrameGeometry_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QGraphicsWidget *)cls)->windowFrameGeometry ());
}

static qt_gsi::GenericMethod *_create_f_windowFrameGeometry_c0 ()
{
  return new qt_gsi::GenericMethod ("windowFrameGeometry", "@brief Method QRectF QGraphicsWidget::windowFrameGeometry()\n", true, &_init_f_windowFrameGeometry_c0, &_call_f_windowFrameGeometry_c0);
}

// QRectF QGraphicsWidget::windowFrameRect()


static void _init_f_windowFrameRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_windowFrameRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QGraphicsWidget *)cls)->windowFrameRect ());
}

static qt_gsi::GenericMethod *_create_f_windowFrameRect_c0 ()
{
  return new qt_gsi::GenericMethod ("windowFrameRect", "@brief Method QRectF QGraphicsWidget::windowFrameRect()\n", true, &_init_f_windowFrameRect_c0, &_call_f_windowFrameRect_c0);
}

// QString QGraphicsWidget::windowTitle()


static void _init_f_windowTitle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_windowTitle_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QGraphicsWidget *)cls)->windowTitle ());
}

static qt_gsi::GenericMethod *_create_f_windowTitle_c0 ()
{
  return new qt_gsi::GenericMethod (":windowTitle", "@brief Method QString QGraphicsWidget::windowTitle()\n", true, &_init_f_windowTitle_c0, &_call_f_windowTitle_c0);
}

// Qt::WindowType QGraphicsWidget::windowType()


static void _init_f_windowType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::WindowType>::target_type > ();
}

static void _call_f_windowType_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::WindowType>::target_type > ((qt_gsi::Converter<Qt::WindowType>::target_type)qt_gsi::CppToQtAdaptor<Qt::WindowType>(((QGraphicsWidget *)cls)->windowType ()));
}

static qt_gsi::GenericMethod *_create_f_windowType_c0 ()
{
  return new qt_gsi::GenericMethod ("windowType", "@brief Method Qt::WindowType QGraphicsWidget::windowType()\n", true, &_init_f_windowType_c0, &_call_f_windowType_c0);
}

// static void QGraphicsWidget::setTabOrder(QGraphicsWidget *first, QGraphicsWidget *second)


static void _init_f_setTabOrder_4156 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("first");
  decl->add_arg<QGraphicsWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("second");
  decl->add_arg<QGraphicsWidget * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setTabOrder_4156 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsWidget *arg1 = args.read<QGraphicsWidget * > ();
  QGraphicsWidget *arg2 = args.read<QGraphicsWidget * > ();
  QGraphicsWidget::setTabOrder (arg1, arg2);
}

static qt_gsi::GenericStaticMethod *_create_f_setTabOrder_4156 ()
{
  return new qt_gsi::GenericStaticMethod ("setTabOrder", "@brief Static method void QGraphicsWidget::setTabOrder(QGraphicsWidget *first, QGraphicsWidget *second)\nThis method is static and can be called without an instance.", &_init_f_setTabOrder_4156, &_call_f_setTabOrder_4156);
}

// static QString QGraphicsWidget::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsWidget::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsWidget::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QGraphicsWidget::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QGraphicsWidget::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsWidget::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QGraphicsWidget::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsWidget::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsWidget::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QGraphicsWidget::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QGraphicsWidget::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsWidget::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QGraphicsWidget, QGraphicsWidget_EventAdaptor> ea_QGraphicsWidget;

//  base class cast for QGraphicsObject

static void _init_f_QGraphicsWidget_as_QGraphicsObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsObject *> ();
}

static void _call_f_QGraphicsWidget_as_QGraphicsObject (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsObject *> ((QGraphicsObject *)(QGraphicsWidget *)cls);
}

static qt_gsi::GenericMethod *_create_f_QGraphicsWidget_as_QGraphicsObject ()
{
  return new qt_gsi::GenericMethod ("asQGraphicsObject", "@brief Delivers the base class interface QGraphicsObject of QGraphicsWidget\nClass QGraphicsWidget is derived from multiple base classes. This method delivers the QGraphicsObject base class aspect.", false, &_init_f_QGraphicsWidget_as_QGraphicsObject, &_call_f_QGraphicsWidget_as_QGraphicsObject);
}

static void _init_f_QGraphicsWidget_as_const_QGraphicsObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QGraphicsObject *> ();
}

static void _call_f_QGraphicsWidget_as_const_QGraphicsObject (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QGraphicsObject *> ((const QGraphicsObject *)(const QGraphicsWidget *)cls);
}

static qt_gsi::GenericMethod *_create_f_QGraphicsWidget_as_const_QGraphicsObject ()
{
  return new qt_gsi::GenericMethod ("asConstQGraphicsObject", "@brief Delivers the base class interface QGraphicsObject of QGraphicsWidget\nClass QGraphicsWidget is derived from multiple base classes. This method delivers the QGraphicsObject base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QGraphicsWidget_as_const_QGraphicsObject, &_call_f_QGraphicsWidget_as_const_QGraphicsObject);
}

//  base class cast for QGraphicsLayoutItem

static void _init_f_QGraphicsWidget_as_QGraphicsLayoutItem (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsLayoutItem *> ();
}

static void _call_f_QGraphicsWidget_as_QGraphicsLayoutItem (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsLayoutItem *> ((QGraphicsLayoutItem *)(QGraphicsWidget *)cls);
}

static qt_gsi::GenericMethod *_create_f_QGraphicsWidget_as_QGraphicsLayoutItem ()
{
  return new qt_gsi::GenericMethod ("asQGraphicsLayoutItem", "@brief Delivers the base class interface QGraphicsLayoutItem of QGraphicsWidget\nClass QGraphicsWidget is derived from multiple base classes. This method delivers the QGraphicsLayoutItem base class aspect.", false, &_init_f_QGraphicsWidget_as_QGraphicsLayoutItem, &_call_f_QGraphicsWidget_as_QGraphicsLayoutItem);
}

static void _init_f_QGraphicsWidget_as_const_QGraphicsLayoutItem (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QGraphicsLayoutItem *> ();
}

static void _call_f_QGraphicsWidget_as_const_QGraphicsLayoutItem (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QGraphicsLayoutItem *> ((const QGraphicsLayoutItem *)(const QGraphicsWidget *)cls);
}

static qt_gsi::GenericMethod *_create_f_QGraphicsWidget_as_const_QGraphicsLayoutItem ()
{
  return new qt_gsi::GenericMethod ("asConstQGraphicsLayoutItem", "@brief Delivers the base class interface QGraphicsLayoutItem of QGraphicsWidget\nClass QGraphicsWidget is derived from multiple base classes. This method delivers the QGraphicsLayoutItem base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QGraphicsWidget_as_const_QGraphicsLayoutItem, &_call_f_QGraphicsWidget_as_const_QGraphicsLayoutItem);
}


namespace gsi
{
extern gsi::Class<QGraphicsObject> decl_QGraphicsObject;

gsi::Class<QGraphicsWidget> decl_QGraphicsWidget (ea_QGraphicsWidget, decl_QGraphicsObject, "QGraphicsWidget_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_actions_c0 ()) +
  gsi::Methods(_create_f_addAction_1309 ()) +
  gsi::Methods(_create_f_addActions_1924 ()) +
  gsi::Methods(_create_f_adjustSize_0 ()) +
  gsi::Methods(_create_f_boundingRect_c0 ()) +
  gsi::Methods(_create_f_children_c0 ()) +
  gsi::Methods(_create_f_close_0 ()) +
  gsi::Methods(_create_f_focusPolicy_c0 ()) +
  gsi::Methods(_create_f_focusWidget_c0 ()) +
  gsi::Methods(_create_f_font_c0 ()) +
  gsi::Methods(_create_f_getContentsMargins_c4704 ()) +
  gsi::Methods(_create_f_getWindowFrameMargins_c4704 ()) +
  gsi::Methods(_create_f_grabShortcut_4758 ()) +
  gsi::Methods(_create_f_insertAction_2510 ()) +
  gsi::Methods(_create_f_insertActions_3125 ()) +
  gsi::Methods(_create_f_isActiveWindow_c0 ()) +
  gsi::Methods(_create_f_layout_c0 ()) +
  gsi::Methods(_create_f_layoutDirection_c0 ()) +
  gsi::Methods(_create_f_paint_6301 ()) +
  gsi::Methods(_create_f_paintWindowFrame_6301 ()) +
  gsi::Methods(_create_f_palette_c0 ()) +
  gsi::Methods(_create_f_rect_c0 ()) +
  gsi::Methods(_create_f_releaseShortcut_767 ()) +
  gsi::Methods(_create_f_removeAction_1309 ()) +
  gsi::Methods(_create_f_resize_1875 ()) +
  gsi::Methods(_create_f_resize_2034 ()) +
  gsi::Methods(_create_f_setAttribute_3065 ()) +
  gsi::Methods(_create_f_setContentsMargins_3960 ()) +
  gsi::Methods(_create_f_setFocusPolicy_1885 ()) +
  gsi::Methods(_create_f_setFont_1801 ()) +
  gsi::Methods(_create_f_setGeometry_1862 ()) +
  gsi::Methods(_create_f_setGeometry_3960 ()) +
  gsi::Methods(_create_f_setLayout_2158 ()) +
  gsi::Methods(_create_f_setLayoutDirection_2316 ()) +
  gsi::Methods(_create_f_setPalette_2113 ()) +
  gsi::Methods(_create_f_setShortcutAutoRepeat_1523 ()) +
  gsi::Methods(_create_f_setShortcutEnabled_1523 ()) +
  gsi::Methods(_create_f_setStyle_1232 ()) +
  gsi::Methods(_create_f_setWindowFlags_2495 ()) +
  gsi::Methods(_create_f_setWindowFrameMargins_3960 ()) +
  gsi::Methods(_create_f_setWindowTitle_2025 ()) +
  gsi::Methods(_create_f_shape_c0 ()) +
  gsi::Methods(_create_f_size_c0 ()) +
  gsi::Methods(_create_f_style_c0 ()) +
  gsi::Methods(_create_f_testAttribute_c2309 ()) +
  gsi::Methods(_create_f_type_c0 ()) +
  gsi::Methods(_create_f_unsetLayoutDirection_0 ()) +
  gsi::Methods(_create_f_unsetWindowFrameMargins_0 ()) +
  gsi::Methods(_create_f_windowFlags_c0 ()) +
  gsi::Methods(_create_f_windowFrameGeometry_c0 ()) +
  gsi::Methods(_create_f_windowFrameRect_c0 ()) +
  gsi::Methods(_create_f_windowTitle_c0 ()) +
  gsi::Methods(_create_f_windowType_c0 ()) +
  qt_gsi::qt_signal<QGraphicsWidget, QGraphicsWidget_EventAdaptor, QObject *> ("destroyed", &QGraphicsWidget_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QGraphicsWidget::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsWidget, QGraphicsWidget_EventAdaptor> ("enabledChanged", &QGraphicsWidget_EventAdaptor::enabledChanged_e_0, "@brief Signal declaration for QGraphicsWidget::enabledChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsWidget, QGraphicsWidget_EventAdaptor> ("opacityChanged", &QGraphicsWidget_EventAdaptor::opacityChanged_e_0, "@brief Signal declaration for QGraphicsWidget::opacityChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsWidget, QGraphicsWidget_EventAdaptor> ("parentChanged", &QGraphicsWidget_EventAdaptor::parentChanged_e_0, "@brief Signal declaration for QGraphicsWidget::parentChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsWidget, QGraphicsWidget_EventAdaptor> ("rotationChanged", &QGraphicsWidget_EventAdaptor::rotationChanged_e_0, "@brief Signal declaration for QGraphicsWidget::rotationChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsWidget, QGraphicsWidget_EventAdaptor> ("scaleChanged", &QGraphicsWidget_EventAdaptor::scaleChanged_e_0, "@brief Signal declaration for QGraphicsWidget::scaleChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsWidget, QGraphicsWidget_EventAdaptor> ("visibleChanged", &QGraphicsWidget_EventAdaptor::visibleChanged_e_0, "@brief Signal declaration for QGraphicsWidget::visibleChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsWidget, QGraphicsWidget_EventAdaptor> ("xChanged", &QGraphicsWidget_EventAdaptor::xChanged_e_0, "@brief Signal declaration for QGraphicsWidget::xChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsWidget, QGraphicsWidget_EventAdaptor> ("yChanged", &QGraphicsWidget_EventAdaptor::yChanged_e_0, "@brief Signal declaration for QGraphicsWidget::yChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsWidget, QGraphicsWidget_EventAdaptor> ("zChanged", &QGraphicsWidget_EventAdaptor::zChanged_e_0, "@brief Signal declaration for QGraphicsWidget::zChanged()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_setTabOrder_4156 ()) +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()) +
  gsi::Methods(_create_f_QGraphicsWidget_as_QGraphicsObject ()) +
  gsi::Methods(_create_f_QGraphicsWidget_as_const_QGraphicsObject ()) +
  gsi::Methods(_create_f_QGraphicsWidget_as_QGraphicsLayoutItem ()) +
  gsi::Methods(_create_f_QGraphicsWidget_as_const_QGraphicsLayoutItem ()),
  "@hide\n@alias QGraphicsWidget");
}


class QGraphicsWidget_Adaptor : public QGraphicsWidget, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsWidget_Adaptor();

  //  [adaptor ctor] QGraphicsWidget::QGraphicsWidget(QGraphicsItem *parent, QFlags<Qt::WindowType> wFlags)
  QGraphicsWidget_Adaptor() : QGraphicsWidget()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsWidget::QGraphicsWidget(QGraphicsItem *parent, QFlags<Qt::WindowType> wFlags)
  QGraphicsWidget_Adaptor(QGraphicsItem *parent) : QGraphicsWidget(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsWidget::QGraphicsWidget(QGraphicsItem *parent, QFlags<Qt::WindowType> wFlags)
  QGraphicsWidget_Adaptor(QGraphicsItem *parent, QFlags<Qt::WindowType> wFlags) : QGraphicsWidget(parent, wFlags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QGraphicsWidget::addToIndex()
  void fp_QGraphicsWidget_addToIndex_0 () {
    QGraphicsWidget::addToIndex();
  }

  //  void QGraphicsWidget::prepareGeometryChange()
  void fp_QGraphicsWidget_prepareGeometryChange_0 () {
    QGraphicsWidget::prepareGeometryChange();
  }

  //  int QGraphicsWidget::receivers(const char *signal)
  int fp_QGraphicsWidget_receivers_c1731 (const char *signal) const {
    return QGraphicsWidget::receivers(signal);
  }

  //  void QGraphicsWidget::removeFromIndex()
  void fp_QGraphicsWidget_removeFromIndex_0 () {
    QGraphicsWidget::removeFromIndex();
  }

  //  QObject *QGraphicsWidget::sender()
  QObject * fp_QGraphicsWidget_sender_c0 () const {
    return QGraphicsWidget::sender();
  }

  //  void QGraphicsWidget::setGraphicsItem(QGraphicsItem *item)
  void fp_QGraphicsWidget_setGraphicsItem_1919 (QGraphicsItem *item) {
    QGraphicsWidget::setGraphicsItem(item);
  }

  //  void QGraphicsWidget::setOwnedByLayout(bool ownedByLayout)
  void fp_QGraphicsWidget_setOwnedByLayout_864 (bool ownedByLayout) {
    QGraphicsWidget::setOwnedByLayout(ownedByLayout);
  }

  //  [adaptor impl] void QGraphicsWidget::advance(int phase)
  void cbs_advance_767_0(int phase)
  {
    QGraphicsWidget::advance(phase);
  }

  virtual void advance(int phase)
  {
    if (cb_advance_767_0.can_issue()) {
      cb_advance_767_0.issue<QGraphicsWidget_Adaptor, int>(&QGraphicsWidget_Adaptor::cbs_advance_767_0, phase);
    } else {
      QGraphicsWidget::advance(phase);
    }
  }

  //  [adaptor impl] QRectF QGraphicsWidget::boundingRect()
  QRectF cbs_boundingRect_c0_0() const
  {
    return QGraphicsWidget::boundingRect();
  }

  virtual QRectF boundingRect() const
  {
    if (cb_boundingRect_c0_0.can_issue()) {
      return cb_boundingRect_c0_0.issue<QGraphicsWidget_Adaptor, QRectF>(&QGraphicsWidget_Adaptor::cbs_boundingRect_c0_0);
    } else {
      return QGraphicsWidget::boundingRect();
    }
  }

  //  [adaptor impl] bool QGraphicsWidget::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)
  bool cbs_collidesWithItem_c4977_1(const QGraphicsItem *other, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & mode) const
  {
    return QGraphicsWidget::collidesWithItem(other, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(mode).cref());
  }

  virtual bool collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode) const
  {
    if (cb_collidesWithItem_c4977_1.can_issue()) {
      return cb_collidesWithItem_c4977_1.issue<QGraphicsWidget_Adaptor, bool, const QGraphicsItem *, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &>(&QGraphicsWidget_Adaptor::cbs_collidesWithItem_c4977_1, other, qt_gsi::CppToQtAdaptor<Qt::ItemSelectionMode>(mode));
    } else {
      return QGraphicsWidget::collidesWithItem(other, mode);
    }
  }

  //  [adaptor impl] bool QGraphicsWidget::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)
  bool cbs_collidesWithPath_c4877_1(const QPainterPath &path, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & mode) const
  {
    return QGraphicsWidget::collidesWithPath(path, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(mode).cref());
  }

  virtual bool collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode) const
  {
    if (cb_collidesWithPath_c4877_1.can_issue()) {
      return cb_collidesWithPath_c4877_1.issue<QGraphicsWidget_Adaptor, bool, const QPainterPath &, const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &>(&QGraphicsWidget_Adaptor::cbs_collidesWithPath_c4877_1, path, qt_gsi::CppToQtAdaptor<Qt::ItemSelectionMode>(mode));
    } else {
      return QGraphicsWidget::collidesWithPath(path, mode);
    }
  }

  //  [adaptor impl] bool QGraphicsWidget::contains(const QPointF &point)
  bool cbs_contains_c1986_0(const QPointF &point) const
  {
    return QGraphicsWidget::contains(point);
  }

  virtual bool contains(const QPointF &point) const
  {
    if (cb_contains_c1986_0.can_issue()) {
      return cb_contains_c1986_0.issue<QGraphicsWidget_Adaptor, bool, const QPointF &>(&QGraphicsWidget_Adaptor::cbs_contains_c1986_0, point);
    } else {
      return QGraphicsWidget::contains(point);
    }
  }

  //  [adaptor impl] bool QGraphicsWidget::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QGraphicsWidget::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGraphicsWidget_Adaptor, bool, QObject *, QEvent *>(&QGraphicsWidget_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QGraphicsWidget::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::getContentsMargins(double *left, double *top, double *right, double *bottom)
  void cbs_getContentsMargins_c4704_0(double *left, double *top, double *right, double *bottom) const
  {
    QGraphicsWidget::getContentsMargins(left, top, right, bottom);
  }

  virtual void getContentsMargins(double *left, double *top, double *right, double *bottom) const
  {
    if (cb_getContentsMargins_c4704_0.can_issue()) {
      cb_getContentsMargins_c4704_0.issue<QGraphicsWidget_Adaptor, double *, double *, double *, double *>(&QGraphicsWidget_Adaptor::cbs_getContentsMargins_c4704_0, left, top, right, bottom);
    } else {
      QGraphicsWidget::getContentsMargins(left, top, right, bottom);
    }
  }

  //  [adaptor impl] bool QGraphicsWidget::isObscuredBy(const QGraphicsItem *item)
  bool cbs_isObscuredBy_c2614_0(const QGraphicsItem *item) const
  {
    return QGraphicsWidget::isObscuredBy(item);
  }

  virtual bool isObscuredBy(const QGraphicsItem *item) const
  {
    if (cb_isObscuredBy_c2614_0.can_issue()) {
      return cb_isObscuredBy_c2614_0.issue<QGraphicsWidget_Adaptor, bool, const QGraphicsItem *>(&QGraphicsWidget_Adaptor::cbs_isObscuredBy_c2614_0, item);
    } else {
      return QGraphicsWidget::isObscuredBy(item);
    }
  }

  //  [adaptor impl] QPainterPath QGraphicsWidget::opaqueArea()
  QPainterPath cbs_opaqueArea_c0_0() const
  {
    return QGraphicsWidget::opaqueArea();
  }

  virtual QPainterPath opaqueArea() const
  {
    if (cb_opaqueArea_c0_0.can_issue()) {
      return cb_opaqueArea_c0_0.issue<QGraphicsWidget_Adaptor, QPainterPath>(&QGraphicsWidget_Adaptor::cbs_opaqueArea_c0_0);
    } else {
      return QGraphicsWidget::opaqueArea();
    }
  }

  //  [adaptor impl] void QGraphicsWidget::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  void cbs_paint_6301_1(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    QGraphicsWidget::paint(painter, option, widget);
  }

  virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    if (cb_paint_6301_1.can_issue()) {
      cb_paint_6301_1.issue<QGraphicsWidget_Adaptor, QPainter *, const QStyleOptionGraphicsItem *, QWidget *>(&QGraphicsWidget_Adaptor::cbs_paint_6301_1, painter, option, widget);
    } else {
      QGraphicsWidget::paint(painter, option, widget);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::paintWindowFrame(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  void cbs_paintWindowFrame_6301_1(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    QGraphicsWidget::paintWindowFrame(painter, option, widget);
  }

  virtual void paintWindowFrame(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)
  {
    if (cb_paintWindowFrame_6301_1.can_issue()) {
      cb_paintWindowFrame_6301_1.issue<QGraphicsWidget_Adaptor, QPainter *, const QStyleOptionGraphicsItem *, QWidget *>(&QGraphicsWidget_Adaptor::cbs_paintWindowFrame_6301_1, painter, option, widget);
    } else {
      QGraphicsWidget::paintWindowFrame(painter, option, widget);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::setGeometry(const QRectF &rect)
  void cbs_setGeometry_1862_0(const QRectF &rect)
  {
    QGraphicsWidget::setGeometry(rect);
  }

  virtual void setGeometry(const QRectF &rect)
  {
    if (cb_setGeometry_1862_0.can_issue()) {
      cb_setGeometry_1862_0.issue<QGraphicsWidget_Adaptor, const QRectF &>(&QGraphicsWidget_Adaptor::cbs_setGeometry_1862_0, rect);
    } else {
      QGraphicsWidget::setGeometry(rect);
    }
  }

  //  [adaptor impl] QPainterPath QGraphicsWidget::shape()
  QPainterPath cbs_shape_c0_0() const
  {
    return QGraphicsWidget::shape();
  }

  virtual QPainterPath shape() const
  {
    if (cb_shape_c0_0.can_issue()) {
      return cb_shape_c0_0.issue<QGraphicsWidget_Adaptor, QPainterPath>(&QGraphicsWidget_Adaptor::cbs_shape_c0_0);
    } else {
      return QGraphicsWidget::shape();
    }
  }

  //  [adaptor impl] int QGraphicsWidget::type()
  int cbs_type_c0_0() const
  {
    return QGraphicsWidget::type();
  }

  virtual int type() const
  {
    if (cb_type_c0_0.can_issue()) {
      return cb_type_c0_0.issue<QGraphicsWidget_Adaptor, int>(&QGraphicsWidget_Adaptor::cbs_type_c0_0);
    } else {
      return QGraphicsWidget::type();
    }
  }

  //  [adaptor impl] void QGraphicsWidget::changeEvent(QEvent *event)
  void cbs_changeEvent_1217_0(QEvent *event)
  {
    QGraphicsWidget::changeEvent(event);
  }

  virtual void changeEvent(QEvent *event)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QGraphicsWidget_Adaptor, QEvent *>(&QGraphicsWidget_Adaptor::cbs_changeEvent_1217_0, event);
    } else {
      QGraphicsWidget::changeEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QGraphicsWidget::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGraphicsWidget_Adaptor, QChildEvent *>(&QGraphicsWidget_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QGraphicsWidget::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::closeEvent(QCloseEvent *event)
  void cbs_closeEvent_1719_0(QCloseEvent *event)
  {
    QGraphicsWidget::closeEvent(event);
  }

  virtual void closeEvent(QCloseEvent *event)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QGraphicsWidget_Adaptor, QCloseEvent *>(&QGraphicsWidget_Adaptor::cbs_closeEvent_1719_0, event);
    } else {
      QGraphicsWidget::closeEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  void cbs_contextMenuEvent_3674_0(QGraphicsSceneContextMenuEvent *event)
  {
    QGraphicsWidget::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QGraphicsSceneContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_3674_0.can_issue()) {
      cb_contextMenuEvent_3674_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneContextMenuEvent *>(&QGraphicsWidget_Adaptor::cbs_contextMenuEvent_3674_0, event);
    } else {
      QGraphicsWidget::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QGraphicsWidget::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGraphicsWidget_Adaptor, QEvent *>(&QGraphicsWidget_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QGraphicsWidget::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QGraphicsWidget::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QGraphicsWidget_Adaptor, const char *>(&QGraphicsWidget_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QGraphicsWidget::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragEnterEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsWidget::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragEnterEvent_3315_0.can_issue()) {
      cb_dragEnterEvent_3315_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsWidget_Adaptor::cbs_dragEnterEvent_3315_0, event);
    } else {
      QGraphicsWidget::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragLeaveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsWidget::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragLeaveEvent_3315_0.can_issue()) {
      cb_dragLeaveEvent_3315_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsWidget_Adaptor::cbs_dragLeaveEvent_3315_0, event);
    } else {
      QGraphicsWidget::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dragMoveEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsWidget::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dragMoveEvent_3315_0.can_issue()) {
      cb_dragMoveEvent_3315_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsWidget_Adaptor::cbs_dragMoveEvent_3315_0, event);
    } else {
      QGraphicsWidget::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::dropEvent(QGraphicsSceneDragDropEvent *event)
  void cbs_dropEvent_3315_0(QGraphicsSceneDragDropEvent *event)
  {
    QGraphicsWidget::dropEvent(event);
  }

  virtual void dropEvent(QGraphicsSceneDragDropEvent *event)
  {
    if (cb_dropEvent_3315_0.can_issue()) {
      cb_dropEvent_3315_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneDragDropEvent *>(&QGraphicsWidget_Adaptor::cbs_dropEvent_3315_0, event);
    } else {
      QGraphicsWidget::dropEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsWidget::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QGraphicsWidget::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGraphicsWidget_Adaptor, bool, QEvent *>(&QGraphicsWidget_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QGraphicsWidget::event(_event);
    }
  }

  //  [adaptor impl] QVariant QGraphicsWidget::extension(const QVariant &variant)
  QVariant cbs_extension_c2119_0(const QVariant &variant) const
  {
    return QGraphicsWidget::extension(variant);
  }

  virtual QVariant extension(const QVariant &variant) const
  {
    if (cb_extension_c2119_0.can_issue()) {
      return cb_extension_c2119_0.issue<QGraphicsWidget_Adaptor, QVariant, const QVariant &>(&QGraphicsWidget_Adaptor::cbs_extension_c2119_0, variant);
    } else {
      return QGraphicsWidget::extension(variant);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsWidget::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QGraphicsWidget_Adaptor, QFocusEvent *>(&QGraphicsWidget_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QGraphicsWidget::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsWidget::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QGraphicsWidget::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QGraphicsWidget_Adaptor, bool, bool>(&QGraphicsWidget_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QGraphicsWidget::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsWidget::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QGraphicsWidget_Adaptor, QFocusEvent *>(&QGraphicsWidget_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QGraphicsWidget::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::grabKeyboardEvent(QEvent *event)
  void cbs_grabKeyboardEvent_1217_0(QEvent *event)
  {
    QGraphicsWidget::grabKeyboardEvent(event);
  }

  virtual void grabKeyboardEvent(QEvent *event)
  {
    if (cb_grabKeyboardEvent_1217_0.can_issue()) {
      cb_grabKeyboardEvent_1217_0.issue<QGraphicsWidget_Adaptor, QEvent *>(&QGraphicsWidget_Adaptor::cbs_grabKeyboardEvent_1217_0, event);
    } else {
      QGraphicsWidget::grabKeyboardEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::grabMouseEvent(QEvent *event)
  void cbs_grabMouseEvent_1217_0(QEvent *event)
  {
    QGraphicsWidget::grabMouseEvent(event);
  }

  virtual void grabMouseEvent(QEvent *event)
  {
    if (cb_grabMouseEvent_1217_0.can_issue()) {
      cb_grabMouseEvent_1217_0.issue<QGraphicsWidget_Adaptor, QEvent *>(&QGraphicsWidget_Adaptor::cbs_grabMouseEvent_1217_0, event);
    } else {
      QGraphicsWidget::grabMouseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::hideEvent(QHideEvent *event)
  void cbs_hideEvent_1595_0(QHideEvent *event)
  {
    QGraphicsWidget::hideEvent(event);
  }

  virtual void hideEvent(QHideEvent *event)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QGraphicsWidget_Adaptor, QHideEvent *>(&QGraphicsWidget_Adaptor::cbs_hideEvent_1595_0, event);
    } else {
      QGraphicsWidget::hideEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::hoverEnterEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverEnterEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsWidget::hoverEnterEvent(event);
  }

  virtual void hoverEnterEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverEnterEvent_3044_0.can_issue()) {
      cb_hoverEnterEvent_3044_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsWidget_Adaptor::cbs_hoverEnterEvent_3044_0, event);
    } else {
      QGraphicsWidget::hoverEnterEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverLeaveEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsWidget::hoverLeaveEvent(event);
  }

  virtual void hoverLeaveEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverLeaveEvent_3044_0.can_issue()) {
      cb_hoverLeaveEvent_3044_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsWidget_Adaptor::cbs_hoverLeaveEvent_3044_0, event);
    } else {
      QGraphicsWidget::hoverLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::hoverMoveEvent(QGraphicsSceneHoverEvent *event)
  void cbs_hoverMoveEvent_3044_0(QGraphicsSceneHoverEvent *event)
  {
    QGraphicsWidget::hoverMoveEvent(event);
  }

  virtual void hoverMoveEvent(QGraphicsSceneHoverEvent *event)
  {
    if (cb_hoverMoveEvent_3044_0.can_issue()) {
      cb_hoverMoveEvent_3044_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneHoverEvent *>(&QGraphicsWidget_Adaptor::cbs_hoverMoveEvent_3044_0, event);
    } else {
      QGraphicsWidget::hoverMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::initStyleOption(QStyleOption *option)
  void cbs_initStyleOption_c1865_0(QStyleOption *option) const
  {
    QGraphicsWidget::initStyleOption(option);
  }

  virtual void initStyleOption(QStyleOption *option) const
  {
    if (cb_initStyleOption_c1865_0.can_issue()) {
      cb_initStyleOption_c1865_0.issue<QGraphicsWidget_Adaptor, QStyleOption *>(&QGraphicsWidget_Adaptor::cbs_initStyleOption_c1865_0, option);
    } else {
      QGraphicsWidget::initStyleOption(option);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QGraphicsWidget::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QGraphicsWidget_Adaptor, QInputMethodEvent *>(&QGraphicsWidget_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QGraphicsWidget::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] QVariant QGraphicsWidget::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QGraphicsWidget::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QGraphicsWidget_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QGraphicsWidget_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QGraphicsWidget::inputMethodQuery(query);
    }
  }

  //  [adaptor impl] QVariant QGraphicsWidget::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)
  QVariant cbs_itemChange_5658_0(const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & change, const QVariant &value)
  {
    return QGraphicsWidget::itemChange(qt_gsi::QtToCppAdaptor<QGraphicsItem::GraphicsItemChange>(change).cref(), value);
  }

  virtual QVariant itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)
  {
    if (cb_itemChange_5658_0.can_issue()) {
      return cb_itemChange_5658_0.issue<QGraphicsWidget_Adaptor, QVariant, const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type &, const QVariant &>(&QGraphicsWidget_Adaptor::cbs_itemChange_5658_0, qt_gsi::CppToQtAdaptor<QGraphicsItem::GraphicsItemChange>(change), value);
    } else {
      return QGraphicsWidget::itemChange(change, value);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsWidget::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QGraphicsWidget_Adaptor, QKeyEvent *>(&QGraphicsWidget_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QGraphicsWidget::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsWidget::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QGraphicsWidget_Adaptor, QKeyEvent *>(&QGraphicsWidget_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QGraphicsWidget::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseDoubleClickEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsWidget::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_3049_0.can_issue()) {
      cb_mouseDoubleClickEvent_3049_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsWidget_Adaptor::cbs_mouseDoubleClickEvent_3049_0, event);
    } else {
      QGraphicsWidget::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseMoveEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsWidget::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseMoveEvent_3049_0.can_issue()) {
      cb_mouseMoveEvent_3049_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsWidget_Adaptor::cbs_mouseMoveEvent_3049_0, event);
    } else {
      QGraphicsWidget::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::mousePressEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mousePressEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsWidget::mousePressEvent(event);
  }

  virtual void mousePressEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mousePressEvent_3049_0.can_issue()) {
      cb_mousePressEvent_3049_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsWidget_Adaptor::cbs_mousePressEvent_3049_0, event);
    } else {
      QGraphicsWidget::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  void cbs_mouseReleaseEvent_3049_0(QGraphicsSceneMouseEvent *event)
  {
    QGraphicsWidget::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_3049_0.can_issue()) {
      cb_mouseReleaseEvent_3049_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneMouseEvent *>(&QGraphicsWidget_Adaptor::cbs_mouseReleaseEvent_3049_0, event);
    } else {
      QGraphicsWidget::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::moveEvent(QGraphicsSceneMoveEvent *event)
  void cbs_moveEvent_2935_0(QGraphicsSceneMoveEvent *event)
  {
    QGraphicsWidget::moveEvent(event);
  }

  virtual void moveEvent(QGraphicsSceneMoveEvent *event)
  {
    if (cb_moveEvent_2935_0.can_issue()) {
      cb_moveEvent_2935_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneMoveEvent *>(&QGraphicsWidget_Adaptor::cbs_moveEvent_2935_0, event);
    } else {
      QGraphicsWidget::moveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::polishEvent()
  void cbs_polishEvent_0_0()
  {
    QGraphicsWidget::polishEvent();
  }

  virtual void polishEvent()
  {
    if (cb_polishEvent_0_0.can_issue()) {
      cb_polishEvent_0_0.issue<QGraphicsWidget_Adaptor>(&QGraphicsWidget_Adaptor::cbs_polishEvent_0_0);
    } else {
      QGraphicsWidget::polishEvent();
    }
  }

  //  [adaptor impl] QVariant QGraphicsWidget::propertyChange(const QString &propertyName, const QVariant &value)
  QVariant cbs_propertyChange_4036_0(const QString &propertyName, const QVariant &value)
  {
    return QGraphicsWidget::propertyChange(propertyName, value);
  }

  virtual QVariant propertyChange(const QString &propertyName, const QVariant &value)
  {
    if (cb_propertyChange_4036_0.can_issue()) {
      return cb_propertyChange_4036_0.issue<QGraphicsWidget_Adaptor, QVariant, const QString &, const QVariant &>(&QGraphicsWidget_Adaptor::cbs_propertyChange_4036_0, propertyName, value);
    } else {
      return QGraphicsWidget::propertyChange(propertyName, value);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::resizeEvent(QGraphicsSceneResizeEvent *event)
  void cbs_resizeEvent_3154_0(QGraphicsSceneResizeEvent *event)
  {
    QGraphicsWidget::resizeEvent(event);
  }

  virtual void resizeEvent(QGraphicsSceneResizeEvent *event)
  {
    if (cb_resizeEvent_3154_0.can_issue()) {
      cb_resizeEvent_3154_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneResizeEvent *>(&QGraphicsWidget_Adaptor::cbs_resizeEvent_3154_0, event);
    } else {
      QGraphicsWidget::resizeEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsWidget::sceneEvent(QEvent *event)
  bool cbs_sceneEvent_1217_0(QEvent *event)
  {
    return QGraphicsWidget::sceneEvent(event);
  }

  virtual bool sceneEvent(QEvent *event)
  {
    if (cb_sceneEvent_1217_0.can_issue()) {
      return cb_sceneEvent_1217_0.issue<QGraphicsWidget_Adaptor, bool, QEvent *>(&QGraphicsWidget_Adaptor::cbs_sceneEvent_1217_0, event);
    } else {
      return QGraphicsWidget::sceneEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsWidget::sceneEventFilter(QGraphicsItem *watched, QEvent *event)
  bool cbs_sceneEventFilter_3028_0(QGraphicsItem *watched, QEvent *event)
  {
    return QGraphicsWidget::sceneEventFilter(watched, event);
  }

  virtual bool sceneEventFilter(QGraphicsItem *watched, QEvent *event)
  {
    if (cb_sceneEventFilter_3028_0.can_issue()) {
      return cb_sceneEventFilter_3028_0.issue<QGraphicsWidget_Adaptor, bool, QGraphicsItem *, QEvent *>(&QGraphicsWidget_Adaptor::cbs_sceneEventFilter_3028_0, watched, event);
    } else {
      return QGraphicsWidget::sceneEventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)
  void cbs_setExtension_4817_0(unsigned int extension, const QVariant &variant)
  {
    QGraphicsWidget::setExtension(QGraphicsItem::Extension(extension), variant);
  }

  virtual void setExtension(QGraphicsItem::Extension extension, const QVariant &variant)
  {
    if (cb_setExtension_4817_0.can_issue()) {
      cb_setExtension_4817_0.issue<QGraphicsWidget_Adaptor, unsigned int, const QVariant &>(&QGraphicsWidget_Adaptor::cbs_setExtension_4817_0, (unsigned int)(extension), variant);
    } else {
      QGraphicsWidget::setExtension(extension, variant);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::showEvent(QShowEvent *event)
  void cbs_showEvent_1634_0(QShowEvent *event)
  {
    QGraphicsWidget::showEvent(event);
  }

  virtual void showEvent(QShowEvent *event)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QGraphicsWidget_Adaptor, QShowEvent *>(&QGraphicsWidget_Adaptor::cbs_showEvent_1634_0, event);
    } else {
      QGraphicsWidget::showEvent(event);
    }
  }

  //  [adaptor impl] QSizeF QGraphicsWidget::sizeHint(Qt::SizeHint which, const QSizeF &constraint)
  QSizeF cbs_sizeHint_c3330_1(const qt_gsi::Converter<Qt::SizeHint>::target_type & which, const QSizeF &constraint) const
  {
    return QGraphicsWidget::sizeHint(qt_gsi::QtToCppAdaptor<Qt::SizeHint>(which).cref(), constraint);
  }

  virtual QSizeF sizeHint(Qt::SizeHint which, const QSizeF &constraint) const
  {
    if (cb_sizeHint_c3330_1.can_issue()) {
      return cb_sizeHint_c3330_1.issue<QGraphicsWidget_Adaptor, QSizeF, const qt_gsi::Converter<Qt::SizeHint>::target_type &, const QSizeF &>(&QGraphicsWidget_Adaptor::cbs_sizeHint_c3330_1, qt_gsi::CppToQtAdaptor<Qt::SizeHint>(which), constraint);
    } else {
      return QGraphicsWidget::sizeHint(which, constraint);
    }
  }

  //  [adaptor impl] bool QGraphicsWidget::supportsExtension(QGraphicsItem::Extension extension)
  bool cbs_supportsExtension_c2806_0(unsigned int extension) const
  {
    return QGraphicsWidget::supportsExtension(QGraphicsItem::Extension(extension));
  }

  virtual bool supportsExtension(QGraphicsItem::Extension extension) const
  {
    if (cb_supportsExtension_c2806_0.can_issue()) {
      return cb_supportsExtension_c2806_0.issue<QGraphicsWidget_Adaptor, bool, unsigned int>(&QGraphicsWidget_Adaptor::cbs_supportsExtension_c2806_0, (unsigned int)(extension));
    } else {
      return QGraphicsWidget::supportsExtension(extension);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QGraphicsWidget::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGraphicsWidget_Adaptor, QTimerEvent *>(&QGraphicsWidget_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QGraphicsWidget::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::ungrabKeyboardEvent(QEvent *event)
  void cbs_ungrabKeyboardEvent_1217_0(QEvent *event)
  {
    QGraphicsWidget::ungrabKeyboardEvent(event);
  }

  virtual void ungrabKeyboardEvent(QEvent *event)
  {
    if (cb_ungrabKeyboardEvent_1217_0.can_issue()) {
      cb_ungrabKeyboardEvent_1217_0.issue<QGraphicsWidget_Adaptor, QEvent *>(&QGraphicsWidget_Adaptor::cbs_ungrabKeyboardEvent_1217_0, event);
    } else {
      QGraphicsWidget::ungrabKeyboardEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::ungrabMouseEvent(QEvent *event)
  void cbs_ungrabMouseEvent_1217_0(QEvent *event)
  {
    QGraphicsWidget::ungrabMouseEvent(event);
  }

  virtual void ungrabMouseEvent(QEvent *event)
  {
    if (cb_ungrabMouseEvent_1217_0.can_issue()) {
      cb_ungrabMouseEvent_1217_0.issue<QGraphicsWidget_Adaptor, QEvent *>(&QGraphicsWidget_Adaptor::cbs_ungrabMouseEvent_1217_0, event);
    } else {
      QGraphicsWidget::ungrabMouseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsWidget::updateGeometry()
  void cbs_updateGeometry_0_0()
  {
    QGraphicsWidget::updateGeometry();
  }

  virtual void updateGeometry()
  {
    if (cb_updateGeometry_0_0.can_issue()) {
      cb_updateGeometry_0_0.issue<QGraphicsWidget_Adaptor>(&QGraphicsWidget_Adaptor::cbs_updateGeometry_0_0);
    } else {
      QGraphicsWidget::updateGeometry();
    }
  }

  //  [adaptor impl] void QGraphicsWidget::wheelEvent(QGraphicsSceneWheelEvent *event)
  void cbs_wheelEvent_3029_0(QGraphicsSceneWheelEvent *event)
  {
    QGraphicsWidget::wheelEvent(event);
  }

  virtual void wheelEvent(QGraphicsSceneWheelEvent *event)
  {
    if (cb_wheelEvent_3029_0.can_issue()) {
      cb_wheelEvent_3029_0.issue<QGraphicsWidget_Adaptor, QGraphicsSceneWheelEvent *>(&QGraphicsWidget_Adaptor::cbs_wheelEvent_3029_0, event);
    } else {
      QGraphicsWidget::wheelEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsWidget::windowFrameEvent(QEvent *e)
  bool cbs_windowFrameEvent_1217_0(QEvent *e)
  {
    return QGraphicsWidget::windowFrameEvent(e);
  }

  virtual bool windowFrameEvent(QEvent *e)
  {
    if (cb_windowFrameEvent_1217_0.can_issue()) {
      return cb_windowFrameEvent_1217_0.issue<QGraphicsWidget_Adaptor, bool, QEvent *>(&QGraphicsWidget_Adaptor::cbs_windowFrameEvent_1217_0, e);
    } else {
      return QGraphicsWidget::windowFrameEvent(e);
    }
  }

  //  [adaptor impl] Qt::WindowFrameSection QGraphicsWidget::windowFrameSectionAt(const QPointF &pos)
  qt_gsi::Converter<Qt::WindowFrameSection>::target_type cbs_windowFrameSectionAt_c1986_0(const QPointF &pos) const
  {
    return qt_gsi::CppToQtAdaptor<Qt::WindowFrameSection>(QGraphicsWidget::windowFrameSectionAt(pos));
  }

  virtual Qt::WindowFrameSection windowFrameSectionAt(const QPointF &pos) const
  {
    if (cb_windowFrameSectionAt_c1986_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<Qt::WindowFrameSection>(cb_windowFrameSectionAt_c1986_0.issue<QGraphicsWidget_Adaptor, qt_gsi::Converter<Qt::WindowFrameSection>::target_type, const QPointF &>(&QGraphicsWidget_Adaptor::cbs_windowFrameSectionAt_c1986_0, pos)).cref();
    } else {
      return QGraphicsWidget::windowFrameSectionAt(pos);
    }
  }

  gsi::Callback cb_advance_767_0;
  gsi::Callback cb_boundingRect_c0_0;
  gsi::Callback cb_collidesWithItem_c4977_1;
  gsi::Callback cb_collidesWithPath_c4877_1;
  gsi::Callback cb_contains_c1986_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_getContentsMargins_c4704_0;
  gsi::Callback cb_isObscuredBy_c2614_0;
  gsi::Callback cb_opaqueArea_c0_0;
  gsi::Callback cb_paint_6301_1;
  gsi::Callback cb_paintWindowFrame_6301_1;
  gsi::Callback cb_setGeometry_1862_0;
  gsi::Callback cb_shape_c0_0;
  gsi::Callback cb_type_c0_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_3674_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_3315_0;
  gsi::Callback cb_dragLeaveEvent_3315_0;
  gsi::Callback cb_dragMoveEvent_3315_0;
  gsi::Callback cb_dropEvent_3315_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_extension_c2119_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_grabKeyboardEvent_1217_0;
  gsi::Callback cb_grabMouseEvent_1217_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_hoverEnterEvent_3044_0;
  gsi::Callback cb_hoverLeaveEvent_3044_0;
  gsi::Callback cb_hoverMoveEvent_3044_0;
  gsi::Callback cb_initStyleOption_c1865_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_itemChange_5658_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_mouseDoubleClickEvent_3049_0;
  gsi::Callback cb_mouseMoveEvent_3049_0;
  gsi::Callback cb_mousePressEvent_3049_0;
  gsi::Callback cb_mouseReleaseEvent_3049_0;
  gsi::Callback cb_moveEvent_2935_0;
  gsi::Callback cb_polishEvent_0_0;
  gsi::Callback cb_propertyChange_4036_0;
  gsi::Callback cb_resizeEvent_3154_0;
  gsi::Callback cb_sceneEvent_1217_0;
  gsi::Callback cb_sceneEventFilter_3028_0;
  gsi::Callback cb_setExtension_4817_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_sizeHint_c3330_1;
  gsi::Callback cb_supportsExtension_c2806_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_ungrabKeyboardEvent_1217_0;
  gsi::Callback cb_ungrabMouseEvent_1217_0;
  gsi::Callback cb_updateGeometry_0_0;
  gsi::Callback cb_wheelEvent_3029_0;
  gsi::Callback cb_windowFrameEvent_1217_0;
  gsi::Callback cb_windowFrameSectionAt_c1986_0;
};

QGraphicsWidget_Adaptor::~QGraphicsWidget_Adaptor() { }

//  Constructor QGraphicsWidget::QGraphicsWidget(QGraphicsItem *parent, QFlags<Qt::WindowType> wFlags) (adaptor class)

static void _init_ctor_QGraphicsWidget_Adaptor_4306 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("wFlags", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_1);
  decl->set_return_new<QGraphicsWidget_Adaptor *> ();
}

static void _call_ctor_QGraphicsWidget_Adaptor_4306 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItem *arg1 = args ? args.read<QGraphicsItem * > () : (QGraphicsItem *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::WindowType> >(heap, 0));
  ret.write<QGraphicsWidget_Adaptor *> (new QGraphicsWidget_Adaptor (arg1, qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QGraphicsWidget_Adaptor_4306 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsWidget::QGraphicsWidget(QGraphicsItem *parent, QFlags<Qt::WindowType> wFlags)\nThis method creates an object of class QGraphicsWidget.", &_init_ctor_QGraphicsWidget_Adaptor_4306, &_call_ctor_QGraphicsWidget_Adaptor_4306);
}

// void QGraphicsWidget::addToIndex()

static void _init_fp_addToIndex_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_addToIndex_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsWidget_Adaptor *)cls)->fp_QGraphicsWidget_addToIndex_0 ();
}

static qt_gsi::GenericMethod*_create_fp_addToIndex_0 ()
{
  return new qt_gsi::GenericMethod("*addToIndex", "@brief Method void QGraphicsWidget::addToIndex()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addToIndex_0, &_call_fp_addToIndex_0);
}


// void QGraphicsWidget::prepareGeometryChange()

static void _init_fp_prepareGeometryChange_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_prepareGeometryChange_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsWidget_Adaptor *)cls)->fp_QGraphicsWidget_prepareGeometryChange_0 ();
}

static qt_gsi::GenericMethod*_create_fp_prepareGeometryChange_0 ()
{
  return new qt_gsi::GenericMethod("*prepareGeometryChange", "@brief Method void QGraphicsWidget::prepareGeometryChange()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_prepareGeometryChange_0, &_call_fp_prepareGeometryChange_0);
}


// int QGraphicsWidget::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QGraphicsWidget_Adaptor *)cls)->fp_QGraphicsWidget_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QGraphicsWidget::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QGraphicsWidget::removeFromIndex()

static void _init_fp_removeFromIndex_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_removeFromIndex_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsWidget_Adaptor *)cls)->fp_QGraphicsWidget_removeFromIndex_0 ();
}

static qt_gsi::GenericMethod*_create_fp_removeFromIndex_0 ()
{
  return new qt_gsi::GenericMethod("*removeFromIndex", "@brief Method void QGraphicsWidget::removeFromIndex()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_removeFromIndex_0, &_call_fp_removeFromIndex_0);
}


// QObject *QGraphicsWidget::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QGraphicsWidget_Adaptor *)cls)->fp_QGraphicsWidget_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QGraphicsWidget::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QGraphicsWidget::setGraphicsItem(QGraphicsItem *item)

static void _init_fp_setGraphicsItem_1919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setGraphicsItem_1919 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > ();
  ((QGraphicsWidget_Adaptor *)cls)->fp_QGraphicsWidget_setGraphicsItem_1919 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setGraphicsItem_1919 ()
{
  return new qt_gsi::GenericMethod("*setGraphicsItem", "@brief Method void QGraphicsWidget::setGraphicsItem(QGraphicsItem *item)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setGraphicsItem_1919, &_call_fp_setGraphicsItem_1919);
}


// void QGraphicsWidget::setOwnedByLayout(bool ownedByLayout)

static void _init_fp_setOwnedByLayout_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ownedByLayout");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setOwnedByLayout_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QGraphicsWidget_Adaptor *)cls)->fp_QGraphicsWidget_setOwnedByLayout_864 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setOwnedByLayout_864 ()
{
  return new qt_gsi::GenericMethod("*setOwnedByLayout", "@brief Method void QGraphicsWidget::setOwnedByLayout(bool ownedByLayout)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setOwnedByLayout_864, &_call_fp_setOwnedByLayout_864);
}


// void QGraphicsWidget::advance(int phase)

static void _init_cbs_advance_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("phase");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_advance_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_advance_767_0 (arg1);
}

static void _set_callback_cbs_advance_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_advance_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_advance_767_0 ()
{
  return new qt_gsi::GenericMethod ("advance", "@hide", false, &_init_cbs_advance_767_0, &_call_cbs_advance_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_advance_767_0 ()
{
  return new qt_gsi::GenericMethod ("advance", "@brief Virtual method void QGraphicsWidget::advance(int phase)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_advance_767_0, &_call_cbs_advance_767_0, &_set_callback_cbs_advance_767_0);
}


// QRectF QGraphicsWidget::boundingRect()

static void _init_cbs_boundingRect_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_cbs_boundingRect_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QGraphicsWidget_Adaptor *)cls)->cbs_boundingRect_c0_0 ());
}

static void _set_callback_cbs_boundingRect_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_boundingRect_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_boundingRect_c0_0 ()
{
  return new qt_gsi::GenericMethod ("boundingRect", "@hide", true, &_init_cbs_boundingRect_c0_0, &_call_cbs_boundingRect_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_boundingRect_c0_0 ()
{
  return new qt_gsi::GenericMethod ("boundingRect", "@brief Virtual method QRectF QGraphicsWidget::boundingRect()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_boundingRect_c0_0, &_call_cbs_boundingRect_c0_0, &_set_callback_cbs_boundingRect_c0_0);
}


// bool QGraphicsWidget::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)

static void _init_cbs_collidesWithItem_c4977_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_collidesWithItem_c4977_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > ();
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_collidesWithItem_c4977_1 (arg1, arg2));
}

static void _set_callback_cbs_collidesWithItem_c4977_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_collidesWithItem_c4977_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_collidesWithItem_c4977_1 ()
{
  return new qt_gsi::GenericMethod ("collidesWithItem", "@hide", true, &_init_cbs_collidesWithItem_c4977_1, &_call_cbs_collidesWithItem_c4977_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_collidesWithItem_c4977_1 ()
{
  return new qt_gsi::GenericMethod ("collidesWithItem", "@brief Virtual method bool QGraphicsWidget::collidesWithItem(const QGraphicsItem *other, Qt::ItemSelectionMode mode)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_collidesWithItem_c4977_1, &_call_cbs_collidesWithItem_c4977_1, &_set_callback_cbs_collidesWithItem_c4977_1);
}


// bool QGraphicsWidget::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)

static void _init_cbs_collidesWithPath_c4877_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_collidesWithPath_c4877_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > ();
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_collidesWithPath_c4877_1 (arg1, arg2));
}

static void _set_callback_cbs_collidesWithPath_c4877_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_collidesWithPath_c4877_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_collidesWithPath_c4877_1 ()
{
  return new qt_gsi::GenericMethod ("collidesWithPath", "@hide", true, &_init_cbs_collidesWithPath_c4877_1, &_call_cbs_collidesWithPath_c4877_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_collidesWithPath_c4877_1 ()
{
  return new qt_gsi::GenericMethod ("collidesWithPath", "@brief Virtual method bool QGraphicsWidget::collidesWithPath(const QPainterPath &path, Qt::ItemSelectionMode mode)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_collidesWithPath_c4877_1, &_call_cbs_collidesWithPath_c4877_1, &_set_callback_cbs_collidesWithPath_c4877_1);
}


// bool QGraphicsWidget::contains(const QPointF &point)

static void _init_cbs_contains_c1986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_contains_c1986_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_contains_c1986_0 (arg1));
}

static void _set_callback_cbs_contains_c1986_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_contains_c1986_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contains_c1986_0 ()
{
  return new qt_gsi::GenericMethod ("contains", "@hide", true, &_init_cbs_contains_c1986_0, &_call_cbs_contains_c1986_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contains_c1986_0 ()
{
  return new qt_gsi::GenericMethod ("contains", "@brief Virtual method bool QGraphicsWidget::contains(const QPointF &point)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_contains_c1986_0, &_call_cbs_contains_c1986_0, &_set_callback_cbs_contains_c1986_0);
}


// bool QGraphicsWidget::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QGraphicsWidget::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QGraphicsWidget::getContentsMargins(double *left, double *top, double *right, double *bottom)

static void _init_cbs_getContentsMargins_c4704_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<double * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<double * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<double * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<double * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_getContentsMargins_c4704_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double *arg1 = args.read<double * > ();
  double *arg2 = args.read<double * > ();
  double *arg3 = args.read<double * > ();
  double *arg4 = args.read<double * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_getContentsMargins_c4704_0 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_getContentsMargins_c4704_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_getContentsMargins_c4704_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_getContentsMargins_c4704_0 ()
{
  return new qt_gsi::GenericMethod ("getContentsMargins", "@hide", true, &_init_cbs_getContentsMargins_c4704_0, &_call_cbs_getContentsMargins_c4704_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_getContentsMargins_c4704_0 ()
{
  return new qt_gsi::GenericMethod ("getContentsMargins", "@brief Virtual method void QGraphicsWidget::getContentsMargins(double *left, double *top, double *right, double *bottom)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_getContentsMargins_c4704_0, &_call_cbs_getContentsMargins_c4704_0, &_set_callback_cbs_getContentsMargins_c4704_0);
}


// bool QGraphicsWidget::isObscuredBy(const QGraphicsItem *item)

static void _init_cbs_isObscuredBy_c2614_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isObscuredBy_c2614_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_isObscuredBy_c2614_0 (arg1));
}

static void _set_callback_cbs_isObscuredBy_c2614_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_isObscuredBy_c2614_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_isObscuredBy_c2614_0 ()
{
  return new qt_gsi::GenericMethod ("isObscuredBy", "@hide", true, &_init_cbs_isObscuredBy_c2614_0, &_call_cbs_isObscuredBy_c2614_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_isObscuredBy_c2614_0 ()
{
  return new qt_gsi::GenericMethod ("isObscuredBy", "@brief Virtual method bool QGraphicsWidget::isObscuredBy(const QGraphicsItem *item)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isObscuredBy_c2614_0, &_call_cbs_isObscuredBy_c2614_0, &_set_callback_cbs_isObscuredBy_c2614_0);
}


// QPainterPath QGraphicsWidget::opaqueArea()

static void _init_cbs_opaqueArea_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_cbs_opaqueArea_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsWidget_Adaptor *)cls)->cbs_opaqueArea_c0_0 ());
}

static void _set_callback_cbs_opaqueArea_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_opaqueArea_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_opaqueArea_c0_0 ()
{
  return new qt_gsi::GenericMethod ("opaqueArea", "@hide", true, &_init_cbs_opaqueArea_c0_0, &_call_cbs_opaqueArea_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_opaqueArea_c0_0 ()
{
  return new qt_gsi::GenericMethod ("opaqueArea", "@brief Virtual method QPainterPath QGraphicsWidget::opaqueArea()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_opaqueArea_c0_0, &_call_cbs_opaqueArea_c0_0, &_set_callback_cbs_opaqueArea_c0_0);
}


// void QGraphicsWidget::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)

static void _init_cbs_paint_6301_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_paint_6301_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QStyleOptionGraphicsItem *arg2 = args.read<const QStyleOptionGraphicsItem * > ();
  QWidget *arg3 = args.read<QWidget * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_paint_6301_1 (arg1, arg2, arg3);
}

static void _set_callback_cbs_paint_6301_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_paint_6301_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paint_6301_1 ()
{
  return new qt_gsi::GenericMethod ("paint", "@hide", false, &_init_cbs_paint_6301_1, &_call_cbs_paint_6301_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paint_6301_1 ()
{
  return new qt_gsi::GenericMethod ("paint", "@brief Virtual method void QGraphicsWidget::paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paint_6301_1, &_call_cbs_paint_6301_1, &_set_callback_cbs_paint_6301_1);
}


// void QGraphicsWidget::paintWindowFrame(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)

static void _init_cbs_paintWindowFrame_6301_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionGraphicsItem * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_paintWindowFrame_6301_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QStyleOptionGraphicsItem *arg2 = args.read<const QStyleOptionGraphicsItem * > ();
  QWidget *arg3 = args.read<QWidget * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_paintWindowFrame_6301_1 (arg1, arg2, arg3);
}

static void _set_callback_cbs_paintWindowFrame_6301_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_paintWindowFrame_6301_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintWindowFrame_6301_1 ()
{
  return new qt_gsi::GenericMethod ("paintWindowFrame", "@hide", false, &_init_cbs_paintWindowFrame_6301_1, &_call_cbs_paintWindowFrame_6301_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintWindowFrame_6301_1 ()
{
  return new qt_gsi::GenericMethod ("paintWindowFrame", "@brief Virtual method void QGraphicsWidget::paintWindowFrame(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintWindowFrame_6301_1, &_call_cbs_paintWindowFrame_6301_1, &_set_callback_cbs_paintWindowFrame_6301_1);
}


// void QGraphicsWidget::setGeometry(const QRectF &rect)

static void _init_cbs_setGeometry_1862_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setGeometry_1862_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_setGeometry_1862_0 (arg1);
}

static void _set_callback_cbs_setGeometry_1862_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_setGeometry_1862_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setGeometry_1862_0 ()
{
  return new qt_gsi::GenericMethod ("setGeometry", "@hide", false, &_init_cbs_setGeometry_1862_0, &_call_cbs_setGeometry_1862_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setGeometry_1862_0 ()
{
  return new qt_gsi::GenericMethod ("setGeometry", "@brief Virtual method void QGraphicsWidget::setGeometry(const QRectF &rect)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setGeometry_1862_0, &_call_cbs_setGeometry_1862_0, &_set_callback_cbs_setGeometry_1862_0);
}


// QPainterPath QGraphicsWidget::shape()

static void _init_cbs_shape_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainterPath > ();
}

static void _call_cbs_shape_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsWidget_Adaptor *)cls)->cbs_shape_c0_0 ());
}

static void _set_callback_cbs_shape_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_shape_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_shape_c0_0 ()
{
  return new qt_gsi::GenericMethod ("shape", "@hide", true, &_init_cbs_shape_c0_0, &_call_cbs_shape_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_shape_c0_0 ()
{
  return new qt_gsi::GenericMethod ("shape", "@brief Virtual method QPainterPath QGraphicsWidget::shape()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_shape_c0_0, &_call_cbs_shape_c0_0, &_set_callback_cbs_shape_c0_0);
}


// int QGraphicsWidget::type()

static void _init_cbs_type_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_type_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QGraphicsWidget_Adaptor *)cls)->cbs_type_c0_0 ());
}

static void _set_callback_cbs_type_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_type_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_type_c0_0 ()
{
  return new qt_gsi::GenericMethod ("type", "@hide", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_type_c0_0 ()
{
  return new qt_gsi::GenericMethod ("type", "@brief Virtual method int QGraphicsWidget::type()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_type_c0_0, &_call_cbs_type_c0_0, &_set_callback_cbs_type_c0_0);
}


// void QGraphicsWidget::changeEvent(QEvent *event)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QGraphicsWidget::changeEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QGraphicsWidget::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGraphicsWidget::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QGraphicsWidget::closeEvent(QCloseEvent *event)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QGraphicsWidget::closeEvent(QCloseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QGraphicsWidget::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_3674_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_3674_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneContextMenuEvent *arg1 = args.read<QGraphicsSceneContextMenuEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_contextMenuEvent_3674_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_3674_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_contextMenuEvent_3674_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_3674_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_3674_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QGraphicsWidget::contextMenuEvent(QGraphicsSceneContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_3674_0, &_call_cbs_contextMenuEvent_3674_0, &_set_callback_cbs_contextMenuEvent_3674_0);
}


// void QGraphicsWidget::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGraphicsWidget::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QGraphicsWidget::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGraphicsWidget::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QGraphicsWidget::dragEnterEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragEnterEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_dragEnterEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_dragEnterEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QGraphicsWidget::dragEnterEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_3315_0, &_call_cbs_dragEnterEvent_3315_0, &_set_callback_cbs_dragEnterEvent_3315_0);
}


// void QGraphicsWidget::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragLeaveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_dragLeaveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_dragLeaveEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QGraphicsWidget::dragLeaveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_3315_0, &_call_cbs_dragLeaveEvent_3315_0, &_set_callback_cbs_dragLeaveEvent_3315_0);
}


// void QGraphicsWidget::dragMoveEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dragMoveEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_dragMoveEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_dragMoveEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QGraphicsWidget::dragMoveEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_3315_0, &_call_cbs_dragMoveEvent_3315_0, &_set_callback_cbs_dragMoveEvent_3315_0);
}


// void QGraphicsWidget::dropEvent(QGraphicsSceneDragDropEvent *event)

static void _init_cbs_dropEvent_3315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneDragDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_3315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneDragDropEvent *arg1 = args.read<QGraphicsSceneDragDropEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_dropEvent_3315_0 (arg1);
}

static void _set_callback_cbs_dropEvent_3315_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_dropEvent_3315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_3315_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QGraphicsWidget::dropEvent(QGraphicsSceneDragDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_3315_0, &_call_cbs_dropEvent_3315_0, &_set_callback_cbs_dropEvent_3315_0);
}


// bool QGraphicsWidget::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QGraphicsWidget::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// QVariant QGraphicsWidget::extension(const QVariant &variant)

static void _init_cbs_extension_c2119_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("variant");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_extension_c2119_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QVariant &arg1 = args.read<const QVariant & > ();
  ret.write<QVariant > ((QVariant)((QGraphicsWidget_Adaptor *)cls)->cbs_extension_c2119_0 (arg1));
}

static void _set_callback_cbs_extension_c2119_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_extension_c2119_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_extension_c2119_0 ()
{
  return new qt_gsi::GenericMethod ("*extension", "@hide", true, &_init_cbs_extension_c2119_0, &_call_cbs_extension_c2119_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_extension_c2119_0 ()
{
  return new qt_gsi::GenericMethod ("*extension", "@brief Virtual method QVariant QGraphicsWidget::extension(const QVariant &variant)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_extension_c2119_0, &_call_cbs_extension_c2119_0, &_set_callback_cbs_extension_c2119_0);
}


// void QGraphicsWidget::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QGraphicsWidget::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QGraphicsWidget::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QGraphicsWidget::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QGraphicsWidget::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QGraphicsWidget::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QGraphicsWidget::grabKeyboardEvent(QEvent *event)

static void _init_cbs_grabKeyboardEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_grabKeyboardEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_grabKeyboardEvent_1217_0 (arg1);
}

static void _set_callback_cbs_grabKeyboardEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_grabKeyboardEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_grabKeyboardEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*grabKeyboardEvent", "@hide", false, &_init_cbs_grabKeyboardEvent_1217_0, &_call_cbs_grabKeyboardEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_grabKeyboardEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*grabKeyboardEvent", "@brief Virtual method void QGraphicsWidget::grabKeyboardEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_grabKeyboardEvent_1217_0, &_call_cbs_grabKeyboardEvent_1217_0, &_set_callback_cbs_grabKeyboardEvent_1217_0);
}


// void QGraphicsWidget::grabMouseEvent(QEvent *event)

static void _init_cbs_grabMouseEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_grabMouseEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_grabMouseEvent_1217_0 (arg1);
}

static void _set_callback_cbs_grabMouseEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_grabMouseEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_grabMouseEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*grabMouseEvent", "@hide", false, &_init_cbs_grabMouseEvent_1217_0, &_call_cbs_grabMouseEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_grabMouseEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*grabMouseEvent", "@brief Virtual method void QGraphicsWidget::grabMouseEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_grabMouseEvent_1217_0, &_call_cbs_grabMouseEvent_1217_0, &_set_callback_cbs_grabMouseEvent_1217_0);
}


// void QGraphicsWidget::hideEvent(QHideEvent *event)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QGraphicsWidget::hideEvent(QHideEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// void QGraphicsWidget::hoverEnterEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverEnterEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverEnterEvent_3044_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_hoverEnterEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverEnterEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_hoverEnterEvent_3044_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hoverEnterEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverEnterEvent", "@hide", false, &_init_cbs_hoverEnterEvent_3044_0, &_call_cbs_hoverEnterEvent_3044_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hoverEnterEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverEnterEvent", "@brief Virtual method void QGraphicsWidget::hoverEnterEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverEnterEvent_3044_0, &_call_cbs_hoverEnterEvent_3044_0, &_set_callback_cbs_hoverEnterEvent_3044_0);
}


// void QGraphicsWidget::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverLeaveEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverLeaveEvent_3044_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_hoverLeaveEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverLeaveEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_hoverLeaveEvent_3044_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hoverLeaveEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverLeaveEvent", "@hide", false, &_init_cbs_hoverLeaveEvent_3044_0, &_call_cbs_hoverLeaveEvent_3044_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hoverLeaveEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverLeaveEvent", "@brief Virtual method void QGraphicsWidget::hoverLeaveEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverLeaveEvent_3044_0, &_call_cbs_hoverLeaveEvent_3044_0, &_set_callback_cbs_hoverLeaveEvent_3044_0);
}


// void QGraphicsWidget::hoverMoveEvent(QGraphicsSceneHoverEvent *event)

static void _init_cbs_hoverMoveEvent_3044_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneHoverEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hoverMoveEvent_3044_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneHoverEvent *arg1 = args.read<QGraphicsSceneHoverEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_hoverMoveEvent_3044_0 (arg1);
}

static void _set_callback_cbs_hoverMoveEvent_3044_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_hoverMoveEvent_3044_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hoverMoveEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverMoveEvent", "@hide", false, &_init_cbs_hoverMoveEvent_3044_0, &_call_cbs_hoverMoveEvent_3044_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hoverMoveEvent_3044_0 ()
{
  return new qt_gsi::GenericMethod ("*hoverMoveEvent", "@brief Virtual method void QGraphicsWidget::hoverMoveEvent(QGraphicsSceneHoverEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hoverMoveEvent_3044_0, &_call_cbs_hoverMoveEvent_3044_0, &_set_callback_cbs_hoverMoveEvent_3044_0);
}


// void QGraphicsWidget::initStyleOption(QStyleOption *option)

static void _init_cbs_initStyleOption_c1865_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOption * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initStyleOption_c1865_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyleOption *arg1 = args.read<QStyleOption * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_initStyleOption_c1865_0 (arg1);
}

static void _set_callback_cbs_initStyleOption_c1865_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_initStyleOption_c1865_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_initStyleOption_c1865_0 ()
{
  return new qt_gsi::GenericMethod ("*initStyleOption", "@hide", true, &_init_cbs_initStyleOption_c1865_0, &_call_cbs_initStyleOption_c1865_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_initStyleOption_c1865_0 ()
{
  return new qt_gsi::GenericMethod ("*initStyleOption", "@brief Virtual method void QGraphicsWidget::initStyleOption(QStyleOption *option)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initStyleOption_c1865_0, &_call_cbs_initStyleOption_c1865_0, &_set_callback_cbs_initStyleOption_c1865_0);
}


// void QGraphicsWidget::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QGraphicsWidget::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// QVariant QGraphicsWidget::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QGraphicsWidget_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodQuery", "@brief Virtual method QVariant QGraphicsWidget::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// QVariant QGraphicsWidget::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)

static void _init_cbs_itemChange_5658_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("change");
  decl->add_arg<const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_itemChange_5658_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & arg1 = args.read<const qt_gsi::Converter<QGraphicsItem::GraphicsItemChange>::target_type & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ret.write<QVariant > ((QVariant)((QGraphicsWidget_Adaptor *)cls)->cbs_itemChange_5658_0 (arg1, arg2));
}

static void _set_callback_cbs_itemChange_5658_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_itemChange_5658_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_itemChange_5658_0 ()
{
  return new qt_gsi::GenericMethod ("*itemChange", "@hide", false, &_init_cbs_itemChange_5658_0, &_call_cbs_itemChange_5658_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_itemChange_5658_0 ()
{
  return new qt_gsi::GenericMethod ("*itemChange", "@brief Virtual method QVariant QGraphicsWidget::itemChange(QGraphicsItem::GraphicsItemChange change, const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_itemChange_5658_0, &_call_cbs_itemChange_5658_0, &_set_callback_cbs_itemChange_5658_0);
}


// void QGraphicsWidget::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QGraphicsWidget::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QGraphicsWidget::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QGraphicsWidget::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QGraphicsWidget::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_mouseDoubleClickEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_mouseDoubleClickEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QGraphicsWidget::mouseDoubleClickEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_3049_0, &_call_cbs_mouseDoubleClickEvent_3049_0, &_set_callback_cbs_mouseDoubleClickEvent_3049_0);
}


// void QGraphicsWidget::mouseMoveEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseMoveEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_mouseMoveEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_mouseMoveEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QGraphicsWidget::mouseMoveEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_3049_0, &_call_cbs_mouseMoveEvent_3049_0, &_set_callback_cbs_mouseMoveEvent_3049_0);
}


// void QGraphicsWidget::mousePressEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mousePressEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_mousePressEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_mousePressEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QGraphicsWidget::mousePressEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_3049_0, &_call_cbs_mousePressEvent_3049_0, &_set_callback_cbs_mousePressEvent_3049_0);
}


// void QGraphicsWidget::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_3049_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_3049_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMouseEvent *arg1 = args.read<QGraphicsSceneMouseEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_mouseReleaseEvent_3049_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_3049_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_mouseReleaseEvent_3049_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_3049_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QGraphicsWidget::mouseReleaseEvent(QGraphicsSceneMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_3049_0, &_call_cbs_mouseReleaseEvent_3049_0, &_set_callback_cbs_mouseReleaseEvent_3049_0);
}


// void QGraphicsWidget::moveEvent(QGraphicsSceneMoveEvent *event)

static void _init_cbs_moveEvent_2935_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_2935_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneMoveEvent *arg1 = args.read<QGraphicsSceneMoveEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_moveEvent_2935_0 (arg1);
}

static void _set_callback_cbs_moveEvent_2935_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_moveEvent_2935_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_2935_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_2935_0, &_call_cbs_moveEvent_2935_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_2935_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QGraphicsWidget::moveEvent(QGraphicsSceneMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_2935_0, &_call_cbs_moveEvent_2935_0, &_set_callback_cbs_moveEvent_2935_0);
}


// void QGraphicsWidget::polishEvent()

static void _init_cbs_polishEvent_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_polishEvent_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsWidget_Adaptor *)cls)->cbs_polishEvent_0_0 ();
}

static void _set_callback_cbs_polishEvent_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_polishEvent_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_polishEvent_0_0 ()
{
  return new qt_gsi::GenericMethod ("*polishEvent", "@hide", false, &_init_cbs_polishEvent_0_0, &_call_cbs_polishEvent_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_polishEvent_0_0 ()
{
  return new qt_gsi::GenericMethod ("*polishEvent", "@brief Virtual method void QGraphicsWidget::polishEvent()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_polishEvent_0_0, &_call_cbs_polishEvent_0_0, &_set_callback_cbs_polishEvent_0_0);
}


// QVariant QGraphicsWidget::propertyChange(const QString &propertyName, const QVariant &value)

static void _init_cbs_propertyChange_4036_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("propertyName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_propertyChange_4036_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ret.write<QVariant > ((QVariant)((QGraphicsWidget_Adaptor *)cls)->cbs_propertyChange_4036_0 (arg1, arg2));
}

static void _set_callback_cbs_propertyChange_4036_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_propertyChange_4036_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_propertyChange_4036_0 ()
{
  return new qt_gsi::GenericMethod ("*propertyChange", "@hide", false, &_init_cbs_propertyChange_4036_0, &_call_cbs_propertyChange_4036_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_propertyChange_4036_0 ()
{
  return new qt_gsi::GenericMethod ("*propertyChange", "@brief Virtual method QVariant QGraphicsWidget::propertyChange(const QString &propertyName, const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_propertyChange_4036_0, &_call_cbs_propertyChange_4036_0, &_set_callback_cbs_propertyChange_4036_0);
}


// void QGraphicsWidget::resizeEvent(QGraphicsSceneResizeEvent *event)

static void _init_cbs_resizeEvent_3154_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_3154_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneResizeEvent *arg1 = args.read<QGraphicsSceneResizeEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_resizeEvent_3154_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_3154_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_resizeEvent_3154_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_3154_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_3154_0, &_call_cbs_resizeEvent_3154_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_3154_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QGraphicsWidget::resizeEvent(QGraphicsSceneResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_3154_0, &_call_cbs_resizeEvent_3154_0, &_set_callback_cbs_resizeEvent_3154_0);
}


// bool QGraphicsWidget::sceneEvent(QEvent *event)

static void _init_cbs_sceneEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_sceneEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_sceneEvent_1217_0 (arg1));
}

static void _set_callback_cbs_sceneEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_sceneEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sceneEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*sceneEvent", "@hide", false, &_init_cbs_sceneEvent_1217_0, &_call_cbs_sceneEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sceneEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*sceneEvent", "@brief Virtual method bool QGraphicsWidget::sceneEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sceneEvent_1217_0, &_call_cbs_sceneEvent_1217_0, &_set_callback_cbs_sceneEvent_1217_0);
}


// bool QGraphicsWidget::sceneEventFilter(QGraphicsItem *watched, QEvent *event)

static void _init_cbs_sceneEventFilter_3028_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_sceneEventFilter_3028_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsItem *arg1 = args.read<QGraphicsItem * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_sceneEventFilter_3028_0 (arg1, arg2));
}

static void _set_callback_cbs_sceneEventFilter_3028_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_sceneEventFilter_3028_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sceneEventFilter_3028_0 ()
{
  return new qt_gsi::GenericMethod ("*sceneEventFilter", "@hide", false, &_init_cbs_sceneEventFilter_3028_0, &_call_cbs_sceneEventFilter_3028_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sceneEventFilter_3028_0 ()
{
  return new qt_gsi::GenericMethod ("*sceneEventFilter", "@brief Virtual method bool QGraphicsWidget::sceneEventFilter(QGraphicsItem *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sceneEventFilter_3028_0, &_call_cbs_sceneEventFilter_3028_0, &_set_callback_cbs_sceneEventFilter_3028_0);
}


// void QGraphicsWidget::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)

static void _init_cbs_setExtension_4817_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("extension");
  decl->add_arg<unsigned int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("variant");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setExtension_4817_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_setExtension_4817_0 (arg1, arg2);
}

static void _set_callback_cbs_setExtension_4817_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_setExtension_4817_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setExtension_4817_0 ()
{
  return new qt_gsi::GenericMethod ("*setExtension", "@hide", false, &_init_cbs_setExtension_4817_0, &_call_cbs_setExtension_4817_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setExtension_4817_0 ()
{
  return new qt_gsi::GenericMethod ("*setExtension", "@brief Virtual method void QGraphicsWidget::setExtension(QGraphicsItem::Extension extension, const QVariant &variant)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setExtension_4817_0, &_call_cbs_setExtension_4817_0, &_set_callback_cbs_setExtension_4817_0);
}


// void QGraphicsWidget::showEvent(QShowEvent *event)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QGraphicsWidget::showEvent(QShowEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// QSizeF QGraphicsWidget::sizeHint(Qt::SizeHint which, const QSizeF &constraint)

static void _init_cbs_sizeHint_c3330_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("which");
  decl->add_arg<const qt_gsi::Converter<Qt::SizeHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("constraint");
  decl->add_arg<const QSizeF & > (argspec_1);
  decl->set_return<QSizeF > ();
}

static void _call_cbs_sizeHint_c3330_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::SizeHint>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::SizeHint>::target_type & > ();
  const QSizeF &arg2 = args.read<const QSizeF & > ();
  ret.write<QSizeF > ((QSizeF)((QGraphicsWidget_Adaptor *)cls)->cbs_sizeHint_c3330_1 (arg1, arg2));
}

static void _set_callback_cbs_sizeHint_c3330_1 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_sizeHint_c3330_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c3330_1 ()
{
  return new qt_gsi::GenericMethod ("*sizeHint", "@hide", true, &_init_cbs_sizeHint_c3330_1, &_call_cbs_sizeHint_c3330_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c3330_1 ()
{
  return new qt_gsi::GenericMethod ("*sizeHint", "@brief Virtual method QSizeF QGraphicsWidget::sizeHint(Qt::SizeHint which, const QSizeF &constraint)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c3330_1, &_call_cbs_sizeHint_c3330_1, &_set_callback_cbs_sizeHint_c3330_1);
}


// bool QGraphicsWidget::supportsExtension(QGraphicsItem::Extension extension)

static void _init_cbs_supportsExtension_c2806_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("extension");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_supportsExtension_c2806_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_supportsExtension_c2806_0 (arg1));
}

static void _set_callback_cbs_supportsExtension_c2806_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_supportsExtension_c2806_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_supportsExtension_c2806_0 ()
{
  return new qt_gsi::GenericMethod ("*supportsExtension", "@hide", true, &_init_cbs_supportsExtension_c2806_0, &_call_cbs_supportsExtension_c2806_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_supportsExtension_c2806_0 ()
{
  return new qt_gsi::GenericMethod ("*supportsExtension", "@brief Virtual method bool QGraphicsWidget::supportsExtension(QGraphicsItem::Extension extension)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportsExtension_c2806_0, &_call_cbs_supportsExtension_c2806_0, &_set_callback_cbs_supportsExtension_c2806_0);
}


// void QGraphicsWidget::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGraphicsWidget::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QGraphicsWidget::ungrabKeyboardEvent(QEvent *event)

static void _init_cbs_ungrabKeyboardEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_ungrabKeyboardEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_ungrabKeyboardEvent_1217_0 (arg1);
}

static void _set_callback_cbs_ungrabKeyboardEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_ungrabKeyboardEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_ungrabKeyboardEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*ungrabKeyboardEvent", "@hide", false, &_init_cbs_ungrabKeyboardEvent_1217_0, &_call_cbs_ungrabKeyboardEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_ungrabKeyboardEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*ungrabKeyboardEvent", "@brief Virtual method void QGraphicsWidget::ungrabKeyboardEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_ungrabKeyboardEvent_1217_0, &_call_cbs_ungrabKeyboardEvent_1217_0, &_set_callback_cbs_ungrabKeyboardEvent_1217_0);
}


// void QGraphicsWidget::ungrabMouseEvent(QEvent *event)

static void _init_cbs_ungrabMouseEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_ungrabMouseEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_ungrabMouseEvent_1217_0 (arg1);
}

static void _set_callback_cbs_ungrabMouseEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_ungrabMouseEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_ungrabMouseEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*ungrabMouseEvent", "@hide", false, &_init_cbs_ungrabMouseEvent_1217_0, &_call_cbs_ungrabMouseEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_ungrabMouseEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*ungrabMouseEvent", "@brief Virtual method void QGraphicsWidget::ungrabMouseEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_ungrabMouseEvent_1217_0, &_call_cbs_ungrabMouseEvent_1217_0, &_set_callback_cbs_ungrabMouseEvent_1217_0);
}


// void QGraphicsWidget::updateGeometry()

static void _init_cbs_updateGeometry_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_updateGeometry_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsWidget_Adaptor *)cls)->cbs_updateGeometry_0_0 ();
}

static void _set_callback_cbs_updateGeometry_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_updateGeometry_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_updateGeometry_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateGeometry", "@hide", false, &_init_cbs_updateGeometry_0_0, &_call_cbs_updateGeometry_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_updateGeometry_0_0 ()
{
  return new qt_gsi::GenericMethod ("*updateGeometry", "@brief Virtual method void QGraphicsWidget::updateGeometry()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateGeometry_0_0, &_call_cbs_updateGeometry_0_0, &_set_callback_cbs_updateGeometry_0_0);
}


// void QGraphicsWidget::wheelEvent(QGraphicsSceneWheelEvent *event)

static void _init_cbs_wheelEvent_3029_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QGraphicsSceneWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_3029_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsSceneWheelEvent *arg1 = args.read<QGraphicsSceneWheelEvent * > ();
  ((QGraphicsWidget_Adaptor *)cls)->cbs_wheelEvent_3029_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_3029_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_wheelEvent_3029_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_3029_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_3029_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QGraphicsWidget::wheelEvent(QGraphicsSceneWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_3029_0, &_call_cbs_wheelEvent_3029_0, &_set_callback_cbs_wheelEvent_3029_0);
}


// bool QGraphicsWidget::windowFrameEvent(QEvent *e)

static void _init_cbs_windowFrameEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_windowFrameEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsWidget_Adaptor *)cls)->cbs_windowFrameEvent_1217_0 (arg1));
}

static void _set_callback_cbs_windowFrameEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_windowFrameEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowFrameEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*windowFrameEvent", "@hide", false, &_init_cbs_windowFrameEvent_1217_0, &_call_cbs_windowFrameEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowFrameEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*windowFrameEvent", "@brief Virtual method bool QGraphicsWidget::windowFrameEvent(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowFrameEvent_1217_0, &_call_cbs_windowFrameEvent_1217_0, &_set_callback_cbs_windowFrameEvent_1217_0);
}


// Qt::WindowFrameSection QGraphicsWidget::windowFrameSectionAt(const QPointF &pos)

static void _init_cbs_windowFrameSectionAt_c1986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<qt_gsi::Converter<Qt::WindowFrameSection>::target_type > ();
}

static void _call_cbs_windowFrameSectionAt_c1986_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<qt_gsi::Converter<Qt::WindowFrameSection>::target_type > ((qt_gsi::Converter<Qt::WindowFrameSection>::target_type)((QGraphicsWidget_Adaptor *)cls)->cbs_windowFrameSectionAt_c1986_0 (arg1));
}

static void _set_callback_cbs_windowFrameSectionAt_c1986_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsWidget_Adaptor *)cls)->cb_windowFrameSectionAt_c1986_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowFrameSectionAt_c1986_0 ()
{
  return new qt_gsi::GenericMethod ("*windowFrameSectionAt", "@hide", true, &_init_cbs_windowFrameSectionAt_c1986_0, &_call_cbs_windowFrameSectionAt_c1986_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowFrameSectionAt_c1986_0 ()
{
  return new qt_gsi::GenericMethod ("*windowFrameSectionAt", "@brief Virtual method Qt::WindowFrameSection QGraphicsWidget::windowFrameSectionAt(const QPointF &pos)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_windowFrameSectionAt_c1986_0, &_call_cbs_windowFrameSectionAt_c1986_0, &_set_callback_cbs_windowFrameSectionAt_c1986_0);
}


namespace gsi
{

extern gsi::Class<QGraphicsWidget> decl_QGraphicsWidget;

gsi::Class<QGraphicsWidget_Adaptor> decl_QGraphicsWidget_Adaptor (decl_QGraphicsWidget, "QGraphicsWidget",
  gsi::Methods(_create_fp_addToIndex_0 ()) +
  gsi::Methods(_create_fp_prepareGeometryChange_0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_removeFromIndex_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_setGraphicsItem_1919 ()) +
  gsi::Methods(_create_fp_setOwnedByLayout_864 ()) +
  gsi::Methods(_create_cbs_advance_767_0 ()) +
  gsi::Methods(_create_callback_cbs_advance_767_0 ()) +
  gsi::Methods(_create_cbs_boundingRect_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_boundingRect_c0_0 ()) +
  gsi::Methods(_create_cbs_collidesWithItem_c4977_1 ()) +
  gsi::Methods(_create_callback_cbs_collidesWithItem_c4977_1 ()) +
  gsi::Methods(_create_cbs_collidesWithPath_c4877_1 ()) +
  gsi::Methods(_create_callback_cbs_collidesWithPath_c4877_1 ()) +
  gsi::Methods(_create_cbs_contains_c1986_0 ()) +
  gsi::Methods(_create_callback_cbs_contains_c1986_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_getContentsMargins_c4704_0 ()) +
  gsi::Methods(_create_callback_cbs_getContentsMargins_c4704_0 ()) +
  gsi::Methods(_create_cbs_isObscuredBy_c2614_0 ()) +
  gsi::Methods(_create_callback_cbs_isObscuredBy_c2614_0 ()) +
  gsi::Methods(_create_cbs_opaqueArea_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_opaqueArea_c0_0 ()) +
  gsi::Methods(_create_cbs_paint_6301_1 ()) +
  gsi::Methods(_create_callback_cbs_paint_6301_1 ()) +
  gsi::Methods(_create_cbs_paintWindowFrame_6301_1 ()) +
  gsi::Methods(_create_callback_cbs_paintWindowFrame_6301_1 ()) +
  gsi::Methods(_create_cbs_setGeometry_1862_0 ()) +
  gsi::Methods(_create_callback_cbs_setGeometry_1862_0 ()) +
  gsi::Methods(_create_cbs_shape_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_shape_c0_0 ()) +
  gsi::Methods(_create_cbs_type_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_type_c0_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_3674_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_3674_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_3315_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_3315_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_extension_c2119_0 ()) +
  gsi::Methods(_create_callback_cbs_extension_c2119_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_grabKeyboardEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_grabKeyboardEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_grabMouseEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_grabMouseEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_hoverEnterEvent_3044_0 ()) +
  gsi::Methods(_create_callback_cbs_hoverEnterEvent_3044_0 ()) +
  gsi::Methods(_create_cbs_hoverLeaveEvent_3044_0 ()) +
  gsi::Methods(_create_callback_cbs_hoverLeaveEvent_3044_0 ()) +
  gsi::Methods(_create_cbs_hoverMoveEvent_3044_0 ()) +
  gsi::Methods(_create_callback_cbs_hoverMoveEvent_3044_0 ()) +
  gsi::Methods(_create_cbs_initStyleOption_c1865_0 ()) +
  gsi::Methods(_create_callback_cbs_initStyleOption_c1865_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_itemChange_5658_0 ()) +
  gsi::Methods(_create_callback_cbs_itemChange_5658_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_3049_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_3049_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_2935_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_2935_0 ()) +
  gsi::Methods(_create_cbs_polishEvent_0_0 ()) +
  gsi::Methods(_create_callback_cbs_polishEvent_0_0 ()) +
  gsi::Methods(_create_cbs_propertyChange_4036_0 ()) +
  gsi::Methods(_create_callback_cbs_propertyChange_4036_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_3154_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_3154_0 ()) +
  gsi::Methods(_create_cbs_sceneEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_sceneEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_sceneEventFilter_3028_0 ()) +
  gsi::Methods(_create_callback_cbs_sceneEventFilter_3028_0 ()) +
  gsi::Methods(_create_cbs_setExtension_4817_0 ()) +
  gsi::Methods(_create_callback_cbs_setExtension_4817_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c3330_1 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c3330_1 ()) +
  gsi::Methods(_create_cbs_supportsExtension_c2806_0 ()) +
  gsi::Methods(_create_callback_cbs_supportsExtension_c2806_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_ungrabKeyboardEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_ungrabKeyboardEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_ungrabMouseEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_ungrabMouseEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_updateGeometry_0_0 ()) +
  gsi::Methods(_create_callback_cbs_updateGeometry_0_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_3029_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_3029_0 ()) +
  gsi::Methods(_create_cbs_windowFrameEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_windowFrameEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_windowFrameSectionAt_c1986_0 ()) +
  gsi::Methods(_create_callback_cbs_windowFrameSectionAt_c1986_0 ()) +
  gsi::Methods(_create_ctor_QGraphicsWidget_Adaptor_4306 ()),
  "@qt\n@brief Binding of QGraphicsWidget");

}

