
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsEffect.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQGraphicsEffect_EventAdaptor.h"
#include "gsiDeclQGraphicsEffect_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsEffect

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGraphicsEffect::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QRectF QGraphicsEffect::boundingRect()


static void _init_f_boundingRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_boundingRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QGraphicsEffect *)cls)->boundingRect ());
}

static qt_gsi::GenericMethod *_create_f_boundingRect_c0 ()
{
  return new qt_gsi::GenericMethod ("boundingRect", "@brief Method QRectF QGraphicsEffect::boundingRect()\n", true, &_init_f_boundingRect_c0, &_call_f_boundingRect_c0);
}

// QRectF QGraphicsEffect::boundingRectFor(const QRectF &sourceRect)


static void _init_f_boundingRectFor_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceRect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_boundingRectFor_c1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<QRectF > ((QRectF)((QGraphicsEffect *)cls)->boundingRectFor (arg1));
}

static qt_gsi::GenericMethod *_create_f_boundingRectFor_c1862 ()
{
  return new qt_gsi::GenericMethod ("boundingRectFor", "@brief Method QRectF QGraphicsEffect::boundingRectFor(const QRectF &sourceRect)\n", true, &_init_f_boundingRectFor_c1862, &_call_f_boundingRectFor_c1862);
}

// bool QGraphicsEffect::isEnabled()


static void _init_f_isEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsEffect *)cls)->isEnabled ());
}

static qt_gsi::GenericMethod *_create_f_isEnabled_c0 ()
{
  return new qt_gsi::GenericMethod ("isEnabled?|:enabled", "@brief Method bool QGraphicsEffect::isEnabled()\n", true, &_init_f_isEnabled_c0, &_call_f_isEnabled_c0);
}

// void QGraphicsEffect::setEnabled(bool enable)


static void _init_f_setEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QGraphicsEffect *)cls)->setEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setEnabled|enabled=", "@brief Method void QGraphicsEffect::setEnabled(bool enable)\n", false, &_init_f_setEnabled_864, &_call_f_setEnabled_864);
}

// void QGraphicsEffect::update()


static void _init_f_update_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_update_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsEffect *)cls)->update ();
}

static qt_gsi::GenericMethod *_create_f_update_0 ()
{
  return new qt_gsi::GenericMethod ("update", "@brief Method void QGraphicsEffect::update()\n", false, &_init_f_update_0, &_call_f_update_0);
}

// static QString QGraphicsEffect::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsEffect::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsEffect::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QGraphicsEffect::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QGraphicsEffect::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsEffect::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QGraphicsEffect::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsEffect::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsEffect::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QGraphicsEffect::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QGraphicsEffect::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsEffect::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QGraphicsEffect, QGraphicsEffect_EventAdaptor> ea_QGraphicsEffect;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QGraphicsEffect> decl_QGraphicsEffect (ea_QGraphicsEffect, decl_QObject, "QGraphicsEffect_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_boundingRect_c0 ()) +
  gsi::Methods(_create_f_boundingRectFor_c1862 ()) +
  gsi::Methods(_create_f_isEnabled_c0 ()) +
  gsi::Methods(_create_f_setEnabled_864 ()) +
  gsi::Methods(_create_f_update_0 ()) +
  qt_gsi::qt_signal<QGraphicsEffect, QGraphicsEffect_EventAdaptor, QObject *> ("destroyed", &QGraphicsEffect_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QGraphicsEffect::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsEffect, QGraphicsEffect_EventAdaptor, bool> ("enabledChanged", &QGraphicsEffect_EventAdaptor::enabledChanged_e_864, gsi::arg("enabled"), "@brief Signal declaration for QGraphicsEffect::enabledChanged(bool enabled)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QGraphicsEffect");
}


class QGraphicsEffect_Adaptor : public QGraphicsEffect, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsEffect_Adaptor();

  //  [adaptor ctor] QGraphicsEffect::QGraphicsEffect(QObject *parent)
  QGraphicsEffect_Adaptor() : QGraphicsEffect()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsEffect::QGraphicsEffect(QObject *parent)
  QGraphicsEffect_Adaptor(QObject *parent) : QGraphicsEffect(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QGraphicsEffect::drawSource(QPainter *painter)
  void fp_QGraphicsEffect_drawSource_1426 (QPainter *painter) {
    QGraphicsEffect::drawSource(painter);
  }

  //  int QGraphicsEffect::receivers(const char *signal)
  int fp_QGraphicsEffect_receivers_c1731 (const char *signal) const {
    return QGraphicsEffect::receivers(signal);
  }

  //  QObject *QGraphicsEffect::sender()
  QObject * fp_QGraphicsEffect_sender_c0 () const {
    return QGraphicsEffect::sender();
  }

  //  QRectF QGraphicsEffect::sourceBoundingRect(Qt::CoordinateSystem system)
  QRectF fp_QGraphicsEffect_sourceBoundingRect_c2426 (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & system) const {
    return QGraphicsEffect::sourceBoundingRect(qt_gsi::QtToCppAdaptor<Qt::CoordinateSystem>(system).cref());
  }

  //  bool QGraphicsEffect::sourceIsPixmap()
  bool fp_QGraphicsEffect_sourceIsPixmap_c0 () const {
    return QGraphicsEffect::sourceIsPixmap();
  }

  //  QPixmap QGraphicsEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)
  QPixmap fp_QGraphicsEffect_sourcePixmap_c6763 (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & system, QPoint *offset, const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & mode) const {
    return QGraphicsEffect::sourcePixmap(qt_gsi::QtToCppAdaptor<Qt::CoordinateSystem>(system).cref(), offset, qt_gsi::QtToCppAdaptor<QGraphicsEffect::PixmapPadMode>(mode).cref());
  }

  //  void QGraphicsEffect::updateBoundingRect()
  void fp_QGraphicsEffect_updateBoundingRect_0 () {
    QGraphicsEffect::updateBoundingRect();
  }

  //  [adaptor impl] QRectF QGraphicsEffect::boundingRectFor(const QRectF &sourceRect)
  QRectF cbs_boundingRectFor_c1862_0(const QRectF &sourceRect) const
  {
    return QGraphicsEffect::boundingRectFor(sourceRect);
  }

  virtual QRectF boundingRectFor(const QRectF &sourceRect) const
  {
    if (cb_boundingRectFor_c1862_0.can_issue()) {
      return cb_boundingRectFor_c1862_0.issue<QGraphicsEffect_Adaptor, QRectF, const QRectF &>(&QGraphicsEffect_Adaptor::cbs_boundingRectFor_c1862_0, sourceRect);
    } else {
      return QGraphicsEffect::boundingRectFor(sourceRect);
    }
  }

  //  [adaptor impl] bool QGraphicsEffect::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QGraphicsEffect::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGraphicsEffect_Adaptor, bool, QEvent *>(&QGraphicsEffect_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QGraphicsEffect::event(arg1);
    }
  }

  //  [adaptor impl] bool QGraphicsEffect::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QGraphicsEffect::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGraphicsEffect_Adaptor, bool, QObject *, QEvent *>(&QGraphicsEffect_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QGraphicsEffect::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QGraphicsEffect::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QGraphicsEffect::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGraphicsEffect_Adaptor, QChildEvent *>(&QGraphicsEffect_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QGraphicsEffect::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsEffect::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QGraphicsEffect::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGraphicsEffect_Adaptor, QEvent *>(&QGraphicsEffect_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QGraphicsEffect::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsEffect::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QGraphicsEffect::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QGraphicsEffect_Adaptor, const char *>(&QGraphicsEffect_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QGraphicsEffect::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGraphicsEffect::draw(QPainter *painter)
  void cbs_draw_1426_0(QPainter *painter)
  {
    throw qt_gsi::AbstractMethodCalledException("draw");
  }

  virtual void draw(QPainter *painter)
  {
    if (cb_draw_1426_0.can_issue()) {
      cb_draw_1426_0.issue<QGraphicsEffect_Adaptor, QPainter *>(&QGraphicsEffect_Adaptor::cbs_draw_1426_0, painter);
    } else {
      throw qt_gsi::AbstractMethodCalledException("draw");
    }
  }

  //  [adaptor impl] void QGraphicsEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)
  void cbs_sourceChanged_3695_0(const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type & flags)
  {
    QGraphicsEffect::sourceChanged(qt_gsi::QtToCppAdaptor<QFlags<QGraphicsEffect::ChangeFlag> >(flags).cref());
  }

  virtual void sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)
  {
    if (cb_sourceChanged_3695_0.can_issue()) {
      cb_sourceChanged_3695_0.issue<QGraphicsEffect_Adaptor, const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type &>(&QGraphicsEffect_Adaptor::cbs_sourceChanged_3695_0, qt_gsi::CppToQtAdaptor<QFlags<QGraphicsEffect::ChangeFlag> >(flags));
    } else {
      QGraphicsEffect::sourceChanged(flags);
    }
  }

  //  [adaptor impl] void QGraphicsEffect::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QGraphicsEffect::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGraphicsEffect_Adaptor, QTimerEvent *>(&QGraphicsEffect_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QGraphicsEffect::timerEvent(arg1);
    }
  }

  gsi::Callback cb_boundingRectFor_c1862_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_draw_1426_0;
  gsi::Callback cb_sourceChanged_3695_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QGraphicsEffect_Adaptor::~QGraphicsEffect_Adaptor() { }

//  Constructor QGraphicsEffect::QGraphicsEffect(QObject *parent) (adaptor class)

static void _init_ctor_QGraphicsEffect_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QGraphicsEffect_Adaptor *> ();
}

static void _call_ctor_QGraphicsEffect_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QGraphicsEffect_Adaptor *> (new QGraphicsEffect_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QGraphicsEffect_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsEffect::QGraphicsEffect(QObject *parent)\nThis method creates an object of class QGraphicsEffect.", &_init_ctor_QGraphicsEffect_Adaptor_1302, &_call_ctor_QGraphicsEffect_Adaptor_1302);
}

// void QGraphicsEffect::drawSource(QPainter *painter)

static void _init_fp_drawSource_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawSource_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  ((QGraphicsEffect_Adaptor *)cls)->fp_QGraphicsEffect_drawSource_1426 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_drawSource_1426 ()
{
  return new qt_gsi::GenericMethod("*drawSource", "@brief Method void QGraphicsEffect::drawSource(QPainter *painter)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawSource_1426, &_call_fp_drawSource_1426);
}


// int QGraphicsEffect::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QGraphicsEffect_Adaptor *)cls)->fp_QGraphicsEffect_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QGraphicsEffect::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QGraphicsEffect::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QGraphicsEffect_Adaptor *)cls)->fp_QGraphicsEffect_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QGraphicsEffect::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// QRectF QGraphicsEffect::sourceBoundingRect(Qt::CoordinateSystem system)

static void _init_fp_sourceBoundingRect_c2426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("system", true, "Qt::LogicalCoordinates");
  decl->add_arg<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_fp_sourceBoundingRect_c2426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > () : (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::CoordinateSystem>(heap, Qt::LogicalCoordinates));
  ret.write<QRectF > ((QRectF)((QGraphicsEffect_Adaptor *)cls)->fp_QGraphicsEffect_sourceBoundingRect_c2426 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_sourceBoundingRect_c2426 ()
{
  return new qt_gsi::GenericMethod("*sourceBoundingRect", "@brief Method QRectF QGraphicsEffect::sourceBoundingRect(Qt::CoordinateSystem system)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourceBoundingRect_c2426, &_call_fp_sourceBoundingRect_c2426);
}


// bool QGraphicsEffect::sourceIsPixmap()

static void _init_fp_sourceIsPixmap_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_sourceIsPixmap_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsEffect_Adaptor *)cls)->fp_QGraphicsEffect_sourceIsPixmap_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sourceIsPixmap_c0 ()
{
  return new qt_gsi::GenericMethod("*sourceIsPixmap", "@brief Method bool QGraphicsEffect::sourceIsPixmap()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourceIsPixmap_c0, &_call_fp_sourceIsPixmap_c0);
}


// QPixmap QGraphicsEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)

static void _init_fp_sourcePixmap_c6763 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("system", true, "Qt::LogicalCoordinates");
  decl->add_arg<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("offset", true, "0");
  decl->add_arg<QPoint * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QGraphicsEffect::PadToEffectiveBoundingRect");
  decl->add_arg<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_fp_sourcePixmap_c6763 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > () : (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::CoordinateSystem>(heap, Qt::LogicalCoordinates));
  QPoint *arg2 = args ? args.read<QPoint * > () : (QPoint *)(0);
  const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & > () : (const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QGraphicsEffect::PixmapPadMode>(heap, QGraphicsEffect::PadToEffectiveBoundingRect));
  ret.write<QPixmap > ((QPixmap)((QGraphicsEffect_Adaptor *)cls)->fp_QGraphicsEffect_sourcePixmap_c6763 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_sourcePixmap_c6763 ()
{
  return new qt_gsi::GenericMethod("*sourcePixmap", "@brief Method QPixmap QGraphicsEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourcePixmap_c6763, &_call_fp_sourcePixmap_c6763);
}


// void QGraphicsEffect::updateBoundingRect()

static void _init_fp_updateBoundingRect_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateBoundingRect_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsEffect_Adaptor *)cls)->fp_QGraphicsEffect_updateBoundingRect_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateBoundingRect_0 ()
{
  return new qt_gsi::GenericMethod("*updateBoundingRect", "@brief Method void QGraphicsEffect::updateBoundingRect()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateBoundingRect_0, &_call_fp_updateBoundingRect_0);
}


// QRectF QGraphicsEffect::boundingRectFor(const QRectF &sourceRect)

static void _init_cbs_boundingRectFor_c1862_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceRect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_cbs_boundingRectFor_c1862_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<QRectF > ((QRectF)((QGraphicsEffect_Adaptor *)cls)->cbs_boundingRectFor_c1862_0 (arg1));
}

static void _set_callback_cbs_boundingRectFor_c1862_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsEffect_Adaptor *)cls)->cb_boundingRectFor_c1862_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_boundingRectFor_c1862_0 ()
{
  return new qt_gsi::GenericMethod ("boundingRectFor", "@hide", true, &_init_cbs_boundingRectFor_c1862_0, &_call_cbs_boundingRectFor_c1862_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_boundingRectFor_c1862_0 ()
{
  return new qt_gsi::GenericMethod ("boundingRectFor", "@brief Virtual method QRectF QGraphicsEffect::boundingRectFor(const QRectF &sourceRect)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_boundingRectFor_c1862_0, &_call_cbs_boundingRectFor_c1862_0, &_set_callback_cbs_boundingRectFor_c1862_0);
}


// bool QGraphicsEffect::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsEffect_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsEffect_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QGraphicsEffect::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QGraphicsEffect::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsEffect_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsEffect_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QGraphicsEffect::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QGraphicsEffect::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QGraphicsEffect_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsEffect_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGraphicsEffect::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QGraphicsEffect::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QGraphicsEffect_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsEffect_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGraphicsEffect::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QGraphicsEffect::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QGraphicsEffect_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsEffect_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGraphicsEffect::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QGraphicsEffect::draw(QPainter *painter)

static void _init_cbs_draw_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_draw_1426_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  ((QGraphicsEffect_Adaptor *)cls)->cbs_draw_1426_0 (arg1);
}

static void _set_callback_cbs_draw_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsEffect_Adaptor *)cls)->cb_draw_1426_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_draw_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*draw", "@hide", false, &_init_cbs_draw_1426_0, &_call_cbs_draw_1426_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_draw_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*draw", "@brief Virtual method void QGraphicsEffect::draw(QPainter *painter)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_draw_1426_0, &_call_cbs_draw_1426_0, &_set_callback_cbs_draw_1426_0);
}


// void QGraphicsEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)

static void _init_cbs_sourceChanged_3695_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_sourceChanged_3695_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type & > ();
  ((QGraphicsEffect_Adaptor *)cls)->cbs_sourceChanged_3695_0 (arg1);
}

static void _set_callback_cbs_sourceChanged_3695_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsEffect_Adaptor *)cls)->cb_sourceChanged_3695_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sourceChanged_3695_0 ()
{
  return new qt_gsi::GenericMethod ("*sourceChanged", "@hide", false, &_init_cbs_sourceChanged_3695_0, &_call_cbs_sourceChanged_3695_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sourceChanged_3695_0 ()
{
  return new qt_gsi::GenericMethod ("*sourceChanged", "@brief Virtual method void QGraphicsEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sourceChanged_3695_0, &_call_cbs_sourceChanged_3695_0, &_set_callback_cbs_sourceChanged_3695_0);
}


// void QGraphicsEffect::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QGraphicsEffect_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsEffect_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGraphicsEffect::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QGraphicsEffect> decl_QGraphicsEffect;

gsi::Class<QGraphicsEffect_Adaptor> decl_QGraphicsEffect_Adaptor (decl_QGraphicsEffect, "QGraphicsEffect",
  gsi::Methods(_create_fp_drawSource_1426 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_sourceBoundingRect_c2426 ()) +
  gsi::Methods(_create_fp_sourceIsPixmap_c0 ()) +
  gsi::Methods(_create_fp_sourcePixmap_c6763 ()) +
  gsi::Methods(_create_fp_updateBoundingRect_0 ()) +
  gsi::Methods(_create_cbs_boundingRectFor_c1862_0 ()) +
  gsi::Methods(_create_callback_cbs_boundingRectFor_c1862_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_draw_1426_0 ()) +
  gsi::Methods(_create_callback_cbs_draw_1426_0 ()) +
  gsi::Methods(_create_cbs_sourceChanged_3695_0 ()) +
  gsi::Methods(_create_callback_cbs_sourceChanged_3695_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QGraphicsEffect_Adaptor_1302 ()),
  "@qt\n@brief Binding of QGraphicsEffect");

}


//  Implementation of the enum wrapper class for QGraphicsEffect::ChangeFlag
namespace qt_gsi
{

static QGraphicsEffect_ChangeFlag_Enum *c_1_QGraphicsEffect_ChangeFlag_Enum () { return new QGraphicsEffect_ChangeFlag_Enum (QGraphicsEffect::SourceAttached); }
static QGraphicsEffect_ChangeFlag_Enum *c_2_QGraphicsEffect_ChangeFlag_Enum () { return new QGraphicsEffect_ChangeFlag_Enum (QGraphicsEffect::SourceDetached); }
static QGraphicsEffect_ChangeFlag_Enum *c_3_QGraphicsEffect_ChangeFlag_Enum () { return new QGraphicsEffect_ChangeFlag_Enum (QGraphicsEffect::SourceBoundingRectChanged); }
static QGraphicsEffect_ChangeFlag_Enum *c_4_QGraphicsEffect_ChangeFlag_Enum () { return new QGraphicsEffect_ChangeFlag_Enum (QGraphicsEffect::SourceInvalidated); }

static gsi::Methods mkdefs_QGraphicsEffect_ChangeFlag () {
  return
    gsi::constant ("SourceAttached", &qt_gsi::c_1_QGraphicsEffect_ChangeFlag_Enum, "@brief Enum constant QGraphicsEffect::SourceAttached") +
    gsi::constant ("SourceDetached", &qt_gsi::c_2_QGraphicsEffect_ChangeFlag_Enum, "@brief Enum constant QGraphicsEffect::SourceDetached") +
    gsi::constant ("SourceBoundingRectChanged", &qt_gsi::c_3_QGraphicsEffect_ChangeFlag_Enum, "@brief Enum constant QGraphicsEffect::SourceBoundingRectChanged") +
    gsi::constant ("SourceInvalidated", &qt_gsi::c_4_QGraphicsEffect_ChangeFlag_Enum, "@brief Enum constant QGraphicsEffect::SourceInvalidated");
}

static std::string to_s_QGraphicsEffect_ChangeFlag_Enum (const QGraphicsEffect_ChangeFlag_Enum *e)
{
  if (e->value () == QGraphicsEffect::SourceAttached) { return tl::sprintf ("SourceAttached (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsEffect::SourceDetached) { return tl::sprintf ("SourceDetached (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsEffect::SourceBoundingRectChanged) { return tl::sprintf ("SourceBoundingRectChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsEffect::SourceInvalidated) { return tl::sprintf ("SourceInvalidated (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QGraphicsEffect_ChangeFlag_Enum (const QGraphicsEffect_ChangeFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static QGraphicsEffect_ChangeFlag_Enum *from_i_QGraphicsEffect_ChangeFlag_Enum (unsigned int i)
{
  return new QGraphicsEffect_ChangeFlag_Enum ((QGraphicsEffect::ChangeFlag) i);
}

static bool equalQGraphicsEffect_ChangeFlag_Enum (const QGraphicsEffect_ChangeFlag_Enum *e, QGraphicsEffect_ChangeFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QGraphicsEffect_ChangeFlag_Enum (const QGraphicsEffect_ChangeFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QGraphicsEffect_ChangeFlag_Enums oropQGraphicsEffect_ChangeFlag_Enums (const QGraphicsEffect_ChangeFlag_Enums *e, const QGraphicsEffect_ChangeFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static QGraphicsEffect_ChangeFlag_Enums andopQGraphicsEffect_ChangeFlag_Enums (const QGraphicsEffect_ChangeFlag_Enums *e, const QGraphicsEffect_ChangeFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static QGraphicsEffect_ChangeFlag_Enums xoropQGraphicsEffect_ChangeFlag_Enums (const QGraphicsEffect_ChangeFlag_Enums *e, const QGraphicsEffect_ChangeFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QGraphicsEffect_ChangeFlag_Enums (const QGraphicsEffect_ChangeFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (QGraphicsEffect::SourceAttached)) { if (!l.empty ()) l += "|"; l += "SourceAttached"; }
  if (e->testFlag (QGraphicsEffect::SourceDetached)) { if (!l.empty ()) l += "|"; l += "SourceDetached"; }
  if (e->testFlag (QGraphicsEffect::SourceBoundingRectChanged)) { if (!l.empty ()) l += "|"; l += "SourceBoundingRectChanged"; }
  if (e->testFlag (QGraphicsEffect::SourceInvalidated)) { if (!l.empty ()) l += "|"; l += "SourceInvalidated"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QGraphicsEffect_ChangeFlag_Enums (const QGraphicsEffect_ChangeFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QGraphicsEffect_ChangeFlag_Enums (const QGraphicsEffect_ChangeFlag_Enums *e, const QGraphicsEffect_ChangeFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QGraphicsEffect_ChangeFlag_Enums> decl_QGraphicsEffect_ChangeFlag_Enums ("QGraphicsEffect_QFlags_ChangeFlag",
  gsi::method_ext ("|", &qt_gsi::oropQGraphicsEffect_ChangeFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQGraphicsEffect_ChangeFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQGraphicsEffect_ChangeFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsEffect_ChangeFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsEffect_ChangeFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QGraphicsEffect_ChangeFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QGraphicsEffect::ChangeFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QGraphicsEffect_ChangeFlag_Enum> decl_QGraphicsEffect_ChangeFlag_Enum (decl_QGraphicsEffect_ChangeFlag_Enums, "QGraphicsEffect_ChangeFlag",
  qt_gsi::mkdefs_QGraphicsEffect_ChangeFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsEffect_ChangeFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsEffect_ChangeFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQGraphicsEffect_ChangeFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QGraphicsEffect_ChangeFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QGraphicsEffect_ChangeFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QGraphicsEffect::ChangeFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsEffect> inject_QGraphicsEffect_ChangeFlag_Enum_in_parent (qt_gsi::mkdefs_QGraphicsEffect_ChangeFlag ());
static gsi::ClassExt<QGraphicsEffect> decl_QGraphicsEffect_ChangeFlag_Enum_as_child (decl_QGraphicsEffect_ChangeFlag_Enum, "ChangeFlag");

}


//  Implementation of the enum wrapper class for QGraphicsEffect::PixmapPadMode
namespace qt_gsi
{

static QGraphicsEffect_PixmapPadMode_Enum *c_1_QGraphicsEffect_PixmapPadMode_Enum () { return new QGraphicsEffect_PixmapPadMode_Enum (QGraphicsEffect::NoPad); }
static QGraphicsEffect_PixmapPadMode_Enum *c_2_QGraphicsEffect_PixmapPadMode_Enum () { return new QGraphicsEffect_PixmapPadMode_Enum (QGraphicsEffect::PadToTransparentBorder); }
static QGraphicsEffect_PixmapPadMode_Enum *c_3_QGraphicsEffect_PixmapPadMode_Enum () { return new QGraphicsEffect_PixmapPadMode_Enum (QGraphicsEffect::PadToEffectiveBoundingRect); }

static gsi::Methods mkdefs_QGraphicsEffect_PixmapPadMode () {
  return
    gsi::constant ("NoPad", &qt_gsi::c_1_QGraphicsEffect_PixmapPadMode_Enum, "@brief Enum constant QGraphicsEffect::NoPad") +
    gsi::constant ("PadToTransparentBorder", &qt_gsi::c_2_QGraphicsEffect_PixmapPadMode_Enum, "@brief Enum constant QGraphicsEffect::PadToTransparentBorder") +
    gsi::constant ("PadToEffectiveBoundingRect", &qt_gsi::c_3_QGraphicsEffect_PixmapPadMode_Enum, "@brief Enum constant QGraphicsEffect::PadToEffectiveBoundingRect");
}

static std::string to_s_QGraphicsEffect_PixmapPadMode_Enum (const QGraphicsEffect_PixmapPadMode_Enum *e)
{
  if (e->value () == QGraphicsEffect::NoPad) { return tl::sprintf ("NoPad (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsEffect::PadToTransparentBorder) { return tl::sprintf ("PadToTransparentBorder (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsEffect::PadToEffectiveBoundingRect) { return tl::sprintf ("PadToEffectiveBoundingRect (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QGraphicsEffect_PixmapPadMode_Enum (const QGraphicsEffect_PixmapPadMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QGraphicsEffect_PixmapPadMode_Enum *from_i_QGraphicsEffect_PixmapPadMode_Enum (unsigned int i)
{
  return new QGraphicsEffect_PixmapPadMode_Enum ((QGraphicsEffect::PixmapPadMode) i);
}

static bool equalQGraphicsEffect_PixmapPadMode_Enum (const QGraphicsEffect_PixmapPadMode_Enum *e, QGraphicsEffect_PixmapPadMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QGraphicsEffect_PixmapPadMode_Enum (const QGraphicsEffect_PixmapPadMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QGraphicsEffect_PixmapPadMode_Enums oropQGraphicsEffect_PixmapPadMode_Enums (const QGraphicsEffect_PixmapPadMode_Enums *e, const QGraphicsEffect_PixmapPadMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QGraphicsEffect_PixmapPadMode_Enums andopQGraphicsEffect_PixmapPadMode_Enums (const QGraphicsEffect_PixmapPadMode_Enums *e, const QGraphicsEffect_PixmapPadMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QGraphicsEffect_PixmapPadMode_Enums xoropQGraphicsEffect_PixmapPadMode_Enums (const QGraphicsEffect_PixmapPadMode_Enums *e, const QGraphicsEffect_PixmapPadMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QGraphicsEffect_PixmapPadMode_Enums (const QGraphicsEffect_PixmapPadMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QGraphicsEffect::NoPad)) { if (!l.empty ()) l += "|"; l += "NoPad"; }
  if (e->testFlag (QGraphicsEffect::PadToTransparentBorder)) { if (!l.empty ()) l += "|"; l += "PadToTransparentBorder"; }
  if (e->testFlag (QGraphicsEffect::PadToEffectiveBoundingRect)) { if (!l.empty ()) l += "|"; l += "PadToEffectiveBoundingRect"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QGraphicsEffect_PixmapPadMode_Enums (const QGraphicsEffect_PixmapPadMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QGraphicsEffect_PixmapPadMode_Enums (const QGraphicsEffect_PixmapPadMode_Enums *e, const QGraphicsEffect_PixmapPadMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QGraphicsEffect_PixmapPadMode_Enums> decl_QGraphicsEffect_PixmapPadMode_Enums ("QGraphicsEffect_QFlags_PixmapPadMode",
  gsi::method_ext ("|", &qt_gsi::oropQGraphicsEffect_PixmapPadMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQGraphicsEffect_PixmapPadMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQGraphicsEffect_PixmapPadMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsEffect_PixmapPadMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsEffect_PixmapPadMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QGraphicsEffect_PixmapPadMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QGraphicsEffect::PixmapPadMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QGraphicsEffect_PixmapPadMode_Enum> decl_QGraphicsEffect_PixmapPadMode_Enum (decl_QGraphicsEffect_PixmapPadMode_Enums, "QGraphicsEffect_PixmapPadMode",
  qt_gsi::mkdefs_QGraphicsEffect_PixmapPadMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsEffect_PixmapPadMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsEffect_PixmapPadMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQGraphicsEffect_PixmapPadMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QGraphicsEffect_PixmapPadMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QGraphicsEffect_PixmapPadMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QGraphicsEffect::PixmapPadMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsEffect> inject_QGraphicsEffect_PixmapPadMode_Enum_in_parent (qt_gsi::mkdefs_QGraphicsEffect_PixmapPadMode ());
static gsi::ClassExt<QGraphicsEffect> decl_QGraphicsEffect_PixmapPadMode_Enum_as_child (decl_QGraphicsEffect_PixmapPadMode_Enum, "PixmapPadMode");

}

