
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQFileInfo.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQFileInfo_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QFileInfo

//  Constructor QFileInfo::QFileInfo()


static void _init_ctor_QFileInfo_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QFileInfo *> ();
}

static void _call_ctor_QFileInfo_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFileInfo *> (new QFileInfo ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFileInfo_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFileInfo::QFileInfo()\nThis method creates an object of class QFileInfo.", &_init_ctor_QFileInfo_0, &_call_ctor_QFileInfo_0);
}

//  Constructor QFileInfo::QFileInfo(const QString &file)


static void _init_ctor_QFileInfo_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("file");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QFileInfo *> ();
}

static void _call_ctor_QFileInfo_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QFileInfo *> (new QFileInfo (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFileInfo_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFileInfo::QFileInfo(const QString &file)\nThis method creates an object of class QFileInfo.", &_init_ctor_QFileInfo_2025, &_call_ctor_QFileInfo_2025);
}

//  Constructor QFileInfo::QFileInfo(const QFile &file)


static void _init_ctor_QFileInfo_1778 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("file");
  decl->add_arg<const QFile & > (argspec_0);
  decl->set_return_new<QFileInfo *> ();
}

static void _call_ctor_QFileInfo_1778 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFile &arg1 = args.read<const QFile & > ();
  ret.write<QFileInfo *> (new QFileInfo (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFileInfo_1778 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFileInfo::QFileInfo(const QFile &file)\nThis method creates an object of class QFileInfo.", &_init_ctor_QFileInfo_1778, &_call_ctor_QFileInfo_1778);
}

//  Constructor QFileInfo::QFileInfo(const QDir &dir, const QString &file)


static void _init_ctor_QFileInfo_3598 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir");
  decl->add_arg<const QDir & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("file");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return_new<QFileInfo *> ();
}

static void _call_ctor_QFileInfo_3598 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDir &arg1 = args.read<const QDir & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<QFileInfo *> (new QFileInfo (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFileInfo_3598 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFileInfo::QFileInfo(const QDir &dir, const QString &file)\nThis method creates an object of class QFileInfo.", &_init_ctor_QFileInfo_3598, &_call_ctor_QFileInfo_3598);
}

//  Constructor QFileInfo::QFileInfo(const QFileInfo &fileinfo)


static void _init_ctor_QFileInfo_2174 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileinfo");
  decl->add_arg<const QFileInfo & > (argspec_0);
  decl->set_return_new<QFileInfo *> ();
}

static void _call_ctor_QFileInfo_2174 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFileInfo &arg1 = args.read<const QFileInfo & > ();
  ret.write<QFileInfo *> (new QFileInfo (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFileInfo_2174 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFileInfo::QFileInfo(const QFileInfo &fileinfo)\nThis method creates an object of class QFileInfo.", &_init_ctor_QFileInfo_2174, &_call_ctor_QFileInfo_2174);
}

// QDir QFileInfo::absoluteDir()


static void _init_f_absoluteDir_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDir > ();
}

static void _call_f_absoluteDir_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDir > ((QDir)((QFileInfo *)cls)->absoluteDir ());
}

static qt_gsi::GenericMethod *_create_f_absoluteDir_c0 ()
{
  return new qt_gsi::GenericMethod ("absoluteDir", "@brief Method QDir QFileInfo::absoluteDir()\n", true, &_init_f_absoluteDir_c0, &_call_f_absoluteDir_c0);
}

// QString QFileInfo::absoluteFilePath()


static void _init_f_absoluteFilePath_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_absoluteFilePath_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileInfo *)cls)->absoluteFilePath ());
}

static qt_gsi::GenericMethod *_create_f_absoluteFilePath_c0 ()
{
  return new qt_gsi::GenericMethod ("absoluteFilePath", "@brief Method QString QFileInfo::absoluteFilePath()\n", true, &_init_f_absoluteFilePath_c0, &_call_f_absoluteFilePath_c0);
}

// QString QFileInfo::absolutePath()


static void _init_f_absolutePath_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_absolutePath_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileInfo *)cls)->absolutePath ());
}

static qt_gsi::GenericMethod *_create_f_absolutePath_c0 ()
{
  return new qt_gsi::GenericMethod ("absolutePath", "@brief Method QString QFileInfo::absolutePath()\n", true, &_init_f_absolutePath_c0, &_call_f_absolutePath_c0);
}

// QString QFileInfo::baseName()


static void _init_f_baseName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_baseName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileInfo *)cls)->baseName ());
}

static qt_gsi::GenericMethod *_create_f_baseName_c0 ()
{
  return new qt_gsi::GenericMethod ("baseName", "@brief Method QString QFileInfo::baseName()\n", true, &_init_f_baseName_c0, &_call_f_baseName_c0);
}

// QString QFileInfo::bundleName()


static void _init_f_bundleName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_bundleName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileInfo *)cls)->bundleName ());
}

static qt_gsi::GenericMethod *_create_f_bundleName_c0 ()
{
  return new qt_gsi::GenericMethod ("bundleName", "@brief Method QString QFileInfo::bundleName()\n", true, &_init_f_bundleName_c0, &_call_f_bundleName_c0);
}

// bool QFileInfo::caching()


static void _init_f_caching_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_caching_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileInfo *)cls)->caching ());
}

static qt_gsi::GenericMethod *_create_f_caching_c0 ()
{
  return new qt_gsi::GenericMethod (":caching", "@brief Method bool QFileInfo::caching()\n", true, &_init_f_caching_c0, &_call_f_caching_c0);
}

// QString QFileInfo::canonicalFilePath()


static void _init_f_canonicalFilePath_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_canonicalFilePath_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileInfo *)cls)->canonicalFilePath ());
}

static qt_gsi::GenericMethod *_create_f_canonicalFilePath_c0 ()
{
  return new qt_gsi::GenericMethod ("canonicalFilePath", "@brief Method QString QFileInfo::canonicalFilePath()\n", true, &_init_f_canonicalFilePath_c0, &_call_f_canonicalFilePath_c0);
}

// QString QFileInfo::canonicalPath()


static void _init_f_canonicalPath_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_canonicalPath_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileInfo *)cls)->canonicalPath ());
}

static qt_gsi::GenericMethod *_create_f_canonicalPath_c0 ()
{
  return new qt_gsi::GenericMethod ("canonicalPath", "@brief Method QString QFileInfo::canonicalPath()\n", true, &_init_f_canonicalPath_c0, &_call_f_canonicalPath_c0);
}

// QString QFileInfo::completeBaseName()


static void _init_f_completeBaseName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_completeBaseName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileInfo *)cls)->completeBaseName ());
}

static qt_gsi::GenericMethod *_create_f_completeBaseName_c0 ()
{
  return new qt_gsi::GenericMethod ("completeBaseName", "@brief Method QString QFileInfo::completeBaseName()\n", true, &_init_f_completeBaseName_c0, &_call_f_completeBaseName_c0);
}

// QString QFileInfo::completeSuffix()


static void _init_f_completeSuffix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_completeSuffix_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileInfo *)cls)->completeSuffix ());
}

static qt_gsi::GenericMethod *_create_f_completeSuffix_c0 ()
{
  return new qt_gsi::GenericMethod ("completeSuffix", "@brief Method QString QFileInfo::completeSuffix()\n", true, &_init_f_completeSuffix_c0, &_call_f_completeSuffix_c0);
}

// QDateTime QFileInfo::created()


static void _init_f_created_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDateTime > ();
}

static void _call_f_created_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDateTime > ((QDateTime)((QFileInfo *)cls)->created ());
}

static qt_gsi::GenericMethod *_create_f_created_c0 ()
{
  return new qt_gsi::GenericMethod ("created", "@brief Method QDateTime QFileInfo::created()\n", true, &_init_f_created_c0, &_call_f_created_c0);
}

// void QFileInfo::detach()


static void _init_f_detach_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_detach_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFileInfo *)cls)->detach ();
}

static qt_gsi::GenericMethod *_create_f_detach_0 ()
{
  return new qt_gsi::GenericMethod ("detach", "@brief Method void QFileInfo::detach()\n", false, &_init_f_detach_0, &_call_f_detach_0);
}

// QDir QFileInfo::dir()


static void _init_f_dir_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDir > ();
}

static void _call_f_dir_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDir > ((QDir)((QFileInfo *)cls)->dir ());
}

static qt_gsi::GenericMethod *_create_f_dir_c0 ()
{
  return new qt_gsi::GenericMethod ("dir", "@brief Method QDir QFileInfo::dir()\n", true, &_init_f_dir_c0, &_call_f_dir_c0);
}

// bool QFileInfo::exists()


static void _init_f_exists_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_exists_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileInfo *)cls)->exists ());
}

static qt_gsi::GenericMethod *_create_f_exists_c0 ()
{
  return new qt_gsi::GenericMethod ("exists", "@brief Method bool QFileInfo::exists()\n", true, &_init_f_exists_c0, &_call_f_exists_c0);
}

// QString QFileInfo::fileName()


static void _init_f_fileName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fileName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileInfo *)cls)->fileName ());
}

static qt_gsi::GenericMethod *_create_f_fileName_c0 ()
{
  return new qt_gsi::GenericMethod ("fileName", "@brief Method QString QFileInfo::fileName()\n", true, &_init_f_fileName_c0, &_call_f_fileName_c0);
}

// QString QFileInfo::filePath()


static void _init_f_filePath_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_filePath_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileInfo *)cls)->filePath ());
}

static qt_gsi::GenericMethod *_create_f_filePath_c0 ()
{
  return new qt_gsi::GenericMethod ("filePath", "@brief Method QString QFileInfo::filePath()\n", true, &_init_f_filePath_c0, &_call_f_filePath_c0);
}

// QString QFileInfo::group()


static void _init_f_group_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_group_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileInfo *)cls)->group ());
}

static qt_gsi::GenericMethod *_create_f_group_c0 ()
{
  return new qt_gsi::GenericMethod ("group", "@brief Method QString QFileInfo::group()\n", true, &_init_f_group_c0, &_call_f_group_c0);
}

// unsigned int QFileInfo::groupId()


static void _init_f_groupId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_f_groupId_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<unsigned int > ((unsigned int)((QFileInfo *)cls)->groupId ());
}

static qt_gsi::GenericMethod *_create_f_groupId_c0 ()
{
  return new qt_gsi::GenericMethod ("groupId", "@brief Method unsigned int QFileInfo::groupId()\n", true, &_init_f_groupId_c0, &_call_f_groupId_c0);
}

// bool QFileInfo::isAbsolute()


static void _init_f_isAbsolute_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAbsolute_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileInfo *)cls)->isAbsolute ());
}

static qt_gsi::GenericMethod *_create_f_isAbsolute_c0 ()
{
  return new qt_gsi::GenericMethod ("isAbsolute?", "@brief Method bool QFileInfo::isAbsolute()\n", true, &_init_f_isAbsolute_c0, &_call_f_isAbsolute_c0);
}

// bool QFileInfo::isBundle()


static void _init_f_isBundle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isBundle_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileInfo *)cls)->isBundle ());
}

static qt_gsi::GenericMethod *_create_f_isBundle_c0 ()
{
  return new qt_gsi::GenericMethod ("isBundle?", "@brief Method bool QFileInfo::isBundle()\n", true, &_init_f_isBundle_c0, &_call_f_isBundle_c0);
}

// bool QFileInfo::isDir()


static void _init_f_isDir_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDir_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileInfo *)cls)->isDir ());
}

static qt_gsi::GenericMethod *_create_f_isDir_c0 ()
{
  return new qt_gsi::GenericMethod ("isDir?", "@brief Method bool QFileInfo::isDir()\n", true, &_init_f_isDir_c0, &_call_f_isDir_c0);
}

// bool QFileInfo::isExecutable()


static void _init_f_isExecutable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isExecutable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileInfo *)cls)->isExecutable ());
}

static qt_gsi::GenericMethod *_create_f_isExecutable_c0 ()
{
  return new qt_gsi::GenericMethod ("isExecutable?", "@brief Method bool QFileInfo::isExecutable()\n", true, &_init_f_isExecutable_c0, &_call_f_isExecutable_c0);
}

// bool QFileInfo::isFile()


static void _init_f_isFile_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isFile_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileInfo *)cls)->isFile ());
}

static qt_gsi::GenericMethod *_create_f_isFile_c0 ()
{
  return new qt_gsi::GenericMethod ("isFile?", "@brief Method bool QFileInfo::isFile()\n", true, &_init_f_isFile_c0, &_call_f_isFile_c0);
}

// bool QFileInfo::isHidden()


static void _init_f_isHidden_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isHidden_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileInfo *)cls)->isHidden ());
}

static qt_gsi::GenericMethod *_create_f_isHidden_c0 ()
{
  return new qt_gsi::GenericMethod ("isHidden?", "@brief Method bool QFileInfo::isHidden()\n", true, &_init_f_isHidden_c0, &_call_f_isHidden_c0);
}

// bool QFileInfo::isReadable()


static void _init_f_isReadable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isReadable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileInfo *)cls)->isReadable ());
}

static qt_gsi::GenericMethod *_create_f_isReadable_c0 ()
{
  return new qt_gsi::GenericMethod ("isReadable?", "@brief Method bool QFileInfo::isReadable()\n", true, &_init_f_isReadable_c0, &_call_f_isReadable_c0);
}

// bool QFileInfo::isRelative()


static void _init_f_isRelative_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRelative_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileInfo *)cls)->isRelative ());
}

static qt_gsi::GenericMethod *_create_f_isRelative_c0 ()
{
  return new qt_gsi::GenericMethod ("isRelative?", "@brief Method bool QFileInfo::isRelative()\n", true, &_init_f_isRelative_c0, &_call_f_isRelative_c0);
}

// bool QFileInfo::isRoot()


static void _init_f_isRoot_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRoot_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileInfo *)cls)->isRoot ());
}

static qt_gsi::GenericMethod *_create_f_isRoot_c0 ()
{
  return new qt_gsi::GenericMethod ("isRoot?", "@brief Method bool QFileInfo::isRoot()\n", true, &_init_f_isRoot_c0, &_call_f_isRoot_c0);
}

// bool QFileInfo::isSymLink()


static void _init_f_isSymLink_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSymLink_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileInfo *)cls)->isSymLink ());
}

static qt_gsi::GenericMethod *_create_f_isSymLink_c0 ()
{
  return new qt_gsi::GenericMethod ("isSymLink?", "@brief Method bool QFileInfo::isSymLink()\n", true, &_init_f_isSymLink_c0, &_call_f_isSymLink_c0);
}

// bool QFileInfo::isWritable()


static void _init_f_isWritable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWritable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileInfo *)cls)->isWritable ());
}

static qt_gsi::GenericMethod *_create_f_isWritable_c0 ()
{
  return new qt_gsi::GenericMethod ("isWritable?", "@brief Method bool QFileInfo::isWritable()\n", true, &_init_f_isWritable_c0, &_call_f_isWritable_c0);
}

// QDateTime QFileInfo::lastModified()


static void _init_f_lastModified_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDateTime > ();
}

static void _call_f_lastModified_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDateTime > ((QDateTime)((QFileInfo *)cls)->lastModified ());
}

static qt_gsi::GenericMethod *_create_f_lastModified_c0 ()
{
  return new qt_gsi::GenericMethod ("lastModified", "@brief Method QDateTime QFileInfo::lastModified()\n", true, &_init_f_lastModified_c0, &_call_f_lastModified_c0);
}

// QDateTime QFileInfo::lastRead()


static void _init_f_lastRead_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDateTime > ();
}

static void _call_f_lastRead_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDateTime > ((QDateTime)((QFileInfo *)cls)->lastRead ());
}

static qt_gsi::GenericMethod *_create_f_lastRead_c0 ()
{
  return new qt_gsi::GenericMethod ("lastRead", "@brief Method QDateTime QFileInfo::lastRead()\n", true, &_init_f_lastRead_c0, &_call_f_lastRead_c0);
}

// bool QFileInfo::makeAbsolute()


static void _init_f_makeAbsolute_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_makeAbsolute_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFileInfo *)cls)->makeAbsolute ());
}

static qt_gsi::GenericMethod *_create_f_makeAbsolute_0 ()
{
  return new qt_gsi::GenericMethod ("makeAbsolute", "@brief Method bool QFileInfo::makeAbsolute()\n", false, &_init_f_makeAbsolute_0, &_call_f_makeAbsolute_0);
}

// bool QFileInfo::operator!=(const QFileInfo &fileinfo)


static void _init_f_operator_excl__eq__2174 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileinfo");
  decl->add_arg<const QFileInfo & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__2174 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFileInfo &arg1 = args.read<const QFileInfo & > ();
  ret.write<bool > ((bool)((QFileInfo *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__2174 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QFileInfo::operator!=(const QFileInfo &fileinfo)\n", false, &_init_f_operator_excl__eq__2174, &_call_f_operator_excl__eq__2174);
}

// bool QFileInfo::operator!=(const QFileInfo &fileinfo)


static void _init_f_operator_excl__eq__c2174 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileinfo");
  decl->add_arg<const QFileInfo & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2174 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFileInfo &arg1 = args.read<const QFileInfo & > ();
  ret.write<bool > ((bool)((QFileInfo *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c2174 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QFileInfo::operator!=(const QFileInfo &fileinfo)\n", true, &_init_f_operator_excl__eq__c2174, &_call_f_operator_excl__eq__c2174);
}

// QFileInfo &QFileInfo::operator=(const QFileInfo &fileinfo)


static void _init_f_operator_eq__2174 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileinfo");
  decl->add_arg<const QFileInfo & > (argspec_0);
  decl->set_return<QFileInfo & > ();
}

static void _call_f_operator_eq__2174 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFileInfo &arg1 = args.read<const QFileInfo & > ();
  ret.write<QFileInfo & > ((QFileInfo &)((QFileInfo *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__2174 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QFileInfo &QFileInfo::operator=(const QFileInfo &fileinfo)\n", false, &_init_f_operator_eq__2174, &_call_f_operator_eq__2174);
}

// bool QFileInfo::operator==(const QFileInfo &fileinfo)


static void _init_f_operator_eq__eq__2174 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileinfo");
  decl->add_arg<const QFileInfo & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__2174 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFileInfo &arg1 = args.read<const QFileInfo & > ();
  ret.write<bool > ((bool)((QFileInfo *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__2174 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QFileInfo::operator==(const QFileInfo &fileinfo)\n", false, &_init_f_operator_eq__eq__2174, &_call_f_operator_eq__eq__2174);
}

// bool QFileInfo::operator==(const QFileInfo &fileinfo)


static void _init_f_operator_eq__eq__c2174 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileinfo");
  decl->add_arg<const QFileInfo & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2174 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFileInfo &arg1 = args.read<const QFileInfo & > ();
  ret.write<bool > ((bool)((QFileInfo *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c2174 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QFileInfo::operator==(const QFileInfo &fileinfo)\n", true, &_init_f_operator_eq__eq__c2174, &_call_f_operator_eq__eq__c2174);
}

// QString QFileInfo::owner()


static void _init_f_owner_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_owner_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileInfo *)cls)->owner ());
}

static qt_gsi::GenericMethod *_create_f_owner_c0 ()
{
  return new qt_gsi::GenericMethod ("owner", "@brief Method QString QFileInfo::owner()\n", true, &_init_f_owner_c0, &_call_f_owner_c0);
}

// unsigned int QFileInfo::ownerId()


static void _init_f_ownerId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_f_ownerId_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<unsigned int > ((unsigned int)((QFileInfo *)cls)->ownerId ());
}

static qt_gsi::GenericMethod *_create_f_ownerId_c0 ()
{
  return new qt_gsi::GenericMethod ("ownerId", "@brief Method unsigned int QFileInfo::ownerId()\n", true, &_init_f_ownerId_c0, &_call_f_ownerId_c0);
}

// QString QFileInfo::path()


static void _init_f_path_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_path_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileInfo *)cls)->path ());
}

static qt_gsi::GenericMethod *_create_f_path_c0 ()
{
  return new qt_gsi::GenericMethod ("path", "@brief Method QString QFileInfo::path()\n", true, &_init_f_path_c0, &_call_f_path_c0);
}

// bool QFileInfo::permission(QFlags<QFile::Permission> permissions)


static void _init_f_permission_c2778 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("permissions");
  decl->add_arg<const qt_gsi::Converter<QFlags<QFile::Permission> >::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_permission_c2778 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QFile::Permission> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QFile::Permission> >::target_type & > ();
  ret.write<bool > ((bool)((QFileInfo *)cls)->permission (qt_gsi::QtToCppAdaptor<QFlags<QFile::Permission> >(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_permission_c2778 ()
{
  return new qt_gsi::GenericMethod ("permission", "@brief Method bool QFileInfo::permission(QFlags<QFile::Permission> permissions)\n", true, &_init_f_permission_c2778, &_call_f_permission_c2778);
}

// QFlags<QFile::Permission> QFileInfo::permissions()


static void _init_f_permissions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QFile::Permission> >::target_type > ();
}

static void _call_f_permissions_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QFile::Permission> >::target_type > ((qt_gsi::Converter<QFlags<QFile::Permission> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QFile::Permission> >(((QFileInfo *)cls)->permissions ()));
}

static qt_gsi::GenericMethod *_create_f_permissions_c0 ()
{
  return new qt_gsi::GenericMethod ("permissions", "@brief Method QFlags<QFile::Permission> QFileInfo::permissions()\n", true, &_init_f_permissions_c0, &_call_f_permissions_c0);
}

// QString QFileInfo::readLink()


static void _init_f_readLink_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_readLink_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileInfo *)cls)->readLink ());
}

static qt_gsi::GenericMethod *_create_f_readLink_c0 ()
{
  return new qt_gsi::GenericMethod ("readLink", "@brief Method QString QFileInfo::readLink()\n", true, &_init_f_readLink_c0, &_call_f_readLink_c0);
}

// void QFileInfo::refresh()


static void _init_f_refresh_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_refresh_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFileInfo *)cls)->refresh ();
}

static qt_gsi::GenericMethod *_create_f_refresh_0 ()
{
  return new qt_gsi::GenericMethod ("refresh", "@brief Method void QFileInfo::refresh()\n", false, &_init_f_refresh_0, &_call_f_refresh_0);
}

// void QFileInfo::setCaching(bool on)


static void _init_f_setCaching_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("on");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCaching_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QFileInfo *)cls)->setCaching (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCaching_864 ()
{
  return new qt_gsi::GenericMethod ("setCaching|caching=", "@brief Method void QFileInfo::setCaching(bool on)\n", false, &_init_f_setCaching_864, &_call_f_setCaching_864);
}

// void QFileInfo::setFile(const QString &file)


static void _init_f_setFile_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("file");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFile_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QFileInfo *)cls)->setFile (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFile_2025 ()
{
  return new qt_gsi::GenericMethod ("setFile", "@brief Method void QFileInfo::setFile(const QString &file)\n", false, &_init_f_setFile_2025, &_call_f_setFile_2025);
}

// void QFileInfo::setFile(const QFile &file)


static void _init_f_setFile_1778 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("file");
  decl->add_arg<const QFile & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFile_1778 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFile &arg1 = args.read<const QFile & > ();
  ((QFileInfo *)cls)->setFile (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFile_1778 ()
{
  return new qt_gsi::GenericMethod ("setFile", "@brief Method void QFileInfo::setFile(const QFile &file)\n", false, &_init_f_setFile_1778, &_call_f_setFile_1778);
}

// void QFileInfo::setFile(const QDir &dir, const QString &file)


static void _init_f_setFile_3598 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir");
  decl->add_arg<const QDir & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("file");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFile_3598 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDir &arg1 = args.read<const QDir & > ();
  const QString &arg2 = args.read<const QString & > ();
  ((QFileInfo *)cls)->setFile (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setFile_3598 ()
{
  return new qt_gsi::GenericMethod ("setFile", "@brief Method void QFileInfo::setFile(const QDir &dir, const QString &file)\n", false, &_init_f_setFile_3598, &_call_f_setFile_3598);
}

// qint64 QFileInfo::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QFileInfo *)cls)->size ());
}

static qt_gsi::GenericMethod *_create_f_size_c0 ()
{
  return new qt_gsi::GenericMethod ("size", "@brief Method qint64 QFileInfo::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
}

// QString QFileInfo::suffix()


static void _init_f_suffix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_suffix_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileInfo *)cls)->suffix ());
}

static qt_gsi::GenericMethod *_create_f_suffix_c0 ()
{
  return new qt_gsi::GenericMethod ("suffix", "@brief Method QString QFileInfo::suffix()\n", true, &_init_f_suffix_c0, &_call_f_suffix_c0);
}

// QString QFileInfo::symLinkTarget()


static void _init_f_symLinkTarget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_symLinkTarget_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFileInfo *)cls)->symLinkTarget ());
}

static qt_gsi::GenericMethod *_create_f_symLinkTarget_c0 ()
{
  return new qt_gsi::GenericMethod ("symLinkTarget", "@brief Method QString QFileInfo::symLinkTarget()\n", true, &_init_f_symLinkTarget_c0, &_call_f_symLinkTarget_c0);
}


namespace gsi
{
gsi::Class<QFileInfo> decl_QFileInfo ("QFileInfo",
  gsi::Methods(_create_ctor_QFileInfo_0 ()) +
  gsi::Methods(_create_ctor_QFileInfo_2025 ()) +
  gsi::Methods(_create_ctor_QFileInfo_1778 ()) +
  gsi::Methods(_create_ctor_QFileInfo_3598 ()) +
  gsi::Methods(_create_ctor_QFileInfo_2174 ()) +
  gsi::Methods(_create_f_absoluteDir_c0 ()) +
  gsi::Methods(_create_f_absoluteFilePath_c0 ()) +
  gsi::Methods(_create_f_absolutePath_c0 ()) +
  gsi::Methods(_create_f_baseName_c0 ()) +
  gsi::Methods(_create_f_bundleName_c0 ()) +
  gsi::Methods(_create_f_caching_c0 ()) +
  gsi::Methods(_create_f_canonicalFilePath_c0 ()) +
  gsi::Methods(_create_f_canonicalPath_c0 ()) +
  gsi::Methods(_create_f_completeBaseName_c0 ()) +
  gsi::Methods(_create_f_completeSuffix_c0 ()) +
  gsi::Methods(_create_f_created_c0 ()) +
  gsi::Methods(_create_f_detach_0 ()) +
  gsi::Methods(_create_f_dir_c0 ()) +
  gsi::Methods(_create_f_exists_c0 ()) +
  gsi::Methods(_create_f_fileName_c0 ()) +
  gsi::Methods(_create_f_filePath_c0 ()) +
  gsi::Methods(_create_f_group_c0 ()) +
  gsi::Methods(_create_f_groupId_c0 ()) +
  gsi::Methods(_create_f_isAbsolute_c0 ()) +
  gsi::Methods(_create_f_isBundle_c0 ()) +
  gsi::Methods(_create_f_isDir_c0 ()) +
  gsi::Methods(_create_f_isExecutable_c0 ()) +
  gsi::Methods(_create_f_isFile_c0 ()) +
  gsi::Methods(_create_f_isHidden_c0 ()) +
  gsi::Methods(_create_f_isReadable_c0 ()) +
  gsi::Methods(_create_f_isRelative_c0 ()) +
  gsi::Methods(_create_f_isRoot_c0 ()) +
  gsi::Methods(_create_f_isSymLink_c0 ()) +
  gsi::Methods(_create_f_isWritable_c0 ()) +
  gsi::Methods(_create_f_lastModified_c0 ()) +
  gsi::Methods(_create_f_lastRead_c0 ()) +
  gsi::Methods(_create_f_makeAbsolute_0 ()) +
  gsi::Methods(_create_f_operator_excl__eq__2174 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c2174 ()) +
  gsi::Methods(_create_f_operator_eq__2174 ()) +
  gsi::Methods(_create_f_operator_eq__eq__2174 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c2174 ()) +
  gsi::Methods(_create_f_owner_c0 ()) +
  gsi::Methods(_create_f_ownerId_c0 ()) +
  gsi::Methods(_create_f_path_c0 ()) +
  gsi::Methods(_create_f_permission_c2778 ()) +
  gsi::Methods(_create_f_permissions_c0 ()) +
  gsi::Methods(_create_f_readLink_c0 ()) +
  gsi::Methods(_create_f_refresh_0 ()) +
  gsi::Methods(_create_f_setCaching_864 ()) +
  gsi::Methods(_create_f_setFile_2025 ()) +
  gsi::Methods(_create_f_setFile_1778 ()) +
  gsi::Methods(_create_f_setFile_3598 ()) +
  gsi::Methods(_create_f_size_c0 ()) +
  gsi::Methods(_create_f_suffix_c0 ()) +
  gsi::Methods(_create_f_symLinkTarget_c0 ()),
  "@qt\n@brief Binding of QFileInfo");

}

