
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCoreApplication.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQCoreApplication_EventAdaptor.h"
#include "gsiDeclQCoreApplication_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCoreApplication

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCoreApplication::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// bool QCoreApplication::filterEvent(void *message, long int *result)


static void _init_f_filterEvent_2477 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("message");
  decl->add_arg<void * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("result");
  decl->add_arg<long int * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_filterEvent_2477 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  void *arg1 = args.read<void * > ();
  long int *arg2 = args.read<long int * > ();
  ret.write<bool > ((bool)((QCoreApplication *)cls)->filterEvent (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_filterEvent_2477 ()
{
  return new qt_gsi::GenericMethod ("filterEvent", "@brief Method bool QCoreApplication::filterEvent(void *message, long int *result)\n", false, &_init_f_filterEvent_2477, &_call_f_filterEvent_2477);
}

// bool QCoreApplication::notify(QObject *, QEvent *)


static void _init_f_notify_2411 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_notify_2411 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QCoreApplication *)cls)->notify (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_notify_2411 ()
{
  return new qt_gsi::GenericMethod ("notify", "@brief Method bool QCoreApplication::notify(QObject *, QEvent *)\n", false, &_init_f_notify_2411, &_call_f_notify_2411);
}

// static void QCoreApplication::addLibraryPath(const QString &)


static void _init_f_addLibraryPath_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addLibraryPath_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QCoreApplication::addLibraryPath (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_addLibraryPath_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("addLibraryPath", "@brief Static method void QCoreApplication::addLibraryPath(const QString &)\nThis method is static and can be called without an instance.", &_init_f_addLibraryPath_2025, &_call_f_addLibraryPath_2025);
}

// static QString QCoreApplication::applicationDirPath()


static void _init_f_applicationDirPath_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_applicationDirPath_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)QCoreApplication::applicationDirPath ());
}

static qt_gsi::GenericStaticMethod *_create_f_applicationDirPath_0 ()
{
  return new qt_gsi::GenericStaticMethod ("applicationDirPath", "@brief Static method QString QCoreApplication::applicationDirPath()\nThis method is static and can be called without an instance.", &_init_f_applicationDirPath_0, &_call_f_applicationDirPath_0);
}

// static QString QCoreApplication::applicationFilePath()


static void _init_f_applicationFilePath_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_applicationFilePath_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)QCoreApplication::applicationFilePath ());
}

static qt_gsi::GenericStaticMethod *_create_f_applicationFilePath_0 ()
{
  return new qt_gsi::GenericStaticMethod ("applicationFilePath", "@brief Static method QString QCoreApplication::applicationFilePath()\nThis method is static and can be called without an instance.", &_init_f_applicationFilePath_0, &_call_f_applicationFilePath_0);
}

// static QString QCoreApplication::applicationName()


static void _init_f_applicationName_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_applicationName_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)QCoreApplication::applicationName ());
}

static qt_gsi::GenericStaticMethod *_create_f_applicationName_0 ()
{
  return new qt_gsi::GenericStaticMethod (":applicationName", "@brief Static method QString QCoreApplication::applicationName()\nThis method is static and can be called without an instance.", &_init_f_applicationName_0, &_call_f_applicationName_0);
}

// static qint64 QCoreApplication::applicationPid()


static void _init_f_applicationPid_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_applicationPid_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)QCoreApplication::applicationPid ());
}

static qt_gsi::GenericStaticMethod *_create_f_applicationPid_0 ()
{
  return new qt_gsi::GenericStaticMethod ("applicationPid", "@brief Static method qint64 QCoreApplication::applicationPid()\nThis method is static and can be called without an instance.", &_init_f_applicationPid_0, &_call_f_applicationPid_0);
}

// static QString QCoreApplication::applicationVersion()


static void _init_f_applicationVersion_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_applicationVersion_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)QCoreApplication::applicationVersion ());
}

static qt_gsi::GenericStaticMethod *_create_f_applicationVersion_0 ()
{
  return new qt_gsi::GenericStaticMethod (":applicationVersion", "@brief Static method QString QCoreApplication::applicationVersion()\nThis method is static and can be called without an instance.", &_init_f_applicationVersion_0, &_call_f_applicationVersion_0);
}

// static QStringList QCoreApplication::arguments()


static void _init_f_arguments_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_arguments_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(QCoreApplication::arguments ()));
}

static qt_gsi::GenericStaticMethod *_create_f_arguments_0 ()
{
  return new qt_gsi::GenericStaticMethod ("arguments", "@brief Static method QStringList QCoreApplication::arguments()\nThis method is static and can be called without an instance.", &_init_f_arguments_0, &_call_f_arguments_0);
}

// static bool QCoreApplication::closingDown()


static void _init_f_closingDown_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_closingDown_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)QCoreApplication::closingDown ());
}

static qt_gsi::GenericStaticMethod *_create_f_closingDown_0 ()
{
  return new qt_gsi::GenericStaticMethod ("closingDown", "@brief Static method bool QCoreApplication::closingDown()\nThis method is static and can be called without an instance.", &_init_f_closingDown_0, &_call_f_closingDown_0);
}

// static int QCoreApplication::exec()


static void _init_f_exec_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_exec_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)QCoreApplication::exec ());
}

static qt_gsi::GenericStaticMethod *_create_f_exec_0 ()
{
  return new qt_gsi::GenericStaticMethod ("exec", "@brief Static method int QCoreApplication::exec()\nThis method is static and can be called without an instance.", &_init_f_exec_0, &_call_f_exec_0);
}

// static void QCoreApplication::exit(int retcode)


static void _init_f_exit_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("retcode", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_exit_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(0);
  QCoreApplication::exit (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_exit_767 ()
{
  return new qt_gsi::GenericStaticMethod ("exit", "@brief Static method void QCoreApplication::exit(int retcode)\nThis method is static and can be called without an instance.", &_init_f_exit_767, &_call_f_exit_767);
}

// static void QCoreApplication::flush()


static void _init_f_flush_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_flush_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCoreApplication::flush ();
}

static qt_gsi::GenericStaticMethod *_create_f_flush_0 ()
{
  return new qt_gsi::GenericStaticMethod ("flush", "@brief Static method void QCoreApplication::flush()\nThis method is static and can be called without an instance.", &_init_f_flush_0, &_call_f_flush_0);
}

// static bool QCoreApplication::hasPendingEvents()


static void _init_f_hasPendingEvents_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasPendingEvents_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)QCoreApplication::hasPendingEvents ());
}

static qt_gsi::GenericStaticMethod *_create_f_hasPendingEvents_0 ()
{
  return new qt_gsi::GenericStaticMethod ("hasPendingEvents", "@brief Static method bool QCoreApplication::hasPendingEvents()\nThis method is static and can be called without an instance.", &_init_f_hasPendingEvents_0, &_call_f_hasPendingEvents_0);
}

// static void QCoreApplication::installTranslator(QTranslator *messageFile)


static void _init_f_installTranslator_1769 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("messageFile");
  decl->add_arg<QTranslator * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_installTranslator_1769 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTranslator *arg1 = args.read<QTranslator * > ();
  QCoreApplication::installTranslator (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_installTranslator_1769 ()
{
  return new qt_gsi::GenericStaticMethod ("installTranslator", "@brief Static method void QCoreApplication::installTranslator(QTranslator *messageFile)\nThis method is static and can be called without an instance.", &_init_f_installTranslator_1769, &_call_f_installTranslator_1769);
}

// static QCoreApplication *QCoreApplication::instance()


static void _init_f_instance_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QCoreApplication * > ();
}

static void _call_f_instance_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QCoreApplication * > ((QCoreApplication *)QCoreApplication::instance ());
}

static qt_gsi::GenericStaticMethod *_create_f_instance_0 ()
{
  return new qt_gsi::GenericStaticMethod ("instance", "@brief Static method QCoreApplication *QCoreApplication::instance()\nThis method is static and can be called without an instance.", &_init_f_instance_0, &_call_f_instance_0);
}

// static QStringList QCoreApplication::libraryPaths()


static void _init_f_libraryPaths_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_libraryPaths_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(QCoreApplication::libraryPaths ()));
}

static qt_gsi::GenericStaticMethod *_create_f_libraryPaths_0 ()
{
  return new qt_gsi::GenericStaticMethod (":libraryPaths", "@brief Static method QStringList QCoreApplication::libraryPaths()\nThis method is static and can be called without an instance.", &_init_f_libraryPaths_0, &_call_f_libraryPaths_0);
}

// static QString QCoreApplication::organizationDomain()


static void _init_f_organizationDomain_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_organizationDomain_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)QCoreApplication::organizationDomain ());
}

static qt_gsi::GenericStaticMethod *_create_f_organizationDomain_0 ()
{
  return new qt_gsi::GenericStaticMethod (":organizationDomain", "@brief Static method QString QCoreApplication::organizationDomain()\nThis method is static and can be called without an instance.", &_init_f_organizationDomain_0, &_call_f_organizationDomain_0);
}

// static QString QCoreApplication::organizationName()


static void _init_f_organizationName_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_organizationName_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)QCoreApplication::organizationName ());
}

static qt_gsi::GenericStaticMethod *_create_f_organizationName_0 ()
{
  return new qt_gsi::GenericStaticMethod (":organizationName", "@brief Static method QString QCoreApplication::organizationName()\nThis method is static and can be called without an instance.", &_init_f_organizationName_0, &_call_f_organizationName_0);
}

// static void QCoreApplication::postEvent(QObject *receiver, QEvent *event)


static void _init_f_postEvent_2411 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_postEvent_2411 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  qt_gsi::qt_keep (arg2);
  QCoreApplication::postEvent (arg1, arg2);
}

static qt_gsi::GenericStaticMethod *_create_f_postEvent_2411 ()
{
  return new qt_gsi::GenericStaticMethod ("postEvent", "@brief Static method void QCoreApplication::postEvent(QObject *receiver, QEvent *event)\nThis method is static and can be called without an instance.", &_init_f_postEvent_2411, &_call_f_postEvent_2411);
}

// static void QCoreApplication::postEvent(QObject *receiver, QEvent *event, int priority)


static void _init_f_postEvent_3070 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("priority");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_postEvent_3070 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  qt_gsi::qt_keep (arg2);
  int arg3 = args.read<int > ();
  QCoreApplication::postEvent (arg1, arg2, arg3);
}

static qt_gsi::GenericStaticMethod *_create_f_postEvent_3070 ()
{
  return new qt_gsi::GenericStaticMethod ("postEvent", "@brief Static method void QCoreApplication::postEvent(QObject *receiver, QEvent *event, int priority)\nThis method is static and can be called without an instance.", &_init_f_postEvent_3070, &_call_f_postEvent_3070);
}

// static void QCoreApplication::processEvents(QFlags<QEventLoop::ProcessEventsFlag> flags)


static void _init_f_processEvents_3995 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags", true, "QEventLoop::AllEvents");
  decl->add_arg<const qt_gsi::Converter<QFlags<QEventLoop::ProcessEventsFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_processEvents_3995 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QEventLoop::ProcessEventsFlag> >::target_type & arg1 = args ? args.read<const qt_gsi::Converter<QFlags<QEventLoop::ProcessEventsFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QEventLoop::ProcessEventsFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QEventLoop::ProcessEventsFlag> >(heap, QEventLoop::AllEvents));
  QCoreApplication::processEvents (qt_gsi::QtToCppAdaptor<QFlags<QEventLoop::ProcessEventsFlag> >(arg1).cref());
}

static qt_gsi::GenericStaticMethod *_create_f_processEvents_3995 ()
{
  return new qt_gsi::GenericStaticMethod ("processEvents", "@brief Static method void QCoreApplication::processEvents(QFlags<QEventLoop::ProcessEventsFlag> flags)\nThis method is static and can be called without an instance.", &_init_f_processEvents_3995, &_call_f_processEvents_3995);
}

// static void QCoreApplication::processEvents(QFlags<QEventLoop::ProcessEventsFlag> flags, int maxtime)


static void _init_f_processEvents_4654 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<QEventLoop::ProcessEventsFlag> >::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("maxtime");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_processEvents_4654 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QEventLoop::ProcessEventsFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QEventLoop::ProcessEventsFlag> >::target_type & > ();
  int arg2 = args.read<int > ();
  QCoreApplication::processEvents (qt_gsi::QtToCppAdaptor<QFlags<QEventLoop::ProcessEventsFlag> >(arg1).cref(), arg2);
}

static qt_gsi::GenericStaticMethod *_create_f_processEvents_4654 ()
{
  return new qt_gsi::GenericStaticMethod ("processEvents", "@brief Static method void QCoreApplication::processEvents(QFlags<QEventLoop::ProcessEventsFlag> flags, int maxtime)\nThis method is static and can be called without an instance.", &_init_f_processEvents_4654, &_call_f_processEvents_4654);
}

// static void QCoreApplication::quit()


static void _init_f_quit_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_quit_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCoreApplication::quit ();
}

static qt_gsi::GenericStaticMethod *_create_f_quit_0 ()
{
  return new qt_gsi::GenericStaticMethod ("quit", "@brief Static method void QCoreApplication::quit()\nThis method is static and can be called without an instance.", &_init_f_quit_0, &_call_f_quit_0);
}

// static void QCoreApplication::removeLibraryPath(const QString &)


static void _init_f_removeLibraryPath_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeLibraryPath_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QCoreApplication::removeLibraryPath (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_removeLibraryPath_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("removeLibraryPath", "@brief Static method void QCoreApplication::removeLibraryPath(const QString &)\nThis method is static and can be called without an instance.", &_init_f_removeLibraryPath_2025, &_call_f_removeLibraryPath_2025);
}

// static void QCoreApplication::removePostedEvents(QObject *receiver)


static void _init_f_removePostedEvents_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removePostedEvents_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QCoreApplication::removePostedEvents (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_removePostedEvents_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("removePostedEvents", "@brief Static method void QCoreApplication::removePostedEvents(QObject *receiver)\nThis method is static and can be called without an instance.", &_init_f_removePostedEvents_1302, &_call_f_removePostedEvents_1302);
}

// static void QCoreApplication::removePostedEvents(QObject *receiver, int eventType)


static void _init_f_removePostedEvents_1961 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("eventType");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_removePostedEvents_1961 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  int arg2 = args.read<int > ();
  QCoreApplication::removePostedEvents (arg1, arg2);
}

static qt_gsi::GenericStaticMethod *_create_f_removePostedEvents_1961 ()
{
  return new qt_gsi::GenericStaticMethod ("removePostedEvents", "@brief Static method void QCoreApplication::removePostedEvents(QObject *receiver, int eventType)\nThis method is static and can be called without an instance.", &_init_f_removePostedEvents_1961, &_call_f_removePostedEvents_1961);
}

// static void QCoreApplication::removeTranslator(QTranslator *messageFile)


static void _init_f_removeTranslator_1769 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("messageFile");
  decl->add_arg<QTranslator * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeTranslator_1769 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTranslator *arg1 = args.read<QTranslator * > ();
  QCoreApplication::removeTranslator (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_removeTranslator_1769 ()
{
  return new qt_gsi::GenericStaticMethod ("removeTranslator", "@brief Static method void QCoreApplication::removeTranslator(QTranslator *messageFile)\nThis method is static and can be called without an instance.", &_init_f_removeTranslator_1769, &_call_f_removeTranslator_1769);
}

// static bool QCoreApplication::sendEvent(QObject *receiver, QEvent *event)


static void _init_f_sendEvent_2411 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_sendEvent_2411 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)QCoreApplication::sendEvent (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_sendEvent_2411 ()
{
  return new qt_gsi::GenericStaticMethod ("sendEvent", "@brief Static method bool QCoreApplication::sendEvent(QObject *receiver, QEvent *event)\nThis method is static and can be called without an instance.", &_init_f_sendEvent_2411, &_call_f_sendEvent_2411);
}

// static void QCoreApplication::sendPostedEvents(QObject *receiver, int event_type)


static void _init_f_sendPostedEvents_1961 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event_type");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_sendPostedEvents_1961 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  int arg2 = args.read<int > ();
  QCoreApplication::sendPostedEvents (arg1, arg2);
}

static qt_gsi::GenericStaticMethod *_create_f_sendPostedEvents_1961 ()
{
  return new qt_gsi::GenericStaticMethod ("sendPostedEvents", "@brief Static method void QCoreApplication::sendPostedEvents(QObject *receiver, int event_type)\nThis method is static and can be called without an instance.", &_init_f_sendPostedEvents_1961, &_call_f_sendPostedEvents_1961);
}

// static void QCoreApplication::sendPostedEvents()


static void _init_f_sendPostedEvents_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_sendPostedEvents_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCoreApplication::sendPostedEvents ();
}

static qt_gsi::GenericStaticMethod *_create_f_sendPostedEvents_0 ()
{
  return new qt_gsi::GenericStaticMethod ("sendPostedEvents", "@brief Static method void QCoreApplication::sendPostedEvents()\nThis method is static and can be called without an instance.", &_init_f_sendPostedEvents_0, &_call_f_sendPostedEvents_0);
}

// static void QCoreApplication::setApplicationName(const QString &application)


static void _init_f_setApplicationName_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("application");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setApplicationName_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QCoreApplication::setApplicationName (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setApplicationName_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("setApplicationName|applicationName=", "@brief Static method void QCoreApplication::setApplicationName(const QString &application)\nThis method is static and can be called without an instance.", &_init_f_setApplicationName_2025, &_call_f_setApplicationName_2025);
}

// static void QCoreApplication::setApplicationVersion(const QString &version)


static void _init_f_setApplicationVersion_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("version");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setApplicationVersion_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QCoreApplication::setApplicationVersion (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setApplicationVersion_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("setApplicationVersion|applicationVersion=", "@brief Static method void QCoreApplication::setApplicationVersion(const QString &version)\nThis method is static and can be called without an instance.", &_init_f_setApplicationVersion_2025, &_call_f_setApplicationVersion_2025);
}

// static void QCoreApplication::setAttribute(Qt::ApplicationAttribute attribute, bool on)


static void _init_f_setAttribute_3593 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("attribute");
  decl->add_arg<const qt_gsi::Converter<Qt::ApplicationAttribute>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setAttribute_3593 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::ApplicationAttribute>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::ApplicationAttribute>::target_type & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  QCoreApplication::setAttribute (qt_gsi::QtToCppAdaptor<Qt::ApplicationAttribute>(arg1).cref(), arg2);
}

static qt_gsi::GenericStaticMethod *_create_f_setAttribute_3593 ()
{
  return new qt_gsi::GenericStaticMethod ("setAttribute", "@brief Static method void QCoreApplication::setAttribute(Qt::ApplicationAttribute attribute, bool on)\nThis method is static and can be called without an instance.", &_init_f_setAttribute_3593, &_call_f_setAttribute_3593);
}

// static void QCoreApplication::setLibraryPaths(const QStringList &)


static void _init_f_setLibraryPaths_2437 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLibraryPaths_2437 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  QCoreApplication::setLibraryPaths (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref());
}

static qt_gsi::GenericStaticMethod *_create_f_setLibraryPaths_2437 ()
{
  return new qt_gsi::GenericStaticMethod ("setLibraryPaths|libraryPaths=", "@brief Static method void QCoreApplication::setLibraryPaths(const QStringList &)\nThis method is static and can be called without an instance.", &_init_f_setLibraryPaths_2437, &_call_f_setLibraryPaths_2437);
}

// static void QCoreApplication::setOrganizationDomain(const QString &orgDomain)


static void _init_f_setOrganizationDomain_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orgDomain");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOrganizationDomain_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QCoreApplication::setOrganizationDomain (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setOrganizationDomain_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("setOrganizationDomain|organizationDomain=", "@brief Static method void QCoreApplication::setOrganizationDomain(const QString &orgDomain)\nThis method is static and can be called without an instance.", &_init_f_setOrganizationDomain_2025, &_call_f_setOrganizationDomain_2025);
}

// static void QCoreApplication::setOrganizationName(const QString &orgName)


static void _init_f_setOrganizationName_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("orgName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOrganizationName_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QCoreApplication::setOrganizationName (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setOrganizationName_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("setOrganizationName|organizationName=", "@brief Static method void QCoreApplication::setOrganizationName(const QString &orgName)\nThis method is static and can be called without an instance.", &_init_f_setOrganizationName_2025, &_call_f_setOrganizationName_2025);
}

// static bool QCoreApplication::startingUp()


static void _init_f_startingUp_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_startingUp_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)QCoreApplication::startingUp ());
}

static qt_gsi::GenericStaticMethod *_create_f_startingUp_0 ()
{
  return new qt_gsi::GenericStaticMethod ("startingUp", "@brief Static method bool QCoreApplication::startingUp()\nThis method is static and can be called without an instance.", &_init_f_startingUp_0, &_call_f_startingUp_0);
}

// static bool QCoreApplication::testAttribute(Qt::ApplicationAttribute attribute)


static void _init_f_testAttribute_2837 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("attribute");
  decl->add_arg<const qt_gsi::Converter<Qt::ApplicationAttribute>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testAttribute_2837 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::ApplicationAttribute>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::ApplicationAttribute>::target_type & > ();
  ret.write<bool > ((bool)QCoreApplication::testAttribute (qt_gsi::QtToCppAdaptor<Qt::ApplicationAttribute>(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_testAttribute_2837 ()
{
  return new qt_gsi::GenericStaticMethod ("testAttribute", "@brief Static method bool QCoreApplication::testAttribute(Qt::ApplicationAttribute attribute)\nThis method is static and can be called without an instance.", &_init_f_testAttribute_2837, &_call_f_testAttribute_2837);
}

// static QString QCoreApplication::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QCoreApplication::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCoreApplication::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QCoreApplication::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QCoreApplication::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCoreApplication::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QCoreApplication::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QCoreApplication::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCoreApplication::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QCoreApplication::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QCoreApplication::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCoreApplication::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

// static QString QCoreApplication::translate(const char *context, const char *key, const char *disambiguation, QCoreApplication::Encoding encoding)


static void _init_f_translate_7842 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("context");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("key");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("disambiguation", true, "0");
  decl->add_arg<const char * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("encoding", true, "QCoreApplication::CodecForTr");
  decl->add_arg<const qt_gsi::Converter<QCoreApplication::Encoding>::target_type & > (argspec_3);
  decl->set_return<QString > ();
}

static void _call_f_translate_7842 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  const char *arg3 = args ? args.read<const char * > () : (const char *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QCoreApplication::Encoding>::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QCoreApplication::Encoding>::target_type & > () : (const qt_gsi::Converter<QCoreApplication::Encoding>::target_type &)(qt_gsi::CppToQtReadAdaptor<QCoreApplication::Encoding>(heap, QCoreApplication::CodecForTr));
  ret.write<QString > ((QString)QCoreApplication::translate (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QCoreApplication::Encoding>(arg4).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_translate_7842 ()
{
  return new qt_gsi::GenericStaticMethod ("translate", "@brief Static method QString QCoreApplication::translate(const char *context, const char *key, const char *disambiguation, QCoreApplication::Encoding encoding)\nThis method is static and can be called without an instance.", &_init_f_translate_7842, &_call_f_translate_7842);
}

// static QString QCoreApplication::translate(const char *context, const char *key, const char *disambiguation, QCoreApplication::Encoding encoding, int n)


static void _init_f_translate_8501 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("context");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("key");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("disambiguation");
  decl->add_arg<const char * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("encoding");
  decl->add_arg<const qt_gsi::Converter<QCoreApplication::Encoding>::target_type & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("n");
  decl->add_arg<int > (argspec_4);
  decl->set_return<QString > ();
}

static void _call_f_translate_8501 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  const char *arg3 = args.read<const char * > ();
  const qt_gsi::Converter<QCoreApplication::Encoding>::target_type & arg4 = args.read<const qt_gsi::Converter<QCoreApplication::Encoding>::target_type & > ();
  int arg5 = args.read<int > ();
  ret.write<QString > ((QString)QCoreApplication::translate (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QCoreApplication::Encoding>(arg4).cref(), arg5));
}

static qt_gsi::GenericStaticMethod *_create_f_translate_8501 ()
{
  return new qt_gsi::GenericStaticMethod ("translate", "@brief Static method QString QCoreApplication::translate(const char *context, const char *key, const char *disambiguation, QCoreApplication::Encoding encoding, int n)\nThis method is static and can be called without an instance.", &_init_f_translate_8501, &_call_f_translate_8501);
}

static qt_gsi::QObjectConnector<QCoreApplication, QCoreApplication_EventAdaptor> ea_QCoreApplication;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QCoreApplication> decl_QCoreApplication (ea_QCoreApplication, decl_QObject, "QCoreApplication_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_filterEvent_2477 ()) +
  gsi::Methods(_create_f_notify_2411 ()) +
  qt_gsi::qt_signal<QCoreApplication, QCoreApplication_EventAdaptor> ("aboutToQuit", &QCoreApplication_EventAdaptor::aboutToQuit_e_0, "@brief Signal declaration for QCoreApplication::aboutToQuit()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QCoreApplication, QCoreApplication_EventAdaptor, QObject *> ("destroyed", &QCoreApplication_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QCoreApplication::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QCoreApplication, QCoreApplication_EventAdaptor, int> ("unixSignal", &QCoreApplication_EventAdaptor::unixSignal_e_767, gsi::arg("arg1"), "@brief Signal declaration for QCoreApplication::unixSignal(int)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_addLibraryPath_2025 ()) +
  gsi::Methods(_create_f_applicationDirPath_0 ()) +
  gsi::Methods(_create_f_applicationFilePath_0 ()) +
  gsi::Methods(_create_f_applicationName_0 ()) +
  gsi::Methods(_create_f_applicationPid_0 ()) +
  gsi::Methods(_create_f_applicationVersion_0 ()) +
  gsi::Methods(_create_f_arguments_0 ()) +
  gsi::Methods(_create_f_closingDown_0 ()) +
  gsi::Methods(_create_f_exec_0 ()) +
  gsi::Methods(_create_f_exit_767 ()) +
  gsi::Methods(_create_f_flush_0 ()) +
  gsi::Methods(_create_f_hasPendingEvents_0 ()) +
  gsi::Methods(_create_f_installTranslator_1769 ()) +
  gsi::Methods(_create_f_instance_0 ()) +
  gsi::Methods(_create_f_libraryPaths_0 ()) +
  gsi::Methods(_create_f_organizationDomain_0 ()) +
  gsi::Methods(_create_f_organizationName_0 ()) +
  gsi::Methods(_create_f_postEvent_2411 ()) +
  gsi::Methods(_create_f_postEvent_3070 ()) +
  gsi::Methods(_create_f_processEvents_3995 ()) +
  gsi::Methods(_create_f_processEvents_4654 ()) +
  gsi::Methods(_create_f_quit_0 ()) +
  gsi::Methods(_create_f_removeLibraryPath_2025 ()) +
  gsi::Methods(_create_f_removePostedEvents_1302 ()) +
  gsi::Methods(_create_f_removePostedEvents_1961 ()) +
  gsi::Methods(_create_f_removeTranslator_1769 ()) +
  gsi::Methods(_create_f_sendEvent_2411 ()) +
  gsi::Methods(_create_f_sendPostedEvents_1961 ()) +
  gsi::Methods(_create_f_sendPostedEvents_0 ()) +
  gsi::Methods(_create_f_setApplicationName_2025 ()) +
  gsi::Methods(_create_f_setApplicationVersion_2025 ()) +
  gsi::Methods(_create_f_setAttribute_3593 ()) +
  gsi::Methods(_create_f_setLibraryPaths_2437 ()) +
  gsi::Methods(_create_f_setOrganizationDomain_2025 ()) +
  gsi::Methods(_create_f_setOrganizationName_2025 ()) +
  gsi::Methods(_create_f_startingUp_0 ()) +
  gsi::Methods(_create_f_testAttribute_2837 ()) +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()) +
  gsi::Methods(_create_f_translate_7842 ()) +
  gsi::Methods(_create_f_translate_8501 ()),
  "@hide\n@alias QCoreApplication");
}


class QCoreApplication_Adaptor : public QCoreApplication, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCoreApplication_Adaptor();

  //  int QCoreApplication::receivers(const char *signal)
  int fp_QCoreApplication_receivers_c1731 (const char *signal) const {
    return QCoreApplication::receivers(signal);
  }

  //  QObject *QCoreApplication::sender()
  QObject * fp_QCoreApplication_sender_c0 () const {
    return QCoreApplication::sender();
  }

  //  [adaptor impl] bool QCoreApplication::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QCoreApplication::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCoreApplication_Adaptor, bool, QObject *, QEvent *>(&QCoreApplication_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QCoreApplication::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QCoreApplication::notify(QObject *, QEvent *)
  bool cbs_notify_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QCoreApplication::notify(arg1, arg2);
  }

  virtual bool notify(QObject *arg1, QEvent *arg2)
  {
    if (cb_notify_2411_0.can_issue()) {
      return cb_notify_2411_0.issue<QCoreApplication_Adaptor, bool, QObject *, QEvent *>(&QCoreApplication_Adaptor::cbs_notify_2411_0, arg1, arg2);
    } else {
      return QCoreApplication::notify(arg1, arg2);
    }
  }

  //  [adaptor impl] void QCoreApplication::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QCoreApplication::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCoreApplication_Adaptor, QChildEvent *>(&QCoreApplication_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QCoreApplication::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QCoreApplication::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QCoreApplication::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCoreApplication_Adaptor, QEvent *>(&QCoreApplication_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QCoreApplication::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QCoreApplication::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QCoreApplication::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QCoreApplication_Adaptor, const char *>(&QCoreApplication_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QCoreApplication::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QCoreApplication::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QCoreApplication::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCoreApplication_Adaptor, bool, QEvent *>(&QCoreApplication_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QCoreApplication::event(arg1);
    }
  }

  //  [adaptor impl] void QCoreApplication::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QCoreApplication::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCoreApplication_Adaptor, QTimerEvent *>(&QCoreApplication_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QCoreApplication::timerEvent(arg1);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_notify_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QCoreApplication_Adaptor::~QCoreApplication_Adaptor() { }

// int QCoreApplication::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QCoreApplication_Adaptor *)cls)->fp_QCoreApplication_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QCoreApplication::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QCoreApplication::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QCoreApplication_Adaptor *)cls)->fp_QCoreApplication_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QCoreApplication::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QCoreApplication::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QCoreApplication_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCoreApplication_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QCoreApplication::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// bool QCoreApplication::notify(QObject *, QEvent *)

static void _init_cbs_notify_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_notify_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QCoreApplication_Adaptor *)cls)->cbs_notify_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_notify_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCoreApplication_Adaptor *)cls)->cb_notify_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_notify_2411_0 ()
{
  return new qt_gsi::GenericMethod ("notify", "@hide", false, &_init_cbs_notify_2411_0, &_call_cbs_notify_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_notify_2411_0 ()
{
  return new qt_gsi::GenericMethod ("notify", "@brief Virtual method bool QCoreApplication::notify(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_notify_2411_0, &_call_cbs_notify_2411_0, &_set_callback_cbs_notify_2411_0);
}


// void QCoreApplication::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QCoreApplication_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCoreApplication_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCoreApplication::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QCoreApplication::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QCoreApplication_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCoreApplication_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCoreApplication::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QCoreApplication::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QCoreApplication_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QCoreApplication_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCoreApplication::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// bool QCoreApplication::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QCoreApplication_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCoreApplication_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QCoreApplication::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QCoreApplication::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QCoreApplication_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCoreApplication_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCoreApplication::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QCoreApplication> decl_QCoreApplication;

gsi::Class<QCoreApplication_Adaptor> decl_QCoreApplication_Adaptor (decl_QCoreApplication, "QCoreApplication",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_notify_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_notify_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()),
  "@qt\n@brief Binding of QCoreApplication");

}


//  Implementation of the enum wrapper class for QCoreApplication::Encoding
namespace qt_gsi
{

static QCoreApplication_Encoding_Enum *c_1_QCoreApplication_Encoding_Enum () { return new QCoreApplication_Encoding_Enum (QCoreApplication::CodecForTr); }
static QCoreApplication_Encoding_Enum *c_2_QCoreApplication_Encoding_Enum () { return new QCoreApplication_Encoding_Enum (QCoreApplication::UnicodeUTF8); }
static QCoreApplication_Encoding_Enum *c_3_QCoreApplication_Encoding_Enum () { return new QCoreApplication_Encoding_Enum (QCoreApplication::DefaultCodec); }

static gsi::Methods mkdefs_QCoreApplication_Encoding () {
  return
    gsi::constant ("CodecForTr", &qt_gsi::c_1_QCoreApplication_Encoding_Enum, "@brief Enum constant QCoreApplication::CodecForTr") +
    gsi::constant ("UnicodeUTF8", &qt_gsi::c_2_QCoreApplication_Encoding_Enum, "@brief Enum constant QCoreApplication::UnicodeUTF8") +
    gsi::constant ("DefaultCodec", &qt_gsi::c_3_QCoreApplication_Encoding_Enum, "@brief Enum constant QCoreApplication::DefaultCodec");
}

static std::string to_s_QCoreApplication_Encoding_Enum (const QCoreApplication_Encoding_Enum *e)
{
  if (e->value () == QCoreApplication::CodecForTr) { return tl::sprintf ("CodecForTr (%u)", (unsigned int) e->value ()); }
  if (e->value () == QCoreApplication::UnicodeUTF8) { return tl::sprintf ("UnicodeUTF8 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QCoreApplication::DefaultCodec) { return tl::sprintf ("DefaultCodec (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QCoreApplication_Encoding_Enum (const QCoreApplication_Encoding_Enum *e)
{
  return (unsigned int) e->value ();
}

static QCoreApplication_Encoding_Enum *from_i_QCoreApplication_Encoding_Enum (unsigned int i)
{
  return new QCoreApplication_Encoding_Enum ((QCoreApplication::Encoding) i);
}

static bool equalQCoreApplication_Encoding_Enum (const QCoreApplication_Encoding_Enum *e, QCoreApplication_Encoding_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QCoreApplication_Encoding_Enum (const QCoreApplication_Encoding_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QCoreApplication_Encoding_Enums oropQCoreApplication_Encoding_Enums (const QCoreApplication_Encoding_Enums *e, const QCoreApplication_Encoding_Enums &d)
{
  return e->flags () | d.flags ();
}

static QCoreApplication_Encoding_Enums andopQCoreApplication_Encoding_Enums (const QCoreApplication_Encoding_Enums *e, const QCoreApplication_Encoding_Enums &d)
{
  return e->flags () & d.flags ();
}

static QCoreApplication_Encoding_Enums xoropQCoreApplication_Encoding_Enums (const QCoreApplication_Encoding_Enums *e, const QCoreApplication_Encoding_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QCoreApplication_Encoding_Enums (const QCoreApplication_Encoding_Enums *e)
{
  std::string l;
  if (e->testFlag (QCoreApplication::CodecForTr)) { if (!l.empty ()) l += "|"; l += "CodecForTr"; }
  if (e->testFlag (QCoreApplication::UnicodeUTF8)) { if (!l.empty ()) l += "|"; l += "UnicodeUTF8"; }
  if (e->testFlag (QCoreApplication::DefaultCodec)) { if (!l.empty ()) l += "|"; l += "DefaultCodec"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QCoreApplication_Encoding_Enums (const QCoreApplication_Encoding_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QCoreApplication_Encoding_Enums (const QCoreApplication_Encoding_Enums *e, const QCoreApplication_Encoding_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QCoreApplication_Encoding_Enums> decl_QCoreApplication_Encoding_Enums ("QCoreApplication_QFlags_Encoding",
  gsi::method_ext ("|", &qt_gsi::oropQCoreApplication_Encoding_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQCoreApplication_Encoding_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQCoreApplication_Encoding_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QCoreApplication_Encoding_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QCoreApplication_Encoding_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QCoreApplication_Encoding_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QCoreApplication::Encoding> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QCoreApplication_Encoding_Enum> decl_QCoreApplication_Encoding_Enum (decl_QCoreApplication_Encoding_Enums, "QCoreApplication_Encoding",
  qt_gsi::mkdefs_QCoreApplication_Encoding () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QCoreApplication_Encoding_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QCoreApplication_Encoding_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQCoreApplication_Encoding_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QCoreApplication_Encoding_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QCoreApplication_Encoding_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QCoreApplication::Encoding enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QCoreApplication> inject_QCoreApplication_Encoding_Enum_in_parent (qt_gsi::mkdefs_QCoreApplication_Encoding ());
static gsi::ClassExt<QCoreApplication> decl_QCoreApplication_Encoding_Enum_as_child (decl_QCoreApplication_Encoding_Enum, "Encoding");

}

