
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCheckBox.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQCheckBox_EventAdaptor.h"
#include "gsiDeclQCheckBox_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCheckBox

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCheckBox::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// Qt::CheckState QCheckBox::checkState()


static void _init_f_checkState_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::CheckState>::target_type > ();
}

static void _call_f_checkState_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::CheckState>::target_type > ((qt_gsi::Converter<Qt::CheckState>::target_type)qt_gsi::CppToQtAdaptor<Qt::CheckState>(((QCheckBox *)cls)->checkState ()));
}

static qt_gsi::GenericMethod *_create_f_checkState_c0 ()
{
  return new qt_gsi::GenericMethod (":checkState", "@brief Method Qt::CheckState QCheckBox::checkState()\n", true, &_init_f_checkState_c0, &_call_f_checkState_c0);
}

// bool QCheckBox::isTristate()


static void _init_f_isTristate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isTristate_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QCheckBox *)cls)->isTristate ());
}

static qt_gsi::GenericMethod *_create_f_isTristate_c0 ()
{
  return new qt_gsi::GenericMethod ("isTristate?|:tristate", "@brief Method bool QCheckBox::isTristate()\n", true, &_init_f_isTristate_c0, &_call_f_isTristate_c0);
}

// void QCheckBox::setCheckState(Qt::CheckState state)


static void _init_f_setCheckState_1740 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const qt_gsi::Converter<Qt::CheckState>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCheckState_1740 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::CheckState>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::CheckState>::target_type & > ();
  ((QCheckBox *)cls)->setCheckState (qt_gsi::QtToCppAdaptor<Qt::CheckState>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setCheckState_1740 ()
{
  return new qt_gsi::GenericMethod ("setCheckState|checkState=", "@brief Method void QCheckBox::setCheckState(Qt::CheckState state)\n", false, &_init_f_setCheckState_1740, &_call_f_setCheckState_1740);
}

// void QCheckBox::setTristate(bool y)


static void _init_f_setTristate_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("y", true, "true");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTristate_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  ((QCheckBox *)cls)->setTristate (arg1);
}

static qt_gsi::GenericMethod *_create_f_setTristate_864 ()
{
  return new qt_gsi::GenericMethod ("setTristate|tristate=", "@brief Method void QCheckBox::setTristate(bool y)\n", false, &_init_f_setTristate_864, &_call_f_setTristate_864);
}

// QSize QCheckBox::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QCheckBox *)cls)->sizeHint ());
}

static qt_gsi::GenericMethod *_create_f_sizeHint_c0 ()
{
  return new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QCheckBox::sizeHint()\nThis is a reimplementation of QWidget::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
}

// static QString QCheckBox::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QCheckBox::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCheckBox::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QCheckBox::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QCheckBox::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCheckBox::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QCheckBox::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QCheckBox::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCheckBox::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QCheckBox::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QCheckBox::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCheckBox::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QCheckBox, QCheckBox_EventAdaptor> ea_QCheckBox;

namespace gsi
{
extern gsi::Class<QAbstractButton> decl_QAbstractButton;

gsi::Class<QCheckBox> decl_QCheckBox (ea_QCheckBox, decl_QAbstractButton, "QCheckBox_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_checkState_c0 ()) +
  gsi::Methods(_create_f_isTristate_c0 ()) +
  gsi::Methods(_create_f_setCheckState_1740 ()) +
  gsi::Methods(_create_f_setTristate_864 ()) +
  gsi::Methods(_create_f_sizeHint_c0 ()) +
  qt_gsi::qt_signal<QCheckBox, QCheckBox_EventAdaptor, bool> ("clicked", &QCheckBox_EventAdaptor::clicked_e_864, gsi::arg("checked"), "@brief Signal declaration for QCheckBox::clicked(bool checked)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QCheckBox, QCheckBox_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QCheckBox_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QCheckBox::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QCheckBox, QCheckBox_EventAdaptor, QObject *> ("destroyed", &QCheckBox_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QCheckBox::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QCheckBox, QCheckBox_EventAdaptor> ("pressed", &QCheckBox_EventAdaptor::pressed_e_0, "@brief Signal declaration for QCheckBox::pressed()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QCheckBox, QCheckBox_EventAdaptor> ("released", &QCheckBox_EventAdaptor::released_e_0, "@brief Signal declaration for QCheckBox::released()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QCheckBox, QCheckBox_EventAdaptor, int> ("stateChanged", &QCheckBox_EventAdaptor::stateChanged_e_767, gsi::arg("arg1"), "@brief Signal declaration for QCheckBox::stateChanged(int)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QCheckBox, QCheckBox_EventAdaptor, bool> ("toggled", &QCheckBox_EventAdaptor::toggled_e_864, gsi::arg("checked"), "@brief Signal declaration for QCheckBox::toggled(bool checked)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QCheckBox");
}


class QCheckBox_Adaptor : public QCheckBox, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCheckBox_Adaptor();

  //  [adaptor ctor] QCheckBox::QCheckBox(QWidget *parent)
  QCheckBox_Adaptor() : QCheckBox()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCheckBox::QCheckBox(QWidget *parent)
  QCheckBox_Adaptor(QWidget *parent) : QCheckBox(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCheckBox::QCheckBox(const QString &text, QWidget *parent)
  QCheckBox_Adaptor(const QString &text) : QCheckBox(text)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCheckBox::QCheckBox(const QString &text, QWidget *parent)
  QCheckBox_Adaptor(const QString &text, QWidget *parent) : QCheckBox(text, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QCheckBox::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QCheckBox_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QCheckBox::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QCheckBox::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QCheckBox_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QCheckBox::destroy(destroyWindow, destroySubWindows);
  }

  //  bool QCheckBox::focusNextChild()
  bool fp_QCheckBox_focusNextChild_0 () {
    return QCheckBox::focusNextChild();
  }

  //  bool QCheckBox::focusPreviousChild()
  bool fp_QCheckBox_focusPreviousChild_0 () {
    return QCheckBox::focusPreviousChild();
  }

  //  void QCheckBox::initStyleOption(QStyleOptionButton *option)
  void fp_QCheckBox_initStyleOption_c2501 (QStyleOptionButton *option) const {
    QCheckBox::initStyleOption(option);
  }

  //  int QCheckBox::receivers(const char *signal)
  int fp_QCheckBox_receivers_c1731 (const char *signal) const {
    return QCheckBox::receivers(signal);
  }

  //  void QCheckBox::resetInputContext()
  void fp_QCheckBox_resetInputContext_0 () {
    QCheckBox::resetInputContext();
  }

  //  QObject *QCheckBox::sender()
  QObject * fp_QCheckBox_sender_c0 () const {
    return QCheckBox::sender();
  }

  //  void QCheckBox::updateMicroFocus()
  void fp_QCheckBox_updateMicroFocus_0 () {
    QCheckBox::updateMicroFocus();
  }

  //  [adaptor impl] bool QCheckBox::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QCheckBox::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCheckBox_Adaptor, bool, QObject *, QEvent *>(&QCheckBox_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QCheckBox::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] int QCheckBox::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QCheckBox::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QCheckBox_Adaptor, int, int>(&QCheckBox_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QCheckBox::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QCheckBox::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QCheckBox::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QCheckBox_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QCheckBox_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QCheckBox::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QCheckBox::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QCheckBox::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QCheckBox_Adaptor, QSize>(&QCheckBox_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QCheckBox::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QCheckBox::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QCheckBox::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QCheckBox_Adaptor, QPaintEngine *>(&QCheckBox_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QCheckBox::paintEngine();
    }
  }

  //  [adaptor impl] void QCheckBox::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QCheckBox::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QCheckBox_Adaptor, bool>(&QCheckBox_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QCheckBox::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QCheckBox::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QCheckBox::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QCheckBox_Adaptor, QSize>(&QCheckBox_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QCheckBox::sizeHint();
    }
  }

  //  [adaptor impl] void QCheckBox::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QCheckBox::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QCheckBox_Adaptor, QActionEvent *>(&QCheckBox_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QCheckBox::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::changeEvent(QEvent *e)
  void cbs_changeEvent_1217_0(QEvent *e)
  {
    QCheckBox::changeEvent(e);
  }

  virtual void changeEvent(QEvent *e)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QCheckBox_Adaptor, QEvent *>(&QCheckBox_Adaptor::cbs_changeEvent_1217_0, e);
    } else {
      QCheckBox::changeEvent(e);
    }
  }

  //  [adaptor impl] void QCheckBox::checkStateSet()
  void cbs_checkStateSet_0_0()
  {
    QCheckBox::checkStateSet();
  }

  virtual void checkStateSet()
  {
    if (cb_checkStateSet_0_0.can_issue()) {
      cb_checkStateSet_0_0.issue<QCheckBox_Adaptor>(&QCheckBox_Adaptor::cbs_checkStateSet_0_0);
    } else {
      QCheckBox::checkStateSet();
    }
  }

  //  [adaptor impl] void QCheckBox::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QCheckBox::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCheckBox_Adaptor, QChildEvent *>(&QCheckBox_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QCheckBox::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QCheckBox::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QCheckBox_Adaptor, QCloseEvent *>(&QCheckBox_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QCheckBox::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QCheckBox::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QCheckBox_Adaptor, QContextMenuEvent *>(&QCheckBox_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QCheckBox::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QCheckBox::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCheckBox_Adaptor, QEvent *>(&QCheckBox_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QCheckBox::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QCheckBox::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QCheckBox_Adaptor, const char *>(&QCheckBox_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QCheckBox::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QCheckBox::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QCheckBox::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QCheckBox_Adaptor, QDragEnterEvent *>(&QCheckBox_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QCheckBox::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QCheckBox::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QCheckBox_Adaptor, QDragLeaveEvent *>(&QCheckBox_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QCheckBox::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QCheckBox::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QCheckBox_Adaptor, QDragMoveEvent *>(&QCheckBox_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QCheckBox::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QCheckBox::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QCheckBox_Adaptor, QDropEvent *>(&QCheckBox_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QCheckBox::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QCheckBox::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QCheckBox_Adaptor, bool>(&QCheckBox_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QCheckBox::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QCheckBox::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QCheckBox_Adaptor, QEvent *>(&QCheckBox_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QCheckBox::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QCheckBox::event(QEvent *e)
  bool cbs_event_1217_0(QEvent *e)
  {
    return QCheckBox::event(e);
  }

  virtual bool event(QEvent *e)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCheckBox_Adaptor, bool, QEvent *>(&QCheckBox_Adaptor::cbs_event_1217_0, e);
    } else {
      return QCheckBox::event(e);
    }
  }

  //  [adaptor impl] void QCheckBox::focusInEvent(QFocusEvent *e)
  void cbs_focusInEvent_1729_0(QFocusEvent *e)
  {
    QCheckBox::focusInEvent(e);
  }

  virtual void focusInEvent(QFocusEvent *e)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QCheckBox_Adaptor, QFocusEvent *>(&QCheckBox_Adaptor::cbs_focusInEvent_1729_0, e);
    } else {
      QCheckBox::focusInEvent(e);
    }
  }

  //  [adaptor impl] bool QCheckBox::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QCheckBox::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QCheckBox_Adaptor, bool, bool>(&QCheckBox_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QCheckBox::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QCheckBox::focusOutEvent(QFocusEvent *e)
  void cbs_focusOutEvent_1729_0(QFocusEvent *e)
  {
    QCheckBox::focusOutEvent(e);
  }

  virtual void focusOutEvent(QFocusEvent *e)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QCheckBox_Adaptor, QFocusEvent *>(&QCheckBox_Adaptor::cbs_focusOutEvent_1729_0, e);
    } else {
      QCheckBox::focusOutEvent(e);
    }
  }

  //  [adaptor impl] void QCheckBox::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QCheckBox::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QCheckBox_Adaptor, const QFont &>(&QCheckBox_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QCheckBox::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QCheckBox::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QCheckBox_Adaptor, QHideEvent *>(&QCheckBox_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QCheckBox::hideEvent(arg1);
    }
  }

  //  [adaptor impl] bool QCheckBox::hitButton(const QPoint &pos)
  bool cbs_hitButton_c1916_0(const QPoint &pos) const
  {
    return QCheckBox::hitButton(pos);
  }

  virtual bool hitButton(const QPoint &pos) const
  {
    if (cb_hitButton_c1916_0.can_issue()) {
      return cb_hitButton_c1916_0.issue<QCheckBox_Adaptor, bool, const QPoint &>(&QCheckBox_Adaptor::cbs_hitButton_c1916_0, pos);
    } else {
      return QCheckBox::hitButton(pos);
    }
  }

  //  [adaptor impl] void QCheckBox::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QCheckBox::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QCheckBox_Adaptor, QInputMethodEvent *>(&QCheckBox_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QCheckBox::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::keyPressEvent(QKeyEvent *e)
  void cbs_keyPressEvent_1514_0(QKeyEvent *e)
  {
    QCheckBox::keyPressEvent(e);
  }

  virtual void keyPressEvent(QKeyEvent *e)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QCheckBox_Adaptor, QKeyEvent *>(&QCheckBox_Adaptor::cbs_keyPressEvent_1514_0, e);
    } else {
      QCheckBox::keyPressEvent(e);
    }
  }

  //  [adaptor impl] void QCheckBox::keyReleaseEvent(QKeyEvent *e)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *e)
  {
    QCheckBox::keyReleaseEvent(e);
  }

  virtual void keyReleaseEvent(QKeyEvent *e)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QCheckBox_Adaptor, QKeyEvent *>(&QCheckBox_Adaptor::cbs_keyReleaseEvent_1514_0, e);
    } else {
      QCheckBox::keyReleaseEvent(e);
    }
  }

  //  [adaptor impl] void QCheckBox::languageChange()
  void cbs_languageChange_0_0()
  {
    QCheckBox::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QCheckBox_Adaptor>(&QCheckBox_Adaptor::cbs_languageChange_0_0);
    } else {
      QCheckBox::languageChange();
    }
  }

  //  [adaptor impl] void QCheckBox::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QCheckBox::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QCheckBox_Adaptor, QEvent *>(&QCheckBox_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QCheckBox::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QCheckBox::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QCheckBox::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QCheckBox_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QCheckBox_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QCheckBox::metric(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QCheckBox::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QCheckBox_Adaptor, QMouseEvent *>(&QCheckBox_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QCheckBox::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QCheckBox::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QCheckBox_Adaptor, QMouseEvent *>(&QCheckBox_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QCheckBox::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::mousePressEvent(QMouseEvent *e)
  void cbs_mousePressEvent_1738_0(QMouseEvent *e)
  {
    QCheckBox::mousePressEvent(e);
  }

  virtual void mousePressEvent(QMouseEvent *e)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QCheckBox_Adaptor, QMouseEvent *>(&QCheckBox_Adaptor::cbs_mousePressEvent_1738_0, e);
    } else {
      QCheckBox::mousePressEvent(e);
    }
  }

  //  [adaptor impl] void QCheckBox::mouseReleaseEvent(QMouseEvent *e)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *e)
  {
    QCheckBox::mouseReleaseEvent(e);
  }

  virtual void mouseReleaseEvent(QMouseEvent *e)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QCheckBox_Adaptor, QMouseEvent *>(&QCheckBox_Adaptor::cbs_mouseReleaseEvent_1738_0, e);
    } else {
      QCheckBox::mouseReleaseEvent(e);
    }
  }

  //  [adaptor impl] void QCheckBox::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QCheckBox::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QCheckBox_Adaptor, QMoveEvent *>(&QCheckBox_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QCheckBox::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::nextCheckState()
  void cbs_nextCheckState_0_0()
  {
    QCheckBox::nextCheckState();
  }

  virtual void nextCheckState()
  {
    if (cb_nextCheckState_0_0.can_issue()) {
      cb_nextCheckState_0_0.issue<QCheckBox_Adaptor>(&QCheckBox_Adaptor::cbs_nextCheckState_0_0);
    } else {
      QCheckBox::nextCheckState();
    }
  }

  //  [adaptor impl] void QCheckBox::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QCheckBox::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QCheckBox_Adaptor, QPaintEvent *>(&QCheckBox_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QCheckBox::paintEvent(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QCheckBox::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QCheckBox_Adaptor, const QPalette &>(&QCheckBox_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QCheckBox::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QCheckBox::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QCheckBox_Adaptor, QResizeEvent *>(&QCheckBox_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QCheckBox::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QCheckBox::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QCheckBox_Adaptor, QShowEvent *>(&QCheckBox_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QCheckBox::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QCheckBox::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QCheckBox_Adaptor, QStyle &>(&QCheckBox_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QCheckBox::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QCheckBox::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QCheckBox_Adaptor, QTabletEvent *>(&QCheckBox_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QCheckBox::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::timerEvent(QTimerEvent *e)
  void cbs_timerEvent_1730_0(QTimerEvent *e)
  {
    QCheckBox::timerEvent(e);
  }

  virtual void timerEvent(QTimerEvent *e)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCheckBox_Adaptor, QTimerEvent *>(&QCheckBox_Adaptor::cbs_timerEvent_1730_0, e);
    } else {
      QCheckBox::timerEvent(e);
    }
  }

  //  [adaptor impl] void QCheckBox::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QCheckBox::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QCheckBox_Adaptor, QWheelEvent *>(&QCheckBox_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QCheckBox::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QCheckBox::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QCheckBox::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QCheckBox_Adaptor, bool>(&QCheckBox_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QCheckBox::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_checkStateSet_0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_hitButton_c1916_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nextCheckState_0_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QCheckBox_Adaptor::~QCheckBox_Adaptor() { }

//  Constructor QCheckBox::QCheckBox(QWidget *parent) (adaptor class)

static void _init_ctor_QCheckBox_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QCheckBox_Adaptor *> ();
}

static void _call_ctor_QCheckBox_Adaptor_1315 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QCheckBox_Adaptor *> (new QCheckBox_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QCheckBox_Adaptor_1315 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCheckBox::QCheckBox(QWidget *parent)\nThis method creates an object of class QCheckBox.", &_init_ctor_QCheckBox_Adaptor_1315, &_call_ctor_QCheckBox_Adaptor_1315);
}

//  Constructor QCheckBox::QCheckBox(const QString &text, QWidget *parent) (adaptor class)

static void _init_ctor_QCheckBox_Adaptor_3232 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return_new<QCheckBox_Adaptor *> ();
}

static void _call_ctor_QCheckBox_Adaptor_3232 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QWidget *arg2 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QCheckBox_Adaptor *> (new QCheckBox_Adaptor (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QCheckBox_Adaptor_3232 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCheckBox::QCheckBox(const QString &text, QWidget *parent)\nThis method creates an object of class QCheckBox.", &_init_ctor_QCheckBox_Adaptor_3232, &_call_ctor_QCheckBox_Adaptor_3232);
}

// void QCheckBox::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QCheckBox_Adaptor *)cls)->fp_QCheckBox_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QCheckBox::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QCheckBox::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QCheckBox_Adaptor *)cls)->fp_QCheckBox_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QCheckBox::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// bool QCheckBox::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QCheckBox_Adaptor *)cls)->fp_QCheckBox_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QCheckBox::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QCheckBox::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QCheckBox_Adaptor *)cls)->fp_QCheckBox_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QCheckBox::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// void QCheckBox::initStyleOption(QStyleOptionButton *option)

static void _init_fp_initStyleOption_c2501 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionButton * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_initStyleOption_c2501 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyleOptionButton *arg1 = args.read<QStyleOptionButton * > ();
  ((QCheckBox_Adaptor *)cls)->fp_QCheckBox_initStyleOption_c2501 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_initStyleOption_c2501 ()
{
  return new qt_gsi::GenericMethod("*initStyleOption", "@brief Method void QCheckBox::initStyleOption(QStyleOptionButton *option)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_initStyleOption_c2501, &_call_fp_initStyleOption_c2501);
}


// int QCheckBox::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QCheckBox_Adaptor *)cls)->fp_QCheckBox_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QCheckBox::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QCheckBox::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QCheckBox_Adaptor *)cls)->fp_QCheckBox_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QCheckBox::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// QObject *QCheckBox::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QCheckBox_Adaptor *)cls)->fp_QCheckBox_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QCheckBox::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QCheckBox::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QCheckBox_Adaptor *)cls)->fp_QCheckBox_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QCheckBox::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// bool QCheckBox::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QCheckBox_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QCheckBox::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// int QCheckBox::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QCheckBox_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QCheckBox::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// QVariant QCheckBox::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QCheckBox_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QCheckBox::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// QSize QCheckBox::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QCheckBox_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QCheckBox::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// QPaintEngine *QCheckBox::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QCheckBox_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QCheckBox::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QCheckBox::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QCheckBox_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QCheckBox::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// QSize QCheckBox::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QCheckBox_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QCheckBox::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// void QCheckBox::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QCheckBox::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QCheckBox::changeEvent(QEvent *e)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QCheckBox::changeEvent(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QCheckBox::checkStateSet()

static void _init_cbs_checkStateSet_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_checkStateSet_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QCheckBox_Adaptor *)cls)->cbs_checkStateSet_0_0 ();
}

static void _set_callback_cbs_checkStateSet_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_checkStateSet_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_checkStateSet_0_0 ()
{
  return new qt_gsi::GenericMethod ("*checkStateSet", "@hide", false, &_init_cbs_checkStateSet_0_0, &_call_cbs_checkStateSet_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_checkStateSet_0_0 ()
{
  return new qt_gsi::GenericMethod ("*checkStateSet", "@brief Virtual method void QCheckBox::checkStateSet()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_checkStateSet_0_0, &_call_cbs_checkStateSet_0_0, &_set_callback_cbs_checkStateSet_0_0);
}


// void QCheckBox::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCheckBox::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QCheckBox::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QCheckBox::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QCheckBox::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QCheckBox::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QCheckBox::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCheckBox::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QCheckBox::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCheckBox::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QCheckBox::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QCheckBox::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QCheckBox::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QCheckBox::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QCheckBox::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QCheckBox::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// void QCheckBox::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QCheckBox::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// void QCheckBox::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QCheckBox_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QCheckBox::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QCheckBox::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QCheckBox::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// bool QCheckBox::event(QEvent *e)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QCheckBox_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QCheckBox::event(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QCheckBox::focusInEvent(QFocusEvent *e)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QCheckBox::focusInEvent(QFocusEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QCheckBox::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QCheckBox_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QCheckBox::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QCheckBox::focusOutEvent(QFocusEvent *e)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QCheckBox::focusOutEvent(QFocusEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QCheckBox::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QCheckBox_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QCheckBox::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QCheckBox::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QCheckBox::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// bool QCheckBox::hitButton(const QPoint &pos)

static void _init_cbs_hitButton_c1916_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_hitButton_c1916_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<bool > ((bool)((QCheckBox_Adaptor *)cls)->cbs_hitButton_c1916_0 (arg1));
}

static void _set_callback_cbs_hitButton_c1916_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_hitButton_c1916_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hitButton_c1916_0 ()
{
  return new qt_gsi::GenericMethod ("*hitButton", "@hide", true, &_init_cbs_hitButton_c1916_0, &_call_cbs_hitButton_c1916_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hitButton_c1916_0 ()
{
  return new qt_gsi::GenericMethod ("*hitButton", "@brief Virtual method bool QCheckBox::hitButton(const QPoint &pos)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hitButton_c1916_0, &_call_cbs_hitButton_c1916_0, &_set_callback_cbs_hitButton_c1916_0);
}


// void QCheckBox::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QCheckBox::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// void QCheckBox::keyPressEvent(QKeyEvent *e)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QCheckBox::keyPressEvent(QKeyEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QCheckBox::keyReleaseEvent(QKeyEvent *e)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QCheckBox::keyReleaseEvent(QKeyEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QCheckBox::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QCheckBox_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QCheckBox::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QCheckBox::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QCheckBox::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QCheckBox::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QCheckBox_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QCheckBox::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// void QCheckBox::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QCheckBox::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QCheckBox::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QCheckBox::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QCheckBox::mousePressEvent(QMouseEvent *e)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QCheckBox::mousePressEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QCheckBox::mouseReleaseEvent(QMouseEvent *e)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QCheckBox::mouseReleaseEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// void QCheckBox::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QCheckBox::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QCheckBox::nextCheckState()

static void _init_cbs_nextCheckState_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_nextCheckState_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QCheckBox_Adaptor *)cls)->cbs_nextCheckState_0_0 ();
}

static void _set_callback_cbs_nextCheckState_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_nextCheckState_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_nextCheckState_0_0 ()
{
  return new qt_gsi::GenericMethod ("*nextCheckState", "@hide", false, &_init_cbs_nextCheckState_0_0, &_call_cbs_nextCheckState_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_nextCheckState_0_0 ()
{
  return new qt_gsi::GenericMethod ("*nextCheckState", "@brief Virtual method void QCheckBox::nextCheckState()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nextCheckState_0_0, &_call_cbs_nextCheckState_0_0, &_set_callback_cbs_nextCheckState_0_0);
}


// void QCheckBox::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QCheckBox::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QCheckBox::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QCheckBox_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QCheckBox::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QCheckBox::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QCheckBox::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QCheckBox::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QCheckBox::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// void QCheckBox::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QCheckBox_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QCheckBox::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// void QCheckBox::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QCheckBox::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QCheckBox::timerEvent(QTimerEvent *e)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCheckBox::timerEvent(QTimerEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QCheckBox::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QCheckBox_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QCheckBox::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QCheckBox::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QCheckBox_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QCheckBox_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QCheckBox::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QCheckBox> decl_QCheckBox;

gsi::Class<QCheckBox_Adaptor> decl_QCheckBox_Adaptor (decl_QCheckBox, "QCheckBox",
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_initStyleOption_c2501 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_checkStateSet_0_0 ()) +
  gsi::Methods(_create_callback_cbs_checkStateSet_0_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_hitButton_c1916_0 ()) +
  gsi::Methods(_create_callback_cbs_hitButton_c1916_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_nextCheckState_0_0 ()) +
  gsi::Methods(_create_callback_cbs_nextCheckState_0_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QCheckBox_Adaptor_1315 ()) +
  gsi::Methods(_create_ctor_QCheckBox_Adaptor_3232 ()),
  "@qt\n@brief Binding of QCheckBox");

}

