
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCDEStyle.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQCDEStyle_EventAdaptor.h"
#include "gsiDeclQCDEStyle_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCDEStyle

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCDEStyle::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QCDEStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)


static void _init_f_drawControl_c8285 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("element");
  decl->add_arg<const qt_gsi::Converter<QStyle::ControlElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w", true, "0");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawControl_c8285 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::ControlElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ControlElement>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  QPainter *arg3 = args.read<QPainter * > ();
  const QWidget *arg4 = args ? args.read<const QWidget * > () : (const QWidget *)(0);
  ((QCDEStyle *)cls)->drawControl (qt_gsi::QtToCppAdaptor<QStyle::ControlElement>(arg1).cref(), arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_drawControl_c8285 ()
{
  return new qt_gsi::GenericMethod ("drawControl", "@brief Method void QCDEStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)\nThis is a reimplementation of QMotifStyle::drawControl", true, &_init_f_drawControl_c8285, &_call_f_drawControl_c8285);
}

// void QCDEStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)


static void _init_f_drawPrimitive_c8501 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pe");
  decl->add_arg<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w", true, "0");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_drawPrimitive_c8501 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  QPainter *arg3 = args.read<QPainter * > ();
  const QWidget *arg4 = args ? args.read<const QWidget * > () : (const QWidget *)(0);
  ((QCDEStyle *)cls)->drawPrimitive (qt_gsi::QtToCppAdaptor<QStyle::PrimitiveElement>(arg1).cref(), arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_drawPrimitive_c8501 ()
{
  return new qt_gsi::GenericMethod ("drawPrimitive", "@brief Method void QCDEStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)\nThis is a reimplementation of QMotifStyle::drawPrimitive", true, &_init_f_drawPrimitive_c8501, &_call_f_drawPrimitive_c8501);
}

// int QCDEStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)


static void _init_f_pixelMetric_c6642 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metric");
  decl->add_arg<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option", true, "0");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_pixelMetric_c6642 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::PixelMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & > ();
  const QStyleOption *arg2 = args ? args.read<const QStyleOption * > () : (const QStyleOption *)(0);
  const QWidget *arg3 = args ? args.read<const QWidget * > () : (const QWidget *)(0);
  ret.write<int > ((int)((QCDEStyle *)cls)->pixelMetric (qt_gsi::QtToCppAdaptor<QStyle::PixelMetric>(arg1).cref(), arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_pixelMetric_c6642 ()
{
  return new qt_gsi::GenericMethod ("pixelMetric", "@brief Method int QCDEStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)\nThis is a reimplementation of QMotifStyle::pixelMetric", true, &_init_f_pixelMetric_c6642, &_call_f_pixelMetric_c6642);
}

// QPalette QCDEStyle::standardPalette()


static void _init_f_standardPalette_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPalette > ();
}

static void _call_f_standardPalette_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPalette > ((QPalette)((QCDEStyle *)cls)->standardPalette ());
}

static qt_gsi::GenericMethod *_create_f_standardPalette_c0 ()
{
  return new qt_gsi::GenericMethod ("standardPalette", "@brief Method QPalette QCDEStyle::standardPalette()\nThis is a reimplementation of QMotifStyle::standardPalette", true, &_init_f_standardPalette_c0, &_call_f_standardPalette_c0);
}

// static QString QCDEStyle::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QCDEStyle::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCDEStyle::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QCDEStyle::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QCDEStyle::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCDEStyle::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QCDEStyle::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QCDEStyle::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCDEStyle::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QCDEStyle::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QCDEStyle::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCDEStyle::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QCDEStyle, QCDEStyle_EventAdaptor> ea_QCDEStyle;

namespace gsi
{
extern gsi::Class<QMotifStyle> decl_QMotifStyle;

gsi::Class<QCDEStyle> decl_QCDEStyle (ea_QCDEStyle, decl_QMotifStyle, "QCDEStyle_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_drawControl_c8285 ()) +
  gsi::Methods(_create_f_drawPrimitive_c8501 ()) +
  gsi::Methods(_create_f_pixelMetric_c6642 ()) +
  gsi::Methods(_create_f_standardPalette_c0 ()) +
  qt_gsi::qt_signal<QCDEStyle, QCDEStyle_EventAdaptor, QObject *> ("destroyed", &QCDEStyle_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QCDEStyle::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QCDEStyle");
}


class QCDEStyle_Adaptor : public QCDEStyle, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCDEStyle_Adaptor();

  //  [adaptor ctor] QCDEStyle::QCDEStyle(bool useHighlightCols)
  QCDEStyle_Adaptor() : QCDEStyle()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCDEStyle::QCDEStyle(bool useHighlightCols)
  QCDEStyle_Adaptor(bool useHighlightCols) : QCDEStyle(useHighlightCols)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QCDEStyle::layoutSpacingImplementation(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)
  int fp_QCDEStyle_layoutSpacingImplementation_c11697 (const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & control1, const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & control2, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, const QStyleOption *option, const QWidget *widget) const {
    return QCDEStyle::layoutSpacingImplementation(qt_gsi::QtToCppAdaptor<QSizePolicy::ControlType>(control1).cref(), qt_gsi::QtToCppAdaptor<QSizePolicy::ControlType>(control2).cref(), qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), option, widget);
  }

  //  int QCDEStyle::receivers(const char *signal)
  int fp_QCDEStyle_receivers_c1731 (const char *signal) const {
    return QCDEStyle::receivers(signal);
  }

  //  QObject *QCDEStyle::sender()
  QObject * fp_QCDEStyle_sender_c0 () const {
    return QCDEStyle::sender();
  }

  //  QIcon QCDEStyle::standardIconImplementation(QStyle::StandardPixmap standardIcon, const QStyleOption *opt, const QWidget *widget)
  QIcon fp_QCDEStyle_standardIconImplementation_c6956 (const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & standardIcon, const QStyleOption *opt, const QWidget *widget) const {
    return QCDEStyle::standardIconImplementation(qt_gsi::QtToCppAdaptor<QStyle::StandardPixmap>(standardIcon).cref(), opt, widget);
  }

  //  [adaptor impl] void QCDEStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w)
  void cbs_drawComplexControl_c9027_1(const qt_gsi::Converter<QStyle::ComplexControl>::target_type & cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w) const
  {
    QCDEStyle::drawComplexControl(qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(cc).cref(), opt, p, w);
  }

  virtual void drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w) const
  {
    if (cb_drawComplexControl_c9027_1.can_issue()) {
      cb_drawComplexControl_c9027_1.issue<QCDEStyle_Adaptor, const qt_gsi::Converter<QStyle::ComplexControl>::target_type &, const QStyleOptionComplex *, QPainter *, const QWidget *>(&QCDEStyle_Adaptor::cbs_drawComplexControl_c9027_1, qt_gsi::CppToQtAdaptor<QStyle::ComplexControl>(cc), opt, p, w);
    } else {
      QCDEStyle::drawComplexControl(cc, opt, p, w);
    }
  }

  //  [adaptor impl] void QCDEStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)
  void cbs_drawControl_c8285_1(const qt_gsi::Converter<QStyle::ControlElement>::target_type & element, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    QCDEStyle::drawControl(qt_gsi::QtToCppAdaptor<QStyle::ControlElement>(element).cref(), opt, p, w);
  }

  virtual void drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    if (cb_drawControl_c8285_1.can_issue()) {
      cb_drawControl_c8285_1.issue<QCDEStyle_Adaptor, const qt_gsi::Converter<QStyle::ControlElement>::target_type &, const QStyleOption *, QPainter *, const QWidget *>(&QCDEStyle_Adaptor::cbs_drawControl_c8285_1, qt_gsi::CppToQtAdaptor<QStyle::ControlElement>(element), opt, p, w);
    } else {
      QCDEStyle::drawControl(element, opt, p, w);
    }
  }

  //  [adaptor impl] void QCDEStyle::drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap)
  void cbs_drawItemPixmap_c5678_0(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap) const
  {
    QCDEStyle::drawItemPixmap(painter, rect, alignment, pixmap);
  }

  virtual void drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap) const
  {
    if (cb_drawItemPixmap_c5678_0.can_issue()) {
      cb_drawItemPixmap_c5678_0.issue<QCDEStyle_Adaptor, QPainter *, const QRect &, int, const QPixmap &>(&QCDEStyle_Adaptor::cbs_drawItemPixmap_c5678_0, painter, rect, alignment, pixmap);
    } else {
      QCDEStyle::drawItemPixmap(painter, rect, alignment, pixmap);
    }
  }

  //  [adaptor impl] void QCDEStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole)
  void cbs_drawItemText_c10604_1(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, const qt_gsi::Converter<QPalette::ColorRole>::target_type & textRole) const
  {
    QCDEStyle::drawItemText(painter, rect, flags, pal, enabled, text, qt_gsi::QtToCppAdaptor<QPalette::ColorRole>(textRole).cref());
  }

  virtual void drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole) const
  {
    if (cb_drawItemText_c10604_1.can_issue()) {
      cb_drawItemText_c10604_1.issue<QCDEStyle_Adaptor, QPainter *, const QRect &, int, const QPalette &, bool, const QString &, const qt_gsi::Converter<QPalette::ColorRole>::target_type &>(&QCDEStyle_Adaptor::cbs_drawItemText_c10604_1, painter, rect, flags, pal, enabled, text, qt_gsi::CppToQtAdaptor<QPalette::ColorRole>(textRole));
    } else {
      QCDEStyle::drawItemText(painter, rect, flags, pal, enabled, text, textRole);
    }
  }

  //  [adaptor impl] void QCDEStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)
  void cbs_drawPrimitive_c8501_1(const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & pe, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    QCDEStyle::drawPrimitive(qt_gsi::QtToCppAdaptor<QStyle::PrimitiveElement>(pe).cref(), opt, p, w);
  }

  virtual void drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w) const
  {
    if (cb_drawPrimitive_c8501_1.can_issue()) {
      cb_drawPrimitive_c8501_1.issue<QCDEStyle_Adaptor, const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type &, const QStyleOption *, QPainter *, const QWidget *>(&QCDEStyle_Adaptor::cbs_drawPrimitive_c8501_1, qt_gsi::CppToQtAdaptor<QStyle::PrimitiveElement>(pe), opt, p, w);
    } else {
      QCDEStyle::drawPrimitive(pe, opt, p, w);
    }
  }

  //  [adaptor impl] bool QCDEStyle::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QCDEStyle::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCDEStyle_Adaptor, bool, QEvent *>(&QCDEStyle_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QCDEStyle::event(arg1);
    }
  }

  //  [adaptor impl] QPixmap QCDEStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)
  QPixmap cbs_generatedIconPixmap_c5776_0(const qt_gsi::Converter<QIcon::Mode>::target_type & iconMode, const QPixmap &pixmap, const QStyleOption *opt) const
  {
    return QCDEStyle::generatedIconPixmap(qt_gsi::QtToCppAdaptor<QIcon::Mode>(iconMode).cref(), pixmap, opt);
  }

  virtual QPixmap generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt) const
  {
    if (cb_generatedIconPixmap_c5776_0.can_issue()) {
      return cb_generatedIconPixmap_c5776_0.issue<QCDEStyle_Adaptor, QPixmap, const qt_gsi::Converter<QIcon::Mode>::target_type &, const QPixmap &, const QStyleOption *>(&QCDEStyle_Adaptor::cbs_generatedIconPixmap_c5776_0, qt_gsi::CppToQtAdaptor<QIcon::Mode>(iconMode), pixmap, opt);
    } else {
      return QCDEStyle::generatedIconPixmap(iconMode, pixmap, opt);
    }
  }

  //  [adaptor impl] QStyle::SubControl QCDEStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *w)
  qt_gsi::Converter<QStyle::SubControl>::target_type cbs_hitTestComplexControl_c9517_1(const qt_gsi::Converter<QStyle::ComplexControl>::target_type & cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *w) const
  {
    return qt_gsi::CppToQtAdaptor<QStyle::SubControl>(QCDEStyle::hitTestComplexControl(qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(cc).cref(), opt, pt, w));
  }

  virtual QStyle::SubControl hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *w) const
  {
    if (cb_hitTestComplexControl_c9517_1.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QStyle::SubControl>(cb_hitTestComplexControl_c9517_1.issue<QCDEStyle_Adaptor, qt_gsi::Converter<QStyle::SubControl>::target_type, const qt_gsi::Converter<QStyle::ComplexControl>::target_type &, const QStyleOptionComplex *, const QPoint &, const QWidget *>(&QCDEStyle_Adaptor::cbs_hitTestComplexControl_c9517_1, qt_gsi::CppToQtAdaptor<QStyle::ComplexControl>(cc), opt, pt, w)).cref();
    } else {
      return QCDEStyle::hitTestComplexControl(cc, opt, pt, w);
    }
  }

  //  [adaptor impl] QRect QCDEStyle::itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap)
  QRect cbs_itemPixmapRect_c4360_0(const QRect &r, int flags, const QPixmap &pixmap) const
  {
    return QCDEStyle::itemPixmapRect(r, flags, pixmap);
  }

  virtual QRect itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap) const
  {
    if (cb_itemPixmapRect_c4360_0.can_issue()) {
      return cb_itemPixmapRect_c4360_0.issue<QCDEStyle_Adaptor, QRect, const QRect &, int, const QPixmap &>(&QCDEStyle_Adaptor::cbs_itemPixmapRect_c4360_0, r, flags, pixmap);
    } else {
      return QCDEStyle::itemPixmapRect(r, flags, pixmap);
    }
  }

  //  [adaptor impl] QRect QCDEStyle::itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text)
  QRect cbs_itemTextRect_c7544_0(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text) const
  {
    return QCDEStyle::itemTextRect(fm, r, flags, enabled, text);
  }

  virtual QRect itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text) const
  {
    if (cb_itemTextRect_c7544_0.can_issue()) {
      return cb_itemTextRect_c7544_0.issue<QCDEStyle_Adaptor, QRect, const QFontMetrics &, const QRect &, int, bool, const QString &>(&QCDEStyle_Adaptor::cbs_itemTextRect_c7544_0, fm, r, flags, enabled, text);
    } else {
      return QCDEStyle::itemTextRect(fm, r, flags, enabled, text);
    }
  }

  //  [adaptor impl] int QCDEStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)
  int cbs_pixelMetric_c6642_2(const qt_gsi::Converter<QStyle::PixelMetric>::target_type & metric, const QStyleOption *option, const QWidget *widget) const
  {
    return QCDEStyle::pixelMetric(qt_gsi::QtToCppAdaptor<QStyle::PixelMetric>(metric).cref(), option, widget);
  }

  virtual int pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget) const
  {
    if (cb_pixelMetric_c6642_2.can_issue()) {
      return cb_pixelMetric_c6642_2.issue<QCDEStyle_Adaptor, int, const qt_gsi::Converter<QStyle::PixelMetric>::target_type &, const QStyleOption *, const QWidget *>(&QCDEStyle_Adaptor::cbs_pixelMetric_c6642_2, qt_gsi::CppToQtAdaptor<QStyle::PixelMetric>(metric), option, widget);
    } else {
      return QCDEStyle::pixelMetric(metric, option, widget);
    }
  }

  //  [adaptor impl] void QCDEStyle::polish(QPalette &)
  void cbs_polish_1418_0(QPalette &arg1)
  {
    QCDEStyle::polish(arg1);
  }

  virtual void polish(QPalette &arg1)
  {
    if (cb_polish_1418_0.can_issue()) {
      cb_polish_1418_0.issue<QCDEStyle_Adaptor, QPalette &>(&QCDEStyle_Adaptor::cbs_polish_1418_0, arg1);
    } else {
      QCDEStyle::polish(arg1);
    }
  }

  //  [adaptor impl] void QCDEStyle::polish(QWidget *)
  void cbs_polish_1315_0(QWidget *arg1)
  {
    QCDEStyle::polish(arg1);
  }

  virtual void polish(QWidget *arg1)
  {
    if (cb_polish_1315_0.can_issue()) {
      cb_polish_1315_0.issue<QCDEStyle_Adaptor, QWidget *>(&QCDEStyle_Adaptor::cbs_polish_1315_0, arg1);
    } else {
      QCDEStyle::polish(arg1);
    }
  }

  //  [adaptor impl] void QCDEStyle::polish(QApplication *)
  void cbs_polish_1843_0(QApplication *arg1)
  {
    QCDEStyle::polish(arg1);
  }

  virtual void polish(QApplication *arg1)
  {
    if (cb_polish_1843_0.can_issue()) {
      cb_polish_1843_0.issue<QCDEStyle_Adaptor, QApplication *>(&QCDEStyle_Adaptor::cbs_polish_1843_0, arg1);
    } else {
      QCDEStyle::polish(arg1);
    }
  }

  //  [adaptor impl] QSize QCDEStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *widget)
  QSize cbs_sizeFromContents_c8477_1(const qt_gsi::Converter<QStyle::ContentsType>::target_type & ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *widget) const
  {
    return QCDEStyle::sizeFromContents(qt_gsi::QtToCppAdaptor<QStyle::ContentsType>(ct).cref(), opt, contentsSize, widget);
  }

  virtual QSize sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *widget) const
  {
    if (cb_sizeFromContents_c8477_1.can_issue()) {
      return cb_sizeFromContents_c8477_1.issue<QCDEStyle_Adaptor, QSize, const qt_gsi::Converter<QStyle::ContentsType>::target_type &, const QStyleOption *, const QSize &, const QWidget *>(&QCDEStyle_Adaptor::cbs_sizeFromContents_c8477_1, qt_gsi::CppToQtAdaptor<QStyle::ContentsType>(ct), opt, contentsSize, widget);
    } else {
      return QCDEStyle::sizeFromContents(ct, opt, contentsSize, widget);
    }
  }

  //  [adaptor impl] QPalette QCDEStyle::standardPalette()
  QPalette cbs_standardPalette_c0_0() const
  {
    return QCDEStyle::standardPalette();
  }

  virtual QPalette standardPalette() const
  {
    if (cb_standardPalette_c0_0.can_issue()) {
      return cb_standardPalette_c0_0.issue<QCDEStyle_Adaptor, QPalette>(&QCDEStyle_Adaptor::cbs_standardPalette_c0_0);
    } else {
      return QCDEStyle::standardPalette();
    }
  }

  //  [adaptor impl] QPixmap QCDEStyle::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption *opt, const QWidget *widget)
  QPixmap cbs_standardPixmap_c6956_1(const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & _standardPixmap, const QStyleOption *opt, const QWidget *widget) const
  {
    return QCDEStyle::standardPixmap(qt_gsi::QtToCppAdaptor<QStyle::StandardPixmap>(_standardPixmap).cref(), opt, widget);
  }

  virtual QPixmap standardPixmap(QStyle::StandardPixmap _standardPixmap, const QStyleOption *opt, const QWidget *widget) const
  {
    if (cb_standardPixmap_c6956_1.can_issue()) {
      return cb_standardPixmap_c6956_1.issue<QCDEStyle_Adaptor, QPixmap, const qt_gsi::Converter<QStyle::StandardPixmap>::target_type &, const QStyleOption *, const QWidget *>(&QCDEStyle_Adaptor::cbs_standardPixmap_c6956_1, qt_gsi::CppToQtAdaptor<QStyle::StandardPixmap>(_standardPixmap), opt, widget);
    } else {
      return QCDEStyle::standardPixmap(_standardPixmap, opt, widget);
    }
  }

  //  [adaptor impl] int QCDEStyle::styleHint(QStyle::StyleHint hint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData)
  int cbs_styleHint_c8615_3(const qt_gsi::Converter<QStyle::StyleHint>::target_type & hint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData) const
  {
    return QCDEStyle::styleHint(qt_gsi::QtToCppAdaptor<QStyle::StyleHint>(hint).cref(), opt, widget, returnData);
  }

  virtual int styleHint(QStyle::StyleHint hint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData) const
  {
    if (cb_styleHint_c8615_3.can_issue()) {
      return cb_styleHint_c8615_3.issue<QCDEStyle_Adaptor, int, const qt_gsi::Converter<QStyle::StyleHint>::target_type &, const QStyleOption *, const QWidget *, QStyleHintReturn *>(&QCDEStyle_Adaptor::cbs_styleHint_c8615_3, qt_gsi::CppToQtAdaptor<QStyle::StyleHint>(hint), opt, widget, returnData);
    } else {
      return QCDEStyle::styleHint(hint, opt, widget, returnData);
    }
  }

  //  [adaptor impl] QRect QCDEStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget)
  QRect cbs_subControlRect_c9798_1(const qt_gsi::Converter<QStyle::ComplexControl>::target_type & cc, const QStyleOptionComplex *opt, const qt_gsi::Converter<QStyle::SubControl>::target_type & sc, const QWidget *widget) const
  {
    return QCDEStyle::subControlRect(qt_gsi::QtToCppAdaptor<QStyle::ComplexControl>(cc).cref(), opt, qt_gsi::QtToCppAdaptor<QStyle::SubControl>(sc).cref(), widget);
  }

  virtual QRect subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget) const
  {
    if (cb_subControlRect_c9798_1.can_issue()) {
      return cb_subControlRect_c9798_1.issue<QCDEStyle_Adaptor, QRect, const qt_gsi::Converter<QStyle::ComplexControl>::target_type &, const QStyleOptionComplex *, const qt_gsi::Converter<QStyle::SubControl>::target_type &, const QWidget *>(&QCDEStyle_Adaptor::cbs_subControlRect_c9798_1, qt_gsi::CppToQtAdaptor<QStyle::ComplexControl>(cc), opt, qt_gsi::CppToQtAdaptor<QStyle::SubControl>(sc), widget);
    } else {
      return QCDEStyle::subControlRect(cc, opt, sc, widget);
    }
  }

  //  [adaptor impl] QRect QCDEStyle::subElementRect(QStyle::SubElement r, const QStyleOption *opt, const QWidget *widget)
  QRect cbs_subElementRect_c6528_1(const qt_gsi::Converter<QStyle::SubElement>::target_type & r, const QStyleOption *opt, const QWidget *widget) const
  {
    return QCDEStyle::subElementRect(qt_gsi::QtToCppAdaptor<QStyle::SubElement>(r).cref(), opt, widget);
  }

  virtual QRect subElementRect(QStyle::SubElement r, const QStyleOption *opt, const QWidget *widget) const
  {
    if (cb_subElementRect_c6528_1.can_issue()) {
      return cb_subElementRect_c6528_1.issue<QCDEStyle_Adaptor, QRect, const qt_gsi::Converter<QStyle::SubElement>::target_type &, const QStyleOption *, const QWidget *>(&QCDEStyle_Adaptor::cbs_subElementRect_c6528_1, qt_gsi::CppToQtAdaptor<QStyle::SubElement>(r), opt, widget);
    } else {
      return QCDEStyle::subElementRect(r, opt, widget);
    }
  }

  //  [adaptor impl] void QCDEStyle::unpolish(QWidget *)
  void cbs_unpolish_1315_0(QWidget *arg1)
  {
    QCDEStyle::unpolish(arg1);
  }

  virtual void unpolish(QWidget *arg1)
  {
    if (cb_unpolish_1315_0.can_issue()) {
      cb_unpolish_1315_0.issue<QCDEStyle_Adaptor, QWidget *>(&QCDEStyle_Adaptor::cbs_unpolish_1315_0, arg1);
    } else {
      QCDEStyle::unpolish(arg1);
    }
  }

  //  [adaptor impl] void QCDEStyle::unpolish(QApplication *)
  void cbs_unpolish_1843_0(QApplication *arg1)
  {
    QCDEStyle::unpolish(arg1);
  }

  virtual void unpolish(QApplication *arg1)
  {
    if (cb_unpolish_1843_0.can_issue()) {
      cb_unpolish_1843_0.issue<QCDEStyle_Adaptor, QApplication *>(&QCDEStyle_Adaptor::cbs_unpolish_1843_0, arg1);
    } else {
      QCDEStyle::unpolish(arg1);
    }
  }

  //  [adaptor impl] void QCDEStyle::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QCDEStyle::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCDEStyle_Adaptor, QChildEvent *>(&QCDEStyle_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QCDEStyle::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QCDEStyle::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QCDEStyle::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCDEStyle_Adaptor, QEvent *>(&QCDEStyle_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QCDEStyle::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QCDEStyle::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QCDEStyle::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QCDEStyle_Adaptor, const char *>(&QCDEStyle_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QCDEStyle::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QCDEStyle::eventFilter(QObject *o, QEvent *e)
  bool cbs_eventFilter_2411_0(QObject *o, QEvent *e)
  {
    return QCDEStyle::eventFilter(o, e);
  }

  virtual bool eventFilter(QObject *o, QEvent *e)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCDEStyle_Adaptor, bool, QObject *, QEvent *>(&QCDEStyle_Adaptor::cbs_eventFilter_2411_0, o, e);
    } else {
      return QCDEStyle::eventFilter(o, e);
    }
  }

  //  [adaptor impl] void QCDEStyle::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QCDEStyle::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCDEStyle_Adaptor, QTimerEvent *>(&QCDEStyle_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QCDEStyle::timerEvent(event);
    }
  }

  gsi::Callback cb_drawComplexControl_c9027_1;
  gsi::Callback cb_drawControl_c8285_1;
  gsi::Callback cb_drawItemPixmap_c5678_0;
  gsi::Callback cb_drawItemText_c10604_1;
  gsi::Callback cb_drawPrimitive_c8501_1;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_generatedIconPixmap_c5776_0;
  gsi::Callback cb_hitTestComplexControl_c9517_1;
  gsi::Callback cb_itemPixmapRect_c4360_0;
  gsi::Callback cb_itemTextRect_c7544_0;
  gsi::Callback cb_pixelMetric_c6642_2;
  gsi::Callback cb_polish_1418_0;
  gsi::Callback cb_polish_1315_0;
  gsi::Callback cb_polish_1843_0;
  gsi::Callback cb_sizeFromContents_c8477_1;
  gsi::Callback cb_standardPalette_c0_0;
  gsi::Callback cb_standardPixmap_c6956_1;
  gsi::Callback cb_styleHint_c8615_3;
  gsi::Callback cb_subControlRect_c9798_1;
  gsi::Callback cb_subElementRect_c6528_1;
  gsi::Callback cb_unpolish_1315_0;
  gsi::Callback cb_unpolish_1843_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QCDEStyle_Adaptor::~QCDEStyle_Adaptor() { }

//  Constructor QCDEStyle::QCDEStyle(bool useHighlightCols) (adaptor class)

static void _init_ctor_QCDEStyle_Adaptor_864 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("useHighlightCols", true, "false");
  decl->add_arg<bool > (argspec_0);
  decl->set_return_new<QCDEStyle_Adaptor *> ();
}

static void _call_ctor_QCDEStyle_Adaptor_864 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(false);
  ret.write<QCDEStyle_Adaptor *> (new QCDEStyle_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QCDEStyle_Adaptor_864 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCDEStyle::QCDEStyle(bool useHighlightCols)\nThis method creates an object of class QCDEStyle.", &_init_ctor_QCDEStyle_Adaptor_864, &_call_ctor_QCDEStyle_Adaptor_864);
}

// int QCDEStyle::layoutSpacingImplementation(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)

static void _init_fp_layoutSpacingImplementation_c11697 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("control1");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("control2");
  decl->add_arg<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("option", true, "0");
  decl->add_arg<const QStyleOption * > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_4);
  decl->set_return<int > ();
}

static void _call_fp_layoutSpacingImplementation_c11697 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & arg1 = args.read<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > ();
  const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & arg2 = args.read<const qt_gsi::Converter<QSizePolicy::ControlType>::target_type & > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg3 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  const QStyleOption *arg4 = args ? args.read<const QStyleOption * > () : (const QStyleOption *)(0);
  const QWidget *arg5 = args ? args.read<const QWidget * > () : (const QWidget *)(0);
  ret.write<int > ((int)((QCDEStyle_Adaptor *)cls)->fp_QCDEStyle_layoutSpacingImplementation_c11697 (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericMethod*_create_fp_layoutSpacingImplementation_c11697 ()
{
  return new qt_gsi::GenericMethod("*layoutSpacingImplementation", "@brief Method int QCDEStyle::layoutSpacingImplementation(QSizePolicy::ControlType control1, QSizePolicy::ControlType control2, Qt::Orientation orientation, const QStyleOption *option, const QWidget *widget)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_layoutSpacingImplementation_c11697, &_call_fp_layoutSpacingImplementation_c11697);
}


// int QCDEStyle::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QCDEStyle_Adaptor *)cls)->fp_QCDEStyle_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QCDEStyle::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QCDEStyle::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QCDEStyle_Adaptor *)cls)->fp_QCDEStyle_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QCDEStyle::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// QIcon QCDEStyle::standardIconImplementation(QStyle::StandardPixmap standardIcon, const QStyleOption *opt, const QWidget *widget)

static void _init_fp_standardIconImplementation_c6956 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("standardIcon");
  decl->add_arg<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt", true, "0");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget", true, "0");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QIcon > ();
}

static void _call_fp_standardIconImplementation_c6956 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > ();
  const QStyleOption *arg2 = args ? args.read<const QStyleOption * > () : (const QStyleOption *)(0);
  const QWidget *arg3 = args ? args.read<const QWidget * > () : (const QWidget *)(0);
  ret.write<QIcon > ((QIcon)((QCDEStyle_Adaptor *)cls)->fp_QCDEStyle_standardIconImplementation_c6956 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_standardIconImplementation_c6956 ()
{
  return new qt_gsi::GenericMethod("*standardIconImplementation", "@brief Method QIcon QCDEStyle::standardIconImplementation(QStyle::StandardPixmap standardIcon, const QStyleOption *opt, const QWidget *widget)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_standardIconImplementation_c6956, &_call_fp_standardIconImplementation_c6956);
}


// void QCDEStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w)

static void _init_cbs_drawComplexControl_c9027_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawComplexControl_c9027_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > ();
  const QStyleOptionComplex *arg2 = args.read<const QStyleOptionComplex * > ();
  QPainter *arg3 = args.read<QPainter * > ();
  const QWidget *arg4 = args.read<const QWidget * > ();
  ((QCDEStyle_Adaptor *)cls)->cbs_drawComplexControl_c9027_1 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawComplexControl_c9027_1 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_drawComplexControl_c9027_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawComplexControl_c9027_1 ()
{
  return new qt_gsi::GenericMethod ("drawComplexControl", "@hide", true, &_init_cbs_drawComplexControl_c9027_1, &_call_cbs_drawComplexControl_c9027_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawComplexControl_c9027_1 ()
{
  return new qt_gsi::GenericMethod ("drawComplexControl", "@brief Virtual method void QCDEStyle::drawComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QPainter *p, const QWidget *w)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawComplexControl_c9027_1, &_call_cbs_drawComplexControl_c9027_1, &_set_callback_cbs_drawComplexControl_c9027_1);
}


// void QCDEStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)

static void _init_cbs_drawControl_c8285_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("element");
  decl->add_arg<const qt_gsi::Converter<QStyle::ControlElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawControl_c8285_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::ControlElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ControlElement>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  QPainter *arg3 = args.read<QPainter * > ();
  const QWidget *arg4 = args.read<const QWidget * > ();
  ((QCDEStyle_Adaptor *)cls)->cbs_drawControl_c8285_1 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawControl_c8285_1 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_drawControl_c8285_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawControl_c8285_1 ()
{
  return new qt_gsi::GenericMethod ("drawControl", "@hide", true, &_init_cbs_drawControl_c8285_1, &_call_cbs_drawControl_c8285_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawControl_c8285_1 ()
{
  return new qt_gsi::GenericMethod ("drawControl", "@brief Virtual method void QCDEStyle::drawControl(QStyle::ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawControl_c8285_1, &_call_cbs_drawControl_c8285_1, &_set_callback_cbs_drawControl_c8285_1);
}


// void QCDEStyle::drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap)

static void _init_cbs_drawItemPixmap_c5678_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alignment");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawItemPixmap_c5678_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRect &arg2 = args.read<const QRect & > ();
  int arg3 = args.read<int > ();
  const QPixmap &arg4 = args.read<const QPixmap & > ();
  ((QCDEStyle_Adaptor *)cls)->cbs_drawItemPixmap_c5678_0 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawItemPixmap_c5678_0 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_drawItemPixmap_c5678_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawItemPixmap_c5678_0 ()
{
  return new qt_gsi::GenericMethod ("drawItemPixmap", "@hide", true, &_init_cbs_drawItemPixmap_c5678_0, &_call_cbs_drawItemPixmap_c5678_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawItemPixmap_c5678_0 ()
{
  return new qt_gsi::GenericMethod ("drawItemPixmap", "@brief Virtual method void QCDEStyle::drawItemPixmap(QPainter *painter, const QRect &rect, int alignment, const QPixmap &pixmap)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawItemPixmap_c5678_0, &_call_cbs_drawItemPixmap_c5678_0, &_set_callback_cbs_drawItemPixmap_c5678_0);
}


// void QCDEStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole)

static void _init_cbs_drawItemText_c10604_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("pal");
  decl->add_arg<const QPalette & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("enabled");
  decl->add_arg<bool > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("text");
  decl->add_arg<const QString & > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("textRole");
  decl->add_arg<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > (argspec_6);
  decl->set_return<void > ();
}

static void _call_cbs_drawItemText_c10604_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRect &arg2 = args.read<const QRect & > ();
  int arg3 = args.read<int > ();
  const QPalette &arg4 = args.read<const QPalette & > ();
  bool arg5 = args.read<bool > ();
  const QString &arg6 = args.read<const QString & > ();
  const qt_gsi::Converter<QPalette::ColorRole>::target_type & arg7 = args.read<const qt_gsi::Converter<QPalette::ColorRole>::target_type & > ();
  ((QCDEStyle_Adaptor *)cls)->cbs_drawItemText_c10604_1 (arg1, arg2, arg3, arg4, arg5, arg6, arg7);
}

static void _set_callback_cbs_drawItemText_c10604_1 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_drawItemText_c10604_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawItemText_c10604_1 ()
{
  return new qt_gsi::GenericMethod ("drawItemText", "@hide", true, &_init_cbs_drawItemText_c10604_1, &_call_cbs_drawItemText_c10604_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawItemText_c10604_1 ()
{
  return new qt_gsi::GenericMethod ("drawItemText", "@brief Virtual method void QCDEStyle::drawItemText(QPainter *painter, const QRect &rect, int flags, const QPalette &pal, bool enabled, const QString &text, QPalette::ColorRole textRole)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawItemText_c10604_1, &_call_cbs_drawItemText_c10604_1, &_set_callback_cbs_drawItemText_c10604_1);
}


// void QCDEStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)

static void _init_cbs_drawPrimitive_c8501_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pe");
  decl->add_arg<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("p");
  decl->add_arg<QPainter * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawPrimitive_c8501_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::PrimitiveElement>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  QPainter *arg3 = args.read<QPainter * > ();
  const QWidget *arg4 = args.read<const QWidget * > ();
  ((QCDEStyle_Adaptor *)cls)->cbs_drawPrimitive_c8501_1 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawPrimitive_c8501_1 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_drawPrimitive_c8501_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawPrimitive_c8501_1 ()
{
  return new qt_gsi::GenericMethod ("drawPrimitive", "@hide", true, &_init_cbs_drawPrimitive_c8501_1, &_call_cbs_drawPrimitive_c8501_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawPrimitive_c8501_1 ()
{
  return new qt_gsi::GenericMethod ("drawPrimitive", "@brief Virtual method void QCDEStyle::drawPrimitive(QStyle::PrimitiveElement pe, const QStyleOption *opt, QPainter *p, const QWidget *w)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawPrimitive_c8501_1, &_call_cbs_drawPrimitive_c8501_1, &_set_callback_cbs_drawPrimitive_c8501_1);
}


// bool QCDEStyle::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QCDEStyle_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QCDEStyle::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// QPixmap QCDEStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)

static void _init_cbs_generatedIconPixmap_c5776_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconMode");
  decl->add_arg<const qt_gsi::Converter<QIcon::Mode>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_cbs_generatedIconPixmap_c5776_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QIcon::Mode>::target_type & arg1 = args.read<const qt_gsi::Converter<QIcon::Mode>::target_type & > ();
  const QPixmap &arg2 = args.read<const QPixmap & > ();
  const QStyleOption *arg3 = args.read<const QStyleOption * > ();
  ret.write<QPixmap > ((QPixmap)((QCDEStyle_Adaptor *)cls)->cbs_generatedIconPixmap_c5776_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_generatedIconPixmap_c5776_0 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_generatedIconPixmap_c5776_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_generatedIconPixmap_c5776_0 ()
{
  return new qt_gsi::GenericMethod ("generatedIconPixmap", "@hide", true, &_init_cbs_generatedIconPixmap_c5776_0, &_call_cbs_generatedIconPixmap_c5776_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_generatedIconPixmap_c5776_0 ()
{
  return new qt_gsi::GenericMethod ("generatedIconPixmap", "@brief Virtual method QPixmap QCDEStyle::generatedIconPixmap(QIcon::Mode iconMode, const QPixmap &pixmap, const QStyleOption *opt)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_generatedIconPixmap_c5776_0, &_call_cbs_generatedIconPixmap_c5776_0, &_set_callback_cbs_generatedIconPixmap_c5776_0);
}


// QStyle::SubControl QCDEStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *w)

static void _init_cbs_hitTestComplexControl_c9517_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pt");
  decl->add_arg<const QPoint & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("w");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<qt_gsi::Converter<QStyle::SubControl>::target_type > ();
}

static void _call_cbs_hitTestComplexControl_c9517_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > ();
  const QStyleOptionComplex *arg2 = args.read<const QStyleOptionComplex * > ();
  const QPoint &arg3 = args.read<const QPoint & > ();
  const QWidget *arg4 = args.read<const QWidget * > ();
  ret.write<qt_gsi::Converter<QStyle::SubControl>::target_type > ((qt_gsi::Converter<QStyle::SubControl>::target_type)((QCDEStyle_Adaptor *)cls)->cbs_hitTestComplexControl_c9517_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_hitTestComplexControl_c9517_1 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_hitTestComplexControl_c9517_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hitTestComplexControl_c9517_1 ()
{
  return new qt_gsi::GenericMethod ("hitTestComplexControl", "@hide", true, &_init_cbs_hitTestComplexControl_c9517_1, &_call_cbs_hitTestComplexControl_c9517_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hitTestComplexControl_c9517_1 ()
{
  return new qt_gsi::GenericMethod ("hitTestComplexControl", "@brief Virtual method QStyle::SubControl QCDEStyle::hitTestComplexControl(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, const QPoint &pt, const QWidget *w)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hitTestComplexControl_c9517_1, &_call_cbs_hitTestComplexControl_c9517_1, &_set_callback_cbs_hitTestComplexControl_c9517_1);
}


// QRect QCDEStyle::itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap)

static void _init_cbs_itemPixmapRect_c4360_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_cbs_itemPixmapRect_c4360_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  int arg2 = args.read<int > ();
  const QPixmap &arg3 = args.read<const QPixmap & > ();
  ret.write<QRect > ((QRect)((QCDEStyle_Adaptor *)cls)->cbs_itemPixmapRect_c4360_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_itemPixmapRect_c4360_0 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_itemPixmapRect_c4360_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_itemPixmapRect_c4360_0 ()
{
  return new qt_gsi::GenericMethod ("itemPixmapRect", "@hide", true, &_init_cbs_itemPixmapRect_c4360_0, &_call_cbs_itemPixmapRect_c4360_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_itemPixmapRect_c4360_0 ()
{
  return new qt_gsi::GenericMethod ("itemPixmapRect", "@brief Virtual method QRect QCDEStyle::itemPixmapRect(const QRect &r, int flags, const QPixmap &pixmap)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemPixmapRect_c4360_0, &_call_cbs_itemPixmapRect_c4360_0, &_set_callback_cbs_itemPixmapRect_c4360_0);
}


// QRect QCDEStyle::itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text)

static void _init_cbs_itemTextRect_c7544_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fm");
  decl->add_arg<const QFontMetrics & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("r");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("flags");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("enabled");
  decl->add_arg<bool > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("text");
  decl->add_arg<const QString & > (argspec_4);
  decl->set_return<QRect > ();
}

static void _call_cbs_itemTextRect_c7544_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFontMetrics &arg1 = args.read<const QFontMetrics & > ();
  const QRect &arg2 = args.read<const QRect & > ();
  int arg3 = args.read<int > ();
  bool arg4 = args.read<bool > ();
  const QString &arg5 = args.read<const QString & > ();
  ret.write<QRect > ((QRect)((QCDEStyle_Adaptor *)cls)->cbs_itemTextRect_c7544_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_itemTextRect_c7544_0 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_itemTextRect_c7544_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_itemTextRect_c7544_0 ()
{
  return new qt_gsi::GenericMethod ("itemTextRect", "@hide", true, &_init_cbs_itemTextRect_c7544_0, &_call_cbs_itemTextRect_c7544_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_itemTextRect_c7544_0 ()
{
  return new qt_gsi::GenericMethod ("itemTextRect", "@brief Virtual method QRect QCDEStyle::itemTextRect(const QFontMetrics &fm, const QRect &r, int flags, bool enabled, const QString &text)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemTextRect_c7544_0, &_call_cbs_itemTextRect_c7544_0, &_set_callback_cbs_itemTextRect_c7544_0);
}


// int QCDEStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)

static void _init_cbs_pixelMetric_c6642_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metric");
  decl->add_arg<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<int > ();
}

static void _call_cbs_pixelMetric_c6642_2 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::PixelMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::PixelMetric>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  const QWidget *arg3 = args.read<const QWidget * > ();
  ret.write<int > ((int)((QCDEStyle_Adaptor *)cls)->cbs_pixelMetric_c6642_2 (arg1, arg2, arg3));
}

static void _set_callback_cbs_pixelMetric_c6642_2 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_pixelMetric_c6642_2 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_pixelMetric_c6642_2 ()
{
  return new qt_gsi::GenericMethod ("pixelMetric", "@hide", true, &_init_cbs_pixelMetric_c6642_2, &_call_cbs_pixelMetric_c6642_2);
}

static qt_gsi::GenericMethod *_create_callback_cbs_pixelMetric_c6642_2 ()
{
  return new qt_gsi::GenericMethod ("pixelMetric", "@brief Virtual method int QCDEStyle::pixelMetric(QStyle::PixelMetric metric, const QStyleOption *option, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_pixelMetric_c6642_2, &_call_cbs_pixelMetric_c6642_2, &_set_callback_cbs_pixelMetric_c6642_2);
}


// void QCDEStyle::polish(QPalette &)

static void _init_cbs_polish_1418_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_polish_1418_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPalette &arg1 = args.read<QPalette & > ();
  ((QCDEStyle_Adaptor *)cls)->cbs_polish_1418_0 (arg1);
}

static void _set_callback_cbs_polish_1418_0 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_polish_1418_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_polish_1418_0 ()
{
  return new qt_gsi::GenericMethod ("polish", "@hide", false, &_init_cbs_polish_1418_0, &_call_cbs_polish_1418_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_polish_1418_0 ()
{
  return new qt_gsi::GenericMethod ("polish", "@brief Virtual method void QCDEStyle::polish(QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_polish_1418_0, &_call_cbs_polish_1418_0, &_set_callback_cbs_polish_1418_0);
}


// void QCDEStyle::polish(QWidget *)

static void _init_cbs_polish_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_polish_1315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QCDEStyle_Adaptor *)cls)->cbs_polish_1315_0 (arg1);
}

static void _set_callback_cbs_polish_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_polish_1315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_polish_1315_0 ()
{
  return new qt_gsi::GenericMethod ("polish", "@hide", false, &_init_cbs_polish_1315_0, &_call_cbs_polish_1315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_polish_1315_0 ()
{
  return new qt_gsi::GenericMethod ("polish", "@brief Virtual method void QCDEStyle::polish(QWidget *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_polish_1315_0, &_call_cbs_polish_1315_0, &_set_callback_cbs_polish_1315_0);
}


// void QCDEStyle::polish(QApplication *)

static void _init_cbs_polish_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QApplication * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_polish_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QApplication *arg1 = args.read<QApplication * > ();
  ((QCDEStyle_Adaptor *)cls)->cbs_polish_1843_0 (arg1);
}

static void _set_callback_cbs_polish_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_polish_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_polish_1843_0 ()
{
  return new qt_gsi::GenericMethod ("polish", "@hide", false, &_init_cbs_polish_1843_0, &_call_cbs_polish_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_polish_1843_0 ()
{
  return new qt_gsi::GenericMethod ("polish", "@brief Virtual method void QCDEStyle::polish(QApplication *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_polish_1843_0, &_call_cbs_polish_1843_0, &_set_callback_cbs_polish_1843_0);
}


// QSize QCDEStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *widget)

static void _init_cbs_sizeFromContents_c8477_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ct");
  decl->add_arg<const qt_gsi::Converter<QStyle::ContentsType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("contentsSize");
  decl->add_arg<const QSize & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeFromContents_c8477_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::ContentsType>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ContentsType>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  const QSize &arg3 = args.read<const QSize & > ();
  const QWidget *arg4 = args.read<const QWidget * > ();
  ret.write<QSize > ((QSize)((QCDEStyle_Adaptor *)cls)->cbs_sizeFromContents_c8477_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_sizeFromContents_c8477_1 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_sizeFromContents_c8477_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeFromContents_c8477_1 ()
{
  return new qt_gsi::GenericMethod ("sizeFromContents", "@hide", true, &_init_cbs_sizeFromContents_c8477_1, &_call_cbs_sizeFromContents_c8477_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeFromContents_c8477_1 ()
{
  return new qt_gsi::GenericMethod ("sizeFromContents", "@brief Virtual method QSize QCDEStyle::sizeFromContents(QStyle::ContentsType ct, const QStyleOption *opt, const QSize &contentsSize, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeFromContents_c8477_1, &_call_cbs_sizeFromContents_c8477_1, &_set_callback_cbs_sizeFromContents_c8477_1);
}


// QPalette QCDEStyle::standardPalette()

static void _init_cbs_standardPalette_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPalette > ();
}

static void _call_cbs_standardPalette_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPalette > ((QPalette)((QCDEStyle_Adaptor *)cls)->cbs_standardPalette_c0_0 ());
}

static void _set_callback_cbs_standardPalette_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_standardPalette_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_standardPalette_c0_0 ()
{
  return new qt_gsi::GenericMethod ("standardPalette", "@hide", true, &_init_cbs_standardPalette_c0_0, &_call_cbs_standardPalette_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_standardPalette_c0_0 ()
{
  return new qt_gsi::GenericMethod ("standardPalette", "@brief Virtual method QPalette QCDEStyle::standardPalette()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_standardPalette_c0_0, &_call_cbs_standardPalette_c0_0, &_set_callback_cbs_standardPalette_c0_0);
}


// QPixmap QCDEStyle::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption *opt, const QWidget *widget)

static void _init_cbs_standardPixmap_c6956_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("standardPixmap");
  decl->add_arg<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_cbs_standardPixmap_c6956_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::StandardPixmap>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  const QWidget *arg3 = args.read<const QWidget * > ();
  ret.write<QPixmap > ((QPixmap)((QCDEStyle_Adaptor *)cls)->cbs_standardPixmap_c6956_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_standardPixmap_c6956_1 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_standardPixmap_c6956_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_standardPixmap_c6956_1 ()
{
  return new qt_gsi::GenericMethod ("standardPixmap", "@hide", true, &_init_cbs_standardPixmap_c6956_1, &_call_cbs_standardPixmap_c6956_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_standardPixmap_c6956_1 ()
{
  return new qt_gsi::GenericMethod ("standardPixmap", "@brief Virtual method QPixmap QCDEStyle::standardPixmap(QStyle::StandardPixmap standardPixmap, const QStyleOption *opt, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_standardPixmap_c6956_1, &_call_cbs_standardPixmap_c6956_1, &_set_callback_cbs_standardPixmap_c6956_1);
}


// int QCDEStyle::styleHint(QStyle::StyleHint hint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData)

static void _init_cbs_styleHint_c8615_3 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hint");
  decl->add_arg<const qt_gsi::Converter<QStyle::StyleHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("returnData");
  decl->add_arg<QStyleHintReturn * > (argspec_3);
  decl->set_return<int > ();
}

static void _call_cbs_styleHint_c8615_3 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::StyleHint>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::StyleHint>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  const QWidget *arg3 = args.read<const QWidget * > ();
  QStyleHintReturn *arg4 = args.read<QStyleHintReturn * > ();
  ret.write<int > ((int)((QCDEStyle_Adaptor *)cls)->cbs_styleHint_c8615_3 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_styleHint_c8615_3 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_styleHint_c8615_3 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleHint_c8615_3 ()
{
  return new qt_gsi::GenericMethod ("styleHint", "@hide", true, &_init_cbs_styleHint_c8615_3, &_call_cbs_styleHint_c8615_3);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleHint_c8615_3 ()
{
  return new qt_gsi::GenericMethod ("styleHint", "@brief Virtual method int QCDEStyle::styleHint(QStyle::StyleHint hint, const QStyleOption *opt, const QWidget *widget, QStyleHintReturn *returnData)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_styleHint_c8615_3, &_call_cbs_styleHint_c8615_3, &_set_callback_cbs_styleHint_c8615_3);
}


// QRect QCDEStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget)

static void _init_cbs_subControlRect_c9798_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("cc");
  decl->add_arg<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOptionComplex * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sc");
  decl->add_arg<const qt_gsi::Converter<QStyle::SubControl>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("widget");
  decl->add_arg<const QWidget * > (argspec_3);
  decl->set_return<QRect > ();
}

static void _call_cbs_subControlRect_c9798_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::ComplexControl>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::ComplexControl>::target_type & > ();
  const QStyleOptionComplex *arg2 = args.read<const QStyleOptionComplex * > ();
  const qt_gsi::Converter<QStyle::SubControl>::target_type & arg3 = args.read<const qt_gsi::Converter<QStyle::SubControl>::target_type & > ();
  const QWidget *arg4 = args.read<const QWidget * > ();
  ret.write<QRect > ((QRect)((QCDEStyle_Adaptor *)cls)->cbs_subControlRect_c9798_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_subControlRect_c9798_1 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_subControlRect_c9798_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_subControlRect_c9798_1 ()
{
  return new qt_gsi::GenericMethod ("subControlRect", "@hide", true, &_init_cbs_subControlRect_c9798_1, &_call_cbs_subControlRect_c9798_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_subControlRect_c9798_1 ()
{
  return new qt_gsi::GenericMethod ("subControlRect", "@brief Virtual method QRect QCDEStyle::subControlRect(QStyle::ComplexControl cc, const QStyleOptionComplex *opt, QStyle::SubControl sc, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_subControlRect_c9798_1, &_call_cbs_subControlRect_c9798_1, &_set_callback_cbs_subControlRect_c9798_1);
}


// QRect QCDEStyle::subElementRect(QStyle::SubElement r, const QStyleOption *opt, const QWidget *widget)

static void _init_cbs_subElementRect_c6528_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const qt_gsi::Converter<QStyle::SubElement>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("opt");
  decl->add_arg<const QStyleOption * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<const QWidget * > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_cbs_subElementRect_c6528_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStyle::SubElement>::target_type & arg1 = args.read<const qt_gsi::Converter<QStyle::SubElement>::target_type & > ();
  const QStyleOption *arg2 = args.read<const QStyleOption * > ();
  const QWidget *arg3 = args.read<const QWidget * > ();
  ret.write<QRect > ((QRect)((QCDEStyle_Adaptor *)cls)->cbs_subElementRect_c6528_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_subElementRect_c6528_1 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_subElementRect_c6528_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_subElementRect_c6528_1 ()
{
  return new qt_gsi::GenericMethod ("subElementRect", "@hide", true, &_init_cbs_subElementRect_c6528_1, &_call_cbs_subElementRect_c6528_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_subElementRect_c6528_1 ()
{
  return new qt_gsi::GenericMethod ("subElementRect", "@brief Virtual method QRect QCDEStyle::subElementRect(QStyle::SubElement r, const QStyleOption *opt, const QWidget *widget)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_subElementRect_c6528_1, &_call_cbs_subElementRect_c6528_1, &_set_callback_cbs_subElementRect_c6528_1);
}


// void QCDEStyle::unpolish(QWidget *)

static void _init_cbs_unpolish_1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_unpolish_1315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QCDEStyle_Adaptor *)cls)->cbs_unpolish_1315_0 (arg1);
}

static void _set_callback_cbs_unpolish_1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_unpolish_1315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_unpolish_1315_0 ()
{
  return new qt_gsi::GenericMethod ("unpolish", "@hide", false, &_init_cbs_unpolish_1315_0, &_call_cbs_unpolish_1315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_unpolish_1315_0 ()
{
  return new qt_gsi::GenericMethod ("unpolish", "@brief Virtual method void QCDEStyle::unpolish(QWidget *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unpolish_1315_0, &_call_cbs_unpolish_1315_0, &_set_callback_cbs_unpolish_1315_0);
}


// void QCDEStyle::unpolish(QApplication *)

static void _init_cbs_unpolish_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QApplication * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_unpolish_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QApplication *arg1 = args.read<QApplication * > ();
  ((QCDEStyle_Adaptor *)cls)->cbs_unpolish_1843_0 (arg1);
}

static void _set_callback_cbs_unpolish_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_unpolish_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_unpolish_1843_0 ()
{
  return new qt_gsi::GenericMethod ("unpolish", "@hide", false, &_init_cbs_unpolish_1843_0, &_call_cbs_unpolish_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_unpolish_1843_0 ()
{
  return new qt_gsi::GenericMethod ("unpolish", "@brief Virtual method void QCDEStyle::unpolish(QApplication *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_unpolish_1843_0, &_call_cbs_unpolish_1843_0, &_set_callback_cbs_unpolish_1843_0);
}


// void QCDEStyle::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QCDEStyle_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCDEStyle::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QCDEStyle::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QCDEStyle_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCDEStyle::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QCDEStyle::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QCDEStyle_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCDEStyle::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// bool QCDEStyle::eventFilter(QObject *o, QEvent *e)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("o");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("e");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QCDEStyle_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QCDEStyle::eventFilter(QObject *o, QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QCDEStyle::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QCDEStyle_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCDEStyle_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCDEStyle::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QCDEStyle> decl_QCDEStyle;

gsi::Class<QCDEStyle_Adaptor> decl_QCDEStyle_Adaptor (decl_QCDEStyle, "QCDEStyle",
  gsi::Methods(_create_fp_layoutSpacingImplementation_c11697 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_standardIconImplementation_c6956 ()) +
  gsi::Methods(_create_cbs_drawComplexControl_c9027_1 ()) +
  gsi::Methods(_create_callback_cbs_drawComplexControl_c9027_1 ()) +
  gsi::Methods(_create_cbs_drawControl_c8285_1 ()) +
  gsi::Methods(_create_callback_cbs_drawControl_c8285_1 ()) +
  gsi::Methods(_create_cbs_drawItemPixmap_c5678_0 ()) +
  gsi::Methods(_create_callback_cbs_drawItemPixmap_c5678_0 ()) +
  gsi::Methods(_create_cbs_drawItemText_c10604_1 ()) +
  gsi::Methods(_create_callback_cbs_drawItemText_c10604_1 ()) +
  gsi::Methods(_create_cbs_drawPrimitive_c8501_1 ()) +
  gsi::Methods(_create_callback_cbs_drawPrimitive_c8501_1 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_generatedIconPixmap_c5776_0 ()) +
  gsi::Methods(_create_callback_cbs_generatedIconPixmap_c5776_0 ()) +
  gsi::Methods(_create_cbs_hitTestComplexControl_c9517_1 ()) +
  gsi::Methods(_create_callback_cbs_hitTestComplexControl_c9517_1 ()) +
  gsi::Methods(_create_cbs_itemPixmapRect_c4360_0 ()) +
  gsi::Methods(_create_callback_cbs_itemPixmapRect_c4360_0 ()) +
  gsi::Methods(_create_cbs_itemTextRect_c7544_0 ()) +
  gsi::Methods(_create_callback_cbs_itemTextRect_c7544_0 ()) +
  gsi::Methods(_create_cbs_pixelMetric_c6642_2 ()) +
  gsi::Methods(_create_callback_cbs_pixelMetric_c6642_2 ()) +
  gsi::Methods(_create_cbs_polish_1418_0 ()) +
  gsi::Methods(_create_callback_cbs_polish_1418_0 ()) +
  gsi::Methods(_create_cbs_polish_1315_0 ()) +
  gsi::Methods(_create_callback_cbs_polish_1315_0 ()) +
  gsi::Methods(_create_cbs_polish_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_polish_1843_0 ()) +
  gsi::Methods(_create_cbs_sizeFromContents_c8477_1 ()) +
  gsi::Methods(_create_callback_cbs_sizeFromContents_c8477_1 ()) +
  gsi::Methods(_create_cbs_standardPalette_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_standardPalette_c0_0 ()) +
  gsi::Methods(_create_cbs_standardPixmap_c6956_1 ()) +
  gsi::Methods(_create_callback_cbs_standardPixmap_c6956_1 ()) +
  gsi::Methods(_create_cbs_styleHint_c8615_3 ()) +
  gsi::Methods(_create_callback_cbs_styleHint_c8615_3 ()) +
  gsi::Methods(_create_cbs_subControlRect_c9798_1 ()) +
  gsi::Methods(_create_callback_cbs_subControlRect_c9798_1 ()) +
  gsi::Methods(_create_cbs_subElementRect_c6528_1 ()) +
  gsi::Methods(_create_callback_cbs_subElementRect_c6528_1 ()) +
  gsi::Methods(_create_cbs_unpolish_1315_0 ()) +
  gsi::Methods(_create_callback_cbs_unpolish_1315_0 ()) +
  gsi::Methods(_create_cbs_unpolish_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_unpolish_1843_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QCDEStyle_Adaptor_864 ()),
  "@qt\n@brief Binding of QCDEStyle");

}

