
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAbstractTextDocumentLayout.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQAbstractTextDocumentLayout_EventAdaptor.h"
#include "gsiDeclQAbstractTextDocumentLayout_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAbstractTextDocumentLayout

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAbstractTextDocumentLayout::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QString QAbstractTextDocumentLayout::anchorAt(const QPointF &pos)


static void _init_f_anchorAt_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_anchorAt_c1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<QString > ((QString)((QAbstractTextDocumentLayout *)cls)->anchorAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_anchorAt_c1986 ()
{
  return new qt_gsi::GenericMethod ("anchorAt", "@brief Method QString QAbstractTextDocumentLayout::anchorAt(const QPointF &pos)\n", true, &_init_f_anchorAt_c1986, &_call_f_anchorAt_c1986);
}

// QRectF QAbstractTextDocumentLayout::blockBoundingRect(const QTextBlock &block)


static void _init_f_blockBoundingRect_c2306 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_blockBoundingRect_c2306 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextBlock &arg1 = args.read<const QTextBlock & > ();
  ret.write<QRectF > ((QRectF)((QAbstractTextDocumentLayout *)cls)->blockBoundingRect (arg1));
}

static qt_gsi::GenericMethod *_create_f_blockBoundingRect_c2306 ()
{
  return new qt_gsi::GenericMethod ("blockBoundingRect", "@brief Method QRectF QAbstractTextDocumentLayout::blockBoundingRect(const QTextBlock &block)\n", true, &_init_f_blockBoundingRect_c2306, &_call_f_blockBoundingRect_c2306);
}

// QTextDocument *QAbstractTextDocumentLayout::document()


static void _init_f_document_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextDocument * > ();
}

static void _call_f_document_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextDocument * > ((QTextDocument *)((QAbstractTextDocumentLayout *)cls)->document ());
}

static qt_gsi::GenericMethod *_create_f_document_c0 ()
{
  return new qt_gsi::GenericMethod ("document", "@brief Method QTextDocument *QAbstractTextDocumentLayout::document()\n", true, &_init_f_document_c0, &_call_f_document_c0);
}

// QSizeF QAbstractTextDocumentLayout::documentSize()


static void _init_f_documentSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_f_documentSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSizeF > ((QSizeF)((QAbstractTextDocumentLayout *)cls)->documentSize ());
}

static qt_gsi::GenericMethod *_create_f_documentSize_c0 ()
{
  return new qt_gsi::GenericMethod ("documentSize", "@brief Method QSizeF QAbstractTextDocumentLayout::documentSize()\n", true, &_init_f_documentSize_c0, &_call_f_documentSize_c0);
}

// void QAbstractTextDocumentLayout::draw(QPainter *painter, const QAbstractTextDocumentLayout::PaintContext &context)


static void _init_f_draw_6787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("context");
  decl->add_arg<const QAbstractTextDocumentLayout::PaintContext & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_draw_6787 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QAbstractTextDocumentLayout::PaintContext &arg2 = args.read<const QAbstractTextDocumentLayout::PaintContext & > ();
  ((QAbstractTextDocumentLayout *)cls)->draw (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_draw_6787 ()
{
  return new qt_gsi::GenericMethod ("draw", "@brief Method void QAbstractTextDocumentLayout::draw(QPainter *painter, const QAbstractTextDocumentLayout::PaintContext &context)\n", false, &_init_f_draw_6787, &_call_f_draw_6787);
}

// QRectF QAbstractTextDocumentLayout::frameBoundingRect(QTextFrame *frame)


static void _init_f_frameBoundingRect_c1615 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frame");
  decl->add_arg<QTextFrame * > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_f_frameBoundingRect_c1615 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextFrame *arg1 = args.read<QTextFrame * > ();
  ret.write<QRectF > ((QRectF)((QAbstractTextDocumentLayout *)cls)->frameBoundingRect (arg1));
}

static qt_gsi::GenericMethod *_create_f_frameBoundingRect_c1615 ()
{
  return new qt_gsi::GenericMethod ("frameBoundingRect", "@brief Method QRectF QAbstractTextDocumentLayout::frameBoundingRect(QTextFrame *frame)\n", true, &_init_f_frameBoundingRect_c1615, &_call_f_frameBoundingRect_c1615);
}

// QTextObjectInterface *QAbstractTextDocumentLayout::handlerForObject(int objectType)


static void _init_f_handlerForObject_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectType");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextObjectInterface * > ();
}

static void _call_f_handlerForObject_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QTextObjectInterface * > ((QTextObjectInterface *)((QAbstractTextDocumentLayout *)cls)->handlerForObject (arg1));
}

static qt_gsi::GenericMethod *_create_f_handlerForObject_c767 ()
{
  return new qt_gsi::GenericMethod ("handlerForObject", "@brief Method QTextObjectInterface *QAbstractTextDocumentLayout::handlerForObject(int objectType)\n", true, &_init_f_handlerForObject_c767, &_call_f_handlerForObject_c767);
}

// int QAbstractTextDocumentLayout::hitTest(const QPointF &point, Qt::HitTestAccuracy accuracy)


static void _init_f_hitTest_c4147 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("accuracy");
  decl->add_arg<const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_hitTest_c4147 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & > ();
  ret.write<int > ((int)((QAbstractTextDocumentLayout *)cls)->hitTest (arg1, qt_gsi::QtToCppAdaptor<Qt::HitTestAccuracy>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_hitTest_c4147 ()
{
  return new qt_gsi::GenericMethod ("hitTest", "@brief Method int QAbstractTextDocumentLayout::hitTest(const QPointF &point, Qt::HitTestAccuracy accuracy)\n", true, &_init_f_hitTest_c4147, &_call_f_hitTest_c4147);
}

// int QAbstractTextDocumentLayout::pageCount()


static void _init_f_pageCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_pageCount_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QAbstractTextDocumentLayout *)cls)->pageCount ());
}

static qt_gsi::GenericMethod *_create_f_pageCount_c0 ()
{
  return new qt_gsi::GenericMethod ("pageCount", "@brief Method int QAbstractTextDocumentLayout::pageCount()\n", true, &_init_f_pageCount_c0, &_call_f_pageCount_c0);
}

// QPaintDevice *QAbstractTextDocumentLayout::paintDevice()


static void _init_f_paintDevice_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintDevice * > ();
}

static void _call_f_paintDevice_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintDevice * > ((QPaintDevice *)((QAbstractTextDocumentLayout *)cls)->paintDevice ());
}

static qt_gsi::GenericMethod *_create_f_paintDevice_c0 ()
{
  return new qt_gsi::GenericMethod (":paintDevice", "@brief Method QPaintDevice *QAbstractTextDocumentLayout::paintDevice()\n", true, &_init_f_paintDevice_c0, &_call_f_paintDevice_c0);
}

// void QAbstractTextDocumentLayout::registerHandler(int objectType, QObject *component)


static void _init_f_registerHandler_1961 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectType");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("component");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_registerHandler_1961 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QObject *arg2 = args.read<QObject * > ();
  ((QAbstractTextDocumentLayout *)cls)->registerHandler (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_registerHandler_1961 ()
{
  return new qt_gsi::GenericMethod ("registerHandler", "@brief Method void QAbstractTextDocumentLayout::registerHandler(int objectType, QObject *component)\n", false, &_init_f_registerHandler_1961, &_call_f_registerHandler_1961);
}

// void QAbstractTextDocumentLayout::setPaintDevice(QPaintDevice *device)


static void _init_f_setPaintDevice_1803 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QPaintDevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPaintDevice_1803 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintDevice *arg1 = args.read<QPaintDevice * > ();
  ((QAbstractTextDocumentLayout *)cls)->setPaintDevice (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPaintDevice_1803 ()
{
  return new qt_gsi::GenericMethod ("setPaintDevice|paintDevice=", "@brief Method void QAbstractTextDocumentLayout::setPaintDevice(QPaintDevice *device)\n", false, &_init_f_setPaintDevice_1803, &_call_f_setPaintDevice_1803);
}

// static QString QAbstractTextDocumentLayout::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QAbstractTextDocumentLayout::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractTextDocumentLayout::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QAbstractTextDocumentLayout::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QAbstractTextDocumentLayout::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractTextDocumentLayout::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QAbstractTextDocumentLayout::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QAbstractTextDocumentLayout::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractTextDocumentLayout::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QAbstractTextDocumentLayout::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QAbstractTextDocumentLayout::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractTextDocumentLayout::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QAbstractTextDocumentLayout, QAbstractTextDocumentLayout_EventAdaptor> ea_QAbstractTextDocumentLayout;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QAbstractTextDocumentLayout> decl_QAbstractTextDocumentLayout (ea_QAbstractTextDocumentLayout, decl_QObject, "QAbstractTextDocumentLayout_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_anchorAt_c1986 ()) +
  gsi::Methods(_create_f_blockBoundingRect_c2306 ()) +
  gsi::Methods(_create_f_document_c0 ()) +
  gsi::Methods(_create_f_documentSize_c0 ()) +
  gsi::Methods(_create_f_draw_6787 ()) +
  gsi::Methods(_create_f_frameBoundingRect_c1615 ()) +
  gsi::Methods(_create_f_handlerForObject_c767 ()) +
  gsi::Methods(_create_f_hitTest_c4147 ()) +
  gsi::Methods(_create_f_pageCount_c0 ()) +
  gsi::Methods(_create_f_paintDevice_c0 ()) +
  gsi::Methods(_create_f_registerHandler_1961 ()) +
  gsi::Methods(_create_f_setPaintDevice_1803 ()) +
  qt_gsi::qt_signal<QAbstractTextDocumentLayout, QAbstractTextDocumentLayout_EventAdaptor, QObject *> ("destroyed", &QAbstractTextDocumentLayout_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QAbstractTextDocumentLayout::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractTextDocumentLayout, QAbstractTextDocumentLayout_EventAdaptor, const QSizeF &> ("documentSizeChanged", &QAbstractTextDocumentLayout_EventAdaptor::documentSizeChanged_e_1875, gsi::arg("newSize"), "@brief Signal declaration for QAbstractTextDocumentLayout::documentSizeChanged(const QSizeF &newSize)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractTextDocumentLayout, QAbstractTextDocumentLayout_EventAdaptor, int> ("pageCountChanged", &QAbstractTextDocumentLayout_EventAdaptor::pageCountChanged_e_767, gsi::arg("newPages"), "@brief Signal declaration for QAbstractTextDocumentLayout::pageCountChanged(int newPages)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractTextDocumentLayout, QAbstractTextDocumentLayout_EventAdaptor, const QRectF &> ("update", &QAbstractTextDocumentLayout_EventAdaptor::update_e_1862, gsi::arg("arg1"), "@brief Signal declaration for QAbstractTextDocumentLayout::update(const QRectF &)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractTextDocumentLayout, QAbstractTextDocumentLayout_EventAdaptor, const QTextBlock &> ("updateBlock", &QAbstractTextDocumentLayout_EventAdaptor::updateBlock_e_2306, gsi::arg("block"), "@brief Signal declaration for QAbstractTextDocumentLayout::updateBlock(const QTextBlock &block)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QAbstractTextDocumentLayout");
}


class QAbstractTextDocumentLayout_Adaptor : public QAbstractTextDocumentLayout, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAbstractTextDocumentLayout_Adaptor();

  //  [adaptor ctor] QAbstractTextDocumentLayout::QAbstractTextDocumentLayout(QTextDocument *doc)
  QAbstractTextDocumentLayout_Adaptor(QTextDocument *doc) : QAbstractTextDocumentLayout(doc)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  QTextCharFormat QAbstractTextDocumentLayout::format(int pos)
  QTextCharFormat fp_QAbstractTextDocumentLayout_format_767 (int pos) {
    return QAbstractTextDocumentLayout::format(pos);
  }

  //  int QAbstractTextDocumentLayout::formatIndex(int pos)
  int fp_QAbstractTextDocumentLayout_formatIndex_767 (int pos) {
    return QAbstractTextDocumentLayout::formatIndex(pos);
  }

  //  int QAbstractTextDocumentLayout::receivers(const char *signal)
  int fp_QAbstractTextDocumentLayout_receivers_c1731 (const char *signal) const {
    return QAbstractTextDocumentLayout::receivers(signal);
  }

  //  QObject *QAbstractTextDocumentLayout::sender()
  QObject * fp_QAbstractTextDocumentLayout_sender_c0 () const {
    return QAbstractTextDocumentLayout::sender();
  }

  //  [adaptor impl] QRectF QAbstractTextDocumentLayout::blockBoundingRect(const QTextBlock &block)
  QRectF cbs_blockBoundingRect_c2306_0(const QTextBlock &block) const
  {
    throw qt_gsi::AbstractMethodCalledException("blockBoundingRect");
  }

  virtual QRectF blockBoundingRect(const QTextBlock &block) const
  {
    if (cb_blockBoundingRect_c2306_0.can_issue()) {
      return cb_blockBoundingRect_c2306_0.issue<QAbstractTextDocumentLayout_Adaptor, QRectF, const QTextBlock &>(&QAbstractTextDocumentLayout_Adaptor::cbs_blockBoundingRect_c2306_0, block);
    } else {
      throw qt_gsi::AbstractMethodCalledException("blockBoundingRect");
    }
  }

  //  [adaptor impl] QSizeF QAbstractTextDocumentLayout::documentSize()
  QSizeF cbs_documentSize_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("documentSize");
  }

  virtual QSizeF documentSize() const
  {
    if (cb_documentSize_c0_0.can_issue()) {
      return cb_documentSize_c0_0.issue<QAbstractTextDocumentLayout_Adaptor, QSizeF>(&QAbstractTextDocumentLayout_Adaptor::cbs_documentSize_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("documentSize");
    }
  }

  //  [adaptor impl] void QAbstractTextDocumentLayout::draw(QPainter *painter, const QAbstractTextDocumentLayout::PaintContext &context)
  void cbs_draw_6787_0(QPainter *painter, const QAbstractTextDocumentLayout::PaintContext &context)
  {
    throw qt_gsi::AbstractMethodCalledException("draw");
  }

  virtual void draw(QPainter *painter, const QAbstractTextDocumentLayout::PaintContext &context)
  {
    if (cb_draw_6787_0.can_issue()) {
      cb_draw_6787_0.issue<QAbstractTextDocumentLayout_Adaptor, QPainter *, const QAbstractTextDocumentLayout::PaintContext &>(&QAbstractTextDocumentLayout_Adaptor::cbs_draw_6787_0, painter, context);
    } else {
      throw qt_gsi::AbstractMethodCalledException("draw");
    }
  }

  //  [adaptor impl] bool QAbstractTextDocumentLayout::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QAbstractTextDocumentLayout::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAbstractTextDocumentLayout_Adaptor, bool, QEvent *>(&QAbstractTextDocumentLayout_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QAbstractTextDocumentLayout::event(arg1);
    }
  }

  //  [adaptor impl] bool QAbstractTextDocumentLayout::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QAbstractTextDocumentLayout::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAbstractTextDocumentLayout_Adaptor, bool, QObject *, QEvent *>(&QAbstractTextDocumentLayout_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QAbstractTextDocumentLayout::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QRectF QAbstractTextDocumentLayout::frameBoundingRect(QTextFrame *frame)
  QRectF cbs_frameBoundingRect_c1615_0(QTextFrame *frame) const
  {
    throw qt_gsi::AbstractMethodCalledException("frameBoundingRect");
  }

  virtual QRectF frameBoundingRect(QTextFrame *frame) const
  {
    if (cb_frameBoundingRect_c1615_0.can_issue()) {
      return cb_frameBoundingRect_c1615_0.issue<QAbstractTextDocumentLayout_Adaptor, QRectF, QTextFrame *>(&QAbstractTextDocumentLayout_Adaptor::cbs_frameBoundingRect_c1615_0, frame);
    } else {
      throw qt_gsi::AbstractMethodCalledException("frameBoundingRect");
    }
  }

  //  [adaptor impl] int QAbstractTextDocumentLayout::hitTest(const QPointF &point, Qt::HitTestAccuracy accuracy)
  int cbs_hitTest_c4147_0(const QPointF &point, const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & accuracy) const
  {
    throw qt_gsi::AbstractMethodCalledException("hitTest");
  }

  virtual int hitTest(const QPointF &point, Qt::HitTestAccuracy accuracy) const
  {
    if (cb_hitTest_c4147_0.can_issue()) {
      return cb_hitTest_c4147_0.issue<QAbstractTextDocumentLayout_Adaptor, int, const QPointF &, const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type &>(&QAbstractTextDocumentLayout_Adaptor::cbs_hitTest_c4147_0, point, qt_gsi::CppToQtAdaptor<Qt::HitTestAccuracy>(accuracy));
    } else {
      throw qt_gsi::AbstractMethodCalledException("hitTest");
    }
  }

  //  [adaptor impl] int QAbstractTextDocumentLayout::pageCount()
  int cbs_pageCount_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("pageCount");
  }

  virtual int pageCount() const
  {
    if (cb_pageCount_c0_0.can_issue()) {
      return cb_pageCount_c0_0.issue<QAbstractTextDocumentLayout_Adaptor, int>(&QAbstractTextDocumentLayout_Adaptor::cbs_pageCount_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("pageCount");
    }
  }

  //  [adaptor impl] void QAbstractTextDocumentLayout::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QAbstractTextDocumentLayout::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAbstractTextDocumentLayout_Adaptor, QChildEvent *>(&QAbstractTextDocumentLayout_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QAbstractTextDocumentLayout::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractTextDocumentLayout::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QAbstractTextDocumentLayout::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAbstractTextDocumentLayout_Adaptor, QEvent *>(&QAbstractTextDocumentLayout_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QAbstractTextDocumentLayout::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractTextDocumentLayout::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QAbstractTextDocumentLayout::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QAbstractTextDocumentLayout_Adaptor, const char *>(&QAbstractTextDocumentLayout_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QAbstractTextDocumentLayout::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QAbstractTextDocumentLayout::documentChanged(int from, int charsRemoved, int charsAdded)
  void cbs_documentChanged_2085_0(int from, int charsRemoved, int charsAdded)
  {
    throw qt_gsi::AbstractMethodCalledException("documentChanged");
  }

  virtual void documentChanged(int from, int charsRemoved, int charsAdded)
  {
    if (cb_documentChanged_2085_0.can_issue()) {
      cb_documentChanged_2085_0.issue<QAbstractTextDocumentLayout_Adaptor, int, int, int>(&QAbstractTextDocumentLayout_Adaptor::cbs_documentChanged_2085_0, from, charsRemoved, charsAdded);
    } else {
      throw qt_gsi::AbstractMethodCalledException("documentChanged");
    }
  }

  //  [adaptor impl] void QAbstractTextDocumentLayout::drawInlineObject(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)
  void cbs_drawInlineObject_8199_0(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)
  {
    QAbstractTextDocumentLayout::drawInlineObject(painter, rect, object, posInDocument, format);
  }

  virtual void drawInlineObject(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)
  {
    if (cb_drawInlineObject_8199_0.can_issue()) {
      cb_drawInlineObject_8199_0.issue<QAbstractTextDocumentLayout_Adaptor, QPainter *, const QRectF &, QTextInlineObject, int, const QTextFormat &>(&QAbstractTextDocumentLayout_Adaptor::cbs_drawInlineObject_8199_0, painter, rect, object, posInDocument, format);
    } else {
      QAbstractTextDocumentLayout::drawInlineObject(painter, rect, object, posInDocument, format);
    }
  }

  //  [adaptor impl] void QAbstractTextDocumentLayout::positionInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  void cbs_positionInlineObject_5127_0(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  {
    QAbstractTextDocumentLayout::positionInlineObject(item, posInDocument, format);
  }

  virtual void positionInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  {
    if (cb_positionInlineObject_5127_0.can_issue()) {
      cb_positionInlineObject_5127_0.issue<QAbstractTextDocumentLayout_Adaptor, QTextInlineObject, int, const QTextFormat &>(&QAbstractTextDocumentLayout_Adaptor::cbs_positionInlineObject_5127_0, item, posInDocument, format);
    } else {
      QAbstractTextDocumentLayout::positionInlineObject(item, posInDocument, format);
    }
  }

  //  [adaptor impl] void QAbstractTextDocumentLayout::resizeInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  void cbs_resizeInlineObject_5127_0(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  {
    QAbstractTextDocumentLayout::resizeInlineObject(item, posInDocument, format);
  }

  virtual void resizeInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)
  {
    if (cb_resizeInlineObject_5127_0.can_issue()) {
      cb_resizeInlineObject_5127_0.issue<QAbstractTextDocumentLayout_Adaptor, QTextInlineObject, int, const QTextFormat &>(&QAbstractTextDocumentLayout_Adaptor::cbs_resizeInlineObject_5127_0, item, posInDocument, format);
    } else {
      QAbstractTextDocumentLayout::resizeInlineObject(item, posInDocument, format);
    }
  }

  //  [adaptor impl] void QAbstractTextDocumentLayout::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QAbstractTextDocumentLayout::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAbstractTextDocumentLayout_Adaptor, QTimerEvent *>(&QAbstractTextDocumentLayout_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QAbstractTextDocumentLayout::timerEvent(arg1);
    }
  }

  gsi::Callback cb_blockBoundingRect_c2306_0;
  gsi::Callback cb_documentSize_c0_0;
  gsi::Callback cb_draw_6787_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_frameBoundingRect_c1615_0;
  gsi::Callback cb_hitTest_c4147_0;
  gsi::Callback cb_pageCount_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_documentChanged_2085_0;
  gsi::Callback cb_drawInlineObject_8199_0;
  gsi::Callback cb_positionInlineObject_5127_0;
  gsi::Callback cb_resizeInlineObject_5127_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QAbstractTextDocumentLayout_Adaptor::~QAbstractTextDocumentLayout_Adaptor() { }

//  Constructor QAbstractTextDocumentLayout::QAbstractTextDocumentLayout(QTextDocument *doc) (adaptor class)

static void _init_ctor_QAbstractTextDocumentLayout_Adaptor_1955 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("doc");
  decl->add_arg<QTextDocument * > (argspec_0);
  decl->set_return_new<QAbstractTextDocumentLayout_Adaptor *> ();
}

static void _call_ctor_QAbstractTextDocumentLayout_Adaptor_1955 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextDocument *arg1 = args.read<QTextDocument * > ();
  ret.write<QAbstractTextDocumentLayout_Adaptor *> (new QAbstractTextDocumentLayout_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QAbstractTextDocumentLayout_Adaptor_1955 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAbstractTextDocumentLayout::QAbstractTextDocumentLayout(QTextDocument *doc)\nThis method creates an object of class QAbstractTextDocumentLayout.", &_init_ctor_QAbstractTextDocumentLayout_Adaptor_1955, &_call_ctor_QAbstractTextDocumentLayout_Adaptor_1955);
}

// QTextCharFormat QAbstractTextDocumentLayout::format(int pos)

static void _init_fp_format_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QTextCharFormat > ();
}

static void _call_fp_format_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QTextCharFormat > ((QTextCharFormat)((QAbstractTextDocumentLayout_Adaptor *)cls)->fp_QAbstractTextDocumentLayout_format_767 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_format_767 ()
{
  return new qt_gsi::GenericMethod("*format", "@brief Method QTextCharFormat QAbstractTextDocumentLayout::format(int pos)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_format_767, &_call_fp_format_767);
}


// int QAbstractTextDocumentLayout::formatIndex(int pos)

static void _init_fp_formatIndex_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_formatIndex_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QAbstractTextDocumentLayout_Adaptor *)cls)->fp_QAbstractTextDocumentLayout_formatIndex_767 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_formatIndex_767 ()
{
  return new qt_gsi::GenericMethod("*formatIndex", "@brief Method int QAbstractTextDocumentLayout::formatIndex(int pos)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_formatIndex_767, &_call_fp_formatIndex_767);
}


// int QAbstractTextDocumentLayout::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QAbstractTextDocumentLayout_Adaptor *)cls)->fp_QAbstractTextDocumentLayout_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QAbstractTextDocumentLayout::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QAbstractTextDocumentLayout::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QAbstractTextDocumentLayout_Adaptor *)cls)->fp_QAbstractTextDocumentLayout_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QAbstractTextDocumentLayout::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// QRectF QAbstractTextDocumentLayout::blockBoundingRect(const QTextBlock &block)

static void _init_cbs_blockBoundingRect_c2306_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("block");
  decl->add_arg<const QTextBlock & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_cbs_blockBoundingRect_c2306_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextBlock &arg1 = args.read<const QTextBlock & > ();
  ret.write<QRectF > ((QRectF)((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_blockBoundingRect_c2306_0 (arg1));
}

static void _set_callback_cbs_blockBoundingRect_c2306_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_blockBoundingRect_c2306_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_blockBoundingRect_c2306_0 ()
{
  return new qt_gsi::GenericMethod ("blockBoundingRect", "@hide", true, &_init_cbs_blockBoundingRect_c2306_0, &_call_cbs_blockBoundingRect_c2306_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_blockBoundingRect_c2306_0 ()
{
  return new qt_gsi::GenericMethod ("blockBoundingRect", "@brief Virtual method QRectF QAbstractTextDocumentLayout::blockBoundingRect(const QTextBlock &block)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_blockBoundingRect_c2306_0, &_call_cbs_blockBoundingRect_c2306_0, &_set_callback_cbs_blockBoundingRect_c2306_0);
}


// QSizeF QAbstractTextDocumentLayout::documentSize()

static void _init_cbs_documentSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSizeF > ();
}

static void _call_cbs_documentSize_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSizeF > ((QSizeF)((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_documentSize_c0_0 ());
}

static void _set_callback_cbs_documentSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_documentSize_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_documentSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("documentSize", "@hide", true, &_init_cbs_documentSize_c0_0, &_call_cbs_documentSize_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_documentSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("documentSize", "@brief Virtual method QSizeF QAbstractTextDocumentLayout::documentSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_documentSize_c0_0, &_call_cbs_documentSize_c0_0, &_set_callback_cbs_documentSize_c0_0);
}


// void QAbstractTextDocumentLayout::draw(QPainter *painter, const QAbstractTextDocumentLayout::PaintContext &context)

static void _init_cbs_draw_6787_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("context");
  decl->add_arg<const QAbstractTextDocumentLayout::PaintContext & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_draw_6787_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QAbstractTextDocumentLayout::PaintContext &arg2 = args.read<const QAbstractTextDocumentLayout::PaintContext & > ();
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_draw_6787_0 (arg1, arg2);
}

static void _set_callback_cbs_draw_6787_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_draw_6787_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_draw_6787_0 ()
{
  return new qt_gsi::GenericMethod ("draw", "@hide", false, &_init_cbs_draw_6787_0, &_call_cbs_draw_6787_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_draw_6787_0 ()
{
  return new qt_gsi::GenericMethod ("draw", "@brief Virtual method void QAbstractTextDocumentLayout::draw(QPainter *painter, const QAbstractTextDocumentLayout::PaintContext &context)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_draw_6787_0, &_call_cbs_draw_6787_0, &_set_callback_cbs_draw_6787_0);
}


// bool QAbstractTextDocumentLayout::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QAbstractTextDocumentLayout::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QAbstractTextDocumentLayout::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAbstractTextDocumentLayout::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// QRectF QAbstractTextDocumentLayout::frameBoundingRect(QTextFrame *frame)

static void _init_cbs_frameBoundingRect_c1615_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frame");
  decl->add_arg<QTextFrame * > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_cbs_frameBoundingRect_c1615_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextFrame *arg1 = args.read<QTextFrame * > ();
  ret.write<QRectF > ((QRectF)((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_frameBoundingRect_c1615_0 (arg1));
}

static void _set_callback_cbs_frameBoundingRect_c1615_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_frameBoundingRect_c1615_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_frameBoundingRect_c1615_0 ()
{
  return new qt_gsi::GenericMethod ("frameBoundingRect", "@hide", true, &_init_cbs_frameBoundingRect_c1615_0, &_call_cbs_frameBoundingRect_c1615_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_frameBoundingRect_c1615_0 ()
{
  return new qt_gsi::GenericMethod ("frameBoundingRect", "@brief Virtual method QRectF QAbstractTextDocumentLayout::frameBoundingRect(QTextFrame *frame)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_frameBoundingRect_c1615_0, &_call_cbs_frameBoundingRect_c1615_0, &_set_callback_cbs_frameBoundingRect_c1615_0);
}


// int QAbstractTextDocumentLayout::hitTest(const QPointF &point, Qt::HitTestAccuracy accuracy)

static void _init_cbs_hitTest_c4147_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("accuracy");
  decl->add_arg<const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_cbs_hitTest_c4147_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::HitTestAccuracy>::target_type & > ();
  ret.write<int > ((int)((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_hitTest_c4147_0 (arg1, arg2));
}

static void _set_callback_cbs_hitTest_c4147_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_hitTest_c4147_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hitTest_c4147_0 ()
{
  return new qt_gsi::GenericMethod ("hitTest", "@hide", true, &_init_cbs_hitTest_c4147_0, &_call_cbs_hitTest_c4147_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hitTest_c4147_0 ()
{
  return new qt_gsi::GenericMethod ("hitTest", "@brief Virtual method int QAbstractTextDocumentLayout::hitTest(const QPointF &point, Qt::HitTestAccuracy accuracy)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hitTest_c4147_0, &_call_cbs_hitTest_c4147_0, &_set_callback_cbs_hitTest_c4147_0);
}


// int QAbstractTextDocumentLayout::pageCount()

static void _init_cbs_pageCount_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_pageCount_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_pageCount_c0_0 ());
}

static void _set_callback_cbs_pageCount_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_pageCount_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_pageCount_c0_0 ()
{
  return new qt_gsi::GenericMethod ("pageCount", "@hide", true, &_init_cbs_pageCount_c0_0, &_call_cbs_pageCount_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_pageCount_c0_0 ()
{
  return new qt_gsi::GenericMethod ("pageCount", "@brief Virtual method int QAbstractTextDocumentLayout::pageCount()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_pageCount_c0_0, &_call_cbs_pageCount_c0_0, &_set_callback_cbs_pageCount_c0_0);
}


// void QAbstractTextDocumentLayout::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAbstractTextDocumentLayout::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QAbstractTextDocumentLayout::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAbstractTextDocumentLayout::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QAbstractTextDocumentLayout::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAbstractTextDocumentLayout::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QAbstractTextDocumentLayout::documentChanged(int from, int charsRemoved, int charsAdded)

static void _init_cbs_documentChanged_2085_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("charsRemoved");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("charsAdded");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_documentChanged_2085_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_documentChanged_2085_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_documentChanged_2085_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_documentChanged_2085_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_documentChanged_2085_0 ()
{
  return new qt_gsi::GenericMethod ("*documentChanged", "@hide", false, &_init_cbs_documentChanged_2085_0, &_call_cbs_documentChanged_2085_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_documentChanged_2085_0 ()
{
  return new qt_gsi::GenericMethod ("*documentChanged", "@brief Virtual method void QAbstractTextDocumentLayout::documentChanged(int from, int charsRemoved, int charsAdded)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_documentChanged_2085_0, &_call_cbs_documentChanged_2085_0, &_set_callback_cbs_documentChanged_2085_0);
}


// void QAbstractTextDocumentLayout::drawInlineObject(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)

static void _init_cbs_drawInlineObject_8199_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("object");
  decl->add_arg<QTextInlineObject > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("posInDocument");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("format");
  decl->add_arg<const QTextFormat & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_cbs_drawInlineObject_8199_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRectF &arg2 = args.read<const QRectF & > ();
  QTextInlineObject arg3 = args.read<QTextInlineObject > ();
  int arg4 = args.read<int > ();
  const QTextFormat &arg5 = args.read<const QTextFormat & > ();
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_drawInlineObject_8199_0 (arg1, arg2, arg3, arg4, arg5);
}

static void _set_callback_cbs_drawInlineObject_8199_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_drawInlineObject_8199_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawInlineObject_8199_0 ()
{
  return new qt_gsi::GenericMethod ("*drawInlineObject", "@hide", false, &_init_cbs_drawInlineObject_8199_0, &_call_cbs_drawInlineObject_8199_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawInlineObject_8199_0 ()
{
  return new qt_gsi::GenericMethod ("*drawInlineObject", "@brief Virtual method void QAbstractTextDocumentLayout::drawInlineObject(QPainter *painter, const QRectF &rect, QTextInlineObject object, int posInDocument, const QTextFormat &format)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawInlineObject_8199_0, &_call_cbs_drawInlineObject_8199_0, &_set_callback_cbs_drawInlineObject_8199_0);
}


// void QAbstractTextDocumentLayout::positionInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)

static void _init_cbs_positionInlineObject_5127_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTextInlineObject > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("posInDocument");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format");
  decl->add_arg<const QTextFormat & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_positionInlineObject_5127_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextInlineObject arg1 = args.read<QTextInlineObject > ();
  int arg2 = args.read<int > ();
  const QTextFormat &arg3 = args.read<const QTextFormat & > ();
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_positionInlineObject_5127_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_positionInlineObject_5127_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_positionInlineObject_5127_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_positionInlineObject_5127_0 ()
{
  return new qt_gsi::GenericMethod ("*positionInlineObject", "@hide", false, &_init_cbs_positionInlineObject_5127_0, &_call_cbs_positionInlineObject_5127_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_positionInlineObject_5127_0 ()
{
  return new qt_gsi::GenericMethod ("*positionInlineObject", "@brief Virtual method void QAbstractTextDocumentLayout::positionInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_positionInlineObject_5127_0, &_call_cbs_positionInlineObject_5127_0, &_set_callback_cbs_positionInlineObject_5127_0);
}


// void QAbstractTextDocumentLayout::resizeInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)

static void _init_cbs_resizeInlineObject_5127_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QTextInlineObject > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("posInDocument");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format");
  decl->add_arg<const QTextFormat & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_resizeInlineObject_5127_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextInlineObject arg1 = args.read<QTextInlineObject > ();
  int arg2 = args.read<int > ();
  const QTextFormat &arg3 = args.read<const QTextFormat & > ();
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_resizeInlineObject_5127_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_resizeInlineObject_5127_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_resizeInlineObject_5127_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeInlineObject_5127_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeInlineObject", "@hide", false, &_init_cbs_resizeInlineObject_5127_0, &_call_cbs_resizeInlineObject_5127_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeInlineObject_5127_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeInlineObject", "@brief Virtual method void QAbstractTextDocumentLayout::resizeInlineObject(QTextInlineObject item, int posInDocument, const QTextFormat &format)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeInlineObject_5127_0, &_call_cbs_resizeInlineObject_5127_0, &_set_callback_cbs_resizeInlineObject_5127_0);
}


// void QAbstractTextDocumentLayout::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTextDocumentLayout_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAbstractTextDocumentLayout::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QAbstractTextDocumentLayout> decl_QAbstractTextDocumentLayout;

gsi::Class<QAbstractTextDocumentLayout_Adaptor> decl_QAbstractTextDocumentLayout_Adaptor (decl_QAbstractTextDocumentLayout, "QAbstractTextDocumentLayout",
  gsi::Methods(_create_fp_format_767 ()) +
  gsi::Methods(_create_fp_formatIndex_767 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_blockBoundingRect_c2306_0 ()) +
  gsi::Methods(_create_callback_cbs_blockBoundingRect_c2306_0 ()) +
  gsi::Methods(_create_cbs_documentSize_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_documentSize_c0_0 ()) +
  gsi::Methods(_create_cbs_draw_6787_0 ()) +
  gsi::Methods(_create_callback_cbs_draw_6787_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_frameBoundingRect_c1615_0 ()) +
  gsi::Methods(_create_callback_cbs_frameBoundingRect_c1615_0 ()) +
  gsi::Methods(_create_cbs_hitTest_c4147_0 ()) +
  gsi::Methods(_create_callback_cbs_hitTest_c4147_0 ()) +
  gsi::Methods(_create_cbs_pageCount_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_pageCount_c0_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_documentChanged_2085_0 ()) +
  gsi::Methods(_create_callback_cbs_documentChanged_2085_0 ()) +
  gsi::Methods(_create_cbs_drawInlineObject_8199_0 ()) +
  gsi::Methods(_create_callback_cbs_drawInlineObject_8199_0 ()) +
  gsi::Methods(_create_cbs_positionInlineObject_5127_0 ()) +
  gsi::Methods(_create_callback_cbs_positionInlineObject_5127_0 ()) +
  gsi::Methods(_create_cbs_resizeInlineObject_5127_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeInlineObject_5127_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QAbstractTextDocumentLayout_Adaptor_1955 ()),
  "@qt\n@brief Binding of QAbstractTextDocumentLayout");

}

