
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQUrlInfo.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtNetwork.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQUrlInfo_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QUrlInfo

// QString QUrlInfo::group()


static void _init_f_group_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_group_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QUrlInfo *)cls)->group ());
}

static qt_gsi::GenericMethod *_create_f_group_c0 ()
{
  return new qt_gsi::GenericMethod (":group", "@brief Method QString QUrlInfo::group()\n", true, &_init_f_group_c0, &_call_f_group_c0);
}

// bool QUrlInfo::isDir()


static void _init_f_isDir_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDir_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUrlInfo *)cls)->isDir ());
}

static qt_gsi::GenericMethod *_create_f_isDir_c0 ()
{
  return new qt_gsi::GenericMethod ("isDir?|:dir", "@brief Method bool QUrlInfo::isDir()\n", true, &_init_f_isDir_c0, &_call_f_isDir_c0);
}

// bool QUrlInfo::isExecutable()


static void _init_f_isExecutable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isExecutable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUrlInfo *)cls)->isExecutable ());
}

static qt_gsi::GenericMethod *_create_f_isExecutable_c0 ()
{
  return new qt_gsi::GenericMethod ("isExecutable?", "@brief Method bool QUrlInfo::isExecutable()\n", true, &_init_f_isExecutable_c0, &_call_f_isExecutable_c0);
}

// bool QUrlInfo::isFile()


static void _init_f_isFile_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isFile_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUrlInfo *)cls)->isFile ());
}

static qt_gsi::GenericMethod *_create_f_isFile_c0 ()
{
  return new qt_gsi::GenericMethod ("isFile?|:file", "@brief Method bool QUrlInfo::isFile()\n", true, &_init_f_isFile_c0, &_call_f_isFile_c0);
}

// bool QUrlInfo::isReadable()


static void _init_f_isReadable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isReadable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUrlInfo *)cls)->isReadable ());
}

static qt_gsi::GenericMethod *_create_f_isReadable_c0 ()
{
  return new qt_gsi::GenericMethod ("isReadable?|:readable", "@brief Method bool QUrlInfo::isReadable()\n", true, &_init_f_isReadable_c0, &_call_f_isReadable_c0);
}

// bool QUrlInfo::isSymLink()


static void _init_f_isSymLink_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isSymLink_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUrlInfo *)cls)->isSymLink ());
}

static qt_gsi::GenericMethod *_create_f_isSymLink_c0 ()
{
  return new qt_gsi::GenericMethod ("isSymLink?|:symLink", "@brief Method bool QUrlInfo::isSymLink()\n", true, &_init_f_isSymLink_c0, &_call_f_isSymLink_c0);
}

// bool QUrlInfo::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUrlInfo *)cls)->isValid ());
}

static qt_gsi::GenericMethod *_create_f_isValid_c0 ()
{
  return new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QUrlInfo::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
}

// bool QUrlInfo::isWritable()


static void _init_f_isWritable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isWritable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QUrlInfo *)cls)->isWritable ());
}

static qt_gsi::GenericMethod *_create_f_isWritable_c0 ()
{
  return new qt_gsi::GenericMethod ("isWritable?|:writable", "@brief Method bool QUrlInfo::isWritable()\n", true, &_init_f_isWritable_c0, &_call_f_isWritable_c0);
}

// QDateTime QUrlInfo::lastModified()


static void _init_f_lastModified_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDateTime > ();
}

static void _call_f_lastModified_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDateTime > ((QDateTime)((QUrlInfo *)cls)->lastModified ());
}

static qt_gsi::GenericMethod *_create_f_lastModified_c0 ()
{
  return new qt_gsi::GenericMethod (":lastModified", "@brief Method QDateTime QUrlInfo::lastModified()\n", true, &_init_f_lastModified_c0, &_call_f_lastModified_c0);
}

// QDateTime QUrlInfo::lastRead()


static void _init_f_lastRead_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDateTime > ();
}

static void _call_f_lastRead_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDateTime > ((QDateTime)((QUrlInfo *)cls)->lastRead ());
}

static qt_gsi::GenericMethod *_create_f_lastRead_c0 ()
{
  return new qt_gsi::GenericMethod (":lastRead", "@brief Method QDateTime QUrlInfo::lastRead()\n", true, &_init_f_lastRead_c0, &_call_f_lastRead_c0);
}

// QString QUrlInfo::name()


static void _init_f_name_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_name_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QUrlInfo *)cls)->name ());
}

static qt_gsi::GenericMethod *_create_f_name_c0 ()
{
  return new qt_gsi::GenericMethod (":name", "@brief Method QString QUrlInfo::name()\n", true, &_init_f_name_c0, &_call_f_name_c0);
}

// bool QUrlInfo::operator!=(const QUrlInfo &i)


static void _init_f_operator_excl__eq__c2097 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<const QUrlInfo & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2097 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QUrlInfo &arg1 = args.read<const QUrlInfo & > ();
  ret.write<bool > ((bool)((QUrlInfo *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c2097 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QUrlInfo::operator!=(const QUrlInfo &i)\n", true, &_init_f_operator_excl__eq__c2097, &_call_f_operator_excl__eq__c2097);
}

// QUrlInfo &QUrlInfo::operator=(const QUrlInfo &ui)


static void _init_f_operator_eq__2097 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ui");
  decl->add_arg<const QUrlInfo & > (argspec_0);
  decl->set_return<QUrlInfo & > ();
}

static void _call_f_operator_eq__2097 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QUrlInfo &arg1 = args.read<const QUrlInfo & > ();
  ret.write<QUrlInfo & > ((QUrlInfo &)((QUrlInfo *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__2097 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QUrlInfo &QUrlInfo::operator=(const QUrlInfo &ui)\n", false, &_init_f_operator_eq__2097, &_call_f_operator_eq__2097);
}

// bool QUrlInfo::operator==(const QUrlInfo &i)


static void _init_f_operator_eq__eq__c2097 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<const QUrlInfo & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2097 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QUrlInfo &arg1 = args.read<const QUrlInfo & > ();
  ret.write<bool > ((bool)((QUrlInfo *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c2097 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QUrlInfo::operator==(const QUrlInfo &i)\n", true, &_init_f_operator_eq__eq__c2097, &_call_f_operator_eq__eq__c2097);
}

// QString QUrlInfo::owner()


static void _init_f_owner_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_owner_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QUrlInfo *)cls)->owner ());
}

static qt_gsi::GenericMethod *_create_f_owner_c0 ()
{
  return new qt_gsi::GenericMethod (":owner", "@brief Method QString QUrlInfo::owner()\n", true, &_init_f_owner_c0, &_call_f_owner_c0);
}

// int QUrlInfo::permissions()


static void _init_f_permissions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_permissions_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QUrlInfo *)cls)->permissions ());
}

static qt_gsi::GenericMethod *_create_f_permissions_c0 ()
{
  return new qt_gsi::GenericMethod (":permissions", "@brief Method int QUrlInfo::permissions()\n", true, &_init_f_permissions_c0, &_call_f_permissions_c0);
}

// void QUrlInfo::setDir(bool b)


static void _init_f_setDir_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDir_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QUrlInfo *)cls)->setDir (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDir_864 ()
{
  return new qt_gsi::GenericMethod ("setDir|dir=", "@brief Method void QUrlInfo::setDir(bool b)\n", false, &_init_f_setDir_864, &_call_f_setDir_864);
}

// void QUrlInfo::setFile(bool b)


static void _init_f_setFile_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFile_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QUrlInfo *)cls)->setFile (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFile_864 ()
{
  return new qt_gsi::GenericMethod ("setFile|file=", "@brief Method void QUrlInfo::setFile(bool b)\n", false, &_init_f_setFile_864, &_call_f_setFile_864);
}

// void QUrlInfo::setGroup(const QString &s)


static void _init_f_setGroup_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGroup_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUrlInfo *)cls)->setGroup (arg1);
}

static qt_gsi::GenericMethod *_create_f_setGroup_2025 ()
{
  return new qt_gsi::GenericMethod ("setGroup|group=", "@brief Method void QUrlInfo::setGroup(const QString &s)\n", false, &_init_f_setGroup_2025, &_call_f_setGroup_2025);
}

// void QUrlInfo::setLastModified(const QDateTime &dt)


static void _init_f_setLastModified_2175 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dt");
  decl->add_arg<const QDateTime & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLastModified_2175 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDateTime &arg1 = args.read<const QDateTime & > ();
  ((QUrlInfo *)cls)->setLastModified (arg1);
}

static qt_gsi::GenericMethod *_create_f_setLastModified_2175 ()
{
  return new qt_gsi::GenericMethod ("setLastModified|lastModified=", "@brief Method void QUrlInfo::setLastModified(const QDateTime &dt)\n", false, &_init_f_setLastModified_2175, &_call_f_setLastModified_2175);
}

// void QUrlInfo::setLastRead(const QDateTime &dt)


static void _init_f_setLastRead_2175 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dt");
  decl->add_arg<const QDateTime & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLastRead_2175 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDateTime &arg1 = args.read<const QDateTime & > ();
  ((QUrlInfo *)cls)->setLastRead (arg1);
}

static qt_gsi::GenericMethod *_create_f_setLastRead_2175 ()
{
  return new qt_gsi::GenericMethod ("setLastRead|lastRead=", "@brief Method void QUrlInfo::setLastRead(const QDateTime &dt)\n", false, &_init_f_setLastRead_2175, &_call_f_setLastRead_2175);
}

// void QUrlInfo::setName(const QString &name)


static void _init_f_setName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setName_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUrlInfo *)cls)->setName (arg1);
}

static qt_gsi::GenericMethod *_create_f_setName_2025 ()
{
  return new qt_gsi::GenericMethod ("setName|name=", "@brief Method void QUrlInfo::setName(const QString &name)\n", false, &_init_f_setName_2025, &_call_f_setName_2025);
}

// void QUrlInfo::setOwner(const QString &s)


static void _init_f_setOwner_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOwner_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUrlInfo *)cls)->setOwner (arg1);
}

static qt_gsi::GenericMethod *_create_f_setOwner_2025 ()
{
  return new qt_gsi::GenericMethod ("setOwner|owner=", "@brief Method void QUrlInfo::setOwner(const QString &s)\n", false, &_init_f_setOwner_2025, &_call_f_setOwner_2025);
}

// void QUrlInfo::setPermissions(int p)


static void _init_f_setPermissions_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPermissions_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QUrlInfo *)cls)->setPermissions (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPermissions_767 ()
{
  return new qt_gsi::GenericMethod ("setPermissions|permissions=", "@brief Method void QUrlInfo::setPermissions(int p)\n", false, &_init_f_setPermissions_767, &_call_f_setPermissions_767);
}

// void QUrlInfo::setReadable(bool b)


static void _init_f_setReadable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setReadable_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QUrlInfo *)cls)->setReadable (arg1);
}

static qt_gsi::GenericMethod *_create_f_setReadable_864 ()
{
  return new qt_gsi::GenericMethod ("setReadable|readable=", "@brief Method void QUrlInfo::setReadable(bool b)\n", false, &_init_f_setReadable_864, &_call_f_setReadable_864);
}

// void QUrlInfo::setSize(qint64 size)


static void _init_f_setSize_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSize_986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qint64 arg1 = args.read<qint64 > ();
  ((QUrlInfo *)cls)->setSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSize_986 ()
{
  return new qt_gsi::GenericMethod ("setSize|size=", "@brief Method void QUrlInfo::setSize(qint64 size)\n", false, &_init_f_setSize_986, &_call_f_setSize_986);
}

// void QUrlInfo::setSymLink(bool b)


static void _init_f_setSymLink_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSymLink_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QUrlInfo *)cls)->setSymLink (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSymLink_864 ()
{
  return new qt_gsi::GenericMethod ("setSymLink|symLink=", "@brief Method void QUrlInfo::setSymLink(bool b)\n", false, &_init_f_setSymLink_864, &_call_f_setSymLink_864);
}

// void QUrlInfo::setWritable(bool b)


static void _init_f_setWritable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWritable_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QUrlInfo *)cls)->setWritable (arg1);
}

static qt_gsi::GenericMethod *_create_f_setWritable_864 ()
{
  return new qt_gsi::GenericMethod ("setWritable|writable=", "@brief Method void QUrlInfo::setWritable(bool b)\n", false, &_init_f_setWritable_864, &_call_f_setWritable_864);
}

// qint64 QUrlInfo::size()


static void _init_f_size_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_size_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QUrlInfo *)cls)->size ());
}

static qt_gsi::GenericMethod *_create_f_size_c0 ()
{
  return new qt_gsi::GenericMethod (":size", "@brief Method qint64 QUrlInfo::size()\n", true, &_init_f_size_c0, &_call_f_size_c0);
}

// static bool QUrlInfo::equal(const QUrlInfo &i1, const QUrlInfo &i2, int sortBy)


static void _init_f_equal_4745 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i1");
  decl->add_arg<const QUrlInfo & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("i2");
  decl->add_arg<const QUrlInfo & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sortBy");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_equal_4745 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QUrlInfo &arg1 = args.read<const QUrlInfo & > ();
  const QUrlInfo &arg2 = args.read<const QUrlInfo & > ();
  int arg3 = args.read<int > ();
  ret.write<bool > ((bool)QUrlInfo::equal (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_equal_4745 ()
{
  return new qt_gsi::GenericStaticMethod ("equal", "@brief Static method bool QUrlInfo::equal(const QUrlInfo &i1, const QUrlInfo &i2, int sortBy)\nThis method is static and can be called without an instance.", &_init_f_equal_4745, &_call_f_equal_4745);
}

// static bool QUrlInfo::greaterThan(const QUrlInfo &i1, const QUrlInfo &i2, int sortBy)


static void _init_f_greaterThan_4745 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i1");
  decl->add_arg<const QUrlInfo & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("i2");
  decl->add_arg<const QUrlInfo & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sortBy");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_greaterThan_4745 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QUrlInfo &arg1 = args.read<const QUrlInfo & > ();
  const QUrlInfo &arg2 = args.read<const QUrlInfo & > ();
  int arg3 = args.read<int > ();
  ret.write<bool > ((bool)QUrlInfo::greaterThan (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_greaterThan_4745 ()
{
  return new qt_gsi::GenericStaticMethod ("greaterThan", "@brief Static method bool QUrlInfo::greaterThan(const QUrlInfo &i1, const QUrlInfo &i2, int sortBy)\nThis method is static and can be called without an instance.", &_init_f_greaterThan_4745, &_call_f_greaterThan_4745);
}

// static bool QUrlInfo::lessThan(const QUrlInfo &i1, const QUrlInfo &i2, int sortBy)


static void _init_f_lessThan_4745 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i1");
  decl->add_arg<const QUrlInfo & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("i2");
  decl->add_arg<const QUrlInfo & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sortBy");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_lessThan_4745 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QUrlInfo &arg1 = args.read<const QUrlInfo & > ();
  const QUrlInfo &arg2 = args.read<const QUrlInfo & > ();
  int arg3 = args.read<int > ();
  ret.write<bool > ((bool)QUrlInfo::lessThan (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_lessThan_4745 ()
{
  return new qt_gsi::GenericStaticMethod ("lessThan", "@brief Static method bool QUrlInfo::lessThan(const QUrlInfo &i1, const QUrlInfo &i2, int sortBy)\nThis method is static and can be called without an instance.", &_init_f_lessThan_4745, &_call_f_lessThan_4745);
}

namespace gsi
{
gsi::Class<QUrlInfo> decl_QUrlInfo ("QUrlInfo_Native",
  gsi::Methods(_create_f_group_c0 ()) +
  gsi::Methods(_create_f_isDir_c0 ()) +
  gsi::Methods(_create_f_isExecutable_c0 ()) +
  gsi::Methods(_create_f_isFile_c0 ()) +
  gsi::Methods(_create_f_isReadable_c0 ()) +
  gsi::Methods(_create_f_isSymLink_c0 ()) +
  gsi::Methods(_create_f_isValid_c0 ()) +
  gsi::Methods(_create_f_isWritable_c0 ()) +
  gsi::Methods(_create_f_lastModified_c0 ()) +
  gsi::Methods(_create_f_lastRead_c0 ()) +
  gsi::Methods(_create_f_name_c0 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c2097 ()) +
  gsi::Methods(_create_f_operator_eq__2097 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c2097 ()) +
  gsi::Methods(_create_f_owner_c0 ()) +
  gsi::Methods(_create_f_permissions_c0 ()) +
  gsi::Methods(_create_f_setDir_864 ()) +
  gsi::Methods(_create_f_setFile_864 ()) +
  gsi::Methods(_create_f_setGroup_2025 ()) +
  gsi::Methods(_create_f_setLastModified_2175 ()) +
  gsi::Methods(_create_f_setLastRead_2175 ()) +
  gsi::Methods(_create_f_setName_2025 ()) +
  gsi::Methods(_create_f_setOwner_2025 ()) +
  gsi::Methods(_create_f_setPermissions_767 ()) +
  gsi::Methods(_create_f_setReadable_864 ()) +
  gsi::Methods(_create_f_setSize_986 ()) +
  gsi::Methods(_create_f_setSymLink_864 ()) +
  gsi::Methods(_create_f_setWritable_864 ()) +
  gsi::Methods(_create_f_size_c0 ()) +
  gsi::Methods(_create_f_equal_4745 ()) +
  gsi::Methods(_create_f_greaterThan_4745 ()) +
  gsi::Methods(_create_f_lessThan_4745 ()),
  "@hide\n@alias QUrlInfo");
}


class QUrlInfo_Adaptor : public QUrlInfo, public qt_gsi::QtObjectBase
{
public:

  virtual ~QUrlInfo_Adaptor();

  //  [adaptor ctor] QUrlInfo::QUrlInfo()
  QUrlInfo_Adaptor() : QUrlInfo()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QUrlInfo::QUrlInfo(const QUrlInfo &ui)
  QUrlInfo_Adaptor(const QUrlInfo &ui) : QUrlInfo(ui)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor impl] void QUrlInfo::setDir(bool b)
  void cbs_setDir_864_0(bool b)
  {
    QUrlInfo::setDir(b);
  }

  virtual void setDir(bool b)
  {
    if (cb_setDir_864_0.can_issue()) {
      cb_setDir_864_0.issue<QUrlInfo_Adaptor, bool>(&QUrlInfo_Adaptor::cbs_setDir_864_0, b);
    } else {
      QUrlInfo::setDir(b);
    }
  }

  //  [adaptor impl] void QUrlInfo::setFile(bool b)
  void cbs_setFile_864_0(bool b)
  {
    QUrlInfo::setFile(b);
  }

  virtual void setFile(bool b)
  {
    if (cb_setFile_864_0.can_issue()) {
      cb_setFile_864_0.issue<QUrlInfo_Adaptor, bool>(&QUrlInfo_Adaptor::cbs_setFile_864_0, b);
    } else {
      QUrlInfo::setFile(b);
    }
  }

  //  [adaptor impl] void QUrlInfo::setGroup(const QString &s)
  void cbs_setGroup_2025_0(const QString &s)
  {
    QUrlInfo::setGroup(s);
  }

  virtual void setGroup(const QString &s)
  {
    if (cb_setGroup_2025_0.can_issue()) {
      cb_setGroup_2025_0.issue<QUrlInfo_Adaptor, const QString &>(&QUrlInfo_Adaptor::cbs_setGroup_2025_0, s);
    } else {
      QUrlInfo::setGroup(s);
    }
  }

  //  [adaptor impl] void QUrlInfo::setLastModified(const QDateTime &dt)
  void cbs_setLastModified_2175_0(const QDateTime &dt)
  {
    QUrlInfo::setLastModified(dt);
  }

  virtual void setLastModified(const QDateTime &dt)
  {
    if (cb_setLastModified_2175_0.can_issue()) {
      cb_setLastModified_2175_0.issue<QUrlInfo_Adaptor, const QDateTime &>(&QUrlInfo_Adaptor::cbs_setLastModified_2175_0, dt);
    } else {
      QUrlInfo::setLastModified(dt);
    }
  }

  //  [adaptor impl] void QUrlInfo::setName(const QString &name)
  void cbs_setName_2025_0(const QString &name)
  {
    QUrlInfo::setName(name);
  }

  virtual void setName(const QString &name)
  {
    if (cb_setName_2025_0.can_issue()) {
      cb_setName_2025_0.issue<QUrlInfo_Adaptor, const QString &>(&QUrlInfo_Adaptor::cbs_setName_2025_0, name);
    } else {
      QUrlInfo::setName(name);
    }
  }

  //  [adaptor impl] void QUrlInfo::setOwner(const QString &s)
  void cbs_setOwner_2025_0(const QString &s)
  {
    QUrlInfo::setOwner(s);
  }

  virtual void setOwner(const QString &s)
  {
    if (cb_setOwner_2025_0.can_issue()) {
      cb_setOwner_2025_0.issue<QUrlInfo_Adaptor, const QString &>(&QUrlInfo_Adaptor::cbs_setOwner_2025_0, s);
    } else {
      QUrlInfo::setOwner(s);
    }
  }

  //  [adaptor impl] void QUrlInfo::setPermissions(int p)
  void cbs_setPermissions_767_0(int p)
  {
    QUrlInfo::setPermissions(p);
  }

  virtual void setPermissions(int p)
  {
    if (cb_setPermissions_767_0.can_issue()) {
      cb_setPermissions_767_0.issue<QUrlInfo_Adaptor, int>(&QUrlInfo_Adaptor::cbs_setPermissions_767_0, p);
    } else {
      QUrlInfo::setPermissions(p);
    }
  }

  //  [adaptor impl] void QUrlInfo::setReadable(bool b)
  void cbs_setReadable_864_0(bool b)
  {
    QUrlInfo::setReadable(b);
  }

  virtual void setReadable(bool b)
  {
    if (cb_setReadable_864_0.can_issue()) {
      cb_setReadable_864_0.issue<QUrlInfo_Adaptor, bool>(&QUrlInfo_Adaptor::cbs_setReadable_864_0, b);
    } else {
      QUrlInfo::setReadable(b);
    }
  }

  //  [adaptor impl] void QUrlInfo::setSize(qint64 size)
  void cbs_setSize_986_0(qint64 size)
  {
    QUrlInfo::setSize(size);
  }

  virtual void setSize(qint64 size)
  {
    if (cb_setSize_986_0.can_issue()) {
      cb_setSize_986_0.issue<QUrlInfo_Adaptor, qint64>(&QUrlInfo_Adaptor::cbs_setSize_986_0, size);
    } else {
      QUrlInfo::setSize(size);
    }
  }

  //  [adaptor impl] void QUrlInfo::setSymLink(bool b)
  void cbs_setSymLink_864_0(bool b)
  {
    QUrlInfo::setSymLink(b);
  }

  virtual void setSymLink(bool b)
  {
    if (cb_setSymLink_864_0.can_issue()) {
      cb_setSymLink_864_0.issue<QUrlInfo_Adaptor, bool>(&QUrlInfo_Adaptor::cbs_setSymLink_864_0, b);
    } else {
      QUrlInfo::setSymLink(b);
    }
  }

  //  [adaptor impl] void QUrlInfo::setWritable(bool b)
  void cbs_setWritable_864_0(bool b)
  {
    QUrlInfo::setWritable(b);
  }

  virtual void setWritable(bool b)
  {
    if (cb_setWritable_864_0.can_issue()) {
      cb_setWritable_864_0.issue<QUrlInfo_Adaptor, bool>(&QUrlInfo_Adaptor::cbs_setWritable_864_0, b);
    } else {
      QUrlInfo::setWritable(b);
    }
  }

  gsi::Callback cb_setDir_864_0;
  gsi::Callback cb_setFile_864_0;
  gsi::Callback cb_setGroup_2025_0;
  gsi::Callback cb_setLastModified_2175_0;
  gsi::Callback cb_setName_2025_0;
  gsi::Callback cb_setOwner_2025_0;
  gsi::Callback cb_setPermissions_767_0;
  gsi::Callback cb_setReadable_864_0;
  gsi::Callback cb_setSize_986_0;
  gsi::Callback cb_setSymLink_864_0;
  gsi::Callback cb_setWritable_864_0;
};

QUrlInfo_Adaptor::~QUrlInfo_Adaptor() { }

//  Constructor QUrlInfo::QUrlInfo() (adaptor class)

static void _init_ctor_QUrlInfo_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QUrlInfo_Adaptor *> ();
}

static void _call_ctor_QUrlInfo_Adaptor_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QUrlInfo_Adaptor *> (new QUrlInfo_Adaptor ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QUrlInfo_Adaptor_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUrlInfo::QUrlInfo()\nThis method creates an object of class QUrlInfo.", &_init_ctor_QUrlInfo_Adaptor_0, &_call_ctor_QUrlInfo_Adaptor_0);
}

//  Constructor QUrlInfo::QUrlInfo(const QUrlInfo &ui) (adaptor class)

static void _init_ctor_QUrlInfo_Adaptor_2097 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ui");
  decl->add_arg<const QUrlInfo & > (argspec_0);
  decl->set_return_new<QUrlInfo_Adaptor *> ();
}

static void _call_ctor_QUrlInfo_Adaptor_2097 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QUrlInfo &arg1 = args.read<const QUrlInfo & > ();
  ret.write<QUrlInfo_Adaptor *> (new QUrlInfo_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QUrlInfo_Adaptor_2097 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QUrlInfo::QUrlInfo(const QUrlInfo &ui)\nThis method creates an object of class QUrlInfo.", &_init_ctor_QUrlInfo_Adaptor_2097, &_call_ctor_QUrlInfo_Adaptor_2097);
}

// void QUrlInfo::setDir(bool b)

static void _init_cbs_setDir_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setDir_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QUrlInfo_Adaptor *)cls)->cbs_setDir_864_0 (arg1);
}

static void _set_callback_cbs_setDir_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setDir_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setDir_864_0 ()
{
  return new qt_gsi::GenericMethod ("setDir", "@hide", false, &_init_cbs_setDir_864_0, &_call_cbs_setDir_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setDir_864_0 ()
{
  return new qt_gsi::GenericMethod ("setDir", "@brief Virtual method void QUrlInfo::setDir(bool b)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setDir_864_0, &_call_cbs_setDir_864_0, &_set_callback_cbs_setDir_864_0);
}


// void QUrlInfo::setFile(bool b)

static void _init_cbs_setFile_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setFile_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QUrlInfo_Adaptor *)cls)->cbs_setFile_864_0 (arg1);
}

static void _set_callback_cbs_setFile_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setFile_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setFile_864_0 ()
{
  return new qt_gsi::GenericMethod ("setFile", "@hide", false, &_init_cbs_setFile_864_0, &_call_cbs_setFile_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setFile_864_0 ()
{
  return new qt_gsi::GenericMethod ("setFile", "@brief Virtual method void QUrlInfo::setFile(bool b)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setFile_864_0, &_call_cbs_setFile_864_0, &_set_callback_cbs_setFile_864_0);
}


// void QUrlInfo::setGroup(const QString &s)

static void _init_cbs_setGroup_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setGroup_2025_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUrlInfo_Adaptor *)cls)->cbs_setGroup_2025_0 (arg1);
}

static void _set_callback_cbs_setGroup_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setGroup_2025_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setGroup_2025_0 ()
{
  return new qt_gsi::GenericMethod ("setGroup", "@hide", false, &_init_cbs_setGroup_2025_0, &_call_cbs_setGroup_2025_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setGroup_2025_0 ()
{
  return new qt_gsi::GenericMethod ("setGroup", "@brief Virtual method void QUrlInfo::setGroup(const QString &s)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setGroup_2025_0, &_call_cbs_setGroup_2025_0, &_set_callback_cbs_setGroup_2025_0);
}


// void QUrlInfo::setLastModified(const QDateTime &dt)

static void _init_cbs_setLastModified_2175_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dt");
  decl->add_arg<const QDateTime & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setLastModified_2175_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDateTime &arg1 = args.read<const QDateTime & > ();
  ((QUrlInfo_Adaptor *)cls)->cbs_setLastModified_2175_0 (arg1);
}

static void _set_callback_cbs_setLastModified_2175_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setLastModified_2175_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setLastModified_2175_0 ()
{
  return new qt_gsi::GenericMethod ("setLastModified", "@hide", false, &_init_cbs_setLastModified_2175_0, &_call_cbs_setLastModified_2175_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setLastModified_2175_0 ()
{
  return new qt_gsi::GenericMethod ("setLastModified", "@brief Virtual method void QUrlInfo::setLastModified(const QDateTime &dt)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setLastModified_2175_0, &_call_cbs_setLastModified_2175_0, &_set_callback_cbs_setLastModified_2175_0);
}


// void QUrlInfo::setName(const QString &name)

static void _init_cbs_setName_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setName_2025_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUrlInfo_Adaptor *)cls)->cbs_setName_2025_0 (arg1);
}

static void _set_callback_cbs_setName_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setName_2025_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setName_2025_0 ()
{
  return new qt_gsi::GenericMethod ("setName", "@hide", false, &_init_cbs_setName_2025_0, &_call_cbs_setName_2025_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setName_2025_0 ()
{
  return new qt_gsi::GenericMethod ("setName", "@brief Virtual method void QUrlInfo::setName(const QString &name)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setName_2025_0, &_call_cbs_setName_2025_0, &_set_callback_cbs_setName_2025_0);
}


// void QUrlInfo::setOwner(const QString &s)

static void _init_cbs_setOwner_2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setOwner_2025_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QUrlInfo_Adaptor *)cls)->cbs_setOwner_2025_0 (arg1);
}

static void _set_callback_cbs_setOwner_2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setOwner_2025_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setOwner_2025_0 ()
{
  return new qt_gsi::GenericMethod ("setOwner", "@hide", false, &_init_cbs_setOwner_2025_0, &_call_cbs_setOwner_2025_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setOwner_2025_0 ()
{
  return new qt_gsi::GenericMethod ("setOwner", "@brief Virtual method void QUrlInfo::setOwner(const QString &s)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setOwner_2025_0, &_call_cbs_setOwner_2025_0, &_set_callback_cbs_setOwner_2025_0);
}


// void QUrlInfo::setPermissions(int p)

static void _init_cbs_setPermissions_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setPermissions_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QUrlInfo_Adaptor *)cls)->cbs_setPermissions_767_0 (arg1);
}

static void _set_callback_cbs_setPermissions_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setPermissions_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setPermissions_767_0 ()
{
  return new qt_gsi::GenericMethod ("setPermissions", "@hide", false, &_init_cbs_setPermissions_767_0, &_call_cbs_setPermissions_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setPermissions_767_0 ()
{
  return new qt_gsi::GenericMethod ("setPermissions", "@brief Virtual method void QUrlInfo::setPermissions(int p)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setPermissions_767_0, &_call_cbs_setPermissions_767_0, &_set_callback_cbs_setPermissions_767_0);
}


// void QUrlInfo::setReadable(bool b)

static void _init_cbs_setReadable_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setReadable_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QUrlInfo_Adaptor *)cls)->cbs_setReadable_864_0 (arg1);
}

static void _set_callback_cbs_setReadable_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setReadable_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setReadable_864_0 ()
{
  return new qt_gsi::GenericMethod ("setReadable", "@hide", false, &_init_cbs_setReadable_864_0, &_call_cbs_setReadable_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setReadable_864_0 ()
{
  return new qt_gsi::GenericMethod ("setReadable", "@brief Virtual method void QUrlInfo::setReadable(bool b)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setReadable_864_0, &_call_cbs_setReadable_864_0, &_set_callback_cbs_setReadable_864_0);
}


// void QUrlInfo::setSize(qint64 size)

static void _init_cbs_setSize_986_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSize_986_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qint64 arg1 = args.read<qint64 > ();
  ((QUrlInfo_Adaptor *)cls)->cbs_setSize_986_0 (arg1);
}

static void _set_callback_cbs_setSize_986_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setSize_986_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setSize_986_0 ()
{
  return new qt_gsi::GenericMethod ("setSize", "@hide", false, &_init_cbs_setSize_986_0, &_call_cbs_setSize_986_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setSize_986_0 ()
{
  return new qt_gsi::GenericMethod ("setSize", "@brief Virtual method void QUrlInfo::setSize(qint64 size)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSize_986_0, &_call_cbs_setSize_986_0, &_set_callback_cbs_setSize_986_0);
}


// void QUrlInfo::setSymLink(bool b)

static void _init_cbs_setSymLink_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setSymLink_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QUrlInfo_Adaptor *)cls)->cbs_setSymLink_864_0 (arg1);
}

static void _set_callback_cbs_setSymLink_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setSymLink_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setSymLink_864_0 ()
{
  return new qt_gsi::GenericMethod ("setSymLink", "@hide", false, &_init_cbs_setSymLink_864_0, &_call_cbs_setSymLink_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setSymLink_864_0 ()
{
  return new qt_gsi::GenericMethod ("setSymLink", "@brief Virtual method void QUrlInfo::setSymLink(bool b)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setSymLink_864_0, &_call_cbs_setSymLink_864_0, &_set_callback_cbs_setSymLink_864_0);
}


// void QUrlInfo::setWritable(bool b)

static void _init_cbs_setWritable_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("b");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setWritable_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QUrlInfo_Adaptor *)cls)->cbs_setWritable_864_0 (arg1);
}

static void _set_callback_cbs_setWritable_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QUrlInfo_Adaptor *)cls)->cb_setWritable_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setWritable_864_0 ()
{
  return new qt_gsi::GenericMethod ("setWritable", "@hide", false, &_init_cbs_setWritable_864_0, &_call_cbs_setWritable_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setWritable_864_0 ()
{
  return new qt_gsi::GenericMethod ("setWritable", "@brief Virtual method void QUrlInfo::setWritable(bool b)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setWritable_864_0, &_call_cbs_setWritable_864_0, &_set_callback_cbs_setWritable_864_0);
}


namespace gsi
{

extern gsi::Class<QUrlInfo> decl_QUrlInfo;

gsi::Class<QUrlInfo_Adaptor> decl_QUrlInfo_Adaptor (decl_QUrlInfo, "QUrlInfo",
  gsi::Methods(_create_cbs_setDir_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setDir_864_0 ()) +
  gsi::Methods(_create_cbs_setFile_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setFile_864_0 ()) +
  gsi::Methods(_create_cbs_setGroup_2025_0 ()) +
  gsi::Methods(_create_callback_cbs_setGroup_2025_0 ()) +
  gsi::Methods(_create_cbs_setLastModified_2175_0 ()) +
  gsi::Methods(_create_callback_cbs_setLastModified_2175_0 ()) +
  gsi::Methods(_create_cbs_setName_2025_0 ()) +
  gsi::Methods(_create_callback_cbs_setName_2025_0 ()) +
  gsi::Methods(_create_cbs_setOwner_2025_0 ()) +
  gsi::Methods(_create_callback_cbs_setOwner_2025_0 ()) +
  gsi::Methods(_create_cbs_setPermissions_767_0 ()) +
  gsi::Methods(_create_callback_cbs_setPermissions_767_0 ()) +
  gsi::Methods(_create_cbs_setReadable_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setReadable_864_0 ()) +
  gsi::Methods(_create_cbs_setSize_986_0 ()) +
  gsi::Methods(_create_callback_cbs_setSize_986_0 ()) +
  gsi::Methods(_create_cbs_setSymLink_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setSymLink_864_0 ()) +
  gsi::Methods(_create_cbs_setWritable_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setWritable_864_0 ()) +
  gsi::Methods(_create_ctor_QUrlInfo_Adaptor_0 ()) +
  gsi::Methods(_create_ctor_QUrlInfo_Adaptor_2097 ()),
  "@qt\n@brief Binding of QUrlInfo");

}

