
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file generated/gsiDeclQTreeWidget_EventAdaptor.h
*  @brief Event adaptor implementations for QTreeWidget
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#ifndef _HDR_gsiDeclQTreeWidget_EventAdaptor
#define _HDR_gsiDeclQTreeWidget_EventAdaptor

#include "gsiDecl.h"
#include "gsiQtEvents.h"
#include "gsiQtGui.h"
#include "gsiDeclQTreeWidget_Enums.h"

#include "layExceptions.h"

#include <QtCore/QObject>

// -----------------------------------------------------------------------
// class QTreeWidget_EventAdaptor

class QTreeWidget_EventAdaptor
  : public QObject, public qt_gsi::EventAdaptorBase, public gsi::ObjectBase
{
Q_OBJECT

public:
  QTreeWidget_EventAdaptor (QObject *host);

public slots:
  void activated(const QModelIndex &);
  void clicked(const QModelIndex &);
  void collapsed(const QModelIndex &);
  void currentItemChanged(QTreeWidgetItem *, QTreeWidgetItem *);
  void customContextMenuRequested(const QPoint &);
  void destroyed(QObject *);
  void doubleClicked(const QModelIndex &);
  void entered(const QModelIndex &);
  void expanded(const QModelIndex &);
  void itemActivated(QTreeWidgetItem *, int);
  void itemChanged(QTreeWidgetItem *, int);
  void itemClicked(QTreeWidgetItem *, int);
  void itemCollapsed(QTreeWidgetItem *);
  void itemDoubleClicked(QTreeWidgetItem *, int);
  void itemEntered(QTreeWidgetItem *, int);
  void itemExpanded(QTreeWidgetItem *);
  void itemPressed(QTreeWidgetItem *, int);
  void itemSelectionChanged();
  void pressed(const QModelIndex &);
  void viewportEntered();

public:
  gsi::event<const QModelIndex &> activated_e_2395;
  gsi::event<const QModelIndex &> clicked_e_2395;
  gsi::event<const QModelIndex &> collapsed_e_2395;
  gsi::event<QTreeWidgetItem *, QTreeWidgetItem *> currentItemChanged_e_4120;
  gsi::event<const QPoint &> customContextMenuRequested_e_1916;
  gsi::event<QObject *> destroyed_e_1302;
  gsi::event<const QModelIndex &> doubleClicked_e_2395;
  gsi::event<const QModelIndex &> entered_e_2395;
  gsi::event<const QModelIndex &> expanded_e_2395;
  gsi::event<QTreeWidgetItem *, int> itemActivated_e_2773;
  gsi::event<QTreeWidgetItem *, int> itemChanged_e_2773;
  gsi::event<QTreeWidgetItem *, int> itemClicked_e_2773;
  gsi::event<QTreeWidgetItem *> itemCollapsed_e_2114;
  gsi::event<QTreeWidgetItem *, int> itemDoubleClicked_e_2773;
  gsi::event<QTreeWidgetItem *, int> itemEntered_e_2773;
  gsi::event<QTreeWidgetItem *> itemExpanded_e_2114;
  gsi::event<QTreeWidgetItem *, int> itemPressed_e_2773;
  gsi::event<> itemSelectionChanged_e_0;
  gsi::event<const QModelIndex &> pressed_e_2395;
  gsi::event<> viewportEntered_e_0;
};

#endif
