
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTextStream.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQTextStream_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTextStream
  static short f_QTextStream_read_s(QTextStream *s)
  {
    short v = 0;
    *s >> v;
    return v;
  }

  static unsigned short f_QTextStream_read_us(QTextStream *s)
  {
    unsigned short v = 0;
    *s >> v;
    return v;
  }

  static int f_QTextStream_read_i(QTextStream *s)
  {
    int v = 0;
    *s >> v;
    return v;
  }

  static unsigned int f_QTextStream_read_ui(QTextStream *s)
  {
    unsigned int v = 0;
    *s >> v;
    return v;
  }

  static qulonglong f_QTextStream_read_ull(QTextStream *s)
  {
    qulonglong v = 0;
    *s >> v;
    return v;
  }

  static qlonglong f_QTextStream_read_ll(QTextStream *s)
  {
    qlonglong v = 0;
    *s >> v;
    return v;
  }

  static double f_QTextStream_read_double(QTextStream *s)
  {
    double v = 0;
    *s >> v;
    return v;
  }

  static float f_QTextStream_read_float(QTextStream *s)
  {
    float v = 0;
    *s >> v;
    return v;
  }

  static qt_gsi::Converter<QChar>::target_type f_QTextStream_read_qchar(QTextStream *s)
  {
    QChar v = 0;
    *s >> v;
    return qt_gsi::Converter<QChar>::toc (v);
  }

  static QString f_QTextStream_read_string(QTextStream *s)
  {
    QString v;
    *s >> v;
    return v;
  }

  static qt_gsi::Converter<QByteArray>::target_type f_QTextStream_read_bytearray(QTextStream *s)
  {
    QByteArray v;
    *s >> v;
    return qt_gsi::Converter<QByteArray>::toc (v);
  }

  static QTextStream *f_QTextStream_put_s(QTextStream *s, short v)
  {
    *s << v;
    return s;
  }

  static QTextStream *f_QTextStream_put_us(QTextStream *s, unsigned short v)
  {
    *s << v;
    return s;
  }

  static QTextStream *f_QTextStream_put_i(QTextStream *s, int v)
  {
    *s << v;
    return s;
  }

  static QTextStream *f_QTextStream_put_ui(QTextStream *s, unsigned int v)
  {
    *s << v;
    return s;
  }

  static QTextStream *f_QTextStream_put_ll(QTextStream *s, qlonglong v)
  {
    *s << v;
    return s;
  }

  static QTextStream *f_QTextStream_put_ull(QTextStream *s, qulonglong v)
  {
    *s << v;
    return s;
  }

  static QTextStream *f_QTextStream_put_float(QTextStream *s, float v)
  {
    *s << v;
    return s;
  }

  static QTextStream *f_QTextStream_put_double(QTextStream *s, double v)
  {
    *s << v;
    return s;
  }

  static QTextStream *f_QTextStream_put_qchar(QTextStream *s, const qt_gsi::Converter<class QChar>::target_type v)
  {
    *s << qt_gsi::Converter<class QChar>::toq (v);
    return s;
  }

  static QTextStream *f_QTextStream_put_string(QTextStream *s, const QString &v)
  {
    *s << v;
    return s;
  }

  static QTextStream *f_QTextStream_put_bytearray(QTextStream *s, const qt_gsi::Converter<class QByteArray>::target_type &v)
  {
    *s << qt_gsi::Converter<class QByteArray>::toq (v);
    return s;
  }


// bool QTextStream::atEnd()


static void _init_f_atEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atEnd_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextStream *)cls)->atEnd ());
}

static qt_gsi::GenericMethod *_create_f_atEnd_c0 ()
{
  return new qt_gsi::GenericMethod ("atEnd", "@brief Method bool QTextStream::atEnd()\n", true, &_init_f_atEnd_c0, &_call_f_atEnd_c0);
}

// bool QTextStream::autoDetectUnicode()


static void _init_f_autoDetectUnicode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_autoDetectUnicode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextStream *)cls)->autoDetectUnicode ());
}

static qt_gsi::GenericMethod *_create_f_autoDetectUnicode_c0 ()
{
  return new qt_gsi::GenericMethod (":autoDetectUnicode", "@brief Method bool QTextStream::autoDetectUnicode()\n", true, &_init_f_autoDetectUnicode_c0, &_call_f_autoDetectUnicode_c0);
}

// QTextCodec *QTextStream::codec()


static void _init_f_codec_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextCodec * > ();
}

static void _call_f_codec_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextCodec * > ((QTextCodec *)((QTextStream *)cls)->codec ());
}

static qt_gsi::GenericMethod *_create_f_codec_c0 ()
{
  return new qt_gsi::GenericMethod (":codec", "@brief Method QTextCodec *QTextStream::codec()\n", true, &_init_f_codec_c0, &_call_f_codec_c0);
}

// QIODevice *QTextStream::device()


static void _init_f_device_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_f_device_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QIODevice * > ((QIODevice *)((QTextStream *)cls)->device ());
}

static qt_gsi::GenericMethod *_create_f_device_c0 ()
{
  return new qt_gsi::GenericMethod (":device", "@brief Method QIODevice *QTextStream::device()\n", true, &_init_f_device_c0, &_call_f_device_c0);
}

// QTextStream::FieldAlignment QTextStream::fieldAlignment()


static void _init_f_fieldAlignment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTextStream::FieldAlignment>::target_type > ();
}

static void _call_f_fieldAlignment_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QTextStream::FieldAlignment>::target_type > ((qt_gsi::Converter<QTextStream::FieldAlignment>::target_type)qt_gsi::CppToQtAdaptor<QTextStream::FieldAlignment>(((QTextStream *)cls)->fieldAlignment ()));
}

static qt_gsi::GenericMethod *_create_f_fieldAlignment_c0 ()
{
  return new qt_gsi::GenericMethod (":fieldAlignment", "@brief Method QTextStream::FieldAlignment QTextStream::fieldAlignment()\n", true, &_init_f_fieldAlignment_c0, &_call_f_fieldAlignment_c0);
}

// int QTextStream::fieldWidth()


static void _init_f_fieldWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_fieldWidth_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextStream *)cls)->fieldWidth ());
}

static qt_gsi::GenericMethod *_create_f_fieldWidth_c0 ()
{
  return new qt_gsi::GenericMethod (":fieldWidth", "@brief Method int QTextStream::fieldWidth()\n", true, &_init_f_fieldWidth_c0, &_call_f_fieldWidth_c0);
}

// void QTextStream::flush()


static void _init_f_flush_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_flush_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextStream *)cls)->flush ();
}

static qt_gsi::GenericMethod *_create_f_flush_0 ()
{
  return new qt_gsi::GenericMethod ("flush", "@brief Method void QTextStream::flush()\n", false, &_init_f_flush_0, &_call_f_flush_0);
}

// bool QTextStream::generateByteOrderMark()


static void _init_f_generateByteOrderMark_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_generateByteOrderMark_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QTextStream *)cls)->generateByteOrderMark ());
}

static qt_gsi::GenericMethod *_create_f_generateByteOrderMark_c0 ()
{
  return new qt_gsi::GenericMethod (":generateByteOrderMark", "@brief Method bool QTextStream::generateByteOrderMark()\n", true, &_init_f_generateByteOrderMark_c0, &_call_f_generateByteOrderMark_c0);
}

// int QTextStream::integerBase()


static void _init_f_integerBase_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_integerBase_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextStream *)cls)->integerBase ());
}

static qt_gsi::GenericMethod *_create_f_integerBase_c0 ()
{
  return new qt_gsi::GenericMethod (":integerBase", "@brief Method int QTextStream::integerBase()\n", true, &_init_f_integerBase_c0, &_call_f_integerBase_c0);
}

// QLocale QTextStream::locale()


static void _init_f_locale_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLocale > ();
}

static void _call_f_locale_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLocale > ((QLocale)((QTextStream *)cls)->locale ());
}

static qt_gsi::GenericMethod *_create_f_locale_c0 ()
{
  return new qt_gsi::GenericMethod (":locale", "@brief Method QLocale QTextStream::locale()\n", true, &_init_f_locale_c0, &_call_f_locale_c0);
}

// QFlags<QTextStream::NumberFlag> QTextStream::numberFlags()


static void _init_f_numberFlags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QTextStream::NumberFlag> >::target_type > ();
}

static void _call_f_numberFlags_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QTextStream::NumberFlag> >::target_type > ((qt_gsi::Converter<QFlags<QTextStream::NumberFlag> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QTextStream::NumberFlag> >(((QTextStream *)cls)->numberFlags ()));
}

static qt_gsi::GenericMethod *_create_f_numberFlags_c0 ()
{
  return new qt_gsi::GenericMethod (":numberFlags", "@brief Method QFlags<QTextStream::NumberFlag> QTextStream::numberFlags()\n", true, &_init_f_numberFlags_c0, &_call_f_numberFlags_c0);
}

// QChar QTextStream::padChar()


static void _init_f_padChar_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QChar>::target_type > ();
}

static void _call_f_padChar_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QChar>::target_type > ((qt_gsi::Converter<QChar>::target_type)qt_gsi::CppToQtAdaptor<QChar>(((QTextStream *)cls)->padChar ()));
}

static qt_gsi::GenericMethod *_create_f_padChar_c0 ()
{
  return new qt_gsi::GenericMethod (":padChar", "@brief Method QChar QTextStream::padChar()\n", true, &_init_f_padChar_c0, &_call_f_padChar_c0);
}

// qint64 QTextStream::pos()


static void _init_f_pos_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_pos_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QTextStream *)cls)->pos ());
}

static qt_gsi::GenericMethod *_create_f_pos_c0 ()
{
  return new qt_gsi::GenericMethod ("pos", "@brief Method qint64 QTextStream::pos()\n", true, &_init_f_pos_c0, &_call_f_pos_c0);
}

// QString QTextStream::read(qint64 maxlen)


static void _init_f_read_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maxlen");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_read_986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qint64 arg1 = args.read<qint64 > ();
  ret.write<QString > ((QString)((QTextStream *)cls)->read (arg1));
}

static qt_gsi::GenericMethod *_create_f_read_986 ()
{
  return new qt_gsi::GenericMethod ("read", "@brief Method QString QTextStream::read(qint64 maxlen)\n", false, &_init_f_read_986, &_call_f_read_986);
}

// QString QTextStream::readAll()


static void _init_f_readAll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_readAll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QTextStream *)cls)->readAll ());
}

static qt_gsi::GenericMethod *_create_f_readAll_0 ()
{
  return new qt_gsi::GenericMethod ("readAll", "@brief Method QString QTextStream::readAll()\n", false, &_init_f_readAll_0, &_call_f_readAll_0);
}

// QString QTextStream::readLine(qint64 maxlen)


static void _init_f_readLine_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("maxlen", true, "0");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_readLine_986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qint64 arg1 = args ? args.read<qint64 > () : (qint64)(0);
  ret.write<QString > ((QString)((QTextStream *)cls)->readLine (arg1));
}

static qt_gsi::GenericMethod *_create_f_readLine_986 ()
{
  return new qt_gsi::GenericMethod ("readLine", "@brief Method QString QTextStream::readLine(qint64 maxlen)\n", false, &_init_f_readLine_986, &_call_f_readLine_986);
}

// QTextStream::RealNumberNotation QTextStream::realNumberNotation()


static void _init_f_realNumberNotation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTextStream::RealNumberNotation>::target_type > ();
}

static void _call_f_realNumberNotation_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QTextStream::RealNumberNotation>::target_type > ((qt_gsi::Converter<QTextStream::RealNumberNotation>::target_type)qt_gsi::CppToQtAdaptor<QTextStream::RealNumberNotation>(((QTextStream *)cls)->realNumberNotation ()));
}

static qt_gsi::GenericMethod *_create_f_realNumberNotation_c0 ()
{
  return new qt_gsi::GenericMethod (":realNumberNotation", "@brief Method QTextStream::RealNumberNotation QTextStream::realNumberNotation()\n", true, &_init_f_realNumberNotation_c0, &_call_f_realNumberNotation_c0);
}

// int QTextStream::realNumberPrecision()


static void _init_f_realNumberPrecision_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_realNumberPrecision_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QTextStream *)cls)->realNumberPrecision ());
}

static qt_gsi::GenericMethod *_create_f_realNumberPrecision_c0 ()
{
  return new qt_gsi::GenericMethod (":realNumberPrecision", "@brief Method int QTextStream::realNumberPrecision()\n", true, &_init_f_realNumberPrecision_c0, &_call_f_realNumberPrecision_c0);
}

// void QTextStream::reset()


static void _init_f_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_reset_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextStream *)cls)->reset ();
}

static qt_gsi::GenericMethod *_create_f_reset_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@brief Method void QTextStream::reset()\n", false, &_init_f_reset_0, &_call_f_reset_0);
}

// void QTextStream::resetStatus()


static void _init_f_resetStatus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resetStatus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextStream *)cls)->resetStatus ();
}

static qt_gsi::GenericMethod *_create_f_resetStatus_0 ()
{
  return new qt_gsi::GenericMethod ("resetStatus", "@brief Method void QTextStream::resetStatus()\n", false, &_init_f_resetStatus_0, &_call_f_resetStatus_0);
}

// bool QTextStream::seek(qint64 pos)


static void _init_f_seek_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_seek_986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qint64 arg1 = args.read<qint64 > ();
  ret.write<bool > ((bool)((QTextStream *)cls)->seek (arg1));
}

static qt_gsi::GenericMethod *_create_f_seek_986 ()
{
  return new qt_gsi::GenericMethod ("seek", "@brief Method bool QTextStream::seek(qint64 pos)\n", false, &_init_f_seek_986, &_call_f_seek_986);
}

// void QTextStream::setAutoDetectUnicode(bool enabled)


static void _init_f_setAutoDetectUnicode_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoDetectUnicode_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QTextStream *)cls)->setAutoDetectUnicode (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAutoDetectUnicode_864 ()
{
  return new qt_gsi::GenericMethod ("setAutoDetectUnicode|autoDetectUnicode=", "@brief Method void QTextStream::setAutoDetectUnicode(bool enabled)\n", false, &_init_f_setAutoDetectUnicode_864, &_call_f_setAutoDetectUnicode_864);
}

// void QTextStream::setCodec(QTextCodec *codec)


static void _init_f_setCodec_1602 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("codec");
  decl->add_arg<QTextCodec * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCodec_1602 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextCodec *arg1 = args.read<QTextCodec * > ();
  ((QTextStream *)cls)->setCodec (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCodec_1602 ()
{
  return new qt_gsi::GenericMethod ("setCodec|codec=", "@brief Method void QTextStream::setCodec(QTextCodec *codec)\n", false, &_init_f_setCodec_1602, &_call_f_setCodec_1602);
}

// void QTextStream::setCodec(const char *codecName)


static void _init_f_setCodec_1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("codecName");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCodec_1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QTextStream *)cls)->setCodec (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCodec_1731 ()
{
  return new qt_gsi::GenericMethod ("setCodec|codec=", "@brief Method void QTextStream::setCodec(const char *codecName)\n", false, &_init_f_setCodec_1731, &_call_f_setCodec_1731);
}

// void QTextStream::setDevice(QIODevice *device)


static void _init_f_setDevice_1447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDevice_1447 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QIODevice *arg1 = args.read<QIODevice * > ();
  ((QTextStream *)cls)->setDevice (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDevice_1447 ()
{
  return new qt_gsi::GenericMethod ("setDevice|device=", "@brief Method void QTextStream::setDevice(QIODevice *device)\n", false, &_init_f_setDevice_1447, &_call_f_setDevice_1447);
}

// void QTextStream::setFieldAlignment(QTextStream::FieldAlignment alignment)


static void _init_f_setFieldAlignment_3085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("alignment");
  decl->add_arg<const qt_gsi::Converter<QTextStream::FieldAlignment>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFieldAlignment_3085 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QTextStream::FieldAlignment>::target_type & arg1 = args.read<const qt_gsi::Converter<QTextStream::FieldAlignment>::target_type & > ();
  ((QTextStream *)cls)->setFieldAlignment (qt_gsi::QtToCppAdaptor<QTextStream::FieldAlignment>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setFieldAlignment_3085 ()
{
  return new qt_gsi::GenericMethod ("setFieldAlignment|fieldAlignment=", "@brief Method void QTextStream::setFieldAlignment(QTextStream::FieldAlignment alignment)\n", false, &_init_f_setFieldAlignment_3085, &_call_f_setFieldAlignment_3085);
}

// void QTextStream::setFieldWidth(int width)


static void _init_f_setFieldWidth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFieldWidth_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTextStream *)cls)->setFieldWidth (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFieldWidth_767 ()
{
  return new qt_gsi::GenericMethod ("setFieldWidth|fieldWidth=", "@brief Method void QTextStream::setFieldWidth(int width)\n", false, &_init_f_setFieldWidth_767, &_call_f_setFieldWidth_767);
}

// void QTextStream::setGenerateByteOrderMark(bool generate)


static void _init_f_setGenerateByteOrderMark_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("generate");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGenerateByteOrderMark_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QTextStream *)cls)->setGenerateByteOrderMark (arg1);
}

static qt_gsi::GenericMethod *_create_f_setGenerateByteOrderMark_864 ()
{
  return new qt_gsi::GenericMethod ("setGenerateByteOrderMark|generateByteOrderMark=", "@brief Method void QTextStream::setGenerateByteOrderMark(bool generate)\n", false, &_init_f_setGenerateByteOrderMark_864, &_call_f_setGenerateByteOrderMark_864);
}

// void QTextStream::setIntegerBase(int base)


static void _init_f_setIntegerBase_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("base");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIntegerBase_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTextStream *)cls)->setIntegerBase (arg1);
}

static qt_gsi::GenericMethod *_create_f_setIntegerBase_767 ()
{
  return new qt_gsi::GenericMethod ("setIntegerBase|integerBase=", "@brief Method void QTextStream::setIntegerBase(int base)\n", false, &_init_f_setIntegerBase_767, &_call_f_setIntegerBase_767);
}

// void QTextStream::setLocale(const QLocale &locale)


static void _init_f_setLocale_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("locale");
  decl->add_arg<const QLocale & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLocale_1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QLocale &arg1 = args.read<const QLocale & > ();
  ((QTextStream *)cls)->setLocale (arg1);
}

static qt_gsi::GenericMethod *_create_f_setLocale_1986 ()
{
  return new qt_gsi::GenericMethod ("setLocale|locale=", "@brief Method void QTextStream::setLocale(const QLocale &locale)\n", false, &_init_f_setLocale_1986, &_call_f_setLocale_1986);
}

// void QTextStream::setNumberFlags(QFlags<QTextStream::NumberFlag> flags)


static void _init_f_setNumberFlags_3365 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<QTextStream::NumberFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNumberFlags_3365 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QTextStream::NumberFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QTextStream::NumberFlag> >::target_type & > ();
  ((QTextStream *)cls)->setNumberFlags (qt_gsi::QtToCppAdaptor<QFlags<QTextStream::NumberFlag> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setNumberFlags_3365 ()
{
  return new qt_gsi::GenericMethod ("setNumberFlags|numberFlags=", "@brief Method void QTextStream::setNumberFlags(QFlags<QTextStream::NumberFlag> flags)\n", false, &_init_f_setNumberFlags_3365, &_call_f_setNumberFlags_3365);
}

// void QTextStream::setPadChar(QChar ch)


static void _init_f_setPadChar_899 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ch");
  decl->add_arg<const qt_gsi::Converter<QChar>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPadChar_899 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QChar>::target_type & arg1 = args.read<const qt_gsi::Converter<QChar>::target_type & > ();
  ((QTextStream *)cls)->setPadChar (qt_gsi::QtToCppAdaptor<QChar>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setPadChar_899 ()
{
  return new qt_gsi::GenericMethod ("setPadChar|padChar=", "@brief Method void QTextStream::setPadChar(QChar ch)\n", false, &_init_f_setPadChar_899, &_call_f_setPadChar_899);
}

// void QTextStream::setRealNumberNotation(QTextStream::RealNumberNotation notation)


static void _init_f_setRealNumberNotation_3523 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("notation");
  decl->add_arg<const qt_gsi::Converter<QTextStream::RealNumberNotation>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRealNumberNotation_3523 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QTextStream::RealNumberNotation>::target_type & arg1 = args.read<const qt_gsi::Converter<QTextStream::RealNumberNotation>::target_type & > ();
  ((QTextStream *)cls)->setRealNumberNotation (qt_gsi::QtToCppAdaptor<QTextStream::RealNumberNotation>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setRealNumberNotation_3523 ()
{
  return new qt_gsi::GenericMethod ("setRealNumberNotation|realNumberNotation=", "@brief Method void QTextStream::setRealNumberNotation(QTextStream::RealNumberNotation notation)\n", false, &_init_f_setRealNumberNotation_3523, &_call_f_setRealNumberNotation_3523);
}

// void QTextStream::setRealNumberPrecision(int precision)


static void _init_f_setRealNumberPrecision_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("precision");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRealNumberPrecision_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QTextStream *)cls)->setRealNumberPrecision (arg1);
}

static qt_gsi::GenericMethod *_create_f_setRealNumberPrecision_767 ()
{
  return new qt_gsi::GenericMethod ("setRealNumberPrecision|realNumberPrecision=", "@brief Method void QTextStream::setRealNumberPrecision(int precision)\n", false, &_init_f_setRealNumberPrecision_767, &_call_f_setRealNumberPrecision_767);
}

// void QTextStream::setStatus(QTextStream::Status status)


static void _init_f_setStatus_2318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("status");
  decl->add_arg<const qt_gsi::Converter<QTextStream::Status>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStatus_2318 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QTextStream::Status>::target_type & arg1 = args.read<const qt_gsi::Converter<QTextStream::Status>::target_type & > ();
  ((QTextStream *)cls)->setStatus (qt_gsi::QtToCppAdaptor<QTextStream::Status>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setStatus_2318 ()
{
  return new qt_gsi::GenericMethod ("setStatus|status=", "@brief Method void QTextStream::setStatus(QTextStream::Status status)\n", false, &_init_f_setStatus_2318, &_call_f_setStatus_2318);
}

// void QTextStream::setString(QString *string, QFlags<QIODevice::OpenModeFlag> openMode)


static void _init_f_setString_4468 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<QString * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("openMode", true, "QIODevice::ReadWrite");
  decl->add_arg<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setString_4468 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QString *arg1 = args.read<QString * > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QIODevice::OpenModeFlag> >(heap, QIODevice::ReadWrite));
  ((QTextStream *)cls)->setString (arg1, qt_gsi::QtToCppAdaptor<QFlags<QIODevice::OpenModeFlag> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setString_4468 ()
{
  return new qt_gsi::GenericMethod ("setString", "@brief Method void QTextStream::setString(QString *string, QFlags<QIODevice::OpenModeFlag> openMode)\n", false, &_init_f_setString_4468, &_call_f_setString_4468);
}

// void QTextStream::skipWhiteSpace()


static void _init_f_skipWhiteSpace_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_skipWhiteSpace_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QTextStream *)cls)->skipWhiteSpace ();
}

static qt_gsi::GenericMethod *_create_f_skipWhiteSpace_0 ()
{
  return new qt_gsi::GenericMethod ("skipWhiteSpace", "@brief Method void QTextStream::skipWhiteSpace()\n", false, &_init_f_skipWhiteSpace_0, &_call_f_skipWhiteSpace_0);
}

// QTextStream::Status QTextStream::status()


static void _init_f_status_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTextStream::Status>::target_type > ();
}

static void _call_f_status_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QTextStream::Status>::target_type > ((qt_gsi::Converter<QTextStream::Status>::target_type)qt_gsi::CppToQtAdaptor<QTextStream::Status>(((QTextStream *)cls)->status ()));
}

static qt_gsi::GenericMethod *_create_f_status_c0 ()
{
  return new qt_gsi::GenericMethod (":status", "@brief Method QTextStream::Status QTextStream::status()\n", true, &_init_f_status_c0, &_call_f_status_c0);
}

// QString *QTextStream::string()


static void _init_f_string_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString * > ();
}

static void _call_f_string_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString * > ((QString *)((QTextStream *)cls)->string ());
}

static qt_gsi::GenericMethod *_create_f_string_c0 ()
{
  return new qt_gsi::GenericMethod (":string", "@brief Method QString *QTextStream::string()\n", true, &_init_f_string_c0, &_call_f_string_c0);
}

namespace gsi
{
gsi::Class<QTextStream> decl_QTextStream ("QTextStream_Native",
  gsi::method_ext("read_s", &f_QTextStream_read_s, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_us", &f_QTextStream_read_us, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_i", &f_QTextStream_read_i, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_ui", &f_QTextStream_read_ui, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_ull", &f_QTextStream_read_ull, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_ll", &f_QTextStream_read_ll, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_d", &f_QTextStream_read_double, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_f", &f_QTextStream_read_float, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_qc", &f_QTextStream_read_qchar, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_s", &f_QTextStream_read_string, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_ba", &f_QTextStream_read_bytearray, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("put_s", &f_QTextStream_put_s, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_us", &f_QTextStream_put_us, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_i", &f_QTextStream_put_i, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_ui", &f_QTextStream_put_ui, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_ull", &f_QTextStream_put_ull, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_ll", &f_QTextStream_put_ll, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_d", &f_QTextStream_put_double, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_f", &f_QTextStream_put_float, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_qc", &f_QTextStream_put_qchar, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_s", &f_QTextStream_put_string, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_ba", &f_QTextStream_put_bytearray, "@brief Unambiguous adaptation of the corresponding operator<<") 
+
  gsi::Methods(_create_f_atEnd_c0 ()) +
  gsi::Methods(_create_f_autoDetectUnicode_c0 ()) +
  gsi::Methods(_create_f_codec_c0 ()) +
  gsi::Methods(_create_f_device_c0 ()) +
  gsi::Methods(_create_f_fieldAlignment_c0 ()) +
  gsi::Methods(_create_f_fieldWidth_c0 ()) +
  gsi::Methods(_create_f_flush_0 ()) +
  gsi::Methods(_create_f_generateByteOrderMark_c0 ()) +
  gsi::Methods(_create_f_integerBase_c0 ()) +
  gsi::Methods(_create_f_locale_c0 ()) +
  gsi::Methods(_create_f_numberFlags_c0 ()) +
  gsi::Methods(_create_f_padChar_c0 ()) +
  gsi::Methods(_create_f_pos_c0 ()) +
  gsi::Methods(_create_f_read_986 ()) +
  gsi::Methods(_create_f_readAll_0 ()) +
  gsi::Methods(_create_f_readLine_986 ()) +
  gsi::Methods(_create_f_realNumberNotation_c0 ()) +
  gsi::Methods(_create_f_realNumberPrecision_c0 ()) +
  gsi::Methods(_create_f_reset_0 ()) +
  gsi::Methods(_create_f_resetStatus_0 ()) +
  gsi::Methods(_create_f_seek_986 ()) +
  gsi::Methods(_create_f_setAutoDetectUnicode_864 ()) +
  gsi::Methods(_create_f_setCodec_1602 ()) +
  gsi::Methods(_create_f_setCodec_1731 ()) +
  gsi::Methods(_create_f_setDevice_1447 ()) +
  gsi::Methods(_create_f_setFieldAlignment_3085 ()) +
  gsi::Methods(_create_f_setFieldWidth_767 ()) +
  gsi::Methods(_create_f_setGenerateByteOrderMark_864 ()) +
  gsi::Methods(_create_f_setIntegerBase_767 ()) +
  gsi::Methods(_create_f_setLocale_1986 ()) +
  gsi::Methods(_create_f_setNumberFlags_3365 ()) +
  gsi::Methods(_create_f_setPadChar_899 ()) +
  gsi::Methods(_create_f_setRealNumberNotation_3523 ()) +
  gsi::Methods(_create_f_setRealNumberPrecision_767 ()) +
  gsi::Methods(_create_f_setStatus_2318 ()) +
  gsi::Methods(_create_f_setString_4468 ()) +
  gsi::Methods(_create_f_skipWhiteSpace_0 ()) +
  gsi::Methods(_create_f_status_c0 ()) +
  gsi::Methods(_create_f_string_c0 ()),
  "@hide\n@alias QTextStream");
}


class QTextStream_Adaptor : public QTextStream, public qt_gsi::QtObjectBase
{
public:

  virtual ~QTextStream_Adaptor();

  //  [adaptor ctor] QTextStream::QTextStream()
  QTextStream_Adaptor() : QTextStream()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTextStream::QTextStream(QIODevice *device)
  QTextStream_Adaptor(QIODevice *device) : QTextStream(device)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTextStream::QTextStream(QString *string, QFlags<QIODevice::OpenModeFlag> openMode)
  QTextStream_Adaptor(QString *string) : QTextStream(string)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTextStream::QTextStream(QString *string, QFlags<QIODevice::OpenModeFlag> openMode)
  QTextStream_Adaptor(QString *string, QFlags<QIODevice::OpenModeFlag> openMode) : QTextStream(string, openMode)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  
};

QTextStream_Adaptor::~QTextStream_Adaptor() { }

//  Constructor QTextStream::QTextStream() (adaptor class)

static void _init_ctor_QTextStream_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QTextStream_Adaptor *> ();
}

static void _call_ctor_QTextStream_Adaptor_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextStream_Adaptor *> (new QTextStream_Adaptor ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextStream_Adaptor_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextStream::QTextStream()\nThis method creates an object of class QTextStream.", &_init_ctor_QTextStream_Adaptor_0, &_call_ctor_QTextStream_Adaptor_0);
}

//  Constructor QTextStream::QTextStream(QIODevice *device) (adaptor class)

static void _init_ctor_QTextStream_Adaptor_1447 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return_new<QTextStream_Adaptor *> ();
}

static void _call_ctor_QTextStream_Adaptor_1447 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QIODevice *arg1 = args.read<QIODevice * > ();
  ret.write<QTextStream_Adaptor *> (new QTextStream_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextStream_Adaptor_1447 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextStream::QTextStream(QIODevice *device)\nThis method creates an object of class QTextStream.", &_init_ctor_QTextStream_Adaptor_1447, &_call_ctor_QTextStream_Adaptor_1447);
}

//  Constructor QTextStream::QTextStream(QString *string, QFlags<QIODevice::OpenModeFlag> openMode) (adaptor class)

static void _init_ctor_QTextStream_Adaptor_4468 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<QString * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("openMode", true, "QIODevice::ReadWrite");
  decl->add_arg<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > (argspec_1);
  decl->set_return_new<QTextStream_Adaptor *> ();
}

static void _call_ctor_QTextStream_Adaptor_4468 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QString *arg1 = args.read<QString * > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QIODevice::OpenModeFlag> >(heap, QIODevice::ReadWrite));
  ret.write<QTextStream_Adaptor *> (new QTextStream_Adaptor (arg1, qt_gsi::QtToCppAdaptor<QFlags<QIODevice::OpenModeFlag> >(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QTextStream_Adaptor_4468 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTextStream::QTextStream(QString *string, QFlags<QIODevice::OpenModeFlag> openMode)\nThis method creates an object of class QTextStream.", &_init_ctor_QTextStream_Adaptor_4468, &_call_ctor_QTextStream_Adaptor_4468);
}

namespace gsi
{

extern gsi::Class<QTextStream> decl_QTextStream;

gsi::Class<QTextStream_Adaptor> decl_QTextStream_Adaptor (decl_QTextStream, "QTextStream",
  gsi::Methods(_create_ctor_QTextStream_Adaptor_0 ()) +
  gsi::Methods(_create_ctor_QTextStream_Adaptor_1447 ()) +
  gsi::Methods(_create_ctor_QTextStream_Adaptor_4468 ()),
  "@qt\n@brief Binding of QTextStream");

}


//  Implementation of the enum wrapper class for QTextStream::FieldAlignment
namespace qt_gsi
{

static QTextStream_FieldAlignment_Enum *c_1_QTextStream_FieldAlignment_Enum () { return new QTextStream_FieldAlignment_Enum (QTextStream::AlignLeft); }
static QTextStream_FieldAlignment_Enum *c_2_QTextStream_FieldAlignment_Enum () { return new QTextStream_FieldAlignment_Enum (QTextStream::AlignRight); }
static QTextStream_FieldAlignment_Enum *c_3_QTextStream_FieldAlignment_Enum () { return new QTextStream_FieldAlignment_Enum (QTextStream::AlignCenter); }
static QTextStream_FieldAlignment_Enum *c_4_QTextStream_FieldAlignment_Enum () { return new QTextStream_FieldAlignment_Enum (QTextStream::AlignAccountingStyle); }

static gsi::Methods mkdefs_QTextStream_FieldAlignment () {
  return
    gsi::constant ("AlignLeft", &qt_gsi::c_1_QTextStream_FieldAlignment_Enum, "@brief Enum constant QTextStream::AlignLeft") +
    gsi::constant ("AlignRight", &qt_gsi::c_2_QTextStream_FieldAlignment_Enum, "@brief Enum constant QTextStream::AlignRight") +
    gsi::constant ("AlignCenter", &qt_gsi::c_3_QTextStream_FieldAlignment_Enum, "@brief Enum constant QTextStream::AlignCenter") +
    gsi::constant ("AlignAccountingStyle", &qt_gsi::c_4_QTextStream_FieldAlignment_Enum, "@brief Enum constant QTextStream::AlignAccountingStyle");
}

static std::string to_s_QTextStream_FieldAlignment_Enum (const QTextStream_FieldAlignment_Enum *e)
{
  if (e->value () == QTextStream::AlignLeft) { return tl::sprintf ("AlignLeft (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextStream::AlignRight) { return tl::sprintf ("AlignRight (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextStream::AlignCenter) { return tl::sprintf ("AlignCenter (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextStream::AlignAccountingStyle) { return tl::sprintf ("AlignAccountingStyle (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTextStream_FieldAlignment_Enum (const QTextStream_FieldAlignment_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTextStream_FieldAlignment_Enum *from_i_QTextStream_FieldAlignment_Enum (unsigned int i)
{
  return new QTextStream_FieldAlignment_Enum ((QTextStream::FieldAlignment) i);
}

static bool equalQTextStream_FieldAlignment_Enum (const QTextStream_FieldAlignment_Enum *e, QTextStream_FieldAlignment_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTextStream_FieldAlignment_Enum (const QTextStream_FieldAlignment_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTextStream_FieldAlignment_Enums oropQTextStream_FieldAlignment_Enums (const QTextStream_FieldAlignment_Enums *e, const QTextStream_FieldAlignment_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTextStream_FieldAlignment_Enums andopQTextStream_FieldAlignment_Enums (const QTextStream_FieldAlignment_Enums *e, const QTextStream_FieldAlignment_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTextStream_FieldAlignment_Enums xoropQTextStream_FieldAlignment_Enums (const QTextStream_FieldAlignment_Enums *e, const QTextStream_FieldAlignment_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTextStream_FieldAlignment_Enums (const QTextStream_FieldAlignment_Enums *e)
{
  std::string l;
  if (e->testFlag (QTextStream::AlignLeft)) { if (!l.empty ()) l += "|"; l += "AlignLeft"; }
  if (e->testFlag (QTextStream::AlignRight)) { if (!l.empty ()) l += "|"; l += "AlignRight"; }
  if (e->testFlag (QTextStream::AlignCenter)) { if (!l.empty ()) l += "|"; l += "AlignCenter"; }
  if (e->testFlag (QTextStream::AlignAccountingStyle)) { if (!l.empty ()) l += "|"; l += "AlignAccountingStyle"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTextStream_FieldAlignment_Enums (const QTextStream_FieldAlignment_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTextStream_FieldAlignment_Enums (const QTextStream_FieldAlignment_Enums *e, const QTextStream_FieldAlignment_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTextStream_FieldAlignment_Enums> decl_QTextStream_FieldAlignment_Enums ("QTextStream_QFlags_FieldAlignment",
  gsi::method_ext ("|", &qt_gsi::oropQTextStream_FieldAlignment_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTextStream_FieldAlignment_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTextStream_FieldAlignment_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextStream_FieldAlignment_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextStream_FieldAlignment_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTextStream_FieldAlignment_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTextStream::FieldAlignment> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTextStream_FieldAlignment_Enum> decl_QTextStream_FieldAlignment_Enum (decl_QTextStream_FieldAlignment_Enums, "QTextStream_FieldAlignment",
  qt_gsi::mkdefs_QTextStream_FieldAlignment () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextStream_FieldAlignment_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextStream_FieldAlignment_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTextStream_FieldAlignment_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTextStream_FieldAlignment_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTextStream_FieldAlignment_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTextStream::FieldAlignment enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextStream> inject_QTextStream_FieldAlignment_Enum_in_parent (qt_gsi::mkdefs_QTextStream_FieldAlignment ());
static gsi::ClassExt<QTextStream> decl_QTextStream_FieldAlignment_Enum_as_child (decl_QTextStream_FieldAlignment_Enum, "FieldAlignment");

}


//  Implementation of the enum wrapper class for QTextStream::NumberFlag
namespace qt_gsi
{

static QTextStream_NumberFlag_Enum *c_1_QTextStream_NumberFlag_Enum () { return new QTextStream_NumberFlag_Enum (QTextStream::ShowBase); }
static QTextStream_NumberFlag_Enum *c_2_QTextStream_NumberFlag_Enum () { return new QTextStream_NumberFlag_Enum (QTextStream::ForcePoint); }
static QTextStream_NumberFlag_Enum *c_3_QTextStream_NumberFlag_Enum () { return new QTextStream_NumberFlag_Enum (QTextStream::ForceSign); }
static QTextStream_NumberFlag_Enum *c_4_QTextStream_NumberFlag_Enum () { return new QTextStream_NumberFlag_Enum (QTextStream::UppercaseBase); }
static QTextStream_NumberFlag_Enum *c_5_QTextStream_NumberFlag_Enum () { return new QTextStream_NumberFlag_Enum (QTextStream::UppercaseDigits); }

static gsi::Methods mkdefs_QTextStream_NumberFlag () {
  return
    gsi::constant ("ShowBase", &qt_gsi::c_1_QTextStream_NumberFlag_Enum, "@brief Enum constant QTextStream::ShowBase") +
    gsi::constant ("ForcePoint", &qt_gsi::c_2_QTextStream_NumberFlag_Enum, "@brief Enum constant QTextStream::ForcePoint") +
    gsi::constant ("ForceSign", &qt_gsi::c_3_QTextStream_NumberFlag_Enum, "@brief Enum constant QTextStream::ForceSign") +
    gsi::constant ("UppercaseBase", &qt_gsi::c_4_QTextStream_NumberFlag_Enum, "@brief Enum constant QTextStream::UppercaseBase") +
    gsi::constant ("UppercaseDigits", &qt_gsi::c_5_QTextStream_NumberFlag_Enum, "@brief Enum constant QTextStream::UppercaseDigits");
}

static std::string to_s_QTextStream_NumberFlag_Enum (const QTextStream_NumberFlag_Enum *e)
{
  if (e->value () == QTextStream::ShowBase) { return tl::sprintf ("ShowBase (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextStream::ForcePoint) { return tl::sprintf ("ForcePoint (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextStream::ForceSign) { return tl::sprintf ("ForceSign (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextStream::UppercaseBase) { return tl::sprintf ("UppercaseBase (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextStream::UppercaseDigits) { return tl::sprintf ("UppercaseDigits (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTextStream_NumberFlag_Enum (const QTextStream_NumberFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTextStream_NumberFlag_Enum *from_i_QTextStream_NumberFlag_Enum (unsigned int i)
{
  return new QTextStream_NumberFlag_Enum ((QTextStream::NumberFlag) i);
}

static bool equalQTextStream_NumberFlag_Enum (const QTextStream_NumberFlag_Enum *e, QTextStream_NumberFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTextStream_NumberFlag_Enum (const QTextStream_NumberFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTextStream_NumberFlag_Enums oropQTextStream_NumberFlag_Enums (const QTextStream_NumberFlag_Enums *e, const QTextStream_NumberFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTextStream_NumberFlag_Enums andopQTextStream_NumberFlag_Enums (const QTextStream_NumberFlag_Enums *e, const QTextStream_NumberFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTextStream_NumberFlag_Enums xoropQTextStream_NumberFlag_Enums (const QTextStream_NumberFlag_Enums *e, const QTextStream_NumberFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTextStream_NumberFlag_Enums (const QTextStream_NumberFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (QTextStream::ShowBase)) { if (!l.empty ()) l += "|"; l += "ShowBase"; }
  if (e->testFlag (QTextStream::ForcePoint)) { if (!l.empty ()) l += "|"; l += "ForcePoint"; }
  if (e->testFlag (QTextStream::ForceSign)) { if (!l.empty ()) l += "|"; l += "ForceSign"; }
  if (e->testFlag (QTextStream::UppercaseBase)) { if (!l.empty ()) l += "|"; l += "UppercaseBase"; }
  if (e->testFlag (QTextStream::UppercaseDigits)) { if (!l.empty ()) l += "|"; l += "UppercaseDigits"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTextStream_NumberFlag_Enums (const QTextStream_NumberFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTextStream_NumberFlag_Enums (const QTextStream_NumberFlag_Enums *e, const QTextStream_NumberFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTextStream_NumberFlag_Enums> decl_QTextStream_NumberFlag_Enums ("QTextStream_QFlags_NumberFlag",
  gsi::method_ext ("|", &qt_gsi::oropQTextStream_NumberFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTextStream_NumberFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTextStream_NumberFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextStream_NumberFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextStream_NumberFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTextStream_NumberFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTextStream::NumberFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTextStream_NumberFlag_Enum> decl_QTextStream_NumberFlag_Enum (decl_QTextStream_NumberFlag_Enums, "QTextStream_NumberFlag",
  qt_gsi::mkdefs_QTextStream_NumberFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextStream_NumberFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextStream_NumberFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTextStream_NumberFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTextStream_NumberFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTextStream_NumberFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTextStream::NumberFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextStream> inject_QTextStream_NumberFlag_Enum_in_parent (qt_gsi::mkdefs_QTextStream_NumberFlag ());
static gsi::ClassExt<QTextStream> decl_QTextStream_NumberFlag_Enum_as_child (decl_QTextStream_NumberFlag_Enum, "NumberFlag");

}


//  Implementation of the enum wrapper class for QTextStream::RealNumberNotation
namespace qt_gsi
{

static QTextStream_RealNumberNotation_Enum *c_1_QTextStream_RealNumberNotation_Enum () { return new QTextStream_RealNumberNotation_Enum (QTextStream::SmartNotation); }
static QTextStream_RealNumberNotation_Enum *c_2_QTextStream_RealNumberNotation_Enum () { return new QTextStream_RealNumberNotation_Enum (QTextStream::FixedNotation); }
static QTextStream_RealNumberNotation_Enum *c_3_QTextStream_RealNumberNotation_Enum () { return new QTextStream_RealNumberNotation_Enum (QTextStream::ScientificNotation); }

static gsi::Methods mkdefs_QTextStream_RealNumberNotation () {
  return
    gsi::constant ("SmartNotation", &qt_gsi::c_1_QTextStream_RealNumberNotation_Enum, "@brief Enum constant QTextStream::SmartNotation") +
    gsi::constant ("FixedNotation", &qt_gsi::c_2_QTextStream_RealNumberNotation_Enum, "@brief Enum constant QTextStream::FixedNotation") +
    gsi::constant ("ScientificNotation", &qt_gsi::c_3_QTextStream_RealNumberNotation_Enum, "@brief Enum constant QTextStream::ScientificNotation");
}

static std::string to_s_QTextStream_RealNumberNotation_Enum (const QTextStream_RealNumberNotation_Enum *e)
{
  if (e->value () == QTextStream::SmartNotation) { return tl::sprintf ("SmartNotation (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextStream::FixedNotation) { return tl::sprintf ("FixedNotation (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextStream::ScientificNotation) { return tl::sprintf ("ScientificNotation (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTextStream_RealNumberNotation_Enum (const QTextStream_RealNumberNotation_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTextStream_RealNumberNotation_Enum *from_i_QTextStream_RealNumberNotation_Enum (unsigned int i)
{
  return new QTextStream_RealNumberNotation_Enum ((QTextStream::RealNumberNotation) i);
}

static bool equalQTextStream_RealNumberNotation_Enum (const QTextStream_RealNumberNotation_Enum *e, QTextStream_RealNumberNotation_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTextStream_RealNumberNotation_Enum (const QTextStream_RealNumberNotation_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTextStream_RealNumberNotation_Enums oropQTextStream_RealNumberNotation_Enums (const QTextStream_RealNumberNotation_Enums *e, const QTextStream_RealNumberNotation_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTextStream_RealNumberNotation_Enums andopQTextStream_RealNumberNotation_Enums (const QTextStream_RealNumberNotation_Enums *e, const QTextStream_RealNumberNotation_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTextStream_RealNumberNotation_Enums xoropQTextStream_RealNumberNotation_Enums (const QTextStream_RealNumberNotation_Enums *e, const QTextStream_RealNumberNotation_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTextStream_RealNumberNotation_Enums (const QTextStream_RealNumberNotation_Enums *e)
{
  std::string l;
  if (e->testFlag (QTextStream::SmartNotation)) { if (!l.empty ()) l += "|"; l += "SmartNotation"; }
  if (e->testFlag (QTextStream::FixedNotation)) { if (!l.empty ()) l += "|"; l += "FixedNotation"; }
  if (e->testFlag (QTextStream::ScientificNotation)) { if (!l.empty ()) l += "|"; l += "ScientificNotation"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTextStream_RealNumberNotation_Enums (const QTextStream_RealNumberNotation_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTextStream_RealNumberNotation_Enums (const QTextStream_RealNumberNotation_Enums *e, const QTextStream_RealNumberNotation_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTextStream_RealNumberNotation_Enums> decl_QTextStream_RealNumberNotation_Enums ("QTextStream_QFlags_RealNumberNotation",
  gsi::method_ext ("|", &qt_gsi::oropQTextStream_RealNumberNotation_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTextStream_RealNumberNotation_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTextStream_RealNumberNotation_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextStream_RealNumberNotation_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextStream_RealNumberNotation_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTextStream_RealNumberNotation_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTextStream::RealNumberNotation> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTextStream_RealNumberNotation_Enum> decl_QTextStream_RealNumberNotation_Enum (decl_QTextStream_RealNumberNotation_Enums, "QTextStream_RealNumberNotation",
  qt_gsi::mkdefs_QTextStream_RealNumberNotation () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextStream_RealNumberNotation_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextStream_RealNumberNotation_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTextStream_RealNumberNotation_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTextStream_RealNumberNotation_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTextStream_RealNumberNotation_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTextStream::RealNumberNotation enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextStream> inject_QTextStream_RealNumberNotation_Enum_in_parent (qt_gsi::mkdefs_QTextStream_RealNumberNotation ());
static gsi::ClassExt<QTextStream> decl_QTextStream_RealNumberNotation_Enum_as_child (decl_QTextStream_RealNumberNotation_Enum, "RealNumberNotation");

}


//  Implementation of the enum wrapper class for QTextStream::Status
namespace qt_gsi
{

static QTextStream_Status_Enum *c_1_QTextStream_Status_Enum () { return new QTextStream_Status_Enum (QTextStream::Ok); }
static QTextStream_Status_Enum *c_2_QTextStream_Status_Enum () { return new QTextStream_Status_Enum (QTextStream::ReadPastEnd); }
static QTextStream_Status_Enum *c_3_QTextStream_Status_Enum () { return new QTextStream_Status_Enum (QTextStream::ReadCorruptData); }

static gsi::Methods mkdefs_QTextStream_Status () {
  return
    gsi::constant ("Ok", &qt_gsi::c_1_QTextStream_Status_Enum, "@brief Enum constant QTextStream::Ok") +
    gsi::constant ("ReadPastEnd", &qt_gsi::c_2_QTextStream_Status_Enum, "@brief Enum constant QTextStream::ReadPastEnd") +
    gsi::constant ("ReadCorruptData", &qt_gsi::c_3_QTextStream_Status_Enum, "@brief Enum constant QTextStream::ReadCorruptData");
}

static std::string to_s_QTextStream_Status_Enum (const QTextStream_Status_Enum *e)
{
  if (e->value () == QTextStream::Ok) { return tl::sprintf ("Ok (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextStream::ReadPastEnd) { return tl::sprintf ("ReadPastEnd (%u)", (unsigned int) e->value ()); }
  if (e->value () == QTextStream::ReadCorruptData) { return tl::sprintf ("ReadCorruptData (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QTextStream_Status_Enum (const QTextStream_Status_Enum *e)
{
  return (unsigned int) e->value ();
}

static QTextStream_Status_Enum *from_i_QTextStream_Status_Enum (unsigned int i)
{
  return new QTextStream_Status_Enum ((QTextStream::Status) i);
}

static bool equalQTextStream_Status_Enum (const QTextStream_Status_Enum *e, QTextStream_Status_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QTextStream_Status_Enum (const QTextStream_Status_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QTextStream_Status_Enums oropQTextStream_Status_Enums (const QTextStream_Status_Enums *e, const QTextStream_Status_Enums &d)
{
  return e->flags () | d.flags ();
}

static QTextStream_Status_Enums andopQTextStream_Status_Enums (const QTextStream_Status_Enums *e, const QTextStream_Status_Enums &d)
{
  return e->flags () & d.flags ();
}

static QTextStream_Status_Enums xoropQTextStream_Status_Enums (const QTextStream_Status_Enums *e, const QTextStream_Status_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QTextStream_Status_Enums (const QTextStream_Status_Enums *e)
{
  std::string l;
  if (e->testFlag (QTextStream::Ok)) { if (!l.empty ()) l += "|"; l += "Ok"; }
  if (e->testFlag (QTextStream::ReadPastEnd)) { if (!l.empty ()) l += "|"; l += "ReadPastEnd"; }
  if (e->testFlag (QTextStream::ReadCorruptData)) { if (!l.empty ()) l += "|"; l += "ReadCorruptData"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QTextStream_Status_Enums (const QTextStream_Status_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QTextStream_Status_Enums (const QTextStream_Status_Enums *e, const QTextStream_Status_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QTextStream_Status_Enums> decl_QTextStream_Status_Enums ("QTextStream_QFlags_Status",
  gsi::method_ext ("|", &qt_gsi::oropQTextStream_Status_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQTextStream_Status_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQTextStream_Status_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextStream_Status_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextStream_Status_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QTextStream_Status_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QTextStream::Status> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QTextStream_Status_Enum> decl_QTextStream_Status_Enum (decl_QTextStream_Status_Enums, "QTextStream_Status",
  qt_gsi::mkdefs_QTextStream_Status () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QTextStream_Status_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QTextStream_Status_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQTextStream_Status_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QTextStream_Status_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QTextStream_Status_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QTextStream::Status enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QTextStream> inject_QTextStream_Status_Enum_in_parent (qt_gsi::mkdefs_QTextStream_Status ());
static gsi::ClassExt<QTextStream> decl_QTextStream_Status_Enum_as_child (decl_QTextStream_Status_Enum, "Status");

}

