
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQStringListModel.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQStringListModel_EventAdaptor.h"
#include "gsiDeclQStringListModel_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QStringListModel

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QStringListModel::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QVariant QStringListModel::data(const QModelIndex &index, int role)


static void _init_f_data_c3054 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_f_data_c3054 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  ret.write<QVariant > ((QVariant)((QStringListModel *)cls)->data (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_data_c3054 ()
{
  return new qt_gsi::GenericMethod ("data", "@brief Method QVariant QStringListModel::data(const QModelIndex &index, int role)\nThis is a reimplementation of QAbstractItemModel::data", true, &_init_f_data_c3054, &_call_f_data_c3054);
}

// QFlags<Qt::ItemFlag> QStringListModel::flags(const QModelIndex &index)


static void _init_f_flags_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ();
}

static void _call_f_flags_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ((qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::ItemFlag> >(((QStringListModel *)cls)->flags (arg1)));
}

static qt_gsi::GenericMethod *_create_f_flags_c2395 ()
{
  return new qt_gsi::GenericMethod ("flags", "@brief Method QFlags<Qt::ItemFlag> QStringListModel::flags(const QModelIndex &index)\nThis is a reimplementation of QAbstractItemModel::flags", true, &_init_f_flags_c2395, &_call_f_flags_c2395);
}

// bool QStringListModel::insertRows(int row, int count, const QModelIndex &parent)


static void _init_f_insertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_insertRows_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QStringListModel *)cls)->insertRows (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_insertRows_3713 ()
{
  return new qt_gsi::GenericMethod ("insertRows", "@brief Method bool QStringListModel::insertRows(int row, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::insertRows", false, &_init_f_insertRows_3713, &_call_f_insertRows_3713);
}

// bool QStringListModel::removeRows(int row, int count, const QModelIndex &parent)


static void _init_f_removeRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_removeRows_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<bool > ((bool)((QStringListModel *)cls)->removeRows (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_removeRows_3713 ()
{
  return new qt_gsi::GenericMethod ("removeRows", "@brief Method bool QStringListModel::removeRows(int row, int count, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::removeRows", false, &_init_f_removeRows_3713, &_call_f_removeRows_3713);
}

// int QStringListModel::rowCount(const QModelIndex &parent)


static void _init_f_rowCount_c2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_rowCount_c2395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<int > ((int)((QStringListModel *)cls)->rowCount (arg1));
}

static qt_gsi::GenericMethod *_create_f_rowCount_c2395 ()
{
  return new qt_gsi::GenericMethod ("rowCount", "@brief Method int QStringListModel::rowCount(const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::rowCount", true, &_init_f_rowCount_c2395, &_call_f_rowCount_c2395);
}

// bool QStringListModel::setData(const QModelIndex &index, const QVariant &value, int role)


static void _init_f_setData_5065 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role", true, "Qt::EditRole");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_setData_5065 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  int arg3 = args ? args.read<int > () : (int)(Qt::EditRole);
  ret.write<bool > ((bool)((QStringListModel *)cls)->setData (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_setData_5065 ()
{
  return new qt_gsi::GenericMethod ("setData", "@brief Method bool QStringListModel::setData(const QModelIndex &index, const QVariant &value, int role)\nThis is a reimplementation of QAbstractItemModel::setData", false, &_init_f_setData_5065, &_call_f_setData_5065);
}

// void QStringListModel::setStringList(const QStringList &strings)


static void _init_f_setStringList_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("strings");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStringList_2437 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  ((QStringListModel *)cls)->setStringList (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setStringList_2437 ()
{
  return new qt_gsi::GenericMethod ("setStringList|stringList=", "@brief Method void QStringListModel::setStringList(const QStringList &strings)\n", false, &_init_f_setStringList_2437, &_call_f_setStringList_2437);
}

// void QStringListModel::sort(int column, Qt::SortOrder order)


static void _init_f_sort_2340 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order", true, "Qt::AscendingOrder");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_sort_2340 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > () : (const qt_gsi::Converter<Qt::SortOrder>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::SortOrder>(heap, Qt::AscendingOrder));
  ((QStringListModel *)cls)->sort (arg1, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_sort_2340 ()
{
  return new qt_gsi::GenericMethod ("sort", "@brief Method void QStringListModel::sort(int column, Qt::SortOrder order)\nThis is a reimplementation of QAbstractItemModel::sort", false, &_init_f_sort_2340, &_call_f_sort_2340);
}

// QStringList QStringListModel::stringList()


static void _init_f_stringList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_stringList_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QStringListModel *)cls)->stringList ()));
}

static qt_gsi::GenericMethod *_create_f_stringList_c0 ()
{
  return new qt_gsi::GenericMethod (":stringList", "@brief Method QStringList QStringListModel::stringList()\n", true, &_init_f_stringList_c0, &_call_f_stringList_c0);
}

// QFlags<Qt::DropAction> QStringListModel::supportedDropActions()


static void _init_f_supportedDropActions_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ();
}

static void _call_f_supportedDropActions_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ((qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::DropAction> >(((QStringListModel *)cls)->supportedDropActions ()));
}

static qt_gsi::GenericMethod *_create_f_supportedDropActions_c0 ()
{
  return new qt_gsi::GenericMethod ("supportedDropActions", "@brief Method QFlags<Qt::DropAction> QStringListModel::supportedDropActions()\nThis is a reimplementation of QAbstractItemModel::supportedDropActions", true, &_init_f_supportedDropActions_c0, &_call_f_supportedDropActions_c0);
}

// static QString QStringListModel::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QStringListModel::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QStringListModel::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QStringListModel::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QStringListModel::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QStringListModel::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QStringListModel::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QStringListModel::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QStringListModel::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QStringListModel::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QStringListModel::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QStringListModel::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QStringListModel, QStringListModel_EventAdaptor> ea_QStringListModel;

namespace gsi
{
extern gsi::Class<QAbstractListModel> decl_QAbstractListModel;

gsi::Class<QStringListModel> decl_QStringListModel (ea_QStringListModel, decl_QAbstractListModel, "QStringListModel_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_data_c3054 ()) +
  gsi::Methods(_create_f_flags_c2395 ()) +
  gsi::Methods(_create_f_insertRows_3713 ()) +
  gsi::Methods(_create_f_removeRows_3713 ()) +
  gsi::Methods(_create_f_rowCount_c2395 ()) +
  gsi::Methods(_create_f_setData_5065 ()) +
  gsi::Methods(_create_f_setStringList_2437 ()) +
  gsi::Methods(_create_f_sort_2340 ()) +
  gsi::Methods(_create_f_stringList_c0 ()) +
  gsi::Methods(_create_f_supportedDropActions_c0 ()) +
  qt_gsi::qt_signal<QStringListModel, QStringListModel_EventAdaptor, const QModelIndex &, const QModelIndex &> ("dataChanged", &QStringListModel_EventAdaptor::dataChanged_e_4682, gsi::arg("topLeft"), gsi::arg("bottomRight"), "@brief Signal declaration for QStringListModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QStringListModel, QStringListModel_EventAdaptor, QObject *> ("destroyed", &QStringListModel_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QStringListModel::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QStringListModel, QStringListModel_EventAdaptor, const qt_gsi::Converter<Qt::Orientation>::target_type &, int, int> ("headerDataChanged", &QStringListModel_EventAdaptor::headerDataChanged_e_3231, gsi::arg("orientation"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QStringListModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QStringListModel, QStringListModel_EventAdaptor> ("layoutAboutToBeChanged", &QStringListModel_EventAdaptor::layoutAboutToBeChanged_e_0, "@brief Signal declaration for QStringListModel::layoutAboutToBeChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QStringListModel, QStringListModel_EventAdaptor> ("layoutChanged", &QStringListModel_EventAdaptor::layoutChanged_e_0, "@brief Signal declaration for QStringListModel::layoutChanged()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QStringListModel");
}


class QStringListModel_Adaptor : public QStringListModel, public qt_gsi::QtObjectBase
{
public:

  virtual ~QStringListModel_Adaptor();

  //  [adaptor ctor] QStringListModel::QStringListModel(QObject *parent)
  QStringListModel_Adaptor() : QStringListModel()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QStringListModel::QStringListModel(QObject *parent)
  QStringListModel_Adaptor(QObject *parent) : QStringListModel(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QStringListModel::QStringListModel(const QStringList &strings, QObject *parent)
  QStringListModel_Adaptor(const QStringList &strings) : QStringListModel(strings)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QStringListModel::QStringListModel(const QStringList &strings, QObject *parent)
  QStringListModel_Adaptor(const QStringList &strings, QObject *parent) : QStringListModel(strings, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QStringListModel::beginInsertColumns(const QModelIndex &parent, int first, int last)
  void fp_QStringListModel_beginInsertColumns_3713 (const QModelIndex &parent, int first, int last) {
    QStringListModel::beginInsertColumns(parent, first, last);
  }

  //  void QStringListModel::beginInsertRows(const QModelIndex &parent, int first, int last)
  void fp_QStringListModel_beginInsertRows_3713 (const QModelIndex &parent, int first, int last) {
    QStringListModel::beginInsertRows(parent, first, last);
  }

  //  bool QStringListModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)
  bool fp_QStringListModel_beginMoveColumns_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn) {
    return QStringListModel::beginMoveColumns(sourceParent, sourceFirst, sourceLast, destinationParent, destinationColumn);
  }

  //  bool QStringListModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)
  bool fp_QStringListModel_beginMoveRows_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow) {
    return QStringListModel::beginMoveRows(sourceParent, sourceFirst, sourceLast, destinationParent, destinationRow);
  }

  //  void QStringListModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)
  void fp_QStringListModel_beginRemoveColumns_3713 (const QModelIndex &parent, int first, int last) {
    QStringListModel::beginRemoveColumns(parent, first, last);
  }

  //  void QStringListModel::beginRemoveRows(const QModelIndex &parent, int first, int last)
  void fp_QStringListModel_beginRemoveRows_3713 (const QModelIndex &parent, int first, int last) {
    QStringListModel::beginRemoveRows(parent, first, last);
  }

  //  void QStringListModel::beginResetModel()
  void fp_QStringListModel_beginResetModel_0 () {
    QStringListModel::beginResetModel();
  }

  //  void QStringListModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)
  void fp_QStringListModel_changePersistentIndex_4682 (const QModelIndex &from, const QModelIndex &to) {
    QStringListModel::changePersistentIndex(from, to);
  }

  //  void QStringListModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)
  void fp_QStringListModel_changePersistentIndexList_5912 (const qt_gsi::Converter<QList<QModelIndex> >::target_type & from, const qt_gsi::Converter<QList<QModelIndex> >::target_type & to) {
    QStringListModel::changePersistentIndexList(qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(from).cref(), qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(to).cref());
  }

  //  QModelIndex QStringListModel::createIndex(int row, int column, void *data)
  QModelIndex fp_QStringListModel_createIndex_c2374 (int row, int column, void *data) const {
    return QStringListModel::createIndex(row, column, data);
  }

  //  QModelIndex QStringListModel::createIndex(int row, int column, int id)
  QModelIndex fp_QStringListModel_createIndex_c2085 (int row, int column, int id) const {
    return QStringListModel::createIndex(row, column, id);
  }

  //  QModelIndex QStringListModel::createIndex(int row, int column, quint32 id)
  QModelIndex fp_QStringListModel_createIndex_c2416 (int row, int column, quint32 id) const {
    return QStringListModel::createIndex(row, column, id);
  }

  //  bool QStringListModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)
  bool fp_QStringListModel_decodeData_5302 (int row, int column, const QModelIndex &parent, QDataStream &stream) {
    return QStringListModel::decodeData(row, column, parent, stream);
  }

  //  void QStringListModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)
  void fp_QStringListModel_encodeData_c4599 (const qt_gsi::Converter<QList<QModelIndex> >::target_type & indexes, QDataStream &stream) const {
    QStringListModel::encodeData(qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(indexes).cref(), stream);
  }

  //  void QStringListModel::endInsertColumns()
  void fp_QStringListModel_endInsertColumns_0 () {
    QStringListModel::endInsertColumns();
  }

  //  void QStringListModel::endInsertRows()
  void fp_QStringListModel_endInsertRows_0 () {
    QStringListModel::endInsertRows();
  }

  //  void QStringListModel::endMoveColumns()
  void fp_QStringListModel_endMoveColumns_0 () {
    QStringListModel::endMoveColumns();
  }

  //  void QStringListModel::endMoveRows()
  void fp_QStringListModel_endMoveRows_0 () {
    QStringListModel::endMoveRows();
  }

  //  void QStringListModel::endRemoveColumns()
  void fp_QStringListModel_endRemoveColumns_0 () {
    QStringListModel::endRemoveColumns();
  }

  //  void QStringListModel::endRemoveRows()
  void fp_QStringListModel_endRemoveRows_0 () {
    QStringListModel::endRemoveRows();
  }

  //  void QStringListModel::endResetModel()
  void fp_QStringListModel_endResetModel_0 () {
    QStringListModel::endResetModel();
  }

  //  QList<QModelIndex> QStringListModel::persistentIndexList()
  qt_gsi::Converter<QList<QModelIndex> >::target_type fp_QStringListModel_persistentIndexList_c0 () const {
    return qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(QStringListModel::persistentIndexList());
  }

  //  int QStringListModel::receivers(const char *signal)
  int fp_QStringListModel_receivers_c1731 (const char *signal) const {
    return QStringListModel::receivers(signal);
  }

  //  void QStringListModel::reset()
  void fp_QStringListModel_reset_0 () {
    QStringListModel::reset();
  }

  //  QObject *QStringListModel::sender()
  QObject * fp_QStringListModel_sender_c0 () const {
    return QStringListModel::sender();
  }

  //  [adaptor impl] QModelIndex QStringListModel::buddy(const QModelIndex &index)
  QModelIndex cbs_buddy_c2395_0(const QModelIndex &index) const
  {
    return QStringListModel::buddy(index);
  }

  virtual QModelIndex buddy(const QModelIndex &index) const
  {
    if (cb_buddy_c2395_0.can_issue()) {
      return cb_buddy_c2395_0.issue<QStringListModel_Adaptor, QModelIndex, const QModelIndex &>(&QStringListModel_Adaptor::cbs_buddy_c2395_0, index);
    } else {
      return QStringListModel::buddy(index);
    }
  }

  //  [adaptor impl] bool QStringListModel::canFetchMore(const QModelIndex &parent)
  bool cbs_canFetchMore_c2395_0(const QModelIndex &parent) const
  {
    return QStringListModel::canFetchMore(parent);
  }

  virtual bool canFetchMore(const QModelIndex &parent) const
  {
    if (cb_canFetchMore_c2395_0.can_issue()) {
      return cb_canFetchMore_c2395_0.issue<QStringListModel_Adaptor, bool, const QModelIndex &>(&QStringListModel_Adaptor::cbs_canFetchMore_c2395_0, parent);
    } else {
      return QStringListModel::canFetchMore(parent);
    }
  }

  //  [adaptor impl] QVariant QStringListModel::data(const QModelIndex &index, int role)
  QVariant cbs_data_c3054_0(const QModelIndex &index, int role) const
  {
    return QStringListModel::data(index, role);
  }

  virtual QVariant data(const QModelIndex &index, int role) const
  {
    if (cb_data_c3054_0.can_issue()) {
      return cb_data_c3054_0.issue<QStringListModel_Adaptor, QVariant, const QModelIndex &, int>(&QStringListModel_Adaptor::cbs_data_c3054_0, index, role);
    } else {
      return QStringListModel::data(index, role);
    }
  }

  //  [adaptor impl] bool QStringListModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_dropMimeData_7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent)
  {
    return QStringListModel::dropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  {
    if (cb_dropMimeData_7425_0.can_issue()) {
      return cb_dropMimeData_7425_0.issue<QStringListModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QStringListModel_Adaptor::cbs_dropMimeData_7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QStringListModel::dropMimeData(data, action, row, column, parent);
    }
  }

  //  [adaptor impl] bool QStringListModel::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QStringListModel::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QStringListModel_Adaptor, bool, QEvent *>(&QStringListModel_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QStringListModel::event(arg1);
    }
  }

  //  [adaptor impl] bool QStringListModel::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QStringListModel::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QStringListModel_Adaptor, bool, QObject *, QEvent *>(&QStringListModel_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QStringListModel::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QStringListModel::fetchMore(const QModelIndex &parent)
  void cbs_fetchMore_2395_0(const QModelIndex &parent)
  {
    QStringListModel::fetchMore(parent);
  }

  virtual void fetchMore(const QModelIndex &parent)
  {
    if (cb_fetchMore_2395_0.can_issue()) {
      cb_fetchMore_2395_0.issue<QStringListModel_Adaptor, const QModelIndex &>(&QStringListModel_Adaptor::cbs_fetchMore_2395_0, parent);
    } else {
      QStringListModel::fetchMore(parent);
    }
  }

  //  [adaptor impl] QFlags<Qt::ItemFlag> QStringListModel::flags(const QModelIndex &index)
  qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type cbs_flags_c2395_0(const QModelIndex &index) const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<Qt::ItemFlag> >(QStringListModel::flags(index));
  }

  virtual QFlags<Qt::ItemFlag> flags(const QModelIndex &index) const
  {
    if (cb_flags_c2395_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<Qt::ItemFlag> >(cb_flags_c2395_0.issue<QStringListModel_Adaptor, qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type, const QModelIndex &>(&QStringListModel_Adaptor::cbs_flags_c2395_0, index)).cref();
    } else {
      return QStringListModel::flags(index);
    }
  }

  //  [adaptor impl] QVariant QStringListModel::headerData(int section, Qt::Orientation orientation, int role)
  QVariant cbs_headerData_c3231_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, int role) const
  {
    return QStringListModel::headerData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), role);
  }

  virtual QVariant headerData(int section, Qt::Orientation orientation, int role) const
  {
    if (cb_headerData_c3231_1.can_issue()) {
      return cb_headerData_c3231_1.issue<QStringListModel_Adaptor, QVariant, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, int>(&QStringListModel_Adaptor::cbs_headerData_c3231_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), role);
    } else {
      return QStringListModel::headerData(section, orientation, role);
    }
  }

  //  [adaptor impl] QModelIndex QStringListModel::index(int row, int column, const QModelIndex &parent)
  QModelIndex cbs_index_c3713_2(int row, int column, const QModelIndex &parent) const
  {
    return QStringListModel::index(row, column, parent);
  }

  virtual QModelIndex index(int row, int column, const QModelIndex &parent) const
  {
    if (cb_index_c3713_2.can_issue()) {
      return cb_index_c3713_2.issue<QStringListModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QStringListModel_Adaptor::cbs_index_c3713_2, row, column, parent);
    } else {
      return QStringListModel::index(row, column, parent);
    }
  }

  //  [adaptor impl] bool QStringListModel::insertColumns(int column, int count, const QModelIndex &parent)
  bool cbs_insertColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QStringListModel::insertColumns(column, count, parent);
  }

  virtual bool insertColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_insertColumns_3713_1.can_issue()) {
      return cb_insertColumns_3713_1.issue<QStringListModel_Adaptor, bool, int, int, const QModelIndex &>(&QStringListModel_Adaptor::cbs_insertColumns_3713_1, column, count, parent);
    } else {
      return QStringListModel::insertColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QStringListModel::insertRows(int row, int count, const QModelIndex &parent)
  bool cbs_insertRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QStringListModel::insertRows(row, count, parent);
  }

  virtual bool insertRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_insertRows_3713_1.can_issue()) {
      return cb_insertRows_3713_1.issue<QStringListModel_Adaptor, bool, int, int, const QModelIndex &>(&QStringListModel_Adaptor::cbs_insertRows_3713_1, row, count, parent);
    } else {
      return QStringListModel::insertRows(row, count, parent);
    }
  }

  //  [adaptor impl] QList<QModelIndex> QStringListModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)
  qt_gsi::Converter<QList<QModelIndex> >::target_type cbs_match_c7932_2(const QModelIndex &start, int role, const QVariant &value, int hits, const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & flags) const
  {
    return qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(QStringListModel::match(start, role, value, hits, qt_gsi::QtToCppAdaptor<QFlags<Qt::MatchFlag> >(flags).cref()));
  }

  virtual QList<QModelIndex> match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    if (cb_match_c7932_2.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(cb_match_c7932_2.issue<QStringListModel_Adaptor, qt_gsi::Converter<QList<QModelIndex> >::target_type, const QModelIndex &, int, const QVariant &, int, const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type &>(&QStringListModel_Adaptor::cbs_match_c7932_2, start, role, value, hits, qt_gsi::CppToQtAdaptor<QFlags<Qt::MatchFlag> >(flags))).cref();
    } else {
      return QStringListModel::match(start, role, value, hits, flags);
    }
  }

  //  [adaptor impl] QMimeData *QStringListModel::mimeData(const QList<QModelIndex> &indexes)
  QMimeData * cbs_mimeData_c3010_0(const qt_gsi::Converter<QList<QModelIndex> >::target_type & indexes) const
  {
    return QStringListModel::mimeData(qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(indexes).cref());
  }

  virtual QMimeData * mimeData(const QList<QModelIndex> &indexes) const
  {
    if (cb_mimeData_c3010_0.can_issue()) {
      return cb_mimeData_c3010_0.issue<QStringListModel_Adaptor, QMimeData *, const qt_gsi::Converter<QList<QModelIndex> >::target_type &>(&QStringListModel_Adaptor::cbs_mimeData_c3010_0, qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(indexes));
    } else {
      return QStringListModel::mimeData(indexes);
    }
  }

  //  [adaptor impl] QStringList QStringListModel::mimeTypes()
  qt_gsi::Converter<QStringList>::target_type cbs_mimeTypes_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QStringList>(QStringListModel::mimeTypes());
  }

  virtual QStringList mimeTypes() const
  {
    if (cb_mimeTypes_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QStringList>(cb_mimeTypes_c0_0.issue<QStringListModel_Adaptor, qt_gsi::Converter<QStringList>::target_type>(&QStringListModel_Adaptor::cbs_mimeTypes_c0_0)).cref();
    } else {
      return QStringListModel::mimeTypes();
    }
  }

  //  [adaptor impl] bool QStringListModel::removeColumns(int column, int count, const QModelIndex &parent)
  bool cbs_removeColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QStringListModel::removeColumns(column, count, parent);
  }

  virtual bool removeColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_removeColumns_3713_1.can_issue()) {
      return cb_removeColumns_3713_1.issue<QStringListModel_Adaptor, bool, int, int, const QModelIndex &>(&QStringListModel_Adaptor::cbs_removeColumns_3713_1, column, count, parent);
    } else {
      return QStringListModel::removeColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QStringListModel::removeRows(int row, int count, const QModelIndex &parent)
  bool cbs_removeRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QStringListModel::removeRows(row, count, parent);
  }

  virtual bool removeRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_removeRows_3713_1.can_issue()) {
      return cb_removeRows_3713_1.issue<QStringListModel_Adaptor, bool, int, int, const QModelIndex &>(&QStringListModel_Adaptor::cbs_removeRows_3713_1, row, count, parent);
    } else {
      return QStringListModel::removeRows(row, count, parent);
    }
  }

  //  [adaptor impl] void QStringListModel::revert()
  void cbs_revert_0_0()
  {
    QStringListModel::revert();
  }

  virtual void revert()
  {
    if (cb_revert_0_0.can_issue()) {
      cb_revert_0_0.issue<QStringListModel_Adaptor>(&QStringListModel_Adaptor::cbs_revert_0_0);
    } else {
      QStringListModel::revert();
    }
  }

  //  [adaptor impl] int QStringListModel::rowCount(const QModelIndex &parent)
  int cbs_rowCount_c2395_1(const QModelIndex &parent) const
  {
    return QStringListModel::rowCount(parent);
  }

  virtual int rowCount(const QModelIndex &parent) const
  {
    if (cb_rowCount_c2395_1.can_issue()) {
      return cb_rowCount_c2395_1.issue<QStringListModel_Adaptor, int, const QModelIndex &>(&QStringListModel_Adaptor::cbs_rowCount_c2395_1, parent);
    } else {
      return QStringListModel::rowCount(parent);
    }
  }

  //  [adaptor impl] bool QStringListModel::setData(const QModelIndex &index, const QVariant &value, int role)
  bool cbs_setData_5065_1(const QModelIndex &index, const QVariant &value, int role)
  {
    return QStringListModel::setData(index, value, role);
  }

  virtual bool setData(const QModelIndex &index, const QVariant &value, int role)
  {
    if (cb_setData_5065_1.can_issue()) {
      return cb_setData_5065_1.issue<QStringListModel_Adaptor, bool, const QModelIndex &, const QVariant &, int>(&QStringListModel_Adaptor::cbs_setData_5065_1, index, value, role);
    } else {
      return QStringListModel::setData(index, value, role);
    }
  }

  //  [adaptor impl] bool QStringListModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  bool cbs_setHeaderData_5242_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, const QVariant &value, int role)
  {
    return QStringListModel::setHeaderData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), value, role);
  }

  virtual bool setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  {
    if (cb_setHeaderData_5242_1.can_issue()) {
      return cb_setHeaderData_5242_1.issue<QStringListModel_Adaptor, bool, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, const QVariant &, int>(&QStringListModel_Adaptor::cbs_setHeaderData_5242_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), value, role);
    } else {
      return QStringListModel::setHeaderData(section, orientation, value, role);
    }
  }

  //  [adaptor impl] void QStringListModel::sort(int column, Qt::SortOrder order)
  void cbs_sort_2340_1(int column, const qt_gsi::Converter<Qt::SortOrder>::target_type & order)
  {
    QStringListModel::sort(column, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(order).cref());
  }

  virtual void sort(int column, Qt::SortOrder order)
  {
    if (cb_sort_2340_1.can_issue()) {
      cb_sort_2340_1.issue<QStringListModel_Adaptor, int, const qt_gsi::Converter<Qt::SortOrder>::target_type &>(&QStringListModel_Adaptor::cbs_sort_2340_1, column, qt_gsi::CppToQtAdaptor<Qt::SortOrder>(order));
    } else {
      QStringListModel::sort(column, order);
    }
  }

  //  [adaptor impl] QSize QStringListModel::span(const QModelIndex &index)
  QSize cbs_span_c2395_0(const QModelIndex &index) const
  {
    return QStringListModel::span(index);
  }

  virtual QSize span(const QModelIndex &index) const
  {
    if (cb_span_c2395_0.can_issue()) {
      return cb_span_c2395_0.issue<QStringListModel_Adaptor, QSize, const QModelIndex &>(&QStringListModel_Adaptor::cbs_span_c2395_0, index);
    } else {
      return QStringListModel::span(index);
    }
  }

  //  [adaptor impl] bool QStringListModel::submit()
  bool cbs_submit_0_0()
  {
    return QStringListModel::submit();
  }

  virtual bool submit()
  {
    if (cb_submit_0_0.can_issue()) {
      return cb_submit_0_0.issue<QStringListModel_Adaptor, bool>(&QStringListModel_Adaptor::cbs_submit_0_0);
    } else {
      return QStringListModel::submit();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QStringListModel::supportedDropActions()
  qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type cbs_supportedDropActions_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<Qt::DropAction> >(QStringListModel::supportedDropActions());
  }

  virtual QFlags<Qt::DropAction> supportedDropActions() const
  {
    if (cb_supportedDropActions_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<Qt::DropAction> >(cb_supportedDropActions_c0_0.issue<QStringListModel_Adaptor, qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type>(&QStringListModel_Adaptor::cbs_supportedDropActions_c0_0)).cref();
    } else {
      return QStringListModel::supportedDropActions();
    }
  }

  //  [adaptor impl] void QStringListModel::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QStringListModel::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QStringListModel_Adaptor, QChildEvent *>(&QStringListModel_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QStringListModel::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QStringListModel::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QStringListModel::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QStringListModel_Adaptor, QEvent *>(&QStringListModel_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QStringListModel::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QStringListModel::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QStringListModel::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QStringListModel_Adaptor, const char *>(&QStringListModel_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QStringListModel::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QStringListModel::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QStringListModel::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QStringListModel_Adaptor, QTimerEvent *>(&QStringListModel_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QStringListModel::timerEvent(arg1);
    }
  }

  gsi::Callback cb_buddy_c2395_0;
  gsi::Callback cb_canFetchMore_c2395_0;
  gsi::Callback cb_data_c3054_0;
  gsi::Callback cb_dropMimeData_7425_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_fetchMore_2395_0;
  gsi::Callback cb_flags_c2395_0;
  gsi::Callback cb_headerData_c3231_1;
  gsi::Callback cb_index_c3713_2;
  gsi::Callback cb_insertColumns_3713_1;
  gsi::Callback cb_insertRows_3713_1;
  gsi::Callback cb_match_c7932_2;
  gsi::Callback cb_mimeData_c3010_0;
  gsi::Callback cb_mimeTypes_c0_0;
  gsi::Callback cb_removeColumns_3713_1;
  gsi::Callback cb_removeRows_3713_1;
  gsi::Callback cb_revert_0_0;
  gsi::Callback cb_rowCount_c2395_1;
  gsi::Callback cb_setData_5065_1;
  gsi::Callback cb_setHeaderData_5242_1;
  gsi::Callback cb_sort_2340_1;
  gsi::Callback cb_span_c2395_0;
  gsi::Callback cb_submit_0_0;
  gsi::Callback cb_supportedDropActions_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QStringListModel_Adaptor::~QStringListModel_Adaptor() { }

//  Constructor QStringListModel::QStringListModel(QObject *parent) (adaptor class)

static void _init_ctor_QStringListModel_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QStringListModel_Adaptor *> ();
}

static void _call_ctor_QStringListModel_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QStringListModel_Adaptor *> (new QStringListModel_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QStringListModel_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStringListModel::QStringListModel(QObject *parent)\nThis method creates an object of class QStringListModel.", &_init_ctor_QStringListModel_Adaptor_1302, &_call_ctor_QStringListModel_Adaptor_1302);
}

//  Constructor QStringListModel::QStringListModel(const QStringList &strings, QObject *parent) (adaptor class)

static void _init_ctor_QStringListModel_Adaptor_3631 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("strings");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QStringListModel_Adaptor *> ();
}

static void _call_ctor_QStringListModel_Adaptor_3631 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  QObject *arg2 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QStringListModel_Adaptor *> (new QStringListModel_Adaptor (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref(), arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QStringListModel_Adaptor_3631 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QStringListModel::QStringListModel(const QStringList &strings, QObject *parent)\nThis method creates an object of class QStringListModel.", &_init_ctor_QStringListModel_Adaptor_3631, &_call_ctor_QStringListModel_Adaptor_3631);
}

// void QStringListModel::beginInsertColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertColumns_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QStringListModel_Adaptor *)cls)->fp_QStringListModel_beginInsertColumns_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginInsertColumns_3713 ()
{
  return new qt_gsi::GenericMethod("*beginInsertColumns", "@brief Method void QStringListModel::beginInsertColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertColumns_3713, &_call_fp_beginInsertColumns_3713);
}


// void QStringListModel::beginInsertRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertRows_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QStringListModel_Adaptor *)cls)->fp_QStringListModel_beginInsertRows_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginInsertRows_3713 ()
{
  return new qt_gsi::GenericMethod("*beginInsertRows", "@brief Method void QStringListModel::beginInsertRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertRows_3713, &_call_fp_beginInsertRows_3713);
}


// bool QStringListModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)

static void _init_fp_beginMoveColumns_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationColumn");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveColumns_6659 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  const QModelIndex &arg4 = args.read<const QModelIndex & > ();
  int arg5 = args.read<int > ();
  ret.write<bool > ((bool)((QStringListModel_Adaptor *)cls)->fp_QStringListModel_beginMoveColumns_6659 (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericMethod*_create_fp_beginMoveColumns_6659 ()
{
  return new qt_gsi::GenericMethod("*beginMoveColumns", "@brief Method bool QStringListModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveColumns_6659, &_call_fp_beginMoveColumns_6659);
}


// bool QStringListModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)

static void _init_fp_beginMoveRows_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationRow");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveRows_6659 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  const QModelIndex &arg4 = args.read<const QModelIndex & > ();
  int arg5 = args.read<int > ();
  ret.write<bool > ((bool)((QStringListModel_Adaptor *)cls)->fp_QStringListModel_beginMoveRows_6659 (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericMethod*_create_fp_beginMoveRows_6659 ()
{
  return new qt_gsi::GenericMethod("*beginMoveRows", "@brief Method bool QStringListModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveRows_6659, &_call_fp_beginMoveRows_6659);
}


// void QStringListModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveColumns_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QStringListModel_Adaptor *)cls)->fp_QStringListModel_beginRemoveColumns_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginRemoveColumns_3713 ()
{
  return new qt_gsi::GenericMethod("*beginRemoveColumns", "@brief Method void QStringListModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveColumns_3713, &_call_fp_beginRemoveColumns_3713);
}


// void QStringListModel::beginRemoveRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveRows_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QStringListModel_Adaptor *)cls)->fp_QStringListModel_beginRemoveRows_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginRemoveRows_3713 ()
{
  return new qt_gsi::GenericMethod("*beginRemoveRows", "@brief Method void QStringListModel::beginRemoveRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveRows_3713, &_call_fp_beginRemoveRows_3713);
}


// void QStringListModel::beginResetModel()

static void _init_fp_beginResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_beginResetModel_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStringListModel_Adaptor *)cls)->fp_QStringListModel_beginResetModel_0 ();
}

static qt_gsi::GenericMethod*_create_fp_beginResetModel_0 ()
{
  return new qt_gsi::GenericMethod("*beginResetModel", "@brief Method void QStringListModel::beginResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginResetModel_0, &_call_fp_beginResetModel_0);
}


// void QStringListModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)

static void _init_fp_changePersistentIndex_4682 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndex_4682 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QStringListModel_Adaptor *)cls)->fp_QStringListModel_changePersistentIndex_4682 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_changePersistentIndex_4682 ()
{
  return new qt_gsi::GenericMethod("*changePersistentIndex", "@brief Method void QStringListModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndex_4682, &_call_fp_changePersistentIndex_4682);
}


// void QStringListModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)

static void _init_fp_changePersistentIndexList_5912 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndexList_5912 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg2 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  ((QStringListModel_Adaptor *)cls)->fp_QStringListModel_changePersistentIndexList_5912 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_changePersistentIndexList_5912 ()
{
  return new qt_gsi::GenericMethod("*changePersistentIndexList", "@brief Method void QStringListModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndexList_5912, &_call_fp_changePersistentIndexList_5912);
}


// QModelIndex QStringListModel::createIndex(int row, int column, void *data)

static void _init_fp_createIndex_c2374 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("data", true, "0");
  decl->add_arg<void * > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2374 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  void *arg3 = args ? args.read<void * > () : (void *)(0);
  ret.write<QModelIndex > ((QModelIndex)((QStringListModel_Adaptor *)cls)->fp_QStringListModel_createIndex_c2374 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_createIndex_c2374 ()
{
  return new qt_gsi::GenericMethod("*createIndex", "@brief Method QModelIndex QStringListModel::createIndex(int row, int column, void *data)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2374, &_call_fp_createIndex_c2374);
}


// QModelIndex QStringListModel::createIndex(int row, int column, int id)

static void _init_fp_createIndex_c2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("id");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2085 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ret.write<QModelIndex > ((QModelIndex)((QStringListModel_Adaptor *)cls)->fp_QStringListModel_createIndex_c2085 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_createIndex_c2085 ()
{
  return new qt_gsi::GenericMethod("*createIndex", "@brief Method QModelIndex QStringListModel::createIndex(int row, int column, int id)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2085, &_call_fp_createIndex_c2085);
}


// QModelIndex QStringListModel::createIndex(int row, int column, quint32 id)

static void _init_fp_createIndex_c2416 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("id");
  decl->add_arg<quint32 > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2416 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  quint32 arg3 = args.read<quint32 > ();
  ret.write<QModelIndex > ((QModelIndex)((QStringListModel_Adaptor *)cls)->fp_QStringListModel_createIndex_c2416 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_createIndex_c2416 ()
{
  return new qt_gsi::GenericMethod("*createIndex", "@brief Method QModelIndex QStringListModel::createIndex(int row, int column, quint32 id)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2416, &_call_fp_createIndex_c2416);
}


// bool QStringListModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)

static void _init_fp_decodeData_5302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("stream");
  decl->add_arg<QDataStream & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_fp_decodeData_5302 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  QDataStream &arg4 = args.read<QDataStream & > ();
  ret.write<bool > ((bool)((QStringListModel_Adaptor *)cls)->fp_QStringListModel_decodeData_5302 (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod*_create_fp_decodeData_5302 ()
{
  return new qt_gsi::GenericMethod("*decodeData", "@brief Method bool QStringListModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_decodeData_5302, &_call_fp_decodeData_5302);
}


// void QStringListModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)

static void _init_fp_encodeData_c4599 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stream");
  decl->add_arg<QDataStream & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_encodeData_c4599 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  QDataStream &arg2 = args.read<QDataStream & > ();
  ((QStringListModel_Adaptor *)cls)->fp_QStringListModel_encodeData_c4599 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_encodeData_c4599 ()
{
  return new qt_gsi::GenericMethod("*encodeData", "@brief Method void QStringListModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_encodeData_c4599, &_call_fp_encodeData_c4599);
}


// void QStringListModel::endInsertColumns()

static void _init_fp_endInsertColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertColumns_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStringListModel_Adaptor *)cls)->fp_QStringListModel_endInsertColumns_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endInsertColumns_0 ()
{
  return new qt_gsi::GenericMethod("*endInsertColumns", "@brief Method void QStringListModel::endInsertColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertColumns_0, &_call_fp_endInsertColumns_0);
}


// void QStringListModel::endInsertRows()

static void _init_fp_endInsertRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertRows_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStringListModel_Adaptor *)cls)->fp_QStringListModel_endInsertRows_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endInsertRows_0 ()
{
  return new qt_gsi::GenericMethod("*endInsertRows", "@brief Method void QStringListModel::endInsertRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertRows_0, &_call_fp_endInsertRows_0);
}


// void QStringListModel::endMoveColumns()

static void _init_fp_endMoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveColumns_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStringListModel_Adaptor *)cls)->fp_QStringListModel_endMoveColumns_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endMoveColumns_0 ()
{
  return new qt_gsi::GenericMethod("*endMoveColumns", "@brief Method void QStringListModel::endMoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveColumns_0, &_call_fp_endMoveColumns_0);
}


// void QStringListModel::endMoveRows()

static void _init_fp_endMoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveRows_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStringListModel_Adaptor *)cls)->fp_QStringListModel_endMoveRows_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endMoveRows_0 ()
{
  return new qt_gsi::GenericMethod("*endMoveRows", "@brief Method void QStringListModel::endMoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveRows_0, &_call_fp_endMoveRows_0);
}


// void QStringListModel::endRemoveColumns()

static void _init_fp_endRemoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveColumns_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStringListModel_Adaptor *)cls)->fp_QStringListModel_endRemoveColumns_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endRemoveColumns_0 ()
{
  return new qt_gsi::GenericMethod("*endRemoveColumns", "@brief Method void QStringListModel::endRemoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveColumns_0, &_call_fp_endRemoveColumns_0);
}


// void QStringListModel::endRemoveRows()

static void _init_fp_endRemoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveRows_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStringListModel_Adaptor *)cls)->fp_QStringListModel_endRemoveRows_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endRemoveRows_0 ()
{
  return new qt_gsi::GenericMethod("*endRemoveRows", "@brief Method void QStringListModel::endRemoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveRows_0, &_call_fp_endRemoveRows_0);
}


// void QStringListModel::endResetModel()

static void _init_fp_endResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endResetModel_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStringListModel_Adaptor *)cls)->fp_QStringListModel_endResetModel_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endResetModel_0 ()
{
  return new qt_gsi::GenericMethod("*endResetModel", "@brief Method void QStringListModel::endResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endResetModel_0, &_call_fp_endResetModel_0);
}


// QList<QModelIndex> QStringListModel::persistentIndexList()

static void _init_fp_persistentIndexList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QModelIndex> >::target_type > ();
}

static void _call_fp_persistentIndexList_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QModelIndex> >::target_type > ((qt_gsi::Converter<QList<QModelIndex> >::target_type)((QStringListModel_Adaptor *)cls)->fp_QStringListModel_persistentIndexList_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_persistentIndexList_c0 ()
{
  return new qt_gsi::GenericMethod("*persistentIndexList", "@brief Method QList<QModelIndex> QStringListModel::persistentIndexList()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_persistentIndexList_c0, &_call_fp_persistentIndexList_c0);
}


// int QStringListModel::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QStringListModel_Adaptor *)cls)->fp_QStringListModel_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QStringListModel::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QStringListModel::reset()

static void _init_fp_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_reset_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStringListModel_Adaptor *)cls)->fp_QStringListModel_reset_0 ();
}

static qt_gsi::GenericMethod*_create_fp_reset_0 ()
{
  return new qt_gsi::GenericMethod("*reset", "@brief Method void QStringListModel::reset()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_reset_0, &_call_fp_reset_0);
}


// QObject *QStringListModel::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QStringListModel_Adaptor *)cls)->fp_QStringListModel_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QStringListModel::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// QModelIndex QStringListModel::buddy(const QModelIndex &index)

static void _init_cbs_buddy_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_buddy_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QModelIndex > ((QModelIndex)((QStringListModel_Adaptor *)cls)->cbs_buddy_c2395_0 (arg1));
}

static void _set_callback_cbs_buddy_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_buddy_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_buddy_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("buddy", "@hide", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_buddy_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("buddy", "@brief Virtual method QModelIndex QStringListModel::buddy(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0, &_set_callback_cbs_buddy_c2395_0);
}


// bool QStringListModel::canFetchMore(const QModelIndex &parent)

static void _init_cbs_canFetchMore_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_canFetchMore_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QStringListModel_Adaptor *)cls)->cbs_canFetchMore_c2395_0 (arg1));
}

static void _set_callback_cbs_canFetchMore_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_canFetchMore_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_canFetchMore_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("canFetchMore", "@hide", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_canFetchMore_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("canFetchMore", "@brief Virtual method bool QStringListModel::canFetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0, &_set_callback_cbs_canFetchMore_c2395_0);
}


// QVariant QStringListModel::data(const QModelIndex &index, int role)

static void _init_cbs_data_c3054_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_data_c3054_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  ret.write<QVariant > ((QVariant)((QStringListModel_Adaptor *)cls)->cbs_data_c3054_0 (arg1, arg2));
}

static void _set_callback_cbs_data_c3054_0 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_data_c3054_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_data_c3054_0 ()
{
  return new qt_gsi::GenericMethod ("data", "@hide", true, &_init_cbs_data_c3054_0, &_call_cbs_data_c3054_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_data_c3054_0 ()
{
  return new qt_gsi::GenericMethod ("data", "@brief Virtual method QVariant QStringListModel::data(const QModelIndex &index, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_data_c3054_0, &_call_cbs_data_c3054_0, &_set_callback_cbs_data_c3054_0);
}


// bool QStringListModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_dropMimeData_7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_dropMimeData_7425_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMimeData *arg1 = args.read<const QMimeData * > ();
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  const QModelIndex &arg5 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QStringListModel_Adaptor *)cls)->cbs_dropMimeData_7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_dropMimeData_7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_dropMimeData_7425_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropMimeData_7425_0 ()
{
  return new qt_gsi::GenericMethod ("dropMimeData", "@hide", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropMimeData_7425_0 ()
{
  return new qt_gsi::GenericMethod ("dropMimeData", "@brief Virtual method bool QStringListModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0, &_set_callback_cbs_dropMimeData_7425_0);
}


// bool QStringListModel::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QStringListModel_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QStringListModel::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QStringListModel::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QStringListModel_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QStringListModel::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QStringListModel::fetchMore(const QModelIndex &parent)

static void _init_cbs_fetchMore_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fetchMore_2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QStringListModel_Adaptor *)cls)->cbs_fetchMore_2395_0 (arg1);
}

static void _set_callback_cbs_fetchMore_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_fetchMore_2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fetchMore_2395_0 ()
{
  return new qt_gsi::GenericMethod ("fetchMore", "@hide", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fetchMore_2395_0 ()
{
  return new qt_gsi::GenericMethod ("fetchMore", "@brief Virtual method void QStringListModel::fetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0, &_set_callback_cbs_fetchMore_2395_0);
}


// QFlags<Qt::ItemFlag> QStringListModel::flags(const QModelIndex &index)

static void _init_cbs_flags_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ();
}

static void _call_cbs_flags_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ((qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type)((QStringListModel_Adaptor *)cls)->cbs_flags_c2395_0 (arg1));
}

static void _set_callback_cbs_flags_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_flags_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_flags_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("flags", "@hide", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_flags_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("flags", "@brief Virtual method QFlags<Qt::ItemFlag> QStringListModel::flags(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0, &_set_callback_cbs_flags_c2395_0);
}


// QVariant QStringListModel::headerData(int section, Qt::Orientation orientation, int role)

static void _init_cbs_headerData_c3231_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_cbs_headerData_c3231_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  int arg3 = args.read<int > ();
  ret.write<QVariant > ((QVariant)((QStringListModel_Adaptor *)cls)->cbs_headerData_c3231_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_headerData_c3231_1 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_headerData_c3231_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_headerData_c3231_1 ()
{
  return new qt_gsi::GenericMethod ("headerData", "@hide", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_headerData_c3231_1 ()
{
  return new qt_gsi::GenericMethod ("headerData", "@brief Virtual method QVariant QStringListModel::headerData(int section, Qt::Orientation orientation, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1, &_set_callback_cbs_headerData_c3231_1);
}


// QModelIndex QStringListModel::index(int row, int column, const QModelIndex &parent)

static void _init_cbs_index_c3713_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_index_c3713_2 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<QModelIndex > ((QModelIndex)((QStringListModel_Adaptor *)cls)->cbs_index_c3713_2 (arg1, arg2, arg3));
}

static void _set_callback_cbs_index_c3713_2 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_index_c3713_2 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_index_c3713_2 ()
{
  return new qt_gsi::GenericMethod ("index", "@hide", true, &_init_cbs_index_c3713_2, &_call_cbs_index_c3713_2);
}

static qt_gsi::GenericMethod *_create_callback_cbs_index_c3713_2 ()
{
  return new qt_gsi::GenericMethod ("index", "@brief Virtual method QModelIndex QStringListModel::index(int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_index_c3713_2, &_call_cbs_index_c3713_2, &_set_callback_cbs_index_c3713_2);
}


// bool QStringListModel::insertColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_insertColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertColumns_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QStringListModel_Adaptor *)cls)->cbs_insertColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_insertColumns_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_insertColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertColumns", "@hide", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_insertColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertColumns", "@brief Virtual method bool QStringListModel::insertColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1, &_set_callback_cbs_insertColumns_3713_1);
}


// bool QStringListModel::insertRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_insertRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertRows_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QStringListModel_Adaptor *)cls)->cbs_insertRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_insertRows_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_insertRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertRows", "@hide", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_insertRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertRows", "@brief Virtual method bool QStringListModel::insertRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1, &_set_callback_cbs_insertRows_3713_1);
}


// QList<QModelIndex> QStringListModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)

static void _init_cbs_match_c7932_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("hits");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > (argspec_4);
  decl->set_return<qt_gsi::Converter<QList<QModelIndex> >::target_type > ();
}

static void _call_cbs_match_c7932_2 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  const QVariant &arg3 = args.read<const QVariant & > ();
  int arg4 = args.read<int > ();
  const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & arg5 = args.read<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > ();
  ret.write<qt_gsi::Converter<QList<QModelIndex> >::target_type > ((qt_gsi::Converter<QList<QModelIndex> >::target_type)((QStringListModel_Adaptor *)cls)->cbs_match_c7932_2 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_match_c7932_2 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_match_c7932_2 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_match_c7932_2 ()
{
  return new qt_gsi::GenericMethod ("match", "@hide", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2);
}

static qt_gsi::GenericMethod *_create_callback_cbs_match_c7932_2 ()
{
  return new qt_gsi::GenericMethod ("match", "@brief Virtual method QList<QModelIndex> QStringListModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2, &_set_callback_cbs_match_c7932_2);
}


// QMimeData *QStringListModel::mimeData(const QList<QModelIndex> &indexes)

static void _init_cbs_mimeData_c3010_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_cbs_mimeData_c3010_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  ret.write<QMimeData * > ((QMimeData *)((QStringListModel_Adaptor *)cls)->cbs_mimeData_c3010_0 (arg1));
}

static void _set_callback_cbs_mimeData_c3010_0 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_mimeData_c3010_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mimeData_c3010_0 ()
{
  return new qt_gsi::GenericMethod ("mimeData", "@hide", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mimeData_c3010_0 ()
{
  return new qt_gsi::GenericMethod ("mimeData", "@brief Virtual method QMimeData *QStringListModel::mimeData(const QList<QModelIndex> &indexes)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0, &_set_callback_cbs_mimeData_c3010_0);
}


// QStringList QStringListModel::mimeTypes()

static void _init_cbs_mimeTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_cbs_mimeTypes_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)((QStringListModel_Adaptor *)cls)->cbs_mimeTypes_c0_0 ());
}

static void _set_callback_cbs_mimeTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_mimeTypes_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mimeTypes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("mimeTypes", "@hide", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mimeTypes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("mimeTypes", "@brief Virtual method QStringList QStringListModel::mimeTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0, &_set_callback_cbs_mimeTypes_c0_0);
}


// bool QStringListModel::removeColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_removeColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeColumns_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QStringListModel_Adaptor *)cls)->cbs_removeColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_removeColumns_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_removeColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeColumns", "@hide", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_removeColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeColumns", "@brief Virtual method bool QStringListModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1, &_set_callback_cbs_removeColumns_3713_1);
}


// bool QStringListModel::removeRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_removeRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeRows_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QStringListModel_Adaptor *)cls)->cbs_removeRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_removeRows_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_removeRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeRows", "@hide", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_removeRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeRows", "@brief Virtual method bool QStringListModel::removeRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1, &_set_callback_cbs_removeRows_3713_1);
}


// void QStringListModel::revert()

static void _init_cbs_revert_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_revert_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QStringListModel_Adaptor *)cls)->cbs_revert_0_0 ();
}

static void _set_callback_cbs_revert_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_revert_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_revert_0_0 ()
{
  return new qt_gsi::GenericMethod ("revert", "@hide", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_revert_0_0 ()
{
  return new qt_gsi::GenericMethod ("revert", "@brief Virtual method void QStringListModel::revert()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0, &_set_callback_cbs_revert_0_0);
}


// int QStringListModel::rowCount(const QModelIndex &parent)

static void _init_cbs_rowCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_rowCount_c2395_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<int > ((int)((QStringListModel_Adaptor *)cls)->cbs_rowCount_c2395_1 (arg1));
}

static void _set_callback_cbs_rowCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_rowCount_c2395_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_rowCount_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("rowCount", "@hide", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_rowCount_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("rowCount", "@brief Virtual method int QStringListModel::rowCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1, &_set_callback_cbs_rowCount_c2395_1);
}


// bool QStringListModel::setData(const QModelIndex &index, const QVariant &value, int role)

static void _init_cbs_setData_5065_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_setData_5065_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  int arg3 = args.read<int > ();
  ret.write<bool > ((bool)((QStringListModel_Adaptor *)cls)->cbs_setData_5065_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_setData_5065_1 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_setData_5065_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setData_5065_1 ()
{
  return new qt_gsi::GenericMethod ("setData", "@hide", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setData_5065_1 ()
{
  return new qt_gsi::GenericMethod ("setData", "@brief Virtual method bool QStringListModel::setData(const QModelIndex &index, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1, &_set_callback_cbs_setData_5065_1);
}


// bool QStringListModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)

static void _init_cbs_setHeaderData_5242_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("role");
  decl->add_arg<int > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_setHeaderData_5242_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  const QVariant &arg3 = args.read<const QVariant & > ();
  int arg4 = args.read<int > ();
  ret.write<bool > ((bool)((QStringListModel_Adaptor *)cls)->cbs_setHeaderData_5242_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_setHeaderData_5242_1 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_setHeaderData_5242_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setHeaderData_5242_1 ()
{
  return new qt_gsi::GenericMethod ("setHeaderData", "@hide", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setHeaderData_5242_1 ()
{
  return new qt_gsi::GenericMethod ("setHeaderData", "@brief Virtual method bool QStringListModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1, &_set_callback_cbs_setHeaderData_5242_1);
}


// void QStringListModel::sort(int column, Qt::SortOrder order)

static void _init_cbs_sort_2340_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_sort_2340_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > ();
  ((QStringListModel_Adaptor *)cls)->cbs_sort_2340_1 (arg1, arg2);
}

static void _set_callback_cbs_sort_2340_1 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_sort_2340_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sort_2340_1 ()
{
  return new qt_gsi::GenericMethod ("sort", "@hide", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sort_2340_1 ()
{
  return new qt_gsi::GenericMethod ("sort", "@brief Virtual method void QStringListModel::sort(int column, Qt::SortOrder order)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1, &_set_callback_cbs_sort_2340_1);
}


// QSize QStringListModel::span(const QModelIndex &index)

static void _init_cbs_span_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_cbs_span_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QSize > ((QSize)((QStringListModel_Adaptor *)cls)->cbs_span_c2395_0 (arg1));
}

static void _set_callback_cbs_span_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_span_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_span_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("span", "@hide", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_span_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("span", "@brief Virtual method QSize QStringListModel::span(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0, &_set_callback_cbs_span_c2395_0);
}


// bool QStringListModel::submit()

static void _init_cbs_submit_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_submit_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QStringListModel_Adaptor *)cls)->cbs_submit_0_0 ());
}

static void _set_callback_cbs_submit_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_submit_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_submit_0_0 ()
{
  return new qt_gsi::GenericMethod ("submit", "@hide", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_submit_0_0 ()
{
  return new qt_gsi::GenericMethod ("submit", "@brief Virtual method bool QStringListModel::submit()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0, &_set_callback_cbs_submit_0_0);
}


// QFlags<Qt::DropAction> QStringListModel::supportedDropActions()

static void _init_cbs_supportedDropActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ();
}

static void _call_cbs_supportedDropActions_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ((qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type)((QStringListModel_Adaptor *)cls)->cbs_supportedDropActions_c0_0 ());
}

static void _set_callback_cbs_supportedDropActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_supportedDropActions_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_supportedDropActions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("supportedDropActions", "@hide", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_supportedDropActions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("supportedDropActions", "@brief Virtual method QFlags<Qt::DropAction> QStringListModel::supportedDropActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0, &_set_callback_cbs_supportedDropActions_c0_0);
}


// void QStringListModel::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QStringListModel_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QStringListModel::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QStringListModel::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QStringListModel_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QStringListModel::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QStringListModel::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QStringListModel_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QStringListModel::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QStringListModel::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QStringListModel_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QStringListModel_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QStringListModel::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QStringListModel> decl_QStringListModel;

gsi::Class<QStringListModel_Adaptor> decl_QStringListModel_Adaptor (decl_QStringListModel, "QStringListModel",
  gsi::Methods(_create_fp_beginInsertColumns_3713 ()) +
  gsi::Methods(_create_fp_beginInsertRows_3713 ()) +
  gsi::Methods(_create_fp_beginMoveColumns_6659 ()) +
  gsi::Methods(_create_fp_beginMoveRows_6659 ()) +
  gsi::Methods(_create_fp_beginRemoveColumns_3713 ()) +
  gsi::Methods(_create_fp_beginRemoveRows_3713 ()) +
  gsi::Methods(_create_fp_beginResetModel_0 ()) +
  gsi::Methods(_create_fp_changePersistentIndex_4682 ()) +
  gsi::Methods(_create_fp_changePersistentIndexList_5912 ()) +
  gsi::Methods(_create_fp_createIndex_c2374 ()) +
  gsi::Methods(_create_fp_createIndex_c2085 ()) +
  gsi::Methods(_create_fp_createIndex_c2416 ()) +
  gsi::Methods(_create_fp_decodeData_5302 ()) +
  gsi::Methods(_create_fp_encodeData_c4599 ()) +
  gsi::Methods(_create_fp_endInsertColumns_0 ()) +
  gsi::Methods(_create_fp_endInsertRows_0 ()) +
  gsi::Methods(_create_fp_endMoveColumns_0 ()) +
  gsi::Methods(_create_fp_endMoveRows_0 ()) +
  gsi::Methods(_create_fp_endRemoveColumns_0 ()) +
  gsi::Methods(_create_fp_endRemoveRows_0 ()) +
  gsi::Methods(_create_fp_endResetModel_0 ()) +
  gsi::Methods(_create_fp_persistentIndexList_c0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_reset_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_buddy_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_buddy_c2395_0 ()) +
  gsi::Methods(_create_cbs_canFetchMore_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_canFetchMore_c2395_0 ()) +
  gsi::Methods(_create_cbs_data_c3054_0 ()) +
  gsi::Methods(_create_callback_cbs_data_c3054_0 ()) +
  gsi::Methods(_create_cbs_dropMimeData_7425_0 ()) +
  gsi::Methods(_create_callback_cbs_dropMimeData_7425_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_fetchMore_2395_0 ()) +
  gsi::Methods(_create_callback_cbs_fetchMore_2395_0 ()) +
  gsi::Methods(_create_cbs_flags_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_flags_c2395_0 ()) +
  gsi::Methods(_create_cbs_headerData_c3231_1 ()) +
  gsi::Methods(_create_callback_cbs_headerData_c3231_1 ()) +
  gsi::Methods(_create_cbs_index_c3713_2 ()) +
  gsi::Methods(_create_callback_cbs_index_c3713_2 ()) +
  gsi::Methods(_create_cbs_insertColumns_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_insertColumns_3713_1 ()) +
  gsi::Methods(_create_cbs_insertRows_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_insertRows_3713_1 ()) +
  gsi::Methods(_create_cbs_match_c7932_2 ()) +
  gsi::Methods(_create_callback_cbs_match_c7932_2 ()) +
  gsi::Methods(_create_cbs_mimeData_c3010_0 ()) +
  gsi::Methods(_create_callback_cbs_mimeData_c3010_0 ()) +
  gsi::Methods(_create_cbs_mimeTypes_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_mimeTypes_c0_0 ()) +
  gsi::Methods(_create_cbs_removeColumns_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_removeColumns_3713_1 ()) +
  gsi::Methods(_create_cbs_removeRows_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_removeRows_3713_1 ()) +
  gsi::Methods(_create_cbs_revert_0_0 ()) +
  gsi::Methods(_create_callback_cbs_revert_0_0 ()) +
  gsi::Methods(_create_cbs_rowCount_c2395_1 ()) +
  gsi::Methods(_create_callback_cbs_rowCount_c2395_1 ()) +
  gsi::Methods(_create_cbs_setData_5065_1 ()) +
  gsi::Methods(_create_callback_cbs_setData_5065_1 ()) +
  gsi::Methods(_create_cbs_setHeaderData_5242_1 ()) +
  gsi::Methods(_create_callback_cbs_setHeaderData_5242_1 ()) +
  gsi::Methods(_create_cbs_sort_2340_1 ()) +
  gsi::Methods(_create_callback_cbs_sort_2340_1 ()) +
  gsi::Methods(_create_cbs_span_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_span_c2395_0 ()) +
  gsi::Methods(_create_cbs_submit_0_0 ()) +
  gsi::Methods(_create_callback_cbs_submit_0_0 ()) +
  gsi::Methods(_create_cbs_supportedDropActions_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_supportedDropActions_c0_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QStringListModel_Adaptor_1302 ()) +
  gsi::Methods(_create_ctor_QStringListModel_Adaptor_3631 ()),
  "@qt\n@brief Binding of QStringListModel");

}

