
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSslSocket.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtNetwork.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQSslSocket_EventAdaptor.h"
#include "gsiDeclQSslSocket_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSslSocket

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSslSocket::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

//  Constructor QSslSocket::QSslSocket(QObject *parent)


static void _init_ctor_QSslSocket_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QSslSocket *> ();
}

static void _call_ctor_QSslSocket_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QSslSocket *> (new QSslSocket (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSslSocket_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSslSocket::QSslSocket(QObject *parent)\nThis method creates an object of class QSslSocket.", &_init_ctor_QSslSocket_1302, &_call_ctor_QSslSocket_1302);
}

// void QSslSocket::abort()


static void _init_f_abort_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_abort_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSslSocket *)cls)->abort ();
}

static qt_gsi::GenericMethod *_create_f_abort_0 ()
{
  return new qt_gsi::GenericMethod ("abort", "@brief Method void QSslSocket::abort()\n", false, &_init_f_abort_0, &_call_f_abort_0);
}

// void QSslSocket::addCaCertificate(const QSslCertificate &certificate)


static void _init_f_addCaCertificate_2823 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("certificate");
  decl->add_arg<const QSslCertificate & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addCaCertificate_2823 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSslCertificate &arg1 = args.read<const QSslCertificate & > ();
  ((QSslSocket *)cls)->addCaCertificate (arg1);
}

static qt_gsi::GenericMethod *_create_f_addCaCertificate_2823 ()
{
  return new qt_gsi::GenericMethod ("addCaCertificate", "@brief Method void QSslSocket::addCaCertificate(const QSslCertificate &certificate)\n", false, &_init_f_addCaCertificate_2823, &_call_f_addCaCertificate_2823);
}

// bool QSslSocket::addCaCertificates(const QString &path, QSsl::EncodingFormat format, QRegExp::PatternSyntax syntax)


static void _init_f_addCaCertificates_6773 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QSsl::Pem");
  decl->add_arg<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("syntax", true, "QRegExp::FixedString");
  decl->add_arg<const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_addCaCertificates_6773 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & > () : (const qt_gsi::Converter<QSsl::EncodingFormat>::target_type &)(qt_gsi::CppToQtReadAdaptor<QSsl::EncodingFormat>(heap, QSsl::Pem));
  const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & > () : (const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type &)(qt_gsi::CppToQtReadAdaptor<QRegExp::PatternSyntax>(heap, QRegExp::FixedString));
  ret.write<bool > ((bool)((QSslSocket *)cls)->addCaCertificates (arg1, qt_gsi::QtToCppAdaptor<QSsl::EncodingFormat>(arg2).cref(), qt_gsi::QtToCppAdaptor<QRegExp::PatternSyntax>(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_addCaCertificates_6773 ()
{
  return new qt_gsi::GenericMethod ("addCaCertificates", "@brief Method bool QSslSocket::addCaCertificates(const QString &path, QSsl::EncodingFormat format, QRegExp::PatternSyntax syntax)\n", false, &_init_f_addCaCertificates_6773, &_call_f_addCaCertificates_6773);
}

// void QSslSocket::addCaCertificates(const QList<QSslCertificate> &certificates)


static void _init_f_addCaCertificates_3438 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("certificates");
  decl->add_arg<const qt_gsi::Converter<QList<QSslCertificate> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addCaCertificates_3438 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QSslCertificate> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QSslCertificate> >::target_type & > ();
  ((QSslSocket *)cls)->addCaCertificates (qt_gsi::QtToCppAdaptor<QList<QSslCertificate> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_addCaCertificates_3438 ()
{
  return new qt_gsi::GenericMethod ("addCaCertificates", "@brief Method void QSslSocket::addCaCertificates(const QList<QSslCertificate> &certificates)\n", false, &_init_f_addCaCertificates_3438, &_call_f_addCaCertificates_3438);
}

// bool QSslSocket::atEnd()


static void _init_f_atEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atEnd_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSslSocket *)cls)->atEnd ());
}

static qt_gsi::GenericMethod *_create_f_atEnd_c0 ()
{
  return new qt_gsi::GenericMethod ("atEnd", "@brief Method bool QSslSocket::atEnd()\nThis is a reimplementation of QAbstractSocket::atEnd", true, &_init_f_atEnd_c0, &_call_f_atEnd_c0);
}

// qint64 QSslSocket::bytesAvailable()


static void _init_f_bytesAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesAvailable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QSslSocket *)cls)->bytesAvailable ());
}

static qt_gsi::GenericMethod *_create_f_bytesAvailable_c0 ()
{
  return new qt_gsi::GenericMethod ("bytesAvailable", "@brief Method qint64 QSslSocket::bytesAvailable()\nThis is a reimplementation of QAbstractSocket::bytesAvailable", true, &_init_f_bytesAvailable_c0, &_call_f_bytesAvailable_c0);
}

// qint64 QSslSocket::bytesToWrite()


static void _init_f_bytesToWrite_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesToWrite_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QSslSocket *)cls)->bytesToWrite ());
}

static qt_gsi::GenericMethod *_create_f_bytesToWrite_c0 ()
{
  return new qt_gsi::GenericMethod ("bytesToWrite", "@brief Method qint64 QSslSocket::bytesToWrite()\nThis is a reimplementation of QAbstractSocket::bytesToWrite", true, &_init_f_bytesToWrite_c0, &_call_f_bytesToWrite_c0);
}

// QList<QSslCertificate> QSslSocket::caCertificates()


static void _init_f_caCertificates_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QSslCertificate> >::target_type > ();
}

static void _call_f_caCertificates_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QSslCertificate> >::target_type > ((qt_gsi::Converter<QList<QSslCertificate> >::target_type)qt_gsi::CppToQtAdaptor<QList<QSslCertificate> >(((QSslSocket *)cls)->caCertificates ()));
}

static qt_gsi::GenericMethod *_create_f_caCertificates_c0 ()
{
  return new qt_gsi::GenericMethod (":caCertificates", "@brief Method QList<QSslCertificate> QSslSocket::caCertificates()\n", true, &_init_f_caCertificates_c0, &_call_f_caCertificates_c0);
}

// bool QSslSocket::canReadLine()


static void _init_f_canReadLine_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_canReadLine_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSslSocket *)cls)->canReadLine ());
}

static qt_gsi::GenericMethod *_create_f_canReadLine_c0 ()
{
  return new qt_gsi::GenericMethod ("canReadLine", "@brief Method bool QSslSocket::canReadLine()\nThis is a reimplementation of QAbstractSocket::canReadLine", true, &_init_f_canReadLine_c0, &_call_f_canReadLine_c0);
}

// QList<QSslCipher> QSslSocket::ciphers()


static void _init_f_ciphers_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QSslCipher> >::target_type > ();
}

static void _call_f_ciphers_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QSslCipher> >::target_type > ((qt_gsi::Converter<QList<QSslCipher> >::target_type)qt_gsi::CppToQtAdaptor<QList<QSslCipher> >(((QSslSocket *)cls)->ciphers ()));
}

static qt_gsi::GenericMethod *_create_f_ciphers_c0 ()
{
  return new qt_gsi::GenericMethod (":ciphers", "@brief Method QList<QSslCipher> QSslSocket::ciphers()\n", true, &_init_f_ciphers_c0, &_call_f_ciphers_c0);
}

// void QSslSocket::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSslSocket *)cls)->close ();
}

static qt_gsi::GenericMethod *_create_f_close_0 ()
{
  return new qt_gsi::GenericMethod ("close", "@brief Method void QSslSocket::close()\nThis is a reimplementation of QAbstractSocket::close", false, &_init_f_close_0, &_call_f_close_0);
}

// void QSslSocket::connectToHostEncrypted(const QString &hostName, quint16 port, QFlags<QIODevice::OpenModeFlag> mode)


static void _init_f_connectToHostEncrypted_6151 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hostName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port");
  decl->add_arg<quint16 > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QIODevice::ReadWrite");
  decl->add_arg<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_connectToHostEncrypted_6151 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  quint16 arg2 = args.read<quint16 > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QIODevice::OpenModeFlag> >(heap, QIODevice::ReadWrite));
  ((QSslSocket *)cls)->connectToHostEncrypted (arg1, arg2, qt_gsi::QtToCppAdaptor<QFlags<QIODevice::OpenModeFlag> >(arg3).cref());
}

static qt_gsi::GenericMethod *_create_f_connectToHostEncrypted_6151 ()
{
  return new qt_gsi::GenericMethod ("connectToHostEncrypted", "@brief Method void QSslSocket::connectToHostEncrypted(const QString &hostName, quint16 port, QFlags<QIODevice::OpenModeFlag> mode)\n", false, &_init_f_connectToHostEncrypted_6151, &_call_f_connectToHostEncrypted_6151);
}

// void QSslSocket::connectToHostEncrypted(const QString &hostName, quint16 port, const QString &sslPeerName, QFlags<QIODevice::OpenModeFlag> mode)


static void _init_f_connectToHostEncrypted_8068 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hostName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port");
  decl->add_arg<quint16 > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sslPeerName");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("mode", true, "QIODevice::ReadWrite");
  decl->add_arg<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_connectToHostEncrypted_8068 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  quint16 arg2 = args.read<quint16 > ();
  const QString &arg3 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QIODevice::OpenModeFlag> >(heap, QIODevice::ReadWrite));
  ((QSslSocket *)cls)->connectToHostEncrypted (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QFlags<QIODevice::OpenModeFlag> >(arg4).cref());
}

static qt_gsi::GenericMethod *_create_f_connectToHostEncrypted_8068 ()
{
  return new qt_gsi::GenericMethod ("connectToHostEncrypted", "@brief Method void QSslSocket::connectToHostEncrypted(const QString &hostName, quint16 port, const QString &sslPeerName, QFlags<QIODevice::OpenModeFlag> mode)\n", false, &_init_f_connectToHostEncrypted_8068, &_call_f_connectToHostEncrypted_8068);
}

// qint64 QSslSocket::encryptedBytesAvailable()


static void _init_f_encryptedBytesAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_encryptedBytesAvailable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QSslSocket *)cls)->encryptedBytesAvailable ());
}

static qt_gsi::GenericMethod *_create_f_encryptedBytesAvailable_c0 ()
{
  return new qt_gsi::GenericMethod ("encryptedBytesAvailable", "@brief Method qint64 QSslSocket::encryptedBytesAvailable()\n", true, &_init_f_encryptedBytesAvailable_c0, &_call_f_encryptedBytesAvailable_c0);
}

// qint64 QSslSocket::encryptedBytesToWrite()


static void _init_f_encryptedBytesToWrite_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_encryptedBytesToWrite_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QSslSocket *)cls)->encryptedBytesToWrite ());
}

static qt_gsi::GenericMethod *_create_f_encryptedBytesToWrite_c0 ()
{
  return new qt_gsi::GenericMethod ("encryptedBytesToWrite", "@brief Method qint64 QSslSocket::encryptedBytesToWrite()\n", true, &_init_f_encryptedBytesToWrite_c0, &_call_f_encryptedBytesToWrite_c0);
}

// bool QSslSocket::flush()


static void _init_f_flush_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_flush_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSslSocket *)cls)->flush ());
}

static qt_gsi::GenericMethod *_create_f_flush_0 ()
{
  return new qt_gsi::GenericMethod ("flush", "@brief Method bool QSslSocket::flush()\n", false, &_init_f_flush_0, &_call_f_flush_0);
}

// void QSslSocket::ignoreSslErrors(const QList<QSslError> &errors)


static void _init_f_ignoreSslErrors_2837 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("errors");
  decl->add_arg<const qt_gsi::Converter<QList<QSslError> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_ignoreSslErrors_2837 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QSslError> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QSslError> >::target_type & > ();
  ((QSslSocket *)cls)->ignoreSslErrors (qt_gsi::QtToCppAdaptor<QList<QSslError> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_ignoreSslErrors_2837 ()
{
  return new qt_gsi::GenericMethod ("ignoreSslErrors", "@brief Method void QSslSocket::ignoreSslErrors(const QList<QSslError> &errors)\n", false, &_init_f_ignoreSslErrors_2837, &_call_f_ignoreSslErrors_2837);
}

// void QSslSocket::ignoreSslErrors()


static void _init_f_ignoreSslErrors_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_ignoreSslErrors_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSslSocket *)cls)->ignoreSslErrors ();
}

static qt_gsi::GenericMethod *_create_f_ignoreSslErrors_0 ()
{
  return new qt_gsi::GenericMethod ("ignoreSslErrors", "@brief Method void QSslSocket::ignoreSslErrors()\n", false, &_init_f_ignoreSslErrors_0, &_call_f_ignoreSslErrors_0);
}

// bool QSslSocket::isEncrypted()


static void _init_f_isEncrypted_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEncrypted_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSslSocket *)cls)->isEncrypted ());
}

static qt_gsi::GenericMethod *_create_f_isEncrypted_c0 ()
{
  return new qt_gsi::GenericMethod ("isEncrypted?", "@brief Method bool QSslSocket::isEncrypted()\n", true, &_init_f_isEncrypted_c0, &_call_f_isEncrypted_c0);
}

// QSslCertificate QSslSocket::localCertificate()


static void _init_f_localCertificate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSslCertificate > ();
}

static void _call_f_localCertificate_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSslCertificate > ((QSslCertificate)((QSslSocket *)cls)->localCertificate ());
}

static qt_gsi::GenericMethod *_create_f_localCertificate_c0 ()
{
  return new qt_gsi::GenericMethod (":localCertificate", "@brief Method QSslCertificate QSslSocket::localCertificate()\n", true, &_init_f_localCertificate_c0, &_call_f_localCertificate_c0);
}

// QSslSocket::SslMode QSslSocket::mode()


static void _init_f_mode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSslSocket::SslMode>::target_type > ();
}

static void _call_f_mode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QSslSocket::SslMode>::target_type > ((qt_gsi::Converter<QSslSocket::SslMode>::target_type)qt_gsi::CppToQtAdaptor<QSslSocket::SslMode>(((QSslSocket *)cls)->mode ()));
}

static qt_gsi::GenericMethod *_create_f_mode_c0 ()
{
  return new qt_gsi::GenericMethod ("mode", "@brief Method QSslSocket::SslMode QSslSocket::mode()\n", true, &_init_f_mode_c0, &_call_f_mode_c0);
}

// QSslCertificate QSslSocket::peerCertificate()


static void _init_f_peerCertificate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSslCertificate > ();
}

static void _call_f_peerCertificate_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSslCertificate > ((QSslCertificate)((QSslSocket *)cls)->peerCertificate ());
}

static qt_gsi::GenericMethod *_create_f_peerCertificate_c0 ()
{
  return new qt_gsi::GenericMethod ("peerCertificate", "@brief Method QSslCertificate QSslSocket::peerCertificate()\n", true, &_init_f_peerCertificate_c0, &_call_f_peerCertificate_c0);
}

// QList<QSslCertificate> QSslSocket::peerCertificateChain()


static void _init_f_peerCertificateChain_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QSslCertificate> >::target_type > ();
}

static void _call_f_peerCertificateChain_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QSslCertificate> >::target_type > ((qt_gsi::Converter<QList<QSslCertificate> >::target_type)qt_gsi::CppToQtAdaptor<QList<QSslCertificate> >(((QSslSocket *)cls)->peerCertificateChain ()));
}

static qt_gsi::GenericMethod *_create_f_peerCertificateChain_c0 ()
{
  return new qt_gsi::GenericMethod ("peerCertificateChain", "@brief Method QList<QSslCertificate> QSslSocket::peerCertificateChain()\n", true, &_init_f_peerCertificateChain_c0, &_call_f_peerCertificateChain_c0);
}

// int QSslSocket::peerVerifyDepth()


static void _init_f_peerVerifyDepth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_peerVerifyDepth_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QSslSocket *)cls)->peerVerifyDepth ());
}

static qt_gsi::GenericMethod *_create_f_peerVerifyDepth_c0 ()
{
  return new qt_gsi::GenericMethod (":peerVerifyDepth", "@brief Method int QSslSocket::peerVerifyDepth()\n", true, &_init_f_peerVerifyDepth_c0, &_call_f_peerVerifyDepth_c0);
}

// QSslSocket::PeerVerifyMode QSslSocket::peerVerifyMode()


static void _init_f_peerVerifyMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSslSocket::PeerVerifyMode>::target_type > ();
}

static void _call_f_peerVerifyMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QSslSocket::PeerVerifyMode>::target_type > ((qt_gsi::Converter<QSslSocket::PeerVerifyMode>::target_type)qt_gsi::CppToQtAdaptor<QSslSocket::PeerVerifyMode>(((QSslSocket *)cls)->peerVerifyMode ()));
}

static qt_gsi::GenericMethod *_create_f_peerVerifyMode_c0 ()
{
  return new qt_gsi::GenericMethod (":peerVerifyMode", "@brief Method QSslSocket::PeerVerifyMode QSslSocket::peerVerifyMode()\n", true, &_init_f_peerVerifyMode_c0, &_call_f_peerVerifyMode_c0);
}

// QSslKey QSslSocket::privateKey()


static void _init_f_privateKey_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSslKey > ();
}

static void _call_f_privateKey_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSslKey > ((QSslKey)((QSslSocket *)cls)->privateKey ());
}

static qt_gsi::GenericMethod *_create_f_privateKey_c0 ()
{
  return new qt_gsi::GenericMethod (":privateKey", "@brief Method QSslKey QSslSocket::privateKey()\n", true, &_init_f_privateKey_c0, &_call_f_privateKey_c0);
}

// QSsl::SslProtocol QSslSocket::protocol()


static void _init_f_protocol_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSsl::SslProtocol>::target_type > ();
}

static void _call_f_protocol_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QSsl::SslProtocol>::target_type > ((qt_gsi::Converter<QSsl::SslProtocol>::target_type)qt_gsi::CppToQtAdaptor<QSsl::SslProtocol>(((QSslSocket *)cls)->protocol ()));
}

static qt_gsi::GenericMethod *_create_f_protocol_c0 ()
{
  return new qt_gsi::GenericMethod (":protocol", "@brief Method QSsl::SslProtocol QSslSocket::protocol()\n", true, &_init_f_protocol_c0, &_call_f_protocol_c0);
}

// QSslCipher QSslSocket::sessionCipher()


static void _init_f_sessionCipher_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSslCipher > ();
}

static void _call_f_sessionCipher_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSslCipher > ((QSslCipher)((QSslSocket *)cls)->sessionCipher ());
}

static qt_gsi::GenericMethod *_create_f_sessionCipher_c0 ()
{
  return new qt_gsi::GenericMethod ("sessionCipher", "@brief Method QSslCipher QSslSocket::sessionCipher()\n", true, &_init_f_sessionCipher_c0, &_call_f_sessionCipher_c0);
}

// void QSslSocket::setCaCertificates(const QList<QSslCertificate> &certificates)


static void _init_f_setCaCertificates_3438 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("certificates");
  decl->add_arg<const qt_gsi::Converter<QList<QSslCertificate> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCaCertificates_3438 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QSslCertificate> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QSslCertificate> >::target_type & > ();
  ((QSslSocket *)cls)->setCaCertificates (qt_gsi::QtToCppAdaptor<QList<QSslCertificate> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setCaCertificates_3438 ()
{
  return new qt_gsi::GenericMethod ("setCaCertificates|caCertificates=", "@brief Method void QSslSocket::setCaCertificates(const QList<QSslCertificate> &certificates)\n", false, &_init_f_setCaCertificates_3438, &_call_f_setCaCertificates_3438);
}

// void QSslSocket::setCiphers(const QList<QSslCipher> &ciphers)


static void _init_f_setCiphers_2918 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ciphers");
  decl->add_arg<const qt_gsi::Converter<QList<QSslCipher> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCiphers_2918 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QSslCipher> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QSslCipher> >::target_type & > ();
  ((QSslSocket *)cls)->setCiphers (qt_gsi::QtToCppAdaptor<QList<QSslCipher> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setCiphers_2918 ()
{
  return new qt_gsi::GenericMethod ("setCiphers|ciphers=", "@brief Method void QSslSocket::setCiphers(const QList<QSslCipher> &ciphers)\n", false, &_init_f_setCiphers_2918, &_call_f_setCiphers_2918);
}

// void QSslSocket::setCiphers(const QString &ciphers)


static void _init_f_setCiphers_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ciphers");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCiphers_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QSslSocket *)cls)->setCiphers (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCiphers_2025 ()
{
  return new qt_gsi::GenericMethod ("setCiphers|ciphers=", "@brief Method void QSslSocket::setCiphers(const QString &ciphers)\n", false, &_init_f_setCiphers_2025, &_call_f_setCiphers_2025);
}

// void QSslSocket::setLocalCertificate(const QSslCertificate &certificate)


static void _init_f_setLocalCertificate_2823 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("certificate");
  decl->add_arg<const QSslCertificate & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLocalCertificate_2823 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSslCertificate &arg1 = args.read<const QSslCertificate & > ();
  ((QSslSocket *)cls)->setLocalCertificate (arg1);
}

static qt_gsi::GenericMethod *_create_f_setLocalCertificate_2823 ()
{
  return new qt_gsi::GenericMethod ("setLocalCertificate|localCertificate=", "@brief Method void QSslSocket::setLocalCertificate(const QSslCertificate &certificate)\n", false, &_init_f_setLocalCertificate_2823, &_call_f_setLocalCertificate_2823);
}

// void QSslSocket::setLocalCertificate(const QString &fileName, QSsl::EncodingFormat format)


static void _init_f_setLocalCertificate_4280 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QSsl::Pem");
  decl->add_arg<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setLocalCertificate_4280 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & > () : (const qt_gsi::Converter<QSsl::EncodingFormat>::target_type &)(qt_gsi::CppToQtReadAdaptor<QSsl::EncodingFormat>(heap, QSsl::Pem));
  ((QSslSocket *)cls)->setLocalCertificate (arg1, qt_gsi::QtToCppAdaptor<QSsl::EncodingFormat>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_setLocalCertificate_4280 ()
{
  return new qt_gsi::GenericMethod ("setLocalCertificate", "@brief Method void QSslSocket::setLocalCertificate(const QString &fileName, QSsl::EncodingFormat format)\n", false, &_init_f_setLocalCertificate_4280, &_call_f_setLocalCertificate_4280);
}

// void QSslSocket::setPeerVerifyDepth(int depth)


static void _init_f_setPeerVerifyDepth_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("depth");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPeerVerifyDepth_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QSslSocket *)cls)->setPeerVerifyDepth (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPeerVerifyDepth_767 ()
{
  return new qt_gsi::GenericMethod ("setPeerVerifyDepth|peerVerifyDepth=", "@brief Method void QSslSocket::setPeerVerifyDepth(int depth)\n", false, &_init_f_setPeerVerifyDepth_767, &_call_f_setPeerVerifyDepth_767);
}

// void QSslSocket::setPeerVerifyMode(QSslSocket::PeerVerifyMode mode)


static void _init_f_setPeerVerifyMode_2970 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QSslSocket::PeerVerifyMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPeerVerifyMode_2970 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QSslSocket::PeerVerifyMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QSslSocket::PeerVerifyMode>::target_type & > ();
  ((QSslSocket *)cls)->setPeerVerifyMode (qt_gsi::QtToCppAdaptor<QSslSocket::PeerVerifyMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setPeerVerifyMode_2970 ()
{
  return new qt_gsi::GenericMethod ("setPeerVerifyMode|peerVerifyMode=", "@brief Method void QSslSocket::setPeerVerifyMode(QSslSocket::PeerVerifyMode mode)\n", false, &_init_f_setPeerVerifyMode_2970, &_call_f_setPeerVerifyMode_2970);
}

// void QSslSocket::setPrivateKey(const QSslKey &key)


static void _init_f_setPrivateKey_1997 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QSslKey & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPrivateKey_1997 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSslKey &arg1 = args.read<const QSslKey & > ();
  ((QSslSocket *)cls)->setPrivateKey (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPrivateKey_1997 ()
{
  return new qt_gsi::GenericMethod ("setPrivateKey|privateKey=", "@brief Method void QSslSocket::setPrivateKey(const QSslKey &key)\n", false, &_init_f_setPrivateKey_1997, &_call_f_setPrivateKey_1997);
}

// void QSslSocket::setPrivateKey(const QString &fileName, QSsl::KeyAlgorithm algorithm, QSsl::EncodingFormat format, const QByteArray &passPhrase)


static void _init_f_setPrivateKey_8544 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("algorithm", true, "QSsl::Rsa");
  decl->add_arg<const qt_gsi::Converter<QSsl::KeyAlgorithm>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("format", true, "QSsl::Pem");
  decl->add_arg<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("passPhrase", true, "QByteArray()");
  decl->add_arg<const QByteArray & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setPrivateKey_8544 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QSsl::KeyAlgorithm>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QSsl::KeyAlgorithm>::target_type & > () : (const qt_gsi::Converter<QSsl::KeyAlgorithm>::target_type &)(qt_gsi::CppToQtReadAdaptor<QSsl::KeyAlgorithm>(heap, QSsl::Rsa));
  const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & > () : (const qt_gsi::Converter<QSsl::EncodingFormat>::target_type &)(qt_gsi::CppToQtReadAdaptor<QSsl::EncodingFormat>(heap, QSsl::Pem));
  const QByteArray &arg4 = args ? args.read<const QByteArray & > () : (const QByteArray &)(QByteArray());
  ((QSslSocket *)cls)->setPrivateKey (arg1, qt_gsi::QtToCppAdaptor<QSsl::KeyAlgorithm>(arg2).cref(), qt_gsi::QtToCppAdaptor<QSsl::EncodingFormat>(arg3).cref(), arg4);
}

static qt_gsi::GenericMethod *_create_f_setPrivateKey_8544 ()
{
  return new qt_gsi::GenericMethod ("setPrivateKey", "@brief Method void QSslSocket::setPrivateKey(const QString &fileName, QSsl::KeyAlgorithm algorithm, QSsl::EncodingFormat format, const QByteArray &passPhrase)\n", false, &_init_f_setPrivateKey_8544, &_call_f_setPrivateKey_8544);
}

// void QSslSocket::setProtocol(QSsl::SslProtocol protocol)


static void _init_f_setProtocol_2095 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("protocol");
  decl->add_arg<const qt_gsi::Converter<QSsl::SslProtocol>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProtocol_2095 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QSsl::SslProtocol>::target_type & arg1 = args.read<const qt_gsi::Converter<QSsl::SslProtocol>::target_type & > ();
  ((QSslSocket *)cls)->setProtocol (qt_gsi::QtToCppAdaptor<QSsl::SslProtocol>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setProtocol_2095 ()
{
  return new qt_gsi::GenericMethod ("setProtocol|protocol=", "@brief Method void QSslSocket::setProtocol(QSsl::SslProtocol protocol)\n", false, &_init_f_setProtocol_2095, &_call_f_setProtocol_2095);
}

// void QSslSocket::setReadBufferSize(qint64 size)


static void _init_f_setReadBufferSize_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setReadBufferSize_986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  qint64 arg1 = args.read<qint64 > ();
  ((QSslSocket *)cls)->setReadBufferSize (arg1);
}

static qt_gsi::GenericMethod *_create_f_setReadBufferSize_986 ()
{
  return new qt_gsi::GenericMethod ("setReadBufferSize|readBufferSize=", "@brief Method void QSslSocket::setReadBufferSize(qint64 size)\n", false, &_init_f_setReadBufferSize_986, &_call_f_setReadBufferSize_986);
}

// bool QSslSocket::setSocketDescriptor(int socketDescriptor, QAbstractSocket::SocketState state, QFlags<QIODevice::OpenModeFlag> openMode)


static void _init_f_setSocketDescriptor_6993 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("socketDescriptor");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("state", true, "QAbstractSocket::ConnectedState");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("openMode", true, "QIODevice::ReadWrite");
  decl->add_arg<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_setSocketDescriptor_6993 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type & > () : (const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type &)(qt_gsi::CppToQtReadAdaptor<QAbstractSocket::SocketState>(heap, QAbstractSocket::ConnectedState));
  const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QIODevice::OpenModeFlag> >(heap, QIODevice::ReadWrite));
  ret.write<bool > ((bool)((QSslSocket *)cls)->setSocketDescriptor (arg1, qt_gsi::QtToCppAdaptor<QAbstractSocket::SocketState>(arg2).cref(), qt_gsi::QtToCppAdaptor<QFlags<QIODevice::OpenModeFlag> >(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_setSocketDescriptor_6993 ()
{
  return new qt_gsi::GenericMethod ("setSocketDescriptor", "@brief Method bool QSslSocket::setSocketDescriptor(int socketDescriptor, QAbstractSocket::SocketState state, QFlags<QIODevice::OpenModeFlag> openMode)\n", false, &_init_f_setSocketDescriptor_6993, &_call_f_setSocketDescriptor_6993);
}

// void QSslSocket::setSocketOption(QAbstractSocket::SocketOption option, const QVariant &value)


static void _init_f_setSocketOption_5331 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setSocketOption_5331 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  ((QSslSocket *)cls)->setSocketOption (qt_gsi::QtToCppAdaptor<QAbstractSocket::SocketOption>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setSocketOption_5331 ()
{
  return new qt_gsi::GenericMethod ("setSocketOption", "@brief Method void QSslSocket::setSocketOption(QAbstractSocket::SocketOption option, const QVariant &value)\n", false, &_init_f_setSocketOption_5331, &_call_f_setSocketOption_5331);
}

// void QSslSocket::setSslConfiguration(const QSslConfiguration &config)


static void _init_f_setSslConfiguration_3068 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("config");
  decl->add_arg<const QSslConfiguration & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSslConfiguration_3068 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSslConfiguration &arg1 = args.read<const QSslConfiguration & > ();
  ((QSslSocket *)cls)->setSslConfiguration (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSslConfiguration_3068 ()
{
  return new qt_gsi::GenericMethod ("setSslConfiguration|sslConfiguration=", "@brief Method void QSslSocket::setSslConfiguration(const QSslConfiguration &config)\n", false, &_init_f_setSslConfiguration_3068, &_call_f_setSslConfiguration_3068);
}

// QVariant QSslSocket::socketOption(QAbstractSocket::SocketOption option)


static void _init_f_socketOption_3320 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_socketOption_3320 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractSocket::SocketOption>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QSslSocket *)cls)->socketOption (qt_gsi::QtToCppAdaptor<QAbstractSocket::SocketOption>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_socketOption_3320 ()
{
  return new qt_gsi::GenericMethod ("socketOption", "@brief Method QVariant QSslSocket::socketOption(QAbstractSocket::SocketOption option)\n", false, &_init_f_socketOption_3320, &_call_f_socketOption_3320);
}

// QSslConfiguration QSslSocket::sslConfiguration()


static void _init_f_sslConfiguration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSslConfiguration > ();
}

static void _call_f_sslConfiguration_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSslConfiguration > ((QSslConfiguration)((QSslSocket *)cls)->sslConfiguration ());
}

static qt_gsi::GenericMethod *_create_f_sslConfiguration_c0 ()
{
  return new qt_gsi::GenericMethod (":sslConfiguration", "@brief Method QSslConfiguration QSslSocket::sslConfiguration()\n", true, &_init_f_sslConfiguration_c0, &_call_f_sslConfiguration_c0);
}

// QList<QSslError> QSslSocket::sslErrors()


static void _init_f_sslErrors_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QSslError> >::target_type > ();
}

static void _call_f_sslErrors_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QSslError> >::target_type > ((qt_gsi::Converter<QList<QSslError> >::target_type)qt_gsi::CppToQtAdaptor<QList<QSslError> >(((QSslSocket *)cls)->sslErrors ()));
}

static qt_gsi::GenericMethod *_create_f_sslErrors_c0 ()
{
  return new qt_gsi::GenericMethod ("sslErrors", "@brief Method QList<QSslError> QSslSocket::sslErrors()\n", true, &_init_f_sslErrors_c0, &_call_f_sslErrors_c0);
}

// void QSslSocket::startClientEncryption()


static void _init_f_startClientEncryption_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_startClientEncryption_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSslSocket *)cls)->startClientEncryption ();
}

static qt_gsi::GenericMethod *_create_f_startClientEncryption_0 ()
{
  return new qt_gsi::GenericMethod ("startClientEncryption", "@brief Method void QSslSocket::startClientEncryption()\n", false, &_init_f_startClientEncryption_0, &_call_f_startClientEncryption_0);
}

// void QSslSocket::startServerEncryption()


static void _init_f_startServerEncryption_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_startServerEncryption_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSslSocket *)cls)->startServerEncryption ();
}

static qt_gsi::GenericMethod *_create_f_startServerEncryption_0 ()
{
  return new qt_gsi::GenericMethod ("startServerEncryption", "@brief Method void QSslSocket::startServerEncryption()\n", false, &_init_f_startServerEncryption_0, &_call_f_startServerEncryption_0);
}

// bool QSslSocket::waitForBytesWritten(int msecs)


static void _init_f_waitForBytesWritten_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForBytesWritten_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(30000);
  ret.write<bool > ((bool)((QSslSocket *)cls)->waitForBytesWritten (arg1));
}

static qt_gsi::GenericMethod *_create_f_waitForBytesWritten_767 ()
{
  return new qt_gsi::GenericMethod ("waitForBytesWritten", "@brief Method bool QSslSocket::waitForBytesWritten(int msecs)\nThis is a reimplementation of QAbstractSocket::waitForBytesWritten", false, &_init_f_waitForBytesWritten_767, &_call_f_waitForBytesWritten_767);
}

// bool QSslSocket::waitForConnected(int msecs)


static void _init_f_waitForConnected_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForConnected_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(30000);
  ret.write<bool > ((bool)((QSslSocket *)cls)->waitForConnected (arg1));
}

static qt_gsi::GenericMethod *_create_f_waitForConnected_767 ()
{
  return new qt_gsi::GenericMethod ("waitForConnected", "@brief Method bool QSslSocket::waitForConnected(int msecs)\n", false, &_init_f_waitForConnected_767, &_call_f_waitForConnected_767);
}

// bool QSslSocket::waitForDisconnected(int msecs)


static void _init_f_waitForDisconnected_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForDisconnected_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(30000);
  ret.write<bool > ((bool)((QSslSocket *)cls)->waitForDisconnected (arg1));
}

static qt_gsi::GenericMethod *_create_f_waitForDisconnected_767 ()
{
  return new qt_gsi::GenericMethod ("waitForDisconnected", "@brief Method bool QSslSocket::waitForDisconnected(int msecs)\n", false, &_init_f_waitForDisconnected_767, &_call_f_waitForDisconnected_767);
}

// bool QSslSocket::waitForEncrypted(int msecs)


static void _init_f_waitForEncrypted_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForEncrypted_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(30000);
  ret.write<bool > ((bool)((QSslSocket *)cls)->waitForEncrypted (arg1));
}

static qt_gsi::GenericMethod *_create_f_waitForEncrypted_767 ()
{
  return new qt_gsi::GenericMethod ("waitForEncrypted", "@brief Method bool QSslSocket::waitForEncrypted(int msecs)\n", false, &_init_f_waitForEncrypted_767, &_call_f_waitForEncrypted_767);
}

// bool QSslSocket::waitForReadyRead(int msecs)


static void _init_f_waitForReadyRead_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs", true, "30000");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_waitForReadyRead_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(30000);
  ret.write<bool > ((bool)((QSslSocket *)cls)->waitForReadyRead (arg1));
}

static qt_gsi::GenericMethod *_create_f_waitForReadyRead_767 ()
{
  return new qt_gsi::GenericMethod ("waitForReadyRead", "@brief Method bool QSslSocket::waitForReadyRead(int msecs)\nThis is a reimplementation of QAbstractSocket::waitForReadyRead", false, &_init_f_waitForReadyRead_767, &_call_f_waitForReadyRead_767);
}

// static void QSslSocket::addDefaultCaCertificate(const QSslCertificate &certificate)


static void _init_f_addDefaultCaCertificate_2823 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("certificate");
  decl->add_arg<const QSslCertificate & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addDefaultCaCertificate_2823 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSslCertificate &arg1 = args.read<const QSslCertificate & > ();
  QSslSocket::addDefaultCaCertificate (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_addDefaultCaCertificate_2823 ()
{
  return new qt_gsi::GenericStaticMethod ("addDefaultCaCertificate", "@brief Static method void QSslSocket::addDefaultCaCertificate(const QSslCertificate &certificate)\nThis method is static and can be called without an instance.", &_init_f_addDefaultCaCertificate_2823, &_call_f_addDefaultCaCertificate_2823);
}

// static bool QSslSocket::addDefaultCaCertificates(const QString &path, QSsl::EncodingFormat format, QRegExp::PatternSyntax syntax)


static void _init_f_addDefaultCaCertificates_6773 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QSsl::Pem");
  decl->add_arg<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("syntax", true, "QRegExp::FixedString");
  decl->add_arg<const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_f_addDefaultCaCertificates_6773 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QSsl::EncodingFormat>::target_type & > () : (const qt_gsi::Converter<QSsl::EncodingFormat>::target_type &)(qt_gsi::CppToQtReadAdaptor<QSsl::EncodingFormat>(heap, QSsl::Pem));
  const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type & > () : (const qt_gsi::Converter<QRegExp::PatternSyntax>::target_type &)(qt_gsi::CppToQtReadAdaptor<QRegExp::PatternSyntax>(heap, QRegExp::FixedString));
  ret.write<bool > ((bool)QSslSocket::addDefaultCaCertificates (arg1, qt_gsi::QtToCppAdaptor<QSsl::EncodingFormat>(arg2).cref(), qt_gsi::QtToCppAdaptor<QRegExp::PatternSyntax>(arg3).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_addDefaultCaCertificates_6773 ()
{
  return new qt_gsi::GenericStaticMethod ("addDefaultCaCertificates", "@brief Static method bool QSslSocket::addDefaultCaCertificates(const QString &path, QSsl::EncodingFormat format, QRegExp::PatternSyntax syntax)\nThis method is static and can be called without an instance.", &_init_f_addDefaultCaCertificates_6773, &_call_f_addDefaultCaCertificates_6773);
}

// static void QSslSocket::addDefaultCaCertificates(const QList<QSslCertificate> &certificates)


static void _init_f_addDefaultCaCertificates_3438 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("certificates");
  decl->add_arg<const qt_gsi::Converter<QList<QSslCertificate> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addDefaultCaCertificates_3438 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QSslCertificate> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QSslCertificate> >::target_type & > ();
  QSslSocket::addDefaultCaCertificates (qt_gsi::QtToCppAdaptor<QList<QSslCertificate> >(arg1).cref());
}

static qt_gsi::GenericStaticMethod *_create_f_addDefaultCaCertificates_3438 ()
{
  return new qt_gsi::GenericStaticMethod ("addDefaultCaCertificates", "@brief Static method void QSslSocket::addDefaultCaCertificates(const QList<QSslCertificate> &certificates)\nThis method is static and can be called without an instance.", &_init_f_addDefaultCaCertificates_3438, &_call_f_addDefaultCaCertificates_3438);
}

// static QList<QSslCertificate> QSslSocket::defaultCaCertificates()


static void _init_f_defaultCaCertificates_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QSslCertificate> >::target_type > ();
}

static void _call_f_defaultCaCertificates_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QSslCertificate> >::target_type > ((qt_gsi::Converter<QList<QSslCertificate> >::target_type)qt_gsi::CppToQtAdaptor<QList<QSslCertificate> >(QSslSocket::defaultCaCertificates ()));
}

static qt_gsi::GenericStaticMethod *_create_f_defaultCaCertificates_0 ()
{
  return new qt_gsi::GenericStaticMethod (":defaultCaCertificates", "@brief Static method QList<QSslCertificate> QSslSocket::defaultCaCertificates()\nThis method is static and can be called without an instance.", &_init_f_defaultCaCertificates_0, &_call_f_defaultCaCertificates_0);
}

// static QList<QSslCipher> QSslSocket::defaultCiphers()


static void _init_f_defaultCiphers_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QSslCipher> >::target_type > ();
}

static void _call_f_defaultCiphers_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QSslCipher> >::target_type > ((qt_gsi::Converter<QList<QSslCipher> >::target_type)qt_gsi::CppToQtAdaptor<QList<QSslCipher> >(QSslSocket::defaultCiphers ()));
}

static qt_gsi::GenericStaticMethod *_create_f_defaultCiphers_0 ()
{
  return new qt_gsi::GenericStaticMethod (":defaultCiphers", "@brief Static method QList<QSslCipher> QSslSocket::defaultCiphers()\nThis method is static and can be called without an instance.", &_init_f_defaultCiphers_0, &_call_f_defaultCiphers_0);
}

// static void QSslSocket::setDefaultCaCertificates(const QList<QSslCertificate> &certificates)


static void _init_f_setDefaultCaCertificates_3438 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("certificates");
  decl->add_arg<const qt_gsi::Converter<QList<QSslCertificate> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultCaCertificates_3438 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QSslCertificate> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QSslCertificate> >::target_type & > ();
  QSslSocket::setDefaultCaCertificates (qt_gsi::QtToCppAdaptor<QList<QSslCertificate> >(arg1).cref());
}

static qt_gsi::GenericStaticMethod *_create_f_setDefaultCaCertificates_3438 ()
{
  return new qt_gsi::GenericStaticMethod ("setDefaultCaCertificates|defaultCaCertificates=", "@brief Static method void QSslSocket::setDefaultCaCertificates(const QList<QSslCertificate> &certificates)\nThis method is static and can be called without an instance.", &_init_f_setDefaultCaCertificates_3438, &_call_f_setDefaultCaCertificates_3438);
}

// static void QSslSocket::setDefaultCiphers(const QList<QSslCipher> &ciphers)


static void _init_f_setDefaultCiphers_2918 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ciphers");
  decl->add_arg<const qt_gsi::Converter<QList<QSslCipher> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultCiphers_2918 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QSslCipher> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QSslCipher> >::target_type & > ();
  QSslSocket::setDefaultCiphers (qt_gsi::QtToCppAdaptor<QList<QSslCipher> >(arg1).cref());
}

static qt_gsi::GenericStaticMethod *_create_f_setDefaultCiphers_2918 ()
{
  return new qt_gsi::GenericStaticMethod ("setDefaultCiphers|defaultCiphers=", "@brief Static method void QSslSocket::setDefaultCiphers(const QList<QSslCipher> &ciphers)\nThis method is static and can be called without an instance.", &_init_f_setDefaultCiphers_2918, &_call_f_setDefaultCiphers_2918);
}

// static QList<QSslCipher> QSslSocket::supportedCiphers()


static void _init_f_supportedCiphers_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QSslCipher> >::target_type > ();
}

static void _call_f_supportedCiphers_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QSslCipher> >::target_type > ((qt_gsi::Converter<QList<QSslCipher> >::target_type)qt_gsi::CppToQtAdaptor<QList<QSslCipher> >(QSslSocket::supportedCiphers ()));
}

static qt_gsi::GenericStaticMethod *_create_f_supportedCiphers_0 ()
{
  return new qt_gsi::GenericStaticMethod ("supportedCiphers", "@brief Static method QList<QSslCipher> QSslSocket::supportedCiphers()\nThis method is static and can be called without an instance.", &_init_f_supportedCiphers_0, &_call_f_supportedCiphers_0);
}

// static bool QSslSocket::supportsSsl()


static void _init_f_supportsSsl_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_supportsSsl_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)QSslSocket::supportsSsl ());
}

static qt_gsi::GenericStaticMethod *_create_f_supportsSsl_0 ()
{
  return new qt_gsi::GenericStaticMethod ("supportsSsl", "@brief Static method bool QSslSocket::supportsSsl()\nThis method is static and can be called without an instance.", &_init_f_supportsSsl_0, &_call_f_supportsSsl_0);
}

// static QList<QSslCertificate> QSslSocket::systemCaCertificates()


static void _init_f_systemCaCertificates_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QSslCertificate> >::target_type > ();
}

static void _call_f_systemCaCertificates_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QSslCertificate> >::target_type > ((qt_gsi::Converter<QList<QSslCertificate> >::target_type)qt_gsi::CppToQtAdaptor<QList<QSslCertificate> >(QSslSocket::systemCaCertificates ()));
}

static qt_gsi::GenericStaticMethod *_create_f_systemCaCertificates_0 ()
{
  return new qt_gsi::GenericStaticMethod ("systemCaCertificates", "@brief Static method QList<QSslCertificate> QSslSocket::systemCaCertificates()\nThis method is static and can be called without an instance.", &_init_f_systemCaCertificates_0, &_call_f_systemCaCertificates_0);
}

// static QString QSslSocket::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QSslSocket::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSslSocket::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QSslSocket::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QSslSocket::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSslSocket::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QSslSocket::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QSslSocket::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSslSocket::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QSslSocket::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QSslSocket::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSslSocket::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QSslSocket, QSslSocket_EventAdaptor> ea_QSslSocket;


namespace gsi
{
extern gsi::Class<QTcpSocket> decl_QTcpSocket;

gsi::Class<QSslSocket> decl_QSslSocket (ea_QSslSocket, decl_QTcpSocket, "QSslSocket",
  gsi::Methods(_create_ctor_QSslSocket_1302 ()) +
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_abort_0 ()) +
  gsi::Methods(_create_f_addCaCertificate_2823 ()) +
  gsi::Methods(_create_f_addCaCertificates_6773 ()) +
  gsi::Methods(_create_f_addCaCertificates_3438 ()) +
  gsi::Methods(_create_f_atEnd_c0 ()) +
  gsi::Methods(_create_f_bytesAvailable_c0 ()) +
  gsi::Methods(_create_f_bytesToWrite_c0 ()) +
  gsi::Methods(_create_f_caCertificates_c0 ()) +
  gsi::Methods(_create_f_canReadLine_c0 ()) +
  gsi::Methods(_create_f_ciphers_c0 ()) +
  gsi::Methods(_create_f_close_0 ()) +
  gsi::Methods(_create_f_connectToHostEncrypted_6151 ()) +
  gsi::Methods(_create_f_connectToHostEncrypted_8068 ()) +
  gsi::Methods(_create_f_encryptedBytesAvailable_c0 ()) +
  gsi::Methods(_create_f_encryptedBytesToWrite_c0 ()) +
  gsi::Methods(_create_f_flush_0 ()) +
  gsi::Methods(_create_f_ignoreSslErrors_2837 ()) +
  gsi::Methods(_create_f_ignoreSslErrors_0 ()) +
  gsi::Methods(_create_f_isEncrypted_c0 ()) +
  gsi::Methods(_create_f_localCertificate_c0 ()) +
  gsi::Methods(_create_f_mode_c0 ()) +
  gsi::Methods(_create_f_peerCertificate_c0 ()) +
  gsi::Methods(_create_f_peerCertificateChain_c0 ()) +
  gsi::Methods(_create_f_peerVerifyDepth_c0 ()) +
  gsi::Methods(_create_f_peerVerifyMode_c0 ()) +
  gsi::Methods(_create_f_privateKey_c0 ()) +
  gsi::Methods(_create_f_protocol_c0 ()) +
  gsi::Methods(_create_f_sessionCipher_c0 ()) +
  gsi::Methods(_create_f_setCaCertificates_3438 ()) +
  gsi::Methods(_create_f_setCiphers_2918 ()) +
  gsi::Methods(_create_f_setCiphers_2025 ()) +
  gsi::Methods(_create_f_setLocalCertificate_2823 ()) +
  gsi::Methods(_create_f_setLocalCertificate_4280 ()) +
  gsi::Methods(_create_f_setPeerVerifyDepth_767 ()) +
  gsi::Methods(_create_f_setPeerVerifyMode_2970 ()) +
  gsi::Methods(_create_f_setPrivateKey_1997 ()) +
  gsi::Methods(_create_f_setPrivateKey_8544 ()) +
  gsi::Methods(_create_f_setProtocol_2095 ()) +
  gsi::Methods(_create_f_setReadBufferSize_986 ()) +
  gsi::Methods(_create_f_setSocketDescriptor_6993 ()) +
  gsi::Methods(_create_f_setSocketOption_5331 ()) +
  gsi::Methods(_create_f_setSslConfiguration_3068 ()) +
  gsi::Methods(_create_f_socketOption_3320 ()) +
  gsi::Methods(_create_f_sslConfiguration_c0 ()) +
  gsi::Methods(_create_f_sslErrors_c0 ()) +
  gsi::Methods(_create_f_startClientEncryption_0 ()) +
  gsi::Methods(_create_f_startServerEncryption_0 ()) +
  gsi::Methods(_create_f_waitForBytesWritten_767 ()) +
  gsi::Methods(_create_f_waitForConnected_767 ()) +
  gsi::Methods(_create_f_waitForDisconnected_767 ()) +
  gsi::Methods(_create_f_waitForEncrypted_767 ()) +
  gsi::Methods(_create_f_waitForReadyRead_767 ()) +
  qt_gsi::qt_signal<QSslSocket, QSslSocket_EventAdaptor> ("aboutToClose", &QSslSocket_EventAdaptor::aboutToClose_e_0, "@brief Signal declaration for QSslSocket::aboutToClose()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSslSocket, QSslSocket_EventAdaptor, qint64> ("bytesWritten", &QSslSocket_EventAdaptor::bytesWritten_e_986, gsi::arg("bytes"), "@brief Signal declaration for QSslSocket::bytesWritten(qint64 bytes)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSslSocket, QSslSocket_EventAdaptor> ("connected", &QSslSocket_EventAdaptor::connected_e_0, "@brief Signal declaration for QSslSocket::connected()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSslSocket, QSslSocket_EventAdaptor, QObject *> ("destroyed", &QSslSocket_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QSslSocket::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSslSocket, QSslSocket_EventAdaptor> ("disconnected", &QSslSocket_EventAdaptor::disconnected_e_0, "@brief Signal declaration for QSslSocket::disconnected()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSslSocket, QSslSocket_EventAdaptor> ("encrypted", &QSslSocket_EventAdaptor::encrypted_e_0, "@brief Signal declaration for QSslSocket::encrypted()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSslSocket, QSslSocket_EventAdaptor, qint64> ("encryptedBytesWritten", &QSslSocket_EventAdaptor::encryptedBytesWritten_e_986, gsi::arg("totalBytes"), "@brief Signal declaration for QSslSocket::encryptedBytesWritten(qint64 totalBytes)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSslSocket, QSslSocket_EventAdaptor, const qt_gsi::Converter<QAbstractSocket::SocketError>::target_type &> ("error", &QSslSocket_EventAdaptor::error_e_3209, gsi::arg("arg1"), "@brief Signal declaration for QSslSocket::error(QAbstractSocket::SocketError)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSslSocket, QSslSocket_EventAdaptor> ("hostFound", &QSslSocket_EventAdaptor::hostFound_e_0, "@brief Signal declaration for QSslSocket::hostFound()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSslSocket, QSslSocket_EventAdaptor, const qt_gsi::Converter<QSslSocket::SslMode>::target_type &> ("modeChanged", &QSslSocket_EventAdaptor::modeChanged_e_2251, gsi::arg("newMode"), "@brief Signal declaration for QSslSocket::modeChanged(QSslSocket::SslMode newMode)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSslSocket, QSslSocket_EventAdaptor, const QSslError &> ("peerVerifyError", &QSslSocket_EventAdaptor::peerVerifyError_e_2222, gsi::arg("error"), "@brief Signal declaration for QSslSocket::peerVerifyError(const QSslError &error)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSslSocket, QSslSocket_EventAdaptor, const QNetworkProxy &, QAuthenticator *> ("proxyAuthenticationRequired", &QSslSocket_EventAdaptor::proxyAuthenticationRequired_e_4652, gsi::arg("proxy"), gsi::arg("authenticator"), "@brief Signal declaration for QSslSocket::proxyAuthenticationRequired(const QNetworkProxy &proxy, QAuthenticator *authenticator)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSslSocket, QSslSocket_EventAdaptor> ("readChannelFinished", &QSslSocket_EventAdaptor::readChannelFinished_e_0, "@brief Signal declaration for QSslSocket::readChannelFinished()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSslSocket, QSslSocket_EventAdaptor> ("readyRead", &QSslSocket_EventAdaptor::readyRead_e_0, "@brief Signal declaration for QSslSocket::readyRead()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSslSocket, QSslSocket_EventAdaptor, const qt_gsi::Converter<QList<QSslError> >::target_type &> ("sslErrors", &QSslSocket_EventAdaptor::sslErrors_e_2837, gsi::arg("errors"), "@brief Signal declaration for QSslSocket::sslErrors(const QList<QSslError> &errors)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSslSocket, QSslSocket_EventAdaptor, const qt_gsi::Converter<QAbstractSocket::SocketState>::target_type &> ("stateChanged", &QSslSocket_EventAdaptor::stateChanged_e_3200, gsi::arg("arg1"), "@brief Signal declaration for QSslSocket::stateChanged(QAbstractSocket::SocketState)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_addDefaultCaCertificate_2823 ()) +
  gsi::Methods(_create_f_addDefaultCaCertificates_6773 ()) +
  gsi::Methods(_create_f_addDefaultCaCertificates_3438 ()) +
  gsi::Methods(_create_f_defaultCaCertificates_0 ()) +
  gsi::Methods(_create_f_defaultCiphers_0 ()) +
  gsi::Methods(_create_f_setDefaultCaCertificates_3438 ()) +
  gsi::Methods(_create_f_setDefaultCiphers_2918 ()) +
  gsi::Methods(_create_f_supportedCiphers_0 ()) +
  gsi::Methods(_create_f_supportsSsl_0 ()) +
  gsi::Methods(_create_f_systemCaCertificates_0 ()) +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@qt\n@brief Binding of QSslSocket");

}


//  Implementation of the enum wrapper class for QSslSocket::PeerVerifyMode
namespace qt_gsi
{

static QSslSocket_PeerVerifyMode_Enum *c_1_QSslSocket_PeerVerifyMode_Enum () { return new QSslSocket_PeerVerifyMode_Enum (QSslSocket::VerifyNone); }
static QSslSocket_PeerVerifyMode_Enum *c_2_QSslSocket_PeerVerifyMode_Enum () { return new QSslSocket_PeerVerifyMode_Enum (QSslSocket::QueryPeer); }
static QSslSocket_PeerVerifyMode_Enum *c_3_QSslSocket_PeerVerifyMode_Enum () { return new QSslSocket_PeerVerifyMode_Enum (QSslSocket::VerifyPeer); }
static QSslSocket_PeerVerifyMode_Enum *c_4_QSslSocket_PeerVerifyMode_Enum () { return new QSslSocket_PeerVerifyMode_Enum (QSslSocket::AutoVerifyPeer); }

static gsi::Methods mkdefs_QSslSocket_PeerVerifyMode () {
  return
    gsi::constant ("VerifyNone", &qt_gsi::c_1_QSslSocket_PeerVerifyMode_Enum, "@brief Enum constant QSslSocket::VerifyNone") +
    gsi::constant ("QueryPeer", &qt_gsi::c_2_QSslSocket_PeerVerifyMode_Enum, "@brief Enum constant QSslSocket::QueryPeer") +
    gsi::constant ("VerifyPeer", &qt_gsi::c_3_QSslSocket_PeerVerifyMode_Enum, "@brief Enum constant QSslSocket::VerifyPeer") +
    gsi::constant ("AutoVerifyPeer", &qt_gsi::c_4_QSslSocket_PeerVerifyMode_Enum, "@brief Enum constant QSslSocket::AutoVerifyPeer");
}

static std::string to_s_QSslSocket_PeerVerifyMode_Enum (const QSslSocket_PeerVerifyMode_Enum *e)
{
  if (e->value () == QSslSocket::VerifyNone) { return tl::sprintf ("VerifyNone (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSslSocket::QueryPeer) { return tl::sprintf ("QueryPeer (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSslSocket::VerifyPeer) { return tl::sprintf ("VerifyPeer (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSslSocket::AutoVerifyPeer) { return tl::sprintf ("AutoVerifyPeer (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSslSocket_PeerVerifyMode_Enum (const QSslSocket_PeerVerifyMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSslSocket_PeerVerifyMode_Enum *from_i_QSslSocket_PeerVerifyMode_Enum (unsigned int i)
{
  return new QSslSocket_PeerVerifyMode_Enum ((QSslSocket::PeerVerifyMode) i);
}

static bool equalQSslSocket_PeerVerifyMode_Enum (const QSslSocket_PeerVerifyMode_Enum *e, QSslSocket_PeerVerifyMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSslSocket_PeerVerifyMode_Enum (const QSslSocket_PeerVerifyMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSslSocket_PeerVerifyMode_Enums oropQSslSocket_PeerVerifyMode_Enums (const QSslSocket_PeerVerifyMode_Enums *e, const QSslSocket_PeerVerifyMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSslSocket_PeerVerifyMode_Enums andopQSslSocket_PeerVerifyMode_Enums (const QSslSocket_PeerVerifyMode_Enums *e, const QSslSocket_PeerVerifyMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSslSocket_PeerVerifyMode_Enums xoropQSslSocket_PeerVerifyMode_Enums (const QSslSocket_PeerVerifyMode_Enums *e, const QSslSocket_PeerVerifyMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSslSocket_PeerVerifyMode_Enums (const QSslSocket_PeerVerifyMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QSslSocket::VerifyNone)) { if (!l.empty ()) l += "|"; l += "VerifyNone"; }
  if (e->testFlag (QSslSocket::QueryPeer)) { if (!l.empty ()) l += "|"; l += "QueryPeer"; }
  if (e->testFlag (QSslSocket::VerifyPeer)) { if (!l.empty ()) l += "|"; l += "VerifyPeer"; }
  if (e->testFlag (QSslSocket::AutoVerifyPeer)) { if (!l.empty ()) l += "|"; l += "AutoVerifyPeer"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSslSocket_PeerVerifyMode_Enums (const QSslSocket_PeerVerifyMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSslSocket_PeerVerifyMode_Enums (const QSslSocket_PeerVerifyMode_Enums *e, const QSslSocket_PeerVerifyMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSslSocket_PeerVerifyMode_Enums> decl_QSslSocket_PeerVerifyMode_Enums ("QSslSocket_QFlags_PeerVerifyMode",
  gsi::method_ext ("|", &qt_gsi::oropQSslSocket_PeerVerifyMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSslSocket_PeerVerifyMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSslSocket_PeerVerifyMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSslSocket_PeerVerifyMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSslSocket_PeerVerifyMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSslSocket_PeerVerifyMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSslSocket::PeerVerifyMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSslSocket_PeerVerifyMode_Enum> decl_QSslSocket_PeerVerifyMode_Enum (decl_QSslSocket_PeerVerifyMode_Enums, "QSslSocket_PeerVerifyMode",
  qt_gsi::mkdefs_QSslSocket_PeerVerifyMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSslSocket_PeerVerifyMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSslSocket_PeerVerifyMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSslSocket_PeerVerifyMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSslSocket_PeerVerifyMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSslSocket_PeerVerifyMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSslSocket::PeerVerifyMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSslSocket> inject_QSslSocket_PeerVerifyMode_Enum_in_parent (qt_gsi::mkdefs_QSslSocket_PeerVerifyMode ());
static gsi::ClassExt<QSslSocket> decl_QSslSocket_PeerVerifyMode_Enum_as_child (decl_QSslSocket_PeerVerifyMode_Enum, "PeerVerifyMode");

}


//  Implementation of the enum wrapper class for QSslSocket::SslMode
namespace qt_gsi
{

static QSslSocket_SslMode_Enum *c_1_QSslSocket_SslMode_Enum () { return new QSslSocket_SslMode_Enum (QSslSocket::UnencryptedMode); }
static QSslSocket_SslMode_Enum *c_2_QSslSocket_SslMode_Enum () { return new QSslSocket_SslMode_Enum (QSslSocket::SslClientMode); }
static QSslSocket_SslMode_Enum *c_3_QSslSocket_SslMode_Enum () { return new QSslSocket_SslMode_Enum (QSslSocket::SslServerMode); }

static gsi::Methods mkdefs_QSslSocket_SslMode () {
  return
    gsi::constant ("UnencryptedMode", &qt_gsi::c_1_QSslSocket_SslMode_Enum, "@brief Enum constant QSslSocket::UnencryptedMode") +
    gsi::constant ("SslClientMode", &qt_gsi::c_2_QSslSocket_SslMode_Enum, "@brief Enum constant QSslSocket::SslClientMode") +
    gsi::constant ("SslServerMode", &qt_gsi::c_3_QSslSocket_SslMode_Enum, "@brief Enum constant QSslSocket::SslServerMode");
}

static std::string to_s_QSslSocket_SslMode_Enum (const QSslSocket_SslMode_Enum *e)
{
  if (e->value () == QSslSocket::UnencryptedMode) { return tl::sprintf ("UnencryptedMode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSslSocket::SslClientMode) { return tl::sprintf ("SslClientMode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSslSocket::SslServerMode) { return tl::sprintf ("SslServerMode (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSslSocket_SslMode_Enum (const QSslSocket_SslMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSslSocket_SslMode_Enum *from_i_QSslSocket_SslMode_Enum (unsigned int i)
{
  return new QSslSocket_SslMode_Enum ((QSslSocket::SslMode) i);
}

static bool equalQSslSocket_SslMode_Enum (const QSslSocket_SslMode_Enum *e, QSslSocket_SslMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSslSocket_SslMode_Enum (const QSslSocket_SslMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSslSocket_SslMode_Enums oropQSslSocket_SslMode_Enums (const QSslSocket_SslMode_Enums *e, const QSslSocket_SslMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSslSocket_SslMode_Enums andopQSslSocket_SslMode_Enums (const QSslSocket_SslMode_Enums *e, const QSslSocket_SslMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSslSocket_SslMode_Enums xoropQSslSocket_SslMode_Enums (const QSslSocket_SslMode_Enums *e, const QSslSocket_SslMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSslSocket_SslMode_Enums (const QSslSocket_SslMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QSslSocket::UnencryptedMode)) { if (!l.empty ()) l += "|"; l += "UnencryptedMode"; }
  if (e->testFlag (QSslSocket::SslClientMode)) { if (!l.empty ()) l += "|"; l += "SslClientMode"; }
  if (e->testFlag (QSslSocket::SslServerMode)) { if (!l.empty ()) l += "|"; l += "SslServerMode"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSslSocket_SslMode_Enums (const QSslSocket_SslMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSslSocket_SslMode_Enums (const QSslSocket_SslMode_Enums *e, const QSslSocket_SslMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSslSocket_SslMode_Enums> decl_QSslSocket_SslMode_Enums ("QSslSocket_QFlags_SslMode",
  gsi::method_ext ("|", &qt_gsi::oropQSslSocket_SslMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSslSocket_SslMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSslSocket_SslMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSslSocket_SslMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSslSocket_SslMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSslSocket_SslMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSslSocket::SslMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSslSocket_SslMode_Enum> decl_QSslSocket_SslMode_Enum (decl_QSslSocket_SslMode_Enums, "QSslSocket_SslMode",
  qt_gsi::mkdefs_QSslSocket_SslMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSslSocket_SslMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSslSocket_SslMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSslSocket_SslMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSslSocket_SslMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSslSocket_SslMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSslSocket::SslMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSslSocket> inject_QSslSocket_SslMode_Enum_in_parent (qt_gsi::mkdefs_QSslSocket_SslMode ());
static gsi::ClassExt<QSslSocket> decl_QSslSocket_SslMode_Enum_as_child (decl_QSslSocket_SslMode_Enum, "SslMode");

}

