
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSsl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtNetwork.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQSsl_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// namespace QSsl

class QSsl_Namespace { };

namespace gsi
{
gsi::Class<QSsl_Namespace> decl_QSsl_Namespace ("QSsl",
  gsi::Methods(),
  "@qt\n@brief This class represents the QSsl namespace");
}


//  Implementation of the enum wrapper class for QSsl::AlternateNameEntryType
namespace qt_gsi
{

static QSsl_AlternateNameEntryType_Enum *c_1_QSsl_AlternateNameEntryType_Enum () { return new QSsl_AlternateNameEntryType_Enum (QSsl::EmailEntry); }
static QSsl_AlternateNameEntryType_Enum *c_2_QSsl_AlternateNameEntryType_Enum () { return new QSsl_AlternateNameEntryType_Enum (QSsl::DnsEntry); }

static gsi::Methods mkdefs_QSsl_AlternateNameEntryType () {
  return
    gsi::constant ("EmailEntry", &qt_gsi::c_1_QSsl_AlternateNameEntryType_Enum, "@brief Enum constant QSsl::EmailEntry") +
    gsi::constant ("DnsEntry", &qt_gsi::c_2_QSsl_AlternateNameEntryType_Enum, "@brief Enum constant QSsl::DnsEntry");
}

static std::string to_s_QSsl_AlternateNameEntryType_Enum (const QSsl_AlternateNameEntryType_Enum *e)
{
  if (e->value () == QSsl::EmailEntry) { return tl::sprintf ("EmailEntry (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSsl::DnsEntry) { return tl::sprintf ("DnsEntry (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSsl_AlternateNameEntryType_Enum (const QSsl_AlternateNameEntryType_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSsl_AlternateNameEntryType_Enum *from_i_QSsl_AlternateNameEntryType_Enum (unsigned int i)
{
  return new QSsl_AlternateNameEntryType_Enum ((QSsl::AlternateNameEntryType) i);
}

static bool equalQSsl_AlternateNameEntryType_Enum (const QSsl_AlternateNameEntryType_Enum *e, QSsl_AlternateNameEntryType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSsl_AlternateNameEntryType_Enum (const QSsl_AlternateNameEntryType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSsl_AlternateNameEntryType_Enums oropQSsl_AlternateNameEntryType_Enums (const QSsl_AlternateNameEntryType_Enums *e, const QSsl_AlternateNameEntryType_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSsl_AlternateNameEntryType_Enums andopQSsl_AlternateNameEntryType_Enums (const QSsl_AlternateNameEntryType_Enums *e, const QSsl_AlternateNameEntryType_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSsl_AlternateNameEntryType_Enums xoropQSsl_AlternateNameEntryType_Enums (const QSsl_AlternateNameEntryType_Enums *e, const QSsl_AlternateNameEntryType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSsl_AlternateNameEntryType_Enums (const QSsl_AlternateNameEntryType_Enums *e)
{
  std::string l;
  if (e->testFlag (QSsl::EmailEntry)) { if (!l.empty ()) l += "|"; l += "EmailEntry"; }
  if (e->testFlag (QSsl::DnsEntry)) { if (!l.empty ()) l += "|"; l += "DnsEntry"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSsl_AlternateNameEntryType_Enums (const QSsl_AlternateNameEntryType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSsl_AlternateNameEntryType_Enums (const QSsl_AlternateNameEntryType_Enums *e, const QSsl_AlternateNameEntryType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSsl_AlternateNameEntryType_Enums> decl_QSsl_AlternateNameEntryType_Enums ("QSsl_QFlags_AlternateNameEntryType",
  gsi::method_ext ("|", &qt_gsi::oropQSsl_AlternateNameEntryType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSsl_AlternateNameEntryType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSsl_AlternateNameEntryType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSsl_AlternateNameEntryType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSsl_AlternateNameEntryType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSsl_AlternateNameEntryType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSsl::AlternateNameEntryType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSsl_AlternateNameEntryType_Enum> decl_QSsl_AlternateNameEntryType_Enum (decl_QSsl_AlternateNameEntryType_Enums, "QSsl_AlternateNameEntryType",
  qt_gsi::mkdefs_QSsl_AlternateNameEntryType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSsl_AlternateNameEntryType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSsl_AlternateNameEntryType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSsl_AlternateNameEntryType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSsl_AlternateNameEntryType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSsl_AlternateNameEntryType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSsl::AlternateNameEntryType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSsl_Namespace> inject_QSsl_AlternateNameEntryType_Enum_in_parent (qt_gsi::mkdefs_QSsl_AlternateNameEntryType ());
static gsi::ClassExt<QSsl_Namespace> decl_QSsl_AlternateNameEntryType_Enum_as_child (decl_QSsl_AlternateNameEntryType_Enum, "AlternateNameEntryType");

}


//  Implementation of the enum wrapper class for QSsl::EncodingFormat
namespace qt_gsi
{

static QSsl_EncodingFormat_Enum *c_1_QSsl_EncodingFormat_Enum () { return new QSsl_EncodingFormat_Enum (QSsl::Pem); }
static QSsl_EncodingFormat_Enum *c_2_QSsl_EncodingFormat_Enum () { return new QSsl_EncodingFormat_Enum (QSsl::Der); }

static gsi::Methods mkdefs_QSsl_EncodingFormat () {
  return
    gsi::constant ("Pem", &qt_gsi::c_1_QSsl_EncodingFormat_Enum, "@brief Enum constant QSsl::Pem") +
    gsi::constant ("Der", &qt_gsi::c_2_QSsl_EncodingFormat_Enum, "@brief Enum constant QSsl::Der");
}

static std::string to_s_QSsl_EncodingFormat_Enum (const QSsl_EncodingFormat_Enum *e)
{
  if (e->value () == QSsl::Pem) { return tl::sprintf ("Pem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSsl::Der) { return tl::sprintf ("Der (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSsl_EncodingFormat_Enum (const QSsl_EncodingFormat_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSsl_EncodingFormat_Enum *from_i_QSsl_EncodingFormat_Enum (unsigned int i)
{
  return new QSsl_EncodingFormat_Enum ((QSsl::EncodingFormat) i);
}

static bool equalQSsl_EncodingFormat_Enum (const QSsl_EncodingFormat_Enum *e, QSsl_EncodingFormat_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSsl_EncodingFormat_Enum (const QSsl_EncodingFormat_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSsl_EncodingFormat_Enums oropQSsl_EncodingFormat_Enums (const QSsl_EncodingFormat_Enums *e, const QSsl_EncodingFormat_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSsl_EncodingFormat_Enums andopQSsl_EncodingFormat_Enums (const QSsl_EncodingFormat_Enums *e, const QSsl_EncodingFormat_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSsl_EncodingFormat_Enums xoropQSsl_EncodingFormat_Enums (const QSsl_EncodingFormat_Enums *e, const QSsl_EncodingFormat_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSsl_EncodingFormat_Enums (const QSsl_EncodingFormat_Enums *e)
{
  std::string l;
  if (e->testFlag (QSsl::Pem)) { if (!l.empty ()) l += "|"; l += "Pem"; }
  if (e->testFlag (QSsl::Der)) { if (!l.empty ()) l += "|"; l += "Der"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSsl_EncodingFormat_Enums (const QSsl_EncodingFormat_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSsl_EncodingFormat_Enums (const QSsl_EncodingFormat_Enums *e, const QSsl_EncodingFormat_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSsl_EncodingFormat_Enums> decl_QSsl_EncodingFormat_Enums ("QSsl_QFlags_EncodingFormat",
  gsi::method_ext ("|", &qt_gsi::oropQSsl_EncodingFormat_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSsl_EncodingFormat_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSsl_EncodingFormat_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSsl_EncodingFormat_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSsl_EncodingFormat_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSsl_EncodingFormat_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSsl::EncodingFormat> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSsl_EncodingFormat_Enum> decl_QSsl_EncodingFormat_Enum (decl_QSsl_EncodingFormat_Enums, "QSsl_EncodingFormat",
  qt_gsi::mkdefs_QSsl_EncodingFormat () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSsl_EncodingFormat_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSsl_EncodingFormat_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSsl_EncodingFormat_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSsl_EncodingFormat_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSsl_EncodingFormat_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSsl::EncodingFormat enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSsl_Namespace> inject_QSsl_EncodingFormat_Enum_in_parent (qt_gsi::mkdefs_QSsl_EncodingFormat ());
static gsi::ClassExt<QSsl_Namespace> decl_QSsl_EncodingFormat_Enum_as_child (decl_QSsl_EncodingFormat_Enum, "EncodingFormat");

}


//  Implementation of the enum wrapper class for QSsl::KeyAlgorithm
namespace qt_gsi
{

static QSsl_KeyAlgorithm_Enum *c_1_QSsl_KeyAlgorithm_Enum () { return new QSsl_KeyAlgorithm_Enum (QSsl::Rsa); }
static QSsl_KeyAlgorithm_Enum *c_2_QSsl_KeyAlgorithm_Enum () { return new QSsl_KeyAlgorithm_Enum (QSsl::Dsa); }

static gsi::Methods mkdefs_QSsl_KeyAlgorithm () {
  return
    gsi::constant ("Rsa", &qt_gsi::c_1_QSsl_KeyAlgorithm_Enum, "@brief Enum constant QSsl::Rsa") +
    gsi::constant ("Dsa", &qt_gsi::c_2_QSsl_KeyAlgorithm_Enum, "@brief Enum constant QSsl::Dsa");
}

static std::string to_s_QSsl_KeyAlgorithm_Enum (const QSsl_KeyAlgorithm_Enum *e)
{
  if (e->value () == QSsl::Rsa) { return tl::sprintf ("Rsa (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSsl::Dsa) { return tl::sprintf ("Dsa (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSsl_KeyAlgorithm_Enum (const QSsl_KeyAlgorithm_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSsl_KeyAlgorithm_Enum *from_i_QSsl_KeyAlgorithm_Enum (unsigned int i)
{
  return new QSsl_KeyAlgorithm_Enum ((QSsl::KeyAlgorithm) i);
}

static bool equalQSsl_KeyAlgorithm_Enum (const QSsl_KeyAlgorithm_Enum *e, QSsl_KeyAlgorithm_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSsl_KeyAlgorithm_Enum (const QSsl_KeyAlgorithm_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSsl_KeyAlgorithm_Enums oropQSsl_KeyAlgorithm_Enums (const QSsl_KeyAlgorithm_Enums *e, const QSsl_KeyAlgorithm_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSsl_KeyAlgorithm_Enums andopQSsl_KeyAlgorithm_Enums (const QSsl_KeyAlgorithm_Enums *e, const QSsl_KeyAlgorithm_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSsl_KeyAlgorithm_Enums xoropQSsl_KeyAlgorithm_Enums (const QSsl_KeyAlgorithm_Enums *e, const QSsl_KeyAlgorithm_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSsl_KeyAlgorithm_Enums (const QSsl_KeyAlgorithm_Enums *e)
{
  std::string l;
  if (e->testFlag (QSsl::Rsa)) { if (!l.empty ()) l += "|"; l += "Rsa"; }
  if (e->testFlag (QSsl::Dsa)) { if (!l.empty ()) l += "|"; l += "Dsa"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSsl_KeyAlgorithm_Enums (const QSsl_KeyAlgorithm_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSsl_KeyAlgorithm_Enums (const QSsl_KeyAlgorithm_Enums *e, const QSsl_KeyAlgorithm_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSsl_KeyAlgorithm_Enums> decl_QSsl_KeyAlgorithm_Enums ("QSsl_QFlags_KeyAlgorithm",
  gsi::method_ext ("|", &qt_gsi::oropQSsl_KeyAlgorithm_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSsl_KeyAlgorithm_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSsl_KeyAlgorithm_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSsl_KeyAlgorithm_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSsl_KeyAlgorithm_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSsl_KeyAlgorithm_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSsl::KeyAlgorithm> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSsl_KeyAlgorithm_Enum> decl_QSsl_KeyAlgorithm_Enum (decl_QSsl_KeyAlgorithm_Enums, "QSsl_KeyAlgorithm",
  qt_gsi::mkdefs_QSsl_KeyAlgorithm () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSsl_KeyAlgorithm_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSsl_KeyAlgorithm_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSsl_KeyAlgorithm_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSsl_KeyAlgorithm_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSsl_KeyAlgorithm_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSsl::KeyAlgorithm enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSsl_Namespace> inject_QSsl_KeyAlgorithm_Enum_in_parent (qt_gsi::mkdefs_QSsl_KeyAlgorithm ());
static gsi::ClassExt<QSsl_Namespace> decl_QSsl_KeyAlgorithm_Enum_as_child (decl_QSsl_KeyAlgorithm_Enum, "KeyAlgorithm");

}


//  Implementation of the enum wrapper class for QSsl::KeyType
namespace qt_gsi
{

static QSsl_KeyType_Enum *c_1_QSsl_KeyType_Enum () { return new QSsl_KeyType_Enum (QSsl::PrivateKey); }
static QSsl_KeyType_Enum *c_2_QSsl_KeyType_Enum () { return new QSsl_KeyType_Enum (QSsl::PublicKey); }

static gsi::Methods mkdefs_QSsl_KeyType () {
  return
    gsi::constant ("PrivateKey", &qt_gsi::c_1_QSsl_KeyType_Enum, "@brief Enum constant QSsl::PrivateKey") +
    gsi::constant ("PublicKey", &qt_gsi::c_2_QSsl_KeyType_Enum, "@brief Enum constant QSsl::PublicKey");
}

static std::string to_s_QSsl_KeyType_Enum (const QSsl_KeyType_Enum *e)
{
  if (e->value () == QSsl::PrivateKey) { return tl::sprintf ("PrivateKey (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSsl::PublicKey) { return tl::sprintf ("PublicKey (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSsl_KeyType_Enum (const QSsl_KeyType_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSsl_KeyType_Enum *from_i_QSsl_KeyType_Enum (unsigned int i)
{
  return new QSsl_KeyType_Enum ((QSsl::KeyType) i);
}

static bool equalQSsl_KeyType_Enum (const QSsl_KeyType_Enum *e, QSsl_KeyType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSsl_KeyType_Enum (const QSsl_KeyType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSsl_KeyType_Enums oropQSsl_KeyType_Enums (const QSsl_KeyType_Enums *e, const QSsl_KeyType_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSsl_KeyType_Enums andopQSsl_KeyType_Enums (const QSsl_KeyType_Enums *e, const QSsl_KeyType_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSsl_KeyType_Enums xoropQSsl_KeyType_Enums (const QSsl_KeyType_Enums *e, const QSsl_KeyType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSsl_KeyType_Enums (const QSsl_KeyType_Enums *e)
{
  std::string l;
  if (e->testFlag (QSsl::PrivateKey)) { if (!l.empty ()) l += "|"; l += "PrivateKey"; }
  if (e->testFlag (QSsl::PublicKey)) { if (!l.empty ()) l += "|"; l += "PublicKey"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSsl_KeyType_Enums (const QSsl_KeyType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSsl_KeyType_Enums (const QSsl_KeyType_Enums *e, const QSsl_KeyType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSsl_KeyType_Enums> decl_QSsl_KeyType_Enums ("QSsl_QFlags_KeyType",
  gsi::method_ext ("|", &qt_gsi::oropQSsl_KeyType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSsl_KeyType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSsl_KeyType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSsl_KeyType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSsl_KeyType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSsl_KeyType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSsl::KeyType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSsl_KeyType_Enum> decl_QSsl_KeyType_Enum (decl_QSsl_KeyType_Enums, "QSsl_KeyType",
  qt_gsi::mkdefs_QSsl_KeyType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSsl_KeyType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSsl_KeyType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSsl_KeyType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSsl_KeyType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSsl_KeyType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSsl::KeyType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSsl_Namespace> inject_QSsl_KeyType_Enum_in_parent (qt_gsi::mkdefs_QSsl_KeyType ());
static gsi::ClassExt<QSsl_Namespace> decl_QSsl_KeyType_Enum_as_child (decl_QSsl_KeyType_Enum, "KeyType");

}


//  Implementation of the enum wrapper class for QSsl::SslProtocol
namespace qt_gsi
{

static QSsl_SslProtocol_Enum *c_1_QSsl_SslProtocol_Enum () { return new QSsl_SslProtocol_Enum (QSsl::SslV3); }
static QSsl_SslProtocol_Enum *c_2_QSsl_SslProtocol_Enum () { return new QSsl_SslProtocol_Enum (QSsl::SslV2); }
static QSsl_SslProtocol_Enum *c_3_QSsl_SslProtocol_Enum () { return new QSsl_SslProtocol_Enum (QSsl::TlsV1); }
static QSsl_SslProtocol_Enum *c_4_QSsl_SslProtocol_Enum () { return new QSsl_SslProtocol_Enum (QSsl::AnyProtocol); }
static QSsl_SslProtocol_Enum *c_5_QSsl_SslProtocol_Enum () { return new QSsl_SslProtocol_Enum (QSsl::UnknownProtocol); }

static gsi::Methods mkdefs_QSsl_SslProtocol () {
  return
    gsi::constant ("SslV3", &qt_gsi::c_1_QSsl_SslProtocol_Enum, "@brief Enum constant QSsl::SslV3") +
    gsi::constant ("SslV2", &qt_gsi::c_2_QSsl_SslProtocol_Enum, "@brief Enum constant QSsl::SslV2") +
    gsi::constant ("TlsV1", &qt_gsi::c_3_QSsl_SslProtocol_Enum, "@brief Enum constant QSsl::TlsV1") +
    gsi::constant ("AnyProtocol", &qt_gsi::c_4_QSsl_SslProtocol_Enum, "@brief Enum constant QSsl::AnyProtocol") +
    gsi::constant ("UnknownProtocol", &qt_gsi::c_5_QSsl_SslProtocol_Enum, "@brief Enum constant QSsl::UnknownProtocol");
}

static std::string to_s_QSsl_SslProtocol_Enum (const QSsl_SslProtocol_Enum *e)
{
  if (e->value () == QSsl::SslV3) { return tl::sprintf ("SslV3 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSsl::SslV2) { return tl::sprintf ("SslV2 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSsl::TlsV1) { return tl::sprintf ("TlsV1 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSsl::AnyProtocol) { return tl::sprintf ("AnyProtocol (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSsl::UnknownProtocol) { return tl::sprintf ("UnknownProtocol (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSsl_SslProtocol_Enum (const QSsl_SslProtocol_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSsl_SslProtocol_Enum *from_i_QSsl_SslProtocol_Enum (unsigned int i)
{
  return new QSsl_SslProtocol_Enum ((QSsl::SslProtocol) i);
}

static bool equalQSsl_SslProtocol_Enum (const QSsl_SslProtocol_Enum *e, QSsl_SslProtocol_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSsl_SslProtocol_Enum (const QSsl_SslProtocol_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSsl_SslProtocol_Enums oropQSsl_SslProtocol_Enums (const QSsl_SslProtocol_Enums *e, const QSsl_SslProtocol_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSsl_SslProtocol_Enums andopQSsl_SslProtocol_Enums (const QSsl_SslProtocol_Enums *e, const QSsl_SslProtocol_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSsl_SslProtocol_Enums xoropQSsl_SslProtocol_Enums (const QSsl_SslProtocol_Enums *e, const QSsl_SslProtocol_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSsl_SslProtocol_Enums (const QSsl_SslProtocol_Enums *e)
{
  std::string l;
  if (e->testFlag (QSsl::SslV3)) { if (!l.empty ()) l += "|"; l += "SslV3"; }
  if (e->testFlag (QSsl::SslV2)) { if (!l.empty ()) l += "|"; l += "SslV2"; }
  if (e->testFlag (QSsl::TlsV1)) { if (!l.empty ()) l += "|"; l += "TlsV1"; }
  if (e->testFlag (QSsl::AnyProtocol)) { if (!l.empty ()) l += "|"; l += "AnyProtocol"; }
  if (e->testFlag (QSsl::UnknownProtocol)) { if (!l.empty ()) l += "|"; l += "UnknownProtocol"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSsl_SslProtocol_Enums (const QSsl_SslProtocol_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSsl_SslProtocol_Enums (const QSsl_SslProtocol_Enums *e, const QSsl_SslProtocol_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSsl_SslProtocol_Enums> decl_QSsl_SslProtocol_Enums ("QSsl_QFlags_SslProtocol",
  gsi::method_ext ("|", &qt_gsi::oropQSsl_SslProtocol_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSsl_SslProtocol_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSsl_SslProtocol_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSsl_SslProtocol_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSsl_SslProtocol_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSsl_SslProtocol_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSsl::SslProtocol> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSsl_SslProtocol_Enum> decl_QSsl_SslProtocol_Enum (decl_QSsl_SslProtocol_Enums, "QSsl_SslProtocol",
  qt_gsi::mkdefs_QSsl_SslProtocol () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSsl_SslProtocol_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSsl_SslProtocol_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSsl_SslProtocol_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSsl_SslProtocol_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSsl_SslProtocol_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSsl::SslProtocol enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSsl_Namespace> inject_QSsl_SslProtocol_Enum_in_parent (qt_gsi::mkdefs_QSsl_SslProtocol ());
static gsi::ClassExt<QSsl_Namespace> decl_QSsl_SslProtocol_Enum_as_child (decl_QSsl_SslProtocol_Enum, "SslProtocol");

}

