
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSqlDriver.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtSql.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQSqlDriver_EventAdaptor.h"
#include "gsiDeclQSqlDriver_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSqlDriver

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QSqlDriver::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// bool QSqlDriver::beginTransaction()


static void _init_f_beginTransaction_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_beginTransaction_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlDriver *)cls)->beginTransaction ());
}

static qt_gsi::GenericMethod *_create_f_beginTransaction_0 ()
{
  return new qt_gsi::GenericMethod ("beginTransaction", "@brief Method bool QSqlDriver::beginTransaction()\n", false, &_init_f_beginTransaction_0, &_call_f_beginTransaction_0);
}

// void QSqlDriver::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSqlDriver *)cls)->close ();
}

static qt_gsi::GenericMethod *_create_f_close_0 ()
{
  return new qt_gsi::GenericMethod ("close", "@brief Method void QSqlDriver::close()\n", false, &_init_f_close_0, &_call_f_close_0);
}

// bool QSqlDriver::commitTransaction()


static void _init_f_commitTransaction_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_commitTransaction_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlDriver *)cls)->commitTransaction ());
}

static qt_gsi::GenericMethod *_create_f_commitTransaction_0 ()
{
  return new qt_gsi::GenericMethod ("commitTransaction", "@brief Method bool QSqlDriver::commitTransaction()\n", false, &_init_f_commitTransaction_0, &_call_f_commitTransaction_0);
}

// QSqlResult *QSqlDriver::createResult()


static void _init_f_createResult_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSqlResult * > ();
}

static void _call_f_createResult_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSqlResult * > ((QSqlResult *)((QSqlDriver *)cls)->createResult ());
}

static qt_gsi::GenericMethod *_create_f_createResult_c0 ()
{
  return new qt_gsi::GenericMethod ("createResult", "@brief Method QSqlResult *QSqlDriver::createResult()\n", true, &_init_f_createResult_c0, &_call_f_createResult_c0);
}

// QString QSqlDriver::escapeIdentifier(const QString &identifier, QSqlDriver::IdentifierType type)


static void _init_f_escapeIdentifier_c4919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("identifier");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_escapeIdentifier_c4919 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & arg2 = args.read<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > ();
  ret.write<QString > ((QString)((QSqlDriver *)cls)->escapeIdentifier (arg1, qt_gsi::QtToCppAdaptor<QSqlDriver::IdentifierType>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_escapeIdentifier_c4919 ()
{
  return new qt_gsi::GenericMethod ("escapeIdentifier", "@brief Method QString QSqlDriver::escapeIdentifier(const QString &identifier, QSqlDriver::IdentifierType type)\n", true, &_init_f_escapeIdentifier_c4919, &_call_f_escapeIdentifier_c4919);
}

// QString QSqlDriver::formatValue(const QSqlField &field, bool trimStrings)


static void _init_f_formatValue_c2938 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("field");
  decl->add_arg<const QSqlField & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("trimStrings", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_formatValue_c2938 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSqlField &arg1 = args.read<const QSqlField & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(false);
  ret.write<QString > ((QString)((QSqlDriver *)cls)->formatValue (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_formatValue_c2938 ()
{
  return new qt_gsi::GenericMethod ("formatValue", "@brief Method QString QSqlDriver::formatValue(const QSqlField &field, bool trimStrings)\n", true, &_init_f_formatValue_c2938, &_call_f_formatValue_c2938);
}

// QVariant QSqlDriver::handle()


static void _init_f_handle_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVariant > ();
}

static void _call_f_handle_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QVariant > ((QVariant)((QSqlDriver *)cls)->handle ());
}

static qt_gsi::GenericMethod *_create_f_handle_c0 ()
{
  return new qt_gsi::GenericMethod ("handle", "@brief Method QVariant QSqlDriver::handle()\n", true, &_init_f_handle_c0, &_call_f_handle_c0);
}

// bool QSqlDriver::hasFeature(QSqlDriver::DriverFeature f)


static void _init_f_hasFeature_c2893 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::DriverFeature>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_hasFeature_c2893 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QSqlDriver::DriverFeature>::target_type & arg1 = args.read<const qt_gsi::Converter<QSqlDriver::DriverFeature>::target_type & > ();
  ret.write<bool > ((bool)((QSqlDriver *)cls)->hasFeature (qt_gsi::QtToCppAdaptor<QSqlDriver::DriverFeature>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_hasFeature_c2893 ()
{
  return new qt_gsi::GenericMethod ("hasFeature", "@brief Method bool QSqlDriver::hasFeature(QSqlDriver::DriverFeature f)\n", true, &_init_f_hasFeature_c2893, &_call_f_hasFeature_c2893);
}

// bool QSqlDriver::isIdentifierEscaped(const QString &identifier, QSqlDriver::IdentifierType type)


static void _init_f_isIdentifierEscaped_c4919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("identifier");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isIdentifierEscaped_c4919 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & arg2 = args.read<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > ();
  ret.write<bool > ((bool)((QSqlDriver *)cls)->isIdentifierEscaped (arg1, qt_gsi::QtToCppAdaptor<QSqlDriver::IdentifierType>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_isIdentifierEscaped_c4919 ()
{
  return new qt_gsi::GenericMethod ("isIdentifierEscaped?", "@brief Method bool QSqlDriver::isIdentifierEscaped(const QString &identifier, QSqlDriver::IdentifierType type)\n", true, &_init_f_isIdentifierEscaped_c4919, &_call_f_isIdentifierEscaped_c4919);
}

// bool QSqlDriver::isOpen()


static void _init_f_isOpen_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isOpen_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlDriver *)cls)->isOpen ());
}

static qt_gsi::GenericMethod *_create_f_isOpen_c0 ()
{
  return new qt_gsi::GenericMethod ("isOpen?", "@brief Method bool QSqlDriver::isOpen()\n", true, &_init_f_isOpen_c0, &_call_f_isOpen_c0);
}

// bool QSqlDriver::isOpenError()


static void _init_f_isOpenError_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isOpenError_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlDriver *)cls)->isOpenError ());
}

static qt_gsi::GenericMethod *_create_f_isOpenError_c0 ()
{
  return new qt_gsi::GenericMethod ("isOpenError?", "@brief Method bool QSqlDriver::isOpenError()\n", true, &_init_f_isOpenError_c0, &_call_f_isOpenError_c0);
}

// QSqlError QSqlDriver::lastError()


static void _init_f_lastError_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSqlError > ();
}

static void _call_f_lastError_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSqlError > ((QSqlError)((QSqlDriver *)cls)->lastError ());
}

static qt_gsi::GenericMethod *_create_f_lastError_c0 ()
{
  return new qt_gsi::GenericMethod ("lastError", "@brief Method QSqlError QSqlDriver::lastError()\n", true, &_init_f_lastError_c0, &_call_f_lastError_c0);
}

// QSql::NumericalPrecisionPolicy QSqlDriver::numericalPrecisionPolicy()


static void _init_f_numericalPrecisionPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type > ();
}

static void _call_f_numericalPrecisionPolicy_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type > ((qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type)qt_gsi::CppToQtAdaptor<QSql::NumericalPrecisionPolicy>(((QSqlDriver *)cls)->numericalPrecisionPolicy ()));
}

static qt_gsi::GenericMethod *_create_f_numericalPrecisionPolicy_c0 ()
{
  return new qt_gsi::GenericMethod (":numericalPrecisionPolicy", "@brief Method QSql::NumericalPrecisionPolicy QSqlDriver::numericalPrecisionPolicy()\n", true, &_init_f_numericalPrecisionPolicy_c0, &_call_f_numericalPrecisionPolicy_c0);
}

// bool QSqlDriver::open(const QString &db, const QString &user, const QString &password, const QString &host, int port, const QString &connOpts)


static void _init_f_open_10352 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("db");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("user", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("password", true, "QString()");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("host", true, "QString()");
  decl->add_arg<const QString & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("port", true, "-1");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("connOpts", true, "QString()");
  decl->add_arg<const QString & > (argspec_5);
  decl->set_return<bool > ();
}

static void _call_f_open_10352 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args ? args.read<const QString & > () : (const QString &)(QString());
  const QString &arg3 = args ? args.read<const QString & > () : (const QString &)(QString());
  const QString &arg4 = args ? args.read<const QString & > () : (const QString &)(QString());
  int arg5 = args ? args.read<int > () : (int)(-1);
  const QString &arg6 = args ? args.read<const QString & > () : (const QString &)(QString());
  ret.write<bool > ((bool)((QSqlDriver *)cls)->open (arg1, arg2, arg3, arg4, arg5, arg6));
}

static qt_gsi::GenericMethod *_create_f_open_10352 ()
{
  return new qt_gsi::GenericMethod ("open", "@brief Method bool QSqlDriver::open(const QString &db, const QString &user, const QString &password, const QString &host, int port, const QString &connOpts)\n", false, &_init_f_open_10352, &_call_f_open_10352);
}

// QSqlIndex QSqlDriver::primaryIndex(const QString &tableName)


static void _init_f_primaryIndex_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tableName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QSqlIndex > ();
}

static void _call_f_primaryIndex_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QSqlIndex > ((QSqlIndex)((QSqlDriver *)cls)->primaryIndex (arg1));
}

static qt_gsi::GenericMethod *_create_f_primaryIndex_c2025 ()
{
  return new qt_gsi::GenericMethod ("primaryIndex", "@brief Method QSqlIndex QSqlDriver::primaryIndex(const QString &tableName)\n", true, &_init_f_primaryIndex_c2025, &_call_f_primaryIndex_c2025);
}

// QSqlRecord QSqlDriver::record(const QString &tableName)


static void _init_f_record_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tableName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QSqlRecord > ();
}

static void _call_f_record_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QSqlRecord > ((QSqlRecord)((QSqlDriver *)cls)->record (arg1));
}

static qt_gsi::GenericMethod *_create_f_record_c2025 ()
{
  return new qt_gsi::GenericMethod ("record", "@brief Method QSqlRecord QSqlDriver::record(const QString &tableName)\n", true, &_init_f_record_c2025, &_call_f_record_c2025);
}

// bool QSqlDriver::rollbackTransaction()


static void _init_f_rollbackTransaction_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_rollbackTransaction_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlDriver *)cls)->rollbackTransaction ());
}

static qt_gsi::GenericMethod *_create_f_rollbackTransaction_0 ()
{
  return new qt_gsi::GenericMethod ("rollbackTransaction", "@brief Method bool QSqlDriver::rollbackTransaction()\n", false, &_init_f_rollbackTransaction_0, &_call_f_rollbackTransaction_0);
}

// void QSqlDriver::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy precisionPolicy)


static void _init_f_setNumericalPrecisionPolicy_3429 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("precisionPolicy");
  decl->add_arg<const qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNumericalPrecisionPolicy_3429 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type & arg1 = args.read<const qt_gsi::Converter<QSql::NumericalPrecisionPolicy>::target_type & > ();
  ((QSqlDriver *)cls)->setNumericalPrecisionPolicy (qt_gsi::QtToCppAdaptor<QSql::NumericalPrecisionPolicy>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setNumericalPrecisionPolicy_3429 ()
{
  return new qt_gsi::GenericMethod ("setNumericalPrecisionPolicy|numericalPrecisionPolicy=", "@brief Method void QSqlDriver::setNumericalPrecisionPolicy(QSql::NumericalPrecisionPolicy precisionPolicy)\n", false, &_init_f_setNumericalPrecisionPolicy_3429, &_call_f_setNumericalPrecisionPolicy_3429);
}

// QString QSqlDriver::sqlStatement(QSqlDriver::StatementType type, const QString &tableName, const QSqlRecord &rec, bool preparedStatement)


static void _init_f_sqlStatement_c7794 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::StatementType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("tableName");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rec");
  decl->add_arg<const QSqlRecord & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("preparedStatement");
  decl->add_arg<bool > (argspec_3);
  decl->set_return<QString > ();
}

static void _call_f_sqlStatement_c7794 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QSqlDriver::StatementType>::target_type & arg1 = args.read<const qt_gsi::Converter<QSqlDriver::StatementType>::target_type & > ();
  const QString &arg2 = args.read<const QString & > ();
  const QSqlRecord &arg3 = args.read<const QSqlRecord & > ();
  bool arg4 = args.read<bool > ();
  ret.write<QString > ((QString)((QSqlDriver *)cls)->sqlStatement (qt_gsi::QtToCppAdaptor<QSqlDriver::StatementType>(arg1).cref(), arg2, arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_sqlStatement_c7794 ()
{
  return new qt_gsi::GenericMethod ("sqlStatement", "@brief Method QString QSqlDriver::sqlStatement(QSqlDriver::StatementType type, const QString &tableName, const QSqlRecord &rec, bool preparedStatement)\n", true, &_init_f_sqlStatement_c7794, &_call_f_sqlStatement_c7794);
}

// QString QSqlDriver::stripDelimiters(const QString &identifier, QSqlDriver::IdentifierType type)


static void _init_f_stripDelimiters_c4919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("identifier");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_stripDelimiters_c4919 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & arg2 = args.read<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > ();
  ret.write<QString > ((QString)((QSqlDriver *)cls)->stripDelimiters (arg1, qt_gsi::QtToCppAdaptor<QSqlDriver::IdentifierType>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_stripDelimiters_c4919 ()
{
  return new qt_gsi::GenericMethod ("stripDelimiters", "@brief Method QString QSqlDriver::stripDelimiters(const QString &identifier, QSqlDriver::IdentifierType type)\n", true, &_init_f_stripDelimiters_c4919, &_call_f_stripDelimiters_c4919);
}

// bool QSqlDriver::subscribeToNotification(const QString &name)


static void _init_f_subscribeToNotification_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_subscribeToNotification_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QSqlDriver *)cls)->subscribeToNotification (arg1));
}

static qt_gsi::GenericMethod *_create_f_subscribeToNotification_2025 ()
{
  return new qt_gsi::GenericMethod ("subscribeToNotification", "@brief Method bool QSqlDriver::subscribeToNotification(const QString &name)\n", false, &_init_f_subscribeToNotification_2025, &_call_f_subscribeToNotification_2025);
}

// QStringList QSqlDriver::subscribedToNotifications()


static void _init_f_subscribedToNotifications_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_subscribedToNotifications_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QSqlDriver *)cls)->subscribedToNotifications ()));
}

static qt_gsi::GenericMethod *_create_f_subscribedToNotifications_c0 ()
{
  return new qt_gsi::GenericMethod ("subscribedToNotifications", "@brief Method QStringList QSqlDriver::subscribedToNotifications()\n", true, &_init_f_subscribedToNotifications_c0, &_call_f_subscribedToNotifications_c0);
}

// QStringList QSqlDriver::tables(QSql::TableType tableType)


static void _init_f_tables_c1843 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tableType");
  decl->add_arg<const qt_gsi::Converter<QSql::TableType>::target_type & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_tables_c1843 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QSql::TableType>::target_type & arg1 = args.read<const qt_gsi::Converter<QSql::TableType>::target_type & > ();
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QSqlDriver *)cls)->tables (qt_gsi::QtToCppAdaptor<QSql::TableType>(arg1).cref())));
}

static qt_gsi::GenericMethod *_create_f_tables_c1843 ()
{
  return new qt_gsi::GenericMethod ("tables", "@brief Method QStringList QSqlDriver::tables(QSql::TableType tableType)\n", true, &_init_f_tables_c1843, &_call_f_tables_c1843);
}

// bool QSqlDriver::unsubscribeFromNotification(const QString &name)


static void _init_f_unsubscribeFromNotification_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_unsubscribeFromNotification_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QSqlDriver *)cls)->unsubscribeFromNotification (arg1));
}

static qt_gsi::GenericMethod *_create_f_unsubscribeFromNotification_2025 ()
{
  return new qt_gsi::GenericMethod ("unsubscribeFromNotification", "@brief Method bool QSqlDriver::unsubscribeFromNotification(const QString &name)\n", false, &_init_f_unsubscribeFromNotification_2025, &_call_f_unsubscribeFromNotification_2025);
}

// static QString QSqlDriver::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QSqlDriver::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSqlDriver::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QSqlDriver::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QSqlDriver::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QSqlDriver::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QSqlDriver::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QSqlDriver::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSqlDriver::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QSqlDriver::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QSqlDriver::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QSqlDriver::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QSqlDriver, QSqlDriver_EventAdaptor> ea_QSqlDriver;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QSqlDriver> decl_QSqlDriver (ea_QSqlDriver, decl_QObject, "QSqlDriver_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_beginTransaction_0 ()) +
  gsi::Methods(_create_f_close_0 ()) +
  gsi::Methods(_create_f_commitTransaction_0 ()) +
  gsi::Methods(_create_f_createResult_c0 ()) +
  gsi::Methods(_create_f_escapeIdentifier_c4919 ()) +
  gsi::Methods(_create_f_formatValue_c2938 ()) +
  gsi::Methods(_create_f_handle_c0 ()) +
  gsi::Methods(_create_f_hasFeature_c2893 ()) +
  gsi::Methods(_create_f_isIdentifierEscaped_c4919 ()) +
  gsi::Methods(_create_f_isOpen_c0 ()) +
  gsi::Methods(_create_f_isOpenError_c0 ()) +
  gsi::Methods(_create_f_lastError_c0 ()) +
  gsi::Methods(_create_f_numericalPrecisionPolicy_c0 ()) +
  gsi::Methods(_create_f_open_10352 ()) +
  gsi::Methods(_create_f_primaryIndex_c2025 ()) +
  gsi::Methods(_create_f_record_c2025 ()) +
  gsi::Methods(_create_f_rollbackTransaction_0 ()) +
  gsi::Methods(_create_f_setNumericalPrecisionPolicy_3429 ()) +
  gsi::Methods(_create_f_sqlStatement_c7794 ()) +
  gsi::Methods(_create_f_stripDelimiters_c4919 ()) +
  gsi::Methods(_create_f_subscribeToNotification_2025 ()) +
  gsi::Methods(_create_f_subscribedToNotifications_c0 ()) +
  gsi::Methods(_create_f_tables_c1843 ()) +
  gsi::Methods(_create_f_unsubscribeFromNotification_2025 ()) +
  qt_gsi::qt_signal<QSqlDriver, QSqlDriver_EventAdaptor, QObject *> ("destroyed", &QSqlDriver_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QSqlDriver::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QSqlDriver, QSqlDriver_EventAdaptor, const QString &> ("notification", &QSqlDriver_EventAdaptor::notification_e_2025, gsi::arg("name"), "@brief Signal declaration for QSqlDriver::notification(const QString &name)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QSqlDriver");
}


class QSqlDriver_Adaptor : public QSqlDriver, public qt_gsi::QtObjectBase
{
public:

  virtual ~QSqlDriver_Adaptor();

  //  [adaptor ctor] QSqlDriver::QSqlDriver(QObject *parent)
  QSqlDriver_Adaptor() : QSqlDriver()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QSqlDriver::QSqlDriver(QObject *parent)
  QSqlDriver_Adaptor(QObject *parent) : QSqlDriver(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  bool QSqlDriver::isIdentifierEscapedImplementation(const QString &identifier, QSqlDriver::IdentifierType type)
  bool fp_QSqlDriver_isIdentifierEscapedImplementation_c4919 (const QString &identifier, const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & type) const {
    return QSqlDriver::isIdentifierEscapedImplementation(identifier, qt_gsi::QtToCppAdaptor<QSqlDriver::IdentifierType>(type).cref());
  }

  //  int QSqlDriver::receivers(const char *signal)
  int fp_QSqlDriver_receivers_c1731 (const char *signal) const {
    return QSqlDriver::receivers(signal);
  }

  //  QObject *QSqlDriver::sender()
  QObject * fp_QSqlDriver_sender_c0 () const {
    return QSqlDriver::sender();
  }

  //  QString QSqlDriver::stripDelimitersImplementation(const QString &identifier, QSqlDriver::IdentifierType type)
  QString fp_QSqlDriver_stripDelimitersImplementation_c4919 (const QString &identifier, const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & type) const {
    return QSqlDriver::stripDelimitersImplementation(identifier, qt_gsi::QtToCppAdaptor<QSqlDriver::IdentifierType>(type).cref());
  }

  //  bool QSqlDriver::subscribeToNotificationImplementation(const QString &name)
  bool fp_QSqlDriver_subscribeToNotificationImplementation_2025 (const QString &name) {
    return QSqlDriver::subscribeToNotificationImplementation(name);
  }

  //  QStringList QSqlDriver::subscribedToNotificationsImplementation()
  qt_gsi::Converter<QStringList>::target_type fp_QSqlDriver_subscribedToNotificationsImplementation_c0 () const {
    return qt_gsi::CppToQtAdaptor<QStringList>(QSqlDriver::subscribedToNotificationsImplementation());
  }

  //  bool QSqlDriver::unsubscribeFromNotificationImplementation(const QString &name)
  bool fp_QSqlDriver_unsubscribeFromNotificationImplementation_2025 (const QString &name) {
    return QSqlDriver::unsubscribeFromNotificationImplementation(name);
  }

  //  [adaptor impl] bool QSqlDriver::beginTransaction()
  bool cbs_beginTransaction_0_0()
  {
    return QSqlDriver::beginTransaction();
  }

  virtual bool beginTransaction()
  {
    if (cb_beginTransaction_0_0.can_issue()) {
      return cb_beginTransaction_0_0.issue<QSqlDriver_Adaptor, bool>(&QSqlDriver_Adaptor::cbs_beginTransaction_0_0);
    } else {
      return QSqlDriver::beginTransaction();
    }
  }

  //  [adaptor impl] void QSqlDriver::close()
  void cbs_close_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("close");
  }

  virtual void close()
  {
    if (cb_close_0_0.can_issue()) {
      cb_close_0_0.issue<QSqlDriver_Adaptor>(&QSqlDriver_Adaptor::cbs_close_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("close");
    }
  }

  //  [adaptor impl] bool QSqlDriver::commitTransaction()
  bool cbs_commitTransaction_0_0()
  {
    return QSqlDriver::commitTransaction();
  }

  virtual bool commitTransaction()
  {
    if (cb_commitTransaction_0_0.can_issue()) {
      return cb_commitTransaction_0_0.issue<QSqlDriver_Adaptor, bool>(&QSqlDriver_Adaptor::cbs_commitTransaction_0_0);
    } else {
      return QSqlDriver::commitTransaction();
    }
  }

  //  [adaptor impl] QSqlResult *QSqlDriver::createResult()
  QSqlResult * cbs_createResult_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("createResult");
  }

  virtual QSqlResult * createResult() const
  {
    if (cb_createResult_c0_0.can_issue()) {
      return cb_createResult_c0_0.issue<QSqlDriver_Adaptor, QSqlResult *>(&QSqlDriver_Adaptor::cbs_createResult_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("createResult");
    }
  }

  //  [adaptor impl] QString QSqlDriver::escapeIdentifier(const QString &identifier, QSqlDriver::IdentifierType type)
  QString cbs_escapeIdentifier_c4919_0(const QString &identifier, const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & type) const
  {
    return QSqlDriver::escapeIdentifier(identifier, qt_gsi::QtToCppAdaptor<QSqlDriver::IdentifierType>(type).cref());
  }

  virtual QString escapeIdentifier(const QString &identifier, QSqlDriver::IdentifierType type) const
  {
    if (cb_escapeIdentifier_c4919_0.can_issue()) {
      return cb_escapeIdentifier_c4919_0.issue<QSqlDriver_Adaptor, QString, const QString &, const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type &>(&QSqlDriver_Adaptor::cbs_escapeIdentifier_c4919_0, identifier, qt_gsi::CppToQtAdaptor<QSqlDriver::IdentifierType>(type));
    } else {
      return QSqlDriver::escapeIdentifier(identifier, type);
    }
  }

  //  [adaptor impl] bool QSqlDriver::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QSqlDriver::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QSqlDriver_Adaptor, bool, QEvent *>(&QSqlDriver_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QSqlDriver::event(arg1);
    }
  }

  //  [adaptor impl] bool QSqlDriver::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QSqlDriver::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QSqlDriver_Adaptor, bool, QObject *, QEvent *>(&QSqlDriver_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QSqlDriver::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QString QSqlDriver::formatValue(const QSqlField &field, bool trimStrings)
  QString cbs_formatValue_c2938_1(const QSqlField &field, bool trimStrings) const
  {
    return QSqlDriver::formatValue(field, trimStrings);
  }

  virtual QString formatValue(const QSqlField &field, bool trimStrings) const
  {
    if (cb_formatValue_c2938_1.can_issue()) {
      return cb_formatValue_c2938_1.issue<QSqlDriver_Adaptor, QString, const QSqlField &, bool>(&QSqlDriver_Adaptor::cbs_formatValue_c2938_1, field, trimStrings);
    } else {
      return QSqlDriver::formatValue(field, trimStrings);
    }
  }

  //  [adaptor impl] QVariant QSqlDriver::handle()
  QVariant cbs_handle_c0_0() const
  {
    return QSqlDriver::handle();
  }

  virtual QVariant handle() const
  {
    if (cb_handle_c0_0.can_issue()) {
      return cb_handle_c0_0.issue<QSqlDriver_Adaptor, QVariant>(&QSqlDriver_Adaptor::cbs_handle_c0_0);
    } else {
      return QSqlDriver::handle();
    }
  }

  //  [adaptor impl] bool QSqlDriver::hasFeature(QSqlDriver::DriverFeature f)
  bool cbs_hasFeature_c2893_0(const qt_gsi::Converter<QSqlDriver::DriverFeature>::target_type & f) const
  {
    throw qt_gsi::AbstractMethodCalledException("hasFeature");
  }

  virtual bool hasFeature(QSqlDriver::DriverFeature f) const
  {
    if (cb_hasFeature_c2893_0.can_issue()) {
      return cb_hasFeature_c2893_0.issue<QSqlDriver_Adaptor, bool, const qt_gsi::Converter<QSqlDriver::DriverFeature>::target_type &>(&QSqlDriver_Adaptor::cbs_hasFeature_c2893_0, qt_gsi::CppToQtAdaptor<QSqlDriver::DriverFeature>(f));
    } else {
      throw qt_gsi::AbstractMethodCalledException("hasFeature");
    }
  }

  //  [adaptor impl] bool QSqlDriver::isOpen()
  bool cbs_isOpen_c0_0() const
  {
    return QSqlDriver::isOpen();
  }

  virtual bool isOpen() const
  {
    if (cb_isOpen_c0_0.can_issue()) {
      return cb_isOpen_c0_0.issue<QSqlDriver_Adaptor, bool>(&QSqlDriver_Adaptor::cbs_isOpen_c0_0);
    } else {
      return QSqlDriver::isOpen();
    }
  }

  //  [adaptor impl] bool QSqlDriver::open(const QString &db, const QString &user, const QString &password, const QString &host, int port, const QString &connOpts)
  bool cbs_open_10352_5(const QString &db, const QString &user, const QString &password, const QString &host, int port, const QString &connOpts)
  {
    throw qt_gsi::AbstractMethodCalledException("open");
  }

  virtual bool open(const QString &db, const QString &user, const QString &password, const QString &host, int port, const QString &connOpts)
  {
    if (cb_open_10352_5.can_issue()) {
      return cb_open_10352_5.issue<QSqlDriver_Adaptor, bool, const QString &, const QString &, const QString &, const QString &, int, const QString &>(&QSqlDriver_Adaptor::cbs_open_10352_5, db, user, password, host, port, connOpts);
    } else {
      throw qt_gsi::AbstractMethodCalledException("open");
    }
  }

  //  [adaptor impl] QSqlIndex QSqlDriver::primaryIndex(const QString &tableName)
  QSqlIndex cbs_primaryIndex_c2025_0(const QString &tableName) const
  {
    return QSqlDriver::primaryIndex(tableName);
  }

  virtual QSqlIndex primaryIndex(const QString &tableName) const
  {
    if (cb_primaryIndex_c2025_0.can_issue()) {
      return cb_primaryIndex_c2025_0.issue<QSqlDriver_Adaptor, QSqlIndex, const QString &>(&QSqlDriver_Adaptor::cbs_primaryIndex_c2025_0, tableName);
    } else {
      return QSqlDriver::primaryIndex(tableName);
    }
  }

  //  [adaptor impl] QSqlRecord QSqlDriver::record(const QString &tableName)
  QSqlRecord cbs_record_c2025_0(const QString &tableName) const
  {
    return QSqlDriver::record(tableName);
  }

  virtual QSqlRecord record(const QString &tableName) const
  {
    if (cb_record_c2025_0.can_issue()) {
      return cb_record_c2025_0.issue<QSqlDriver_Adaptor, QSqlRecord, const QString &>(&QSqlDriver_Adaptor::cbs_record_c2025_0, tableName);
    } else {
      return QSqlDriver::record(tableName);
    }
  }

  //  [adaptor impl] bool QSqlDriver::rollbackTransaction()
  bool cbs_rollbackTransaction_0_0()
  {
    return QSqlDriver::rollbackTransaction();
  }

  virtual bool rollbackTransaction()
  {
    if (cb_rollbackTransaction_0_0.can_issue()) {
      return cb_rollbackTransaction_0_0.issue<QSqlDriver_Adaptor, bool>(&QSqlDriver_Adaptor::cbs_rollbackTransaction_0_0);
    } else {
      return QSqlDriver::rollbackTransaction();
    }
  }

  //  [adaptor impl] QString QSqlDriver::sqlStatement(QSqlDriver::StatementType type, const QString &tableName, const QSqlRecord &rec, bool preparedStatement)
  QString cbs_sqlStatement_c7794_0(const qt_gsi::Converter<QSqlDriver::StatementType>::target_type & type, const QString &tableName, const QSqlRecord &rec, bool preparedStatement) const
  {
    return QSqlDriver::sqlStatement(qt_gsi::QtToCppAdaptor<QSqlDriver::StatementType>(type).cref(), tableName, rec, preparedStatement);
  }

  virtual QString sqlStatement(QSqlDriver::StatementType type, const QString &tableName, const QSqlRecord &rec, bool preparedStatement) const
  {
    if (cb_sqlStatement_c7794_0.can_issue()) {
      return cb_sqlStatement_c7794_0.issue<QSqlDriver_Adaptor, QString, const qt_gsi::Converter<QSqlDriver::StatementType>::target_type &, const QString &, const QSqlRecord &, bool>(&QSqlDriver_Adaptor::cbs_sqlStatement_c7794_0, qt_gsi::CppToQtAdaptor<QSqlDriver::StatementType>(type), tableName, rec, preparedStatement);
    } else {
      return QSqlDriver::sqlStatement(type, tableName, rec, preparedStatement);
    }
  }

  //  [adaptor impl] QStringList QSqlDriver::tables(QSql::TableType tableType)
  qt_gsi::Converter<QStringList>::target_type cbs_tables_c1843_0(const qt_gsi::Converter<QSql::TableType>::target_type & tableType) const
  {
    return qt_gsi::CppToQtAdaptor<QStringList>(QSqlDriver::tables(qt_gsi::QtToCppAdaptor<QSql::TableType>(tableType).cref()));
  }

  virtual QStringList tables(QSql::TableType tableType) const
  {
    if (cb_tables_c1843_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QStringList>(cb_tables_c1843_0.issue<QSqlDriver_Adaptor, qt_gsi::Converter<QStringList>::target_type, const qt_gsi::Converter<QSql::TableType>::target_type &>(&QSqlDriver_Adaptor::cbs_tables_c1843_0, qt_gsi::CppToQtAdaptor<QSql::TableType>(tableType))).cref();
    } else {
      return QSqlDriver::tables(tableType);
    }
  }

  //  [adaptor impl] void QSqlDriver::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QSqlDriver::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QSqlDriver_Adaptor, QChildEvent *>(&QSqlDriver_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QSqlDriver::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QSqlDriver::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QSqlDriver::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QSqlDriver_Adaptor, QEvent *>(&QSqlDriver_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QSqlDriver::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QSqlDriver::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QSqlDriver::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QSqlDriver_Adaptor, const char *>(&QSqlDriver_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QSqlDriver::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QSqlDriver::setLastError(const QSqlError &e)
  void cbs_setLastError_2220_0(const QSqlError &e)
  {
    QSqlDriver::setLastError(e);
  }

  virtual void setLastError(const QSqlError &e)
  {
    if (cb_setLastError_2220_0.can_issue()) {
      cb_setLastError_2220_0.issue<QSqlDriver_Adaptor, const QSqlError &>(&QSqlDriver_Adaptor::cbs_setLastError_2220_0, e);
    } else {
      QSqlDriver::setLastError(e);
    }
  }

  //  [adaptor impl] void QSqlDriver::setOpen(bool o)
  void cbs_setOpen_864_0(bool o)
  {
    QSqlDriver::setOpen(o);
  }

  virtual void setOpen(bool o)
  {
    if (cb_setOpen_864_0.can_issue()) {
      cb_setOpen_864_0.issue<QSqlDriver_Adaptor, bool>(&QSqlDriver_Adaptor::cbs_setOpen_864_0, o);
    } else {
      QSqlDriver::setOpen(o);
    }
  }

  //  [adaptor impl] void QSqlDriver::setOpenError(bool e)
  void cbs_setOpenError_864_0(bool e)
  {
    QSqlDriver::setOpenError(e);
  }

  virtual void setOpenError(bool e)
  {
    if (cb_setOpenError_864_0.can_issue()) {
      cb_setOpenError_864_0.issue<QSqlDriver_Adaptor, bool>(&QSqlDriver_Adaptor::cbs_setOpenError_864_0, e);
    } else {
      QSqlDriver::setOpenError(e);
    }
  }

  //  [adaptor impl] void QSqlDriver::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QSqlDriver::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QSqlDriver_Adaptor, QTimerEvent *>(&QSqlDriver_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QSqlDriver::timerEvent(arg1);
    }
  }

  gsi::Callback cb_beginTransaction_0_0;
  gsi::Callback cb_close_0_0;
  gsi::Callback cb_commitTransaction_0_0;
  gsi::Callback cb_createResult_c0_0;
  gsi::Callback cb_escapeIdentifier_c4919_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_formatValue_c2938_1;
  gsi::Callback cb_handle_c0_0;
  gsi::Callback cb_hasFeature_c2893_0;
  gsi::Callback cb_isOpen_c0_0;
  gsi::Callback cb_open_10352_5;
  gsi::Callback cb_primaryIndex_c2025_0;
  gsi::Callback cb_record_c2025_0;
  gsi::Callback cb_rollbackTransaction_0_0;
  gsi::Callback cb_sqlStatement_c7794_0;
  gsi::Callback cb_tables_c1843_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_setLastError_2220_0;
  gsi::Callback cb_setOpen_864_0;
  gsi::Callback cb_setOpenError_864_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QSqlDriver_Adaptor::~QSqlDriver_Adaptor() { }

//  Constructor QSqlDriver::QSqlDriver(QObject *parent) (adaptor class)

static void _init_ctor_QSqlDriver_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QSqlDriver_Adaptor *> ();
}

static void _call_ctor_QSqlDriver_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QSqlDriver_Adaptor *> (new QSqlDriver_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QSqlDriver_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSqlDriver::QSqlDriver(QObject *parent)\nThis method creates an object of class QSqlDriver.", &_init_ctor_QSqlDriver_Adaptor_1302, &_call_ctor_QSqlDriver_Adaptor_1302);
}

// bool QSqlDriver::isIdentifierEscapedImplementation(const QString &identifier, QSqlDriver::IdentifierType type)

static void _init_fp_isIdentifierEscapedImplementation_c4919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("identifier");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_fp_isIdentifierEscapedImplementation_c4919 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & arg2 = args.read<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > ();
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->fp_QSqlDriver_isIdentifierEscapedImplementation_c4919 (arg1, arg2));
}

static qt_gsi::GenericMethod*_create_fp_isIdentifierEscapedImplementation_c4919 ()
{
  return new qt_gsi::GenericMethod("*isIdentifierEscapedImplementation", "@brief Method bool QSqlDriver::isIdentifierEscapedImplementation(const QString &identifier, QSqlDriver::IdentifierType type)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isIdentifierEscapedImplementation_c4919, &_call_fp_isIdentifierEscapedImplementation_c4919);
}


// int QSqlDriver::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QSqlDriver_Adaptor *)cls)->fp_QSqlDriver_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QSqlDriver::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QSqlDriver::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QSqlDriver_Adaptor *)cls)->fp_QSqlDriver_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QSqlDriver::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// QString QSqlDriver::stripDelimitersImplementation(const QString &identifier, QSqlDriver::IdentifierType type)

static void _init_fp_stripDelimitersImplementation_c4919 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("identifier");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_fp_stripDelimitersImplementation_c4919 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & arg2 = args.read<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > ();
  ret.write<QString > ((QString)((QSqlDriver_Adaptor *)cls)->fp_QSqlDriver_stripDelimitersImplementation_c4919 (arg1, arg2));
}

static qt_gsi::GenericMethod*_create_fp_stripDelimitersImplementation_c4919 ()
{
  return new qt_gsi::GenericMethod("*stripDelimitersImplementation", "@brief Method QString QSqlDriver::stripDelimitersImplementation(const QString &identifier, QSqlDriver::IdentifierType type)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_stripDelimitersImplementation_c4919, &_call_fp_stripDelimitersImplementation_c4919);
}


// bool QSqlDriver::subscribeToNotificationImplementation(const QString &name)

static void _init_fp_subscribeToNotificationImplementation_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_subscribeToNotificationImplementation_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->fp_QSqlDriver_subscribeToNotificationImplementation_2025 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_subscribeToNotificationImplementation_2025 ()
{
  return new qt_gsi::GenericMethod("*subscribeToNotificationImplementation", "@brief Method bool QSqlDriver::subscribeToNotificationImplementation(const QString &name)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_subscribeToNotificationImplementation_2025, &_call_fp_subscribeToNotificationImplementation_2025);
}


// QStringList QSqlDriver::subscribedToNotificationsImplementation()

static void _init_fp_subscribedToNotificationsImplementation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_fp_subscribedToNotificationsImplementation_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)((QSqlDriver_Adaptor *)cls)->fp_QSqlDriver_subscribedToNotificationsImplementation_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_subscribedToNotificationsImplementation_c0 ()
{
  return new qt_gsi::GenericMethod("*subscribedToNotificationsImplementation", "@brief Method QStringList QSqlDriver::subscribedToNotificationsImplementation()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_subscribedToNotificationsImplementation_c0, &_call_fp_subscribedToNotificationsImplementation_c0);
}


// bool QSqlDriver::unsubscribeFromNotificationImplementation(const QString &name)

static void _init_fp_unsubscribeFromNotificationImplementation_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_unsubscribeFromNotificationImplementation_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->fp_QSqlDriver_unsubscribeFromNotificationImplementation_2025 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_unsubscribeFromNotificationImplementation_2025 ()
{
  return new qt_gsi::GenericMethod("*unsubscribeFromNotificationImplementation", "@brief Method bool QSqlDriver::unsubscribeFromNotificationImplementation(const QString &name)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_unsubscribeFromNotificationImplementation_2025, &_call_fp_unsubscribeFromNotificationImplementation_2025);
}


// bool QSqlDriver::beginTransaction()

static void _init_cbs_beginTransaction_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_beginTransaction_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_beginTransaction_0_0 ());
}

static void _set_callback_cbs_beginTransaction_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_beginTransaction_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_beginTransaction_0_0 ()
{
  return new qt_gsi::GenericMethod ("beginTransaction", "@hide", false, &_init_cbs_beginTransaction_0_0, &_call_cbs_beginTransaction_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_beginTransaction_0_0 ()
{
  return new qt_gsi::GenericMethod ("beginTransaction", "@brief Virtual method bool QSqlDriver::beginTransaction()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_beginTransaction_0_0, &_call_cbs_beginTransaction_0_0, &_set_callback_cbs_beginTransaction_0_0);
}


// void QSqlDriver::close()

static void _init_cbs_close_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_close_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QSqlDriver_Adaptor *)cls)->cbs_close_0_0 ();
}

static void _set_callback_cbs_close_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_close_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_close_0_0 ()
{
  return new qt_gsi::GenericMethod ("close", "@hide", false, &_init_cbs_close_0_0, &_call_cbs_close_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_close_0_0 ()
{
  return new qt_gsi::GenericMethod ("close", "@brief Virtual method void QSqlDriver::close()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_close_0_0, &_call_cbs_close_0_0, &_set_callback_cbs_close_0_0);
}


// bool QSqlDriver::commitTransaction()

static void _init_cbs_commitTransaction_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_commitTransaction_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_commitTransaction_0_0 ());
}

static void _set_callback_cbs_commitTransaction_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_commitTransaction_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_commitTransaction_0_0 ()
{
  return new qt_gsi::GenericMethod ("commitTransaction", "@hide", false, &_init_cbs_commitTransaction_0_0, &_call_cbs_commitTransaction_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_commitTransaction_0_0 ()
{
  return new qt_gsi::GenericMethod ("commitTransaction", "@brief Virtual method bool QSqlDriver::commitTransaction()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_commitTransaction_0_0, &_call_cbs_commitTransaction_0_0, &_set_callback_cbs_commitTransaction_0_0);
}


// QSqlResult *QSqlDriver::createResult()

static void _init_cbs_createResult_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSqlResult * > ();
}

static void _call_cbs_createResult_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSqlResult * > ((QSqlResult *)((QSqlDriver_Adaptor *)cls)->cbs_createResult_c0_0 ());
}

static void _set_callback_cbs_createResult_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_createResult_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_createResult_c0_0 ()
{
  return new qt_gsi::GenericMethod ("createResult", "@hide", true, &_init_cbs_createResult_c0_0, &_call_cbs_createResult_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_createResult_c0_0 ()
{
  return new qt_gsi::GenericMethod ("createResult", "@brief Virtual method QSqlResult *QSqlDriver::createResult()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_createResult_c0_0, &_call_cbs_createResult_c0_0, &_set_callback_cbs_createResult_c0_0);
}


// QString QSqlDriver::escapeIdentifier(const QString &identifier, QSqlDriver::IdentifierType type)

static void _init_cbs_escapeIdentifier_c4919_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("identifier");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("type");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_cbs_escapeIdentifier_c4919_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & arg2 = args.read<const qt_gsi::Converter<QSqlDriver::IdentifierType>::target_type & > ();
  ret.write<QString > ((QString)((QSqlDriver_Adaptor *)cls)->cbs_escapeIdentifier_c4919_0 (arg1, arg2));
}

static void _set_callback_cbs_escapeIdentifier_c4919_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_escapeIdentifier_c4919_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_escapeIdentifier_c4919_0 ()
{
  return new qt_gsi::GenericMethod ("escapeIdentifier", "@hide", true, &_init_cbs_escapeIdentifier_c4919_0, &_call_cbs_escapeIdentifier_c4919_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_escapeIdentifier_c4919_0 ()
{
  return new qt_gsi::GenericMethod ("escapeIdentifier", "@brief Virtual method QString QSqlDriver::escapeIdentifier(const QString &identifier, QSqlDriver::IdentifierType type)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_escapeIdentifier_c4919_0, &_call_cbs_escapeIdentifier_c4919_0, &_set_callback_cbs_escapeIdentifier_c4919_0);
}


// bool QSqlDriver::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QSqlDriver::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QSqlDriver::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QSqlDriver::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// QString QSqlDriver::formatValue(const QSqlField &field, bool trimStrings)

static void _init_cbs_formatValue_c2938_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("field");
  decl->add_arg<const QSqlField & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("trimStrings");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_cbs_formatValue_c2938_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSqlField &arg1 = args.read<const QSqlField & > ();
  bool arg2 = args.read<bool > ();
  ret.write<QString > ((QString)((QSqlDriver_Adaptor *)cls)->cbs_formatValue_c2938_1 (arg1, arg2));
}

static void _set_callback_cbs_formatValue_c2938_1 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_formatValue_c2938_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_formatValue_c2938_1 ()
{
  return new qt_gsi::GenericMethod ("formatValue", "@hide", true, &_init_cbs_formatValue_c2938_1, &_call_cbs_formatValue_c2938_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_formatValue_c2938_1 ()
{
  return new qt_gsi::GenericMethod ("formatValue", "@brief Virtual method QString QSqlDriver::formatValue(const QSqlField &field, bool trimStrings)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_formatValue_c2938_1, &_call_cbs_formatValue_c2938_1, &_set_callback_cbs_formatValue_c2938_1);
}


// QVariant QSqlDriver::handle()

static void _init_cbs_handle_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVariant > ();
}

static void _call_cbs_handle_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QVariant > ((QVariant)((QSqlDriver_Adaptor *)cls)->cbs_handle_c0_0 ());
}

static void _set_callback_cbs_handle_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_handle_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_handle_c0_0 ()
{
  return new qt_gsi::GenericMethod ("handle", "@hide", true, &_init_cbs_handle_c0_0, &_call_cbs_handle_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_handle_c0_0 ()
{
  return new qt_gsi::GenericMethod ("handle", "@brief Virtual method QVariant QSqlDriver::handle()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_handle_c0_0, &_call_cbs_handle_c0_0, &_set_callback_cbs_handle_c0_0);
}


// bool QSqlDriver::hasFeature(QSqlDriver::DriverFeature f)

static void _init_cbs_hasFeature_c2893_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("f");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::DriverFeature>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_hasFeature_c2893_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QSqlDriver::DriverFeature>::target_type & arg1 = args.read<const qt_gsi::Converter<QSqlDriver::DriverFeature>::target_type & > ();
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_hasFeature_c2893_0 (arg1));
}

static void _set_callback_cbs_hasFeature_c2893_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_hasFeature_c2893_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hasFeature_c2893_0 ()
{
  return new qt_gsi::GenericMethod ("hasFeature", "@hide", true, &_init_cbs_hasFeature_c2893_0, &_call_cbs_hasFeature_c2893_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hasFeature_c2893_0 ()
{
  return new qt_gsi::GenericMethod ("hasFeature", "@brief Virtual method bool QSqlDriver::hasFeature(QSqlDriver::DriverFeature f)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasFeature_c2893_0, &_call_cbs_hasFeature_c2893_0, &_set_callback_cbs_hasFeature_c2893_0);
}


// bool QSqlDriver::isOpen()

static void _init_cbs_isOpen_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isOpen_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_isOpen_c0_0 ());
}

static void _set_callback_cbs_isOpen_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_isOpen_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_isOpen_c0_0 ()
{
  return new qt_gsi::GenericMethod ("isOpen", "@hide", true, &_init_cbs_isOpen_c0_0, &_call_cbs_isOpen_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_isOpen_c0_0 ()
{
  return new qt_gsi::GenericMethod ("isOpen", "@brief Virtual method bool QSqlDriver::isOpen()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isOpen_c0_0, &_call_cbs_isOpen_c0_0, &_set_callback_cbs_isOpen_c0_0);
}


// bool QSqlDriver::open(const QString &db, const QString &user, const QString &password, const QString &host, int port, const QString &connOpts)

static void _init_cbs_open_10352_5 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("db");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("user");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("password");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("host");
  decl->add_arg<const QString & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("port");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("connOpts");
  decl->add_arg<const QString & > (argspec_5);
  decl->set_return<bool > ();
}

static void _call_cbs_open_10352_5 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  const QString &arg3 = args.read<const QString & > ();
  const QString &arg4 = args.read<const QString & > ();
  int arg5 = args.read<int > ();
  const QString &arg6 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_open_10352_5 (arg1, arg2, arg3, arg4, arg5, arg6));
}

static void _set_callback_cbs_open_10352_5 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_open_10352_5 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_open_10352_5 ()
{
  return new qt_gsi::GenericMethod ("open", "@hide", false, &_init_cbs_open_10352_5, &_call_cbs_open_10352_5);
}

static qt_gsi::GenericMethod *_create_callback_cbs_open_10352_5 ()
{
  return new qt_gsi::GenericMethod ("open", "@brief Virtual method bool QSqlDriver::open(const QString &db, const QString &user, const QString &password, const QString &host, int port, const QString &connOpts)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_open_10352_5, &_call_cbs_open_10352_5, &_set_callback_cbs_open_10352_5);
}


// QSqlIndex QSqlDriver::primaryIndex(const QString &tableName)

static void _init_cbs_primaryIndex_c2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tableName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QSqlIndex > ();
}

static void _call_cbs_primaryIndex_c2025_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QSqlIndex > ((QSqlIndex)((QSqlDriver_Adaptor *)cls)->cbs_primaryIndex_c2025_0 (arg1));
}

static void _set_callback_cbs_primaryIndex_c2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_primaryIndex_c2025_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_primaryIndex_c2025_0 ()
{
  return new qt_gsi::GenericMethod ("primaryIndex", "@hide", true, &_init_cbs_primaryIndex_c2025_0, &_call_cbs_primaryIndex_c2025_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_primaryIndex_c2025_0 ()
{
  return new qt_gsi::GenericMethod ("primaryIndex", "@brief Virtual method QSqlIndex QSqlDriver::primaryIndex(const QString &tableName)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_primaryIndex_c2025_0, &_call_cbs_primaryIndex_c2025_0, &_set_callback_cbs_primaryIndex_c2025_0);
}


// QSqlRecord QSqlDriver::record(const QString &tableName)

static void _init_cbs_record_c2025_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tableName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QSqlRecord > ();
}

static void _call_cbs_record_c2025_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QSqlRecord > ((QSqlRecord)((QSqlDriver_Adaptor *)cls)->cbs_record_c2025_0 (arg1));
}

static void _set_callback_cbs_record_c2025_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_record_c2025_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_record_c2025_0 ()
{
  return new qt_gsi::GenericMethod ("record", "@hide", true, &_init_cbs_record_c2025_0, &_call_cbs_record_c2025_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_record_c2025_0 ()
{
  return new qt_gsi::GenericMethod ("record", "@brief Virtual method QSqlRecord QSqlDriver::record(const QString &tableName)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_record_c2025_0, &_call_cbs_record_c2025_0, &_set_callback_cbs_record_c2025_0);
}


// bool QSqlDriver::rollbackTransaction()

static void _init_cbs_rollbackTransaction_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_rollbackTransaction_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QSqlDriver_Adaptor *)cls)->cbs_rollbackTransaction_0_0 ());
}

static void _set_callback_cbs_rollbackTransaction_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_rollbackTransaction_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_rollbackTransaction_0_0 ()
{
  return new qt_gsi::GenericMethod ("rollbackTransaction", "@hide", false, &_init_cbs_rollbackTransaction_0_0, &_call_cbs_rollbackTransaction_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_rollbackTransaction_0_0 ()
{
  return new qt_gsi::GenericMethod ("rollbackTransaction", "@brief Virtual method bool QSqlDriver::rollbackTransaction()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_rollbackTransaction_0_0, &_call_cbs_rollbackTransaction_0_0, &_set_callback_cbs_rollbackTransaction_0_0);
}


// QString QSqlDriver::sqlStatement(QSqlDriver::StatementType type, const QString &tableName, const QSqlRecord &rec, bool preparedStatement)

static void _init_cbs_sqlStatement_c7794_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QSqlDriver::StatementType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("tableName");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rec");
  decl->add_arg<const QSqlRecord & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("preparedStatement");
  decl->add_arg<bool > (argspec_3);
  decl->set_return<QString > ();
}

static void _call_cbs_sqlStatement_c7794_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QSqlDriver::StatementType>::target_type & arg1 = args.read<const qt_gsi::Converter<QSqlDriver::StatementType>::target_type & > ();
  const QString &arg2 = args.read<const QString & > ();
  const QSqlRecord &arg3 = args.read<const QSqlRecord & > ();
  bool arg4 = args.read<bool > ();
  ret.write<QString > ((QString)((QSqlDriver_Adaptor *)cls)->cbs_sqlStatement_c7794_0 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_sqlStatement_c7794_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_sqlStatement_c7794_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sqlStatement_c7794_0 ()
{
  return new qt_gsi::GenericMethod ("sqlStatement", "@hide", true, &_init_cbs_sqlStatement_c7794_0, &_call_cbs_sqlStatement_c7794_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sqlStatement_c7794_0 ()
{
  return new qt_gsi::GenericMethod ("sqlStatement", "@brief Virtual method QString QSqlDriver::sqlStatement(QSqlDriver::StatementType type, const QString &tableName, const QSqlRecord &rec, bool preparedStatement)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sqlStatement_c7794_0, &_call_cbs_sqlStatement_c7794_0, &_set_callback_cbs_sqlStatement_c7794_0);
}


// QStringList QSqlDriver::tables(QSql::TableType tableType)

static void _init_cbs_tables_c1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tableType");
  decl->add_arg<const qt_gsi::Converter<QSql::TableType>::target_type & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_cbs_tables_c1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QSql::TableType>::target_type & arg1 = args.read<const qt_gsi::Converter<QSql::TableType>::target_type & > ();
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)((QSqlDriver_Adaptor *)cls)->cbs_tables_c1843_0 (arg1));
}

static void _set_callback_cbs_tables_c1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_tables_c1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tables_c1843_0 ()
{
  return new qt_gsi::GenericMethod ("tables", "@hide", true, &_init_cbs_tables_c1843_0, &_call_cbs_tables_c1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tables_c1843_0 ()
{
  return new qt_gsi::GenericMethod ("tables", "@brief Virtual method QStringList QSqlDriver::tables(QSql::TableType tableType)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_tables_c1843_0, &_call_cbs_tables_c1843_0, &_set_callback_cbs_tables_c1843_0);
}


// void QSqlDriver::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QSqlDriver_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QSqlDriver::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QSqlDriver::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QSqlDriver_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QSqlDriver::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QSqlDriver::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QSqlDriver_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QSqlDriver::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QSqlDriver::setLastError(const QSqlError &e)

static void _init_cbs_setLastError_2220_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<const QSqlError & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setLastError_2220_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSqlError &arg1 = args.read<const QSqlError & > ();
  ((QSqlDriver_Adaptor *)cls)->cbs_setLastError_2220_0 (arg1);
}

static void _set_callback_cbs_setLastError_2220_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_setLastError_2220_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setLastError_2220_0 ()
{
  return new qt_gsi::GenericMethod ("*setLastError", "@hide", false, &_init_cbs_setLastError_2220_0, &_call_cbs_setLastError_2220_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setLastError_2220_0 ()
{
  return new qt_gsi::GenericMethod ("*setLastError", "@brief Virtual method void QSqlDriver::setLastError(const QSqlError &e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setLastError_2220_0, &_call_cbs_setLastError_2220_0, &_set_callback_cbs_setLastError_2220_0);
}


// void QSqlDriver::setOpen(bool o)

static void _init_cbs_setOpen_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("o");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setOpen_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QSqlDriver_Adaptor *)cls)->cbs_setOpen_864_0 (arg1);
}

static void _set_callback_cbs_setOpen_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_setOpen_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setOpen_864_0 ()
{
  return new qt_gsi::GenericMethod ("*setOpen", "@hide", false, &_init_cbs_setOpen_864_0, &_call_cbs_setOpen_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setOpen_864_0 ()
{
  return new qt_gsi::GenericMethod ("*setOpen", "@brief Virtual method void QSqlDriver::setOpen(bool o)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setOpen_864_0, &_call_cbs_setOpen_864_0, &_set_callback_cbs_setOpen_864_0);
}


// void QSqlDriver::setOpenError(bool e)

static void _init_cbs_setOpenError_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setOpenError_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QSqlDriver_Adaptor *)cls)->cbs_setOpenError_864_0 (arg1);
}

static void _set_callback_cbs_setOpenError_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_setOpenError_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setOpenError_864_0 ()
{
  return new qt_gsi::GenericMethod ("*setOpenError", "@hide", false, &_init_cbs_setOpenError_864_0, &_call_cbs_setOpenError_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setOpenError_864_0 ()
{
  return new qt_gsi::GenericMethod ("*setOpenError", "@brief Virtual method void QSqlDriver::setOpenError(bool e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setOpenError_864_0, &_call_cbs_setOpenError_864_0, &_set_callback_cbs_setOpenError_864_0);
}


// void QSqlDriver::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QSqlDriver_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QSqlDriver_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QSqlDriver::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QSqlDriver> decl_QSqlDriver;

gsi::Class<QSqlDriver_Adaptor> decl_QSqlDriver_Adaptor (decl_QSqlDriver, "QSqlDriver",
  gsi::Methods(_create_fp_isIdentifierEscapedImplementation_c4919 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_stripDelimitersImplementation_c4919 ()) +
  gsi::Methods(_create_fp_subscribeToNotificationImplementation_2025 ()) +
  gsi::Methods(_create_fp_subscribedToNotificationsImplementation_c0 ()) +
  gsi::Methods(_create_fp_unsubscribeFromNotificationImplementation_2025 ()) +
  gsi::Methods(_create_cbs_beginTransaction_0_0 ()) +
  gsi::Methods(_create_callback_cbs_beginTransaction_0_0 ()) +
  gsi::Methods(_create_cbs_close_0_0 ()) +
  gsi::Methods(_create_callback_cbs_close_0_0 ()) +
  gsi::Methods(_create_cbs_commitTransaction_0_0 ()) +
  gsi::Methods(_create_callback_cbs_commitTransaction_0_0 ()) +
  gsi::Methods(_create_cbs_createResult_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_createResult_c0_0 ()) +
  gsi::Methods(_create_cbs_escapeIdentifier_c4919_0 ()) +
  gsi::Methods(_create_callback_cbs_escapeIdentifier_c4919_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_formatValue_c2938_1 ()) +
  gsi::Methods(_create_callback_cbs_formatValue_c2938_1 ()) +
  gsi::Methods(_create_cbs_handle_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_handle_c0_0 ()) +
  gsi::Methods(_create_cbs_hasFeature_c2893_0 ()) +
  gsi::Methods(_create_callback_cbs_hasFeature_c2893_0 ()) +
  gsi::Methods(_create_cbs_isOpen_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_isOpen_c0_0 ()) +
  gsi::Methods(_create_cbs_open_10352_5 ()) +
  gsi::Methods(_create_callback_cbs_open_10352_5 ()) +
  gsi::Methods(_create_cbs_primaryIndex_c2025_0 ()) +
  gsi::Methods(_create_callback_cbs_primaryIndex_c2025_0 ()) +
  gsi::Methods(_create_cbs_record_c2025_0 ()) +
  gsi::Methods(_create_callback_cbs_record_c2025_0 ()) +
  gsi::Methods(_create_cbs_rollbackTransaction_0_0 ()) +
  gsi::Methods(_create_callback_cbs_rollbackTransaction_0_0 ()) +
  gsi::Methods(_create_cbs_sqlStatement_c7794_0 ()) +
  gsi::Methods(_create_callback_cbs_sqlStatement_c7794_0 ()) +
  gsi::Methods(_create_cbs_tables_c1843_0 ()) +
  gsi::Methods(_create_callback_cbs_tables_c1843_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_setLastError_2220_0 ()) +
  gsi::Methods(_create_callback_cbs_setLastError_2220_0 ()) +
  gsi::Methods(_create_cbs_setOpen_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setOpen_864_0 ()) +
  gsi::Methods(_create_cbs_setOpenError_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setOpenError_864_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QSqlDriver_Adaptor_1302 ()),
  "@qt\n@brief Binding of QSqlDriver");

}


//  Implementation of the enum wrapper class for QSqlDriver::DriverFeature
namespace qt_gsi
{

static QSqlDriver_DriverFeature_Enum *c_1_QSqlDriver_DriverFeature_Enum () { return new QSqlDriver_DriverFeature_Enum (QSqlDriver::Transactions); }
static QSqlDriver_DriverFeature_Enum *c_2_QSqlDriver_DriverFeature_Enum () { return new QSqlDriver_DriverFeature_Enum (QSqlDriver::QuerySize); }
static QSqlDriver_DriverFeature_Enum *c_3_QSqlDriver_DriverFeature_Enum () { return new QSqlDriver_DriverFeature_Enum (QSqlDriver::BLOB); }
static QSqlDriver_DriverFeature_Enum *c_4_QSqlDriver_DriverFeature_Enum () { return new QSqlDriver_DriverFeature_Enum (QSqlDriver::Unicode); }
static QSqlDriver_DriverFeature_Enum *c_5_QSqlDriver_DriverFeature_Enum () { return new QSqlDriver_DriverFeature_Enum (QSqlDriver::PreparedQueries); }
static QSqlDriver_DriverFeature_Enum *c_6_QSqlDriver_DriverFeature_Enum () { return new QSqlDriver_DriverFeature_Enum (QSqlDriver::NamedPlaceholders); }
static QSqlDriver_DriverFeature_Enum *c_7_QSqlDriver_DriverFeature_Enum () { return new QSqlDriver_DriverFeature_Enum (QSqlDriver::PositionalPlaceholders); }
static QSqlDriver_DriverFeature_Enum *c_8_QSqlDriver_DriverFeature_Enum () { return new QSqlDriver_DriverFeature_Enum (QSqlDriver::LastInsertId); }
static QSqlDriver_DriverFeature_Enum *c_9_QSqlDriver_DriverFeature_Enum () { return new QSqlDriver_DriverFeature_Enum (QSqlDriver::BatchOperations); }
static QSqlDriver_DriverFeature_Enum *c_10_QSqlDriver_DriverFeature_Enum () { return new QSqlDriver_DriverFeature_Enum (QSqlDriver::SimpleLocking); }
static QSqlDriver_DriverFeature_Enum *c_11_QSqlDriver_DriverFeature_Enum () { return new QSqlDriver_DriverFeature_Enum (QSqlDriver::LowPrecisionNumbers); }
static QSqlDriver_DriverFeature_Enum *c_12_QSqlDriver_DriverFeature_Enum () { return new QSqlDriver_DriverFeature_Enum (QSqlDriver::EventNotifications); }
static QSqlDriver_DriverFeature_Enum *c_13_QSqlDriver_DriverFeature_Enum () { return new QSqlDriver_DriverFeature_Enum (QSqlDriver::FinishQuery); }
static QSqlDriver_DriverFeature_Enum *c_14_QSqlDriver_DriverFeature_Enum () { return new QSqlDriver_DriverFeature_Enum (QSqlDriver::MultipleResultSets); }

static gsi::Methods mkdefs_QSqlDriver_DriverFeature () {
  return
    gsi::constant ("Transactions", &qt_gsi::c_1_QSqlDriver_DriverFeature_Enum, "@brief Enum constant QSqlDriver::Transactions") +
    gsi::constant ("QuerySize", &qt_gsi::c_2_QSqlDriver_DriverFeature_Enum, "@brief Enum constant QSqlDriver::QuerySize") +
    gsi::constant ("BLOB", &qt_gsi::c_3_QSqlDriver_DriverFeature_Enum, "@brief Enum constant QSqlDriver::BLOB") +
    gsi::constant ("Unicode", &qt_gsi::c_4_QSqlDriver_DriverFeature_Enum, "@brief Enum constant QSqlDriver::Unicode") +
    gsi::constant ("PreparedQueries", &qt_gsi::c_5_QSqlDriver_DriverFeature_Enum, "@brief Enum constant QSqlDriver::PreparedQueries") +
    gsi::constant ("NamedPlaceholders", &qt_gsi::c_6_QSqlDriver_DriverFeature_Enum, "@brief Enum constant QSqlDriver::NamedPlaceholders") +
    gsi::constant ("PositionalPlaceholders", &qt_gsi::c_7_QSqlDriver_DriverFeature_Enum, "@brief Enum constant QSqlDriver::PositionalPlaceholders") +
    gsi::constant ("LastInsertId", &qt_gsi::c_8_QSqlDriver_DriverFeature_Enum, "@brief Enum constant QSqlDriver::LastInsertId") +
    gsi::constant ("BatchOperations", &qt_gsi::c_9_QSqlDriver_DriverFeature_Enum, "@brief Enum constant QSqlDriver::BatchOperations") +
    gsi::constant ("SimpleLocking", &qt_gsi::c_10_QSqlDriver_DriverFeature_Enum, "@brief Enum constant QSqlDriver::SimpleLocking") +
    gsi::constant ("LowPrecisionNumbers", &qt_gsi::c_11_QSqlDriver_DriverFeature_Enum, "@brief Enum constant QSqlDriver::LowPrecisionNumbers") +
    gsi::constant ("EventNotifications", &qt_gsi::c_12_QSqlDriver_DriverFeature_Enum, "@brief Enum constant QSqlDriver::EventNotifications") +
    gsi::constant ("FinishQuery", &qt_gsi::c_13_QSqlDriver_DriverFeature_Enum, "@brief Enum constant QSqlDriver::FinishQuery") +
    gsi::constant ("MultipleResultSets", &qt_gsi::c_14_QSqlDriver_DriverFeature_Enum, "@brief Enum constant QSqlDriver::MultipleResultSets");
}

static std::string to_s_QSqlDriver_DriverFeature_Enum (const QSqlDriver_DriverFeature_Enum *e)
{
  if (e->value () == QSqlDriver::Transactions) { return tl::sprintf ("Transactions (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlDriver::QuerySize) { return tl::sprintf ("QuerySize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlDriver::BLOB) { return tl::sprintf ("BLOB (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlDriver::Unicode) { return tl::sprintf ("Unicode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlDriver::PreparedQueries) { return tl::sprintf ("PreparedQueries (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlDriver::NamedPlaceholders) { return tl::sprintf ("NamedPlaceholders (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlDriver::PositionalPlaceholders) { return tl::sprintf ("PositionalPlaceholders (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlDriver::LastInsertId) { return tl::sprintf ("LastInsertId (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlDriver::BatchOperations) { return tl::sprintf ("BatchOperations (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlDriver::SimpleLocking) { return tl::sprintf ("SimpleLocking (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlDriver::LowPrecisionNumbers) { return tl::sprintf ("LowPrecisionNumbers (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlDriver::EventNotifications) { return tl::sprintf ("EventNotifications (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlDriver::FinishQuery) { return tl::sprintf ("FinishQuery (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlDriver::MultipleResultSets) { return tl::sprintf ("MultipleResultSets (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSqlDriver_DriverFeature_Enum (const QSqlDriver_DriverFeature_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSqlDriver_DriverFeature_Enum *from_i_QSqlDriver_DriverFeature_Enum (unsigned int i)
{
  return new QSqlDriver_DriverFeature_Enum ((QSqlDriver::DriverFeature) i);
}

static bool equalQSqlDriver_DriverFeature_Enum (const QSqlDriver_DriverFeature_Enum *e, QSqlDriver_DriverFeature_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSqlDriver_DriverFeature_Enum (const QSqlDriver_DriverFeature_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSqlDriver_DriverFeature_Enums oropQSqlDriver_DriverFeature_Enums (const QSqlDriver_DriverFeature_Enums *e, const QSqlDriver_DriverFeature_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSqlDriver_DriverFeature_Enums andopQSqlDriver_DriverFeature_Enums (const QSqlDriver_DriverFeature_Enums *e, const QSqlDriver_DriverFeature_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSqlDriver_DriverFeature_Enums xoropQSqlDriver_DriverFeature_Enums (const QSqlDriver_DriverFeature_Enums *e, const QSqlDriver_DriverFeature_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSqlDriver_DriverFeature_Enums (const QSqlDriver_DriverFeature_Enums *e)
{
  std::string l;
  if (e->testFlag (QSqlDriver::Transactions)) { if (!l.empty ()) l += "|"; l += "Transactions"; }
  if (e->testFlag (QSqlDriver::QuerySize)) { if (!l.empty ()) l += "|"; l += "QuerySize"; }
  if (e->testFlag (QSqlDriver::BLOB)) { if (!l.empty ()) l += "|"; l += "BLOB"; }
  if (e->testFlag (QSqlDriver::Unicode)) { if (!l.empty ()) l += "|"; l += "Unicode"; }
  if (e->testFlag (QSqlDriver::PreparedQueries)) { if (!l.empty ()) l += "|"; l += "PreparedQueries"; }
  if (e->testFlag (QSqlDriver::NamedPlaceholders)) { if (!l.empty ()) l += "|"; l += "NamedPlaceholders"; }
  if (e->testFlag (QSqlDriver::PositionalPlaceholders)) { if (!l.empty ()) l += "|"; l += "PositionalPlaceholders"; }
  if (e->testFlag (QSqlDriver::LastInsertId)) { if (!l.empty ()) l += "|"; l += "LastInsertId"; }
  if (e->testFlag (QSqlDriver::BatchOperations)) { if (!l.empty ()) l += "|"; l += "BatchOperations"; }
  if (e->testFlag (QSqlDriver::SimpleLocking)) { if (!l.empty ()) l += "|"; l += "SimpleLocking"; }
  if (e->testFlag (QSqlDriver::LowPrecisionNumbers)) { if (!l.empty ()) l += "|"; l += "LowPrecisionNumbers"; }
  if (e->testFlag (QSqlDriver::EventNotifications)) { if (!l.empty ()) l += "|"; l += "EventNotifications"; }
  if (e->testFlag (QSqlDriver::FinishQuery)) { if (!l.empty ()) l += "|"; l += "FinishQuery"; }
  if (e->testFlag (QSqlDriver::MultipleResultSets)) { if (!l.empty ()) l += "|"; l += "MultipleResultSets"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSqlDriver_DriverFeature_Enums (const QSqlDriver_DriverFeature_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSqlDriver_DriverFeature_Enums (const QSqlDriver_DriverFeature_Enums *e, const QSqlDriver_DriverFeature_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSqlDriver_DriverFeature_Enums> decl_QSqlDriver_DriverFeature_Enums ("QSqlDriver_QFlags_DriverFeature",
  gsi::method_ext ("|", &qt_gsi::oropQSqlDriver_DriverFeature_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSqlDriver_DriverFeature_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSqlDriver_DriverFeature_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSqlDriver_DriverFeature_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSqlDriver_DriverFeature_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSqlDriver_DriverFeature_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSqlDriver::DriverFeature> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSqlDriver_DriverFeature_Enum> decl_QSqlDriver_DriverFeature_Enum (decl_QSqlDriver_DriverFeature_Enums, "QSqlDriver_DriverFeature",
  qt_gsi::mkdefs_QSqlDriver_DriverFeature () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSqlDriver_DriverFeature_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSqlDriver_DriverFeature_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSqlDriver_DriverFeature_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSqlDriver_DriverFeature_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSqlDriver_DriverFeature_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSqlDriver::DriverFeature enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSqlDriver> inject_QSqlDriver_DriverFeature_Enum_in_parent (qt_gsi::mkdefs_QSqlDriver_DriverFeature ());
static gsi::ClassExt<QSqlDriver> decl_QSqlDriver_DriverFeature_Enum_as_child (decl_QSqlDriver_DriverFeature_Enum, "DriverFeature");

}


//  Implementation of the enum wrapper class for QSqlDriver::IdentifierType
namespace qt_gsi
{

static QSqlDriver_IdentifierType_Enum *c_1_QSqlDriver_IdentifierType_Enum () { return new QSqlDriver_IdentifierType_Enum (QSqlDriver::FieldName); }
static QSqlDriver_IdentifierType_Enum *c_2_QSqlDriver_IdentifierType_Enum () { return new QSqlDriver_IdentifierType_Enum (QSqlDriver::TableName); }

static gsi::Methods mkdefs_QSqlDriver_IdentifierType () {
  return
    gsi::constant ("FieldName", &qt_gsi::c_1_QSqlDriver_IdentifierType_Enum, "@brief Enum constant QSqlDriver::FieldName") +
    gsi::constant ("TableName", &qt_gsi::c_2_QSqlDriver_IdentifierType_Enum, "@brief Enum constant QSqlDriver::TableName");
}

static std::string to_s_QSqlDriver_IdentifierType_Enum (const QSqlDriver_IdentifierType_Enum *e)
{
  if (e->value () == QSqlDriver::FieldName) { return tl::sprintf ("FieldName (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlDriver::TableName) { return tl::sprintf ("TableName (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSqlDriver_IdentifierType_Enum (const QSqlDriver_IdentifierType_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSqlDriver_IdentifierType_Enum *from_i_QSqlDriver_IdentifierType_Enum (unsigned int i)
{
  return new QSqlDriver_IdentifierType_Enum ((QSqlDriver::IdentifierType) i);
}

static bool equalQSqlDriver_IdentifierType_Enum (const QSqlDriver_IdentifierType_Enum *e, QSqlDriver_IdentifierType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSqlDriver_IdentifierType_Enum (const QSqlDriver_IdentifierType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSqlDriver_IdentifierType_Enums oropQSqlDriver_IdentifierType_Enums (const QSqlDriver_IdentifierType_Enums *e, const QSqlDriver_IdentifierType_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSqlDriver_IdentifierType_Enums andopQSqlDriver_IdentifierType_Enums (const QSqlDriver_IdentifierType_Enums *e, const QSqlDriver_IdentifierType_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSqlDriver_IdentifierType_Enums xoropQSqlDriver_IdentifierType_Enums (const QSqlDriver_IdentifierType_Enums *e, const QSqlDriver_IdentifierType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSqlDriver_IdentifierType_Enums (const QSqlDriver_IdentifierType_Enums *e)
{
  std::string l;
  if (e->testFlag (QSqlDriver::FieldName)) { if (!l.empty ()) l += "|"; l += "FieldName"; }
  if (e->testFlag (QSqlDriver::TableName)) { if (!l.empty ()) l += "|"; l += "TableName"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSqlDriver_IdentifierType_Enums (const QSqlDriver_IdentifierType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSqlDriver_IdentifierType_Enums (const QSqlDriver_IdentifierType_Enums *e, const QSqlDriver_IdentifierType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSqlDriver_IdentifierType_Enums> decl_QSqlDriver_IdentifierType_Enums ("QSqlDriver_QFlags_IdentifierType",
  gsi::method_ext ("|", &qt_gsi::oropQSqlDriver_IdentifierType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSqlDriver_IdentifierType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSqlDriver_IdentifierType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSqlDriver_IdentifierType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSqlDriver_IdentifierType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSqlDriver_IdentifierType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSqlDriver::IdentifierType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSqlDriver_IdentifierType_Enum> decl_QSqlDriver_IdentifierType_Enum (decl_QSqlDriver_IdentifierType_Enums, "QSqlDriver_IdentifierType",
  qt_gsi::mkdefs_QSqlDriver_IdentifierType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSqlDriver_IdentifierType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSqlDriver_IdentifierType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSqlDriver_IdentifierType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSqlDriver_IdentifierType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSqlDriver_IdentifierType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSqlDriver::IdentifierType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSqlDriver> inject_QSqlDriver_IdentifierType_Enum_in_parent (qt_gsi::mkdefs_QSqlDriver_IdentifierType ());
static gsi::ClassExt<QSqlDriver> decl_QSqlDriver_IdentifierType_Enum_as_child (decl_QSqlDriver_IdentifierType_Enum, "IdentifierType");

}


//  Implementation of the enum wrapper class for QSqlDriver::StatementType
namespace qt_gsi
{

static QSqlDriver_StatementType_Enum *c_1_QSqlDriver_StatementType_Enum () { return new QSqlDriver_StatementType_Enum (QSqlDriver::WhereStatement); }
static QSqlDriver_StatementType_Enum *c_2_QSqlDriver_StatementType_Enum () { return new QSqlDriver_StatementType_Enum (QSqlDriver::SelectStatement); }
static QSqlDriver_StatementType_Enum *c_3_QSqlDriver_StatementType_Enum () { return new QSqlDriver_StatementType_Enum (QSqlDriver::UpdateStatement); }
static QSqlDriver_StatementType_Enum *c_4_QSqlDriver_StatementType_Enum () { return new QSqlDriver_StatementType_Enum (QSqlDriver::InsertStatement); }
static QSqlDriver_StatementType_Enum *c_5_QSqlDriver_StatementType_Enum () { return new QSqlDriver_StatementType_Enum (QSqlDriver::DeleteStatement); }

static gsi::Methods mkdefs_QSqlDriver_StatementType () {
  return
    gsi::constant ("WhereStatement", &qt_gsi::c_1_QSqlDriver_StatementType_Enum, "@brief Enum constant QSqlDriver::WhereStatement") +
    gsi::constant ("SelectStatement", &qt_gsi::c_2_QSqlDriver_StatementType_Enum, "@brief Enum constant QSqlDriver::SelectStatement") +
    gsi::constant ("UpdateStatement", &qt_gsi::c_3_QSqlDriver_StatementType_Enum, "@brief Enum constant QSqlDriver::UpdateStatement") +
    gsi::constant ("InsertStatement", &qt_gsi::c_4_QSqlDriver_StatementType_Enum, "@brief Enum constant QSqlDriver::InsertStatement") +
    gsi::constant ("DeleteStatement", &qt_gsi::c_5_QSqlDriver_StatementType_Enum, "@brief Enum constant QSqlDriver::DeleteStatement");
}

static std::string to_s_QSqlDriver_StatementType_Enum (const QSqlDriver_StatementType_Enum *e)
{
  if (e->value () == QSqlDriver::WhereStatement) { return tl::sprintf ("WhereStatement (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlDriver::SelectStatement) { return tl::sprintf ("SelectStatement (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlDriver::UpdateStatement) { return tl::sprintf ("UpdateStatement (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlDriver::InsertStatement) { return tl::sprintf ("InsertStatement (%u)", (unsigned int) e->value ()); }
  if (e->value () == QSqlDriver::DeleteStatement) { return tl::sprintf ("DeleteStatement (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QSqlDriver_StatementType_Enum (const QSqlDriver_StatementType_Enum *e)
{
  return (unsigned int) e->value ();
}

static QSqlDriver_StatementType_Enum *from_i_QSqlDriver_StatementType_Enum (unsigned int i)
{
  return new QSqlDriver_StatementType_Enum ((QSqlDriver::StatementType) i);
}

static bool equalQSqlDriver_StatementType_Enum (const QSqlDriver_StatementType_Enum *e, QSqlDriver_StatementType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QSqlDriver_StatementType_Enum (const QSqlDriver_StatementType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QSqlDriver_StatementType_Enums oropQSqlDriver_StatementType_Enums (const QSqlDriver_StatementType_Enums *e, const QSqlDriver_StatementType_Enums &d)
{
  return e->flags () | d.flags ();
}

static QSqlDriver_StatementType_Enums andopQSqlDriver_StatementType_Enums (const QSqlDriver_StatementType_Enums *e, const QSqlDriver_StatementType_Enums &d)
{
  return e->flags () & d.flags ();
}

static QSqlDriver_StatementType_Enums xoropQSqlDriver_StatementType_Enums (const QSqlDriver_StatementType_Enums *e, const QSqlDriver_StatementType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QSqlDriver_StatementType_Enums (const QSqlDriver_StatementType_Enums *e)
{
  std::string l;
  if (e->testFlag (QSqlDriver::WhereStatement)) { if (!l.empty ()) l += "|"; l += "WhereStatement"; }
  if (e->testFlag (QSqlDriver::SelectStatement)) { if (!l.empty ()) l += "|"; l += "SelectStatement"; }
  if (e->testFlag (QSqlDriver::UpdateStatement)) { if (!l.empty ()) l += "|"; l += "UpdateStatement"; }
  if (e->testFlag (QSqlDriver::InsertStatement)) { if (!l.empty ()) l += "|"; l += "InsertStatement"; }
  if (e->testFlag (QSqlDriver::DeleteStatement)) { if (!l.empty ()) l += "|"; l += "DeleteStatement"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QSqlDriver_StatementType_Enums (const QSqlDriver_StatementType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QSqlDriver_StatementType_Enums (const QSqlDriver_StatementType_Enums *e, const QSqlDriver_StatementType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QSqlDriver_StatementType_Enums> decl_QSqlDriver_StatementType_Enums ("QSqlDriver_QFlags_StatementType",
  gsi::method_ext ("|", &qt_gsi::oropQSqlDriver_StatementType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQSqlDriver_StatementType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQSqlDriver_StatementType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSqlDriver_StatementType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSqlDriver_StatementType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QSqlDriver_StatementType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QSqlDriver::StatementType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QSqlDriver_StatementType_Enum> decl_QSqlDriver_StatementType_Enum (decl_QSqlDriver_StatementType_Enums, "QSqlDriver_StatementType",
  qt_gsi::mkdefs_QSqlDriver_StatementType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QSqlDriver_StatementType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QSqlDriver_StatementType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQSqlDriver_StatementType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QSqlDriver_StatementType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QSqlDriver_StatementType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QSqlDriver::StatementType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QSqlDriver> inject_QSqlDriver_StatementType_Enum_in_parent (qt_gsi::mkdefs_QSqlDriver_StatementType ());
static gsi::ClassExt<QSqlDriver> decl_QSqlDriver_StatementType_Enum_as_child (decl_QSqlDriver_StatementType_Enum, "StatementType");

}

