
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPushButton.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQPushButton_EventAdaptor.h"
#include "gsiDeclQPushButton_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPushButton

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QPushButton::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// bool QPushButton::autoDefault()


static void _init_f_autoDefault_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_autoDefault_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPushButton *)cls)->autoDefault ());
}

static qt_gsi::GenericMethod *_create_f_autoDefault_c0 ()
{
  return new qt_gsi::GenericMethod (":autoDefault", "@brief Method bool QPushButton::autoDefault()\n", true, &_init_f_autoDefault_c0, &_call_f_autoDefault_c0);
}

// bool QPushButton::isDefault()


static void _init_f_isDefault_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDefault_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPushButton *)cls)->isDefault ());
}

static qt_gsi::GenericMethod *_create_f_isDefault_c0 ()
{
  return new qt_gsi::GenericMethod ("isDefault?|:default", "@brief Method bool QPushButton::isDefault()\n", true, &_init_f_isDefault_c0, &_call_f_isDefault_c0);
}

// bool QPushButton::isFlat()


static void _init_f_isFlat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isFlat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPushButton *)cls)->isFlat ());
}

static qt_gsi::GenericMethod *_create_f_isFlat_c0 ()
{
  return new qt_gsi::GenericMethod ("isFlat?|:flat", "@brief Method bool QPushButton::isFlat()\n", true, &_init_f_isFlat_c0, &_call_f_isFlat_c0);
}

// QMenu *QPushButton::menu()


static void _init_f_menu_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMenu * > ();
}

static void _call_f_menu_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QMenu * > ((QMenu *)((QPushButton *)cls)->menu ());
}

static qt_gsi::GenericMethod *_create_f_menu_c0 ()
{
  return new qt_gsi::GenericMethod (":menu", "@brief Method QMenu *QPushButton::menu()\n", true, &_init_f_menu_c0, &_call_f_menu_c0);
}

// QSize QPushButton::minimumSizeHint()


static void _init_f_minimumSizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QPushButton *)cls)->minimumSizeHint ());
}

static qt_gsi::GenericMethod *_create_f_minimumSizeHint_c0 ()
{
  return new qt_gsi::GenericMethod (":minimumSizeHint", "@brief Method QSize QPushButton::minimumSizeHint()\nThis is a reimplementation of QWidget::minimumSizeHint", true, &_init_f_minimumSizeHint_c0, &_call_f_minimumSizeHint_c0);
}

// void QPushButton::setAutoDefault(bool)


static void _init_f_setAutoDefault_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoDefault_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QPushButton *)cls)->setAutoDefault (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAutoDefault_864 ()
{
  return new qt_gsi::GenericMethod ("setAutoDefault|autoDefault=", "@brief Method void QPushButton::setAutoDefault(bool)\n", false, &_init_f_setAutoDefault_864, &_call_f_setAutoDefault_864);
}

// void QPushButton::setDefault(bool)


static void _init_f_setDefault_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefault_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QPushButton *)cls)->setDefault (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDefault_864 ()
{
  return new qt_gsi::GenericMethod ("setDefault|default=", "@brief Method void QPushButton::setDefault(bool)\n", false, &_init_f_setDefault_864, &_call_f_setDefault_864);
}

// void QPushButton::setFlat(bool)


static void _init_f_setFlat_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFlat_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QPushButton *)cls)->setFlat (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFlat_864 ()
{
  return new qt_gsi::GenericMethod ("setFlat|flat=", "@brief Method void QPushButton::setFlat(bool)\n", false, &_init_f_setFlat_864, &_call_f_setFlat_864);
}

// void QPushButton::setMenu(QMenu *menu)


static void _init_f_setMenu_1108 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("menu");
  decl->add_arg<QMenu * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMenu_1108 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMenu *arg1 = args.read<QMenu * > ();
  ((QPushButton *)cls)->setMenu (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMenu_1108 ()
{
  return new qt_gsi::GenericMethod ("setMenu|menu=", "@brief Method void QPushButton::setMenu(QMenu *menu)\n", false, &_init_f_setMenu_1108, &_call_f_setMenu_1108);
}

// void QPushButton::showMenu()


static void _init_f_showMenu_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showMenu_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPushButton *)cls)->showMenu ();
}

static qt_gsi::GenericMethod *_create_f_showMenu_0 ()
{
  return new qt_gsi::GenericMethod ("showMenu", "@brief Method void QPushButton::showMenu()\n", false, &_init_f_showMenu_0, &_call_f_showMenu_0);
}

// QSize QPushButton::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QPushButton *)cls)->sizeHint ());
}

static qt_gsi::GenericMethod *_create_f_sizeHint_c0 ()
{
  return new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QPushButton::sizeHint()\nThis is a reimplementation of QWidget::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
}

// static QString QPushButton::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QPushButton::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPushButton::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QPushButton::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QPushButton::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPushButton::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QPushButton::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QPushButton::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QPushButton::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QPushButton::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QPushButton::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QPushButton::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QPushButton, QPushButton_EventAdaptor> ea_QPushButton;

namespace gsi
{
extern gsi::Class<QAbstractButton> decl_QAbstractButton;

gsi::Class<QPushButton> decl_QPushButton (ea_QPushButton, decl_QAbstractButton, "QPushButton_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_autoDefault_c0 ()) +
  gsi::Methods(_create_f_isDefault_c0 ()) +
  gsi::Methods(_create_f_isFlat_c0 ()) +
  gsi::Methods(_create_f_menu_c0 ()) +
  gsi::Methods(_create_f_minimumSizeHint_c0 ()) +
  gsi::Methods(_create_f_setAutoDefault_864 ()) +
  gsi::Methods(_create_f_setDefault_864 ()) +
  gsi::Methods(_create_f_setFlat_864 ()) +
  gsi::Methods(_create_f_setMenu_1108 ()) +
  gsi::Methods(_create_f_showMenu_0 ()) +
  gsi::Methods(_create_f_sizeHint_c0 ()) +
  qt_gsi::qt_signal<QPushButton, QPushButton_EventAdaptor, bool> ("clicked", &QPushButton_EventAdaptor::clicked_e_864, gsi::arg("checked"), "@brief Signal declaration for QPushButton::clicked(bool checked)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QPushButton, QPushButton_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QPushButton_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QPushButton::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QPushButton, QPushButton_EventAdaptor, QObject *> ("destroyed", &QPushButton_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QPushButton::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QPushButton, QPushButton_EventAdaptor> ("pressed", &QPushButton_EventAdaptor::pressed_e_0, "@brief Signal declaration for QPushButton::pressed()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QPushButton, QPushButton_EventAdaptor> ("released", &QPushButton_EventAdaptor::released_e_0, "@brief Signal declaration for QPushButton::released()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QPushButton, QPushButton_EventAdaptor, bool> ("toggled", &QPushButton_EventAdaptor::toggled_e_864, gsi::arg("checked"), "@brief Signal declaration for QPushButton::toggled(bool checked)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QPushButton");
}


class QPushButton_Adaptor : public QPushButton, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPushButton_Adaptor();

  //  [adaptor ctor] QPushButton::QPushButton(QWidget *parent)
  QPushButton_Adaptor() : QPushButton()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPushButton::QPushButton(QWidget *parent)
  QPushButton_Adaptor(QWidget *parent) : QPushButton(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPushButton::QPushButton(const QString &text, QWidget *parent)
  QPushButton_Adaptor(const QString &text) : QPushButton(text)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPushButton::QPushButton(const QString &text, QWidget *parent)
  QPushButton_Adaptor(const QString &text, QWidget *parent) : QPushButton(text, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPushButton::QPushButton(const QIcon &icon, const QString &text, QWidget *parent)
  QPushButton_Adaptor(const QIcon &icon, const QString &text) : QPushButton(icon, text)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPushButton::QPushButton(const QIcon &icon, const QString &text, QWidget *parent)
  QPushButton_Adaptor(const QIcon &icon, const QString &text, QWidget *parent) : QPushButton(icon, text, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QPushButton::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QPushButton_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QPushButton::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QPushButton::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QPushButton_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QPushButton::destroy(destroyWindow, destroySubWindows);
  }

  //  bool QPushButton::focusNextChild()
  bool fp_QPushButton_focusNextChild_0 () {
    return QPushButton::focusNextChild();
  }

  //  bool QPushButton::focusPreviousChild()
  bool fp_QPushButton_focusPreviousChild_0 () {
    return QPushButton::focusPreviousChild();
  }

  //  void QPushButton::initStyleOption(QStyleOptionButton *option)
  void fp_QPushButton_initStyleOption_c2501 (QStyleOptionButton *option) const {
    QPushButton::initStyleOption(option);
  }

  //  int QPushButton::receivers(const char *signal)
  int fp_QPushButton_receivers_c1731 (const char *signal) const {
    return QPushButton::receivers(signal);
  }

  //  void QPushButton::resetInputContext()
  void fp_QPushButton_resetInputContext_0 () {
    QPushButton::resetInputContext();
  }

  //  QObject *QPushButton::sender()
  QObject * fp_QPushButton_sender_c0 () const {
    return QPushButton::sender();
  }

  //  void QPushButton::updateMicroFocus()
  void fp_QPushButton_updateMicroFocus_0 () {
    QPushButton::updateMicroFocus();
  }

  //  [adaptor impl] bool QPushButton::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QPushButton::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QPushButton_Adaptor, bool, QObject *, QEvent *>(&QPushButton_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QPushButton::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] int QPushButton::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QPushButton::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QPushButton_Adaptor, int, int>(&QPushButton_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QPushButton::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QPushButton::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QPushButton::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QPushButton_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QPushButton_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QPushButton::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QPushButton::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QPushButton::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QPushButton_Adaptor, QSize>(&QPushButton_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QPushButton::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QPushButton::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QPushButton::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QPushButton_Adaptor, QPaintEngine *>(&QPushButton_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QPushButton::paintEngine();
    }
  }

  //  [adaptor impl] void QPushButton::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QPushButton::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QPushButton_Adaptor, bool>(&QPushButton_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QPushButton::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QPushButton::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QPushButton::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QPushButton_Adaptor, QSize>(&QPushButton_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QPushButton::sizeHint();
    }
  }

  //  [adaptor impl] void QPushButton::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QPushButton::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QPushButton_Adaptor, QActionEvent *>(&QPushButton_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QPushButton::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::changeEvent(QEvent *e)
  void cbs_changeEvent_1217_0(QEvent *e)
  {
    QPushButton::changeEvent(e);
  }

  virtual void changeEvent(QEvent *e)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QPushButton_Adaptor, QEvent *>(&QPushButton_Adaptor::cbs_changeEvent_1217_0, e);
    } else {
      QPushButton::changeEvent(e);
    }
  }

  //  [adaptor impl] void QPushButton::checkStateSet()
  void cbs_checkStateSet_0_0()
  {
    QPushButton::checkStateSet();
  }

  virtual void checkStateSet()
  {
    if (cb_checkStateSet_0_0.can_issue()) {
      cb_checkStateSet_0_0.issue<QPushButton_Adaptor>(&QPushButton_Adaptor::cbs_checkStateSet_0_0);
    } else {
      QPushButton::checkStateSet();
    }
  }

  //  [adaptor impl] void QPushButton::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QPushButton::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QPushButton_Adaptor, QChildEvent *>(&QPushButton_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QPushButton::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QPushButton::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QPushButton_Adaptor, QCloseEvent *>(&QPushButton_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QPushButton::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QPushButton::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QPushButton_Adaptor, QContextMenuEvent *>(&QPushButton_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QPushButton::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QPushButton::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QPushButton_Adaptor, QEvent *>(&QPushButton_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QPushButton::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QPushButton::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QPushButton_Adaptor, const char *>(&QPushButton_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QPushButton::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QPushButton::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QPushButton::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QPushButton_Adaptor, QDragEnterEvent *>(&QPushButton_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QPushButton::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QPushButton::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QPushButton_Adaptor, QDragLeaveEvent *>(&QPushButton_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QPushButton::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QPushButton::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QPushButton_Adaptor, QDragMoveEvent *>(&QPushButton_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QPushButton::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QPushButton::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QPushButton_Adaptor, QDropEvent *>(&QPushButton_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QPushButton::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QPushButton::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QPushButton_Adaptor, bool>(&QPushButton_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QPushButton::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QPushButton::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QPushButton_Adaptor, QEvent *>(&QPushButton_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QPushButton::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QPushButton::event(QEvent *e)
  bool cbs_event_1217_0(QEvent *e)
  {
    return QPushButton::event(e);
  }

  virtual bool event(QEvent *e)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QPushButton_Adaptor, bool, QEvent *>(&QPushButton_Adaptor::cbs_event_1217_0, e);
    } else {
      return QPushButton::event(e);
    }
  }

  //  [adaptor impl] void QPushButton::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QPushButton::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QPushButton_Adaptor, QFocusEvent *>(&QPushButton_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QPushButton::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] bool QPushButton::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QPushButton::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QPushButton_Adaptor, bool, bool>(&QPushButton_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QPushButton::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QPushButton::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QPushButton::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QPushButton_Adaptor, QFocusEvent *>(&QPushButton_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QPushButton::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QPushButton::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QPushButton_Adaptor, const QFont &>(&QPushButton_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QPushButton::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QPushButton::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QPushButton_Adaptor, QHideEvent *>(&QPushButton_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QPushButton::hideEvent(arg1);
    }
  }

  //  [adaptor impl] bool QPushButton::hitButton(const QPoint &pos)
  bool cbs_hitButton_c1916_0(const QPoint &pos) const
  {
    return QPushButton::hitButton(pos);
  }

  virtual bool hitButton(const QPoint &pos) const
  {
    if (cb_hitButton_c1916_0.can_issue()) {
      return cb_hitButton_c1916_0.issue<QPushButton_Adaptor, bool, const QPoint &>(&QPushButton_Adaptor::cbs_hitButton_c1916_0, pos);
    } else {
      return QPushButton::hitButton(pos);
    }
  }

  //  [adaptor impl] void QPushButton::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QPushButton::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QPushButton_Adaptor, QInputMethodEvent *>(&QPushButton_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QPushButton::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QPushButton::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QPushButton_Adaptor, QKeyEvent *>(&QPushButton_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QPushButton::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::keyReleaseEvent(QKeyEvent *e)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *e)
  {
    QPushButton::keyReleaseEvent(e);
  }

  virtual void keyReleaseEvent(QKeyEvent *e)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QPushButton_Adaptor, QKeyEvent *>(&QPushButton_Adaptor::cbs_keyReleaseEvent_1514_0, e);
    } else {
      QPushButton::keyReleaseEvent(e);
    }
  }

  //  [adaptor impl] void QPushButton::languageChange()
  void cbs_languageChange_0_0()
  {
    QPushButton::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QPushButton_Adaptor>(&QPushButton_Adaptor::cbs_languageChange_0_0);
    } else {
      QPushButton::languageChange();
    }
  }

  //  [adaptor impl] void QPushButton::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QPushButton::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QPushButton_Adaptor, QEvent *>(&QPushButton_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QPushButton::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QPushButton::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QPushButton::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QPushButton_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QPushButton_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QPushButton::metric(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QPushButton::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QPushButton_Adaptor, QMouseEvent *>(&QPushButton_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QPushButton::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::mouseMoveEvent(QMouseEvent *e)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *e)
  {
    QPushButton::mouseMoveEvent(e);
  }

  virtual void mouseMoveEvent(QMouseEvent *e)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QPushButton_Adaptor, QMouseEvent *>(&QPushButton_Adaptor::cbs_mouseMoveEvent_1738_0, e);
    } else {
      QPushButton::mouseMoveEvent(e);
    }
  }

  //  [adaptor impl] void QPushButton::mousePressEvent(QMouseEvent *e)
  void cbs_mousePressEvent_1738_0(QMouseEvent *e)
  {
    QPushButton::mousePressEvent(e);
  }

  virtual void mousePressEvent(QMouseEvent *e)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QPushButton_Adaptor, QMouseEvent *>(&QPushButton_Adaptor::cbs_mousePressEvent_1738_0, e);
    } else {
      QPushButton::mousePressEvent(e);
    }
  }

  //  [adaptor impl] void QPushButton::mouseReleaseEvent(QMouseEvent *e)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *e)
  {
    QPushButton::mouseReleaseEvent(e);
  }

  virtual void mouseReleaseEvent(QMouseEvent *e)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QPushButton_Adaptor, QMouseEvent *>(&QPushButton_Adaptor::cbs_mouseReleaseEvent_1738_0, e);
    } else {
      QPushButton::mouseReleaseEvent(e);
    }
  }

  //  [adaptor impl] void QPushButton::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QPushButton::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QPushButton_Adaptor, QMoveEvent *>(&QPushButton_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QPushButton::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::nextCheckState()
  void cbs_nextCheckState_0_0()
  {
    QPushButton::nextCheckState();
  }

  virtual void nextCheckState()
  {
    if (cb_nextCheckState_0_0.can_issue()) {
      cb_nextCheckState_0_0.issue<QPushButton_Adaptor>(&QPushButton_Adaptor::cbs_nextCheckState_0_0);
    } else {
      QPushButton::nextCheckState();
    }
  }

  //  [adaptor impl] void QPushButton::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QPushButton::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QPushButton_Adaptor, QPaintEvent *>(&QPushButton_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QPushButton::paintEvent(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QPushButton::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QPushButton_Adaptor, const QPalette &>(&QPushButton_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QPushButton::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QPushButton::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QPushButton_Adaptor, QResizeEvent *>(&QPushButton_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QPushButton::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QPushButton::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QPushButton_Adaptor, QShowEvent *>(&QPushButton_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QPushButton::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QPushButton::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QPushButton_Adaptor, QStyle &>(&QPushButton_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QPushButton::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QPushButton::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QPushButton_Adaptor, QTabletEvent *>(&QPushButton_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QPushButton::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::timerEvent(QTimerEvent *e)
  void cbs_timerEvent_1730_0(QTimerEvent *e)
  {
    QPushButton::timerEvent(e);
  }

  virtual void timerEvent(QTimerEvent *e)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QPushButton_Adaptor, QTimerEvent *>(&QPushButton_Adaptor::cbs_timerEvent_1730_0, e);
    } else {
      QPushButton::timerEvent(e);
    }
  }

  //  [adaptor impl] void QPushButton::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QPushButton::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QPushButton_Adaptor, QWheelEvent *>(&QPushButton_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QPushButton::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QPushButton::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QPushButton::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QPushButton_Adaptor, bool>(&QPushButton_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QPushButton::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_checkStateSet_0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_hitButton_c1916_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nextCheckState_0_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QPushButton_Adaptor::~QPushButton_Adaptor() { }

//  Constructor QPushButton::QPushButton(QWidget *parent) (adaptor class)

static void _init_ctor_QPushButton_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QPushButton_Adaptor *> ();
}

static void _call_ctor_QPushButton_Adaptor_1315 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QPushButton_Adaptor *> (new QPushButton_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPushButton_Adaptor_1315 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPushButton::QPushButton(QWidget *parent)\nThis method creates an object of class QPushButton.", &_init_ctor_QPushButton_Adaptor_1315, &_call_ctor_QPushButton_Adaptor_1315);
}

//  Constructor QPushButton::QPushButton(const QString &text, QWidget *parent) (adaptor class)

static void _init_ctor_QPushButton_Adaptor_3232 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return_new<QPushButton_Adaptor *> ();
}

static void _call_ctor_QPushButton_Adaptor_3232 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QWidget *arg2 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QPushButton_Adaptor *> (new QPushButton_Adaptor (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPushButton_Adaptor_3232 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPushButton::QPushButton(const QString &text, QWidget *parent)\nThis method creates an object of class QPushButton.", &_init_ctor_QPushButton_Adaptor_3232, &_call_ctor_QPushButton_Adaptor_3232);
}

//  Constructor QPushButton::QPushButton(const QIcon &icon, const QString &text, QWidget *parent) (adaptor class)

static void _init_ctor_QPushButton_Adaptor_4911 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return_new<QPushButton_Adaptor *> ();
}

static void _call_ctor_QPushButton_Adaptor_4911 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QIcon &arg1 = args.read<const QIcon & > ();
  const QString &arg2 = args.read<const QString & > ();
  QWidget *arg3 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QPushButton_Adaptor *> (new QPushButton_Adaptor (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPushButton_Adaptor_4911 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPushButton::QPushButton(const QIcon &icon, const QString &text, QWidget *parent)\nThis method creates an object of class QPushButton.", &_init_ctor_QPushButton_Adaptor_4911, &_call_ctor_QPushButton_Adaptor_4911);
}

// void QPushButton::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QPushButton_Adaptor *)cls)->fp_QPushButton_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QPushButton::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QPushButton::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QPushButton_Adaptor *)cls)->fp_QPushButton_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QPushButton::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// bool QPushButton::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPushButton_Adaptor *)cls)->fp_QPushButton_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QPushButton::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QPushButton::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QPushButton_Adaptor *)cls)->fp_QPushButton_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QPushButton::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// void QPushButton::initStyleOption(QStyleOptionButton *option)

static void _init_fp_initStyleOption_c2501 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionButton * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_initStyleOption_c2501 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyleOptionButton *arg1 = args.read<QStyleOptionButton * > ();
  ((QPushButton_Adaptor *)cls)->fp_QPushButton_initStyleOption_c2501 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_initStyleOption_c2501 ()
{
  return new qt_gsi::GenericMethod("*initStyleOption", "@brief Method void QPushButton::initStyleOption(QStyleOptionButton *option)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_initStyleOption_c2501, &_call_fp_initStyleOption_c2501);
}


// int QPushButton::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QPushButton_Adaptor *)cls)->fp_QPushButton_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QPushButton::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QPushButton::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPushButton_Adaptor *)cls)->fp_QPushButton_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QPushButton::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// QObject *QPushButton::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QPushButton_Adaptor *)cls)->fp_QPushButton_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QPushButton::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QPushButton::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPushButton_Adaptor *)cls)->fp_QPushButton_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QPushButton::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// bool QPushButton::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QPushButton_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QPushButton::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// int QPushButton::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QPushButton_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QPushButton::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// QVariant QPushButton::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QPushButton_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QPushButton::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// QSize QPushButton::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QPushButton_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QPushButton::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// QPaintEngine *QPushButton::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QPushButton_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QPushButton::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QPushButton::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QPushButton_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QPushButton::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// QSize QPushButton::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QPushButton_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QPushButton::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// void QPushButton::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QPushButton::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QPushButton::changeEvent(QEvent *e)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QPushButton::changeEvent(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QPushButton::checkStateSet()

static void _init_cbs_checkStateSet_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_checkStateSet_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPushButton_Adaptor *)cls)->cbs_checkStateSet_0_0 ();
}

static void _set_callback_cbs_checkStateSet_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_checkStateSet_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_checkStateSet_0_0 ()
{
  return new qt_gsi::GenericMethod ("*checkStateSet", "@hide", false, &_init_cbs_checkStateSet_0_0, &_call_cbs_checkStateSet_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_checkStateSet_0_0 ()
{
  return new qt_gsi::GenericMethod ("*checkStateSet", "@brief Virtual method void QPushButton::checkStateSet()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_checkStateSet_0_0, &_call_cbs_checkStateSet_0_0, &_set_callback_cbs_checkStateSet_0_0);
}


// void QPushButton::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QPushButton::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QPushButton::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QPushButton::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QPushButton::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QPushButton::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QPushButton::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QPushButton::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QPushButton::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QPushButton_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QPushButton::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QPushButton::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QPushButton::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QPushButton::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QPushButton::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QPushButton::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QPushButton::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// void QPushButton::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QPushButton::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// void QPushButton::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QPushButton_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QPushButton::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QPushButton::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QPushButton::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// bool QPushButton::event(QEvent *e)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QPushButton_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QPushButton::event(QEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QPushButton::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QPushButton::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QPushButton::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QPushButton_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QPushButton::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QPushButton::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QPushButton::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QPushButton::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QPushButton_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QPushButton::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QPushButton::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QPushButton::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// bool QPushButton::hitButton(const QPoint &pos)

static void _init_cbs_hitButton_c1916_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_hitButton_c1916_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<bool > ((bool)((QPushButton_Adaptor *)cls)->cbs_hitButton_c1916_0 (arg1));
}

static void _set_callback_cbs_hitButton_c1916_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_hitButton_c1916_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hitButton_c1916_0 ()
{
  return new qt_gsi::GenericMethod ("*hitButton", "@hide", true, &_init_cbs_hitButton_c1916_0, &_call_cbs_hitButton_c1916_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hitButton_c1916_0 ()
{
  return new qt_gsi::GenericMethod ("*hitButton", "@brief Virtual method bool QPushButton::hitButton(const QPoint &pos)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hitButton_c1916_0, &_call_cbs_hitButton_c1916_0, &_set_callback_cbs_hitButton_c1916_0);
}


// void QPushButton::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QPushButton::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// void QPushButton::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QPushButton::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QPushButton::keyReleaseEvent(QKeyEvent *e)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QPushButton::keyReleaseEvent(QKeyEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QPushButton::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPushButton_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QPushButton::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QPushButton::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QPushButton::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QPushButton::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QPushButton_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QPushButton::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// void QPushButton::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QPushButton::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QPushButton::mouseMoveEvent(QMouseEvent *e)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QPushButton::mouseMoveEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QPushButton::mousePressEvent(QMouseEvent *e)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QPushButton::mousePressEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QPushButton::mouseReleaseEvent(QMouseEvent *e)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QPushButton::mouseReleaseEvent(QMouseEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// void QPushButton::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QPushButton::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QPushButton::nextCheckState()

static void _init_cbs_nextCheckState_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_nextCheckState_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QPushButton_Adaptor *)cls)->cbs_nextCheckState_0_0 ();
}

static void _set_callback_cbs_nextCheckState_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_nextCheckState_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_nextCheckState_0_0 ()
{
  return new qt_gsi::GenericMethod ("*nextCheckState", "@hide", false, &_init_cbs_nextCheckState_0_0, &_call_cbs_nextCheckState_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_nextCheckState_0_0 ()
{
  return new qt_gsi::GenericMethod ("*nextCheckState", "@brief Virtual method void QPushButton::nextCheckState()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nextCheckState_0_0, &_call_cbs_nextCheckState_0_0, &_set_callback_cbs_nextCheckState_0_0);
}


// void QPushButton::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QPushButton::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QPushButton::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QPushButton_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QPushButton::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QPushButton::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QPushButton::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QPushButton::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QPushButton::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// void QPushButton::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QPushButton_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QPushButton::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// void QPushButton::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QPushButton::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QPushButton::timerEvent(QTimerEvent *e)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QPushButton::timerEvent(QTimerEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QPushButton::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QPushButton_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QPushButton::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QPushButton::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QPushButton_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QPushButton_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QPushButton::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QPushButton> decl_QPushButton;

gsi::Class<QPushButton_Adaptor> decl_QPushButton_Adaptor (decl_QPushButton, "QPushButton",
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_initStyleOption_c2501 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_checkStateSet_0_0 ()) +
  gsi::Methods(_create_callback_cbs_checkStateSet_0_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_hitButton_c1916_0 ()) +
  gsi::Methods(_create_callback_cbs_hitButton_c1916_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_nextCheckState_0_0 ()) +
  gsi::Methods(_create_callback_cbs_nextCheckState_0_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QPushButton_Adaptor_1315 ()) +
  gsi::Methods(_create_ctor_QPushButton_Adaptor_3232 ()) +
  gsi::Methods(_create_ctor_QPushButton_Adaptor_4911 ()),
  "@qt\n@brief Binding of QPushButton");

}

