
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPolygon.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQPolygon_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPolygon

#include "dbPolygon.h"

  static QPolygon *ctor_QPolygon_from_polygon (const db::Polygon &pts)
  {
    QPolygon *p = new QPolygon ();
    p->reserve (int (pts.hull ().size ()));
    for (db::Polygon::polygon_contour_iterator q = pts.begin_hull (); q != pts.end_hull (); ++q) {
      p->push_back (QPoint ((*q).x (), (*q).y ()));
    }
    return p;
  }

  static QPolygon *ctor_QPolygon_from_simple_polygon (const db::SimplePolygon &pts)
  {
    QPolygon *p = new QPolygon ();
    p->reserve (int (pts.hull ().size ()));
    for (db::SimplePolygon::polygon_contour_iterator q = pts.begin_hull (); q != pts.end_hull (); ++q) {
      p->push_back (QPoint ((*q).x (), (*q).y ()));
    }
    return p;
  }

  static QPolygon::const_iterator f_QPolygon_each_begin (const QPolygon *m)
  {
    return m->begin ();
  }

  static QPolygon::const_iterator f_QPolygon_each_end (const QPolygon *m)
  {
    return m->end ();
  }

  static QPoint f_QPolygon_at (const QPolygon *m, int i)
  {
    return m->at(i);
  }

  static QPoint f_QPolygon_front (const QPolygon *m)
  {
    return m->front();
  }

  static QPoint f_QPolygon_back (const QPolygon *m)
  {
    return m->back();
  }

  static int f_QPolygon_size (const QPolygon *m)
  {
    return m->size();
  }

  static void f_QPolygon_clear (QPolygon *m)
  {
    return m->clear();
  }

  static void f_QPolygon_remove (QPolygon *m, int i)
  {
    return m->remove (i);
  }

  static void f_QPolygon_insert (QPolygon *m, int i, const QPoint &p)
  {
    return m->insert (i, p);
  }

  static void f_QPolygon_replace (QPolygon *m, int i, const QPoint &p)
  {
    return m->replace (i, p);
  }

  static void f_QPolygon_pop_front (QPolygon *m)
  {
    return m->pop_front ();
  }

  static void f_QPolygon_pop_back (QPolygon *m)
  {
    return m->pop_back ();
  }

  static void f_QPolygon_push_front (QPolygon *m, const QPoint &p)
  {
    return m->push_front (p);
  }

  static void f_QPolygon_push_back (QPolygon *m, const QPoint &p)
  {
    return m->push_back (p);
  }

  static void f_QPolygon_reserve (QPolygon *m, int n)
  {
    return m->reserve (n);
  }

  static void f_QPolygon_resize (QPolygon *m, int n)
  {
    return m->resize (n);
  }

  static void f_QPolygon_fill (QPolygon *m, const QPoint &p, int n)
  {
    m->fill (p, n);
  }

//  Constructor QPolygon::QPolygon()


static void _init_ctor_QPolygon_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QPolygon *> ();
}

static void _call_ctor_QPolygon_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPolygon *> (new QPolygon ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPolygon_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPolygon::QPolygon()\nThis method creates an object of class QPolygon.", &_init_ctor_QPolygon_0, &_call_ctor_QPolygon_0);
}

//  Constructor QPolygon::QPolygon(int size)


static void _init_ctor_QPolygon_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<QPolygon *> ();
}

static void _call_ctor_QPolygon_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QPolygon *> (new QPolygon (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPolygon_767 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPolygon::QPolygon(int size)\nThis method creates an object of class QPolygon.", &_init_ctor_QPolygon_767, &_call_ctor_QPolygon_767);
}

//  Constructor QPolygon::QPolygon(const QPolygon &a)


static void _init_ctor_QPolygon_2138 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("a");
  decl->add_arg<const QPolygon & > (argspec_0);
  decl->set_return_new<QPolygon *> ();
}

static void _call_ctor_QPolygon_2138 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygon &arg1 = args.read<const QPolygon & > ();
  ret.write<QPolygon *> (new QPolygon (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPolygon_2138 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPolygon::QPolygon(const QPolygon &a)\nThis method creates an object of class QPolygon.", &_init_ctor_QPolygon_2138, &_call_ctor_QPolygon_2138);
}

//  Constructor QPolygon::QPolygon(const QVector<QPoint> &v)


static void _init_ctor_QPolygon_2746 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("v");
  decl->add_arg<const qt_gsi::Converter<QVector<QPoint> >::target_type & > (argspec_0);
  decl->set_return_new<QPolygon *> ();
}

static void _call_ctor_QPolygon_2746 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QVector<QPoint> >::target_type & arg1 = args.read<const qt_gsi::Converter<QVector<QPoint> >::target_type & > ();
  ret.write<QPolygon *> (new QPolygon (qt_gsi::QtToCppAdaptor<QVector<QPoint> >(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPolygon_2746 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPolygon::QPolygon(const QVector<QPoint> &v)\nThis method creates an object of class QPolygon.", &_init_ctor_QPolygon_2746, &_call_ctor_QPolygon_2746);
}

//  Constructor QPolygon::QPolygon(const QRect &r, bool closed)


static void _init_ctor_QPolygon_2548 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("closed", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return_new<QPolygon *> ();
}

static void _call_ctor_QPolygon_2548 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(false);
  ret.write<QPolygon *> (new QPolygon (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QPolygon_2548 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPolygon::QPolygon(const QRect &r, bool closed)\nThis method creates an object of class QPolygon.", &_init_ctor_QPolygon_2548, &_call_ctor_QPolygon_2548);
}

// QRect QPolygon::boundingRect()


static void _init_f_boundingRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_boundingRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QPolygon *)cls)->boundingRect ());
}

static qt_gsi::GenericMethod *_create_f_boundingRect_c0 ()
{
  return new qt_gsi::GenericMethod ("boundingRect", "@brief Method QRect QPolygon::boundingRect()\n", true, &_init_f_boundingRect_c0, &_call_f_boundingRect_c0);
}

// bool QPolygon::containsPoint(const QPoint &pt, Qt::FillRule fillRule)


static void _init_f_containsPoint_c3356 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pt");
  decl->add_arg<const QPoint & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("fillRule");
  decl->add_arg<const qt_gsi::Converter<Qt::FillRule>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_containsPoint_c3356 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  const qt_gsi::Converter<Qt::FillRule>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::FillRule>::target_type & > ();
  ret.write<bool > ((bool)((QPolygon *)cls)->containsPoint (arg1, qt_gsi::QtToCppAdaptor<Qt::FillRule>(arg2).cref()));
}

static qt_gsi::GenericMethod *_create_f_containsPoint_c3356 ()
{
  return new qt_gsi::GenericMethod ("containsPoint", "@brief Method bool QPolygon::containsPoint(const QPoint &pt, Qt::FillRule fillRule)\n", true, &_init_f_containsPoint_c3356, &_call_f_containsPoint_c3356);
}

// QPolygon QPolygon::intersected(const QPolygon &r)


static void _init_f_intersected_c2138 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QPolygon & > (argspec_0);
  decl->set_return<QPolygon > ();
}

static void _call_f_intersected_c2138 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygon &arg1 = args.read<const QPolygon & > ();
  ret.write<QPolygon > ((QPolygon)((QPolygon *)cls)->intersected (arg1));
}

static qt_gsi::GenericMethod *_create_f_intersected_c2138 ()
{
  return new qt_gsi::GenericMethod ("intersected", "@brief Method QPolygon QPolygon::intersected(const QPolygon &r)\n", true, &_init_f_intersected_c2138, &_call_f_intersected_c2138);
}

// void QPolygon::point(int i, int *x, int *y)


static void _init_f_point_c2457 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<int * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_point_c2457 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int *arg2 = args.read<int * > ();
  int *arg3 = args.read<int * > ();
  ((QPolygon *)cls)->point (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_point_c2457 ()
{
  return new qt_gsi::GenericMethod ("point", "@brief Method void QPolygon::point(int i, int *x, int *y)\n", true, &_init_f_point_c2457, &_call_f_point_c2457);
}

// QPoint QPolygon::point(int i)


static void _init_f_point_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QPoint > ();
}

static void _call_f_point_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QPoint > ((QPoint)((QPolygon *)cls)->point (arg1));
}

static qt_gsi::GenericMethod *_create_f_point_c767 ()
{
  return new qt_gsi::GenericMethod ("point", "@brief Method QPoint QPolygon::point(int i)\n", true, &_init_f_point_c767, &_call_f_point_c767);
}

// void QPolygon::putPoints(int index, int nPoints, int firstx, int firsty, ...)


static void _init_f_putPoints_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("nPoints");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("firstx");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("firsty");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_putPoints_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QPolygon *)cls)->putPoints (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_putPoints_2744 ()
{
  return new qt_gsi::GenericMethod ("putPoints", "@brief Method void QPolygon::putPoints(int index, int nPoints, int firstx, int firsty, ...)\n", false, &_init_f_putPoints_2744, &_call_f_putPoints_2744);
}

// void QPolygon::putPoints(int index, int nPoints, const QPolygon &from, int fromIndex)


static void _init_f_putPoints_4115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("nPoints");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("from");
  decl->add_arg<const QPolygon & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("fromIndex", true, "0");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_putPoints_4115 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QPolygon &arg3 = args.read<const QPolygon & > ();
  int arg4 = args ? args.read<int > () : (int)(0);
  ((QPolygon *)cls)->putPoints (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_putPoints_4115 ()
{
  return new qt_gsi::GenericMethod ("putPoints", "@brief Method void QPolygon::putPoints(int index, int nPoints, const QPolygon &from, int fromIndex)\n", false, &_init_f_putPoints_4115, &_call_f_putPoints_4115);
}

// void QPolygon::setPoint(int index, int x, int y)


static void _init_f_setPoint_2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("x");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("y");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setPoint_2085 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QPolygon *)cls)->setPoint (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_setPoint_2085 ()
{
  return new qt_gsi::GenericMethod ("setPoint", "@brief Method void QPolygon::setPoint(int index, int x, int y)\n", false, &_init_f_setPoint_2085, &_call_f_setPoint_2085);
}

// void QPolygon::setPoint(int index, const QPoint &p)


static void _init_f_setPoint_2575 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("p");
  decl->add_arg<const QPoint & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPoint_2575 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const QPoint &arg2 = args.read<const QPoint & > ();
  ((QPolygon *)cls)->setPoint (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setPoint_2575 ()
{
  return new qt_gsi::GenericMethod ("setPoint", "@brief Method void QPolygon::setPoint(int index, const QPoint &p)\n", false, &_init_f_setPoint_2575, &_call_f_setPoint_2575);
}

// void QPolygon::setPoints(int nPoints, int firstx, int firsty, ...)


static void _init_f_setPoints_2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("nPoints");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("firstx");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("firsty");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setPoints_2085 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QPolygon *)cls)->setPoints (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_setPoints_2085 ()
{
  return new qt_gsi::GenericMethod ("setPoints", "@brief Method void QPolygon::setPoints(int nPoints, int firstx, int firsty, ...)\n", false, &_init_f_setPoints_2085, &_call_f_setPoints_2085);
}

// QPolygon QPolygon::subtracted(const QPolygon &r)


static void _init_f_subtracted_c2138 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QPolygon & > (argspec_0);
  decl->set_return<QPolygon > ();
}

static void _call_f_subtracted_c2138 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygon &arg1 = args.read<const QPolygon & > ();
  ret.write<QPolygon > ((QPolygon)((QPolygon *)cls)->subtracted (arg1));
}

static qt_gsi::GenericMethod *_create_f_subtracted_c2138 ()
{
  return new qt_gsi::GenericMethod ("subtracted", "@brief Method QPolygon QPolygon::subtracted(const QPolygon &r)\n", true, &_init_f_subtracted_c2138, &_call_f_subtracted_c2138);
}

// void QPolygon::translate(int dx, int dy)


static void _init_f_translate_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_translate_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QPolygon *)cls)->translate (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_translate_1426 ()
{
  return new qt_gsi::GenericMethod ("translate", "@brief Method void QPolygon::translate(int dx, int dy)\n", false, &_init_f_translate_1426, &_call_f_translate_1426);
}

// void QPolygon::translate(const QPoint &offset)


static void _init_f_translate_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_translate_1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ((QPolygon *)cls)->translate (arg1);
}

static qt_gsi::GenericMethod *_create_f_translate_1916 ()
{
  return new qt_gsi::GenericMethod ("translate", "@brief Method void QPolygon::translate(const QPoint &offset)\n", false, &_init_f_translate_1916, &_call_f_translate_1916);
}

// QPolygon QPolygon::translated(int dx, int dy)


static void _init_f_translated_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QPolygon > ();
}

static void _call_f_translated_c1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<QPolygon > ((QPolygon)((QPolygon *)cls)->translated (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_translated_c1426 ()
{
  return new qt_gsi::GenericMethod ("translated", "@brief Method QPolygon QPolygon::translated(int dx, int dy)\n", true, &_init_f_translated_c1426, &_call_f_translated_c1426);
}

// QPolygon QPolygon::translated(const QPoint &offset)


static void _init_f_translated_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QPolygon > ();
}

static void _call_f_translated_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QPolygon > ((QPolygon)((QPolygon *)cls)->translated (arg1));
}

static qt_gsi::GenericMethod *_create_f_translated_c1916 ()
{
  return new qt_gsi::GenericMethod ("translated", "@brief Method QPolygon QPolygon::translated(const QPoint &offset)\n", true, &_init_f_translated_c1916, &_call_f_translated_c1916);
}

// QPolygon QPolygon::united(const QPolygon &r)


static void _init_f_united_c2138 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("r");
  decl->add_arg<const QPolygon & > (argspec_0);
  decl->set_return<QPolygon > ();
}

static void _call_f_united_c2138 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygon &arg1 = args.read<const QPolygon & > ();
  ret.write<QPolygon > ((QPolygon)((QPolygon *)cls)->united (arg1));
}

static qt_gsi::GenericMethod *_create_f_united_c2138 ()
{
  return new qt_gsi::GenericMethod ("united", "@brief Method QPolygon QPolygon::united(const QPolygon &r)\n", true, &_init_f_united_c2138, &_call_f_united_c2138);
}

//  QPolygon ::operator *(const QPolygon &a, const QMatrix &m)
static QPolygon op_QPolygon_operator_star__4053(const QPolygon *_self, const QMatrix &m) {
  return ::operator *(*_self, m);
}

//  QPolygon ::operator *(const QPolygon &a, const QTransform &m)
static QPolygon op_QPolygon_operator_star__4380(const QPolygon *_self, const QTransform &m) {
  return ::operator *(*_self, m);
}


namespace gsi
{
gsi::Class<QPolygon> decl_QPolygon ("QPolygon",
  gsi::constructor("new", &ctor_QPolygon_from_polygon, "@brief Creates a polygon from the given KLayout Polygon\n@args p\nRemark: holes are not transferred into the QPolygon.") +
  gsi::constructor("new", &ctor_QPolygon_from_simple_polygon, "@brief Creates a polygon from the given KLayout SimplePolygon\n@args p") +
  gsi::iterator_ext ("each", &f_QPolygon_each_begin, &f_QPolygon_each_end, "@brief Iterates over all points of the polygon.") +
  gsi::method_ext("[]", &f_QPolygon_at, "@brief Gets the point at the given position\n@args index") +
  gsi::method_ext("front", &f_QPolygon_front, "@brief Gets the first point") +
  gsi::method_ext("back", &f_QPolygon_back, "@brief Gets the last point") +
  gsi::method_ext("size", &f_QPolygon_size, "@brief Gets the number of points in the polygon") +
  gsi::method_ext("clear", &f_QPolygon_clear, "@brief Empties the polygon") +
  gsi::method_ext("remove", &f_QPolygon_remove, "@brief Removes the point at the given position\n@args index") +
  gsi::method_ext("insert", &f_QPolygon_insert, "@brief Inserts the point after the given position\n@args index, p") +
  gsi::method_ext("replace", &f_QPolygon_replace, "@brief Replaces the point at the given position\n@args index, p") +
  gsi::method_ext("pop_front", &f_QPolygon_pop_front, "@brief Removes the point at the beginning of the list") +
  gsi::method_ext("pop_back", &f_QPolygon_pop_back, "@brief Removes the point at the end of the list") +
  gsi::method_ext("push_front", &f_QPolygon_push_front, "@brief Inserts the point at the beginning of the list\n@args p") +
  gsi::method_ext("push_back", &f_QPolygon_push_back, "@brief Inserts the point at the end of the list\n@args p") +
  gsi::method_ext("reserve", &f_QPolygon_reserve, "@brief Reserve memory for the given number of points\n@args n") +
  gsi::method_ext("resize", &f_QPolygon_resize, "@brief Sets the number of points to the given length\n@args l") +
  gsi::method_ext("fill", &f_QPolygon_fill, "@brief Resizes the polygon to l points and ets all elements to the given point\n@args p,l") 
+
  gsi::Methods(_create_ctor_QPolygon_0 ()) +
  gsi::Methods(_create_ctor_QPolygon_767 ()) +
  gsi::Methods(_create_ctor_QPolygon_2138 ()) +
  gsi::Methods(_create_ctor_QPolygon_2746 ()) +
  gsi::Methods(_create_ctor_QPolygon_2548 ()) +
  gsi::Methods(_create_f_boundingRect_c0 ()) +
  gsi::Methods(_create_f_containsPoint_c3356 ()) +
  gsi::Methods(_create_f_intersected_c2138 ()) +
  gsi::Methods(_create_f_point_c2457 ()) +
  gsi::Methods(_create_f_point_c767 ()) +
  gsi::Methods(_create_f_putPoints_2744 ()) +
  gsi::Methods(_create_f_putPoints_4115 ()) +
  gsi::Methods(_create_f_setPoint_2085 ()) +
  gsi::Methods(_create_f_setPoint_2575 ()) +
  gsi::Methods(_create_f_setPoints_2085 ()) +
  gsi::Methods(_create_f_subtracted_c2138 ()) +
  gsi::Methods(_create_f_translate_1426 ()) +
  gsi::Methods(_create_f_translate_1916 ()) +
  gsi::Methods(_create_f_translated_c1426 ()) +
  gsi::Methods(_create_f_translated_c1916 ()) +
  gsi::Methods(_create_f_united_c2138 ()) +
  gsi::method_ext("*", &::op_QPolygon_operator_star__4053, gsi::arg ("m"), "@brief Operator QPolygon ::operator *(const QPolygon &a, const QMatrix &m)\nThis is the mapping of the global operator to the instance method.") +
  gsi::method_ext("*", &::op_QPolygon_operator_star__4380, gsi::arg ("m"), "@brief Operator QPolygon ::operator *(const QPolygon &a, const QTransform &m)\nThis is the mapping of the global operator to the instance method."),
  "@qt\n@brief Binding of QPolygon");

}

